/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

class TypeLiteral<T> {
    final Class<? super T> type;
    final String typeName;
    final String[] argumentsType;

    static <T> TypeLiteral<T> of(Class<T> type) {
        return new TypeLiteral<T>(type, new Type[0]);
    }

    static <T> TypeLiteral<List<T>> listOf(Class<? extends T> type) {
        return new TypeLiteral<List<T>>(List.class, type);
    }

    static <K, V> TypeLiteral<Map<K, V>> mapOf(Class<? extends K> keyType, Class<? extends V> valueType) {
        return new TypeLiteral<Map<K, V>>(Map.class, keyType, valueType);
    }

    TypeLiteral(Class<? super T> type, Type ... argumentsType) {
        this.type = type;
        this.typeName = type.getName();
        this.argumentsType = new String[argumentsType.length];
        for (int i = 0; i < argumentsType.length; ++i) {
            if (argumentsType[i] instanceof ParameterizedType) {
                argumentsType[i] = ((ParameterizedType)argumentsType[i]).getRawType();
            }
            this.argumentsType[i] = argumentsType[i] instanceof Class ? ((Class)argumentsType[i]).getName() : argumentsType[i].toString();
        }
    }

    Class<? super T> getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeLiteral that = (TypeLiteral)o;
        if (!this.typeName.equals(that.typeName)) {
            return false;
        }
        return Arrays.equals(this.argumentsType, that.argumentsType);
    }

    public int hashCode() {
        int result = this.typeName.hashCode();
        result = 31 * result + Arrays.hashCode(this.argumentsType);
        return result;
    }

    public String toString() {
        Object result = this.typeName;
        if (this.argumentsType.length > 0) {
            result = (String)result + Arrays.toString(this.argumentsType);
        }
        return result;
    }
}

