/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.reverse.dbload;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dbsync.reverse.dbload.AttributeProcessor;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoadDataStore;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoader;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderConfiguration;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.dbload.PerCatalogAndSchemaLoader;
import org.apache.cayenne.dbsync.reverse.filters.CatalogFilter;
import org.apache.cayenne.dbsync.reverse.filters.PatternFilter;
import org.apache.cayenne.dbsync.reverse.filters.SchemaFilter;
import org.apache.cayenne.map.DbEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AttributeLoader
extends PerCatalogAndSchemaLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbLoader.class);
    private final AttributeProcessor attributeProcessor;

    AttributeLoader(DbAdapter adapter, DbLoaderConfiguration config, DbLoaderDelegate delegate) {
        super(adapter, config, delegate);
        this.attributeProcessor = new AttributeProcessor(adapter);
    }

    @Override
    protected ResultSet getResultSet(String catalogName, String schemaName, DatabaseMetaData metaData) throws SQLException {
        return metaData.getColumns(catalogName, schemaName, "%", "%");
    }

    @Override
    boolean catchException(String catalogName, String schemaName, SQLException ex) {
        String message = "Unable to load columns for the " + catalogName + "/" + schemaName + ", falling back to per-entity loader.";
        LOGGER.warn(message, ex);
        return true;
    }

    @Override
    protected void processResultSetRow(CatalogFilter catalog, SchemaFilter schema, DbLoadDataStore map, ResultSet rs) throws SQLException {
        String tableName = rs.getString("TABLE_NAME");
        DbEntity entity = map.getDbEntity(tableName);
        if (entity == null) {
            return;
        }
        PatternFilter columnFilter = schema.tables.getIncludeTableColumnFilter(tableName);
        this.attributeProcessor.processAttribute(rs, columnFilter, entity);
    }
}

