/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.cayenne.access.translator.ejbql.EJBQLJoinAppender;
import org.apache.cayenne.access.translator.ejbql.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.translator.ejbql.EJBQLTableId;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.util.CayenneMapEntry;

public abstract class EJBQLPathTranslator
extends EJBQLBaseVisitor {
    private final EJBQLTranslationContext context;
    protected ObjEntity currentEntity;
    protected String lastPathComponent;
    protected boolean innerJoin;
    protected String lastAlias;
    protected String idPath;
    protected String joinMarker;
    protected String fullPath;
    private boolean usingAliases;

    public EJBQLPathTranslator(EJBQLTranslationContext context) {
        super(true);
        this.context = context;
        this.usingAliases = true;
    }

    protected abstract void appendMultiColumnPath(EJBQLMultiColumnOperand var1);

    @Override
    public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
        if (finishedChildIndex > 0) {
            if (finishedChildIndex + 1 < expression.getChildrenCount()) {
                this.processIntermediatePathComponent();
            } else {
                this.processLastPathComponent();
            }
        }
        return true;
    }

    @Override
    public boolean visitIdentifier(EJBQLExpression expression) {
        ClassDescriptor descriptor = this.context.getEntityDescriptor(expression.getText());
        if (descriptor == null) {
            throw new EJBQLException("Invalid identification variable: " + expression.getText(), new Object[0]);
        }
        this.currentEntity = descriptor.getEntity();
        this.idPath = expression.getText();
        this.joinMarker = EJBQLJoinAppender.makeJoinTailMarker(this.idPath);
        this.fullPath = this.idPath;
        return true;
    }

    @Override
    public boolean visitIdentificationVariable(EJBQLExpression expression) {
        if (this.lastPathComponent != null) {
            this.resolveJoin();
        }
        this.resolveLastPathComponent(expression.getText());
        return true;
    }

    protected void resolveLastPathComponent(String pathComponent) {
        if (pathComponent.endsWith("+")) {
            this.lastPathComponent = pathComponent.substring(0, pathComponent.length() - 1);
            this.innerJoin = false;
        } else {
            this.lastPathComponent = pathComponent;
            this.innerJoin = true;
        }
    }

    protected void resolveJoin() {
        EJBQLJoinAppender joinAppender = this.context.getTranslatorFactory().getJoinAppender(this.context);
        String newPath = this.idPath + "." + this.lastPathComponent;
        String oldPath = joinAppender.registerReusableJoin(this.idPath, this.lastPathComponent, newPath);
        this.fullPath = this.fullPath + "." + this.lastPathComponent;
        if (oldPath != null) {
            this.idPath = oldPath;
            ObjRelationship lastRelationship = this.currentEntity.getRelationship(this.lastPathComponent);
            if (lastRelationship != null) {
                ObjEntity targetEntity = lastRelationship.getTargetEntity();
                this.lastAlias = this.context.getTableAlias(this.fullPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(targetEntity.getDbEntity()));
            } else {
                String tableName = this.context.getQuotingStrategy().quotedFullyQualifiedName(this.currentEntity.getDbEntity());
                this.lastAlias = this.context.getTableAlias(oldPath, tableName);
            }
        } else {
            ObjRelationship lastRelationship = this.currentEntity.getRelationship(this.lastPathComponent);
            ObjEntity targetEntity = lastRelationship != null ? lastRelationship.getTargetEntity() : this.currentEntity;
            if (this.innerJoin) {
                joinAppender.appendInnerJoin(this.joinMarker, new EJBQLTableId(this.idPath), new EJBQLTableId(this.fullPath));
            } else {
                joinAppender.appendOuterJoin(this.joinMarker, new EJBQLTableId(this.idPath), new EJBQLTableId(this.fullPath));
            }
            this.lastAlias = this.context.getTableAlias(this.fullPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(targetEntity.getDbEntity()));
            this.idPath = newPath;
        }
    }

    protected void processIntermediatePathComponent() {
        ObjRelationship relationship = this.currentEntity.getRelationship(this.lastPathComponent);
        if (relationship == null) {
            throw new EJBQLException("Unknown relationship '" + this.lastPathComponent + "' for entity '" + this.currentEntity.getName() + "'", new Object[0]);
        }
        this.currentEntity = relationship.getTargetEntity();
    }

    protected void processLastPathComponent() {
        ObjAttribute attribute = this.currentEntity.getAttribute(this.lastPathComponent);
        if (attribute != null) {
            this.processTerminatingAttribute(attribute);
            return;
        }
        ObjRelationship relationship = this.currentEntity.getRelationship(this.lastPathComponent);
        if (relationship != null) {
            this.processTerminatingRelationship(relationship);
            return;
        }
        throw new IllegalStateException("Invalid path component: " + this.lastPathComponent);
    }

    protected void processTerminatingAttribute(ObjAttribute attribute) {
        DbEntity table = null;
        Iterator<CayenneMapEntry> it = attribute.getDbPathIterator();
        while (it.hasNext()) {
            CayenneMapEntry pathComponent = it.next();
            if (!(pathComponent instanceof DbAttribute)) continue;
            table = ((DbAttribute)pathComponent).getEntity();
        }
        if (this.isUsingAliases()) {
            String alias = this.lastAlias != null ? this.lastAlias : this.context.getTableAlias(this.idPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
            this.context.append(' ').append(alias).append('.').append(this.context.getQuotingStrategy().quotedName(attribute.getDbAttribute()));
        } else {
            this.context.append(' ').append(this.context.getQuotingStrategy().quotedName(attribute.getDbAttribute()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processTerminatingRelationship(ObjRelationship relationship) {
        if (relationship.isSourceIndependentFromTargetChange()) {
            this.innerJoin = false;
            this.resolveJoin();
            DbRelationship dbRelationship = this.chooseDbRelationship(relationship);
            DbEntity table = dbRelationship.getTargetEntity();
            String alias = this.lastAlias != null ? this.lastAlias : this.context.getTableAlias(this.idPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
            List<DbAttribute> pks = table.getPrimaryKeys();
            if (pks.size() != 1) throw new EJBQLException("Multi-column PK to-many matches are not yet supported.", new Object[0]);
            DbAttribute pk = (DbAttribute)pks.iterator().next();
            this.context.append(' ');
            if (this.isUsingAliases()) {
                this.context.append(alias).append('.');
            }
            this.context.append(this.context.getQuotingStrategy().quotedName(pk));
            return;
        } else {
            DbRelationship dbRelationship = this.chooseDbRelationship(relationship);
            DbEntity table = (DbEntity)dbRelationship.getSourceEntity();
            String alias = this.lastAlias != null ? this.lastAlias : this.context.getTableAlias(this.idPath, this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
            List<DbJoin> joins = dbRelationship.getJoins();
            if (joins.size() == 1) {
                DbJoin join = joins.get(0);
                this.context.append(' ');
                if (this.isUsingAliases()) {
                    this.context.append(alias).append('.');
                }
                this.context.append(this.context.getQuotingStrategy().quotedName(join.getSource()));
                return;
            } else {
                HashMap<String, String> multiColumnMatch = new HashMap<String, String>(joins.size() + 2);
                for (DbJoin join : joins) {
                    String column = this.isUsingAliases() ? alias + "." + join.getSourceName() : join.getSourceName();
                    multiColumnMatch.put(join.getTargetName(), column);
                }
                this.appendMultiColumnPath(EJBQLMultiColumnOperand.getPathOperand(this.context, multiColumnMatch));
            }
        }
    }

    protected DbRelationship chooseDbRelationship(ObjRelationship relationship) {
        List<DbRelationship> dbRelationships = relationship.getDbRelationships();
        CayennePath dbRelationshipPath = relationship.getDbRelationshipPath();
        if (dbRelationshipPath.length() > 1) {
            String dbRelName = dbRelationshipPath.last().value();
            for (DbRelationship dbR : dbRelationships) {
                if (!dbR.getName().equals(dbRelName)) continue;
                return dbR;
            }
        }
        return relationship.getDbRelationships().get(0);
    }

    public boolean isUsingAliases() {
        return this.usingAliases;
    }

    public void setUsingAliases(boolean usingAliases) {
        this.usingAliases = usingAliases;
    }
}

