/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.flush;

import java.util.Iterator;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.access.flush.ArcTarget;
import org.apache.cayenne.access.flush.DbRowOpFactory;
import org.apache.cayenne.access.flush.ObjectIdValueSupplier;
import org.apache.cayenne.access.flush.operation.DbRowOpType;
import org.apache.cayenne.access.flush.operation.DbRowOpVisitor;
import org.apache.cayenne.access.flush.operation.DbRowOpWithValues;
import org.apache.cayenne.access.flush.operation.DeleteDbRowOp;
import org.apache.cayenne.access.flush.operation.InsertDbRowOp;
import org.apache.cayenne.access.flush.operation.UpdateDbRowOp;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.graph.ArcId;
import org.apache.cayenne.graph.GraphChangeHandler;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.util.CayenneMapEntry;

class ArcValuesCreationHandler
implements GraphChangeHandler {
    final DbRowOpFactory factory;
    final DbRowOpType defaultType;

    ArcValuesCreationHandler(DbRowOpFactory factory, DbRowOpType defaultType) {
        this.factory = factory;
        this.defaultType = defaultType;
    }

    @Override
    public void arcCreated(Object nodeId, Object targetNodeId, ArcId arcId) {
        this.processArcChange(nodeId, targetNodeId, arcId, true);
    }

    @Override
    public void arcDeleted(Object nodeId, Object targetNodeId, ArcId arcId) {
        this.processArcChange(nodeId, targetNodeId, arcId, false);
    }

    private void processArcChange(Object nodeId, Object targetNodeId, ArcId arcId, boolean created) {
        ObjectId actualTargetId = (ObjectId)targetNodeId;
        ObjectId snapshotId = this.factory.getDiff().getCurrentArcSnapshotValue(arcId.getForwardArc());
        if (snapshotId != null) {
            actualTargetId = snapshotId;
        }
        ArcTarget arcTarget = new ArcTarget((ObjectId)nodeId, actualTargetId, arcId, !created);
        if (this.factory.getProcessedArcs().contains(arcTarget.getReversed())) {
            return;
        }
        ObjEntity entity = this.factory.getDescriptor().getEntity();
        ObjRelationship objRelationship = entity.getRelationship(arcTarget.getArcId().getForwardArc());
        if (objRelationship == null) {
            String arc = arcId.getForwardArc();
            if (arc.startsWith("db:")) {
                String relName = arc.substring("db:".length());
                DbRelationship dbRelationship = (DbRelationship)entity.getDbEntity().getRelationship(relName);
                this.processRelationship(dbRelationship, arcTarget.getSourceId(), arcTarget.getTargetId(), created);
            }
            return;
        }
        if (objRelationship.isFlattened()) {
            FlattenedPathProcessingResult result = this.processFlattenedPath(arcTarget.getSourceId(), arcTarget.getTargetId(), entity.getDbEntity(), objRelationship.getDbRelationshipPath(), created);
            if (result.isProcessed()) {
                this.factory.getProcessedArcs().add(arcTarget);
            }
        } else {
            DbRelationship dbRelationship = objRelationship.getDbRelationships().get(0);
            this.processRelationship(dbRelationship, arcTarget.getSourceId(), arcTarget.getTargetId(), created);
            this.factory.getProcessedArcs().add(arcTarget);
        }
    }

    FlattenedPathProcessingResult processFlattenedPath(ObjectId id, ObjectId finalTargetId, DbEntity entity, CayennePath dbPath, boolean add) {
        if (this.shouldSkipFlattenedOp(id, finalTargetId)) {
            return ArcValuesCreationHandler.flattenedResultNotProcessed();
        }
        CayennePath flattenedPath = CayennePath.EMPTY_PATH;
        ObjectId srcId = id;
        ObjectId targetId = null;
        Iterator<CayenneMapEntry> dbPathIterator = entity.resolvePathComponents(dbPath);
        while (dbPathIterator.hasNext()) {
            CayenneMapEntry entry = dbPathIterator.next();
            flattenedPath = flattenedPath.dot(entry.getName());
            if (!(entry instanceof DbRelationship)) continue;
            DbRelationship relationship = (DbRelationship)entry;
            DbEntity target = relationship.getTargetEntity();
            targetId = !dbPathIterator.hasNext() ? finalTargetId : (!relationship.isToMany() ? this.factory.getStore().getFlattenedId(id, flattenedPath) : null);
            if (targetId == null) {
                DbRowOpType type;
                targetId = ObjectId.of("db:" + target.getName());
                if (!relationship.isToMany()) {
                    this.factory.getStore().markFlattenedPath(id, flattenedPath, targetId);
                }
                if (relationship.isToMany()) {
                    type = add ? DbRowOpType.INSERT : DbRowOpType.DELETE;
                    this.factory.getOrCreate(target, targetId, type);
                } else {
                    type = add ? DbRowOpType.INSERT : DbRowOpType.UPDATE;
                    ((DbRowOpWithValues)this.factory.getOrCreate(target, targetId, type)).getValues().addFlattenedId(flattenedPath, targetId);
                }
            } else if (dbPathIterator.hasNext()) {
                this.factory.getOrCreate(target, targetId, add ? DbRowOpType.UPDATE : this.defaultType);
            }
            this.processRelationship(relationship, srcId, targetId, this.shouldProcessAsAddition(relationship, add));
            srcId = targetId;
        }
        return ArcValuesCreationHandler.flattenedResultId(targetId);
    }

    private boolean shouldSkipFlattenedOp(ObjectId id, ObjectId finalTargetId) {
        return finalTargetId != null && this.factory.getStore().getFlattenedIds(id).isEmpty() && !this.factory.getStore().getFlattenedIds(finalTargetId).isEmpty();
    }

    private boolean shouldProcessAsAddition(DbRelationship relationship, boolean add) {
        if (add) {
            return true;
        }
        for (DbJoin join : relationship.getJoins()) {
            if (join.getSource().isPrimaryKey() && join.getTarget().isPrimaryKey()) continue;
            return false;
        }
        return true;
    }

    protected void processRelationship(DbRelationship dbRelationship, ObjectId srcId, ObjectId targetId, boolean add) {
        for (DbJoin join : dbRelationship.getJoins()) {
            DbAttribute attribute;
            Object rowOp;
            Object valueToUse;
            ObjectId id;
            boolean processDelete;
            boolean targetPK;
            boolean srcPK = join.getSource().isPrimaryKey();
            if (srcPK != (targetPK = join.getTarget().isPrimaryKey())) {
                processDelete = true;
                id = null;
                if (srcPK) {
                    valueToUse = ObjectIdValueSupplier.getFor(srcId, join.getSourceName());
                    rowOp = this.factory.getOrCreate(dbRelationship.getTargetEntity(), targetId, DbRowOpType.UPDATE);
                    attribute = join.getTarget();
                } else {
                    valueToUse = ObjectIdValueSupplier.getFor(targetId, join.getTargetName());
                    rowOp = this.factory.getOrCreate((DbEntity)dbRelationship.getSourceEntity(), srcId, this.defaultType);
                    attribute = join.getSource();
                }
            } else {
                processDelete = false;
                if (dbRelationship.isToDependentPK()) {
                    valueToUse = ObjectIdValueSupplier.getFor(srcId, join.getSourceName());
                    rowOp = this.factory.getOrCreate(dbRelationship.getTargetEntity(), targetId, DbRowOpType.UPDATE);
                    attribute = join.getTarget();
                    id = targetId;
                    if (dbRelationship.isToMany()) {
                        rowOp = null;
                    }
                } else {
                    valueToUse = ObjectIdValueSupplier.getFor(targetId, join.getTargetName());
                    rowOp = this.factory.getOrCreate((DbEntity)dbRelationship.getSourceEntity(), srcId, this.defaultType);
                    attribute = join.getSource();
                    id = srcId;
                    if (dbRelationship.getReverseRelationship().isToMany()) {
                        rowOp = null;
                    }
                }
            }
            if (id != null && attribute.isPrimaryKey()) {
                id.getReplacementIdMap().put(attribute.getName(), valueToUse);
            }
            if (rowOp == null) continue;
            rowOp.accept(new ValuePropagationVisitor(attribute, add, valueToUse, processDelete));
        }
    }

    @Override
    public void nodeIdChanged(Object nodeId, Object newId) {
    }

    @Override
    public void nodeCreated(Object nodeId) {
    }

    @Override
    public void nodeRemoved(Object nodeId) {
    }

    @Override
    public void nodePropertyChanged(Object nodeId, String property, Object oldValue, Object newValue) {
    }

    static FlattenedPathProcessingResult flattenedResultId(ObjectId id) {
        return new FlattenedPathProcessingResult(true, id);
    }

    static FlattenedPathProcessingResult flattenedResultNotProcessed() {
        return new FlattenedPathProcessingResult(false, null);
    }

    static final class FlattenedPathProcessingResult {
        private final boolean processed;
        private final ObjectId id;

        private FlattenedPathProcessingResult(boolean processed, ObjectId id) {
            this.processed = processed;
            this.id = id;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public ObjectId getId() {
            return this.id;
        }
    }

    private static class ValuePropagationVisitor
    implements DbRowOpVisitor<Void> {
        private final DbAttribute attribute;
        private final boolean add;
        private final Object valueToUse;
        private final boolean processDelete;

        private ValuePropagationVisitor(DbAttribute attribute, boolean add, Object valueToUse, boolean processDelete) {
            this.attribute = attribute;
            this.add = add;
            this.valueToUse = valueToUse;
            this.processDelete = processDelete;
        }

        @Override
        public Void visitInsert(InsertDbRowOp dbRow) {
            dbRow.getValues().addValue(this.attribute, this.add ? this.valueToUse : null, true);
            return null;
        }

        @Override
        public Void visitUpdate(UpdateDbRowOp dbRow) {
            dbRow.getValues().addValue(this.attribute, this.add ? this.valueToUse : null, true);
            return null;
        }

        @Override
        public Void visitDelete(DeleteDbRowOp dbRow) {
            if (this.processDelete) {
                dbRow.getQualifier().addAdditionalQualifier(this.attribute, this.valueToUse);
            }
            return null;
        }
    }
}

