/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.variables;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowExpressionResolution;
import org.apache.brooklyn.core.workflow.steps.variables.WorkflowTransformDefault;
import org.apache.brooklyn.util.collections.MutableList;
import org.apache.brooklyn.util.exceptions.Exceptions;

public class TransformSlice
extends WorkflowTransformDefault {
    private String startIndex;
    private String endIndex;

    @Override
    protected void initCheckingDefinition() {
        MutableList d = MutableList.copyOf(this.definition.subList(1, this.definition.size()));
        if (d.isEmpty()) {
            throw new IllegalArgumentException("Transform 'slice' requires arguments: <start_index> [<end_index>]");
        }
        this.startIndex = (String)d.remove(0);
        if (!d.isEmpty()) {
            this.endIndex = (String)d.remove(0);
        }
        if (!d.isEmpty()) {
            throw new IllegalArgumentException("Transform 'slice' takes max 2 arguments: <start_index> [<end_index>]");
        }
    }

    public Object apply(Object v) {
        if (v instanceof String) {
            List codePoints = ((String)v).codePoints().boxed().collect(Collectors.toList());
            return this.applyList(codePoints).stream().collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        }
        List list = (List)this.context.resolveCoercingOnly(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, v, TypeToken.of(List.class));
        if (list == null) {
            throw new IllegalArgumentException("List to slice is null");
        }
        return this.applyList(list);
    }

    protected <T> List<T> applyList(List<T> v) {
        List list = (List)this.context.resolveCoercingOnly(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, v, TypeToken.of(List.class));
        if (list == null) {
            throw new IllegalArgumentException("List to slice is null");
        }
        Integer from = TransformSlice.resolveAs(this.startIndex, this.context, "First argument start-index", true, Integer.class, "an integer");
        Integer to = TransformSlice.resolveAs(this.endIndex, this.context, "Second argument end-index", false, Integer.class, "an integer");
        if (from < 0) {
            from = list.size() + from;
        }
        if (from < 0 || from > list.size()) {
            throw new IllegalArgumentException("Invalid start index " + from + "; list is size " + list.size());
        }
        if (to == null) {
            to = list.size();
        }
        if (to < 0) {
            to = list.size() + to;
        }
        if (to < 0 || to > list.size()) {
            throw new IllegalArgumentException("Invalid end index " + to + "; list is size " + list.size());
        }
        if (to < from) {
            throw new IllegalArgumentException("Invalid end index " + to + "; should be greater than or equal to start index " + from);
        }
        return list.subList(from, to);
    }

    public static <T> T resolveAs(Object expression, WorkflowExecutionContext context, String errorPrefix, boolean failIfNull, Class<T> type, String typeName) {
        T result = null;
        try {
            if (expression != null) {
                result = context.resolve(WorkflowExpressionResolution.WorkflowExpressionStage.STEP_RUNNING, expression, type);
            }
        }
        catch (Exception e) {
            throw Exceptions.propagate((String)(errorPrefix + " must be " + typeName + " (" + expression + ")"), (Throwable)e);
        }
        if (failIfNull && result == null) {
            throw new IllegalArgumentException(errorPrefix + " is required");
        }
        return result;
    }
}

