/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.mgmt.internal;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.brooklyn.api.entity.Application;
import org.apache.brooklyn.api.entity.Entity;
import org.apache.brooklyn.api.entity.Group;
import org.apache.brooklyn.util.collections.MutableSet;

public class AppGroupTraverser {
    int depth = -1;
    Set<Entity> visited = MutableSet.of();
    Set<Entity> visitedThisTime = MutableSet.of();
    Entity ancestorBound = null;
    Set<Entity> descendantBounds = MutableSet.of();
    boolean allowMembers = false;

    protected AppGroupTraverser() {
    }

    AppGroupTraverser(Entity source) {
        this(source, false);
    }

    AppGroupTraverser(Entity source, boolean allowMembers) {
        this.visitedThisTime.add(source);
        this.visited.add(source);
        this.ancestorBound = source.getParent();
        this.allowMembers = allowMembers;
        this.descendantBounds.addAll(this.getNextGeneration(source));
    }

    AppGroupTraverser next() {
        AppGroupTraverser result = new AppGroupTraverser();
        result.visited.addAll(this.visited);
        result.depth = this.depth + 1;
        this.descendantBounds.forEach(c -> result.visitDescendants((Entity)c, true));
        if (this.ancestorBound != null) {
            result.visitAncestorsAndTheirDescendants(this.ancestorBound);
        }
        return result;
    }

    protected Collection<Entity> getNextGeneration(Entity parent) {
        if (!this.allowMembers || !(parent instanceof Group)) {
            return parent.getChildren();
        }
        MutableSet result = MutableSet.of();
        result.addAll(parent.getChildren());
        result.addAll(((Group)parent).getMembers());
        return result;
    }

    protected void visitAncestorsAndTheirDescendants(Entity ancestor) {
        Entity appAncestor = ancestor;
        while (!(appAncestor instanceof Application) && appAncestor.getParent() != null) {
            appAncestor = appAncestor.getParent();
        }
        this.visitDescendants(appAncestor, true);
        this.ancestorBound = appAncestor.getParent() != null ? appAncestor.getParent() : null;
    }

    protected void visitDescendants(Entity node, boolean isFirst) {
        if (!isFirst && !this.visited.add(node)) {
            return;
        }
        this.visitedThisTime.add(node);
        if (!isFirst && node instanceof Application) {
            this.descendantBounds.add(node);
        } else {
            this.getNextGeneration(node).forEach(c -> this.visitDescendants((Entity)c, false));
        }
    }

    boolean hasNext() {
        return this.ancestorBound != null || !this.descendantBounds.isEmpty();
    }

    AppGroupTraverser expandUntilMatchesFound(Predicate<Entity> test) {
        if (this.visitedThisTime.stream().anyMatch(test) || this.visitedThisTime.isEmpty()) {
            return this;
        }
        return this.next().expandUntilMatchesFound(test);
    }

    public static List<Entity> findFirstGroupOfMatches(Entity source, Predicate<Entity> test) {
        return AppGroupTraverser.findFirstGroupOfMatches(source, false, test);
    }

    public static List<Entity> findFirstGroupOfMatches(Entity source, boolean allowMembers, Predicate<Entity> test) {
        AppGroupTraverser traversed = new AppGroupTraverser(source).expandUntilMatchesFound(test);
        return traversed.visitedThisTime.stream().filter(test).collect(Collectors.toList());
    }
}

