/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml1.binding.encoding;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml1.binding.encoding.BaseSAML1MessageEncoder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.soap.common.SOAPObjectBuilder;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.ws.transport.http.HTTPOutTransport;
import org.opensaml.ws.transport.http.HTTPTransportUtils;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTTPSOAP11Encoder
extends BaseSAML1MessageEncoder {
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Encoder.class);

    public String getBindingURI() {
        return "urn:oasis:names:tc:SAML:1.0:bindings:SOAP-binding";
    }

    public boolean providesMessageConfidentiality(MessageContext messageContext) throws MessageEncodingException {
        return messageContext.getOutboundMessageTransport().isConfidential();
    }

    public boolean providesMessageIntegrity(MessageContext messageContext) throws MessageEncodingException {
        return messageContext.getOutboundMessageTransport().isIntegrityProtected();
    }

    protected void doEncode(MessageContext messageContext) throws MessageEncodingException {
        this.validateMessageContent(messageContext);
        SAMLMessageContext samlMsgCtx = (SAMLMessageContext)messageContext;
        Object samlMessage = samlMsgCtx.getOutboundSAMLMessage();
        if (samlMessage == null) {
            throw new MessageEncodingException("No outbound SAML message contained in message context");
        }
        this.signMessage(samlMsgCtx);
        Envelope envelope = this.buildSOAPMessage((SAMLObject)samlMessage);
        samlMsgCtx.setOutboundMessage((XMLObject)envelope);
        Element envelopeElem = this.marshallMessage((XMLObject)envelope);
        try {
            HTTPOutTransport outTransport = (HTTPOutTransport)messageContext.getOutboundMessageTransport();
            HTTPTransportUtils.addNoCacheHeaders((HTTPOutTransport)outTransport);
            HTTPTransportUtils.setUTF8Encoding((HTTPOutTransport)outTransport);
            HTTPTransportUtils.setContentType((HTTPOutTransport)outTransport, (String)"text/xml");
            outTransport.setHeader("SOAPAction", "http://www.oasis-open.org/committees/security");
            OutputStreamWriter out = new OutputStreamWriter(outTransport.getOutgoingStream(), "UTF-8");
            XMLHelper.writeNode((Node)envelopeElem, (Writer)out);
            ((Writer)out).flush();
        }
        catch (UnsupportedEncodingException e) {
            this.log.error("JVM does not support required UTF-8 encoding");
            throw new MessageEncodingException("JVM does not support required UTF-8 encoding");
        }
        catch (IOException e) {
            this.log.error("Unable to write message content to outbound stream", (Throwable)e);
            throw new MessageEncodingException("Unable to write message content to outbound stream", (Exception)e);
        }
    }

    protected Envelope buildSOAPMessage(SAMLObject samlMessage) {
        this.log.debug("Building SOAP message");
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SOAPObjectBuilder envBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Envelope.DEFAULT_ELEMENT_NAME);
        Envelope envelope = (Envelope)envBuilder.buildObject();
        this.log.debug("Adding SAML message to the SOAP message's body");
        SOAPObjectBuilder bodyBuilder = (SOAPObjectBuilder)builderFactory.getBuilder(Body.DEFAULT_ELEMENT_NAME);
        Body body = (Body)bodyBuilder.buildObject();
        body.getUnknownXMLObjects().add(samlMessage);
        envelope.setBody(body);
        return envelope;
    }

    protected void validateMessageContent(MessageContext messageContext) throws MessageEncodingException {
        if (!(messageContext instanceof SAMLMessageContext)) {
            this.log.error("Invalid message context type, this encoder only support SAMLMessageContext");
            throw new MessageEncodingException("Invalid message context type, this encoder only support SAMLMessageContext");
        }
        if (!(messageContext.getOutboundMessageTransport() instanceof HTTPOutTransport)) {
            this.log.error("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
            throw new MessageEncodingException("Invalid outbound message transport type, this encoder only support HTTPOutTransport");
        }
    }
}

