/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.reference.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.owasp.esapi.Encoder;
import org.owasp.esapi.EncoderConstants;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.reference.validation.BaseValidationRule;
import org.owasp.esapi.util.NullSafe;

public class StringValidationRule
extends BaseValidationRule {
    protected List<Pattern> whitelistPatterns = new ArrayList<Pattern>();
    protected List<Pattern> blacklistPatterns = new ArrayList<Pattern>();
    protected int minLength = 0;
    protected int maxLength = Integer.MAX_VALUE;
    protected boolean validateInputAndCanonical = true;

    public StringValidationRule(String typeName) {
        super(typeName);
    }

    public StringValidationRule(String typeName, Encoder encoder) {
        super(typeName, encoder);
    }

    public StringValidationRule(String typeName, Encoder encoder, String whitelistPattern) {
        super(typeName, encoder);
        this.addWhitelistPattern(whitelistPattern);
    }

    public void addWhitelistPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        try {
            this.whitelistPatterns.add(Pattern.compile(pattern));
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Validation misconfiguration, problem with specified pattern: " + pattern, e);
        }
    }

    public void addWhitelistPattern(Pattern p) {
        if (p == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.whitelistPatterns.add(p);
    }

    public void addBlacklistPattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        try {
            this.blacklistPatterns.add(Pattern.compile(pattern));
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Validation misconfiguration, problem with specified pattern: " + pattern, e);
        }
    }

    public void addBlacklistPattern(Pattern p) {
        if (p == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.blacklistPatterns.add(p);
    }

    public void setMinimumLength(int length) {
        this.minLength = length;
    }

    public void setMaximumLength(int length) {
        this.maxLength = length;
    }

    public void setValidateInputAndCanonical(boolean flag) {
        this.validateInputAndCanonical = flag;
    }

    private String checkWhitelist(String context, String input, String orig) throws ValidationException {
        for (Pattern p : this.whitelistPatterns) {
            if (p.matcher(input).matches()) continue;
            throw new ValidationException(context + ": Invalid input. Please conform to regex " + p.pattern() + (this.maxLength == Integer.MAX_VALUE ? "" : " with a maximum length of " + this.maxLength), "Invalid input: context=" + context + ", type(" + this.getTypeName() + ")=" + p.pattern() + ", input=" + input + (NullSafe.equals(orig, input) ? "" : ", orig=" + orig), context);
        }
        return input;
    }

    private String checkWhitelist(String context, String input) throws ValidationException {
        return this.checkWhitelist(context, input, input);
    }

    private String checkBlacklist(String context, String input, String orig) throws ValidationException {
        for (Pattern p : this.blacklistPatterns) {
            if (!p.matcher(input).matches()) continue;
            throw new ValidationException(context + ": Invalid input. Dangerous input matching " + p.pattern() + " detected.", "Dangerous input: context=" + context + ", type(" + this.getTypeName() + ")=" + p.pattern() + ", input=" + input + (NullSafe.equals(orig, input) ? "" : ", orig=" + orig), context);
        }
        return input;
    }

    private String checkBlacklist(String context, String input) throws ValidationException {
        return this.checkBlacklist(context, input, input);
    }

    private String checkLength(String context, String input, String orig) throws ValidationException {
        if (input.length() < this.minLength) {
            throw new ValidationException(context + ": Invalid input. The minimum length of " + this.minLength + " characters was not met.", "Input does not meet the minimum length of " + this.minLength + " by " + (this.minLength - input.length()) + " characters: context=" + context + ", type=" + this.getTypeName() + "), input=" + input + (NullSafe.equals(input, orig) ? "" : ", orig=" + orig), context);
        }
        if (input.length() > this.maxLength) {
            throw new ValidationException(context + ": Invalid input. The maximum length of " + this.maxLength + " characters was exceeded.", "Input exceeds maximum allowed length of " + this.maxLength + " by " + (input.length() - this.maxLength) + " characters: context=" + context + ", type=" + this.getTypeName() + ", orig=" + orig + ", input=" + input, context);
        }
        return input;
    }

    private String checkLength(String context, String input) throws ValidationException {
        return this.checkLength(context, input, input);
    }

    private String checkEmpty(String context, String input, String orig) throws ValidationException {
        if (!StringUtilities.isEmpty(input)) {
            return input;
        }
        if (this.allowNull) {
            return null;
        }
        throw new ValidationException(context + ": Input required.", "Input required: context=" + context + "), input=" + input + (NullSafe.equals(input, orig) ? "" : ", orig=" + orig), context);
    }

    private String checkEmpty(String context, String input) throws ValidationException {
        return this.checkEmpty(context, input, input);
    }

    public String getValid(String context, String input) throws ValidationException {
        String data = null;
        if (this.checkEmpty(context, input) == null) {
            return null;
        }
        if (this.validateInputAndCanonical) {
            this.checkLength(context, input);
            this.checkWhitelist(context, input);
            this.checkBlacklist(context, input);
            data = this.encoder.canonicalize(input);
        } else {
            data = input;
        }
        if (this.checkEmpty(context, data, input) == null) {
            return null;
        }
        this.checkLength(context, data, input);
        this.checkWhitelist(context, data, input);
        this.checkBlacklist(context, data, input);
        return data;
    }

    public String sanitize(String context, String input) {
        return this.whitelist(input, EncoderConstants.CHAR_ALPHANUMERICS);
    }
}

