/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.x509.PKIXValidationInformation;
import org.opensaml.xml.security.x509.PKIXValidationInformationResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticPKIXValidationInformationResolver
implements PKIXValidationInformationResolver {
    private List<PKIXValidationInformation> pkixInfo;
    private Set<String> trustedNames;

    public StaticPKIXValidationInformationResolver(List<PKIXValidationInformation> info, Set<String> names) {
        this.pkixInfo = info != null ? new ArrayList<PKIXValidationInformation>(info) : Collections.EMPTY_LIST;
        this.trustedNames = names != null ? new HashSet<String>(names) : Collections.EMPTY_SET;
    }

    @Override
    public Set<String> resolveTrustedNames(CriteriaSet criteriaSet) throws SecurityException, UnsupportedOperationException {
        return this.trustedNames;
    }

    @Override
    public boolean supportsTrustedNameResolution() {
        return true;
    }

    @Override
    public Iterable<PKIXValidationInformation> resolve(CriteriaSet criteria) throws SecurityException {
        return this.pkixInfo;
    }

    @Override
    public PKIXValidationInformation resolveSingle(CriteriaSet criteria) throws SecurityException {
        if (!this.pkixInfo.isEmpty()) {
            return this.pkixInfo.get(0);
        }
        return null;
    }
}

