# The PEP 484 type hints stub file for the QtNetworkAuth module.
#
# Generated by SIP 6.15.1
#
# Copyright (c) 2025 Riverbank Computing Limited <info@riverbankcomputing.com>
# 
# This file is part of PyQt6-NetworkAuth.
# 
# This file may be used under the terms of the GNU General Public License
# version 3.0 as published by the Free Software Foundation and appearing in
# the file LICENSE included in the packaging of this file.  Please review the
# following information to ensure the GNU General Public License version 3.0
# requirements will be met: http://www.gnu.org/copyleft/gpl.html.
# 
# If you do not wish to use this file under the terms of the GPL version 3.0
# then you may purchase a commercial license.  For more information contact
# info@riverbankcomputing.com.
# 
# This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
# WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.


import collections, re, typing, enum

try:
    from warnings import deprecated
except ImportError:
    pass

import PyQt6.sip

from PyQt6 import QtCore
from PyQt6 import QtNetwork

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[collections.abc.Callable[..., Any], QtCore.pyqtBoundSignal]


class QAbstractOAuth(QtCore.QObject):

    class ContentType(enum.Enum):
        WwwFormUrlEncoded = ... # type: QAbstractOAuth.ContentType
        Json = ... # type: QAbstractOAuth.ContentType

    class Error(enum.Enum):
        NoError = ... # type: QAbstractOAuth.Error
        NetworkError = ... # type: QAbstractOAuth.Error
        ServerError = ... # type: QAbstractOAuth.Error
        OAuthTokenNotFoundError = ... # type: QAbstractOAuth.Error
        OAuthTokenSecretNotFoundError = ... # type: QAbstractOAuth.Error
        OAuthCallbackNotVerified = ... # type: QAbstractOAuth.Error
        ClientError = ... # type: QAbstractOAuth.Error
        ExpiredError = ... # type: QAbstractOAuth.Error

    class Stage(enum.Enum):
        RequestingTemporaryCredentials = ... # type: QAbstractOAuth.Stage
        RequestingAuthorization = ... # type: QAbstractOAuth.Stage
        RequestingAccessToken = ... # type: QAbstractOAuth.Stage
        RefreshingAccessToken = ... # type: QAbstractOAuth.Stage

    class Status(enum.Enum):
        NotAuthenticated = ... # type: QAbstractOAuth.Status
        TemporaryCredentialsReceived = ... # type: QAbstractOAuth.Status
        Granted = ... # type: QAbstractOAuth.Status
        RefreshingToken = ... # type: QAbstractOAuth.Status

    @staticmethod
    def generateRandomString(length: int) -> QtCore.QByteArray: ...
    def resourceOwnerAuthorization(self, url: QtCore.QUrl, parameters: dict[str|None, collections.abc.Sequence[typing.Any]]) -> None: ...
    def callback(self) -> str: ...
    def setStatus(self, status: 'QAbstractOAuth.Status') -> None: ...
    replyDataReceived: typing.ClassVar[QtCore.pyqtSignal]
    finished: typing.ClassVar[QtCore.pyqtSignal]
    granted: typing.ClassVar[QtCore.pyqtSignal]
    authorizeWithBrowser: typing.ClassVar[QtCore.pyqtSignal]
    requestFailed: typing.ClassVar[QtCore.pyqtSignal]
    contentTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    extraTokensChanged: typing.ClassVar[QtCore.pyqtSignal]
    authorizationUrlChanged: typing.ClassVar[QtCore.pyqtSignal]
    statusChanged: typing.ClassVar[QtCore.pyqtSignal]
    tokenChanged: typing.ClassVar[QtCore.pyqtSignal]
    clientIdentifierChanged: typing.ClassVar[QtCore.pyqtSignal]
    def grant(self) -> None: ...
    def prepareRequest(self, request: QtNetwork.QNetworkRequest|None, verb: QtCore.QByteArray|bytes|bytearray|memoryview, body: QtCore.QByteArray|bytes|bytearray|memoryview = ...) -> None: ...
    def setContentType(self, contentType: 'QAbstractOAuth.ContentType') -> None: ...
    def contentType(self) -> 'QAbstractOAuth.ContentType': ...
    def setModifyParametersFunction(self, modifyParametersFunction: typing.Callable[..., None]) -> None: ...
    def modifyParametersFunction(self) -> typing.Callable[..., None]: ...
    def deleteResource(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def put(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def post(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def get(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def head(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def setReplyHandler(self, handler: 'QAbstractOAuthReplyHandler|None') -> None: ...
    def replyHandler(self) -> 'QAbstractOAuthReplyHandler|None': ...
    def extraTokens(self) -> dict[str, typing.Any]: ...
    def setAuthorizationUrl(self, url: QtCore.QUrl) -> None: ...
    def authorizationUrl(self) -> QtCore.QUrl: ...
    def status(self) -> 'QAbstractOAuth.Status': ...
    def setNetworkAccessManager(self, networkAccessManager: QtNetwork.QNetworkAccessManager|None) -> None: ...
    def networkAccessManager(self) -> QtNetwork.QNetworkAccessManager|None: ...
    def setToken(self, token: str|None) -> None: ...
    def token(self) -> str: ...
    def setClientIdentifier(self, clientIdentifier: str|None) -> None: ...
    def clientIdentifier(self) -> str: ...


class QAbstractOAuth2(QAbstractOAuth):

    class NonceMode(enum.Enum):
        Automatic = ... # type: QAbstractOAuth2.NonceMode
        Enabled = ... # type: QAbstractOAuth2.NonceMode
        Disabled = ... # type: QAbstractOAuth2.NonceMode

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, manager: QtNetwork.QNetworkAccessManager|None, parent: QtCore.QObject|None = ...) -> None: ...

    serverReportedErrorOccurred: typing.ClassVar[QtCore.pyqtSignal]
    tokenUrlChanged: typing.ClassVar[QtCore.pyqtSignal]
    idTokenChanged: typing.ClassVar[QtCore.pyqtSignal]
    nonceChanged: typing.ClassVar[QtCore.pyqtSignal]
    nonceModeChanged: typing.ClassVar[QtCore.pyqtSignal]
    autoRefreshChanged: typing.ClassVar[QtCore.pyqtSignal]
    refreshLeadTimeChanged: typing.ClassVar[QtCore.pyqtSignal]
    accessTokenAboutToExpire: typing.ClassVar[QtCore.pyqtSignal]
    requestedScopeTokensChanged: typing.ClassVar[QtCore.pyqtSignal]
    grantedScopeTokensChanged: typing.ClassVar[QtCore.pyqtSignal]
    def refreshTokens(self) -> None: ...
    def refreshTokensImplementation(self) -> None: ...
    def clearNetworkRequestModifier(self) -> None: ...
    def setTokenUrl(self, tokenUrl: QtCore.QUrl) -> None: ...
    def tokenUrl(self) -> QtCore.QUrl: ...
    def idToken(self) -> str: ...
    def setNonce(self, nonce: str|None) -> None: ...
    def nonce(self) -> str: ...
    def setNonceMode(self, mode: 'QAbstractOAuth2.NonceMode') -> None: ...
    def nonceMode(self) -> 'QAbstractOAuth2.NonceMode': ...
    def setAutoRefresh(self, enable: bool) -> None: ...
    def autoRefresh(self) -> bool: ...
    def setRefreshLeadTime(self, leadTime: int) -> None: ...
    def refreshLeadTime(self) -> int: ...
    def setRequestedScopeTokens(self, tokens: collections.abc.Iterable[QtCore.QByteArray|bytes|bytearray|memoryview]) -> None: ...
    def requestedScopeTokens(self) -> set[QtCore.QByteArray]: ...
    def grantedScopeTokens(self) -> set[QtCore.QByteArray]: ...
    sslConfigurationChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setSslConfiguration(self, configuration: QtNetwork.QSslConfiguration) -> None: ...
    def sslConfiguration(self) -> QtNetwork.QSslConfiguration: ...
    def prepareRequest(self, request: QtNetwork.QNetworkRequest|None, verb: QtCore.QByteArray|bytes|bytearray|memoryview, body: QtCore.QByteArray|bytes|bytearray|memoryview = ...) -> None: ...
    def setResponseType(self, responseType: str|None) -> None: ...
    authorizationCallbackReceived: typing.ClassVar[QtCore.pyqtSignal]
    error: typing.ClassVar[QtCore.pyqtSignal]
    expirationAtChanged: typing.ClassVar[QtCore.pyqtSignal]
    stateChanged: typing.ClassVar[QtCore.pyqtSignal]
    clientIdentifierSharedKeyChanged: typing.ClassVar[QtCore.pyqtSignal]
    responseTypeChanged: typing.ClassVar[QtCore.pyqtSignal]
    refreshTokenChanged: typing.ClassVar[QtCore.pyqtSignal]
    userAgentChanged: typing.ClassVar[QtCore.pyqtSignal]
    scopeChanged: typing.ClassVar[QtCore.pyqtSignal]
    def setRefreshToken(self, refreshToken: str|None) -> None: ...
    def refreshToken(self) -> str: ...
    def expirationAt(self) -> QtCore.QDateTime: ...
    def setState(self, state: str|None) -> None: ...
    def state(self) -> str: ...
    def setClientIdentifierSharedKey(self, clientIdentifierSharedKey: str|None) -> None: ...
    def clientIdentifierSharedKey(self) -> str: ...
    def responseType(self) -> str: ...
    def setUserAgent(self, userAgent: str|None) -> None: ...
    def userAgent(self) -> str: ...
    def setScope(self, scope: str|None) -> None: ...
    def scope(self) -> str: ...
    def deleteResource(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    @typing.overload
    def put(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    @typing.overload
    def put(self, url: QtCore.QUrl, data: QtCore.QByteArray|bytes|bytearray|memoryview) -> QtNetwork.QNetworkReply|None: ...
    @typing.overload
    def put(self, url: QtCore.QUrl, multiPart: QtNetwork.QHttpMultiPart|None) -> QtNetwork.QNetworkReply|None: ...
    @typing.overload
    def post(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    @typing.overload
    def post(self, url: QtCore.QUrl, data: QtCore.QByteArray|bytes|bytearray|memoryview) -> QtNetwork.QNetworkReply|None: ...
    @typing.overload
    def post(self, url: QtCore.QUrl, multiPart: QtNetwork.QHttpMultiPart|None) -> QtNetwork.QNetworkReply|None: ...
    def get(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def head(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def createAuthenticatedUrl(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtCore.QUrl: ...


class QAbstractOAuthReplyHandler(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    tokenRequestErrorOccurred: typing.ClassVar[QtCore.pyqtSignal]
    callbackDataReceived: typing.ClassVar[QtCore.pyqtSignal]
    replyDataReceived: typing.ClassVar[QtCore.pyqtSignal]
    tokensReceived: typing.ClassVar[QtCore.pyqtSignal]
    callbackReceived: typing.ClassVar[QtCore.pyqtSignal]
    def networkReplyFinished(self, reply: QtNetwork.QNetworkReply|None) -> None: ...
    def callback(self) -> str: ...


class QOAuth1(QAbstractOAuth):

    class SignatureMethod(enum.Enum):
        Hmac_Sha1 = ... # type: QOAuth1.SignatureMethod
        Rsa_Sha1 = ... # type: QOAuth1.SignatureMethod
        PlainText = ... # type: QOAuth1.SignatureMethod

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, manager: QtNetwork.QNetworkAccessManager|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, clientIdentifier: str|None, clientSharedSecret: str|None, manager: QtNetwork.QNetworkAccessManager|None, parent: QtCore.QObject|None = ...) -> None: ...

    @staticmethod
    def generateAuthorizationHeader(oauthParams: dict[str|None, typing.Any]) -> QtCore.QByteArray: ...
    @staticmethod
    def nonce() -> QtCore.QByteArray: ...
    @typing.overload
    def setup(self, request: QtNetwork.QNetworkRequest|None, signingParameters: dict[str|None, typing.Any], operation: QtNetwork.QNetworkAccessManager.Operation) -> None: ...
    @typing.overload
    def setup(self, request: QtNetwork.QNetworkRequest|None, signingParameters: dict[str|None, typing.Any], operationVerb: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def requestTokenCredentials(self, operation: QtNetwork.QNetworkAccessManager.Operation, url: QtCore.QUrl, temporaryToken: tuple[str|None, str|None], parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def requestTemporaryCredentials(self, operation: QtNetwork.QNetworkAccessManager.Operation, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    tokenCredentialsUrlChanged: typing.ClassVar[QtCore.pyqtSignal]
    temporaryCredentialsUrlChanged: typing.ClassVar[QtCore.pyqtSignal]
    tokenSecretChanged: typing.ClassVar[QtCore.pyqtSignal]
    clientSharedSecretChanged: typing.ClassVar[QtCore.pyqtSignal]
    signatureMethodChanged: typing.ClassVar[QtCore.pyqtSignal]
    def continueGrantWithVerifier(self, verifier: str|None) -> None: ...
    def grant(self) -> None: ...
    def prepareRequest(self, request: QtNetwork.QNetworkRequest|None, verb: QtCore.QByteArray|bytes|bytearray|memoryview, body: QtCore.QByteArray|bytes|bytearray|memoryview = ...) -> None: ...
    def deleteResource(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def put(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def post(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def get(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def head(self, url: QtCore.QUrl, parameters: dict[str|None, typing.Any] = ...) -> QtNetwork.QNetworkReply|None: ...
    def setSignatureMethod(self, value: 'QOAuth1.SignatureMethod') -> None: ...
    def signatureMethod(self) -> 'QOAuth1.SignatureMethod': ...
    def setTokenCredentialsUrl(self, url: QtCore.QUrl) -> None: ...
    def tokenCredentialsUrl(self) -> QtCore.QUrl: ...
    def setTemporaryCredentialsUrl(self, url: QtCore.QUrl) -> None: ...
    def temporaryCredentialsUrl(self) -> QtCore.QUrl: ...
    @typing.overload
    def setTokenCredentials(self, tokenCredentials: tuple[str|None, str|None]) -> None: ...
    @typing.overload
    def setTokenCredentials(self, token: str|None, tokenSecret: str|None) -> None: ...
    def tokenCredentials(self) -> tuple[str, str]: ...
    def setTokenSecret(self, tokenSecret: str|None) -> None: ...
    def tokenSecret(self) -> str: ...
    @typing.overload
    def setClientCredentials(self, clientCredentials: tuple[str|None, str|None]) -> None: ...
    @typing.overload
    def setClientCredentials(self, clientIdentifier: str|None, clientSharedSecret: str|None) -> None: ...
    def clientCredentials(self) -> tuple[str, str]: ...
    def setClientSharedSecret(self, clientSharedSecret: str|None) -> None: ...
    def clientSharedSecret(self) -> str: ...


class QOAuth1Signature(PyQt6.sip.simplewrapper):

    class HttpRequestMethod(enum.Enum):
        Head = ... # type: QOAuth1Signature.HttpRequestMethod
        Get = ... # type: QOAuth1Signature.HttpRequestMethod
        Put = ... # type: QOAuth1Signature.HttpRequestMethod
        Post = ... # type: QOAuth1Signature.HttpRequestMethod
        Delete = ... # type: QOAuth1Signature.HttpRequestMethod
        Custom = ... # type: QOAuth1Signature.HttpRequestMethod
        Unknown = ... # type: QOAuth1Signature.HttpRequestMethod

    @typing.overload
    def __init__(self, url: QtCore.QUrl = ..., method: 'QOAuth1Signature.HttpRequestMethod' = ..., parameters: dict[str|None, collections.abc.Sequence[typing.Any]] = ...) -> None: ...
    @typing.overload
    def __init__(self, url: QtCore.QUrl, clientSharedKey: str|None, tokenSecret: str|None, method: 'QOAuth1Signature.HttpRequestMethod' = ..., parameters: dict[str|None, collections.abc.Sequence[typing.Any]] = ...) -> None: ...
    @typing.overload
    def __init__(self, other: 'QOAuth1Signature') -> None: ...

    def setCustomMethodString(self, verb: QtCore.QByteArray|bytes|bytearray|memoryview) -> None: ...
    def customMethodString(self) -> QtCore.QByteArray: ...
    def swap(self, other: 'QOAuth1Signature') -> None: ...
    @typing.overload
    def plainText(self) -> QtCore.QByteArray: ...
    @typing.overload
    @staticmethod
    def plainText(clientSharedSecret: str|None, tokenSecret: str|None) -> QtCore.QByteArray: ...
    def rsaSha1(self) -> QtCore.QByteArray: ...
    def hmacSha1(self) -> QtCore.QByteArray: ...
    def setTokenSecret(self, secret: str|None) -> None: ...
    def tokenSecret(self) -> str: ...
    def setClientSharedKey(self, secret: str|None) -> None: ...
    def clientSharedKey(self) -> str: ...
    def value(self, key: str|None, defaultValue: typing.Any = ...) -> typing.Any: ...
    def take(self, key: str|None) -> typing.Any: ...
    def keys(self) -> list[str]: ...
    def insert(self, key: str|None, value: typing.Any) -> None: ...
    def addRequestBody(self, body: QtCore.QUrlQuery) -> None: ...
    def setParameters(self, parameters: dict[str|None, collections.abc.Sequence[typing.Any]]) -> None: ...
    def parameters(self) -> dict[str, list[typing.Any]]: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def url(self) -> QtCore.QUrl: ...
    def setHttpRequestMethod(self, method: 'QOAuth1Signature.HttpRequestMethod') -> None: ...
    def httpRequestMethod(self) -> 'QOAuth1Signature.HttpRequestMethod': ...


class QOAuth2AuthorizationCodeFlow(QAbstractOAuth2):

    class PkceMethod(enum.Enum):
        S256 = ... # type: QOAuth2AuthorizationCodeFlow.PkceMethod
        Plain = ... # type: QOAuth2AuthorizationCodeFlow.PkceMethod
        None_ = ... # type: QOAuth2AuthorizationCodeFlow.PkceMethod

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, manager: QtNetwork.QNetworkAccessManager|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, clientIdentifier: str|None, manager: QtNetwork.QNetworkAccessManager|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, authorizationUrl: QtCore.QUrl, accessTokenUrl: QtCore.QUrl, manager: QtNetwork.QNetworkAccessManager|None, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, clientIdentifier: str|None, authorizationUrl: QtCore.QUrl, accessTokenUrl: QtCore.QUrl, manager: QtNetwork.QNetworkAccessManager|None, parent: QtCore.QObject|None = ...) -> None: ...

    def refreshTokensImplementation(self) -> None: ...
    def pkceMethod(self) -> 'QOAuth2AuthorizationCodeFlow.PkceMethod': ...
    def setPkceMethod(self, method: 'QOAuth2AuthorizationCodeFlow.PkceMethod', length: int = ...) -> None: ...
    def resourceOwnerAuthorization(self, url: QtCore.QUrl, parameters: dict[str|None, collections.abc.Sequence[typing.Any]] = ...) -> None: ...
    def requestAccessToken(self, code: str|None) -> None: ...
    def buildAuthenticateUrl(self, parameters: dict[str|None, collections.abc.Sequence[typing.Any]] = ...) -> QtCore.QUrl: ...
    accessTokenUrlChanged: typing.ClassVar[QtCore.pyqtSignal]
    def refreshAccessToken(self) -> None: ...
    def grant(self) -> None: ...
    def setAccessTokenUrl(self, accessTokenUrl: QtCore.QUrl) -> None: ...
    def accessTokenUrl(self) -> QtCore.QUrl: ...


class QOAuth2DeviceAuthorizationFlow(QAbstractOAuth2):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject|None) -> None: ...
    @typing.overload
    def __init__(self, manager: QtNetwork.QNetworkAccessManager|None, parent: QtCore.QObject|None = ...) -> None: ...

    def refreshTokensImplementation(self) -> None: ...
    def event(self, event: QtCore.QEvent|None) -> bool: ...
    userCodeExpirationAtChanged: typing.ClassVar[QtCore.pyqtSignal]
    pollingChanged: typing.ClassVar[QtCore.pyqtSignal]
    completeVerificationUrlChanged: typing.ClassVar[QtCore.pyqtSignal]
    verificationUrlChanged: typing.ClassVar[QtCore.pyqtSignal]
    userCodeChanged: typing.ClassVar[QtCore.pyqtSignal]
    authorizeWithUserCode: typing.ClassVar[QtCore.pyqtSignal]
    def stopTokenPolling(self) -> None: ...
    def startTokenPolling(self) -> bool: ...
    def grant(self) -> None: ...
    def userCodeExpirationAt(self) -> QtCore.QDateTime: ...
    def isPolling(self) -> bool: ...
    def completeVerificationUrl(self) -> QtCore.QUrl: ...
    def verificationUrl(self) -> QtCore.QUrl: ...
    def userCode(self) -> str: ...


class QOAuthOobReplyHandler(QAbstractOAuthReplyHandler):

    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...

    def networkReplyFinished(self, reply: QtNetwork.QNetworkReply|None) -> None: ...
    def callback(self) -> str: ...


class QOAuthHttpServerReplyHandler(QOAuthOobReplyHandler):

    @typing.overload
    def __init__(self, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, port: int, parent: QtCore.QObject|None = ...) -> None: ...
    @typing.overload
    def __init__(self, address: QtNetwork.QHostAddress|QtNetwork.QHostAddress.SpecialAddress, port: int, parent: QtCore.QObject|None = ...) -> None: ...

    def setCallbackHost(self, path: str|None) -> None: ...
    def callbackHost(self) -> str: ...
    def isListening(self) -> bool: ...
    def close(self) -> None: ...
    @typing.overload
    def listen(self, configuration: QtNetwork.QSslConfiguration, address: QtNetwork.QHostAddress|QtNetwork.QHostAddress.SpecialAddress = ..., port: int = ...) -> bool: ...
    @typing.overload
    def listen(self, address: QtNetwork.QHostAddress|QtNetwork.QHostAddress.SpecialAddress = ..., port: int = ...) -> bool: ...
    def port(self) -> int: ...
    def setCallbackText(self, text: str|None) -> None: ...
    def callbackText(self) -> str: ...
    def setCallbackPath(self, path: str|None) -> None: ...
    def callbackPath(self) -> str: ...
    def callback(self) -> str: ...


class QOAuthUriSchemeReplyHandler(QOAuthOobReplyHandler):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, parent: QtCore.QObject|None) -> None: ...
    @typing.overload
    def __init__(self, redirectUrl: QtCore.QUrl, parent: QtCore.QObject|None = ...) -> None: ...

    redirectUrlChanged: typing.ClassVar[QtCore.pyqtSignal]
    def handleAuthorizationRedirect(self, url: QtCore.QUrl) -> bool: ...
    def isListening(self) -> bool: ...
    def close(self) -> None: ...
    def listen(self) -> bool: ...
    def redirectUrl(self) -> QtCore.QUrl: ...
    def setRedirectUrl(self, url: QtCore.QUrl) -> None: ...
    def callback(self) -> str: ...


PYQT_NETWORKAUTH_VERSION = ... # type: int
PYQT_NETWORKAUTH_VERSION_STR = ... # type: str
