/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: IXPathResult.java,v $
 * Version:       $Name:  $ $Revision: 1.3 $
 * Last Modified: $Date: 2004/06/21 10:24:23 $
 *****************************************************************************/
package org.ten60.netkernel.xml.xda;

/**
 * The result of evaluating an XPath expression on IXDA
 * @author  pjr
 */
public interface IXPathResult
{
	public static final int XPR_BOOLEAN=1;
	public static final int XPR_NODESET=2;
	public static final int XPR_NULL=3;
	public static final int XPR_NUMBER=4;
	public static final int XPR_RTREEFRAG=5;
	public static final int XPR_STRING=6;
	public static final int XPR_UNKNOWN=7;
	public static final int XPR_SINGLE_ELEMENT=8;
    
    /** @return the type of result. It will be one of the constants
     * defined by this interface
     */
    public int getType();
    
    /** @return the value of result cast to a string
     * @throws XPathResultTransformException if result cannot be extracted
     */
    public String getStringValue();
	
	/** @return true if the result can be cast to true
	 * @exception thrown if result cannot be cast to boolean
	 */
	public boolean isTrue() throws XPathLocationException;
}