/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: JDOMSerializer.java,v $
  Version:       $Name:  $ $Revision: 1.2 $
  Last Modified: $Date: 2004/09/13 08:55:31 $
 *****************************************************************************/

package org.ten60.netkernel.xml.transrepresentation;

import com.ten60.netkernel.urii.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.layer1.representation.*;
import com.ten60.netkernel.urii.aspect.*;

import org.jdom.*;
import org.jdom.output.*;
import java.io.*;

/**
 * Serialise JDOM to a binary stream, use special serializer if content is HTML.
 * @author  pjr
 */
public class JDOMSerializer extends NKFTransreptorImpl
{
	public boolean supports(IURRepresentation aFrom, Class aTo)
	{	return ( aFrom.hasAspect(IAspectJDOM.class) && ( aTo.isAssignableFrom(IAspectReadableBinaryStream.class)) );
	}
	
	protected void transrepresent(INKFConvenienceHelper context) throws Exception
	{	IURRepresentation old=context.source(INKFRequestReadOnly.URI_SYSTEM);
		boolean isHTML=old.getMeta().getMimeType().equals("text/html");
		IAspectJDOM jda =(IAspectJDOM)old.getAspect(IAspectJDOM.class);
		ByteArrayOutputStream baos=new ByteArrayOutputStream(2048);
		if(isHTML)
		{	DOMOutputter dout=new DOMOutputter();
			OutputStreamWriter osw=new OutputStreamWriter(baos, "UTF-8");
			SerializedDOMAspect.serialize((dout.output(jda.getReadOnlyDocument())).getDocumentElement(), osw );
		}
		else
		{	XMLOutputter xo=new XMLOutputter();
			xo.setFormat(Format.getPrettyFormat());
			xo.output(jda.getReadOnlyDocument(), baos);		
		}
		IAspectBinaryStream bsa=new ByteArrayAspect(baos.toByteArray());
		INKFResponse resp=context.createResponseFrom(old);
		resp.addAspect(bsa);
		context.setResponse(resp);
	}
}