<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="default"/>
    <xsl:template match="/config">
        <config>
			<xsl:choose>
				<xsl:when test="followRedirects">
					<xsl:copy-of select="followRedirects"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="$default/config/followRedirects"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="retryAttempts">
					<xsl:copy-of select="retryAttempts"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="$default/config/retryAttempts"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="maxConnectionsPerHost">
					<xsl:copy-of select="maxConnectionsPerHost"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="$default/config/maxConnectionsPerHost"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="maxTotalConnections">
					<xsl:copy-of select="maxTotalConnections"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="$default/config/maxTotalConnections"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="maxAcceptableContentLength">
					<xsl:copy-of select="maxAcceptableContentLength"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="$default/config/maxAcceptableContentLength"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:choose>
				<xsl:when test="stateExpirationTime">
					<xsl:copy-of select="stateExpirationTime"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:copy-of select="$default/config/stateExpirationTime"/>
				</xsl:otherwise>
			</xsl:choose>
		</config>
    </xsl:template>
</xsl:stylesheet>
