/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     CSTRING = 326,
     CVARIABLE = 327,
     CPP_LINE = 328,
     IP = 329,
     DOLCONST = 330,
     ECONST = 331,
     NCONST = 332,
     UCONST = 333,
     UIDENT = 334,
     IDENT = 335,
     FCONST = 336,
     SCONST = 337,
     BCONST = 338,
     XCONST = 339,
     Op = 340,
     ICONST = 341,
     PARAM = 342,
     TYPECAST = 343,
     DOT_DOT = 344,
     COLON_EQUALS = 345,
     ABORT_P = 346,
     ABSOLUTE_P = 347,
     ACCESS = 348,
     ACTION = 349,
     ADD_P = 350,
     ADMIN = 351,
     AFTER = 352,
     AGGREGATE = 353,
     ALL = 354,
     ALSO = 355,
     ALTER = 356,
     ALWAYS = 357,
     ANALYSE = 358,
     ANALYZE = 359,
     AND = 360,
     ANY = 361,
     ARRAY = 362,
     AS = 363,
     ASC = 364,
     ASSERTION = 365,
     ASSIGNMENT = 366,
     ASYMMETRIC = 367,
     AT = 368,
     AUTHORIZATION = 369,
     BACKWARD = 370,
     BEFORE = 371,
     BEGIN_P = 372,
     BETWEEN = 373,
     BIGINT = 374,
     BINARY = 375,
     BIT = 376,
     BOOLEAN_P = 377,
     BOTH = 378,
     BY = 379,
     CACHE = 380,
     CALLED = 381,
     CASCADE = 382,
     CASCADED = 383,
     CASE = 384,
     CAST = 385,
     CATALOG_P = 386,
     CHAIN = 387,
     CHAR_P = 388,
     CHARACTER = 389,
     CHARACTERISTICS = 390,
     CHECK = 391,
     CHECKPOINT = 392,
     CLASS = 393,
     CLOSE = 394,
     CLUSTER = 395,
     COALESCE = 396,
     COLLATE = 397,
     COLUMN = 398,
     COMMENT = 399,
     COMMENTS = 400,
     COMMIT = 401,
     COMMITTED = 402,
     CONCURRENTLY = 403,
     CONFIGURATION = 404,
     CONNECTION = 405,
     CONSTRAINT = 406,
     CONSTRAINTS = 407,
     CONTENT_P = 408,
     CONTINUE_P = 409,
     CONVERSION_P = 410,
     COPY = 411,
     COST = 412,
     CREATE = 413,
     CREATEDB = 414,
     CREATEROLE = 415,
     CREATEUSER = 416,
     CROSS = 417,
     CSV = 418,
     CURRENT_P = 419,
     CURRENT_CATALOG = 420,
     CURRENT_DATE = 421,
     CURRENT_ROLE = 422,
     CURRENT_SCHEMA = 423,
     CURRENT_TIME = 424,
     CURRENT_TIMESTAMP = 425,
     CURRENT_USER = 426,
     CURSOR = 427,
     CYCLE = 428,
     DATA_P = 429,
     DATABASE = 430,
     DAY_P = 431,
     DEALLOCATE = 432,
     DEC = 433,
     DECIMAL_P = 434,
     DECLARE = 435,
     DEFAULT = 436,
     DEFAULTS = 437,
     DEFERRABLE = 438,
     DEFERRED = 439,
     DEFINER = 440,
     DELETE_P = 441,
     DELIMITER = 442,
     DELIMITERS = 443,
     DESC = 444,
     DICTIONARY = 445,
     DISABLE_P = 446,
     DISCARD = 447,
     DISTINCT = 448,
     DO = 449,
     DOCUMENT_P = 450,
     DOMAIN_P = 451,
     DOUBLE_P = 452,
     DROP = 453,
     EACH = 454,
     ELSE = 455,
     ENABLE_P = 456,
     ENCODING = 457,
     ENCRYPTED = 458,
     END_P = 459,
     ENUM_P = 460,
     ESCAPE = 461,
     EXCEPT = 462,
     EXCLUDE = 463,
     EXCLUDING = 464,
     EXCLUSIVE = 465,
     EXECUTE = 466,
     EXISTS = 467,
     EXPLAIN = 468,
     EXTERNAL = 469,
     EXTRACT = 470,
     FALSE_P = 471,
     FAMILY = 472,
     FETCH = 473,
     FIRST_P = 474,
     FLOAT_P = 475,
     FOLLOWING = 476,
     FOR = 477,
     FORCE = 478,
     FOREIGN = 479,
     FORWARD = 480,
     FREEZE = 481,
     FROM = 482,
     FULL = 483,
     FUNCTION = 484,
     FUNCTIONS = 485,
     GLOBAL = 486,
     GRANT = 487,
     GRANTED = 488,
     GREATEST = 489,
     GROUP_P = 490,
     HANDLER = 491,
     HAVING = 492,
     HEADER_P = 493,
     HOLD = 494,
     HOUR_P = 495,
     IDENTITY_P = 496,
     IF_P = 497,
     ILIKE = 498,
     IMMEDIATE = 499,
     IMMUTABLE = 500,
     IMPLICIT_P = 501,
     IN_P = 502,
     INCLUDING = 503,
     INCREMENT = 504,
     INDEX = 505,
     INDEXES = 506,
     INHERIT = 507,
     INHERITS = 508,
     INITIALLY = 509,
     INLINE_P = 510,
     INNER_P = 511,
     INOUT = 512,
     INPUT_P = 513,
     INSENSITIVE = 514,
     INSERT = 515,
     INSTEAD = 516,
     INT_P = 517,
     INTEGER = 518,
     INTERSECT = 519,
     INTERVAL = 520,
     INTO = 521,
     INVOKER = 522,
     IS = 523,
     ISNULL = 524,
     ISOLATION = 525,
     JOIN = 526,
     KEY = 527,
     LANGUAGE = 528,
     LARGE_P = 529,
     LAST_P = 530,
     LC_COLLATE_P = 531,
     LC_CTYPE_P = 532,
     LEADING = 533,
     LEAST = 534,
     LEFT = 535,
     LEVEL = 536,
     LIKE = 537,
     LIMIT = 538,
     LISTEN = 539,
     LOAD = 540,
     LOCAL = 541,
     LOCALTIME = 542,
     LOCALTIMESTAMP = 543,
     LOCATION = 544,
     LOCK_P = 545,
     LOGIN_P = 546,
     MAPPING = 547,
     MATCH = 548,
     MAXVALUE = 549,
     MINUTE_P = 550,
     MINVALUE = 551,
     MODE = 552,
     MONTH_P = 553,
     MOVE = 554,
     NAME_P = 555,
     NAMES = 556,
     NATIONAL = 557,
     NATURAL = 558,
     NCHAR = 559,
     NEXT = 560,
     NO = 561,
     NOCREATEDB = 562,
     NOCREATEROLE = 563,
     NOCREATEUSER = 564,
     NOINHERIT = 565,
     NOLOGIN_P = 566,
     NONE = 567,
     NOSUPERUSER = 568,
     NOT = 569,
     NOTHING = 570,
     NOTIFY = 571,
     NOTNULL = 572,
     NOWAIT = 573,
     NULL_P = 574,
     NULLIF = 575,
     NULLS_P = 576,
     NUMERIC = 577,
     OBJECT_P = 578,
     OF = 579,
     OFF = 580,
     OFFSET = 581,
     OIDS = 582,
     ON = 583,
     ONLY = 584,
     OPERATOR = 585,
     OPTION = 586,
     OPTIONS = 587,
     OR = 588,
     ORDER = 589,
     OUT_P = 590,
     OUTER_P = 591,
     OVER = 592,
     OVERLAPS = 593,
     OVERLAY = 594,
     OWNED = 595,
     OWNER = 596,
     PARSER = 597,
     PARTIAL = 598,
     PARTITION = 599,
     PASSWORD = 600,
     PLACING = 601,
     PLANS = 602,
     POSITION = 603,
     PRECEDING = 604,
     PRECISION = 605,
     PRESERVE = 606,
     PREPARE = 607,
     PREPARED = 608,
     PRIMARY = 609,
     PRIOR = 610,
     PRIVILEGES = 611,
     PROCEDURAL = 612,
     PROCEDURE = 613,
     QUOTE = 614,
     RANGE = 615,
     READ = 616,
     REAL = 617,
     REASSIGN = 618,
     RECHECK = 619,
     RECURSIVE = 620,
     REFERENCES = 621,
     REINDEX = 622,
     RELATIVE_P = 623,
     RELEASE = 624,
     RENAME = 625,
     REPEATABLE = 626,
     REPLACE = 627,
     REPLICA = 628,
     RESET = 629,
     RESTART = 630,
     RESTRICT = 631,
     RETURNING = 632,
     RETURNS = 633,
     REVOKE = 634,
     RIGHT = 635,
     ROLE = 636,
     ROLLBACK = 637,
     ROW = 638,
     ROWS = 639,
     RULE = 640,
     SAVEPOINT = 641,
     SCHEMA = 642,
     SCROLL = 643,
     SEARCH = 644,
     SECOND_P = 645,
     SECURITY = 646,
     SELECT = 647,
     SEQUENCE = 648,
     SEQUENCES = 649,
     SERIALIZABLE = 650,
     SERVER = 651,
     SESSION = 652,
     SESSION_USER = 653,
     SET = 654,
     SETOF = 655,
     SHARE = 656,
     SHOW = 657,
     SIMILAR = 658,
     SIMPLE = 659,
     SMALLINT = 660,
     SOME = 661,
     STABLE = 662,
     STANDALONE_P = 663,
     START = 664,
     STATEMENT = 665,
     STATISTICS = 666,
     STDIN = 667,
     STDOUT = 668,
     STORAGE = 669,
     STRICT_P = 670,
     STRIP_P = 671,
     SUBSTRING = 672,
     SUPERUSER_P = 673,
     SYMMETRIC = 674,
     SYSID = 675,
     SYSTEM_P = 676,
     TABLE = 677,
     TABLES = 678,
     TABLESPACE = 679,
     TEMP = 680,
     TEMPLATE = 681,
     TEMPORARY = 682,
     TEXT_P = 683,
     THEN = 684,
     TIME = 685,
     TIMESTAMP = 686,
     TO = 687,
     TRAILING = 688,
     TRANSACTION = 689,
     TREAT = 690,
     TRIGGER = 691,
     TRIM = 692,
     TRUE_P = 693,
     TRUNCATE = 694,
     TRUSTED = 695,
     TYPE_P = 696,
     UNBOUNDED = 697,
     UNCOMMITTED = 698,
     UNENCRYPTED = 699,
     UNION = 700,
     UNIQUE = 701,
     UNKNOWN = 702,
     UNLISTEN = 703,
     UNTIL = 704,
     UPDATE = 705,
     USER = 706,
     USING = 707,
     VACUUM = 708,
     VALID = 709,
     VALIDATOR = 710,
     VALUE_P = 711,
     VALUES = 712,
     VARCHAR = 713,
     VARIADIC = 714,
     VARYING = 715,
     VERBOSE = 716,
     VERSION_P = 717,
     VIEW = 718,
     VOLATILE = 719,
     WHEN = 720,
     WHERE = 721,
     WHITESPACE_P = 722,
     WINDOW = 723,
     WITH = 724,
     WITHOUT = 725,
     WORK = 726,
     WRAPPER = 727,
     WRITE = 728,
     XML_P = 729,
     XMLATTRIBUTES = 730,
     XMLCONCAT = 731,
     XMLELEMENT = 732,
     XMLFOREST = 733,
     XMLPARSE = 734,
     XMLPI = 735,
     XMLROOT = 736,
     XMLSERIALIZE = 737,
     YEAR_P = 738,
     YES_P = 739,
     ZONE = 740,
     NULLS_FIRST = 741,
     NULLS_LAST = 742,
     WITH_TIME = 743,
     POSTFIXOP = 744,
     UMINUS = 745
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_COUNT 265
#define SQL_DATETIME_INTERVAL_CODE 266
#define SQL_DATETIME_INTERVAL_PRECISION 267
#define SQL_DESCRIBE 268
#define SQL_DESCRIPTOR 269
#define SQL_DISCONNECT 270
#define SQL_FOUND 271
#define SQL_FREE 272
#define SQL_GET 273
#define SQL_GO 274
#define SQL_GOTO 275
#define SQL_IDENTIFIED 276
#define SQL_INDICATOR 277
#define SQL_KEY_MEMBER 278
#define SQL_LENGTH 279
#define SQL_LONG 280
#define SQL_NULLABLE 281
#define SQL_OCTET_LENGTH 282
#define SQL_OPEN 283
#define SQL_OUTPUT 284
#define SQL_REFERENCE 285
#define SQL_RETURNED_LENGTH 286
#define SQL_RETURNED_OCTET_LENGTH 287
#define SQL_SCALE 288
#define SQL_SECTION 289
#define SQL_SHORT 290
#define SQL_SIGNED 291
#define SQL_SQL 292
#define SQL_SQLERROR 293
#define SQL_SQLPRINT 294
#define SQL_SQLWARNING 295
#define SQL_START 296
#define SQL_STOP 297
#define SQL_STRUCT 298
#define SQL_UNSIGNED 299
#define SQL_VAR 300
#define SQL_WHENEVER 301
#define S_ADD 302
#define S_AND 303
#define S_ANYTHING 304
#define S_AUTO 305
#define S_CONST 306
#define S_DEC 307
#define S_DIV 308
#define S_DOTPOINT 309
#define S_EQUAL 310
#define S_EXTERN 311
#define S_INC 312
#define S_LSHIFT 313
#define S_MEMPOINT 314
#define S_MEMBER 315
#define S_MOD 316
#define S_MUL 317
#define S_NEQUAL 318
#define S_OR 319
#define S_REGISTER 320
#define S_RSHIFT 321
#define S_STATIC 322
#define S_SUB 323
#define S_VOLATILE 324
#define S_TYPEDEF 325
#define CSTRING 326
#define CVARIABLE 327
#define CPP_LINE 328
#define IP 329
#define DOLCONST 330
#define ECONST 331
#define NCONST 332
#define UCONST 333
#define UIDENT 334
#define IDENT 335
#define FCONST 336
#define SCONST 337
#define BCONST 338
#define XCONST 339
#define Op 340
#define ICONST 341
#define PARAM 342
#define TYPECAST 343
#define DOT_DOT 344
#define COLON_EQUALS 345
#define ABORT_P 346
#define ABSOLUTE_P 347
#define ACCESS 348
#define ACTION 349
#define ADD_P 350
#define ADMIN 351
#define AFTER 352
#define AGGREGATE 353
#define ALL 354
#define ALSO 355
#define ALTER 356
#define ALWAYS 357
#define ANALYSE 358
#define ANALYZE 359
#define AND 360
#define ANY 361
#define ARRAY 362
#define AS 363
#define ASC 364
#define ASSERTION 365
#define ASSIGNMENT 366
#define ASYMMETRIC 367
#define AT 368
#define AUTHORIZATION 369
#define BACKWARD 370
#define BEFORE 371
#define BEGIN_P 372
#define BETWEEN 373
#define BIGINT 374
#define BINARY 375
#define BIT 376
#define BOOLEAN_P 377
#define BOTH 378
#define BY 379
#define CACHE 380
#define CALLED 381
#define CASCADE 382
#define CASCADED 383
#define CASE 384
#define CAST 385
#define CATALOG_P 386
#define CHAIN 387
#define CHAR_P 388
#define CHARACTER 389
#define CHARACTERISTICS 390
#define CHECK 391
#define CHECKPOINT 392
#define CLASS 393
#define CLOSE 394
#define CLUSTER 395
#define COALESCE 396
#define COLLATE 397
#define COLUMN 398
#define COMMENT 399
#define COMMENTS 400
#define COMMIT 401
#define COMMITTED 402
#define CONCURRENTLY 403
#define CONFIGURATION 404
#define CONNECTION 405
#define CONSTRAINT 406
#define CONSTRAINTS 407
#define CONTENT_P 408
#define CONTINUE_P 409
#define CONVERSION_P 410
#define COPY 411
#define COST 412
#define CREATE 413
#define CREATEDB 414
#define CREATEROLE 415
#define CREATEUSER 416
#define CROSS 417
#define CSV 418
#define CURRENT_P 419
#define CURRENT_CATALOG 420
#define CURRENT_DATE 421
#define CURRENT_ROLE 422
#define CURRENT_SCHEMA 423
#define CURRENT_TIME 424
#define CURRENT_TIMESTAMP 425
#define CURRENT_USER 426
#define CURSOR 427
#define CYCLE 428
#define DATA_P 429
#define DATABASE 430
#define DAY_P 431
#define DEALLOCATE 432
#define DEC 433
#define DECIMAL_P 434
#define DECLARE 435
#define DEFAULT 436
#define DEFAULTS 437
#define DEFERRABLE 438
#define DEFERRED 439
#define DEFINER 440
#define DELETE_P 441
#define DELIMITER 442
#define DELIMITERS 443
#define DESC 444
#define DICTIONARY 445
#define DISABLE_P 446
#define DISCARD 447
#define DISTINCT 448
#define DO 449
#define DOCUMENT_P 450
#define DOMAIN_P 451
#define DOUBLE_P 452
#define DROP 453
#define EACH 454
#define ELSE 455
#define ENABLE_P 456
#define ENCODING 457
#define ENCRYPTED 458
#define END_P 459
#define ENUM_P 460
#define ESCAPE 461
#define EXCEPT 462
#define EXCLUDE 463
#define EXCLUDING 464
#define EXCLUSIVE 465
#define EXECUTE 466
#define EXISTS 467
#define EXPLAIN 468
#define EXTERNAL 469
#define EXTRACT 470
#define FALSE_P 471
#define FAMILY 472
#define FETCH 473
#define FIRST_P 474
#define FLOAT_P 475
#define FOLLOWING 476
#define FOR 477
#define FORCE 478
#define FOREIGN 479
#define FORWARD 480
#define FREEZE 481
#define FROM 482
#define FULL 483
#define FUNCTION 484
#define FUNCTIONS 485
#define GLOBAL 486
#define GRANT 487
#define GRANTED 488
#define GREATEST 489
#define GROUP_P 490
#define HANDLER 491
#define HAVING 492
#define HEADER_P 493
#define HOLD 494
#define HOUR_P 495
#define IDENTITY_P 496
#define IF_P 497
#define ILIKE 498
#define IMMEDIATE 499
#define IMMUTABLE 500
#define IMPLICIT_P 501
#define IN_P 502
#define INCLUDING 503
#define INCREMENT 504
#define INDEX 505
#define INDEXES 506
#define INHERIT 507
#define INHERITS 508
#define INITIALLY 509
#define INLINE_P 510
#define INNER_P 511
#define INOUT 512
#define INPUT_P 513
#define INSENSITIVE 514
#define INSERT 515
#define INSTEAD 516
#define INT_P 517
#define INTEGER 518
#define INTERSECT 519
#define INTERVAL 520
#define INTO 521
#define INVOKER 522
#define IS 523
#define ISNULL 524
#define ISOLATION 525
#define JOIN 526
#define KEY 527
#define LANGUAGE 528
#define LARGE_P 529
#define LAST_P 530
#define LC_COLLATE_P 531
#define LC_CTYPE_P 532
#define LEADING 533
#define LEAST 534
#define LEFT 535
#define LEVEL 536
#define LIKE 537
#define LIMIT 538
#define LISTEN 539
#define LOAD 540
#define LOCAL 541
#define LOCALTIME 542
#define LOCALTIMESTAMP 543
#define LOCATION 544
#define LOCK_P 545
#define LOGIN_P 546
#define MAPPING 547
#define MATCH 548
#define MAXVALUE 549
#define MINUTE_P 550
#define MINVALUE 551
#define MODE 552
#define MONTH_P 553
#define MOVE 554
#define NAME_P 555
#define NAMES 556
#define NATIONAL 557
#define NATURAL 558
#define NCHAR 559
#define NEXT 560
#define NO 561
#define NOCREATEDB 562
#define NOCREATEROLE 563
#define NOCREATEUSER 564
#define NOINHERIT 565
#define NOLOGIN_P 566
#define NONE 567
#define NOSUPERUSER 568
#define NOT 569
#define NOTHING 570
#define NOTIFY 571
#define NOTNULL 572
#define NOWAIT 573
#define NULL_P 574
#define NULLIF 575
#define NULLS_P 576
#define NUMERIC 577
#define OBJECT_P 578
#define OF 579
#define OFF 580
#define OFFSET 581
#define OIDS 582
#define ON 583
#define ONLY 584
#define OPERATOR 585
#define OPTION 586
#define OPTIONS 587
#define OR 588
#define ORDER 589
#define OUT_P 590
#define OUTER_P 591
#define OVER 592
#define OVERLAPS 593
#define OVERLAY 594
#define OWNED 595
#define OWNER 596
#define PARSER 597
#define PARTIAL 598
#define PARTITION 599
#define PASSWORD 600
#define PLACING 601
#define PLANS 602
#define POSITION 603
#define PRECEDING 604
#define PRECISION 605
#define PRESERVE 606
#define PREPARE 607
#define PREPARED 608
#define PRIMARY 609
#define PRIOR 610
#define PRIVILEGES 611
#define PROCEDURAL 612
#define PROCEDURE 613
#define QUOTE 614
#define RANGE 615
#define READ 616
#define REAL 617
#define REASSIGN 618
#define RECHECK 619
#define RECURSIVE 620
#define REFERENCES 621
#define REINDEX 622
#define RELATIVE_P 623
#define RELEASE 624
#define RENAME 625
#define REPEATABLE 626
#define REPLACE 627
#define REPLICA 628
#define RESET 629
#define RESTART 630
#define RESTRICT 631
#define RETURNING 632
#define RETURNS 633
#define REVOKE 634
#define RIGHT 635
#define ROLE 636
#define ROLLBACK 637
#define ROW 638
#define ROWS 639
#define RULE 640
#define SAVEPOINT 641
#define SCHEMA 642
#define SCROLL 643
#define SEARCH 644
#define SECOND_P 645
#define SECURITY 646
#define SELECT 647
#define SEQUENCE 648
#define SEQUENCES 649
#define SERIALIZABLE 650
#define SERVER 651
#define SESSION 652
#define SESSION_USER 653
#define SET 654
#define SETOF 655
#define SHARE 656
#define SHOW 657
#define SIMILAR 658
#define SIMPLE 659
#define SMALLINT 660
#define SOME 661
#define STABLE 662
#define STANDALONE_P 663
#define START 664
#define STATEMENT 665
#define STATISTICS 666
#define STDIN 667
#define STDOUT 668
#define STORAGE 669
#define STRICT_P 670
#define STRIP_P 671
#define SUBSTRING 672
#define SUPERUSER_P 673
#define SYMMETRIC 674
#define SYSID 675
#define SYSTEM_P 676
#define TABLE 677
#define TABLES 678
#define TABLESPACE 679
#define TEMP 680
#define TEMPLATE 681
#define TEMPORARY 682
#define TEXT_P 683
#define THEN 684
#define TIME 685
#define TIMESTAMP 686
#define TO 687
#define TRAILING 688
#define TRANSACTION 689
#define TREAT 690
#define TRIGGER 691
#define TRIM 692
#define TRUE_P 693
#define TRUNCATE 694
#define TRUSTED 695
#define TYPE_P 696
#define UNBOUNDED 697
#define UNCOMMITTED 698
#define UNENCRYPTED 699
#define UNION 700
#define UNIQUE 701
#define UNKNOWN 702
#define UNLISTEN 703
#define UNTIL 704
#define UPDATE 705
#define USER 706
#define USING 707
#define VACUUM 708
#define VALID 709
#define VALIDATOR 710
#define VALUE_P 711
#define VALUES 712
#define VARCHAR 713
#define VARIADIC 714
#define VARYING 715
#define VERBOSE 716
#define VERSION_P 717
#define VIEW 718
#define VOLATILE 719
#define WHEN 720
#define WHERE 721
#define WHITESPACE_P 722
#define WINDOW 723
#define WITH 724
#define WITHOUT 725
#define WORK 726
#define WRAPPER 727
#define WRITE 728
#define XML_P 729
#define XMLATTRIBUTES 730
#define XMLCONCAT 731
#define XMLELEMENT 732
#define XMLFOREST 733
#define XMLPARSE 734
#define XMLPI 735
#define XMLROOT 736
#define XMLSERIALIZE 737
#define YEAR_P 738
#define YES_P 739
#define ZONE 740
#define NULLS_FIRST 741
#define NULLS_LAST 742
#define WITH_TIME 743
#define POSTFIXOP 744
#define UMINUS 745




/* Copy the first part of user declarations.  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int 	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			
			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in other functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn's cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = make_str("");
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char temp[20];
			char *original_var;
			bool skip_set_var = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(temp, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable) && (!strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement"))))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char && ptr->variable->type->type != ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
				sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char || ptr->variable->type->type == ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				if (ptr->variable->type->type == ECPGt_varchar)
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				else
					sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_struct || ptr->variable->type->type == ECPGt_union)
			{
				sprintf(temp, "%d)))", ecpg_internal_var);
				newvar = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->variable->type->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.members, ptr->variable->type->type, ptr->variable->type->type_name, ptr->variable->type->struct_sizeof), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct || ptr->variable->type->u.element->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newvar = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->variable->type->u.element->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.element->u.members, ptr->variable->type->u.element->type, ptr->variable->type->u.element->type_name, ptr->variable->type->u.element->struct_sizeof), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, ptr->variable->type->u.element->size, ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}

			/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
			if (!skip_set_var)
				result = cat_str(5, result, make_str("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(temp, "%d))", ecpg_internal_var);

				if (ptr->indicator->type->type == ECPGt_struct || ptr->indicator->type->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newind = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->indicator->type->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.members, ptr->indicator->type->type, ptr->indicator->type->type_name, ptr->indicator->type->struct_sizeof), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct || ptr->indicator->type->u.element->type == ECPGt_union)
					{
						sprintf(temp, "%d)))", ecpg_internal_var);
						newind = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->indicator->type->u.element->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.element->u.members, ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->type_name, ptr->indicator->type->u.element->struct_sizeof), 0);
						sprintf(temp, "%d, (", ecpg_internal_var++);
					}
					else
					{
						newind = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->size, ptr->indicator->type->u.element->counter), ptr->indicator->type->size), 0);
						sprintf(temp, "%d, &(", ecpg_internal_var++);
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newind = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				result = cat_str(5, result, make_str("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && !strcmp(cur->function, current_function)))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 471 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1541 "preproc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1565 "preproc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   93686

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  510
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  657
/* YYNRULES -- Number of rules. */
#define YYNRULES  2561
/* YYNRULES -- Number of states. */
#define YYNSTATES  4489

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   745

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   497,     2,     2,
     502,   503,   495,   493,   505,   494,   504,   496,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   507,   506,
     490,   489,   491,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   500,     2,   501,   498,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   508,     2,   509,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   492,   499
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   245,   247,   248,   254,   256,   257,   260,
     261,   264,   265,   268,   271,   275,   279,   281,   283,   285,
     287,   289,   291,   293,   295,   297,   299,   301,   303,   307,
     311,   314,   316,   319,   322,   325,   329,   333,   339,   345,
     346,   350,   356,   362,   367,   371,   377,   381,   387,   393,
     400,   402,   404,   408,   414,   421,   426,   428,   429,   432,
     433,   435,   437,   439,   441,   443,   445,   448,   452,   456,
     460,   464,   468,   472,   476,   480,   483,   489,   492,   495,
     498,   501,   505,   509,   513,   515,   519,   521,   525,   527,
     529,   532,   535,   538,   540,   542,   544,   546,   548,   550,
     552,   556,   563,   565,   567,   569,   571,   573,   574,   576,
     578,   581,   585,   590,   594,   597,   600,   602,   606,   611,
     617,   622,   625,   630,   632,   634,   636,   638,   640,   643,
     646,   649,   652,   657,   662,   667,   672,   674,   678,   681,
     685,   690,   697,   704,   711,   717,   723,   730,   737,   742,
     750,   753,   760,   765,   769,   773,   777,   781,   785,   790,
     795,   799,   803,   807,   811,   815,   819,   824,   829,   833,
     836,   840,   844,   848,   851,   854,   858,   861,   863,   865,
     866,   869,   870,   874,   877,   878,   880,   884,   888,   890,
     896,   900,   903,   906,   917,   924,   926,   928,   930,   932,
     934,   936,   940,   943,   944,   946,   948,   952,   956,   958,
     960,   964,   968,   972,   976,   981,   983,   984,   987,   988,
     992,   993,   995,   996,   998,  1002,  1005,  1007,  1009,  1011,
    1015,  1016,  1018,  1022,  1024,  1036,  1047,  1049,  1051,  1054,
    1057,  1060,  1063,  1064,  1066,  1067,  1071,  1072,  1074,  1078,
    1080,  1084,  1086,  1088,  1090,  1092,  1094,  1098,  1103,  1106,
    1107,  1111,  1113,  1115,  1118,  1120,  1124,  1129,  1134,  1137,
    1143,  1145,  1148,  1151,  1154,  1158,  1162,  1166,  1167,  1169,
    1171,  1173,  1175,  1177,  1179,  1183,  1185,  1191,  1199,  1208,
    1218,  1230,  1234,  1235,  1237,  1241,  1243,  1246,  1249,  1252,
    1253,  1255,  1259,  1263,  1270,  1275,  1276,  1278,  1280,  1283,
    1286,  1287,  1291,  1295,  1298,  1300,  1302,  1305,  1308,  1313,
    1314,  1317,  1320,  1323,  1324,  1328,  1333,  1338,  1339,  1342,
    1343,  1348,  1349,  1355,  1359,  1360,  1362,  1366,  1368,  1371,
    1375,  1376,  1382,  1387,  1389,  1390,  1392,  1395,  1398,  1400,
    1403,  1407,  1410,  1413,  1416,  1419,  1423,  1427,  1429,  1433,
    1435,  1436,  1438,  1441,  1443,  1445,  1449,  1456,  1467,  1469,
    1470,  1472,  1475,  1478,  1479,  1482,  1485,  1487,  1488,  1494,
    1502,  1504,  1505,  1512,  1515,  1516,  1520,  1526,  1534,  1541,
    1550,  1558,  1565,  1572,  1577,  1578,  1580,  1584,  1589,  1591,
    1595,  1597,  1600,  1603,  1606,  1609,  1611,  1613,  1624,  1627,
    1628,  1631,  1634,  1636,  1637,  1642,  1649,  1655,  1660,  1665,
    1674,  1676,  1678,  1680,  1688,  1698,  1707,  1723,  1744,  1746,
    1748,  1750,  1754,  1756,  1758,  1760,  1764,  1766,  1770,  1771,
    1773,  1774,  1776,  1778,  1783,  1784,  1786,  1790,  1791,  1793,
    1795,  1797,  1799,  1801,  1803,  1806,  1807,  1809,  1812,  1814,
    1817,  1818,  1821,  1823,  1826,  1829,  1836,  1845,  1854,  1859,
    1865,  1870,  1875,  1880,  1884,  1892,  1901,  1908,  1915,  1922,
    1929,  1933,  1935,  1939,  1943,  1945,  1947,  1949,  1951,  1953,
    1955,  1959,  1963,  1967,  1969,  1973,  1977,  1979,  1980,  1982,
    1986,  2000,  2002,  2006,  2011,  2017,  2022,  2030,  2033,  2035,
    2036,  2039,  2040,  2042,  2043,  2050,  2059,  2068,  2070,  2074,
    2080,  2086,  2094,  2104,  2112,  2122,  2128,  2135,  2142,  2147,
    2149,  2151,  2153,  2155,  2157,  2159,  2161,  2163,  2167,  2171,
    2175,  2179,  2181,  2185,  2187,  2190,  2193,  2197,  2203,  2206,
    2209,  2210,  2217,  2225,  2233,  2241,  2250,  2259,  2266,  2275,
    2285,  2295,  2303,  2314,  2322,  2331,  2340,  2349,  2358,  2360,
    2362,  2364,  2366,  2368,  2370,  2372,  2374,  2376,  2378,  2380,
    2382,  2384,  2386,  2389,  2392,  2396,  2401,  2407,  2412,  2418,
    2422,  2427,  2431,  2436,  2438,  2441,  2445,  2449,  2453,  2457,
    2462,  2467,  2471,  2475,  2480,  2485,  2490,  2495,  2497,  2499,
    2501,  2502,  2510,  2518,  2529,  2531,  2533,  2536,  2541,  2547,
    2549,  2553,  2556,  2559,  2562,  2565,  2567,  2570,  2573,  2578,
    2582,  2585,  2588,  2591,  2595,  2598,  2601,  2607,  2613,  2619,
    2621,  2625,  2627,  2630,  2634,  2635,  2637,  2641,  2644,  2651,
    2658,  2668,  2672,  2673,  2677,  2678,  2684,  2687,  2688,  2692,
    2696,  2700,  2708,  2716,  2727,  2729,  2731,  2733,  2748,  2750,
    2751,  2753,  2754,  2756,  2757,  2760,  2761,  2763,  2767,  2772,
    2777,  2784,  2786,  2789,  2790,  2792,  2794,  2795,  2797,  2799,
    2800,  2810,  2823,  2831,  2834,  2835,  2839,  2842,  2844,  2848,
    2852,  2855,  2857,  2861,  2865,  2869,  2872,  2875,  2877,  2879,
    2881,  2883,  2886,  2888,  2890,  2892,  2894,  2899,  2905,  2907,
    2911,  2915,  2917,  2920,  2925,  2931,  2933,  2935,  2937,  2939,
    2943,  2947,  2950,  2953,  2956,  2959,  2961,  2964,  2967,  2969,
    2971,  2973,  2977,  2980,  2981,  2984,  2986,  2990,  2996,  2998,
    3001,  3003,  3004,  3010,  3018,  3024,  3032,  3038,  3046,  3050,
    3056,  3062,  3068,  3070,  3074,  3077,  3079,  3082,  3084,  3087,
    3099,  3110,  3121,  3124,  3127,  3128,  3138,  3141,  3142,  3147,
    3152,  3157,  3159,  3161,  3163,  3164,  3172,  3179,  3186,  3193,
    3200,  3208,  3218,  3228,  3235,  3242,  3249,  3256,  3263,  3272,
    3281,  3288,  3295,  3302,  3308,  3314,  3323,  3332,  3341,  3350,
    3357,  3359,  3360,  3363,  3364,  3372,  3379,  3386,  3393,  3400,
    3407,  3414,  3422,  3429,  3436,  3443,  3450,  3458,  3466,  3474,
    3484,  3494,  3501,  3508,  3515,  3524,  3533,  3542,  3549,  3563,
    3565,  3567,  3571,  3575,  3577,  3579,  3581,  3583,  3585,  3587,
    3589,  3590,  3592,  3594,  3596,  3598,  3600,  3602,  3603,  3610,
    3619,  3623,  3626,  3627,  3630,  3633,  3636,  3639,  3643,  3647,
    3650,  3653,  3656,  3659,  3663,  3666,  3672,  3677,  3681,  3685,
    3689,  3691,  3693,  3694,  3698,  3701,  3704,  3706,  3710,  3713,
    3715,  3716,  3725,  3736,  3740,  3745,  3750,  3751,  3754,  3760,
    3763,  3764,  3768,  3772,  3776,  3780,  3784,  3788,  3792,  3796,
    3800,  3804,  3808,  3812,  3816,  3821,  3825,  3829,  3831,  3832,
    3838,  3845,  3850,  3853,  3854,  3859,  3863,  3869,  3876,  3881,
    3888,  3895,  3901,  3909,  3911,  3912,  3919,  3931,  3943,  3955,
    3969,  3979,  3991,  4002,  4007,  4010,  4016,  4019,  4020,  4025,
    4031,  4037,  4042,  4049,  4051,  4055,  4057,  4059,  4061,  4063,
    4066,  4071,  4073,  4075,  4077,  4078,  4080,  4081,  4083,  4084,
    4088,  4089,  4092,  4097,  4101,  4107,  4109,  4111,  4113,  4115,
    4117,  4119,  4121,  4123,  4127,  4130,  4132,  4134,  4136,  4138,
    4140,  4141,  4147,  4152,  4156,  4157,  4159,  4161,  4163,  4165,
    4170,  4179,  4183,  4184,  4190,  4192,  4197,  4200,  4202,  4206,
    4209,  4213,  4214,  4221,  4224,  4225,  4231,  4235,  4236,  4239,
    4242,  4245,  4249,  4251,  4255,  4257,  4260,  4262,  4263,  4271,
    4273,  4277,  4279,  4281,  4285,  4291,  4294,  4296,  4300,  4308,
    4310,  4312,  4313,  4317,  4320,  4323,  4326,  4327,  4330,  4333,
    4335,  4337,  4341,  4345,  4347,  4350,  4355,  4360,  4363,  4367,
    4373,  4379,  4381,  4383,  4393,  4395,  4398,  4403,  4408,  4413,
    4416,  4420,  4422,  4426,  4431,  4434,  4436,  4437,  4441,  4445,
    4450,  4455,  4460,  4465,  4468,  4470,  4472,  4473,  4475,  4477,
    4478,  4480,  4486,  4488,  4489,  4491,  4492,  4496,  4498,  4502,
    4507,  4511,  4514,  4517,  4519,  4521,  4523,  4524,  4527,  4532,
    4538,  4541,  4545,  4547,  4549,  4551,  4553,  4557,  4558,  4560,
    4562,  4564,  4566,  4568,  4572,  4573,  4576,  4577,  4579,  4583,
    4585,  4586,  4588,  4591,  4596,  4601,  4604,  4605,  4608,  4612,
    4615,  4616,  4618,  4622,  4624,  4627,  4629,  4632,  4638,  4645,
    4651,  4653,  4656,  4658,  4663,  4667,  4672,  4678,  4683,  4689,
    4694,  4700,  4703,  4708,  4710,  4713,  4716,  4719,  4721,  4723,
    4724,  4729,  4732,  4734,  4737,  4740,  4745,  4747,  4751,  4753,
    4756,  4760,  4762,  4765,  4766,  4769,  4774,  4775,  4777,  4781,
    4784,  4787,  4791,  4797,  4804,  4807,  4811,  4815,  4820,  4821,
    4823,  4825,  4827,  4829,  4831,  4834,  4840,  4842,  4844,  4846,
    4848,  4851,  4855,  4859,  4860,  4862,  4864,  4866,  4868,  4870,
    4873,  4876,  4879,  4882,  4885,  4887,  4891,  4892,  4894,  4896,
    4898,  4900,  4906,  4909,  4911,  4913,  4915,  4917,  4923,  4926,
    4929,  4932,  4934,  4938,  4942,  4945,  4947,  4948,  4952,  4953,
    4959,  4962,  4968,  4971,  4973,  4976,  4980,  4981,  4983,  4985,
    4987,  4989,  4991,  4993,  4997,  5001,  5005,  5009,  5013,  5017,
    5021,  5022,  5024,  5029,  5031,  5035,  5041,  5044,  5047,  5051,
    5055,  5059,  5063,  5067,  5071,  5075,  5079,  5083,  5087,  5090,
    5093,  5097,  5101,  5104,  5108,  5114,  5119,  5126,  5130,  5136,
    5141,  5148,  5153,  5160,  5166,  5174,  5178,  5181,  5186,  5189,
    5193,  5197,  5202,  5206,  5211,  5215,  5220,  5226,  5233,  5240,
    5248,  5255,  5263,  5270,  5278,  5282,  5287,  5292,  5299,  5302,
    5306,  5311,  5313,  5317,  5320,  5323,  5327,  5331,  5335,  5339,
    5343,  5347,  5351,  5355,  5359,  5363,  5366,  5369,  5375,  5382,
    5389,  5397,  5401,  5406,  5408,  5410,  5413,  5418,  5420,  5422,
    5424,  5427,  5430,  5433,  5435,  5440,  5446,  5453,  5462,  5469,
    5477,  5485,  5491,  5493,  5495,  5500,  5502,  5507,  5509,  5514,
    5516,  5521,  5523,  5525,  5527,  5529,  5531,  5533,  5540,  5545,
    5550,  5555,  5560,  5567,  5573,  5579,  5585,  5590,  5597,  5602,
    5607,  5612,  5617,  5623,  5631,  5639,  5649,  5654,  5661,  5667,
    5675,  5683,  5691,  5694,  5698,  5702,  5706,  5711,  5712,  5717,
    5719,  5723,  5727,  5729,  5731,  5733,  5736,  5739,  5740,  5743,
    5744,  5746,  5750,  5754,  5757,  5760,  5761,  5768,  5770,  5771,
    5775,  5776,  5779,  5782,  5783,  5785,  5790,  5793,  5796,  5799,
    5802,  5805,  5810,  5814,  5820,  5822,  5824,  5826,  5828,  5830,
    5832,  5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,
    5855,  5857,  5862,  5864,  5869,  5871,  5874,  5876,  5879,  5881,
    5885,  5887,  5891,  5893,  5897,  5899,  5903,  5907,  5911,  5914,
    5916,  5920,  5924,  5925,  5927,  5929,  5931,  5933,  5935,  5937,
    5939,  5941,  5946,  5950,  5953,  5957,  5958,  5962,  5966,  5969,
    5972,  5974,  5975,  5978,  5981,  5985,  5988,  5990,  5992,  5996,
    6002,  6004,  6007,  6012,  6015,  6016,  6018,  6019,  6021,  6024,
    6027,  6030,  6034,  6040,  6042,  6045,  6046,  6049,  6051,  6052,
    6054,  6056,  6058,  6062,  6066,  6068,  6072,  6076,  6079,  6081,
    6083,  6085,  6089,  6091,  6094,  6096,  6100,  6102,  6104,  6106,
    6108,  6110,  6112,  6114,  6117,  6119,  6121,  6123,  6125,  6127,
    6130,  6136,  6139,  6143,  6150,  6152,  6154,  6156,  6158,  6160,
    6162,  6164,  6166,  6168,  6171,  6174,  6176,  6178,  6180,  6182,
    6184,  6186,  6188,  6190,  6192,  6194,  6196,  6198,  6200,  6202,
    6204,  6206,  6208,  6210,  6212,  6214,  6216,  6218,  6220,  6222,
    6224,  6226,  6228,  6230,  6232,  6234,  6236,  6238,  6240,  6242,
    6244,  6246,  6248,  6250,  6252,  6254,  6256,  6258,  6260,  6262,
    6264,  6266,  6268,  6270,  6272,  6274,  6276,  6278,  6280,  6282,
    6284,  6286,  6288,  6290,  6292,  6294,  6296,  6298,  6300,  6302,
    6304,  6306,  6308,  6310,  6312,  6314,  6316,  6318,  6320,  6322,
    6324,  6326,  6328,  6330,  6332,  6334,  6336,  6338,  6340,  6342,
    6344,  6346,  6348,  6350,  6352,  6354,  6356,  6358,  6360,  6362,
    6364,  6366,  6368,  6370,  6372,  6374,  6376,  6378,  6380,  6382,
    6384,  6386,  6388,  6390,  6392,  6394,  6396,  6398,  6400,  6402,
    6404,  6406,  6408,  6410,  6412,  6414,  6416,  6418,  6420,  6422,
    6424,  6426,  6428,  6430,  6432,  6434,  6436,  6438,  6440,  6442,
    6444,  6446,  6448,  6450,  6452,  6454,  6456,  6458,  6460,  6462,
    6464,  6466,  6468,  6470,  6472,  6474,  6476,  6478,  6480,  6482,
    6484,  6486,  6488,  6490,  6492,  6494,  6496,  6498,  6500,  6502,
    6504,  6506,  6508,  6510,  6512,  6514,  6516,  6518,  6520,  6522,
    6524,  6526,  6528,  6530,  6532,  6534,  6536,  6538,  6540,  6542,
    6544,  6546,  6548,  6550,  6552,  6554,  6556,  6558,  6560,  6562,
    6564,  6566,  6568,  6570,  6572,  6574,  6576,  6578,  6580,  6582,
    6584,  6586,  6588,  6590,  6592,  6594,  6596,  6598,  6600,  6602,
    6604,  6606,  6608,  6610,  6612,  6614,  6616,  6618,  6620,  6622,
    6624,  6626,  6628,  6630,  6632,  6634,  6636,  6638,  6640,  6642,
    6644,  6646,  6648,  6650,  6652,  6654,  6656,  6658,  6660,  6662,
    6664,  6666,  6668,  6670,  6672,  6674,  6676,  6678,  6680,  6682,
    6684,  6686,  6688,  6690,  6692,  6694,  6696,  6698,  6700,  6702,
    6704,  6706,  6708,  6710,  6712,  6714,  6716,  6718,  6720,  6722,
    6724,  6726,  6728,  6730,  6732,  6734,  6736,  6738,  6740,  6742,
    6744,  6746,  6748,  6750,  6752,  6754,  6756,  6758,  6760,  6762,
    6764,  6766,  6768,  6770,  6772,  6774,  6776,  6778,  6780,  6782,
    6784,  6786,  6788,  6790,  6792,  6794,  6796,  6798,  6800,  6802,
    6804,  6806,  6808,  6810,  6812,  6814,  6816,  6818,  6820,  6822,
    6824,  6826,  6828,  6830,  6832,  6834,  6836,  6838,  6840,  6842,
    6844,  6846,  6848,  6850,  6852,  6854,  6856,  6858,  6860,  6862,
    6864,  6866,  6868,  6870,  6872,  6874,  6876,  6878,  6880,  6882,
    6884,  6886,  6888,  6890,  6892,  6894,  6896,  6898,  6900,  6902,
    6904,  6906,  6908,  6910,  6912,  6914,  6916,  6918,  6920,  6922,
    6924,  6926,  6928,  6930,  6932,  6934,  6936,  6937,  6940,  6945,
    6949,  6952,  6954,  6956,  6958,  6960,  6962,  6963,  6972,  6975,
    6981,  6985,  6988,  6991,  6995,  7003,  7005,  7007,  7009,  7010,
    7013,  7016,  7018,  7019,  7021,  7025,  7027,  7030,  7031,  7034,
    7035,  7038,  7039,  7041,  7045,  7050,  7054,  7056,  7058,  7060,
    7062,  7065,  7066,  7069,  7074,  7075,  7078,  7081,  7084,  7086,
    7088,  7096,  7100,  7102,  7104,  7106,  7108,  7111,  7112,  7114,
    7118,  7122,  7126,  7130,  7131,  7136,  7142,  7148,  7149,  7151,
    7153,  7155,  7158,  7161,  7163,  7166,  7167,  7175,  7176,  7182,
    7183,  7188,  7191,  7194,  7195,  7198,  7200,  7202,  7204,  7206,
    7208,  7210,  7212,  7214,  7216,  7218,  7220,  7226,  7229,  7231,
    7235,  7238,  7241,  7245,  7246,  7252,  7254,  7255,  7261,  7264,
    7267,  7269,  7271,  7273,  7276,  7279,  7283,  7285,  7288,  7291,
    7295,  7299,  7304,  7307,  7309,  7312,  7314,  7316,  7319,  7322,
    7326,  7328,  7330,  7332,  7334,  7335,  7337,  7341,  7347,  7348,
    7351,  7352,  7354,  7357,  7361,  7364,  7366,  7368,  7370,  7371,
    7373,  7375,  7377,  7379,  7381,  7384,  7387,  7391,  7392,  7394,
    7397,  7399,  7404,  7408,  7413,  7417,  7420,  7422,  7426,  7428,
    7430,  7432,  7434,  7437,  7440,  7442,  7445,  7448,  7450,  7452,
    7454,  7459,  7464,  7469,  7474,  7479,  7481,  7482,  7486,  7490,
    7495,  7497,  7501,  7505,  7510,  7512,  7516,  7520,  7522,  7524,
    7526,  7533,  7535,  7539,  7543,  7550,  7552,  7556,  7560,  7562,
    7564,  7567,  7570,  7572,  7574,  7576,  7578,  7580,  7582,  7584,
    7586,  7588,  7590,  7592,  7594,  7596,  7598,  7600,  7602,  7607,
    7612,  7614,  7616,  7621,  7626,  7630,  7631,  7639,  7641,  7642,
    7643,  7651,  7655,  7660,  7664,  7666,  7668,  7670,  7673,  7677,
    7683,  7686,  7692,  7695,  7697,  7699,  7701,  7703,  7705,  7707,
    7709,  7711,  7713,  7715,  7717,  7719,  7721,  7723,  7725,  7727,
    7729,  7731,  7733,  7735,  7737,  7739,  7741,  7743,  7745,  7747,
    7749,  7751,  7753,  7755,  7757,  7759,  7761,  7763,  7765,  7767,
    7769,  7771,  7773,  7775,  7777,  7779,  7781,  7783,  7785,  7787,
    7789,  7791,  7793,  7795,  7797,  7799,  7801,  7803,  7805,  7807,
    7809,  7811,  7813,  7815,  7817,  7819,  7821,  7823,  7825,  7827,
    7829,  7831,  7833,  7835,  7837,  7839,  7841,  7843,  7845,  7847,
    7849,  7851,  7853,  7855,  7857,  7859,  7861,  7863,  7865,  7867,
    7869,  7871,  7873,  7875,  7877,  7879,  7881,  7883,  7885,  7887,
    7889,  7891,  7895,  7897,  7898,  7900,  7903,  7905,  7908,  7910,
    7912,  7914,  7917,  7920,  7922,  7924,  7926,  7928,  7930,  7932,
    7934,  7936,  7938,  7940,  7942,  7944,  7946,  7948,  7950,  7952,
    7955,  7959,  7961,  7964,  7966,  7970,  7972,  7976,  7978,  7980,
    7982,  7984,  7986,  7988,  7990,  7992,  7994,  7996,  7998,  8000,
    8002,  8004,  8006,  8008,  8010,  8012,  8014,  8016,  8018,  8020,
    8022,  8024,  8026,  8028,  8030,  8032,  8034,  8036,  8038,  8040,
    8042,  8044,  8046,  8048,  8050,  8052,  8054,  8056,  8058,  8060,
    8062,  8064,  8066,  8068,  8070,  8072,  8074,  8076,  8078,  8080,
    8082,  8084,  8086,  8088,  8090,  8092,  8094,  8096,  8098,  8101,
    8105,  8108,  8112,  8114,  8118,  8122,  8126,  8130,  8134,  8138,
    8140,  8142,  8143,  8146,  8149,  8151,  8153,  8156,  8158,  8160,
    8162,  8163
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     511,     0,    -1,  1018,    -1,   811,    -1,   812,    -1,   730,
      -1,   817,    -1,   640,    -1,   654,    -1,   764,    -1,   528,
      -1,   785,    -1,   786,    -1,   620,    -1,   553,    -1,   522,
      -1,   520,    -1,   820,    -1,   819,    -1,   658,    -1,   524,
      -1,   523,    -1,   827,    -1,   551,    -1,   563,    -1,   822,
      -1,   708,    -1,   548,    -1,   564,    -1,  1020,    -1,   674,
      -1,   775,    -1,   821,    -1,   816,    -1,   638,    -1,   649,
      -1,   745,    -1,   527,    -1,   687,    -1,   693,    -1,   694,
      -1,   627,    -1,   531,    -1,   619,    -1,   579,    -1,   635,
      -1,   659,    -1,   513,    -1,   519,    -1,   655,    -1,   807,
      -1,  1161,    -1,   862,    -1,   676,    -1,   849,    -1,   552,
      -1,   772,    -1,   675,    -1,   777,    -1,   639,    -1,   653,
      -1,   530,    -1,   697,    -1,   698,    -1,   699,    -1,   633,
      -1,   794,    -1,   701,    -1,   637,    -1,   673,    -1,   525,
      -1,   526,    -1,   657,    -1,   815,    -1,   842,    -1,   833,
      -1,   711,    -1,   715,    -1,   726,    -1,   735,    -1,   844,
      -1,   797,    -1,   806,    -1,   851,    -1,   795,    -1,   839,
      -1,   700,    -1,   779,    -1,   768,    -1,   767,    -1,   769,
      -1,   782,    -1,   716,    -1,   727,    -1,   787,    -1,   866,
      -1,   799,    -1,   706,    -1,   798,    -1,   855,    -1,   824,
      -1,   545,    -1,   535,    -1,   547,    -1,   804,    -1,  1097,
      -1,  1023,    -1,  1040,    -1,  1098,    -1,  1080,    -1,  1095,
      -1,  1081,    -1,  1041,    -1,  1085,    -1,  1107,    -1,  1099,
      -1,  1086,    -1,  1115,    -1,  1117,    -1,  1110,    -1,  1102,
      -1,  1118,    -1,  1121,    -1,  1123,    -1,    -1,   158,   381,
    1012,   514,   515,    -1,   469,    -1,    -1,   515,   518,    -1,
      -1,   516,   517,    -1,    -1,   345,  1151,    -1,   345,   319,
      -1,   203,   345,  1151,    -1,   444,   345,  1151,    -1,   418,
      -1,   313,    -1,   252,    -1,   310,    -1,   159,    -1,   307,
      -1,   160,    -1,   308,    -1,   161,    -1,   309,    -1,   291,
      -1,   311,    -1,   150,   283,  1013,    -1,   454,   449,  1151,
      -1,   451,  1002,    -1,   517,    -1,   420,  1011,    -1,    96,
    1002,    -1,   381,  1002,    -1,   247,   381,  1002,    -1,   247,
     235,  1002,    -1,   158,   451,  1012,   514,   515,    -1,   101,
     381,  1012,   514,   516,    -1,    -1,   247,   175,  1004,    -1,
     101,   381,  1012,   521,   546,    -1,   101,   451,  1012,   514,
     516,    -1,   101,   451,  1012,   546,    -1,   198,   381,  1002,
      -1,   198,   381,   242,   212,  1002,    -1,   198,   451,  1002,
      -1,   198,   451,   242,   212,  1002,    -1,   158,   235,  1012,
     514,   515,    -1,   101,   235,  1012,   529,   451,  1002,    -1,
      95,    -1,   198,    -1,   198,   235,  1002,    -1,   198,   235,
     242,   212,  1002,    -1,   158,   387,   532,   114,  1012,   533,
      -1,   158,   387,  1131,   533,    -1,  1131,    -1,    -1,   533,
     534,    -1,    -1,   579,    -1,   735,    -1,   619,    -1,   659,
      -1,   715,    -1,   804,    -1,   399,   536,    -1,   399,   286,
     536,    -1,   399,   397,   536,    -1,   537,   432,   538,    -1,
     537,   489,   538,    -1,   537,   432,   181,    -1,   537,   489,
     181,    -1,   537,   227,   164,    -1,   430,   485,   542,    -1,
     434,   802,    -1,   397,   135,   108,   434,   802,    -1,   131,
    1151,    -1,   387,  1151,    -1,   301,   543,    -1,   381,   544,
      -1,   397,   114,   544,    -1,   397,   114,   181,    -1,   474,
     331,   950,    -1,  1130,    -1,   537,   504,  1131,    -1,   539,
      -1,   538,   505,   539,    -1,   541,    -1,   625,    -1,   361,
     443,    -1,   361,   147,    -1,   371,   361,    -1,   395,    -1,
     438,    -1,   216,    -1,   328,    -1,   544,    -1,  1151,    -1,
    1153,    -1,   937,  1151,   939,    -1,   937,   502,  1011,   503,
    1151,   939,    -1,   625,    -1,   181,    -1,   286,    -1,  1151,
      -1,   181,    -1,    -1,  1131,    -1,  1151,    -1,   374,   537,
      -1,   374,   430,   485,    -1,   374,   434,   270,   281,    -1,
     374,   397,   114,    -1,   374,    99,    -1,   399,   536,    -1,
     545,    -1,   402,   537,  1164,    -1,   402,   430,   485,  1164,
      -1,   402,   434,   270,   281,  1164,    -1,   402,   397,   114,
    1164,    -1,   402,    99,    -1,   399,   152,   549,   550,    -1,
      99,    -1,  1000,    -1,   184,    -1,   244,    -1,   137,    -1,
     192,    99,    -1,   192,   425,    -1,   192,   427,    -1,   192,
     347,    -1,   101,   422,   909,   554,    -1,   101,   250,  1001,
     554,    -1,   101,   393,  1001,   554,    -1,   101,   463,  1001,
     554,    -1,   555,    -1,   554,   505,   555,    -1,    95,   587,
      -1,    95,   143,   587,    -1,   101,   783,  1131,   556,    -1,
     101,   783,  1131,   198,   314,   319,    -1,   101,   783,  1131,
     399,   314,   319,    -1,   101,   783,  1131,   399,   411,  1013,
      -1,   101,   783,  1131,   399,   559,    -1,   101,   783,  1131,
     374,   559,    -1,   101,   783,  1131,   399,   414,  1131,    -1,
     198,   783,   242,   212,  1131,   557,    -1,   198,   783,  1131,
     557,    -1,   101,   783,  1131,   784,   441,   917,   558,    -1,
      95,   596,    -1,   198,   151,   242,   212,  1003,   557,    -1,
     198,   151,  1003,   557,    -1,   399,   469,   327,    -1,   399,
     470,   327,    -1,   140,   328,  1003,    -1,   399,   470,   140,
      -1,   201,   436,  1003,    -1,   201,   102,   436,  1003,    -1,
     201,   373,   436,  1003,    -1,   201,   436,    99,    -1,   201,
     436,   451,    -1,   191,   436,  1003,    -1,   191,   436,    99,
      -1,   191,   436,   451,    -1,   201,   385,  1003,    -1,   201,
     102,   385,  1003,    -1,   201,   373,   385,  1003,    -1,   191,
     385,  1003,    -1,   252,  1001,    -1,   306,   252,  1001,    -1,
     341,   432,  1012,    -1,   399,   424,  1003,    -1,   399,   559,
      -1,   374,   559,    -1,   399,   181,   941,    -1,   198,   181,
      -1,   127,    -1,   376,    -1,    -1,   452,   941,    -1,    -1,
     502,   561,   503,    -1,   469,   559,    -1,    -1,   562,    -1,
     561,   505,   562,    -1,  1133,   489,   680,    -1,  1133,    -1,
    1133,   504,  1133,   489,   680,    -1,  1133,   504,  1133,    -1,
     139,   863,    -1,   139,    99,    -1,   156,   570,  1001,   598,
     571,   565,   566,   572,   514,   567,    -1,   156,   867,   432,
     566,   514,   567,    -1,   227,    -1,   432,    -1,  1151,    -1,
     412,    -1,   413,    -1,   568,    -1,   502,   574,   503,    -1,
     568,   569,    -1,    -1,   120,    -1,   327,    -1,   187,   818,
    1151,    -1,   319,   818,  1151,    -1,   163,    -1,   238,    -1,
     359,   818,  1151,    -1,   206,   818,  1151,    -1,   223,   359,
     599,    -1,   223,   359,   495,    -1,   223,   314,   319,   599,
      -1,   120,    -1,    -1,   469,   327,    -1,    -1,   573,   188,
    1151,    -1,    -1,   452,    -1,    -1,   575,    -1,   574,   505,
     575,    -1,  1133,   576,    -1,   541,    -1,   625,    -1,   495,
      -1,   502,   577,   503,    -1,    -1,   578,    -1,   577,   505,
     578,    -1,   541,    -1,   158,   580,   422,  1001,   502,   581,
     503,   609,   610,   611,   612,    -1,   158,   580,   422,  1001,
     324,   704,   582,   610,   611,   612,    -1,   427,    -1,   425,
      -1,   286,   427,    -1,   286,   425,    -1,   231,   427,    -1,
     231,   425,    -1,    -1,   583,    -1,    -1,   502,   584,   503,
      -1,    -1,   585,    -1,   583,   505,   585,    -1,   586,    -1,
     584,   505,   586,    -1,   587,    -1,   593,    -1,   596,    -1,
     588,    -1,   596,    -1,  1131,   917,   589,    -1,  1131,   469,
     332,   589,    -1,   589,   590,    -1,    -1,   151,  1003,   591,
      -1,   591,    -1,   592,    -1,   314,   319,    -1,   319,    -1,
     446,   761,   613,    -1,   354,   272,   761,   613,    -1,   136,
     502,   941,   503,    -1,   181,   942,    -1,   366,  1001,   598,
     601,   605,    -1,   183,    -1,   314,   183,    -1,   254,   184,
      -1,   254,   244,    -1,   282,  1001,   594,    -1,   594,   248,
     595,    -1,   594,   209,   595,    -1,    -1,   182,    -1,   152,
      -1,   251,    -1,   414,    -1,   145,    -1,    99,    -1,   151,
    1003,   597,    -1,   597,    -1,   136,   502,   941,   503,   670,
      -1,   446,   502,   599,   503,   761,   613,   670,    -1,   354,
     272,   502,   599,   503,   761,   613,   670,    -1,   208,   739,
     502,   602,   503,   761,   613,   604,   670,    -1,   224,   272,
     502,   599,   503,   366,  1001,   598,   601,   605,   670,    -1,
     502,   599,   503,    -1,    -1,   600,    -1,   599,   505,   600,
      -1,  1131,    -1,   293,   228,    -1,   293,   343,    -1,   293,
     404,    -1,    -1,   603,    -1,   602,   505,   603,    -1,   741,
     469,   771,    -1,   741,   469,   330,   502,   771,   503,    -1,
     466,   502,   941,   503,    -1,    -1,   606,    -1,   607,    -1,
     606,   607,    -1,   607,   606,    -1,    -1,   328,   450,   608,
      -1,   328,   186,   608,    -1,   306,    94,    -1,   376,    -1,
     127,    -1,   399,   319,    -1,   399,   181,    -1,   253,   502,
    1000,   503,    -1,    -1,   469,   559,    -1,   469,   327,    -1,
     470,   327,    -1,    -1,   328,   146,   198,    -1,   328,   146,
     186,   384,    -1,   328,   146,   351,   384,    -1,    -1,   424,
    1003,    -1,    -1,   452,   250,   424,  1003,    -1,    -1,  1001,
     615,   610,   611,   612,    -1,   502,   616,   503,    -1,    -1,
     617,    -1,   616,   505,   617,    -1,  1131,    -1,   469,   174,
      -1,   469,   306,   174,    -1,    -1,   158,   580,   393,  1001,
     621,    -1,   101,   393,  1001,   622,    -1,   622,    -1,    -1,
     623,    -1,   622,   623,    -1,   125,   625,    -1,   173,    -1,
     306,   173,    -1,   249,   624,   625,    -1,   294,   625,    -1,
     296,   625,    -1,   306,   294,    -1,   306,   296,    -1,   340,
     124,   704,    -1,   409,   514,   625,    -1,   375,    -1,   375,
     514,   625,    -1,   124,    -1,    -1,  1150,    -1,   494,  1150,
      -1,  1013,    -1,   625,    -1,   626,   505,   625,    -1,   158,
     746,   628,   634,   273,   544,    -1,   158,   746,   628,   634,
     273,   544,   236,   629,   630,   632,    -1,   440,    -1,    -1,
    1003,    -1,  1003,   705,    -1,   255,   629,    -1,    -1,   455,
     629,    -1,   306,   455,    -1,   631,    -1,    -1,   198,   634,
     273,   544,   557,    -1,   198,   634,   273,   242,   212,   544,
     557,    -1,   357,    -1,    -1,   158,   424,  1003,   636,   289,
    1151,    -1,   341,  1003,    -1,    -1,   198,   424,  1003,    -1,
     198,   424,   242,   212,  1003,    -1,   158,   224,   174,   472,
    1003,   632,   641,    -1,   198,   224,   174,   472,  1003,   557,
      -1,   198,   224,   174,   472,   242,   212,  1003,   557,    -1,
     101,   224,   174,   472,  1003,   631,   643,    -1,   101,   224,
     174,   472,  1003,   631,    -1,   101,   224,   174,   472,  1003,
     643,    -1,   332,   502,   642,   503,    -1,    -1,   646,    -1,
     642,   505,   646,    -1,   332,   502,   644,   503,    -1,   645,
      -1,   644,   505,   645,    -1,   646,    -1,   399,   646,    -1,
      95,   646,    -1,   198,   647,    -1,   647,   648,    -1,  1133,
      -1,  1151,    -1,   158,   396,  1003,   650,   652,   224,   174,
     472,  1003,   641,    -1,   441,  1151,    -1,    -1,   462,  1151,
      -1,   462,   319,    -1,   651,    -1,    -1,   198,   396,  1003,
     557,    -1,   198,   396,   242,   212,  1003,   557,    -1,   101,
     396,  1003,   651,   643,    -1,   101,   396,  1003,   651,    -1,
     101,   396,  1003,   643,    -1,   158,   451,   292,   222,   656,
     396,  1003,   641,    -1,   171,    -1,   451,    -1,  1012,    -1,
     198,   451,   292,   222,   656,   396,  1003,    -1,   198,   451,
     292,   242,   212,   222,   656,   396,  1003,    -1,   101,   451,
     292,   222,   656,   396,  1003,   643,    -1,   158,   436,  1003,
     660,   661,   328,  1001,   663,   666,   211,   358,  1009,   502,
     667,   503,    -1,   158,   151,   436,  1003,    97,   661,   328,
    1001,   669,   670,   222,   199,   383,   666,   211,   358,  1009,
     502,   667,   503,    -1,   116,    -1,    97,    -1,   662,    -1,
     661,   333,   662,    -1,   260,    -1,   186,    -1,   450,    -1,
     450,   324,   599,    -1,   439,    -1,   222,   664,   665,    -1,
      -1,   199,    -1,    -1,   383,    -1,   410,    -1,   465,   502,
     941,   503,    -1,    -1,   668,    -1,   667,   505,   668,    -1,
      -1,  1011,    -1,  1150,    -1,  1151,    -1,  1149,    -1,    84,
      -1,  1131,    -1,   227,  1001,    -1,    -1,   671,    -1,   671,
     672,    -1,   672,    -1,   672,   671,    -1,    -1,   314,   183,
      -1,   183,    -1,   254,   244,    -1,   254,   184,    -1,   198,
     436,  1003,   328,  1001,   557,    -1,   198,   436,   242,   212,
    1003,   328,  1001,   557,    -1,   158,   110,  1003,   136,   502,
     941,   503,   670,    -1,   198,   110,  1003,   557,    -1,   158,
      98,  1009,   681,   677,    -1,   158,    98,  1009,   682,    -1,
     158,   330,   771,   677,    -1,   158,   441,   704,   677,    -1,
     158,   441,   704,    -1,   158,   441,   704,   108,   502,   915,
     503,    -1,   158,   441,   704,   108,   205,   502,   685,   503,
      -1,   158,   428,   389,   342,   704,   677,    -1,   158,   428,
     389,   190,   704,   677,    -1,   158,   428,   389,   426,   704,
     677,    -1,   158,   428,   389,   149,   704,   677,    -1,   502,
     678,   503,    -1,   679,    -1,   678,   505,   679,    -1,  1133,
     489,   680,    -1,  1133,    -1,   755,    -1,  1017,    -1,   967,
      -1,   625,    -1,  1151,    -1,   502,   972,   503,    -1,   502,
     495,   503,    -1,   502,   683,   503,    -1,   684,    -1,   683,
     505,   684,    -1,  1153,   489,   680,    -1,   686,    -1,    -1,
    1151,    -1,   686,   505,  1151,    -1,   158,   330,   138,   704,
     690,   222,   441,   917,   452,  1005,   691,   108,   688,    -1,
     689,    -1,   688,   505,   689,    -1,   330,  1011,   771,   692,
      -1,   330,  1011,   771,   770,   692,    -1,   229,  1011,  1009,
     747,    -1,   229,  1011,   502,   972,   503,  1009,   747,    -1,
     414,   917,    -1,   181,    -1,    -1,   217,   704,    -1,    -1,
     364,    -1,    -1,   158,   330,   217,   704,   452,  1005,    -1,
     101,   330,   217,   704,   452,  1005,    95,   688,    -1,   101,
     330,   217,   704,   452,  1005,   198,   695,    -1,   696,    -1,
     695,   505,   696,    -1,   330,  1011,   502,   972,   503,    -1,
     229,  1011,   502,   972,   503,    -1,   198,   330,   138,   704,
     452,  1005,   557,    -1,   198,   330,   138,   242,   212,   704,
     452,  1005,   557,    -1,   198,   330,   217,   704,   452,  1005,
     557,    -1,   198,   330,   217,   242,   212,   704,   452,  1005,
     557,    -1,   198,   340,   124,  1002,   557,    -1,   363,   340,
     124,  1002,   432,  1003,    -1,   198,   702,   242,   212,   703,
     557,    -1,   198,   702,   703,   557,    -1,   422,    -1,   393,
      -1,   463,    -1,   250,    -1,   441,    -1,   196,    -1,   155,
      -1,   387,    -1,   428,   389,   342,    -1,   428,   389,   190,
      -1,   428,   389,   426,    -1,   428,   389,   149,    -1,   704,
      -1,   703,   505,   704,    -1,  1131,    -1,  1131,   705,    -1,
     504,  1006,    -1,   705,   504,  1006,    -1,   439,   876,   910,
     707,   557,    -1,   154,   241,    -1,   375,   241,    -1,    -1,
     144,   328,   709,   704,   268,   710,    -1,   144,   328,    98,
    1009,   681,   268,   710,    -1,   144,   328,   229,  1009,   747,
     268,   710,    -1,   144,   328,   330,   771,   770,   268,   710,
      -1,   144,   328,   151,  1003,   328,   704,   268,   710,    -1,
     144,   328,   385,  1003,   328,   704,   268,   710,    -1,   144,
     328,   385,  1003,   268,   710,    -1,   144,   328,   436,  1003,
     328,   704,   268,   710,    -1,   144,   328,   330,   138,   704,
     452,  1005,   268,   710,    -1,   144,   328,   330,   217,   704,
     452,  1005,   268,   710,    -1,   144,   328,   274,   323,   625,
     268,   710,    -1,   144,   328,   130,   502,   917,   108,   917,
     503,   268,   710,    -1,   144,   328,   634,   273,   704,   268,
     710,    -1,   144,   328,   428,   389,   342,   704,   268,   710,
      -1,   144,   328,   428,   389,   190,   704,   268,   710,    -1,
     144,   328,   428,   389,   426,   704,   268,   710,    -1,   144,
     328,   428,   389,   149,   704,   268,   710,    -1,   143,    -1,
     175,    -1,   387,    -1,   250,    -1,   393,    -1,   422,    -1,
     196,    -1,   441,    -1,   463,    -1,   155,    -1,   424,    -1,
     381,    -1,  1151,    -1,   319,    -1,   218,   712,    -1,   299,
     712,    -1,   218,   712,  1165,    -1,   218,   225,   863,  1166,
      -1,   218,   225,   713,   863,  1166,    -1,   218,   115,   863,
    1166,    -1,   218,   115,   713,   863,  1166,    -1,   299,   225,
     863,    -1,   299,   225,   713,   863,    -1,   299,   115,   863,
      -1,   299,   115,   713,   863,    -1,   863,    -1,   713,   863,
      -1,   305,   714,   863,    -1,   355,   714,   863,    -1,   219,
     714,   863,    -1,   275,   714,   863,    -1,    92,  1013,   714,
     863,    -1,   368,  1013,   714,   863,    -1,  1013,   714,   863,
      -1,    99,   714,   863,    -1,   225,  1013,   714,   863,    -1,
     225,    99,   714,   863,    -1,   115,  1013,   714,   863,    -1,
     115,    99,   714,   863,    -1,   227,    -1,   247,    -1,   713,
      -1,    -1,   232,   717,   328,   720,   432,   721,   723,    -1,
     379,   717,   328,   720,   227,   721,   557,    -1,   379,   232,
     331,   222,   717,   328,   720,   227,   721,   557,    -1,   718,
      -1,    99,    -1,    99,   356,    -1,    99,   502,   599,   503,
      -1,    99,   356,   502,   599,   503,    -1,   719,    -1,   718,
     505,   719,    -1,   392,   598,    -1,   366,   598,    -1,   158,
     598,    -1,  1131,   598,    -1,  1000,    -1,   422,  1000,    -1,
     393,  1000,    -1,   224,   174,   472,  1002,    -1,   224,   396,
    1002,    -1,   229,   724,    -1,   175,  1002,    -1,   273,  1002,
      -1,   274,   323,   626,    -1,   387,  1002,    -1,   424,  1002,
      -1,    99,   423,   247,   387,  1002,    -1,    99,   394,   247,
     387,  1002,    -1,    99,   230,   247,   387,  1002,    -1,   722,
      -1,   721,   505,   722,    -1,  1012,    -1,   235,  1012,    -1,
     469,   232,   331,    -1,    -1,   725,    -1,   724,   505,   725,
      -1,  1009,   747,    -1,   232,   718,   432,  1002,   728,   729,
      -1,   379,   718,   227,  1002,   729,   557,    -1,   379,    96,
     331,   222,   718,   227,  1002,   729,   557,    -1,   469,    96,
     331,    -1,    -1,   233,   124,  1012,    -1,    -1,   101,   181,
     356,   731,   733,    -1,   731,   732,    -1,    -1,   247,   387,
    1002,    -1,   222,   381,  1002,    -1,   222,   451,  1002,    -1,
     232,   717,   328,   734,   432,   721,   723,    -1,   379,   717,
     328,   734,   227,   721,   557,    -1,   379,   232,   331,   222,
     717,   328,   734,   227,   721,   557,    -1,   423,    -1,   230,
      -1,   394,    -1,   158,   736,   250,   737,   738,   328,  1001,
     739,   502,   740,   503,   560,   612,   913,    -1,   446,    -1,
      -1,   148,    -1,    -1,  1007,    -1,    -1,   452,  1005,    -1,
      -1,   741,    -1,   740,   505,   741,    -1,  1131,   742,   743,
     744,    -1,   944,   742,   743,   744,    -1,   502,   941,   503,
     742,   743,   744,    -1,   704,    -1,   452,   704,    -1,    -1,
     109,    -1,   189,    -1,    -1,   486,    -1,   487,    -1,    -1,
     158,   746,   229,  1009,   749,   378,   754,   757,   761,    -1,
     158,   746,   229,  1009,   749,   378,   422,   502,   763,   503,
     757,   761,    -1,   158,   746,   229,  1009,   749,   757,   761,
      -1,   333,   372,    -1,    -1,   502,   748,   503,    -1,   502,
     503,    -1,   751,    -1,   748,   505,   751,    -1,   502,   750,
     503,    -1,   502,   503,    -1,   756,    -1,   750,   505,   756,
      -1,   752,   753,   755,    -1,   753,   752,   755,    -1,   753,
     755,    -1,   752,   755,    -1,   755,    -1,   247,    -1,   335,
      -1,   257,    -1,   247,   335,    -1,   459,    -1,  1132,    -1,
     755,    -1,   917,    -1,  1132,   705,   497,   441,    -1,   400,
    1132,   705,   497,   441,    -1,   751,    -1,   751,   181,   941,
      -1,   751,   489,   941,    -1,   759,    -1,   757,   759,    -1,
     126,   328,   319,   258,    -1,   378,   319,   328,   319,   258,
      -1,   415,    -1,   245,    -1,   407,    -1,   464,    -1,   214,
     391,   185,    -1,   214,   391,   267,    -1,   391,   185,    -1,
     391,   267,    -1,   157,   625,    -1,   384,   625,    -1,   546,
      -1,   108,   760,    -1,   273,   544,    -1,   468,    -1,   758,
      -1,  1151,    -1,  1151,   505,  1151,    -1,   469,   677,    -1,
      -1,   753,   755,    -1,   762,    -1,   763,   505,   762,    -1,
     101,   229,   725,   765,   766,    -1,   758,    -1,   765,   758,
      -1,   376,    -1,    -1,   198,   229,  1009,   747,   557,    -1,
     198,   229,   242,   212,  1009,   747,   557,    -1,   198,    98,
    1009,   681,   557,    -1,   198,    98,   242,   212,  1009,   681,
     557,    -1,   198,   330,   771,   770,   557,    -1,   198,   330,
     242,   212,   771,   770,   557,    -1,   502,   917,   503,    -1,
     502,   917,   505,   917,   503,    -1,   502,   312,   505,   917,
     503,    -1,   502,   917,   505,   312,   503,    -1,   964,    -1,
    1131,   504,   771,    -1,   194,   773,    -1,   774,    -1,   773,
     774,    -1,  1151,    -1,   273,   544,    -1,   158,   130,   502,
     917,   108,   917,   503,   469,   229,   725,   776,    -1,   158,
     130,   502,   917,   108,   917,   503,   470,   229,   776,    -1,
     158,   130,   502,   917,   108,   917,   503,   469,   257,   776,
      -1,   108,   246,    -1,   108,   111,    -1,    -1,   198,   130,
     778,   502,   917,   108,   917,   503,   557,    -1,   242,   212,
      -1,    -1,   367,   780,  1001,   781,    -1,   367,   421,  1003,
     781,    -1,   367,   175,  1003,   781,    -1,   250,    -1,   422,
      -1,   223,    -1,    -1,   101,    98,  1009,   681,   370,   432,
    1003,    -1,   101,   155,   704,   370,   432,  1003,    -1,   101,
     175,  1004,   370,   432,  1004,    -1,   101,   229,   725,   370,
     432,  1003,    -1,   101,   235,  1012,   370,   432,  1012,    -1,
     101,   634,   273,  1003,   370,   432,  1003,    -1,   101,   330,
     138,   704,   452,  1005,   370,   432,  1003,    -1,   101,   330,
     217,   704,   452,  1005,   370,   432,  1003,    -1,   101,   387,
    1003,   370,   432,  1003,    -1,   101,   422,   909,   370,   432,
    1003,    -1,   101,   393,  1001,   370,   432,  1003,    -1,   101,
     463,  1001,   370,   432,  1003,    -1,   101,   250,  1001,   370,
     432,  1003,    -1,   101,   422,   909,   370,   783,  1003,   432,
    1003,    -1,   101,   436,  1003,   328,  1001,   370,   432,  1003,
      -1,   101,   381,  1012,   370,   432,  1012,    -1,   101,   451,
    1012,   370,   432,  1012,    -1,   101,   424,  1003,   370,   432,
    1003,    -1,   101,   424,  1003,   399,   559,    -1,   101,   424,
    1003,   374,   559,    -1,   101,   428,   389,   342,   704,   370,
     432,  1003,    -1,   101,   428,   389,   190,   704,   370,   432,
    1003,    -1,   101,   428,   389,   426,   704,   370,   432,  1003,
      -1,   101,   428,   389,   149,   704,   370,   432,  1003,    -1,
     101,   441,   704,   370,   432,  1003,    -1,   143,    -1,    -1,
     399,   174,    -1,    -1,   101,    98,  1009,   681,   399,   387,
    1003,    -1,   101,   196,   704,   399,   387,  1003,    -1,   101,
     229,   725,   399,   387,  1003,    -1,   101,   422,   909,   399,
     387,  1003,    -1,   101,   393,  1001,   399,   387,  1003,    -1,
     101,   463,  1001,   399,   387,  1003,    -1,   101,   441,   704,
     399,   387,  1003,    -1,   101,    98,  1009,   681,   341,   432,
    1012,    -1,   101,   155,   704,   341,   432,  1012,    -1,   101,
     175,  1004,   341,   432,  1012,    -1,   101,   196,   704,   341,
     432,  1012,    -1,   101,   229,   725,   341,   432,  1012,    -1,
     101,   634,   273,  1003,   341,   432,  1012,    -1,   101,   274,
     323,   625,   341,   432,  1012,    -1,   101,   330,   771,   770,
     341,   432,  1012,    -1,   101,   330,   138,   704,   452,  1005,
     341,   432,  1012,    -1,   101,   330,   217,   704,   452,  1005,
     341,   432,  1012,    -1,   101,   387,  1003,   341,   432,  1012,
      -1,   101,   441,   704,   341,   432,  1012,    -1,   101,   424,
    1003,   341,   432,  1012,    -1,   101,   428,   389,   190,   704,
     341,   432,  1012,    -1,   101,   428,   389,   149,   704,   341,
     432,  1012,    -1,   101,   224,   174,   472,  1003,   341,   432,
    1012,    -1,   101,   396,  1003,   341,   432,  1012,    -1,   158,
     746,   385,  1003,   108,   328,   792,   432,  1001,   913,   194,
     793,   788,    -1,   315,    -1,   790,    -1,   502,   789,   503,
      -1,   789,   506,   791,    -1,   791,    -1,   866,    -1,   844,
      -1,   855,    -1,   849,    -1,   795,    -1,   790,    -1,    -1,
     392,    -1,   450,    -1,   186,    -1,   260,    -1,   261,    -1,
     100,    -1,    -1,   198,   385,  1003,   328,  1001,   557,    -1,
     198,   385,   242,   212,  1003,   328,  1001,   557,    -1,   316,
    1131,   796,    -1,   505,  1151,    -1,    -1,   284,  1131,    -1,
     448,  1131,    -1,   448,   495,    -1,    91,   800,    -1,   117,
     800,   803,    -1,   409,   434,   803,    -1,   146,   800,    -1,
     204,   800,    -1,   382,   800,    -1,   386,  1131,    -1,   369,
     386,  1131,    -1,   369,  1131,    -1,   382,   800,   432,   386,
    1131,    -1,   382,   800,   432,  1131,    -1,   352,   434,  1151,
      -1,   146,   353,  1151,    -1,   382,   353,  1151,    -1,   471,
      -1,   434,    -1,    -1,   270,   281,   540,    -1,   361,   329,
      -1,   361,   473,    -1,   801,    -1,   802,   505,   801,    -1,
     802,   801,    -1,   802,    -1,    -1,   158,   580,   463,  1001,
     598,   108,   866,   805,    -1,   158,   333,   372,   580,   463,
    1001,   598,   108,   866,   805,    -1,   469,   136,   331,    -1,
     469,   128,   136,   331,    -1,   469,   286,   136,   331,    -1,
      -1,   285,  1008,    -1,   158,   175,  1004,   514,   808,    -1,
     808,   809,    -1,    -1,   424,   810,  1003,    -1,   424,   810,
     181,    -1,   289,   810,  1151,    -1,   289,   810,   181,    -1,
     426,   810,  1003,    -1,   426,   810,   181,    -1,   202,   810,
    1151,    -1,   202,   810,  1011,    -1,   202,   810,   181,    -1,
     276,   810,  1151,    -1,   276,   810,   181,    -1,   277,   810,
    1151,    -1,   277,   810,   181,    -1,   150,   283,   810,  1013,
      -1,   341,   810,  1003,    -1,   341,   810,   181,    -1,   489,
      -1,    -1,   101,   175,  1004,   514,   813,    -1,   101,   175,
    1004,   399,   424,  1003,    -1,   101,   175,  1004,   546,    -1,
     813,   814,    -1,    -1,   150,   283,   810,  1013,    -1,   198,
     175,  1004,    -1,   198,   175,   242,   212,  1004,    -1,   158,
     196,   704,   818,   917,   589,    -1,   101,   196,   704,   556,
      -1,   101,   196,   704,   198,   314,   319,    -1,   101,   196,
     704,   399,   314,   319,    -1,   101,   196,   704,    95,   596,
      -1,   101,   196,   704,   198,   151,  1003,   557,    -1,   108,
      -1,    -1,   101,   428,   389,   190,   704,   677,    -1,   101,
     428,   389,   149,   704,    95,   292,   222,  1002,   469,   703,
      -1,   101,   428,   389,   149,   704,   101,   292,   222,  1002,
     469,   703,    -1,   101,   428,   389,   149,   704,   101,   292,
     372,   704,   469,   704,    -1,   101,   428,   389,   149,   704,
     101,   292,   222,  1002,   372,   704,   469,   704,    -1,   101,
     428,   389,   149,   704,   198,   292,   222,  1002,    -1,   101,
     428,   389,   149,   704,   198,   292,   242,   212,   222,  1002,
      -1,   158,   690,   155,   704,   222,  1151,   432,  1151,   227,
     704,    -1,   140,   829,  1001,   823,    -1,   140,   829,    -1,
     140,   829,  1007,   328,  1001,    -1,   452,  1007,    -1,    -1,
     453,   830,   831,   829,    -1,   453,   830,   831,   829,  1001,
      -1,   453,   830,   831,   829,   827,    -1,   453,   502,   825,
     503,    -1,   453,   502,   825,   503,  1001,   832,    -1,   826,
      -1,   825,   505,   826,    -1,   828,    -1,   461,    -1,   226,
      -1,   228,    -1,   828,   829,    -1,   828,   829,  1001,   832,
      -1,   104,    -1,   103,    -1,   461,    -1,    -1,   228,    -1,
      -1,   226,    -1,    -1,   502,  1002,   503,    -1,    -1,   213,
     834,    -1,   213,   828,   829,   834,    -1,   213,   461,   834,
      -1,   213,   502,   835,   503,   834,    -1,   866,    -1,   844,
      -1,   855,    -1,   849,    -1,   862,    -1,  1020,    -1,   842,
      -1,   836,    -1,   835,   505,   836,    -1,   837,   838,    -1,
    1131,    -1,   828,    -1,   461,    -1,   541,    -1,   625,    -1,
      -1,   352,  1039,   840,   108,   841,    -1,   352,  1039,   227,
    1084,    -1,   502,   972,   503,    -1,    -1,   866,    -1,   844,
      -1,   855,    -1,   849,    -1,   211,  1039,   843,  1163,    -1,
     158,   580,   422,   614,   108,   211,  1039,   843,    -1,   502,
     969,   503,    -1,    -1,   260,   266,  1001,   845,   848,    -1,
     866,    -1,   502,   846,   503,   866,    -1,   181,   457,    -1,
     847,    -1,   846,   505,   847,    -1,  1131,   993,    -1,   377,
     998,  1164,    -1,    -1,   186,   227,   911,   850,   914,   848,
      -1,   452,   902,    -1,    -1,   290,   876,   910,   852,   854,
      -1,   247,   853,   297,    -1,    -1,    93,   401,    -1,   383,
     401,    -1,   383,   210,    -1,   401,   450,   210,    -1,   401,
      -1,   401,   383,   210,    -1,   210,    -1,    93,   210,    -1,
     318,    -1,    -1,   450,   911,   399,   856,   901,   914,   848,
      -1,   857,    -1,   856,   505,   857,    -1,   858,    -1,   859,
      -1,   860,   489,   995,    -1,   502,   861,   503,   489,   997,
      -1,  1131,   993,    -1,   860,    -1,   861,   505,   860,    -1,
     180,   863,   864,   172,   865,   222,   866,    -1,  1003,    -1,
    1144,    -1,    -1,   864,   306,   388,    -1,   864,   388,    -1,
     864,   120,    -1,   864,   259,    -1,    -1,   469,   239,    -1,
     470,   239,    -1,   868,    -1,   867,    -1,   502,   868,   503,
      -1,   502,   867,   503,    -1,   870,    -1,   869,   880,    -1,
     869,   879,   895,   884,    -1,   869,   879,   883,   896,    -1,
     871,   869,    -1,   871,   869,   880,    -1,   871,   869,   879,
     895,   884,    -1,   871,   869,   879,   883,   896,    -1,   870,
      -1,   867,    -1,   392,   878,   998,   874,   901,   913,   893,
     894,   952,    -1,   900,    -1,   422,   909,    -1,   869,   445,
     877,   869,    -1,   869,   264,   877,   869,    -1,   869,   207,
     877,   869,    -1,   469,   872,    -1,   469,   365,   872,    -1,
     873,    -1,   872,   505,   873,    -1,  1003,   832,   108,   867,
      -1,   266,   875,    -1,  1164,    -1,    -1,   427,   876,  1001,
      -1,   425,   876,  1001,    -1,   286,   427,   876,  1001,    -1,
     286,   425,   876,  1001,    -1,   231,   427,   876,  1001,    -1,
     231,   425,   876,  1001,    -1,   422,  1001,    -1,  1001,    -1,
     422,    -1,    -1,    99,    -1,   193,    -1,    -1,   193,    -1,
     193,   328,   502,   969,   503,    -1,    99,    -1,    -1,   880,
      -1,    -1,   334,   124,   881,    -1,   882,    -1,   881,   505,
     882,    -1,   941,   452,   967,   744,    -1,   941,   743,   744,
      -1,   885,   886,    -1,   886,   885,    -1,   885,    -1,   886,
      -1,   883,    -1,    -1,   283,   887,    -1,   283,   887,   505,
     888,    -1,   218,   892,   889,   891,   329,    -1,   326,   888,
      -1,   326,   890,   891,    -1,   941,    -1,    99,    -1,   941,
      -1,  1013,    -1,   502,   941,   503,    -1,    -1,   943,    -1,
     383,    -1,   384,    -1,   219,    -1,   305,    -1,   235,   124,
     969,    -1,    -1,   237,   941,    -1,    -1,   897,    -1,   222,
     361,   329,    -1,   895,    -1,    -1,   898,    -1,   897,   898,
      -1,   222,   450,   899,   854,    -1,   222,   401,   899,   854,
      -1,   324,  1000,    -1,    -1,   457,   997,    -1,   900,   505,
     997,    -1,   227,   902,    -1,    -1,   903,    -1,   902,   505,
     903,    -1,   909,    -1,   909,   905,    -1,   912,    -1,   912,
     905,    -1,   912,   108,   502,   915,   503,    -1,   912,   108,
    1131,   502,   915,   503,    -1,   912,  1131,   502,   915,   503,
      -1,   867,    -1,   867,   905,    -1,   904,    -1,   502,   904,
     503,   905,    -1,   502,   904,   503,    -1,   903,   162,   271,
     903,    -1,   903,   906,   271,   903,   908,    -1,   903,   271,
     903,   908,    -1,   903,   303,   906,   271,   903,    -1,   903,
     303,   271,   903,    -1,   108,  1131,   502,  1002,   503,    -1,
     108,  1131,    -1,  1131,   502,  1002,   503,    -1,  1131,    -1,
     228,   907,    -1,   280,   907,    -1,   380,   907,    -1,   256,
      -1,   336,    -1,    -1,   452,   502,  1002,   503,    -1,   328,
     941,    -1,  1001,    -1,  1001,   495,    -1,   329,  1001,    -1,
     329,   502,  1001,   503,    -1,   909,    -1,   910,   505,   909,
      -1,   909,    -1,   909,  1131,    -1,   909,   108,  1131,    -1,
     944,    -1,   466,   941,    -1,    -1,   466,   941,    -1,   466,
     164,   324,  1003,    -1,    -1,   916,    -1,   915,   505,   916,
      -1,  1131,   917,    -1,   919,   918,    -1,   400,   919,   918,
      -1,   919,   107,   500,  1011,   501,    -1,   400,   919,   107,
     500,  1011,   501,    -1,   919,   107,    -1,   400,   919,   107,
      -1,   918,   500,   501,    -1,   918,   500,  1162,   501,    -1,
      -1,   921,    -1,   923,    -1,   925,    -1,   929,    -1,   936,
      -1,   937,   939,    -1,   937,   502,  1011,   503,   939,    -1,
     923,    -1,   926,    -1,   930,    -1,   936,    -1,  1132,   922,
      -1,  1132,   705,   922,    -1,   502,   969,   503,    -1,    -1,
     262,    -1,   263,    -1,   405,    -1,   119,    -1,   362,    -1,
     220,   924,    -1,   197,   350,    -1,   179,   922,    -1,   178,
     922,    -1,   322,   922,    -1,   122,    -1,   502,  1011,   503,
      -1,    -1,   927,    -1,   928,    -1,   927,    -1,   928,    -1,
     121,   934,   502,   969,   503,    -1,   121,   934,    -1,   931,
      -1,   932,    -1,   931,    -1,   932,    -1,   933,   502,  1011,
     503,   935,    -1,   933,   935,    -1,   134,   934,    -1,   133,
     934,    -1,   458,    -1,   302,   134,   934,    -1,   302,   133,
     934,    -1,   304,   934,    -1,   460,    -1,    -1,   134,   399,
    1131,    -1,    -1,   431,   502,  1011,   503,   938,    -1,   431,
     938,    -1,   430,   502,  1011,   503,   938,    -1,   430,   938,
      -1,   265,    -1,   488,   485,    -1,   470,   430,   485,    -1,
      -1,   483,    -1,   298,    -1,   176,    -1,   240,    -1,   295,
      -1,   940,    -1,   483,   432,   298,    -1,   176,   432,   240,
      -1,   176,   432,   295,    -1,   176,   432,   940,    -1,   240,
     432,   295,    -1,   240,   432,   940,    -1,   295,   432,   940,
      -1,    -1,   390,    -1,   390,   502,  1011,   503,    -1,   943,
      -1,   941,    88,   917,    -1,   941,   113,   430,   485,   941,
      -1,   493,   941,    -1,   494,   941,    -1,   941,   493,   941,
      -1,   941,   494,   941,    -1,   941,   495,   941,    -1,   941,
     496,   941,    -1,   941,   497,   941,    -1,   941,   498,   941,
      -1,   941,   490,   941,    -1,   941,   491,   941,    -1,   941,
     489,   941,    -1,   941,   966,   941,    -1,   966,   941,    -1,
     941,   966,    -1,   941,   105,   941,    -1,   941,   333,   941,
      -1,   314,   941,    -1,   941,   282,   941,    -1,   941,   282,
     941,   206,   941,    -1,   941,   314,   282,   941,    -1,   941,
     314,   282,   941,   206,   941,    -1,   941,   243,   941,    -1,
     941,   243,   941,   206,   941,    -1,   941,   314,   243,   941,
      -1,   941,   314,   243,   941,   206,   941,    -1,   941,   403,
     432,   941,    -1,   941,   403,   432,   941,   206,   941,    -1,
     941,   314,   403,   432,   941,    -1,   941,   314,   403,   432,
     941,   206,   941,    -1,   941,   268,   319,    -1,   941,   269,
      -1,   941,   268,   314,   319,    -1,   941,   317,    -1,   962,
     338,   962,    -1,   941,   268,   438,    -1,   941,   268,   314,
     438,    -1,   941,   268,   216,    -1,   941,   268,   314,   216,
      -1,   941,   268,   447,    -1,   941,   268,   314,   447,    -1,
     941,   268,   193,   227,   941,    -1,   941,   268,   314,   193,
     227,   941,    -1,   941,   268,   324,   502,   972,   503,    -1,
     941,   268,   314,   324,   502,   972,   503,    -1,   941,   118,
     994,   942,   105,   942,    -1,   941,   314,   118,   994,   942,
     105,   942,    -1,   941,   118,   419,   942,   105,   942,    -1,
     941,   314,   118,   419,   942,   105,   942,    -1,   941,   247,
     984,    -1,   941,   314,   247,   984,    -1,   941,   968,   963,
     867,    -1,   941,   968,   963,   502,   941,   503,    -1,   446,
     867,    -1,   941,   268,   195,    -1,   941,   268,   314,   195,
      -1,   943,    -1,   942,    88,   917,    -1,   493,   942,    -1,
     494,   942,    -1,   942,   493,   942,    -1,   942,   494,   942,
      -1,   942,   495,   942,    -1,   942,   496,   942,    -1,   942,
     497,   942,    -1,   942,   498,   942,    -1,   942,   490,   942,
      -1,   942,   491,   942,    -1,   942,   489,   942,    -1,   942,
     966,   942,    -1,   966,   942,    -1,   942,   966,    -1,   942,
     268,   193,   227,   942,    -1,   942,   268,   314,   193,   227,
     942,    -1,   942,   268,   324,   502,   972,   503,    -1,   942,
     268,   314,   324,   502,   972,   503,    -1,   942,   268,   195,
      -1,   942,   268,   314,   195,    -1,   990,    -1,  1010,    -1,
    1148,   993,    -1,   502,   941,   503,   993,    -1,   985,    -1,
     944,    -1,   867,    -1,   212,   867,    -1,   107,   867,    -1,
     107,   973,    -1,   962,    -1,  1009,   502,   503,   955,    -1,
    1009,   502,   970,   503,   955,    -1,  1009,   502,   459,   971,
     503,   955,    -1,  1009,   502,   970,   505,   459,   971,   503,
     955,    -1,  1009,   502,   970,   880,   503,   955,    -1,  1009,
     502,    99,   970,   879,   503,   955,    -1,  1009,   502,   193,
     970,   879,   503,   955,    -1,  1009,   502,   495,   503,   955,
      -1,   166,    -1,   169,    -1,   169,   502,  1011,   503,    -1,
     170,    -1,   170,   502,  1011,   503,    -1,   287,    -1,   287,
     502,  1011,   503,    -1,   288,    -1,   288,   502,  1011,   503,
      -1,   167,    -1,   171,    -1,   398,    -1,   451,    -1,   165,
      -1,   168,    -1,   130,   502,   941,   108,   917,   503,    -1,
     215,   502,   975,   503,    -1,   339,   502,   977,   503,    -1,
     348,   502,   979,   503,    -1,   417,   502,   980,   503,    -1,
     435,   502,   941,   108,   917,   503,    -1,   437,   502,   123,
     983,   503,    -1,   437,   502,   278,   983,   503,    -1,   437,
     502,   433,   983,   503,    -1,   437,   502,   983,   503,    -1,
     320,   502,   941,   505,   941,   503,    -1,   141,   502,   969,
     503,    -1,   234,   502,   969,   503,    -1,   279,   502,   969,
     503,    -1,   476,   502,   969,   503,    -1,   477,   502,   300,
    1133,   503,    -1,   477,   502,   300,  1133,   505,   947,   503,
      -1,   477,   502,   300,  1133,   505,   969,   503,    -1,   477,
     502,   300,  1133,   505,   947,   505,   969,   503,    -1,   478,
     502,   948,   503,    -1,   479,   502,   950,   941,   951,   503,
      -1,   480,   502,   300,  1133,   503,    -1,   480,   502,   300,
    1133,   505,   941,   503,    -1,   481,   502,   941,   505,   945,
     946,   503,    -1,   482,   502,   950,   941,   108,   919,   503,
      -1,   462,   941,    -1,   462,   306,   456,    -1,   505,   408,
     484,    -1,   505,   408,   306,    -1,   505,   408,   306,   456,
      -1,    -1,   475,   502,   948,   503,    -1,   949,    -1,   948,
     505,   949,    -1,   941,   108,  1133,    -1,   941,    -1,   195,
      -1,   153,    -1,   351,   467,    -1,   416,   467,    -1,    -1,
     468,   953,    -1,    -1,   954,    -1,   953,   505,   954,    -1,
    1131,   108,   956,    -1,   337,   956,    -1,   337,  1131,    -1,
      -1,   502,   957,   958,   879,   959,   503,    -1,  1131,    -1,
      -1,   344,   124,   969,    -1,    -1,   360,   960,    -1,   384,
     960,    -1,    -1,   961,    -1,   118,   961,   105,   961,    -1,
     442,   349,    -1,   442,   221,    -1,   164,   383,    -1,   941,
     349,    -1,   941,   221,    -1,   383,   502,   969,   503,    -1,
     383,   502,   503,    -1,   502,   969,   505,   941,   503,    -1,
     106,    -1,   406,    -1,    99,    -1,    85,    -1,   965,    -1,
     493,    -1,   494,    -1,   495,    -1,   496,    -1,   497,    -1,
     498,    -1,   490,    -1,   491,    -1,   489,    -1,    85,    -1,
     330,   502,   771,   503,    -1,   964,    -1,   330,   502,   771,
     503,    -1,   964,    -1,   330,   502,   771,   503,    -1,   282,
      -1,   314,   282,    -1,   243,    -1,   314,   243,    -1,   941,
      -1,   969,   505,   941,    -1,   971,    -1,   970,   505,   971,
      -1,   941,    -1,   753,    90,   941,    -1,   917,    -1,   972,
     505,   917,    -1,   500,   969,   501,    -1,   500,   974,   501,
      -1,   500,   501,    -1,   973,    -1,   974,   505,   973,    -1,
     976,   227,   941,    -1,    -1,  1153,    -1,   483,    -1,   298,
      -1,   176,    -1,   240,    -1,   295,    -1,   390,    -1,  1151,
      -1,   941,   978,   981,   982,    -1,   941,   978,   981,    -1,
     346,   941,    -1,   942,   247,   942,    -1,    -1,   941,   981,
     982,    -1,   941,   982,   981,    -1,   941,   981,    -1,   941,
     982,    -1,   969,    -1,    -1,   227,   941,    -1,   222,   941,
      -1,   941,   227,   969,    -1,   227,   969,    -1,   969,    -1,
     867,    -1,   502,   969,   503,    -1,   129,   989,   986,   988,
     204,    -1,   987,    -1,   986,   987,    -1,   465,   941,   429,
     941,    -1,   200,   941,    -1,    -1,   941,    -1,    -1,  1131,
      -1,  1131,   992,    -1,   504,  1006,    -1,   504,   495,    -1,
     500,   941,   501,    -1,   500,   941,   507,   941,   501,    -1,
     991,    -1,   992,   991,    -1,    -1,   993,   991,    -1,   112,
      -1,    -1,   941,    -1,   181,    -1,   995,    -1,   996,   505,
     995,    -1,   502,   996,   503,    -1,   999,    -1,   998,   505,
     999,    -1,   941,   108,  1133,    -1,   941,  1153,    -1,   941,
      -1,   495,    -1,  1001,    -1,  1000,   505,  1001,    -1,  1131,
      -1,  1131,   992,    -1,  1003,    -1,  1002,   505,  1003,    -1,
    1131,    -1,  1131,    -1,  1131,    -1,  1133,    -1,  1131,    -1,
    1151,    -1,  1132,    -1,  1131,   992,    -1,  1011,    -1,  1150,
      -1,  1151,    -1,  1149,    -1,    84,    -1,  1009,  1151,    -1,
    1009,   502,   970,   503,  1151,    -1,   920,  1151,    -1,   937,
    1151,   939,    -1,   937,   502,  1011,   503,  1151,   939,    -1,
     438,    -1,   216,    -1,   319,    -1,  1145,    -1,  1143,    -1,
      86,    -1,  1131,    -1,  1011,    -1,  1145,    -1,   493,  1011,
      -1,   494,  1011,    -1,    91,    -1,    92,    -1,    93,    -1,
      94,    -1,    95,    -1,    96,    -1,    97,    -1,    98,    -1,
     100,    -1,   101,    -1,   102,    -1,   110,    -1,   111,    -1,
     113,    -1,   115,    -1,   116,    -1,   117,    -1,   124,    -1,
     125,    -1,   126,    -1,   127,    -1,   128,    -1,   131,    -1,
     132,    -1,   135,    -1,   137,    -1,   138,    -1,   139,    -1,
     140,    -1,   144,    -1,   145,    -1,   146,    -1,   147,    -1,
     149,    -1,   152,    -1,   153,    -1,   154,    -1,   155,    -1,
     156,    -1,   157,    -1,   159,    -1,   160,    -1,   161,    -1,
     163,    -1,   172,    -1,   173,    -1,   174,    -1,   175,    -1,
     177,    -1,   180,    -1,   182,    -1,   184,    -1,   185,    -1,
     186,    -1,   187,    -1,   188,    -1,   190,    -1,   191,    -1,
     192,    -1,   195,    -1,   196,    -1,   197,    -1,   198,    -1,
     199,    -1,   201,    -1,   202,    -1,   203,    -1,   205,    -1,
     206,    -1,   208,    -1,   209,    -1,   210,    -1,   211,    -1,
     213,    -1,   214,    -1,   217,    -1,   219,    -1,   221,    -1,
     223,    -1,   225,    -1,   229,    -1,   230,    -1,   231,    -1,
     233,    -1,   236,    -1,   238,    -1,   239,    -1,   241,    -1,
     242,    -1,   244,    -1,   245,    -1,   246,    -1,   248,    -1,
     249,    -1,   250,    -1,   251,    -1,   252,    -1,   253,    -1,
     255,    -1,   259,    -1,   260,    -1,   261,    -1,   267,    -1,
     270,    -1,   272,    -1,   273,    -1,   274,    -1,   275,    -1,
     276,    -1,   277,    -1,   281,    -1,   284,    -1,   285,    -1,
     286,    -1,   289,    -1,   290,    -1,   291,    -1,   292,    -1,
     293,    -1,   294,    -1,   296,    -1,   297,    -1,   299,    -1,
     300,    -1,   301,    -1,   305,    -1,   306,    -1,   307,    -1,
     308,    -1,   309,    -1,   310,    -1,   311,    -1,   313,    -1,
     315,    -1,   316,    -1,   318,    -1,   321,    -1,   323,    -1,
     324,    -1,   325,    -1,   327,    -1,   330,    -1,   331,    -1,
     332,    -1,   340,    -1,   341,    -1,   342,    -1,   343,    -1,
     344,    -1,   345,    -1,   347,    -1,   349,    -1,   352,    -1,
     353,    -1,   351,    -1,   355,    -1,   356,    -1,   357,    -1,
     358,    -1,   359,    -1,   360,    -1,   361,    -1,   363,    -1,
     364,    -1,   365,    -1,   367,    -1,   368,    -1,   369,    -1,
     370,    -1,   371,    -1,   372,    -1,   373,    -1,   374,    -1,
     375,    -1,   376,    -1,   378,    -1,   379,    -1,   381,    -1,
     382,    -1,   384,    -1,   385,    -1,   386,    -1,   387,    -1,
     388,    -1,   389,    -1,   391,    -1,   393,    -1,   394,    -1,
     395,    -1,   396,    -1,   397,    -1,   399,    -1,   401,    -1,
     402,    -1,   404,    -1,   407,    -1,   408,    -1,   409,    -1,
     410,    -1,   411,    -1,   412,    -1,   413,    -1,   414,    -1,
     415,    -1,   416,    -1,   418,    -1,   420,    -1,   421,    -1,
     423,    -1,   424,    -1,   425,    -1,   426,    -1,   427,    -1,
     428,    -1,   434,    -1,   436,    -1,   439,    -1,   440,    -1,
     441,    -1,   442,    -1,   443,    -1,   444,    -1,   447,    -1,
     448,    -1,   449,    -1,   450,    -1,   453,    -1,   454,    -1,
     455,    -1,   456,    -1,   460,    -1,   462,    -1,   463,    -1,
     464,    -1,   467,    -1,   470,    -1,   471,    -1,   472,    -1,
     473,    -1,   474,    -1,   484,    -1,   485,    -1,   118,    -1,
     119,    -1,   121,    -1,   122,    -1,   134,    -1,   141,    -1,
     178,    -1,   179,    -1,   212,    -1,   215,    -1,   220,    -1,
     234,    -1,   257,    -1,   263,    -1,   265,    -1,   279,    -1,
     302,    -1,   304,    -1,   312,    -1,   320,    -1,   322,    -1,
     335,    -1,   339,    -1,   348,    -1,   350,    -1,   362,    -1,
     383,    -1,   400,    -1,   405,    -1,   417,    -1,   430,    -1,
     431,    -1,   435,    -1,   437,    -1,   458,    -1,   475,    -1,
     476,    -1,   477,    -1,   478,    -1,   479,    -1,   480,    -1,
     481,    -1,   482,    -1,   114,    -1,   120,    -1,   148,    -1,
     162,    -1,   168,    -1,   226,    -1,   228,    -1,   243,    -1,
     256,    -1,   268,    -1,   269,    -1,   271,    -1,   280,    -1,
     282,    -1,   303,    -1,   317,    -1,   336,    -1,   337,    -1,
     338,    -1,   380,    -1,   403,    -1,   461,    -1,    99,    -1,
     103,    -1,   104,    -1,   105,    -1,   106,    -1,   107,    -1,
     108,    -1,   109,    -1,   112,    -1,   123,    -1,   129,    -1,
     130,    -1,   136,    -1,   142,    -1,   143,    -1,   151,    -1,
     158,    -1,   165,    -1,   166,    -1,   167,    -1,   169,    -1,
     170,    -1,   171,    -1,   181,    -1,   183,    -1,   189,    -1,
     193,    -1,   194,    -1,   200,    -1,   204,    -1,   207,    -1,
     216,    -1,   218,    -1,   222,    -1,   224,    -1,   227,    -1,
     232,    -1,   235,    -1,   237,    -1,   247,    -1,   254,    -1,
     264,    -1,   266,    -1,   278,    -1,   283,    -1,   287,    -1,
     288,    -1,   314,    -1,   319,    -1,   326,    -1,   328,    -1,
     329,    -1,   333,    -1,   334,    -1,   346,    -1,   354,    -1,
     366,    -1,   377,    -1,   392,    -1,   398,    -1,   406,    -1,
     419,    -1,   422,    -1,   429,    -1,   433,    -1,   438,    -1,
     446,    -1,   451,    -1,   452,    -1,   459,    -1,   465,    -1,
     466,    -1,   468,    -1,   469,    -1,    -1,  1018,  1019,    -1,
    1140,  1022,   512,   506,    -1,  1140,   512,   506,    -1,  1140,
    1042,    -1,  1047,    -1,  1159,    -1,    73,    -1,   508,    -1,
     509,    -1,    -1,   158,   580,   422,   614,   108,  1021,   866,
     618,    -1,   113,  1083,    -1,     9,   432,  1024,  1031,  1032,
      -1,     9,   432,   181,    -1,     9,  1033,    -1,   175,  1024,
      -1,  1025,  1028,  1030,    -1,  1026,   507,  1027,  1030,   496,
    1025,  1036,    -1,  1035,    -1,  1151,    -1,  1004,    -1,    -1,
    1153,  1147,    -1,    85,  1029,    -1,  1027,    -1,    -1,  1131,
      -1,  1131,   504,  1029,    -1,    74,    -1,   507,  1011,    -1,
      -1,   108,  1083,    -1,    -1,   451,  1033,    -1,    -1,  1034,
      -1,  1034,   496,  1034,    -1,  1034,    21,   124,  1034,    -1,
    1034,   452,  1034,    -1,  1012,    -1,  1151,    -1,  1145,    -1,
    1147,    -1,    85,  1037,    -1,    -1,  1131,  1038,    -1,  1131,
    1038,    85,  1037,    -1,    -1,   489,  1011,    -1,   489,  1153,
      -1,   489,  1145,    -1,  1003,    -1,  1035,    -1,   180,   863,
     864,   172,   865,   222,  1039,    -1,   211,   244,  1084,    -1,
    1043,    -1,  1054,    -1,  1056,    -1,   625,    -1,   505,   625,
      -1,    -1,   939,    -1,   483,   432,   295,    -1,   483,   432,
     390,    -1,   176,   432,   176,    -1,   298,   432,   298,    -1,
      -1,  1049,  1048,  1051,  1050,    -1,  1140,   117,   180,    34,
     506,    -1,  1140,   204,   180,    34,   506,    -1,    -1,  1052,
      -1,  1043,    -1,    73,    -1,  1052,  1043,    -1,  1052,    73,
      -1,  1056,    -1,  1053,  1056,    -1,    -1,    70,  1055,  1063,
    1079,  1135,   918,   506,    -1,    -1,  1060,  1063,  1057,  1076,
     506,    -1,    -1,  1063,  1058,  1076,   506,    -1,  1066,   506,
      -1,   507,  1011,    -1,    -1,  1061,  1062,    -1,  1061,    -1,
    1062,    -1,    56,    -1,    67,    -1,    65,    -1,    50,    -1,
      51,    -1,    69,    -1,  1072,    -1,  1068,    -1,  1064,    -1,
    1135,   502,  1044,  1045,   503,    -1,  1135,  1046,    -1,  1070,
      -1,   205,  1129,  1065,    -1,   205,  1065,    -1,   205,  1129,
      -1,   508,  1157,   509,    -1,    -1,  1070,  1067,   508,  1053,
     509,    -1,  1066,    -1,    -1,  1071,  1069,   508,  1053,   509,
      -1,    43,  1129,    -1,   445,  1129,    -1,    43,    -1,   445,
      -1,  1073,    -1,  1075,  1074,    -1,    44,    35,    -1,    44,
      35,   262,    -1,    44,    -1,    44,   262,    -1,    44,    25,
      -1,    44,    25,   262,    -1,    44,    25,    25,    -1,    44,
      25,    25,   262,    -1,    44,   133,    -1,    35,    -1,    35,
     262,    -1,   262,    -1,    25,    -1,    25,   262,    -1,    25,
      25,    -1,    25,    25,   262,    -1,     5,    -1,   133,    -1,
     197,    -1,    36,    -1,    -1,  1077,    -1,  1076,   505,  1077,
      -1,  1079,  1134,   918,  1059,  1078,    -1,    -1,   489,  1158,
      -1,    -1,   495,    -1,   495,   495,    -1,   180,   410,  1153,
      -1,    15,  1082,    -1,  1083,    -1,   164,    -1,    99,    -1,
      -1,  1004,    -1,   181,    -1,  1035,    -1,  1035,    -1,    71,
      -1,    17,   863,    -1,    17,    99,    -1,    28,   863,  1087,
      -1,    -1,  1088,    -1,   452,  1092,    -1,  1089,    -1,   452,
      37,    14,  1154,    -1,   452,    14,  1003,    -1,   266,    37,
      14,  1154,    -1,   266,    14,  1003,    -1,   266,  1003,    -1,
    1093,    -1,  1093,   505,  1092,    -1,  1094,    -1,  1145,    -1,
    1143,    -1,  1011,    -1,   493,  1011,    -1,   494,  1011,    -1,
    1150,    -1,   493,  1150,    -1,   494,  1150,    -1,  1151,    -1,
    1149,    -1,  1152,    -1,    13,   258,  1039,  1089,    -1,    13,
    1096,  1039,  1089,    -1,    13,  1096,  1039,  1090,    -1,    13,
     258,  1039,  1091,    -1,    13,  1096,  1039,  1091,    -1,    29,
      -1,    -1,     3,    14,  1154,    -1,   177,    14,  1154,    -1,
      18,    14,  1154,  1100,    -1,  1101,    -1,  1100,   505,  1101,
      -1,  1147,   489,  1106,    -1,   399,    14,  1154,  1103,    -1,
    1104,    -1,  1103,   505,  1104,    -1,  1106,   489,  1105,    -1,
    1011,    -1,  1147,    -1,    10,    -1,    18,    14,  1154,   456,
    1105,  1108,    -1,  1109,    -1,  1108,   505,  1109,    -1,  1147,
     489,  1114,    -1,   399,    14,  1154,   456,  1105,  1111,    -1,
    1112,    -1,  1111,   505,  1112,    -1,  1114,   489,  1113,    -1,
    1150,    -1,  1105,    -1,   494,  1150,    -1,   494,  1011,    -1,
    1151,    -1,     8,    -1,   174,    -1,    11,    -1,    12,    -1,
      22,    -1,    23,    -1,    24,    -1,   300,    -1,    26,    -1,
      27,    -1,   350,    -1,    31,    -1,    32,    -1,    33,    -1,
     441,    -1,   399,     4,   489,  1116,    -1,   399,     4,   432,
    1116,    -1,   328,    -1,   325,    -1,   399,   150,   432,  1083,
      -1,   399,   150,   489,  1083,    -1,   399,   150,  1083,    -1,
      -1,   441,  1119,  1135,   268,  1063,   918,  1120,    -1,    30,
      -1,    -1,    -1,    45,  1122,  1133,   268,  1063,   918,  1120,
      -1,    46,    38,  1124,    -1,    46,   314,    16,  1124,    -1,
      46,    40,  1124,    -1,   154,    -1,    39,    -1,    42,    -1,
      20,  1003,    -1,    19,   432,  1003,    -1,   194,  1003,   502,
    1141,   503,    -1,   194,     6,    -1,     7,  1003,   502,  1141,
     503,    -1,     7,  1003,    -1,  1126,    -1,  1127,    -1,     6,
      -1,     7,    -1,     8,    -1,    10,    -1,    11,    -1,    12,
      -1,    16,    -1,    19,    -1,    20,    -1,    21,    -1,    22,
      -1,    23,    -1,    24,    -1,    26,    -1,    27,    -1,    31,
      -1,    32,    -1,    33,    -1,    34,    -1,    37,    -1,    38,
      -1,    39,    -1,    40,    -1,    42,    -1,     9,    -1,    13,
      -1,    15,    -1,    28,    -1,    45,    -1,    46,    -1,     5,
      -1,    25,    -1,    29,    -1,    35,    -1,    43,    -1,    36,
      -1,    44,    -1,  1133,    -1,  1153,    -1,  1014,    -1,  1015,
      -1,  1138,    -1,  1125,    -1,  1136,    -1,   133,    -1,   457,
      -1,  1153,    -1,  1137,    -1,  1015,    -1,  1125,    -1,  1136,
      -1,   133,    -1,   457,    -1,  1153,    -1,  1137,    -1,  1016,
      -1,  1125,    -1,  1136,    -1,  1128,    -1,  1134,    -1,  1128,
      -1,   133,    -1,   164,    -1,   258,    -1,   262,    -1,   432,
      -1,   445,    -1,   457,    -1,  1136,    -1,  1138,    -1,  1135,
      -1,  1014,    -1,  1017,    -1,  1127,    -1,   150,    -1,  1153,
      -1,  1015,    -1,  1016,    -1,  1126,    -1,    50,    -1,    51,
      -1,    56,    -1,    65,    -1,    67,    -1,    70,    -1,    69,
      -1,  1014,    -1,  1138,    -1,   150,    -1,   176,    -1,   240,
      -1,   295,    -1,   298,    -1,   390,    -1,   483,    -1,  1142,
      -1,  1139,   505,  1142,    -1,    41,    -1,    -1,  1157,    -1,
    1147,  1146,    -1,  1147,    -1,  1147,  1146,    -1,  1035,    -1,
    1147,    -1,  1147,    -1,    22,  1147,    -1,    22,  1003,    -1,
      72,    -1,    87,    -1,    83,    -1,    81,    -1,    82,    -1,
      76,    -1,    77,    -1,    78,    -1,    75,    -1,    84,    -1,
      80,    -1,    71,    -1,    79,    -1,  1003,    -1,  1035,    -1,
    1160,    -1,   502,   503,    -1,   502,  1156,   503,    -1,  1155,
      -1,  1156,  1155,    -1,  1158,    -1,  1157,   505,  1158,    -1,
    1156,    -1,   508,  1157,   509,    -1,  1160,    -1,   502,    -1,
     503,    -1,   505,    -1,   506,    -1,  1153,    -1,  1011,    -1,
    1150,    -1,  1151,    -1,   495,    -1,   493,    -1,   494,    -1,
     496,    -1,   497,    -1,   319,    -1,    47,    -1,    48,    -1,
      49,    -1,    50,    -1,    51,    -1,    52,    -1,    53,    -1,
      54,    -1,    55,    -1,    56,    -1,    57,    -1,    58,    -1,
      60,    -1,    59,    -1,    61,    -1,    62,    -1,    63,    -1,
      64,    -1,    65,    -1,    66,    -1,    67,    -1,    68,    -1,
      70,    -1,    69,    -1,     5,    -1,   205,    -1,   240,    -1,
     262,    -1,    25,    -1,   295,    -1,   298,    -1,   390,    -1,
      35,    -1,    36,    -1,    43,    -1,    44,    -1,   483,    -1,
     133,    -1,   220,    -1,   432,    -1,   445,    -1,   458,    -1,
     500,    -1,   501,    -1,   489,    -1,   507,    -1,   177,  1039,
      -1,   177,   352,  1039,    -1,   177,    99,    -1,   177,   352,
      99,    -1,  1011,    -1,   502,  1162,   503,    -1,  1162,   493,
    1162,    -1,  1162,   494,  1162,    -1,  1162,   495,  1162,    -1,
    1162,   496,  1162,    -1,  1162,   497,  1162,    -1,  1151,    -1,
    1131,    -1,    -1,  1088,  1164,    -1,  1164,  1088,    -1,  1088,
      -1,  1164,    -1,   266,  1139,    -1,  1090,    -1,  1164,    -1,
    1089,    -1,    -1,  1165,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1340,  1340,  1343,  1345,  1347,  1349,  1351,  1353,  1355,
    1357,  1359,  1361,  1363,  1365,  1367,  1369,  1371,  1373,  1375,
    1377,  1379,  1381,  1383,  1385,  1403,  1405,  1407,  1409,  1411,
    1413,  1415,  1417,  1419,  1421,  1423,  1425,  1427,  1429,  1431,
    1433,  1435,  1437,  1439,  1441,  1443,  1445,  1447,  1449,  1451,
    1453,  1455,  1462,  1464,  1466,  1468,  1470,  1472,  1474,  1476,
    1478,  1480,  1482,  1484,  1486,  1488,  1490,  1492,  1494,  1496,
    1498,  1500,  1502,  1504,  1506,  1508,  1510,  1512,  1514,  1516,
    1518,  1520,  1522,  1524,  1526,  1528,  1535,  1537,  1539,  1541,
    1543,  1545,  1547,  1549,  1551,  1553,  1555,  1561,  1563,  1565,
    1567,  1569,  1571,  1573,  1575,  1577,  1583,  1593,  1597,  1605,
    1609,  1619,  1629,  1630,  1644,  1651,  1657,  1668,  1674,  1683,
    1690,  1696,  1705,  1712,  1720,  1725,  1733,  1738,  1744,  1749,
    1755,  1760,  1766,  1770,  1774,  1778,  1782,  1786,  1790,  1794,
    1798,  1802,  1806,  1810,  1814,  1818,  1822,  1826,  1830,  1834,
    1838,  1846,  1850,  1854,  1858,  1862,  1866,  1874,  1882,  1891,
    1893,  1901,  1909,  1917,  1925,  1929,  1937,  1941,  1949,  1957,
    1965,  1969,  1977,  1981,  1989,  1993,  2001,  2006,  2012,  2017,
    2023,  2027,  2031,  2035,  2039,  2043,  2051,  2055,  2059,  2067,
    2071,  2075,  2079,  2083,  2087,  2091,  2095,  2099,  2104,  2108,
    2112,  2116,  2120,  2124,  2132,  2136,  2144,  2148,  2156,  2160,
    2174,  2178,  2182,  2186,  2194,  2198,  2202,  2206,  2214,  2218,
    2222,  2226,  2230,  2234,  2238,  2246,  2250,  2255,  2261,  2265,
    2273,  2277,  2281,  2285,  2289,  2297,  2301,  2309,  2313,  2317,
    2321,  2325,  2334,  2342,  2346,  2354,  2358,  2366,  2374,  2378,
    2382,  2386,  2394,  2398,  2402,  2406,  2414,  2418,  2426,  2430,
    2434,  2438,  2442,  2446,  2450,  2454,  2458,  2462,  2466,  2470,
    2474,  2478,  2482,  2486,  2490,  2494,  2498,  2502,  2506,  2510,
    2514,  2518,  2522,  2526,  2530,  2534,  2538,  2542,  2546,  2550,
    2554,  2558,  2562,  2566,  2570,  2578,  2582,  2590,  2594,  2599,
    2605,  2610,  2616,  2624,  2629,  2635,  2639,  2647,  2651,  2655,
    2659,  2667,  2672,  2680,  2691,  2702,  2706,  2714,  2718,  2722,
    2730,  2734,  2742,  2747,  2753,  2757,  2761,  2765,  2769,  2773,
    2777,  2781,  2785,  2789,  2793,  2801,  2806,  2812,  2817,  2823,
    2828,  2834,  2839,  2845,  2849,  2857,  2865,  2869,  2873,  2877,
    2882,  2888,  2892,  2900,  2908,  2912,  2920,  2924,  2928,  2932,
    2936,  2940,  2945,  2951,  2956,  2962,  2967,  2973,  2977,  2985,
    2989,  2997,  3001,  3005,  3013,  3017,  3025,  3033,  3041,  3046,
    3052,  3056,  3060,  3068,  3072,  3076,  3080,  3084,  3088,  3092,
    3100,  3104,  3108,  3112,  3120,  3128,  3132,  3137,  3143,  3147,
    3151,  3155,  3159,  3163,  3171,  3175,  3183,  3188,  3192,  3196,
    3200,  3208,  3213,  3219,  3223,  3231,  3239,  3243,  3248,  3253,
    3259,  3263,  3271,  3275,  3283,  3288,  3294,  3298,  3302,  3306,
    3311,  3317,  3325,  3333,  3337,  3341,  3345,  3349,  3357,  3362,
    3368,  3372,  3376,  3381,  3387,  3391,  3395,  3400,  3406,  3411,
    3417,  3422,  3428,  3436,  3441,  3447,  3451,  3459,  3467,  3471,
    3476,  3482,  3490,  3498,  3503,  3509,  3513,  3521,  3525,  3529,
    3533,  3537,  3541,  3545,  3549,  3553,  3557,  3561,  3565,  3573,
    3578,  3584,  3588,  3592,  3600,  3604,  3612,  3616,  3624,  3629,
    3635,  3639,  3647,  3652,  3658,  3662,  3670,  3675,  3681,  3685,
    3693,  3698,  3704,  3712,  3717,  3723,  3727,  3735,  3743,  3747,
    3755,  3759,  3763,  3771,  3776,  3782,  3786,  3794,  3802,  3806,
    3814,  3818,  3822,  3826,  3834,  3842,  3850,  3858,  3866,  3871,
    3877,  3881,  3889,  3894,  3900,  3904,  3912,  3916,  3920,  3928,
    3936,  3940,  3944,  3952,  3956,  3964,  3972,  3976,  3984,  3988,
    3996,  4000,  4008,  4012,  4016,  4020,  4024,  4032,  4037,  4043,
    4048,  4054,  4058,  4066,  4071,  4077,  4081,  4086,  4092,  4096,
    4100,  4104,  4108,  4112,  4120,  4125,  4131,  4135,  4142,  4146,
    4154,  4160,  4164,  4172,  4176,  4184,  4188,  4196,  4205,  4214,
    4218,  4222,  4226,  4230,  4234,  4238,  4242,  4246,  4250,  4254,
    4262,  4270,  4274,  4282,  4286,  4294,  4298,  4302,  4306,  4310,
    4318,  4322,  4330,  4338,  4342,  4350,  4358,  4363,  4369,  4373,
    4381,  4389,  4393,  4401,  4405,  4409,  4413,  4417,  4425,  4430,
    4436,  4441,  4447,  4453,  4459,  4467,  4471,  4479,  4483,  4491,
    4495,  4503,  4507,  4515,  4519,  4527,  4535,  4543,  4547,  4555,
    4559,  4563,  4567,  4571,  4575,  4579,  4583,  4587,  4591,  4595,
    4599,  4607,  4611,  4619,  4623,  4631,  4635,  4643,  4651,  4655,
    4660,  4666,  4670,  4674,  4678,  4682,  4686,  4690,  4694,  4698,
    4702,  4706,  4710,  4714,  4718,  4722,  4726,  4730,  4738,  4742,
    4746,  4750,  4754,  4758,  4762,  4766,  4770,  4774,  4778,  4782,
    4790,  4794,  4802,  4806,  4810,  4814,  4820,  4826,  4832,  4838,
    4844,  4850,  4856,  4866,  4877,  4888,  4899,  4910,  4921,  4932,
    4948,  4964,  4980,  4991,  5007,  5018,  5034,  5049,  5053,  5061,
    5066,  5072,  5080,  5084,  5092,  5096,  5100,  5104,  5108,  5116,
    5120,  5128,  5132,  5136,  5140,  5148,  5152,  5156,  5160,  5164,
    5168,  5172,  5176,  5180,  5184,  5188,  5192,  5196,  5200,  5208,
    5212,  5220,  5224,  5232,  5237,  5243,  5247,  5255,  5263,  5271,
    5275,  5283,  5288,  5294,  5299,  5305,  5313,  5318,  5324,  5328,
    5332,  5340,  5344,  5348,  5356,  5360,  5364,  5372,  5380,  5385,
    5391,  5396,  5402,  5407,  5413,  5418,  5424,  5428,  5436,  5440,
    5444,  5452,  5456,  5461,  5467,  5471,  5476,  5482,  5486,  5491,
    5497,  5501,  5505,  5513,  5518,  5524,  5528,  5536,  5540,  5548,
    5552,  5560,  5564,  5572,  5576,  5580,  5584,  5588,  5596,  5600,
    5604,  5608,  5612,  5620,  5628,  5636,  5640,  5644,  5652,  5656,
    5660,  5668,  5672,  5680,  5684,  5688,  5692,  5696,  5700,  5704,
    5708,  5712,  5716,  5720,  5724,  5728,  5736,  5740,  5744,  5748,
    5756,  5760,  5768,  5773,  5779,  5787,  5791,  5799,  5807,  5811,
    5819,  5824,  5830,  5834,  5842,  5846,  5854,  5858,  5866,  5870,
    5874,  5878,  5886,  5890,  5898,  5906,  5910,  5918,  5922,  5930,
    5934,  5938,  5946,  5950,  5955,  5961,  5969,  5974,  5980,  5984,
    5988,  5996,  6000,  6008,  6013,  6019,  6023,  6027,  6031,  6035,
    6039,  6043,  6047,  6051,  6055,  6059,  6063,  6067,  6071,  6075,
    6079,  6083,  6087,  6091,  6095,  6099,  6103,  6107,  6111,  6115,
    6123,  6128,  6134,  6139,  6145,  6149,  6153,  6157,  6161,  6165,
    6169,  6177,  6181,  6185,  6189,  6193,  6197,  6201,  6205,  6209,
    6213,  6217,  6221,  6225,  6229,  6233,  6237,  6241,  6249,  6257,
    6261,  6265,  6273,  6277,  6285,  6289,  6293,  6297,  6301,  6309,
    6314,  6320,  6324,  6328,  6332,  6340,  6344,  6349,  6355,  6359,
    6367,  6375,  6380,  6386,  6394,  6398,  6406,  6410,  6414,  6418,
    6422,  6426,  6430,  6434,  6438,  6442,  6446,  6450,  6454,  6458,
    6466,  6470,  6475,  6481,  6485,  6489,  6497,  6501,  6505,  6513,
    6518,  6524,  6528,  6536,  6541,  6546,  6552,  6558,  6566,  6574,
    6579,  6585,  6589,  6593,  6597,  6601,  6605,  6609,  6613,  6617,
    6621,  6625,  6629,  6633,  6637,  6641,  6645,  6653,  6658,  6664,
    6668,  6676,  6684,  6689,  6695,  6703,  6707,  6715,  6723,  6727,
    6731,  6735,  6739,  6747,  6752,  6758,  6766,  6770,  6774,  6778,
    6782,  6786,  6794,  6802,  6806,  6810,  6818,  6823,  6829,  6833,
    6837,  6841,  6845,  6853,  6857,  6865,  6869,  6873,  6877,  6885,
    6889,  6897,  6901,  6909,  6914,  6920,  6925,  6931,  6936,  6942,
    6947,  6953,  6957,  6961,  6965,  6973,  6977,  6981,  6985,  6989,
    6993,  6997,  7005,  7009,  7017,  7025,  7029,  7033,  7041,  7045,
    7050,  7056,  7062,  7072,  7077,  7083,  7087,  7091,  7095,  7103,
    7105,  7113,  7118,  7124,  7132,  7136,  7140,  7148,  7152,  7160,
    7168,  7173,  7179,  7187,  7192,  7198,  7206,  7211,  7217,  7221,
    7225,  7229,  7233,  7237,  7241,  7245,  7253,  7258,  7264,  7272,
    7276,  7284,  7288,  7296,  7304,  7312,  7320,  7324,  7332,  7384,
    7388,  7401,  7403,  7407,  7411,  7415,  7424,  7430,  7434,  7442,
    7446,  7454,  7458,  7466,  7470,  7474,  7478,  7482,  7486,  7490,
    7494,  7502,  7506,  7514,  7518,  7522,  7526,  7530,  7534,  7542,
    7546,  7554,  7558,  7566,  7574,  7579,  7581,  7587,  7591,  7595,
    7599,  7603,  7607,  7611,  7615,  7623,  7628,  7634,  7638,  7643,
    7649,  7653,  7657,  7662,  7668,  7673,  7679,  7687,  7691,  7699,
    7703,  7711,  7715,  7719,  7723,  7731,  7736,  7742,  7746,  7751,
    7759,  7763,  7771,  7775,  7783,  7791,  7795,  7800,  7806,  7814,
    7818,  7826,  7830,  7838,  7843,  7849,  7854,  7860,  7864,  7872,
    7877,  7883,  7887,  7895,  7899,  7907,  7912,  7918,  7922,  7930,
    7935,  7941,  7945,  7953,  7957,  7961,  7965,  7969,  7973,  7977,
    7981,  7987,  7991,  7995,  8003,  8007,  8011,  8015,  8019,  8023,
    8031,  8035,  8039,  8043,  8051,  8055,  8059,  8063,  8071,  8076,
    8082,  8086,  8094,  8098,  8102,  8106,  8114,  8118,  8126,  8130,
    8134,  8142,  8150,  8155,  8161,  8165,  8170,  8176,  8180,  8188,
    8196,  8198,  8200,  8204,  8208,  8212,  8220,  8230,  8241,  8250,
    8254,  8258,  8262,  8266,  8270,  8274,  8282,  8286,  8290,  8294,
    8302,  8306,  8314,  8319,  8325,  8329,  8333,  8337,  8341,  8345,
    8349,  8353,  8357,  8361,  8365,  8373,  8378,  8384,  8388,  8396,
    8400,  8408,  8416,  8424,  8428,  8436,  8440,  8448,  8456,  8464,
    8468,  8472,  8476,  8480,  8484,  8492,  8497,  8503,  8508,  8514,
    8518,  8522,  8526,  8534,  8542,  8546,  8551,  8557,  8561,  8565,
    8569,  8573,  8577,  8581,  8585,  8589,  8593,  8597,  8601,  8605,
    8610,  8616,  8620,  8628,  8632,  8636,  8640,  8644,  8648,  8652,
    8656,  8660,  8664,  8668,  8672,  8676,  8680,  8684,  8688,  8692,
    8696,  8700,  8704,  8708,  8712,  8716,  8720,  8724,  8728,  8732,
    8736,  8740,  8744,  8748,  8752,  8756,  8760,  8764,  8768,  8772,
    8776,  8780,  8784,  8788,  8792,  8796,  8800,  8804,  8808,  8812,
    8816,  8820,  8824,  8828,  8832,  8836,  8840,  8844,  8848,  8853,
    8857,  8865,  8869,  8873,  8877,  8881,  8885,  8889,  8893,  8897,
    8901,  8905,  8909,  8913,  8917,  8921,  8925,  8929,  8933,  8937,
    8941,  8945,  8949,  8957,  8961,  8965,  8969,  8973,  8977,  8981,
    8985,  8989,  8993,  8997,  9005,  9009,  9013,  9017,  9021,  9025,
    9029,  9033,  9037,  9041,  9045,  9049,  9053,  9057,  9061,  9065,
    9069,  9073,  9077,  9081,  9085,  9089,  9093,  9097,  9101,  9105,
    9109,  9113,  9117,  9121,  9125,  9129,  9133,  9137,  9141,  9145,
    9149,  9153,  9157,  9161,  9165,  9169,  9173,  9177,  9181,  9185,
    9189,  9193,  9201,  9205,  9213,  9217,  9221,  9226,  9232,  9240,
    9244,  9252,  9256,  9264,  9268,  9276,  9280,  9285,  9291,  9296,
    9302,  9306,  9314,  9322,  9326,  9331,  9337,  9345,  9349,  9356,
    9361,  9367,  9372,  9377,  9383,  9387,  9395,  9399,  9403,  9407,
    9411,  9419,  9423,  9427,  9435,  9439,  9443,  9451,  9455,  9463,
    9467,  9471,  9475,  9479,  9483,  9487,  9491,  9495,  9503,  9507,
    9515,  9519,  9527,  9531,  9535,  9539,  9543,  9547,  9555,  9559,
    9567,  9571,  9579,  9583,  9591,  9595,  9603,  9607,  9611,  9619,
    9623,  9631,  9636,  9642,  9646,  9650,  9654,  9658,  9662,  9666,
    9670,  9678,  9682,  9690,  9698,  9703,  9709,  9713,  9717,  9721,
    9725,  9730,  9736,  9744,  9752,  9756,  9760,  9768,  9772,  9780,
    9788,  9792,  9800,  9808,  9813,  9819,  9824,  9830,  9834,  9842,
    9846,  9850,  9854,  9862,  9866,  9875,  9877,  9885,  9890,  9896,
    9900,  9908,  9912,  9920,  9928,  9932,  9940,  9944,  9948,  9952,
    9960,  9964,  9972,  9976,  9984,  9988,  9996, 10004, 10012, 10020,
   10028, 10036, 10044, 10048, 10056, 10060, 10064, 10068, 10072, 10076,
   10080, 10084, 10088, 10092, 10096, 10100, 10104, 10108, 10109, 10114,
   10120, 10128, 10132, 10133, 10137, 10145, 10149, 10153, 10157, 10161,
   10165, 10169, 10173, 10177, 10181, 10185, 10189, 10193, 10197, 10201,
   10205, 10209, 10213, 10217, 10221, 10225, 10229, 10233, 10237, 10241,
   10245, 10249, 10253, 10257, 10261, 10265, 10269, 10273, 10277, 10281,
   10285, 10289, 10293, 10297, 10301, 10305, 10309, 10313, 10317, 10321,
   10325, 10329, 10333, 10337, 10341, 10345, 10349, 10353, 10357, 10361,
   10365, 10369, 10373, 10377, 10381, 10385, 10389, 10393, 10397, 10401,
   10405, 10409, 10413, 10417, 10421, 10425, 10429, 10433, 10437, 10441,
   10445, 10449, 10453, 10457, 10461, 10465, 10469, 10473, 10477, 10481,
   10485, 10489, 10493, 10497, 10501, 10505, 10509, 10513, 10517, 10521,
   10525, 10529, 10533, 10537, 10541, 10545, 10549, 10553, 10557, 10561,
   10565, 10569, 10573, 10577, 10581, 10585, 10589, 10593, 10597, 10601,
   10605, 10609, 10613, 10617, 10621, 10625, 10629, 10633, 10637, 10641,
   10645, 10649, 10653, 10657, 10661, 10665, 10669, 10673, 10677, 10681,
   10685, 10689, 10693, 10697, 10701, 10705, 10709, 10713, 10717, 10721,
   10725, 10729, 10733, 10737, 10741, 10745, 10749, 10753, 10757, 10761,
   10765, 10769, 10773, 10777, 10781, 10785, 10789, 10793, 10797, 10801,
   10805, 10809, 10813, 10817, 10821, 10825, 10829, 10833, 10837, 10841,
   10845, 10849, 10853, 10857, 10861, 10865, 10869, 10873, 10877, 10881,
   10885, 10889, 10893, 10897, 10901, 10905, 10909, 10913, 10917, 10921,
   10925, 10929, 10933, 10937, 10941, 10945, 10949, 10953, 10957, 10961,
   10965, 10969, 10973, 10977, 10981, 10985, 10989, 10993, 10997, 11001,
   11005, 11009, 11013, 11017, 11021, 11025, 11029, 11033, 11037, 11041,
   11045, 11049, 11053, 11057, 11061, 11065, 11069, 11073, 11077, 11081,
   11085, 11089, 11093, 11097, 11101, 11105, 11109, 11117, 11121, 11125,
   11129, 11133, 11137, 11141, 11145, 11149, 11153, 11157, 11161, 11165,
   11169, 11173, 11177, 11181, 11185, 11189, 11193, 11197, 11201, 11205,
   11209, 11213, 11217, 11221, 11225, 11229, 11233, 11237, 11241, 11245,
   11249, 11253, 11257, 11261, 11265, 11269, 11273, 11277, 11281, 11285,
   11293, 11297, 11301, 11305, 11309, 11313, 11317, 11321, 11325, 11329,
   11333, 11337, 11341, 11345, 11349, 11353, 11357, 11361, 11365, 11369,
   11373, 11377, 11385, 11389, 11393, 11397, 11401, 11405, 11409, 11413,
   11417, 11421, 11425, 11429, 11433, 11437, 11441, 11445, 11449, 11453,
   11457, 11461, 11465, 11469, 11473, 11477, 11481, 11485, 11489, 11493,
   11497, 11501, 11505, 11509, 11513, 11517, 11521, 11525, 11529, 11533,
   11537, 11541, 11545, 11549, 11553, 11557, 11561, 11565, 11569, 11573,
   11577, 11581, 11585, 11589, 11593, 11597, 11601, 11605, 11609, 11613,
   11617, 11621, 11625, 11629, 11633, 11637, 11641, 11645, 11649, 11653,
   11657, 11661, 11665, 11669, 11673, 11677, 11687, 11688, 11691, 11692,
   11693, 11699, 11700, 11701, 11702, 11703, 11716, 11716, 11725, 11741,
   11743, 11746, 11748, 11752, 11764, 11780, 11784, 11795, 11796, 11799,
   11811, 11820, 11821, 11824, 11825, 11826, 11829, 11830, 11833, 11834,
   11837, 11838, 11841, 11843, 11845, 11847, 11851, 11858, 11865, 11881,
   11915, 11925, 11928, 11930, 11943, 11944, 11946, 11948, 11952, 11965,
   11972, 12032, 12041, 12043, 12044, 12047, 12049, 12050, 12053, 12054,
   12055, 12056, 12057, 12064, 12063, 12073, 12075, 12077, 12078, 12081,
   12082, 12083, 12084, 12087, 12088, 12092, 12091, 12108, 12106, 12122,
   12121, 12135, 12141, 12142, 12145, 12147, 12148, 12151, 12152, 12153,
   12154, 12157, 12158, 12161, 12169, 12186, 12194, 12217, 12323, 12357,
   12359, 12361, 12365, 12369, 12368, 12419, 12421, 12420, 12435, 12441,
   12448, 12453, 12456, 12457, 12460, 12461, 12462, 12463, 12464, 12465,
   12466, 12474, 12482, 12485, 12486, 12487, 12488, 12489, 12490, 12498,
   12506, 12507, 12508, 12511, 12512, 12515, 12517, 12521, 12609, 12610,
   12617, 12618, 12619, 12625, 12634, 12637, 12638, 12639, 12640, 12643,
   12644, 12645, 12648, 12650, 12658, 12659, 12665, 12673, 12674, 12677,
   12678, 12681, 12686, 12693, 12698, 12705, 12712, 12712, 12714, 12721,
   12722, 12725, 12726, 12727, 12728, 12729, 12730, 12731, 12732, 12733,
   12739, 12746, 12758, 12764, 12771, 12779, 12780, 12792, 12803, 12814,
   12818, 12819, 12822, 12827, 12831, 12832, 12835, 12841, 12849, 12852,
   12859, 12863, 12864, 12867, 12870, 12874, 12875, 12878, 12884, 12892,
   12893, 12902, 12911, 12923, 12924, 12925, 12926, 12927, 12928, 12929,
   12930, 12931, 12932, 12933, 12934, 12935, 12936, 12937, 12944, 12945,
   12948, 12949, 12956, 12957, 12958, 12965, 12964, 12981, 12982, 12989,
   12988, 13058, 13064, 13070, 13078, 13084, 13090, 13096, 13102, 13108,
   13114, 13120, 13126, 13137, 13138, 13141, 13142, 13143, 13144, 13145,
   13146, 13147, 13148, 13149, 13150, 13151, 13152, 13153, 13154, 13155,
   13156, 13157, 13158, 13159, 13160, 13161, 13162, 13163, 13164, 13167,
   13168, 13169, 13170, 13171, 13172, 13176, 13177, 13178, 13179, 13180,
   13181, 13182, 13185, 13188, 13189, 13190, 13191, 13192, 13193, 13194,
   13195, 13208, 13209, 13210, 13211, 13212, 13213, 13214, 13219, 13220,
   13221, 13222, 13223, 13224, 13230, 13231, 13232, 13233, 13234, 13235,
   13236, 13237, 13238, 13239, 13240, 13243, 13244, 13245, 13246, 13247,
   13250, 13251, 13252, 13253, 13256, 13257, 13258, 13259, 13260, 13261,
   13262, 13279, 13280, 13281, 13284, 13285, 13286, 13287, 13288, 13289,
   13293, 13293, 13296, 13302, 13303, 13306, 13308, 13313, 13323, 13334,
   13341, 13342, 13343, 13346, 13379, 13381, 13383, 13386, 13396, 13406,
   13416, 13417, 13420, 13422, 13423, 13424, 13427, 13429, 13437, 13438,
   13439, 13443, 13444, 13448, 13449, 13452, 13453, 13456, 13457, 13458,
   13459, 13460, 13463, 13464, 13465, 13466, 13467, 13468, 13469, 13470,
   13471, 13472, 13473, 13474, 13475, 13476, 13477, 13478, 13479, 13480,
   13481, 13482, 13483, 13484, 13485, 13486, 13487, 13488, 13489, 13490,
   13491, 13492, 13493, 13494, 13495, 13496, 13497, 13498, 13499, 13500,
   13501, 13502, 13503, 13504, 13505, 13506, 13507, 13508, 13509, 13510,
   13511, 13512, 13513, 13514, 13515, 13516, 13517, 13518, 13521, 13522,
   13523, 13524, 13527, 13528, 13529, 13530, 13531, 13532, 13533, 13534,
   13535, 13538, 13539, 13540, 13541, 13542, 13545, 13546, 13549, 13550,
   13561, 13562
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", 
  "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP", 
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST", 
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST", 
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", 
  "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", 
  "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", "AUTHORIZATION", 
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", 
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED", 
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMENTS", "COMMIT", 
  "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION", 
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P", 
  "COPY", "COST", "CREATE", "CREATEDB", "CREATEROLE", "CREATEUSER", 
  "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG", "CURRENT_DATE", 
  "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P", "DATABASE", "DAY_P", 
  "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", 
  "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", 
  "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD", "DISTINCT", 
  "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", 
  "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE", 
  "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS", 
  "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", "FAMILY", "FETCH", 
  "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", "FOREIGN", "FORWARD", 
  "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS", "GLOBAL", "GRANT", 
  "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", "HEADER_P", 
  "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P", 
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", 
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", 
  "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", "LEFT", "LEVEL", 
  "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", 
  "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", "MAPPING", "MATCH", 
  "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P", 
  "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOCREATEDB", 
  "NOCREATEROLE", "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P", "NONE", 
  "NOSUPERUSER", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", 
  "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", "OBJECT_P", "OF", "OFF", 
  "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR", "OPTION", "OPTIONS", "OR", 
  "ORDER", "OUT_P", "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", "OWNED", 
  "OWNER", "PARSER", "PARTIAL", "PARTITION", "PASSWORD", "PLACING", 
  "PLANS", "POSITION", "PRECEDING", "PRECISION", "PRESERVE", "PREPARE", 
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", 
  "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE", 
  "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "REPLICA", "RESET", "RESTART", "RESTRICT", 
  "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW", 
  "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", 
  "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER", 
  "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", 
  "SIMPLE", "SMALLINT", "SOME", "STABLE", "STANDALONE_P", "START", 
  "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", 
  "STRIP_P", "SUBSTRING", "SUPERUSER_P", "SYMMETRIC", "SYSID", "SYSTEM_P", 
  "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", 
  "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRANSACTION", 
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", 
  "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", 
  "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", 
  "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", "VARIADIC", "VARYING", 
  "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE", 
  "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK", "WRAPPER", "WRITE", 
  "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLFOREST", 
  "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P", 
  "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME", "'='", "'<'", "'>'", 
  "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", 
  "']'", "'('", "')'", "'.'", "','", "';'", "':'", "'{'", "'}'", 
  "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList", 
  "AlterOptRoleList", "AlterOptRoleElem", "CreateOptRoleElem", 
  "CreateUserStmt", "AlterRoleStmt", "opt_in_database", 
  "AlterRoleSetStmt", "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", 
  "DropUserStmt", "CreateGroupStmt", "AlterGroupStmt", "add_drop", 
  "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName", 
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest", 
  "var_name", "var_list", "var_value", "iso_level", 
  "opt_boolean_or_string", "zone_value", "opt_encoding", 
  "ColId_or_Sconst", "VariableResetStmt", "SetResetClause", 
  "VariableShowStmt", "ConstraintsSetStmt", "constraints_set_list", 
  "constraints_set_mode", "CheckPointStmt", "DiscardStmt", 
  "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "reloptions", "opt_reloptions", "reloption_list", "reloption_elem", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_options", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "copy_generic_opt_list", 
  "copy_generic_opt_elem", "copy_generic_opt_arg", 
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item", 
  "CreateStmt", "OptTemp", "OptTableElementList", 
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList", 
  "TableElement", "TypedTableElement", "columnDef", "columnOptions", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "ExclusionConstraintList", 
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions", 
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith", 
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", 
  "create_as_target", "OptCreateAs", "CreateAsList", "CreateAsElement", 
  "opt_with_data", "CreateSeqStmt", "AlterSeqStmt", "OptSeqOptList", 
  "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly", "NumericOnly_list", 
  "CreatePLangStmt", "opt_trusted", "handler_name", "opt_inline_handler", 
  "validator_clause", "opt_validator", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateFdwStmt", "DropFdwStmt", "AlterFdwStmt", 
  "create_generic_options", "generic_option_list", 
  "alter_generic_options", "alter_generic_option_list", 
  "alter_generic_option_elem", "generic_option_elem", 
  "generic_option_name", "generic_option_arg", "CreateForeignServerStmt", 
  "opt_type", "foreign_server_version", "opt_foreign_server_version", 
  "DropForeignServerStmt", "AlterForeignServerStmt", 
  "CreateUserMappingStmt", "auth_ident", "DropUserMappingStmt", 
  "AlterUserMappingStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerWhen", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "opt_enum_val_list", "enum_val_list", 
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default", 
  "opt_opfamily", "opt_recheck", "CreateOpFamilyStmt", 
  "AlterOpFamilyStmt", "opclass_drop_list", "opclass_drop", 
  "DropOpClassStmt", "DropOpFamilyStmt", "DropOwnedStmt", 
  "ReassignOwnedStmt", "DropStmt", "drop_type", "any_name_list", 
  "any_name", "attrs", "TruncateStmt", "opt_restart_seqs", "CommentStmt", 
  "comment_type", "comment_text", "FetchStmt", "fetch_args", "from_in", 
  "opt_from_in", "GrantStmt", "RevokeStmt", "privileges", 
  "privilege_list", "privilege", "privilege_target", "grantee_list", 
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt", 
  "opt_grant_admin_option", "opt_granted_by", 
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption", 
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique", 
  "opt_concurrently", "opt_index_name", "access_method_clause", 
  "index_params", "index_elem", "opt_class", "opt_asc_desc", 
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args", 
  "func_args_list", "func_args_with_defaults", 
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name", 
  "func_return", "func_type", "func_arg_with_default", 
  "createfunc_opt_list", "common_func_opt_item", "createfunc_opt_item", 
  "func_as", "opt_definition", "table_func_column", 
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list", 
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list", 
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt", 
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force", 
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt", 
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti", 
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead", 
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt", 
  "UnlistenStmt", "TransactionStmt", "opt_transaction", 
  "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "vacuum_option_list", "vacuum_option_elem", "AnalyzeStmt", 
  "analyze_keyword", "opt_verbose", "opt_full", "opt_freeze", 
  "opt_name_list", "ExplainStmt", "ExplainableStmt", 
  "explain_option_list", "explain_option_elem", "explain_option_name", 
  "explain_option_arg", "PrepareStmt", "prep_type_clause", 
  "PreparableStmt", "ExecuteStmt", "execute_param_clause", "InsertStmt", 
  "insert_rest", "insert_column_list", "insert_column_item", 
  "returning_clause", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", "set_clause_list", 
  "set_clause", "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options", 
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens", 
  "select_clause", "simple_select", "with_clause", "cte_list", 
  "common_table_expr", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "limit_clause", "offset_clause", "select_limit_value", 
  "select_offset_value", "opt_select_fetch_first_value", 
  "select_offset_value2", "row_or_rows", "first_or_next", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_list", "relation_expr_opt_alias", 
  "func_table", "where_clause", "where_or_current_clause", 
  "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType", 
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr", 
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "window_clause", 
  "window_definition_list", "window_definition", "over_clause", 
  "window_specification", "opt_existing_window_name", 
  "opt_partition_clause", "opt_frame_clause", "frame_extent", 
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list", 
  "func_arg_expr", "type_list", "array_expr", "array_expr_list", 
  "extract_list", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_asymmetric", "ctext_expr", 
  "ctext_expr_list", "ctext_row", "target_list", "target_el", 
  "qualified_name_list", "qualified_name", "name_list", "name", 
  "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "RoleId", 
  "SignedIconst", "unreserved_keyword", "col_name_keyword", 
  "type_func_name_keyword", "reserved_keyword", "statements", "statement", 
  "CreateAsStmt", "@1", "at", "ECPGConnect", "connection_target", 
  "opt_database_name", "db_prefix", "server", "opt_server", "server_name", 
  "opt_port", "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "connect_options", "opt_opt_value", 
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt", 
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale", 
  "ecpg_interval", "ECPGDeclaration", "@2", "sql_startdeclare", 
  "sql_enddeclare", "var_type_declarations", "vt_declarations", 
  "variable_declarations", "type_declaration", "@3", "var_declaration", 
  "@4", "@5", "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@6", "struct_union_type", "@7", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execstring", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list", 
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item", 
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem", 
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem", 
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off", 
  "ECPGSetConnection", "ECPGTypedef", "@8", "opt_reference", "ECPGVar", 
  "@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames", 
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId", 
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon", 
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param", 
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", 
  "ecpg_ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", 
  "c_list", "c_term", "c_thing", "c_anything", "DeallocateStmt", 
  "Iresult", "execute_rest", "ecpg_into", "ecpg_fetch_into", 
  "opt_ecpg_fetch_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,    61,
      60,    62,   744,    43,    45,    42,    47,    37,    94,   745,
      91,    93,    40,    41,    46,    44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   510,   511,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   513,   514,   514,   515,   515,
     516,   516,   517,   517,   517,   517,   517,   517,   517,   517,
     517,   517,   517,   517,   517,   517,   517,   517,   517,   517,
     517,   518,   518,   518,   518,   518,   518,   519,   520,   521,
     521,   522,   523,   524,   525,   525,   526,   526,   527,   528,
     529,   529,   530,   530,   531,   531,   532,   532,   533,   533,
     534,   534,   534,   534,   534,   534,   535,   535,   535,   536,
     536,   536,   536,   536,   536,   536,   536,   536,   536,   536,
     536,   536,   536,   536,   537,   537,   538,   538,   539,   539,
     540,   540,   540,   540,   541,   541,   541,   541,   542,   542,
     542,   542,   542,   542,   542,   543,   543,   543,   544,   544,
     545,   545,   545,   545,   545,   546,   546,   547,   547,   547,
     547,   547,   548,   549,   549,   550,   550,   551,   552,   552,
     552,   552,   553,   553,   553,   553,   554,   554,   555,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   556,   556,   557,   557,   557,
     558,   558,   559,   560,   560,   561,   561,   562,   562,   562,
     562,   563,   563,   564,   564,   565,   565,   566,   566,   566,
     567,   567,   568,   568,   569,   569,   569,   569,   569,   569,
     569,   569,   569,   569,   569,   570,   570,   571,   571,   572,
     572,   573,   573,   574,   574,   575,   576,   576,   576,   576,
     576,   577,   577,   578,   579,   579,   580,   580,   580,   580,
     580,   580,   580,   581,   581,   582,   582,   583,   583,   584,
     584,   585,   585,   585,   586,   586,   587,   588,   589,   589,
     590,   590,   590,   591,   591,   591,   591,   591,   591,   591,
     592,   592,   592,   592,   593,   594,   594,   594,   595,   595,
     595,   595,   595,   595,   596,   596,   597,   597,   597,   597,
     597,   598,   598,   599,   599,   600,   601,   601,   601,   601,
     602,   602,   603,   603,   604,   604,   605,   605,   605,   605,
     605,   606,   607,   608,   608,   608,   608,   608,   609,   609,
     610,   610,   610,   610,   611,   611,   611,   611,   612,   612,
     613,   613,   614,   615,   615,   616,   616,   617,   618,   618,
     618,   619,   620,   621,   621,   622,   622,   623,   623,   623,
     623,   623,   623,   623,   623,   623,   623,   623,   623,   624,
     624,   625,   625,   625,   626,   626,   627,   627,   628,   628,
     629,   629,   630,   630,   631,   631,   632,   632,   633,   633,
     634,   634,   635,   636,   636,   637,   637,   638,   639,   639,
     640,   640,   640,   641,   641,   642,   642,   643,   644,   644,
     645,   645,   645,   645,   646,   647,   648,   649,   650,   650,
     651,   651,   652,   652,   653,   653,   654,   654,   654,   655,
     656,   656,   656,   657,   657,   658,   659,   659,   660,   660,
     661,   661,   662,   662,   662,   662,   662,   663,   663,   664,
     664,   665,   665,   666,   666,   667,   667,   667,   668,   668,
     668,   668,   668,   668,   669,   669,   670,   670,   670,   670,
     670,   671,   671,   672,   672,   673,   673,   674,   675,   676,
     676,   676,   676,   676,   676,   676,   676,   676,   676,   676,
     677,   678,   678,   679,   679,   680,   680,   680,   680,   680,
     681,   681,   682,   683,   683,   684,   685,   685,   686,   686,
     687,   688,   688,   689,   689,   689,   689,   689,   690,   690,
     691,   691,   692,   692,   693,   694,   694,   695,   695,   696,
     696,   697,   697,   698,   698,   699,   700,   701,   701,   702,
     702,   702,   702,   702,   702,   702,   702,   702,   702,   702,
     702,   703,   703,   704,   704,   705,   705,   706,   707,   707,
     707,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   708,   708,   708,   708,   708,   708,   708,   709,   709,
     709,   709,   709,   709,   709,   709,   709,   709,   709,   709,
     710,   710,   711,   711,   711,   711,   711,   711,   711,   711,
     711,   711,   711,   712,   712,   712,   712,   712,   712,   712,
     712,   712,   712,   712,   712,   712,   712,   713,   713,   714,
     714,   715,   716,   716,   717,   717,   717,   717,   717,   718,
     718,   719,   719,   719,   719,   720,   720,   720,   720,   720,
     720,   720,   720,   720,   720,   720,   720,   720,   720,   721,
     721,   722,   722,   723,   723,   724,   724,   725,   726,   727,
     727,   728,   728,   729,   729,   730,   731,   731,   732,   732,
     732,   733,   733,   733,   734,   734,   734,   735,   736,   736,
     737,   737,   738,   738,   739,   739,   740,   740,   741,   741,
     741,   742,   742,   742,   743,   743,   743,   744,   744,   744,
     745,   745,   745,   746,   746,   747,   747,   748,   748,   749,
     749,   750,   750,   751,   751,   751,   751,   751,   752,   752,
     752,   752,   752,   753,   754,   755,   755,   755,   756,   756,
     756,   757,   757,   758,   758,   758,   758,   758,   758,   758,
     758,   758,   758,   758,   758,   758,   759,   759,   759,   759,
     760,   760,   761,   761,   762,   763,   763,   764,   765,   765,
     766,   766,   767,   767,   768,   768,   769,   769,   770,   770,
     770,   770,   771,   771,   772,   773,   773,   774,   774,   775,
     775,   775,   776,   776,   776,   777,   778,   778,   779,   779,
     779,   780,   780,   781,   781,   782,   782,   782,   782,   782,
     782,   782,   782,   782,   782,   782,   782,   782,   782,   782,
     782,   782,   782,   782,   782,   782,   782,   782,   782,   782,
     783,   783,   784,   784,   785,   785,   785,   785,   785,   785,
     785,   786,   786,   786,   786,   786,   786,   786,   786,   786,
     786,   786,   786,   786,   786,   786,   786,   786,   787,   788,
     788,   788,   789,   789,   790,   790,   790,   790,   790,   791,
     791,   792,   792,   792,   792,   793,   793,   793,   794,   794,
     795,   796,   796,   797,   798,   798,   799,   799,   799,   799,
     799,   799,   799,   799,   799,   799,   799,   799,   799,   799,
     800,   800,   800,   801,   801,   801,   802,   802,   802,   803,
     803,   804,   804,   805,   805,   805,   805,   806,   807,   808,
     808,   809,   809,   809,   809,   809,   809,   809,   809,   809,
     809,   809,   809,   809,   809,   809,   809,   810,   810,   811,
     811,   812,   813,   813,   814,   815,   815,   816,   817,   817,
     817,   817,   817,   818,   818,   819,   820,   820,   820,   820,
     820,   820,   821,   822,   822,   822,   823,   823,   824,   824,
     824,   824,   824,   825,   825,   826,   826,   826,   826,   827,
     827,   828,   828,   829,   829,   830,   830,   831,   831,   832,
     832,   833,   833,   833,   833,   834,   834,   834,   834,   834,
     834,   834,   835,   835,   836,   837,   837,   837,   838,   838,
     838,   839,   839,   840,   840,   841,   841,   841,   841,   842,
     842,   843,   843,   844,   845,   845,   845,   846,   846,   847,
     848,   848,   849,   850,   850,   851,   852,   852,   853,   853,
     853,   853,   853,   853,   853,   853,   854,   854,   855,   856,
     856,   857,   857,   858,   859,   860,   861,   861,   862,   863,
     863,   864,   864,   864,   864,   864,   865,   865,   865,   866,
     866,   867,   867,   868,   868,   868,   868,   868,   868,   868,
     868,   869,   869,   870,   870,   870,   870,   870,   870,   871,
     871,   872,   872,   873,   874,   874,   874,   875,   875,   875,
     875,   875,   875,   875,   875,   876,   876,   877,   877,   877,
     878,   878,   878,   878,   879,   879,   880,   881,   881,   882,
     882,   883,   883,   883,   883,   884,   884,   885,   885,   885,
     886,   886,   887,   887,   888,   889,   889,   889,   890,   891,
     891,   892,   892,   893,   893,   894,   894,   895,   895,   896,
     896,   897,   897,   898,   898,   899,   899,   900,   900,   901,
     901,   902,   902,   903,   903,   903,   903,   903,   903,   903,
     903,   903,   903,   903,   904,   904,   904,   904,   904,   904,
     905,   905,   905,   905,   906,   906,   906,   906,   907,   907,
     908,   908,   909,   909,   909,   909,   910,   910,   911,   911,
     911,   912,   913,   913,   914,   914,   914,   915,   915,   916,
     917,   917,   917,   917,   917,   917,   918,   918,   918,   919,
     919,   919,   919,   919,   919,   919,   920,   920,   920,   920,
     921,   921,   922,   922,   923,   923,   923,   923,   923,   923,
     923,   923,   923,   923,   923,   924,   924,   925,   925,   926,
     926,   927,   928,   929,   929,   930,   930,   931,   932,   933,
     933,   933,   933,   933,   933,   934,   934,   935,   935,   936,
     936,   936,   936,   937,   938,   938,   938,   939,   939,   939,
     939,   939,   939,   939,   939,   939,   939,   939,   939,   939,
     939,   940,   940,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   942,   942,   942,   942,   942,   942,   942,   942,   942,
     942,   942,   942,   942,   942,   942,   942,   942,   942,   942,
     942,   942,   942,   943,   943,   943,   943,   943,   943,   943,
     943,   943,   943,   943,   944,   944,   944,   944,   944,   944,
     944,   944,   944,   944,   944,   944,   944,   944,   944,   944,
     944,   944,   944,   944,   944,   944,   944,   944,   944,   944,
     944,   944,   944,   944,   944,   944,   944,   944,   944,   944,
     944,   944,   944,   944,   944,   944,   944,   944,   944,   944,
     944,   944,   945,   945,   946,   946,   946,   946,   947,   948,
     948,   949,   949,   950,   950,   951,   951,   951,   952,   952,
     953,   953,   954,   955,   955,   955,   956,   957,   957,   958,
     958,   959,   959,   959,   960,   960,   961,   961,   961,   961,
     961,   962,   962,   962,   963,   963,   963,   964,   964,   965,
     965,   965,   965,   965,   965,   965,   965,   965,   966,   966,
     967,   967,   968,   968,   968,   968,   968,   968,   969,   969,
     970,   970,   971,   971,   972,   972,   973,   973,   973,   974,
     974,   975,   975,   976,   976,   976,   976,   976,   976,   976,
     976,   977,   977,   978,   979,   979,   980,   980,   980,   980,
     980,   980,   981,   982,   983,   983,   983,   984,   984,   985,
     986,   986,   987,   988,   988,   989,   989,   990,   990,   991,
     991,   991,   991,   992,   992,   993,   993,   994,   994,   995,
     995,   996,   996,   997,   998,   998,   999,   999,   999,   999,
    1000,  1000,  1001,  1001,  1002,  1002,  1003,  1004,  1005,  1006,
    1007,  1008,  1009,  1009,  1010,  1010,  1010,  1010,  1010,  1010,
    1010,  1010,  1010,  1010,  1010,  1010,  1010,  1010,  1010,  1011,
    1012,  1013,  1013,  1013,  1013,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,
    1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,
    1016,  1016,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1018,  1018,  1019,  1019,
    1019,  1019,  1019,  1019,  1019,  1019,  1021,  1020,  1022,  1023,
    1023,  1023,  1023,  1024,  1024,  1024,  1024,  1025,  1025,  1026,
    1027,  1028,  1028,  1029,  1029,  1029,  1030,  1030,  1031,  1031,
    1032,  1032,  1033,  1033,  1033,  1033,  1034,  1034,  1034,  1035,
    1036,  1036,  1037,  1037,  1038,  1038,  1038,  1038,  1039,  1039,
    1040,  1041,  1042,  1043,  1043,  1044,  1045,  1045,  1046,  1046,
    1046,  1046,  1046,  1048,  1047,  1049,  1050,  1051,  1051,  1052,
    1052,  1052,  1052,  1053,  1053,  1055,  1054,  1057,  1056,  1058,
    1056,  1056,  1059,  1059,  1060,  1060,  1060,  1061,  1061,  1061,
    1061,  1062,  1062,  1063,  1063,  1063,  1063,  1063,  1063,  1064,
    1064,  1064,  1065,  1067,  1066,  1068,  1069,  1068,  1070,  1070,
    1071,  1071,  1072,  1072,  1073,  1073,  1073,  1073,  1073,  1073,
    1073,  1073,  1073,  1074,  1074,  1074,  1074,  1074,  1074,  1074,
    1074,  1074,  1074,  1075,  1075,  1076,  1076,  1077,  1078,  1078,
    1079,  1079,  1079,  1080,  1081,  1082,  1082,  1082,  1082,  1083,
    1083,  1083,  1084,  1084,  1085,  1085,  1086,  1087,  1087,  1088,
    1088,  1089,  1089,  1090,  1090,  1091,  1092,  1092,  1093,  1093,
    1093,  1094,  1094,  1094,  1094,  1094,  1094,  1094,  1094,  1094,
    1095,  1095,  1095,  1095,  1095,  1096,  1096,  1097,  1098,  1099,
    1100,  1100,  1101,  1102,  1103,  1103,  1104,  1105,  1105,  1106,
    1107,  1108,  1108,  1109,  1110,  1111,  1111,  1112,  1113,  1113,
    1113,  1113,  1113,  1114,  1114,  1114,  1114,  1114,  1114,  1114,
    1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1115,  1115,
    1116,  1116,  1117,  1117,  1117,  1119,  1118,  1120,  1120,  1122,
    1121,  1123,  1123,  1123,  1124,  1124,  1124,  1124,  1124,  1124,
    1124,  1124,  1124,  1125,  1125,  1126,  1126,  1126,  1126,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1127,
    1127,  1127,  1127,  1127,  1127,  1128,  1128,  1128,  1128,  1128,
    1128,  1128,  1129,  1130,  1130,  1130,  1130,  1130,  1130,  1130,
    1130,  1131,  1131,  1131,  1131,  1131,  1131,  1131,  1132,  1132,
    1132,  1132,  1132,  1132,  1133,  1133,  1133,  1133,  1133,  1133,
    1133,  1133,  1133,  1133,  1133,  1134,  1134,  1134,  1134,  1134,
    1135,  1135,  1135,  1135,  1136,  1136,  1136,  1136,  1136,  1136,
    1136,  1137,  1137,  1137,  1138,  1138,  1138,  1138,  1138,  1138,
    1139,  1139,  1140,  1141,  1141,  1142,  1142,  1143,  1144,  1145,
    1146,  1146,  1146,  1147,  1148,  1149,  1150,  1151,  1151,  1151,
    1151,  1151,  1152,  1153,  1153,  1153,  1154,  1154,  1155,  1155,
    1155,  1156,  1156,  1157,  1157,  1158,  1158,  1159,  1159,  1159,
    1159,  1159,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1161,  1161,
    1161,  1161,  1162,  1162,  1162,  1162,  1162,  1162,  1162,  1162,
    1162,  1163,  1163,  1163,  1163,  1163,  1164,  1164,  1165,  1165,
    1166,  1166
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     5,     1,     0,     2,     0,
       2,     0,     2,     2,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       2,     1,     2,     2,     2,     3,     3,     5,     5,     0,
       3,     5,     5,     4,     3,     5,     3,     5,     5,     6,
       1,     1,     3,     5,     6,     4,     1,     0,     2,     0,
       1,     1,     1,     1,     1,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     5,     2,     2,     2,
       2,     3,     3,     3,     1,     3,     1,     3,     1,     1,
       2,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       3,     6,     1,     1,     1,     1,     1,     0,     1,     1,
       2,     3,     4,     3,     2,     2,     1,     3,     4,     5,
       4,     2,     4,     1,     1,     1,     1,     1,     2,     2,
       2,     2,     4,     4,     4,     4,     1,     3,     2,     3,
       4,     6,     6,     6,     5,     5,     6,     6,     4,     7,
       2,     6,     4,     3,     3,     3,     3,     3,     4,     4,
       3,     3,     3,     3,     3,     3,     4,     4,     3,     2,
       3,     3,     3,     2,     2,     3,     2,     1,     1,     0,
       2,     0,     3,     2,     0,     1,     3,     3,     1,     5,
       3,     2,     2,    10,     6,     1,     1,     1,     1,     1,
       1,     3,     2,     0,     1,     1,     3,     3,     1,     1,
       3,     3,     3,     3,     4,     1,     0,     2,     0,     3,
       0,     1,     0,     1,     3,     2,     1,     1,     1,     3,
       0,     1,     3,     1,    11,    10,     1,     1,     2,     2,
       2,     2,     0,     1,     0,     3,     0,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     3,     4,     2,     0,
       3,     1,     1,     2,     1,     3,     4,     4,     2,     5,
       1,     2,     2,     2,     3,     3,     3,     0,     1,     1,
       1,     1,     1,     1,     3,     1,     5,     7,     8,     9,
      11,     3,     0,     1,     3,     1,     2,     2,     2,     0,
       1,     3,     3,     6,     4,     0,     1,     1,     2,     2,
       0,     3,     3,     2,     1,     1,     2,     2,     4,     0,
       2,     2,     2,     0,     3,     4,     4,     0,     2,     0,
       4,     0,     5,     3,     0,     1,     3,     1,     2,     3,
       0,     5,     4,     1,     0,     1,     2,     2,     1,     2,
       3,     2,     2,     2,     2,     3,     3,     1,     3,     1,
       0,     1,     2,     1,     1,     3,     6,    10,     1,     0,
       1,     2,     2,     0,     2,     2,     1,     0,     5,     7,
       1,     0,     6,     2,     0,     3,     5,     7,     6,     8,
       7,     6,     6,     4,     0,     1,     3,     4,     1,     3,
       1,     2,     2,     2,     2,     1,     1,    10,     2,     0,
       2,     2,     1,     0,     4,     6,     5,     4,     4,     8,
       1,     1,     1,     7,     9,     8,    15,    20,     1,     1,
       1,     3,     1,     1,     1,     3,     1,     3,     0,     1,
       0,     1,     1,     4,     0,     1,     3,     0,     1,     1,
       1,     1,     1,     1,     2,     0,     1,     2,     1,     2,
       0,     2,     1,     2,     2,     6,     8,     8,     4,     5,
       4,     4,     4,     3,     7,     8,     6,     6,     6,     6,
       3,     1,     3,     3,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     1,     3,     3,     1,     0,     1,     3,
      13,     1,     3,     4,     5,     4,     7,     2,     1,     0,
       2,     0,     1,     0,     6,     8,     8,     1,     3,     5,
       5,     7,     9,     7,     9,     5,     6,     6,     4,     1,
       1,     1,     1,     1,     1,     1,     1,     3,     3,     3,
       3,     1,     3,     1,     2,     2,     3,     5,     2,     2,
       0,     6,     7,     7,     7,     8,     8,     6,     8,     9,
       9,     7,    10,     7,     8,     8,     8,     8,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     2,     3,     4,     5,     4,     5,     3,
       4,     3,     4,     1,     2,     3,     3,     3,     3,     4,
       4,     3,     3,     4,     4,     4,     4,     1,     1,     1,
       0,     7,     7,    10,     1,     1,     2,     4,     5,     1,
       3,     2,     2,     2,     2,     1,     2,     2,     4,     3,
       2,     2,     2,     3,     2,     2,     5,     5,     5,     1,
       3,     1,     2,     3,     0,     1,     3,     2,     6,     6,
       9,     3,     0,     3,     0,     5,     2,     0,     3,     3,
       3,     7,     7,    10,     1,     1,     1,    14,     1,     0,
       1,     0,     1,     0,     2,     0,     1,     3,     4,     4,
       6,     1,     2,     0,     1,     1,     0,     1,     1,     0,
       9,    12,     7,     2,     0,     3,     2,     1,     3,     3,
       2,     1,     3,     3,     3,     2,     2,     1,     1,     1,
       1,     2,     1,     1,     1,     1,     4,     5,     1,     3,
       3,     1,     2,     4,     5,     1,     1,     1,     1,     3,
       3,     2,     2,     2,     2,     1,     2,     2,     1,     1,
       1,     3,     2,     0,     2,     1,     3,     5,     1,     2,
       1,     0,     5,     7,     5,     7,     5,     7,     3,     5,
       5,     5,     1,     3,     2,     1,     2,     1,     2,    11,
      10,    10,     2,     2,     0,     9,     2,     0,     4,     4,
       4,     1,     1,     1,     0,     7,     6,     6,     6,     6,
       7,     9,     9,     6,     6,     6,     6,     6,     8,     8,
       6,     6,     6,     5,     5,     8,     8,     8,     8,     6,
       1,     0,     2,     0,     7,     6,     6,     6,     6,     6,
       6,     7,     6,     6,     6,     6,     7,     7,     7,     9,
       9,     6,     6,     6,     8,     8,     8,     6,    13,     1,
       1,     3,     3,     1,     1,     1,     1,     1,     1,     1,
       0,     1,     1,     1,     1,     1,     1,     0,     6,     8,
       3,     2,     0,     2,     2,     2,     2,     3,     3,     2,
       2,     2,     2,     3,     2,     5,     4,     3,     3,     3,
       1,     1,     0,     3,     2,     2,     1,     3,     2,     1,
       0,     8,    10,     3,     4,     4,     0,     2,     5,     2,
       0,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     4,     3,     3,     1,     0,     5,
       6,     4,     2,     0,     4,     3,     5,     6,     4,     6,
       6,     5,     7,     1,     0,     6,    11,    11,    11,    13,
       9,    11,    10,     4,     2,     5,     2,     0,     4,     5,
       5,     4,     6,     1,     3,     1,     1,     1,     1,     2,
       4,     1,     1,     1,     0,     1,     0,     1,     0,     3,
       0,     2,     4,     3,     5,     1,     1,     1,     1,     1,
       1,     1,     1,     3,     2,     1,     1,     1,     1,     1,
       0,     5,     4,     3,     0,     1,     1,     1,     1,     4,
       8,     3,     0,     5,     1,     4,     2,     1,     3,     2,
       3,     0,     6,     2,     0,     5,     3,     0,     2,     2,
       2,     3,     1,     3,     1,     2,     1,     0,     7,     1,
       3,     1,     1,     3,     5,     2,     1,     3,     7,     1,
       1,     0,     3,     2,     2,     2,     0,     2,     2,     1,
       1,     3,     3,     1,     2,     4,     4,     2,     3,     5,
       5,     1,     1,     9,     1,     2,     4,     4,     4,     2,
       3,     1,     3,     4,     2,     1,     0,     3,     3,     4,
       4,     4,     4,     2,     1,     1,     0,     1,     1,     0,
       1,     5,     1,     0,     1,     0,     3,     1,     3,     4,
       3,     2,     2,     1,     1,     1,     0,     2,     4,     5,
       2,     3,     1,     1,     1,     1,     3,     0,     1,     1,
       1,     1,     1,     3,     0,     2,     0,     1,     3,     1,
       0,     1,     2,     4,     4,     2,     0,     2,     3,     2,
       0,     1,     3,     1,     2,     1,     2,     5,     6,     5,
       1,     2,     1,     4,     3,     4,     5,     4,     5,     4,
       5,     2,     4,     1,     2,     2,     2,     1,     1,     0,
       4,     2,     1,     2,     2,     4,     1,     3,     1,     2,
       3,     1,     2,     0,     2,     4,     0,     1,     3,     2,
       2,     3,     5,     6,     2,     3,     3,     4,     0,     1,
       1,     1,     1,     1,     2,     5,     1,     1,     1,     1,
       2,     3,     3,     0,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     2,     1,     3,     0,     1,     1,     1,
       1,     5,     2,     1,     1,     1,     1,     5,     2,     2,
       2,     1,     3,     3,     2,     1,     0,     3,     0,     5,
       2,     5,     2,     1,     2,     3,     0,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     3,     3,     3,     3,
       0,     1,     4,     1,     3,     5,     2,     2,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     2,     2,
       3,     3,     2,     3,     5,     4,     6,     3,     5,     4,
       6,     4,     6,     5,     7,     3,     2,     4,     2,     3,
       3,     4,     3,     4,     3,     4,     5,     6,     6,     7,
       6,     7,     6,     7,     3,     4,     4,     6,     2,     3,
       4,     1,     3,     2,     2,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     2,     5,     6,     6,
       7,     3,     4,     1,     1,     2,     4,     1,     1,     1,
       2,     2,     2,     1,     4,     5,     6,     8,     6,     7,
       7,     5,     1,     1,     4,     1,     4,     1,     4,     1,
       4,     1,     1,     1,     1,     1,     1,     6,     4,     4,
       4,     4,     6,     5,     5,     5,     4,     6,     4,     4,
       4,     4,     5,     7,     7,     9,     4,     6,     5,     7,
       7,     7,     2,     3,     3,     3,     4,     0,     4,     1,
       3,     3,     1,     1,     1,     2,     2,     0,     2,     0,
       1,     3,     3,     2,     2,     0,     6,     1,     0,     3,
       0,     2,     2,     0,     1,     4,     2,     2,     2,     2,
       2,     4,     3,     5,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     4,
       1,     4,     1,     4,     1,     2,     1,     2,     1,     3,
       1,     3,     1,     3,     1,     3,     3,     3,     2,     1,
       3,     3,     0,     1,     1,     1,     1,     1,     1,     1,
       1,     4,     3,     2,     3,     0,     3,     3,     2,     2,
       1,     0,     2,     2,     3,     2,     1,     1,     3,     5,
       1,     2,     4,     2,     0,     1,     0,     1,     2,     2,
       2,     3,     5,     1,     2,     0,     2,     1,     0,     1,
       1,     1,     3,     3,     1,     3,     3,     2,     1,     1,
       1,     3,     1,     2,     1,     3,     1,     1,     1,     1,
       1,     1,     1,     2,     1,     1,     1,     1,     1,     2,
       5,     2,     3,     6,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     0,     2,     4,     3,
       2,     1,     1,     1,     1,     1,     0,     8,     2,     5,
       3,     2,     2,     3,     7,     1,     1,     1,     0,     2,
       2,     1,     0,     1,     3,     1,     2,     0,     2,     0,
       2,     0,     1,     3,     4,     3,     1,     1,     1,     1,
       2,     0,     2,     4,     0,     2,     2,     2,     1,     1,
       7,     3,     1,     1,     1,     1,     2,     0,     1,     3,
       3,     3,     3,     0,     4,     5,     5,     0,     1,     1,
       1,     2,     2,     1,     2,     0,     7,     0,     5,     0,
       4,     2,     2,     0,     2,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     5,     2,     1,     3,
       2,     2,     3,     0,     5,     1,     0,     5,     2,     2,
       1,     1,     1,     2,     2,     3,     1,     2,     2,     3,
       3,     4,     2,     1,     2,     1,     1,     2,     2,     3,
       1,     1,     1,     1,     0,     1,     3,     5,     0,     2,
       0,     1,     2,     3,     2,     1,     1,     1,     0,     1,
       1,     1,     1,     1,     2,     2,     3,     0,     1,     2,
       1,     4,     3,     4,     3,     2,     1,     3,     1,     1,
       1,     1,     2,     2,     1,     2,     2,     1,     1,     1,
       4,     4,     4,     4,     4,     1,     0,     3,     3,     4,
       1,     3,     3,     4,     1,     3,     3,     1,     1,     1,
       6,     1,     3,     3,     6,     1,     3,     3,     1,     1,
       2,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     4,     4,
       1,     1,     4,     4,     3,     0,     7,     1,     0,     0,
       7,     3,     4,     3,     1,     1,     1,     2,     3,     5,
       2,     5,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     3,     1,     0,     1,     2,     1,     2,     1,     1,
       1,     2,     2,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     2,
       3,     1,     2,     1,     3,     1,     3,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     2,     3,
       2,     3,     1,     3,     3,     3,     3,     3,     3,     1,
       1,     0,     2,     2,     1,     1,     2,     1,     1,     1,
       0,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
    2086,     0,     2,     1,  2516,  2520,  2524,  2525,  2442,  2526,
    2527,  2492,  2493,  2494,  2495,  2496,  2497,  2498,  2499,  2500,
    2501,  2502,  2503,  2505,  2504,  2506,  2507,  2508,  2509,  2510,
    2511,  2512,  2513,  2515,  2514,  2464,  2093,  2461,  2458,  2459,
    2460,  2465,  2463,  2456,  2457,  1699,  2529,  2517,  2530,  2518,
    2519,  2521,  2522,  2491,  2523,  2531,  2532,  2533,  2528,  2536,
    2487,  2488,  2486,  2489,  2490,  2534,  2535,  2478,  2479,  2480,
    2481,  2537,  2094,  2095,  2483,  2087,  2091,  2153,  2224,  2484,
    2485,  2482,  2092,  2477,  2224,     0,  2345,  2346,  2347,     0,
    2348,  2349,  2350,  2276,  2238,  2351,     0,     0,  2352,  2353,
    2354,  2355,  2356,  2357,  2358,  2359,     0,  2360,  2361,  2362,
    2363,  2223,  2364,  2365,  2366,  2367,  2368,  2200,  2206,  2329,
       0,  2180,  2181,  2177,  2179,  2178,  2182,  2165,  1002,   501,
    1082,  1081,     0,  1990,  1002,  1947,  1948,  1991,  1949,  1950,
    1951,   247,     0,  1084,  1952,     0,  1002,  1992,   336,   814,
    1993,  1994,  2108,     0,  1953,  1954,     0,     0,     0,     0,
     501,  1002,     0,     0,  1955,     0,  1956,     0,  1957,  1995,
    1996,     0,  1958,  1997,  1998,  1959,     0,  1960,  1961,  1999,
    2000,  2001,  1962,  2002,  2003,     0,     0,  1206,     0,  1963,
    2004,  1964,  1965,     0,  2005,  1966,  1967,  1968,  2006,  2007,
    2008,  1969,  1970,  1971,     0,  1972,     0,     0,     0,     0,
       0,  2009,  1002,  1973,     0,  1213,     0,  1974,     0,  2010,
    1975,     0,  1976,     0,  1977,  1978,  1979,  1980,  1206,  2325,
    2201,     0,     0,  1086,     0,  1981,  2011,     0,  1982,  1983,
    1984,  1985,  1986,  1987,  1988,  1989,     0,     0,    47,    48,
      16,    15,    21,    20,    70,    71,    37,    10,    61,    42,
     102,   101,   103,    27,    23,    55,    14,    24,    28,    44,
      43,    13,    41,    65,    45,    68,    34,    59,     7,    35,
      60,     8,    49,    72,    19,    46,    69,    30,    57,    53,
      38,    39,    40,    62,    63,    64,    86,    67,    97,    26,
      76,    77,    92,    78,    93,     5,    79,    36,     9,    89,
      88,    90,    56,    31,    58,    87,    91,    11,    12,    94,
      66,    84,    81,    98,    96,   104,    82,    50,     3,     4,
      73,    33,     6,    18,    17,    32,    25,   100,    22,  1084,
      75,    85,    74,    80,    54,    83,    99,    52,    95,  1182,
    1169,  1215,  1181,     0,  1184,  2421,  2422,    29,   124,   106,
     107,   112,  2090,  2142,  2143,  2144,  2224,  2175,  2176,  2169,
    2185,  2195,  2184,  2188,  2196,  2183,  2202,     0,   109,   111,
     113,   116,   110,   105,   108,   115,   120,   114,   119,   117,
     118,   121,   122,   123,  2423,  1390,  2420,    51,  2160,  2159,
       0,  2224,     0,  2369,  2370,  2371,  2372,  2373,  2374,  2424,
    2425,  2426,  2427,  2428,  2430,  2429,  2453,  1705,  1706,  1707,
    1708,  1709,  1710,  1711,  1712,  1713,  1714,  1715,  1716,  1717,
    1718,  1719,  1720,  1721,  1722,  1723,  1724,  1725,  1726,  1727,
    1728,  2396,  1729,  1730,  1731,  1732,  1733,  1734,  1735,  1736,
    1737,  1738,  2433,  1739,  1740,  1741,  1742,  1743,  1744,  1745,
    1746,  1747,  1748,  1749,  1750,  1751,  1752,  2434,  1753,  1754,
    1755,  1756,  1757,  1758,  1759,  1760,  1761,  1762,  1763,  1764,
    1765,  1766,  1767,  1768,  1769,  1770,  1771,  1772,  1773,  1774,
    1775,  1776,  1777,  1778,  1779,  1780,  1781,  1782,  1783,  1784,
    1785,  1786,  1787,  1788,  1789,  1790,  1791,  2435,  1792,  1793,
    1794,  1795,  1796,  1797,  1798,  1799,  1800,  1801,  1802,  1803,
    1804,  1805,  1806,  1807,  1808,  1809,  1810,  1811,  1812,  1813,
    1814,  1815,  1816,  1817,  1818,  1819,  1820,  1821,  1822,  1823,
    1824,  2436,  1825,  1826,  2437,  1827,  1828,  1829,  1830,  1831,
    1832,  1833,  1834,  1835,  1836,  1837,  1838,  1839,  1840,  1841,
    1842,  1843,  1844,  1845,  1846,  1847,  1848,  1849,  1850,  1851,
    1852,  1853,  1854,  1855,  1856,  1859,  1857,  1858,  1860,  1861,
    1862,  1863,  1864,  1865,  1866,  1867,  1868,  1869,  1870,  1871,
    1872,  1873,  1874,  1875,  1876,  1877,  1878,  1879,  1880,  1881,
    1882,  1883,  1884,  1885,  1886,  1887,  1888,  1889,  2438,  1890,
    1891,  1892,  1893,  1894,  1895,  1896,  1897,  1898,  1899,  1900,
    1901,  1902,  1903,  1904,  1905,  1906,  1907,  1908,  1909,  1910,
    1911,  1912,  1913,  1914,  1915,  1916,  1917,  1918,  2108,  1919,
    1920,  1921,  1922,  1923,  1924,  1925,  1926,  1927,  1928,  1929,
    1930,  1931,  1932,  1933,  1934,  2397,  1935,  1936,  1937,  1938,
    1939,  1940,  1941,  1942,  1943,  1944,  2439,  1945,  1946,  2126,
    2431,  2393,  2101,  2122,  2394,  2343,  2344,  1700,  2395,  2392,
    2432,  2128,  2449,  2127,  2391,  2275,     0,     0,  2237,  2236,
    2240,  2239,  2241,  2234,  2235,  1677,  2129,  2245,  2244,  1159,
    2448,  1676,  1160,     0,  2247,  2375,  2376,  2377,  2378,  2380,
    2379,  2381,  2012,  2013,  2014,  2015,  2016,  2017,  2018,  2019,
    2020,  2021,  2022,  2023,  2406,  2024,  2025,  2026,  2419,  2027,
    2028,  2407,  2029,  2030,  2031,  2032,  2033,  2034,  2035,  2036,
    2037,  2038,  2039,  2040,  2041,  2042,  2043,  2044,  2045,  2046,
    2047,  2048,  2049,  2050,  2051,  2052,  2408,  2409,  2053,  2054,
    2055,  2056,  2057,  2058,  2059,  2060,  2061,  2062,  2063,  2064,
    2065,  2066,  2067,  2068,  2069,  2070,  2071,  2072,  2073,  2074,
    2075,  2410,  2076,  2077,  2411,  2078,  2079,  2080,  2412,  2081,
    2082,  2083,  2084,  2085,  2416,  2417,  2418,  2405,  2198,  2382,
    2404,  2415,  2413,  2414,  2208,  2204,  2212,  2207,     0,     0,
       0,     0,  2224,  1001,  1000,   986,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   500,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2098,     0,  1010,   312,   311,  1083,  1064,   501,     0,   989,
     335,     0,     0,     0,     0,     0,     0,     0,   628,     0,
       0,     0,     0,     0,     0,     0,     0,   177,     0,     0,
     357,   356,     0,     0,     0,   788,     0,     0,     0,     0,
     489,  2107,  2102,  2112,     0,  2105,  2106,  2391,     0,  2540,
    1857,  2138,  2139,  2538,  1903,  1161,     0,   248,   251,   249,
     250,     0,   884,   885,   887,     0,     0,   897,   655,     0,
     654,     0,     0,     0,   652,     0,     0,     0,     0,   656,
     650,     0,   649,     0,     0,     0,   653,     0,   651,     0,
       0,   990,     0,  2190,  2191,  1794,  1122,   362,     0,     0,
       0,     0,  1084,  1091,  1101,  1096,  1098,  1097,  1099,  1095,
    1100,  1706,   730,  1719,   730,  1784,   727,   728,   730,   730,
     730,  1871,     0,     0,   702,     0,   713,  1701,   730,  1702,
    2449,   735,   412,   412,   412,     0,   734,   739,   412,     0,
     983,  1017,  1681,  1205,     0,  1719,  1784,   703,   982,  1919,
    1114,     0,     0,   901,     0,   902,     0,  1886,   994,   234,
    2389,  1895,  1977,  1919,  2390,   230,  2384,  2385,  2387,   204,
    2388,  2386,  2383,  1710,     0,     0,   734,     0,   991,   992,
    1212,  1210,     0,     0,     0,  1727,     0,  1739,  1818,   227,
    1882,  1887,  1895,  1977,  1919,  1944,   186,     0,   241,  1895,
    1977,  1919,     0,  1010,     0,  1185,  1292,  1672,     0,     0,
    2199,   985,   984,  1298,     0,  1085,     0,  1088,     0,  1257,
    1869,  1189,  1191,  1090,  1182,     0,  2089,  1079,  1209,  1209,
       0,  1209,     0,  1174,  1182,  1177,  1181,     0,  1002,     0,
    2167,  2195,  2174,  2230,  2171,     0,     0,  2220,  2216,  2213,
    2221,  2222,  2215,  2203,  1379,  1380,  1381,  1378,  1391,  1377,
       0,  2148,  1382,  2187,  2154,     0,  2162,  2161,  2466,  2467,
    2277,  2100,  2119,     0,     0,     0,     0,     0,     0,     0,
    2246,  2248,  2250,  2210,  2209,  2205,     0,     0,     0,     0,
    2335,  2336,  2334,     0,  2331,  2333,     0,  2230,     0,  2400,
    2394,  2403,     0,  1682,  2395,  2392,  2391,     0,   663,   127,
     777,     0,     0,     0,     0,     0,     0,     0,  1577,  1731,
    1780,  1587,  1585,  1586,  1579,  1580,  1581,  1582,  1583,  1584,
       0,   882,  1578,     0,   127,     0,     0,     0,     0,     0,
       0,     0,     0,  1822,   127,     0,     0,     0,     0,     0,
    1006,  1009,   987,  1067,     0,  1672,     0,     0,   688,     0,
     697,   689,   694,     0,   691,     0,     0,   699,     0,   690,
     692,   693,   698,     0,     0,   695,   696,     0,     0,   998,
     412,     0,     0,     0,     0,     0,   127,  1054,     0,   361,
     360,   127,   359,   358,  1731,  1780,     0,   813,   127,     0,
     179,   529,   504,     0,     0,   593,  1822,   127,     0,     0,
       0,     0,   791,     0,     0,   488,   501,     0,  2111,  2117,
       0,  2109,  2278,  2541,  2539,  2233,     0,  1134,   888,   228,
     229,   886,  1793,     0,   299,     0,     0,  1793,  1045,     0,
    1793,     0,  1793,   172,  1674,  1731,  1780,  1793,     0,     0,
    1793,   164,  1793,     0,  1793,   299,  1793,   505,     0,  1793,
       0,  1793,  1822,   166,     0,  1793,   299,   661,     0,     0,
    2471,  2475,     0,  2473,  2468,  2189,  2243,  2242,  2141,     0,
    2551,     0,  1161,  1093,  2397,  1107,  1106,     0,  1102,  1110,
    1105,     0,   730,   729,     0,   730,     0,  2560,   730,     0,
     730,     0,  2560,   730,     0,     0,     0,   730,  1703,  1704,
       0,     0,  2559,  2557,  2558,   704,   714,     0,   736,     0,
       0,   743,   742,   741,     0,     0,     0,   744,     0,  1296,
    1137,     0,   711,     0,   709,     0,   980,   997,     0,     0,
       0,     0,   904,   904,   904,   993,   233,   231,     0,     0,
       0,     0,     0,     0,   999,     0,     0,  2455,  1688,  1588,
    2454,     0,  1948,  1949,  1950,  1646,     0,  2396,  1951,  1952,
    1505,  1492,  1501,  1506,  1493,  1495,  1502,  1953,  1954,  1766,
    1955,  1956,  1695,  1957,  1958,  1334,  1960,  1961,  1962,  1497,
    1499,  1963,  1964,     0,  1696,  1966,  1967,  1846,  1969,  1970,
    1972,  1973,  1503,  1975,  1976,  1977,  1978,  1979,  1980,  1694,
       0,  1504,  1981,  1983,  1984,  1985,  1986,  1987,  1988,  1989,
       0,     0,  1669,     0,  1479,     0,  1326,  1327,  1349,  1350,
    1328,  1355,  1356,  1368,  1329,     0,  1668,  1393,  1478,  1483,
       0,  1477,  1473,  1196,  1664,     0,  1474,  1684,  1647,  1698,
    1697,  2449,  1655,  1687,  1685,  1686,     0,     0,     0,   197,
       0,     0,  2324,   243,     0,   244,  1670,  1895,   187,   226,
     199,   225,   200,   198,     0,  1729,   188,     0,   195,     0,
       0,     0,     0,     0,     0,     0,   237,   988,     0,  1294,
    1293,     0,     0,  1653,  1673,   670,     0,     0,  1299,     0,
    1077,  1078,  1076,     0,  1073,  1075,  1087,  1084,  1660,  1659,
    1661,     0,  1190,     0,     0,     0,  1172,  1171,  1090,  1207,
    1208,     0,     0,     0,     0,     0,     0,     0,     0,  1250,
    1223,  1224,  1226,  1247,  1251,     0,  1178,  1258,  2088,  2230,
    2231,     0,  2225,     0,  2224,  2224,  2218,  2217,  2214,     0,
       0,     0,     0,     0,     0,     0,  2145,   483,  2147,   481,
       0,     0,  2121,     0,  2125,  2123,     0,  2270,  2273,     0,
    2271,  2272,  2274,     0,  2279,  2280,     0,     0,     0,  2462,
       0,     0,  2261,  2249,  2256,  2258,  2260,  2259,  2268,  2264,
    2267,  2269,  2211,  2224,  2342,     0,  2337,  2340,     0,  2332,
       0,     0,     0,  1683,     0,     0,     0,   664,     0,     0,
       0,   126,  1043,   236,  1041,     0,     0,     0,     0,     0,
    1048,     0,     0,     0,     0,   846,     0,     0,     0,     0,
       0,     0,   847,   845,   848,   855,   868,   871,     0,   767,
     170,   171,     0,     0,     0,   931,     0,     0,   931,     0,
       0,     0,     0,     0,     0,     0,   253,   256,     0,     0,
       0,     0,     0,     0,     0,     0,   131,     0,     0,     0,
       0,   468,   480,     0,     0,     0,     0,     0,   477,     0,
     127,   254,   462,   465,     0,     0,     0,   538,   537,   931,
       0,   252,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   131,   163,     0,
       0,   255,     0,  2155,     0,  1004,  1005,     0,  1008,     0,
    1063,     0,     0,     0,     0,     0,     0,  1731,  1780,     0,
       0,     0,     0,     0,     0,   338,   318,   319,   127,   317,
       0,     0,   590,     0,  1337,  1366,  1344,  1366,  1366,  1333,
    1333,  1346,  1335,  1373,     0,  1366,  1333,  1338,     0,  1336,
    1376,  1376,  1361,     0,  1318,  1319,  1320,  1321,  1347,  1348,
    1322,  1353,  1354,  1323,  1390,  2401,  1333,  2402,  2399,  2398,
       0,  1020,  1053,     0,     0,   129,   629,     0,     0,   591,
       0,   129,     0,   175,     0,   533,     0,     0,     0,     0,
       0,     0,   549,   548,     0,     0,   592,     0,   129,   464,
       0,   454,   412,     0,   790,   793,     0,     0,     0,  2115,
    2110,  2113,     0,  2103,  2117,  1164,  1166,  1165,     0,  1163,
       0,  1306,     0,   299,   297,   298,   588,   896,     0,     0,
       0,     0,   299,     0,     0,  1793,     0,  1793,     0,     0,
     299,   299,     0,     0,     0,     0,   534,     0,   660,   658,
     657,   659,     0,     0,     0,     0,     0,  1793,   299,     0,
       0,   648,  2469,     0,     0,  2472,     0,  2192,  1598,     0,
    2554,  1119,  2555,     0,     0,     0,     0,   215,   216,   214,
    1108,   217,  1109,  1104,  1092,     0,   722,     0,  2560,  2561,
     707,     0,   717,     0,  2560,   705,     0,   718,   715,   716,
       0,     0,     0,  2556,  2440,  2446,   721,     0,     0,   413,
     415,     0,     0,  1752,     0,  1785,  1810,  1811,  1887,  1891,
       0,  1914,     0,   745,   772,   740,     0,     0,  1131,  1124,
       0,     0,  1147,   712,   710,   981,  1112,  1604,     0,     0,
       0,   903,   900,   899,   898,   232,   205,     0,     0,     0,
     774,  1886,   996,     0,     0,  1481,  1482,  1365,  1352,  1645,
       0,     0,  1360,  1359,     0,     0,     0,     0,  1342,  1341,
    1340,  1480,  1612,     0,  1339,     0,     0,     0,     0,  1366,
    1366,  1364,  1412,     0,  1343,     0,     0,  1625,     0,  1631,
       0,     0,     0,  1372,     0,  1370,     0,     0,  1448,     0,
       0,     0,     0,     0,     0,     0,  1396,  1397,  1479,  1598,
       0,  1691,     0,     0,  1358,     0,  1390,  1588,     0,     0,
       0,     0,  1658,  1596,     0,     0,  1426,  1594,     0,  1428,
       0,     0,     0,  1587,  1585,  1586,  1579,  1580,  1581,  1582,
    1583,  1584,  1592,  1409,     0,  1667,     0,  1408,     0,     0,
    1260,  1195,     0,  1689,  1648,     0,  2447,  2450,  1475,  2321,
    2320,  2319,  2318,  2289,     0,  2283,  2284,     0,  2322,  2323,
     245,   246,   242,     0,     0,   202,   201,     0,   223,   224,
     194,   222,     0,   218,   219,  1544,  1543,   203,   193,   191,
     189,   206,   208,   209,   192,   190,   240,   238,     0,     0,
       0,  1650,  1649,  1679,  1654,     0,     0,   299,  2224,  1300,
       0,  1260,  1149,  1151,  1152,     0,  1655,  1071,     0,  1068,
    1663,     0,  1192,     0,     0,  1080,  1188,  1187,  1216,  1217,
     806,  1186,  1241,  1242,  1237,     0,  1256,  1256,  1233,  1227,
    1232,  1230,     0,  1234,  1393,  1249,  1176,  1221,  1222,  1225,
    1175,     0,  1252,  1250,  1226,     0,  2232,  2230,  2170,  1318,
    2224,  2163,  2224,  2219,  2151,  1384,  1385,  1386,  1387,  1388,
    1389,  2152,     0,  2149,  1383,  2150,   482,     0,     0,     0,
    2118,     0,  2099,  2124,  2255,  2364,  2287,     0,  2288,     0,
       0,  2252,     0,  2262,  2265,  2263,  2266,     0,  1318,  2443,
    2338,  2443,  1318,     0,     0,     0,     0,     0,     0,     0,
     665,     0,     0,     0,  1914,   235,  1039,     0,     0,     0,
       0,   776,   775,     0,     0,   795,     0,     0,     0,  1051,
     405,     0,   296,     0,     0,     0,     0,     0,     0,     0,
     853,     0,     0,     0,     0,   854,   851,   852,  1887,   870,
     869,   867,   828,   830,   829,     0,   832,   816,     0,   817,
       0,     0,   827,   835,   833,     0,     0,     0,  1774,   258,
     270,     0,   930,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   289,     0,     0,     0,     0,   294,     0,
       0,     0,   293,     0,     0,     0,     0,     0,     0,     0,
     883,     0,     0,   158,   161,     0,     0,   467,   479,     0,
     471,   472,   469,   473,   474,     0,     0,     0,     0,     0,
       0,   466,     0,     0,   531,   530,   536,     0,     0,     0,
       0,     0,   924,   923,     0,     0,     0,     0,     0,     0,
       0,     0,   540,   541,     0,   542,     0,   162,     0,     0,
       0,     0,     0,     0,   213,  1003,  1007,  1066,  1680,  1065,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   323,
       0,   613,  2398,   589,     0,  1318,     0,  1314,  1310,  1379,
    1378,  1377,     0,  1324,  1333,  1330,     0,  1018,   379,   497,
     168,     0,     0,     0,   601,   604,     0,   125,   179,   362,
       0,   178,   180,   182,   183,   184,   181,   185,   528,   532,
       0,   503,     0,     0,     0,     0,     0,   553,   552,   556,
     554,     0,   550,     0,     0,     0,   157,   461,   463,  2096,
       0,   364,   443,     0,     0,     0,   792,     0,     0,     0,
       0,     0,  2116,     0,     0,     0,     0,  1162,     0,  1270,
    1133,  1261,  1272,  1263,  1265,  1301,     0,  1672,     0,  1131,
       0,   874,     0,  1046,  1793,   299,     0,   872,   173,  1675,
       0,     0,     0,     0,     0,   876,   645,   165,     0,   299,
     299,   506,     0,   299,   167,     0,     0,     0,   498,   299,
     662,  2470,  2476,  2474,  1121,     0,  2552,  2553,   454,  1166,
    1094,  1103,   719,   726,   708,   725,   724,   706,   723,   720,
    2254,     0,     0,  2445,     0,   737,     0,   411,     0,     0,
       0,   751,     0,     0,   750,   765,   752,     0,   754,   747,
     746,   755,     0,     0,   774,  1126,     0,  1127,  1655,     0,
    1123,     0,  1144,     0,  1142,     0,  1297,  1146,  1135,  1113,
       0,  1111,  1116,  1118,  1117,  1115,     0,     0,     0,   734,
       0,     0,   299,   995,     0,  1608,     0,  1609,     0,     0,
       0,  1644,  1640,     0,     0,     0,     0,     0,  1616,  1617,
    1618,  1615,  1619,  1614,     0,     0,  1620,  1613,     0,     0,
       0,     0,     0,  1363,  1362,     0,     0,     0,     0,     0,
       0,     0,  1451,  1483,     0,     0,  1572,     0,  1598,  1630,
       0,     0,  1374,     0,     0,     0,     0,     0,     0,     0,
    1598,  1636,     0,     0,     0,  1542,     0,  1539,     0,     0,
       0,     0,  1655,     0,     0,     0,     0,  1692,  1394,  1410,
    1666,     0,  1657,     0,     0,  1417,     0,  1637,  1444,     0,
    1449,  1432,     0,  1425,     0,  1430,  1434,  1413,  1658,  1597,
       0,  1595,     0,     0,  1411,     0,  1406,  1404,  1405,  1398,
    1399,  1400,  1401,  1402,  1403,  1407,  1576,  1574,  1575,     0,
       0,     0,  1429,  1787,  1818,     0,  1206,  1206,  1194,  1204,
    1665,     0,  1303,     0,     0,     0,     0,  1555,     0,  1602,
       0,  1600,  1682,  2452,  2451,  1656,     0,     0,     0,  1671,
       0,     0,  1390,     0,   239,  1295,  1651,     0,   668,   669,
     667,  1318,  1156,     0,     0,  1306,     0,  1155,  1090,  1074,
    1070,  1069,  1662,  1089,  1193,     0,   804,   805,     0,   809,
       0,     0,  1235,  1248,     0,  1147,  1147,     0,  1239,  1240,
    1231,  1180,  1179,  2168,  2226,  2173,  2194,  2164,  2197,  1392,
    2146,  2186,     0,  2120,  2290,  2291,     0,  2281,  2282,  2251,
    2257,  2328,     0,  2444,     0,     0,   611,   610,     0,     0,
       0,   942,   906,   666,   943,   907,  1040,     0,  1042,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   299,  1049,   944,   295,  1050,   935,     0,     0,
       0,   511,   512,     0,   849,   850,   945,   908,     0,   936,
     831,  1333,   815,     0,     0,   826,     0,   825,  1333,  1333,
     909,   169,   259,   379,   933,   275,   288,   283,   284,   282,
    1793,   299,  1793,   299,     0,     0,     0,     0,   285,   280,
     281,   277,   290,   291,   917,     0,   305,   308,   292,   273,
     276,   274,   257,     0,     0,  1678,     0,     0,   878,     0,
       0,   160,   920,     0,   140,   142,   144,     0,   138,   146,
     141,   143,   145,   139,   147,   137,     0,   136,     0,     0,
       0,   130,   951,   913,   470,   475,   915,   478,   938,   476,
    1709,  1767,  1896,     0,   518,   520,     0,   525,   957,   914,
       0,   937,   953,   922,     0,     0,     0,     0,     0,     0,
       0,  1055,     0,     0,     0,   952,   929,   940,     0,   921,
     916,   939,     0,     0,   211,   210,   212,     0,     0,     0,
       0,     0,     0,     0,     0,   701,   677,   700,     0,     0,
       0,     0,     0,     0,     0,   671,   337,   315,   316,     0,
       0,   314,   320,   612,     0,     0,     0,  1315,  1311,     0,
       0,     0,     0,     0,     0,  1331,     0,     0,  1038,  1038,
    1038,  1038,  1038,  1038,  1038,  1019,  1047,   496,   514,     0,
       0,     0,     0,   151,   128,     0,   634,   600,     0,     0,
     412,   174,     0,     0,     0,   502,   599,   597,   596,   598,
       0,     0,     0,   617,     0,  1307,     0,     0,     0,     0,
     366,     0,     0,   363,   367,   371,   372,   373,     0,   455,
     457,     0,     0,   447,     0,     0,     0,   820,     0,   838,
     821,     0,     0,     0,   858,   863,   859,   841,     0,   486,
    2114,  2108,  1167,  1168,     0,  1182,     0,  1272,     0,  1271,
    1283,     0,     0,  1289,  1287,     0,  1289,     0,  1289,     0,
    1264,     0,  1266,  1283,     0,  1673,     0,  1304,  1132,   299,
       0,     0,   508,   299,     0,   299,     0,   299,   299,     0,
     978,   535,     0,   585,     0,     0,   299,   647,  1599,     0,
       0,  2253,  2441,   738,   414,     0,     0,     0,     0,   749,
       0,   484,   753,     0,   764,   759,   761,     0,   768,     0,
       0,  1129,     0,  1145,  1138,  1140,  1139,     0,     0,  1136,
    1605,   646,     0,     0,   299,     0,   769,  1211,  1606,  1607,
       0,     0,     0,     0,  1641,     0,     0,  1518,  1494,  1496,
    1332,  1508,     0,  1345,  1519,  1520,  1498,  1500,     0,  1589,
       0,     0,  1509,  1453,  1454,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1466,  1465,
    1510,  1571,     0,     0,  1628,  1629,  1511,  1375,  1376,  1376,
       0,     0,  1635,     0,     0,     0,  1516,  1521,     0,     0,
    1526,     0,  1547,     0,     0,     0,  1476,  1599,  1367,  1368,
       0,     0,     0,     0,     0,     0,     0,     0,  1450,  1433,
    1427,     0,  1431,  1435,     0,     0,     0,     0,  1419,  1445,
    1415,     0,     0,  1421,     0,  1446,  1206,  1206,  1206,  1206,
    1203,     0,     0,  1259,     0,  1244,  1215,  1215,     0,  1555,
       0,  1484,     0,  1555,     0,     0,  2303,  2305,  2306,  2307,
    2308,  2309,  2311,  2312,  2314,  2315,  2316,  2304,  2310,  2313,
    2317,  2294,  2295,     0,  2285,  2286,   196,     0,   220,   207,
       0,  2328,     0,     0,  1150,  1131,  1153,  1072,  1218,     0,
    1590,   809,   807,   808,  1220,     0,     0,  1255,  1254,  1253,
    1228,     0,  2228,  2156,     0,     0,  2327,  2330,  2341,  2339,
    2166,   941,   905,   934,  1038,   779,   780,     0,   778,     0,
       0,     0,   404,   794,     0,     0,     0,     0,  1052,   495,
       0,   494,   490,   510,   843,     0,  1333,   818,   823,   824,
       0,   376,     0,     0,     0,   260,     0,     0,   272,     0,
     268,   286,   278,   287,   279,   302,     0,     0,     0,   947,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   948,
       0,     0,   133,   132,     0,   150,     0,   522,   523,   521,
     517,     0,   524,   526,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   946,   910,   672,     0,
       0,   673,   681,     0,     0,   674,     0,     0,     0,     0,
       0,     0,   683,   340,     0,   343,   350,   324,   328,  1054,
    1054,     0,   329,  1054,   325,  1054,   322,   614,     0,  1846,
    1579,  1580,   608,   615,   605,   607,   606,   609,   580,     0,
       0,     0,  1316,     0,  2542,  2550,  2549,     0,  1390,     0,
    1038,  1037,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   390,     0,     0,   384,     0,     0,   863,   378,
     381,   382,     0,   507,   153,     0,     0,   154,   152,     0,
     602,   603,     0,   362,     0,     0,   555,   558,   551,     0,
     616,   618,   594,     0,  1309,   514,  1122,   460,     0,   443,
     397,   439,     0,   453,     0,   441,   440,   442,     0,   449,
    1016,     0,   795,   819,     0,     0,     0,   856,   860,   857,
       0,     0,   834,     0,   842,   812,   973,   974,   971,   972,
       0,     0,  2131,  1158,  2140,  1274,  1281,     0,  1262,     0,
    1288,  1284,     0,  1285,     0,     0,  1286,     0,     0,  1281,
       0,     0,     0,   875,     0,   299,   873,     0,   641,     0,
     643,   877,   299,   299,   543,     0,   499,   457,     0,     0,
       0,     0,   748,   766,     0,   762,     0,     0,   731,   771,
    1125,  1128,  1130,  1143,  1141,   774,     0,   732,   773,  1610,
    1351,     0,  1643,  1639,     0,  1611,     0,  1623,  1622,  1452,
    1624,     0,  1471,     0,     0,  1463,  1461,  1462,  1455,  1456,
    1457,  1458,  1459,  1460,  1464,  1633,  1632,  1626,  1627,  1371,
    1369,     0,  1513,  1514,  1515,  1634,  1522,     0,  1541,  1540,
       0,     0,     0,  1528,     0,     0,  1537,     0,  1573,  1357,
    1390,  1395,     0,     0,  1418,  1638,  1436,     0,     0,     0,
    1414,     0,     0,     0,     0,  1423,  1589,     0,     0,     0,
       0,     0,     0,  1198,  1197,  1302,     0,  1246,     0,     0,
    1214,     0,  1555,  1491,  1558,  1553,  1554,  1603,  1485,  1690,
       0,  1601,  1555,     0,     0,     0,  1652,  2326,     0,  1157,
    1148,     0,  1219,  1236,  1229,  2172,     0,  2227,  2292,  2293,
       0,   785,   786,   784,     0,     0,     0,   580,     0,     0,
     420,     0,   803,   803,     0,     0,   863,   956,   491,   844,
       0,   836,     0,   265,   932,     0,     0,     0,   264,     0,
     299,   299,   306,   307,   310,     0,     0,     0,     0,     0,
     635,   621,     0,     0,   636,   637,     0,     0,   880,   881,
     879,   148,   134,   135,   149,   519,   918,     0,     0,     0,
       0,     0,   955,   928,   954,   926,   925,   927,   919,   545,
       0,   675,     0,     0,   676,   687,   685,   684,   686,   678,
     341,   127,     0,   321,     0,   348,     0,   346,   345,   347,
       0,     0,     0,     0,     0,     0,   582,     0,     0,   587,
     576,   578,     0,     0,     0,  1312,     0,     0,     0,     0,
       0,     0,  1317,  1325,   575,     0,  1029,  1028,  1027,  1031,
    1030,  1033,  1032,  1024,  1023,  1036,  1035,  1022,  1021,  1026,
    1025,     0,     0,   388,   392,   393,   391,   383,   863,   412,
     451,     0,   156,   155,     0,     0,     0,     0,   560,   564,
     595,     0,  1308,   539,  1120,     0,  2097,     0,   369,   374,
     375,     0,   447,   394,     0,   443,   368,   456,     0,     0,
     452,     0,  1011,     0,     0,   822,   839,   840,     0,     0,
     863,   862,     0,   493,     0,  2104,  1273,     0,     0,  1275,
       0,     0,  1277,  1279,     0,     0,     0,     0,     0,  1676,
    1555,  1305,   299,   509,   299,   299,   979,   586,     0,   758,
     757,   756,   485,     0,   760,   299,     0,  1642,  1507,  1517,
    1621,     0,     0,  1472,     0,     0,  1512,  1982,     0,     0,
    1545,  1546,  1527,     0,  1831,  1532,     0,     0,     0,  1693,
    1442,  1440,  1437,     0,  1438,     0,     0,  1420,  1416,     0,
    1422,  1447,  1202,  1201,  1200,  1199,     0,     0,  1549,  1555,
    1555,  1486,  1560,  1557,     0,  1488,  2296,     0,  2299,  2297,
    2298,  2302,  1390,  1154,     0,  2229,  1044,     0,     0,     0,
     406,     0,   863,     0,     0,     0,   801,   806,   806,     0,
     863,   451,   837,   261,   262,   263,   266,   301,   271,   267,
       0,   949,   911,     0,     0,   627,     0,     0,     0,     0,
     950,   912,     0,     0,     0,  1060,     0,     0,   679,   680,
     323,     0,   344,   353,     0,   351,   326,   331,     0,   333,
     332,   327,   330,   584,   583,   581,   577,   579,  1313,     0,
     894,   894,  2543,  2544,  2545,  2546,  2547,  2548,     0,   580,
    1034,     0,     0,   380,   451,   419,     0,   385,     0,   515,
       0,  1016,   364,   514,   559,     0,     0,     0,   619,   458,
       0,   365,     0,     0,   449,     0,     0,     0,   447,     0,
     444,     0,   448,     0,     0,     0,     0,     0,   861,     0,
     865,     0,   833,   810,  1303,     0,   497,  2130,  2134,     0,
    1282,  1291,     0,  1278,  1276,  1267,     0,  1269,   895,   642,
     644,   544,   763,   770,   299,  1467,     0,     0,     0,     0,
    1523,     0,  1524,  1529,  1533,     0,  1530,  1531,  1439,  1443,
    1441,  1424,  1243,  1245,     0,  1183,  1489,  1490,     0,  1215,
    1555,  2301,  2300,   221,  1591,   764,     0,   299,   803,   451,
     421,  1846,   422,   802,   809,   809,     0,   451,   580,     0,
     269,   309,     0,     0,   633,   622,     0,     0,   638,     0,
       0,     0,     0,     0,   682,   313,   339,   349,     0,   334,
     894,     0,   891,   890,   574,     0,   387,   386,     0,   430,
       0,   513,     0,   631,  1012,   527,   561,   562,   557,     0,
       0,   459,   370,   379,   355,   403,   402,   399,   398,   400,
     401,   396,   395,     0,   449,   445,   446,     0,  1013,     0,
    1062,     0,   796,   864,     0,     0,     0,   492,   487,     0,
    2132,  1280,     0,  1268,   733,  1468,     0,  1469,     0,     0,
    1535,  1534,  1548,  1550,     0,     0,  1563,  1487,   781,     0,
     782,   806,   425,     0,   799,   798,   412,   580,   407,   300,
       0,   625,   632,   623,   633,     0,     0,  1056,     0,  1057,
    1058,  1061,   352,   889,   893,   892,     0,   416,   417,   418,
       0,   389,   426,   427,     0,   516,     0,     0,     0,     0,
     377,   438,   354,  1014,  1015,   304,     0,   863,   866,   977,
    2135,  2137,  2136,     0,  1290,  1470,  1538,  1525,  1536,     0,
       0,  1559,     0,     0,     0,     0,   809,     0,   580,     0,
     419,   408,     0,   624,   640,   639,     0,     0,     0,     0,
       0,   428,     0,   429,   450,   630,     0,   563,     0,     0,
     449,   797,   811,   976,   975,     0,  2133,  1551,  1552,  1947,
       0,  1924,     0,  1561,  1564,  1562,  1556,   299,   800,     0,
     409,   423,   430,     0,  1059,   564,   435,     0,   434,     0,
     432,   431,   620,   567,   303,  1303,   959,   970,   958,   960,
     968,   965,   967,   966,   964,     0,  1568,  1567,  1566,  1570,
    1569,   783,     0,   580,   626,     0,   433,   437,   436,   572,
       0,   565,   568,   573,   571,   569,   570,   787,     0,   969,
     963,  1182,  1169,     0,   424,   410,     0,   546,     0,   961,
     970,  1565,     0,   566,   962,     0,   567,     0,   547
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,   247,   248,  1652,  2450,  2353,  3053,  3054,   249,
     250,  1707,   251,   252,   253,   254,   255,   256,   257,  1683,
     258,   259,  1239,  1833,  2461,   260,  2265,  1037,  2140,  2141,
    2405,  2142,  2130,  1510,  1931,  1653,  1675,   262,   263,  1504,
    2122,   264,   265,   266,  1696,  1697,  1660,  1876,  4220,  2342,
    4400,  2915,  2916,   267,   268,  3019,  1778,  3021,  3022,  3486,
     851,  2428,  3841,  3842,  3474,  3475,  3848,  4084,  4085,   269,
    1830,  3082,  3559,  3083,  3917,  3084,  3918,  3085,  3919,  3046,
    3529,  3530,  3531,  3086,  3923,  4271,  3087,  2280,  1361,  1958,
    1959,  4249,  3769,  3770,  4378,  4341,  4342,  4343,  4430,  3925,
    3093,  3569,  3930,  4117,  1850,  2492,  3088,  3089,  3916,   270,
     271,  2487,  1722,  1723,  2359,  3492,  3172,   272,  1256,  3391,
    4156,  3047,  3048,   273,   839,   274,  1837,   275,   276,   277,
     278,  3533,  4118,  1727,  2963,  2964,  2965,  2966,  3442,   279,
    1835,  1728,  2470,   280,   281,   282,  2394,   283,   284,   285,
    1844,  2481,  2482,  3909,  4125,  4258,  4127,  4460,  4461,  4109,
    3859,  3860,  3861,   286,   287,   288,   289,  1829,  2453,  2454,
    3493,  1642,  1782,  2430,  2431,  3549,  3550,   290,  3800,  3801,
     878,  4347,  4323,   291,   292,  3804,  3805,   293,   294,   295,
     296,   297,   930,  1306,  1307,  2889,   298,  2157,   299,  1218,
    3006,   300,   964,  1333,  1334,   301,   302,   975,  2619,   977,
    1972,  3174,  3175,  3638,  2584,  1153,   303,   304,  2594,  2622,
     305,  1655,  2271,  2272,  3764,   306,   879,  1855,  2495,  2858,
    4281,  3771,  4047,  2799,  3354,   307,   880,  1679,  2308,  2498,
    3098,  3099,  2310,  2758,  3581,  2312,  3100,  3105,  3106,  3107,
    3577,  3585,  4150,  4151,   308,  1677,  2301,   309,   310,   311,
    1702,  1170,   312,   902,   903,   313,  4242,   314,  1276,   315,
     996,  1992,   316,  2323,  3406,   317,   318,   319,  4438,  4468,
    4469,  4470,  3590,  4405,   320,  4440,  1376,   322,   323,   324,
     842,  1190,  1191,  1192,   325,  3932,   326,   327,  2447,  3045,
    3512,   328,   329,  2266,  2848,   330,   331,   332,  1823,   333,
     334,   335,   336,  1760,   337,  1543,  1544,   338,   339,   846,
    1057,  1547,  1555,   340,   943,  1327,  1328,  1329,  1933,   341,
    1380,  2611,   944,  1320,   945,  1978,  2596,  2597,  2600,   946,
    1871,   345,  1982,  2605,  2608,   947,  2161,  2162,  2163,  2164,
    2165,  2783,   948,   966,  1266,  2506,   949,  1464,   350,   351,
     352,   353,  1061,  1062,  2100,  2748,   984,  1561,  1022,  1072,
    3730,  2178,  2179,  2199,  2200,  1570,  1571,  2189,  2191,  2801,
    2192,  2810,  2184,  3727,  4018,  2195,  2196,  1573,  1574,  2805,
     354,  2752,  2510,  2511,  2512,  3119,  3129,  3601,  3952,  2513,
    1370,  1054,  2514,  3305,  2519,  3074,  3075,  2313,  2438,  1804,
    1465,  1805,  2445,  1466,  2024,  1807,  1467,  1468,  1469,  1810,
    1470,  1471,  1472,  1473,  2008,  2064,  1474,  1475,  2043,  1101,
    1102,  1918,  2661,  1477,  1478,  3696,  3997,  3988,  2686,  2687,
    2137,  3692,  4195,  4302,  4303,  3738,  3735,  4022,  4199,  4374,
    4413,  4414,  1479,  2739,  2092,  1172,  1480,  3495,  2094,  2681,
    2760,  2761,  2254,  2006,  2628,  2644,  2645,  2658,  3221,  2665,
    2670,  3244,  3245,  2682,  2708,  1481,  2631,  2632,  3205,  2010,
    1482,  1533,  1534,  2108,  2704,  1550,  1551,  1059,  1483,  1484,
    1973,  1046,  3948,  1284,   691,  2924,  2152,  1194,   981,  1485,
    1486,  1487,  3176,  1597,   670,   671,  1139,   795,     2,    75,
     950,  3079,   358,   359,   882,   883,   884,  1258,  1259,  1860,
    1863,  1602,  2232,   672,   673,   700,  3945,  4157,  4290,   936,
     360,   361,   362,   363,  1598,  2228,  1103,    76,    84,    77,
    1104,   400,   401,  2210,   364,   812,   365,  1579,  1083,  3362,
     366,   367,   368,   369,   370,   933,   371,  1085,   372,  1086,
     373,   374,   375,   376,  1093,   377,  1581,  1582,  3757,  1583,
     378,   379,   693,   694,  1318,   380,   381,  1120,  1121,  1352,
    1353,  1608,  1623,  1624,  1625,   382,   687,   383,   384,   385,
    1614,  1615,   386,  2115,  2116,  2237,  2117,   387,  2824,  2825,
     388,  3331,  3332,  4029,  3333,   389,  2111,   390,   391,  1049,
    3367,   392,   808,   393,  1134,   674,   675,   676,  1141,   798,
    1009,   701,  1143,  2967,   800,   801,   678,   679,   680,  1953,
      78,  2832,  1954,  1489,   702,  1490,  2106,  1491,  1492,  1493,
    1494,  1495,  1631,   684,  1110,  1310,  1311,  2833,  1313,    82,
    1314,   397,  3507,  1921,  1354,  1939,  1940
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -4053
static const int yypact[] =
{
   -4053,   422,  7641, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, 20592, -4053,
   -4053, -4053, -4053, -4053, 91296,   345, -4053, -4053, -4053, 57696,
   -4053, -4053, -4053,   217, 62976, -4053, 66336,   738, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, 70176, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, 50004,  1101, -4053,
     376, -4053, -4053, -4053, -4053, -4053, -4053, -4053,   -89,  4634,
   -4053, -4053, 66816, -4053,   120, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, 67296,   382, -4053,   462,  1018, -4053,    97, 11065,
   -4053, -4053, 58656, 63936, -4053, -4053, 70656,   767,   182,  1888,
   10606,   -89, 20109, 71136, -4053,  1887, -4053, 47083, -4053, -4053,
   -4053, 63456, -4053, -4053, -4053, -4053,   978, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, 77376,  2399,   728, 47572, -4053,
   -4053, -4053, -4053, 77376, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, 71616, -4053,   843,   637, 77856, 78336,
   60576, -4053,  1129, -4053, 77376,   248, 49523, -4053, 78816, -4053,
   -4053,   867, -4053, 72096, -4053, -4053, -4053, -4053,   728, -4053,
   50004, 44654, 72096,   192,   784, -4053, -4053, 79296, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053,  1826,   975, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,   382,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,   557,
   -4053,   663,  1150,  1237,  1059, -4053, -4053, -4053, 18851, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, 92727,  1717, -4053, -4053,
   -4053,  1081, -4053,  1124, -4053, -4053, -4053,   804, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053,  1060, -4053, -4053, -4053, -4053,
    1617, 91773, 70176, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, 58176, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053,   160, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, 70176, 70176, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, 70176,  1244, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053,   392,  1442, -4053, -4053, 50004,  2475,
    2475,  1696, 92727, -4053, -4053, -4053, 50966, 77376, 77376,  1445,
   77376,  1663, 50966, 77376, 77376,  1505, 40733, -4053, 77376, 77376,
   77376, 77376, 72096, 77376,  1458, 77376, 77376, 79776, 77376,  1585,
   -4053,  1834,    92, -4053, -4053, -4053, 77376,  9162,  2399, -4053,
   -4053, 77376,  1462, 50966, 77376,  1433,  1515, 77376, -4053, 77376,
    1769,  1591, 77376,  1712, 41226,  1606, 77376, 77376, 77376, 77376,
   -4053, -4053,  1603, 77376, 77376, -4053, 80256,   902,  1842,  1780,
     595, -4053, -4053,  1962,  1548, -4053, -4053,  1988, 70176, -4053,
   67776, -4053, -4053, -4053,  2048, -4053, 72096, -4053, -4053, -4053,
   -4053, 61056,  1888, -4053, -4053, 51447, 77376,  1827, -4053, 80736,
   -4053,  1903, 51928, 81216, -4053, 41719,  1964, 81696, 82176, -4053,
   -4053, 82656, -4053, 83136,  1705, 83616, -4053, 84096, -4053,  1831,
   84576, -4053,  8718, -4053,  1604,  2091,  1646,  1235, 70176, 70176,
    1931, 36368,   382, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053,   320,  1243, 48061,   883, 48550, -4053, -4053,   897,  1001,
    1250,   320,  2080,  2080,   229, 70176, -4053, -4053,  1243, -4053,
     203,   -37,  1651,  1651,  1651,  1862,   359, -4053,  1651, 77376,
   -4053, -4053, -4053, -4053, 72096, 48061, 48550, -4053,  1697,  2399,
      63,  2092, 77376, -4053, 77376, -4053, 77376, 77376, -4053, -4053,
   -4053,  2110,  1720,  1958, -4053,  1737, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053,  1904,  1920,  1926,   106,  2399,  1836, -4053,
   -4053,  1952, 25496,   800, 70176,  2399, 49039, 72576, 89376,   311,
   61056,  2399, 85056,  1792,    92,  1971, -4053,   460, -4053,  2199,
    1833,  2035,   -22,    92, 38304, -4053,  1830,   925, 72096, 93204,
   -4053, -4053, -4053, 85536,  1930, -4053,   155,  2106, 25994, -4053,
   77376,  1841, -4053,  1852,  1855,  1868, -4053, 77376,  1005,  1005,
    2241,  1005,  1204,  1572, -4053,  1877, -4053,   784,   -89,  1878,
   -4053, -4053, -4053,  1912, -4053,  1867,  1890, -4053,   421,  2149,
   -4053, -4053, -4053, -4053,  1982,  1993,  2000,  2011,  1933,  2024,
     260, -4053, -4053, -4053, -4053,  2216, -4053, -4053, -4053, -4053,
   -4053, -4053,  2352,  2341, 58656, 58656,   556,   579,   128,   220,
   -4053, -4053, -4053,  2222, -4053, -4053,  2204, 77376,  2058, 77376,
   -4053, -4053, -4053, 86016, -4053, -4053,  2475,  1912,  1976, -4053,
     178, -4053,   925, -4053,   323,   386,   473,  1314,  1989,  1417,
   -4053,   361,  2034,  2089,  1995,   447,  1892,   260, -4053, 77376,
   77376, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
    2010, -4053, -4053,  2018,  1550,  1378,  6070,   729,  2576,  1755,
     555,  2201,  1555,  2333,  1744,  3036, 77376,  2037,  2313,   446,
   -4053,   593, -4053,  2145,  2273,   615, 50966,  2111, -4053, 77376,
   -4053, -4053, -4053, 50966, -4053,  2296, 42212, -4053, 77376, -4053,
   -4053, -4053, -4053,  2237, 77376, -4053, -4053,  2366, 77376, -4053,
    1651,   249,  2141,  2512, 54333, 77376,  2183,  2549,  2202, -4053,
   -4053,  2183, -4053, -4053, 77376, 77376,  2176,  1598,  2183,  2568,
    2575,  2254,  2358,   677,  1201,    75,  2482,  2183, 77376, 77376,
   77376, 77376,  2559, 50966, 77376, -4053,  2374, 73056, -4053,  2233,
    1962, -4053, -4053, -4053, -4053, -4053,  1200,  2271, -4053, -4053,
   -4053, -4053,  2535,  1976,   112,  2542,  2253,  2546, -4053,  2300,
    2550,  1995,  2572,  2285, -4053, 86496, 86976,  2582,  2010, 77376,
    2588,  2285,  2589,  2476,  2596,   112,  2597, -4053,  1091,  2604,
    2495,  2622,  1540,  2285, 61536,  2626,    67, -4053, 10613,  8718,
   -4053, 18192,  1421, -4053, -4053, -4053, -4053, -4053, -4053, 29480,
     620,  2424, -4053, -4053,   784, -4053, -4053,  1654, -4053, 46594,
   -4053,  1931,  1243, -4053, 70176,  1243, 70176,   229,  1243, 70176,
    1243, 70176,   229,  1243, 70176, 70176, 70176,  1243, -4053, -4053,
    1395,  1756, -4053, -4053, -4053, -4053, -4053, 70176,  2357, 77376,
   77376, -4053, -4053, -4053, 64416, 77376, 64896, -4053,   427, -4053,
     119, 70176, -4053, 70176, -4053,  2399, -4053, -4053,  2091, 54333,
    2752, 77376,  2641,  2641,  2641, -4053, -4053, -4053,  2586, 77376,
    2646,  2658, 64416, 77376, -4053, 87456,  2389, -4053, -4053, -4053,
   -4053,  1685,  2555,   433,  2688, 29480,  2390,   351,   351,  2395,
   -4053, -4053, -4053,   491,  2400,  2401, -4053,   239,   239,  2556,
    2403,  2406, -4053,   511,  2411, -4053,  2812,   565,  2423,  2426,
    2429,  2041,   351, 29480, -4053,  2432,   239,  2433,  2434,  2436,
    2834,  2438, -4053,  2845,  2446,   276,   360,  2447,  2451, -4053,
    2403, -4053,   402,  2452,  2453,  2454,  2456,  2459,  2460,  2461,
   29480, 29480, -4053, 24500, -4053,  2399, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053,    98, -4053,   690,  4289, -4053, -4053,  2627,
   29480, -4053, -4053,    57, -4053,   705, -4053, -4053,   925, -4053,
   -4053,  1383, -4053, -4053, -4053, -4053,  1648,  1648,   162, -4053,
   66816, 66816, -4053, -4053,   937,  2421, -4053,  1026, -4053, -4053,
   -4053, -4053, -4053, -4053, 59136,  2859, -4053,   797,   593,  1403,
    2804, 45616, 46105,  2703,  2703,  2689, -4053, -4053, 77376, -4053,
   -4053, 29480, 43692, -4053,   925,   126,  2704, 77376, -4053, 38788,
   -4053, -4053, -4053,  1690, -4053, -4053, -4053,   382, -4053, 10808,
   -4053,  1694,  1841, 77376, 77376,  2866, -4053, -4053,  1852, -4053,
   -4053,  1237,  1237, 29480,  1237,   899,  1153, 26492, 29480,  2756,
    2653,   125,  1256,  2762, -4053,  1204,  1572, -4053, -4053,  1912,
    2490,  1754, -4053, 56256, 92250, 92250,  2726, -4053, -4053,   794,
      40,  2600,  2693,  2080,   688,  1724, -4053, -4053,  2487, -4053,
    2813, 66816,  2543, 58656, -4053, -4053, 77376, -4053, -4053, 73536,
   -4053, -4053, -4053,  1629,  2491, -4053,  2511, 77376,  2987, -4053,
    1724,  1724, -4053, -4053,  2503, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, 92727,  2507, 77376, -4053,  2508,  2509, -4053,
   93204, 44173,  1558,   925,  2581,  2583, 50004,  2514,  2584,  2587,
   89856, -4053, -4053, -4053, -4053,  1346,   787,   589,  2592,   552,
   -4053, 77376,  2692,   260,  2630, -4053,  2593,  2595,  2711,   260,
     866, 90336, -4053, -4053, -4053, -4053, -4053,  2361, 22546, -4053,
   -4053, -4053,  2599,  2594, 59616,  2889,  2705,  1163,  1045,   459,
   77376,  2782,  2603,  2605,  2536,  1477,  2534, -4053,  2699,  2598,
    2601, 53371,  2706, 42705,  2869,  2614, -4053,   599,  2619,  2620,
     260, -4053,  2930,   260,   260,  1394,  2931,  2624,   207,  1282,
    2183,  2534,  1355, -4053,  2560,  2632,  1423, -4053,  2733,    93,
    1333,  2534,  2635,  2637,  2536,  2536, 77376, 77376, 77376, 77376,
   77376,  2643,  2644,  2671, 68256,  2645, 89376, -4053, -4053,  2648,
    1676,  2534,  1418, -4053,  1360, -4053, -4053,    92, -4053, 77376,
   -4053, 77376,  1976, 54333,  2744,  1995,   260, 77376, 77376,  2010,
     929,  1231,  2745, 77376,  2815,  2612, -4053, -4053,  2183, -4053,
   44173,  2176, -4053,  2590, -4053,  2628, -4053,  2628,  2628,  2591,
    2591,  2602, -4053, -4053,  2041,  2628,  2591, -4053, 55295, -4053,
    1497,  1662, -4053,  2978,  2988, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053,  1251, -4053,  1710, -4053, -4053, -4053,
    2999, -4053, -4053, 54333, 77376, -4053,  2916,  2650, 50004, -4053,
    2647, -4053, 77376,   179,  2399,  2636, 77376,  2814, 77376, 77376,
   77376, 77376, -4053, -4053,   756,    16, -4053, 68256, -4053,  1355,
    2998,   -54,  1651,  2886, -4053, 77376,  2607,  3007,  2844, -4053,
   -4053,  2616,  2080, -4053,  2233, -4053,  1925, -4053,  2737, -4053,
   33450,  2663, 50966,   112, -4053, -4053, -4053, -4053, 54333, 77376,
   87936, 50966,   112, 77376, 77376,  2918,  2680,  2921,  2682, 42705,
     112,    69, 77376, 77376, 77376, 77376, -4053, 77376, -4053, -4053,
   -4053, -4053, 77376, 77376, 77376, 68256,  2923,  2924,   112, 77376,
   77376, -4053, -4053, 13086,  1557, -4053,  8718, -4053, 10808,  1722,
    2703, -4053,  1244, 77376,  1375,  1931, 65376, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, 70176, -4053, 70176,   229, -4053,
   -4053, 70176, -4053, 70176,   229, -4053, 70176, -4053, -4053, -4053,
   70176, 77376,  3125,  2638, -4053,  1383, -4053, 77376,  1729, -4053,
   -4053,  1739,    77, 77376,    95, 50966, 77376,  2817, 77376, 77376,
   77376, 77376,  2710,  2421,  1206, -4053,  2684, 37820,  2767, -4053,
     169, 72096,  2827, -4053, -4053, -4053, -4053, -4053,  1766,  1453,
     745, -4053, -4053, -4053, -4053, -4053, -4053, 64896, 63456,  2919,
     127, 77376, -4053, 29480, 24998, -4053, -4053, -4053,  2649, 10808,
    2687, 29480, -4053, -4053, 29480,  2080,  2080, 29480, -4053, -4053,
   -4053, -4053,   961,  2080, -4053, 29480, 29480,  2080,  2080,  2628,
    2628, -4053,  5311, 29480, -4053, 42705, 29480, 30974, 22047, 29480,
    2717,  2673,  2080, -4053,  2080, -4053, 29480, 24002, -4053, 29480,
    2862, 29480,  1403,  2864, 29480,  1403,  3071,  3071,  1543,  4918,
    2660, -4053,  2768,  2080, -4053,  2080,   610,   165, 54333, 29480,
   50004,  2736,   139, 29480,  2666,  2072, -4053, 29480,   176, -4053,
    2667, 29480,  2740, 29480, 29480, 29480, 29480, 29480, 29480, 29480,
   29480, 29480, -4053, 31970,   265, -4053,   -47,  1507, 65856, 25496,
    2946, -4053, 21548, -4053,   292, 70176, -4053, -4053,   925, -4053,
   -4053, -4053, -4053, -4053,  1629,  2669, -4053,  2690, -4053, -4053,
   -4053, -4053, -4053, 77376,  2859, -4053, -4053,  2741, -4053, -4053,
   -4053, -4053,   783, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
    2672, -4053, -4053, -4053, -4053,  2672, -4053, -4053,  2703,  2677,
    3331, -4053, -4053, -4053, -4053,  2940,  2941,   112, 92727, -4053,
   77376,   167, -4053, -4053, -4053,  2694, -4053, 77376,   155, 68736,
   -4053, 25994, -4053,  1816,  2403, -4053,  2926, -4053,  2691, -4053,
    7920,  2926, -4053, -4053,   205,  2856,  2863,  2863, -4053,  2696,
   10808, -4053,  1906, 10808,  1955, -4053, -4053, -4053, -4053, -4053,
   -4053,  1185, -4053,  2756,  1256,  1941, -4053,  1912, -4053, -4053,
   19550, -4053, 21069, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053,  2700, -4053, -4053, -4053, -4053,   260,  2707,  3158,
   -4053, 58656, -4053, -4053, -4053,  3125, -4053,  1988, -4053,  1988,
    3183, -4053, 70176, -4053, -4053, -4053, -4053,  1090, -4053,  8718,
   -4053,  8718, -4053,  2708,  1828,  2770,  2774,  2807, 77376, 77376,
   -4053, 50004, 77376, 77376, 77376, -4053,  3049,   924, 63456,  2820,
   62016, -4053, -4053,  2713, 77376,  2757,  2944,  2945,  2716, -4053,
   -4053, 77376, -4053,  2894, 77376, 29480,  2900, 77376,  1368,  2901,
   -4053,   950, 77376, 77376,  2893, -4053, -4053, -4053, 61056, -4053,
   -4053, -4053,  2887, -4053, -4053, 55295, -4053, -4053,  1844, -4053,
   54814, 52409, -4053, -4053,   935, 77376, 77376, 77376,  1036, -4053,
   -4053, 54333, -4053, 77376, 77376, 77376, 69216, 88416, 88896,  1181,
    1255, 77376, 69696, -4053, 77376, 77376, 77376, 50004, -4053, 77376,
    2902,   676, -4053,  3131,  2796, 77376, 77376,  2725,  1859,  2799,
   -4053, 77376, 77376,  3853, -4053, 77376, 77376, -4053, -4053,   260,
   -4053, -4053, -4053, -4053, -4053, 77376, 77376,   260, 77376,   260,
     927, -4053, 50485, 77376, -4053, -4053, -4053, 77376, 77376, 77376,
   77376, 77376, -4053, -4053,   884,   898,  2865,  2868,  2870, 77376,
   77376, 77376, -4053, -4053,  2837, -4053, 77376,  3853, 77376, 77376,
    2809,  2818,    56,  2875, -4053, -4053, -4053, -4053, -4053, -4053,
    2976,  3137, 77376,  2983,  2985,  2794,  2802,  2989,  1514, 77376,
   77376, 77376, 77376, 77376, 77376,  2993,  1514,  2928,    58,  2754,
    1869, -4053,  2775, -4053, 29480,  3156, 54333,  2765,  2766,  2835,
   -4053,  2838,  2080, -4053,  1874, -4053,   756,  1782, -4053,   436,
   10148,  3047, 77376,  1880, -4053,  2785, 77376, 10148, -4053,  1731,
   63456, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
    3052, -4053,  2399,  2176,  2176,  2176,  2176, -4053, -4053, -4053,
    2953,  1546, -4053,  2777, 77376,  2885, 10148, -4053,  1355,  3072,
   77376, 60096,  1999,  3174,  2399,  2956, -4053, 23031,  3644,  2958,
   61056, 73056, -4053,  2791,  3050,  3051,  3069, -4053, 32966, 74016,
    2787,  2099, -4053, 74016, 74496, -4053,  2792,   925, 26990,  2767,
    1976, -4053,  3185, -4053,  3087,   112,  1995, -4053,  2285, -4053,
   77376, 77376, 77376, 77376,  2010, -4053, -4053,  2285,  2972,   112,
     112, -4053,  2973,   112,  2285,  2907,  3082, 61056, -4053,    67,
   -4053, -4053, -4053, -4053, -4053, 29480, -4053, -4053,  2821,  1925,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, 70176,  1988, -4053,  1896, -4053, 77376, -4053,  3059,  3073,
    3074,  2285,  2847, 77376,  2822, -4053,  2285,   260,  2285,  2421,
    2421,  2285, 74976,  3228,  3093, -4053,  1900, -4053, -4053, 25496,
   -4053,    65, -4053,   479,   568,  3031, -4053, -4053, -4053, -4053,
   54333, -4053, -4053, -4053, -4053, -4053, 77376,   180,  3002,  2826,
   74976,  3209,   112, -4053,  1905, -4053,  1571, -4053,  1635, 29480,
   29480,   110, -4053,  8343,  1914,  2831,  2833,  1918, -4053, -4053,
   -4053, -4053, -4053, -4053,  2836,  3111, -4053, -4053,  2840,  1949,
    1961,  2841,  2846, -4053, -4053,  3984,  2848,  9182,  2849, 30974,
   30974,  2190, -4053, -4053, 30974,  2850, -4053,  1980,  9158,  2842,
    2851,  2855, -4053,  2857,  2858,  9610, 27488, 29480, 27488, 27488,
    9728,  2842,  2860,  1986, 50004, 10057,  1997, -4053, 29480, 50004,
    4720, 29480, -4053, 29480, 77376,  2861,  2871, -4053, -4053,  5311,
   -4053,  2874, -4053, 30974, 30974,  5453, 24500, -4053, -4053,  3114,
   -4053, -4053,  2331, -4053,  2867, -4053, -4053,  5877,   196, 29480,
    2666, 29480,  2934, 42705,  9947, 29480,  4955,  6064,  6064,   590,
     590,    94,    94,    94,  1489,  1507, -4053, -4053, -4053,  2873,
    2438, 29480, -4053,  2084,  2100, 77376,  6840, 10999, -4053, -4053,
   -4053, 33450,  2882, 29480, 29480, 29480,  2876,  3013,  3275, 10808,
     572, -4053,  3277, -4053, -4053, -4053,   187,  3183,  1629, -4053,
      92,  2080,   610, 46594, -4053, -4053, -4053, 29480, -4053, -4053,
   -4053, -4053, -4053,  2025, 38788,  2663, 25994,   925,  1852, -4053,
   -4053, -4053, -4053, -4053, -4053, 29480, -4053, -4053,   559,  2046,
   29480,  1906, -4053, -4053, 77376,  2827,  2827, 29480, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053,  -152, -4053, -4053, -4053, -4053,
   -4053, -4053,  2881, -4053,  2877, -4053,  2879, -4053, -4053, -4053,
   -4053,   133,  2891,  2890,  2896,  1521, -4053, -4053, 77376, 77376,
   77376, -4053, -4053, -4053, -4053, -4053, -4053,  3088, -4053, 77376,
   77376,  3044, 77376,  3042,  3048, 29480,  1270, 77376,  2898,  2899,
    2903, 77376,   112, -4053, -4053, 10808, -4053, -4053,  2943,  2964,
   77376,  2733, -4053,  3144, -4053, -4053, -4053, -4053,  3084, -4053,
   -4053,  1710, -4053, 52409, 54814, -4053, 54814, -4053,  1710,  1391,
   -4053,  2285, -4053, -4053,   786, -4053, -4053, -4053, -4053, -4053,
    3192,   112,  3195,   112, 77376, 77376, 77376, 77376, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053,  2049, -4053,  1070, -4053, -4053,
   -4053, -4053, -4053, 77376,  1479, -4053,   622, 54333, -4053, 53852,
   77376, -4053, -4053,  3129, -4053, -4053, -4053,  3063, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053,  1974, -4053,  3068, 77376,
    2965, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   50004, 50004, 50004,  2064, -4053, -4053,  2399, -4053, -4053, -4053,
    2986, -4053, -4053, -4053,  3130,  3132,  3134,  2991,  2995,  2996,
    3001, -4053,  3006,  3009,  3010, -4053, -4053, -4053, 77376, -4053,
   -4053, -4053, 77376, 77376, -4053, -4053, -4053,  1514, 54333,  3149,
    1514,  1514, 77376, 77376,  1514, -4053, -4053, -4053,  3153,  3162,
    3163,  3175,  3177,  3178,  1514, -4053, -4053, -4053, -4053,   249,
   50004, -4053,  2709, -4053,  2048, 40240,  5509,  2947,  2766,  2948,
    2080, 35884,  1136,  3152,  2951, -4053,  1576,  3172,  2971,  2971,
    2971,  2971,  2971,  2971,  2971, -4053,   928, -4053,  3138, 77376,
     475, 77376,  2080, -4053, -4053,  3022, -4053, -4053, 50004, 40240,
    1651,   179,  3099,  1399,  3299, -4053, -4053, -4053, -4053, -4053,
   77376, 77376,   756,  2399,  2065, -4053, 54333, 77376, 70176,  1826,
    2975, 77376,  2977,  2970, -4053, -4053, -4053, -4053,  2079, -4053,
   54333,   -28,  3151,  3154,  1826,  3053, 77376, -4053,  2082,    50,
   -4053,  2399, 61056, 52890, -4053,  3382, -4053, -4053,   736,  3243,
   -4053, 77376, -4053, -4053, 37336, 34902,  2099,  2980, 77376, -4053,
    2979, 33450,  3215,  3155, -4053, 33450,  3155,  1437,  3155,  3216,
   -4053, 39272, -4053,  2992, 21548,  1631,  3164, 10808, -4053,   112,
   54333, 77376, -4053,   112,  3043,   112,  3045,   112,   112, 77376,
   -4053, -4053, 77376, -4053, 77376, 68256,   112, -4053, 10808, 77376,
    3274, -4053, -4053, -4053, -4053,  3113,  3115,  3116, 77376,  2285,
   50966, -4053,  3004, 77376,  1209, -4053, -4053,  3167, -4053,  1826,
   77376,   925,   201, -4053, -4053, -4053, -4053,  3294,  3296, -4053,
   -4053, -4053, 77376, 64416,   118, 77376, -4053, -4053, -4053, -4053,
    3016,  2086, 10475, 29480, -4053,  3303, 54333, -4053, -4053, -4053,
   -4053, -4053, 29480, -4053, -4053, -4053, -4053, -4053, 29480, -4053,
   29480,  3291, -4053,  3431,  3431, 54333, 30974,  1309,  2433, 30974,
   30974, 30974, 30974, 30974, 30974, 30974, 30974, 30974, 32468,   418,
   -4053, -4053, 29480, 29480,  3298,  3291, -4053, -4053,  1325,  1325,
   54333,  3018,  2842,  3019,  3020, 29480, -4053, -4053,  2104, 50004,
   -4053, 29480,  9081,  2133,  3062, 10758,   925,  5641, -4053,  3391,
    2399, 29480,  2067,  2324, 29480,  2144, 29480,  3300, -4053, -4053,
   -4053,  3024, -4053, -4053, 54333, 29480, 30974, 30974,  6712, -4053,
    8190, 29480,  3025,  8607, 24500, -4053,   728,   728,   728,   728,
   -4053, 77376, 77376,  2787, 29480,  3301,   -58,   -58,  3026,  3013,
   39756, -4053, 29480,  1459, 27986,  3028, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053,  3032, -4053,  3054, -4053, -4053,   593,  3030, -4053, -4053,
    5189,   133,  3055, 77376, -4053,  2767, -4053, -4053, -4053,  3039,
   -4053,  2046, -4053, -4053, -4053,  6116,  3213,  2421, -4053, -4053,
   -4053,  2080,  3058, -4053,  1988,   187, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053,  2971,  2285,  2285,   835,  2285,  3316,
     835,  6169, -4053, -4053, 33934, 77376, 77376,  2148, -4053, -4053,
   77376, -4053,  1989, -4053, -4053,  3293,  1692, -4053, -4053, -4053,
    3112,   928,   941,  2536,   216, -4053,  3118, 77376, -4053, 77376,
   -4053, -4053, -4053, -4053, -4053, -4053, 50004, 40240, 50004, -4053,
    3122,  3128,   923,   101,  3135,  3136,  3061,  3070,  3076, -4053,
     320,  2399, -4053, -4053,  2399,  2285,  2399, -4053, -4053, -4053,
   -4053, 50485, -4053, -4053, 77376,  3339,    87,  1596, 77376, 77376,
   77376, 77376, 77376, 77376, 77376,  2733, -4053, -4053, -4053,  3077,
    1514, -4053, -4053,  3309,  3315, -4053,  1514,  1514,  1514,  1514,
    1514,  1514, -4053,    41,  2153, -4053, 35387, -4053, -4053,  2549,
    2549,   811, -4053,  2549, -4053,  2549, -4053, -4053,  2775,  3039,
    2080,  1724, -4053, -4053, -4053, -4053, -4053, -4053,  1165,  2080,
    2081,  3085, -4053, 36852, -4053, -4053, -4053,  2171,   610, 77376,
    2971, -4053,  2363,  2003,  2464,  2540, 75456, 75936, 76416,  3086,
   77376, 30974, -4053,  1217,   698, -4053,  3317, 77376,  3123, -4053,
   -4053, -4053,  3089, -4053,  2285, 77376, 77376,  2285, -4053, 54333,
   -4053, -4053,  3479,  1235, 77376,  3121,  3092,  3372, -4053,  3098,
    3100, -4053, -4053, 77376, -4053,  3138,  1646,  3140, 62496,  1999,
   -4053,  3351, 60096, -4053, 77376, -4053, -4053, -4053,  3460,  3187,
    3145,  2399,  2757, -4053, 52409, 29480, 29480, -4053,  3110, -4053,
    3124,  3733, -4053,  2176, -4053, -4053, -4053, -4053, -4053, -4053,
    3184, 77376,  3533, -4053, -4053, 74016,  3127, 77376,  2099, 33450,
   -4053, -4053,  2686, -4053, 33450,  3349, -4053, 33450, 77376,  3139,
   77376,   809, 77376, -4053,  3120,   112, -4053, 77376, -4053, 77376,
   -4053, -4053,   112,   112, -4053,  3229, -4053, -4053,  1826, 77376,
   77376, 77376,  2285, -4053,   260, -4053,  3392, 74976, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053,   127,  3403, -4053, -4053, -4053,
   -4053, 29480, 10808, -4053,  3133, 10808,  6184, 10808,  3298, -4053,
    2895,  3404, -4053,  1318,  3141,  2895,  2083,  2083,   124,   124,
     116,   116,   116,  3431,   418, 10808, 10808, -4053, -4053, -4053,
   -4053,  3146, -4053, -4053, -4053,  2842, -4053, 29978, -4053, -4053,
    3165,  3166,  3147, -4053, 29480, 30476,  3142, 55295, -4053, -4053,
     610,  3071, 30974, 30974,  1117, -4053,  1517, 29480, 54333,  2170,
    1117,  2346,  2819, 29480, 29480,  8735,   333, 29480,  6752, 77376,
   77376, 77376, 77376, -4053, -4053, 10808,  3510,  3400, 29480,  3148,
   -4053,  3150,  3013, -4053, 90816, -4053, -4053, 10808, -4053, -4053,
   29480, -4053,  3013,   187,   890,  2399, -4053, -4053,   784, -4053,
   -4053, 42705, -4053, -4053, -4053, -4053,  8718, -4053, -4053, -4053,
     320, -4053, -4053, -4053,  3206, 63456,  3412,  1165, 29480,  2187,
   -4053,  3171, 76896, 23516,  2191,  2197,  3123, -4053,  2514, -4053,
    3211, -4053,  3335, -4053, -4053,  3340,   320, 77376, -4053, 54333,
     112,   112, -4053, -4053,  3169, 77376, 77376,  2080,  2080, 54333,
    3160, -4053,  2080,  2080,  3161, -4053, 77376, 77376, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, 77376, 77376, 77376,
   77376,  3448, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
    3395, -4053,  1514,  1514, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053,  2183,  3481, -4053, 50004, -4053, 57216, -4053, -4053, -4053,
    2399,  2399,  3348, 45135,  2399,  2399, -4053,  1252,  3487, -4053,
    3417,   619,  3173,   134,  3444, -4053,  1804, 36852, 36852, 36852,
   36852, 36852, -4053, -4053,  3449,   320, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, 29480,  1064,  2895, -4053, -4053, -4053, -4053,  3123,  1651,
    3223, 50004,  2285,  2285,  3225,  1826,   329, 77376,  3480,  3217,
   -4053,  2399, -4053, -4053, -4053,   611, -4053,  2200, -4053, -4053,
   -4053,  3214,  3154,  1439,  3182,  1999, -4053, -4053,   948, 77376,
   -4053,   945, -4053,  3451,  3186, -4053, 10808, 10808,  2399, 55776,
    3382, -4053, 77376,  3425, 77376, -4053, -4053, 77376,  2207, -4053,
   29480,  3188, -4053, -4053, 33450,  2686,  2210, 77376,  2223, 54333,
    3013, -4053,   112, -4053,   112,   112, -4053, -4053, 77376,  2285,
    2285,  2285, -4053,  3354, -4053,   112, 74976, 10808, -4053, -4053,
   -4053, 30974,  3459, -4053,  3189, 54333, -4053,  3190,  2238,  2245,
   -4053, -4053, -4053,  6947,  3231, 10808,  3286,  3193,  3194, -4053,
     919,   919,  1517,  2248, -4053, 30974, 30974,  1117,  1117, 29480,
    1117, -4053, -4053, -4053, -4053, -4053, 29480, 29480,  3227,  3013,
    3013, -4053,  3355, -4053,  3197, -4053, -4053,  1724, -4053, -4053,
   -4053, -4053,   610, -4053,  3198, -4053, -4053, 74976,  3374, 74976,
   -4053,  6983,  3123, 33934, 43198, 77376, -4053,  1038,  1038,  3338,
    3123,  3223, -4053, -4053, -4053, -4053, -4053,  3254, -4053, -4053,
   40240, -4053, -4053, 34418, 42705, -4053,   923,  3205,  3207,   101,
   -4053, -4053,  1230,   852,  3239,  2285,  3488,  1514, -4053, -4053,
    2754,  2399, -4053, -4053,  2256, -4053, -4053, -4053, 77376, -4053,
    3092, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, 50966,
    3603,  3603, -4053,  1820,  1820, -4053, -4053, -4053, 77376,  1165,
   -4053,  7079,  3393, -4053,  3223,  3420,  3465, -4053,  2270, -4053,
   77376,  3145, 60096,  3138, -4053,   352,  3218,  3507, -4053, -4053,
    3545, -4053, 62496,  3389,  3187,   795,   795, 77376,  3154,  3341,
   -4053,  3342, -4053,  3586,  3396,  3588, 77376, 33934, -4053, 54814,
   -4053,  2276, -4053, -4053,  2882, 77376,   436, -4053,  3240,  2277,
   -4053, 10808, 77376, -4053, -4053, -4053,  2282, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053,   118,   660, 30974, 54333,  2286, 29480,
   -4053, 29480, -4053, -4053, -4053,   406, -4053, -4053, -4053,   919,
     919,  1117,  2842, 10808, 77376, -4053, -4053, -4053,  3606,  3397,
    3013, -4053, -4053, -4053, -4053,  1209,   835,   118, 76896,  3223,
   -4053,  3230, -4053, -4053,  2046,  2046, 77376,  3223,  1165, 29480,
   -4053, -4053, 54333,  1995,   588, -4053, 54333, 54333, -4053, 77376,
   77376, 77376, 77376, 77376, -4053, -4053, -4053, -4053, 57216,  3092,
    3603,   625, -4053, -4053, -4053,  3511, -4053, -4053,   626,  3407,
    3312, -4053, 50004,  3521, -4053, -4053, -4053, -4053, -4053, 29480,
    3383, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053,  2290,  3187, -4053, -4053,  3409, -4053,  3413,
   -4053,  2294, -4053, -4053,  3733, 55776,  3551, -4053, -4053,  2151,
    3661, -4053,  2302, -4053, -4053,   660,  2321, -4053,  2328,  2342,
    3292, -4053,  3242, -4053,  3641, 29480,  1343, -4053, -4053,  3524,
   -4053,  1038,  3289, 42705, -4053, -4053,  1651,  1165, -4053, 10808,
    2348, -4053, -4053, -4053,  3394,  2349,  2360,  3252,  3290,  3252,
   -4053,  2285, -4053, -4053, -4053, -4053,  3562, -4053, -4053, -4053,
     198, -4053,  3434,  3436, 77376, -4053, 77376,  3657,  7342, 50966,
     928, -4053, -4053, -4053, -4053,  3302, 33934,  3382, -4053,   212,
   -4053, -4053, -4053, 77376, -4053, -4053, -4053, -4053, -4053, 77376,
    3266,  2842, 28484, 28484,  3269, 74976,  2046,  3272,  1165,  3273,
    3420, -4053, 50966, -4053, -4053, -4053, 77376,  3401,   814,   814,
    3589, -4053,  3327, -4053, -4053, -4053,   923, -4053,  3276,  2536,
    3187, -4053, -4053, -4053, -4053,  1484, -4053, -4053, -4053, 31472,
    3402,   917,  8219, -4053, -4053, -4053, -4053,   118, -4053, 29480,
   -4053, -4053,  3407,  1995, -4053,  3217, -4053,  3692, -4053,   772,
   -4053, -4053,  3160, 56736, -4053,  2882, -4053,  1216, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053,  3683, -4053, -4053, -4053, -4053,
   -4053, -4053,  7767,  1165, -4053,  3579, -4053, -4053, -4053, -4053,
    2370, -4053, -4053, -4053, -4053, -4053, -4053, -4053,  1240, -4053,
   -4053,  1599,  1868, 28982, -4053, -4053,  3433, -4053, 56736, -4053,
    1216, -4053, 50966, -4053, -4053,  3297, 56736,  2376, -4053
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -4053, -4053,  3435, -4053, -1140,   -17,  2051, -1006, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053,  1336, -4053, -4053,   -84,  1172,  2274,  1022,
   -4053, -1297, -4053, -4053,  -850,   164,  -976, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053,   931,  1457,   908, -1256, -4053, -1663,
   -4053, -4053,   388, -4053, -4053, -4053,   790,  -275, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053,   -38, -4053, -4053,  -428, -1738,
    -114, -4053, -4053, -4053, -4053,   250,  -321, -1543, -4053, -2820,
   -4053,   -79, -4053, -4053, -4053,  -322, -1616,   960,  -954, -1332,
    1241,  -562, -4053,  -220, -4053,  -588,  -508,  -505,  -550, -4053,
   -3331, -3657, -3324, -2810, -4053, -4053, -4053,   278, -4053, -1733,
   -4053, -4053,  1998, -1586, -4053,  -990, -4053, -4053, -4053, -3436,
   -4053,  1566,  -301, -4053,   -41, -4053, -4053, -4053, -4053, -4053,
   -4053, -3393, -4053, -1651, -4053,   419, -2854,   909, -4053, -4053,
   -4053,  2028, -4053, -4053, -4053, -4053, -1762, -4053, -4053, -1718,
   -4053,  1426,   801, -4053, -4053, -4053,  -551,  -611,  -602, -4053,
   -3620,    17,    19, -4053, -4053, -4053, -4053, -1196, -4053,   819,
   -2931, -1133, -4053, -4053,   856, -4053, -4053, -4053,  -515,  -184,
    2057, -4053,  -440, -4053, -4053, -4053,  -183, -4053, -4053, -4053,
   -4053, -4053, -4053, -1868,  2933, -1100, -4053, -4053, -4053, -4053,
   -2196, -4053,  3697,   -29,  1382, -1717, -4053,  -200,  -107,  2522,
   -1330, -2553,   254,  -313, -4053, -1918, -4053, -4053, -4053, -2470,
   -4053, -4053, -4053, -4053, -3247, -1716, -4053, -4053, -4053,   325,
   -4053, -3858, -3598, -3799, -3225, -4053, -4053, -1263, -4053, -4053,
   -4053, -1565,  1587, -1645, -4053, -2218,   326, -3444,  -995, -3015,
   -4053, -3358,  -384, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -1272,  -856, -4053, -4053,  3000, -4053, -3330, -4053, -4053, -4053,
   -4053,  1278, -4053,  -280, -4053, -4053, -4053, -4053, -4053, -4053,
    -502,  -576, -4053, -4053, -4053,   185, -4053, -4053, -4053, -4053,
    1357, -1153,  -959,  2872, -1715,  -216, -4053, -4053, -4053, -4053,
   -2853, -4053, -4053, -4053, -4053, -4053, -4053, -4053, -1198, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053,  1742,  1738,  -120,  -214,
   -4053, -4053, -1449, -4053,  -798, -4053,  1985, -4053, -4053, -4053,
   -4053, -4053,   189,   356,   -76, -4053, -4053,   733, -2384,   -74,
   -4053, -4053, -4053, -4053,  -269,   -71, -4053,  1130, -4053, -4053,
   -2046, -4053,   244,  1254,  2609,  1359,   -72,    -9,  -245,  -251,
    -208, -4053,  2878,  2368, -4053, -4053,  -175,  1533, -4053, -1049,
    -338, -4053,  1121,  -906,  1715,  2351,  2353, -4053,  1118, -4053,
   -4053,  1132, -4053, -4053, -4053,  -898,  1732, -4053,  2367,  1752,
   -4053,  1781,  1195, -2396,  1444, -2383,   826,  -242,    -1,  -127,
    2908,  3064, -4053, -3916,  1170, -3367,   404,  3176, -2055, -1752,
   -4053, -4053, -1339,  9251, -4053, -4053, -4053, 11660, 13455, -4053,
   -4053, 13934, 14645, -4053, -1231,   689, 14774,  3319, -1376, -1748,
   -1507, 14135,  1526, -1195, -1833, -4053, -4053, -4053,  -218,   701,
     -96, -4053, -4053, -4053,  -406, -2658,  -405, -4053, -4053, -4053,
    -409, -4052,  1686, -4053,  -821, -4053, 15746,  1168, -4053,   -43,
   -2529, -2626, -1365, -1884, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -1516, -3052,  -771,  1247, -4053, -4053,  1337, -4053, -4053,
   -4053, -1458, -1113, -2001,  1253, -2027, -4053, -1055,  1370,  1873,
   -1024,  2047,  2016, 13457,  -125, -2281, -1500, -1421, -4053,  -801,
   -4053,    59,  2780,  -158,   287,   194,   -61, -2891, -4053, -4053,
     300, -4053, -4053, -4053,  3336,   864, -4053,  2720, -4053,  1475,
    2113, -4053, -4053,  1750,  -936,    70, -4053,  -378, -4053,  -141,
   -4053, -4053, -4053,   143, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053, -4053, -4053,  2404, -4053, -4053, -1433, -4053, -4053, -4053,
   -4053, -4053,  3619,  -308, -4053,  3056,  -292, -4053, -4053, -4053,
   -4053, -4053, -4053, -4053, -4053, -4053,  2409,  1784, -4053,  2883,
   -4053, -4053, -4053,   -44,  2615, -4053, -4053, -4053, -1167,  -582,
    2880,  2884,  1745, -4053, -4053, -4053, -4053, -4053, -4053, -4053,
   -4053,  1757, -4053, -4053,  1227, -2034,  1758, -4053, -4053,   631,
   -4053, -4053,   256, -4053,   639, -4053,  2505, -4053, -4053, -4053,
     664, -4053, -4053, -4053,  -595, 10766,    43,    99,   166,   210,
   -4053,  5894,  8526,   -81,  2425,   -24,  8488, 13407,   298, -4053,
    3607,  1760,  1443,  -996, -4053,   146,  2054,   507, -4053, -1108,
      23,    -2, -4053,  2640,  -648, -1150,  2715,  -726, -1859, -4053,
    4022, -4053, -3033, -4053, -1000,  3065, -1194
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2403
static const short yytable[] =
{
      80,  1065,   343,  1505,   344,  1171,   348,   346,  1236,   968,
    1015,  1628,   893,  1073,  1988,  1138,  1890,   356,  1882,  1362,
    1363,  1154,  1577,   356,  1367,    79,  1575,   881,  1961,  1643,
     968,  2338,  1930,  2311,  1706,   877,   799,  2515,  1758,  1896,
    2279,  2549,  1526,  1171,  1747,   942,  2435,  2585,  1647,  1846,
    1911,  1268,  1222,  1048,   395,  1118,   356,  2553,  1080,  1288,
     395,    74,  1999,   990,   976,  2926,  2443,  3194,  2320,   349,
    2045,  2382,  2383,  3401,  1081,  1518,  2154,  2376,  2018,  2019,
    2766,   799,  2217,  2219,  2220,  2485,  1821,   683,   840,  1781,
    3584,  1825,  2885,  2887,  1171,  2462,  1045,  2034,  1831,  3311,
    2463,   356,  1075,  1016,  1273,  1053,  3437,  1848,  3439,  2175,
    1596,  1281,  3116,  2309,  2782,  2464,  2465,  2466,  2467,   929,
    2627,   394,  1122,  1626,  3178,  1067,  3752,   394,  3541,  3308,
    3130,  3132,  1036,  3766,  3496,  3138,  2371,  3940,   965,   852,
    1873,  2319,  1323,  2545,  2792,  1076,  2260,  4040,  1945,   799,
     886,  2211,  2211,  1920,  2815,  3943,   349,   904,  1676,   965,
     394,  1915,  3913,  3366,   692,  2787,  1569,  1698,  3496,   356,
    3900,  3056,  2113,  1654,  1572,  4048,  2012,  2013,  1604,  1605,
    1512,  1113,  2068,  1845,   982,  2154,  3513,  3514,  3515,  3516,
    3517,  3518,  3677,  2831,  1874,  3316,  1874,  2835,  3317,  3318,
     416,  2031,   692,  2994,  3225,   394,  1312,  2071,  1748,  3319,
    3320,  3321,  3225,  3322,  3323,  1135,   796,   850,  3324,  3325,
    3326,  2483,   885,   892,  3306,  3307,   967,   399,  3922,  -342,
    3015,  3575,  2062,   892,  1617,   681,  2322,  1064,  4286,  1874,
    1262,  3956,   261,  3958,  1350,  1874,   685,   967,  4214,  4215,
    3145,  2702,  3147, -2401, -2401, -2401, -2401,  1618,   130,   131,
   -2401,   796,  2601,   321, -1577,  4134,  1775,   342, -2401,  2582,
    2490, -1577,   355,   394,   892,  3183,  1070,   416,   355,  -127,
    2155,   897,   343,   797,   344,  3017,   348,   346,  -127,  4282,
    1378,    45,   416,  -127,  2718,    37,    38,    39,    40,  3565,
     841,    43,    44,  1397,  1619,   356,    45,  2578,  2702,  3818,
    3203,   355,  4403,   969, -1333, -1333, -1333, -1333,  2697,  1358,
    1922, -1333,   347,  2098,    37,    38,    39,    40,   797,   796,
    3802,    44,   416,  1393,   969,  2218,  2740,  2459,  2407,  1932,
     356,    43,   395,  1565,  1074,   813,    45,  1020,  3031,   349,
    1769, -1376, -1376, -1376, -1376,  3361,   355,  4445, -1376,   402,
    2621,  3327,  1188,  4099,  2736,  1758,  1980, -1683, -1683, -1683,
   -1683,  2737,   934,  2194, -1683,  2104,  1498,   395,   357,  2602,
    3028,  1540,   814,  1541,  4388,  1171,    37,    38,    39,    40,
    3784,  4100,   416,    44,  2751,  1762,   797,  2285, -2402, -2402,
   -2402, -2402,  1765,  1007,   794, -2402,    45,  3192,  1567,   394,
    1007,  2460,  1007, -2402,   809,   803,   810,  1123,  4051,  2719,
    1055,  4481,     3,  2720,   355,  2045, -1366, -1366, -1366, -1366,
    1098,  3803, -1593, -1366,  2496, -1376, -1376, -1376, -1376, -1593,
    1050,  1021, -1376,  1875,   394,  1875,  1586,  3728,  2491,   794,
    2018,  2019,  1856,  1189,  1908,  2741,  1656,  2034,  2721,  3819,
     803, -2399, -2399, -2399, -2399,  1359,  3184,  1350, -2399, -2129,
    3866,  2579,  1109,  4404,  2337,   686, -2399, -1361, -1361, -1361,
   -1361,  4274,  1389,  2101, -1361, -1366,  3793,  3328,  1875,  4245,
    3018,  2583,  1509,  3840,  1875,  1350,  1006,  2417,  4401,  2995,
    2580,  2156,  2413,  1006,  1137,  1006,  3225,  1011, -1366, -1366,
   -1366, -1366,  4376,   881,  1011, -1366,  1011,   794,  2484,  4467,
    1081,  3760,   261,  2146,  2147,  2377,  3496,  2131,   803,   898,
    3785,  2143,  2143,  1934,  1607,  1610, -1361,  3329, -1829,  3576,
    4114,  1639,  1680,   321,  1107,  1116,  1117,   342, -2398, -2398,
   -2398, -2398,  2603,  2435,   813, -2398,  2012,  2013,  2703,  1657,
     355,  2329,  2099, -2398,  2031,  1379, -1994, -1994, -1994, -1994,
    2604, -1577,  1910, -1994,  1884,  2630,  3383,  1828,  2367,  2722,
    2369, -1994,  4153,  1914,  1613,  2433, -1346, -1346, -1346, -1346,
    4166,   814,  2091, -1346,  4138,   355,   682,  3181,  4318,   246,
    2063,   696,   347,   696,  2406,  3611,  3980,   899,  1976,   900,
    4311,  1366,  1114,   696,  3237,  3286,  1542,  2521,  2114,  3234,
    3235,  3236,  3237,  3637,  1981,  2574,  2527,  3786,  3330,  2410,
    3787,  1981,  1884,  3031,  2535,  2536,   886,  2872,  2429,   696,
   -1373, -1373, -1373, -1373,  1158,  1681,  2154, -1373,  4389,   696,
    2765,  3733,  2548,  2490,  1124, -2129,  1115,  3875,   357,   696,
     696,  1776,  1777,   696,  2126,  2884,  3398,  2233,  3399,  2203,
     696,  2738,  2784,  2290,   970,  2515,  1651,  2204,  2068,  2295,
   -2401,  1351,  2300,  1587,  4209,  1366,  3227,  1520,  3741,  3185,
     811,  3266,  4217,  1149,  1056,   970,  1065,  4381,   962,   963,
    -127,  -127,  1658,  2071,  1736,  1178,  2099,  2800,   885, -2129,
    3535,   696,  4300,  1620,  1621, -1170,  2444,  3422,  2337,  4287,
    2357,  3463,  3464,  2360,  2361,  3598,  3341,  1126,  1331,  3602,
    4255,  2354,  1226,  2285,  3335,  4256,  4334,  1576,  1122, -1593,
    2281,  2017,  2868, -1829,  2564,  1737,  2040,   356,  3225,  1264,
    2567,   356,   703,   962,  1595,  2557,   892,   892,  4420,  3346,
    1659,  2843,  4257,  1915,  2041,    37,    38,    39,    40,  1053,
    2282,  4243,    44,  1109,  2892,  1755,  2414,  2817,  2042,  2817,
      37,    38,    39,    40,  1278,  4129,  2439,    44,   395, -1170,
     847,  1365,  1531,  1332, -1683,  1338,  1532,  1343,  2653,  2654,
   -1829,  3458,  3856,  1347,  3461,  3462,  1217,  3494,  3465,  1087,
    4264,  2007,   992,   962,   963, -1829,  2920,  1682,  3472,   215,
    3423,  1326,  1606,  1321,  1253, -2402,  1838,  1338,  1343,  1088,
    2040,  4122,  2330,  4475,  4103,  4104,  4105,  4106,  4107,  1089,
    4357,  3494,  2662,   845,  2331,  1609,  1219,  2350,  2041,   223,
    1095,   394,  2311, -1366,  4337,   394,  3536,  1369,    37,    38,
      39,    40,  2044,  1188,  1366,    44,  2286,  1839,    35,   416,
    1068,  4335,    37,    38,    39,    40,    41,    42,    43,    44,
    3186,  3896,  1171,    45,   234,  3582,  1350,   993, -2399,  3349,
    4301,  2870,  1521,  2007,  4265,  2332,   237,  1738,  2493,  1270,
     904,  2780,  2371,  2283, -1361,  1096,  1070,   796,  2440,   696,
    4333,  3232,  3233,  3234,  3235,  3236,  3237,  4130,  2515,  1756,
    2556,  1369,  3586,  2273,  1336,  3584,  1341,  1069, -2403,  1977,
      80,   349,  1064,  3858, -1170, -1366,  1545,  1090,  2274,  2287,
    4266,  4426,  2477, -1680,  1508,  2589,  2590,  4267,  1516,  1522,
    4352,  3187,  4322,  4457,  1189,    79,  1371,  1373,  1109,  4309,
     892,  3750,   416,  3424,  1389,    37,    38,    39,    40,  4338,
    2214,    43,    44,   209,   797, -2398,    45,  4268,  2128,  2974,
    1254,  1739,  1502,  2223,  3402,  2975,  2224,  1377,   356,  4314,
    4315,    74,  3425, -1994,   896,  2275,  3587,  1070,  1746,  4402,
    1098,  1091,   355,  2921,  1399,  1317,   355,  3225,  1351,   892,
     967,  2276,   967,  2023,   967,  1394,  2478,  3897,  3188,  1840,
     967,  1348,  1349,  1499,  3338,  1536, -1170,  1511,  1270,  1513,
    4339,  1351,    35,  2534,  2215,  1255,    37,    38,    39,    40,
      41,    42, -1333,    44,   967,   967,  4269,  4119,  1161,  1162,
    1163,  2296,  1164,  1165,  1166,  1167,  1168,  1169,   994,   995,
   -1170,  1724,  1793, -1170,  3519,  3761,  1092, -1373,  1171,  2516,
    1725,  2520,  1119,  4143,  4021,  3313,  4435,  3314,  2225,  3520,
    2526,  4144,  2976,  2129,  4025,  2088,  2089,  2090,  2091,  2216,
    1701,  4458,   394,  2441,  1109,   794,   692,   969,  1757,   969,
    2362,   969,  3741,  1841,  1559,  3035,   803,   969,  1071,  3521,
     956,  3522,   683,   683,  4024,  1531, -1333,  1630,  2182,  1532,
    4427,  2120,  2282,  1599,   956,  3852,   804,  2560,  3588,  4221,
     957,   969,   969,  2297,  4139,  2874,   805,  2638,  4447,  1628,
    1514,  2277,  1629,  1070,   957,   696,  4140,  2796,  2774, -1781,
     983,  4418,  3797,  3232,  3233,  3234,  3235,  3236,  3237,   967,
    3403,  2124,   416, -1812,  1154,    37,    38,    39,    40,  3496,
    3853,    43,    44,  1397,  1619,  3975,    45,  2616,  1622,  2656,
    1599,  2121,  3523,   991,  1098,  3404,  3589,  3227,  2322,  2981,
    4428,  1726,  2065,   696,   696,  2479,  2327,  2418,  1560,  3494,
    3519,  2639,  2067,  3949,  2183,  2068,  2480,  2102,  3953,  4270,
     696,  3955,  3946,  4429,  1171,  1858,   967,  2875,  1065,  1779,
    3393,  2363,  1007,  2364,  4230,  2977,  1007,  2797,   956,  3762,
    2071,  4145,  1496,  2278,   806,  2072,  1094,  2820,  2311,  2979,
    1898,  4218,  3524,   355,   979,  3521,   969,  3525,   957,  3228,
    1884,  1626,  3633,  3798,  2978,  3782,  2640,  2419,  3763,  2641,
     681,   681,  3148,  3143,  3831,  1627,  4448, -1830,  2980,  3142,
    3834,  3835,  3836,  3837,  3838,  3839,  1919,  3066,  3067,  3068,
    3069,  1899,  3526,  3150,  3151,  2771,  1058,  3153,  2515,  1497,
     962,  1595,  2515,  3157,  3527,  1248,  1979,  3749,  1842,  4141,
    1095,  1043,  1270,   969,  4247,  2849,    80,    80, -1173,    80,
    2176,  2177,  3960,  2181,  3314,  1006,  3649,  1843,  3397,  1006,
    1865,  4231,   349,  2462,  1249,  2248,  1011,  1270,  2463,  2765,
    1011,    79,    79,  2169,    79, -1781,  3964,  3799,  3965,  3347,
    1122,  1081,  3584,  2464,  2465,  2466,  2467,  2951,  3856, -1812,
     698,  2642,  1599,  1076,  1076,  1096,  1076,  1884,  1097,   349,
     704,  4196,  4197,   807,  2074,  1250,  3196,    74,    74,  2954,
      74,   848,  1866,  1985,  3528,  2850,  2215,  2957,  4112,  2959,
    2420,  1005, -1173,  3525,  4027,  2075,  2076,  3139,   967, -1781,
    1042,  2951,  2005,  3625,  1261,   696,   844,   696,  4345,  4312,
    1828,  3894,   157, -1812,  3135,  2105,  2273,  4317,  2328,  1951,
     895,  2021,  3232,  3233,  3234,  3235,  3236,  3237,  3526,  3857,
    2060,  2421,  1565,  4174, -1333,  1531,  1566,  2439,  3566,  1532,
    3527,  2216,  1952,  1900,  2079, -1333,  4093,  2017, -1333,  1646,
   -1333,  2048,   696,  4350,  2643,   696,   696,  2080,  1317,  2378,
    1098,  2153,   813, -1830,  2058,   416,  2118,  2119,   682,  1867,
     970,  3895,   970,  2061,  2662,  2662,   861,   416,   682,  2662,
     956,   356,   696,  2066,  1565,   969,   176,   956,  2275,  3858,
    1710,  1066,  1017,  2103,  4205,   815,  4207,  1567,  2857,   814,
     957,  1095,   970,   970,  2276,  1865,  4094,   957,    37,    38,
      39,    40,  3661,   849,  3662,    44,  1868, -1830,  2662,  2662,
    3528,  3982,  1270,  3983,  2185,  2133, -1860,  1901,   931,  1270,
    1270,   863,   356,   356,   356,  2217,  1098, -1173,  1711,  3387,
    1568,   696,   193,   696,    37,    38,    39,    40,  -795,  1567,
    1599,    44,  4307,  1099,  1599,  1599,  1096,  2559,  2325,  2440,
    3035,  3772,  1074,  1074,  2186,  1074,  2135,  2230,  4163,  3417,
     395,   395,  1100,   813,  1077,  2153,  2904,  2362,  2267,  1018,
     692,   692,   356,  2422,  3418,   394,   967,  2068,  2268,   356,
     967,   967,  1568,  1620,  1621,   356,  2186,  1084,  1869,    37,
      38,    39,    40,  2269,  2829,  2068,    44,  3171,  2136,  2326,
     814,   683,  2071,  2187,  1712,  2068,  3388,   682,   215,   395,
    2086,  2087,  2088,  2089,  2090,  2091,  2252,  2905,  2226, -1173,
    2071,   682,   682,  3663,  2277,  1616,   394,   394,   394,   215,
    2071,   796, -2193,  3664,  1867,  2187,  4078,  4079,   223,   157,
    2906,  1098,  3984,  2244,  2246,  3408,  2334,  3410,  4135,  1713,
    3109,  1714,  2222, -1173,  1349,  1644, -1173,  2423,     8,   223,
     870,  2370,   871,   969,   682,  3123,   232,   969,   969,  2368,
     157,   692,  2236,   234,  2868,  2593,   394,  2154,  3636,  2243,
    2245,  1868,   796,   394,  1645,   237,  1599,  4136,  2363,   394,
    2364,  2907,  1599,  3124,   234,  1716,  1119,  3156,   797,  4229,
    1724,   416, -1860,  4372,  1125,  3658,  2339,  2516,  3604,  2869,
    4028,  1884,  1136,   176,  3637,    45,  2278,  3126,   246,  1708,
    2379,  2402,   967,  2765,  2375,  2270,   355,  4373,   967,  3678,
    1718,  2403,  1065,  1599,  2441,  1884,  1599,  1599,  3546,   246,
    3783,  3788,  2374,  4479,   176,   796,  4480,  2455,  1709,   681,
   -1182,  2340,  2341,  2442,  2523,  2404, -1860,  2339,  1648,  2400,
    3873, -1182,  1905,  1869,  1720, -1182,  2515,   356,   122,   967,
    1617,  2515,   967,   967,  2515,  2075,  2076,   355,   355,   355,
    3357,  3396,  1906,  2143,  2337, -2403,   126,  1649,  2401,  1599,
   -1214,   209,  1248,  1618, -1214,  2040,  3310,  1704,  2618,  4436,
     193,  1150,  2340,  2341,  3829,    43,  1326, -1182,  2765,   969,
      45,  3336,   797,  2041,  2457,   969,  1650,  3128,  3820,   794,
    3420,  3544,  4417,  2870,  2079,   967, -1182,   355,  1157,   861,
     803,  2486,  2468,  3005,   355,  2337,   682,  1152,  3821,  4253,
     355,   696,  3494,   696,  1007,   215,   696,  1180,   696,  3421,
    2781,   696,   696,   696,  2606, -1214,   969,  1955,  1186,   969,
     969,  2509,  1250,  3646,   696,  1007,  1081,  3292,  1187, -1182,
     794,   394,  3679,  3680,  3071,   223,   215, -1182,   696,  3072,
     696,  4234,   856,  3613,   863,   696,  1651,  3616,  3400,  3618,
    2617,  3620,  3621,  2017,  1221,  2261,  1741,  4035, -1214,  2255,
    3626,  2339,  1171,   232,  3509,  3251,   223,  3253,  3254,  3072,
     234,    80,   969,  2612,    80,  2613,   349,  2615,  2614,  3709,
    1705,  2502,   237,  3161,  -159,  1742,  1916,   796,  2256,  2311,
    1917,  4283,  3037,   794,   232,  1224,    79,  1006,  3647,    79,
    1007,   234,  3920,  1228,   803,  3998,  2340,  2341,  1011,  -159,
    2516,  1225,  3999,   237,  1743,   246,  2688,  2257,  1006,  2691,
    2624,  2626,   861,    37,    38,    39,    40,  2040,  1064,  1011,
      44,  2634,    74,  2109,  2637,    74,  2110,  3350,  1237,  2337,
     349,  -789,  2649,  2650,  3038,  2041,  4437,  1684, -1182,  2700,
     130,   131,  1243,  1685,   797,  2667,  2669,  1251,  2107,  2042,
    2086,  2087,  2088,  2089,  2090,  2091,  2683,   696,   696,   356,
    2086,  2087,  2088,  2089,  2090,  2091,  1229,   863,  1230,  1651,
    2646,  3031,   355,   870,   682,   871,  2802,  3370,   682,   682,
    1252,  2662,  1686,  1006,  2662,  2662,  2662,  2662,  2662,  2662,
    2662,  2662,  2662,  2662,  1011,   937,  1556,  1257,  1545,    37,
      38,    39,    40,  3774,  3775,  1260,    44,  3035,  3039,  3040,
     416,  -362,  1916,  2399,  3062,  2707,  2552,   938,  2851,  1275,
    2854,  3041,  3198,   157,  2635,  2636,  2555,  1279,    37,    38,
      39,    40,  2648,  1687,  1068,    44,  2651,  2652,  1289,   937,
    1688,  2662,  2662,  1689,  1298, -1215,  1732,   356,   939, -1215,
    2339,  2673,  1556,  2674,  1304, -1170,  3542,  1721,   696,  1731,
     682,   938,   932,   394,  1745,   794,  1751,   157,   209,    35,
    2238,  2515,  2695,  3042,  2696,  1733,   803,    41,    42,  1734,
    2772,  1531,  2040, -1683,   395,  1532,  3199,  1232,  2845,  1233,
    3200,  1069,   939,  1746,  1690,  2340,  2341,   176,  1319,   356,
    2041,   356,  1399,  1360,  1735,  3225,   870,  1925,   871,  1926,
   -1215,   901,  1316,   416,  2044,  2794,    45,   873,  1399,   796,
     682,  3225,  3702,  2236,  2029,  2030,   682,   875,  2337,  3847,
    2153,  4240,  3642,  1758,  3879,  2004,   395,   246,   395,  3780,
    1364,   176,  1322,  2167,  2017,  2168,  2261,  2170,  1691,  2171,
     356,   394,  1375, -1215,  3350,  1387,  3043,  1337,  3044,  1342,
    3772,  1070,  2017,  1651,  1646,  1662,  1381,   682,   215,  1356,
     682,   682,    35,   416,  1386,  2554,  2931,  2555,  1388,   683,
      41,    42,  2575,  1692,  2576,  1390,   797,    45,  3350,  1372,
    1374,  1389,  2577,   967,  2576,  1630,  1663,    80,   223,    80,
    1599,  1391,  3579,   394,  1392,   394,  2917,  3729,  3731,  2207,
    2208,  3122,  1693,  1065,   355,  2709,  1694,  2710,  1395,  2609,
    1629,  2610,    79,   682,    79,  1399,   356,  1517,  3225,   215,
    1396,  3850,  3851,   234,  4203,  3854,   967,  3855,  2711,  2808,
    2809,  1695,  3778,  3432,  4149,   237,  1513,  3867,  3868,  3869,
    3870,  3871,  1519,  1664,   394,  1525,  1622,  4102,    74,   223,
      74,   356,  1109,  1523,  3772,  3869,  3870,  3871,  1524,  2793,
    2516,  1884,  1071,   215,  2516,  1530,  2662,  3123,   246,  1539,
     969,  2837,  1546,  2610,  1665,  3227,  1339,   232, -1238, -1238,
    1344,  1345,  1346,  4003,   234,  3063,  1553,  2882,   940,  2883,
    1357,  3227,   355,   223,  1554,  3124,   237,   794,  1556,  3963,
     796,  4327,  2928,  4329,  2929,  1563,  3966,  3967,   803,  1154,
    3125,  1557,  3023,   969,  3024,  1584,  2017,   681,  2261,  3126,
     394,   232,  1599,  3057,  1578,  3058,  2712,  3941,   234,   941,
    1599,  2713,  1599,  1627,  2504,  2505,  2714,  3228,  1585,  3163,
     237,  2576,  3127,  3179,   355,  3180,   355,  1580,  3197,  1399,
    2555,  1588,  3225,  3228,  1589,   394,  3007,  3207,   967,  2555,
    1600,  3210,  3315,  2555,  3007,  1590,   967,   797,   967,  3703,
    1666,  1399,  1591,   246,  3225,  1593,   796,  3226,    37,    38,
      39,    40,   696,  1592,   696,    44,  2207,  2813,   696,    45,
     696,  4005,  3214,   696,  2555,   355,  1594,   696,  3227,  1667,
    1601,  1065,  2107,   209,  3215,  1603,  2555,  1668,  3091,  3092,
    3065,   796,  1633,  1669,    37,    38,    39,    40,  1641,  3128,
    1670,    44,  1127,  3241,  1632,  2555,  3849,  1662,  1671,  3257,
    1635,  2555,  3095,  1646,  1128,  1129,  1672,  1678,  1270,  3115,
    3260,  3034,  3261,   797,  1673,   969,  1661,  2662,  2662,  3296,
    2715,  3297,  1701,   969,  1130,   969,  3920,  1131,  1663,  2716,
    3228,  4090,  1703,  3772,  3277,  3298,  3278,  3299,  3342,  1740,
    3343,   355,  3352,  3353,  4058,  4059,  3358,  3359,   797,    37,
      38,    39,    40,  1753,  3876,  1270,    44,  3279,   794,  4083,
    3863,  3864,  3415,  1674,  3416,  1744,  3229,  3230,  3231,   803,
    3232,  3233,  3234,  3235,  3236,  3237,   355,  3440,  3552,  3441,
    3553,  3301,  3302, -2403, -2403,  1664,  3232,  3233,  3234,  3235,
    3236,  3237,  3563,  2516,  3564,  3573,  3201,  3574,  1936,  3650,
    1938,  2555,  3227,  1942,  1754,  1944,  3350,  1759,  1947,  1948,
    1949,  1761,  1562,  3258,  1564,  1955,  1665,  3686,  3263,  3687,
    1599,  1956,  2764,  1763,  3227,    37,    38,    39,    40,  1766,
    4178,  2238,    44,   356,   794,  1983,  1771,  1984,   356,  1132,
   -1337, -1337, -1337, -1337,  3252,   803,  3693, -1337,  3694,  1773,
    4149,  1109,    81,  1780,  3972,  3881,   967,  3705,  1783,  2555,
    3280,  3776,  1651,  2576,  3228,  3281,  3843,  1822,  3844,   794,
    1643,  1993,  1994,  3275,  3867,  3868,  3869,  3870,  3871,  1133,
     803,  1684,  3872,  4004,  1824,  2610,  3228,  1685,  1828,  3229,
    3230,  3231,  1832,  3232,  3233,  3234,  3235,  3236,  3237,  -176,
    4042,   682,  4043,  4033,  4049,  1834,  2576,  2058,  2060,  1836,
    4050,  4080,  2576,  4131,  1847,  4132,  4168,  1854,  4169,  4170,
    4160,  2707,  1884,  4165,  1935,  3553,  1686,  1937,   396,  4173,
    1941,  3883,  1943,  1870,   396,  1946,  4167,   394,  3553,  1950,
    3295,   827,   394,   969,   682,   209,  4434,  2299,   682,  1668,
    1862,  4180,  2509,  4181,  2826,  1669,  1616,  1872,  4182,   696,
    2555,  4188,  1670,  2610,  1877,  1878,  4239,   396,  1879,  4237,
    1746,  4238,  1881, -1344, -1344, -1344, -1344,  1687,  1672,  3282,
   -1344,  1270,  1880,  4251,  1688,  4252,  1673,  1689,  3283,  4284,
    4291,  4285,  1884,   796,  1883,  4293,  2662,  3553,   796,  4297,
    1884,  2610,   887,  4351,  1889,  2123,  1599,  4355,  2516,  4356,
    1892,  1893,   396,  2516,  1894,  4364,  2516,  1884,  1895,  1897,
    2662,  2662,  4296,  3229,  3230,  3231,  1902,  3232,  3233,  3234,
    3235,  3236,  3237,  1903,  4365,  1674,  2610,  2236,  1690,  3477,
    3337,  4366,   967,  3261,  1904,  3229,  3230,  3231,  1909,  3232,
    3233,  3234,  3235,  3236,  3237,  4367,  1923,  2555,  3122,  1012,
     797,  4382,  4384,  2610,  2610,   797,  1012,  4320,  1012,  1957,
    1989,  4325,  4326,  4385,  1991,  2610,   682,  1995,  1997,   669,
     396,  1156,  3478,  4477,   682,  4478,   682,  1176,   355,  4488,
    1998,  4478,  1691,   355,  3603,  1185,  3606, -1335, -1335, -1335,
   -1335,  2003,  2011,  1193, -1335,  4034,  3479,  2014,  1220,   356,
     356,   356,  2015,  2016,  1399,   246,  2020,  3225,  2022, -1338,
   -1338, -1338, -1338,  2025,  3123,  3480, -1338,  1692,  4294,   969,
   -1336, -1336, -1336, -1336,  4006,  2026,  2123, -1336,  2027,  1283,
    1171,  2028,  3481,  1291,  2033,  2035,  2036,  3556,  2037,  3476,
    2038,  4083,  3124,  1303,  3433,  4115,  1729,  3482,  2039,  2046,
    1694,  4310,  4324,  2047,  2049,  2050,  2051,  3125,  2052,   356,
    4321,  2053,  2054,  2055,  3443,  2096,  3126,  2127,  2138,  1350,
    2148,   794,  2158,  3594,  2174,  1730,   794,  2455,  1566,  1568,
    1399,  2662,   803,  3225,  2201,  2206,   881,   803,  2213,  3127,
    1098,  2221,  2227,  2229,  2231,  3007,  2239,   356,  3007,  3007,
    2240,  2242,  3007,   394,   394,   394,   396,  3557,  2247,  2249,
   -2345,  2251,  3007,  2258,  3950,  2259,  2262,  1779,  2261,  2263,
    2289,  2291,  3570,  3497,  2284,  2292,  1368,  2293,  3483,  3506,
    2294,  2315,  2322,  2324,  2334,  2335,  3484,  2336,  2337,  2343,
    2344,   396,  3593,  1384,  2351,  2316,  2352,  2349,  1599,  1065,
    2345,  2355,  2356,  2346,  2358,  2365,  2366,  3497,  2391,   796,
     796,   796,  2372,   394,  2373,  1724,  3128,  2380,  3485,  2381,
     349,  3551,  2412,  2424,  1506,  2389,  2390,  2396,   696,  1955,
    2398,  2427,  1599,  2426,   967,   349,  2436,  3227,  2007,  3501,
    3504,  1529,  2434,  2017,   682,  2437,  2446,   858,  1726,  3578,
    1270,   394,  2452,  2472,  2023,   349,  2489,  3640,  2494,  2497,
    2456,  3538,  2509,  4273,  1558,  2499,  2509,  2500,   967,   796,
    2501,  3719,  3720,  3721,  3722,  2507,   797,   797,   797,  2518,
    2530,  1684,  2531,  2532,  2533,  2546,  2547,  1685,  3951,  2571,
    2587,  2595,  2592,  2572,  2599,  2607,  2620,  2671,   892,  3228,
    4306,  2629,  2630,  2516,   355,   355,   355,   796,  2672,  2068,
    4454,  4451,  2684,  3227,  2689,  2693,  2701,  2694,  2706,  2723,
     349,   969,  2725,  2751,  2767,  2770,  1686,  2773,  3688,  2768,
    2775,  2778,  2779,  2786,   892,  2803,   797,  2804,  4212,  2562,
    1069,  2563,  2822,  2113,  2840,  2565,  2795,  2566,   356,  2847,
    2568,  2807,  2838,  2819,  2569,   969,  2839,  2852,  4224,  2857,
    2821,  2836,  3685,  2863,   355,  2855,  2859,  2860,  2861,  2866,
    2873,  2878,  2880,  1171,   797,  3228,  1684,  1687,  2923,  2919,
    2927,  2930,  1685,  2988,  1688,  2982,  2996,  1689,  2983,  3350,
    2984,  2992,  2516,  1171,  2997,  2998,  3002,   794,   794,   794,
    2993,  3000,   355,  3001,  3003,  3016,  3020,  3004,   803,   803,
     803,  3014,  4223,  3027,  3025,  3030,  3031,  3032,  3700,  3055,
    3033,  1686,  3811,  3315,  3059,  2238,  3064,  3070,   887,  3073,
     682,  3077,  3094,  3078,  3096,  2058,  3108,  3111,  1690,  3112,
    3113,  3114,  3121,  3140,  3134,  1849,  1851,  1852,  1154,  3141,
    3149,  3152,   394,  3154,  3155,  1891,  3165,   794,  3229,  3230,
    3231,  3739,  3232,  3233,  3234,  3235,  3236,  3237,   803,  3168,
    3166,  3167,  1687,  3159,  3177,  4464,  2621,  3170,  3189,  1688,
    3193,  1366,  1689,  3195,  3208,  2917,  3209,  3794,  3212,  3211,
    3247,  3276,  1691,  3213,  3216,   794,  2516,  2555,  3304,  3217,
    3310,  3219,  3222,  3240,  3246,   356,   803,   356,   796,  3271,
    3248,  3249,  4380,  3256,  3269,  3312,  3291,  -833,  3365,  3284,
    4464,  3374,  3377,  3379,  3270,  3294,  3380,  1692,  4464,  3309,
     356,  1974,  3364,  1690,  3229,  3230,  3231,  3363,  3232,  3233,
    3234,  3235,  3236,  3237,  3368,  1916,  3390,  1990,  3389,  3369,
    3384,  3385,  3394,  3395,  3407,  3386,  1749,  3409,  3431,  2000,
    1694,  1506,  3430,  3434,  3436,  3497,  2067,  3460,  3444,  2068,
    3755,  3466,  3445,  3448,  3446,   797,  3447,  3449,  3450,  3812,
    3467,  3468,  3813,  3451,  3814,  1750,  2069,  1691,  3452,  1506,
    1599,  3453,  3454,  3469,  2071,  3470,  3471,  3499,   396,  2072,
    2224,  3500,   396,   355,  3508,  3510,  1146,  4379,  3007,   394,
    3511,   394,  1146,  3539,  3007,  3007,  3007,  3007,  3007,  3007,
    3532,  3543,  1692,  3545,  1270,  3562,   967,  3558,  3567,  3591,
    3561,  3597,  3568,  3595,   394,  3571,  3599,  3607,  3612,   967,
    3101,  3600,  1171,  1146,  3610,  3617,  3628,  3619,  3639,  1599,
    3629,  3506,  3630,  3631,  3643,  1694,  3644,  3653,  1662,  3634,
    3878,  3880,  3882,  3884,  2226,   796,  2004,   796,  3243,  3225,
    3242,  3682,  3683,  3684,  3695,  2062,  3708,  3707,  3716,  3732,
    1695,  3742,   682,  3745,  1265,   967,  3726,  3743,  3765,  1663,
     796,  3751,  3754,  3744,  3748,  1146,   794,  3756,  4398,  1348,
    1349,  3779,  1146,  3781,  3795,  2516,  3593,   803,  3862,  3789,
    3796,  3817,  3504,   969,  3808,  4038,   682,  3806,  3807,  3933,
    2173,  3877,    81,  3809,  2073,  2149,   969,  3832,  2074,  3810,
    3830,  4423,   797,  3833,   797,   696,  3865,  3905,  3891,  3898,
    2509,  3901,  3583,  3907,  3908,  2509,  1664,  2576,  2509,  2075,
    2076,  3910,  4036,  1155,  3924,  3911,  3928,   797,  1174,  3915,
     355,  3929,   355,  2077,  3931,  3938,  3942,  1184,  3944,   349,
    3954,   696,   969,  3962,  3973,  3968,  3939,  1665,  4055,  3947,
    3976,  3981,  3990,  3991,  4016,   355,  3978,  4017,  4037,  4039,
    4044,  3957,  1231,  3985,  3989,  2078,  1238,  3996,  2079,  3986,
    3992,  4019,  4052,  4020,  4053,  3102,  1247,  1599,  4060,  4054,
    4076,  2080,  1146,  4077,  2081,  4066,  4069,  4088,  1012,  4081,
    4095,  3857,  1012,  4101,  4098,  4116,  4108,  4120,  4146,  4124,
    4155,  4485,  4126,  4133,  4137,  4172,  4176,  4184,  4147,   396,
    4162,  4177,  4179,   967,  4185,  4194,  4186,  4187,  1146,  4198,
    4200,  4204,  4206,   794,  4216,   794,  4219,  4226,  4232,  4227,
    4233,  4241,  3897,  4248,   803,  4250,   803,  4110,  4260,  4261,
    4259,  4263,  4277,  2663,  4279,  4275,  4276,  4278,   794,  4289,
    4305,  1070,  4313,  4336,  2082,  4340,  4344,  2333,  4346,   803,
    4353,  4349,  4031,  4032,  4354,  4359,  4363,  4369,  4368,  4370,
    1147,  4375,  3101,  1151,    80,  4377,   209,  1910,  4322,  4386,
    1668,  4387,  4390,  3476,  4392,  4396,  1669,  4030,  3734,  1182,
    1662,  4399,  4416,  1670,  4419,  4388,  4421,  4389,  4433,    79,
     969,  1746,  2742,   356,  4425,  4446,  4456,  2388,  4473,  1672,
    4476,  4482,  1227,  1079,  3061,  3339,  2145,  1673,  2397,  4486,
    2922,  1663,  3405,  2236,  3792,  4235,  4082,  1245,  2409,  3473,
    4332,  4262,  3926,  4113,  4272,    74,  3382,  3164,  4422,   967,
    2083,  2084,  2085,  4210,  2086,  2087,  2088,  2089,  2090,  2091,
    3007,  3007,  2776,  4121,  4453,  4393,  1146,  4391,  2777,  4431,
     356,  3101,  3927,  1146,  1270,   967,  1674,  2488,  4086,  4087,
    3104,  3583,  4091,  4092,  2871,  4288,  4063,  4064,  1664,  1662,
    3815,  4067,  4068,  2469,  1819,  3506,  3506,  3506,  3506,  3506,
    3438,  2826,  3036,  3548,  4455,  4487,  4483,  3540,  4097,  4096,
    3487,  4432,  4225,  2451,  4383,   987,  4228,   394,  1975,  1665,
    1663,  3974,  4308,  1146,   669,   669,   349,  3934,  2886,  2528,
    3935,  4358,  1271,  4439,  4484,  4254,   969,  2790,  2537,  4128,
    2789,  2561,  3914,  3641,  3344,  1527,  3348,  3102,  3160,  2812,
    2544,  2172,  2198,  2197,   682,  3360,  3504,  3504,  3504,  3504,
    3504,  1924,   969,  3356,   967,  2811,  4148,   682,  1552,  2806,
    2202,  2539,  2785,   796,   394,  2509,  3303,  1664,    81,    81,
    2543,    81,  3117,  3605,  4164,  3345,  1535,  3912,  3699,  1146,
    1267,  4298,  3689,  4407,  4415,  4408,  3351,  3289,  3204,  3182,
    2558,  3287,  2750,  4192,  1112,  3592,  3110,  2503,  1665,  2581,
    1864,  2823,  2586,   682,  2588,  4406,  1082,  2591,  2205,  2212,
    1315,  2814,  2830,  1986,  3334,  3758,  2827,  1611,  2828,  4026,
     796,  1612,  2112,  2933,  3759,  3747,  3102,  1105,  2209,  2573,
     797,  2834,  2934,  2935,  2936,  3162,  1506,  1506,   209,  1819,
    1640,   969,  3103,  1913,    83,     0,     0,     0,  1669,  1355,
       0,     0,     0,     0,     0,  1670,     0,     0,   355,     0,
       0,     0,     0,  1746,     0,  1146,     0,     0,     0,     0,
    4202,  1672,     0,     0,     0,     0,  2937,     0,  3497,  1673,
       0,     0,     0,     0,     0,     0,     0,   797,     0,  2067,
       0,     0,  2068,  1146,     0,  3007,     0,     0,     0,  4236,
       0,     0,     0,  1599,     0,     0,  4201,     0,     0,  2069,
       0,     0,  1699,  1700,     0,   355,     0,  2071,     0,     0,
    1146,  1146,  2072,  1146,     0,  2938,     0,   209,  1674,     0,
       0,  1668,  3104,     0,     0,     0,  2095,  1669,     0,   967,
    1146,     0,     0,     0,  1670,     0,     0,     0,     0,     0,
       0,   794,  1746,     0,     0,     0,     0,     0,  4299,     0,
    1672,   682,   803,     0,  2939,  2749,     0,     0,  1673,     0,
       0,  1774,     0,     0,     0,     0,     0,  2134,     0,     0,
    2940,  2941,  2942,  2943,  2944,     0,  2945,  1826,  1827,     0,
    2769,  1146,   396,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1853,  3223,  3224,     0,   794,     0,
    3239,   356,  4472,     0,     0,     0,     0,  1674,  2946,   803,
       0,  3104,     0,  1146,     0,     0,   969,  1146,  1146,     0,
       0,     0,     0,     0,  2788,     0,  2791,     0,  1886,  1888,
       0,     0,     0,   396,   396,   396,     0,  2073,     0,  3272,
    3273,  2074,     0,     0,     0,     0,  1270,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2238,  2075,  2076,     0,     0,     0,     0,     0,     0,
       0,     0,  4371,     0,     0,     0,  2077,   682,     0,     0,
       0,  2947,     0,   396,     0,     0,     0,     0,     0,     0,
     396,  1819,     0,     0,     0,     0,   396,     0,     0,     0,
    1012,     0,     0,   682,     0,   394,     0,  2948,  2078,     0,
       0,  2079,     0,     0,  2949,     0,     0,  2950,     0,     0,
       0,  1012,     0,     0,  2080,     0,     0,  2081,  1819,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4441,
       0,  4442,  2891,  4444,  4443,     0,     0,     0,     0,     0,
       0,  1819,     0,     0,     0,  2663,  2663,     0,  4360,     0,
    2663,   796,     0,     0,     0,     0,     0,     0,     0,     0,
      35,  4441,     0,  4442,     0,  4444,  4443,     0,    41,    42,
       0,     0,     0,     0,  2067,     0,     0,  2068,     0,     0,
       0,  2912,   682,   669,     0,     0,  1012,  2082,     0,  2663,
    2663,     0,     0,     0,  2069,     0,   349,  2070,     0,     0,
    1803,     0,  2071,  1819,  4441,     0,  4442,  2072,  4444,  4443,
       0,     0,     0,     0,     0,     0,     0,     0,   797,     0,
    2432,     0,     0,     0,     0,     0,     0,     0,  4471,     0,
       0,  4466,     0,     0,     0,  4361,     0,     0,  1819,     0,
       0,     0,     0,     0,     0,     0,   355,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4465,     0,     0,     0,
       0,     0,     0,  1819,     0,     0,     0,     0,   396,     0,
       0,   349,     0,  2083,  2084,  2085,  4466,  2086,  2087,  2088,
    2089,  2090,  2091,     0,  4466,     0,     0,     0,     0,  3218,
       0,     0,  4462,     0,     0,     0,     0,     0,     0,     0,
       0,  4465,     0,  3060,     0,     0,     0,     0,     0,  4465,
    1146,     0,  1146,     0,     0,     0,     0,     0,  1819,     0,
       0,  1146,     0,     0,  2395,     0,     0,     0,     0,     0,
       0,     0,  2073,     0,     0,     0,  2074,  4462,     0,   794,
       0,     0,     0,  1814,     0,  4462,     0,     0,     0,     0,
     803,     0,     0,    81,     0,  1987,    81,  2075,  2076,     0,
       0,     0,     0,     0,     0,     0,     0,   682,     0,     0,
       0,  2077,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3169,
       0,     0,     0,  2078,     0,  1146,  2079,     0,     0,     0,
       0,     0,  2458,     0,     0,     0,     0,     0,     0,  2080,
       0,     0,  2081,     0,     0,     0,     0,  2395,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1146,  1146,     0,     0,     0,     0,     0,
       0,  1146,     0,     0,  1146,     0,     0,  1146,     0,     0,
       0,     0,  2647,     0,     0,  1146,  1146,     0,     0,  2384,
    2385,  2386,  2387,  1146,     0,     0,  1146,  1146,  1146,  1146,
       0,     0,     0,     0,     0,  2395,  1146,  1146,     0,  1146,
       0,  1146,  2082,     0,  1146,     0,     0,     0,  1814,     0,
    2415,  2416,     0,     0,     0,     0,  2425,     0,  1819,  1146,
     396,     0,     0,  1146,     0,     0,     0,  1146,     0,     0,
       0,  1146,     0,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,   816,  1146,     0,     0,     0,     0,     0,  1146,
       0,     0,  1146,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3660,     0,     0,  3665,  3666,  3667,  3668,  3669,
    3670,  3671,  3672,  3673,  3674,     0,     0,     0,     0,     0,
       0,  2473,  2474,  2475,  2476,     0,     0,     0,  2083,  2084,
    2085,     0,  2086,  2087,  2088,  2089,  2090,  2091,     0,   817,
       0,     0,  3300,     0,     0,     0,   682,     0,   396,     0,
       0,     0,     0,     0,     0,  2067,     0,     0,  2068,   818,
       0,  1146,  3711,  3712,     0,   819,     0,  1987,     0,     0,
       0,     0,     0,     0,     0,  2069,     0,     0,     0,     0,
     820,     0,     0,  2071,     0,     0,  2132,     0,  2072,     0,
       0,     0,     0,  2550,     0,     0,     0,     0,     0,     0,
     396,  1506,   396,     0,     0,     0,     0,     0,   821,     0,
       0,     0,     0,   822,     0,  3375,  3376,     0,  3378,   823,
       0,     0,     0,     0,     0,     0,     0,  2348,     0,     0,
       0,     0,     0,     0,   824,     0,     0,     0,     0,    81,
       0,    81,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   396,     0,     0,     0,     0,     0,     0,   825,     0,
       0,     0,  2663,     0,     0,  2663,  2663,  2663,  2663,  2663,
    2663,  2663,  2663,  2663,  2663,  1146,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2411,
       0,     0,     0,     0,     0,  1819,     0,     0,     0,     0,
    1819,  1819,     0,     0,     0,     0,  1987,     0,     0,     0,
    1814,  1819,     0,  2073,   826,  3435,     0,  2074,     0,     0,
       0,     0,  2663,  2663,     0,     0,     0,   396,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2075,  2076,
       0,   827,     0,     0,     0,     0,     0,  1814,     0,  2448,
       0,     0,  2077,  2067,     0,     0,  2068,     0,     0,     0,
       0,   669,   396,     0,     0,   828,     0,     0,     0,     0,
    1814,   829,     0,  2069,     0,     0,     0,   830,     0,     0,
     831,  2071,     0,     0,  2078,     0,  2072,  2079,  2841,     0,
    2067,     0,  2844,  2068,     0,     0,     0,  3893,     0,     0,
    2080,     0,     0,  2081,  2522,     0,   832,     0,   833,     0,
       0,     0,   834,     0,  2864,  3534,     0,  3537,  2071,     0,
     835,     0,  2876,  2072,  1146,   836,  1819,     0,     0,     0,
       0,     0,  1814,     0,     0,   837,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2890,     0,   838,     0,  1814,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2913,     0,  1814,  3547,     0,
       0,     0,     0,  2082,     0,     0,     0,     0,  3560,     0,
       0,     0,  2932,     0,     0,  2952,     0,  1819,     0,     0,
       0,     0,  1814,  3572,     0,     0,     0,     0,  1146,     0,
       0,     0,     0,  2968,     0,     0,     0,     0,  1146,     0,
    2972,  2073,     0,     0,     0,  2074,     0,     0,     0,  2985,
       0,     0,     0,     0,     0,     0,  2989,     0,     0,     0,
       0,     0,     0,     0,  3632,     0,  2075,  2076,     0,     0,
       0,     0,     0,     0,     0,  1146,  3622,  1814,  2073,  3623,
    2077,     0,  2074,     0,     0,     0,     0,  2663,  3645,  2083,
    2084,  2085,     0,  2086,  2087,  2088,  2089,  2090,  2091,     0,
       0,     0,     0,  2075,  2076,  3264,     0,     0,  4000,  4001,
       0,     0,  2078,     0,     0,  2079,     0,  2077,     0,  1146,
    1506,     0,     0,     0,  2698,     0,     0,     0,  2080,     0,
    1819,  2081,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1146,
    1146,     0,  2079,     0,  2067,     0,     0,  2068,     0,     0,
       0,     0,     0,     0,     0,  2080,     0,     0,     0,     0,
       0,     0,     0,     0,  2069,     0,     0,     0,  2955,  1146,
    1146,     0,  2071,     0,  1146,     0,     0,  2072,     0,     0,
       0,     0,     0,     0,     0,     0,  1146,  1146,  1146,  1146,
       0,  2082,     0,     0,   396,     0,     0,     0,  1146,   396,
       0,  1146,     0,  1146,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1146,  1146,  2999,  1146,     0,  3723,  3724,
       0,     0,  3008,  3009,  3010,  3011,  3012,  3013,  2082,  1146,
       0,  1146,     0,     0,     0,  1146,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1146,     0,     0,     0,     0,     0,  1814,  2663,  2663,
       0,  1146,     0,  1146,  1146,  1146,  2067,     0,     0,  2068,
       0,     0,     0,     0,     0,     0,     0,  2083,  2084,  2085,
       0,  2086,  2087,  2088,  2089,  2090,  2091,  1146,     0,     0,
       0,  2692,     0,  3080,  2071,     0,  1146,     0,     0,  2072,
       0,     0,  2073,     0,     0,  1146,  2074,     0,     0,     0,
    1146,     0,     0,     0,  2083,  2084,  2085,  1146,  2086,  2087,
    2088,  2089,  2090,  2091,     0,     0,     0,  2075,  2076,     0,
       0,     0,     0,  3144,     0,  3146,     0,     0,     0,     0,
       0,  2077,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1146,     0,  2893,     0,     0,
       0,     0,     0,  2078,     0,     0,  2079,  4175,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2080,
       0,     0,  2081,  1819,  1819,     0,  1819,     0,     0,     0,
       0,  4189,  4190,     0,     0,     0,     0,     0,  2067,     0,
       0,  2068,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3902,  3903,     0,  2073,     0,  3874,     0,  2074,     0,
       0,     0,     0,     0,     0,     0,  2071,  1819,     0,  1819,
       0,  2072,     0,     0,  3899,     0,     0,     0,     0,  2075,
    2076,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3906,  2082,  2077,  2067,     0,     0,  2068,     0,     0,
     396,   396,   396,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3029,     0,  2069,     0,     0,     0,  3371,     0,
       0,     0,  2071,     0,  1814,  2078,     0,  2072,  2079,  1814,
    1814,     0,     0,     0,     0,     0,     0,     0,  1819,     0,
    1814,  2080,     0,     0,     0,  3969,  3970,  3971,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3274,
     396,     0,     0,     0,  3488,  1819,     0,  2663,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2083,  2084,
    2085,     0,  2086,  2087,  2088,  2089,  2090,  2091,     0,     0,
    3746,  2663,  2663,     0,     0,     0, -2403,     0,   396,  1819,
    2074,     0,  4295,  3419,     0,     0,     0,     0,     0,     0,
    3429,     0,     0,     0,  2082,     0,  1819,     0,     0,     0,
       0,  2075,  2076,     0,     0,     0,  2067,     0,     0,  2068,
    1819,     0,     0,     0,     0, -2403,     0,     0,     0,     0,
       0,     0,     0,  1819,     0,     0,  2069,     0,     0,     0,
       0,     0,  2073,     0,  2071,  1814,  2074,     0,     0,  2072,
       0,  1146,     0,     0,     0,  1146,  4012,  4013,  4014,  4015,
    2079,     0,  3456,     0,  1146,     0,     0,  2075,  2076,     0,
    1819,     0,     0,  2080,     0,     0,  3190,     0,     0,     0,
       0,  2077,     0,     0,     0,     0,     0,     0,     0,     0,
    2083,  2084,  2085,     0,  2086,  2087,  2088,  2089,  2090,  2091,
    1146,     0,     0,     0,     0,     0,  1814,     0,     0,     0,
       0,     0,     0,  2078,     0,     0,  2079,     0,     0,     0,
       0,     0,     0,  4072,  4073,     0,  4075,     0,     0,  2080,
       0,     0,  2081,  1146,     0,     0,  1819,     0,     0,     0,
       0,     0,  1146,     0,     0,     0, -2403,     0,  1146,     0,
    1146,     0,  2663,     0,     0,  1819,  1146,     0,     0,  1146,
    1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,  1146,     0,
       0,     0,  1146,  1146,  2073,     0,     0,     0,  2074,     0,
    1819,     0,     0,     0,     0,  1146,     0,     0,     0,   396,
       0,  1146,     0,     0,     0,     0,     0,     0,     0,  2075,
    2076,  1146,  2082,     0,  1146,     0,  1146,     0,     0,     0,
       0,     0,     0,  2077,  1819,  1146,  1146,  1146,     0,  1814,
       0,  1146,     0,     0,  1146,  2395,     0,     0,     0,     0,
       0,     0,     0,     0,  1146,     0,  2086,  2087,  2088,  2089,
    2090,  2091,  1146,  3635,  1146,  2078,     0,     0,  2079,     0,
       0,     0,  2067,  4159,     0,  2068,     0,     0,     0,     0,
       0,  2080,     0,  4159,  2081,  3648,     0,     0,     0,     0,
       0,     0,     0,   677,     0,     0,     0,     0,   695,  4154,
    2071,     0,     0,     0,     0,  2072,     0,     0,  2083,  2084,
    2085,     0,  2086,  2087,  2088,  2089,  2090,  2091,     0,     0,
       0,     0,  3498,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1146,     0,   695,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2082,     0,   695,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   396,  1819,   396,     0,
       0,     0,     0,     0,     0,   978,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   980,
       0,   396,     0,  3285,     0,     0,     0,   988,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   998,  3426,   978,  3428,     0,     0,  1019,     0,
       0,     0,     0,     0,     0,     0,     0,  1047,     0,     0,
   -2403,     0,     0,     0,  2074,  1052,  1047,     0,     0,     0,
    2083,  2084,  2085,     0,  2086,  2087,  2088,  2089,  2090,  2091,
       0,     0,     0,     0,  3698,  2075,  2076,     0,     0,  2067,
       0,     0,  2068,     0,     0,  4244,     0,     0,     0, -2403,
       0,  1146,     0,     0,     0,  1684,     0,     0,     0,     0,
    3777,  1685,     0,     0,  3459,     0,     0,  2071,  4292,  1819,
       0,     0,  2072,     0,  1506,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2079,  1710,     0,     0,     0,     0,
       0,  2067,  1814,  1814,  2068,  1814,     0,  2080,     0,     0,
    1686,     0,     0,     0,  1819,  1146,  1146,     0,     0,     0,
       0,  2069,     0,     0,     0,     0,     0,     0,  3822,  2071,
    3824,     0,     0,     0,  2072,     0,     0,     0,     0,  1146,
       0,     0,     0,  1711,  1146,     0,  1814,  1146,  1814,  4331,
       0,     0,  3554,     0,  2067,     0,     0,  2068,     0,     0,
       0,  1687,     0,  4316,     0,     0,  2893,     0,  1688,  2067,
       0,  1689,  2068,     0,  2069,     0,     0,     0,     0,     0,
   -2403,     0,  2071,     0,     0,     0,     0,  2072,     0,  2069,
       0,  1146,     0,     0,     0,     0,     0,  2071,     0,     0,
       0,     0,  2072,     0,     0,     0,     0,  2073,     0,     0,
       0,  2074,     0,     0,     0,     0,  3614,  1814,     0,  1712,
       0,     0,  1690,     0,     0,     0,     0,  1146,     0,     0,
       0,     0,  2075,  2076,  1146,  1146,     0,  1819,     0,     0,
       0,     0,  1146,  1146,  1814,     0,  2077,  1146,  1819,     0,
       0,     0,     0,  1146,  1146,     0,     0,  1146,     0,  2073,
       0,     0,     0,  2074,  1713,     0,  1714,     0,  1146,     0,
    2086,  2087,  2088,  2089,  2090,  2091,  1715,     0,  1814,     0,
    1146,  2079,  3654,     0,  2075,  2076,     0,     0,     0,     0,
       0,     0,     0,     0,  2080,  1814,    81,     0,  2077,     0,
       0,  3659,     0,     0,     0,     0,     0,     0,  1146,  1814,
    1716,  1692,  2073,     0,     0,     0,  2074,     0,     0,     0,
       0,     0,  1814,     0,     0,     0,  3681,  2073,     0,  1819,
    2078,  2074,     0,  2079,     0,     0,     0,  2075,  2076,  1819,
    1717,     0,     0,     0,  1694,  1718,  2080,     0,     0,  2081,
       0,  2077,  2075,  2076,     0,     0,     0,     0,     0,  1814,
    1987,     0,     0,     0,     0,     0,  2077,  2082,     0,  1719,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1720,
       0,     0,     0,  2078,   396,     0,  2079,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2078,  2080,
       0,  2079,  2081,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2080,     0,     0,  2081,     0,  2082,
       0,     0,     0,     0,     0,  1814,     0,     0,     0,     0,
       0,  1146,   695,     0,     0,     0,     0,     0,     0,     0,
       0,   396,     0,     0,  1814,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -2403, -2403,     0,  2086,  2087,  2088,
    2089,  2090,  2091,     0,     0,     0,     0,     0,     0,  1814,
       0,     0,  2082,     0,     0,  4061,     0,     0,     0,  1819,
       0,     0,     0,     0,     0,     0,  4070,  2082,     0,     0,
    1146,     0,     0,     0,  1146,     0,     0,     0,     0,  1819,
       0,     0,     0,  1814,     0,  2083,  2084,  2085,     0,  2086,
    2087,  2088,  2089,  2090,  2091,     0,     0,     0,     0,  3753,
       0,  1146,     0,     0,     0,  1819,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1146,  1146,     0,     0,  1146,
       0,     0,     0,     0,     0,     0,  1146,  1146,  2083,  2084,
    2085,     0,  2086,  2087,  2088,  2089,  2090,  2091,     0,     0,
       0,     0,  3767,  2083,  2084,  2085,     0,  2086,  2087,  2088,
    2089,  2090,  2091,  1146,     0,     0,     0,  3979,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1819,     0,     0,  1146,     0,  4046,  4046,     0,     0,     0,
    1142,  1148,   695,     0,  1148,  3904,  1142,   677,  1047,     0,
    1173,     0,   677,     0,  1047,     0,  1047,     0,     0,     0,
    1148,   677,  1047,     0,     0,     0,  1814,     0,     0,  1146,
    1195,     0,     0,     0,     0,  1047,     0,  1142,     0,     0,
       0,   695,  4074,  1148,     0,     0,   677,     0,  1173,     0,
     677,  1240,     0,     0,     0,     0,     0,     0,  1148,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1146,     0,  1819,
    1047,     0,     0,     0,     0,  1269,     0,  2067,     0,  1142,
    2068,     0,     0,   695,     0,     0,  1142,     0,     0,  1173,
       0,     0,     0,     0,     0,     0,  1146,  1819,     0,  1146,
       0,  1146,     0,     0,  1148,  2071,     0,     0,     0,     0,
    2072,     0,     0,     0,     0,  1330,     0,  2067,     0,     0,
    2068,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2069,  1814,  1146,
       0,     0,  1819,     0,     0,  2071,  1819,  1819,     0,     0,
    2072,     0,     0,  1047,     0,     0,     0,     0,  1047,     0,
       0,     0,     0,     0,  1987,     0,     0,     0,     0,     0,
    1047,  1385,   396,  1814,     0,     0,     0,     0,     0,  1146,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1488,     0,  3713,     0,
     695,  1047,     0,     0,  1269,  1819,     0,     0,     0,  4362,
       0,     0,     0,     0,     0,     0,     0,     0,  1047,     0,
       0,     0,  1047,     0,     0,  1146,     0,  1538,     0,     0,
       0,     0,  1488,     0,     0, -2403,     0,     0,     0,  2074,
       0,  1047,     0,     0,     0,  4057,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  4065,     0,     0,  4213,     0,
    2075,  2076,     0,     0,     0,     0,     0,     0,     0,  1146,
       0,     0,     0,     0, -2403,  2073,  1146,     0, -1915,  2074,
       0,     0,     0,     0,     0,     0,     0,     0,   677,   677,
       0,     0,  1146,  1146,     0,     0,  1814,     0,     0,     0,
    2075,  2076,  1146,     0,     0,     0,     0,  1814,     0,  2079,
       0,     0,  2067,     0,  2077,  2068,     0,     0,     0,     0,
       0,     0,  2080,     0,     0,     0,     0, -1915,     0,  1146,
       0,     0,  2069,  1148,  1148,     0,     0,     0, -1915,  1146,
    2071,     0, -1915,     0,     0,  2072,  2078, -1915,  2067,  2079,
       0,  2068, -1915,     0,     0, -1915,     0, -1915,     0,  4280,
       0,     0,  2080,     0,     0,  2081,     0,     0,  2069,     0,
    1142,     0,     0,     0,     0,     0,  2071,  1142,     0,     0,
    1173,  2072,     0,     0, -1915,     0,     0,     0,  1814,     0,
       0,     0,  1148,  1146,     0, -2403,     0,     0,  1814,     0,
       0,     0,  1146, -1915,     0,     0,     0,     0,  1148,  1148,
       0,     0,     0,     0,     0,  3554,     0,     0,     0,     0,
       0,  4046,  1047,  1047,  1047,  1148,     0,  1142,     0,     0,
       0,  1861,     0,     0,     0,  2082,     0,     0,     0,     0,
       0,  1987,     0,  4328,  2067,  4330, -1915,  2068,     0,     0,
       0,     0,     0,     0, -1915,     0,     0,     0,     0,  1148,
    1148,     0,     0,     0,  2069,     0,     0,     0,     0,     0,
    2073,     0,  2071,     0,  2074,     0,     0,  2072,  1269,     0,
       0,     0,     0,     0,     0,  2086,  2087,  2088,  2089,  2090,
    2091,     0,     0,  1488,     0,  2075,  2076, -1915,     0,     0,
       0,     0,     0,  1269,     0,     0,  2073,     0,     0,  2077,
    2074,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2083,  2084,  2085,     0,  2086,  2087,  2088,  2089,  2090,
    2091,  2075,  2076,  1960,  1960,  4011,     0,     0,  1047,     0,
     978,  2078,   983,     0,  2079,  2077,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2080,  1814,  4395,
    2081,     0,     0,  1996,     0, -1915,  1047,     0,     0,  2002,
       0,     0,     0,     0,     0,     0,     0,  2078,     0,  1488,
    2079,     0,     0,     0,  1814,     0, -1915,     0, -1915, -1915,
       0,     0,     0,  2080,     0,     0,  2081,     0,     0,  4424,
       0,     0,  2073,     0,     0,     0,  2074,  1488,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
   -1915,     0,     0, -1915, -1915,     0, -1915,  2075,  2076,     0,
    2082,     0,     0,  1987,  1488,  1488,     0,  1488,     0,     0,
       0,  2077,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1488,     0,     0,     0,     0,  1814,
       0,     0,     0,     0,     0,     0,  2082,     0,     0,     0,
       0,     0,     0,  2078,   695,   695,  2079,     0,  1987,     0,
       0,     0,  1987,  1987,     0,     0,     0,     0,  1269,  2080,
       0,     0,  2081,     0,     0,  1269,  1269,     0,     0,     0,
       0,     0,  1047,     0,     0,  1488,     0,  2067,     0,     0,
    2068,  2159,     0,  2166,     0,     0,  2083,  2084,  2085,     0,
    2086,  2087,  2088,  2089,  2090,  2091,     0,  2069,     0,     0,
    4183,     0,     0,     0,     0,  2071,     0,  1488,     0,     0,
    2072,  1488,  1488,     0,     0,     0,     0,     0,  1814,     0,
       0,     0,  2083,  2084,  2085,     0,  2086,  2087,  2088,  2089,
    2090,  2091,  2082,     0,     0,     0,  4208,     0,     0,     0,
       0,     0,     0,     0,     0,   695,  1814,   677,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1814,     0,     0,     0,  1814,  1814,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2083,  2084,
    2085,     0,  2086,  2087,  2088,  2089,  2090,  2091,  2321,     0,
       0,     0,  4246,     0,  1047,  2073,     0,     0,     0,  2074,
       0,     0,     0,     0,     0,     0,     0,  1173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2075,  2076,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2077,     0,     0,     0,     0,     0,
    1148,  1148,  1148,  1148,  1047,     0,     0,     0,   677,     0,
       0,     0,     0,     0,     0,     0,     4,     0,     0,     0,
       0,     0,     0,  2408,     0,  1047,  2078,     0,     0,  2079,
       0,  1148,  1148,     0,     0,     0,     5,  1148,     0,     0,
       0,     0,  2080,     0,     0,  2081,     6,     7,     0,     0,
       0,     0,     8,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,    36,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,   677,    45,     0,     0,
       0,     0,  1148,  1148,  1148,  1148,     0,     0,     0,     0,
       0,   677,     0,     0,     0,  2082,     0,     0,     0,  2408,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2517,     0,  1142,     0,     0,     0,
       0,     0,     0,   695,    46,  1142,     0,     0,     0,     0,
       0,     0,     0,  1173,     0,     0,     0,     0,  1047,     0,
       0,     0,     0,     0,     0,     0,     0,  1047,     0,   677,
       0,     0,     0,  1148,  1148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1047,     0,     0,
    1330,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2083,  2084,  2085,     0,  2086,  2087,  2088,  2089,  2090,
    2091,     0,     0,     0,     0,  4397,    47,     0,     0,     0,
       0,  1960,  2067,     0,     0,  2068,     0,     0,     0,  1142,
       0,    48,     0,  1047,  1047,     0,     0,     0,     0,     0,
       0,  2598,  2069,     0,     0,  1047,     0,     0,     0,     0,
    2071,    49,     0,     0,     0,  2072,     0,     0,     0,     0,
       0,   978,   978,     0,     0,  2623,     0,  1488,  1488,     0,
       0,     0,     0,    50,     0,  1488,     0,     0,  1488,     0,
       0,  1488,     0,     0,     0,     0,     0,     0,     0,  1488,
    1488,     0,     0,     0,     0,     0,     0,  1488,     0,  1173,
    1488,  1488,  1488,  1488,     0,     0,    51,     0,     0,    52,
    1488,  1488,     0,  1488,     0,  1488,     0,     0,  1488,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      53,     0,     0,  1488,     0,     0,     0,  1488,     0,     0,
       0,  1488,     0,     0,     0,  1488,     0,  1488,  1488,  1488,
    1488,  1488,  1488,  1488,  1488,  1488,     0,  1488,     0,     0,
       0,     0,  1047,  1488,     0,     0,  1488,     0,     0,     0,
       0,     0,     0,     0,     0,  2067,     0,     0,  2068,     0,
    2073,     0,     0,     0,  2074,     0,     0,  1047,     0,     0,
       0,     0,     0,     0,     0,  2069,     0,     0,     0,  2796,
       0,    54,     0,  2071,     0,  2075,  2076,     0,  2072,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2077,
       0,     0,     0,     0,  2166,     0,     0,     0,     0,     0,
       0,  1047,     0,  1047,     0,  1488,     0,     0,     0,     0,
       0,     0,     0,    55,     0,     0,     0,     0,     0,     0,
       0,  2078,     0,     0,  2079,     0,    56,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2080,     0,    57,
    2081,     0,     0,     0,     0,     0,     0,     0,     0,  2797,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    58,   677,     0,     0,     0,     0,
      59,     0,     0,     0,    60,    61,    62,    63,    64,     0,
       0,    65,    66,    67,    68,     0,    69,    70,    71,    72,
      73,     0,   677,     0,     0,     0,   677,   695,     0,     0,
       0,     0,   978,  2073,   978,     0,     0,  2074,     0,     0,
    2082,     0,     0,     0,     0,     0,     0,     0,   677,  1488,
       0,     0,     0,     0,     0,     0,   677,     0,  2075,  2076,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2077,     0,     0,     0,     0,     0,     0,   677,
       0,  2321,     0,     0,     0,     0,     0,  2894,     0,     0,
       0,     0,  2903,     0,     0,     0,     0,     0,  1047,   677,
       0,     0,     0,     0,  2078,     0,     0,  2079,     0,  2925,
    2925,     0,     0,     0,     0,   695,   677,     0,     0,   677,
    2080,     0,     0,  2081,     0,     0,  2083,  2084,  2085,  1148,
    2086,  2087,  2088,  2089,  2090,  2091,     0,   677,     0,     0,
    4474,     0,     0,     0,   677,  2067,     0,     0,  2068,     0,
       0,     0,     0,   677,     0,     0,     0,     0,     0,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2071,  2067,     0,  1148,  2068,  2072,     0,
       0,     0,     0,  1148,  1148,  1148,  1148,  1148,  1148,     0,
       0,     0,     0,  2082,  2069,     0,     0,     0,  1488,     0,
       0,     0,  2071,     0,     0,     0,     0,  2072,     0,     0,
       0,     0,     0,     0,     0,     0,  2925,     0,     0,     0,
    1047,     0,     0,     0,   978,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2798,     0,     0,     0,     0,     0,  3076,     0,
       0,     0,     0,     0,  1148,  3090,     0,     0,     0,     0,
       0,     0,     0,     0,  1269,  1861,  3714,     0,     0,     0,
       0,     0,  2517,  3120,     0,     0,     0,  3120,  3133,  2083,
    2084,  2085,  1488,  2086,  2087,  2088,  2089,  2090,  2091,     0,
       0,     0,     0,     0,  1148,  2925,  1148,  2925,  2067,     0,
       0,  2068,     0, -2403,     0,     0,     0,  2074,     0,     0,
    4449,  1269,     0,     0,     0,     0,     0,     0,  2069,  1488,
       0,  3206,     0,     0,     0,     0,  2071,     0,  2075,  2076,
       0,  2072,  2073,     0,     0,     0,  2074,     0,     0,     0,
    1960,     0, -2403,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   677,  2075,  2076,     0,
       0,     0,     0,  1488,     0,     0,     0,     0,     0,     0,
       0,  2077,     0,     0,     0,     0,     0,  2079,     0,     0,
       0,     0,     0,     0,   677,     0,     0,     0,     0,     0,
    2080,     0,     0,  1488,  1488,     0,     0,     0,     0,     0,
       0,     0,     0,  2078,     0,     0,  2079,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2080,
       0,     0,  2081,  1488,  1488,     0,     0,     0,  1488,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4450,     0,
    1488,  1488,  1488,  1488,     0,     0,     0,     0,     0,     0,
       0,     0,  1488,     0,     0,  1488,  2073,  1488,  3268,     0,
    2074,     0,     0, -2403,     0,     0,     0,  1488,  1488,     0,
    1488,     0,     0,     0,     0,   802,     0,     0,     0,     0,
       0,  2075,  2076,  1488,     0,  1488,     0,  1173,     0,  1488,
       0,     0,  2082,     0,     0,  2077,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1488,     0,     0,     0,  1047,
       0,     0,     0,     0,     0,  2517,     0,  1488,  1488,  1488,
     802,     0,     0,     0,     0,     0,     0,  2078,     0,     0,
    2079,     0,     0,     0,     0,     0,     0,  1269,     0,     0,
       0,  1488,     0,  2080,     0,     0,  2081,     0,  2166,     0,
    1488,     0,     0,  2086,  2087,  2088,  2089,  2090,  2091,  1488,
       0,     0,  2067,     0,  1488,  2068,     0,  1010,  1047,     0,
       0,  1488,     0,     0,  1010,     0,  1010,     0,  2083,  2084,
    2085,     0,  2086,  2087,  2088,  2089,  2090,  2091,   802,     0,
    2071,     0,     0,     4,     0,  2072,     0,     0,     0,     0,
       0,     0,   677,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     5,     0,     0,  2082,     0,     0,  1488,
       0,  2925,     0,     6,     7,  1960,     0,     0,     0,     0,
       0,     9,    10,     0,     0,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,     0,
       0,     0,     0,  3717,     0,     0,     0,   677,     0,     0,
    2067,     0,     0,  2068,   677,     0,     0,     0,     0,     0,
       0,     0,  2083,  2084,  2085,     0,  2086,  2087,  2088,  2089,
    2090,  2091,     0,     0,     0,     0,     0,     0,  2071,     0,
   -2403,    46,     0,  2072,  2074,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2075,  2076,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   677,     0,     0, -2403,
       0,     0,     0,     0,     0,     0,  2925,  2925,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,    47,  2079,  3505,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2080,    48,     0,
       0,  4009,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    49,     0,
       0,     0,     0,     0,  1960,  1047,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1047,     0,     0, -2403,     0,
      50,     0,  2074,     0,     0,     0,     0,     0,     0,     0,
    1047,     0,     0,     0,     0,     0,  1269,     0,     0,     0,
       0,     0,     0,  2075,  2076,   695,     0,     0,     0,  3120,
   -2403,     0,  3596,    51,     0,  2517,    52, -2403,     0,  2517,
       0,     0,     0,     0,     0,  3609,     0,     0,  1488,     0,
       0,     0,     0,     0,     0,     0,     0,    53,     0,     0,
       0,     0,     0,  1047,     0,     0,  1047,     0,     0,   677,
       0,     0,  2079,  3627,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1142,  2080,     0,   677,     0,     0,
       0,     0,     0,     0,  2598,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1047,     0,   677,
       0,     0,     0,     0,     0,     0,     0,  1488,     0,     0,
    2086,  2087,  2088,  2089,  2090,  2091,  1488,     0,    54,     0,
       0,     0,  1488,     0,  1488,     0,     0,     0,     0,     0,
    1488,     0,     0,  1488,  1488,  1488,  1488,  1488,  1488,  1488,
    1488,  1488,  1488,     0,     0,     0,  1488,  1488, -2403,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1488,
      55,     0,     0,     0,     0,  1488,     0,     0,     0,     0,
       0,     0,     0,    56,     0,  1488,  2067,     0,  1488,  2068,
    1488,     0,     0,     0,     0,     0,    57,     0,     0,  1488,
    1488,  1488,     0,     0,     0,  1488,  2069,     0,  1488,     0,
       0,     0,     0,     0,  2071,  1047,  1047,     0,  1488,  2072,
       0,    58,     0,     0,  3736,     0,  1488,    59,  1488,     0,
       0,    60,    61,    62,    63,    64,     0,     0,    65,    66,
    1308,     0,     0,     0,     0,    71,  1309,     0,  2086,  2087,
    2088,  2089,  2090,  2091,     0,     0,     0,  2166,     0,     0,
       0,     0,     0,  2067,     0,     0,  2068,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1196,     0,     0,  2069,     0,     0,     0,  2067,     0,     0,
    2068,  2071,     0,     0,     0,     0,  2072,     0,  3773,  1960,
    1960,     0,     0,     0,   677,     0,     0,  2069,     0,     0,
       0,     0,  1197,     0,     0,  2071,   802,     0,     0,     0,
    2072,     0,     0,  3791,  1144,  1198,     0,     0,     0,     0,
    1144,     0,     0,  1199,     0,     0,     0,  1200,     0,     0,
       0,     0,     0,     0,  2073,     0,     0,     0,  2074,     0,
       0,     0,     0,     0,     0,     0,     0,  1201,     0,     0,
       0,  1144,   677,     0,   677,     0,     0,     0,     0,  2075,
    2076,     0,     0,     0,     0,     0,     0,     0,  1202,     0,
       0,     0,     0,  2077,     0,     0,     0,     0,     0,     0,
    1269,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3242,     0,     0,     0,     0,  3243,     0,     0,     0,     0,
       0,  1203,     0,  1144,     0,  2078,     0,  3505,  2079,     0,
    1144,  2073,     0,  1047,     0,  2074,     0,     0,     0,     0,
       0,  2080,  1204,     0,  2081,  1488,     0,     0,     0,     0,
       0,  1047,     0,     0,     0,  2073,  2075,  2076,     0,  2074,
       0,     0,  3690,     0,     0,     0,  1205,     0,  1047,     0,
    2077,     0,     0,     0,     0,     0,     0,  3076,     0,     0,
    2075,  2076,  3921,     0,     0,     0,  2321,     0,  3627,     0,
       0,     0,     0,     0,  2077,     0,     0,     0,     0,  1488,
    1488,     0,  2078,     0,     0,  2079,     0,     0,     0,     0,
       0,     0,     0,     0,  2082,     0,     0,     0,  2080,  3120,
       0,  2081,  1206,  2517,     0,     0,  2078,  3691,  2517,  2079,
       0,  2517,  3076,     0,  3959,     0,     0,     0,     0,     0,
    1144,  2925,  2080,  2925,     0,  2081,  1010,     0,     0,   827,
    1010,     0,     0,     0,     0,     0,     0,     0,  3220,     0,
       0,   677,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1207,     0,  1488,  1144,  1208,     0,  1209,
       0,     0,     0,     0,     0,  1210,     0,     0,     0,     0,
       0,  2082,     0,     0,     0,     0,     0,     0,     0,     0,
    2083,  2084,  2085,     0,  2086,  2087,  2088,  2089,  2090,  2091,
       0,  1488,     0,     0,  1211,  2082,  1212,     0,  1488,  1488,
    1213,     0,     0,     0,     0,     0,  1488,  1488,  1214,     0,
       0,  1488,     0,  1215,     0,     0,     0,  1488,  1488,     0,
       0,  1488,     0,  1047,  1047,  1047,  1047,     0,     0,     0,
       0,     0,  1488,     0,     0,  1216,     0,     0,  4023,     0,
       0,     0,     0,     0,  1488,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1173,     0,  2083,  2084,  2085,
       0,  2086,  2087,  2088,  2089,  2090,  2091,     0,     0,   978,
       0,     0,  1488,     0,     0,     0,  1148,  1148,     0,     0,
       0,  2083,  2084,  2085,     0,  2086,  2087,  2088,  2089,  2090,
    2091,  4056,     0,     0,  1144,     0,     0,     0,     0,   677,
       0,  1144,     0,     0,     0,  2067,     0,     0,  2068,     0,
     677,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1817,  1148,     0,  2069,     0,     0,  3250,     0,
       0,     0,     0,  2071,     0,     0,     0,     0,  2072,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1269,  1144,     0,     0,     0,     0,     0,  1960,     0,     0,
    1816,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3505,  3505,  3505,  3505,  3505,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1488,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,     0,     0,
       0,     0,     0,  2067,     0,     0,  2068,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2069,     0,     0,  1047,     0,  4158,     0,
       0,  2071,     0,     0,  1488,     0,  2072,     0,  2517,     0,
       0,  3959,     0,  2073,     0,     0,     0,  2074,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1817,     0,     0,
     677,     0,     0,     0,     0,  1488,     0,     0,  2075,  2076,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2077,  1144,     0,     0,     0,     0,     0,  1488,
    1488,     0,     0,  1488,     0,  1816,     0,     0,     0,     0,
    1488,  1488,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1144,     0,     0,  2078,     0,     0,  2079,     0,     0,
       0,   677,     0,   677,     0,     0,     0,  3773,  1173,  1148,
    2080,     0,     0,  2081,     0,     0,     0,     0,  1144,  1144,
       0,  1144,     0,     0,     0,  3255,     0,  1142,  1173,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1144,     0,
       0,  2073,     0,     0,     0,  2074,     0,     0,     0,     0,
       0,     0,  1960,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1142,     0,     0,  2075,  2076,     0,     0,
       0,     0,  1047,     0,     0,     0,     0,     0,     0,     0,
    2077,     0,     0,  2082,  2925,     0,  2321,     0,     0,  1144,
     802,     0,     0,     0,     0,     0,  3921,     0,     0,     0,
       0,  1047,  2067,     0,     0,  2068,     0,     0,     0,     0,
    1148,  3773,  2078,     0,     0,  2079,     0,     0,     0,     0,
       0,  1144,  2069,     0,     0,  1144,  1144,     0,  2080,     0,
    2071,  2081,     0,     0,     0,  2072,     0,     0,     0,     0,
    1488,     0,     0,  1488,     0,  1488,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4304,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2083,
    2084,  2085,  1148,  2086,  2087,  2088,  2089,  2090,  2091,     0,
    1047,     0,     0,  1488,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1148,  1148,  1148,  1148,     0,     0,  1817,
       0,  2082,  1269,     0,   802,     0,     0,     0,  1010,     0,
       0,     0,  2067,     0,     0,  2068,     0,     0,     0,     0,
       0,     0,     0,  1488,     0,     0,     0,     0,     0,  1010,
       0,     0,  2069,     0,     0,  3259,  1817,  1816,     0,     0,
    2071,     0,     0,     0,     0,  2072,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1817,
    2073,     0,     0,     0,  2074,     0,     0,     0,     0,  1488,
       0,     0,     0,     0,  2314,     0,     0,  1173,     0,     0,
       0,     0,     0,     0,     0,  2075,  2076,  2083,  2084,  2085,
       0,  2086,  2087,  2088,  2089,  2090,  2091,  1816,     0,  2077,
       0,     0,     0,     0,  1010,     0,     0,     0,     0,     0,
    1148,     0,     0,  1142,  3049,     0,     0,     0,     0,     0,
    3773,  1817,     0,     0,     0,     0,     0,  4158,     0,     0,
       0,  2078,     0,  4304,  2079,     0,  1488,  1488,  1817,   677,
       0,     0,     0,     0,     0,     0,  1142,  2080,     0,     0,
    1148,     0,     0,     0,     0,     0,  1817,     0,     0,  1816,
       0,     0,     0,     0,     0,     0,     0,     0,  2933,     0,
    2073,     0,     0,  1488,  2074,     0,  1816,  2934,  2935,  2936,
       0,  1817,     0,  1488,     0,     0,   802,     0,     0,     0,
       0,     0,     0,     0,  1816,  2075,  2076,  4463,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2077,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1816,
    2082,  2937,     0,     0,     0,     0,     0,     0,  1144,     0,
    1144,     0,     0,     0,     0,     0,  1817,  1488,     0,  1144,
       0,  2078,  4463,     0,  2079,     0,  1142,     0,     0,     0,
    4463,     0,     0,     0,     0,     0,     0,  2080,     0,     0,
    2081,     0,     0,     0,     0,  3050,     0,     0,     0,     0,
    2938,     0,     0,     0,  1816,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2083,  2084,  2085,  2939,
    2086,  2087,  2088,  2089,  2090,  2091,     0,     0,     0,     0,
       0,     0,     0,  1144,     0,  2940,  2941,  2942,  2943,  2944,
    2082,  2945,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1806,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1144,  1144,  2946,     0,     0,     0,     0,     0,  1144,
       0,     0,  1144,     0,     0,  1144,     0,     0,     0,     0,
       0,     0,     0,  1144,  1144,     0,     0,     0,     0,     0,
       0,  1144,     0,     0,  1144,  1144,  1144,  1144,     0,  3051,
       0,     0,     0,     0,  1144,  1144,     0,  1144,     0,  1144,
       0,     0,  1144,     0,     0,     0,  2083,  2084,  2085,     0,
    2086,  2087,  2088,  2089,  2090,  2091,  1817,  1144,   802,     0,
    2067,  1144,     0,  2068,     0,  1144,  2947,     0,  3052,  1144,
       0,  1144,  1144,  1144,  1144,  1144,  1144,  1144,  1144,  1144,
    2069,  1144,     0,     0,     0,     0,     0,  1144,  2071,     0,
    1144,     0,  2948,  2072,  1816,     0,     0,     0,     0,  2949,
       0,     0,  2950,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     4,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2762,     0,
    1806,     0,     0,     0,     0,     0,     0,     0,     5,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     6,     7,
       0,     0,     0,     0,     0,     0,     9,    10,     0,  1144,
      11,    12,    13,    14,    15,    16,    17,    18,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,     0,     0,     0,    37,    38,
      39,    40,    41,    42,    43,    44,     0,     0,     0,    45,
       0,     0,     0,     0,   905,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   906,     0,  2073,     0,
       0,     0,  2074,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   907,     0,     0,     0,
       0,     0,     0,  2075,  2076,     0,    46,     0,     0,   802,
       0,     0,     0,     0,     0,     0,     0,  2077,     0,     0,
       0,   908,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1144,     0,     0,     0,     0,     0,     0,
       0,   909,     0,     0,     0,     0,     0,     0,     0,  2078,
       0,     0,  2079,  1817,     0,     0,     0,     0,  1817,  1817,
       0,     0,   910,     0,     0,  2080,     0,     0,  2081,  1817,
       0,     0,     0,     0,     0,     0,     0,     0,    47,     0,
       0,     0,     0,     0,     0,   802,     0,     0,     0,     0,
     911,  2881,     0,    48,     0,   912,  2314,  2888,     0,     0,
       0,   913,     0,  2067,     0,     0,  2068,  1816,     0,     0,
       0,     0,     0,    49,     0,     0,   914,     0,     0,     0,
     802,     0,     0,  2069,     0,     0,  3697,     0,     0,     0,
       0,  2071,     0,     0,     0,    50,  2072,     0,  2082,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1806,  2067,     0,     0,  2068,     0,     0,     0,
       0,     0,     0,     0,  3651,     0,     0,     0,    51,     0,
       0,    52,     0,  2069,     0,     0,     0,     0,     0,     0,
       0,  2071,  1144,     0,  1817,     0,  2072,     0,     0,  1806,
       0,     0,    53,     0,     0,     0,   915,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   916,     0,     0,     0,
       0,     0,  1806,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1816,   827,  2083,  2084,  2085,     0,  2086,  2087,
    2088,  2089,  2090,  2091,     0,  1008,     0,     0,     0,     0,
       0,     0,  1008,     0,  1008,  1817,     0,   917,     0,     0,
       0,   918,     0,   919,     0,     0,  1144,     0,     0,   920,
       0,  2073,   921,    54,     0,  2074,  1144,     0,     0,     0,
       0,     0,     0,     0,  1806,     0,     0,     0,     0,     0,
       0,     0,     0,  2314,     0,     0,  2075,  2076,   922,     0,
     923,  1806,     0,     0,   924,     0,     0,     0,     0,     0,
    2077,     0,   925,  1144,     0,    55,     0,   926,     0,  1806,
       0,  2073,     0,     0,     0,  2074,     0,   927,    56,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   928,
       0,    57,  2078,     0,  1806,  2079,  2075,  2076,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,  2080,     0,
    2077,  2081,     0,     0,     0,     0,    58,     0,  1817,     0,
       0,     0,    59,     0,     0,     0,    60,    61,    62,    63,
      64,     0,     0,    65,    66,  1308,  1912,  1144,  1144,     0,
      71,     0,  2078,     0,     0,  2079,     0,     0,     0,  1806,
       0,     0,     0,     0,     0,     0,  1816,     0,  2080,     0,
       0,  2081,     0,     0,     0,     0,     0,  1144,  1144,     0,
       0,     0,  1144,     0,     0,     0,     0, -1917,     0,     0,
       0,  2082,     0,   853,  1144,  1144,  1144,  1144,     0,     0,
       0,     0,   802,     0,     0,   854,  1144,   802,     0,  1144,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1144,  1144,     0,  1144,   855,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0, -1917,  1144,     0,  1144,
       0,  2082,     0,  1144,     0,     0,   856, -1917,     0,     0,
    -629, -1917,     0,     0,     0,     0, -1917,     0,     0,  1144,
       0, -1917,     0,     0, -1917,     0, -1917,     0,     0,  1144,
     857,  1144,  1144,  1144,     0,     0,   858,  2083,  2084,  2085,
       0,  2086,  2087,  2088,  2089,  2090,  2091,     0,     0,     0,
       0,   859,     0, -1917,     0,  1144,     0,     0,     0,     0,
       0,     0,     0,     0,  1144,     0,     0,     0,     0,  2762,
    2762,  2762, -1917,  1144,     0,     0,     0,     0,  1144,   860,
       0,     0,     0,     0,     0,  1144,   861,  2083,  2084,  2085,
     862,  2086,  2087,  2088,  2089,  2090,  2091,     0,     0,     0,
       0,     0,     0,     0,     0,  -789,     0,     0,     0,  1806,
       0,     0,     0,     0,     0, -1917,     0,     0,     0,     0,
       0,     0,     0, -1917,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1144,     0,     0,     0,     0,     0,     0,
       0,   863,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1817,  1817,     0,  1817,     0, -1917,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   864,     0,     0,   865,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2314,
    2888,     0,  2888,     0,     0,  1817,     0,  1817,     0,     0,
       0,   983,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0, -1917,     0,   866,     0,   802,   802,
     802,     0,   867,  1816,     0,  1816,     0,     0,  -362,     0,
       0,   868,     0,     0,     0, -1917,     0, -1917, -1917,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1817,  -362,     0,   869,
     870,     0,   871,   872,     0,     0,     0,     0,     0, -1917,
       0,   873, -1917, -1917,     0, -1917,   874,     0,   802,     0,
       0,   875,     0,  1817,     0,     0,   876,     0,     0,     0,
       0,     0,     0,     0,  1816,     0,     0,     0,  -362,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   802,  1817,     0,     0,
       0,  2888,     0,     0,     0,     0,  1806,     0,     0,     0,
       0,  1806,  1806,     0,  1817,     0,     0,     0,     0,     0,
       0,     0,  1806,     0,     0,     0,     0,     0,  1817,     0,
       0,     0,  1140,     0,     0,  2888,     0,     0,  1140,     0,
       0,  1817,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1816,     0,     0,     0,     0,     0,     0,  1144,
       0,     0,     0,  1144,     0,     0,  1816,     0,     0,  1140,
       0,     0,  1144,     0,     0,     0,     0,     0,  1817,  2888,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1144,     0,
    2762,     0,     0,     0,     0,     0,  1816,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,     0,  1140,     0,
       0,     0,     0,     0,     0,     0,     0,  1806,     0,     0,
       0,  1144,     0,     0,  1817,     0,     0,     0,     0,     0,
    1144,     0,     0,     0,     0,     0,  1144,     0,  1144,     0,
       0,     0,     0,  1817,  1144,     0,     0,  1144,  1144,  1144,
    1144,  1144,  1144,  1144,  1144,  1144,  1144,     0,     0,     0,
    1144,  1144,  1816,     0,     0,     0,     0,     0,  1817,     0,
       0,     0,     0,  1144,     0,     0,     0,   802,  1806,  1144,
       0,  1816,     0,     0,     0,     0,     0,     0,     0,  1144,
       0,     0,  1144,     0,  1144,     0,     0,     0,     0,     0,
       0,     0,  1817,  1144,  1144,  1144,  1816,     0,     0,  1144,
       0,     0,  1144,     0,     0,     0,     0,     0,  1140,     0,
       0,     0,  1144,     0,  1008,     0,     0,     0,  1008,     0,
    1144,     0,  1144,     0,     0,     0,     0,     0,     0,     0,
    1816,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2762,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1806,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1144,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   802,  1817,   802,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   802,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2888,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1140,     0,     0,     0,     0,     0,     0,  1140,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1815,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1140,
       0,     0,     0,     0,     0,     0,     0,  1817,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1817,  1144,  1144,  1816,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,     0,  1144,     0,     0,
       0,     0,  1144,     0,     0,  1144,     0,     0,     0,     0,
    2314,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1806,  1806,     0,  1806,     0,  1144,
       0,     0,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,  1144,     0,     0,  1806,     0,
    1806,     0,  1144,  1144,     0,  1817,     0,     0,     0,     0,
    1144,  1144,     0,     0,     0,  1144,  1817,     0,     0,  1140,
       0,  1144,  1144,     0,     0,  1144,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1144,     0,     0,     0,
       0,     0,     0,  1816,     0,     0,  1140,  1140,  1144,  1140,
       0,     0,     0,     0,  1816,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,  1806,
       0,     0,     0,     0,  2762,     0,  1144,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2762,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1806,  1817,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1817,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1806,     0,     0,     0,     0,  1816,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1816,     0,  1806,     0,  1140,
       0,     0,   802,  1140,  1140,     0,     0,     0,     0,     0,
       0,  1806,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1806,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   802,
       0,  1806,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1815,     0,     0,
       0,     0,     0,     0,     0,     0,  1008,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1817,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1008,  1144,     0,
       0,     0,  1144,     0,  1815,     0,     0,  1817,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1806,     0,     0,
       0,     0,     0,     0,     0,  4152,     0,  1815,     0,  1144,
       0,     0,     0,  1817,     0,     0,  1806,     0,     0,     0,
       0,     0,     0,     0,     0,  1816,     0,     0,     0,     0,
       0,     0,     0,  1144,  1144,     0,     0,  1144,     0,     0,
       0,  1806,     0,     0,  1144,  1144,     0,     0,     0,     0,
       0,  1816,  1008,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1815,
       0,  1144,     0,     0,     0,  1806,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1815,     0,  1817,     0,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1815,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2888,  1144,     0,  1815,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1144,  1140,  1817,  1140,     0,
       0,     0,     0,     0,  1815,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1144,  1817,     0,  1144,  1806,  1144,
       0,     0,     0,     0,     0,  2888,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1816,     0,     0,     0,  1144,     0,     0,
    1817,     0,     0,     0,  1817,  1817,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,     0,     0,     0,
     802,     0,     0,     0,     0,     0,     0,  1144,  1816,     0,
       0,     0,  1816,  1816,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1140,
    1140,     0,     0,  1817,     0,     0,     0,  1140,     0,     0,
    1140,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
    1806,  1140,  1140,  1144,     0,     0,     0,     0,     0,  1140,
       0,     0,  1140,  1140,  1140,  1140,     0,     0,     0,     0,
       0,  4152,  1140,  1140,     0,  1140,     0,  1140,     0,     0,
    1140,     0,     0,     0,     0,  1806,     0,     0,     0,     0,
       0,     0,     0,     0,  1815,  1140,     0,  1144,     0,  1140,
       0,     0,     0,  1140,  1144,     0,     0,  1140,     0,  1140,
    1140,  1140,  1140,  1140,  1140,  1140,  1140,  1140,     0,  1140,
    1144,  1144,     0,     0,     0,  1140,     0,     0,  1140,     0,
    1144,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1808,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1806,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1806,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,     0,
    1144,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1808,
    1806,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1806,  1140,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1815,     0,     0,     0,     0,  1815,  1815,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1815,     0,     0,
       0,     4,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     5,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     6,     7,     0,     0,     0,     0,     0,     0,     9,
      10,     0,     0,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,  1815,     0,     0,     0,     0,     0,     0,     0,
    1806,     0,     0,     0,     0,     0,     0,     0,     0,    46,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1806,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1815,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,    47,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1808,     0,     0,     0,     0,    48,     0,     0,     0,
       0,  1806,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,    49,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1808,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    50,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1808,     0,     0,     0,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1815,     0,     0,     0,
       0,    51,     0,     0,    52,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,  1140,     0,     0,     0,
    1806,     0,     0,     0,     0,    53,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1808,     0,  1140,  1140,     0,  1806,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1808,     0,  1140,  1140,  1140,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,  1140,  1808,  1140,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1140,
    1140,     0,  1140,  1806,     0,     0,    54,  1806,  1806,     0,
       0,     0,     0,  1808,     0,  1140,     0,  1140,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,    55,  1140,
    1140,  1140,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    56,     0,     0,     0,     0,     0,     0,  1808,     0,
       0,     0,     0,  1140,    57,     0,     0,     0,     0,     0,
       0,     0,  1140,   699,     0,     0,     0,     0,     0,     0,
       0,  1140,     0,   699,     0,     0,  1140,     0,     0,    58,
       0,     0,     0,  1140,     0,    59,     0,     0,     0,    60,
      61,    62,    63,    64,     0,     0,    65,    66,  1308,  2551,
       0,     0,     0,    71,     0,     0,     0,     0,     0,   699,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     891,     0,     0,   699,     0,     0,     0,     0,     0,     0,
     891,  1140,     0,     0,   699,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   699,     0,     0,     0,  1815,
    1815,     0,  1815,     0,     0,     0,     0,     0,     0,     0,
       0,   891,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1815,  1063,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1808,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1815,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1815,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1815,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1815,     0,     0,  1108,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1815,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,  1815,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1808,     0,     0,     0,  1140,
    1808,  1808,  1815,     0,     0,     0,     0,     0,  1140,     0,
       0,  1808,     0,     0,  1140,     0,  1140,     0,     0,     0,
       0,  1815,  1140,     0,     0,  1140,  1140,  1140,  1140,  1140,
    1140,  1140,  1140,  1140,  1140,     0,     0,     0,  1140,  1140,
       0,     0,     0,     0,     0,     0,  1815,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
    1140,     0,  1140,     0,     0,     0,     0,     0,     0,     0,
    1815,  1140,  1140,  1140,     0,     0,     0,  1140,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,  1140,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1808,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   891,   891,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,  1808,     0,     0,
    1108,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1815,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,     0,     0,     0,     0,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1808,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1175,  1140,  1177,     0,
    1179,     0,  1181,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,  1223,  1145,     0,     0,     0,     0,     0,     0,  1145,
       0,     0,     0,     0,     0,  1241,  1242,     0,     0,     0,
    1244,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1815,  1140,  1140,     0,     0,  1108,     0,   891,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1274,     0,  1140,     0,     0,     0,     0,
    1140,     0,     0,  1140,     0,  1293,     0,     0,  1295,     0,
    1297,     0,  1300,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   699,   891,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     699,     0,   699,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,   699,     0,     0,     0,     0,     0,     0,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   699,   699,     0,     0,     0,     0,     0,  1382,
       0,  1383,     0,  1140,     0,     0,     0,     0,     0,     0,
    1140,  1140,     0,  1815,     0,  1145,     0,     0,  1140,  1140,
       0,     0,     0,  1140,  1815,     0,     0,     0,     0,  1140,
    1140,  1108,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1063,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,  1808,  1808,     0,  1808,     0,     0,     0,
       0,     0,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1634,     0,  1636,  1808,     0,  1808,
    1638,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1818,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1752,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1764,  1140,  1808,     0,
    1145,     0,     0,     0,     0,  1770,     0,     0,     0,     0,
       0,  1772,     0,     0,     0,     0,     0,     0,     0,  1809,
       0,     0,  1820,     0,     0,  1808,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,  1857,     0,     0,     0,     0,  1140,     0,     0,  1808,
    1140,     0,     0,     0,     0,  1815,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1808,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
    1808,  1815,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1808,     0,     0,     0,     0,     0,     0,
       0,  1140,  1140,     0,     0,  1140,     0,     0,     0,     0,
       0,     0,  1140,  1140,     0,     0,  1818,     0,     0,     0,
       0,   699,     0,   699,     0,     0,   699,     0,   699,     0,
    1808,   699,   699,   699,     0,     0,     0,     0,     0,  1140,
       0,     0,  1145,     0,   699,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1815,     0,   699,  1140,
     699,     0,     0,     0,  1809,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,  1808,  1145,  1145,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1808,     0,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1808,     0,     0,  1140,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,  1140,  1815,  1808,  1140,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,  1145,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,     0,     0,  1815,     0,
       0,     0,  1815,  1815,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1063,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1818,     0,
       0,  1815,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2234,     0,     0,  2234,     0,     0,     0,
       0,  1140,     0,     0,  2241,     0,     0,  1808,     0,     0,
       0,     0,     0,     0,     0,  1818,     0,     0,     0,     0,
       0,     0,  2250,     0,     0,     0,  1809,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1818,     0,
       0,     0,     0,     0,     0,  1140,     0,     0,  2288,     0,
       0,     0,  1140,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1809,     0,     0,     0,     0,  1140,  1140,
       0,     0,     0,     0,     0,     0,     0,     0,  1140,     0,
       0,     0,     0,     0,     0,     0,  1809,  1476,  1811,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1818,     0,     0,     0,     0,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,     0,  1818,     0,     0,
       0,     0,     0,  1549,     0,     0,     0,     0,     0,  1808,
       0,     0,     0,     0,     0,  1818,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1809,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1818,     0,     0,     0,  1808,  1809,     0,     0,     0,  1140,
       0,     0,     0,     0,     0,     0,     0,     0,  1140,     0,
       0,     0,     0,  1809,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1145,  1809,  1145,
       0,  2449,     0,     0,     0,  1818,     0,     0,  1145,     0,
       0,     0,     0,  2471,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1811,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1809,     0,     0,     0,  2525,     0,     0,
       0,  2529,     0,     0,     0,     0,     0,     0,     0,     0,
    2538,     0,  2540,     0,  2541,     0,     0,  1808,     0,  2542,
       0,     0,     0,     0,     0,     0,     0,     0,  1808,     0,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   699,     0,   699,     0,     0,     0,   699,     0,
     699,     0,     0,   699,     0,     0,     0,   699,  2570,     0,
    1145,  1145,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,  1145,     0,     0,  1145,     0,     0,     0,     0,     0,
       0,     0,  1145,  1145,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,  1145,  1145,  1145,  1145,     0,     0,  1808,
       0,     0,     0,  1145,  1145,     0,  1145,     0,  1145,  1808,
       0,  1145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1818,  1145,     0,     0,     0,
    1145,     0,     0,     0,  1145,     0,     0,     0,  1145,     0,
    1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,     0,
    1145,     0,     0,     0,     0,     0,  1145,     0,     0,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1809,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2009,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2763,     0,     0,     0,     0,     0,  2032,     0,
       0,     0,     0,     0,     0,  1811,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2056,  2057,     0,  2059,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1811,     0,     0,  2097,     0,     0,     0,  1808,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1811,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1808,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2150,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1145,     0,     0,     0,     0,  1811,  2180,  1108,
       0,     0,  2190,  2193,     0,     0,     0,     0,     0,     0,
       0,     0,  1818,     0,  1811,     0,  2842,  1818,  1818,     0,
    1808,  2846,     0,     0,     0,     0,     0,     0,  1818,     0,
       0,  2856,  1811,     0,     0,     0,     0,     0,  2862,     0,
       0,     0,     0,     0,  2867,     0,     0,     0,     0,     0,
    2877,     0,     0,     0,     0,  2879,     0,  1811,     0,     0,
    1809,     0,     0,     0,     0,  1809,  1809,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1809,     0,     0,     0,
       0,  2895,  2896,  2899,  2901,     0,     0,     0,  2908,  2911,
       0,     0,     0,  2914,     0,     0,  2918,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1808,
       0,     0,  1811,  2953,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2956,     0,  2958,     0,     0,     0,     0,
       0,     0,     0,     0,  2969,  2970,  2971,  1808,  2973,     0,
       0,  1145,     0,  1818,     0,     0,     0,  2986,  2987,     0,
       0,     0,     0,     0,     0,  2990,  2991,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1812,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1808,     0,     0,     0,  1808,  1808,     0,     0,
       0,  1809,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1818,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1809,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1813,     0,
       0,     0,  1811,     0,     0,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1818,     0,     0,
       0,     0,     0,     0,  1812,     0,     0,     0,  1108,     0,
       0,     0,     0,     0,     0,     0,  1145,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1809,  1145,  1145,     0,     0,
       0,  1145,     0,  3191,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,  1145,  1145,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,  1145,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,  1145,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,  1145,     0,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2633,     0,  1145,     0,
       0,     0,     0,  1813,     0,     0,     0,     0,  1145,     0,
    1145,  1145,  1145,     0,     0,     0,     0,     0,  2655,     0,
       0,  2657,     0,     0,  2668,     0,     0,     0,     0,     0,
       0,  2675,  2680,     0,  1145,     0,  2685,     0,     0,  2690,
       0,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,  1145,     0,  2699,     0,     0,  1145,  2705,     0,
       0,     0,  2717,     0,  1145,     0,  2724,     0,  2726,  2727,
    2728,  2729,  2730,  2731,  2732,  2733,  2734,     0,  2735,     0,
       0,     0,     0,     0,  1476,     0,     0,  2759,     0,  1811,
       0,     0,     0,     0,  1811,  1811,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1811,     0,     0,     0,     0,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1812,     0,     0,     0,
    1818,  1818,     0,  1818,     0,     0,  3372,  3373,     0,     0,
       0,     0,     0,     0,     0,     0,  1549,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1812,     0,     0,     0,  3392,     0,     0,
       0,     0,     0,     0,  1818,     0,  1818,     0,  1809,  1809,
       0,  1809,     0,     0,     0,     0,  1812,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3411,  3412,  3413,  3414,     0,     0,     0,     0,     0,
    1811,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1809,     0,  1809,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1818,     0,     0,  1812,     0,
       0,     0,     0,     0,     0,  1813,     0,     0,     0,     0,
    2865,     0,     0,     0,     0,  1812,     0,     0,     0,     0,
       0,  1811,  1818,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1812,     0,  3455,     0,     0,     0,     0,
    3457,     0,  1813,  1809,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1818,     0,  1812,     0,
       0,     0,     0,     0,     0,  1813,     0,     0,     0,     0,
    1809,     0,     0,  1818,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1818,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1818,     0,     0,     0,  1809,     0,     0,     0,     0,     0,
       0,     0,     0,  1812,     0,     0,     0,     0,  1145,     0,
       0,  1809,  1145,     0,  3555,   891,     0,  1813,     0,     0,
       0,  1145,     0,     0,  1811,  1809,     0,  1818,     0,     0,
       0,     0,     0,     0,  1813,     0,     0,     0,  1809,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3026,
       0,   891,  1813,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1809,     0,  1813,  3615,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,  3624,     0,  1818,     0,     0,     0,     0,     0,  1145,
       0,     0,     0,     0,     0,  1145,     0,  1145,     0,     0,
       0,     0,  1818,  1145,     0,     0,  1145,  1145,  1145,  1145,
    1145,  1145,  1145,  1145,  1145,  1145,     0,     0,     0,  1145,
    1145,     0,  1813,  3137,     0,     0,     0,  1818,     0,     0,
       0,  1809,  1145,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
    1809,  1145,     0,  1145,     0,     0,     0,     0,     0,     0,
    3158,  1818,  1145,  1145,  1145,     0,     0,     0,  1145,     0,
       0,  1145,     0,     0,     0,  1809,     0,     0,     0,     0,
       0,  1145,     0,  1812,     0,     0,     0,     0,     0,  1145,
       0,  1145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1476,     0,     0,     0,     0,  1809,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3202,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1145,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2680,     0,  2680,  2680,     0,     0,  1811,  1811,     0,
    1811,     0,     0,  3262,  1818,     0,  3265,     0,  3267,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1813,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  3288,     0,  3290,     0,     0,     0,
    3293,  1811,     0,  1811,  3790,     0,     0,     0,     0,     0,
       0,     0,  1809,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2759,  2759,
    2759,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3816,     0,     0,     0,     0,  3823,     0,  3825,  3826,
    3827,  3828,  3340,     0,     0,     0,     0,     0,     0,     0,
       0,  1549,     0,     0,     0,     0,     0,     0,  1145,     0,
    2180,     0,  1811,     0,     0,  3355,     0,     0,     0,     0,
       0,     0,  2193,     0,     0,     0,  1818,     0,     0,     0,
    1812,     0,     0,     0,     0,  1812,  1812,     0,     0,  1811,
       0,     0,     0,     0,     0,     0,  1812,     0,     0,     0,
       0,     0,     0,  3886,  3888,  3890,     0,  3892,     0,     0,
       0,  1818,  1145,  1145,     0,     0,     0,     0,     0,     0,
    3381,     0,     0,  1811,  1809,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,     0,
    1811,  1145,     0,     0,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1811,     0,     0,     0,     0,  1809,
       0,     0,     0,     0,     0,     0,     0,  1811,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3392,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3961,
       0,     0,     0,     0,  1811,     0,     0,     0,     0,  1813,
       0,  1812,     0,     0,  1813,  1813,     0,     0,     0,     0,
       0,     0,     0,     0,  1145,  1813,     0,     0,     0,     0,
       0,  1145,  1145,     0,  1818,     0,     0,     0,     0,  1145,
    1145,     0,     0,     0,  1145,  1818,     0,     0,     0,     0,
    1145,  1145,     0,     0,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,     0,     0,
    1811,     0,  1812,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,  1809,     0,     0,     0,     0,     0,     0,  1811,
       0,     0,     0,  1809,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,  1811,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1818,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1818,     0,     0,     0,
    1813,     0,     0,     0,     0,     0,     0,     0,  1811,     0,
       0,     0,  2093,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1809,     0,     0,     0,     0,     0,
       0,     0,     0,  4062,  1809,  1812,     0,     0,     0,     0,
       0,     0,     0,     0,  4071,     0,     0,     0,     0,  2759,
       0,  1813,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2093,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3652,     0,
       0,     0,     0,     0,     0,     0,  1818,  3655,     0,     0,
       0,  1811,     0,  3656,     0,  3657,     0,  1145,     0,     0,
       0,  1145,     0,     0,  4123,     0,  1818,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3675,  3676,     0,
       0,     0,     0,     0,  1813,     0,  4142,     0,  1145,     0,
       0,     0,  1818,     0,     0,     0,  2685,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  3701,     0,     0,  3704,
       0,  3706,  1145,  1145,  1809,     0,  1145,     0,     0,     0,
    3710,     0,     0,  1145,  1145,  4171,  3715,     0,     0,  3718,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3725,
    1809,     0,     0,     0,     0,     0,     0,  3737,     0,  2759,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1818,     0,     0,
    1145,     0,     0,  1811,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,  1811,     0,
       0,     0,     0,     0,     0,  1809,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1812,  1812,
       0,  1812,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1145,     0,  1818,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1812,     0,  1812,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,  1818,     0,  1145,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1809,     0,     0,     0,     0,     0,
       0,     0,  3392,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,  1818,
       0,  1811,  1809,  1818,  1818,     0,     0,     0,     0,     0,
       0,     0,  1811,  1812,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1813,  1813,     0,
    1813,     0,     0,     0,  2093,     0,  1145,     0,     0,     0,
    1812,     0,     0,     0,     0,     0,     0,  1809,     0,     0,
       0,  1809,  1809,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1818,     0,     0,     0,     0,     0,     0,     0,
       0,  1813,     0,  1813,  1812,     0,     0,     0,     0,     0,
    3936,  3937,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,  1812,     0,  1811,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1811,     0,  1812,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1812,     0,
       0,     0,     0,     0,     0,  2093,  1145,     0,     0,     0,
       0,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,  1813,     0,     0,     0,     0,     0,  2093,  1145,
    1145,     0,     0,  2664,     0,  1812,  3977,     0,     0,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1813,
       0,  4394,  2093,  2093,     0,  2093,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,  3993,
    3995,     0,     0,  1813,     0,     0,     0,     0,     0,     0,
       0,     0,  4002,  2093,     0,     0,     0,     0,  4007,  4008,
    1813,  1812,  4010,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2759,  1813,     0,     0,     0,     0,     0,
    1812,     0,     0,     0,     0,  2759,     0,  1813,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,  1145,
       0,     0,     0,  1811,     0,  1812,  2093,     0,     0,     0,
       0,     0,     0,  4041,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1813,     0,     0,     0,     0,  1811,
       0,     0,     0,     0,     0,     0,  2093,     0,     0,  1812,
       0,     0,     0,     0,     0,     0,  2093,     0,     0,  2093,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1813,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1811,     0,     0,     0,     0,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1813,     0,  4111,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1813,     0,
       0,     0,  1812,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1811,     0,  4161,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1811,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4191,     0,     0,     0,     0,     0,
       0,     0,  4193,     0,     0,     0,  1811,     0,     0,     0,
    1811,  1811,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1812,     0,     0,     0,     0,     0,
       0,  1813,     0,     0,     0,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     5,     0,  1812,
       0,     0,     0,     0,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     0,     0,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1813,  2685,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1812,     0,     0,     0,     0,     0,  1813,     0,
       0,     0,     0,  1812,  4319,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2093,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4348,     0,     0,    47,     0,     0,
       0,  2093,     0,  2093,     0,  2664,  2664,  3238,     0,     0,
    2664,     0,    48,     0,  2093,     0,     0,     0,     0,     0,
       0,  2093,     0,     0,     0,     0,  2093,     0,     0,     0,
       0,  2093,    49,     0,  1812,     0,  2093,     0,     0,     0,
       0,     0,     0,     0,  1812,  2093,     0,     0,     0,  2664,
    2664,  2093,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,  2093,     0,     0,     0,     0,     0,     0,
    2093,  1813,  2093,  2093,  2093,  2093,  2093,  2093,  2093,  2093,
    2093,  2093,  1813,     0,     0,     0,     0,    51,     0,     0,
      52,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2093,     0,  4412,  4412,     0,
       0,    53,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4412,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4452,     0,     0,     0,     0,     0,
       0,     0,     0,  1813,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1813,     0,     0,     0,     0,     0,     0,
       0,     0,    54,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1812,     0,     0,     0,  4412,     0,
       0,  2093,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    55,     0,     0,     0,     0,     0,
    1812,     0,     0,     0,     0,     0,     0,    56,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    58,     0,     0,     0,     0,
       0,    59,     0,     0,     0,    60,    61,    62,    63,    64,
       0,     0,    65,    66,  1308,     0,     0,     0,     0,    71,
       0,     0,     0,     0,     0,  1812,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1813,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2093,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1812,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1812,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1813,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    85,     0,     0,     0,     0,     0,
      89,     0,     0,     0,    93,     0,    94,  1812,    96,    97,
       0,  1812,  1812,     0,     0,     0,     0,     0,     0,   106,
       0,     0,     0,  2093,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   119,   120,     0,     0,
       0,     0,     0,     0,  2093,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1813,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   128,     0,     0,     0,     0,     0,  2093,     0,
       0,  1813,   129,     0,   130,   131,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1078,  3238,
    3238,     0,  2664,     0,     0,  2664,  2664,  2664,  2664,  2664,
    2664,  2664,  2664,  2664,  2664,  3238,     0,     0,   141,     0,
     142,   143,     0,     0,     0,   145,  1813,   146,     0,     0,
    1813,  1813,     0,     0,     0,     0,     0,   148,  2093,   149,
       0,  2093,     0,  2093,     0,     0,     0,     0,  3238,  3238,
       0,     0,     0,     0,     0,     0,   152,     0,   153,     0,
       0,   156,  2664,  2664,  2093,     0,  2093,   157,     0,  2093,
       0,     0,     0,   158,     0,   159,     0,     0,     0,   160,
       0,     0,     0,     0,     0,   161,     0,     0,     0,     0,
       0,     0,   163,     0,   165,     0,     0,     0,     0,   167,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   171,     0,     0,  2093,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2093,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   176,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2093,     0,     0,
       0,     0,     0,     0,     0,   185,   186,     0,     0,     0,
       0,   187,     0,     0,     0,     0,     0,     0,     0,     0,
     188,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   193,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   204,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   206,     0,     0,     0,   207,     0,
     208,     0,     0,     0,     0,   209,     0,     0,     0,     0,
     210,     0,     0,   212,     0,     0,     0,   214,     0,     0,
       0,     0,     0,   215,     0,     0,     0,     0,     0,     0,
     216,     0,     0,   218,     0,     0,     0,     0,     0,     0,
     221,     0,     0,     0,     0,     0,     0,  2664,     0,     0,
       0,     0,     0,   223,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     228,     0,   229,     0,     0,     0,     0,     0,     0,   231,
       0,   232,     0,     0,   233,     0,     0,     0,   234,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     237,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   246,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2093,     0,
       0,  2093,  2093,  2093,     0,     0,  3238,     0,     0,     0,
       0,  3238,  3238,  3238,  3238,  3238,  3238,  3238,  3238,  3238,
    3238,  2093,  2093,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2093,  2664,  2664,
    2093,     0,  2093,     0,     0,     0,  2093,  3238,  3238,     0,
       0,  2093,     0,     0,  2093,     0,     0,     0,     0,     0,
       0,  2093,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2093,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,  3238,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2093,  2093,   140,     0,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,     0,     0,   147,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,  2093,     0,     0,     0,  2664,   154,   155,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2093,
       0,  2093,     0,     0,     0,     0,  3238,  3238,  2093,     0,
       0,  2664,  2664,  2093,  2093,   162,  2093,     0,     0,     0,
       0,     0,   164,     0,     0,   166,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   172,     0,     0,  2093,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   177,     0,   178,     0,     0,   179,   180,
       0,   181,     0,     0,     0,     0,     0,     0,     0,   182,
     183,     0,   184,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   189,   190,   191,     0,     0,  2093,     0,     0,
       0,     0,   192,     0,     0,     0,     0,   194,     0,     0,
     195,     0,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   197,   198,   199,   200,   201,
       0,     0,     0,     0,     0,     0,     0,     0,   202,     0,
     203,     0,     0,     0,     0,     0,     0,  2093,     0,     0,
       0,     0,   205,     0,     0,     0,     0,     0,     0,     0,
       0,  3238,  2664,     0,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   213,     0,  3238,  3238,  2093,     0,  2093,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,   225,     0,     0,     0,   226,     0,   227,     0,     0,
       0,     0,     0,     0,     0,   230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   235,     0,
       0,   236,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   238,   239,   240,   241,   242,
     243,   244,   245,     0,     0,     0,     0,     0,     0,     0,
       0,  3238,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2816,
       0,     0,     0,     0,     0,  2093,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2093,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   705,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   706,   104,   105,   406,   707,     0,
     107,   108,   109,   110,   708,   709,   112,   113,   114,   115,
       0,   116,   710,   711,   407,   408,     0,     0,  2093,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,  2093,     0,
     417,   418,   419,   420,   421,   422,   423,   424,   712,   425,
     426,   427,   713,   714,   715,   716,   717,   718,   719,   428,
     429,   720,   430,   133,   431,   432,   433,   135,   136,   137,
     138,   139,   721,   434,   435,   436,   437,   438,   722,   723,
     439,   440,   724,   140,   442,   725,   443,   444,   445,   446,
     144,   726,   727,   447,   448,   449,   450,   147,   451,   728,
     729,   453,   454,   455,   456,   457,   458,   730,   459,   460,
     461,   150,   462,   731,   732,   733,   734,   151,   735,   736,
     737,   463,   464,   465,   466,   467,   468,   154,   155,   469,
     738,   470,   739,   471,   472,   473,   474,   475,   740,   476,
     477,   478,   741,   742,   479,   480,   481,   482,   483,   743,
     484,   485,   486,   744,   487,   488,   745,   489,   490,   491,
     492,   164,   493,   494,   166,   746,   495,   747,   496,   168,
     497,   748,   498,   749,   499,   169,   750,   170,   500,   501,
     502,   751,   503,   172,   752,   504,   753,   505,   506,   507,
     508,   509,   173,   510,   511,   512,   754,   513,   514,   515,
     516,   517,   518,   755,   519,   174,   175,   756,   520,   521,
     522,   757,   177,   758,   178,   759,   523,   179,   180,   524,
     181,   525,   526,   527,   528,   529,   530,   760,   182,   183,
     531,   184,   761,   532,   533,   534,   762,   763,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,   190,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,   764,   556,   557,   194,   558,   765,   195,
     559,   196,   560,   561,   562,   766,   563,   767,   768,   564,
     565,   566,   769,   770,   197,   198,   199,   200,   201,   567,
     568,   569,   570,   571,   572,   771,   573,   202,   574,   203,
     575,   576,   577,   772,   578,   579,   580,   581,   582,   583,
     584,   205,   585,   586,   587,   773,   588,   589,   590,   591,
     592,   593,   594,   595,   596,   597,   774,   598,   599,   211,
     600,   601,   213,   602,   603,   604,   605,   606,   607,   608,
     609,   775,   610,   611,   612,   613,   614,   776,   615,   217,
     616,   617,   219,   618,   220,   777,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   628,   222,   629,   778,   630,
     631,   779,   632,   633,   634,   635,   636,   637,   780,   224,
     225,   781,   782,   639,   226,   640,   227,   783,   641,   642,
     643,   644,   645,   646,   784,   785,   647,   648,   649,   650,
     786,   787,   651,   652,   653,   654,   788,   235,   789,   656,
     236,   657,   658,   659,   790,   791,   660,   792,   793,   661,
     662,   663,   664,   665,   238,   239,   240,   241,   242,   243,
     244,   245,   666,   667,   668,    85,     0,     0,    86,    87,
      88,    89,    90,    91,    92,    93,     0,    94,    95,    96,
      97,    98,    99,   100,   101,   102,   103,   932,   104,   105,
     106,     0,     0,   107,   108,   109,   110,     0,   111,   112,
     113,   114,   115,     0,   116,   117,   118,   119,   120,     0,
       0,     0,   121,   122,     0,     0,     0,     0,   123,     0,
       0,     0,     0,     0,     0,     0,     0,   124,     0,   125,
       0,   126,   127,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   128,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   129,     0,   130,   131,     0,     0,     0,
       0,     0,     0,     0,     0,   132,   133,     0,     0,   134,
     135,   136,   137,   138,   139,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   140,     0,     0,   141,
       0,   142,   143,   144,     0,     0,   145,     0,   146,     0,
     147,     0,     0,     0,     0,     0,     0,     0,   148,     0,
     149,     0,     0,     0,   150,     0,     0,     0,     0,     0,
     151,     0,     0,     0,     0,     0,     0,   152,     0,   153,
     154,   155,   156,     0,     0,     0,     0,     0,   157,     0,
       0,     0,     0,     0,   158,     0,   159,     0,     0,     0,
     160,     0,     0,     0,     0,     0,   161,   162,     0,     0,
       0,     0,     0,   163,   164,   165,     0,   166,     0,     0,
     167,     0,   168,     0,     0,     0,     0,     0,   169,     0,
     170,     0,     0,     0,   171,     0,   172,     0,     0,     0,
       0,     0,     0,     0,     0,   173,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   174,   175,
       0,     0,   176,     0,     0,   177,     0,   178,     0,     0,
     179,   180,     0,   181,     0,     0,     0,     0,     0,     0,
       0,   182,   183,     0,   184,     0,   185,   186,     0,     0,
       0,     0,   187,     0,     0,     0,     0,     0,     0,     0,
       0,   188,     0,     0,   189,   190,   191,     0,     0,     0,
       0,     0,     0,     0,   192,     0,     0,     0,   193,   194,
       0,     0,   195,     0,   196,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   197,   198,   199,
     200,   201,     0,     0,     0,     0,     0,     0,     0,     0,
     202,     0,   203,     0,   204,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   205,   206,     0,     0,     0,   207,
       0,   208,     0,     0,     0,     0,   209,     0,     0,     0,
       0,   210,   211,     0,   212,   213,     0,     0,   214,     0,
       0,     0,     0,     0,   215,     0,     0,     0,     0,     0,
       0,   216,   217,     0,   218,   219,     0,   220,     0,     0,
       0,   221,     0,     0,     0,     0,     0,     0,     0,   222,
       0,     0,     0,     0,   223,     0,     0,     0,     0,     0,
       0,     0,   224,   225,     0,     0,     0,   226,     0,   227,
       0,   228,     0,   229,     0,     0,     0,   230,     0,     0,
     231,     0,   232,     0,     0,   233,     0,     0,     0,   234,
     235,     0,     0,   236,     0,     0,     0,     0,     0,     0,
       0,   237,     0,     0,     0,     0,     0,   238,   239,   240,
     241,   242,   243,   244,   245,    86,    87,    88,     0,    90,
      91,    92,     0,     0,     0,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   246,   104,   105,     0,  -124,     0,
     107,   108,   109,   110,     0,   111,   112,   113,   114,   115,
       0,   116,   117,   118,     0,     0,     0,     0,     0,   121,
     122,     0,     0,     0,     0,   123,     0,     0,     0,     0,
       0,     0,     0,     0,   124,     0,   125,     0,   126,     0,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   133,     0,     0,     0,   135,   136,   137,
     138,   139,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   140,     0,     0,     0,     0,     0,     0,
     144,     0,     0,     0,     0,     0,     0,   147,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   150,     0,     0,     0,     0,     0,   151,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   154,   155,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   162,     0,     0,     0,     0,     0,
       0,   164,     0,     0,   166,     0,     0,     0,     0,   168,
       0,     0,     0,     0,     0,   169,     0,   170,     0,     0,
       0,     0,     0,   172,     0,     0,     0,     0,     0,     0,
       0,     0,   173,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   174,   175,     0,     0,     0,
       0,     0,   177,     0,   178,     0,     0,   179,   180,     0,
     181,     0,     0,     0,     0,     0,     0,     0,   182,   183,
       0,   184,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   189,   190,   191,     0,     0,     0,     0,     0,     0,
       0,   192,     0,     0,     0,     0,   194,     0,     0,   195,
       0,   196,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   197,   198,   199,   200,   201,     0,
       0,     0,     0,     0,     0,     0,     0,   202,     0,   203,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   205,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   211,
       0,     0,   213,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   217,
       0,     0,   219,     0,   220,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   222,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   224,
     225,     0,     0,     0,   226,     0,   227,     0,     0,     0,
       0,     0,     0,     0,   230,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   235,     0,     0,
     236,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   238,   239,   240,   241,   242,   243,
     244,   245,     0,   705,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   706,   104,   105,   406,   707,  2818,   107,
     108,   109,   110,   708,   709,   112,   113,   114,   115,     0,
     116,   710,   711,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,  2753,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,  2754,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,  1433,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,   562,     0,   563,     0,     0,  1437,   565,
     566,     0,     0,   197,   198,   199,   200,  1438,   567,   568,
     569,   570,   571,   572,     0,   573,  1439,   574,   203,   575,
     576,   577,     0,   578,   579,   580,   581,   582,   583,   584,
    1440,   585,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   597,     0,   598,   599,   211,   600,
     601,  1441,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,  1442,   615,   217,   616,
     617,   219,   618,  1443,     0,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,  1444,   629,     0,   630,   631,
       0,   632,   633,   634,   635,   636,   637,     0,  1445,  1446,
       0,     0,   639,  1447,   640,  1448,  1449,   641,   642,   643,
     644,   645,   646,     0,  1450,   647,   648,   649,   650,  1451,
       0,   651,   652,   653,   654,   655,  1452,  2755,   656,   236,
     657,   658,   659,     0,     0,   660,     0,     0,   661,   662,
     663,   664,   665,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   666,   667,   668,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,  2756,     0,     0,     0,     0,     0,     0,
    1463,  2757,   705,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   706,   104,   105,   406,   707,     0,   107,   108,
     109,   110,   708,   709,   112,   113,   114,   115,     0,   116,
     710,   711,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,   416,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
    1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,  1401,     0,     0,   428,   429,     0,
     430,   133,   431,   432,   433,   135,  1402,   137,  1403,  1404,
       0,   434,   435,   436,   437,   438,  1405,  1406,   439,   440,
    1407,  1408,   442,     0,   443,   444,   445,   446,  1409,     0,
       0,   447,   448,   449,   450,   147,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,   150,
     462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,
     464,   465,   466,   467,   468,  1417,  1418,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,  1419,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,  1420,
     493,   494,  1421,  1422,   495,     0,   496,  1423,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,  1424,     0,   504,     0,   505,   506,   507,   508,   509,
     173,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,   174,   175,     0,   520,   521,   522,  1425,
    1426,     0,  1427,     0,   523,   179,   180,   524,   181,   525,
     526,   527,   528,   529,   530,     0,  1428,   183,   531,   184,
       0,   532,   533,   534,  1429,  1430,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,  1431,
     190,  1432,   548,   549,   550,   551,   552,   553,   554,   192,
     555,  1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,
     560,   561,   562,     0,   563,     0,     0,  1437,   565,   566,
       0,     0,   197,   198,   199,   200,  1438,   567,   568,   569,
     570,   571,   572,     0,   573,  1439,   574,   203,   575,   576,
     577,     0,   578,   579,   580,   581,   582,   583,   584,  1440,
     585,   586,   587,     0,   588,   589,   590,   591,   592,   593,
     594,   595,   596,   597,     0,   598,   599,   211,   600,   601,
    1441,   602,   603,   604,   605,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,  1442,   615,   217,   616,   617,
     219,   618,  1443,     0,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,  1444,   629,     0,   630,   631,     0,
     632,   633,   634,   635,   636,   637,     0,  1445,  1446,     0,
       0,   639,  1447,   640,  1448,  1449,   641,   642,   643,   644,
     645,   646,     0,  1450,   647,   648,   649,   650,  1451,     0,
     651,   652,   653,   654,   655,  1452,     0,   656,   236,   657,
     658,   659,     0,     0,   660,     0,     0,   661,   662,   663,
     664,   665,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,
     666,   667,   668,     0,     0,     0,     0,     0,     0,     0,
    1460,  1461,     0,     0,     0,     0,     0,     0,     0,  1463,
    2666,   705,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   706,   104,   105,   406,   707,     0,   107,   108,   109,
     110,   708,   709,   112,   113,   114,   115,     0,   116,   710,
     711,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,     0,  1784,   137,  1785,  1786,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,  1787,
    1788,   442,     0,   443,   444,   445,   446,     0,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,     0,     0,     0,   151,     0,     0,     0,   463,   464,
     465,   466,   467,   468,  1789,  1790,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,     0,   493,
     494,     0,     0,   495,     0,   496,  1791,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,  2302,   513,   514,   515,   516,   517,   518,
       0,   519,   174,  2303,     0,   520,   521,   522,  1425,  1792,
       0,  1793,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,     0,   183,   531,   184,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1794,   190,
    1795,   548,   549,   550,   551,   552,   553,   554,     0,   555,
       0,   556,   557,   194,   558,     0,     0,   559,  1796,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,  2304,   198,   199,   200,     0,   567,   568,   569,   570,
     571,   572,     0,   573,     0,   574,     0,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,  1797,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,   211,   600,   601,     0,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,  2305,   616,   617,   219,
     618,  1799,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,     0,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,  1800,  1801,     0,     0,
     639,     0,   640,     0,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,     0,  1802,  2306,   656,   236,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,     0,     0,     0,     0,     0,     0,     0,     0,   666,
     667,   668,     0,     0,     0,     0,   705,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,  2307,
      98,    99,   100,   101,   102,   103,   706,   104,   105,   406,
     707,     0,   107,   108,   109,   110,   708,   709,   112,   113,
     114,   115,     0,   116,   710,   711,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,     0,     0,
       0,   428,   429,     0,   430,   133,   431,   432,   433,     0,
    1784,   137,  1785,  1786,     0,   434,   435,   436,   437,   438,
       0,     0,   439,   440,  1787,  1788,   442,     0,   443,   444,
     445,   446,     0,     0,     0,   447,   448,   449,   450,   147,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,   150,   462,     0,     0,     0,     0,   151,
       0,     0,     0,   463,   464,   465,   466,   467,   468,  1789,
    1790,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,  1419,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,     0,   493,   494,     0,     0,   495,     0,
     496,  1791,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,     0,     0,   504,     0,   505,
     506,   507,   508,   509,   173,   510,   511,   512,  2302,   513,
     514,   515,   516,   517,   518,     0,   519,   174,  2303,     0,
     520,   521,   522,  1425,  1792,     0,  1793,     0,   523,   179,
     180,   524,   181,   525,   526,   527,   528,   529,   530,     0,
       0,   183,   531,   184,     0,   532,   533,   534,     0,     0,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,  1794,   190,  1795,   548,   549,   550,   551,
     552,   553,   554,     0,   555,     0,   556,   557,   194,   558,
       0,     0,   559,  1796,   560,   561,   562,     0,   563,     0,
       0,   564,   565,   566,     0,     0,  2304,   198,   199,   200,
       0,   567,   568,   569,   570,   571,   572,     0,   573,     0,
     574,     0,   575,   576,   577,     0,   578,   579,   580,   581,
     582,   583,   584,  1797,   585,   586,   587,     0,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   597,     0,   598,
     599,   211,   600,   601,     0,   602,   603,   604,   605,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,     0,
     615,  2305,   616,   617,   219,   618,  1799,     0,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   628,     0,   629,
       0,   630,   631,     0,   632,   633,   634,   635,   636,   637,
       0,  1800,  1801,     0,     0,   639,     0,   640,     0,     0,
     641,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,     0,  1802,
    2306,   656,   236,   657,   658,   659,     0,     0,   660,     0,
       0,   661,   662,   663,   664,   665,     0,     0,     0,     0,
       0,     0,     0,     0,   666,   667,   668,     0,     0,     0,
       0,     0,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,  3097,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,  4045,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,     0,     0,     0,     0,     0,   705,    86,    87,
      88,   403,    90,    91,    92,   404,  1531,   405,    95,     0,
    1532,    98,    99,   100,   101,   102,   103,   706,   104,   105,
     406,   707,     0,   107,   108,   109,   110,   708,   709,   112,
     113,   114,   115,     0,   116,   710,   711,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,  2676,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,  2677,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
    2678,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,   562,     0,   563,
       0,     0,  1437,   565,   566,     0,     0,   197,   198,   199,
     200,  1438,   567,   568,   569,   570,   571,   572,     0,   573,
    1439,   574,   203,   575,   576,   577,     0,   578,   579,   580,
     581,   582,   583,   584,  1440,   585,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   597,     0,
     598,   599,   211,   600,   601,  1441,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
    1442,   615,   217,   616,   617,   219,   618,  1443,     0,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   628,  1444,
     629,     0,   630,   631,     0,   632,   633,   634,   635,   636,
     637,     0,  1445,  1446,     0,  2679,   639,  1447,   640,  1448,
    1449,   641,   642,   643,   644,   645,   646,     0,  1450,   647,
     648,   649,   650,  1451,     0,   651,   652,   653,   654,   655,
    1452,     0,   656,   236,   657,   658,   659,     0,     0,   660,
       0,     0,   661,   662,   663,   664,   665,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   666,   667,   668,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,     0,     0,  1463,   705,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   706,   104,   105,   406,   707,
       0,   107,   108,   109,   110,   708,   709,   112,   113,   114,
     115,     0,   116,   710,   711,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,   549,   550,   551,   552,
     553,   554,   192,   555,  1433,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,   562,     0,   563,     0,     0,
    1437,   565,   566,     0,     0,   197,   198,   199,   200,  1438,
     567,   568,   569,   570,   571,   572,     0,   573,  1439,   574,
     203,   575,   576,   577,     0,   578,   579,   580,   581,   582,
     583,   584,  1440,   585,   586,   587,     0,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   597,     0,   598,   599,
     211,   600,   601,  1441,   602,   603,   604,   605,   606,   607,
     608,   609,   215,   610,   611,   612,   613,   614,  1442,   615,
     217,   616,   617,   219,   618,  1443,     0,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   628,  1444,   629,     0,
     630,   631,   223,   632,   633,   634,   635,   636,   637,     0,
    1445,  1446,     0,     0,   639,  1447,   640,  1448,  1449,   641,
     642,   643,   644,   645,   646,     0,  1450,   647,   648,   649,
     650,  1451,     0,   651,   652,   653,   654,  1324,  1452,     0,
     656,   236,   657,   658,   659,     0,     0,   660,     0,   237,
     661,   662,   663,   664,   665,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   666,   667,   668,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,     0,     0,     0,     0,     0,
       0,     0,  1463,   705,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   706,   104,   105,   406,   707,     0,   107,
     108,   109,   110,   708,   709,   112,   113,   114,   115,     0,
     116,   710,   711,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,  1433,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,   562,     0,   563,     0,     0,  1437,   565,
     566,     0,     0,   197,   198,   199,   200,  1438,   567,   568,
     569,   570,   571,   572,     0,   573,  1439,   574,   203,   575,
     576,   577,     0,   578,   579,   580,   581,   582,   583,   584,
    1440,   585,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   597,     0,   598,   599,   211,   600,
     601,  1441,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,  1442,   615,   217,   616,
     617,   219,   618,  1443,     0,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,  1444,   629,     0,   630,   631,
       0,   632,   633,   634,   635,   636,   637,     0,  1445,  1446,
       0,     0,   639,  1447,   640,  1448,  1449,   641,   642,   643,
     644,   645,   646,     0,  1450,   647,   648,   649,   650,  1451,
       0,   651,   652,   653,   654,   655,  1452,     0,   656,   236,
     657,   658,   659,     0,     0,   660,     0,     0,   661,   662,
     663,   664,   665,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   666,   667,   668,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,     0,     0,     0,     0,     0,  2004,  2625,
    1463,   705,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   706,   104,   105,   406,   707,     0,   107,   108,   109,
     110,   708,   709,   112,   113,   114,   115,     0,   116,   710,
     711,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,   562,     0,   563,     0,     0,  1437,   565,   566,     0,
       0,   197,   198,   199,   200,  1438,   567,   568,   569,   570,
     571,   572,     0,   573,  1439,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,  1440,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,   211,   600,   601,  1441,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,  1442,   615,   217,   616,   617,   219,
     618,  1443,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,  1444,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,  1445,  1446,     0,     0,
     639,  1447,   640,  1448,  1449,   641,   642,   643,   644,   645,
     646,     0,  1450,   647,   648,   649,   650,  1451,     0,   651,
     652,   653,   654,   655,  1452,     0,   656,   236,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   666,
     667,   668,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,  1462,     0,     0,     0,     0,     0,     0,  1463,   705,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   706,
     104,   105,   406,   707,     0,   107,   108,   109,   110,   708,
     709,   112,   113,   114,   115,     0,   116,   710,   711,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,  1548,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,   562,
       0,   563,     0,     0,  1437,   565,   566,     0,     0,   197,
     198,   199,   200,  1438,   567,   568,   569,   570,   571,   572,
       0,   573,  1439,   574,   203,   575,   576,   577,     0,   578,
     579,   580,   581,   582,   583,   584,  1440,   585,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     597,     0,   598,   599,   211,   600,   601,  1441,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,  1442,   615,   217,   616,   617,   219,   618,  1443,
       0,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     628,  1444,   629,     0,   630,   631,     0,   632,   633,   634,
     635,   636,   637,     0,  1445,  1446,     0,     0,   639,  1447,
     640,  1448,  1449,   641,   642,   643,   644,   645,   646,     0,
    1450,   647,   648,   649,   650,  1451,     0,   651,   652,   653,
     654,   655,  1452,     0,   656,   236,   657,   658,   659,     0,
       0,   660,     0,     0,   661,   662,   663,   664,   665,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   666,   667,   668,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   705,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   706,   104,   105,
     406,   707,     0,   107,   108,   109,   110,   708,   709,   112,
     113,   114,   115,     0,   116,   710,   711,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,  2188,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,   562,     0,   563,
       0,     0,  1437,   565,   566,     0,     0,   197,   198,   199,
     200,  1438,   567,   568,   569,   570,   571,   572,     0,   573,
    1439,   574,   203,   575,   576,   577,     0,   578,   579,   580,
     581,   582,   583,   584,  1440,   585,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   597,     0,
     598,   599,   211,   600,   601,  1441,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
    1442,   615,   217,   616,   617,   219,   618,  1443,     0,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   628,  1444,
     629,     0,   630,   631,     0,   632,   633,   634,   635,   636,
     637,     0,  1445,  1446,     0,     0,   639,  1447,   640,  1448,
    1449,   641,   642,   643,   644,   645,   646,     0,  1450,   647,
     648,   649,   650,  1451,     0,   651,   652,   653,   654,   655,
    1452,     0,   656,   236,   657,   658,   659,     0,     0,   660,
       0,     0,   661,   662,   663,   664,   665,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   666,   667,   668,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,     0,     0,  1463,   705,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   706,   104,   105,   406,   707,
       0,   107,   108,   109,   110,   708,   709,   112,   113,   114,
     115,     0,   116,   710,   711,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,  3136,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,   549,   550,   551,   552,
     553,   554,   192,   555,  1433,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,   562,     0,   563,     0,     0,
    1437,   565,   566,     0,     0,   197,   198,   199,   200,  1438,
     567,   568,   569,   570,   571,   572,     0,   573,  1439,   574,
     203,   575,   576,   577,     0,   578,   579,   580,   581,   582,
     583,   584,  1440,   585,   586,   587,     0,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   597,     0,   598,   599,
     211,   600,   601,  1441,   602,   603,   604,   605,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,  1442,   615,
     217,   616,   617,   219,   618,  1443,     0,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   628,  1444,   629,     0,
     630,   631,     0,   632,   633,   634,   635,   636,   637,     0,
    1445,  1446,     0,     0,   639,  1447,   640,  1448,  1449,   641,
     642,   643,   644,   645,   646,     0,  1450,   647,   648,   649,
     650,  1451,     0,   651,   652,   653,   654,   655,  1452,     0,
     656,   236,   657,   658,   659,     0,     0,   660,     0,     0,
     661,   662,   663,   664,   665,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   666,   667,   668,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,     0,     0,     0,     0,     0,
       0,     0,  1463,   705,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   706,   104,   105,   406,   707,     0,   107,
     108,   109,   110,   708,   709,   112,   113,   114,   115,     0,
     116,   710,   711,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,  2677,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,  1433,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,   562,     0,   563,     0,     0,  1437,   565,
     566,     0,     0,   197,   198,   199,   200,  1438,   567,   568,
     569,   570,   571,   572,     0,   573,  1439,   574,   203,   575,
     576,   577,     0,   578,   579,   580,   581,   582,   583,   584,
    1440,   585,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   597,     0,   598,   599,   211,   600,
     601,  1441,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,  1442,   615,   217,   616,
     617,   219,   618,  1443,     0,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,  1444,   629,     0,   630,   631,
       0,   632,   633,   634,   635,   636,   637,     0,  1445,  1446,
       0,     0,   639,  1447,   640,  1448,  1449,   641,   642,   643,
     644,   645,   646,     0,  1450,   647,   648,   649,   650,  1451,
       0,   651,   652,   653,   654,   655,  1452,     0,   656,   236,
     657,   658,   659,     0,     0,   660,     0,     0,   661,   662,
     663,   664,   665,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   666,   667,   668,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,     0,     0,     0,     0,     0,     0,     0,
    1463,   705,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   706,   104,   105,   406,   707,     0,   107,   108,   109,
     110,   708,   709,   112,   113,   114,   115,     0,   116,   710,
     711,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,   562,     0,   563,     0,     0,  1437,   565,   566,     0,
       0,   197,   198,   199,   200,  1438,   567,   568,   569,   570,
     571,   572,     0,   573,  1439,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,  1440,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,   211,   600,   601,  1441,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,  1442,   615,   217,   616,   617,   219,
     618,  1443,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,  1444,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,  1445,  1446,     0,     0,
     639,  1447,   640,  1448,  1449,   641,   642,   643,   644,   645,
     646,     0,  1450,   647,   648,   649,   650,  1451,     0,   651,
     652,   653,   654,   655,  1452,  3740,   656,   236,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   666,
     667,   668,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   705,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   706,
     104,   105,   406,   707,     0,   107,   108,   109,   110,   708,
     709,   112,   113,   114,   115,     0,   116,   710,   711,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,  4409,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,  4410,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,   562,
       0,   563,     0,     0,  1437,   565,   566,     0,     0,   197,
     198,   199,   200,  1438,   567,   568,   569,   570,   571,   572,
       0,   573,  1439,   574,   203,   575,   576,   577,     0,   578,
     579,   580,   581,   582,   583,   584,  1440,   585,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     597,     0,   598,   599,   211,   600,   601,  1441,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,  1442,   615,   217,   616,   617,   219,   618,  1443,
       0,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     628,  1444,   629,     0,   630,   631,     0,   632,   633,   634,
     635,   636,   637,     0,  1445,  1446,     0,     0,   639,  1447,
     640,  1448,  1449,   641,   642,   643,  4411,   645,   646,     0,
    1450,   647,   648,   649,   650,  1451,     0,   651,   652,   653,
     654,   655,  1452,     0,   656,   236,   657,   658,   659,     0,
       0,   660,     0,     0,   661,   662,   663,   664,   665,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   666,   667,   668,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   705,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   706,   104,   105,
     406,   707,     0,   107,   108,   109,   110,   708,   709,   112,
     113,   114,   115,     0,   116,   710,   711,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,  4410,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,   562,     0,   563,
       0,     0,  1437,   565,   566,     0,     0,   197,   198,   199,
     200,  1438,   567,   568,   569,   570,   571,   572,     0,   573,
    1439,   574,   203,   575,   576,   577,     0,   578,   579,   580,
     581,   582,   583,   584,  1440,   585,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   597,     0,
     598,   599,   211,   600,   601,  1441,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
    1442,   615,   217,   616,   617,   219,   618,  1443,     0,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   628,  1444,
     629,     0,   630,   631,     0,   632,   633,   634,   635,   636,
     637,     0,  1445,  1446,     0,     0,   639,  1447,   640,  1448,
    1449,   641,   642,   643,  4411,   645,   646,     0,  1450,   647,
     648,   649,   650,  1451,     0,   651,   652,   653,   654,   655,
    1452,     0,   656,   236,   657,   658,   659,     0,     0,   660,
       0,     0,   661,   662,   663,   664,   665,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   666,   667,   668,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,     0,     0,  1463,   705,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   706,   104,   105,   406,   707,
       0,   107,   108,   109,   110,   708,   709,   112,   113,   114,
     115,     0,   116,   710,   711,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,   549,   550,   551,   552,
     553,   554,   192,   555,  1433,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,   562,     0,   563,     0,     0,
    1437,   565,   566,     0,     0,   197,   198,   199,   200,  1438,
     567,   568,   569,   570,   571,   572,     0,   573,  1439,   574,
     203,   575,   576,   577,     0,   578,   579,   580,   581,   582,
     583,   584,  1440,   585,   586,   587,     0,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   597,     0,   598,   599,
     211,   600,   601,  1441,   602,   603,   604,   605,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,  1442,   615,
     217,   616,   617,   219,   618,  1443,     0,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   628,  1444,   629,     0,
     630,   631,     0,   632,   633,   634,   635,   636,   637,     0,
    1445,  1446,     0,     0,   639,  1447,   640,  1448,  1449,   641,
     642,   643,   644,   645,   646,     0,  1450,   647,   648,   649,
     650,  1451,     0,   651,   652,   653,   654,   655,  1452,     0,
     656,   236,   657,   658,   659,     0,     0,   660,     0,     0,
     661,   662,   663,   664,   665,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   666,   667,   668,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,     0,     0,     0,     0,     0,
       0,     0,  1463,   705,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   706,   104,   105,   406,   707,     0,   107,
     108,   109,   110,   708,   709,   112,   113,   114,   115,     0,
     116,   710,   711,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,  1433,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,   562,     0,   563,     0,     0,  1437,   565,
     566,     0,     0,   197,   198,   199,   200,  1438,   567,   568,
     569,   570,   571,   572,     0,   573,  1439,   574,   203,   575,
     576,   577,     0,   578,   579,   580,   581,   582,   583,   584,
    1440,   585,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   597,     0,   598,   599,   211,   600,
     601,  1441,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,  1442,   615,   217,   616,
     617,   219,   618,  1443,     0,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,  1444,   629,     0,   630,   631,
       0,   632,   633,   634,   635,   636,   637,     0,  1445,  1446,
       0,     0,   639,  1447,   640,  1448,  1449,   641,   642,   643,
     644,   645,   646,     0,  1450,   647,   648,   649,   650,  1451,
       0,   651,   652,   653,   654,   655,  1452,     0,   656,   236,
     657,   658,   659,     0,     0,   660,     0,     0,   661,   662,
     663,   664,   665,  3987,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   666,   667,   668,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,     0,     0,     0,     0,     0,     0,     0,
    1463,   705,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   706,   104,   105,   406,   707,     0,   107,   108,   109,
     110,   708,   709,   112,   113,   114,   115,     0,   116,   710,
     711,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,  3994,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,   562,     0,   563,     0,     0,  1437,   565,   566,     0,
       0,   197,   198,   199,   200,  1438,   567,   568,   569,   570,
     571,   572,     0,   573,  1439,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,  1440,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,   211,   600,   601,  1441,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,  1442,   615,   217,   616,   617,   219,
     618,  1443,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,  1444,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,  1445,  1446,     0,     0,
     639,  1447,   640,  1448,  1449,   641,   642,   643,   644,   645,
     646,     0,  1450,   647,   648,   649,   650,  1451,     0,   651,
     652,   653,   654,   655,  1452,     0,   656,   236,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   666,
     667,   668,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   705,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   706,
     104,   105,   406,   707,     0,   107,   108,   109,   110,   708,
     709,   112,   113,   114,   115,     0,   116,   710,   711,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,   562,
       0,   563,     0,     0,  1437,   565,   566,     0,     0,   197,
     198,   199,   200,  1438,   567,   568,   569,   570,   571,   572,
       0,   573,  1439,   574,   203,   575,   576,   577,     0,   578,
     579,   580,   581,   582,   583,   584,  1440,   585,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     597,     0,   598,   599,   211,   600,   601,  1441,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,  1442,   615,   217,   616,   617,   219,   618,  1443,
       0,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     628,  1444,   629,     0,   630,   631,     0,   632,   633,   634,
     635,   636,   637,     0,  1445,  1446,     0,     0,   639,  1447,
     640,  1448,  1449,   641,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,  1451,     0,   651,   652,   653,
     654,   655,  1452,     0,   656,   236,   657,   658,   659,     0,
       0,   660,     0,     0,   661,   662,   663,   664,   665,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   666,   667,   668,
       0,     0,     0,     0,     0,     0,     0,  2659,  2660,     0,
       0,     0,     0,     0,     0,     0,  1463,   705,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   706,   104,   105,
     406,   707,     0,   107,   108,   109,   110,   708,   709,   112,
     113,   114,   115,     0,   116,   710,   711,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
   -2403,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,  4410,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,     0,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,   562,     0,   563,
       0,     0,  1437,   565,   566,     0,     0,   197,   198,   199,
     200,  1438,   567,   568,   569,   570,   571,   572,     0,   573,
    1439,   574,   203,   575,   576,   577,     0,   578,   579,   580,
     581,   582,   583,   584,  1440,   585,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   597,     0,
     598,   599,   211,   600,   601,  1441,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
    1442,   615,   217,   616,   617,     0,   618,  1443,     0,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   628,  1444,
     629,     0,   630,   631,     0,   632,   633,   634,   635,   636,
     637,     0,  1445,  1446,     0,     0,   639,  1447,   640,  1448,
    1449,   641,   642,   643,  4411,   645,   646,     0,  1450,   647,
     648,   649,   650,  1451,     0,   651,   652,   653,   654,   655,
    1452,     0,   656,   236,   657,   658,   659,     0,     0,   660,
       0,     0,   661,   662,   663,   664,   665,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   666,   667,   668,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,     0,     0,  1463,   705,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   706,   104,   105,   406,   707,
       0,   107,   108,   109,   110,   708,   709,   112,   113,   114,
     115,     0,   116,   710,   711,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,     0,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,     0,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,     0,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,   562,     0,   563,     0,     0,
    1437,   565,   566,     0,     0,   197,   198,   199,   200,  1438,
     567,   568,   569,   570,   571,   572,     0,   573,  1439,   574,
     203,   575,   576,   577,     0,   578,   579,   580,   581,   582,
     583,   584,  1440,   585,   586,   587,     0,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   597,     0,   598,   599,
     211,   600,   601,  1441,   602,   603,   604,   605,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,  1442,   615,
     217,   616,   617,     0,   618,  1443,     0,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   628,  1444,   629,     0,
     630,   631,     0,   632,   633,   634,   635,   636,   637,     0,
    1445,  1446,     0,     0,   639,  1447,   640,  1448,  1449,   641,
     642,   643,   644,   645,   646,     0,  1450,   647,   648,   649,
     650,  1451,     0,   651,   652,   653,   654,   655,  1452,     0,
     656,   236,   657,   658,   659,     0,     0,   660,     0,     0,
     661,   662,   663,   664,   665,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   666,   667,   668,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,     0,     0,     0,     0,     0,
       0,     0,  1463,   705,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   706,   104,   105,   406,   707,     0,   107,
     108,   109,   110,   708,   709,   112,   113,   114,   115,     0,
     116,   710,   711,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,     0,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,     0,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
       0,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,   562,     0,   563,     0,     0,  1437,   565,
     566,     0,     0,   197,   198,   199,   200,  1438,   567,   568,
     569,   570,   571,   572,     0,   573,  1439,   574,   203,   575,
     576,   577,     0,   578,   579,   580,   581,   582,   583,   584,
    1440,   585,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   597,     0,   598,   599,   211,   600,
     601,  1441,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,  1442,   615,   217,   616,
     617,     0,   618,  1443,     0,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,  1444,   629,     0,   630,   631,
       0,   632,   633,   634,   635,   636,   637,     0,  1445,  1446,
       0,     0,   639,  1447,   640,  1448,  1449,   641,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,  1451,
       0,   651,   652,   653,   654,   655,  1452,     0,   656,   236,
     657,   658,   659,     0,     0,   660,     0,     0,   661,   662,
     663,   664,   665,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   666,   667,   668,     0,     0,     0,     0,     0,     0,
       0,  2659,  2660,     0,     0,     0,     0,     0,     0,     0,
    1463,   705,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   706,   104,   105,   406,   707,     0,   107,   108,   109,
     110,   708,   709,   112,   113,   114,   115,     0,   116,   710,
     711,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,   136,   137,   138,   139,     0,
     434,   435,   436,   437,   438,     0,  1406,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,  1421,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,   190,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,   194,   558,     0,  1435,   559,   196,   560,
     561,   562,     0,   563,     0,  1044,   564,   565,   566,     0,
       0,   197,   198,   199,   200,  1438,   567,   568,   569,   570,
     571,   572,     0,   573,  1439,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,   211,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,   215,   610,
     611,   612,   613,   614,  1442,   615,   217,   616,   617,   219,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,  1444,   629,     0,   630,   631,   223,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,  1447,   640,  1448,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,  1451,     0,   651,
     652,   653,   654,  1324,   235,     0,   656,   236,   657,   658,
     659,     0,     0,   660,     0,   237,   661,   662,   663,   664,
     665,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   666,
     667,   668,     0,     0,     0,   705,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,  2508,    98,
      99,   100,   101,   102,   103,   706,   104,   105,   406,   707,
       0,   107,   108,   109,   110,   708,   709,   112,   113,   114,
     115,     0,   116,   710,   711,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,   136,
     137,   138,   139,     0,   434,   435,   436,   437,   438,     0,
    1406,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,  1421,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,   190,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,   194,   558,     0,
    1435,   559,   196,   560,   561,   562,     0,   563,     0,  1044,
     564,   565,   566,     0,     0,   197,   198,   199,   200,  1438,
     567,   568,   569,   570,   571,   572,     0,   573,  1439,   574,
     203,   575,   576,   577,     0,   578,   579,   580,   581,   582,
     583,   584,   205,   585,   586,   587,     0,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   597,     0,   598,   599,
     211,   600,   601,   213,   602,   603,   604,   605,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,  1442,   615,
     217,   616,   617,   219,   618,   220,     0,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   628,  1444,   629,     0,
     630,   631,     0,   632,   633,   634,   635,   636,   637,     0,
     224,   225,     0,     0,   639,  1447,   640,  1448,     0,   641,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,  1451,     0,   651,   652,   653,   654,   655,   235,     0,
     656,   236,   657,   658,   659,     0,     0,   660,     0,     0,
     661,   662,   663,   664,   665,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   666,   667,   668,     0,     0,     0,   705,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,  2508,    98,    99,   100,   101,   102,   103,   706,
     104,   105,   406,   707,     0,   107,   108,   109,   110,   708,
     709,   112,   113,   114,   115,     0,   116,   710,   711,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,   136,   137,   138,   139,     0,   434,   435,
     436,   437,   438,     0,  1406,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,  1421,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,   190,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,   194,   558,     0,  1435,   559,   196,   560,   561,   562,
       0,   563,     0,     0,   564,   565,   566,     0,     0,   197,
     198,   199,   200,  1438,   567,   568,   569,   570,   571,   572,
       0,   573,  1439,   574,   203,   575,   576,   577,     0,   578,
     579,   580,   581,   582,   583,   584,   205,   585,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     597,     0,   598,   599,   211,   600,   601,   213,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,  1442,   615,   217,   616,   617,   219,   618,   220,
       0,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     628,  1444,   629,     0,   630,   631,     0,   632,   633,   634,
     635,   636,   637,     0,   224,   225,     0,     0,   639,  1447,
     640,  1448,     0,   641,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,  1451,     0,   651,   652,   653,
     654,   655,   235,     0,   656,   236,   657,   658,   659,     0,
       0,   660,     0,     0,   661,   662,   663,   664,   665,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   666,   667,   668,
       0,     0,     0,   705,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,  3768,    98,    99,   100,
     101,   102,   103,   706,   104,   105,   406,   707,     0,   107,
     108,   109,   110,   708,   709,   112,   113,   114,   115,     0,
     116,   710,   711,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,   136,   137,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,     0,     0,     0,   151,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,   182,   183,   531,
     184,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,   190,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,   194,   558,     0,   195,   559,
     196,   560,   561,   562,     0,   563,     0,     0,   564,   565,
     566,     0,     0,   197,   198,   199,   200,   201,   567,   568,
     569,   570,   571,   572,     0,   573,   202,   574,   203,   575,
     576,   577,     0,   578,   579,   580,   581,   582,   583,   584,
     205,   585,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   597,     0,   598,   599,   211,   600,
     601,   213,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,     0,   615,   217,   616,
     617,   219,   618,   220,     0,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,   222,   629,     0,   630,   631,
       0,   632,   633,   634,   635,   636,   637,     0,   224,   225,
       0,     0,   639,   226,   640,   227,     0,   641,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,   235,     0,   656,   236,
     657,   658,   659,     0,     0,   660,     0,     0,   661,   662,
     663,   664,   665,   238,   239,   240,   241,   242,   243,   244,
     245,   666,   667,   668,     0,     0,     0,     0,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
    4222,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
    3118,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461, -1270,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
   -1270,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519, -1270,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524, -1270,   525,   526,   527,   528,   529,   530,
       0,   182, -1270,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189, -1270,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,   562,     0,   563,
       0,     0,   564,   565,   566,     0,     0,   197,     0,     0,
       0,   201,   567,   568,   569,   570,   571,   572,     0,   573,
     202,   574,   203,   575,   576,   577,     0,   578,   579,   580,
     581,   582,   583,   584,   205,   585,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   597,     0,
     598,   599, -1270,   600,   601,   213,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
       0,   615,   217,   616,   617,     0,   618,   220,     0,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   628,   222,
     629,     0,   630,   631,     0,   632,   633,   634,   635,   636,
     637,     0,   224,   225,     0,     0,   639,   226,   640,   227,
       0,   641,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     235,     0,   656,     0,   657,   658,   659,     0,     0,   660,
       0,     0,   661,   662,   663,   664,   665,   238,   239,   240,
     241,   242,   243,   244,   245,   666,   667,   668,     0,     0,
       0,     0,     0,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,  1556,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   406,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,   416,
       0,     0,    37,    38,    39,    40,    41,    42,    43,    44,
       0,     0,     0,    45,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,     0,   431,   432,   433,   135,   136,     0,   138,   139,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
     441,   140,   442,     0,   443,   444,   445,   446,   144,     0,
       0,   447,   448,   449,   450,     0,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,     0,
     462,     0,     0,     0,     0,     0,     0,     0,     0,   463,
     464,   465,   466,   467,   468,   154,   155,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,   164,
     493,   494,   166,  1927,   495,     0,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   507,   508,   509,
       0,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,     0,   175,     0,   520,   521,   522,     0,
     177,     0,   178,     0,   523,     0,     0,   524,     0,   525,
     526,   527,   528,   529,   530,     0,   182,     0,   531,     0,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   189,
       0,   191,   548,   549,   550,   551,   552,   553,   554,   192,
     555,     0,   556,   557,     0,   558,     0,   195,   559,   196,
     560,   561,   562,     0,   563,  1928,     0,   564,   565,   566,
       0,     0,   197,     0,     0,     0,   201,   567,   568,   569,
     570,   571,   572,     0,   573,   202,   574,   203,   575,   576,
     577,     0,   578,   579,   580,   581,   582,   583,   584,   205,
     585,   586,   587,     0,   588,   589,   590,   591,   592,   593,
     594,   595,   596,   597,     0,   598,   599,     0,   600,   601,
     213,   602,   603,   604,   605,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,     0,   615,   217,   616,   617,
       0,   618,   220,     0,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   222,   629,     0,   630,   631,     0,
     632,   633,   634,   635,   636,   637,     0,   224,   225,     0,
       0,   639,   226,   640,   227,  1929,   641,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,   235,     0,   656,     0,   657,
     658,   659,     0,     0,   660,     0,     0,   661,   662,   663,
     664,   665,   238,   239,   240,   241,   242,   243,   244,   245,
     666,   667,   668,     0,     0,     0,     0,     0,     0,     0,
     962,  1595,  3845,     0,     0,     0,     0,     0,     0,  3846,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   406,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,    37,
      38,    39,    40,    41,    42,     0,    44,     0,     0,     0,
      45,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,     0,   431,
     432,   433,   135,   136,     0,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,     0,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,     0,   462,     0,     0,
       0,     0,     0,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
       0,     0,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,     0,     0,   524,     0,   525,   526,   527,   528,
     529,   530,     0,   182,     0,   531,     0,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,     0,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,     0,   558,     0,   195,   559,   196,   560,   561,   562,
       0,   563,     0,     0,   564,   565,   566,     0,     0,   197,
       0,     0,     0,   201,   567,   568,   569,   570,   571,   572,
       0,   573,   202,   574,   203,   575,   576,   577,     0,   578,
     579,   580,   581,   582,   583,   584,   205,   585,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     597,     0,   598,   599,     0,   600,   601,   213,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,     0,   615,   217,   616,   617,     0,   618,   220,
       0,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     628,   222,   629,     0,   630,   631,     0,   632,   633,   634,
     635,   636,   637,     0,   224,   225,     0,     0,   639,   226,
     640,   227,     0,   641,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   235,     0,   656,     0,   657,   658,   659,     0,
       0,   660,     0,     0,   661,   662,   663,   664,   665,   238,
     239,   240,   241,   242,   243,   244,   245,   666,   667,   668,
       0,     0,     0,     0,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,  3502,  3503,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,   130,   131,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,   562,     0,   563,     0,     0,   564,   565,
     566,     0,     0,   197,     0,     0,     0,   201,   567,   568,
     569,   570,   571,   572,     0,   573,   202,   574,   203,   575,
     576,   577,     0,   578,   579,   580,   581,   582,   583,   584,
     205,   585,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   597,     0,   598,   599,     0,   600,
     601,   213,   602,   603,   604,   605,   606,   607,   608,   609,
     215,   610,   611,   612,   613,   614,     0,   615,   217,   616,
     617,     0,   618,   220,     0,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,   222,   629,     0,   630,   631,
     223,   632,   633,   634,   635,   636,   637,     0,   224,   225,
       0,     0,   639,   226,   640,   227,     0,   641,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,  1324,   235,     0,   656,  1325,
     657,   658,   659,     0,     0,   660,     0,   237,   661,   662,
     663,   664,   665,   238,   239,   240,   241,   242,   243,   244,
     245,   666,   667,   668,     0,     0,     0,     0,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
     246,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,     0,    44,     0,     0,     0,    45,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,   562,     0,   563,
       0,     0,   564,   565,   566,     0,     0,   197,     0,     0,
       0,   201,   567,   568,   569,   570,   571,   572,     0,   573,
     202,   574,   203,   575,   576,   577,     0,   578,   579,   580,
     581,   582,   583,   584,   205,   585,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   597,     0,
     598,   599,     0,   600,   601,   213,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
       0,   615,   217,   616,   617,     0,   618,   220,     0,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   628,   222,
     629,     0,   630,   631,     0,   632,   633,   634,   635,   636,
     637,     0,   224,   225,     0,     0,   639,   226,   640,   227,
       0,   641,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     235,     0,   656,     0,   657,   658,   659,     0,     0,   660,
       0,     0,   661,   662,   663,   664,   665,   238,   239,   240,
     241,   242,   243,   244,   245,   666,   667,   668,     0,     0,
       0,     0,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,  3503,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,   215,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,   223,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,  1324,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,   237,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,     0,     0,     0,     0,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,   246,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,   562,     0,   563,     0,     0,
     564,   565,   566,     0,     0,   197,     0,     0,     0,   201,
     567,   568,   569,   570,   571,   572,     0,   573,   202,   574,
     203,   575,   576,   577,     0,   578,   579,   580,   581,   582,
     583,   584,   205,   585,   586,   587,     0,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   597,     0,   598,   599,
       0,   600,   601,   213,   602,   603,   604,   605,   606,   607,
     608,   609,   215,   610,   611,   612,   613,   614,     0,   615,
     217,   616,   617,     0,   618,   220,     0,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   628,   222,   629,     0,
     630,   631,   223,   632,   633,   634,   635,   636,   637,     0,
     224,   225,     0,     0,   639,   226,   640,   227,     0,   641,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,  1324,   235,     0,
     656,     0,   657,   658,   659,     0,     0,   660,     0,   237,
     661,   662,   663,   664,   665,   238,   239,   240,   241,   242,
     243,   244,   245,   666,   667,   668,     0,     0,     0,     0,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,   246,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   406,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,     0,   431,
     432,   433,   135,   136,     0,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,     0,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,     0,   462,     0,     0,
       0,     0,     0,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
       0,     0,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,     0,     0,   524,     0,   525,   526,   527,   528,
     529,   530,     0,   182,     0,   531,     0,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,     0,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,     0,   558,     0,   195,   559,   196,   560,   561,   562,
       0,   563,     0,     0,   564,   565,   566,     0,     0,   197,
       0,     0,     0,   201,   567,   568,   569,   570,   571,   572,
       0,   573,   202,   574,   203,   575,   576,   577,     0,   578,
     579,   580,   581,   582,   583,   584,   205,   585,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     597,     0,   598,   599,     0,   600,   601,   213,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,     0,   615,   217,   616,   617,     0,   618,   220,
       0,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     628,   222,   629,     0,   630,   631,     0,   632,   633,   634,
     635,   636,   637,     0,   224,   225,     0,     0,   639,   226,
     640,   227,     0,   641,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   235,     0,   656,     0,   657,   658,   659,     0,
       0,   660,     0,     0,   661,   662,   663,   664,   665,   238,
     239,   240,   241,   242,   243,   244,   245,   666,   667,   668,
       0,     0,     0,     0,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,  1528,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,   562,     0,   563,     0,     0,   564,   565,
     566,     0,     0,   197,     0,     0,     0,   201,   567,   568,
     569,   570,   571,   572,     0,   573,   202,   574,   203,   575,
     576,   577,     0,   578,   579,   580,   581,   582,   583,   584,
     205,   585,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   597,     0,   598,   599,     0,   600,
     601,   213,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,     0,   615,   217,   616,
     617,     0,   618,   220,     0,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,   222,   629,     0,   630,   631,
       0,   632,   633,   634,   635,   636,   637,     0,   224,   225,
       0,     0,   639,   226,   640,   227,     0,   641,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,   235,     0,   656,     0,
     657,   658,   659,     0,     0,   660,     0,     0,   661,   662,
     663,   664,   665,   238,   239,   240,   241,   242,   243,   244,
     245,   666,   667,   668,     0,     0,     0,     0,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
    2160,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,   562,     0,   563,
       0,     0,   564,   565,   566,     0,     0,   197,     0,     0,
       0,   201,   567,   568,   569,   570,   571,   572,     0,   573,
     202,   574,   203,   575,   576,   577,     0,   578,   579,   580,
     581,   582,   583,   584,   205,   585,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   597,     0,
     598,   599,     0,   600,   601,   213,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
       0,   615,   217,   616,   617,     0,   618,   220,     0,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   628,   222,
     629,     0,   630,   631,     0,   632,   633,   634,   635,   636,
     637,     0,   224,   225,     0,     0,   639,   226,   640,   227,
       0,   641,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     235,     0,   656,     0,   657,   658,   659,     0,     0,   660,
       0,     0,   661,   662,   663,   664,   665,   238,   239,   240,
     241,   242,   243,   244,   245,   666,   667,   668,     0,     0,
       0,     0,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,  3608,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,     0,     0,     0,   705,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,  3734,    98,
      99,   100,   101,   102,   103,   706,   104,   105,   406,   707,
       0,   107,   108,   109,   110,   708,   709,   112,   113,   114,
     115,     0,   116,   710,   711,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,  1158,    45,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   712,
     425,   426,   427,   713,   714,   715,   716,   717,   718,   719,
     428,   429,   720,   430,   133,   431,   432,   433,     0,  1784,
     137,  1785,  1786,   721,   434,   435,   436,   437,   438,   722,
     723,   439,   440,  1787,  1788,   442,   725,   443,   444,   445,
     446,     0,   726,   727,   447,   448,   449,   450,   147,   451,
     452,   729,   453,   454,   455,   456,   457,   458,   730,   459,
     460,   461,   150,   462,     0,   732,   733,   734,   151,   735,
     736,   737,   463,   464,   465,   466,   467,   468,  1789,  1790,
     469,   738,   470,   739,   471,   472,   473,   474,   475,   740,
     476,   477,   478,   741,   742,   479,   480,  1419,   482,   483,
     743,   484,   485,   486,   744,   487,   488,   745,   489,   490,
     491,   492,     0,   493,   494,     0,   746,   495,   747,   496,
    1791,   497,   748,   498,   749,   499,   169,   750,   170,   500,
     501,   502,   751,   503,     0,   752,   504,   753,   505,   506,
     507,   508,   509,   173,   510,   511,   512,   754,   513,   514,
     515,   516,   517,   518,   755,   519,   174,     0,     0,   520,
     521,   522,  1425,  1792,   758,  1793,   759,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,   760,     0,
     183,   531,   184,   761,   532,   533,   534,   762,   763,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1794,   190,  1795,   548,   549,   550,   551,   552,
     553,   554,     0,   555,   764,   556,   557,   194,   558,   765,
       0,   559,  1796,   560,   561,   562,   766,   563,   767,   768,
    3489,   565,   566,   769,   770,     0,   198,   199,   200,     0,
     567,   568,   569,   570,   571,   572,   771,   573,     0,   574,
       0,   575,   576,   577,   772,   578,   579,   580,   581,   582,
     583,   584,  1797,   585,   586,   587,   773,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   597,   774,   598,   599,
     211,   600,   601,     0,   602,   603,   604,   605,   606,   607,
     608,   609,   775,   610,   611,   612,   613,   614,   776,   615,
    2305,   616,   617,   219,   618,  1799,   777,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   628,     0,   629,   778,
     630,   631,   779,   632,   633,   634,   635,   636,   637,   780,
    1800,  1801,     0,   782,   639,     0,   640,     0,   783,   641,
     642,   643,   644,   645,   646,     0,   785,   647,   648,   649,
     650,   786,   787,   651,   652,   653,   654,     0,  1802,   789,
     656,   236,   657,   658,   659,   790,   791,   660,   792,   793,
     661,   662,   663,   664,   665,     0,     0,     0,     0,     0,
       0,     0,     0,   666,   667,   668,     0,     0,     0,  1161,
    1162,  1163,     0,  3490,  3491,  1166,  1167,  1168,  1169,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   406,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1158,     0,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,     0,   431,   432,
     433,   135,   136,     0,   138,   139,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,   441,   140,   442,     0,
     443,  1159,   445,   446,   144,     0,     0,   447,   448,   449,
     450,     0,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,     0,   462,     0,     0,     0,
       0,     0,     0,     0,     0,   463,   464,   465,   466,   467,
     468,   154,   155,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,   164,   493,   494,   166,     0,
    1160,     0,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   507,   508,   509,     0,   510,   511,   512,
       0,   513,   514,   515,   516,   517,   518,     0,   519,     0,
     175,     0,   520,   521,   522,     0,   177,     0,   178,     0,
     523,     0,     0,   524,     0,   525,   526,   527,   528,   529,
     530,     0,   182,     0,   531,     0,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   189,     0,   191,   548,   549,
     550,   551,   552,   553,   554,   192,   555,     0,   556,   557,
       0,   558,     0,   195,   559,   196,   560,   561,   562,     0,
     563,     0,     0,   564,   565,   566,     0,     0,   197,     0,
       0,     0,   201,   567,   568,   569,   570,   571,   572,     0,
     573,   202,   574,   203,   575,   576,   577,     0,   578,   579,
     580,   581,   582,   583,   584,   205,   585,   586,   587,     0,
     588,   589,   590,   591,   592,   593,   594,   595,   596,   597,
       0,   598,   599,     0,   600,   601,   213,   602,   603,   604,
     605,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,     0,   615,   217,   616,   617,     0,   618,   220,     0,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   628,
     222,   629,     0,   630,   631,     0,   632,   633,   634,   635,
     636,   637,     0,   224,   225,     0,     0,   639,   226,   640,
     227,     0,   641,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,   235,     0,   656,     0,   657,   658,   659,     0,     0,
     660,     0,     0,   661,   662,   663,   664,   665,   238,   239,
     240,   241,   242,   243,   244,   245,   666,   667,   668,     0,
       0,     0,  1161,  1162,  1163,     0,  1164,  1165,  1166,  1167,
    1168,  1169,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,  1234,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,  1235,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,     0,     0,     0,  1161,  1162,  1163,     0,  1164,
    1165,  1166,  1167,  1168,  1169,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   406,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1158,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,     0,   431,   432,   433,   135,   136,     0,
     138,   139,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,   441,   140,   442,     0,   443,  1285,   445,   446,
     144,     0,     0,   447,   448,   449,   450,     0,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,     0,   462,     0,     0,     0,     0,     0,     0,     0,
       0,   463,   464,   465,   466,   467,   468,   154,   155,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,   164,   493,   494,   166,     0,  1286,     0,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   507,
     508,  1287,     0,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   175,     0,   520,   521,
     522,     0,   177,     0,   178,     0,   523,     0,     0,   524,
       0,   525,   526,   527,   528,   529,   530,     0,   182,     0,
     531,     0,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,     0,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,     0,   556,   557,     0,   558,     0,   195,
     559,   196,   560,   561,   562,     0,   563,     0,     0,   564,
     565,   566,     0,     0,   197,     0,     0,     0,   201,   567,
     568,   569,   570,   571,   572,     0,   573,   202,   574,   203,
     575,   576,   577,     0,   578,   579,   580,   581,   582,   583,
     584,   205,   585,   586,   587,     0,   588,   589,   590,   591,
     592,   593,   594,   595,   596,   597,     0,   598,   599,     0,
     600,   601,   213,   602,   603,   604,   605,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,     0,   615,   217,
     616,   617,     0,   618,   220,     0,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   628,   222,   629,     0,   630,
     631,     0,   632,   633,   634,   635,   636,   637,     0,   224,
     225,     0,     0,   639,   226,   640,   227,     0,   641,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   235,     0,   656,
       0,   657,   658,   659,     0,     0,   660,     0,     0,   661,
     662,   663,   664,   665,   238,   239,   240,   241,   242,   243,
     244,   245,   666,   667,   668,     0,     0,     0,  1161,  1162,
    1163,     0,  1164,  1165,  1166,  1167,  1168,  1169,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,  1158,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
    1767,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,  1768,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,   562,     0,   563,
       0,     0,   564,   565,   566,     0,     0,   197,     0,     0,
       0,   201,   567,   568,   569,   570,   571,   572,     0,   573,
     202,   574,   203,   575,   576,   577,     0,   578,   579,   580,
     581,   582,   583,   584,   205,   585,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   597,     0,
     598,   599,     0,   600,   601,   213,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
       0,   615,   217,   616,   617,     0,   618,   220,     0,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   628,   222,
     629,     0,   630,   631,     0,   632,   633,   634,   635,   636,
     637,     0,   224,   225,     0,     0,   639,   226,   640,   227,
       0,   641,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     235,     0,   656,     0,   657,   658,   659,     0,     0,   660,
       0,     0,   661,   662,   663,   664,   665,   238,   239,   240,
     241,   242,   243,   244,   245,   666,   667,   668,     0,     0,
       0,  1161,  1162,  1163,     0,  1164,  1165,  1166,  1167,  1168,
    1169,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   406,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
    1158,     0,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,     0,
     431,   432,   433,   135,   136,     0,   138,   139,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,   441,   140,
     442,     0,   443,   444,   445,   446,   144,     0,     0,   447,
     448,   449,   450,     0,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,     0,   462,     0,
       0,     0,     0,     0,     0,     0,     0,   463,   464,   465,
     466,   467,   468,   154,   155,   469,     0,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,   164,   493,   494,
     166,     0,   495,     0,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   507,   508,   509,     0,   510,
     511,   512,     0,   513,   514,   515,   516,   517,   518,     0,
     519,     0,   175,     0,   520,   521,   522,     0,   177,     0,
     178,     0,   523,     0,     0,   524,     0,   525,   526,   527,
     528,   529,   530,     0,   182,     0,   531,     0,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   189,     0,   191,
     548,   549,   550,   551,   552,   553,   554,   192,   555,     0,
     556,   557,     0,   558,     0,   195,   559,   196,   560,   561,
     562,     0,   563,     0,     0,   564,   565,   566,     0,     0,
     197,     0,     0,     0,   201,   567,   568,   569,   570,   571,
     572,     0,   573,   202,   574,   203,   575,   576,   577,     0,
     578,   579,   580,   581,   582,   583,   584,   205,   585,   586,
     587,     0,   588,   589,   590,   591,   592,   593,   594,   595,
     596,   597,     0,   598,   599,     0,   600,   601,   213,   602,
     603,   604,   605,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,     0,   615,   217,   616,   617,     0,   618,
     220,     0,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   628,   222,   629,     0,   630,   631,     0,   632,   633,
     634,   635,   636,   637,     0,   224,   225,     0,     0,   639,
     226,   640,   227,     0,   641,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   235,     0,   656,     0,   657,   658,   659,
       0,     0,   660,     0,     0,   661,   662,   663,   664,   665,
     238,   239,   240,   241,   242,   243,   244,   245,   666,   667,
     668,     0,     0,     0,  1161,  1162,  1163,     0,  1164,  1165,
    1166,  1167,  1168,  1169,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,  1158,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,   562,     0,   563,     0,     0,  4211,   565,
     566,     0,     0,   197,     0,     0,     0,   201,   567,   568,
     569,   570,   571,   572,     0,   573,   202,   574,   203,   575,
     576,   577,     0,   578,   579,   580,   581,   582,   583,   584,
     205,   585,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   597,     0,   598,   599,     0,   600,
     601,   213,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,     0,   615,   217,   616,
     617,     0,   618,   220,     0,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,   222,   629,     0,   630,   631,
       0,   632,   633,   634,   635,   636,   637,     0,   224,   225,
       0,     0,   639,   226,   640,   227,     0,   641,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,   235,     0,   656,     0,
     657,   658,   659,     0,     0,   660,     0,     0,   661,   662,
     663,   664,   665,   238,   239,   240,   241,   242,   243,   244,
     245,   666,   667,   668,     0,     0,     0,  1161,  1162,  1163,
       0,  1164,  1165,  1166,  1167,  1168,  1169,   705,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   706,   104,   105,
     406,   707,     0,   107,   108,   109,   110,   708,   709,   112,
     113,   114,   115,     0,   116,   710,   711,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,   712,   425,   426,   427,   713,   714,   715,   716,   717,
     718,   719,   428,   429,   720,   430,   133,   431,   432,   433,
     135,   136,   137,   138,   139,   721,   434,   435,   436,   437,
     438,   722,   723,   439,   440,   724,   140,   442,   725,   443,
     444,   445,   446,   144,   726,   727,   447,   448,   449,   450,
     147,   451,   728,   729,   453,   454,   455,   456,   457,   458,
     730,   459,   460,   461,   150,   462,   731,   732,   733,   734,
     151,   735,   736,   737,   463,   464,   465,   466,   467,   468,
     154,   155,   469,   738,   470,   739,   471,   472,   473,   474,
     475,   740,   476,   477,   478,   741,   742,   479,   480,   481,
     482,   483,   743,   484,   485,   486,   744,   487,   488,   745,
     489,   490,   491,   492,   164,   493,   494,   166,   746,   495,
     747,   496,   168,   497,   748,   498,   749,   499,   169,   750,
     170,   500,   501,   502,   751,   503,   172,   752,   504,   753,
     505,   506,   507,   508,   509,   173,   510,   511,   512,   754,
     513,   514,   515,   516,   517,   518,   755,   519,   174,   175,
     756,   520,   521,   522,   757,   177,   758,   178,   759,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
     760,   182,   183,   531,   184,   761,   532,   533,   534,   762,
     763,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,   190,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,   764,   556,   557,   194,
     558,   765,   195,   559,   196,   560,   561,   562,   766,   563,
     767,   768,   564,   565,   566,   769,   770,   197,   198,   199,
     200,   201,   567,   568,   569,   570,   571,   572,   771,   573,
     202,   574,   203,   575,   576,   577,   772,   578,   579,   580,
     581,   582,   583,   584,   205,   585,   586,   587,   773,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   597,   774,
     598,   599,   211,   600,   601,   213,   602,   603,   604,   605,
     606,   607,   608,   609,   775,   610,   611,   612,   613,   614,
     776,   615,   217,   616,   617,   219,   618,   220,   777,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   628,   222,
     629,   778,   630,   631,   779,   632,   633,   634,   635,   636,
     637,   780,   224,   225,   781,   782,   639,   226,   640,   227,
     783,   641,   642,   643,   644,   645,   646,   784,   785,   647,
     648,   649,   650,   786,   787,   651,   652,   653,   654,   788,
     235,   789,   656,   236,   657,   658,   659,   790,   791,   660,
     792,   793,   661,   662,   663,   664,   665,   238,   239,   240,
     241,   242,   243,   244,   245,   666,   667,   668,   705,    86,
      87,    88,   403,    90,    91,    92,   404,  2151,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   706,   104,
     105,   406,   707,     0,   107,   108,   109,   110,   708,   709,
     112,   113,   114,   115,     0,   116,   710,   711,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,   133,   431,   432,
     433,     0,  1784,   137,  1785,  1786,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,  1787,  1788,   442,     0,
     443,   444,   445,   446,     0,     0,     0,   447,   448,   449,
     450,   147,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,   150,   462,     0,     0,     0,
       0,   151,     0,     0,     0,   463,   464,   465,   466,   467,
     468,  1789,  1790,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
    1419,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,     0,   493,   494,     0,     0,
     495,     0,   496,  1791,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,     0,     0,   504,
       0,   505,   506,   507,   508,   509,   173,   510,   511,   512,
       0,   513,   514,   515,   516,   517,   518,     0,   519,   174,
       0,     0,   520,   521,   522,  1425,  1792,     0,  1793,     0,
     523,   179,   180,   524,   181,   525,   526,   527,   528,   529,
     530,     0,     0,   183,   531,   184,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,  1794,   190,  1795,   548,   549,
     550,   551,   552,   553,   554,     0,   555,     0,   556,   557,
     194,   558,     0,     0,   559,  1796,   560,   561,   562,     0,
     563,     0,     0,   564,   565,   566,     0,     0,     0,   198,
     199,   200,     0,   567,   568,   569,   570,   571,   572,     0,
     573,     0,   574,     0,   575,   576,   577,     0,   578,   579,
     580,   581,   582,   583,   584,  1797,   585,   586,   587,     0,
     588,   589,   590,   591,   592,   593,   594,   595,   596,   597,
       0,   598,   599,   211,   600,   601,     0,   602,   603,   604,
     605,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,     0,   615,  1798,   616,   617,   219,   618,  1799,     0,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   628,
       0,   629,     0,   630,   631,     0,   632,   633,   634,   635,
     636,   637,     0,  1800,  1801,     0,     0,   639,     0,   640,
       0,     0,   641,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
       0,  1802,     0,   656,   236,   657,   658,   659,     0,     0,
     660,     0,     0,   661,   662,   663,   664,   665,     0,     0,
       0,     0,     0,     0,     0,     0,   666,   667,   668,     0,
      86,    87,    88,   403,    90,    91,    92,   404,  2253,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   406,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,     0,   431,
     432,   433,   135,   136,     0,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,     0,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,     0,   462,     0,     0,
       0,     0,     0,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
       0,     0,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,     0,     0,   524,     0,   525,   526,   527,   528,
     529,   530,     0,   182,     0,   531,     0,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,     0,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,     0,   558,     0,   195,   559,   196,   560,   561,   562,
       0,   563,     0,     0,   564,   565,   566,     0,     0,   197,
       0,     0,     0,   201,   567,   568,   569,   570,   571,   572,
       0,   573,   202,   574,   203,   575,   576,   577,     0,   578,
     579,   580,   581,   582,   583,   584,   205,   585,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     597,     0,   598,   599,     0,   600,   601,   213,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,     0,   615,   217,   616,   617,     0,   618,   220,
       0,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     628,   222,   629,     0,   630,   631,     0,   632,   633,   634,
     635,   636,   637,     0,   224,   225,     0,     0,   639,   226,
     640,   227,     0,   641,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   235,     0,   656,     0,   657,   658,   659,     0,
       0,   660,     0,     0,   661,   662,   663,   664,   665,   238,
     239,   240,   241,   242,   243,   244,   245,   666,   667,   668,
       0,    86,    87,    88,   403,    90,    91,    92,   404,  1051,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   406,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,     0,
     431,   432,   433,   135,   136,     0,   138,   139,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,   441,   140,
     442,     0,   443,   444,   445,   446,   144,     0,     0,   447,
     448,   449,   450,     0,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,     0,   462,     0,
       0,     0,     0,     0,     0,     0,     0,   463,   464,   465,
     466,   467,   468,   154,   155,   469,     0,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,   164,   493,   494,
     166,     0,   495,     0,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   507,   508,   509,     0,   510,
     511,   512,     0,   513,   514,   515,   516,   517,   518,     0,
     519,     0,   175,     0,   520,   521,   522,     0,   177,     0,
     178,     0,   523,     0,     0,   524,     0,   525,   526,   527,
     528,   529,   530,     0,   182,     0,   531,     0,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   189,     0,   191,
     548,   549,   550,   551,   552,   553,   554,   192,   555,     0,
     556,   557,     0,   558,     0,   195,   559,   196,   560,   561,
     562,     0,   563,     0,     0,   564,   565,   566,     0,     0,
     197,     0,     0,     0,   201,   567,   568,   569,   570,   571,
     572,     0,   573,   202,   574,   203,   575,   576,   577,     0,
     578,   579,   580,   581,   582,   583,   584,   205,   585,   586,
     587,     0,   588,   589,   590,   591,   592,   593,   594,   595,
     596,   597,     0,   598,   599,     0,   600,   601,   213,   602,
     603,   604,   605,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,     0,   615,   217,   616,   617,     0,   618,
     220,     0,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   628,   222,   629,     0,   630,   631,     0,   632,   633,
     634,   635,   636,   637,     0,   224,   225,     0,     0,   639,
     226,   640,   227,     0,   641,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   235,     0,   656,     0,   657,   658,   659,
       0,     0,   660,     0,     0,   661,   662,   663,   664,   665,
     238,   239,   240,   241,   242,   243,   244,   245,   666,   667,
     668,     0,    86,    87,    88,   403,    90,    91,    92,   404,
    4089,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,  2139,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,  1927,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,  1928,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,  1929,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,     0,     0,     0,     0,     0,     0,     0,   962,
    1595,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   406,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,   416,     0,     0,
      37,    38,    39,    40,    41,    42,    43,    44,     0,     0,
       0,    45,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,     0,
     431,   432,   433,   135,   136,     0,   138,   139,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,   441,   140,
     442,     0,   443,   444,   445,   446,   144,     0,     0,   447,
     448,   449,   450,     0,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,     0,   462,     0,
       0,     0,     0,     0,     0,     0,     0,   463,   464,   465,
     466,   467,   468,   154,   155,   469,  2144,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,   164,   493,   494,
     166,  1927,   495,     0,   496,   168,   497,     0,   498,     0,
     499,     0,     0,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   507,   508,   509,     0,   510,
     511,   512,     0,   513,   514,   515,   516,   517,   518,     0,
     519,     0,   175,     0,   520,   521,   522,     0,   177,     0,
     178,     0,   523,     0,     0,   524,     0,   525,   526,   527,
     528,   529,   530,     0,   182,     0,   531,     0,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   189,     0,   191,
     548,   549,   550,   551,   552,   553,   554,   192,   555,     0,
     556,   557,     0,   558,     0,   195,   559,   196,   560,   561,
     562,     0,   563,  1928,     0,   564,   565,   566,     0,     0,
     197,     0,     0,     0,   201,   567,   568,   569,   570,   571,
     572,     0,   573,   202,   574,   203,   575,   576,   577,     0,
     578,   579,   580,   581,   582,   583,   584,   205,   585,   586,
     587,     0,   588,   589,   590,   591,   592,   593,   594,   595,
     596,   597,     0,   598,   599,     0,   600,   601,   213,   602,
     603,   604,   605,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,     0,   615,   217,   616,   617,     0,   618,
     220,     0,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   628,   222,   629,     0,   630,   631,     0,   632,   633,
     634,   635,   636,   637,     0,   224,   225,     0,     0,   639,
     226,   640,   227,  1929,   641,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,   655,   235,     0,   656,     0,   657,   658,   659,
       0,     0,   660,     0,     0,   661,   662,   663,   664,   665,
     238,   239,   240,   241,   242,   243,   244,   245,   666,   667,
     668,     0,     0,     0,     0,     0,     0,     0,   962,  1595,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   406,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,     0,
      45,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,     0,   431,
     432,   433,   135,   136,     0,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,     0,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,     0,   462,     0,     0,
       0,     0,     0,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
    1927,   495,     0,   496,   168,   497,     0,   498,     0,   499,
       0,     0,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,     0,     0,   524,     0,   525,   526,   527,   528,
     529,   530,     0,   182,     0,   531,     0,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,     0,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,     0,   558,     0,   195,   559,   196,   560,   561,   562,
       0,   563,  1928,     0,   564,   565,   566,     0,     0,   197,
       0,     0,     0,   201,   567,   568,   569,   570,   571,   572,
       0,   573,   202,   574,   203,   575,   576,   577,     0,   578,
     579,   580,   581,   582,   583,   584,   205,   585,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     597,     0,   598,   599,     0,   600,   601,   213,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,     0,   615,   217,   616,   617,     0,   618,   220,
       0,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     628,   222,   629,     0,   630,   631,     0,   632,   633,   634,
     635,   636,   637,     0,   224,   225,     0,     0,   639,   226,
     640,   227,  1929,   641,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,   655,   235,     0,   656,     0,   657,   658,   659,     0,
       0,   660,     0,     0,   661,   662,   663,   664,   665,   238,
     239,   240,   241,   242,   243,   244,   245,   666,   667,   668,
       0,     0,     0,     0,     0,     0,     0,   962,  1595,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   406,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,   416,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,    45,
       0,     0,     0,     0,   417,   951,   419,   420,   421,   422,
     423,   424,   952,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,     0,   953,   432,
     433,   135,   136,     0,   138,   139,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,   441,   140,   442,     0,
     443,   444,   445,   446,   144,     0,     0,   447,   448,   449,
     450,     0,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,     0,   462,     0,     0,     0,
       0,     0,     0,     0,     0,   463,   464,   465,   466,   467,
     468,   154,   155,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,   164,   493,   494,   166,     0,
     495,     0,   954,   168,   497,     0,   498,     0,   955,     0,
     956,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   507,   508,   509,     0,   510,   511,   512,
     957,   513,   514,   515,   516,   517,   518,     0,   519,     0,
     175,     0,   520,   521,   522,     0,   177,     0,   178,     0,
     523,     0,     0,   524,     0,   525,   526,   527,   958,   529,
     530,     0,   182,     0,   531,     0,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   189,     0,   191,   959,   549,
     550,   551,   552,   553,   554,   192,   555,     0,   556,   557,
       0,   558,     0,   195,   559,   196,   560,   561,   562,     0,
     563,     0,     0,   564,   565,   566,     0,     0,   197,     0,
       0,     0,   201,   567,   568,   569,   570,   571,   572,     0,
     573,   202,   574,   203,   575,   576,   577,     0,   960,   579,
     580,   581,   582,   583,   584,   205,   585,   586,   587,     0,
     588,   961,   590,   591,   592,   593,   594,   595,   596,   597,
       0,   598,   599,     0,   600,   601,   213,   602,   603,   604,
     605,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,     0,   615,   217,   616,   617,     0,   618,   220,     0,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   628,
     222,   629,     0,   630,   631,     0,   632,   633,   634,   635,
     636,   637,     0,   224,   225,     0,     0,   639,   226,   640,
     227,     0,   641,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
     655,   235,     0,   656,     0,   657,   658,   659,     0,     0,
     660,     0,     0,   661,   662,   663,   664,   665,   238,   239,
     240,   241,   242,   243,   244,   245,   666,   667,   668,     0,
       0,     0,     0,     0,     0,     0,   962,   963,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,    45,     0,
       0,     0,     0,   417,   951,   419,   420,   421,   422,   423,
     424,   952,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   985,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   954,   168,   497,     0,   498,     0,   986,     0,   956,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,   957,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   958,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   959,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,   562,     0,   563,
       0,     0,   564,   565,   566,     0,     0,   197,     0,     0,
       0,   201,   567,   568,   569,   570,   571,   572,     0,   573,
     202,   574,   203,   575,   576,   577,     0,   960,   579,   580,
     581,   582,   583,   584,   205,   585,   586,   587,     0,   588,
     961,   590,   591,   592,   593,   594,   595,   596,   597,     0,
     598,   599,     0,   600,   601,   213,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
       0,   615,   217,   616,   617,     0,   618,   220,     0,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   628,   222,
     629,     0,   630,   631,     0,   632,   633,   634,   635,   636,
     637,     0,   224,   225,     0,     0,   639,   226,   640,   227,
       0,   641,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,   655,
     235,     0,   656,     0,   657,   658,   659,     0,     0,   660,
       0,     0,   661,   662,   663,   664,   665,   238,   239,   240,
     241,   242,   243,   244,   245,   666,   667,   668,     0,     0,
       0,     0,     0,     0,     0,   962,   963,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   406,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,   416,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,    45,     0,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
    1335,   425,   426,   427,     0,     0,     0,     0,     0,     0,
       0,   428,   429,     0,   430,     0,   431,   432,   433,   135,
     136,     0,   138,   139,     0,   434,   435,   436,   437,   438,
       0,     0,   439,   440,   441,   140,   442,     0,   443,   444,
     445,   446,   144,     0,     0,   447,   448,   449,   450,     0,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,     0,   462,     0,     0,     0,     0,     0,
       0,     0,     0,   463,   464,   465,   466,   467,   468,   154,
     155,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,   164,   493,   494,   166,     0,   495,     0,
     496,   168,   497,     0,   498,     0,   499,     0,   956,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   507,   508,   509,     0,   510,   511,   512,   957,   513,
     514,   515,   516,   517,   518,     0,   519,     0,   175,     0,
     520,   521,   522,     0,   177,     0,   178,     0,   523,     0,
       0,   524,     0,   525,   526,   527,   528,   529,   530,     0,
     182,     0,   531,     0,     0,   532,   533,   534,     0,     0,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   189,     0,   191,   548,   549,   550,   551,
     552,   553,   554,   192,   555,     0,   556,   557,     0,   558,
       0,   195,   559,   196,   560,   561,   562,     0,   563,     0,
       0,   564,   565,   566,     0,     0,   197,     0,     0,     0,
     201,   567,   568,   569,   570,   571,   572,     0,   573,   202,
     574,   203,   575,   576,   577,     0,   578,   579,   580,   581,
     582,   583,   584,   205,   585,   586,   587,     0,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   597,     0,   598,
     599,     0,   600,   601,   213,   602,   603,   604,   605,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,     0,
     615,   217,   616,   617,     0,   618,   220,     0,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   628,   222,   629,
       0,   630,   631,     0,   632,   633,   634,   635,   636,   637,
       0,   224,   225,     0,     0,   639,   226,   640,   227,     0,
     641,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,   655,   235,
       0,   656,     0,   657,   658,   659,     0,     0,   660,     0,
       0,   661,   662,   663,   664,   665,   238,   239,   240,   241,
     242,   243,   244,   245,   666,   667,   668,     0,     0,     0,
       0,     0,     0,     0,   962,   963,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,    45,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  1340,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,   956,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,   957,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,   562,     0,   563,     0,     0,
     564,   565,   566,     0,     0,   197,     0,     0,     0,   201,
     567,   568,   569,   570,   571,   572,     0,   573,   202,   574,
     203,   575,   576,   577,     0,   578,   579,   580,   581,   582,
     583,   584,   205,   585,   586,   587,     0,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   597,     0,   598,   599,
       0,   600,   601,   213,   602,   603,   604,   605,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,     0,   615,
     217,   616,   617,     0,   618,   220,     0,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   628,   222,   629,     0,
     630,   631,     0,   632,   633,   634,   635,   636,   637,     0,
     224,   225,     0,     0,   639,   226,   640,   227,     0,   641,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,   655,   235,     0,
     656,     0,   657,   658,   659,     0,     0,   660,     0,     0,
     661,   662,   663,   664,   665,   238,   239,   240,   241,   242,
     243,   244,   245,   666,   667,   668,     0,     0,     0,     0,
       0,     0,     0,   962,   963,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   406,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,   416,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,     0,   431,   432,   433,   135,   136,     0,
     138,   139,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,   441,   140,   442,     0,   443,   444,   445,   446,
     144,     0,     0,   447,   448,   449,   450,     0,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,     0,   462,     0,     0,     0,     0,     0,     0,     0,
       0,   463,   464,   465,   466,   467,   468,   154,   155,   469,
     690,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,   164,   493,   494,   166,     0,   495,     0,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   507,
     508,   509,     0,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   175,     0,   520,   521,
     522,     0,   177,     0,   178,     0,   523,     0,     0,   524,
       0,   525,   526,   527,   528,   529,   530,     0,   182,     0,
     531,     0,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,     0,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,     0,   556,   557,     0,   558,     0,   195,
     559,   196,   560,   561,   562,     0,   563,     0,     0,   564,
     565,   566,     0,     0,   197,     0,     0,     0,   201,   567,
     568,   569,   570,   571,   572,     0,   573,   202,   574,   203,
     575,   576,   577,     0,   578,   579,   580,   581,   582,   583,
     584,   205,   585,   586,   587,     0,   588,   589,   590,   591,
     592,   593,   594,   595,   596,   597,     0,   598,   599,     0,
     600,   601,   213,   602,   603,   604,   605,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,     0,   615,   217,
     616,   617,     0,   618,   220,     0,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   628,   222,   629,     0,   630,
     631,     0,   632,   633,   634,   635,   636,   637,     0,   224,
     225,  1500,     0,   639,   226,   640,   227,     0,   641,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,   655,   235,     0,   656,
       0,   657,   658,   659,     0,     0,   660,     0,     0,   661,
     662,   663,   664,   665,   238,   239,   240,   241,   242,   243,
     244,   245,   666,   667,   668,     0,     0,  1023,  1501,    86,
      87,    88,   403,    90,    91,    92,   404,  1024,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   406,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,     0,   431,   432,
     433,   135,   136,     0,   138,   139,     0,   434,   435,   436,
     437,   438,     0,     0,  1025,   440,  1000,   140,   442,     0,
     443,   444,   445,   446,   144,     0,     0,   447,   448,   449,
     450,     0,   451,  1026,     0,  1027,   454,   455,   456,   457,
     458,     0,   459,   460,   461,     0,   462,     0,     0,     0,
       0,     0,     0,     0,     0,   463,   464,   465,   466,   467,
     468,   154,   155,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,   164,   493,   494,   166,     0,
     495,     0,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   507,   508,   509,     0,   510,   511,   512,
       0,   513,   514,   515,   516,   517,   518,     0,   519,     0,
     175,     0,   520,   521,   522,     0,   177,     0,   178,     0,
     523,     0,     0,   524,     0,   525,   526,   527,   528,   529,
     530,     0,   182,     0,   531,     0,     0,   532,   533,  1028,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,  1029,   189,     0,   191,   548,   549,
     550,   551,   552,   553,   554,   192,   555,     0,   556,   557,
       0,   558,     0,   195,   559,   196,   560,   561,   562,     0,
     563,     0,     0,   564,   565,   566,     0,     0,   197,     0,
       0,     0,   201,   567,   568,   569,   570,   571,   572,     0,
     573,   202,   574,   203,   575,   576,   577,     0,   578,   579,
     580,   581,   582,   583,   584,   205,   585,   586,   587,     0,
     588,   589,   590,   591,   592,   593,   594,   595,   596,   597,
       0,   598,   599,     0,  1030,   601,   213,   602,   603,   604,
    1031,   606,   607,   608,   609,     0,   610,   611,   612,   613,
    1032,     0,   615,   217,   616,   617,     0,   618,   220,     0,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   628,
     222,   629,     0,   630,   631,     0,   632,   633,   634,   635,
     636,   637,     0,  1033,   225,     0,     0,  1034,   226,   640,
     227,     0,   641,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
    1004,   235,     0,   656,     0,   657,   658,   659,     0,     0,
     660,     0,     0,   661,   662,   663,   664,  1035,   238,   239,
     240,   241,   242,   243,   244,   245,   666,   667,   668,   705,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   706,
     104,   105,   406,   707,     0,   107,   108,   109,   110,   708,
     709,   112,   113,   114,   115,     0,   116,   710,   711,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,   712,   425,   426,   427,   713,   714,   715,
     716,   717,   718,   719,   428,   429,   720,   430,   133,   431,
     432,   433,   135,   136,   137,   138,   139,   721,   434,   435,
     436,   437,   438,   722,   723,   439,   440,   724,   140,   442,
     725,   443,   444,   445,   446,   144,   726,   727,   447,   448,
     449,   450,   147,   451,   728,   729,   453,   454,   455,   456,
     457,   458,   730,   459,   460,   461,   150,   462,   731,   732,
     733,   734,   151,   735,   736,   737,   463,   464,   465,   466,
     467,   468,   154,   155,   469,   738,   470,   739,   471,   472,
     473,   474,   475,   740,   476,   477,   478,   741,   742,   479,
     480,   481,   482,   483,   743,   484,   485,   486,   744,   487,
     488,   745,   489,   490,   491,   492,   164,   493,   494,   166,
     746,   495,   747,   496,   168,   497,   748,   498,   749,   499,
     169,   750,   170,   500,   501,   502,   751,   503,   172,   752,
     504,   753,   505,   506,   507,   508,   509,   173,   510,   511,
     512,   754,   513,   514,   515,   516,   517,   518,   755,   519,
     174,   175,   756,   520,   521,   522,   757,   177,   758,   178,
     759,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,   760,   182,   183,   531,   184,   761,   532,   533,
     534,   762,   763,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,   190,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,   764,   556,
     557,   194,   558,   765,   195,   559,   196,   560,   561,   562,
     766,   563,   767,   768,   564,   565,   566,   769,   770,   197,
     198,   199,   200,   201,   567,   568,   569,   570,   571,   572,
     771,   573,   202,   574,   203,   575,   576,   577,   772,   578,
     579,   580,   581,   582,   583,   584,   205,   585,   586,   587,
     773,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     597,   774,   598,   599,   211,   600,   601,   213,   602,   603,
     604,   605,   606,   607,   608,   609,   775,   610,   611,   612,
     613,   614,   776,   615,   217,   616,   617,   219,   618,   220,
     777,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     628,   222,   629,   778,   630,   631,   779,   632,   633,   634,
     635,   636,   637,   780,   224,   225,   781,   782,   639,   226,
     640,   227,   783,   641,   642,   643,   644,   645,   646,   784,
     785,   647,   648,   649,   650,   786,   787,   651,   652,   653,
     654,   788,   235,   789,   656,   236,   657,   658,   659,   790,
     791,   660,   792,   793,   661,   662,   663,   664,   665,   238,
     239,   240,   241,   242,   243,   244,   245,   666,   667,   668,
     705,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     706,   104,   105,   406,   707,     0,   107,   108,   109,   110,
     708,   709,   112,   113,   114,   115,     0,   116,   710,   711,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   417,   418,   419,   420,
    2960,   422,   423,   424,   712,   425,   426,   427,   713,   714,
     715,   716,   717,   718,   719,   428,   429,   720,   430,   133,
     431,   432,   433,   135,   136,   137,   138,   139,   721,   434,
     435,   436,   437,   438,   722,   723,   439,   440,   724,   140,
     442,   725,   443,   444,   445,   446,   144,   726,   727,   447,
     448,   449,   450,   147,   451,   728,   729,   453,   454,   455,
     456,   457,   458,   730,   459,   460,   461,   150,   462,   731,
     732,   733,   734,   151,   735,   736,   737,   463,   464,   465,
     466,   467,   468,   154,   155,   469,   738,   470,   739,   471,
     472,   473,   474,   475,   740,   476,   477,   478,   741,   742,
     479,   480,   481,  2961,   483,   743,   484,   485,   486,   744,
     487,   488,   745,   489,   490,   491,   492,   164,   493,   494,
     166,   746,   495,   747,   496,   168,   497,   748,   498,   749,
     499,   169,   750,   170,   500,   501,   502,   751,   503,   172,
     752,   504,   753,   505,   506,   507,   508,   509,   173,   510,
     511,   512,   754,   513,   514,   515,   516,   517,   518,   755,
     519,   174,   175,   756,   520,   521,   522,   757,   177,   758,
     178,   759,   523,   179,   180,   524,   181,   525,   526,   527,
     528,   529,   530,   760,   182,   183,   531,   184,   761,   532,
     533,   534,   762,   763,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   189,   190,   191,
     548,   549,   550,   551,   552,   553,   554,   192,   555,   764,
     556,   557,   194,   558,   765,   195,   559,   196,   560,   561,
     562,   766,   563,   767,   768,   564,   565,   566,   769,   770,
     197,   198,   199,   200,   201,   567,   568,   569,   570,   571,
     572,   771,   573,   202,   574,   203,   575,   576,   577,   772,
     578,   579,   580,   581,   582,   583,   584,   205,   585,   586,
     587,   773,   588,   589,   590,   591,   592,   593,   594,   595,
     596,   597,   774,   598,   599,   211,   600,   601,   213,   602,
     603,   604,   605,   606,   607,   608,   609,   775,   610,   611,
     612,   613,   614,   776,  2962,   217,   616,   617,   219,   618,
     220,   777,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   628,   222,   629,   778,   630,   631,   779,   632,   633,
     634,   635,   636,   637,   780,   224,   225,   781,   782,   639,
     226,   640,   227,   783,   641,   642,   643,   644,   645,   646,
     784,   785,   647,   648,   649,   650,   786,   787,   651,   652,
     653,   654,   788,   235,   789,   656,   236,   657,   658,   659,
     790,   791,   660,   792,   793,   661,   662,   663,   664,   665,
     238,   239,   240,   241,   242,   243,   244,   245,   666,   667,
     668,   705,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   706,   104,   105,   406,   707,     0,   107,   108,   109,
     110,   708,   709,   112,   113,   114,   115,     0,   116,   710,
     711,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,   136,   137,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,     0,     0,     0,   151,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,   182,   183,   531,   184,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,   190,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,   194,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,   198,   199,   200,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,   211,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,   219,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,   236,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,   705,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   706,   104,   105,   406,   707,     0,   107,   108,
     109,   110,   708,   709,   112,   113,   114,   115,     0,   116,
     710,   711,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,   133,   431,   432,   433,   135,   136,   137,   138,   139,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
     441,   140,   442,     0,   443,   444,   445,   446,   144,     0,
       0,   447,   448,   449,   450,   147,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,   150,
     462,     0,     0,     0,     0,   151,     0,     0,     0,   463,
     464,   465,   466,   467,   468,   154,   155,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,   164,
     493,   494,   166,     0,   495,     0,   496,   168,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   507,   508,  1272,
     173,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,   174,   175,     0,   520,   521,   522,     0,
     177,     0,   178,     0,   523,   179,   180,   524,   181,   525,
     526,   527,   528,   529,   530,     0,   182,   183,   531,   184,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   189,
     190,   191,   548,   549,   550,   551,   552,   553,   554,   192,
     555,     0,   556,   557,   194,   558,     0,   195,   559,   196,
     560,   561,   562,     0,   563,     0,     0,   564,   565,   566,
       0,     0,   197,   198,   199,   200,   201,   567,   568,   569,
     570,   571,   572,     0,   573,   202,   574,   203,   575,   576,
     577,     0,   578,   579,   580,   581,   582,   583,   584,   205,
     585,   586,   587,     0,   588,   589,   590,   591,   592,   593,
     594,   595,   596,   597,     0,   598,   599,   211,   600,   601,
     213,   602,   603,   604,   605,   606,   607,   608,   609,     0,
     610,   611,   612,   613,   614,     0,   615,   217,   616,   617,
     219,   618,   220,     0,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   222,   629,     0,   630,   631,     0,
     632,   633,   634,   635,   636,   637,     0,   224,   225,     0,
       0,   639,   226,   640,   227,     0,   641,   642,   643,   644,
     645,   646,     0,     0,   647,   648,   649,   650,     0,     0,
     651,   652,   653,   654,   655,   235,     0,   656,   236,   657,
     658,   659,     0,     0,   660,     0,     0,   661,   662,   663,
     664,   665,   238,   239,   240,   241,   242,   243,   244,   245,
     666,   667,   668,   705,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   706,   104,   105,   406,   707,     0,   107,
     108,   109,   110,   708,   709,   112,   113,   114,   115,     0,
     116,   710,   711,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,   136,   137,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,     0,     0,     0,   151,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
    1280,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,   182,   183,   531,
     184,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,   190,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,   194,   558,     0,   195,   559,
     196,   560,   561,   562,     0,   563,     0,     0,   564,   565,
     566,     0,     0,   197,   198,   199,   200,   201,   567,   568,
     569,   570,   571,   572,     0,   573,   202,   574,   203,   575,
     576,   577,     0,   578,   579,   580,   581,   582,   583,   584,
     205,   585,   586,   587,     0,   588,   589,   590,   591,   592,
     593,   594,   595,   596,   597,     0,   598,   599,   211,   600,
     601,   213,   602,   603,   604,   605,   606,   607,   608,   609,
       0,   610,   611,   612,   613,   614,     0,   615,   217,   616,
     617,   219,   618,   220,     0,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   628,   222,   629,     0,   630,   631,
       0,   632,   633,   634,   635,   636,   637,     0,   224,   225,
       0,     0,   639,   226,   640,   227,     0,   641,   642,   643,
     644,   645,   646,     0,     0,   647,   648,   649,   650,     0,
       0,   651,   652,   653,   654,   655,   235,     0,   656,   236,
     657,   658,   659,     0,     0,   660,     0,     0,   661,   662,
     663,   664,   665,   238,   239,   240,   241,   242,   243,   244,
     245,   666,   667,   668,   705,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   706,   104,   105,   406,   707,     0,
     107,   108,   109,   110,   708,   709,   112,   113,   114,   115,
       0,   116,   710,   711,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,   133,   431,   432,   433,     0,  1784,   137,
    1785,  1786,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,  1787,  1788,   442,     0,   443,   444,   445,   446,
       0,     0,     0,   447,   448,   449,   450,   147,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,   150,   462,     0,     0,     0,     0,   151,     0,     0,
       0,   463,   464,   465,   466,   467,   468,  1789,  1790,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,  1419,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,     0,   493,   494,     0,     0,   495,     0,   496,  1791,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,     0,     0,   504,     0,   505,   506,   507,
     508,   509,   173,   510,   511,   512,  2302,   513,   514,   515,
     516,   517,   518,     0,   519,   174,  2303,     0,   520,   521,
     522,  1425,  1792,     0,  1793,     0,   523,   179,   180,   524,
     181,   525,   526,   527,   528,   529,   530,     0,     0,   183,
     531,   184,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,  1794,   190,  1795,   548,   549,   550,   551,   552,   553,
     554,     0,   555,     0,   556,   557,   194,   558,     0,     0,
     559,  1796,   560,   561,   562,     0,   563,     0,     0,   564,
     565,   566,     0,     0,  2304,   198,   199,   200,     0,   567,
     568,   569,   570,   571,   572,     0,   573,     0,   574,     0,
     575,   576,   577,     0,   578,   579,   580,   581,   582,   583,
     584,  1797,   585,   586,   587,     0,   588,   589,   590,   591,
     592,   593,   594,   595,   596,   597,     0,   598,   599,   211,
     600,   601,     0,   602,   603,   604,   605,   606,   607,   608,
     609,     0,   610,   611,   612,   613,   614,     0,   615,  2305,
     616,   617,   219,   618,  1799,     0,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   628,     0,   629,     0,   630,
     631,     0,   632,   633,   634,   635,   636,   637,     0,  1800,
    1801,     0,     0,   639,     0,   640,     0,     0,   641,   642,
     643,   644,   645,   646,     0,     0,   647,   648,   649,   650,
       0,     0,   651,   652,   653,   654,     0,  1802,  2306,   656,
     236,   657,   658,   659,     0,     0,   660,     0,     0,   661,
     662,   663,   664,   665,     0,     0,     0,     0,     0,     0,
       0,     0,   666,   667,   668,   705,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   706,   104,   105,   406,   707,
       0,   107,   108,   109,   110,   708,   709,   112,   113,   114,
     115,     0,   116,   710,   711,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,     0,  1784,
     137,  1785,  1786,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,  1787,  1788,   442,     0,   443,   444,   445,
     446,     0,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,     0,     0,     0,   151,     0,
       0,     0,   463,   464,   465,   466,   467,   468,  1789,  1790,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,     0,   493,   494,     0,     0,   495,     0,   496,
    1791,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,     0,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,     0,     0,   520,
     521,   522,  1425,  1792,     0,  1793,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,     0,
     183,   531,   184,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1794,   190,  1795,   548,   549,   550,   551,   552,
     553,   554,     0,   555,     0,   556,   557,   194,   558,  2294,
       0,   559,  1796,   560,   561,   562,     0,   563,     0,     0,
     564,   565,   566,     0,     0,     0,   198,   199,   200,     0,
     567,   568,   569,   570,   571,   572,     0,   573,     0,   574,
       0,   575,   576,   577,     0,   578,   579,   580,   581,   582,
     583,   584,  1797,   585,   586,   587,     0,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   597,     0,   598,   599,
     211,   600,   601,     0,   602,   603,   604,   605,   606,   607,
     608,   609,     0,   610,   611,   612,   613,   614,     0,   615,
    2305,   616,   617,   219,   618,  1799,     0,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   628,     0,   629,     0,
     630,   631,  3580,   632,   633,   634,   635,   636,   637,     0,
    1800,  1801,     0,     0,   639,     0,   640,     0,     0,   641,
     642,   643,   644,   645,   646,     0,     0,   647,   648,   649,
     650,     0,     0,   651,   652,   653,   654,     0,  1802,     0,
     656,   236,   657,   658,   659,     0,     0,   660,     0,     0,
     661,   662,   663,   664,   665,     0,     0,     0,     0,     0,
       0,     0,     0,   666,   667,   668,   705,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   706,   104,   105,   406,
     707,     0,   107,   108,   109,   110,   708,   709,   112,   113,
     114,   115,     0,   116,   710,   711,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,     0,     0,
       0,   428,   429,     0,   430,   133,   431,   432,   433,     0,
    1784,   137,  1785,  1786,     0,   434,   435,   436,   437,   438,
       0,     0,   439,   440,  1787,  1788,   442,     0,   443,   444,
     445,   446,     0,     0,     0,   447,   448,   449,   450,   147,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,   150,   462,     0,     0,     0,     0,   151,
       0,     0,     0,   463,   464,   465,   466,   467,   468,  1789,
    1790,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,  1419,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,     0,   493,   494,     0,     0,   495,     0,
     496,  1791,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,     0,     0,   504,     0,   505,
     506,   507,   508,   509,   173,   510,   511,   512,     0,   513,
     514,   515,   516,   517,   518,     0,   519,   174,     0,     0,
     520,   521,   522,  1425,  1792,     0,  1793,     0,   523,   179,
     180,   524,   181,   525,   526,   527,   528,   529,   530,     0,
       0,   183,   531,   184,     0,   532,   533,   534,     0,     0,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,  1794,   190,  1795,   548,   549,   550,   551,
     552,   553,   554,  2347,   555,     0,   556,   557,   194,   558,
       0,     0,   559,  1796,   560,   561,   562,     0,   563,     0,
       0,   564,   565,   566,     0,     0,     0,   198,   199,   200,
       0,   567,   568,   569,   570,   571,   572,     0,   573,     0,
     574,     0,   575,   576,   577,     0,   578,   579,   580,   581,
     582,   583,   584,  1797,   585,   586,   587,     0,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   597,     0,   598,
     599,   211,   600,   601,     0,   602,   603,   604,   605,   606,
     607,   608,   609,     0,   610,   611,   612,   613,   614,     0,
     615,  1798,   616,   617,   219,   618,  1799,     0,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   628,     0,   629,
       0,   630,   631,     0,   632,   633,   634,   635,   636,   637,
       0,  1800,  1801,     0,     0,   639,     0,   640,     0,     0,
     641,   642,   643,   644,   645,   646,     0,     0,   647,   648,
     649,   650,     0,     0,   651,   652,   653,   654,     0,  1802,
       0,   656,   236,   657,   658,   659,     0,     0,   660,     0,
       0,   661,   662,   663,   664,   665,     0,     0,     0,     0,
       0,     0,     0,     0,   666,   667,   668,   705,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   706,   104,   105,
     406,   707,     0,   107,   108,   109,   110,   708,   709,   112,
     113,   114,   115,     0,   116,   710,   711,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
       0,  1784,   137,  1785,  1786,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,  1787,  1788,   442,     0,   443,
     444,   445,   446,     0,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,     0,     0,     0,
     151,     0,     0,     0,   463,   464,   465,   466,   467,   468,
    1789,  1790,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,     0,   493,   494,     0,     0,   495,
       0,   496,  1791,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,     0,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,     0,
       0,   520,   521,   522,  1425,  1792,     0,  1793,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,     0,   183,   531,   184,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1794,   190,  1795,   548,   549,   550,
     551,   552,   553,   554,  3427,   555,     0,   556,   557,   194,
     558,     0,     0,   559,  1796,   560,   561,   562,     0,   563,
       0,     0,   564,   565,   566,     0,     0,     0,   198,   199,
     200,     0,   567,   568,   569,   570,   571,   572,     0,   573,
       0,   574,     0,   575,   576,   577,     0,   578,   579,   580,
     581,   582,   583,   584,  1797,   585,   586,   587,     0,   588,
     589,   590,   591,   592,   593,   594,   595,   596,   597,     0,
     598,   599,   211,   600,   601,     0,   602,   603,   604,   605,
     606,   607,   608,   609,     0,   610,   611,   612,   613,   614,
       0,   615,  1798,   616,   617,   219,   618,  1799,     0,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   628,     0,
     629,     0,   630,   631,     0,   632,   633,   634,   635,   636,
     637,     0,  1800,  1801,     0,     0,   639,     0,   640,     0,
       0,   641,   642,   643,   644,   645,   646,     0,     0,   647,
     648,   649,   650,     0,     0,   651,   652,   653,   654,     0,
    1802,     0,   656,   236,   657,   658,   659,     0,     0,   660,
       0,     0,   661,   662,   663,   664,   665,     0,     0,     0,
       0,     0,     0,     0,     0,   666,   667,   668,   705,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   706,   104,
     105,   406,   707,     0,   107,   108,   109,   110,   708,   709,
     112,   113,   114,   115,     0,   116,   710,   711,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,   133,   431,   432,
     433,     0,  1784,   137,  1785,  1786,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,  1787,  1788,   442,     0,
     443,   444,   445,   446,     0,     0,     0,   447,   448,   449,
     450,   147,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,   150,   462,     0,     0,     0,
       0,   151,     0,     0,     0,   463,   464,   465,   466,   467,
     468,  1789,  1790,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
    1419,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,     0,   493,   494,     0,     0,
     495,     0,   496,  1791,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,     0,     0,   504,
       0,   505,   506,   507,   508,   509,   173,   510,   511,   512,
       0,   513,   514,   515,   516,   517,   518,     0,   519,   174,
       0,     0,   520,   521,   522,  1425,  1792,     0,  1793,     0,
     523,   179,   180,   524,   181,   525,   526,   527,   528,   529,
     530,     0,     0,   183,   531,   184,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,  1794,   190,  1795,   548,   549,
     550,   551,   552,   553,   554,     0,   555,     0,   556,   557,
     194,   558,     0,     0,   559,  1796,   560,   561,   562,     0,
     563,     0,     0,   564,   565,   566,     0,     0,     0,   198,
     199,   200,     0,   567,   568,   569,   570,   571,   572,     0,
     573,     0,   574,     0,   575,   576,   577,     0,   578,   579,
     580,   581,   582,   583,   584,  1797,   585,   586,   587,     0,
     588,   589,   590,   591,   592,   593,   594,   595,   596,   597,
       0,   598,   599,   211,   600,   601,     0,   602,   603,   604,
     605,   606,   607,   608,   609,     0,   610,   611,   612,   613,
     614,     0,   615,  1798,   616,   617,   219,   618,  1799,     0,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   628,
       0,   629,     0,   630,   631,     0,   632,   633,   634,   635,
     636,   637,     0,  1800,  1801,     0,     0,   639,     0,   640,
       0,     0,   641,   642,   643,   644,   645,   646,     0,     0,
     647,   648,   649,   650,     0,     0,   651,   652,   653,   654,
       0,  1802,     0,   656,   236,   657,   658,   659,     0,     0,
     660,     0,     0,   661,   662,   663,   664,   665,     0,     0,
       0,     0,     0,     0,     0,     0,   666,   667,   668,   705,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   706,
     104,   105,   406,   707,     0,   107,   108,   109,   110,   708,
     709,   112,   113,   114,   115,     0,   116,   710,   711,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,     0,  1784,   137,  1785,  1786,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,  1787,  1788,   442,
       0,   443,   444,   445,   446,     0,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,     0,
       0,     0,   151,     0,     0,     0,   463,   464,   465,   466,
     467,   468,  1789,  1790,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,     0,   493,   494,     0,
       0,   495,     0,   496,  1791,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,     0,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,     0,     0,   520,   521,   522,  1425,  1792,     0,  1793,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,     0,   183,   531,   184,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1794,   190,  1795,   548,
     549,   550,   551,   552,   553,   554,     0,   555,     0,   556,
     557,   194,   558,     0,     0,   559,  1796,   560,   561,   562,
       0,   563,     0,     0,   564,   565,   566,     0,     0,     0,
     198,   199,   200,     0,   567,   568,   569,   570,   571,   572,
       0,   573,     0,   574,     0,   575,   576,   577,     0,   578,
     579,   580,   581,   582,   583,   584,  1797,   585,   586,   587,
       0,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     597,     0,   598,   599,   211,   600,   601,     0,   602,   603,
     604,   605,   606,   607,   608,   609,     0,   610,   611,   612,
     613,   614,     0,   615,  2305,   616,   617,   219,   618,  1799,
       0,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     628,     0,   629,     0,   630,   631,     0,   632,   633,   634,
     635,   636,   637,     0,  1800,  1801,     0,     0,   639,     0,
     640,     0,     0,   641,   642,   643,   644,   645,   646,     0,
       0,   647,   648,   649,   650,     0,     0,   651,   652,   653,
     654,     0,  1802,     0,   656,   236,   657,   658,   659,     0,
       0,   660,     0,     0,   661,   662,   663,   664,   665,     0,
       0,     0,     0,     0,     0,     0,     0,   666,   667,   668,
     705,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     706,   104,   105,   406,   707,     0,   107,   108,   109,   110,
     708,   709,   112,   113,   114,   115,     0,   116,   710,   711,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,   133,
     431,   432,   433,     0,  1784,   137,  1785,  1786,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,  1787,  1788,
     442,     0,   443,   444,   445,   446,     0,     0,     0,   447,
     448,   449,   450,   147,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,   150,   462,     0,
       0,     0,     0,   151,     0,     0,     0,   463,   464,   465,
     466,   467,   468,  1789,  1790,   469,     0,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,  1419,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,     0,   493,   494,
       0,     0,   495,     0,   496,  1791,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,     0,
       0,   504,     0,   505,   506,   507,   508,   509,   173,   510,
     511,   512,     0,   513,   514,   515,   516,   517,   518,     0,
     519,   174,     0,     0,   520,   521,   522,  1425,  1792,     0,
    1793,     0,   523,   179,   180,   524,   181,   525,   526,   527,
     528,   529,   530,     0,     0,   183,   531,   184,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,  1794,   190,  1795,
     548,   549,   550,   551,   552,   553,   554,     0,   555,     0,
     556,   557,   194,   558,     0,     0,   559,  1796,   560,   561,
     562,     0,   563,     0,     0,   564,   565,   566,     0,     0,
       0,   198,   199,   200,     0,   567,   568,   569,   570,   571,
     572,     0,   573,     0,   574,     0,   575,   576,   577,     0,
     578,   579,   580,   581,   582,   583,   584,  1797,   585,   586,
     587,     0,   588,   589,   590,   591,   592,   593,   594,   595,
     596,   597,     0,   598,   599,   211,   600,   601,     0,   602,
     603,   604,   605,   606,   607,   608,   609,     0,   610,   611,
     612,   613,   614,     0,   615,     0,   616,   617,   219,   618,
    1799,     0,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   628,     0,   629,     0,   630,   631,     0,   632,   633,
     634,   635,   636,   637,     0,  1800,  1801,     0,     0,   639,
       0,   640,     0,     0,   641,   642,   643,   644,   645,   646,
       0,     0,   647,   648,   649,   650,     0,     0,   651,   652,
     653,   654,     0,  1802,     0,   656,   236,   657,   658,   659,
       0,     0,   660,     0,     0,   661,   662,   663,   664,   665,
       0,     0,     0,     0,     0,     0,     0,     0,   666,   667,
     668,   705,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   706,   104,   105,   406,   707,     0,   107,   108,   109,
     110,   708,   709,   112,   113,   114,   115,     0,   116,   710,
     711,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,     0,     0,   137,     0,     0,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,     0,
       0,   442,     0,   443,   444,   445,   446,     0,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,     0,     0,     0,   151,     0,     0,     0,   463,   464,
     465,   466,   467,   468,     0,     0,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,     0,   493,
     494,     0,     0,   495,     0,   496,     0,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,     0,     0,   520,   521,   522,     0,     0,
       0,     0,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,     0,   183,   531,   184,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,     0,   190,
       0,   548,   549,   550,   551,   552,   553,   554,     0,   555,
       0,   556,   557,   194,   558,     0,     0,   559,     0,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,     0,   198,   199,   200,     0,   567,   568,   569,   570,
     571,   572,     0,   573,     0,   574,     0,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,     0,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,   211,   600,   601,     0,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,     0,   616,   617,   219,
     618,     0,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,     0,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,     0,     0,     0,     0,
     639,     0,   640,     0,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,     0,     0,     0,   656,   236,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,     0,     0,     0,     0,     0,     0,     0,     0,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,   712,   425,   426,   427,   713,
     714,   715,   716,   717,   718,   719,   428,   429,   720,   430,
     133,   431,   432,   433,   135,   136,   137,   138,   139,   721,
     434,   435,   436,   437,   438,   722,   723,   439,   440,     0,
     140,   442,   725,   443,   444,   445,   446,   144,   726,   727,
     447,   448,   449,   450,   147,   451,   728,   729,   453,   454,
     455,   456,   457,   458,   730,   459,   460,   461,   150,   462,
       0,   732,   733,   734,   151,   735,   736,   737,   463,   464,
     465,   466,     0,   468,   154,   155,   469,   738,   470,   739,
     471,   472,   473,   474,   475,   740,   476,   477,   478,   741,
     742,   479,   480,   481,   482,   483,   743,   484,   485,   486,
     744,   487,   488,   745,   489,   490,   491,   492,   164,   493,
     494,   166,   746,   495,   747,   496,   168,   497,   748,   498,
     749,   499,   169,   750,   170,   500,   501,   502,   751,   503,
     172,   752,   504,   753,   505,   506,     0,   508,   509,   173,
     510,   511,   512,   754,   513,   514,   515,   516,   517,   518,
     755,   519,   174,   175,     0,   520,   521,   522,     0,   177,
     758,   178,   759,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,   760,   182,   183,   531,   184,   761,
     532,   533,   534,   762,   763,   535,   536,   537,   538,   539,
     540,     0,   542,   543,     0,   545,   546,   547,   189,   190,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
     764,   556,   557,   194,   558,   765,   195,   559,   196,   560,
     561,   562,   766,   563,   767,   768,   564,   565,   566,   769,
     770,   197,   198,   199,   200,   201,   567,   568,   569,   570,
     571,   572,   771,   573,   202,   574,   203,   575,   576,   577,
     772,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,   773,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   774,   598,   599,   211,   600,   601,   213,
     602,   603,   604,   605,   606,   607,     0,   609,   775,   610,
     611,   612,   613,   614,   776,   615,   217,   616,   617,   219,
     618,   220,   777,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,   778,   630,   631,   779,   632,
     633,   634,   635,   636,   637,   780,   224,   225,     0,   782,
     639,   226,   640,   227,   783,   641,   642,   643,   644,   645,
     646,     0,   785,   647,   648,   649,   650,   786,   787,   651,
     652,   653,   654,     0,   235,   789,   656,   236,   657,   658,
     659,   790,   791,   660,   792,   793,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,     0,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    4459,     0,    45,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,  1927,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,  1928,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,  1929,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,   638,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,  1111,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,  2125,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,  2273,   443,   444,   445,   446,   144,     0,  2317,
     447,   448,   449,   450,     0,   451,   452,  2274,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,  2318,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
    2276,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
    2277,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,  2278,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,  2273,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,  2274,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,  2318,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
    2276,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,  3081,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
    2277,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,  2278,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,  1013,   423,   424,   971,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,   972,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,  1014,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,   973,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,   974,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1907,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,   971,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,   972,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,  2853,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,   973,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,   974,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,  2273,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,  2274,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,  2318,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
    2276,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
    2277,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,  2278,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,   688,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
     689,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,   690,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,   971,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,   972,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,   973,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,   974,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
     888,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,   889,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   890,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,  1962,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,  1963,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
    1964,   499,     0,     0,     0,  1965,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,  1966,
    1967,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,  1968,   606,   607,   608,   609,     0,  1969,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,  1970,   632,
    1971,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,   972,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,   973,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,   974,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,   130,
     131,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,  1325,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
    1951,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,  2235,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,  2743,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,  2744,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,  2745,   632,
     633,  2746,   635,  2747,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,   697,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,   690,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,   843,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,  1263,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,  2392,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,  2393,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,   130,
     131,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,  2897,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,  2898,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,  2909,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,  2910,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   894,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     935,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     989,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,  1044,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,  1503,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
    1859,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
    1951,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,  2235,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,  3118,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,  3131,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,  3173,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,  3885,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,  3887,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,  3889,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,  4045,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   997,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,   999,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,  1000,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,     0,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,  1001,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,  1002,   225,     0,     0,
    1003,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,  1004,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,  1038,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,  1000,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,     0,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,  1039,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,  1040,   225,     0,     0,
    1041,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,  1004,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,  1060,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,  1183,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,  1246,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1277,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1282,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1290,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1292,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1294,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1296,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1299,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1301,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,  1302,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1305,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
    1514,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,  1025,   440,  1000,
     140,  1515,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,     0,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,  1029,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,  1030,   601,   213,
     602,   603,   604,  1031,   606,   607,   608,   609,     0,   610,
     611,   612,   613,  1507,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,  1033,   225,     0,     0,
    1034,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,  1004,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
    1035,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,  1537,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,     0,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,  1637,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1885,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  1887,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,  2001,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  2524,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  2900,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,  2902,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
     602,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,  1025,   440,  1000,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,     0,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,  1029,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,  1030,   601,   213,
     602,   603,   604,  1031,   606,   607,   608,   609,     0,   610,
     611,   612,   613,  1507,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,  1033,   225,     0,     0,
    1034,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,  1004,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
    1035,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,  1025,   440,  1000,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,     0,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,  1029,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,  1030,   601,   213,
     602,   603,   604,  1031,   606,   607,   608,   609,     0,   610,
     611,   612,   613,  1507,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
    2264,   634,   635,   636,   637,     0,  1033,   225,     0,     0,
    1034,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,  1004,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
    1035,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,  1025,   440,  1000,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,     0,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,  1029,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
     571,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,   583,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,  1030,   601,   213,
     602,   603,   604,  2298,   606,   607,   608,   609,     0,   610,
     611,   612,   613,  1507,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,  1033,   225,     0,     0,
    1034,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,  1004,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
    1035,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,   562,     0,   563,     0,     0,   564,   565,   566,     0,
       0,   197,     0,     0,     0,   201,   567,   568,   569,   570,
       0,   572,     0,   573,   202,   574,   203,   575,   576,   577,
       0,   578,   579,   580,   581,   582,     0,   584,   205,   585,
     586,   587,     0,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,     0,   598,   599,     0,   600,   601,   213,
       0,   603,   604,   605,   606,   607,   608,   609,     0,   610,
     611,   612,   613,   614,     0,   615,   217,   616,   617,     0,
     618,   220,     0,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   628,   222,   629,     0,   630,   631,     0,   632,
     633,   634,   635,   636,   637,     0,   224,   225,     0,     0,
     639,   226,   640,   227,     0,   641,   642,   643,   644,   645,
     646,     0,     0,   647,   648,   649,   650,     0,     0,   651,
     652,   653,   654,   655,   235,     0,   656,     0,   657,   658,
     659,     0,     0,   660,     0,     0,   661,   662,   663,   664,
     665,   238,   239,   240,   241,   242,   243,   244,   245,   666,
     667,   668,    86,    87,    88,     0,    90,    91,    92,     0,
       0,     0,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,     0,     0,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115, -2157,   116,   117,
     118,     0,     0,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,   127,    35,     0,   398,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     133,     0,     0,     0,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,     0,     0,     0,     0,   144,     0,     0,
       0,     0,     0,     0,   147,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   150,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   154,   155,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   162,     0,     0,     0,     0,     0,     0,   164,     0,
       0,   166,     0,     0,     0,     0,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,     0,     0,
     172,     0,     0,     0,     0,     0,     0,     0,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   174,   175,     0,     0,     0,     0,     0,   177,
       0,   178,     0,     0,   179,   180,     0,   181,     0,     0,
       0,     0,     0,     0,     0,   182,   183,     0,   184,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   189,   190,
     191,     0,     0,     0,     0,     0,     0,     0,   192,     0,
       0,     0,     0,   194,     0,     0,   195,     0,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   197,   198,   199,   200,   201,     0,     0,     0,     0,
       0,     0,     0,     0,   202,     0,   203,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   205,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   211,     0,     0,   213,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   217,     0,     0,   219,
       0,   220,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   224,   225,     0,     0,
       0,   226,     0,   227,     0,     0,     0,     0,     0,     0,
       0,   230,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   235,     0,     0,   236,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   238,   239,   240,   241,   242,   243,   244,   245,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115, -2158,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,   127,    35,     0,  1106,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,     0,     0,     0,     0,
       0,   147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   150,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   154,   155,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,   164,     0,     0,   166,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   172,     0,     0,
       0,     0,     0,     0,     0,     0,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   174,
     175,     0,     0,     0,     0,     0,   177,     0,   178,     0,
       0,   179,   180,     0,   181,     0,     0,     0,     0,     0,
       0,     0,   182,   183,     0,   184,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
       0,     0,     0,     0,     0,   192,     0,     0,     0,     0,
     194,     0,     0,   195,     0,   196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   197,   198,
     199,   200,   201,     0,     0,     0,     0,     0,     0,     0,
       0,   202,     0,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   205,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   211,     0,     0,   213,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   217,     0,     0,   219,     0,   220,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   224,   225,     0,     0,     0,   226,     0,
     227,     0,     0,     0,     0,     0,     0,     0,   230,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   235,     0,     0,   236,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   238,   239,
     240,   241,   242,   243,   244,   245,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115,     0,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,     0,     0,   147,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   154,   155,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,   164,     0,     0,   166,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   177,     0,   178,     0,     0,   179,   180,
       0,   181,     0,     0,     0,     0,     0,     0,     0,   182,
     183,     0,   184,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   189,   190,   191,     0,     0,     0,     0,     0,
       0,     0,   192,     0,     0,     0,     0,   194,     0,     0,
     195,     0,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   197,   198,   199,   200,   201,
       0,     0,     0,     0,     0,     0,     0,     0,   202,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   213,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,   225,     0,     0,     0,   226,     0,   227,     0,     0,
       0,     0,     0,     0,     0,   230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   235,     0,
       0,   236,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   238,   239,   240,   241,   242,
     243,   244,   245,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115,     0,   116,
     117,   118,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,     0,   147,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   150,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   154,   155,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,   164,
       0,     0,   166,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     177,     0,   178,     0,     0,   179,   180,     0,   181,     0,
       0,     0,     0,     0,     0,     0,   182,   183,     0,   184,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   189,
     190,   191,     0,     0,     0,     0,     0,     0,     0,   192,
       0,     0,     0,     0,   194,     0,     0,   195,     0,   196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   197,   198,   199,   200,   201,     0,     0,     0,
       0,     0,     0,     0,     0,   202,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,     0,     0,
     219,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   224,   225,     0,
       0,     0,   226,     0,   227,     0,     0,     0,     0,     0,
       0,     0,   230,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   235,     0,     0,   236,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   238,   239,   240,   241,   242,   243,   244,   245,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
       0,     0,   147,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   150,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   154,   155,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   164,     0,     0,   166,
       0,     0,     0,     0,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,   173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     174,   175,     0,     0,     0,     0,     0,   177,     0,   178,
       0,     0,   179,   180,     0,   181,     0,     0,     0,     0,
       0,     0,     0,   182,   183,     0,   184,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   189,   190,   191,     0,
       0,     0,     0,     0,     0,     0,   192,     0,     0,     0,
       0,   194,     0,     0,   195,     0,   196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   197,
     198,   199,   200,   201,     0,     0,     0,     0,     0,     0,
       0,     0,   202,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   211,     0,     0,   213,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   217,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   224,   225,     0,     0,     0,   226,
       0,   227,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   235,     0,     0,   236,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   238,
     239,   240,   241,   242,   243,   244,   245
};

static const short yycheck[] =
{
       2,   246,    78,  1027,    78,   826,    78,    78,   864,   167,
     210,  1119,   153,   351,  1379,   816,  1288,    78,  1281,   973,
     974,   822,  1077,    84,   978,     2,  1075,   152,  1360,  1142,
     188,  1694,  1329,  1678,  1174,   149,   117,  1870,  1191,  1295,
    1656,  1909,  1042,   864,  1184,   165,  1798,  1965,  1148,  1245,
    1306,   901,   853,   228,    78,   703,   117,  1916,   366,   915,
      84,     2,  1392,   204,   171,  2346,  1814,  2620,  1684,    78,
    1446,  1734,  1735,  2893,   366,  1034,  1534,  1728,  1417,  1418,
    2114,   162,  1589,  1590,  1591,  1847,  1226,    89,   132,  1222,
    3105,  1231,  2310,  2311,   915,  1833,   223,  1436,  1238,  2757,
    1833,   162,   353,   210,   905,   232,  2960,  1247,  2962,  1558,
    1100,   912,  2508,  1678,  2160,  1833,  1833,  1833,  1833,   160,
    2004,    78,   704,  1119,  2594,   339,  3351,    84,  3059,  2755,
    2513,  2514,   216,  3380,  3025,  2519,  1722,  3581,   167,   148,
    1273,  1684,   940,  1905,  2171,   353,  1646,  3767,  1342,   230,
     152,  1584,  1585,  1320,  2209,  3591,   165,   159,  1153,   188,
     117,  1311,  3555,    30,    94,  2166,  1072,  1157,  3059,   230,
    3528,  2452,    10,  1149,  1072,  3773,  1407,  1408,  1114,  1115,
    1030,    21,    88,   108,   186,  1643,  3039,  3040,  3041,  3042,
    3043,  3044,  3244,  2248,   127,     8,   127,  2252,    11,    12,
      72,  1432,   132,   147,    88,   162,   932,   113,  1184,    22,
      23,    24,    88,    26,    27,   810,   117,   120,    31,    32,
      33,   205,   152,   153,  2753,  2754,   167,    84,  3559,   188,
    2426,   181,   134,   163,    14,    89,   143,   246,  4154,   127,
     888,  3608,    78,  3610,   266,   127,    29,   188,  4047,  4048,
    2531,   112,  2533,    75,    76,    77,    78,    37,   103,   104,
      82,   162,    93,    78,    99,  3922,  1220,    78,    90,   174,
     324,   106,    78,   230,   204,   210,   334,    72,    84,    72,
     154,    99,   358,   117,   358,   227,   358,   358,    81,  4147,
     227,    86,    72,    86,   118,    75,    76,    77,    78,   327,
     180,    81,    82,    83,    84,   366,    86,   230,   112,   222,
     200,   117,   100,   167,    75,    76,    77,    78,  2066,   356,
    1320,    82,    78,   266,    75,    76,    77,    78,   162,   230,
     229,    82,    72,   227,   188,   295,   383,   158,  1759,  1329,
     401,    81,   366,   218,   353,   434,    86,    99,   500,   358,
    1206,    75,    76,    77,    78,   507,   162,  4409,    82,    14,
     233,   174,   270,   229,    99,  1518,   247,    75,    76,    77,
      78,   106,   162,  1568,    82,  1488,  1024,   401,    78,   210,
    2435,   226,   471,   228,   186,  1206,    75,    76,    77,    78,
     174,   257,    72,    82,   227,  1196,   230,   181,    75,    76,
      77,    78,  1203,   209,   117,    82,    86,   227,   283,   366,
     216,   232,   218,    90,    38,   117,    40,    25,  3776,   243,
     228,  4473,     0,   247,   230,  1801,    75,    76,    77,    78,
     390,   330,    99,    82,  1855,    75,    76,    77,    78,   106,
     230,   193,    82,   376,   401,   376,    25,   505,   502,   162,
    1789,  1790,  1253,   361,  1304,   502,    95,  1796,   282,   372,
     162,    75,    76,    77,    78,   502,   401,   266,    82,   266,
    3503,   394,   402,   261,   502,   258,    90,    75,    76,    77,
      78,  4138,   504,  1483,    82,   134,  3417,   300,   376,  4109,
     432,   396,   181,   452,   376,   266,   209,  1769,  4356,   443,
     423,   375,  1765,   216,   812,   218,    88,   209,    75,    76,
      77,    78,  4311,   638,   216,    82,   218,   230,   502,  4435,
     812,  3374,   358,  1523,  1524,   432,  3417,  1517,   230,   347,
     314,  1521,  1522,  1331,  1116,  1117,   134,   350,   227,   489,
    3898,  1136,    95,   358,   401,   686,   687,   358,    75,    76,
      77,    78,   383,  2305,   434,    82,  1787,  1788,   419,   198,
     366,   102,   505,    90,  1795,   502,    75,    76,    77,    78,
     401,   406,   505,    82,   505,   465,  2857,   502,  1718,   403,
    1720,    90,  3940,  1309,   456,  1781,    75,    76,    77,    78,
    3957,   471,   498,    82,  3925,   401,    89,  2598,  4218,   502,
     502,    94,   358,    96,  1757,  3134,  3658,   425,   181,   427,
    4208,   505,   452,   106,   498,   419,   461,  1873,   456,   495,
     496,   497,   498,   505,   505,  1957,  1882,   411,   441,  1762,
     414,   505,   505,   500,  1890,  1891,   638,  2288,  1778,   132,
      75,    76,    77,    78,    85,   198,  2104,    82,   450,   142,
    2108,  3309,  1908,   324,   262,   452,   496,  3510,   358,   152,
     153,   412,   413,   156,  1514,  2310,  2884,  1603,  2886,  1575,
     163,   406,   505,  1663,   167,  2508,   469,  1575,    88,  1669,
     502,   452,  1677,   262,  4042,   505,   268,   227,  3314,   210,
     314,  2692,  4050,   818,   502,   188,   941,  4317,   493,   494,
     493,   494,   341,   113,   149,   832,   505,   502,   638,   506,
     235,   204,   306,   493,   494,   158,  1816,    95,   502,  4155,
    1710,  3002,  3003,  1713,  1714,  3121,  2781,   808,   942,  3125,
    4123,  1707,   857,   181,  2768,   383,   111,  1075,  1320,   406,
     151,   502,   306,   432,  1938,   190,   470,   808,    88,   890,
    1944,   812,    14,   493,   494,  1922,   686,   687,  4378,  2786,
     399,  2261,   410,  1913,   488,    75,    76,    77,    78,   896,
     181,  4101,    82,   703,  2317,   329,  1766,  2210,   502,  2212,
      75,    76,    77,    78,   909,   174,   176,    82,   812,   232,
     328,   432,   500,   951,   502,   953,   504,   955,  2029,  2030,
     489,  2997,   183,   961,  3000,  3001,   847,  3025,  3004,     5,
    4134,   460,   175,   493,   494,   504,   140,   370,  3014,   392,
     198,   941,   266,   937,   229,   502,   149,   985,   986,    25,
     470,   502,   373,  4453,  3867,  3868,  3869,  3870,  3871,    35,
    4284,  3059,  2037,   461,   385,   266,   848,  1703,   488,   422,
     240,   808,  2497,   502,   228,   812,   381,   984,    75,    76,
      77,    78,   502,   270,   505,    82,   314,   190,    71,    72,
     207,   246,    75,    76,    77,    78,    79,    80,    81,    82,
     401,   183,  1703,    86,   457,  3103,   266,   250,   502,   330,
     484,   455,   432,   460,    99,   436,   469,   342,  1852,   901,
     902,  2157,  2488,   314,   502,   295,   334,   808,   298,   402,
    4240,   493,   494,   495,   496,   497,   498,   306,  2751,   473,
    1920,  1048,   186,   136,   953,  3940,   955,   264,   268,   502,
     932,   940,   941,   314,   377,   502,  1056,   133,   151,   387,
     145,   127,   186,   328,  1028,  1969,  1970,   152,  1032,   489,
    4274,   383,   364,   181,   361,   932,   985,   986,   888,  4206,
     890,  3345,    72,   341,   504,    75,    76,    77,    78,   343,
     176,    81,    82,   374,   808,   502,    86,   182,   181,    95,
     385,   426,  1026,   295,   198,   101,   298,   989,  1049,  4214,
    4215,   932,   370,   502,   227,   208,   260,   334,   399,  4357,
     390,   197,   808,   327,    85,   935,   812,    88,   452,   939,
     951,   224,   953,   502,   955,  1017,   260,   319,   450,   342,
     961,   962,   963,  1025,  2772,  1049,   469,  1029,  1030,  1031,
     404,   452,    71,  1889,   240,   440,    75,    76,    77,    78,
      79,    80,   107,    82,   985,   986,   251,  3901,   489,   490,
     491,   185,   493,   494,   495,   496,   497,   498,   421,   422,
     503,   332,   265,   506,   136,   230,   262,   502,  1889,  1870,
     341,  1872,   452,   128,  3732,   503,  4400,   505,   390,   151,
    1881,   136,   198,   286,  3742,   495,   496,   497,   498,   295,
     502,   319,  1049,   483,  1024,   808,  1026,   951,   505,   953,
     173,   955,  3728,   426,    99,  2444,   808,   961,   445,   181,
     227,   183,  1114,  1115,  3740,   500,   181,  1119,   219,   504,
     306,   184,   181,  1100,   227,   314,    25,  1925,   392,  4060,
     247,   985,   986,   267,   186,   185,    35,   176,   221,  2247,
     114,   354,  1119,   334,   247,   638,   198,   109,  2148,   266,
     422,  4376,   229,   493,   494,   495,   496,   497,   498,  1100,
     374,   135,    72,   266,  1965,    75,    76,    77,    78,  4060,
     359,    81,    82,    83,    84,  3645,    86,   432,  1119,  2035,
    1157,   244,   254,   340,   390,   399,   450,   268,   143,  2385,
     376,   462,   502,   686,   687,   439,   151,   268,   193,  3417,
     136,   240,    85,  3599,   305,    88,   450,   502,  3604,   414,
     703,  3607,  3595,   399,  2035,  1256,  1157,   267,  1463,  1221,
    2871,   294,  1028,   296,   372,   341,  1032,   189,   227,   394,
     113,   286,   432,   446,   133,   118,   176,  2227,  2883,   341,
     149,  4051,   314,  1049,   266,   181,  1100,   319,   247,   330,
     505,  2247,  3170,   330,   370,   314,   295,   328,   423,   298,
    1114,  1115,  2534,  2526,  3460,  1119,   349,   266,   370,  2525,
    3466,  3467,  3468,  3469,  3470,  3471,  1319,  2473,  2474,  2475,
    2476,   190,   354,  2539,  2540,   502,   502,  2543,  3121,   489,
     493,   494,  3125,  2549,   366,   393,  1368,  3343,    97,   351,
     240,   434,  1304,  1157,  4114,   381,  1308,  1309,   158,  1311,
    1561,  1562,   503,  1564,   505,  1028,  3200,   116,  2883,  1032,
     120,   469,  1331,  3061,   422,  1633,  1028,  1329,  3061,  2787,
    1032,  1308,  1309,  1547,  1311,   452,  3617,   414,  3619,  2788,
    1922,  1633,  4357,  3061,  3061,  3061,  3061,  2353,   183,   452,
      96,   390,  1329,  1561,  1562,   295,  1564,   505,   298,  1368,
     106,  4019,  4020,   262,   247,   463,  2622,  1308,  1309,  2359,
    1311,   353,   172,  1375,   446,   451,   240,  2367,   314,  2369,
     149,   209,   232,   319,   494,   268,   269,  2520,  1329,   506,
     218,  2397,  1401,  3155,   887,   888,   142,   890,  4252,  4209,
     502,   184,   186,   506,  2517,    22,   136,  4217,  1688,    14,
     156,  1420,   493,   494,   495,   496,   497,   498,   354,   254,
    1463,   190,   218,  3976,   489,   500,   222,   176,  3091,   504,
     366,   295,    37,   342,   317,   500,   184,   502,   503,   504,
     505,  1450,   935,  4263,   483,   938,   939,   330,  1378,  1729,
     390,  1532,   434,   452,  1463,    72,  1500,  1501,   951,   259,
     953,   244,   955,  1465,  2659,  2660,   231,    72,   961,  2664,
     227,  1532,   965,  1475,   218,  1329,   260,   227,   208,   314,
     125,   506,   353,  1485,  4037,   128,  4039,   283,   452,   471,
     247,   240,   985,   986,   224,   120,   244,   247,    75,    76,
      77,    78,   193,   146,   195,    82,   306,   506,  2703,  2704,
     446,   193,  1514,   195,   361,  1517,   266,   426,   161,  1521,
    1522,   286,  1583,  1584,  1585,  3032,   390,   377,   173,  2861,
     326,  1024,   316,  1026,    75,    76,    77,    78,   502,   283,
    1517,    82,  4200,   483,  1521,  1522,   295,   172,   385,   298,
    2889,  3384,  1561,  1562,   401,  1564,   153,  1601,  3954,   489,
    1584,  1585,   502,   434,   505,  1646,   385,   173,   222,   212,
    1500,  1501,  1633,   342,   504,  1532,  1517,    88,   232,  1640,
    1521,  1522,   326,   493,   494,  1646,   401,   506,   388,    75,
      76,    77,    78,   247,  2242,    88,    82,  2587,   195,   436,
     471,  1603,   113,   450,   249,    88,  2862,  1100,   392,  1633,
     493,   494,   495,   496,   497,   498,  1640,   436,  1595,   469,
     113,  1114,  1115,   314,   354,  1118,  1583,  1584,  1585,   392,
     113,  1532,   508,   324,   259,   450,  3832,  3833,   422,   186,
     385,   390,   324,  1620,  1621,  2901,   252,  2903,   209,   294,
    2500,   296,  1593,   503,  1595,   341,   506,   426,    41,   422,
     425,   306,   427,  1517,  1157,   228,   450,  1521,  1522,   387,
     186,  1601,  1613,   457,   306,   469,  1633,  3135,   469,  1620,
    1621,   306,  1583,  1640,   370,   469,  1663,   248,   294,  1646,
     296,   436,  1669,   256,   457,   340,   452,  2547,  1532,   469,
     332,    72,   452,   360,   262,  3221,   424,  2508,   271,   341,
    3744,   505,    16,   260,   505,    86,   446,   280,   502,   341,
     387,   361,  1663,  3181,  1726,   379,  1532,   384,  1669,  3245,
     375,   371,  1977,  1710,   483,   505,  1713,  1714,  3070,   502,
    3403,  3404,   319,   503,   260,  1646,   506,  1828,   370,  1603,
     207,   469,   470,   502,  1879,   395,   506,   424,   341,   341,
    3508,   218,   222,   388,   409,   222,  3599,  1828,    51,  1710,
      14,  3604,  1713,  1714,  3607,   268,   269,  1583,  1584,  1585,
    2804,  2881,   242,  2773,   502,   268,    69,   370,   370,  1766,
     218,   374,   393,    37,   222,   470,   337,   247,  1998,   315,
     316,   356,   469,   470,  3455,    81,  1926,   264,  3266,  1663,
      86,  2770,  1646,   488,  1831,  1669,   399,   380,   222,  1532,
     341,   422,  4375,   455,   317,  1766,   283,  1633,   323,   231,
    1532,  1848,  1834,   319,  1640,   502,  1329,   174,   242,  4120,
    1646,  1334,  4060,  1336,  1650,   392,  1339,   389,  1341,   370,
    2158,  1344,  1345,  1346,  1981,   283,  1710,  1350,   273,  1713,
    1714,  1870,   463,  3193,  1357,  1671,  2158,  2723,    34,   326,
    1583,  1828,  3248,  3249,   328,   422,   392,   334,  1371,   333,
    1373,  4077,   151,  3139,   286,  1378,   469,  3143,   497,  3145,
    1997,  3147,  3148,   502,   432,   504,   341,  3756,   326,   341,
    3156,   424,  2723,   450,   328,  2676,   422,  2678,  2679,   333,
     457,  1913,  1766,  1989,  1916,  1989,  1925,  1989,  1989,  3284,
     370,  1862,   469,  2571,   374,   370,   505,  1828,   370,  3574,
     509,  4149,   150,  1646,   450,   502,  1913,  1650,  3194,  1916,
    1746,   457,  3558,   174,  1646,  3697,   469,   470,  1650,   399,
    2751,   436,  3700,   469,   399,   502,  2052,   399,  1671,  2055,
    2003,  2004,   231,    75,    76,    77,    78,   470,  1977,  1671,
      82,  2014,  1913,   325,  2017,  1916,   328,  2798,   372,   502,
    1989,   250,  2025,  2026,   202,   488,   502,    95,   445,  2070,
     103,   104,   389,   101,  1828,  2038,  2039,   155,  1491,   502,
     493,   494,   495,   496,   497,   498,  2049,  1500,  1501,  2070,
     493,   494,   495,   496,   497,   498,   425,   286,   427,   469,
    2022,   500,  1828,   425,  1517,   427,  2184,   506,  1521,  1522,
     250,  3226,   140,  1746,  3229,  3230,  3231,  3232,  3233,  3234,
    3235,  3236,  3237,  3238,  1746,   158,   503,    85,  2168,    75,
      76,    77,    78,  3385,  3386,   507,    82,  3396,   276,   277,
      72,   463,   505,   387,   333,  2074,   509,   180,  2268,   242,
    2270,   289,   501,   186,  2015,  2016,   505,   174,    75,    76,
      77,    78,  2023,   191,   207,    82,  2027,  2028,   124,   158,
     198,  3286,  3287,   201,   389,   218,   341,  2158,   211,   222,
     424,  2042,   503,  2044,   273,   506,  3060,  1176,  1601,  1178,
    1603,   180,   508,  2070,   370,  1828,  1185,   186,   374,    71,
    1613,  3954,  2063,   341,  2065,   370,  1828,    79,    80,   374,
    2132,   500,   470,   502,  2158,   504,   501,   425,  2263,   427,
     505,   264,   211,   399,   252,   469,   470,   260,   502,  2210,
     488,  2212,    85,   502,   399,    88,   425,   503,   427,   505,
     283,   273,    71,    72,   502,  2174,    86,   436,    85,  2070,
    1663,    88,   105,  2114,   133,   134,  1669,   446,   502,  3476,
    2261,  4099,  3182,  3336,   181,   500,  2210,   502,  2212,   497,
     328,   260,   938,   503,   502,   505,   504,   503,   306,   505,
    2261,  2158,   505,   326,  3025,   485,   424,   953,   426,   955,
    4043,   334,   502,   469,   504,   126,   124,  1710,   392,   965,
    1713,  1714,    71,    72,   114,   503,  2351,   505,   270,  2231,
      79,    80,   503,   341,   505,   331,  2070,    86,  3059,   985,
     986,   504,   503,  2184,   505,  2247,   157,  2249,   422,  2251,
    2227,   331,  3102,  2210,   328,  2212,  2337,  3306,  3307,   505,
     506,   162,   370,  2508,  2070,   193,   374,   195,   432,   503,
    2247,   505,  2249,  1766,  2251,    85,  2337,   485,    88,   392,
     328,  3479,  3480,   457,  4032,  3483,  2227,  3485,   216,   383,
     384,   399,  3392,   319,  3939,   469,  2298,   493,   494,   495,
     496,   497,   331,   214,  2261,   270,  2247,   503,  2249,   422,
    2251,  2372,  2242,   114,  4147,   495,   496,   497,   485,   503,
    3121,   505,   445,   392,  3125,   495,  3521,   228,   502,   399,
    2184,   503,   226,   505,   245,   268,   954,   450,   383,   384,
     958,   959,   960,  3708,   457,  2459,   505,   503,   461,   505,
     968,   268,  2158,   422,   502,   256,   469,  2070,   503,  3615,
    2261,  4229,   503,  4231,   505,   124,  3622,  3623,  2070,  3170,
     271,   503,   503,  2227,   505,   508,   502,  2231,   504,   280,
    2337,   450,  2359,   503,   506,   505,   314,  3583,   457,   502,
    2367,   319,  2369,  2247,   469,   470,   324,   330,   508,   503,
     469,   505,   303,   503,  2210,   505,  2212,   495,   503,    85,
     505,   262,    88,   330,   432,  2372,  2418,   503,  2359,   505,
     204,   503,  2760,   505,  2426,   432,  2367,  2261,  2369,   105,
     341,    85,   432,   502,    88,   502,  2337,   247,    75,    76,
      77,    78,  1935,   432,  1937,    82,   505,   506,  1941,    86,
    1943,   105,   503,  1946,   505,  2261,   432,  1950,   268,   370,
     108,  2706,  1955,   374,   503,   124,   505,   378,   469,   470,
    2472,  2372,   268,   384,    75,    76,    77,    78,   502,   380,
     391,    82,     7,   503,   262,   505,  3476,   126,   399,   503,
     432,   505,  2494,   504,    19,    20,   407,   502,  2500,  2508,
     503,  2442,   505,  2337,   415,  2359,   472,  3702,  3703,   425,
     438,   427,   502,  2367,    39,  2369,  4132,    42,   157,   447,
     330,  3853,   504,  4356,   193,   425,   195,   427,   503,   328,
     505,  2337,   486,   487,  3790,  3791,  2805,  2806,  2372,    75,
      76,    77,    78,   506,   181,  2547,    82,   216,  2261,  3846,
     469,   470,   503,   464,   505,   222,   489,   490,   491,  2261,
     493,   494,   495,   496,   497,   498,  2372,   503,   503,   505,
     505,  2746,  2747,   490,   491,   214,   493,   494,   495,   496,
     497,   498,   503,  3384,   505,   503,  2629,   505,  1334,   503,
    1336,   505,   268,  1339,   281,  1341,  3417,   452,  1344,  1345,
    1346,   328,  1069,  2684,  1071,  2098,   245,   503,  2689,   505,
    2587,  1357,  2105,   502,   268,    75,    76,    77,    78,   323,
    3985,  2114,    82,  2684,  2337,  1371,   389,  1373,  2689,   154,
      75,    76,    77,    78,  2677,  2337,   503,    82,   505,   273,
    4285,  2571,     2,   502,  3634,   181,  2587,   503,   136,   505,
     319,   503,   469,   505,   330,   324,   503,   108,   505,  2372,
    3773,  1383,  1384,  2706,   493,   494,   495,   496,   497,   194,
    2372,    95,   501,   503,   472,   505,   330,   101,   502,   489,
     490,   491,   114,   493,   494,   495,   496,   497,   498,   114,
     503,  2184,   505,  3748,   503,   441,   505,  2706,  2741,   341,
     503,  3841,   505,   503,   222,   505,  3962,   148,  3964,  3965,
     503,  2720,   505,   503,  1332,   505,   140,  1335,    78,  3975,
    1338,   181,  1340,   452,    84,  1343,   503,  2684,   505,  1347,
    2739,   357,  2689,  2587,  2227,   374,  4399,   376,  2231,   378,
     507,   503,  2751,   505,  2237,   384,  2239,   212,   503,  2242,
     505,   503,   391,   505,   212,   502,  4088,   117,   212,   503,
     399,   505,   212,    75,    76,    77,    78,   191,   407,   438,
      82,  2773,   472,   503,   198,   505,   415,   201,   447,   503,
     503,   505,   505,  2684,   212,   503,  3981,   505,  2689,   503,
     505,   505,   152,   503,   212,   505,  2773,   503,  3599,   505,
     212,   212,   162,  3604,   328,   503,  3607,   505,   212,   212,
    4005,  4006,  4177,   489,   490,   491,   212,   493,   494,   495,
     496,   497,   498,   328,   503,   464,   505,  2768,   252,   120,
    2771,   503,  2773,   505,   212,   489,   490,   491,   212,   493,
     494,   495,   496,   497,   498,   503,   422,   505,   162,   209,
    2684,   503,   503,   505,   505,  2689,   216,  4222,   218,   502,
     108,  4226,  4227,   503,   223,   505,  2359,   281,   222,    89,
     230,   824,   163,   503,  2367,   505,  2369,   830,  2684,   503,
     222,   505,   306,  2689,  3126,   838,  3128,    75,    76,    77,
      78,   502,   502,   846,    82,  3751,   187,   502,   851,  2960,
    2961,  2962,   502,   502,    85,   502,   350,    88,   502,    75,
      76,    77,    78,   502,   228,   206,    82,   341,  4174,  2773,
      75,    76,    77,    78,   105,   502,   505,    82,   502,   913,
    3751,   502,   223,   917,   502,   502,   502,  3078,   502,  3020,
     502,  4238,   256,   927,  2946,  3899,   370,   238,   502,   502,
     374,  4207,  4224,   502,   502,   502,   502,   271,   502,  3020,
    4223,   502,   502,   502,  2966,   338,   280,   108,   164,   266,
     281,  2684,   268,  3114,   108,   399,  2689,  3058,   222,   326,
      85,  4176,  2684,    88,   222,   495,  3111,  2689,   262,   303,
     390,   298,   505,   180,   451,  2997,   505,  3058,  3000,  3001,
     489,    14,  3004,  2960,  2961,  2962,   366,  3079,   505,   502,
     502,   502,  3014,   432,   328,   432,   432,  3019,   504,   432,
     328,   391,  3094,  3025,   432,   432,   979,   432,   319,  3031,
     319,   432,   143,   328,   252,   432,   327,   432,   502,   505,
     341,   401,  3114,   996,   175,   451,   432,   341,  3025,  3294,
     452,   432,   432,   452,   124,   124,   432,  3059,   387,  2960,
    2961,  2962,   502,  3020,   432,   332,   380,   432,   359,   432,
    3079,  3073,   328,   328,  1027,   432,   432,   432,  2571,  2572,
     432,   469,  3059,   268,  3025,  3094,   108,   268,   460,  3030,
    3031,  1044,   502,   502,  2587,   107,    97,   181,   462,  3101,
    3102,  3058,   452,   289,   502,  3114,   108,  3179,   222,   502,
     463,  3052,  3121,  4137,  1067,   108,  3125,   273,  3059,  3020,
     504,  3296,  3297,  3298,  3299,   388,  2960,  2961,  2962,   466,
     212,    95,   452,   212,   452,   212,   212,   101,   452,    14,
     323,   457,   432,   505,   377,   318,   227,   430,  3078,   330,
    4199,   502,   465,  3954,  2960,  2961,  2962,  3058,   485,    88,
    4423,  4417,   300,   268,   300,   505,   430,   399,   502,   502,
    3179,  3025,   432,   227,   505,   434,   140,   505,  3259,   489,
     503,   241,   241,   489,  3114,   329,  3020,   324,  4044,  1935,
     264,  1937,    34,    10,   387,  1941,   505,  1943,  3259,   150,
    1946,   505,   432,   503,  1950,  3059,   432,   387,  4064,   452,
     503,   503,  3255,   319,  3020,   502,   272,   272,   502,   319,
     319,   328,   335,  4044,  3058,   330,    95,   191,   432,   327,
     505,   432,   101,   396,   198,   370,   361,   201,   370,  4060,
     370,   432,  4043,  4064,   268,   108,   452,  2960,  2961,  2962,
     432,   268,  3058,   268,   452,   327,   502,   268,  2960,  2961,
    2962,   268,  4063,   107,   489,   500,   500,   432,  3270,   222,
     432,   140,  3430,  3611,   489,  2768,   224,   324,   638,   502,
    2773,   396,   108,   211,   328,  3294,   328,   496,   252,   239,
     239,   222,   505,   108,   502,  1248,  1249,  1250,  4099,   212,
     328,   328,  3259,   396,   222,  1289,   247,  3020,   489,   490,
     491,  3313,   493,   494,   495,   496,   497,   498,  3020,   472,
     247,   247,   191,   502,    96,  4433,   233,   505,   297,   198,
     328,   505,   201,   124,   503,  3416,   503,  3418,   227,   503,
     485,   227,   306,   503,   503,  3058,  4147,   505,   466,   503,
     337,   503,   503,   503,   503,  3416,  3058,  3418,  3259,   485,
     503,   503,  4316,   503,   503,    90,   432,    90,   489,   502,
    4478,   283,   328,   331,   503,   502,   328,   341,  4486,   503,
    3441,  1365,   505,   252,   489,   490,   491,   506,   493,   494,
     495,   496,   497,   498,   503,   505,   432,  1381,   455,   503,
     502,   502,   258,   319,   212,   502,   370,   212,   345,  1393,
     374,  1364,   283,   345,   449,  3417,    85,   268,   432,    88,
    3361,   268,   292,   432,   292,  3259,   292,   432,   432,  3431,
     268,   268,  3434,   432,  3436,   399,   105,   306,   432,  1392,
    3417,   432,   432,   268,   113,   268,   268,   500,   808,   118,
     298,   503,   812,  3259,   503,   283,   816,  4313,  3460,  3416,
     489,  3418,   822,   441,  3466,  3467,  3468,  3469,  3470,  3471,
     332,   372,   341,   174,  3476,   505,  3417,   502,   327,   236,
     503,   502,   328,   503,  3441,   432,   271,   271,   324,  3430,
     108,   336,  4313,   853,   502,   452,   222,   452,   331,  3476,
     387,  3503,   387,   387,   210,   374,   210,   204,   126,   505,
    3512,  3513,  3514,  3515,  3491,  3416,   500,  3418,   227,    88,
     222,   503,   503,   503,   462,   134,   502,   227,   503,   503,
     399,   503,  3025,   503,   894,  3476,   235,   505,   222,   157,
    3441,   502,   329,   489,   489,   905,  3259,   489,  4349,  3490,
    3491,   258,   912,   441,   432,  4356,  3628,  3259,  3499,   441,
     432,   222,  3503,  3417,   503,  3765,  3059,   432,   432,  3571,
    1554,  3512,   932,   503,   243,  1528,  3430,   268,   247,   503,
     503,  4382,  3416,   268,  3418,  3078,   501,   108,   502,   272,
    3599,   502,   469,   472,   222,  3604,   214,   505,  3607,   268,
     269,   503,  3760,   823,   253,   505,   146,  3441,   828,   469,
    3416,   424,  3418,   282,   469,   505,   432,   837,    85,  3628,
     271,  3114,  3476,   503,   232,   396,   502,   245,  3786,   502,
     227,   227,   467,   467,   124,  3441,   503,   237,   432,   227,
     469,   502,   862,   502,  3687,   314,   866,   505,   317,   503,
     503,   503,   441,   503,   319,   273,   876,  3634,   489,   319,
     212,   330,  1022,   268,   333,   505,   505,   319,  1028,   188,
     183,   254,  1032,   229,   501,   452,   227,   452,   227,   199,
     255,  4482,   465,   469,   502,   331,   227,   456,   502,  1049,
     502,   502,   502,  3634,   408,   468,   503,   503,  1058,   344,
     503,   503,   328,  3416,   366,  3418,   452,   502,   469,   502,
     222,   108,   319,   293,  3416,   250,  3418,  3875,   211,   174,
     502,   332,   136,  2037,   136,   384,   384,   331,  3441,   489,
     124,   334,   502,   222,   403,   328,   424,  1690,   217,  3441,
     331,   358,  3744,  3745,   331,   194,    85,   505,   456,   108,
     817,   227,   108,   820,  3756,   466,   374,   505,   364,   469,
     378,   199,   328,  3844,   328,   108,   384,  3744,   502,   836,
     126,   469,   503,   391,   502,   186,   503,   450,   502,  3756,
    3634,   399,  2096,  3844,   383,   383,    94,  1740,   105,   407,
     211,   358,   859,   358,  2458,  2773,  1522,   415,  1747,   502,
    2343,   157,  2894,  3744,  3416,  4080,  3844,   874,  1761,  3019,
    4238,  4132,  3562,  3892,  4136,  3756,  2856,  2576,  4380,  3760,
     489,   490,   491,  4043,   493,   494,   495,   496,   497,   498,
    3832,  3833,   501,  3905,  4422,  4343,  1196,  4342,   507,  4389,
    3901,   108,  3564,  1203,  3846,  3786,   464,  1849,  3850,  3851,
     468,   469,  3854,  3855,  2288,  4156,  3797,  3798,   214,   126,
    3441,  3802,  3803,  1835,  1224,  3867,  3868,  3869,  3870,  3871,
    2961,  3364,  2446,  3072,  4425,  4486,  4478,  3058,  3861,  3860,
    3024,  4396,  4066,  1826,  4324,   188,  4069,  3844,  1366,   245,
     157,  3637,  4205,  1253,  1114,  1115,  3905,  3572,  2311,  1883,
    3574,  4285,   902,  4405,  4480,  4121,  3760,  2169,  1892,  3911,
    2168,  1926,  3556,  3180,  2784,  1043,  2795,   273,  2559,  2204,
    1904,  1553,  1571,  1570,  3417,  2807,  3867,  3868,  3869,  3870,
    3871,  1322,  3786,  2801,  3875,  2203,  3938,  3430,  1060,  2187,
    1573,  1894,  2161,  3844,  3901,  3954,  2751,   214,  1308,  1309,
    1903,  1311,  2508,  3127,  3955,  2785,  1048,  3553,  3269,  1319,
     896,  4179,  3261,  4369,  4373,  4370,  2798,  2720,  2631,  2599,
    1923,  2718,  2099,  4016,   638,  3111,  2501,  1864,   245,  1963,
    1260,  2231,  1966,  3476,  1968,  4363,   367,  1971,  1579,  1585,
     934,  2207,  2247,  1378,  2767,  3364,  2239,  1117,  2240,  3743,
    3901,  1117,  1497,   150,  3365,  3341,   273,   400,  1583,  1955,
    3844,  2251,   159,   160,   161,  2572,  1969,  1970,   374,  1379,
    1137,  3875,   378,  1308,     2,    -1,    -1,    -1,   384,   964,
      -1,    -1,    -1,    -1,    -1,   391,    -1,    -1,  3844,    -1,
      -1,    -1,    -1,   399,    -1,  1405,    -1,    -1,    -1,    -1,
    4027,   407,    -1,    -1,    -1,    -1,   203,    -1,  4060,   415,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  3901,    -1,    85,
      -1,    -1,    88,  1433,    -1,  4077,    -1,    -1,    -1,  4081,
      -1,    -1,    -1,  4060,    -1,    -1,  4027,    -1,    -1,   105,
      -1,    -1,  1159,  1160,    -1,  3901,    -1,   113,    -1,    -1,
    1460,  1461,   118,  1463,    -1,   252,    -1,   374,   464,    -1,
      -1,   378,   468,    -1,    -1,    -1,  1476,   384,    -1,  4060,
    1480,    -1,    -1,    -1,   391,    -1,    -1,    -1,    -1,    -1,
      -1,  3844,   399,    -1,    -1,    -1,    -1,    -1,  4181,    -1,
     407,  3634,  3844,    -1,   291,  2098,    -1,    -1,   415,    -1,
      -1,  1218,    -1,    -1,    -1,    -1,    -1,  1517,    -1,    -1,
     307,   308,   309,   310,   311,    -1,   313,  1234,  1235,    -1,
    2123,  1531,  1532,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,  1251,  2659,  2660,    -1,  3901,    -1,
    2664,  4252,  4437,    -1,    -1,    -1,    -1,   464,   345,  3901,
      -1,   468,    -1,  1563,    -1,    -1,  4060,  1567,  1568,    -1,
      -1,    -1,    -1,    -1,  2167,    -1,  2169,    -1,  1285,  1286,
      -1,    -1,    -1,  1583,  1584,  1585,    -1,   243,    -1,  2703,
    2704,   247,    -1,    -1,    -1,    -1,  4238,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3744,   268,   269,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  4305,    -1,    -1,    -1,   282,  3760,    -1,    -1,
      -1,   418,    -1,  1633,    -1,    -1,    -1,    -1,    -1,    -1,
    1640,  1641,    -1,    -1,    -1,    -1,  1646,    -1,    -1,    -1,
    1650,    -1,    -1,  3786,    -1,  4252,    -1,   444,   314,    -1,
      -1,   317,    -1,    -1,   451,    -1,    -1,   454,    -1,    -1,
      -1,  1671,    -1,    -1,   330,    -1,    -1,   333,  1678,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4405,
      -1,  4405,  2316,  4405,  4405,    -1,    -1,    -1,    -1,    -1,
      -1,  1701,    -1,    -1,    -1,  2659,  2660,    -1,  4289,    -1,
    2664,  4252,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      71,  4437,    -1,  4437,    -1,  4437,  4437,    -1,    79,    80,
      -1,    -1,    -1,    -1,    85,    -1,    -1,    88,    -1,    -1,
      -1,  2334,  3875,  1603,    -1,    -1,  1746,   403,    -1,  2703,
    2704,    -1,    -1,    -1,   105,    -1,  4405,   108,    -1,    -1,
    1224,    -1,   113,  1763,  4480,    -1,  4480,   118,  4480,  4480,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4252,    -1,
    1780,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  4437,    -1,
      -1,  4433,    -1,    -1,    -1,  4289,    -1,    -1,  1798,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4252,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,  4433,    -1,    -1,    -1,
      -1,    -1,    -1,  1823,    -1,    -1,    -1,    -1,  1828,    -1,
      -1,  4480,    -1,   489,   490,   491,  4478,   493,   494,   495,
     496,   497,   498,    -1,  4486,    -1,    -1,    -1,    -1,   505,
      -1,    -1,  4433,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  4478,    -1,  2456,    -1,    -1,    -1,    -1,    -1,  4486,
    1870,    -1,  1872,    -1,    -1,    -1,    -1,    -1,  1878,    -1,
      -1,  1881,    -1,    -1,  1744,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   243,    -1,    -1,    -1,   247,  4478,    -1,  4252,
      -1,    -1,    -1,  1224,    -1,  4486,    -1,    -1,    -1,    -1,
    4252,    -1,    -1,  1913,    -1,  1379,  1916,   268,   269,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,  4060,    -1,    -1,
      -1,   282,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  2583,
      -1,    -1,    -1,   314,    -1,  1965,   317,    -1,    -1,    -1,
      -1,    -1,  1832,    -1,    -1,    -1,    -1,    -1,    -1,   330,
      -1,    -1,   333,    -1,    -1,    -1,    -1,  1847,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,  2003,  2004,    -1,    -1,    -1,    -1,    -1,
      -1,  2011,    -1,    -1,  2014,    -1,    -1,  2017,    -1,    -1,
      -1,    -1,  2022,    -1,    -1,  2025,  2026,    -1,    -1,  1736,
    1737,  1738,  1739,  2033,    -1,    -1,  2036,  2037,  2038,  2039,
      -1,    -1,    -1,    -1,    -1,  1905,  2046,  2047,    -1,  2049,
      -1,  2051,   403,    -1,  2054,    -1,    -1,    -1,  1379,    -1,
    1767,  1768,    -1,    -1,    -1,    -1,  1773,    -1,  2068,  2069,
    2070,    -1,    -1,  2073,    -1,    -1,    -1,  2077,    -1,    -1,
      -1,  2081,    -1,  2083,  2084,  2085,  2086,  2087,  2088,  2089,
    2090,  2091,    98,  2093,    -1,    -1,    -1,    -1,    -1,  2099,
      -1,    -1,  2102,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  3226,    -1,    -1,  3229,  3230,  3231,  3232,  3233,
    3234,  3235,  3236,  3237,  3238,    -1,    -1,    -1,    -1,  