.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DISCARD" "" "2010-10-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
DISCARD \- discard session state

.SH SYNOPSIS
.sp
.nf
DISCARD { ALL | PLANS | TEMPORARY | TEMP }
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDISCARD\fR releases internal resources associated with a
database session. These resources are normally released at the end
of the session.
.PP
\fBDISCARD TEMP\fR drops all temporary tables created in the
current session. \fBDISCARD PLANS\fR releases all internally
cached query plans. \fBDISCARD ALL\fR resets a session to
its original state, discarding temporary resources and resetting
session-local configuration changes.
.SH "PARAMETERS"
.TP
\fBTEMPORARY or TEMP\fR
Drops all temporary tables created in the current session.
.TP
\fBPLANS\fR
Releases all cached query plans.
.TP
\fBALL\fR
Releases all temporary resources associated with the current
session and resets the session to its initial state.
Currently, this has the same effect as executing the following sequence
of statements:
.sp
.nf
SET SESSION AUTHORIZATION DEFAULT;
RESET ALL;
DEALLOCATE ALL;
CLOSE ALL;
UNLISTEN *;
SELECT pg_advisory_unlock_all();
DISCARD PLANS;
DISCARD TEMP;
.sp
.fi
.SH "NOTES"
.PP
\fBDISCARD ALL\fR cannot be executed inside a transaction block.
.SH "COMPATIBILITY"
.PP
\fBDISCARD\fR is a PostgreSQL extension.
