-- SJIS_EUDC --> UTF8
CREATE FUNCTION pg_catalog.sjis_eudc_to_utf8 (integer, integer, cstring, internal, integer)
  RETURNS void AS '$libdir/eudc', 'sjis_eudc_to_utf8' LANGUAGE C STRICT;
DROP CONVERSION pg_catalog.sjis_to_utf8;
CREATE DEFAULT CONVERSION pg_catalog.sjis_eudc_to_utf8 FOR 'SJIS' TO 'UTF8' FROM sjis_eudc_to_utf8;

-- UTF8 --> SJIS_EUDC
CREATE FUNCTION pg_catalog.utf8_to_sjis_eudc (integer, integer, cstring, internal, integer)
  RETURNS void AS '$libdir/eudc', 'utf8_to_sjis_eudc' LANGUAGE C STRICT;
DROP CONVERSION pg_catalog.utf8_to_sjis;
CREATE DEFAULT CONVERSION pg_catalog.utf8_to_sjis_eudc FOR 'UTF8' TO 'SJIS' FROM utf8_to_sjis_eudc;

-- EUC_JP_EUDC --> UTF8
DROP CONVERSION pg_catalog.euc_jp_to_utf8;
CREATE FUNCTION pg_catalog.euc_jp_eudc_to_utf8 (integer, integer, cstring, internal, integer)
  RETURNS void AS '$libdir/eudc', 'euc_jp_eudc_to_utf8' LANGUAGE C STRICT;
CREATE DEFAULT CONVERSION pg_catalog.euc_jp_eudc_to_utf8 FOR 'EUC_JP' TO 'UTF8' FROM euc_jp_eudc_to_utf8;

-- UTF8 --> EUC_JP_EUDC
CREATE FUNCTION pg_catalog.utf8_to_euc_jp_eudc (integer, integer, cstring, internal, integer)
  RETURNS void AS '$libdir/eudc', 'utf8_to_euc_jp_eudc' LANGUAGE C STRICT;
DROP CONVERSION pg_catalog.utf8_to_euc_jp;
CREATE DEFAULT CONVERSION pg_catalog.utf8_to_euc_jp_eudc FOR 'UTF8' TO 'EUC_JP' FROM utf8_to_euc_jp_eudc;
