/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.util.StringUtils;

public class ExecTask
extends Task {
    private String os;
    private File out;
    private File dir;
    protected boolean failOnError = false;
    protected boolean newEnvironment = false;
    private Long timeout = null;
    private Environment env = new Environment();
    protected Commandline cmdl = new Commandline();
    private FileOutputStream fos = null;
    private ByteArrayOutputStream baos = null;
    private String outputprop;
    private String resultProperty;
    private boolean failIfExecFails = true;
    private boolean append = false;
    private boolean vmLauncher = true;

    public void setTimeout(Long value) {
        this.timeout = value;
    }

    public void setTimeout(Integer value) {
        if (value == null) {
            this.timeout = null;
        } else {
            this.setTimeout(new Long(value.intValue()));
        }
    }

    public void setExecutable(String value) {
        this.cmdl.setExecutable(value);
    }

    public void setDir(File d) {
        this.dir = d;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public void setCommand(Commandline cmdl) {
        this.log("The command attribute is deprecated. Please use the executable attribute and nested arg elements.", 1);
        this.cmdl = cmdl;
    }

    public void setOutput(File out) {
        this.out = out;
    }

    public void setOutputproperty(String outputprop) {
        this.outputprop = outputprop;
    }

    public void setFailonerror(boolean fail) {
        this.failOnError = fail;
    }

    public void setNewenvironment(boolean newenv) {
        this.newEnvironment = newenv;
    }

    public void addEnv(Environment.Variable var) {
        this.env.addVariable(var);
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    public void setResultProperty(String resultProperty) {
        this.resultProperty = resultProperty;
    }

    protected void maybeSetResultPropertyValue(int result) {
        String res = Integer.toString(result);
        if (this.resultProperty != null) {
            this.project.setNewProperty(this.resultProperty, res);
        }
    }

    public void setFailIfExecutionFails(boolean flag) {
        this.failIfExecFails = flag;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        File savedDir = this.dir;
        this.checkConfiguration();
        if (this.isValidOs()) {
            try {
                this.runExec(this.prepareExec());
                Object var3_2 = null;
                this.dir = savedDir;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.dir = savedDir;
                throw throwable;
            }
        }
    }

    protected void checkConfiguration() throws BuildException {
        if (this.cmdl.getExecutable() == null) {
            throw new BuildException("no executable specified", this.location);
        }
        if (this.dir != null && !this.dir.exists()) {
            throw new BuildException("The directory you specified does not exist");
        }
        if (this.dir != null && !this.dir.isDirectory()) {
            throw new BuildException("The directory you specified is not a directory");
        }
    }

    protected boolean isValidOs() {
        String myos = System.getProperty("os.name");
        this.log("Current OS is " + myos, 3);
        if (this.os != null && this.os.indexOf(myos) < 0) {
            this.log("This OS, " + myos + " was not found in the specified list of valid OSes: " + this.os, 3);
            return false;
        }
        return true;
    }

    public void setVMLauncher(boolean vmLauncher) {
        this.vmLauncher = vmLauncher;
    }

    protected Execute prepareExec() throws BuildException {
        if (this.dir == null) {
            this.dir = this.project.getBaseDir();
        }
        Execute exe = new Execute(this.createHandler(), this.createWatchdog());
        exe.setAntRun(this.getProject());
        exe.setWorkingDirectory(this.dir);
        exe.setVMLauncher(this.vmLauncher);
        String[] environment = this.env.getVariables();
        if (environment != null) {
            int i = 0;
            while (i < environment.length) {
                this.log("Setting environment variable: " + environment[i], 3);
                ++i;
            }
        }
        exe.setNewenvironment(this.newEnvironment);
        exe.setEnvironment(environment);
        return exe;
    }

    protected final void runExecute(Execute exe) throws IOException {
        int err = -1;
        err = exe.execute();
        if (exe.killedProcess()) {
            this.log("Timeout: killed the sub-process", 1);
        }
        this.maybeSetResultPropertyValue(err);
        if (err != 0) {
            if (this.failOnError) {
                throw new BuildException(this.taskType + " returned: " + err, this.location);
            }
            this.log("Result: " + err, 0);
        }
        if (this.baos != null) {
            BufferedReader in = new BufferedReader(new StringReader(this.baos.toString()));
            String line = null;
            StringBuffer val = new StringBuffer();
            while ((line = in.readLine()) != null) {
                if (val.length() != 0) {
                    val.append(StringUtils.LINE_SEP);
                }
                val.append(line);
            }
            this.project.setNewProperty(this.outputprop, val.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runExec(Execute exe) throws BuildException {
        this.log(this.cmdl.describeCommand(), 3);
        exe.setCommandline(this.cmdl.getCommandline());
        try {
            try {
                this.runExecute(exe);
            }
            catch (IOException e) {
                if (this.failIfExecFails) {
                    throw new BuildException("Execute failed: " + e.toString(), e, this.location);
                }
                this.log("Execute failed: " + e.toString(), 0);
                Object var4_3 = null;
                this.logFlush();
            }
            Object var4_2 = null;
            this.logFlush();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.logFlush();
            throw throwable;
        }
    }

    protected ExecuteStreamHandler createHandler() throws BuildException {
        if (this.out != null) {
            try {
                this.fos = new FileOutputStream(this.out.getAbsolutePath(), this.append);
                this.log("Output redirected to " + this.out, 3);
                return new PumpStreamHandler(this.fos);
            }
            catch (FileNotFoundException fne) {
                throw new BuildException("Cannot write to " + this.out, fne, this.location);
            }
            catch (IOException ioe) {
                throw new BuildException("Cannot write to " + this.out, ioe, this.location);
            }
        }
        if (this.outputprop != null) {
            this.baos = new ByteArrayOutputStream();
            this.log("Output redirected to ByteArray", 3);
            return new PumpStreamHandler(this.baos);
        }
        return new LogStreamHandler(this, 2, 1);
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.timeout == null) {
            return null;
        }
        return new ExecuteWatchdog(this.timeout);
    }

    protected void logFlush() {
        try {
            if (this.fos != null) {
                this.fos.close();
            }
            if (this.baos != null) {
                this.baos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

