'
'	Frank Lupo (Wolf) !!
'	This is a Psql command for Postgresql in Visual Basic Script
'
'	Verify input prompt
'
Option Explicit

Function GetPrompt(szIstr)
Dim szTemp,szTemp1,Fso,szPath,WshShell,bExecuteSql,f,fc,f1

	'Save command into history file
	App.Data.Utility.FileSystem.WriteFile App.Data.Setting.HistoryFile,szIstr & vbcrlf,ForAppending

	szTemp=Trim(szIstr)
	if left(szTemp,2) = "--" and FlagPrompt <> 2 Then
		'Comment
	elseif Left(szTemp,10) = "\copyright" and FlagPrompt <> 2 Then
		'View Copyright
		wscript.echo App.Data.Message.Copyright
	elseif Left(szTemp,11) = "\createhelp" and FlagPrompt <> 2 Then
		'create help from SGML file
		App.Data.Help.CreateHelp
	elseif Left(szTemp,7) = "\export" and FlagPrompt <> 2 Then
		'Export query result
		szTemp=trim(mid(szTemp,9))

		szPath=szIncludePath & PATH_EXPORT & "\"
		Set fso = CreateObject("Scripting.FileSystemObject")

		if len(szTemp) = 0 then
			'Show all export possible

			Set f = fso.GetFolder(szPath)
   			Set fc = f.Files
			Wscript.Echo "None     disable export"
   			For Each f1 in fc
				wscript.echo fso.GetBaseName(f1.name)
   			Next
		elseif lcase(szTemp)="none" then
			Wscript.Echo "Disable export"
			Set App.Data.Export = Nothing
		else
			szTemp1=szTemp & ".vbs"
			szPath=szPath & szTemp1
			If Not fso.FileExists(szPath) Then
				Wscript.Echo App.Data.Message.NoSuchFD(szTemp1)
			else
				'Load export
				Execute Include(szPath)
				Set App.Data.Export = New ClsExport
				Wscript.Echo "Enable export: " & szTemp
			end if
		end if
	Elseif (Left(szTemp,2) = "\h" or Left(szTemp,5) = "\help") and FlagPrompt <> 2 Then
		'View Help sql command
		if Left(szTemp,5) = "\help" then
			szTemp=mid(szTemp,7)
		elseif Left(szTemp,2) = "\h" then
			szTemp=mid(szTemp,4)
		end if
		App.Data.Help.ShowHelp szTemp
	Elseif Left(szTemp,2) = "\s" and FlagPrompt <> 2 Then
		'print history or save it to file
		szPath=trim(mid(szTemp,3))
		if len(szPath) =0 then
			wscript.echo App.Data.Utility.FileSystem.ReadFile(App.Data.Setting.HistoryFile,0)
		else
			Set Fso = CreateObject("Scripting.FileSystemObject")
			If Not fso.FileExists(szPath) Then
				Wscript.Echo App.Data.Message.NoSuchFD(szPath)
			else
				fso.CopyFile App.Data.Setting.HistoryFile, szPath
				wscript.echo "Wrote history to " & szPath & "."
			end if 
		end if
	Elseif Left(szTemp,2) = "\?" and FlagPrompt <> 2 Then
		'View Internal Help
		wscript.echo App.Data.Message.InternalHelp
	Elseif Left(szTemp,2) = "\r" and FlagPrompt <> 2 Then
		'reset (clear) the query buffer
		szSqlIstr=""
		szOldSqlIstr=""
		wscript.echo "Query buffer reset (cleared)."
	Elseif Left(szTemp,5) = "\echo" and FlagPrompt <> 2 Then
		'write text to standard output
		wscript.echo mid(szTemp,7)
	Elseif Left(szTemp,2) = "\!" and FlagPrompt <> 2 Then
		'execute command in shell
		szTemp=trim(mid(szTemp,3))
		if len(szTemp) =0 then szTemp="CMD"
		App.Data.Utility.Misc.RunProgram szTemp, 1, true
	Elseif Left(szTemp,3) = "\cd" and FlagPrompt <> 2 Then
		'change the current working directory

		Set Fso = CreateObject("Scripting.FileSystemObject")
		Set WshShell = WScript.CreateObject("WScript.Shell")

		If len(mid(szTemp,4)) > 0 Then
			szPath=trim(mid(szTemp,4))
			If Not fso.FolderExists(szPath) Then
				Wscript.Echo App.Data.Message.NoSuchFD(szPath)
			else
				'Change directory
				WshShell.CurrentDirectory=szPath
				WScript.Echo szPath
			End If
		Else
			'Show current directory
			WScript.Echo WshShell.CurrentDirectory
		End If
	Elseif Left(szTemp,2) = "\p" and FlagPrompt <> 2 Then
		'show the content of the current query buffer
		szTemp=szSqlIstr
		if len(szTemp)=0 then szTemp=szOldSqlIstr
		WScript.Echo szTemp
	Elseif Left(szTemp,2) = "\H" and FlagPrompt <> 2 Then
		'toggle HTML output mode
		App.Data.Print.Html=Not App.Data.Print.Html

		if App.Data.Print.Html then
			wscript.echo "Output format is html."
		else
			wscript.echo "Output format is aligned."
		end if
	Elseif Left(szTemp,2) = "\t" and FlagPrompt <> 2 Then
		'show only rows
		App.Data.Print.PrintRowsOnly=Not App.Data.Print.PrintRowsOnly

		if App.Data.Print.PrintRowsOnly then
			wscript.echo "Showing only tuples."
		else
			wscript.echo "Tuples only is off."
		end if
	Elseif Left(szTemp,2) = "\o" and FlagPrompt <> 2 Then
		'send all query results to file
		Set Fso = CreateObject("Scripting.FileSystemObject")
		szPath=trim(mid(szTemp,3))
		if len(szPath) > 0 then
			if fso.FolderExists(fso.GetParentFolderName(szPath)) then
				App.Data.Print.FileSendResultsQuery=szPath
			else
				Wscript.Echo App.Data.Message.NoSuchFD(szPath)
			end if
		else
			App.Data.Print.FileSendResultsQuery=""
		end if 
	Elseif (Left(szTemp,2) = "\l" or Left(szTemp,5) = "\list" )and FlagPrompt <> 2 Then
		'List all database
		App.Data.Describe.ListAllDatabase True
	Elseif Left(szTemp,3) = "\du" and FlagPrompt <> 2 Then
		'database users
		App.Data.Describe.DescribeUsers trim(mid(szTemp,4))
	Elseif Left(szTemp,3) = "\dg" and FlagPrompt <> 2 Then
		'database groups
		App.Data.Describe.DescribeGroups trim(mid(szTemp,4))
	Elseif Left(szTemp,3) = "\dd" and FlagPrompt <> 2 Then
		'Object Description
		App.Data.Describe.ObjectDescription trim(mid(szTemp,4))
	Elseif Left(szTemp,3) = "\dT" and FlagPrompt <> 2 Then
		'list data types
		App.Data.Describe.DescribeTypes trim(mid(szTemp,4))
	Elseif Left(szTemp,3) = "\do" and FlagPrompt <> 2 Then
		'list operators
		App.Data.Describe.DescribeOperators trim(mid(szTemp,4))
	Elseif Left(szTemp,3) = "\df" and FlagPrompt <> 2 Then
		'list functions
		App.Data.Describe.DescribeFunctions trim(mid(szTemp,4))
	Elseif Left(szTemp,3) = "\dp" and FlagPrompt <> 2 Then
		'list privilegies
		App.Data.Describe.PermissionsList trim(mid(szTemp,4))
	Elseif Left(szTemp,2) = "\z" and FlagPrompt <> 2 Then
		'list privilegies
		App.Data.Describe.PermissionsList trim(mid(szTemp,3))
	Elseif Left(szTemp,3) = "\da" and FlagPrompt <> 2 Then
		'list aggregate functions
		App.Data.Describe.DescribeAggregates trim(mid(szTemp,4))
	Elseif Left(szTemp,3) = "\dS" and FlagPrompt <> 2 Then
		App.Data.Describe.ListTables trim(mid(szTemp,4)),5
	Elseif Left(szTemp,3) = "\dt" and FlagPrompt <> 2 Then
		App.Data.Describe.ListTables trim(mid(szTemp,4)),1
	Elseif Left(szTemp,3) = "\di" and FlagPrompt <> 2 Then
		App.Data.Describe.ListTables trim(mid(szTemp,4)),2
	Elseif Left(szTemp,3) = "\ds" and FlagPrompt <> 2 Then
		App.Data.Describe.ListTables trim(mid(szTemp,4)),3
	Elseif Left(szTemp,3) = "\dv" and FlagPrompt <> 2 Then
		App.Data.Describe.ListTables trim(mid(szTemp,4)),4
	Elseif Left(szTemp,2) = "\d" and FlagPrompt <> 2 Then
		'Describe Table Details
		App.Data.Describe.DescribeTableDetails trim(mid(szTemp,3))
	Elseif Left(szTemp,2) = "\i" and FlagPrompt <> 2 Then
		'execute commands from file
		Set Fso = CreateObject("Scripting.FileSystemObject")

		If len(mid(szTemp,3)) > 0 Then
			szPath=trim(mid(szTemp,3))
			If Not fso.FileExists(szPath) Then
				Wscript.Echo App.Data.Message.NoSuchFD(szPath)
			else
				'Execute command in file
				szTemp = App.Data.Utility.FileSystem.ReadFile(szPath,1)	
				for each szTemp1 in szTemp
					GetPrompt szTemp1
				next 
			End If
		Else
			Wscript.Echo App.Data.Message.MissArg("\i")
		End If
	Elseif Left(szTemp,2) = "\w" and FlagPrompt <> 2 Then
		'write current query buffer to file
		Set Fso = CreateObject("Scripting.FileSystemObject")

		If len(mid(szTemp,3)) > 0 Then
			szPath=trim(mid(szTemp,3))
			'create file from string command
			szTemp=szSqlIstr
			if len(szTemp)=0 then szTemp=szOldSqlIstr
			App.Data.Utility.FileSystem.WriteFile szPath,szTemp,ForWriting
		Else
			Wscript.Echo App.Data.Message.MissArg("\w")
		End If
	Elseif Left(szTemp,2) = "\e" and FlagPrompt <> 2 Then
		'Editor
		'edit the current query buffer or file with external editor
		Set Fso = CreateObject("Scripting.FileSystemObject")

		If len(mid(szTemp,3)) > 0 Then
			szPath=trim(mid(szTemp,3))
			If Not fso.FileExists(szPath) Then
				Wscript.Echo App.Data.Message.NoSuchFD(szPath)
				szPath=""
			End If
		Else
			'temporaney file
			szPath=Fso.GetSpecialFolder(TemporaryFolder) & "\" & fso.GetTempName    

			'create file from string command
			szTemp=szSqlIstr
			if len(szTemp)=0 then szTemp=szOldSqlIstr
			App.Data.Utility.FileSystem.WriteFile szPath,szTemp,ForWriting
		End If

		If len(szPath) > 0 then
			'run editor
			App.Data.Utility.Misc.RunProgram App.Data.Setting.Editor & " " & szPath, 1, true

			'Execute command in file
			szTemp = App.Data.Utility.FileSystem.ReadFile(szPath,1)	
			for each szTemp1 in szTemp
				GetPrompt szTemp1
			next 
		end if
	Elseif Right(szTemp,2) = "\q" and FlagPrompt <> 2 Then
		'End Program
		Wscript.Quit
	Elseif (Right(szTemp,1) = ";" or Right(szTemp,2) = "\g") and FlagPrompt <> 2 Then
		'Execute sql command
		if Right(szTemp,1) = ";" then
			szSqlIstr = szSqlIstr & mid(szTemp,1,len(szTemp)-1)
		elseif Right(szTemp,2) = "\g" then
			szSqlIstr = szSqlIstr & mid(szTemp,1,len(szTemp)-2)
		end if 

		'Retrive old sql command 
		if len(trim(szSqlIstr))=0 and Right(szTemp,2) = "\g" then szSqlIstr=szOldSqlIstr

		if len(trim(szSqlIstr)) > 0 then
			bExecuteSql=True
			if App.Data.Setting.SingleStepMode then
				Wscript.Echo "***(Single step mode: Verify query)*************************************"
				Wscript.Echo szSqlIstr	
				Wscript.Echo "***(press return to proceed or enter x and return to cancel)************"
				szTemp= WScript.StdIn.ReadLine
				if lcase(left(trim(szTemp),1))="x" then bExecuteSql=False
			end if

			if bExecuteSql then
				App.Data.ConDb.Execute szSqlIstr
				If len(App.Data.ConDb.ErrSql) > 0 then Wscript.Echo App.Data.ConDb.ErrSql

				if Not (App.Data.Export is Nothing) And ucase(left(szSqlIstr,6))="SELECT" then
					App.Data.Export.Export App.Data.ConDb.ResultSet
				else
					App.Data.Print.Title=""
					App.Data.Print.DisplayNumRow=True
					App.Data.Print.PrintResultSQL
				end if
			End if
		end if
		szOldSqlIstr=szSqlIstr
		szSqlIstr=""
		FlagPrompt=0
	Elseif left(szTemp,1) = "\" and FlagPrompt <> 2 Then
		wscript.echo App.Data.Message.InvalidCommand(szTemp)
	Else
		If len(szIstr) > 0 then
			szSqlIstr = szSqlIstr & szIstr & VbCrLf 

			'Verify if string is in quote
			if (len(szIstr)-len(replace(szIstr,"'",""))) Mod 2 <> 0 then
				if FlagPrompt = 2 then
					FlagPrompt=1
				else
					FlagPrompt=2
				end if 
			else
				if FlagPrompt=0 then FlagPrompt=1
			end if
		End If
	End if
End Function
