/*
 * Copyright (c) 2007, 2022 -2022 Apple Inc.  All rights reserved.
 * Copyright (c) 2015 Igalia
 * Copyright (c) 2015 Igalia S.L.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2015, 2016 Canon Inc. All rights reserved.
 * Copyright (c) 2015, 2016, 2017 Canon Inc.
 * Copyright (c) 2016, 2020, 2022 Apple Inc. All rights reserved.
 * Copyright (c) 2017 Apple Inc.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "WebCoreJSBuiltinInternals.h"

#include "JSDOMGlobalObject.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/JSObjectInlines.h>

namespace WebCore {

JSBuiltinInternalFunctions::JSBuiltinInternalFunctions(JSC::VM& vm)
    : m_vm(vm)
    , m_readableByteStreamInternals(m_vm)
    , m_readableStreamInternals(m_vm)
    , m_streamInternals(m_vm)
    , m_transformStreamInternals(m_vm)
    , m_writableStreamInternals(m_vm)
    , m_jsDOMBindingInternals(m_vm)
    , m_commandLineAPIModuleSource(m_vm)
{
    UNUSED_PARAM(vm);
}

template<typename Visitor>
void JSBuiltinInternalFunctions::visit(Visitor& visitor)
{
    m_readableByteStreamInternals.visit(visitor);
    m_readableStreamInternals.visit(visitor);
    m_streamInternals.visit(visitor);
    m_transformStreamInternals.visit(visitor);
    m_writableStreamInternals.visit(visitor);
    m_jsDOMBindingInternals.visit(visitor);
    m_commandLineAPIModuleSource.visit(visitor);
    UNUSED_PARAM(visitor);
}

template void JSBuiltinInternalFunctions::visit(AbstractSlotVisitor&);
template void JSBuiltinInternalFunctions::visit(SlotVisitor&);

SUPPRESS_ASAN void JSBuiltinInternalFunctions::initialize(JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(globalObject);
    m_readableByteStreamInternals.init(globalObject);
    m_readableStreamInternals.init(globalObject);
    m_streamInternals.init(globalObject);
    m_transformStreamInternals.init(globalObject);
    m_writableStreamInternals.init(globalObject);
    m_jsDOMBindingInternals.init(globalObject);
    m_commandLineAPIModuleSource.init(globalObject);

    JSVMClientData& clientData = *static_cast<JSVMClientData*>(m_vm.clientData);
    JSDOMGlobalObject::GlobalPropertyInfo staticGlobals[] = {
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().readableByteStreamInternalsBuiltins().name##PrivateName(), readableByteStreamInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_READABLEBYTESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().readableStreamInternalsBuiltins().name##PrivateName(), readableStreamInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().streamInternalsBuiltins().name##PrivateName(), streamInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_STREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().transformStreamInternalsBuiltins().name##PrivateName(), transformStreamInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_TRANSFORMSTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().writableStreamInternalsBuiltins().name##PrivateName(), writableStreamInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_WRITABLESTREAMINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().jsDOMBindingInternalsBuiltins().name##PrivateName(), jsDOMBindingInternals().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_JSDOMBINDINGINTERNALS_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
#define DECLARE_GLOBAL_STATIC(name) \
    JSDOMGlobalObject::GlobalPropertyInfo( \
        clientData.builtinFunctions().commandLineAPIModuleSourceBuiltins().name##PrivateName(), commandLineAPIModuleSource().m_##name##Function.get() , JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly),
    WEBCORE_FOREACH_COMMANDLINEAPIMODULESOURCE_BUILTIN_FUNCTION_NAME(DECLARE_GLOBAL_STATIC)
#undef DECLARE_GLOBAL_STATIC
    };
    globalObject.addStaticGlobals(staticGlobals, std::size(staticGlobals));
    UNUSED_PARAM(clientData);
}

} // namespace WebCore
