/*
 * Copyright (c) 2015 Canon Inc. All rights reserved.
 * Copyright (c) 2015 Igalia.
 * Copyright (c) 2016 Apple Inc. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#include "config.h"
#include "ReadableStreamInternalsBuiltins.h"

#include "WebCoreJSClientData.h"
#include <JavaScriptCore/IdentifierInlines.h>
#include <JavaScriptCore/ImplementationVisibility.h>
#include <JavaScriptCore/Intrinsic.h>
#include <JavaScriptCore/JSObjectInlines.h>
#include <JavaScriptCore/VM.h>

namespace WebCore {

const JSC::ConstructAbility s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeLength = 3185;
static const JSC::Intrinsic s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsCreateInternalReadableStreamFromUnderlyingSourceCode =
    "(function (underlyingSource, strategy)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = { };\n" \
    "\n" \
    "    if (underlyingSource === @undefined)\n" \
    "         underlyingSource = { };\n" \
    "     if (strategy === @undefined)\n" \
    "         strategy = { };\n" \
    "\n" \
    "    if (!@isObject(underlyingSource))\n" \
    "        @throwTypeError(\"ReadableStream constructor takes an object as first argument\");\n" \
    "\n" \
    "    if (strategy !== @undefined && !@isObject(strategy))\n" \
    "        @throwTypeError(\"ReadableStream constructor takes an object as second argument, if any\");\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"state\", @streamReadable);\n" \
    "    @putByIdDirectPrivate(stream, \"reader\", @undefined);\n" \
    "    @putByIdDirectPrivate(stream, \"storedError\", @undefined);\n" \
    "    @putByIdDirectPrivate(stream, \"disturbed\", false);\n" \
    "    //\n" \
    "    @putByIdDirectPrivate(stream, \"readableStreamController\", null);\n" \
    "    @putByIdDirectPrivate(stream, \"globalObject\", @getGlobalObject());\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    if (underlyingSource.@pull !== @undefined) {\n" \
    "        const size = @getByIdDirectPrivate(strategy, \"size\");\n" \
    "        const highWaterMark = @getByIdDirectPrivate(strategy, \"highWaterMark\");\n" \
    "        @setupReadableStreamDefaultController(stream, underlyingSource, size, highWaterMark !== @undefined ? highWaterMark : 1, underlyingSource.@start, underlyingSource.@pull, underlyingSource.@cancel);\n" \
    "        return stream;\n" \
    "    }\n" \
    "\n" \
    "    const type = underlyingSource.type;\n" \
    "    const typeString = @toString(type);\n" \
    "\n" \
    "    if (typeString === \"bytes\") {\n" \
    "        if (!@readableByteStreamAPIEnabled())\n" \
    "            @throwTypeError(\"ReadableByteStreamController is not implemented\");\n" \
    "\n" \
    "        if (strategy.highWaterMark === @undefined)\n" \
    "            strategy.highWaterMark = 0;\n" \
    "        if (strategy.size !== @undefined)\n" \
    "            @throwRangeError(\"Strategy for a ReadableByteStreamController cannot have a size\");\n" \
    "\n" \
    "        let readableByteStreamControllerConstructor = @ReadableByteStreamController;\n" \
    "        @putByIdDirectPrivate(stream, \"readableStreamController\", new @ReadableByteStreamController(stream, underlyingSource, strategy.highWaterMark, @isReadableStream));\n" \
    "    } else if (type === @undefined) {\n" \
    "        let highWaterMark = strategy.highWaterMark;\n" \
    "        if (highWaterMark !== @undefined)\n" \
    "            highWaterMark = @toNumber(highWaterMark);\n" \
    "        else\n" \
    "            highWaterMark = 1;\n" \
    "        const size = strategy.size;\n" \
    "        if (size !== @undefined && !@isCallable(size))\n" \
    "            @throwTypeError(\"size parameter must be a function\");\n" \
    "\n" \
    "        const cancel = underlyingSource.cancel;\n" \
    "        if (cancel !== @undefined && !@isCallable(cancel))\n" \
    "            @throwTypeError(\"underlyingSource cancel must be a function\");\n" \
    "        const pull = underlyingSource.pull;\n" \
    "        if (pull !== @undefined && !@isCallable(pull))\n" \
    "            @throwTypeError(\"underlyingSource pull must be a function\");\n" \
    "        const start = underlyingSource.start;\n" \
    "        if (start !== @undefined && !@isCallable(start))\n" \
    "            @throwTypeError(\"underlyingSource start must be a function\");\n" \
    "\n" \
    "        @setupReadableStreamDefaultController(stream, underlyingSource, size, highWaterMark, start, pull, cancel);\n" \
    "    } else\n" \
    "        @throwTypeError(\"Invalid type for underlying source\");\n" \
    "\n" \
    "    return stream;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamGetReaderForBindingsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamGetReaderForBindingsCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamGetReaderForBindingsCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamGetReaderForBindingsCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamGetReaderForBindingsCodeLength = 820;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamGetReaderForBindingsCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamGetReaderForBindingsCode =
    "(function (stream, options)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "\n" \
    "    const mode = @toDictionary(options, { }, \"ReadableStream.getReader takes an object as first argument\").mode;\n" \
    "    const readableStreamGlobalObject = @getByIdDirectPrivate(stream, \"globalObject\");\n" \
    "\n" \
    "    if (mode === @undefined) {\n" \
    "        const readableStreamDefaultReaderConstructor = @getByIdDirectPrivate(readableStreamGlobalObject, \"ReadableStreamDefaultReader\");\n" \
    "        return new readableStreamDefaultReaderConstructor(stream);\n" \
    "    }\n" \
    "\n" \
    "    //\n" \
    "    if (mode == 'byob') {\n" \
    "        const readableStreamBYOBReaderConstructor = @getByIdDirectPrivate(readableStreamGlobalObject, \"ReadableStreamBYOBReader\");\n" \
    "        return new readableStreamBYOBReaderConstructor(stream);\n" \
    "    }\n" \
    "\n" \
    "    @throwTypeError(\"Invalid mode is specified\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamCancelForBindingsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamCancelForBindingsCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamCancelForBindingsCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamCancelForBindingsCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamCancelForBindingsCodeLength = 261;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamCancelForBindingsCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamCancelForBindingsCode =
    "(function (stream, reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "\n" \
    "    if (@isReadableStreamLocked(stream))\n" \
    "        return @Promise.@reject(@makeTypeError(\"ReadableStream is locked\"));\n" \
    "\n" \
    "    return @readableStreamCancel(stream, reason);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeLength = 1579;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamPipeThroughForBindingsCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamPipeThroughForBindingsCode =
    "(function (thisStream, streams, options)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(thisStream));\n" \
    "\n" \
    "    const transforms = streams;\n" \
    "\n" \
    "    const readable = transforms[\"readable\"];\n" \
    "    const internalReadable = @getInternalReadableStream(readable);\n" \
    "    if (!@isReadableStream(internalReadable))\n" \
    "        throw @makeTypeError(\"readable should be ReadableStream\");\n" \
    "\n" \
    "    const writable = transforms[\"writable\"];\n" \
    "    const internalWritable = @getInternalWritableStream(writable);\n" \
    "    if (!@isWritableStream(internalWritable))\n" \
    "        throw @makeTypeError(\"writable should be WritableStream\");\n" \
    "\n" \
    "    let preventClose = false;\n" \
    "    let preventAbort = false;\n" \
    "    let preventCancel = false;\n" \
    "    let signal;\n" \
    "    if (!@isUndefinedOrNull(options)) {\n" \
    "        if (!@isObject(options))\n" \
    "            throw @makeTypeError(\"options must be an object\");\n" \
    "\n" \
    "        preventAbort = !!options[\"preventAbort\"];\n" \
    "        preventCancel = !!options[\"preventCancel\"];\n" \
    "        preventClose = !!options[\"preventClose\"];\n" \
    "\n" \
    "        signal = options[\"signal\"];\n" \
    "        if (signal !== @undefined && !@isAbortSignal(signal))\n" \
    "            throw @makeTypeError(\"options.signal must be AbortSignal\");\n" \
    "    }\n" \
    "\n" \
    "    if (@isReadableStreamLocked(thisStream))\n" \
    "        throw @makeTypeError(\"ReadableStream is locked\");\n" \
    "\n" \
    "    if (@isWritableStreamLocked(internalWritable))\n" \
    "        throw @makeTypeError(\"WritableStream is locked\");\n" \
    "\n" \
    "    const promise = @readableStreamPipeToWritableStream(thisStream, internalWritable, preventClose, preventAbort, preventCancel, signal);\n" \
    "    @markPromiseAsHandled(promise);\n" \
    "\n" \
    "    return readable;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamPipeToForBindingsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamPipeToForBindingsCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamPipeToForBindingsCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamPipeToForBindingsCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamPipeToForBindingsCodeLength = 1422;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamPipeToForBindingsCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamPipeToForBindingsCode =
    "(function (stream, destination, options)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "\n" \
    "    let preventClose = false;\n" \
    "    let preventAbort = false;\n" \
    "    let preventCancel = false;\n" \
    "    let signal;\n" \
    "    if (!@isUndefinedOrNull(options)) {\n" \
    "        if (!@isObject(options))\n" \
    "            return @Promise.@reject(@makeTypeError(\"options must be an object\"));\n" \
    "\n" \
    "        try {\n" \
    "            preventAbort = !!options[\"preventAbort\"];\n" \
    "            preventCancel = !!options[\"preventCancel\"];\n" \
    "            preventClose = !!options[\"preventClose\"];\n" \
    "\n" \
    "            signal = options[\"signal\"];\n" \
    "        } catch(e) {\n" \
    "            return @Promise.@reject(e);\n" \
    "        }\n" \
    "\n" \
    "        if (signal !== @undefined && !@isAbortSignal(signal))\n" \
    "            return @Promise.@reject(@makeTypeError(\"options.signal must be AbortSignal\"));\n" \
    "    }\n" \
    "\n" \
    "    const internalDestination = @getInternalWritableStream(destination);\n" \
    "    if (!@isWritableStream(internalDestination))\n" \
    "        return @Promise.@reject(@makeTypeError(\"ReadableStream pipeTo requires a WritableStream\"));\n" \
    "\n" \
    "    if (@isReadableStreamLocked(stream))\n" \
    "        return @Promise.@reject(@makeTypeError(\"ReadableStream is locked\"));\n" \
    "\n" \
    "    if (@isWritableStreamLocked(internalDestination))\n" \
    "        return @Promise.@reject(@makeTypeError(\"WritableStream is locked\"));\n" \
    "\n" \
    "    return @readableStreamPipeToWritableStream(stream, internalDestination, preventClose, preventAbort, preventCancel, signal);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeLength = 754;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamReaderGenericInitializeCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamReaderGenericInitializeCode =
    "(function (reader, stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @putByIdDirectPrivate(reader, \"ownerReadableStream\", stream);\n" \
    "    @putByIdDirectPrivate(stream, \"reader\", reader);\n" \
    "    if (@getByIdDirectPrivate(stream, \"state\") === @streamReadable)\n" \
    "        @putByIdDirectPrivate(reader, \"closedPromiseCapability\", @newPromiseCapability(@Promise));\n" \
    "    else if (@getByIdDirectPrivate(stream, \"state\") === @streamClosed)\n" \
    "        @putByIdDirectPrivate(reader, \"closedPromiseCapability\", { promise: @Promise.@resolve() });\n" \
    "    else {\n" \
    "        @assert(@getByIdDirectPrivate(stream, \"state\") === @streamErrored);\n" \
    "        @putByIdDirectPrivate(reader, \"closedPromiseCapability\", { promise: @newHandledRejectedPromise(@getByIdDirectPrivate(stream, \"storedError\")) });\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeLength = 884;
static const JSC::Intrinsic s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsPrivateInitializeReadableStreamDefaultControllerCode =
    "(function (stream, underlyingSource, size, highWaterMark)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    if (!@isReadableStream(stream))\n" \
    "        @throwTypeError(\"ReadableStreamDefaultController needs a ReadableStream\");\n" \
    "\n" \
    "    //\n" \
    "    if (@getByIdDirectPrivate(stream, \"readableStreamController\") !== null)\n" \
    "        @throwTypeError(\"ReadableStream already has a controller\");\n" \
    "\n" \
    "    @putByIdDirectPrivate(this, \"controlledReadableStream\", stream);\n" \
    "    @putByIdDirectPrivate(this, \"underlyingSource\", underlyingSource);\n" \
    "    @putByIdDirectPrivate(this, \"queue\", @newQueue());\n" \
    "    @putByIdDirectPrivate(this, \"started\", false);\n" \
    "    @putByIdDirectPrivate(this, \"closeRequested\", false);\n" \
    "    @putByIdDirectPrivate(this, \"pullAgain\", false);\n" \
    "    @putByIdDirectPrivate(this, \"pulling\", false);\n" \
    "    @putByIdDirectPrivate(this, \"strategy\", @validateAndNormalizeQueuingStrategy(size, highWaterMark));\n" \
    "\n" \
    "    return this;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeLength = 1360;
static const JSC::Intrinsic s_readableStreamInternalsSetupReadableStreamDefaultControllerCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsSetupReadableStreamDefaultControllerCode =
    "(function (stream, underlyingSource, size, highWaterMark, startMethod, pullMethod, cancelMethod)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    const controller = new @ReadableStreamDefaultController(stream, underlyingSource, size, highWaterMark, @isReadableStream);\n" \
    "    const startAlgorithm = () => @promiseInvokeOrNoopMethodNoCatch(underlyingSource, startMethod, [controller]);\n" \
    "    const pullAlgorithm = () => @promiseInvokeOrNoopMethod(underlyingSource, pullMethod, [controller]);\n" \
    "    const cancelAlgorithm = (reason) => @promiseInvokeOrNoopMethod(underlyingSource, cancelMethod, [reason]);\n" \
    "\n" \
    "    @putByIdDirectPrivate(controller, \"pullAlgorithm\", pullAlgorithm);\n" \
    "    @putByIdDirectPrivate(controller, \"cancelAlgorithm\", cancelAlgorithm);\n" \
    "    @putByIdDirectPrivate(controller, \"pull\", @readableStreamDefaultControllerPull);\n" \
    "    @putByIdDirectPrivate(controller, \"cancel\", @readableStreamDefaultControllerCancel);\n" \
    "    @putByIdDirectPrivate(stream, \"readableStreamController\", controller);\n" \
    "\n" \
    "    startAlgorithm().@then(() => {\n" \
    "        @putByIdDirectPrivate(controller, \"started\", true);\n" \
    "        @assert(!@getByIdDirectPrivate(controller, \"pulling\"));\n" \
    "        @assert(!@getByIdDirectPrivate(controller, \"pullAgain\"));\n" \
    "        @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "    }, (error) => {\n" \
    "        @readableStreamDefaultControllerError(controller, error);\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeLength = 322;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerErrorCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerErrorCode =
    "(function (controller, error)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    if (@getByIdDirectPrivate(stream, \"state\") !== @streamReadable)\n" \
    "        return;\n" \
    "    @putByIdDirectPrivate(controller, \"queue\", @newQueue());\n" \
    "    @readableStreamError(stream, error);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamPipeToCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamPipeToCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamPipeToCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamPipeToCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamPipeToCodeLength = 780;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamPipeToCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamPipeToCode =
    "(function (stream, sink)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "\n" \
    "    const reader = @acquireReadableStreamDefaultReader(stream);\n" \
    "\n" \
    "    @getByIdDirectPrivate(reader, \"closedPromiseCapability\").promise.@then(() => { }, (e) => { sink.error(e); });\n" \
    "\n" \
    "    function doPipe() {\n" \
    "        @readableStreamDefaultReaderRead(reader).@then(function(result) {\n" \
    "            if (result.done) {\n" \
    "                sink.close();\n" \
    "                return;\n" \
    "            }\n" \
    "            try {\n" \
    "                sink.enqueue(result.value);\n" \
    "            } catch (e) {\n" \
    "                sink.error(\"ReadableStream chunk enqueueing in the sink failed\");\n" \
    "                return;\n" \
    "            }\n" \
    "            doPipe();\n" \
    "        }, function(e) {\n" \
    "            sink.error(e);\n" \
    "        });\n" \
    "    }\n" \
    "    doPipe();\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeLength = 306;
static const JSC::Intrinsic s_readableStreamInternalsAcquireReadableStreamDefaultReaderCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsAcquireReadableStreamDefaultReaderCode =
    "(function (stream)\n" \
    "{\n" \
    "    const readableStreamGlobalObject = @getByIdDirectPrivate(stream, \"globalObject\");\n" \
    "    const readableStreamDefaultReaderConstructor = @getByIdDirectPrivate(readableStreamGlobalObject, \"ReadableStreamDefaultReader\");\n" \
    "    return new readableStreamDefaultReaderConstructor(stream);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeLength = 3154;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamPipeToWritableStreamCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamPipeToWritableStreamCode =
    "(function (source, destination, preventClose, preventAbort, preventCancel, signal)\n" \
    "{\n" \
    "    @assert(@isReadableStream(source));\n" \
    "    @assert(@isWritableStream(destination));\n" \
    "    @assert(!@isReadableStreamLocked(source));\n" \
    "    @assert(!@isWritableStreamLocked(destination));\n" \
    "    @assert(signal === @undefined || @isAbortSignal(signal));\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(source, \"underlyingByteSource\") !== @undefined)\n" \
    "        return @Promise.@reject(\"Piping of readable by strean is not supported\");\n" \
    "\n" \
    "    let pipeState = { source : source, destination : destination, preventAbort : preventAbort, preventCancel : preventCancel, preventClose : preventClose, signal : signal };\n" \
    "\n" \
    "    pipeState.reader = @acquireReadableStreamDefaultReader(source);\n" \
    "    pipeState.writer = @acquireWritableStreamDefaultWriter(destination);\n" \
    "\n" \
    "    @putByIdDirectPrivate(source, \"disturbed\", true);\n" \
    "\n" \
    "    pipeState.shuttingDown = false;\n" \
    "    pipeState.promiseCapability = @newPromiseCapability(@Promise);\n" \
    "    pipeState.pendingReadPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "    pipeState.pendingReadPromiseCapability.resolve.@call();\n" \
    "    pipeState.pendingWritePromise = @Promise.@resolve();\n" \
    "\n" \
    "    if (signal !== @undefined) {\n" \
    "        const algorithm = (reason) => {\n" \
    "            @pipeToShutdownWithAction(pipeState, () => {\n" \
    "                const shouldAbortDestination = !pipeState.preventAbort && @getByIdDirectPrivate(pipeState.destination, \"state\") === \"writable\";\n" \
    "                const promiseDestination = shouldAbortDestination ? @writableStreamAbort(pipeState.destination, reason) : @Promise.@resolve();\n" \
    "\n" \
    "                const shouldAbortSource = !pipeState.preventCancel && @getByIdDirectPrivate(pipeState.source, \"state\") === @streamReadable;\n" \
    "                const promiseSource = shouldAbortSource ? @readableStreamCancel(pipeState.source, reason) : @Promise.@resolve();\n" \
    "\n" \
    "                let promiseCapability = @newPromiseCapability(@Promise);\n" \
    "                let shouldWait = true;\n" \
    "                let handleResolvedPromise = () => {\n" \
    "                    if (shouldWait) {\n" \
    "                        shouldWait = false;\n" \
    "                        return;\n" \
    "                    }\n" \
    "                    promiseCapability.resolve.@call();\n" \
    "                }\n" \
    "                let handleRejectedPromise = (e) => {\n" \
    "                    promiseCapability.reject.@call(@undefined, e);\n" \
    "                }\n" \
    "                promiseDestination.@then(handleResolvedPromise, handleRejectedPromise);\n" \
    "                promiseSource.@then(handleResolvedPromise, handleRejectedPromise);\n" \
    "                return promiseCapability.promise;\n" \
    "            }, reason);\n" \
    "        };\n" \
    "        pipeState.abortAlgorithmIdentifier = @addAbortAlgorithmToSignal(signal, algorithm)\n" \
    "        if (!pipeState.abortAlgorithmIdentifier)\n" \
    "            return pipeState.promiseCapability.promise;\n" \
    "        pipeState.signal = signal;\n" \
    "    }\n" \
    "\n" \
    "    @pipeToErrorsMustBePropagatedForward(pipeState);\n" \
    "    @pipeToErrorsMustBePropagatedBackward(pipeState);\n" \
    "    @pipeToClosingMustBePropagatedForward(pipeState);\n" \
    "    @pipeToClosingMustBePropagatedBackward(pipeState);\n" \
    "\n" \
    "    @pipeToLoop(pipeState);\n" \
    "\n" \
    "    return pipeState.promiseCapability.promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPipeToLoopCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsPipeToLoopCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsPipeToLoopCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsPipeToLoopCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsPipeToLoopCodeLength = 194;
static const JSC::Intrinsic s_readableStreamInternalsPipeToLoopCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsPipeToLoopCode =
    "(function (pipeState)\n" \
    "{\n" \
    "    if (pipeState.shuttingDown)\n" \
    "        return;\n" \
    "\n" \
    "    @pipeToDoReadWrite(pipeState).@then((result) => {\n" \
    "        if (result)\n" \
    "            @pipeToLoop(pipeState);\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPipeToDoReadWriteCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsPipeToDoReadWriteCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsPipeToDoReadWriteCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsPipeToDoReadWriteCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsPipeToDoReadWriteCodeLength = 1131;
static const JSC::Intrinsic s_readableStreamInternalsPipeToDoReadWriteCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsPipeToDoReadWriteCode =
    "(function (pipeState)\n" \
    "{\n" \
    "    @assert(!pipeState.shuttingDown);\n" \
    "\n" \
    "    pipeState.pendingReadPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "    @getByIdDirectPrivate(pipeState.writer, \"readyPromise\").promise.@then(() => {\n" \
    "        if (pipeState.shuttingDown) {\n" \
    "            pipeState.pendingReadPromiseCapability.resolve.@call(@undefined, false);\n" \
    "            return;\n" \
    "        }\n" \
    "\n" \
    "        @readableStreamDefaultReaderRead(pipeState.reader).@then((result) => {\n" \
    "            const canWrite = !result.done && @getByIdDirectPrivate(pipeState.writer, \"stream\") !== @undefined;\n" \
    "            pipeState.pendingReadPromiseCapability.resolve.@call(@undefined, canWrite);\n" \
    "            if (!canWrite)\n" \
    "                return;\n" \
    "\n" \
    "            pipeState.pendingWritePromise = @writableStreamDefaultWriterWrite(pipeState.writer, result.value).@then(@undefined, () => { });\n" \
    "        }, (e) => {\n" \
    "            pipeState.pendingReadPromiseCapability.resolve.@call(@undefined, false);\n" \
    "        });\n" \
    "    }, (e) => {\n" \
    "        pipeState.pendingReadPromiseCapability.resolve.@call(@undefined, false);\n" \
    "    });\n" \
    "    return pipeState.pendingReadPromiseCapability.promise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeLength = 674;
static const JSC::Intrinsic s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsPipeToErrorsMustBePropagatedForwardCode =
    "(function (pipeState)\n" \
    "{\n" \
    "    const action = () => {\n" \
    "        pipeState.pendingReadPromiseCapability.resolve.@call(@undefined, false);\n" \
    "        const error = @getByIdDirectPrivate(pipeState.source, \"storedError\");\n" \
    "        if (!pipeState.preventAbort) {\n" \
    "            @pipeToShutdownWithAction(pipeState, () => @writableStreamAbort(pipeState.destination, error), error);\n" \
    "            return;\n" \
    "        }\n" \
    "        @pipeToShutdown(pipeState, error);\n" \
    "    };\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(pipeState.source, \"state\") === @streamErrored) {\n" \
    "        action();\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    @getByIdDirectPrivate(pipeState.reader, \"closedPromiseCapability\").promise.@then(@undefined, action);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeLength = 583;
static const JSC::Intrinsic s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsPipeToErrorsMustBePropagatedBackwardCode =
    "(function (pipeState)\n" \
    "{\n" \
    "    const action = () => {\n" \
    "        const error = @getByIdDirectPrivate(pipeState.destination, \"storedError\");\n" \
    "        if (!pipeState.preventCancel) {\n" \
    "            @pipeToShutdownWithAction(pipeState, () => @readableStreamCancel(pipeState.source, error), error);\n" \
    "            return;\n" \
    "        }\n" \
    "        @pipeToShutdown(pipeState, error);\n" \
    "    };\n" \
    "    if (@getByIdDirectPrivate(pipeState.destination, \"state\") === \"errored\") {\n" \
    "        action();\n" \
    "        return;\n" \
    "    }\n" \
    "    @getByIdDirectPrivate(pipeState.writer, \"closedPromise\").promise.@then(@undefined, action);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeLength = 677;
static const JSC::Intrinsic s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsPipeToClosingMustBePropagatedForwardCode =
    "(function (pipeState)\n" \
    "{\n" \
    "    const action = () => {\n" \
    "        pipeState.pendingReadPromiseCapability.resolve.@call(@undefined, false);\n" \
    "        const error = @getByIdDirectPrivate(pipeState.source, \"storedError\");\n" \
    "        if (!pipeState.preventClose) {\n" \
    "            @pipeToShutdownWithAction(pipeState, () => @writableStreamDefaultWriterCloseWithErrorPropagation(pipeState.writer));\n" \
    "            return;\n" \
    "        }\n" \
    "        @pipeToShutdown(pipeState);\n" \
    "    };\n" \
    "    if (@getByIdDirectPrivate(pipeState.source, \"state\") === @streamClosed) {\n" \
    "        action();\n" \
    "        return;\n" \
    "    }\n" \
    "    @getByIdDirectPrivate(pipeState.reader, \"closedPromiseCapability\").promise.@then(action, () => { });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeLength = 464;
static const JSC::Intrinsic s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsPipeToClosingMustBePropagatedBackwardCode =
    "(function (pipeState)\n" \
    "{\n" \
    "    if (!@writableStreamCloseQueuedOrInFlight(pipeState.destination) && @getByIdDirectPrivate(pipeState.destination, \"state\") !== \"closed\")\n" \
    "        return;\n" \
    "\n" \
    "    //\n" \
    "\n" \
    "    const error = @makeTypeError(\"closing is propagated backward\");\n" \
    "    if (!pipeState.preventCancel) {\n" \
    "        @pipeToShutdownWithAction(pipeState, () => @readableStreamCancel(pipeState.source, error), error);\n" \
    "        return;\n" \
    "    }\n" \
    "    @pipeToShutdown(pipeState, error);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPipeToShutdownWithActionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsPipeToShutdownWithActionCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsPipeToShutdownWithActionCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsPipeToShutdownWithActionCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsPipeToShutdownWithActionCodeLength = 881;
static const JSC::Intrinsic s_readableStreamInternalsPipeToShutdownWithActionCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsPipeToShutdownWithActionCode =
    "(function (pipeState, action)\n" \
    "{\n" \
    "    if (pipeState.shuttingDown)\n" \
    "        return;\n" \
    "\n" \
    "    pipeState.shuttingDown = true;\n" \
    "\n" \
    "    const hasError = arguments.length > 2;\n" \
    "    const error = arguments[2];\n" \
    "    const finalize = () => {\n" \
    "        const promise = action();\n" \
    "        promise.@then(() => {\n" \
    "            if (hasError)\n" \
    "                @pipeToFinalize(pipeState, error);\n" \
    "            else\n" \
    "                @pipeToFinalize(pipeState);\n" \
    "        }, (e)  => {\n" \
    "            @pipeToFinalize(pipeState, e);\n" \
    "        });\n" \
    "    };\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(pipeState.destination, \"state\") === \"writable\" && !@writableStreamCloseQueuedOrInFlight(pipeState.destination)) {\n" \
    "        pipeState.pendingReadPromiseCapability.promise.@then(() => {\n" \
    "            pipeState.pendingWritePromise.@then(finalize, finalize);\n" \
    "        }, (e) => @pipeToFinalize(pipeState, e));\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    finalize();\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPipeToShutdownCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsPipeToShutdownCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsPipeToShutdownCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsPipeToShutdownCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsPipeToShutdownCodeLength = 716;
static const JSC::Intrinsic s_readableStreamInternalsPipeToShutdownCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsPipeToShutdownCode =
    "(function (pipeState)\n" \
    "{\n" \
    "    if (pipeState.shuttingDown)\n" \
    "        return;\n" \
    "\n" \
    "    pipeState.shuttingDown = true;\n" \
    "\n" \
    "    const hasError = arguments.length > 1;\n" \
    "    const error = arguments[1];\n" \
    "    const finalize = () => {\n" \
    "        if (hasError)\n" \
    "            @pipeToFinalize(pipeState, error);\n" \
    "        else\n" \
    "            @pipeToFinalize(pipeState);\n" \
    "    };\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(pipeState.destination, \"state\") === \"writable\" && !@writableStreamCloseQueuedOrInFlight(pipeState.destination)) {\n" \
    "        pipeState.pendingReadPromiseCapability.promise.@then(() => {\n" \
    "            pipeState.pendingWritePromise.@then(finalize, finalize);\n" \
    "        }, (e) => @pipeToFinalize(pipeState, e));\n" \
    "        return;\n" \
    "    }\n" \
    "    finalize();\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsPipeToFinalizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsPipeToFinalizeCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsPipeToFinalizeCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsPipeToFinalizeCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsPipeToFinalizeCodeLength = 435;
static const JSC::Intrinsic s_readableStreamInternalsPipeToFinalizeCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsPipeToFinalizeCode =
    "(function (pipeState)\n" \
    "{\n" \
    "    @writableStreamDefaultWriterRelease(pipeState.writer);\n" \
    "    @readableStreamReaderGenericRelease(pipeState.reader);\n" \
    "\n" \
    "    if (pipeState.signal)\n" \
    "        @removeAbortAlgorithmFromSignal(pipeState.signal, pipeState.abortAlgorithmIdentifier)\n" \
    "\n" \
    "    if (arguments.length > 1)\n" \
    "        pipeState.promiseCapability.reject.@call(@undefined, arguments[1]);\n" \
    "    else\n" \
    "        pipeState.promiseCapability.resolve.@call();\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamTeeCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamTeeCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamTeeCodeLength = 1675;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamTeeCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamTeeCode =
    "(function (stream, shouldClone)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "    @assert(typeof(shouldClone) === \"boolean\");\n" \
    "\n" \
    "    const reader = @acquireReadableStreamDefaultReader(stream);\n" \
    "\n" \
    "    const teeState = {\n" \
    "        stream: stream,\n" \
    "        canceled1: false,\n" \
    "        canceled2: false,\n" \
    "        reason1: @undefined,\n" \
    "        reason2: @undefined,\n" \
    "        reading: false,\n" \
    "        readAgain: false,\n" \
    "    };\n" \
    "\n" \
    "    teeState.cancelPromiseCapability = @newPromiseCapability(@Promise);\n" \
    "\n" \
    "    const pullFunction = @readableStreamTeePullFunction(teeState, reader, shouldClone);\n" \
    "\n" \
    "    const branch1Source = { };\n" \
    "    @putByIdDirectPrivate(branch1Source, \"pull\", pullFunction);\n" \
    "    @putByIdDirectPrivate(branch1Source, \"cancel\", @readableStreamTeeBranch1CancelFunction(teeState, stream));\n" \
    "\n" \
    "    const branch2Source = { };\n" \
    "    @putByIdDirectPrivate(branch2Source, \"pull\", pullFunction);\n" \
    "    @putByIdDirectPrivate(branch2Source, \"cancel\", @readableStreamTeeBranch2CancelFunction(teeState, stream));\n" \
    "\n" \
    "    const branch1 = @createInternalReadableStreamFromUnderlyingSource(branch1Source);\n" \
    "    const branch2 = @createInternalReadableStreamFromUnderlyingSource(branch2Source);\n" \
    "\n" \
    "    @getByIdDirectPrivate(reader, \"closedPromiseCapability\").promise.@then(@undefined, function(e) {\n" \
    "        @readableStreamDefaultControllerError(branch1.@readableStreamController, e);\n" \
    "        @readableStreamDefaultControllerError(branch2.@readableStreamController, e);\n" \
    "        if (!teeState.canceled1 || !teeState.canceled2)\n" \
    "            teeState.cancelPromiseCapability.resolve.@call();\n" \
    "    });\n" \
    "\n" \
    "    //\n" \
    "    teeState.branch1 = branch1;\n" \
    "    teeState.branch2 = branch2;\n" \
    "\n" \
    "    return [branch1, branch2];\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeePullFunctionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeePullFunctionCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamTeePullFunctionCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamTeePullFunctionCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamTeePullFunctionCodeLength = 2359;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamTeePullFunctionCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamTeePullFunctionCode =
    "(function (teeState, reader, shouldClone)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const pullAlgorithm = function() {\n" \
    "        if (teeState.reading) {\n" \
    "            teeState.readAgain = true;\n" \
    "            return @Promise.@resolve();\n" \
    "        }\n" \
    "        teeState.reading = true;\n" \
    "        @Promise.prototype.@then.@call(@readableStreamDefaultReaderRead(reader), function(result) {\n" \
    "            @assert(@isObject(result));\n" \
    "            @assert(typeof result.done === \"boolean\");\n" \
    "            if (result.done) {\n" \
    "                //\n" \
    "                teeState.reading = false;\n" \
    "                if (!teeState.canceled1)\n" \
    "                    @readableStreamDefaultControllerClose(teeState.branch1.@readableStreamController);\n" \
    "                if (!teeState.canceled2)\n" \
    "                    @readableStreamDefaultControllerClose(teeState.branch2.@readableStreamController);\n" \
    "                if (!teeState.canceled1 || !teeState.canceled2)\n" \
    "                    teeState.cancelPromiseCapability.resolve.@call();\n" \
    "                return;\n" \
    "            }\n" \
    "            //\n" \
    "            teeState.readAgain = false;\n" \
    "            let chunk1 = result.value;\n" \
    "            let chunk2 = result.value;\n" \
    "            if (!teeState.canceled2 && shouldClone) {\n" \
    "                try {\n" \
    "                    chunk2 = @structuredCloneForStream(result.value);\n" \
    "                } catch (e) {\n" \
    "                    @readableStreamDefaultControllerError(teeState.branch1.@readableStreamController, e);\n" \
    "                    @readableStreamDefaultControllerError(teeState.branch2.@readableStreamController, e);\n" \
    "                    @readableStreamCancel(teeState.stream, e).@then(teeState.cancelPromiseCapability.resolve, teeState.cancelPromiseCapability.reject);\n" \
    "                    return;\n" \
    "                }\n" \
    "            }\n" \
    "            if (!teeState.canceled1)\n" \
    "                @readableStreamDefaultControllerEnqueue(teeState.branch1.@readableStreamController, chunk1);\n" \
    "            if (!teeState.canceled2)\n" \
    "                @readableStreamDefaultControllerEnqueue(teeState.branch2.@readableStreamController, chunk2);\n" \
    "            teeState.reading = false\n" \
    "\n" \
    "            @Promise.@resolve().@then(() => {\n" \
    "                if (teeState.readAgain)\n" \
    "                    pullAlgorithm();\n" \
    "            });\n" \
    "        }, () => {\n" \
    "            //\n" \
    "            teeState.reading = false\n" \
    "        });\n" \
    "        return @Promise.@resolve();\n" \
    "    }\n" \
    "    return pullAlgorithm;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeLength = 453;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamTeeBranch1CancelFunctionCode =
    "(function (teeState, stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return function(r) {\n" \
    "        teeState.canceled1 = true;\n" \
    "        teeState.reason1 = r;\n" \
    "        if (teeState.canceled2) {\n" \
    "            @readableStreamCancel(stream, [teeState.reason1, teeState.reason2]).@then(\n" \
    "                teeState.cancelPromiseCapability.resolve,\n" \
    "                teeState.cancelPromiseCapability.reject);\n" \
    "        }\n" \
    "        return teeState.cancelPromiseCapability.promise;\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeLength = 453;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamTeeBranch2CancelFunctionCode =
    "(function (teeState, stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return function(r) {\n" \
    "        teeState.canceled2 = true;\n" \
    "        teeState.reason2 = r;\n" \
    "        if (teeState.canceled1) {\n" \
    "            @readableStreamCancel(stream, [teeState.reason1, teeState.reason2]).@then(\n" \
    "                teeState.cancelPromiseCapability.resolve,\n" \
    "                teeState.cancelPromiseCapability.reject);\n" \
    "        }\n" \
    "        return teeState.cancelPromiseCapability.promise;\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsIsReadableStreamCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsIsReadableStreamCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsIsReadableStreamCodeLength = 170;
static const JSC::Intrinsic s_readableStreamInternalsIsReadableStreamCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsIsReadableStreamCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    return @isObject(stream) && @getByIdDirectPrivate(stream, \"readableStreamController\") !== @undefined;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDefaultReaderCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDefaultReaderCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsIsReadableStreamDefaultReaderCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsIsReadableStreamDefaultReaderCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsIsReadableStreamDefaultReaderCodeLength = 145;
static const JSC::Intrinsic s_readableStreamInternalsIsReadableStreamDefaultReaderCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsIsReadableStreamDefaultReaderCode =
    "(function (reader)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    return @isObject(reader) && !!@getByIdDirectPrivate(reader, \"readRequests\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDefaultControllerCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDefaultControllerCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsIsReadableStreamDefaultControllerCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsIsReadableStreamDefaultControllerCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsIsReadableStreamDefaultControllerCodeLength = 168;
static const JSC::Intrinsic s_readableStreamInternalsIsReadableStreamDefaultControllerCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsIsReadableStreamDefaultControllerCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    //\n" \
    "    return @isObject(controller) && !!@getByIdDirectPrivate(controller, \"underlyingSource\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamErrorCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamErrorCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamErrorCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamErrorCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamErrorCodeLength = 1085;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamErrorCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamErrorCode =
    "(function (stream, error)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === @streamReadable);\n" \
    "    @putByIdDirectPrivate(stream, \"state\", @streamErrored);\n" \
    "    @putByIdDirectPrivate(stream, \"storedError\", error);\n" \
    "\n" \
    "    if (!@getByIdDirectPrivate(stream, \"reader\"))\n" \
    "        return;\n" \
    "\n" \
    "    const reader = @getByIdDirectPrivate(stream, \"reader\");\n" \
    "\n" \
    "    @getByIdDirectPrivate(reader, \"closedPromiseCapability\").reject.@call(@undefined, error);\n" \
    "    const promise = @getByIdDirectPrivate(reader, \"closedPromiseCapability\").promise;\n" \
    "    @markPromiseAsHandled(promise);\n" \
    "\n" \
    "    if (@isReadableStreamDefaultReader(reader))\n" \
    "        @readableStreamDefaultReaderErrorReadRequests(reader, error);\n" \
    "    else {\n" \
    "        @assert(@isReadableStreamBYOBReader(reader));\n" \
    "        const requests = @getByIdDirectPrivate(reader, \"readIntoRequests\");\n" \
    "        @putByIdDirectPrivate(reader, \"readIntoRequests\", []);\n" \
    "        for (let index = 0, length = requests.length; index < length; ++index)\n" \
    "            @rejectPromise(requests[index], error);\n" \
    "    }\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeLength = 652;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerShouldCallPullCode =
    "(function (controller)\n" \
    "{\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "\n" \
    "    if (!@readableStreamDefaultControllerCanCloseOrEnqueue(controller))\n" \
    "        return false;\n" \
    "    if (!@getByIdDirectPrivate(controller, \"started\"))\n" \
    "        return false;\n" \
    "    if ((!@isReadableStreamLocked(stream) || !@getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\").length) && @readableStreamDefaultControllerGetDesiredSize(controller) <= 0)\n" \
    "        return false;\n" \
    "    const desiredSize = @readableStreamDefaultControllerGetDesiredSize(controller);\n" \
    "    @assert(desiredSize !== null);\n" \
    "    return desiredSize > 0;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeLength = 1239;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerCallPullIfNeededCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    //\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "\n" \
    "    if (!@readableStreamDefaultControllerCanCloseOrEnqueue(controller))\n" \
    "        return;\n" \
    "    if (!@getByIdDirectPrivate(controller, \"started\"))\n" \
    "        return;\n" \
    "    if ((!@isReadableStreamLocked(stream) || !@getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\").length) && @readableStreamDefaultControllerGetDesiredSize(controller) <= 0)\n" \
    "        return;\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(controller, \"pulling\")) {\n" \
    "        @putByIdDirectPrivate(controller, \"pullAgain\", true);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    @assert(!@getByIdDirectPrivate(controller, \"pullAgain\"));\n" \
    "    @putByIdDirectPrivate(controller, \"pulling\", true);\n" \
    "\n" \
    "    @getByIdDirectPrivate(controller, \"pullAlgorithm\").@call(@undefined).@then(function() {\n" \
    "        @putByIdDirectPrivate(controller, \"pulling\", false);\n" \
    "        if (@getByIdDirectPrivate(controller, \"pullAgain\")) {\n" \
    "            @putByIdDirectPrivate(controller, \"pullAgain\", false);\n" \
    "            @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "        }\n" \
    "    }, function(error) {\n" \
    "        @readableStreamDefaultControllerError(controller, error);\n" \
    "    });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamLockedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamLockedCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsIsReadableStreamLockedCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsIsReadableStreamLockedCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsIsReadableStreamLockedCodeLength = 136;
static const JSC::Intrinsic s_readableStreamInternalsIsReadableStreamLockedCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsIsReadableStreamLockedCode =
    "(function (stream)\n" \
    "{\n" \
    "   \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "    return !!@getByIdDirectPrivate(stream, \"reader\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeLength = 416;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerGetDesiredSizeCode =
    "(function (controller)\n" \
    "{\n" \
    "   \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "\n" \
    "    if (state === @streamErrored)\n" \
    "        return null;\n" \
    "    if (state === @streamClosed)\n" \
    "        return 0;\n" \
    "\n" \
    "    return @getByIdDirectPrivate(controller, \"strategy\").highWaterMark - @getByIdDirectPrivate(controller, \"queue\").size;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericCancelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericCancelCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamReaderGenericCancelCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamReaderGenericCancelCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamReaderGenericCancelCodeLength = 197;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamReaderGenericCancelCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamReaderGenericCancelCode =
    "(function (reader, reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(reader, \"ownerReadableStream\");\n" \
    "    @assert(!!stream);\n" \
    "    return @readableStreamCancel(stream, reason);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamCancelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamCancelCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamCancelCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamCancelCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamCancelCodeLength = 547;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamCancelCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamCancelCode =
    "(function (stream, reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"disturbed\", true);\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "    if (state === @streamClosed)\n" \
    "        return @Promise.@resolve();\n" \
    "    if (state === @streamErrored)\n" \
    "        return @Promise.@reject(@getByIdDirectPrivate(stream, \"storedError\"));\n" \
    "    @readableStreamClose(stream);\n" \
    "    return @getByIdDirectPrivate(stream, \"readableStreamController\").@cancel(@getByIdDirectPrivate(stream, \"readableStreamController\"), reason).@then(function() {  });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeLength = 207;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerCancelCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerCancelCode =
    "(function (controller, reason)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @putByIdDirectPrivate(controller, \"queue\", @newQueue());\n" \
    "    return @getByIdDirectPrivate(controller, \"cancelAlgorithm\").@call(@undefined, reason);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerPullCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerPullCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerPullCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerPullCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerPullCodeLength = 777;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerPullCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerPullCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    if (@getByIdDirectPrivate(controller, \"queue\").content.length) {\n" \
    "        const chunk = @dequeueValue(@getByIdDirectPrivate(controller, \"queue\"));\n" \
    "        if (@getByIdDirectPrivate(controller, \"closeRequested\") && @getByIdDirectPrivate(controller, \"queue\").content.length === 0)\n" \
    "            @readableStreamClose(stream);\n" \
    "        else\n" \
    "            @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "\n" \
    "        return @createFulfilledPromise({ value: chunk, done: false });\n" \
    "    }\n" \
    "    const pendingPromise = @readableStreamAddReadRequest(stream);\n" \
    "    @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "    return pendingPromise;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeLength = 352;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerCloseCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerCloseCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@readableStreamDefaultControllerCanCloseOrEnqueue(controller));\n" \
    "    @putByIdDirectPrivate(controller, \"closeRequested\", true);\n" \
    "    if (@getByIdDirectPrivate(controller, \"queue\").content.length === 0)\n" \
    "        @readableStreamClose(@getByIdDirectPrivate(controller, \"controlledReadableStream\"));\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamCloseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamCloseCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamCloseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamCloseCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamCloseCodeLength = 696;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamCloseCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamCloseCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") === @streamReadable);\n" \
    "    @putByIdDirectPrivate(stream, \"state\", @streamClosed);\n" \
    "    const reader = @getByIdDirectPrivate(stream, \"reader\");\n" \
    "\n" \
    "    if (!reader)\n" \
    "        return;\n" \
    "\n" \
    "    if (@isReadableStreamDefaultReader(reader)) {\n" \
    "        const requests = @getByIdDirectPrivate(reader, \"readRequests\");\n" \
    "        @putByIdDirectPrivate(reader, \"readRequests\", []);\n" \
    "        for (let index = 0, length = requests.length; index < length; ++index)\n" \
    "            @fulfillPromise(requests[index], { value: @undefined, done: true });\n" \
    "    }\n" \
    "\n" \
    "    @getByIdDirectPrivate(reader, \"closedPromiseCapability\").resolve.@call();\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamFulfillReadRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamFulfillReadRequestCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamFulfillReadRequestCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamFulfillReadRequestCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamFulfillReadRequestCodeLength = 232;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamFulfillReadRequestCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamFulfillReadRequestCode =
    "(function (stream, chunk, done)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "    const readRequest = @getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\").@shift();\n" \
    "    @fulfillPromise(readRequest, { value: chunk, done: done });\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeLength = 979;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerEnqueueCode =
    "(function (controller, chunk)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(controller, \"controlledReadableStream\");\n" \
    "    @assert(@readableStreamDefaultControllerCanCloseOrEnqueue(controller));\n" \
    "\n" \
    "    if (@isReadableStreamLocked(stream) && @getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\").length) {\n" \
    "        @readableStreamFulfillReadRequest(stream, chunk, false);\n" \
    "        @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "        return;\n" \
    "    }\n" \
    "\n" \
    "    try {\n" \
    "        let chunkSize = 1;\n" \
    "        if (@getByIdDirectPrivate(controller, \"strategy\").size !== @undefined)\n" \
    "            chunkSize = @getByIdDirectPrivate(controller, \"strategy\").size(chunk);\n" \
    "        @enqueueValueWithSize(@getByIdDirectPrivate(controller, \"queue\"), chunk, chunkSize);\n" \
    "    }\n" \
    "    catch(error) {\n" \
    "        @readableStreamDefaultControllerError(controller, error);\n" \
    "        throw error;\n" \
    "    }\n" \
    "    @readableStreamDefaultControllerCallPullIfNeeded(controller);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderReadCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderReadCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultReaderReadCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultReaderReadCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultReaderReadCodeLength = 649;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultReaderReadCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultReaderReadCode =
    "(function (reader)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    const stream = @getByIdDirectPrivate(reader, \"ownerReadableStream\");\n" \
    "    @assert(!!stream);\n" \
    "    const state = @getByIdDirectPrivate(stream, \"state\");\n" \
    "\n" \
    "    @putByIdDirectPrivate(stream, \"disturbed\", true);\n" \
    "    if (state === @streamClosed)\n" \
    "        return @createFulfilledPromise({ value: @undefined, done: true });\n" \
    "    if (state === @streamErrored)\n" \
    "        return @Promise.@reject(@getByIdDirectPrivate(stream, \"storedError\"));\n" \
    "    @assert(state === @streamReadable);\n" \
    "\n" \
    "    return @getByIdDirectPrivate(stream, \"readableStreamController\").@pull(@getByIdDirectPrivate(stream, \"readableStreamController\"));\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamAddReadRequestCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamAddReadRequestCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamAddReadRequestCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamAddReadRequestCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamAddReadRequestCodeLength = 375;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamAddReadRequestCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamAddReadRequestCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStreamDefaultReader(@getByIdDirectPrivate(stream, \"reader\")));\n" \
    "    @assert(@getByIdDirectPrivate(stream, \"state\") == @streamReadable);\n" \
    "\n" \
    "    const readRequest = @newPromise();\n" \
    "    @arrayPush(@getByIdDirectPrivate(@getByIdDirectPrivate(stream, \"reader\"), \"readRequests\"), readRequest);\n" \
    "\n" \
    "    return readRequest;\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsIsReadableStreamDisturbedCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsIsReadableStreamDisturbedCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsIsReadableStreamDisturbedCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsIsReadableStreamDisturbedCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsIsReadableStreamDisturbedCodeLength = 138;
static const JSC::Intrinsic s_readableStreamInternalsIsReadableStreamDisturbedCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsIsReadableStreamDisturbedCode =
    "(function (stream)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(@isReadableStream(stream));\n" \
    "    return @getByIdDirectPrivate(stream, \"disturbed\");\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeLength = 176;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultReaderReleaseCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultReaderReleaseCode =
    "(function (reader)\n" \
    "{\n" \
    "    @readableStreamReaderGenericRelease(reader);\n" \
    "    @readableStreamDefaultReaderErrorReadRequests(reader, @makeTypeError(\"releasing lock of reader\"));\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeLength = 965;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamReaderGenericReleaseCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamReaderGenericReleaseCode =
    "(function (reader)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    @assert(!!@getByIdDirectPrivate(reader, \"ownerReadableStream\"));\n" \
    "    @assert(@getByIdDirectPrivate(@getByIdDirectPrivate(reader, \"ownerReadableStream\"), \"reader\") === reader);\n" \
    "\n" \
    "    if (@getByIdDirectPrivate(@getByIdDirectPrivate(reader, \"ownerReadableStream\"), \"state\") === @streamReadable)\n" \
    "        @getByIdDirectPrivate(reader, \"closedPromiseCapability\").reject.@call(@undefined, @makeTypeError(\"releasing lock of reader whose stream is still in readable state\"));\n" \
    "    else\n" \
    "        @putByIdDirectPrivate(reader, \"closedPromiseCapability\", { promise: @newHandledRejectedPromise(@makeTypeError(\"reader released lock\")) });\n" \
    "\n" \
    "    const promise = @getByIdDirectPrivate(reader, \"closedPromiseCapability\").promise;\n" \
    "    @markPromiseAsHandled(promise);\n" \
    "    @putByIdDirectPrivate(@getByIdDirectPrivate(reader, \"ownerReadableStream\"), \"reader\", @undefined);\n" \
    "    @putByIdDirectPrivate(reader, \"ownerReadableStream\", @undefined);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeLength = 277;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultReaderErrorReadRequestsCode =
    "(function (reader, error)\n" \
    "{\n" \
    "    const requests = @getByIdDirectPrivate(reader, \"readRequests\");\n" \
    "    @putByIdDirectPrivate(reader, \"readRequests\", []);\n" \
    "    for (let index = 0, length = requests.length; index < length; ++index)\n" \
    "        @rejectPromise(requests[index], error);\n" \
    "})\n" \
;

const JSC::ConstructAbility s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeConstructAbility = JSC::ConstructAbility::CannotConstruct;
const JSC::ConstructorKind s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeConstructorKind = JSC::ConstructorKind::None;
const JSC::ImplementationVisibility s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeImplementationVisibility = JSC::ImplementationVisibility::Public;
const JSC::InlineAttribute s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeInlineAttribute = JSC::InlineAttribute::None;
const int s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeLength = 229;
static const JSC::Intrinsic s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCodeIntrinsic = JSC::NoIntrinsic;
const char* const s_readableStreamInternalsReadableStreamDefaultControllerCanCloseOrEnqueueCode =
    "(function (controller)\n" \
    "{\n" \
    "    \"use strict\";\n" \
    "\n" \
    "    return !@getByIdDirectPrivate(controller, \"closeRequested\") && @getByIdDirectPrivate(@getByIdDirectPrivate(controller, \"controlledReadableStream\"), \"state\") === @streamReadable;\n" \
    "})\n" \
;


#define DEFINE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
JSC::FunctionExecutable* codeName##Generator(JSC::VM& vm) \
{\
    JSVMClientData* clientData = static_cast<JSVMClientData*>(vm.clientData); \
    return clientData->builtinFunctions().readableStreamInternalsBuiltins().codeName##Executable()->link(vm, nullptr, clientData->builtinFunctions().readableStreamInternalsBuiltins().codeName##Source(), std::nullopt, s_##codeName##Intrinsic); \
}
WEBCORE_FOREACH_READABLESTREAMINTERNALS_BUILTIN_CODE(DEFINE_BUILTIN_GENERATOR)
#undef DEFINE_BUILTIN_GENERATOR


} // namespace WebCore
