/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(VIDEO)

#include "IDLTypes.h"
#include "JSCallbackData.h"
#include "VideoFrameRequestCallback.h"
#include "WebCoreOpaqueRootInlines.h"
#include <wtf/Forward.h>

namespace WebCore {

class JSVideoFrameRequestCallback final : public VideoFrameRequestCallback {
public:
    static Ref<JSVideoFrameRequestCallback> create(JSC::JSObject* callback, JSDOMGlobalObject* globalObject)
    {
        return adoptRef(*new JSVideoFrameRequestCallback(callback, globalObject));
    }

    ScriptExecutionContext* scriptExecutionContext() const { return ContextDestructionObserver::scriptExecutionContext(); }

    ~JSVideoFrameRequestCallback() final;
    JSCallbackData* callbackData() { return m_data; }

    // Functions
    CallbackResult<typename IDLUndefined::CallbackReturnType> handleEvent(typename IDLDouble::ParameterType now, typename IDLDictionary<VideoFrameMetadata>::ParameterType metadata) override;

private:
    JSVideoFrameRequestCallback(JSC::JSObject*, JSDOMGlobalObject*);

    bool hasCallback() const final { return m_data && m_data->callback(); }

    JSCallbackData* m_data;
};

JSC::JSValue toJS(VideoFrameRequestCallback&);
inline JSC::JSValue toJS(VideoFrameRequestCallback* impl) { return impl ? toJS(*impl) : JSC::jsNull(); }

template<> struct JSDOMCallbackConverterTraits<JSVideoFrameRequestCallback> {
    using Base = VideoFrameRequestCallback;
};
} // namespace WebCore

#endif // ENABLE(VIDEO)
