/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGPointList.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSSVGPoint.h"
#include "Quirks.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/ArrayPrototype.h>
#include <JavaScriptCore/BuiltinNames.h>
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/PropertyNameArray.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_clear);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_initialize);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_getItem);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_insertItemBefore);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_replaceItem);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_removeItem);
static JSC_DECLARE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_appendItem);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGPointListConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPointList_length);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGPointList_numberOfItems);

class JSSVGPointListPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGPointListPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGPointListPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGPointListPrototype>(vm)) JSSVGPointListPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPointListPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGPointListPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGPointListPrototype, JSSVGPointListPrototype::Base);

using JSSVGPointListDOMConstructor = JSDOMConstructorNotConstructable<JSSVGPointList>;

template<> const ClassInfo JSSVGPointListDOMConstructor::s_info = { "SVGPointList"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPointListDOMConstructor) };

template<> JSValue JSSVGPointListDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGPointListDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGPointList"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGPointList::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSVGPointListPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPointListConstructor, 0 } },
    { "length"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPointList_length, 0 } },
    { "numberOfItems"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGPointList_numberOfItems, 0 } },
    { "clear"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPointListPrototypeFunction_clear, 0 } },
    { "initialize"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPointListPrototypeFunction_initialize, 1 } },
    { "getItem"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPointListPrototypeFunction_getItem, 1 } },
    { "insertItemBefore"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPointListPrototypeFunction_insertItemBefore, 2 } },
    { "replaceItem"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPointListPrototypeFunction_replaceItem, 2 } },
    { "removeItem"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPointListPrototypeFunction_removeItem, 1 } },
    { "appendItem"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsSVGPointListPrototypeFunction_appendItem, 1 } },
};

const ClassInfo JSSVGPointListPrototype::s_info = { "SVGPointList"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPointListPrototype) };

void JSSVGPointListPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGPointList::info(), JSSVGPointListPrototypeTableValues, *this);
    putDirect(vm, vm.propertyNames->iteratorSymbol, globalObject()->arrayPrototype()->getDirect(vm, vm.propertyNames->builtinNames().valuesPrivateName()), static_cast<unsigned>(JSC::PropertyAttribute::DontEnum));
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGPointList::s_info = { "SVGPointList"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGPointList) };

JSSVGPointList::JSSVGPointList(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGPointList>&& impl)
    : JSDOMWrapper<SVGPointList>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGPointList>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGPointList::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGPointListPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGPointListPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGPointList::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGPointList>(vm, globalObject);
}

JSValue JSSVGPointList::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGPointListDOMConstructor, DOMConstructorID::SVGPointList>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGPointList::destroy(JSC::JSCell* cell)
{
    JSSVGPointList* thisObject = static_cast<JSSVGPointList*>(cell);
    thisObject->JSSVGPointList::~JSSVGPointList();
}

bool JSSVGPointList::legacyPlatformObjectGetOwnProperty(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot, bool ignoreNamedProperties)
{
    UNUSED_PARAM(ignoreNamedProperties);
    auto throwScope = DECLARE_THROW_SCOPE(JSC::getVM(lexicalGlobalObject));
    auto* thisObject = jsCast<JSSVGPointList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (auto index = parseIndex(propertyName)) {
        if (index.value() < thisObject->wrapped().length()) {
            auto value = toJS<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *thisObject->globalObject(), throwScope, thisObject->wrapped().getItem(index.value()));
            RETURN_IF_EXCEPTION(throwScope, false);
            slot.setValue(thisObject, 0, value);
            return true;
        }
    }
    return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
}

bool JSSVGPointList::getOwnPropertySlot(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot)
{
    bool ignoreNamedProperties = false;
    return legacyPlatformObjectGetOwnProperty(object, lexicalGlobalObject, propertyName, slot, ignoreNamedProperties);
}

bool JSSVGPointList::getOwnPropertySlotByIndex(JSObject* object, JSGlobalObject* lexicalGlobalObject, unsigned index, PropertySlot& slot)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* thisObject = jsCast<JSSVGPointList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (LIKELY(index <= MAX_ARRAY_INDEX)) {
        if (index < thisObject->wrapped().length()) {
            auto value = toJS<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *thisObject->globalObject(), throwScope, thisObject->wrapped().getItem(index));
            RETURN_IF_EXCEPTION(throwScope, false);
            slot.setValue(thisObject, 0, value);
            return true;
        }
    }
    return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
}

void JSSVGPointList::getOwnPropertyNames(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyNameArray& propertyNames, DontEnumPropertiesMode mode)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSSVGPointList*>(object);
    ASSERT_GC_OBJECT_INHERITS(object, info());
    for (unsigned i = 0, count = thisObject->wrapped().length(); i < count; ++i)
        propertyNames.add(Identifier::from(vm, i));
    JSObject::getOwnPropertyNames(object, lexicalGlobalObject, propertyNames, mode);
}

bool JSSVGPointList::put(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, JSValue value, PutPropertySlot& putPropertySlot)
{
    auto* thisObject = jsCast<JSSVGPointList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    if (UNLIKELY(thisObject != putPropertySlot.thisValue()))
        return JSObject::put(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot);
    auto throwScope = DECLARE_THROW_SCOPE(lexicalGlobalObject->vm());

    if (auto index = parseIndex(propertyName)) {
        auto nativeValue = convert<IDLInterface<SVGPoint>>(*lexicalGlobalObject, value);
        if (UNLIKELY(nativeValue.hasException(throwScope)))
            return true;
        invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return thisObject->wrapped().setItem(index.value(), *nativeValue.releaseReturnValue()); });
        return true;
    }

    throwScope.assertNoException();
    RELEASE_AND_RETURN(throwScope, JSObject::put(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot));
}

bool JSSVGPointList::putByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index, JSValue value, bool shouldThrow)
{
    auto* thisObject = jsCast<JSSVGPointList*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    if (LIKELY(index <= MAX_ARRAY_INDEX)) {
        auto nativeValue = convert<IDLInterface<SVGPoint>>(*lexicalGlobalObject, value);
        if (UNLIKELY(nativeValue.hasException(throwScope)))
            return true;
        invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return thisObject->wrapped().setItem(index, *nativeValue.releaseReturnValue()); });
        return true;
    }

    throwScope.assertNoException();
    auto propertyName = Identifier::from(vm, index);
    PutPropertySlot putPropertySlot(thisObject, shouldThrow);
    RELEASE_AND_RETURN(throwScope, ordinarySetSlow(lexicalGlobalObject, thisObject, propertyName, value, putPropertySlot.thisValue(), shouldThrow));
}

bool JSSVGPointList::defineOwnProperty(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, const PropertyDescriptor& propertyDescriptor, bool shouldThrow)
{
    auto* thisObject = jsCast<JSSVGPointList*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    auto throwScope = DECLARE_THROW_SCOPE(lexicalGlobalObject->vm());

    if (auto index = parseIndex(propertyName)) {
        if (!propertyDescriptor.isDataDescriptor())
            return typeError(lexicalGlobalObject, throwScope, shouldThrow, "Cannot set indexed properties on this object"_s);
        auto nativeValue = convert<IDLInterface<SVGPoint>>(*lexicalGlobalObject, propertyDescriptor.value());
        if (UNLIKELY(nativeValue.hasException(throwScope)))
            return true;
        invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return thisObject->wrapped().setItem(index.value(), *nativeValue.releaseReturnValue()); });
        return true;
    }

    PropertyDescriptor newPropertyDescriptor = propertyDescriptor;
    throwScope.release();
    return JSObject::defineOwnProperty(object, lexicalGlobalObject, propertyName, newPropertyDescriptor, shouldThrow);
}

bool JSSVGPointList::deleteProperty(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, DeletePropertySlot& slot)
{
    auto& thisObject = *jsCast<JSSVGPointList*>(cell);
    auto& impl = thisObject.wrapped();

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (UNLIKELY(document->quirks().needsConfigurableIndexedPropertiesQuirk()))
            return JSObject::deleteProperty(cell, lexicalGlobalObject, propertyName, slot);
    }

    if (auto index = parseIndex(propertyName))
        return !impl.isSupportedPropertyIndex(index.value());
    return JSObject::deleteProperty(cell, lexicalGlobalObject, propertyName, slot);
}

bool JSSVGPointList::deletePropertyByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index)
{
    UNUSED_PARAM(lexicalGlobalObject);
    auto& thisObject = *jsCast<JSSVGPointList*>(cell);
    auto& impl = thisObject.wrapped();

    // Temporary quirk for ungap/@custom-elements polyfill (rdar://problem/111008826), consider removing in 2025.
    if (auto* document = dynamicDowncast<Document>(jsDynamicCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())) {
        if (UNLIKELY(document->quirks().needsConfigurableIndexedPropertiesQuirk()))
            return JSObject::deletePropertyByIndex(cell, lexicalGlobalObject, index);
    }

    return !impl.isSupportedPropertyIndex(index);
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPointListConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGPointListPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGPointList::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsSVGPointList_lengthGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPointList& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.length())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPointList_length, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPointList>::get<jsSVGPointList_lengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsSVGPointList_numberOfItemsGetter(JSGlobalObject& lexicalGlobalObject, JSSVGPointList& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.numberOfItems())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGPointList_numberOfItems, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGPointList>::get<jsSVGPointList_numberOfItemsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsSVGPointListPrototypeFunction_clearBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPointList>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.clear(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_clear, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPointList>::call<jsSVGPointListPrototypeFunction_clearBody>(*lexicalGlobalObject, *callFrame, "clear");
}

static inline JSC::EncodedJSValue jsSVGPointListPrototypeFunction_initializeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPointList>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto newItemConversionResult = convert<IDLInterface<SVGPoint>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "newItem"_s, "SVGPointList"_s, "initialize"_s, "SVGPoint"_s); });
    if (UNLIKELY(newItemConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.initialize(*newItemConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_initialize, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPointList>::call<jsSVGPointListPrototypeFunction_initializeBody>(*lexicalGlobalObject, *callFrame, "initialize");
}

static inline JSC::EncodedJSValue jsSVGPointListPrototypeFunction_getItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPointList>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getItem(indexConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_getItem, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPointList>::call<jsSVGPointListPrototypeFunction_getItemBody>(*lexicalGlobalObject, *callFrame, "getItem");
}

static inline JSC::EncodedJSValue jsSVGPointListPrototypeFunction_insertItemBeforeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPointList>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto newItemConversionResult = convert<IDLInterface<SVGPoint>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "newItem"_s, "SVGPointList"_s, "insertItemBefore"_s, "SVGPoint"_s); });
    if (UNLIKELY(newItemConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.insertItemBefore(*newItemConversionResult.releaseReturnValue(), indexConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_insertItemBefore, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPointList>::call<jsSVGPointListPrototypeFunction_insertItemBeforeBody>(*lexicalGlobalObject, *callFrame, "insertItemBefore");
}

static inline JSC::EncodedJSValue jsSVGPointListPrototypeFunction_replaceItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPointList>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto newItemConversionResult = convert<IDLInterface<SVGPoint>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "newItem"_s, "SVGPointList"_s, "replaceItem"_s, "SVGPoint"_s); });
    if (UNLIKELY(newItemConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.replaceItem(*newItemConversionResult.releaseReturnValue(), indexConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_replaceItem, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPointList>::call<jsSVGPointListPrototypeFunction_replaceItemBody>(*lexicalGlobalObject, *callFrame, "replaceItem");
}

static inline JSC::EncodedJSValue jsSVGPointListPrototypeFunction_removeItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPointList>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.removeItem(indexConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_removeItem, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPointList>::call<jsSVGPointListPrototypeFunction_removeItemBody>(*lexicalGlobalObject, *callFrame, "removeItem");
}

static inline JSC::EncodedJSValue jsSVGPointListPrototypeFunction_appendItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSSVGPointList>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto newItemConversionResult = convert<IDLInterface<SVGPoint>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "newItem"_s, "SVGPointList"_s, "appendItem"_s, "SVGPoint"_s); });
    if (UNLIKELY(newItemConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<SVGPoint>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.appendItem(*newItemConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsSVGPointListPrototypeFunction_appendItem, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSSVGPointList>::call<jsSVGPointListPrototypeFunction_appendItemBody>(*lexicalGlobalObject, *callFrame, "appendItem");
}

JSC::GCClient::IsoSubspace* JSSVGPointList::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGPointList, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGPointList.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGPointList = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGPointList.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGPointList = std::forward<decltype(space)>(space); }
    );
}

void JSSVGPointList::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGPointList*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGPointListOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGPointListOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGPointList = static_cast<JSSVGPointList*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsSVGPointList->protectedWrapped().ptr(), jsSVGPointList);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7SVGPointList@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12SVGPointListE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, SVGPointList>, void>> static inline void verifyVTable(SVGPointList* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7SVGPointList@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore12SVGPointListE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // SVGPointList has subclasses. If SVGPointList has subclasses that get passed
        // to toJS() we currently require SVGPointList you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGPointList>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<SVGPointList>(impl.ptr());
#endif
    return createWrapper<SVGPointList>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGPointList& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGPointList* JSSVGPointList::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGPointList*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
