/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSExtendableMessageEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSMessagePort.h"
#include "JSServiceWorker.h"
#include "JSServiceWorkerClient.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ExtendableMessageEvent::Init>> convertDictionary<ExtendableMessageEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ExtendableMessageEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto bubblesConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, bubblesValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(bubblesConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.bubbles = bubblesConversionResult.releaseReturnValue();
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto cancelableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, cancelableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(cancelableConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.cancelable = cancelableConversionResult.releaseReturnValue();
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto composedConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, composedValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(composedConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.composed = composedConversionResult.releaseReturnValue();
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto dataConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, dataValue, [&]() -> ConversionResult<IDLAny> { return typename Converter<IDLAny>::ReturnType { jsNull() }; });
    if (UNLIKELY(dataConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.data = dataConversionResult.releaseReturnValue();
    JSValue lastEventIdValue;
    if (isNullOrUndefined)
        lastEventIdValue = jsUndefined();
    else {
        lastEventIdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "lastEventId"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto lastEventIdConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, lastEventIdValue, [&]() -> ConversionResult<IDLDOMString> { return Converter<IDLDOMString>::ReturnType { emptyString() }; });
    if (UNLIKELY(lastEventIdConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.lastEventId = lastEventIdConversionResult.releaseReturnValue();
    JSValue originValue;
    if (isNullOrUndefined)
        originValue = jsUndefined();
    else {
        originValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "origin"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto originConversionResult = convertOptionalWithDefault<IDLUSVString>(lexicalGlobalObject, originValue, [&]() -> ConversionResult<IDLUSVString> { return Converter<IDLUSVString>::ReturnType { emptyString() }; });
    if (UNLIKELY(originConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.origin = originConversionResult.releaseReturnValue();
    JSValue portsValue;
    if (isNullOrUndefined)
        portsValue = jsUndefined();
    else {
        portsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ports"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto portsConversionResult = convertOptionalWithDefault<IDLSequence<IDLInterface<MessagePort>>>(lexicalGlobalObject, portsValue, [&]() -> ConversionResult<IDLSequence<IDLInterface<MessagePort>>> { return Converter<IDLSequence<IDLInterface<MessagePort>>>::ReturnType { }; });
    if (UNLIKELY(portsConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.ports = portsConversionResult.releaseReturnValue();
    JSValue sourceValue;
    if (isNullOrUndefined)
        sourceValue = jsUndefined();
    else {
        sourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "source"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto sourceConversionResult = convertOptionalWithDefault<IDLNullable<IDLUnion<IDLInterface<ServiceWorkerClient>, IDLInterface<ServiceWorker>, IDLInterface<MessagePort>>>>(lexicalGlobalObject, sourceValue, [&]() -> ConversionResult<IDLNullable<IDLUnion<IDLInterface<ServiceWorkerClient>, IDLInterface<ServiceWorker>, IDLInterface<MessagePort>>>> { return typename Converter<IDLNullable<IDLUnion<IDLInterface<ServiceWorkerClient>, IDLInterface<ServiceWorker>, IDLInterface<MessagePort>>>>::ReturnType { std::nullopt }; });
    if (UNLIKELY(sourceConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.source = sourceConversionResult.releaseReturnValue();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEvent_data);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEvent_origin);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEvent_lastEventId);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEvent_source);
static JSC_DECLARE_CUSTOM_GETTER(jsExtendableMessageEvent_ports);

class JSExtendableMessageEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSExtendableMessageEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSExtendableMessageEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSExtendableMessageEventPrototype>(vm)) JSExtendableMessageEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSExtendableMessageEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSExtendableMessageEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSExtendableMessageEventPrototype, JSExtendableMessageEventPrototype::Base);

using JSExtendableMessageEventDOMConstructor = JSDOMConstructor<JSExtendableMessageEvent>;

template<> JSC::EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSExtendableMessageEventDOMConstructor::construct(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    ASSERT(callFrame);
    return constructJSExtendableMessageEvent(lexicalGlobalObject, *callFrame);
}
JSC_ANNOTATE_HOST_FUNCTION(JSExtendableMessageEventDOMConstructorConstruct, JSExtendableMessageEventDOMConstructor::construct);

template<> const ClassInfo JSExtendableMessageEventDOMConstructor::s_info = { "ExtendableMessageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSExtendableMessageEventDOMConstructor) };

template<> JSValue JSExtendableMessageEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSExtendableEvent::getConstructor(vm, &globalObject);
}

template<> void JSExtendableMessageEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "ExtendableMessageEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSExtendableMessageEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSExtendableMessageEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEventConstructor, 0 } },
    { "data"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEvent_data, 0 } },
    { "origin"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEvent_origin, 0 } },
    { "lastEventId"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEvent_lastEventId, 0 } },
    { "source"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEvent_source, 0 } },
    { "ports"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsExtendableMessageEvent_ports, 0 } },
};

const ClassInfo JSExtendableMessageEventPrototype::s_info = { "ExtendableMessageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSExtendableMessageEventPrototype) };

void JSExtendableMessageEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSExtendableMessageEvent::info(), JSExtendableMessageEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSExtendableMessageEvent::s_info = { "ExtendableMessageEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSExtendableMessageEvent) };

JSExtendableMessageEvent::JSExtendableMessageEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<ExtendableMessageEvent>&& impl)
    : JSExtendableEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<ExtendableMessageEvent> JSExtendableMessageEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, ExtendableMessageEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSExtendableMessageEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSExtendableMessageEventPrototype::createStructure(vm, &globalObject, JSExtendableEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSExtendableMessageEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSExtendableMessageEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSExtendableMessageEvent>(vm, globalObject);
}

JSValue JSExtendableMessageEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSExtendableMessageEventDOMConstructor, DOMConstructorID::ExtendableMessageEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSExtendableMessageEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSExtendableMessageEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsExtendableMessageEvent_dataGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableMessageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAny>(lexicalGlobalObject, throwScope, impl.data())));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEvent_data, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableMessageEvent>::get<jsExtendableMessageEvent_dataGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsExtendableMessageEvent_originGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableMessageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.origin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEvent_origin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableMessageEvent>::get<jsExtendableMessageEvent_originGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsExtendableMessageEvent_lastEventIdGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableMessageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.lastEventId())));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEvent_lastEventId, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableMessageEvent>::get<jsExtendableMessageEvent_lastEventIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsExtendableMessageEvent_sourceGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableMessageEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLUnion<IDLInterface<ServiceWorkerClient>, IDLInterface<ServiceWorker>, IDLInterface<MessagePort>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.source())));
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEvent_source, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableMessageEvent>::get<jsExtendableMessageEvent_sourceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsExtendableMessageEvent_portsGetter(JSGlobalObject& lexicalGlobalObject, JSExtendableMessageEvent& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.ports(lexicalGlobalObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsExtendableMessageEvent_ports, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSExtendableMessageEvent>::get<jsExtendableMessageEvent_portsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSExtendableMessageEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSExtendableMessageEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForExtendableMessageEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForExtendableMessageEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForExtendableMessageEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForExtendableMessageEvent = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSExtendableMessageEvent::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSExtendableMessageEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSExtendableMessageEvent);

template<typename Visitor>
void JSExtendableMessageEvent::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSExtendableMessageEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSExtendableMessageEvent::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSExtendableMessageEvent::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSExtendableMessageEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSExtendableMessageEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7ExtendableMessageEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22ExtendableMessageEventE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, ExtendableMessageEvent>, void>> static inline void verifyVTable(ExtendableMessageEvent* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7ExtendableMessageEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22ExtendableMessageEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // ExtendableMessageEvent has subclasses. If ExtendableMessageEvent has subclasses that get passed
        // to toJS() we currently require ExtendableMessageEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<ExtendableMessageEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<ExtendableMessageEvent>(impl.ptr());
#endif
    return createWrapper<ExtendableMessageEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, ExtendableMessageEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
