/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSOKLab.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSKeywordValue.h"
#include "JSCSSNumericValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSOKLabConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOKLab_l);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSOKLab_l);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOKLab_a);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSOKLab_a);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOKLab_b);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSOKLab_b);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOKLab_alpha);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSOKLab_alpha);

class JSCSSOKLabPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSOKLabPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSOKLabPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSOKLabPrototype>(vm)) JSCSSOKLabPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSOKLabPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSOKLabPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSOKLabPrototype, JSCSSOKLabPrototype::Base);

using JSCSSOKLabDOMConstructor = JSDOMConstructor<JSCSSOKLab>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSOKLabDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSOKLabDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto lConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(lConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto aConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(aConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto bConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(bConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto alphaConversionResult = convertOptionalWithDefault<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>> { return Converter<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>::ReturnType { 1.0 }; });
    if (UNLIKELY(alphaConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = CSSOKLab::create(lConversionResult.releaseReturnValue(), aConversionResult.releaseReturnValue(), bConversionResult.releaseReturnValue(), alphaConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSOKLab>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSOKLab>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSOKLabDOMConstructorConstruct, JSCSSOKLabDOMConstructor::construct);

template<> const ClassInfo JSCSSOKLabDOMConstructor::s_info = { "CSSOKLab"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOKLabDOMConstructor) };

template<> JSValue JSCSSOKLabDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSColorValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSOKLabDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(3), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSOKLab"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSOKLab::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSOKLabPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOKLabConstructor, 0 } },
    { "l"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOKLab_l, setJSCSSOKLab_l } },
    { "a"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOKLab_a, setJSCSSOKLab_a } },
    { "b"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOKLab_b, setJSCSSOKLab_b } },
    { "alpha"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOKLab_alpha, setJSCSSOKLab_alpha } },
};

const ClassInfo JSCSSOKLabPrototype::s_info = { "CSSOKLab"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOKLabPrototype) };

void JSCSSOKLabPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSOKLab::info(), JSCSSOKLabPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSOKLab::s_info = { "CSSOKLab"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOKLab) };

JSCSSOKLab::JSCSSOKLab(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSOKLab>&& impl)
    : JSCSSColorValue(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSOKLab> JSCSSOKLab::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSOKLab>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSOKLab::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSOKLabPrototype::createStructure(vm, &globalObject, JSCSSColorValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSOKLabPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSOKLab::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSOKLab>(vm, globalObject);
}

JSValue JSCSSOKLab::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSOKLabDOMConstructor, DOMConstructorID::CSSOKLab>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOKLabConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSOKLabPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSOKLab::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSOKLab_lGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLab& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.l())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOKLab_l, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLab>::get<jsCSSOKLab_lGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSOKLab_lSetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLab& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setL(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSOKLab_l, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLab>::set<setJSCSSOKLab_lSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSOKLab_aGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLab& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.a())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOKLab_a, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLab>::get<jsCSSOKLab_aGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSOKLab_aSetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLab& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setA(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSOKLab_a, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLab>::set<setJSCSSOKLab_aSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSOKLab_bGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLab& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.b())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOKLab_b, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLab>::get<jsCSSOKLab_bGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSOKLab_bSetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLab& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setB(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSOKLab_b, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLab>::set<setJSCSSOKLab_bSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSOKLab_alphaGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLab& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.alpha())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOKLab_alpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLab>::get<jsCSSOKLab_alphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSOKLab_alphaSetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLab& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlpha(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSOKLab_alpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLab>::set<setJSCSSOKLab_alphaSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSOKLab::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSOKLab, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSOKLab.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSOKLab = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSOKLab.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSOKLab = std::forward<decltype(space)>(space); }
    );
}

void JSCSSOKLab::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSOKLab*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSOKLab@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8CSSOKLabE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, CSSOKLab>, void>> static inline void verifyVTable(CSSOKLab* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSOKLab@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore8CSSOKLabE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSOKLab has subclasses. If CSSOKLab has subclasses that get passed
        // to toJS() we currently require CSSOKLab you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSOKLab>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSOKLab>(impl.ptr());
#endif
    return createWrapper<CSSOKLab>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSOKLab& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSOKLab* JSCSSOKLab::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSOKLab*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
