/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSOKLCH.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSCSSKeywordValue.h"
#include "JSCSSNumericValue.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSOKLCHConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOKLCH_l);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSOKLCH_l);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOKLCH_c);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSOKLCH_c);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOKLCH_h);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSOKLCH_h);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSOKLCH_alpha);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSOKLCH_alpha);

class JSCSSOKLCHPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSOKLCHPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSOKLCHPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSOKLCHPrototype>(vm)) JSCSSOKLCHPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSOKLCHPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSOKLCHPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSOKLCHPrototype, JSCSSOKLCHPrototype::Base);

using JSCSSOKLCHDOMConstructor = JSDOMConstructor<JSCSSOKLCH>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSOKLCHDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSOKLCHDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto lConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(lConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto cConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(cConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->uncheckedArgument(2);
    auto hConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(hConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto alphaConversionResult = convertOptionalWithDefault<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(*lexicalGlobalObject, argument3.value(), [&]() -> ConversionResult<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>> { return Converter<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>::ReturnType { 1.0 }; });
    if (UNLIKELY(alphaConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = CSSOKLCH::create(lConversionResult.releaseReturnValue(), cConversionResult.releaseReturnValue(), hConversionResult.releaseReturnValue(), alphaConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSOKLCH>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSOKLCH>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSOKLCHDOMConstructorConstruct, JSCSSOKLCHDOMConstructor::construct);

template<> const ClassInfo JSCSSOKLCHDOMConstructor::s_info = { "CSSOKLCH"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOKLCHDOMConstructor) };

template<> JSValue JSCSSOKLCHDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSColorValue::getConstructor(vm, &globalObject);
}

template<> void JSCSSOKLCHDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(3), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSOKLCH"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSOKLCH::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSOKLCHPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOKLCHConstructor, 0 } },
    { "l"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOKLCH_l, setJSCSSOKLCH_l } },
    { "c"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOKLCH_c, setJSCSSOKLCH_c } },
    { "h"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOKLCH_h, setJSCSSOKLCH_h } },
    { "alpha"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSOKLCH_alpha, setJSCSSOKLCH_alpha } },
};

const ClassInfo JSCSSOKLCHPrototype::s_info = { "CSSOKLCH"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOKLCHPrototype) };

void JSCSSOKLCHPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSOKLCH::info(), JSCSSOKLCHPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSOKLCH::s_info = { "CSSOKLCH"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSOKLCH) };

JSCSSOKLCH::JSCSSOKLCH(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSOKLCH>&& impl)
    : JSCSSColorValue(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSOKLCH> JSCSSOKLCH::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSOKLCH>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSOKLCH::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSOKLCHPrototype::createStructure(vm, &globalObject, JSCSSColorValue::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSOKLCHPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSOKLCH::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSOKLCH>(vm, globalObject);
}

JSValue JSCSSOKLCH::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSOKLCHDOMConstructor, DOMConstructorID::CSSOKLCH>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOKLCHConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSOKLCHPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSOKLCH::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSOKLCH_lGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLCH& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.l())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOKLCH_l, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLCH>::get<jsCSSOKLCH_lGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSOKLCH_lSetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLCH& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setL(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSOKLCH_l, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLCH>::set<setJSCSSOKLCH_lSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSOKLCH_cGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLCH& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.c())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOKLCH_c, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLCH>::get<jsCSSOKLCH_cGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSOKLCH_cSetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLCH& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setC(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSOKLCH_c, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLCH>::set<setJSCSSOKLCH_cSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSOKLCH_hGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLCH& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.h())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOKLCH_h, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLCH>::get<jsCSSOKLCH_hGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSOKLCH_hSetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLCH& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setH(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSOKLCH_h, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLCH>::set<setJSCSSOKLCH_hSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSOKLCH_alphaGetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLCH& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.alpha())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSOKLCH_alpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLCH>::get<jsCSSOKLCH_alphaGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSOKLCH_alphaSetter(JSGlobalObject& lexicalGlobalObject, JSCSSOKLCH& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLUnion<IDLDouble, IDLInterface<CSSNumericValue>, IDLDOMString, IDLInterface<CSSKeywordValue>>>(lexicalGlobalObject, value);
    if (UNLIKELY(nativeValueConversionResult.hasException(throwScope)))
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAlpha(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSOKLCH_alpha, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSOKLCH>::set<setJSCSSOKLCH_alphaSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSOKLCH::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSOKLCH, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSOKLCH.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSOKLCH = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSOKLCH.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSOKLCH = std::forward<decltype(space)>(space); }
    );
}

void JSCSSOKLCH::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSOKLCH*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSOKLCH@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore8CSSOKLCHE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, CSSOKLCH>, void>> static inline void verifyVTable(CSSOKLCH* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSOKLCH@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore8CSSOKLCHE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSOKLCH has subclasses. If CSSOKLCH has subclasses that get passed
        // to toJS() we currently require CSSOKLCH you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSOKLCH>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSOKLCH>(impl.ptr());
#endif
    return createWrapper<CSSOKLCH>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSOKLCH& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSOKLCH* JSCSSOKLCH::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSOKLCH*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
