/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.interpreter.jline;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jline.reader.Completer;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.internal.util.OwnerOnlyChmod$;
import scala.runtime.BoxedUnit;
import scala.tools.nsc.interpreter.Repl;
import scala.tools.nsc.interpreter.jline.Completion;
import scala.tools.nsc.interpreter.jline.Reader;
import scala.tools.nsc.interpreter.shell.Accumulator;
import scala.tools.nsc.interpreter.shell.ShellConfig;
import scala.util.control.NonFatal$;

public final class Reader$ {
    public static final Reader$ MODULE$ = new Reader$();

    public Reader apply(ShellConfig config, Repl repl, scala.tools.nsc.interpreter.shell.Completion completion, Accumulator accumulator) {
        Predef$.MODULE$.require(repl != null);
        if (config.isReplDebug()) {
            this.initLogging();
        }
        System.setProperty("org.jline.reader.support.parsedline", Boolean.TRUE.toString());
        Terminal jlineTerminal = TerminalBuilder.builder().jna(true).build();
        Completion completer = new Completion(completion);
        Reader.ReplParser parser = new Reader.ReplParser(repl);
        DefaultHistory history = new DefaultHistory();
        LineReaderBuilder builder = LineReaderBuilder.builder().appName("scala").completer((Completer)completer).history((History)history).parser((Parser)parser).terminal(jlineTerminal);
        Predef$.MODULE$.locally((Object)builder.option(LineReader.Option.AUTO_GROUP, false).option(LineReader.Option.LIST_PACKED, true).option(LineReader.Option.INSERT_TAB, true).variable("history-file", (Object)config.historyFile()).variable("secondary-prompt-pattern", (Object)config.encolor(config.continueText())).variable("WORDCHARS", (Object)StringOps$.MODULE$.filterNot$extension(Predef$.MODULE$.augmentString("*?_-.[]~=/&;!#$%^(){}<>"), (Function1)Predef$.MODULE$.wrapString("*?.[]~=/&;!#%^(){}<>").toSet())).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true));
        LineReader reader = builder.build();
        String keymap = config.viMode() ? "viins" : "emacs";
        Predef$.MODULE$.locally(reader.getKeyMaps().put("main", reader.getKeyMaps().get(keymap)));
        Reader$.secure$1(Paths.get(config.historyFile(), new String[0]), config);
        try {
            history.attach(reader);
        }
        catch (Throwable throwable) {
            IllegalArgumentException illegalArgumentException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IllegalArgumentException && (illegalArgumentException = (IllegalArgumentException)throwable2).getMessage().contains("Bad history file syntax")) {
                Reader$.backupHistory$1(config);
                history.attach(reader);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof NumberFormatException) {
                Reader$.backupHistory$1(config);
                history.attach(reader);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        return new Reader(config, reader, accumulator, completer, jlineTerminal);
    }

    private void initLogging() {
        Logger logger = Logger.getLogger("org.jline");
        ConsoleHandler handler = new ConsoleHandler();
        logger.setLevel(Level.ALL);
        handler.setLevel(Level.ALL);
        logger.addHandler(handler);
    }

    private static final void secure$1(Path p, ShellConfig config$1) {
        try {
            OwnerOnlyChmod$.MODULE$.chmodFileOrCreateEmpty(p);
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                if (config$1.isReplDebug()) {
                    e.printStackTrace();
                }
                config$1.replinfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Warning: history file ").append(p).append("'s permissions could not be restricted to owner-only.").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private static final void backupHistory$1(ShellConfig config$1) {
        Path hf = Paths.get(config$1.historyFile(), new String[0]);
        Path bk = Paths.get(new StringBuilder(3).append(config$1.historyFile()).append(".bk").toString(), new String[0]);
        Files.move(hf, bk, StandardCopyOption.REPLACE_EXISTING);
        Reader$.secure$1(bk, config$1);
    }

    private Reader$() {
    }
}

