/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers.serial;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import processing.app.BaseNoGui;
import processing.app.Platform;
import processing.app.debug.TargetBoard;
import processing.app.helpers.BoardCloudResolver;

public class SerialDiscovery
implements Discovery,
Runnable {
    private Timer serialBoardsListerTimer;
    private final List<BoardPort> serialBoardPorts = new ArrayList<BoardPort>();
    private final List<BoardPort> boardPorts = new ArrayList<BoardPort>();
    private final List<String> oldPorts = new ArrayList<String>();
    public boolean uploadInProgress = false;
    public boolean pausePolling = false;
    private final BoardCloudResolver boardCloudResolver = new BoardCloudResolver();

    @Override
    public List<BoardPort> listDiscoveredBoards() {
        return this.listDiscoveredBoards(false);
    }

    @Override
    public synchronized List<BoardPort> listDiscoveredBoards(boolean complete) {
        if (complete) {
            return new ArrayList<BoardPort>(this.serialBoardPorts);
        }
        ArrayList<BoardPort> onlineBoardPorts = new ArrayList<BoardPort>();
        for (BoardPort port : this.serialBoardPorts) {
            if (!port.isOnline()) continue;
            onlineBoardPorts.add(port);
        }
        return onlineBoardPorts;
    }

    public synchronized void setSerialBoardPorts(List<BoardPort> newSerialBoardPorts) {
        this.serialBoardPorts.clear();
        this.serialBoardPorts.addAll(newSerialBoardPorts);
    }

    public void setUploadInProgress(boolean param) {
        this.uploadInProgress = param;
    }

    public void pausePolling(boolean param) {
        this.pausePolling = param;
    }

    @Override
    public void run() {
        this.start();
    }

    @Override
    public void start() {
        this.serialBoardsListerTimer = new Timer(SerialDiscovery.class.getName());
        this.serialBoardsListerTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (BaseNoGui.packages != null && !SerialDiscovery.this.pausePolling) {
                    SerialDiscovery.this.forceRefresh();
                }
            }
        }, 0L, 1000L);
    }

    @Override
    public void stop() {
        this.serialBoardsListerTimer.cancel();
    }

    public synchronized void forceRefresh() {
        Platform platform = BaseNoGui.getPlatform();
        if (platform == null) {
            return;
        }
        List<String> ports = platform.listSerials();
        if (ports.equals(this.oldPorts)) {
            return;
        }
        this.oldPorts.clear();
        this.oldPorts.addAll(ports);
        for (BoardPort board : this.boardPorts) {
            if (ports.contains(board.toCompleteString())) continue;
            board.setOnlineStatus(false);
        }
        for (String newPort : ports) {
            BoardPort oldBoardPort = this.boardPorts.stream().filter(bp -> bp.toCompleteString().equalsIgnoreCase(newPort)).findAny().orElse(null);
            if (oldBoardPort != null) {
                oldBoardPort.setOnlineStatus(true);
                continue;
            }
            String[] parts = newPort.split("_");
            if (parts.length < 3) continue;
            if (parts.length > 3) {
                for (int i = 1; i < parts.length - 2; ++i) {
                    parts[0] = parts[0] + "_" + parts[i];
                }
                parts[1] = parts[parts.length - 2];
                parts[2] = parts[parts.length - 1];
            }
            String port = parts[0];
            BoardPort boardPort = new BoardPort();
            this.boardPorts.add(boardPort);
            boardPort.setAddress(port);
            boardPort.setProtocol("serial");
            boardPort.setOnlineStatus(true);
            boardPort.setLabel(port);
            Map<String, Object> boardData = platform.resolveDeviceByVendorIdProductId(port, BaseNoGui.packages);
            if (boardData != null) {
                boardPort.getPrefs().put("vid", boardData.get("vid").toString());
                boardPort.getPrefs().put("pid", boardData.get("pid").toString());
                String iserial = boardData.get("iserial").toString();
                boardPort.getPrefs().put("iserial", iserial);
                TargetBoard board = (TargetBoard)boardData.get("board");
                if (board == null) continue;
                String boardName = board.getName();
                boardPort.setBoardName(boardName);
                continue;
            }
            if (!parts[1].equals("0000")) {
                boardPort.getPrefs().put("vid", parts[1]);
                boardPort.getPrefs().put("pid", parts[2]);
                this.boardCloudResolver.getBoardBy(parts[1], parts[2]);
                continue;
            }
            boardPort.getPrefs().put("vid", "0000");
            boardPort.getPrefs().put("pid", "0000");
            boardPort.getPrefs().put("iserial", "");
        }
        this.setSerialBoardPorts(this.boardPorts);
    }
}

