#!/usr/bin/python
# -*- coding: utf-8 -*-
import os
import xbmc
import re
import libmediathek3utils as utils
import xbmcaddon
import HTMLParser
import xbmcvfs

subFile = xbmc.translatePath(xbmcaddon.Addon().getAddonInfo('profile')+'/ttml.srt').decode('utf-8')

def ttml2Srt(url):
	return _newSubtitle(url)

def _newSubtitle(url):
	if xbmcvfs.exists(subFile):
		xbmcvfs.delete(subFile)
	try:
		content = utils.getUrl(url)
	except:
		content = ""
	if content:
		d = _stylesSetup(re.compile('<tt:styling>(.+?)</tt:styling>', re.DOTALL).findall(content)[0])
		div = re.compile('<tt:div.+?>(.+?)</tt:div>', re.DOTALL).findall(content)[0]
		p = re.compile('<tt:p(.+?)</tt:p>', re.DOTALL).findall(div)
		i = 1
		buffer = ''
		for part in p:
			if '<tt:span' in part:
				part = part.replace('begin="1','begin="0').replace('end="1','end="0').replace('\n','').replace('<tt:br/>','\n')
				begin = re.compile('begin="(.+?)"').findall(part)[0]
				begin = begin.replace(".",",")[:-1]
				end = re.compile('end="(.+?)"').findall(part)[0]
				end = end.replace(".",",")[:-1]
				s = part.split('>')[0]
				part = part.replace(s+'>','')
				part = part.replace('<tt:br />','\n')
				if 'style=' in s:
					style = re.compile('style="(.+?)"').findall(s)[0]
					if d[style]:
						part = '<font color="'+d[style]+'">'+part+'</font>'
				match = re.compile('<(.+?)>').findall(part)
				for entry in match:
					if entry.startswith('tt:span'):
						if 'style' in entry:
							style = re.compile('style="(.+?)"').findall(entry)[0]
							part = part.replace('<'+entry+'>','<font color="'+d[style]+'">')
						else:
							part = part.replace('<'+entry+'>','')
					elif entry.startswith('tt:/span'):
						part = part.replace('</tt:span>','</font>')
					else:
						part = part.replace('<'+entry+'>','')
				

				buffer += str(i) + '\n'
				buffer += begin+" --> "+end+"\n"
				buffer += part + '\n\n'
				i+=1
		buffer = buffer.replace('            ','').replace('           ','').replace('  ',' ').replace(' \n','\n')
		utils.f_write(subFile,buffer)
		return subFile


def _stylesSetup(styles):
	d = {}
	styles = styles.replace('tt:','').replace('xml:','')
	match_styles = re.compile('<style(.+?)>', re.DOTALL).findall(styles)
	for style in match_styles:
		id = re.compile('id="(.+?)"', re.DOTALL).findall(style)[0]
		if 'color=' in style:
			color = re.compile('color="(.+?)"', re.DOTALL).findall(style)[0]
		else:
			color = False
		d[id] = color
	return d


def _cleanTitle(title,html=True):
	if html:
		title = HTMLParser.HTMLParser().unescape(title)
		return title.encode("utf-8")
	else:
		title = title.replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&").replace("&#034;", "\"").replace("&#039;", "'").replace("&quot;", "\"").replace("&szlig;", "").replace("&ndash;", "-")
		title = title.replace("&Auml;", "").replace("&Uuml;", "").replace("&Ouml;", "").replace("&auml;", "").replace("&uuml;", "").replace("&ouml;", "").replace("&eacute;", "").replace("&egrave;", "")
		title = title.replace("&#x00c4;","").replace("&#x00e4;","").replace("&#x00d6;","").replace("&#x00f6;","").replace("&#x00dc;","").replace("&#x00fc;","").replace("&#x00df;","")
		title = title.replace("&apos;","'").strip()
		return title