#ifndef __VMLINUX_H__
#define __VMLINUX_H__

#ifndef BPF_NO_PRESERVE_ACCESS_INDEX
#pragma clang attribute push (__attribute__((preserve_access_index)), apply_to = record)
#endif

#ifndef __ksym
#define __ksym __attribute__((section(".ksyms")))
#endif

#ifndef __weak
#define __weak __attribute__((weak))
#endif

#ifndef __bpf_fastcall
#if __has_attribute(bpf_fastcall)
#define __bpf_fastcall __attribute__((bpf_fastcall))
#else
#define __bpf_fastcall
#endif
#endif

enum {
	A380_CPU_TO_DDR = 0,
	A380_CPU_TO_L2 = 1,
};

enum {
	A390_CPU_TO_NBCLK = 0,
	A390_CPU_TO_HCLK = 1,
	A390_CPU_TO_DCLK = 2,
};

enum {
	ACOMP_WALK_SLEEP = 1,
	ACOMP_WALK_SRC_LINEAR = 2,
	ACOMP_WALK_DST_LINEAR = 4,
};

enum {
	ACT8600 = 0,
	ACT8865 = 1,
	ACT8846 = 2,
};

enum {
	ACT8600_ID_DCDC1 = 0,
	ACT8600_ID_DCDC2 = 1,
	ACT8600_ID_DCDC3 = 2,
	ACT8600_ID_SUDCDC4 = 3,
	ACT8600_ID_LDO5 = 4,
	ACT8600_ID_LDO6 = 5,
	ACT8600_ID_LDO7 = 6,
	ACT8600_ID_LDO8 = 7,
	ACT8600_ID_LDO9 = 8,
	ACT8600_ID_LDO10 = 9,
};

enum {
	ACT8846_ID_REG1 = 0,
	ACT8846_ID_REG2 = 1,
	ACT8846_ID_REG3 = 2,
	ACT8846_ID_REG4 = 3,
	ACT8846_ID_REG5 = 4,
	ACT8846_ID_REG6 = 5,
	ACT8846_ID_REG7 = 6,
	ACT8846_ID_REG8 = 7,
	ACT8846_ID_REG9 = 8,
	ACT8846_ID_REG10 = 9,
	ACT8846_ID_REG11 = 10,
	ACT8846_ID_REG12 = 11,
	ACT8846_REG_NUM = 12,
};

enum {
	ACT8865_ID_DCDC1 = 0,
	ACT8865_ID_DCDC2 = 1,
	ACT8865_ID_DCDC3 = 2,
	ACT8865_ID_LDO1 = 3,
	ACT8865_ID_LDO2 = 4,
	ACT8865_ID_LDO3 = 5,
	ACT8865_ID_LDO4 = 6,
	ACT8865_REG_NUM = 7,
};

enum {
	ACT8945A_ID_DCDC1 = 0,
	ACT8945A_ID_DCDC2 = 1,
	ACT8945A_ID_DCDC3 = 2,
	ACT8945A_ID_LDO1 = 3,
	ACT8945A_ID_LDO2 = 4,
	ACT8945A_ID_LDO3 = 5,
	ACT8945A_ID_LDO4 = 6,
	ACT8945A_ID_MAX = 7,
};

enum {
	ACTION_FAIL = 0,
	ACTION_REPREP = 1,
	ACTION_DELAYED_REPREP = 2,
	ACTION_RETRY = 3,
	ACTION_DELAYED_RETRY = 4,
};

enum {
	ADRENO_FW_PM4 = 0,
	ADRENO_FW_SQE = 0,
	ADRENO_FW_PFP = 1,
	ADRENO_FW_GMU = 1,
	ADRENO_FW_GPMU = 2,
	ADRENO_FW_MAX = 3,
};

enum {
	AFFINITY = 0,
	AFFINITY_LIST = 1,
	EFFECTIVE = 2,
	EFFECTIVE_LIST = 3,
};

enum {
	AHB1 = 0,
	AHB2 = 1,
	APB1 = 2,
	APB2 = 3,
	PARENT_MAX = 4,
};

enum {
	AHCI_MAX_PORTS = 32,
	AHCI_MAX_SG = 168,
	AHCI_DMA_BOUNDARY = 4294967295,
	AHCI_MAX_CMDS = 32,
	AHCI_CMD_SZ = 32,
	AHCI_CMD_SLOT_SZ = 1024,
	AHCI_RX_FIS_SZ = 256,
	AHCI_CMD_TBL_CDB = 64,
	AHCI_CMD_TBL_HDR_SZ = 128,
	AHCI_CMD_TBL_SZ = 2816,
	AHCI_CMD_TBL_AR_SZ = 90112,
	AHCI_PORT_PRIV_DMA_SZ = 91392,
	AHCI_PORT_PRIV_FBS_DMA_SZ = 95232,
	AHCI_IRQ_ON_SG = 2147483648,
	AHCI_CMD_ATAPI = 32,
	AHCI_CMD_WRITE = 64,
	AHCI_CMD_PREFETCH = 128,
	AHCI_CMD_RESET = 256,
	AHCI_CMD_CLR_BUSY = 1024,
	RX_FIS_PIO_SETUP = 32,
	RX_FIS_D2H_REG = 64,
	RX_FIS_SDB = 88,
	RX_FIS_UNK = 96,
	HOST_CAP = 0,
	HOST_CTL = 4,
	HOST_IRQ_STAT = 8,
	HOST_PORTS_IMPL = 12,
	HOST_VERSION = 16,
	HOST_EM_LOC = 28,
	HOST_EM_CTL = 32,
	HOST_CAP2 = 36,
	HOST_RESET = 1,
	HOST_IRQ_EN = 2,
	HOST_MRSM = 4,
	HOST_AHCI_EN = 2147483648,
	HOST_CAP_SXS = 32,
	HOST_CAP_EMS = 64,
	HOST_CAP_CCC = 128,
	HOST_CAP_PART = 8192,
	HOST_CAP_SSC = 16384,
	HOST_CAP_PIO_MULTI = 32768,
	HOST_CAP_FBS = 65536,
	HOST_CAP_PMP = 131072,
	HOST_CAP_ONLY = 262144,
	HOST_CAP_CLO = 16777216,
	HOST_CAP_LED = 33554432,
	HOST_CAP_ALPM = 67108864,
	HOST_CAP_SSS = 134217728,
	HOST_CAP_MPS = 268435456,
	HOST_CAP_SNTF = 536870912,
	HOST_CAP_NCQ = 1073741824,
	HOST_CAP_64 = 2147483648,
	HOST_CAP2_BOH = 1,
	HOST_CAP2_NVMHCI = 2,
	HOST_CAP2_APST = 4,
	HOST_CAP2_SDS = 8,
	HOST_CAP2_SADM = 16,
	HOST_CAP2_DESO = 32,
	PORT_LST_ADDR = 0,
	PORT_LST_ADDR_HI = 4,
	PORT_FIS_ADDR = 8,
	PORT_FIS_ADDR_HI = 12,
	PORT_IRQ_STAT = 16,
	PORT_IRQ_MASK = 20,
	PORT_CMD = 24,
	PORT_TFDATA = 32,
	PORT_SIG = 36,
	PORT_CMD_ISSUE = 56,
	PORT_SCR_STAT = 40,
	PORT_SCR_CTL = 44,
	PORT_SCR_ERR = 48,
	PORT_SCR_ACT = 52,
	PORT_SCR_NTF = 60,
	PORT_FBS = 64,
	PORT_DEVSLP = 68,
	PORT_IRQ_COLD_PRES = 2147483648,
	PORT_IRQ_TF_ERR = 1073741824,
	PORT_IRQ_HBUS_ERR = 536870912,
	PORT_IRQ_HBUS_DATA_ERR = 268435456,
	PORT_IRQ_IF_ERR = 134217728,
	PORT_IRQ_IF_NONFATAL = 67108864,
	PORT_IRQ_OVERFLOW = 16777216,
	PORT_IRQ_BAD_PMP = 8388608,
	PORT_IRQ_PHYRDY = 4194304,
	PORT_IRQ_DMPS = 128,
	PORT_IRQ_CONNECT = 64,
	PORT_IRQ_SG_DONE = 32,
	PORT_IRQ_UNK_FIS = 16,
	PORT_IRQ_SDB_FIS = 8,
	PORT_IRQ_DMAS_FIS = 4,
	PORT_IRQ_PIOS_FIS = 2,
	PORT_IRQ_D2H_REG_FIS = 1,
	PORT_IRQ_FREEZE = 683671632,
	PORT_IRQ_ERROR = 2025848912,
	DEF_PORT_IRQ = 2025848959,
	PORT_CMD_ASP = 134217728,
	PORT_CMD_ALPE = 67108864,
	PORT_CMD_ATAPI = 16777216,
	PORT_CMD_FBSCP = 4194304,
	PORT_CMD_ESP = 2097152,
	PORT_CMD_CPD = 1048576,
	PORT_CMD_MPSP = 524288,
	PORT_CMD_HPCP = 262144,
	PORT_CMD_PMP = 131072,
	PORT_CMD_LIST_ON = 32768,
	PORT_CMD_FIS_ON = 16384,
	PORT_CMD_FIS_RX = 16,
	PORT_CMD_CLO = 8,
	PORT_CMD_POWER_ON = 4,
	PORT_CMD_SPIN_UP = 2,
	PORT_CMD_START = 1,
	PORT_CMD_ICC_MASK = 4026531840,
	PORT_CMD_ICC_ACTIVE = 268435456,
	PORT_CMD_ICC_PARTIAL = 536870912,
	PORT_CMD_ICC_SLUMBER = 1610612736,
	PORT_CMD_CAP = 8126464,
	PORT_FBS_DWE_OFFSET = 16,
	PORT_FBS_ADO_OFFSET = 12,
	PORT_FBS_DEV_OFFSET = 8,
	PORT_FBS_DEV_MASK = 3840,
	PORT_FBS_SDE = 4,
	PORT_FBS_DEC = 2,
	PORT_FBS_EN = 1,
	PORT_DEVSLP_DM_OFFSET = 25,
	PORT_DEVSLP_DM_MASK = 503316480,
	PORT_DEVSLP_DITO_OFFSET = 15,
	PORT_DEVSLP_MDAT_OFFSET = 10,
	PORT_DEVSLP_DETO_OFFSET = 2,
	PORT_DEVSLP_DSP = 2,
	PORT_DEVSLP_ADSE = 1,
	AHCI_HFLAG_NO_NCQ = 1,
	AHCI_HFLAG_IGN_IRQ_IF_ERR = 2,
	AHCI_HFLAG_IGN_SERR_INTERNAL = 4,
	AHCI_HFLAG_32BIT_ONLY = 8,
	AHCI_HFLAG_MV_PATA = 16,
	AHCI_HFLAG_NO_MSI = 32,
	AHCI_HFLAG_NO_PMP = 64,
	AHCI_HFLAG_SECT255 = 256,
	AHCI_HFLAG_YES_NCQ = 512,
	AHCI_HFLAG_NO_SUSPEND = 1024,
	AHCI_HFLAG_SRST_TOUT_IS_OFFLINE = 2048,
	AHCI_HFLAG_NO_SNTF = 4096,
	AHCI_HFLAG_NO_FPDMA_AA = 8192,
	AHCI_HFLAG_YES_FBS = 16384,
	AHCI_HFLAG_DELAY_ENGINE = 32768,
	AHCI_HFLAG_NO_DEVSLP = 131072,
	AHCI_HFLAG_NO_FBS = 262144,
	AHCI_HFLAG_MULTI_MSI = 1048576,
	AHCI_HFLAG_WAKE_BEFORE_STOP = 4194304,
	AHCI_HFLAG_YES_ALPM = 8388608,
	AHCI_HFLAG_NO_WRITE_TO_RO = 16777216,
	AHCI_HFLAG_SUSPEND_PHYS = 33554432,
	AHCI_HFLAG_NO_SXS = 67108864,
	AHCI_HFLAG_43BIT_ONLY = 134217728,
	AHCI_HFLAG_INTEL_PCS_QUIRK = 268435456,
	AHCI_HFLAG_ATAPI_DMA_QUIRK = 536870912,
	AHCI_FLAG_COMMON = 393346,
	ICH_MAP = 144,
	PCS_6 = 146,
	PCS_7 = 148,
	EM_MAX_SLOTS = 15,
	EM_MAX_RETRY = 5,
	EM_CTL_RST = 512,
	EM_CTL_TM = 256,
	EM_CTL_MR = 1,
	EM_CTL_ALHD = 67108864,
	EM_CTL_XMT = 33554432,
	EM_CTL_SMB = 16777216,
	EM_CTL_SGPIO = 524288,
	EM_CTL_SES = 262144,
	EM_CTL_SAFTE = 131072,
	EM_CTL_LED = 65536,
	EM_MSG_TYPE_LED = 1,
	EM_MSG_TYPE_SAFTE = 2,
	EM_MSG_TYPE_SES2 = 4,
	EM_MSG_TYPE_SGPIO = 8,
};

enum {
	AHCI_PCI_BAR_STA2X11 = 0,
	AHCI_PCI_BAR_CAVIUM = 0,
	AHCI_PCI_BAR_LOONGSON = 0,
	AHCI_PCI_BAR_ENMOTUS = 2,
	AHCI_PCI_BAR_CAVIUM_GEN5 = 4,
	AHCI_PCI_BAR_STANDARD = 5,
};

enum {
	ALE_ENT_VID_MEMBER_LIST = 0,
	ALE_ENT_VID_UNREG_MCAST_MSK = 1,
	ALE_ENT_VID_REG_MCAST_MSK = 2,
	ALE_ENT_VID_FORCE_UNTAGGED_MSK = 3,
	ALE_ENT_VID_UNREG_MCAST_IDX = 4,
	ALE_ENT_VID_REG_MCAST_IDX = 5,
	ALE_ENT_VID_LAST = 6,
};

enum {
	ALLOC_MODE_DEFAULT = 0,
	ALLOC_MODE_REUSE = 1,
};

enum {
	ALLOC_NODE = 0,
	LOOKUP_NODE = 1,
	LOOKUP_NODE_RA = 2,
};

enum {
	AM62A7_EFUSE_M_MPU_OPP = 13,
	AM62A7_EFUSE_N_MPU_OPP = 14,
	AM62A7_EFUSE_O_MPU_OPP = 15,
	AM62A7_EFUSE_P_MPU_OPP = 16,
	AM62A7_EFUSE_Q_MPU_OPP = 17,
	AM62A7_EFUSE_R_MPU_OPP = 18,
	AM62A7_EFUSE_S_MPU_OPP = 19,
	AM62A7_EFUSE_V_MPU_OPP = 20,
	AM62A7_EFUSE_U_MPU_OPP = 21,
	AM62A7_EFUSE_T_MPU_OPP = 22,
};

enum {
	ASCII_NULL = 0,
	ASCII_BELL = 7,
	ASCII_BACKSPACE = 8,
	ASCII_IGNORE_FIRST = 8,
	ASCII_HTAB = 9,
	ASCII_LINEFEED = 10,
	ASCII_VTAB = 11,
	ASCII_FORMFEED = 12,
	ASCII_CAR_RET = 13,
	ASCII_IGNORE_LAST = 13,
	ASCII_SHIFTOUT = 14,
	ASCII_SHIFTIN = 15,
	ASCII_CANCEL = 24,
	ASCII_SUBSTITUTE = 26,
	ASCII_ESCAPE = 27,
	ASCII_CSI_IGNORE_FIRST = 32,
	ASCII_CSI_IGNORE_LAST = 63,
	ASCII_DEL = 127,
	ASCII_EXT_CSI = 155,
};

enum {
	ASSACT_REPORT = 0,
	ASSACT_RO = 1,
	ASSACT_PANIC = 2,
};

enum {
	ASSUME_PERFECT = 255,
	ASSUME_VALID_DTB = 1,
	ASSUME_VALID_INPUT = 2,
	ASSUME_LATEST = 4,
	ASSUME_NO_ROLLBACK = 8,
	ASSUME_LIBFDT_ORDER = 16,
	ASSUME_LIBFDT_FLAWLESS = 32,
};

enum {
	ATA_EH_SPDN_NCQ_OFF = 1,
	ATA_EH_SPDN_SPEED_DOWN = 2,
	ATA_EH_SPDN_FALLBACK_TO_PIO = 4,
	ATA_EH_SPDN_KEEP_ERRORS = 8,
	ATA_EFLAG_IS_IO = 1,
	ATA_EFLAG_DUBIOUS_XFER = 2,
	ATA_EFLAG_OLD_ER = -2147483648,
	ATA_ECAT_NONE = 0,
	ATA_ECAT_ATA_BUS = 1,
	ATA_ECAT_TOUT_HSM = 2,
	ATA_ECAT_UNK_DEV = 3,
	ATA_ECAT_DUBIOUS_NONE = 4,
	ATA_ECAT_DUBIOUS_ATA_BUS = 5,
	ATA_ECAT_DUBIOUS_TOUT_HSM = 6,
	ATA_ECAT_DUBIOUS_UNK_DEV = 7,
	ATA_ECAT_NR = 8,
	ATA_EH_CMD_DFL_TIMEOUT = 5000,
	ATA_EH_RESET_COOL_DOWN = 5000,
	ATA_EH_PRERESET_TIMEOUT = 10000,
	ATA_EH_FASTDRAIN_INTERVAL = 3000,
	ATA_EH_UA_TRIES = 5,
	ATA_EH_PROBE_TRIAL_INTERVAL = 60000,
	ATA_EH_PROBE_TRIALS = 2,
};

enum {
	ATA_MAX_DEVICES = 2,
	ATA_MAX_PRD = 256,
	ATA_SECT_SIZE = 512,
	ATA_MAX_SECTORS_128 = 128,
	ATA_MAX_SECTORS = 256,
	ATA_MAX_SECTORS_1024 = 1024,
	ATA_MAX_SECTORS_LBA48 = 65535,
	ATA_MAX_SECTORS_TAPE = 65535,
	ATA_MAX_TRIM_RNUM = 64,
	ATA_ID_WORDS = 256,
	ATA_ID_CONFIG = 0,
	ATA_ID_CYLS = 1,
	ATA_ID_HEADS = 3,
	ATA_ID_SECTORS = 6,
	ATA_ID_SERNO = 10,
	ATA_ID_BUF_SIZE = 21,
	ATA_ID_FW_REV = 23,
	ATA_ID_PROD = 27,
	ATA_ID_MAX_MULTSECT = 47,
	ATA_ID_DWORD_IO = 48,
	ATA_ID_TRUSTED = 48,
	ATA_ID_CAPABILITY = 49,
	ATA_ID_OLD_PIO_MODES = 51,
	ATA_ID_OLD_DMA_MODES = 52,
	ATA_ID_FIELD_VALID = 53,
	ATA_ID_CUR_CYLS = 54,
	ATA_ID_CUR_HEADS = 55,
	ATA_ID_CUR_SECTORS = 56,
	ATA_ID_MULTSECT = 59,
	ATA_ID_LBA_CAPACITY = 60,
	ATA_ID_SWDMA_MODES = 62,
	ATA_ID_MWDMA_MODES = 63,
	ATA_ID_PIO_MODES = 64,
	ATA_ID_EIDE_DMA_MIN = 65,
	ATA_ID_EIDE_DMA_TIME = 66,
	ATA_ID_EIDE_PIO = 67,
	ATA_ID_EIDE_PIO_IORDY = 68,
	ATA_ID_ADDITIONAL_SUPP = 69,
	ATA_ID_QUEUE_DEPTH = 75,
	ATA_ID_SATA_CAPABILITY = 76,
	ATA_ID_SATA_CAPABILITY_2 = 77,
	ATA_ID_FEATURE_SUPP = 78,
	ATA_ID_MAJOR_VER = 80,
	ATA_ID_COMMAND_SET_1 = 82,
	ATA_ID_COMMAND_SET_2 = 83,
	ATA_ID_CFSSE = 84,
	ATA_ID_CFS_ENABLE_1 = 85,
	ATA_ID_CFS_ENABLE_2 = 86,
	ATA_ID_CSF_DEFAULT = 87,
	ATA_ID_UDMA_MODES = 88,
	ATA_ID_HW_CONFIG = 93,
	ATA_ID_SPG = 98,
	ATA_ID_LBA_CAPACITY_2 = 100,
	ATA_ID_SECTOR_SIZE = 106,
	ATA_ID_WWN = 108,
	ATA_ID_LOGICAL_SECTOR_SIZE = 117,
	ATA_ID_COMMAND_SET_3 = 119,
	ATA_ID_COMMAND_SET_4 = 120,
	ATA_ID_LAST_LUN = 126,
	ATA_ID_DLF = 128,
	ATA_ID_CSFO = 129,
	ATA_ID_CFA_POWER = 160,
	ATA_ID_CFA_KEY_MGMT = 162,
	ATA_ID_CFA_MODES = 163,
	ATA_ID_DATA_SET_MGMT = 169,
	ATA_ID_SCT_CMD_XPORT = 206,
	ATA_ID_ROT_SPEED = 217,
	ATA_ID_PIO4 = 2,
	ATA_ID_SERNO_LEN = 20,
	ATA_ID_FW_REV_LEN = 8,
	ATA_ID_PROD_LEN = 40,
	ATA_ID_WWN_LEN = 8,
	ATA_PCI_CTL_OFS = 2,
	ATA_PIO0 = 1,
	ATA_PIO1 = 3,
	ATA_PIO2 = 7,
	ATA_PIO3 = 15,
	ATA_PIO4 = 31,
	ATA_PIO5 = 63,
	ATA_PIO6 = 127,
	ATA_PIO4_ONLY = 16,
	ATA_SWDMA0 = 1,
	ATA_SWDMA1 = 3,
	ATA_SWDMA2 = 7,
	ATA_SWDMA2_ONLY = 4,
	ATA_MWDMA0 = 1,
	ATA_MWDMA1 = 3,
	ATA_MWDMA2 = 7,
	ATA_MWDMA3 = 15,
	ATA_MWDMA4 = 31,
	ATA_MWDMA12_ONLY = 6,
	ATA_MWDMA2_ONLY = 4,
	ATA_UDMA0 = 1,
	ATA_UDMA1 = 3,
	ATA_UDMA2 = 7,
	ATA_UDMA3 = 15,
	ATA_UDMA4 = 31,
	ATA_UDMA5 = 63,
	ATA_UDMA6 = 127,
	ATA_UDMA7 = 255,
	ATA_UDMA24_ONLY = 20,
	ATA_UDMA_MASK_40C = 7,
	ATA_PRD_SZ = 8,
	ATA_PRD_TBL_SZ = 2048,
	ATA_PRD_EOT = -2147483648,
	ATA_DMA_TABLE_OFS = 4,
	ATA_DMA_STATUS = 2,
	ATA_DMA_CMD = 0,
	ATA_DMA_WR = 8,
	ATA_DMA_START = 1,
	ATA_DMA_INTR = 4,
	ATA_DMA_ERR = 2,
	ATA_DMA_ACTIVE = 1,
	ATA_HOB = 128,
	ATA_NIEN = 2,
	ATA_LBA = 64,
	ATA_DEV1 = 16,
	ATA_DEVICE_OBS = 160,
	ATA_DEVCTL_OBS = 8,
	ATA_BUSY = 128,
	ATA_DRDY = 64,
	ATA_DF = 32,
	ATA_DSC = 16,
	ATA_DRQ = 8,
	ATA_CORR = 4,
	ATA_SENSE = 2,
	ATA_ERR = 1,
	ATA_SRST = 4,
	ATA_ICRC = 128,
	ATA_BBK = 128,
	ATA_UNC = 64,
	ATA_MC = 32,
	ATA_IDNF = 16,
	ATA_MCR = 8,
	ATA_ABORTED = 4,
	ATA_TRK0NF = 2,
	ATA_AMNF = 1,
	ATAPI_LFS = 240,
	ATAPI_EOM = 2,
	ATAPI_ILI = 1,
	ATAPI_IO = 2,
	ATAPI_COD = 1,
	ATA_REG_DATA = 0,
	ATA_REG_ERR = 1,
	ATA_REG_NSECT = 2,
	ATA_REG_LBAL = 3,
	ATA_REG_LBAM = 4,
	ATA_REG_LBAH = 5,
	ATA_REG_DEVICE = 6,
	ATA_REG_STATUS = 7,
	ATA_REG_FEATURE = 1,
	ATA_REG_CMD = 7,
	ATA_REG_BYTEL = 4,
	ATA_REG_BYTEH = 5,
	ATA_REG_DEVSEL = 6,
	ATA_REG_IRQ = 2,
	ATA_CMD_DEV_RESET = 8,
	ATA_CMD_CHK_POWER = 229,
	ATA_CMD_STANDBY = 226,
	ATA_CMD_IDLE = 227,
	ATA_CMD_EDD = 144,
	ATA_CMD_DOWNLOAD_MICRO = 146,
	ATA_CMD_DOWNLOAD_MICRO_DMA = 147,
	ATA_CMD_NOP = 0,
	ATA_CMD_FLUSH = 231,
	ATA_CMD_FLUSH_EXT = 234,
	ATA_CMD_ID_ATA = 236,
	ATA_CMD_ID_ATAPI = 161,
	ATA_CMD_SERVICE = 162,
	ATA_CMD_READ = 200,
	ATA_CMD_READ_EXT = 37,
	ATA_CMD_READ_QUEUED = 38,
	ATA_CMD_READ_STREAM_EXT = 43,
	ATA_CMD_READ_STREAM_DMA_EXT = 42,
	ATA_CMD_WRITE = 202,
	ATA_CMD_WRITE_EXT = 53,
	ATA_CMD_WRITE_QUEUED = 54,
	ATA_CMD_WRITE_STREAM_EXT = 59,
	ATA_CMD_WRITE_STREAM_DMA_EXT = 58,
	ATA_CMD_WRITE_FUA_EXT = 61,
	ATA_CMD_WRITE_QUEUED_FUA_EXT = 62,
	ATA_CMD_FPDMA_READ = 96,
	ATA_CMD_FPDMA_WRITE = 97,
	ATA_CMD_NCQ_NON_DATA = 99,
	ATA_CMD_FPDMA_SEND = 100,
	ATA_CMD_FPDMA_RECV = 101,
	ATA_CMD_PIO_READ = 32,
	ATA_CMD_PIO_READ_EXT = 36,
	ATA_CMD_PIO_WRITE = 48,
	ATA_CMD_PIO_WRITE_EXT = 52,
	ATA_CMD_READ_MULTI = 196,
	ATA_CMD_READ_MULTI_EXT = 41,
	ATA_CMD_WRITE_MULTI = 197,
	ATA_CMD_WRITE_MULTI_EXT = 57,
	ATA_CMD_WRITE_MULTI_FUA_EXT = 206,
	ATA_CMD_SET_FEATURES = 239,
	ATA_CMD_SET_MULTI = 198,
	ATA_CMD_PACKET = 160,
	ATA_CMD_VERIFY = 64,
	ATA_CMD_VERIFY_EXT = 66,
	ATA_CMD_WRITE_UNCORR_EXT = 69,
	ATA_CMD_STANDBYNOW1 = 224,
	ATA_CMD_IDLEIMMEDIATE = 225,
	ATA_CMD_SLEEP = 230,
	ATA_CMD_INIT_DEV_PARAMS = 145,
	ATA_CMD_READ_NATIVE_MAX = 248,
	ATA_CMD_READ_NATIVE_MAX_EXT = 39,
	ATA_CMD_SET_MAX = 249,
	ATA_CMD_SET_MAX_EXT = 55,
	ATA_CMD_READ_LOG_EXT = 47,
	ATA_CMD_WRITE_LOG_EXT = 63,
	ATA_CMD_READ_LOG_DMA_EXT = 71,
	ATA_CMD_WRITE_LOG_DMA_EXT = 87,
	ATA_CMD_TRUSTED_NONDATA = 91,
	ATA_CMD_TRUSTED_RCV = 92,
	ATA_CMD_TRUSTED_RCV_DMA = 93,
	ATA_CMD_TRUSTED_SND = 94,
	ATA_CMD_TRUSTED_SND_DMA = 95,
	ATA_CMD_PMP_READ = 228,
	ATA_CMD_PMP_READ_DMA = 233,
	ATA_CMD_PMP_WRITE = 232,
	ATA_CMD_PMP_WRITE_DMA = 235,
	ATA_CMD_CONF_OVERLAY = 177,
	ATA_CMD_SEC_SET_PASS = 241,
	ATA_CMD_SEC_UNLOCK = 242,
	ATA_CMD_SEC_ERASE_PREP = 243,
	ATA_CMD_SEC_ERASE_UNIT = 244,
	ATA_CMD_SEC_FREEZE_LOCK = 245,
	ATA_CMD_SEC_DISABLE_PASS = 246,
	ATA_CMD_CONFIG_STREAM = 81,
	ATA_CMD_SMART = 176,
	ATA_CMD_MEDIA_LOCK = 222,
	ATA_CMD_MEDIA_UNLOCK = 223,
	ATA_CMD_DSM = 6,
	ATA_CMD_CHK_MED_CRD_TYP = 209,
	ATA_CMD_CFA_REQ_EXT_ERR = 3,
	ATA_CMD_CFA_WRITE_NE = 56,
	ATA_CMD_CFA_TRANS_SECT = 135,
	ATA_CMD_CFA_ERASE = 192,
	ATA_CMD_CFA_WRITE_MULT_NE = 205,
	ATA_CMD_REQ_SENSE_DATA = 11,
	ATA_CMD_SANITIZE_DEVICE = 180,
	ATA_CMD_ZAC_MGMT_IN = 74,
	ATA_CMD_ZAC_MGMT_OUT = 159,
	ATA_CMD_RESTORE = 16,
	ATA_SUBCMD_FPDMA_RECV_RD_LOG_DMA_EXT = 1,
	ATA_SUBCMD_FPDMA_RECV_ZAC_MGMT_IN = 2,
	ATA_SUBCMD_FPDMA_SEND_DSM = 0,
	ATA_SUBCMD_FPDMA_SEND_WR_LOG_DMA_EXT = 2,
	ATA_SUBCMD_NCQ_NON_DATA_ABORT_QUEUE = 0,
	ATA_SUBCMD_NCQ_NON_DATA_SET_FEATURES = 5,
	ATA_SUBCMD_NCQ_NON_DATA_ZERO_EXT = 6,
	ATA_SUBCMD_NCQ_NON_DATA_ZAC_MGMT_OUT = 7,
	ATA_SUBCMD_ZAC_MGMT_IN_REPORT_ZONES = 0,
	ATA_SUBCMD_ZAC_MGMT_OUT_CLOSE_ZONE = 1,
	ATA_SUBCMD_ZAC_MGMT_OUT_FINISH_ZONE = 2,
	ATA_SUBCMD_ZAC_MGMT_OUT_OPEN_ZONE = 3,
	ATA_SUBCMD_ZAC_MGMT_OUT_RESET_WRITE_POINTER = 4,
	ATA_LOG_DIRECTORY = 0,
	ATA_LOG_SATA_NCQ = 16,
	ATA_LOG_NCQ_NON_DATA = 18,
	ATA_LOG_NCQ_SEND_RECV = 19,
	ATA_LOG_CDL = 24,
	ATA_LOG_CDL_SIZE = 512,
	ATA_LOG_IDENTIFY_DEVICE = 48,
	ATA_LOG_SENSE_NCQ = 15,
	ATA_LOG_SENSE_NCQ_SIZE = 1024,
	ATA_LOG_CONCURRENT_POSITIONING_RANGES = 71,
	ATA_LOG_SUPPORTED_CAPABILITIES = 3,
	ATA_LOG_CURRENT_SETTINGS = 4,
	ATA_LOG_SECURITY = 6,
	ATA_LOG_SATA_SETTINGS = 8,
	ATA_LOG_ZONED_INFORMATION = 9,
	ATA_LOG_DEVSLP_OFFSET = 48,
	ATA_LOG_DEVSLP_SIZE = 8,
	ATA_LOG_DEVSLP_MDAT = 0,
	ATA_LOG_DEVSLP_MDAT_MASK = 31,
	ATA_LOG_DEVSLP_DETO = 1,
	ATA_LOG_DEVSLP_VALID = 7,
	ATA_LOG_DEVSLP_VALID_MASK = 128,
	ATA_LOG_NCQ_PRIO_OFFSET = 9,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_SEND_RECV_SUBCMDS_DSM = 1,
	ATA_LOG_NCQ_SEND_RECV_DSM_OFFSET = 4,
	ATA_LOG_NCQ_SEND_RECV_DSM_TRIM = 1,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_OFFSET = 8,
	ATA_LOG_NCQ_SEND_RECV_RD_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_OFFSET = 12,
	ATA_LOG_NCQ_SEND_RECV_WR_LOG_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OFFSET = 16,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_OUT_SUPPORTED = 1,
	ATA_LOG_NCQ_SEND_RECV_ZAC_MGMT_IN_SUPPORTED = 2,
	ATA_LOG_NCQ_SEND_RECV_SIZE = 20,
	ATA_LOG_NCQ_NON_DATA_SUBCMDS_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_OFFSET = 0,
	ATA_LOG_NCQ_NON_DATA_ABORT_NCQ = 1,
	ATA_LOG_NCQ_NON_DATA_ABORT_ALL = 2,
	ATA_LOG_NCQ_NON_DATA_ABORT_STREAMING = 4,
	ATA_LOG_NCQ_NON_DATA_ABORT_NON_STREAMING = 8,
	ATA_LOG_NCQ_NON_DATA_ABORT_SELECTED = 16,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OFFSET = 28,
	ATA_LOG_NCQ_NON_DATA_ZAC_MGMT_OUT = 1,
	ATA_LOG_NCQ_NON_DATA_SIZE = 64,
	ATA_CMD_READ_LONG = 34,
	ATA_CMD_READ_LONG_ONCE = 35,
	ATA_CMD_WRITE_LONG = 50,
	ATA_CMD_WRITE_LONG_ONCE = 51,
	SETFEATURES_XFER = 3,
	XFER_UDMA_7 = 71,
	XFER_UDMA_6 = 70,
	XFER_UDMA_5 = 69,
	XFER_UDMA_4 = 68,
	XFER_UDMA_3 = 67,
	XFER_UDMA_2 = 66,
	XFER_UDMA_1 = 65,
	XFER_UDMA_0 = 64,
	XFER_MW_DMA_4 = 36,
	XFER_MW_DMA_3 = 35,
	XFER_MW_DMA_2 = 34,
	XFER_MW_DMA_1 = 33,
	XFER_MW_DMA_0 = 32,
	XFER_SW_DMA_2 = 18,
	XFER_SW_DMA_1 = 17,
	XFER_SW_DMA_0 = 16,
	XFER_PIO_6 = 14,
	XFER_PIO_5 = 13,
	XFER_PIO_4 = 12,
	XFER_PIO_3 = 11,
	XFER_PIO_2 = 10,
	XFER_PIO_1 = 9,
	XFER_PIO_0 = 8,
	XFER_PIO_SLOW = 0,
	SETFEATURES_WC_ON = 2,
	SETFEATURES_WC_OFF = 130,
	SETFEATURES_RA_ON = 170,
	SETFEATURES_RA_OFF = 85,
	SETFEATURES_AAM_ON = 66,
	SETFEATURES_AAM_OFF = 194,
	SETFEATURES_SPINUP = 7,
	SETFEATURES_SPINUP_TIMEOUT = 30000,
	SETFEATURES_SATA_ENABLE = 16,
	SETFEATURES_SATA_DISABLE = 144,
	SETFEATURES_CDL = 13,
	SATA_FPDMA_OFFSET = 1,
	SATA_FPDMA_AA = 2,
	SATA_DIPM = 3,
	SATA_FPDMA_IN_ORDER = 4,
	SATA_AN = 5,
	SATA_SSP = 6,
	SATA_DEVSLP = 9,
	SETFEATURE_SENSE_DATA = 195,
	SETFEATURE_SENSE_DATA_SUCC_NCQ = 196,
	ATA_SET_MAX_ADDR = 0,
	ATA_SET_MAX_PASSWD = 1,
	ATA_SET_MAX_LOCK = 2,
	ATA_SET_MAX_UNLOCK = 3,
	ATA_SET_MAX_FREEZE_LOCK = 4,
	ATA_SET_MAX_PASSWD_DMA = 5,
	ATA_SET_MAX_UNLOCK_DMA = 6,
	ATA_DCO_RESTORE = 192,
	ATA_DCO_FREEZE_LOCK = 193,
	ATA_DCO_IDENTIFY = 194,
	ATA_DCO_SET = 195,
	ATA_SMART_ENABLE = 216,
	ATA_SMART_READ_VALUES = 208,
	ATA_SMART_READ_THRESHOLDS = 209,
	ATA_DSM_TRIM = 1,
	ATA_SMART_LBAM_PASS = 79,
	ATA_SMART_LBAH_PASS = 194,
	ATAPI_PKT_DMA = 1,
	ATAPI_DMADIR = 4,
	ATAPI_CDB_LEN = 16,
	SATA_PMP_MAX_PORTS = 15,
	SATA_PMP_CTRL_PORT = 15,
	SATA_PMP_GSCR_DWORDS = 128,
	SATA_PMP_GSCR_PROD_ID = 0,
	SATA_PMP_GSCR_REV = 1,
	SATA_PMP_GSCR_PORT_INFO = 2,
	SATA_PMP_GSCR_ERROR = 32,
	SATA_PMP_GSCR_ERROR_EN = 33,
	SATA_PMP_GSCR_FEAT = 64,
	SATA_PMP_GSCR_FEAT_EN = 96,
	SATA_PMP_PSCR_STATUS = 0,
	SATA_PMP_PSCR_ERROR = 1,
	SATA_PMP_PSCR_CONTROL = 2,
	SATA_PMP_FEAT_BIST = 1,
	SATA_PMP_FEAT_PMREQ = 2,
	SATA_PMP_FEAT_DYNSSC = 4,
	SATA_PMP_FEAT_NOTIFY = 8,
	ATA_CBL_NONE = 0,
	ATA_CBL_PATA40 = 1,
	ATA_CBL_PATA80 = 2,
	ATA_CBL_PATA40_SHORT = 3,
	ATA_CBL_PATA_UNK = 4,
	ATA_CBL_PATA_IGN = 5,
	ATA_CBL_SATA = 6,
	SCR_STATUS = 0,
	SCR_ERROR = 1,
	SCR_CONTROL = 2,
	SCR_ACTIVE = 3,
	SCR_NOTIFICATION = 4,
	SERR_DATA_RECOVERED = 1,
	SERR_COMM_RECOVERED = 2,
	SERR_DATA = 256,
	SERR_PERSISTENT = 512,
	SERR_PROTOCOL = 1024,
	SERR_INTERNAL = 2048,
	SERR_PHYRDY_CHG = 65536,
	SERR_PHY_INT_ERR = 131072,
	SERR_COMM_WAKE = 262144,
	SERR_10B_8B_ERR = 524288,
	SERR_DISPARITY = 1048576,
	SERR_CRC = 2097152,
	SERR_HANDSHAKE = 4194304,
	SERR_LINK_SEQ_ERR = 8388608,
	SERR_TRANS_ST_ERROR = 16777216,
	SERR_UNRECOG_FIS = 33554432,
	SERR_DEV_XCHG = 67108864,
};

enum {
	ATA_READID_POSTRESET = 1,
	ATA_DNXFER_PIO = 0,
	ATA_DNXFER_DMA = 1,
	ATA_DNXFER_40C = 2,
	ATA_DNXFER_FORCE_PIO = 3,
	ATA_DNXFER_FORCE_PIO0 = 4,
	ATA_DNXFER_QUIET = -2147483648,
};

enum {
	AT_PKT_END = -1,
	BEYOND_PKT_END = -2,
};

enum {
	AUDIO_ROUTE_I2S = 0,
	AUDIO_ROUTE_SPDIF = 1,
	AUDIO_ROUTE_NUM = 2,
};

enum {
	AUTOFS_DEV_IOCTL_VERSION_CMD = 113,
	AUTOFS_DEV_IOCTL_PROTOVER_CMD = 114,
	AUTOFS_DEV_IOCTL_PROTOSUBVER_CMD = 115,
	AUTOFS_DEV_IOCTL_OPENMOUNT_CMD = 116,
	AUTOFS_DEV_IOCTL_CLOSEMOUNT_CMD = 117,
	AUTOFS_DEV_IOCTL_READY_CMD = 118,
	AUTOFS_DEV_IOCTL_FAIL_CMD = 119,
	AUTOFS_DEV_IOCTL_SETPIPEFD_CMD = 120,
	AUTOFS_DEV_IOCTL_CATATONIC_CMD = 121,
	AUTOFS_DEV_IOCTL_TIMEOUT_CMD = 122,
	AUTOFS_DEV_IOCTL_REQUESTER_CMD = 123,
	AUTOFS_DEV_IOCTL_EXPIRE_CMD = 124,
	AUTOFS_DEV_IOCTL_ASKUMOUNT_CMD = 125,
	AUTOFS_DEV_IOCTL_ISMOUNTPOINT_CMD = 126,
};

enum {
	AUTOFS_IOC_EXPIRE_MULTI_CMD = 102,
	AUTOFS_IOC_PROTOSUBVER_CMD = 103,
	AUTOFS_IOC_ASKUMOUNT_CMD = 112,
};

enum {
	AUTOFS_IOC_READY_CMD = 96,
	AUTOFS_IOC_FAIL_CMD = 97,
	AUTOFS_IOC_CATATONIC_CMD = 98,
	AUTOFS_IOC_PROTOVER_CMD = 99,
	AUTOFS_IOC_SETTIMEOUT_CMD = 100,
	AUTOFS_IOC_EXPIRE_CMD = 101,
};

enum {
	AUTOP_INVALID = 0,
	AUTOP_HDD = 1,
	AUTOP_SSD_QD1 = 2,
	AUTOP_SSD_DFL = 3,
	AUTOP_SSD_FAST = 4,
};

enum {
	AX25_VALUES_IPDEFMODE = 0,
	AX25_VALUES_AXDEFMODE = 1,
	AX25_VALUES_BACKOFF = 2,
	AX25_VALUES_CONMODE = 3,
	AX25_VALUES_WINDOW = 4,
	AX25_VALUES_EWINDOW = 5,
	AX25_VALUES_T1 = 6,
	AX25_VALUES_T2 = 7,
	AX25_VALUES_T3 = 8,
	AX25_VALUES_IDLE = 9,
	AX25_VALUES_N2 = 10,
	AX25_VALUES_PACLEN = 11,
	AX25_VALUES_PROTOCOL = 12,
	AX25_VALUES_DS_TIMEOUT = 13,
	AX25_MAX_VALUES = 14,
};

enum {
	AXP15060_DCDC1 = 0,
	AXP15060_DCDC2 = 1,
	AXP15060_DCDC3 = 2,
	AXP15060_DCDC4 = 3,
	AXP15060_DCDC5 = 4,
	AXP15060_DCDC6 = 5,
	AXP15060_ALDO1 = 6,
	AXP15060_ALDO2 = 7,
	AXP15060_ALDO3 = 8,
	AXP15060_ALDO4 = 9,
	AXP15060_ALDO5 = 10,
	AXP15060_BLDO1 = 11,
	AXP15060_BLDO2 = 12,
	AXP15060_BLDO3 = 13,
	AXP15060_BLDO4 = 14,
	AXP15060_BLDO5 = 15,
	AXP15060_CLDO1 = 16,
	AXP15060_CLDO2 = 17,
	AXP15060_CLDO3 = 18,
	AXP15060_CLDO4 = 19,
	AXP15060_CPUSLDO = 20,
	AXP15060_SW = 21,
	AXP15060_RTC_LDO = 22,
	AXP15060_REG_ID_MAX = 23,
};

enum {
	AXP152_IRQ_LDO0IN_CONNECT = 1,
	AXP152_IRQ_LDO0IN_REMOVAL = 2,
	AXP152_IRQ_ALDO0IN_CONNECT = 3,
	AXP152_IRQ_ALDO0IN_REMOVAL = 4,
	AXP152_IRQ_DCDC1_V_LOW = 5,
	AXP152_IRQ_DCDC2_V_LOW = 6,
	AXP152_IRQ_DCDC3_V_LOW = 7,
	AXP152_IRQ_DCDC4_V_LOW = 8,
	AXP152_IRQ_PEK_SHORT = 9,
	AXP152_IRQ_PEK_LONG = 10,
	AXP152_IRQ_TIMER = 11,
	AXP152_IRQ_PEK_FAL_EDGE = 12,
	AXP152_IRQ_PEK_RIS_EDGE = 13,
	AXP152_IRQ_GPIO3_INPUT = 14,
	AXP152_IRQ_GPIO2_INPUT = 15,
	AXP152_IRQ_GPIO1_INPUT = 16,
	AXP152_IRQ_GPIO0_INPUT = 17,
};

enum {
	AXP20X_IRQ_ACIN_OVER_V = 1,
	AXP20X_IRQ_ACIN_PLUGIN = 2,
	AXP20X_IRQ_ACIN_REMOVAL = 3,
	AXP20X_IRQ_VBUS_OVER_V = 4,
	AXP20X_IRQ_VBUS_PLUGIN = 5,
	AXP20X_IRQ_VBUS_REMOVAL = 6,
	AXP20X_IRQ_VBUS_V_LOW = 7,
	AXP20X_IRQ_BATT_PLUGIN = 8,
	AXP20X_IRQ_BATT_REMOVAL = 9,
	AXP20X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP20X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP20X_IRQ_CHARG = 12,
	AXP20X_IRQ_CHARG_DONE = 13,
	AXP20X_IRQ_BATT_TEMP_HIGH = 14,
	AXP20X_IRQ_BATT_TEMP_LOW = 15,
	AXP20X_IRQ_DIE_TEMP_HIGH = 16,
	AXP20X_IRQ_CHARG_I_LOW = 17,
	AXP20X_IRQ_DCDC1_V_LONG = 18,
	AXP20X_IRQ_DCDC2_V_LONG = 19,
	AXP20X_IRQ_DCDC3_V_LONG = 20,
	AXP20X_IRQ_PEK_SHORT = 22,
	AXP20X_IRQ_PEK_LONG = 23,
	AXP20X_IRQ_N_OE_PWR_ON = 24,
	AXP20X_IRQ_N_OE_PWR_OFF = 25,
	AXP20X_IRQ_VBUS_VALID = 26,
	AXP20X_IRQ_VBUS_NOT_VALID = 27,
	AXP20X_IRQ_VBUS_SESS_VALID = 28,
	AXP20X_IRQ_VBUS_SESS_END = 29,
	AXP20X_IRQ_LOW_PWR_LVL1 = 30,
	AXP20X_IRQ_LOW_PWR_LVL2 = 31,
	AXP20X_IRQ_TIMER = 32,
	AXP20X_IRQ_PEK_FAL_EDGE = 33,
	AXP20X_IRQ_PEK_RIS_EDGE = 34,
	AXP20X_IRQ_GPIO3_INPUT = 35,
	AXP20X_IRQ_GPIO2_INPUT = 36,
	AXP20X_IRQ_GPIO1_INPUT = 37,
	AXP20X_IRQ_GPIO0_INPUT = 38,
};

enum {
	AXP20X_LDO1 = 0,
	AXP20X_LDO2 = 1,
	AXP20X_LDO3 = 2,
	AXP20X_LDO4 = 3,
	AXP20X_LDO5 = 4,
	AXP20X_DCDC2 = 5,
	AXP20X_DCDC3 = 6,
	AXP20X_REG_ID_MAX = 7,
};

enum {
	AXP22X_DCDC1 = 0,
	AXP22X_DCDC2 = 1,
	AXP22X_DCDC3 = 2,
	AXP22X_DCDC4 = 3,
	AXP22X_DCDC5 = 4,
	AXP22X_DC1SW = 5,
	AXP22X_DC5LDO = 6,
	AXP22X_ALDO1 = 7,
	AXP22X_ALDO2 = 8,
	AXP22X_ALDO3 = 9,
	AXP22X_ELDO1 = 10,
	AXP22X_ELDO2 = 11,
	AXP22X_ELDO3 = 12,
	AXP22X_DLDO1 = 13,
	AXP22X_DLDO2 = 14,
	AXP22X_DLDO3 = 15,
	AXP22X_DLDO4 = 16,
	AXP22X_RTC_LDO = 17,
	AXP22X_LDO_IO0 = 18,
	AXP22X_LDO_IO1 = 19,
	AXP22X_REG_ID_MAX = 20,
};

enum {
	AXP313A_DCDC1 = 0,
	AXP313A_DCDC2 = 1,
	AXP313A_DCDC3 = 2,
	AXP313A_ALDO1 = 3,
	AXP313A_DLDO1 = 4,
	AXP313A_RTC_LDO = 5,
	AXP313A_REG_ID_MAX = 6,
};

enum {
	AXP717_DCDC1 = 0,
	AXP717_DCDC2 = 1,
	AXP717_DCDC3 = 2,
	AXP717_DCDC4 = 3,
	AXP717_ALDO1 = 4,
	AXP717_ALDO2 = 5,
	AXP717_ALDO3 = 6,
	AXP717_ALDO4 = 7,
	AXP717_BLDO1 = 8,
	AXP717_BLDO2 = 9,
	AXP717_BLDO3 = 10,
	AXP717_BLDO4 = 11,
	AXP717_CLDO1 = 12,
	AXP717_CLDO2 = 13,
	AXP717_CLDO3 = 14,
	AXP717_CLDO4 = 15,
	AXP717_CPUSLDO = 16,
	AXP717_BOOST = 17,
	AXP717_REG_ID_MAX = 18,
};

enum {
	AXP803_DCDC1 = 0,
	AXP803_DCDC2 = 1,
	AXP803_DCDC3 = 2,
	AXP803_DCDC4 = 3,
	AXP803_DCDC5 = 4,
	AXP803_DCDC6 = 5,
	AXP803_DC1SW = 6,
	AXP803_ALDO1 = 7,
	AXP803_ALDO2 = 8,
	AXP803_ALDO3 = 9,
	AXP803_DLDO1 = 10,
	AXP803_DLDO2 = 11,
	AXP803_DLDO3 = 12,
	AXP803_DLDO4 = 13,
	AXP803_ELDO1 = 14,
	AXP803_ELDO2 = 15,
	AXP803_ELDO3 = 16,
	AXP803_FLDO1 = 17,
	AXP803_FLDO2 = 18,
	AXP803_RTC_LDO = 19,
	AXP803_LDO_IO0 = 20,
	AXP803_LDO_IO1 = 21,
	AXP803_REG_ID_MAX = 22,
};

enum {
	AXP806_DCDCA = 0,
	AXP806_DCDCB = 1,
	AXP806_DCDCC = 2,
	AXP806_DCDCD = 3,
	AXP806_DCDCE = 4,
	AXP806_ALDO1 = 5,
	AXP806_ALDO2 = 6,
	AXP806_ALDO3 = 7,
	AXP806_BLDO1 = 8,
	AXP806_BLDO2 = 9,
	AXP806_BLDO3 = 10,
	AXP806_BLDO4 = 11,
	AXP806_CLDO1 = 12,
	AXP806_CLDO2 = 13,
	AXP806_CLDO3 = 14,
	AXP806_SW = 15,
	AXP806_REG_ID_MAX = 16,
};

enum {
	AXP809_DCDC1 = 0,
	AXP809_DCDC2 = 1,
	AXP809_DCDC3 = 2,
	AXP809_DCDC4 = 3,
	AXP809_DCDC5 = 4,
	AXP809_DC1SW = 5,
	AXP809_DC5LDO = 6,
	AXP809_ALDO1 = 7,
	AXP809_ALDO2 = 8,
	AXP809_ALDO3 = 9,
	AXP809_ELDO1 = 10,
	AXP809_ELDO2 = 11,
	AXP809_ELDO3 = 12,
	AXP809_DLDO1 = 13,
	AXP809_DLDO2 = 14,
	AXP809_RTC_LDO = 15,
	AXP809_LDO_IO0 = 16,
	AXP809_LDO_IO1 = 17,
	AXP809_SW = 18,
	AXP809_REG_ID_MAX = 19,
};

enum {
	AXP813_DCDC1 = 0,
	AXP813_DCDC2 = 1,
	AXP813_DCDC3 = 2,
	AXP813_DCDC4 = 3,
	AXP813_DCDC5 = 4,
	AXP813_DCDC6 = 5,
	AXP813_DCDC7 = 6,
	AXP813_ALDO1 = 7,
	AXP813_ALDO2 = 8,
	AXP813_ALDO3 = 9,
	AXP813_DLDO1 = 10,
	AXP813_DLDO2 = 11,
	AXP813_DLDO3 = 12,
	AXP813_DLDO4 = 13,
	AXP813_ELDO1 = 14,
	AXP813_ELDO2 = 15,
	AXP813_ELDO3 = 16,
	AXP813_FLDO1 = 17,
	AXP813_FLDO2 = 18,
	AXP813_FLDO3 = 19,
	AXP813_RTC_LDO = 20,
	AXP813_LDO_IO0 = 21,
	AXP813_LDO_IO1 = 22,
	AXP813_SW = 23,
	AXP813_REG_ID_MAX = 24,
};

enum {
	Audit_equal = 0,
	Audit_not_equal = 1,
	Audit_bitmask = 2,
	Audit_bittest = 3,
	Audit_lt = 4,
	Audit_gt = 5,
	Audit_le = 6,
	Audit_ge = 7,
	Audit_bad = 8,
};

enum {
	BACKGROUND = 0,
	FOREGROUND = 1,
	MAX_CALL_TYPE = 2,
	TOTAL_CALL = 1,
};

enum {
	BAD_STACK = -1,
	NOT_STACK = 0,
	GOOD_FRAME = 1,
	GOOD_STACK = 2,
};

enum {
	BANDGAP_97_07 = 0,
	BANDGAP_98_05 = 1,
	BANDGAP_99_02 = 2,
	BANDGAP_100_00 = 3,
	BANDGAP_93_17 = 4,
	BANDGAP_94_15 = 5,
	BANDGAP_95_12 = 6,
	BANDGAP_96_10 = 7,
};

enum {
	BGGC_MODE_ON = 0,
	BGGC_MODE_OFF = 1,
	BGGC_MODE_SYNC = 2,
};

enum {
	BG_GC = 0,
	FG_GC = 1,
};

enum {
	BIAS = 2147483648,
};

enum {
	BIASEXTR_87_1 = 0,
	BIASEXTR_91_5 = 1,
	BIASEXTR_95_9 = 2,
	BIASEXTR_100 = 3,
	BIASEXTR_105_94 = 4,
	BIASEXTR_111_88 = 5,
	BIASEXTR_118_8 = 6,
	BIASEXTR_127_7 = 7,
};

enum {
	BIOSET_NEED_BVECS = 1,
	BIOSET_NEED_RESCUER = 2,
	BIOSET_PERCPU_CACHE = 4,
};

enum {
	BIO_PAGE_PINNED = 0,
	BIO_CLONED = 1,
	BIO_QUIET = 2,
	BIO_CHAIN = 3,
	BIO_REFFED = 4,
	BIO_BPS_THROTTLED = 5,
	BIO_TRACE_COMPLETION = 6,
	BIO_CGROUP_ACCT = 7,
	BIO_QOS_THROTTLED = 8,
	BIO_TG_BPS_THROTTLED = 8,
	BIO_QOS_MERGED = 9,
	BIO_REMAPPED = 10,
	BIO_ZONE_WRITE_PLUGGING = 11,
	BIO_EMULATES_ZONE_APPEND = 12,
	BIO_FLAG_LAST = 13,
};

enum {
	BLK_MQ_F_TAG_QUEUE_SHARED = 2,
	BLK_MQ_F_STACKING = 4,
	BLK_MQ_F_TAG_HCTX_SHARED = 8,
	BLK_MQ_F_BLOCKING = 16,
	BLK_MQ_F_TAG_RR = 32,
	BLK_MQ_F_NO_SCHED_BY_DEFAULT = 64,
	BLK_MQ_F_MAX = 128,
};

enum {
	BLK_MQ_NO_TAG = 4294967295,
	BLK_MQ_TAG_MIN = 1,
	BLK_MQ_TAG_MAX = 4294967294,
};

enum {
	BLK_MQ_REQ_NOWAIT = 1,
	BLK_MQ_REQ_RESERVED = 2,
	BLK_MQ_REQ_PM = 4,
};

enum {
	BLK_MQ_S_STOPPED = 0,
	BLK_MQ_S_TAG_ACTIVE = 1,
	BLK_MQ_S_SCHED_RESTART = 2,
	BLK_MQ_S_INACTIVE = 3,
	BLK_MQ_S_MAX = 4,
};

enum {
	BLK_MQ_UNIQUE_TAG_BITS = 16,
	BLK_MQ_UNIQUE_TAG_MASK = 65535,
};

enum {
	BLOCK_BITMAP = 0,
	INODE_BITMAP = 1,
	INODE_TABLE = 2,
	GROUP_TABLE_COUNT = 3,
};

enum {
	BOOST_ILMIN_75MA = 0,
	BOOST_ILMIN_100MA = 1,
	BOOST_ILMIN_125MA = 2,
	BOOST_ILMIN_150MA = 3,
	BOOST_ILMIN_175MA = 4,
	BOOST_ILMIN_200MA = 5,
	BOOST_ILMIN_225MA = 6,
	BOOST_ILMIN_250MA = 7,
};

enum {
	BPF_ADJ_ROOM_ENCAP_L2_MASK = 255,
	BPF_ADJ_ROOM_ENCAP_L2_SHIFT = 56,
};

enum {
	BPF_ANY = 0,
	BPF_NOEXIST = 1,
	BPF_EXIST = 2,
	BPF_F_LOCK = 4,
};

enum {
	BPF_CSUM_LEVEL_QUERY = 0,
	BPF_CSUM_LEVEL_INC = 1,
	BPF_CSUM_LEVEL_DEC = 2,
	BPF_CSUM_LEVEL_RESET = 3,
};

enum {
	BPF_FIB_LKUP_RET_SUCCESS = 0,
	BPF_FIB_LKUP_RET_BLACKHOLE = 1,
	BPF_FIB_LKUP_RET_UNREACHABLE = 2,
	BPF_FIB_LKUP_RET_PROHIBIT = 3,
	BPF_FIB_LKUP_RET_NOT_FWDED = 4,
	BPF_FIB_LKUP_RET_FWD_DISABLED = 5,
	BPF_FIB_LKUP_RET_UNSUPP_LWT = 6,
	BPF_FIB_LKUP_RET_NO_NEIGH = 7,
	BPF_FIB_LKUP_RET_FRAG_NEEDED = 8,
	BPF_FIB_LKUP_RET_NO_SRC_ADDR = 9,
};

enum {
	BPF_FIB_LOOKUP_DIRECT = 1,
	BPF_FIB_LOOKUP_OUTPUT = 2,
	BPF_FIB_LOOKUP_SKIP_NEIGH = 4,
	BPF_FIB_LOOKUP_TBID = 8,
	BPF_FIB_LOOKUP_SRC = 16,
	BPF_FIB_LOOKUP_MARK = 32,
};

enum {
	BPF_FLOW_DISSECTOR_F_PARSE_1ST_FRAG = 1,
	BPF_FLOW_DISSECTOR_F_STOP_AT_FLOW_LABEL = 2,
	BPF_FLOW_DISSECTOR_F_STOP_AT_ENCAP = 4,
};

enum {
	BPF_F_ADJ_ROOM_FIXED_GSO = 1,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV4 = 2,
	BPF_F_ADJ_ROOM_ENCAP_L3_IPV6 = 4,
	BPF_F_ADJ_ROOM_ENCAP_L4_GRE = 8,
	BPF_F_ADJ_ROOM_ENCAP_L4_UDP = 16,
	BPF_F_ADJ_ROOM_NO_CSUM_RESET = 32,
	BPF_F_ADJ_ROOM_ENCAP_L2_ETH = 64,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV4 = 128,
	BPF_F_ADJ_ROOM_DECAP_L3_IPV6 = 256,
};

enum {
	BPF_F_CURRENT_NETNS = -1,
};

enum {
	BPF_F_HDR_FIELD_MASK = 15,
};

enum {
	BPF_F_INDEX_MASK = 4294967295ULL,
	BPF_F_CURRENT_CPU = 4294967295ULL,
	BPF_F_CTXLEN_MASK = 4503595332403200ULL,
};

enum {
	BPF_F_INGRESS = 1,
	BPF_F_BROADCAST = 8,
	BPF_F_EXCLUDE_INGRESS = 16,
};

enum {
	BPF_F_NEIGH = 65536,
	BPF_F_PEER = 131072,
	BPF_F_NEXTHOP = 262144,
};

enum {
	BPF_F_NO_PREALLOC = 1,
	BPF_F_NO_COMMON_LRU = 2,
	BPF_F_NUMA_NODE = 4,
	BPF_F_RDONLY = 8,
	BPF_F_WRONLY = 16,
	BPF_F_STACK_BUILD_ID = 32,
	BPF_F_ZERO_SEED = 64,
	BPF_F_RDONLY_PROG = 128,
	BPF_F_WRONLY_PROG = 256,
	BPF_F_CLONE = 512,
	BPF_F_MMAPABLE = 1024,
	BPF_F_PRESERVE_ELEMS = 2048,
	BPF_F_INNER_MAP = 4096,
	BPF_F_LINK = 8192,
	BPF_F_PATH_FD = 16384,
	BPF_F_VTYPE_BTF_OBJ_FD = 32768,
	BPF_F_TOKEN_FD = 65536,
	BPF_F_SEGV_ON_FAULT = 131072,
	BPF_F_NO_USER_CONV = 262144,
};

enum {
	BPF_F_PSEUDO_HDR = 16,
	BPF_F_MARK_MANGLED_0 = 32,
	BPF_F_MARK_ENFORCE = 64,
	BPF_F_IPV6 = 128,
};

enum {
	BPF_F_RECOMPUTE_CSUM = 1,
	BPF_F_INVALIDATE_HASH = 2,
};

enum {
	BPF_F_SKIP_FIELD_MASK = 255,
	BPF_F_USER_STACK = 256,
	BPF_F_FAST_STACK_CMP = 512,
	BPF_F_REUSE_STACKID = 1024,
	BPF_F_USER_BUILD_ID = 2048,
};

enum {
	BPF_F_SYSCTL_BASE_NAME = 1,
};

enum {
	BPF_F_TIMER_ABS = 1,
	BPF_F_TIMER_CPU_PIN = 2,
};

enum {
	BPF_F_TUNINFO_FLAGS = 16,
};

enum {
	BPF_F_TUNINFO_IPV6 = 1,
};

enum {
	BPF_F_ZERO_CSUM_TX = 2,
	BPF_F_DONT_FRAGMENT = 4,
	BPF_F_SEQ_NUMBER = 8,
	BPF_F_NO_TUNNEL_KEY = 16,
};

enum {
	BPF_LOAD_HDR_OPT_TCP_SYN = 1,
};

enum {
	BPF_LOCAL_STORAGE_GET_F_CREATE = 1,
	BPF_SK_STORAGE_GET_F_CREATE = 1,
};

enum {
	BPF_MAX_LOOPS = 8388608,
	BPF_MAX_TIMED_LOOPS = 65535,
};

enum {
	BPF_MAX_TRAMP_LINKS = 38,
};

enum {
	BPF_R2_HI = 0,
	BPF_R2_LO = 1,
	BPF_R3_HI = 2,
	BPF_R3_LO = 3,
	BPF_R4_HI = 4,
	BPF_R4_LO = 5,
	BPF_R5_HI = 6,
	BPF_R5_LO = 7,
	BPF_R7_HI = 8,
	BPF_R7_LO = 9,
	BPF_R8_HI = 10,
	BPF_R8_LO = 11,
	BPF_R9_HI = 12,
	BPF_R9_LO = 13,
	BPF_FP_HI = 14,
	BPF_FP_LO = 15,
	BPF_TC_HI = 16,
	BPF_TC_LO = 17,
	BPF_AX_HI = 18,
	BPF_AX_LO = 19,
	BPF_JIT_SCRATCH_REGS = 20,
};

enum {
	BPF_RB_AVAIL_DATA = 0,
	BPF_RB_RING_SIZE = 1,
	BPF_RB_CONS_POS = 2,
	BPF_RB_PROD_POS = 3,
};

enum {
	BPF_RB_NO_WAKEUP = 1,
	BPF_RB_FORCE_WAKEUP = 2,
};

enum {
	BPF_REG_0 = 0,
	BPF_REG_1 = 1,
	BPF_REG_2 = 2,
	BPF_REG_3 = 3,
	BPF_REG_4 = 4,
	BPF_REG_5 = 5,
	BPF_REG_6 = 6,
	BPF_REG_7 = 7,
	BPF_REG_8 = 8,
	BPF_REG_9 = 9,
	BPF_REG_10 = 10,
	__MAX_BPF_REG = 11,
};

enum {
	BPF_RINGBUF_BUSY_BIT = 2147483648,
	BPF_RINGBUF_DISCARD_BIT = 1073741824,
	BPF_RINGBUF_HDR_SZ = 8,
};

enum {
	BPF_SKB_TSTAMP_UNSPEC = 0,
	BPF_SKB_TSTAMP_DELIVERY_MONO = 1,
	BPF_SKB_CLOCK_REALTIME = 0,
	BPF_SKB_CLOCK_MONOTONIC = 1,
	BPF_SKB_CLOCK_TAI = 2,
};

enum {
	BPF_SK_LOOKUP_F_REPLACE = 1,
	BPF_SK_LOOKUP_F_NO_REUSEPORT = 2,
};

enum {
	BPF_SOCK_OPS_RTO_CB_FLAG = 1,
	BPF_SOCK_OPS_RETRANS_CB_FLAG = 2,
	BPF_SOCK_OPS_STATE_CB_FLAG = 4,
	BPF_SOCK_OPS_RTT_CB_FLAG = 8,
	BPF_SOCK_OPS_PARSE_ALL_HDR_OPT_CB_FLAG = 16,
	BPF_SOCK_OPS_PARSE_UNKNOWN_HDR_OPT_CB_FLAG = 32,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB_FLAG = 64,
	BPF_SOCK_OPS_ALL_CB_FLAGS = 127,
};

enum {
	BPF_SOCK_OPS_VOID = 0,
	BPF_SOCK_OPS_TIMEOUT_INIT = 1,
	BPF_SOCK_OPS_RWND_INIT = 2,
	BPF_SOCK_OPS_TCP_CONNECT_CB = 3,
	BPF_SOCK_OPS_ACTIVE_ESTABLISHED_CB = 4,
	BPF_SOCK_OPS_PASSIVE_ESTABLISHED_CB = 5,
	BPF_SOCK_OPS_NEEDS_ECN = 6,
	BPF_SOCK_OPS_BASE_RTT = 7,
	BPF_SOCK_OPS_RTO_CB = 8,
	BPF_SOCK_OPS_RETRANS_CB = 9,
	BPF_SOCK_OPS_STATE_CB = 10,
	BPF_SOCK_OPS_TCP_LISTEN_CB = 11,
	BPF_SOCK_OPS_RTT_CB = 12,
	BPF_SOCK_OPS_PARSE_HDR_OPT_CB = 13,
	BPF_SOCK_OPS_HDR_OPT_LEN_CB = 14,
	BPF_SOCK_OPS_WRITE_HDR_OPT_CB = 15,
	BPF_SOCK_OPS_TSTAMP_SCHED_CB = 16,
	BPF_SOCK_OPS_TSTAMP_SND_SW_CB = 17,
	BPF_SOCK_OPS_TSTAMP_SND_HW_CB = 18,
	BPF_SOCK_OPS_TSTAMP_ACK_CB = 19,
	BPF_SOCK_OPS_TSTAMP_SENDMSG_CB = 20,
};

enum {
	BPF_TASK_ITER_ALL_PROCS = 0,
	BPF_TASK_ITER_ALL_THREADS = 1,
	BPF_TASK_ITER_PROC_THREADS = 2,
};

enum {
	BPF_TCP_ESTABLISHED = 1,
	BPF_TCP_SYN_SENT = 2,
	BPF_TCP_SYN_RECV = 3,
	BPF_TCP_FIN_WAIT1 = 4,
	BPF_TCP_FIN_WAIT2 = 5,
	BPF_TCP_TIME_WAIT = 6,
	BPF_TCP_CLOSE = 7,
	BPF_TCP_CLOSE_WAIT = 8,
	BPF_TCP_LAST_ACK = 9,
	BPF_TCP_LISTEN = 10,
	BPF_TCP_CLOSING = 11,
	BPF_TCP_NEW_SYN_RECV = 12,
	BPF_TCP_BOUND_INACTIVE = 13,
	BPF_TCP_MAX_STATES = 14,
};

enum {
	BPF_WRITE_HDR_TCP_CURRENT_MSS = 1,
	BPF_WRITE_HDR_TCP_SYNACK_COOKIE = 2,
};

enum {
	BPF_XFRM_STATE_OPTS_SZ = 36,
};

enum {
	BR_MCAST_DIR_RX = 0,
	BR_MCAST_DIR_TX = 1,
	BR_MCAST_DIR_SIZE = 2,
};

enum {
	BTF_FIELDS_MAX = 11,
};

enum {
	BTF_FIELD_IGNORE = 0,
	BTF_FIELD_FOUND = 1,
};

enum {
	BTF_F_COMPACT = 1,
	BTF_F_NONAME = 2,
	BTF_F_PTR_RAW = 4,
	BTF_F_ZERO = 8,
};

enum {
	BTF_KFUNC_SET_MAX_CNT = 256,
	BTF_DTOR_KFUNC_MAX_CNT = 256,
	BTF_KFUNC_FILTER_MAX_CNT = 16,
};

enum {
	BTF_KIND_UNKN = 0,
	BTF_KIND_INT = 1,
	BTF_KIND_PTR = 2,
	BTF_KIND_ARRAY = 3,
	BTF_KIND_STRUCT = 4,
	BTF_KIND_UNION = 5,
	BTF_KIND_ENUM = 6,
	BTF_KIND_FWD = 7,
	BTF_KIND_TYPEDEF = 8,
	BTF_KIND_VOLATILE = 9,
	BTF_KIND_CONST = 10,
	BTF_KIND_RESTRICT = 11,
	BTF_KIND_FUNC = 12,
	BTF_KIND_FUNC_PROTO = 13,
	BTF_KIND_VAR = 14,
	BTF_KIND_DATASEC = 15,
	BTF_KIND_FLOAT = 16,
	BTF_KIND_DECL_TAG = 17,
	BTF_KIND_TYPE_TAG = 18,
	BTF_KIND_ENUM64 = 19,
	NR_BTF_KINDS = 20,
	BTF_KIND_MAX = 19,
};

enum {
	BTF_MODULE_F_LIVE = 1,
};

enum {
	BTF_SOCK_TYPE_INET = 0,
	BTF_SOCK_TYPE_INET_CONN = 1,
	BTF_SOCK_TYPE_INET_REQ = 2,
	BTF_SOCK_TYPE_INET_TW = 3,
	BTF_SOCK_TYPE_REQ = 4,
	BTF_SOCK_TYPE_SOCK = 5,
	BTF_SOCK_TYPE_SOCK_COMMON = 6,
	BTF_SOCK_TYPE_TCP = 7,
	BTF_SOCK_TYPE_TCP_REQ = 8,
	BTF_SOCK_TYPE_TCP_TW = 9,
	BTF_SOCK_TYPE_TCP6 = 10,
	BTF_SOCK_TYPE_UDP = 11,
	BTF_SOCK_TYPE_UDP6 = 12,
	BTF_SOCK_TYPE_UNIX = 13,
	BTF_SOCK_TYPE_MPTCP = 14,
	BTF_SOCK_TYPE_SOCKET = 15,
	MAX_BTF_SOCK_TYPE = 16,
};

enum {
	BTF_TRACING_TYPE_TASK = 0,
	BTF_TRACING_TYPE_FILE = 1,
	BTF_TRACING_TYPE_VMA = 2,
	MAX_BTF_TRACING_TYPE = 3,
};

enum {
	BTF_VAR_STATIC = 0,
	BTF_VAR_GLOBAL_ALLOCATED = 1,
	BTF_VAR_GLOBAL_EXTERN = 2,
};

enum {
	BTRFS_FILE_EXTENT_INLINE = 0,
	BTRFS_FILE_EXTENT_REG = 1,
	BTRFS_FILE_EXTENT_PREALLOC = 2,
	BTRFS_NR_FILE_EXTENT_TYPES = 3,
};

enum {
	BTRFS_FS_CLOSING_START = 0,
	BTRFS_FS_CLOSING_DONE = 1,
	BTRFS_FS_LOG_RECOVERING = 2,
	BTRFS_FS_OPEN = 3,
	BTRFS_FS_QUOTA_ENABLED = 4,
	BTRFS_FS_UPDATE_UUID_TREE_GEN = 5,
	BTRFS_FS_CREATING_FREE_SPACE_TREE = 6,
	BTRFS_FS_BTREE_ERR = 7,
	BTRFS_FS_LOG1_ERR = 8,
	BTRFS_FS_LOG2_ERR = 9,
	BTRFS_FS_QUOTA_OVERRIDE = 10,
	BTRFS_FS_FROZEN = 11,
	BTRFS_FS_BALANCE_RUNNING = 12,
	BTRFS_FS_RELOC_RUNNING = 13,
	BTRFS_FS_CLEANER_RUNNING = 14,
	BTRFS_FS_CSUM_IMPL_FAST = 15,
	BTRFS_FS_DISCARD_RUNNING = 16,
	BTRFS_FS_CLEANUP_SPACE_CACHE_V1 = 17,
	BTRFS_FS_FREE_SPACE_TREE_UNTRUSTED = 18,
	BTRFS_FS_TREE_MOD_LOG_USERS = 19,
	BTRFS_FS_COMMIT_TRANS = 20,
	BTRFS_FS_UNFINISHED_DROPS = 21,
	BTRFS_FS_NEED_ZONE_FINISH = 22,
	BTRFS_FS_NEED_TRANS_COMMIT = 23,
	BTRFS_FS_ACTIVE_ZONE_TRACKING = 24,
	BTRFS_FS_FEATURE_CHANGED = 25,
	BTRFS_FS_UNALIGNED_TREE_BLOCK = 26,
	BTRFS_FS_32BIT_ERROR = 27,
	BTRFS_FS_32BIT_WARN = 28,
};

enum {
	BTRFS_FS_STATE_REMOUNTING = 0,
	BTRFS_FS_STATE_RO = 1,
	BTRFS_FS_STATE_TRANS_ABORTED = 2,
	BTRFS_FS_STATE_DEV_REPLACING = 3,
	BTRFS_FS_STATE_DUMMY_FS_INFO = 4,
	BTRFS_FS_STATE_NO_DATA_CSUMS = 5,
	BTRFS_FS_STATE_SKIP_META_CSUMS = 6,
	BTRFS_FS_STATE_LOG_CLEANUP_ERROR = 7,
	BTRFS_FS_STATE_NO_DELAYED_IPUT = 8,
	BTRFS_FS_STATE_COUNT = 9,
};

enum {
	BTRFS_INODE_FLUSH_ON_CLOSE = 0,
	BTRFS_INODE_DUMMY = 1,
	BTRFS_INODE_IN_DEFRAG = 2,
	BTRFS_INODE_HAS_ASYNC_EXTENT = 3,
	BTRFS_INODE_NEEDS_FULL_SYNC = 4,
	BTRFS_INODE_COPY_EVERYTHING = 5,
	BTRFS_INODE_HAS_PROPS = 6,
	BTRFS_INODE_SNAPSHOT_FLUSH = 7,
	BTRFS_INODE_NO_XATTRS = 8,
	BTRFS_INODE_NO_DELALLOC_FLUSH = 9,
	BTRFS_INODE_VERITY_IN_PROGRESS = 10,
	BTRFS_INODE_FREE_SPACE_INODE = 11,
	BTRFS_INODE_NO_CAP_XATTR = 12,
	BTRFS_INODE_COW_WRITE_ERROR = 13,
	BTRFS_INODE_ROOT_STUB = 14,
};

enum {
	BTRFS_MOUNT_NODATASUM = 1ULL,
	BTRFS_MOUNT_NODATACOW = 2ULL,
	BTRFS_MOUNT_NOBARRIER = 4ULL,
	BTRFS_MOUNT_SSD = 8ULL,
	BTRFS_MOUNT_DEGRADED = 16ULL,
	BTRFS_MOUNT_COMPRESS = 32ULL,
	BTRFS_MOUNT_NOTREELOG = 64ULL,
	BTRFS_MOUNT_FLUSHONCOMMIT = 128ULL,
	BTRFS_MOUNT_SSD_SPREAD = 256ULL,
	BTRFS_MOUNT_NOSSD = 512ULL,
	BTRFS_MOUNT_DISCARD_SYNC = 1024ULL,
	BTRFS_MOUNT_FORCE_COMPRESS = 2048ULL,
	BTRFS_MOUNT_SPACE_CACHE = 4096ULL,
	BTRFS_MOUNT_CLEAR_CACHE = 8192ULL,
	BTRFS_MOUNT_USER_SUBVOL_RM_ALLOWED = 16384ULL,
	BTRFS_MOUNT_ENOSPC_DEBUG = 32768ULL,
	BTRFS_MOUNT_AUTO_DEFRAG = 65536ULL,
	BTRFS_MOUNT_USEBACKUPROOT = 131072ULL,
	BTRFS_MOUNT_SKIP_BALANCE = 262144ULL,
	BTRFS_MOUNT_PANIC_ON_FATAL_ERROR = 524288ULL,
	BTRFS_MOUNT_RESCAN_UUID_TREE = 1048576ULL,
	BTRFS_MOUNT_FRAGMENT_DATA = 2097152ULL,
	BTRFS_MOUNT_FRAGMENT_METADATA = 4194304ULL,
	BTRFS_MOUNT_FREE_SPACE_TREE = 8388608ULL,
	BTRFS_MOUNT_NOLOGREPLAY = 16777216ULL,
	BTRFS_MOUNT_REF_VERIFY = 33554432ULL,
	BTRFS_MOUNT_DISCARD_ASYNC = 67108864ULL,
	BTRFS_MOUNT_IGNOREBADROOTS = 134217728ULL,
	BTRFS_MOUNT_IGNOREDATACSUMS = 268435456ULL,
	BTRFS_MOUNT_NODISCARD = 536870912ULL,
	BTRFS_MOUNT_NOSPACECACHE = 1073741824ULL,
	BTRFS_MOUNT_IGNOREMETACSUMS = 2147483648ULL,
	BTRFS_MOUNT_IGNORESUPERFLAGS = 4294967296ULL,
};

enum {
	BTRFS_ORDERED_REGULAR = 0,
	BTRFS_ORDERED_NOCOW = 1,
	BTRFS_ORDERED_PREALLOC = 2,
	BTRFS_ORDERED_COMPRESSED = 3,
	BTRFS_ORDERED_DIRECT = 4,
	BTRFS_ORDERED_IO_DONE = 5,
	BTRFS_ORDERED_COMPLETE = 6,
	BTRFS_ORDERED_IOERR = 7,
	BTRFS_ORDERED_TRUNCATED = 8,
	BTRFS_ORDERED_LOGGED = 9,
	BTRFS_ORDERED_LOGGED_CSUM = 10,
	BTRFS_ORDERED_PENDING = 11,
	BTRFS_ORDERED_ENCODED = 12,
};

enum {
	BTRFS_ROOT_IN_TRANS_SETUP = 0,
	BTRFS_ROOT_SHAREABLE = 1,
	BTRFS_ROOT_TRACK_DIRTY = 2,
	BTRFS_ROOT_IN_RADIX = 3,
	BTRFS_ROOT_ORPHAN_ITEM_INSERTED = 4,
	BTRFS_ROOT_DEFRAG_RUNNING = 5,
	BTRFS_ROOT_FORCE_COW = 6,
	BTRFS_ROOT_MULTI_LOG_TASKS = 7,
	BTRFS_ROOT_DIRTY = 8,
	BTRFS_ROOT_DELETING = 9,
	BTRFS_ROOT_DEAD_RELOC_TREE = 10,
	BTRFS_ROOT_DEAD_TREE = 11,
	BTRFS_ROOT_HAS_LOG_TREE = 12,
	BTRFS_ROOT_QGROUP_FLUSHING = 13,
	BTRFS_ROOT_ORPHAN_CLEANUP = 14,
	BTRFS_ROOT_UNFINISHED_DROP = 15,
	BTRFS_ROOT_RESET_LOCKDEP_CLASS = 16,
};

enum {
	BTRFS_SEND_A_UNSPEC = 0,
	BTRFS_SEND_A_UUID = 1,
	BTRFS_SEND_A_CTRANSID = 2,
	BTRFS_SEND_A_INO = 3,
	BTRFS_SEND_A_SIZE = 4,
	BTRFS_SEND_A_MODE = 5,
	BTRFS_SEND_A_UID = 6,
	BTRFS_SEND_A_GID = 7,
	BTRFS_SEND_A_RDEV = 8,
	BTRFS_SEND_A_CTIME = 9,
	BTRFS_SEND_A_MTIME = 10,
	BTRFS_SEND_A_ATIME = 11,
	BTRFS_SEND_A_OTIME = 12,
	BTRFS_SEND_A_XATTR_NAME = 13,
	BTRFS_SEND_A_XATTR_DATA = 14,
	BTRFS_SEND_A_PATH = 15,
	BTRFS_SEND_A_PATH_TO = 16,
	BTRFS_SEND_A_PATH_LINK = 17,
	BTRFS_SEND_A_FILE_OFFSET = 18,
	BTRFS_SEND_A_DATA = 19,
	BTRFS_SEND_A_CLONE_UUID = 20,
	BTRFS_SEND_A_CLONE_CTRANSID = 21,
	BTRFS_SEND_A_CLONE_PATH = 22,
	BTRFS_SEND_A_CLONE_OFFSET = 23,
	BTRFS_SEND_A_CLONE_LEN = 24,
	BTRFS_SEND_A_MAX_V1 = 24,
	BTRFS_SEND_A_FALLOCATE_MODE = 25,
	BTRFS_SEND_A_FILEATTR = 26,
	BTRFS_SEND_A_UNENCODED_FILE_LEN = 27,
	BTRFS_SEND_A_UNENCODED_LEN = 28,
	BTRFS_SEND_A_UNENCODED_OFFSET = 29,
	BTRFS_SEND_A_COMPRESSION = 30,
	BTRFS_SEND_A_ENCRYPTION = 31,
	BTRFS_SEND_A_MAX_V2 = 31,
	BTRFS_SEND_A_VERITY_ALGORITHM = 32,
	BTRFS_SEND_A_VERITY_BLOCK_SIZE = 33,
	BTRFS_SEND_A_VERITY_SALT_DATA = 34,
	BTRFS_SEND_A_VERITY_SIG_DATA = 35,
	BTRFS_SEND_A_MAX_V3 = 35,
	__BTRFS_SEND_A_MAX = 35,
};

enum {
	BTRFS_STAT_CURR = 0,
	BTRFS_STAT_PREV = 1,
	BTRFS_STAT_NR_ENTRIES = 2,
};

enum {
	BUCK_ILMIN_50MA = 0,
	BUCK_ILMIN_100MA = 1,
	BUCK_ILMIN_150MA = 2,
	BUCK_ILMIN_200MA = 3,
	BUCK_ILMIN_250MA = 4,
	BUCK_ILMIN_300MA = 5,
	BUCK_ILMIN_350MA = 6,
	BUCK_ILMIN_400MA = 7,
};

enum {
	BUCK_MODE_MANUAL = 0,
	BUCK_MODE_SLEEP = 1,
	BUCK_MODE_SYNC = 2,
	BUCK_MODE_AUTO = 3,
};

enum {
	C0_C2_CHANGE_ENABLE = 0,
	C0_C2_CHANGE_DISABLE = 1,
	AUTO_CSC_DISABLE = 0,
	AUTO_CSC_ENABLE = 1,
};

enum {
	C0_G_Y = 0,
	C1_B_Cb = 1,
	C2_R_Cr = 2,
	C3_ALPHA = 3,
};

enum {
	CACHE_VALID = 0,
	CACHE_NEGATIVE = 1,
	CACHE_PENDING = 2,
	CACHE_CLEANED = 3,
};

enum {
	CAPS_0_SUPPORT_LL123 = 1048576,
	CAPS_0_SUPPORT_LL4 = 2097152,
	CCR_FS = 32,
	CCR_READ_PRIORITY = 64,
	CCR_ENABLE = 128,
	CCR_AUTO_INIT = 256,
	CCR_REPEAT = 512,
	CCR_OMAP31_DISABLE = 1024,
	CCR_SUSPEND_SENSITIVE = 256,
	CCR_RD_ACTIVE = 512,
	CCR_WR_ACTIVE = 1024,
	CCR_SRC_AMODE_CONSTANT = 0,
	CCR_SRC_AMODE_POSTINC = 4096,
	CCR_SRC_AMODE_SGLIDX = 8192,
	CCR_SRC_AMODE_DBLIDX = 12288,
	CCR_DST_AMODE_CONSTANT = 0,
	CCR_DST_AMODE_POSTINC = 16384,
	CCR_DST_AMODE_SGLIDX = 32768,
	CCR_DST_AMODE_DBLIDX = 49152,
	CCR_CONSTANT_FILL = 65536,
	CCR_TRANSPARENT_COPY = 131072,
	CCR_BS = 262144,
	CCR_SUPERVISOR = 4194304,
	CCR_PREFETCH = 8388608,
	CCR_TRIGGER_SRC = 16777216,
	CCR_BUFFERING_DISABLE = 33554432,
	CCR_WRITE_PRIORITY = 67108864,
	CCR_SYNC_ELEMENT = 0,
	CCR_SYNC_FRAME = 32,
	CCR_SYNC_BLOCK = 262144,
	CCR_SYNC_PACKET = 262176,
	CSDP_DATA_TYPE_8 = 0,
	CSDP_DATA_TYPE_16 = 1,
	CSDP_DATA_TYPE_32 = 2,
	CSDP_SRC_PORT_EMIFF = 0,
	CSDP_SRC_PORT_EMIFS = 4,
	CSDP_SRC_PORT_OCP_T1 = 8,
	CSDP_SRC_PORT_TIPB = 12,
	CSDP_SRC_PORT_OCP_T2 = 16,
	CSDP_SRC_PORT_MPUI = 20,
	CSDP_SRC_PACKED = 64,
	CSDP_SRC_BURST_1 = 0,
	CSDP_SRC_BURST_16 = 128,
	CSDP_SRC_BURST_32 = 256,
	CSDP_SRC_BURST_64 = 384,
	CSDP_DST_PORT_EMIFF = 0,
	CSDP_DST_PORT_EMIFS = 512,
	CSDP_DST_PORT_OCP_T1 = 1024,
	CSDP_DST_PORT_TIPB = 1536,
	CSDP_DST_PORT_OCP_T2 = 2048,
	CSDP_DST_PORT_MPUI = 2560,
	CSDP_DST_PACKED = 8192,
	CSDP_DST_BURST_1 = 0,
	CSDP_DST_BURST_16 = 16384,
	CSDP_DST_BURST_32 = 32768,
	CSDP_DST_BURST_64 = 49152,
	CSDP_WRITE_NON_POSTED = 0,
	CSDP_WRITE_POSTED = 65536,
	CSDP_WRITE_LAST_NON_POSTED = 131072,
	CICR_TOUT_IE = 1,
	CICR_DROP_IE = 2,
	CICR_HALF_IE = 4,
	CICR_FRAME_IE = 8,
	CICR_LAST_IE = 16,
	CICR_BLOCK_IE = 32,
	CICR_PKT_IE = 128,
	CICR_TRANS_ERR_IE = 256,
	CICR_SUPERVISOR_ERR_IE = 1024,
	CICR_MISALIGNED_ERR_IE = 2048,
	CICR_DRAIN_IE = 4096,
	CICR_SUPER_BLOCK_IE = 16384,
	CLNK_CTRL_ENABLE_LNK = 32768,
	CDP_DST_VALID_INC = 0,
	CDP_DST_VALID_RELOAD = 1,
	CDP_DST_VALID_REUSE = 2,
	CDP_SRC_VALID_INC = 0,
	CDP_SRC_VALID_RELOAD = 4,
	CDP_SRC_VALID_REUSE = 8,
	CDP_NTYPE_TYPE1 = 16,
	CDP_NTYPE_TYPE2 = 32,
	CDP_NTYPE_TYPE3 = 48,
	CDP_TMODE_NORMAL = 0,
	CDP_TMODE_LLIST = 256,
	CDP_FAST = 1024,
};

enum {
	CCI_IF_SLAVE = 0,
	CCI_IF_MASTER = 1,
	CCI_IF_MAX = 2,
};

enum {
	CFTYPE_ONLY_ON_ROOT = 1,
	CFTYPE_NOT_ON_ROOT = 2,
	CFTYPE_NS_DELEGATABLE = 4,
	CFTYPE_NO_PREFIX = 8,
	CFTYPE_WORLD_WRITABLE = 16,
	CFTYPE_DEBUG = 32,
	__CFTYPE_ONLY_ON_DFL = 65536,
	__CFTYPE_NOT_ON_DFL = 131072,
	__CFTYPE_ADDED = 262144,
};

enum {
	CGROUPSTATS_CMD_ATTR_UNSPEC = 0,
	CGROUPSTATS_CMD_ATTR_FD = 1,
	__CGROUPSTATS_CMD_ATTR_MAX = 2,
};

enum {
	CGROUPSTATS_CMD_UNSPEC = 3,
	CGROUPSTATS_CMD_GET = 4,
	CGROUPSTATS_CMD_NEW = 5,
	__CGROUPSTATS_CMD_MAX = 6,
};

enum {
	CGROUPSTATS_TYPE_UNSPEC = 0,
	CGROUPSTATS_TYPE_CGROUP_STATS = 1,
	__CGROUPSTATS_TYPE_MAX = 2,
};

enum {
	CGRP_NOTIFY_ON_RELEASE = 0,
	CGRP_CPUSET_CLONE_CHILDREN = 1,
	CGRP_FREEZE = 2,
	CGRP_FROZEN = 3,
};

enum {
	CGRP_ROOT_NOPREFIX = 2,
	CGRP_ROOT_XATTR = 4,
	CGRP_ROOT_NS_DELEGATE = 8,
	CGRP_ROOT_FAVOR_DYNMODS = 16,
	CGRP_ROOT_CPUSET_V2_MODE = 65536,
	CGRP_ROOT_MEMORY_LOCAL_EVENTS = 131072,
	CGRP_ROOT_MEMORY_RECURSIVE_PROT = 262144,
	CGRP_ROOT_MEMORY_HUGETLB_ACCOUNTING = 524288,
	CGRP_ROOT_PIDS_LOCAL_EVENTS = 1048576,
};

enum {
	CLK_COMPONENT_TYPE_GATE = 0,
	CLK_COMPONENT_TYPE_DIVIDER = 1,
	CLK_COMPONENT_TYPE_MUX = 2,
	CLK_COMPONENT_TYPE_MAX = 3,
};

enum {
	CMD_PIPE_ID = 1,
	STATUS_PIPE_ID = 2,
	DATA_IN_PIPE_ID = 3,
	DATA_OUT_PIPE_ID = 4,
	UAS_SIMPLE_TAG = 0,
	UAS_HEAD_TAG = 1,
	UAS_ORDERED_TAG = 2,
	UAS_ACA = 4,
};

enum {
	CMIS_MODULE_LOW_PWR = 1,
	CMIS_MODULE_READY = 3,
};

enum {
	COHERENCY_FABRIC_TYPE_NONE = 0,
	COHERENCY_FABRIC_TYPE_ARMADA_370_XP = 1,
	COHERENCY_FABRIC_TYPE_ARMADA_375 = 2,
	COHERENCY_FABRIC_TYPE_ARMADA_380 = 3,
};

enum {
	COLD_BIT_SHIFT = 0,
	FSYNC_BIT_SHIFT = 1,
	DENT_BIT_SHIFT = 2,
	OFFSET_BIT_SHIFT = 3,
};

enum {
	COMMIT_RESTING = 0,
	COMMIT_BACKGROUND = 1,
	COMMIT_REQUIRED = 2,
	COMMIT_RUNNING_BACKGROUND = 3,
	COMMIT_RUNNING_REQUIRED = 4,
	COMMIT_BROKEN = 5,
};

enum {
	COMPR_MODE_FS = 0,
	COMPR_MODE_USER = 1,
};

enum {
	COST_CTRL = 0,
	COST_MODEL = 1,
	NR_COST_CTRL_PARAMS = 2,
};

enum {
	CPSW_ALE_F_STATUS_REG = 1,
	CPSW_ALE_F_HW_AUTOAGING = 2,
	CPSW_ALE_F_COUNT = 3,
};

enum {
	CPSW_RX_VLAN_ENCAP_HDR_PKT_VLAN_TAG = 0,
	CPSW_RX_VLAN_ENCAP_HDR_PKT_RESERV = 1,
	CPSW_RX_VLAN_ENCAP_HDR_PKT_PRIO_TAG = 2,
	CPSW_RX_VLAN_ENCAP_HDR_PKT_UNTAG = 3,
};

enum {
	CPSW_SL_CTL_FULLDUPLEX = 1,
	CPSW_SL_CTL_LOOPBACK = 2,
	CPSW_SL_CTL_MTEST = 4,
	CPSW_SL_CTL_RX_FLOW_EN = 8,
	CPSW_SL_CTL_TX_FLOW_EN = 16,
	CPSW_SL_CTL_GMII_EN = 32,
	CPSW_SL_CTL_TX_PACE = 64,
	CPSW_SL_CTL_GIG = 128,
	CPSW_SL_CTL_XGIG = 256,
	CPSW_SL_CTL_TX_SHORT_GAP_EN = 1024,
	CPSW_SL_CTL_CMD_IDLE = 2048,
	CPSW_SL_CTL_CRC_TYPE = 4096,
	CPSW_SL_CTL_XGMII_EN = 8192,
	CPSW_SL_CTL_IFCTL_A = 32768,
	CPSW_SL_CTL_IFCTL_B = 65536,
	CPSW_SL_CTL_GIG_FORCE = 131072,
	CPSW_SL_CTL_EXT_EN = 262144,
	CPSW_SL_CTL_EXT_EN_RX_FLO = 524288,
	CPSW_SL_CTL_EXT_EN_TX_FLO = 1048576,
	CPSW_SL_CTL_TX_SG_LIM_EN = 2097152,
	CPSW_SL_CTL_RX_CEF_EN = 4194304,
	CPSW_SL_CTL_RX_CSF_EN = 8388608,
	CPSW_SL_CTL_RX_CMF_EN = 16777216,
	CPSW_SL_CTL_EXT_EN_XGIG = 33554432,
	CPSW_SL_CTL_FUNCS_COUNT = 33554433,
};

enum {
	CPSW_STATS = 0,
	CPDMA_RX_STATS = 1,
	CPDMA_TX_STATS = 2,
};

enum {
	CPTS_EV_PUSH = 0,
	CPTS_EV_ROLL = 1,
	CPTS_EV_HALF = 2,
	CPTS_EV_HW = 3,
	CPTS_EV_RX = 4,
	CPTS_EV_TX = 5,
};

enum {
	CP_TIME = 0,
	REQ_TIME = 1,
	DISCARD_TIME = 2,
	GC_TIME = 3,
	DISABLE_TIME = 4,
	UMOUNT_DISCARD_TIMEOUT = 5,
	MAX_TIME = 6,
};

enum {
	CRNG_EMPTY = 0,
	CRNG_EARLY = 1,
	CRNG_READY = 2,
};

enum {
	CRNG_RESEED_START_INTERVAL = 250,
	CRNG_RESEED_INTERVAL = 15000,
};

enum {
	CROS_EC_ALTMODE_DP = 0,
	CROS_EC_ALTMODE_TBT = 1,
	CROS_EC_ALTMODE_USB4 = 2,
	CROS_EC_ALTMODE_MAX = 3,
};

enum {
	CROS_EC_SENSOR_LAST_TS = 0,
	CROS_EC_SENSOR_NEW_TS = 1,
	CROS_EC_SENSOR_ALL_TS = 2,
};

enum {
	CRYPTOA_UNSPEC = 0,
	CRYPTOA_ALG = 1,
	CRYPTOA_TYPE = 2,
	__CRYPTOA_MAX = 3,
};

enum {
	CRYPTO_MSG_ALG_REQUEST = 0,
	CRYPTO_MSG_ALG_REGISTER = 1,
	CRYPTO_MSG_ALG_LOADED = 2,
};

enum {
	CSC_RGB_0_255_TO_ITU601_16_235_8BIT = 0,
	CSC_RGB_0_255_TO_ITU709_16_235_8BIT = 1,
	CSC_RGB_0_255_TO_RGB_16_235_8BIT = 2,
};

enum {
	CSD_FLAG_LOCK = 1,
	IRQ_WORK_PENDING = 1,
	IRQ_WORK_BUSY = 2,
	IRQ_WORK_LAZY = 4,
	IRQ_WORK_HARD_IRQ = 8,
	IRQ_WORK_CLAIMED = 3,
	CSD_TYPE_ASYNC = 0,
	CSD_TYPE_SYNC = 16,
	CSD_TYPE_IRQ_WORK = 32,
	CSD_TYPE_TTWU = 48,
	CSD_FLAG_TYPE_MASK = 240,
};

enum {
	CSI_DEC_hl_CURSOR_KEYS = 1,
	CSI_DEC_hl_132_COLUMNS = 3,
	CSI_DEC_hl_REVERSE_VIDEO = 5,
	CSI_DEC_hl_ORIGIN_MODE = 6,
	CSI_DEC_hl_AUTOWRAP = 7,
	CSI_DEC_hl_AUTOREPEAT = 8,
	CSI_DEC_hl_MOUSE_X10 = 9,
	CSI_DEC_hl_SHOW_CURSOR = 25,
	CSI_DEC_hl_MOUSE_VT200 = 1000,
	CSI_DEC_hl_BRACKETED_PASTE = 2004,
};

enum {
	CSI_K_CURSOR_TO_LINEEND = 0,
	CSI_K_LINESTART_TO_CURSOR = 1,
	CSI_K_LINE = 2,
};

enum {
	CSI_hl_DISPLAY_CTRL = 3,
	CSI_hl_INSERT = 4,
	CSI_hl_AUTO_NL = 20,
};

enum {
	CSI_m_DEFAULT = 0,
	CSI_m_BOLD = 1,
	CSI_m_HALF_BRIGHT = 2,
	CSI_m_ITALIC = 3,
	CSI_m_UNDERLINE = 4,
	CSI_m_BLINK = 5,
	CSI_m_REVERSE = 7,
	CSI_m_PRI_FONT = 10,
	CSI_m_ALT_FONT1 = 11,
	CSI_m_ALT_FONT2 = 12,
	CSI_m_DOUBLE_UNDERLINE = 21,
	CSI_m_NORMAL_INTENSITY = 22,
	CSI_m_NO_ITALIC = 23,
	CSI_m_NO_UNDERLINE = 24,
	CSI_m_NO_BLINK = 25,
	CSI_m_NO_REVERSE = 27,
	CSI_m_FG_COLOR_BEG = 30,
	CSI_m_FG_COLOR_END = 37,
	CSI_m_FG_COLOR = 38,
	CSI_m_DEFAULT_FG_COLOR = 39,
	CSI_m_BG_COLOR_BEG = 40,
	CSI_m_BG_COLOR_END = 47,
	CSI_m_BG_COLOR = 48,
	CSI_m_DEFAULT_BG_COLOR = 49,
	CSI_m_BRIGHT_FG_COLOR_BEG = 90,
	CSI_m_BRIGHT_FG_COLOR_END = 97,
	CSI_m_BRIGHT_FG_COLOR_OFF = 60,
	CSI_m_BRIGHT_BG_COLOR_BEG = 100,
	CSI_m_BRIGHT_BG_COLOR_END = 107,
	CSI_m_BRIGHT_BG_COLOR_OFF = 60,
};

enum {
	CSS_NO_REF = 1,
	CSS_ONLINE = 2,
	CSS_RELEASED = 4,
	CSS_VISIBLE = 8,
	CSS_DYING = 16,
};

enum {
	CTRL_ATTR_MCAST_GRP_UNSPEC = 0,
	CTRL_ATTR_MCAST_GRP_NAME = 1,
	CTRL_ATTR_MCAST_GRP_ID = 2,
	__CTRL_ATTR_MCAST_GRP_MAX = 3,
};

enum {
	CTRL_ATTR_OP_UNSPEC = 0,
	CTRL_ATTR_OP_ID = 1,
	CTRL_ATTR_OP_FLAGS = 2,
	__CTRL_ATTR_OP_MAX = 3,
};

enum {
	CTRL_ATTR_POLICY_UNSPEC = 0,
	CTRL_ATTR_POLICY_DO = 1,
	CTRL_ATTR_POLICY_DUMP = 2,
	__CTRL_ATTR_POLICY_DUMP_MAX = 3,
	CTRL_ATTR_POLICY_DUMP_MAX = 2,
};

enum {
	CTRL_ATTR_UNSPEC = 0,
	CTRL_ATTR_FAMILY_ID = 1,
	CTRL_ATTR_FAMILY_NAME = 2,
	CTRL_ATTR_VERSION = 3,
	CTRL_ATTR_HDRSIZE = 4,
	CTRL_ATTR_MAXATTR = 5,
	CTRL_ATTR_OPS = 6,
	CTRL_ATTR_MCAST_GROUPS = 7,
	CTRL_ATTR_POLICY = 8,
	CTRL_ATTR_OP_POLICY = 9,
	CTRL_ATTR_OP = 10,
	__CTRL_ATTR_MAX = 11,
};

enum {
	CTRL_CMD_UNSPEC = 0,
	CTRL_CMD_NEWFAMILY = 1,
	CTRL_CMD_DELFAMILY = 2,
	CTRL_CMD_GETFAMILY = 3,
	CTRL_CMD_NEWOPS = 4,
	CTRL_CMD_DELOPS = 5,
	CTRL_CMD_GETOPS = 6,
	CTRL_CMD_NEWMCAST_GRP = 7,
	CTRL_CMD_DELMCAST_GRP = 8,
	CTRL_CMD_GETMCAST_GRP = 9,
	CTRL_CMD_GETPOLICY = 10,
	__CTRL_CMD_MAX = 11,
};

enum {
	DA9063_DEV_ID_REG = 0,
	DA9063_VAR_ID_REG = 1,
	DA9063_CHIP_ID_REGS = 2,
};

enum {
	DA9063_ID_BCORE1 = 0,
	DA9063_ID_BCORE2 = 1,
	DA9063_ID_BPRO = 2,
	DA9063_ID_BMEM = 3,
	DA9063_ID_BIO = 4,
	DA9063_ID_BPERI = 5,
	DA9063_ID_BCORES_MERGED = 6,
	DA9063_ID_BMEM_BIO_MERGED = 7,
	DA9063_ID_LDO3 = 8,
	DA9063_ID_LDO7 = 9,
	DA9063_ID_LDO8 = 10,
	DA9063_ID_LDO9 = 11,
	DA9063_ID_LDO11 = 12,
	DA9063_ID_LDO1 = 13,
	DA9063_ID_LDO2 = 14,
	DA9063_ID_LDO4 = 15,
	DA9063_ID_LDO5 = 16,
	DA9063_ID_LDO6 = 17,
	DA9063_ID_LDO10 = 18,
};

enum {
	DAD_PROCESS = 0,
	DAD_BEGIN = 1,
	DAD_ABORT = 2,
};

enum {
	DD_DIR_COUNT = 2,
};

enum {
	DD_PRIO_COUNT = 3,
};

enum {
	DEBUG_ENTRIES = 0,
	DEBUG_SLOT_HANDLER_COUNT = 1,
	DEBUG_SLOT_HANDLER_LINE = 2,
	DEBUG_PARSE_LINE = 3,
	DEBUG_PARSE_HEADER = 4,
	DEBUG_PARSE_MSGID = 5,
	DEBUG_AWAIT_COMPLETION_LINE = 6,
	DEBUG_DEQUEUE_MESSAGE_LINE = 7,
	DEBUG_SERVICE_CALLBACK_LINE = 8,
	DEBUG_MSG_QUEUE_FULL_COUNT = 9,
	DEBUG_COMPLETION_QUEUE_FULL_COUNT = 10,
	DEBUG_MAX = 11,
};

enum {
	DEVCONF_FORWARDING = 0,
	DEVCONF_HOPLIMIT = 1,
	DEVCONF_MTU6 = 2,
	DEVCONF_ACCEPT_RA = 3,
	DEVCONF_ACCEPT_REDIRECTS = 4,
	DEVCONF_AUTOCONF = 5,
	DEVCONF_DAD_TRANSMITS = 6,
	DEVCONF_RTR_SOLICITS = 7,
	DEVCONF_RTR_SOLICIT_INTERVAL = 8,
	DEVCONF_RTR_SOLICIT_DELAY = 9,
	DEVCONF_USE_TEMPADDR = 10,
	DEVCONF_TEMP_VALID_LFT = 11,
	DEVCONF_TEMP_PREFERED_LFT = 12,
	DEVCONF_REGEN_MAX_RETRY = 13,
	DEVCONF_MAX_DESYNC_FACTOR = 14,
	DEVCONF_MAX_ADDRESSES = 15,
	DEVCONF_FORCE_MLD_VERSION = 16,
	DEVCONF_ACCEPT_RA_DEFRTR = 17,
	DEVCONF_ACCEPT_RA_PINFO = 18,
	DEVCONF_ACCEPT_RA_RTR_PREF = 19,
	DEVCONF_RTR_PROBE_INTERVAL = 20,
	DEVCONF_ACCEPT_RA_RT_INFO_MAX_PLEN = 21,
	DEVCONF_PROXY_NDP = 22,
	DEVCONF_OPTIMISTIC_DAD = 23,
	DEVCONF_ACCEPT_SOURCE_ROUTE = 24,
	DEVCONF_MC_FORWARDING = 25,
	DEVCONF_DISABLE_IPV6 = 26,
	DEVCONF_ACCEPT_DAD = 27,
	DEVCONF_FORCE_TLLAO = 28,
	DEVCONF_NDISC_NOTIFY = 29,
	DEVCONF_MLDV1_UNSOLICITED_REPORT_INTERVAL = 30,
	DEVCONF_MLDV2_UNSOLICITED_REPORT_INTERVAL = 31,
	DEVCONF_SUPPRESS_FRAG_NDISC = 32,
	DEVCONF_ACCEPT_RA_FROM_LOCAL = 33,
	DEVCONF_USE_OPTIMISTIC = 34,
	DEVCONF_ACCEPT_RA_MTU = 35,
	DEVCONF_STABLE_SECRET = 36,
	DEVCONF_USE_OIF_ADDRS_ONLY = 37,
	DEVCONF_ACCEPT_RA_MIN_HOP_LIMIT = 38,
	DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 39,
	DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 40,
	DEVCONF_DROP_UNSOLICITED_NA = 41,
	DEVCONF_KEEP_ADDR_ON_DOWN = 42,
	DEVCONF_RTR_SOLICIT_MAX_INTERVAL = 43,
	DEVCONF_SEG6_ENABLED = 44,
	DEVCONF_SEG6_REQUIRE_HMAC = 45,
	DEVCONF_ENHANCED_DAD = 46,
	DEVCONF_ADDR_GEN_MODE = 47,
	DEVCONF_DISABLE_POLICY = 48,
	DEVCONF_ACCEPT_RA_RT_INFO_MIN_PLEN = 49,
	DEVCONF_NDISC_TCLASS = 50,
	DEVCONF_RPL_SEG_ENABLED = 51,
	DEVCONF_RA_DEFRTR_METRIC = 52,
	DEVCONF_IOAM6_ENABLED = 53,
	DEVCONF_IOAM6_ID = 54,
	DEVCONF_IOAM6_ID_WIDE = 55,
	DEVCONF_NDISC_EVICT_NOCARRIER = 56,
	DEVCONF_ACCEPT_UNTRACKED_NA = 57,
	DEVCONF_ACCEPT_RA_MIN_LFT = 58,
	DEVCONF_MAX = 59,
};

enum {
	DEVLINK_ATTR_STATS_RX_PACKETS = 0,
	DEVLINK_ATTR_STATS_RX_BYTES = 1,
	DEVLINK_ATTR_STATS_RX_DROPPED = 2,
	__DEVLINK_ATTR_STATS_MAX = 3,
	DEVLINK_ATTR_STATS_MAX = 2,
};

enum {
	DEVLINK_ATTR_TRAP_METADATA_TYPE_IN_PORT = 0,
	DEVLINK_ATTR_TRAP_METADATA_TYPE_FA_COOKIE = 1,
};

enum {
	DEVSTAT_INUSE = 0,
	DEVSTAT_DIRTY = 1,
	DEVSTAT_FULL = 2,
	DEVSTAT_FREE = 3,
	DEVSTAT_PREFREE = 4,
	DEVSTAT_MAX = 5,
};

enum {
	DIO_LOCKING = 1,
	DIO_SKIP_HOLES = 2,
};

enum {
	DIO_SHOULD_DIRTY = 1,
	DIO_IS_SYNC = 2,
};

enum {
	DIRTY_CNODE = 0,
	OBSOLETE_CNODE = 1,
	COW_CNODE = 2,
};

enum {
	DIRTY_ZNODE = 0,
	COW_ZNODE = 1,
	OBSOLETE_ZNODE = 2,
};

enum {
	DIR_OFFSET_FIRST = 2,
	DIR_OFFSET_EOD = 2147483647,
};

enum {
	DIR_OFFSET_MIN = 3,
	DIR_OFFSET_MAX = 2147483646,
};

enum {
	DISCARD_UNIT_BLOCK = 0,
	DISCARD_UNIT_SEGMENT = 1,
	DISCARD_UNIT_SECTION = 2,
};

enum {
	DISCOVERED = 16,
	EXPLORED = 32,
	FALLTHROUGH = 1,
	BRANCH = 2,
};

enum {
	DISK_EVENT_FLAG_POLL = 1,
	DISK_EVENT_FLAG_UEVENT = 2,
	DISK_EVENT_FLAG_BLOCK_ON_EXCL_WRITE = 4,
};

enum {
	DISK_EVENT_MEDIA_CHANGE = 1,
	DISK_EVENT_EJECT_REQUEST = 2,
};

enum {
	DONE_EXPLORING = 0,
	KEEP_EXPLORING = 1,
};

enum {
	DOWN = 0,
	UP = 1,
};

enum {
	DP83867_PORT_MIRROING_KEEP = 0,
	DP83867_PORT_MIRROING_EN = 1,
	DP83867_PORT_MIRROING_DIS = 2,
};

enum {
	DPOLICY_BG = 0,
	DPOLICY_FORCE = 1,
	DPOLICY_FSTRIM = 2,
	DPOLICY_UMOUNT = 3,
	MAX_DPOLICY = 4,
};

enum {
	DPOLICY_IO_AWARE_DISABLE = 0,
	DPOLICY_IO_AWARE_ENABLE = 1,
	DPOLICY_IO_AWARE_MAX = 2,
};

enum {
	DPU_CTL_SPLIT_DISPLAY = 1,
	DPU_CTL_ACTIVE_CFG = 2,
	DPU_CTL_FETCH_ACTIVE = 3,
	DPU_CTL_VM_CFG = 4,
	DPU_CTL_HAS_LAYER_EXT4 = 5,
	DPU_CTL_DSPP_SUB_BLOCK_FLUSH = 6,
	DPU_CTL_MAX = 7,
};

enum {
	DPU_DSC_OUTPUT_CTRL = 1,
	DPU_DSC_HW_REV_1_2 = 2,
	DPU_DSC_NATIVE_42x_EN = 3,
	DPU_DSC_MAX = 4,
};

enum {
	DPU_DSPP_PCC = 1,
	DPU_DSPP_MAX = 2,
};

enum {
	DPU_INTF_INPUT_CTRL = 1,
	DPU_DATA_HCTL_EN = 2,
	DPU_INTF_STATUS_SUPPORTED = 3,
	DPU_INTF_MAX = 4,
};

enum {
	DPU_MDP_PANIC_PER_PIPE = 1,
	DPU_MDP_10BIT_SUPPORT = 2,
	DPU_MDP_AUDIO_SELECT = 3,
	DPU_MDP_PERIPH_0_REMOVED = 4,
	DPU_MDP_VSYNC_SEL = 5,
	DPU_MDP_MAX = 6,
};

enum {
	DPU_MIXER_LAYER = 1,
	DPU_MIXER_SOURCESPLIT = 2,
	DPU_MIXER_GC = 3,
	DPU_DIM_LAYER = 4,
	DPU_MIXER_COMBINED_ALPHA = 5,
	DPU_MIXER_MAX = 6,
};

enum {
	DPU_PERF_CDP_USAGE_RT = 0,
	DPU_PERF_CDP_USAGE_NRT = 1,
	DPU_PERF_CDP_USAGE_MAX = 2,
};

enum {
	DPU_PINGPONG_SPLIT = 1,
	DPU_PINGPONG_SLAVE = 2,
	DPU_PINGPONG_DITHER = 3,
	DPU_PINGPONG_DSC = 4,
	DPU_PINGPONG_MAX = 5,
};

enum {
	DPU_SSPP_COMP_0 = 0,
	DPU_SSPP_COMP_1_2 = 1,
	DPU_SSPP_COMP_2 = 2,
	DPU_SSPP_COMP_3 = 3,
	DPU_SSPP_COMP_MAX = 4,
};

enum {
	DPU_SSPP_SCALER_QSEED2 = 1,
	DPU_SSPP_SCALER_QSEED3_COMPATIBLE = 2,
	DPU_SSPP_SCALER_RGB = 3,
	DPU_SSPP_CSC = 4,
	DPU_SSPP_CSC_10BIT = 5,
	DPU_SSPP_CURSOR = 6,
	DPU_SSPP_QOS = 7,
	DPU_SSPP_QOS_8LVL = 8,
	DPU_SSPP_EXCL_RECT = 9,
	DPU_SSPP_SMART_DMA_V1 = 10,
	DPU_SSPP_SMART_DMA_V2 = 11,
	DPU_SSPP_TS_PREFILL = 12,
	DPU_SSPP_TS_PREFILL_REC1 = 13,
	DPU_SSPP_CDP = 14,
	DPU_SSPP_INLINE_ROTATION = 15,
	DPU_SSPP_MAX = 16,
};

enum {
	DPU_VBIF_QOS_OTLIM = 1,
	DPU_VBIF_QOS_REMAP = 2,
	DPU_VBIF_MAX = 3,
};

enum {
	DPU_WB_LINE_MODE = 1,
	DPU_WB_BLOCK_MODE = 2,
	DPU_WB_UBWC = 3,
	DPU_WB_YUV_CONFIG = 4,
	DPU_WB_PIPE_ALPHA = 5,
	DPU_WB_XY_ROI_OFFSET = 6,
	DPU_WB_QOS = 7,
	DPU_WB_QOS_8LVL = 8,
	DPU_WB_CDP = 9,
	DPU_WB_INPUT_CTRL = 10,
	DPU_WB_CROP = 11,
	DPU_WB_MAX = 12,
};

enum {
	DP_PIN_ASSIGN_A = 0,
	DP_PIN_ASSIGN_B = 1,
	DP_PIN_ASSIGN_C = 2,
	DP_PIN_ASSIGN_D = 3,
	DP_PIN_ASSIGN_E = 4,
	DP_PIN_ASSIGN_F = 5,
	DP_PIN_ASSIGN_MAX = 6,
};

enum {
	DP_TRAINING_NONE = 0,
	DP_TRAINING_1 = 1,
	DP_TRAINING_2 = 2,
};

enum {
	DQF_INFO_DIRTY_B = 17,
};

enum {
	DQF_ROOT_SQUASH_B = 0,
	DQF_SYS_FILE_B = 16,
	DQF_PRIVATE = 17,
};

enum {
	DQST_LOOKUPS = 0,
	DQST_DROPS = 1,
	DQST_READS = 2,
	DQST_WRITES = 3,
	DQST_CACHE_HITS = 4,
	DQST_ALLOC_DQUOTS = 5,
	DQST_FREE_DQUOTS = 6,
	DQST_SYNCS = 7,
	_DQST_DQSTAT_LAST = 8,
};

enum {
	DS3231_CLK_SQW = 0,
	DS3231_CLK_32KHZ = 1,
};

enum {
	DUMP_PREFIX_NONE = 0,
	DUMP_PREFIX_ADDRESS = 1,
	DUMP_PREFIX_OFFSET = 2,
};

enum {
	DW_DSI_USAGE_IDLE = 0,
	DW_DSI_USAGE_DSI = 1,
	DW_DSI_USAGE_PHY = 2,
};

enum {
	DW_HDMI_RES_8 = 0,
	DW_HDMI_RES_10 = 1,
	DW_HDMI_RES_12 = 2,
	DW_HDMI_RES_MAX = 3,
};

enum {
	D_PREP = 0,
	D_PARTIAL = 1,
	D_SUBMIT = 2,
	D_DONE = 3,
};

enum {
	EC_MSG_TX_HEADER_BYTES = 3,
	EC_MSG_TX_TRAILER_BYTES = 1,
	EC_MSG_TX_PROTO_BYTES = 4,
	EC_MSG_RX_PROTO_BYTES = 3,
	EC_PROTO2_MSG_BYTES = 256,
	EC_MAX_MSG_BYTES = 65536,
};

enum {
	EMAC_VERSION_1 = 0,
	EMAC_VERSION_2 = 1,
};

enum {
	EPecma = 0,
	EPdec = 1,
	EPeq = 2,
	EPgt = 3,
	EPlt = 4,
};

enum {
	ERASE = 0,
	WERASE = 1,
	KILL = 2,
};

enum {
	ES_WRITTEN_B = 0,
	ES_UNWRITTEN_B = 1,
	ES_DELAYED_B = 2,
	ES_HOLE_B = 3,
	ES_REFERENCED_B = 4,
	ES_FLAGS = 5,
};

enum {
	ETHTOOL_A_BITSET_BITS_UNSPEC = 0,
	ETHTOOL_A_BITSET_BITS_BIT = 1,
	__ETHTOOL_A_BITSET_BITS_CNT = 2,
	ETHTOOL_A_BITSET_BITS_MAX = 1,
};

enum {
	ETHTOOL_A_BITSET_BIT_UNSPEC = 0,
	ETHTOOL_A_BITSET_BIT_INDEX = 1,
	ETHTOOL_A_BITSET_BIT_NAME = 2,
	ETHTOOL_A_BITSET_BIT_VALUE = 3,
	__ETHTOOL_A_BITSET_BIT_CNT = 4,
	ETHTOOL_A_BITSET_BIT_MAX = 3,
};

enum {
	ETHTOOL_A_BITSET_UNSPEC = 0,
	ETHTOOL_A_BITSET_NOMASK = 1,
	ETHTOOL_A_BITSET_SIZE = 2,
	ETHTOOL_A_BITSET_BITS = 3,
	ETHTOOL_A_BITSET_VALUE = 4,
	ETHTOOL_A_BITSET_MASK = 5,
	__ETHTOOL_A_BITSET_CNT = 6,
	ETHTOOL_A_BITSET_MAX = 5,
};

enum {
	ETHTOOL_A_C33_PSE_PW_LIMIT_UNSPEC = 0,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MIN = 1,
	ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_CNT = 3,
	__ETHTOOL_A_C33_PSE_PW_LIMIT_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_AMPLITUDE_UNSPEC = 0,
	ETHTOOL_A_CABLE_AMPLITUDE_PAIR = 1,
	ETHTOOL_A_CABLE_AMPLITUDE_mV = 2,
	__ETHTOOL_A_CABLE_AMPLITUDE_CNT = 3,
	ETHTOOL_A_CABLE_AMPLITUDE_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_FAULT_LENGTH_UNSPEC = 0,
	ETHTOOL_A_CABLE_FAULT_LENGTH_PAIR = 1,
	ETHTOOL_A_CABLE_FAULT_LENGTH_CM = 2,
	ETHTOOL_A_CABLE_FAULT_LENGTH_SRC = 3,
	__ETHTOOL_A_CABLE_FAULT_LENGTH_CNT = 4,
	ETHTOOL_A_CABLE_FAULT_LENGTH_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_INF_SRC_UNSPEC = 0,
	ETHTOOL_A_CABLE_INF_SRC_TDR = 1,
	ETHTOOL_A_CABLE_INF_SRC_ALCD = 2,
};

enum {
	ETHTOOL_A_CABLE_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_NEST_RESULT = 1,
	ETHTOOL_A_CABLE_NEST_FAULT_LENGTH = 2,
	__ETHTOOL_A_CABLE_NEST_CNT = 3,
	ETHTOOL_A_CABLE_NEST_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_PAIR_A = 0,
	ETHTOOL_A_CABLE_PAIR_B = 1,
	ETHTOOL_A_CABLE_PAIR_C = 2,
	ETHTOOL_A_CABLE_PAIR_D = 3,
};

enum {
	ETHTOOL_A_CABLE_PULSE_UNSPEC = 0,
	ETHTOOL_A_CABLE_PULSE_mV = 1,
	__ETHTOOL_A_CABLE_PULSE_CNT = 2,
	ETHTOOL_A_CABLE_PULSE_MAX = 1,
};

enum {
	ETHTOOL_A_CABLE_RESULT_CODE_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_CODE_OK = 1,
	ETHTOOL_A_CABLE_RESULT_CODE_OPEN = 2,
	ETHTOOL_A_CABLE_RESULT_CODE_SAME_SHORT = 3,
	ETHTOOL_A_CABLE_RESULT_CODE_CROSS_SHORT = 4,
	ETHTOOL_A_CABLE_RESULT_CODE_IMPEDANCE_MISMATCH = 5,
	ETHTOOL_A_CABLE_RESULT_CODE_NOISE = 6,
	ETHTOOL_A_CABLE_RESULT_CODE_RESOLUTION_NOT_POSSIBLE = 7,
};

enum {
	ETHTOOL_A_CABLE_RESULT_UNSPEC = 0,
	ETHTOOL_A_CABLE_RESULT_PAIR = 1,
	ETHTOOL_A_CABLE_RESULT_CODE = 2,
	ETHTOOL_A_CABLE_RESULT_SRC = 3,
	__ETHTOOL_A_CABLE_RESULT_CNT = 4,
	ETHTOOL_A_CABLE_RESULT_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_STEP_UNSPEC = 0,
	ETHTOOL_A_CABLE_STEP_FIRST_DISTANCE = 1,
	ETHTOOL_A_CABLE_STEP_LAST_DISTANCE = 2,
	ETHTOOL_A_CABLE_STEP_STEP_DISTANCE = 3,
	__ETHTOOL_A_CABLE_STEP_CNT = 4,
	ETHTOOL_A_CABLE_STEP_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TDR_NEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TDR_NEST_STEP = 1,
	ETHTOOL_A_CABLE_TDR_NEST_AMPLITUDE = 2,
	ETHTOOL_A_CABLE_TDR_NEST_PULSE = 3,
	__ETHTOOL_A_CABLE_TDR_NEST_CNT = 4,
	ETHTOOL_A_CABLE_TDR_NEST_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_STARTED = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS_COMPLETED = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_NTF_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_NTF_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_NTF_STATUS = 2,
	ETHTOOL_A_CABLE_TEST_NTF_NEST = 3,
	__ETHTOOL_A_CABLE_TEST_NTF_CNT = 4,
	ETHTOOL_A_CABLE_TEST_NTF_MAX = 3,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_CFG_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_FIRST = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_LAST = 2,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_STEP = 3,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_PAIR = 4,
	__ETHTOOL_A_CABLE_TEST_TDR_CFG_CNT = 5,
	ETHTOOL_A_CABLE_TEST_TDR_CFG_MAX = 4,
};

enum {
	ETHTOOL_A_CABLE_TEST_TDR_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_TDR_HEADER = 1,
	ETHTOOL_A_CABLE_TEST_TDR_CFG = 2,
	__ETHTOOL_A_CABLE_TEST_TDR_CNT = 3,
	ETHTOOL_A_CABLE_TEST_TDR_MAX = 2,
};

enum {
	ETHTOOL_A_CABLE_TEST_UNSPEC = 0,
	ETHTOOL_A_CABLE_TEST_HEADER = 1,
	__ETHTOOL_A_CABLE_TEST_CNT = 2,
	ETHTOOL_A_CABLE_TEST_MAX = 1,
};

enum {
	ETHTOOL_A_CHANNELS_UNSPEC = 0,
	ETHTOOL_A_CHANNELS_HEADER = 1,
	ETHTOOL_A_CHANNELS_RX_MAX = 2,
	ETHTOOL_A_CHANNELS_TX_MAX = 3,
	ETHTOOL_A_CHANNELS_OTHER_MAX = 4,
	ETHTOOL_A_CHANNELS_COMBINED_MAX = 5,
	ETHTOOL_A_CHANNELS_RX_COUNT = 6,
	ETHTOOL_A_CHANNELS_TX_COUNT = 7,
	ETHTOOL_A_CHANNELS_OTHER_COUNT = 8,
	ETHTOOL_A_CHANNELS_COMBINED_COUNT = 9,
	__ETHTOOL_A_CHANNELS_CNT = 10,
	ETHTOOL_A_CHANNELS_MAX = 9,
};

enum {
	ETHTOOL_A_COALESCE_UNSPEC = 0,
	ETHTOOL_A_COALESCE_HEADER = 1,
	ETHTOOL_A_COALESCE_RX_USECS = 2,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES = 3,
	ETHTOOL_A_COALESCE_RX_USECS_IRQ = 4,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_IRQ = 5,
	ETHTOOL_A_COALESCE_TX_USECS = 6,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES = 7,
	ETHTOOL_A_COALESCE_TX_USECS_IRQ = 8,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_IRQ = 9,
	ETHTOOL_A_COALESCE_STATS_BLOCK_USECS = 10,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_RX = 11,
	ETHTOOL_A_COALESCE_USE_ADAPTIVE_TX = 12,
	ETHTOOL_A_COALESCE_PKT_RATE_LOW = 13,
	ETHTOOL_A_COALESCE_RX_USECS_LOW = 14,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_LOW = 15,
	ETHTOOL_A_COALESCE_TX_USECS_LOW = 16,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_LOW = 17,
	ETHTOOL_A_COALESCE_PKT_RATE_HIGH = 18,
	ETHTOOL_A_COALESCE_RX_USECS_HIGH = 19,
	ETHTOOL_A_COALESCE_RX_MAX_FRAMES_HIGH = 20,
	ETHTOOL_A_COALESCE_TX_USECS_HIGH = 21,
	ETHTOOL_A_COALESCE_TX_MAX_FRAMES_HIGH = 22,
	ETHTOOL_A_COALESCE_RATE_SAMPLE_INTERVAL = 23,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_TX = 24,
	ETHTOOL_A_COALESCE_USE_CQE_MODE_RX = 25,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_BYTES = 26,
	ETHTOOL_A_COALESCE_TX_AGGR_MAX_FRAMES = 27,
	ETHTOOL_A_COALESCE_TX_AGGR_TIME_USECS = 28,
	ETHTOOL_A_COALESCE_RX_PROFILE = 29,
	ETHTOOL_A_COALESCE_TX_PROFILE = 30,
	__ETHTOOL_A_COALESCE_CNT = 31,
	ETHTOOL_A_COALESCE_MAX = 30,
};

enum {
	ETHTOOL_A_DEBUG_UNSPEC = 0,
	ETHTOOL_A_DEBUG_HEADER = 1,
	ETHTOOL_A_DEBUG_MSGMASK = 2,
	__ETHTOOL_A_DEBUG_CNT = 3,
	ETHTOOL_A_DEBUG_MAX = 2,
};

enum {
	ETHTOOL_A_EEE_UNSPEC = 0,
	ETHTOOL_A_EEE_HEADER = 1,
	ETHTOOL_A_EEE_MODES_OURS = 2,
	ETHTOOL_A_EEE_MODES_PEER = 3,
	ETHTOOL_A_EEE_ACTIVE = 4,
	ETHTOOL_A_EEE_ENABLED = 5,
	ETHTOOL_A_EEE_TX_LPI_ENABLED = 6,
	ETHTOOL_A_EEE_TX_LPI_TIMER = 7,
	__ETHTOOL_A_EEE_CNT = 8,
	ETHTOOL_A_EEE_MAX = 7,
};

enum {
	ETHTOOL_A_FEATURES_UNSPEC = 0,
	ETHTOOL_A_FEATURES_HEADER = 1,
	ETHTOOL_A_FEATURES_HW = 2,
	ETHTOOL_A_FEATURES_WANTED = 3,
	ETHTOOL_A_FEATURES_ACTIVE = 4,
	ETHTOOL_A_FEATURES_NOCHANGE = 5,
	__ETHTOOL_A_FEATURES_CNT = 6,
	ETHTOOL_A_FEATURES_MAX = 5,
};

enum {
	ETHTOOL_A_FEC_STAT_UNSPEC = 0,
	ETHTOOL_A_FEC_STAT_PAD = 1,
	ETHTOOL_A_FEC_STAT_CORRECTED = 2,
	ETHTOOL_A_FEC_STAT_UNCORR = 3,
	ETHTOOL_A_FEC_STAT_CORR_BITS = 4,
	__ETHTOOL_A_FEC_STAT_CNT = 5,
	ETHTOOL_A_FEC_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_FEC_UNSPEC = 0,
	ETHTOOL_A_FEC_HEADER = 1,
	ETHTOOL_A_FEC_MODES = 2,
	ETHTOOL_A_FEC_AUTO = 3,
	ETHTOOL_A_FEC_ACTIVE = 4,
	ETHTOOL_A_FEC_STATS = 5,
	__ETHTOOL_A_FEC_CNT = 6,
	ETHTOOL_A_FEC_MAX = 5,
};

enum {
	ETHTOOL_A_HEADER_UNSPEC = 0,
	ETHTOOL_A_HEADER_DEV_INDEX = 1,
	ETHTOOL_A_HEADER_DEV_NAME = 2,
	ETHTOOL_A_HEADER_FLAGS = 3,
	ETHTOOL_A_HEADER_PHY_INDEX = 4,
	__ETHTOOL_A_HEADER_CNT = 5,
	ETHTOOL_A_HEADER_MAX = 4,
};

enum {
	ETHTOOL_A_IRQ_MODERATION_UNSPEC = 0,
	ETHTOOL_A_IRQ_MODERATION_USEC = 1,
	ETHTOOL_A_IRQ_MODERATION_PKTS = 2,
	ETHTOOL_A_IRQ_MODERATION_COMPS = 3,
	__ETHTOOL_A_IRQ_MODERATION_CNT = 4,
	ETHTOOL_A_IRQ_MODERATION_MAX = 3,
};

enum {
	ETHTOOL_A_LINKINFO_UNSPEC = 0,
	ETHTOOL_A_LINKINFO_HEADER = 1,
	ETHTOOL_A_LINKINFO_PORT = 2,
	ETHTOOL_A_LINKINFO_PHYADDR = 3,
	ETHTOOL_A_LINKINFO_TP_MDIX = 4,
	ETHTOOL_A_LINKINFO_TP_MDIX_CTRL = 5,
	ETHTOOL_A_LINKINFO_TRANSCEIVER = 6,
	__ETHTOOL_A_LINKINFO_CNT = 7,
	ETHTOOL_A_LINKINFO_MAX = 6,
};

enum {
	ETHTOOL_A_LINKMODES_UNSPEC = 0,
	ETHTOOL_A_LINKMODES_HEADER = 1,
	ETHTOOL_A_LINKMODES_AUTONEG = 2,
	ETHTOOL_A_LINKMODES_OURS = 3,
	ETHTOOL_A_LINKMODES_PEER = 4,
	ETHTOOL_A_LINKMODES_SPEED = 5,
	ETHTOOL_A_LINKMODES_DUPLEX = 6,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_CFG = 7,
	ETHTOOL_A_LINKMODES_MASTER_SLAVE_STATE = 8,
	ETHTOOL_A_LINKMODES_LANES = 9,
	ETHTOOL_A_LINKMODES_RATE_MATCHING = 10,
	__ETHTOOL_A_LINKMODES_CNT = 11,
	ETHTOOL_A_LINKMODES_MAX = 10,
};

enum {
	ETHTOOL_A_LINKSTATE_UNSPEC = 0,
	ETHTOOL_A_LINKSTATE_HEADER = 1,
	ETHTOOL_A_LINKSTATE_LINK = 2,
	ETHTOOL_A_LINKSTATE_SQI = 3,
	ETHTOOL_A_LINKSTATE_SQI_MAX = 4,
	ETHTOOL_A_LINKSTATE_EXT_STATE = 5,
	ETHTOOL_A_LINKSTATE_EXT_SUBSTATE = 6,
	ETHTOOL_A_LINKSTATE_EXT_DOWN_CNT = 7,
	__ETHTOOL_A_LINKSTATE_CNT = 8,
	ETHTOOL_A_LINKSTATE_MAX = 7,
};

enum {
	ETHTOOL_A_MM_STAT_UNSPEC = 0,
	ETHTOOL_A_MM_STAT_PAD = 1,
	ETHTOOL_A_MM_STAT_REASSEMBLY_ERRORS = 2,
	ETHTOOL_A_MM_STAT_SMD_ERRORS = 3,
	ETHTOOL_A_MM_STAT_REASSEMBLY_OK = 4,
	ETHTOOL_A_MM_STAT_RX_FRAG_COUNT = 5,
	ETHTOOL_A_MM_STAT_TX_FRAG_COUNT = 6,
	ETHTOOL_A_MM_STAT_HOLD_COUNT = 7,
	__ETHTOOL_A_MM_STAT_CNT = 8,
	ETHTOOL_A_MM_STAT_MAX = 7,
};

enum {
	ETHTOOL_A_MM_UNSPEC = 0,
	ETHTOOL_A_MM_HEADER = 1,
	ETHTOOL_A_MM_PMAC_ENABLED = 2,
	ETHTOOL_A_MM_TX_ENABLED = 3,
	ETHTOOL_A_MM_TX_ACTIVE = 4,
	ETHTOOL_A_MM_TX_MIN_FRAG_SIZE = 5,
	ETHTOOL_A_MM_RX_MIN_FRAG_SIZE = 6,
	ETHTOOL_A_MM_VERIFY_ENABLED = 7,
	ETHTOOL_A_MM_VERIFY_STATUS = 8,
	ETHTOOL_A_MM_VERIFY_TIME = 9,
	ETHTOOL_A_MM_MAX_VERIFY_TIME = 10,
	ETHTOOL_A_MM_STATS = 11,
	__ETHTOOL_A_MM_CNT = 12,
	ETHTOOL_A_MM_MAX = 11,
};

enum {
	ETHTOOL_A_MODULE_EEPROM_UNSPEC = 0,
	ETHTOOL_A_MODULE_EEPROM_HEADER = 1,
	ETHTOOL_A_MODULE_EEPROM_OFFSET = 2,
	ETHTOOL_A_MODULE_EEPROM_LENGTH = 3,
	ETHTOOL_A_MODULE_EEPROM_PAGE = 4,
	ETHTOOL_A_MODULE_EEPROM_BANK = 5,
	ETHTOOL_A_MODULE_EEPROM_I2C_ADDRESS = 6,
	ETHTOOL_A_MODULE_EEPROM_DATA = 7,
	__ETHTOOL_A_MODULE_EEPROM_CNT = 8,
	ETHTOOL_A_MODULE_EEPROM_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_FW_FLASH_UNSPEC = 0,
	ETHTOOL_A_MODULE_FW_FLASH_HEADER = 1,
	ETHTOOL_A_MODULE_FW_FLASH_FILE_NAME = 2,
	ETHTOOL_A_MODULE_FW_FLASH_PASSWORD = 3,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS = 4,
	ETHTOOL_A_MODULE_FW_FLASH_STATUS_MSG = 5,
	ETHTOOL_A_MODULE_FW_FLASH_DONE = 6,
	ETHTOOL_A_MODULE_FW_FLASH_TOTAL = 7,
	__ETHTOOL_A_MODULE_FW_FLASH_CNT = 8,
	ETHTOOL_A_MODULE_FW_FLASH_MAX = 7,
};

enum {
	ETHTOOL_A_MODULE_UNSPEC = 0,
	ETHTOOL_A_MODULE_HEADER = 1,
	ETHTOOL_A_MODULE_POWER_MODE_POLICY = 2,
	ETHTOOL_A_MODULE_POWER_MODE = 3,
	__ETHTOOL_A_MODULE_CNT = 4,
	ETHTOOL_A_MODULE_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_STAT_UNSPEC = 0,
	ETHTOOL_A_PAUSE_STAT_PAD = 1,
	ETHTOOL_A_PAUSE_STAT_TX_FRAMES = 2,
	ETHTOOL_A_PAUSE_STAT_RX_FRAMES = 3,
	__ETHTOOL_A_PAUSE_STAT_CNT = 4,
	ETHTOOL_A_PAUSE_STAT_MAX = 3,
};

enum {
	ETHTOOL_A_PAUSE_UNSPEC = 0,
	ETHTOOL_A_PAUSE_HEADER = 1,
	ETHTOOL_A_PAUSE_AUTONEG = 2,
	ETHTOOL_A_PAUSE_RX = 3,
	ETHTOOL_A_PAUSE_TX = 4,
	ETHTOOL_A_PAUSE_STATS = 5,
	ETHTOOL_A_PAUSE_STATS_SRC = 6,
	__ETHTOOL_A_PAUSE_CNT = 7,
	ETHTOOL_A_PAUSE_MAX = 6,
};

enum {
	ETHTOOL_A_PHC_VCLOCKS_UNSPEC = 0,
	ETHTOOL_A_PHC_VCLOCKS_HEADER = 1,
	ETHTOOL_A_PHC_VCLOCKS_NUM = 2,
	ETHTOOL_A_PHC_VCLOCKS_INDEX = 3,
	__ETHTOOL_A_PHC_VCLOCKS_CNT = 4,
	ETHTOOL_A_PHC_VCLOCKS_MAX = 3,
};

enum {
	ETHTOOL_A_PHY_UNSPEC = 0,
	ETHTOOL_A_PHY_HEADER = 1,
	ETHTOOL_A_PHY_INDEX = 2,
	ETHTOOL_A_PHY_DRVNAME = 3,
	ETHTOOL_A_PHY_NAME = 4,
	ETHTOOL_A_PHY_UPSTREAM_TYPE = 5,
	ETHTOOL_A_PHY_UPSTREAM_INDEX = 6,
	ETHTOOL_A_PHY_UPSTREAM_SFP_NAME = 7,
	ETHTOOL_A_PHY_DOWNSTREAM_SFP_NAME = 8,
	__ETHTOOL_A_PHY_CNT = 9,
	ETHTOOL_A_PHY_MAX = 8,
};

enum {
	ETHTOOL_A_PLCA_UNSPEC = 0,
	ETHTOOL_A_PLCA_HEADER = 1,
	ETHTOOL_A_PLCA_VERSION = 2,
	ETHTOOL_A_PLCA_ENABLED = 3,
	ETHTOOL_A_PLCA_STATUS = 4,
	ETHTOOL_A_PLCA_NODE_CNT = 5,
	ETHTOOL_A_PLCA_NODE_ID = 6,
	ETHTOOL_A_PLCA_TO_TMR = 7,
	ETHTOOL_A_PLCA_BURST_CNT = 8,
	ETHTOOL_A_PLCA_BURST_TMR = 9,
	__ETHTOOL_A_PLCA_CNT = 10,
	ETHTOOL_A_PLCA_MAX = 9,
};

enum {
	ETHTOOL_A_PRIVFLAGS_UNSPEC = 0,
	ETHTOOL_A_PRIVFLAGS_HEADER = 1,
	ETHTOOL_A_PRIVFLAGS_FLAGS = 2,
	__ETHTOOL_A_PRIVFLAGS_CNT = 3,
	ETHTOOL_A_PRIVFLAGS_MAX = 2,
};

enum {
	ETHTOOL_A_PROFILE_UNSPEC = 0,
	ETHTOOL_A_PROFILE_IRQ_MODERATION = 1,
	__ETHTOOL_A_PROFILE_CNT = 2,
	ETHTOOL_A_PROFILE_MAX = 1,
};

enum {
	ETHTOOL_A_PSE_UNSPEC = 0,
	ETHTOOL_A_PSE_HEADER = 1,
	ETHTOOL_A_PODL_PSE_ADMIN_STATE = 2,
	ETHTOOL_A_PODL_PSE_ADMIN_CONTROL = 3,
	ETHTOOL_A_PODL_PSE_PW_D_STATUS = 4,
	ETHTOOL_A_C33_PSE_ADMIN_STATE = 5,
	ETHTOOL_A_C33_PSE_ADMIN_CONTROL = 6,
	ETHTOOL_A_C33_PSE_PW_D_STATUS = 7,
	ETHTOOL_A_C33_PSE_PW_CLASS = 8,
	ETHTOOL_A_C33_PSE_ACTUAL_PW = 9,
	ETHTOOL_A_C33_PSE_EXT_STATE = 10,
	ETHTOOL_A_C33_PSE_EXT_SUBSTATE = 11,
	ETHTOOL_A_C33_PSE_AVAIL_PW_LIMIT = 12,
	ETHTOOL_A_C33_PSE_PW_LIMIT_RANGES = 13,
	__ETHTOOL_A_PSE_CNT = 14,
	ETHTOOL_A_PSE_MAX = 13,
};

enum {
	ETHTOOL_A_RINGS_UNSPEC = 0,
	ETHTOOL_A_RINGS_HEADER = 1,
	ETHTOOL_A_RINGS_RX_MAX = 2,
	ETHTOOL_A_RINGS_RX_MINI_MAX = 3,
	ETHTOOL_A_RINGS_RX_JUMBO_MAX = 4,
	ETHTOOL_A_RINGS_TX_MAX = 5,
	ETHTOOL_A_RINGS_RX = 6,
	ETHTOOL_A_RINGS_RX_MINI = 7,
	ETHTOOL_A_RINGS_RX_JUMBO = 8,
	ETHTOOL_A_RINGS_TX = 9,
	ETHTOOL_A_RINGS_RX_BUF_LEN = 10,
	ETHTOOL_A_RINGS_TCP_DATA_SPLIT = 11,
	ETHTOOL_A_RINGS_CQE_SIZE = 12,
	ETHTOOL_A_RINGS_TX_PUSH = 13,
	ETHTOOL_A_RINGS_RX_PUSH = 14,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN = 15,
	ETHTOOL_A_RINGS_TX_PUSH_BUF_LEN_MAX = 16,
	ETHTOOL_A_RINGS_HDS_THRESH = 17,
	ETHTOOL_A_RINGS_HDS_THRESH_MAX = 18,
	__ETHTOOL_A_RINGS_CNT = 19,
	ETHTOOL_A_RINGS_MAX = 18,
};

enum {
	ETHTOOL_A_RSS_UNSPEC = 0,
	ETHTOOL_A_RSS_HEADER = 1,
	ETHTOOL_A_RSS_CONTEXT = 2,
	ETHTOOL_A_RSS_HFUNC = 3,
	ETHTOOL_A_RSS_INDIR = 4,
	ETHTOOL_A_RSS_HKEY = 5,
	ETHTOOL_A_RSS_INPUT_XFRM = 6,
	ETHTOOL_A_RSS_START_CONTEXT = 7,
	__ETHTOOL_A_RSS_CNT = 8,
	ETHTOOL_A_RSS_MAX = 7,
};

enum {
	ETHTOOL_A_STATS_ETH_CTRL_3_TX = 0,
	ETHTOOL_A_STATS_ETH_CTRL_4_RX = 1,
	ETHTOOL_A_STATS_ETH_CTRL_5_RX_UNSUP = 2,
	__ETHTOOL_A_STATS_ETH_CTRL_CNT = 3,
	ETHTOOL_A_STATS_ETH_CTRL_MAX = 2,
};

enum {
	ETHTOOL_A_STATS_ETH_MAC_2_TX_PKT = 0,
	ETHTOOL_A_STATS_ETH_MAC_3_SINGLE_COL = 1,
	ETHTOOL_A_STATS_ETH_MAC_4_MULTI_COL = 2,
	ETHTOOL_A_STATS_ETH_MAC_5_RX_PKT = 3,
	ETHTOOL_A_STATS_ETH_MAC_6_FCS_ERR = 4,
	ETHTOOL_A_STATS_ETH_MAC_7_ALIGN_ERR = 5,
	ETHTOOL_A_STATS_ETH_MAC_8_TX_BYTES = 6,
	ETHTOOL_A_STATS_ETH_MAC_9_TX_DEFER = 7,
	ETHTOOL_A_STATS_ETH_MAC_10_LATE_COL = 8,
	ETHTOOL_A_STATS_ETH_MAC_11_XS_COL = 9,
	ETHTOOL_A_STATS_ETH_MAC_12_TX_INT_ERR = 10,
	ETHTOOL_A_STATS_ETH_MAC_13_CS_ERR = 11,
	ETHTOOL_A_STATS_ETH_MAC_14_RX_BYTES = 12,
	ETHTOOL_A_STATS_ETH_MAC_15_RX_INT_ERR = 13,
	ETHTOOL_A_STATS_ETH_MAC_18_TX_MCAST = 14,
	ETHTOOL_A_STATS_ETH_MAC_19_TX_BCAST = 15,
	ETHTOOL_A_STATS_ETH_MAC_20_XS_DEFER = 16,
	ETHTOOL_A_STATS_ETH_MAC_21_RX_MCAST = 17,
	ETHTOOL_A_STATS_ETH_MAC_22_RX_BCAST = 18,
	ETHTOOL_A_STATS_ETH_MAC_23_IR_LEN_ERR = 19,
	ETHTOOL_A_STATS_ETH_MAC_24_OOR_LEN = 20,
	ETHTOOL_A_STATS_ETH_MAC_25_TOO_LONG_ERR = 21,
	__ETHTOOL_A_STATS_ETH_MAC_CNT = 22,
	ETHTOOL_A_STATS_ETH_MAC_MAX = 21,
};

enum {
	ETHTOOL_A_STATS_ETH_PHY_5_SYM_ERR = 0,
	__ETHTOOL_A_STATS_ETH_PHY_CNT = 1,
	ETHTOOL_A_STATS_ETH_PHY_MAX = 0,
};

enum {
	ETHTOOL_A_STATS_GRP_UNSPEC = 0,
	ETHTOOL_A_STATS_GRP_PAD = 1,
	ETHTOOL_A_STATS_GRP_ID = 2,
	ETHTOOL_A_STATS_GRP_SS_ID = 3,
	ETHTOOL_A_STATS_GRP_STAT = 4,
	ETHTOOL_A_STATS_GRP_HIST_RX = 5,
	ETHTOOL_A_STATS_GRP_HIST_TX = 6,
	ETHTOOL_A_STATS_GRP_HIST_BKT_LOW = 7,
	ETHTOOL_A_STATS_GRP_HIST_BKT_HI = 8,
	ETHTOOL_A_STATS_GRP_HIST_VAL = 9,
	__ETHTOOL_A_STATS_GRP_CNT = 10,
	ETHTOOL_A_STATS_GRP_MAX = 9,
};

enum {
	ETHTOOL_A_STATS_PHY_RX_PKTS = 0,
	ETHTOOL_A_STATS_PHY_RX_BYTES = 1,
	ETHTOOL_A_STATS_PHY_RX_ERRORS = 2,
	ETHTOOL_A_STATS_PHY_TX_PKTS = 3,
	ETHTOOL_A_STATS_PHY_TX_BYTES = 4,
	ETHTOOL_A_STATS_PHY_TX_ERRORS = 5,
	__ETHTOOL_A_STATS_PHY_CNT = 6,
	ETHTOOL_A_STATS_PHY_MAX = 5,
};

enum {
	ETHTOOL_A_STATS_RMON_UNDERSIZE = 0,
	ETHTOOL_A_STATS_RMON_OVERSIZE = 1,
	ETHTOOL_A_STATS_RMON_FRAG = 2,
	ETHTOOL_A_STATS_RMON_JABBER = 3,
	__ETHTOOL_A_STATS_RMON_CNT = 4,
	ETHTOOL_A_STATS_RMON_MAX = 3,
};

enum {
	ETHTOOL_A_STATS_UNSPEC = 0,
	ETHTOOL_A_STATS_PAD = 1,
	ETHTOOL_A_STATS_HEADER = 2,
	ETHTOOL_A_STATS_GROUPS = 3,
	ETHTOOL_A_STATS_GRP = 4,
	ETHTOOL_A_STATS_SRC = 5,
	__ETHTOOL_A_STATS_CNT = 6,
	ETHTOOL_A_STATS_MAX = 5,
};

enum {
	ETHTOOL_A_STRINGSETS_UNSPEC = 0,
	ETHTOOL_A_STRINGSETS_STRINGSET = 1,
	__ETHTOOL_A_STRINGSETS_CNT = 2,
	ETHTOOL_A_STRINGSETS_MAX = 1,
};

enum {
	ETHTOOL_A_STRINGSET_UNSPEC = 0,
	ETHTOOL_A_STRINGSET_ID = 1,
	ETHTOOL_A_STRINGSET_COUNT = 2,
	ETHTOOL_A_STRINGSET_STRINGS = 3,
	__ETHTOOL_A_STRINGSET_CNT = 4,
	ETHTOOL_A_STRINGSET_MAX = 3,
};

enum {
	ETHTOOL_A_STRINGS_UNSPEC = 0,
	ETHTOOL_A_STRINGS_STRING = 1,
	__ETHTOOL_A_STRINGS_CNT = 2,
	ETHTOOL_A_STRINGS_MAX = 1,
};

enum {
	ETHTOOL_A_STRING_UNSPEC = 0,
	ETHTOOL_A_STRING_INDEX = 1,
	ETHTOOL_A_STRING_VALUE = 2,
	__ETHTOOL_A_STRING_CNT = 3,
	ETHTOOL_A_STRING_MAX = 2,
};

enum {
	ETHTOOL_A_STRSET_UNSPEC = 0,
	ETHTOOL_A_STRSET_HEADER = 1,
	ETHTOOL_A_STRSET_STRINGSETS = 2,
	ETHTOOL_A_STRSET_COUNTS_ONLY = 3,
	__ETHTOOL_A_STRSET_CNT = 4,
	ETHTOOL_A_STRSET_MAX = 3,
};

enum {
	ETHTOOL_A_TSCONFIG_UNSPEC = 0,
	ETHTOOL_A_TSCONFIG_HEADER = 1,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_PROVIDER = 2,
	ETHTOOL_A_TSCONFIG_TX_TYPES = 3,
	ETHTOOL_A_TSCONFIG_RX_FILTERS = 4,
	ETHTOOL_A_TSCONFIG_HWTSTAMP_FLAGS = 5,
	__ETHTOOL_A_TSCONFIG_CNT = 6,
	ETHTOOL_A_TSCONFIG_MAX = 5,
};

enum {
	ETHTOOL_A_TSINFO_UNSPEC = 0,
	ETHTOOL_A_TSINFO_HEADER = 1,
	ETHTOOL_A_TSINFO_TIMESTAMPING = 2,
	ETHTOOL_A_TSINFO_TX_TYPES = 3,
	ETHTOOL_A_TSINFO_RX_FILTERS = 4,
	ETHTOOL_A_TSINFO_PHC_INDEX = 5,
	ETHTOOL_A_TSINFO_STATS = 6,
	ETHTOOL_A_TSINFO_HWTSTAMP_PROVIDER = 7,
	ETHTOOL_A_TSINFO_HWTSTAMP_SOURCE = 8,
	ETHTOOL_A_TSINFO_HWTSTAMP_PHYINDEX = 9,
	__ETHTOOL_A_TSINFO_CNT = 10,
	ETHTOOL_A_TSINFO_MAX = 9,
};

enum {
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_UNSPEC = 0,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_INDEX = 1,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_QUALIFIER = 2,
	__ETHTOOL_A_TS_HWTSTAMP_PROVIDER_CNT = 3,
	ETHTOOL_A_TS_HWTSTAMP_PROVIDER_MAX = 2,
};

enum {
	ETHTOOL_A_TS_STAT_UNSPEC = 0,
	ETHTOOL_A_TS_STAT_TX_PKTS = 1,
	ETHTOOL_A_TS_STAT_TX_LOST = 2,
	ETHTOOL_A_TS_STAT_TX_ERR = 3,
	ETHTOOL_A_TS_STAT_TX_ONESTEP_PKTS_UNCONFIRMED = 4,
	__ETHTOOL_A_TS_STAT_CNT = 5,
	ETHTOOL_A_TS_STAT_MAX = 4,
};

enum {
	ETHTOOL_A_TUNNEL_INFO_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_INFO_HEADER = 1,
	ETHTOOL_A_TUNNEL_INFO_UDP_PORTS = 2,
	__ETHTOOL_A_TUNNEL_INFO_CNT = 3,
	ETHTOOL_A_TUNNEL_INFO_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_ENTRY_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_PORT = 1,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_TYPE = 2,
	__ETHTOOL_A_TUNNEL_UDP_ENTRY_CNT = 3,
	ETHTOOL_A_TUNNEL_UDP_ENTRY_MAX = 2,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_TABLE_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE_SIZE = 1,
	ETHTOOL_A_TUNNEL_UDP_TABLE_TYPES = 2,
	ETHTOOL_A_TUNNEL_UDP_TABLE_ENTRY = 3,
	__ETHTOOL_A_TUNNEL_UDP_TABLE_CNT = 4,
	ETHTOOL_A_TUNNEL_UDP_TABLE_MAX = 3,
};

enum {
	ETHTOOL_A_TUNNEL_UDP_UNSPEC = 0,
	ETHTOOL_A_TUNNEL_UDP_TABLE = 1,
	__ETHTOOL_A_TUNNEL_UDP_CNT = 2,
	ETHTOOL_A_TUNNEL_UDP_MAX = 1,
};

enum {
	ETHTOOL_A_WOL_UNSPEC = 0,
	ETHTOOL_A_WOL_HEADER = 1,
	ETHTOOL_A_WOL_MODES = 2,
	ETHTOOL_A_WOL_SOPASS = 3,
	__ETHTOOL_A_WOL_CNT = 4,
	ETHTOOL_A_WOL_MAX = 3,
};

enum {
	ETHTOOL_MSG_KERNEL_NONE = 0,
	ETHTOOL_MSG_STRSET_GET_REPLY = 1,
	ETHTOOL_MSG_LINKINFO_GET_REPLY = 2,
	ETHTOOL_MSG_LINKINFO_NTF = 3,
	ETHTOOL_MSG_LINKMODES_GET_REPLY = 4,
	ETHTOOL_MSG_LINKMODES_NTF = 5,
	ETHTOOL_MSG_LINKSTATE_GET_REPLY = 6,
	ETHTOOL_MSG_DEBUG_GET_REPLY = 7,
	ETHTOOL_MSG_DEBUG_NTF = 8,
	ETHTOOL_MSG_WOL_GET_REPLY = 9,
	ETHTOOL_MSG_WOL_NTF = 10,
	ETHTOOL_MSG_FEATURES_GET_REPLY = 11,
	ETHTOOL_MSG_FEATURES_SET_REPLY = 12,
	ETHTOOL_MSG_FEATURES_NTF = 13,
	ETHTOOL_MSG_PRIVFLAGS_GET_REPLY = 14,
	ETHTOOL_MSG_PRIVFLAGS_NTF = 15,
	ETHTOOL_MSG_RINGS_GET_REPLY = 16,
	ETHTOOL_MSG_RINGS_NTF = 17,
	ETHTOOL_MSG_CHANNELS_GET_REPLY = 18,
	ETHTOOL_MSG_CHANNELS_NTF = 19,
	ETHTOOL_MSG_COALESCE_GET_REPLY = 20,
	ETHTOOL_MSG_COALESCE_NTF = 21,
	ETHTOOL_MSG_PAUSE_GET_REPLY = 22,
	ETHTOOL_MSG_PAUSE_NTF = 23,
	ETHTOOL_MSG_EEE_GET_REPLY = 24,
	ETHTOOL_MSG_EEE_NTF = 25,
	ETHTOOL_MSG_TSINFO_GET_REPLY = 26,
	ETHTOOL_MSG_CABLE_TEST_NTF = 27,
	ETHTOOL_MSG_CABLE_TEST_TDR_NTF = 28,
	ETHTOOL_MSG_TUNNEL_INFO_GET_REPLY = 29,
	ETHTOOL_MSG_FEC_GET_REPLY = 30,
	ETHTOOL_MSG_FEC_NTF = 31,
	ETHTOOL_MSG_MODULE_EEPROM_GET_REPLY = 32,
	ETHTOOL_MSG_STATS_GET_REPLY = 33,
	ETHTOOL_MSG_PHC_VCLOCKS_GET_REPLY = 34,
	ETHTOOL_MSG_MODULE_GET_REPLY = 35,
	ETHTOOL_MSG_MODULE_NTF = 36,
	ETHTOOL_MSG_PSE_GET_REPLY = 37,
	ETHTOOL_MSG_RSS_GET_REPLY = 38,
	ETHTOOL_MSG_PLCA_GET_CFG_REPLY = 39,
	ETHTOOL_MSG_PLCA_GET_STATUS_REPLY = 40,
	ETHTOOL_MSG_PLCA_NTF = 41,
	ETHTOOL_MSG_MM_GET_REPLY = 42,
	ETHTOOL_MSG_MM_NTF = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_NTF = 44,
	ETHTOOL_MSG_PHY_GET_REPLY = 45,
	ETHTOOL_MSG_PHY_NTF = 46,
	ETHTOOL_MSG_TSCONFIG_GET_REPLY = 47,
	ETHTOOL_MSG_TSCONFIG_SET_REPLY = 48,
	__ETHTOOL_MSG_KERNEL_CNT = 49,
	ETHTOOL_MSG_KERNEL_MAX = 48,
};

enum {
	ETHTOOL_MSG_USER_NONE = 0,
	ETHTOOL_MSG_STRSET_GET = 1,
	ETHTOOL_MSG_LINKINFO_GET = 2,
	ETHTOOL_MSG_LINKINFO_SET = 3,
	ETHTOOL_MSG_LINKMODES_GET = 4,
	ETHTOOL_MSG_LINKMODES_SET = 5,
	ETHTOOL_MSG_LINKSTATE_GET = 6,
	ETHTOOL_MSG_DEBUG_GET = 7,
	ETHTOOL_MSG_DEBUG_SET = 8,
	ETHTOOL_MSG_WOL_GET = 9,
	ETHTOOL_MSG_WOL_SET = 10,
	ETHTOOL_MSG_FEATURES_GET = 11,
	ETHTOOL_MSG_FEATURES_SET = 12,
	ETHTOOL_MSG_PRIVFLAGS_GET = 13,
	ETHTOOL_MSG_PRIVFLAGS_SET = 14,
	ETHTOOL_MSG_RINGS_GET = 15,
	ETHTOOL_MSG_RINGS_SET = 16,
	ETHTOOL_MSG_CHANNELS_GET = 17,
	ETHTOOL_MSG_CHANNELS_SET = 18,
	ETHTOOL_MSG_COALESCE_GET = 19,
	ETHTOOL_MSG_COALESCE_SET = 20,
	ETHTOOL_MSG_PAUSE_GET = 21,
	ETHTOOL_MSG_PAUSE_SET = 22,
	ETHTOOL_MSG_EEE_GET = 23,
	ETHTOOL_MSG_EEE_SET = 24,
	ETHTOOL_MSG_TSINFO_GET = 25,
	ETHTOOL_MSG_CABLE_TEST_ACT = 26,
	ETHTOOL_MSG_CABLE_TEST_TDR_ACT = 27,
	ETHTOOL_MSG_TUNNEL_INFO_GET = 28,
	ETHTOOL_MSG_FEC_GET = 29,
	ETHTOOL_MSG_FEC_SET = 30,
	ETHTOOL_MSG_MODULE_EEPROM_GET = 31,
	ETHTOOL_MSG_STATS_GET = 32,
	ETHTOOL_MSG_PHC_VCLOCKS_GET = 33,
	ETHTOOL_MSG_MODULE_GET = 34,
	ETHTOOL_MSG_MODULE_SET = 35,
	ETHTOOL_MSG_PSE_GET = 36,
	ETHTOOL_MSG_PSE_SET = 37,
	ETHTOOL_MSG_RSS_GET = 38,
	ETHTOOL_MSG_PLCA_GET_CFG = 39,
	ETHTOOL_MSG_PLCA_SET_CFG = 40,
	ETHTOOL_MSG_PLCA_GET_STATUS = 41,
	ETHTOOL_MSG_MM_GET = 42,
	ETHTOOL_MSG_MM_SET = 43,
	ETHTOOL_MSG_MODULE_FW_FLASH_ACT = 44,
	ETHTOOL_MSG_PHY_GET = 45,
	ETHTOOL_MSG_TSCONFIG_GET = 46,
	ETHTOOL_MSG_TSCONFIG_SET = 47,
	__ETHTOOL_MSG_USER_CNT = 48,
	ETHTOOL_MSG_USER_MAX = 47,
};

enum {
	ETHTOOL_STATS_ETH_PHY = 0,
	ETHTOOL_STATS_ETH_MAC = 1,
	ETHTOOL_STATS_ETH_CTRL = 2,
	ETHTOOL_STATS_RMON = 3,
	ETHTOOL_STATS_PHY = 4,
	__ETHTOOL_STATS_CNT = 5,
};

enum {
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN = 0,
	ETHTOOL_UDP_TUNNEL_TYPE_GENEVE = 1,
	ETHTOOL_UDP_TUNNEL_TYPE_VXLAN_GPE = 2,
	__ETHTOOL_UDP_TUNNEL_TYPE_CNT = 3,
	ETHTOOL_UDP_TUNNEL_TYPE_MAX = 2,
};

enum {
	ETH_RSS_HASH_TOP_BIT = 0,
	ETH_RSS_HASH_XOR_BIT = 1,
	ETH_RSS_HASH_CRC32_BIT = 2,
	ETH_RSS_HASH_FUNCS_COUNT = 3,
};

enum {
	EVENT_CMD_COMPLETE = 0,
	EVENT_XFER_COMPLETE = 1,
	EVENT_DATA_COMPLETE = 2,
	EVENT_DATA_ERROR = 3,
};

enum {
	EVENT_FILE_FL_ENABLED_BIT = 0,
	EVENT_FILE_FL_RECORDED_CMD_BIT = 1,
	EVENT_FILE_FL_RECORDED_TGID_BIT = 2,
	EVENT_FILE_FL_FILTERED_BIT = 3,
	EVENT_FILE_FL_NO_SET_FILTER_BIT = 4,
	EVENT_FILE_FL_SOFT_MODE_BIT = 5,
	EVENT_FILE_FL_SOFT_DISABLED_BIT = 6,
	EVENT_FILE_FL_TRIGGER_MODE_BIT = 7,
	EVENT_FILE_FL_TRIGGER_COND_BIT = 8,
	EVENT_FILE_FL_PID_FILTER_BIT = 9,
	EVENT_FILE_FL_WAS_ENABLED_BIT = 10,
	EVENT_FILE_FL_FREED_BIT = 11,
};

enum {
	EV_NO_EVENT = 0,
	EV_HPD_PLUG_INT = 1,
	EV_IRQ_HPD_INT = 2,
	EV_HPD_UNPLUG_INT = 3,
	EV_USER_NOTIFICATION = 4,
};

enum {
	EXT4_FC_REASON_XATTR = 0,
	EXT4_FC_REASON_CROSS_RENAME = 1,
	EXT4_FC_REASON_JOURNAL_FLAG_CHANGE = 2,
	EXT4_FC_REASON_NOMEM = 3,
	EXT4_FC_REASON_SWAP_BOOT = 4,
	EXT4_FC_REASON_RESIZE = 5,
	EXT4_FC_REASON_RENAME_DIR = 6,
	EXT4_FC_REASON_FALLOC_RANGE = 7,
	EXT4_FC_REASON_INODE_JOURNAL_DATA = 8,
	EXT4_FC_REASON_ENCRYPTED_FILENAME = 9,
	EXT4_FC_REASON_MAX = 10,
};

enum {
	EXT4_FC_STATUS_OK = 0,
	EXT4_FC_STATUS_INELIGIBLE = 1,
	EXT4_FC_STATUS_SKIPPED = 2,
	EXT4_FC_STATUS_FAILED = 3,
};

enum {
	EXT4_FLAGS_RESIZING = 0,
	EXT4_FLAGS_SHUTDOWN = 1,
	EXT4_FLAGS_BDEV_IS_DAX = 2,
	EXT4_FLAGS_EMERGENCY_RO = 3,
};

enum {
	EXT4_INODE_SECRM = 0,
	EXT4_INODE_UNRM = 1,
	EXT4_INODE_COMPR = 2,
	EXT4_INODE_SYNC = 3,
	EXT4_INODE_IMMUTABLE = 4,
	EXT4_INODE_APPEND = 5,
	EXT4_INODE_NODUMP = 6,
	EXT4_INODE_NOATIME = 7,
	EXT4_INODE_DIRTY = 8,
	EXT4_INODE_COMPRBLK = 9,
	EXT4_INODE_NOCOMPR = 10,
	EXT4_INODE_ENCRYPT = 11,
	EXT4_INODE_INDEX = 12,
	EXT4_INODE_IMAGIC = 13,
	EXT4_INODE_JOURNAL_DATA = 14,
	EXT4_INODE_NOTAIL = 15,
	EXT4_INODE_DIRSYNC = 16,
	EXT4_INODE_TOPDIR = 17,
	EXT4_INODE_HUGE_FILE = 18,
	EXT4_INODE_EXTENTS = 19,
	EXT4_INODE_VERITY = 20,
	EXT4_INODE_EA_INODE = 21,
	EXT4_INODE_DAX = 25,
	EXT4_INODE_INLINE_DATA = 28,
	EXT4_INODE_PROJINHERIT = 29,
	EXT4_INODE_CASEFOLD = 30,
	EXT4_INODE_RESERVED = 31,
};

enum {
	EXT4_MF_MNTDIR_SAMPLED = 0,
	EXT4_MF_FC_INELIGIBLE = 1,
	EXT4_MF_JOURNAL_DESTROY = 2,
};

enum {
	EXT4_STATE_NEW = 0,
	EXT4_STATE_XATTR = 1,
	EXT4_STATE_NO_EXPAND = 2,
	EXT4_STATE_DA_ALLOC_CLOSE = 3,
	EXT4_STATE_EXT_MIGRATE = 4,
	EXT4_STATE_NEWENTRY = 5,
	EXT4_STATE_MAY_INLINE_DATA = 6,
	EXT4_STATE_EXT_PRECACHED = 7,
	EXT4_STATE_LUSTRE_EA_INODE = 8,
	EXT4_STATE_VERITY_IN_PROGRESS = 9,
	EXT4_STATE_FC_COMMITTING = 10,
	EXT4_STATE_FC_FLUSHING_DATA = 11,
	EXT4_STATE_ORPHAN_FILE = 12,
};

enum {
	EXTENT_BUFFER_UPTODATE = 0,
	EXTENT_BUFFER_DIRTY = 1,
	EXTENT_BUFFER_TREE_REF = 2,
	EXTENT_BUFFER_STALE = 3,
	EXTENT_BUFFER_WRITEBACK = 4,
	EXTENT_BUFFER_UNMAPPED = 5,
	EXTENT_BUFFER_WRITE_ERR = 6,
	EXTENT_BUFFER_ZONED_ZEROOUT = 7,
	EXTENT_BUFFER_READING = 8,
};

enum {
	EXYNOS_ASV_SUBSYS_ID_ARM = 0,
	EXYNOS_ASV_SUBSYS_ID_KFC = 1,
	EXYNOS_ASV_SUBSYS_ID_MAX = 2,
};

enum {
	F2FS_GET_BLOCK_DEFAULT = 0,
	F2FS_GET_BLOCK_FIEMAP = 1,
	F2FS_GET_BLOCK_BMAP = 2,
	F2FS_GET_BLOCK_DIO = 3,
	F2FS_GET_BLOCK_PRE_DIO = 4,
	F2FS_GET_BLOCK_PRE_AIO = 5,
	F2FS_GET_BLOCK_PRECACHE = 6,
};

enum {
	F2FS_IOPRIO_WRITE = 1,
	F2FS_IOPRIO_MAX = 2,
};

enum {
	F2FS_IPU_FORCE = 0,
	F2FS_IPU_SSR = 1,
	F2FS_IPU_UTIL = 2,
	F2FS_IPU_SSR_UTIL = 3,
	F2FS_IPU_FSYNC = 4,
	F2FS_IPU_ASYNC = 5,
	F2FS_IPU_NOCACHE = 6,
	F2FS_IPU_HONOR_OPU_WRITE = 7,
	F2FS_IPU_MAX = 8,
};

enum {
	FAILURE_BAD_HOST = 1,
	FAILURE_SESSION_FAILED = 2,
	FAILURE_SESSION_FREED = 3,
	FAILURE_WINDOW_CLOSED = 4,
	FAILURE_OOM = 5,
	FAILURE_SESSION_TERMINATE = 6,
	FAILURE_SESSION_IN_RECOVERY = 7,
	FAILURE_SESSION_RECOVERY_TIMEOUT = 8,
	FAILURE_SESSION_LOGGING_OUT = 9,
	FAILURE_SESSION_NOT_READY = 10,
};

enum {
	FAN53526_CHIP_ID_01 = 1,
};

enum {
	FAN53526_CHIP_REV_08 = 8,
};

enum {
	FAN53555_CHIP_ID_00 = 0,
	FAN53555_CHIP_ID_01 = 1,
	FAN53555_CHIP_ID_02 = 2,
	FAN53555_CHIP_ID_03 = 3,
	FAN53555_CHIP_ID_04 = 4,
	FAN53555_CHIP_ID_05 = 5,
	FAN53555_CHIP_ID_08 = 8,
};

enum {
	FAN53555_CHIP_REV_00 = 3,
	FAN53555_CHIP_REV_13 = 15,
};

enum {
	FAN53555_VSEL_ID_0 = 0,
	FAN53555_VSEL_ID_1 = 1,
};

enum {
	FAN_EVENT_INIT = 0,
	FAN_EVENT_REPORTED = 1,
	FAN_EVENT_ANSWERED = 2,
	FAN_EVENT_CANCELED = 3,
};

enum {
	FATTR4_CLONE_BLKSIZE = 77,
	FATTR4_SPACE_FREED = 78,
	FATTR4_CHANGE_ATTR_TYPE = 79,
	FATTR4_SEC_LABEL = 80,
};

enum {
	FATTR4_DIR_NOTIF_DELAY = 56,
	FATTR4_DIRENT_NOTIF_DELAY = 57,
	FATTR4_DACL = 58,
	FATTR4_SACL = 59,
	FATTR4_CHANGE_POLICY = 60,
	FATTR4_FS_STATUS = 61,
	FATTR4_FS_LAYOUT_TYPES = 62,
	FATTR4_LAYOUT_HINT = 63,
	FATTR4_LAYOUT_TYPES = 64,
	FATTR4_LAYOUT_BLKSIZE = 65,
	FATTR4_LAYOUT_ALIGNMENT = 66,
	FATTR4_FS_LOCATIONS_INFO = 67,
	FATTR4_MDSTHRESHOLD = 68,
	FATTR4_RETENTION_GET = 69,
	FATTR4_RETENTION_SET = 70,
	FATTR4_RETENTEVT_GET = 71,
	FATTR4_RETENTEVT_SET = 72,
	FATTR4_RETENTION_HOLD = 73,
	FATTR4_MODE_SET_MASKED = 74,
	FATTR4_SUPPATTR_EXCLCREAT = 75,
	FATTR4_FS_CHARSET_CAP = 76,
};

enum {
	FATTR4_MODE_UMASK = 81,
};

enum {
	FATTR4_OPEN_ARGUMENTS = 86,
};

enum {
	FATTR4_SUPPORTED_ATTRS = 0,
	FATTR4_TYPE = 1,
	FATTR4_FH_EXPIRE_TYPE = 2,
	FATTR4_CHANGE = 3,
	FATTR4_SIZE = 4,
	FATTR4_LINK_SUPPORT = 5,
	FATTR4_SYMLINK_SUPPORT = 6,
	FATTR4_NAMED_ATTR = 7,
	FATTR4_FSID = 8,
	FATTR4_UNIQUE_HANDLES = 9,
	FATTR4_LEASE_TIME = 10,
	FATTR4_RDATTR_ERROR = 11,
	FATTR4_ACL = 12,
	FATTR4_ACLSUPPORT = 13,
	FATTR4_ARCHIVE = 14,
	FATTR4_CANSETTIME = 15,
	FATTR4_CASE_INSENSITIVE = 16,
	FATTR4_CASE_PRESERVING = 17,
	FATTR4_CHOWN_RESTRICTED = 18,
	FATTR4_FILEHANDLE = 19,
	FATTR4_FILEID = 20,
	FATTR4_FILES_AVAIL = 21,
	FATTR4_FILES_FREE = 22,
	FATTR4_FILES_TOTAL = 23,
	FATTR4_FS_LOCATIONS = 24,
	FATTR4_HIDDEN = 25,
	FATTR4_HOMOGENEOUS = 26,
	FATTR4_MAXFILESIZE = 27,
	FATTR4_MAXLINK = 28,
	FATTR4_MAXNAME = 29,
	FATTR4_MAXREAD = 30,
	FATTR4_MAXWRITE = 31,
	FATTR4_MIMETYPE = 32,
	FATTR4_MODE = 33,
	FATTR4_NO_TRUNC = 34,
	FATTR4_NUMLINKS = 35,
	FATTR4_OWNER = 36,
	FATTR4_OWNER_GROUP = 37,
	FATTR4_QUOTA_AVAIL_HARD = 38,
	FATTR4_QUOTA_AVAIL_SOFT = 39,
	FATTR4_QUOTA_USED = 40,
	FATTR4_RAWDEV = 41,
	FATTR4_SPACE_AVAIL = 42,
	FATTR4_SPACE_FREE = 43,
	FATTR4_SPACE_TOTAL = 44,
	FATTR4_SPACE_USED = 45,
	FATTR4_SYSTEM = 46,
	FATTR4_TIME_ACCESS = 47,
	FATTR4_TIME_ACCESS_SET = 48,
	FATTR4_TIME_BACKUP = 49,
	FATTR4_TIME_CREATE = 50,
	FATTR4_TIME_DELTA = 51,
	FATTR4_TIME_METADATA = 52,
	FATTR4_TIME_MODIFY = 53,
	FATTR4_TIME_MODIFY_SET = 54,
	FATTR4_MOUNTED_ON_FILEID = 55,
};

enum {
	FATTR4_TIME_DELEG_ACCESS = 84,
};

enum {
	FATTR4_TIME_DELEG_MODIFY = 85,
};

enum {
	FATTR4_XATTR_SUPPORT = 82,
};

enum {
	FAULT_KMALLOC = 0,
	FAULT_KVMALLOC = 1,
	FAULT_PAGE_ALLOC = 2,
	FAULT_PAGE_GET = 3,
	FAULT_ALLOC_BIO = 4,
	FAULT_ALLOC_NID = 5,
	FAULT_ORPHAN = 6,
	FAULT_BLOCK = 7,
	FAULT_DIR_DEPTH = 8,
	FAULT_EVICT_INODE = 9,
	FAULT_TRUNCATE = 10,
	FAULT_READ_IO = 11,
	FAULT_CHECKPOINT = 12,
	FAULT_DISCARD = 13,
	FAULT_WRITE_IO = 14,
	FAULT_SLAB_ALLOC = 15,
	FAULT_DQUOT_INIT = 16,
	FAULT_LOCK_OP = 17,
	FAULT_BLKADDR_VALIDITY = 18,
	FAULT_BLKADDR_CONSISTENCE = 19,
	FAULT_NO_SEGMENT = 20,
	FAULT_INCONSISTENT_FOOTER = 21,
	FAULT_TIMEOUT = 22,
	FAULT_VMALLOC = 23,
	FAULT_MAX = 24,
};

enum {
	FBCON_LOGO_CANSHOW = -1,
	FBCON_LOGO_DRAW = -2,
	FBCON_LOGO_DONTSHOW = -3,
};

enum {
	FB_BLANK_UNBLANK = 0,
	FB_BLANK_NORMAL = 1,
	FB_BLANK_VSYNC_SUSPEND = 2,
	FB_BLANK_HSYNC_SUSPEND = 3,
	FB_BLANK_POWERDOWN = 4,
};

enum {
	FIB6_NO_SERNUM_CHANGE = 0,
};

enum {
	FILEID_HIGH_OFF = 0,
	FILEID_LOW_OFF = 1,
	FILE_I_TYPE_OFF = 2,
	EMBED_FH_OFF = 3,
};

enum {
	FIMD_PORT_IN0 = 0,
	FIMD_PORT_IN1 = 1,
	FIMD_PORT_IN2 = 2,
	FIMD_PORT_RGB = 3,
	FIMD_PORT_WRB = 4,
};

enum {
	FI_NEW_INODE = 0,
	FI_DIRTY_INODE = 1,
	FI_AUTO_RECOVER = 2,
	FI_DIRTY_DIR = 3,
	FI_INC_LINK = 4,
	FI_ACL_MODE = 5,
	FI_NO_ALLOC = 6,
	FI_FREE_NID = 7,
	FI_NO_EXTENT = 8,
	FI_INLINE_XATTR = 9,
	FI_INLINE_DATA = 10,
	FI_INLINE_DENTRY = 11,
	FI_APPEND_WRITE = 12,
	FI_UPDATE_WRITE = 13,
	FI_NEED_IPU = 14,
	FI_ATOMIC_FILE = 15,
	FI_DATA_EXIST = 16,
	FI_SKIP_WRITES = 17,
	FI_OPU_WRITE = 18,
	FI_DIRTY_FILE = 19,
	FI_PREALLOCATED_ALL = 20,
	FI_HOT_DATA = 21,
	FI_EXTRA_ATTR = 22,
	FI_PROJ_INHERIT = 23,
	FI_PIN_FILE = 24,
	FI_VERITY_IN_PROGRESS = 25,
	FI_COMPRESSED_FILE = 26,
	FI_COMPRESS_CORRUPT = 27,
	FI_MMAP_FILE = 28,
	FI_ENABLE_COMPRESS = 29,
	FI_COMPRESS_RELEASED = 30,
	FI_ALIGNED_WRITE = 31,
	FI_COW_FILE = 32,
	FI_ATOMIC_COMMITTED = 33,
	FI_ATOMIC_DIRTIED = 34,
	FI_ATOMIC_REPLACE = 35,
	FI_OPENED_FILE = 36,
	FI_DONATE_FINISHED = 37,
	FI_MAX = 38,
};

enum {
	FOLL_TOUCH = 65536,
	FOLL_TRIED = 131072,
	FOLL_REMOTE = 262144,
	FOLL_PIN = 524288,
	FOLL_FAST_ONLY = 1048576,
	FOLL_UNLOCKABLE = 2097152,
	FOLL_MADV_POPULATE = 4194304,
};

enum {
	FOLL_WRITE = 1,
	FOLL_GET = 2,
	FOLL_DUMP = 4,
	FOLL_FORCE = 8,
	FOLL_NOWAIT = 16,
	FOLL_NOFAULT = 32,
	FOLL_HWPOISON = 64,
	FOLL_ANON = 128,
	FOLL_LONGTERM = 256,
	FOLL_SPLIT_PMD = 512,
	FOLL_PCI_P2PDMA = 1024,
	FOLL_INTERRUPTIBLE = 2048,
	FOLL_HONOR_NUMA_FAULT = 4096,
};

enum {
	FRA_UNSPEC = 0,
	FRA_DST = 1,
	FRA_SRC = 2,
	FRA_IIFNAME = 3,
	FRA_GOTO = 4,
	FRA_UNUSED2 = 5,
	FRA_PRIORITY = 6,
	FRA_UNUSED3 = 7,
	FRA_UNUSED4 = 8,
	FRA_UNUSED5 = 9,
	FRA_FWMARK = 10,
	FRA_FLOW = 11,
	FRA_TUN_ID = 12,
	FRA_SUPPRESS_IFGROUP = 13,
	FRA_SUPPRESS_PREFIXLEN = 14,
	FRA_TABLE = 15,
	FRA_FWMASK = 16,
	FRA_OIFNAME = 17,
	FRA_PAD = 18,
	FRA_L3MDEV = 19,
	FRA_UID_RANGE = 20,
	FRA_PROTOCOL = 21,
	FRA_IP_PROTO = 22,
	FRA_SPORT_RANGE = 23,
	FRA_DPORT_RANGE = 24,
	FRA_DSCP = 25,
	FRA_FLOWLABEL = 26,
	FRA_FLOWLABEL_MASK = 27,
	FRA_SPORT_MASK = 28,
	FRA_DPORT_MASK = 29,
	FRA_DSCP_MASK = 30,
	__FRA_MAX = 31,
};

enum {
	FR_ACT_UNSPEC = 0,
	FR_ACT_TO_TBL = 1,
	FR_ACT_GOTO = 2,
	FR_ACT_NOP = 3,
	FR_ACT_RES3 = 4,
	FR_ACT_RES4 = 5,
	FR_ACT_BLACKHOLE = 6,
	FR_ACT_UNREACHABLE = 7,
	FR_ACT_PROHIBIT = 8,
	__FR_ACT_MAX = 9,
};

enum {
	FS_MODE_ADAPTIVE = 0,
	FS_MODE_LFS = 1,
	FS_MODE_FRAGMENT_SEG = 2,
	FS_MODE_FRAGMENT_BLK = 3,
};

enum {
	FUTEX_STATE_OK = 0,
	FUTEX_STATE_EXITING = 1,
	FUTEX_STATE_DEAD = 2,
};

enum {
	FW_DO_IDLE_SLEEP = 0,
	FW_DO_IDLE_AFTR = 1,
};

enum {
	GC_CB = 0,
	GC_GREEDY = 1,
	GC_AT = 2,
	ALLOC_NEXT = 3,
	FLUSH_DEVICE = 4,
	MAX_GC_POLICY = 5,
};

enum {
	GC_NORMAL = 0,
	GC_IDLE_CB = 1,
	GC_IDLE_GREEDY = 2,
	GC_IDLE_AT = 3,
	GC_URGENT_HIGH = 4,
	GC_URGENT_LOW = 5,
	GC_URGENT_MID = 6,
	MAX_GC_MODE = 7,
};

enum {
	GC_THREAD = 0,
	SM_INFO = 1,
	DCC_INFO = 2,
	NM_INFO = 3,
	F2FS_SBI = 4,
	STAT_INFO = 5,
	RESERVED_BLOCKS = 6,
	CPRC_INFO = 7,
	ATGC_INFO = 8,
};

enum {
	GENHD_FL_REMOVABLE = 1,
	GENHD_FL_HIDDEN = 2,
	GENHD_FL_NO_PART = 4,
};

enum {
	GP_IDLE = 0,
	GP_ENTER = 1,
	GP_PASSED = 2,
	GP_EXIT = 3,
	GP_REPLAY = 4,
};

enum {
	HANDSHAKE_A_ACCEPT_SOCKFD = 1,
	HANDSHAKE_A_ACCEPT_HANDLER_CLASS = 2,
	HANDSHAKE_A_ACCEPT_MESSAGE_TYPE = 3,
	HANDSHAKE_A_ACCEPT_TIMEOUT = 4,
	HANDSHAKE_A_ACCEPT_AUTH_MODE = 5,
	HANDSHAKE_A_ACCEPT_PEER_IDENTITY = 6,
	HANDSHAKE_A_ACCEPT_CERTIFICATE = 7,
	HANDSHAKE_A_ACCEPT_PEERNAME = 8,
	__HANDSHAKE_A_ACCEPT_MAX = 9,
	HANDSHAKE_A_ACCEPT_MAX = 8,
};

enum {
	HANDSHAKE_A_DONE_STATUS = 1,
	HANDSHAKE_A_DONE_SOCKFD = 2,
	HANDSHAKE_A_DONE_REMOTE_AUTH = 3,
	__HANDSHAKE_A_DONE_MAX = 4,
	HANDSHAKE_A_DONE_MAX = 3,
};

enum {
	HANDSHAKE_A_X509_CERT = 1,
	HANDSHAKE_A_X509_PRIVKEY = 2,
	__HANDSHAKE_A_X509_MAX = 3,
	HANDSHAKE_A_X509_MAX = 2,
};

enum {
	HANDSHAKE_CMD_READY = 1,
	HANDSHAKE_CMD_ACCEPT = 2,
	HANDSHAKE_CMD_DONE = 3,
	__HANDSHAKE_CMD_MAX = 4,
	HANDSHAKE_CMD_MAX = 3,
};

enum {
	HANDSHAKE_NLGRP_NONE = 0,
	HANDSHAKE_NLGRP_TLSHD = 1,
};

enum {
	HASH_SIZE = 128,
};

enum {
	HAS_READ = 1,
	HAS_WRITE = 2,
	HAS_LSEEK = 4,
	HAS_POLL = 8,
	HAS_IOCTL = 16,
};

enum {
	HDMI_PRODUCT_ID0_HDMI_TX = 160,
	HDMI_PRODUCT_ID1_HDCP = 192,
	HDMI_PRODUCT_ID1_HDMI_RX = 2,
	HDMI_PRODUCT_ID1_HDMI_TX = 1,
	HDMI_CONFIG0_I2S = 16,
	HDMI_CONFIG0_CEC = 2,
	HDMI_CONFIG1_AHB = 1,
	HDMI_CONFIG3_AHBAUDDMA = 2,
	HDMI_CONFIG3_GPAUD = 1,
	HDMI_IH_FC_INT2_OVERFLOW_MASK = 3,
	HDMI_IH_FC_INT2_LOW_PRIORITY_OVERFLOW = 2,
	HDMI_IH_FC_INT2_HIGH_PRIORITY_OVERFLOW = 1,
	HDMI_IH_FC_STAT2_OVERFLOW_MASK = 3,
	HDMI_IH_FC_STAT2_LOW_PRIORITY_OVERFLOW = 2,
	HDMI_IH_FC_STAT2_HIGH_PRIORITY_OVERFLOW = 1,
	HDMI_IH_PHY_STAT0_RX_SENSE3 = 32,
	HDMI_IH_PHY_STAT0_RX_SENSE2 = 16,
	HDMI_IH_PHY_STAT0_RX_SENSE1 = 8,
	HDMI_IH_PHY_STAT0_RX_SENSE0 = 4,
	HDMI_IH_PHY_STAT0_TX_PHY_LOCK = 2,
	HDMI_IH_PHY_STAT0_HPD = 1,
	HDMI_IH_I2CM_STAT0_DONE = 2,
	HDMI_IH_I2CM_STAT0_ERROR = 1,
	HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYDONE = 2,
	HDMI_IH_MUTE_I2CMPHY_STAT0_I2CMPHYERROR = 1,
	HDMI_IH_AHBDMAAUD_STAT0_ERROR = 32,
	HDMI_IH_AHBDMAAUD_STAT0_LOST = 16,
	HDMI_IH_AHBDMAAUD_STAT0_RETRY = 8,
	HDMI_IH_AHBDMAAUD_STAT0_DONE = 4,
	HDMI_IH_AHBDMAAUD_STAT0_BUFFFULL = 2,
	HDMI_IH_AHBDMAAUD_STAT0_BUFFEMPTY = 1,
	HDMI_IH_MUTE_FC_STAT2_OVERFLOW_MASK = 3,
	HDMI_IH_MUTE_FC_STAT2_LOW_PRIORITY_OVERFLOW = 2,
	HDMI_IH_MUTE_FC_STAT2_HIGH_PRIORITY_OVERFLOW = 1,
	HDMI_IH_MUTE_AHBDMAAUD_STAT0_ERROR = 32,
	HDMI_IH_MUTE_AHBDMAAUD_STAT0_LOST = 16,
	HDMI_IH_MUTE_AHBDMAAUD_STAT0_RETRY = 8,
	HDMI_IH_MUTE_AHBDMAAUD_STAT0_DONE = 4,
	HDMI_IH_MUTE_AHBDMAAUD_STAT0_BUFFFULL = 2,
	HDMI_IH_MUTE_AHBDMAAUD_STAT0_BUFFEMPTY = 1,
	HDMI_IH_MUTE_MUTE_WAKEUP_INTERRUPT = 2,
	HDMI_IH_MUTE_MUTE_ALL_INTERRUPT = 1,
	HDMI_TX_INVID0_INTERNAL_DE_GENERATOR_MASK = 128,
	HDMI_TX_INVID0_INTERNAL_DE_GENERATOR_ENABLE = 128,
	HDMI_TX_INVID0_INTERNAL_DE_GENERATOR_DISABLE = 0,
	HDMI_TX_INVID0_VIDEO_MAPPING_MASK = 31,
	HDMI_TX_INVID0_VIDEO_MAPPING_OFFSET = 0,
	HDMI_TX_INSTUFFING_BDBDATA_STUFFING_MASK = 4,
	HDMI_TX_INSTUFFING_BDBDATA_STUFFING_ENABLE = 4,
	HDMI_TX_INSTUFFING_BDBDATA_STUFFING_DISABLE = 0,
	HDMI_TX_INSTUFFING_RCRDATA_STUFFING_MASK = 2,
	HDMI_TX_INSTUFFING_RCRDATA_STUFFING_ENABLE = 2,
	HDMI_TX_INSTUFFING_RCRDATA_STUFFING_DISABLE = 0,
	HDMI_TX_INSTUFFING_GYDATA_STUFFING_MASK = 1,
	HDMI_TX_INSTUFFING_GYDATA_STUFFING_ENABLE = 1,
	HDMI_TX_INSTUFFING_GYDATA_STUFFING_DISABLE = 0,
	HDMI_VP_PR_CD_COLOR_DEPTH_MASK = 240,
	HDMI_VP_PR_CD_COLOR_DEPTH_OFFSET = 4,
	HDMI_VP_PR_CD_DESIRED_PR_FACTOR_MASK = 15,
	HDMI_VP_PR_CD_DESIRED_PR_FACTOR_OFFSET = 0,
	HDMI_VP_STUFF_IDEFAULT_PHASE_MASK = 32,
	HDMI_VP_STUFF_IDEFAULT_PHASE_OFFSET = 5,
	HDMI_VP_STUFF_IFIX_PP_TO_LAST_MASK = 16,
	HDMI_VP_STUFF_IFIX_PP_TO_LAST_OFFSET = 4,
	HDMI_VP_STUFF_ICX_GOTO_P0_ST_MASK = 8,
	HDMI_VP_STUFF_ICX_GOTO_P0_ST_OFFSET = 3,
	HDMI_VP_STUFF_YCC422_STUFFING_MASK = 4,
	HDMI_VP_STUFF_YCC422_STUFFING_STUFFING_MODE = 4,
	HDMI_VP_STUFF_YCC422_STUFFING_DIRECT_MODE = 0,
	HDMI_VP_STUFF_PP_STUFFING_MASK = 2,
	HDMI_VP_STUFF_PP_STUFFING_STUFFING_MODE = 2,
	HDMI_VP_STUFF_PP_STUFFING_DIRECT_MODE = 0,
	HDMI_VP_STUFF_PR_STUFFING_MASK = 1,
	HDMI_VP_STUFF_PR_STUFFING_STUFFING_MODE = 1,
	HDMI_VP_STUFF_PR_STUFFING_DIRECT_MODE = 0,
	HDMI_VP_CONF_BYPASS_EN_MASK = 64,
	HDMI_VP_CONF_BYPASS_EN_ENABLE = 64,
	HDMI_VP_CONF_BYPASS_EN_DISABLE = 0,
	HDMI_VP_CONF_PP_EN_ENMASK = 32,
	HDMI_VP_CONF_PP_EN_ENABLE = 32,
	HDMI_VP_CONF_PP_EN_DISABLE = 0,
	HDMI_VP_CONF_PR_EN_MASK = 16,
	HDMI_VP_CONF_PR_EN_ENABLE = 16,
	HDMI_VP_CONF_PR_EN_DISABLE = 0,
	HDMI_VP_CONF_YCC422_EN_MASK = 8,
	HDMI_VP_CONF_YCC422_EN_ENABLE = 8,
	HDMI_VP_CONF_YCC422_EN_DISABLE = 0,
	HDMI_VP_CONF_BYPASS_SELECT_MASK = 4,
	HDMI_VP_CONF_BYPASS_SELECT_VID_PACKETIZER = 4,
	HDMI_VP_CONF_BYPASS_SELECT_PIX_REPEATER = 0,
	HDMI_VP_CONF_OUTPUT_SELECTOR_MASK = 3,
	HDMI_VP_CONF_OUTPUT_SELECTOR_BYPASS = 3,
	HDMI_VP_CONF_OUTPUT_SELECTOR_YCC422 = 1,
	HDMI_VP_CONF_OUTPUT_SELECTOR_PP = 0,
	HDMI_VP_REMAP_MASK = 3,
	HDMI_VP_REMAP_YCC422_24bit = 2,
	HDMI_VP_REMAP_YCC422_20bit = 1,
	HDMI_VP_REMAP_YCC422_16bit = 0,
	HDMI_FC_INVIDCONF_HDCP_KEEPOUT_MASK = 128,
	HDMI_FC_INVIDCONF_HDCP_KEEPOUT_ACTIVE = 128,
	HDMI_FC_INVIDCONF_HDCP_KEEPOUT_INACTIVE = 0,
	HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY_MASK = 64,
	HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY_ACTIVE_HIGH = 64,
	HDMI_FC_INVIDCONF_VSYNC_IN_POLARITY_ACTIVE_LOW = 0,
	HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY_MASK = 32,
	HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY_ACTIVE_HIGH = 32,
	HDMI_FC_INVIDCONF_HSYNC_IN_POLARITY_ACTIVE_LOW = 0,
	HDMI_FC_INVIDCONF_DE_IN_POLARITY_MASK = 16,
	HDMI_FC_INVIDCONF_DE_IN_POLARITY_ACTIVE_HIGH = 16,
	HDMI_FC_INVIDCONF_DE_IN_POLARITY_ACTIVE_LOW = 0,
	HDMI_FC_INVIDCONF_DVI_MODEZ_MASK = 8,
	HDMI_FC_INVIDCONF_DVI_MODEZ_HDMI_MODE = 8,
	HDMI_FC_INVIDCONF_DVI_MODEZ_DVI_MODE = 0,
	HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC_MASK = 2,
	HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC_ACTIVE_HIGH = 2,
	HDMI_FC_INVIDCONF_R_V_BLANK_IN_OSC_ACTIVE_LOW = 0,
	HDMI_FC_INVIDCONF_IN_I_P_MASK = 1,
	HDMI_FC_INVIDCONF_IN_I_P_INTERLACED = 1,
	HDMI_FC_INVIDCONF_IN_I_P_PROGRESSIVE = 0,
	HDMI_FC_AUDICONF0_CC_OFFSET = 4,
	HDMI_FC_AUDICONF0_CC_MASK = 112,
	HDMI_FC_AUDICONF0_CT_OFFSET = 0,
	HDMI_FC_AUDICONF0_CT_MASK = 15,
	HDMI_FC_AUDICONF1_SS_OFFSET = 3,
	HDMI_FC_AUDICONF1_SS_MASK = 24,
	HDMI_FC_AUDICONF1_SF_OFFSET = 0,
	HDMI_FC_AUDICONF1_SF_MASK = 7,
	HDMI_FC_AUDICONF3_LFEPBL_OFFSET = 5,
	HDMI_FC_AUDICONF3_LFEPBL_MASK = 96,
	HDMI_FC_AUDICONF3_DM_INH_OFFSET = 4,
	HDMI_FC_AUDICONF3_DM_INH_MASK = 16,
	HDMI_FC_AUDICONF3_LSV_OFFSET = 0,
	HDMI_FC_AUDICONF3_LSV_MASK = 15,
	HDMI_FC_AUDSCHNLS0_CGMSA_OFFSET = 4,
	HDMI_FC_AUDSCHNLS0_CGMSA_MASK = 48,
	HDMI_FC_AUDSCHNLS0_COPYRIGHT_OFFSET = 0,
	HDMI_FC_AUDSCHNLS0_COPYRIGHT_MASK = 1,
	HDMI_FC_AUDSCHNLS3_OIEC_CH0_OFFSET = 0,
	HDMI_FC_AUDSCHNLS3_OIEC_CH0_MASK = 15,
	HDMI_FC_AUDSCHNLS3_OIEC_CH1_OFFSET = 4,
	HDMI_FC_AUDSCHNLS3_OIEC_CH1_MASK = 240,
	HDMI_FC_AUDSCHNLS4_OIEC_CH2_OFFSET = 0,
	HDMI_FC_AUDSCHNLS4_OIEC_CH2_MASK = 15,
	HDMI_FC_AUDSCHNLS4_OIEC_CH3_OFFSET = 4,
	HDMI_FC_AUDSCHNLS4_OIEC_CH3_MASK = 240,
	HDMI_FC_AUDSCHNLS5_OIEC_CH0_OFFSET = 0,
	HDMI_FC_AUDSCHNLS5_OIEC_CH0_MASK = 15,
	HDMI_FC_AUDSCHNLS5_OIEC_CH1_OFFSET = 4,
	HDMI_FC_AUDSCHNLS5_OIEC_CH1_MASK = 240,
	HDMI_FC_AUDSCHNLS6_OIEC_CH2_OFFSET = 0,
	HDMI_FC_AUDSCHNLS6_OIEC_CH2_MASK = 15,
	HDMI_FC_AUDSCHNLS6_OIEC_CH3_OFFSET = 4,
	HDMI_FC_AUDSCHNLS6_OIEC_CH3_MASK = 240,
	HDMI_FC_AUDSCHNLS7_ACCURACY_OFFSET = 4,
	HDMI_FC_AUDSCHNLS7_ACCURACY_MASK = 48,
	HDMI_FC_AUDSCHNLS8_ORIGSAMPFREQ_MASK = 240,
	HDMI_FC_AUDSCHNLS8_ORIGSAMPFREQ_OFFSET = 4,
	HDMI_FC_AUDSCHNLS8_WORDLEGNTH_MASK = 15,
	HDMI_FC_AUDSCHNLS8_WORDLEGNTH_OFFSET = 0,
	HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT_MASK = 240,
	HDMI_FC_AUDSCONF_AUD_PACKET_SAMPFIT_OFFSET = 4,
	HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT_MASK = 1,
	HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT_OFFSET = 0,
	HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT_LAYOUT1 = 1,
	HDMI_FC_AUDSCONF_AUD_PACKET_LAYOUT_LAYOUT0 = 0,
	HDMI_FC_STAT2_OVERFLOW_MASK = 3,
	HDMI_FC_STAT2_LOW_PRIORITY_OVERFLOW = 2,
	HDMI_FC_STAT2_HIGH_PRIORITY_OVERFLOW = 1,
	HDMI_FC_INT2_OVERFLOW_MASK = 3,
	HDMI_FC_INT2_LOW_PRIORITY_OVERFLOW = 2,
	HDMI_FC_INT2_HIGH_PRIORITY_OVERFLOW = 1,
	HDMI_FC_MASK2_OVERFLOW_MASK = 3,
	HDMI_FC_MASK2_LOW_PRIORITY_OVERFLOW = 2,
	HDMI_FC_MASK2_HIGH_PRIORITY_OVERFLOW = 1,
	HDMI_FC_PRCONF_INCOMING_PR_FACTOR_MASK = 240,
	HDMI_FC_PRCONF_INCOMING_PR_FACTOR_OFFSET = 4,
	HDMI_FC_PRCONF_OUTPUT_PR_FACTOR_MASK = 15,
	HDMI_FC_PRCONF_OUTPUT_PR_FACTOR_OFFSET = 0,
	HDMI_FC_PACKET_TX_EN_DRM_MASK = 128,
	HDMI_FC_PACKET_TX_EN_DRM_ENABLE = 128,
	HDMI_FC_PACKET_TX_EN_DRM_DISABLE = 0,
	HDMI_FC_AVICONF0_PIX_FMT_MASK = 3,
	HDMI_FC_AVICONF0_PIX_FMT_RGB = 0,
	HDMI_FC_AVICONF0_PIX_FMT_YCBCR422 = 1,
	HDMI_FC_AVICONF0_PIX_FMT_YCBCR444 = 2,
	HDMI_FC_AVICONF0_ACTIVE_FMT_MASK = 64,
	HDMI_FC_AVICONF0_ACTIVE_FMT_INFO_PRESENT = 64,
	HDMI_FC_AVICONF0_ACTIVE_FMT_NO_INFO = 0,
	HDMI_FC_AVICONF0_BAR_DATA_MASK = 12,
	HDMI_FC_AVICONF0_BAR_DATA_NO_DATA = 0,
	HDMI_FC_AVICONF0_BAR_DATA_VERT_BAR = 4,
	HDMI_FC_AVICONF0_BAR_DATA_HORIZ_BAR = 8,
	HDMI_FC_AVICONF0_BAR_DATA_VERT_HORIZ_BAR = 12,
	HDMI_FC_AVICONF0_SCAN_INFO_MASK = 48,
	HDMI_FC_AVICONF0_SCAN_INFO_OVERSCAN = 16,
	HDMI_FC_AVICONF0_SCAN_INFO_UNDERSCAN = 32,
	HDMI_FC_AVICONF0_SCAN_INFO_NODATA = 0,
	HDMI_FC_AVICONF1_ACTIVE_ASPECT_RATIO_MASK = 15,
	HDMI_FC_AVICONF1_ACTIVE_ASPECT_RATIO_USE_CODED = 8,
	HDMI_FC_AVICONF1_ACTIVE_ASPECT_RATIO_4_3 = 9,
	HDMI_FC_AVICONF1_ACTIVE_ASPECT_RATIO_16_9 = 10,
	HDMI_FC_AVICONF1_ACTIVE_ASPECT_RATIO_14_9 = 11,
	HDMI_FC_AVICONF1_CODED_ASPECT_RATIO_MASK = 48,
	HDMI_FC_AVICONF1_CODED_ASPECT_RATIO_NO_DATA = 0,
	HDMI_FC_AVICONF1_CODED_ASPECT_RATIO_4_3 = 16,
	HDMI_FC_AVICONF1_CODED_ASPECT_RATIO_16_9 = 32,
	HDMI_FC_AVICONF1_COLORIMETRY_MASK = 192,
	HDMI_FC_AVICONF1_COLORIMETRY_NO_DATA = 0,
	HDMI_FC_AVICONF1_COLORIMETRY_SMPTE = 64,
	HDMI_FC_AVICONF1_COLORIMETRY_ITUR = 128,
	HDMI_FC_AVICONF1_COLORIMETRY_EXTENDED_INFO = 192,
	HDMI_FC_AVICONF2_SCALING_MASK = 3,
	HDMI_FC_AVICONF2_SCALING_NONE = 0,
	HDMI_FC_AVICONF2_SCALING_HORIZ = 1,
	HDMI_FC_AVICONF2_SCALING_VERT = 2,
	HDMI_FC_AVICONF2_SCALING_HORIZ_VERT = 3,
	HDMI_FC_AVICONF2_RGB_QUANT_MASK = 12,
	HDMI_FC_AVICONF2_RGB_QUANT_DEFAULT = 0,
	HDMI_FC_AVICONF2_RGB_QUANT_LIMITED_RANGE = 4,
	HDMI_FC_AVICONF2_RGB_QUANT_FULL_RANGE = 8,
	HDMI_FC_AVICONF2_EXT_COLORIMETRY_MASK = 112,
	HDMI_FC_AVICONF2_EXT_COLORIMETRY_XVYCC601 = 0,
	HDMI_FC_AVICONF2_EXT_COLORIMETRY_XVYCC709 = 16,
	HDMI_FC_AVICONF2_EXT_COLORIMETRY_SYCC601 = 32,
	HDMI_FC_AVICONF2_EXT_COLORIMETRY_ADOBE_YCC601 = 48,
	HDMI_FC_AVICONF2_EXT_COLORIMETRY_ADOBE_RGB = 64,
	HDMI_FC_AVICONF2_IT_CONTENT_MASK = 128,
	HDMI_FC_AVICONF2_IT_CONTENT_NO_DATA = 0,
	HDMI_FC_AVICONF2_IT_CONTENT_VALID = 128,
	HDMI_FC_AVICONF3_IT_CONTENT_TYPE_MASK = 3,
	HDMI_FC_AVICONF3_IT_CONTENT_TYPE_GRAPHICS = 0,
	HDMI_FC_AVICONF3_IT_CONTENT_TYPE_PHOTO = 1,
	HDMI_FC_AVICONF3_IT_CONTENT_TYPE_CINEMA = 2,
	HDMI_FC_AVICONF3_IT_CONTENT_TYPE_GAME = 3,
	HDMI_FC_AVICONF3_QUANT_RANGE_MASK = 12,
	HDMI_FC_AVICONF3_QUANT_RANGE_LIMITED = 0,
	HDMI_FC_AVICONF3_QUANT_RANGE_FULL = 4,
	HDMI_FC_DBGFORCE_FORCEAUDIO = 16,
	HDMI_FC_DBGFORCE_FORCEVIDEO = 1,
	HDMI_FC_DATAUTO0_VSD_MASK = 8,
	HDMI_FC_DATAUTO0_VSD_OFFSET = 3,
	HDMI_FC_DATAUTO3_GCP_AUTO = 4,
	HDMI_PHY_CONF0_PDZ_MASK = 128,
	HDMI_PHY_CONF0_PDZ_OFFSET = 7,
	HDMI_PHY_CONF0_ENTMDS_MASK = 64,
	HDMI_PHY_CONF0_ENTMDS_OFFSET = 6,
	HDMI_PHY_CONF0_SVSRET_MASK = 32,
	HDMI_PHY_CONF0_SVSRET_OFFSET = 5,
	HDMI_PHY_CONF0_GEN2_PDDQ_MASK = 16,
	HDMI_PHY_CONF0_GEN2_PDDQ_OFFSET = 4,
	HDMI_PHY_CONF0_GEN2_TXPWRON_MASK = 8,
	HDMI_PHY_CONF0_GEN2_TXPWRON_OFFSET = 3,
	HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE_MASK = 4,
	HDMI_PHY_CONF0_GEN2_ENHPDRXSENSE_OFFSET = 2,
	HDMI_PHY_CONF0_SELDATAENPOL_MASK = 2,
	HDMI_PHY_CONF0_SELDATAENPOL_OFFSET = 1,
	HDMI_PHY_CONF0_SELDIPIF_MASK = 1,
	HDMI_PHY_CONF0_SELDIPIF_OFFSET = 0,
	HDMI_PHY_TST0_TSTCLR_MASK = 32,
	HDMI_PHY_TST0_TSTCLR_OFFSET = 5,
	HDMI_PHY_TST0_TSTEN_MASK = 16,
	HDMI_PHY_TST0_TSTEN_OFFSET = 4,
	HDMI_PHY_TST0_TSTCLK_MASK = 1,
	HDMI_PHY_TST0_TSTCLK_OFFSET = 0,
	HDMI_PHY_RX_SENSE3 = 128,
	HDMI_PHY_RX_SENSE2 = 64,
	HDMI_PHY_RX_SENSE1 = 32,
	HDMI_PHY_RX_SENSE0 = 16,
	HDMI_PHY_HPD = 2,
	HDMI_PHY_TX_PHY_LOCK = 1,
	HDMI_PHY_I2CM_SLAVE_ADDR_PHY_GEN2 = 105,
	HDMI_PHY_I2CM_SLAVE_ADDR_HEAC_PHY = 73,
	HDMI_PHY_I2CM_OPERATION_ADDR_WRITE = 16,
	HDMI_PHY_I2CM_OPERATION_ADDR_READ = 1,
	HDMI_PHY_I2CM_INT_ADDR_DONE_POL = 8,
	HDMI_PHY_I2CM_INT_ADDR_DONE_MASK = 4,
	HDMI_PHY_I2CM_CTLINT_ADDR_NAC_POL = 128,
	HDMI_PHY_I2CM_CTLINT_ADDR_NAC_MASK = 64,
	HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_POL = 8,
	HDMI_PHY_I2CM_CTLINT_ADDR_ARBITRATION_MASK = 4,
	HDMI_AUD_CONF0_SW_RESET = 128,
	HDMI_AUD_CONF0_I2S_SELECT = 32,
	HDMI_AUD_CONF0_I2S_EN3 = 8,
	HDMI_AUD_CONF0_I2S_EN2 = 4,
	HDMI_AUD_CONF0_I2S_EN1 = 2,
	HDMI_AUD_CONF0_I2S_EN0 = 1,
	HDMI_AUD_CONF1_MODE_I2S = 0,
	HDMI_AUD_CONF1_MODE_RIGHT_J = 32,
	HDMI_AUD_CONF1_MODE_LEFT_J = 64,
	HDMI_AUD_CONF1_MODE_BURST_1 = 96,
	HDMI_AUD_CONF1_MODE_BURST_2 = 128,
	HDMI_AUD_CONF1_WIDTH_16 = 16,
	HDMI_AUD_CONF1_WIDTH_24 = 24,
	HDMI_AUD_CTS3_N_SHIFT_OFFSET = 5,
	HDMI_AUD_CTS3_N_SHIFT_MASK = 224,
	HDMI_AUD_CTS3_N_SHIFT_1 = 0,
	HDMI_AUD_CTS3_N_SHIFT_16 = 32,
	HDMI_AUD_CTS3_N_SHIFT_32 = 64,
	HDMI_AUD_CTS3_N_SHIFT_64 = 96,
	HDMI_AUD_CTS3_N_SHIFT_128 = 128,
	HDMI_AUD_CTS3_N_SHIFT_256 = 160,
	HDMI_AUD_CTS3_CTS_MANUAL = 16,
	HDMI_AUD_CTS3_AUDCTS19_16_MASK = 15,
	HDMI_AUD_INPUTCLKFS_128FS = 0,
	HDMI_AUD_INPUTCLKFS_256FS = 1,
	HDMI_AUD_INPUTCLKFS_512FS = 2,
	HDMI_AUD_INPUTCLKFS_64FS = 4,
	HDMI_AHB_DMA_CONF0_SW_FIFO_RST_OFFSET = 7,
	HDMI_AHB_DMA_CONF0_SW_FIFO_RST_MASK = 128,
	HDMI_AHB_DMA_CONF0_HBR = 16,
	HDMI_AHB_DMA_CONF0_EN_HLOCK_OFFSET = 3,
	HDMI_AHB_DMA_CONF0_EN_HLOCK_MASK = 8,
	HDMI_AHB_DMA_CONF0_INCR_TYPE_OFFSET = 1,
	HDMI_AHB_DMA_CONF0_INCR_TYPE_MASK = 6,
	HDMI_AHB_DMA_CONF0_INCR4 = 0,
	HDMI_AHB_DMA_CONF0_INCR8 = 2,
	HDMI_AHB_DMA_CONF0_INCR16 = 4,
	HDMI_AHB_DMA_CONF0_BURST_MODE = 1,
	HDMI_AHB_DMA_START_START_OFFSET = 0,
	HDMI_AHB_DMA_START_START_MASK = 1,
	HDMI_AHB_DMA_STOP_STOP_OFFSET = 0,
	HDMI_AHB_DMA_STOP_STOP_MASK = 1,
	HDMI_AHB_DMA_DONE = 128,
	HDMI_AHB_DMA_RETRY_SPLIT = 64,
	HDMI_AHB_DMA_LOSTOWNERSHIP = 32,
	HDMI_AHB_DMA_ERROR = 16,
	HDMI_AHB_DMA_FIFO_THREMPTY = 4,
	HDMI_AHB_DMA_FIFO_FULL = 2,
	HDMI_AHB_DMA_FIFO_EMPTY = 1,
	HDMI_AHB_DMA_BUFFSTAT_FULL = 2,
	HDMI_AHB_DMA_BUFFSTAT_EMPTY = 1,
	HDMI_MC_CLKDIS_HDCPCLK_DISABLE = 64,
	HDMI_MC_CLKDIS_CECCLK_DISABLE = 32,
	HDMI_MC_CLKDIS_CSCCLK_DISABLE = 16,
	HDMI_MC_CLKDIS_AUDCLK_DISABLE = 8,
	HDMI_MC_CLKDIS_PREPCLK_DISABLE = 4,
	HDMI_MC_CLKDIS_TMDSCLK_DISABLE = 2,
	HDMI_MC_CLKDIS_PIXELCLK_DISABLE = 1,
	HDMI_MC_SWRSTZ_I2SSWRST_REQ = 8,
	HDMI_MC_SWRSTZ_TMDSSWRST_REQ = 2,
	HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF_MASK = 1,
	HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF_CSC_IN_PATH = 1,
	HDMI_MC_FLOWCTRL_FEED_THROUGH_OFF_CSC_BYPASS = 0,
	HDMI_MC_PHYRSTZ_PHYRSTZ = 1,
	HDMI_MC_HEACPHY_RST_ASSERT = 1,
	HDMI_MC_HEACPHY_RST_DEASSERT = 0,
	HDMI_CSC_CFG_INTMODE_MASK = 48,
	HDMI_CSC_CFG_INTMODE_OFFSET = 4,
	HDMI_CSC_CFG_INTMODE_DISABLE = 0,
	HDMI_CSC_CFG_INTMODE_CHROMA_INT_FORMULA1 = 16,
	HDMI_CSC_CFG_INTMODE_CHROMA_INT_FORMULA2 = 32,
	HDMI_CSC_CFG_DECMODE_MASK = 3,
	HDMI_CSC_CFG_DECMODE_OFFSET = 0,
	HDMI_CSC_CFG_DECMODE_DISABLE = 0,
	HDMI_CSC_CFG_DECMODE_CHROMA_INT_FORMULA1 = 1,
	HDMI_CSC_CFG_DECMODE_CHROMA_INT_FORMULA2 = 2,
	HDMI_CSC_CFG_DECMODE_CHROMA_INT_FORMULA3 = 3,
	HDMI_CSC_SCALE_CSC_COLORDE_PTH_MASK = 240,
	HDMI_CSC_SCALE_CSC_COLORDE_PTH_24BPP = 0,
	HDMI_CSC_SCALE_CSC_COLORDE_PTH_30BPP = 80,
	HDMI_CSC_SCALE_CSC_COLORDE_PTH_36BPP = 96,
	HDMI_CSC_SCALE_CSC_COLORDE_PTH_48BPP = 112,
	HDMI_CSC_SCALE_CSCSCALE_MASK = 3,
	HDMI_A_HDCPCFG0_ELVENA_MASK = 128,
	HDMI_A_HDCPCFG0_ELVENA_ENABLE = 128,
	HDMI_A_HDCPCFG0_ELVENA_DISABLE = 0,
	HDMI_A_HDCPCFG0_I2CFASTMODE_MASK = 64,
	HDMI_A_HDCPCFG0_I2CFASTMODE_ENABLE = 64,
	HDMI_A_HDCPCFG0_I2CFASTMODE_DISABLE = 0,
	HDMI_A_HDCPCFG0_BYPENCRYPTION_MASK = 32,
	HDMI_A_HDCPCFG0_BYPENCRYPTION_ENABLE = 32,
	HDMI_A_HDCPCFG0_BYPENCRYPTION_DISABLE = 0,
	HDMI_A_HDCPCFG0_SYNCRICHECK_MASK = 16,
	HDMI_A_HDCPCFG0_SYNCRICHECK_ENABLE = 16,
	HDMI_A_HDCPCFG0_SYNCRICHECK_DISABLE = 0,
	HDMI_A_HDCPCFG0_AVMUTE_MASK = 8,
	HDMI_A_HDCPCFG0_AVMUTE_ENABLE = 8,
	HDMI_A_HDCPCFG0_AVMUTE_DISABLE = 0,
	HDMI_A_HDCPCFG0_RXDETECT_MASK = 4,
	HDMI_A_HDCPCFG0_RXDETECT_ENABLE = 4,
	HDMI_A_HDCPCFG0_RXDETECT_DISABLE = 0,
	HDMI_A_HDCPCFG0_EN11FEATURE_MASK = 2,
	HDMI_A_HDCPCFG0_EN11FEATURE_ENABLE = 2,
	HDMI_A_HDCPCFG0_EN11FEATURE_DISABLE = 0,
	HDMI_A_HDCPCFG0_HDMIDVI_MASK = 1,
	HDMI_A_HDCPCFG0_HDMIDVI_HDMI = 1,
	HDMI_A_HDCPCFG0_HDMIDVI_DVI = 0,
	HDMI_A_HDCPCFG1_DISSHA1CHECK_MASK = 8,
	HDMI_A_HDCPCFG1_DISSHA1CHECK_DISABLE = 8,
	HDMI_A_HDCPCFG1_DISSHA1CHECK_ENABLE = 0,
	HDMI_A_HDCPCFG1_PH2UPSHFTENC_MASK = 4,
	HDMI_A_HDCPCFG1_PH2UPSHFTENC_ENABLE = 4,
	HDMI_A_HDCPCFG1_PH2UPSHFTENC_DISABLE = 0,
	HDMI_A_HDCPCFG1_ENCRYPTIONDISABLE_MASK = 2,
	HDMI_A_HDCPCFG1_ENCRYPTIONDISABLE_DISABLE = 2,
	HDMI_A_HDCPCFG1_ENCRYPTIONDISABLE_ENABLE = 0,
	HDMI_A_HDCPCFG1_SWRESET_MASK = 1,
	HDMI_A_HDCPCFG1_SWRESET_ASSERT = 0,
	HDMI_A_VIDPOLCFG_UNENCRYPTCONF_MASK = 96,
	HDMI_A_VIDPOLCFG_UNENCRYPTCONF_OFFSET = 5,
	HDMI_A_VIDPOLCFG_DATAENPOL_MASK = 16,
	HDMI_A_VIDPOLCFG_DATAENPOL_ACTIVE_HIGH = 16,
	HDMI_A_VIDPOLCFG_DATAENPOL_ACTIVE_LOW = 0,
	HDMI_A_VIDPOLCFG_VSYNCPOL_MASK = 8,
	HDMI_A_VIDPOLCFG_VSYNCPOL_ACTIVE_HIGH = 8,
	HDMI_A_VIDPOLCFG_VSYNCPOL_ACTIVE_LOW = 0,
	HDMI_A_VIDPOLCFG_HSYNCPOL_MASK = 2,
	HDMI_A_VIDPOLCFG_HSYNCPOL_ACTIVE_HIGH = 2,
	HDMI_A_VIDPOLCFG_HSYNCPOL_ACTIVE_LOW = 0,
	HDMI_I2CM_OPERATION_WRITE = 16,
	HDMI_I2CM_OPERATION_READ_EXT = 2,
	HDMI_I2CM_OPERATION_READ = 1,
	HDMI_I2CM_INT_DONE_POL = 8,
	HDMI_I2CM_INT_DONE_MASK = 4,
	HDMI_I2CM_CTLINT_NAC_POL = 128,
	HDMI_I2CM_CTLINT_NAC_MASK = 64,
	HDMI_I2CM_CTLINT_ARB_POL = 8,
	HDMI_I2CM_CTLINT_ARB_MASK = 4,
};

enum {
	HDMI_SYS_POWER_MODE_MASK = 240,
	HDMI_SYS_POWER_MODE_A = 16,
	HDMI_SYS_POWER_MODE_B = 32,
	HDMI_SYS_POWER_MODE_D = 64,
	HDMI_SYS_POWER_MODE_E = 128,
	HDMI_SYS_PLL_RESET_MASK = 12,
	HDMI_SYS_PLL_RESET = 12,
	HDMI_SYS_PLLB_RESET = 8,
	HDMI_AUDIO_LR_SWAP_MASK = 240,
	HDMI_AUDIO_LR_SWAP_SUBPACKET0 = 16,
	HDMI_AUDIO_LR_SWAP_SUBPACKET1 = 32,
	HDMI_AUDIO_LR_SWAP_SUBPACKET2 = 64,
	HDMI_AUDIO_LR_SWAP_SUBPACKET3 = 128,
	HDMI_AUDIO_N_19_16_MASK = 15,
	HDMI_AUDIO_EXTERNAL_CTS = 128,
	HDMI_AUDIO_INPUT_IIS = 0,
	HDMI_AUDIO_INPUT_SPDIF = 8,
	HDMI_AUDIO_INPUT_MCLK_ACTIVE = 4,
	HDMI_AUDIO_INPUT_MCLK_DEACTIVE = 0,
	HDMI_AUDIO_INPUT_MCLK_RATE_128X = 0,
	HDMI_AUDIO_INPUT_MCLK_RATE_256X = 1,
	HDMI_AUDIO_INPUT_MCLK_RATE_384X = 2,
	HDMI_AUDIO_INPUT_MCLK_RATE_512X = 3,
	HDMI_AUDIO_I2S_FORMAT_STANDARD = 0,
	HDMI_AUDIO_I2S_CHANNEL_1_2 = 4,
	HDMI_AUDIO_I2S_CHANNEL_3_4 = 12,
	HDMI_AUDIO_I2S_CHANNEL_5_6 = 28,
	HDMI_AUDIO_I2S_CHANNEL_7_8 = 60,
	HDMI_AUDIO_SAMPLE_FRE_MASK = 240,
	HDMI_AUDIO_SAMPLE_FRE_32000 = 48,
	HDMI_AUDIO_SAMPLE_FRE_44100 = 0,
	HDMI_AUDIO_SAMPLE_FRE_48000 = 32,
	HDMI_AUDIO_SAMPLE_FRE_88200 = 128,
	HDMI_AUDIO_SAMPLE_FRE_96000 = 160,
	HDMI_AUDIO_SAMPLE_FRE_176400 = 192,
	HDMI_AUDIO_SAMPLE_FRE_192000 = 224,
	HDMI_AUDIO_SAMPLE_FRE_768000 = 144,
	HDMI_VIDEO_INPUT_FORMAT_MASK = 14,
	HDMI_VIDEO_INPUT_RGB_YCBCR444 = 0,
	HDMI_VIDEO_INPUT_YCBCR422 = 2,
	HDMI_VIDEO_DE_MASK = 1,
	HDMI_VIDEO_INTERNAL_DE = 0,
	HDMI_VIDEO_EXTERNAL_DE = 1,
	HDMI_VIDEO_OUTPUT_FORMAT_MASK = 192,
	HDMI_VIDEO_OUTPUT_RGB444 = 0,
	HDMI_VIDEO_OUTPUT_YCBCR444 = 64,
	HDMI_VIDEO_OUTPUT_YCBCR422 = 128,
	HDMI_VIDEO_INPUT_DATA_DEPTH_MASK = 48,
	HDMI_VIDEO_INPUT_DATA_DEPTH_12BIT = 0,
	HDMI_VIDEO_INPUT_DATA_DEPTH_10BIT = 16,
	HDMI_VIDEO_INPUT_DATA_DEPTH_8BIT = 48,
	HDMI_VIDEO_INPUT_COLOR_MASK = 1,
	HDMI_VIDEO_INPUT_COLOR_RGB = 0,
	HDMI_VIDEO_INPUT_COLOR_YCBCR = 1,
	HDMI_VIDEO_VSYNC_OFFSET_SHIFT = 4,
	HDMI_VIDEO_VSYNC_ACTIVE_HIGH = 8,
	HDMI_VIDEO_VSYNC_ACTIVE_LOW = 0,
	HDMI_VIDEO_HSYNC_ACTIVE_HIGH = 4,
	HDMI_VIDEO_HSYNC_ACTIVE_LOW = 0,
	HDMI_VIDEO_MODE_INTERLACE = 2,
	HDMI_VIDEO_MODE_PROGRESSIVE = 0,
	HDMI_EXT_VIDEO_SET_EN = 1,
	HDMI_VIDEO_AV_MUTE_MASK = 192,
	HDMI_VIDEO_CLR_AV_MUTE = 128,
	HDMI_VIDEO_SET_AV_MUTE = 64,
	HDMI_AUDIO_CP_LOGIC_RESET_MASK = 4,
	HDMI_AUDIO_CP_LOGIC_RESET = 4,
	HDMI_VIDEO_AUDIO_DISABLE_MASK = 3,
	HDMI_AUDIO_DISABLE = 2,
	HDMI_VIDEO_DISABLE = 1,
	HDMI_INFOFRAME_VSI = 5,
	HDMI_INFOFRAME_AVI = 6,
	HDMI_INFOFRAME_AAI = 8,
	HDMI_INTR_HOTPLUG = 128,
	HDMI_INTR_MSENS = 64,
	HDMI_INTR_VSYNC = 32,
	HDMI_INTR_AUDIO_FIFO_FULL = 16,
	HDMI_INTR_EDID_MASK = 6,
	HDMI_INTR_EDID_READY = 4,
	HDMI_INTR_EDID_ERR = 2,
	HDMI_VIDEO_MODE_MASK = 2,
	HDMI_VIDEO_MODE_HDMI = 2,
	HDMI_HPG_IN_STATUS_HIGH = 128,
	HDMI_MSENS_IN_STATUS_HIGH = 64,
};

enum {
	HIBERNATION_INVALID = 0,
	HIBERNATION_PLATFORM = 1,
	HIBERNATION_SHUTDOWN = 2,
	HIBERNATION_REBOOT = 3,
	HIBERNATION_SUSPEND = 4,
	HIBERNATION_TEST_RESUME = 5,
	__HIBERNATION_AFTER_LAST = 6,
};

enum {
	HI_SOFTIRQ = 0,
	TIMER_SOFTIRQ = 1,
	NET_TX_SOFTIRQ = 2,
	NET_RX_SOFTIRQ = 3,
	BLOCK_SOFTIRQ = 4,
	IRQ_POLL_SOFTIRQ = 5,
	TASKLET_SOFTIRQ = 6,
	SCHED_SOFTIRQ = 7,
	HRTIMER_SOFTIRQ = 8,
	RCU_SOFTIRQ = 9,
	NR_SOFTIRQS = 10,
};

enum {
	HP_THREAD_NONE = 0,
	HP_THREAD_ACTIVE = 1,
	HP_THREAD_PARKED = 2,
};

enum {
	HUF_flags_bmi2 = 1,
	HUF_flags_optimalDepth = 2,
	HUF_flags_preferRepeat = 4,
	HUF_flags_suspectUncompressible = 8,
	HUF_flags_disableAsm = 16,
	HUF_flags_disableFast = 32,
};

enum {
	HUGETLB_SHMFS_INODE = 1,
	HUGETLB_ANONHUGE_INODE = 2,
};

enum {
	HW_BREAKPOINT_EMPTY = 0,
	HW_BREAKPOINT_R = 1,
	HW_BREAKPOINT_W = 2,
	HW_BREAKPOINT_RW = 3,
	HW_BREAKPOINT_X = 4,
	HW_BREAKPOINT_INVALID = 7,
};

enum {
	HW_BREAKPOINT_LEN_1 = 1,
	HW_BREAKPOINT_LEN_2 = 2,
	HW_BREAKPOINT_LEN_3 = 3,
	HW_BREAKPOINT_LEN_4 = 4,
	HW_BREAKPOINT_LEN_5 = 5,
	HW_BREAKPOINT_LEN_6 = 6,
	HW_BREAKPOINT_LEN_7 = 7,
	HW_BREAKPOINT_LEN_8 = 8,
};

enum {
	ICMP6_MIB_NUM = 0,
	ICMP6_MIB_INMSGS = 1,
	ICMP6_MIB_INERRORS = 2,
	ICMP6_MIB_OUTMSGS = 3,
	ICMP6_MIB_OUTERRORS = 4,
	ICMP6_MIB_CSUMERRORS = 5,
	ICMP6_MIB_RATELIMITHOST = 6,
	__ICMP6_MIB_MAX = 7,
};

enum {
	ICMP_MIB_NUM = 0,
	ICMP_MIB_INMSGS = 1,
	ICMP_MIB_INERRORS = 2,
	ICMP_MIB_INDESTUNREACHS = 3,
	ICMP_MIB_INTIMEEXCDS = 4,
	ICMP_MIB_INPARMPROBS = 5,
	ICMP_MIB_INSRCQUENCHS = 6,
	ICMP_MIB_INREDIRECTS = 7,
	ICMP_MIB_INECHOS = 8,
	ICMP_MIB_INECHOREPS = 9,
	ICMP_MIB_INTIMESTAMPS = 10,
	ICMP_MIB_INTIMESTAMPREPS = 11,
	ICMP_MIB_INADDRMASKS = 12,
	ICMP_MIB_INADDRMASKREPS = 13,
	ICMP_MIB_OUTMSGS = 14,
	ICMP_MIB_OUTERRORS = 15,
	ICMP_MIB_OUTDESTUNREACHS = 16,
	ICMP_MIB_OUTTIMEEXCDS = 17,
	ICMP_MIB_OUTPARMPROBS = 18,
	ICMP_MIB_OUTSRCQUENCHS = 19,
	ICMP_MIB_OUTREDIRECTS = 20,
	ICMP_MIB_OUTECHOS = 21,
	ICMP_MIB_OUTECHOREPS = 22,
	ICMP_MIB_OUTTIMESTAMPS = 23,
	ICMP_MIB_OUTTIMESTAMPREPS = 24,
	ICMP_MIB_OUTADDRMASKS = 25,
	ICMP_MIB_OUTADDRMASKREPS = 26,
	ICMP_MIB_CSUMERRORS = 27,
	ICMP_MIB_RATELIMITGLOBAL = 28,
	ICMP_MIB_RATELIMITHOST = 29,
	__ICMP_MIB_MAX = 30,
};

enum {
	ICQ_EXITED = 4,
	ICQ_DESTROYED = 8,
};

enum {
	ICSS_IEP_GLOBAL_CFG_REG = 0,
	ICSS_IEP_GLOBAL_STATUS_REG = 1,
	ICSS_IEP_COMPEN_REG = 2,
	ICSS_IEP_SLOW_COMPEN_REG = 3,
	ICSS_IEP_COUNT_REG0 = 4,
	ICSS_IEP_COUNT_REG1 = 5,
	ICSS_IEP_CAPTURE_CFG_REG = 6,
	ICSS_IEP_CAPTURE_STAT_REG = 7,
	ICSS_IEP_CAP6_RISE_REG0 = 8,
	ICSS_IEP_CAP6_RISE_REG1 = 9,
	ICSS_IEP_CAP7_RISE_REG0 = 10,
	ICSS_IEP_CAP7_RISE_REG1 = 11,
	ICSS_IEP_CMP_CFG_REG = 12,
	ICSS_IEP_CMP_STAT_REG = 13,
	ICSS_IEP_CMP0_REG0 = 14,
	ICSS_IEP_CMP0_REG1 = 15,
	ICSS_IEP_CMP1_REG0 = 16,
	ICSS_IEP_CMP1_REG1 = 17,
	ICSS_IEP_CMP8_REG0 = 18,
	ICSS_IEP_CMP8_REG1 = 19,
	ICSS_IEP_SYNC_CTRL_REG = 20,
	ICSS_IEP_SYNC0_STAT_REG = 21,
	ICSS_IEP_SYNC1_STAT_REG = 22,
	ICSS_IEP_SYNC_PWIDTH_REG = 23,
	ICSS_IEP_SYNC0_PERIOD_REG = 24,
	ICSS_IEP_SYNC1_DELAY_REG = 25,
	ICSS_IEP_SYNC_START_REG = 26,
	ICSS_IEP_MAX_REGS = 27,
};

enum {
	IDX_MODULE_ID = 0,
	IDX_ST_OPS_COMMON_VALUE_ID = 1,
};

enum {
	IFAL_ADDRESS = 1,
	IFAL_LABEL = 2,
	__IFAL_MAX = 3,
};

enum {
	IFA_UNSPEC = 0,
	IFA_ADDRESS = 1,
	IFA_LOCAL = 2,
	IFA_LABEL = 3,
	IFA_BROADCAST = 4,
	IFA_ANYCAST = 5,
	IFA_CACHEINFO = 6,
	IFA_MULTICAST = 7,
	IFA_FLAGS = 8,
	IFA_RT_PRIORITY = 9,
	IFA_TARGET_NETNSID = 10,
	IFA_PROTO = 11,
	__IFA_MAX = 12,
};

enum {
	IFLA_BRIDGE_FLAGS = 0,
	IFLA_BRIDGE_MODE = 1,
	IFLA_BRIDGE_VLAN_INFO = 2,
	IFLA_BRIDGE_VLAN_TUNNEL_INFO = 3,
	IFLA_BRIDGE_MRP = 4,
	IFLA_BRIDGE_CFM = 5,
	IFLA_BRIDGE_MST = 6,
	__IFLA_BRIDGE_MAX = 7,
};

enum {
	IFLA_BRPORT_UNSPEC = 0,
	IFLA_BRPORT_STATE = 1,
	IFLA_BRPORT_PRIORITY = 2,
	IFLA_BRPORT_COST = 3,
	IFLA_BRPORT_MODE = 4,
	IFLA_BRPORT_GUARD = 5,
	IFLA_BRPORT_PROTECT = 6,
	IFLA_BRPORT_FAST_LEAVE = 7,
	IFLA_BRPORT_LEARNING = 8,
	IFLA_BRPORT_UNICAST_FLOOD = 9,
	IFLA_BRPORT_PROXYARP = 10,
	IFLA_BRPORT_LEARNING_SYNC = 11,
	IFLA_BRPORT_PROXYARP_WIFI = 12,
	IFLA_BRPORT_ROOT_ID = 13,
	IFLA_BRPORT_BRIDGE_ID = 14,
	IFLA_BRPORT_DESIGNATED_PORT = 15,
	IFLA_BRPORT_DESIGNATED_COST = 16,
	IFLA_BRPORT_ID = 17,
	IFLA_BRPORT_NO = 18,
	IFLA_BRPORT_TOPOLOGY_CHANGE_ACK = 19,
	IFLA_BRPORT_CONFIG_PENDING = 20,
	IFLA_BRPORT_MESSAGE_AGE_TIMER = 21,
	IFLA_BRPORT_FORWARD_DELAY_TIMER = 22,
	IFLA_BRPORT_HOLD_TIMER = 23,
	IFLA_BRPORT_FLUSH = 24,
	IFLA_BRPORT_MULTICAST_ROUTER = 25,
	IFLA_BRPORT_PAD = 26,
	IFLA_BRPORT_MCAST_FLOOD = 27,
	IFLA_BRPORT_MCAST_TO_UCAST = 28,
	IFLA_BRPORT_VLAN_TUNNEL = 29,
	IFLA_BRPORT_BCAST_FLOOD = 30,
	IFLA_BRPORT_GROUP_FWD_MASK = 31,
	IFLA_BRPORT_NEIGH_SUPPRESS = 32,
	IFLA_BRPORT_ISOLATED = 33,
	IFLA_BRPORT_BACKUP_PORT = 34,
	IFLA_BRPORT_MRP_RING_OPEN = 35,
	IFLA_BRPORT_MRP_IN_OPEN = 36,
	IFLA_BRPORT_MCAST_EHT_HOSTS_LIMIT = 37,
	IFLA_BRPORT_MCAST_EHT_HOSTS_CNT = 38,
	IFLA_BRPORT_LOCKED = 39,
	IFLA_BRPORT_MAB = 40,
	IFLA_BRPORT_MCAST_N_GROUPS = 41,
	IFLA_BRPORT_MCAST_MAX_GROUPS = 42,
	IFLA_BRPORT_NEIGH_VLAN_SUPPRESS = 43,
	IFLA_BRPORT_BACKUP_NHID = 44,
	__IFLA_BRPORT_MAX = 45,
};

enum {
	IFLA_EVENT_NONE = 0,
	IFLA_EVENT_REBOOT = 1,
	IFLA_EVENT_FEATURES = 2,
	IFLA_EVENT_BONDING_FAILOVER = 3,
	IFLA_EVENT_NOTIFY_PEERS = 4,
	IFLA_EVENT_IGMP_RESEND = 5,
	IFLA_EVENT_BONDING_OPTIONS = 6,
};

enum {
	IFLA_INET6_UNSPEC = 0,
	IFLA_INET6_FLAGS = 1,
	IFLA_INET6_CONF = 2,
	IFLA_INET6_STATS = 3,
	IFLA_INET6_MCAST = 4,
	IFLA_INET6_CACHEINFO = 5,
	IFLA_INET6_ICMP6STATS = 6,
	IFLA_INET6_TOKEN = 7,
	IFLA_INET6_ADDR_GEN_MODE = 8,
	IFLA_INET6_RA_MTU = 9,
	__IFLA_INET6_MAX = 10,
};

enum {
	IFLA_INET_UNSPEC = 0,
	IFLA_INET_CONF = 1,
	__IFLA_INET_MAX = 2,
};

enum {
	IFLA_INFO_UNSPEC = 0,
	IFLA_INFO_KIND = 1,
	IFLA_INFO_DATA = 2,
	IFLA_INFO_XSTATS = 3,
	IFLA_INFO_SLAVE_KIND = 4,
	IFLA_INFO_SLAVE_DATA = 5,
	__IFLA_INFO_MAX = 6,
};

enum {
	IFLA_IPTUN_UNSPEC = 0,
	IFLA_IPTUN_LINK = 1,
	IFLA_IPTUN_LOCAL = 2,
	IFLA_IPTUN_REMOTE = 3,
	IFLA_IPTUN_TTL = 4,
	IFLA_IPTUN_TOS = 5,
	IFLA_IPTUN_ENCAP_LIMIT = 6,
	IFLA_IPTUN_FLOWINFO = 7,
	IFLA_IPTUN_FLAGS = 8,
	IFLA_IPTUN_PROTO = 9,
	IFLA_IPTUN_PMTUDISC = 10,
	IFLA_IPTUN_6RD_PREFIX = 11,
	IFLA_IPTUN_6RD_RELAY_PREFIX = 12,
	IFLA_IPTUN_6RD_PREFIXLEN = 13,
	IFLA_IPTUN_6RD_RELAY_PREFIXLEN = 14,
	IFLA_IPTUN_ENCAP_TYPE = 15,
	IFLA_IPTUN_ENCAP_FLAGS = 16,
	IFLA_IPTUN_ENCAP_SPORT = 17,
	IFLA_IPTUN_ENCAP_DPORT = 18,
	IFLA_IPTUN_COLLECT_METADATA = 19,
	IFLA_IPTUN_FWMARK = 20,
	__IFLA_IPTUN_MAX = 21,
};

enum {
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_REQUEST = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO_USED = 2,
	__IFLA_OFFLOAD_XSTATS_HW_S_INFO_MAX = 3,
};

enum {
	IFLA_OFFLOAD_XSTATS_UNSPEC = 0,
	IFLA_OFFLOAD_XSTATS_CPU_HIT = 1,
	IFLA_OFFLOAD_XSTATS_HW_S_INFO = 2,
	IFLA_OFFLOAD_XSTATS_L3_STATS = 3,
	__IFLA_OFFLOAD_XSTATS_MAX = 4,
};

enum {
	IFLA_PORT_UNSPEC = 0,
	IFLA_PORT_VF = 1,
	IFLA_PORT_PROFILE = 2,
	IFLA_PORT_VSI_TYPE = 3,
	IFLA_PORT_INSTANCE_UUID = 4,
	IFLA_PORT_HOST_UUID = 5,
	IFLA_PORT_REQUEST = 6,
	IFLA_PORT_RESPONSE = 7,
	__IFLA_PORT_MAX = 8,
};

enum {
	IFLA_PROTO_DOWN_REASON_UNSPEC = 0,
	IFLA_PROTO_DOWN_REASON_MASK = 1,
	IFLA_PROTO_DOWN_REASON_VALUE = 2,
	__IFLA_PROTO_DOWN_REASON_CNT = 3,
	IFLA_PROTO_DOWN_REASON_MAX = 2,
};

enum {
	IFLA_STATS_GETSET_UNSPEC = 0,
	IFLA_STATS_GET_FILTERS = 1,
	IFLA_STATS_SET_OFFLOAD_XSTATS_L3_STATS = 2,
	__IFLA_STATS_GETSET_MAX = 3,
};

enum {
	IFLA_STATS_UNSPEC = 0,
	IFLA_STATS_LINK_64 = 1,
	IFLA_STATS_LINK_XSTATS = 2,
	IFLA_STATS_LINK_XSTATS_SLAVE = 3,
	IFLA_STATS_LINK_OFFLOAD_XSTATS = 4,
	IFLA_STATS_AF_SPEC = 5,
	__IFLA_STATS_MAX = 6,
};

enum {
	IFLA_UNSPEC = 0,
	IFLA_ADDRESS = 1,
	IFLA_BROADCAST = 2,
	IFLA_IFNAME = 3,
	IFLA_MTU = 4,
	IFLA_LINK = 5,
	IFLA_QDISC = 6,
	IFLA_STATS = 7,
	IFLA_COST = 8,
	IFLA_PRIORITY = 9,
	IFLA_MASTER = 10,
	IFLA_WIRELESS = 11,
	IFLA_PROTINFO = 12,
	IFLA_TXQLEN = 13,
	IFLA_MAP = 14,
	IFLA_WEIGHT = 15,
	IFLA_OPERSTATE = 16,
	IFLA_LINKMODE = 17,
	IFLA_LINKINFO = 18,
	IFLA_NET_NS_PID = 19,
	IFLA_IFALIAS = 20,
	IFLA_NUM_VF = 21,
	IFLA_VFINFO_LIST = 22,
	IFLA_STATS64 = 23,
	IFLA_VF_PORTS = 24,
	IFLA_PORT_SELF = 25,
	IFLA_AF_SPEC = 26,
	IFLA_GROUP = 27,
	IFLA_NET_NS_FD = 28,
	IFLA_EXT_MASK = 29,
	IFLA_PROMISCUITY = 30,
	IFLA_NUM_TX_QUEUES = 31,
	IFLA_NUM_RX_QUEUES = 32,
	IFLA_CARRIER = 33,
	IFLA_PHYS_PORT_ID = 34,
	IFLA_CARRIER_CHANGES = 35,
	IFLA_PHYS_SWITCH_ID = 36,
	IFLA_LINK_NETNSID = 37,
	IFLA_PHYS_PORT_NAME = 38,
	IFLA_PROTO_DOWN = 39,
	IFLA_GSO_MAX_SEGS = 40,
	IFLA_GSO_MAX_SIZE = 41,
	IFLA_PAD = 42,
	IFLA_XDP = 43,
	IFLA_EVENT = 44,
	IFLA_NEW_NETNSID = 45,
	IFLA_IF_NETNSID = 46,
	IFLA_TARGET_NETNSID = 46,
	IFLA_CARRIER_UP_COUNT = 47,
	IFLA_CARRIER_DOWN_COUNT = 48,
	IFLA_NEW_IFINDEX = 49,
	IFLA_MIN_MTU = 50,
	IFLA_MAX_MTU = 51,
	IFLA_PROP_LIST = 52,
	IFLA_ALT_IFNAME = 53,
	IFLA_PERM_ADDRESS = 54,
	IFLA_PROTO_DOWN_REASON = 55,
	IFLA_PARENT_DEV_NAME = 56,
	IFLA_PARENT_DEV_BUS_NAME = 57,
	IFLA_GRO_MAX_SIZE = 58,
	IFLA_TSO_MAX_SIZE = 59,
	IFLA_TSO_MAX_SEGS = 60,
	IFLA_ALLMULTI = 61,
	IFLA_DEVLINK_PORT = 62,
	IFLA_GSO_IPV4_MAX_SIZE = 63,
	IFLA_GRO_IPV4_MAX_SIZE = 64,
	IFLA_DPLL_PIN = 65,
	IFLA_MAX_PACING_OFFLOAD_HORIZON = 66,
	IFLA_NETNS_IMMUTABLE = 67,
	__IFLA_MAX = 68,
};

enum {
	IFLA_VF_INFO_UNSPEC = 0,
	IFLA_VF_INFO = 1,
	__IFLA_VF_INFO_MAX = 2,
};

enum {
	IFLA_VF_PORT_UNSPEC = 0,
	IFLA_VF_PORT = 1,
	__IFLA_VF_PORT_MAX = 2,
};

enum {
	IFLA_VF_STATS_RX_PACKETS = 0,
	IFLA_VF_STATS_TX_PACKETS = 1,
	IFLA_VF_STATS_RX_BYTES = 2,
	IFLA_VF_STATS_TX_BYTES = 3,
	IFLA_VF_STATS_BROADCAST = 4,
	IFLA_VF_STATS_MULTICAST = 5,
	IFLA_VF_STATS_PAD = 6,
	IFLA_VF_STATS_RX_DROPPED = 7,
	IFLA_VF_STATS_TX_DROPPED = 8,
	__IFLA_VF_STATS_MAX = 9,
};

enum {
	IFLA_VF_UNSPEC = 0,
	IFLA_VF_MAC = 1,
	IFLA_VF_VLAN = 2,
	IFLA_VF_TX_RATE = 3,
	IFLA_VF_SPOOFCHK = 4,
	IFLA_VF_LINK_STATE = 5,
	IFLA_VF_RATE = 6,
	IFLA_VF_RSS_QUERY_EN = 7,
	IFLA_VF_STATS = 8,
	IFLA_VF_TRUST = 9,
	IFLA_VF_IB_NODE_GUID = 10,
	IFLA_VF_IB_PORT_GUID = 11,
	IFLA_VF_VLAN_LIST = 12,
	IFLA_VF_BROADCAST = 13,
	__IFLA_VF_MAX = 14,
};

enum {
	IFLA_VF_VLAN_INFO_UNSPEC = 0,
	IFLA_VF_VLAN_INFO = 1,
	__IFLA_VF_VLAN_INFO_MAX = 2,
};

enum {
	IFLA_XDP_UNSPEC = 0,
	IFLA_XDP_FD = 1,
	IFLA_XDP_ATTACHED = 2,
	IFLA_XDP_FLAGS = 3,
	IFLA_XDP_PROG_ID = 4,
	IFLA_XDP_DRV_PROG_ID = 5,
	IFLA_XDP_SKB_PROG_ID = 6,
	IFLA_XDP_HW_PROG_ID = 7,
	IFLA_XDP_EXPECTED_FD = 8,
	__IFLA_XDP_MAX = 9,
};

enum {
	IF_ACT_NONE = -1,
	IF_ACT_FILTER = 0,
	IF_ACT_START = 1,
	IF_ACT_STOP = 2,
	IF_SRC_FILE = 3,
	IF_SRC_KERNEL = 4,
	IF_SRC_FILEADDR = 5,
	IF_SRC_KERNELADDR = 6,
};

enum {
	IF_LINK_MODE_DEFAULT = 0,
	IF_LINK_MODE_DORMANT = 1,
	IF_LINK_MODE_TESTING = 2,
};

enum {
	IF_OPER_UNKNOWN = 0,
	IF_OPER_NOTPRESENT = 1,
	IF_OPER_DOWN = 2,
	IF_OPER_LOWERLAYERDOWN = 3,
	IF_OPER_TESTING = 4,
	IF_OPER_DORMANT = 5,
	IF_OPER_UP = 6,
};

enum {
	IF_STATE_ACTION = 0,
	IF_STATE_SOURCE = 1,
	IF_STATE_END = 2,
};

enum {
	IMX_TIMER1MS = 224,
	IMX_P0PHYCR = 376,
	IMX_P0PHYCR_TEST_PDDQ = 1048576,
	IMX_P0PHYCR_CR_READ = 524288,
	IMX_P0PHYCR_CR_WRITE = 262144,
	IMX_P0PHYCR_CR_CAP_DATA = 131072,
	IMX_P0PHYCR_CR_CAP_ADDR = 65536,
	IMX_P0PHYSR = 380,
	IMX_P0PHYSR_CR_ACK = 262144,
	IMX_P0PHYSR_CR_DATA_OUT = 65535,
	IMX_LANE0_OUT_STAT = 8195,
	IMX_LANE0_OUT_STAT_RX_PLL_STATE = 2,
	IMX_CLOCK_RESET = 32575,
	IMX_CLOCK_RESET_RESET = 1,
	IMX8QM_SATA_AHCI_PTC = 200,
	IMX8QM_SATA_AHCI_PTC_RXWM_MASK = 127,
	IMX8QM_SATA_AHCI_PTC_RXWM = 41,
};

enum {
	INET6_IFADDR_STATE_PREDAD = 0,
	INET6_IFADDR_STATE_DAD = 1,
	INET6_IFADDR_STATE_POSTDAD = 2,
	INET6_IFADDR_STATE_ERRDAD = 3,
	INET6_IFADDR_STATE_DEAD = 4,
};

enum {
	INET_DIAG_REQ_NONE = 0,
	INET_DIAG_REQ_BYTECODE = 1,
	INET_DIAG_REQ_SK_BPF_STORAGES = 2,
	INET_DIAG_REQ_PROTOCOL = 3,
	__INET_DIAG_REQ_MAX = 4,
};

enum {
	INET_ECN_NOT_ECT = 0,
	INET_ECN_ECT_1 = 1,
	INET_ECN_ECT_0 = 2,
	INET_ECN_CE = 3,
	INET_ECN_MASK = 3,
};

enum {
	INET_FLAGS_PKTINFO = 0,
	INET_FLAGS_TTL = 1,
	INET_FLAGS_TOS = 2,
	INET_FLAGS_RECVOPTS = 3,
	INET_FLAGS_RETOPTS = 4,
	INET_FLAGS_PASSSEC = 5,
	INET_FLAGS_ORIGDSTADDR = 6,
	INET_FLAGS_CHECKSUM = 7,
	INET_FLAGS_RECVFRAGSIZE = 8,
	INET_FLAGS_RECVERR = 9,
	INET_FLAGS_RECVERR_RFC4884 = 10,
	INET_FLAGS_FREEBIND = 11,
	INET_FLAGS_HDRINCL = 12,
	INET_FLAGS_MC_LOOP = 13,
	INET_FLAGS_MC_ALL = 14,
	INET_FLAGS_TRANSPARENT = 15,
	INET_FLAGS_IS_ICSK = 16,
	INET_FLAGS_NODEFRAG = 17,
	INET_FLAGS_BIND_ADDRESS_NO_PORT = 18,
	INET_FLAGS_DEFER_CONNECT = 19,
	INET_FLAGS_MC6_LOOP = 20,
	INET_FLAGS_RECVERR6_RFC4884 = 21,
	INET_FLAGS_MC6_ALL = 22,
	INET_FLAGS_AUTOFLOWLABEL_SET = 23,
	INET_FLAGS_AUTOFLOWLABEL = 24,
	INET_FLAGS_DONTFRAG = 25,
	INET_FLAGS_RECVERR6 = 26,
	INET_FLAGS_REPFLOW = 27,
	INET_FLAGS_RTALERT_ISOLATE = 28,
	INET_FLAGS_SNDFLOW = 29,
	INET_FLAGS_RTALERT = 30,
};

enum {
	INET_FRAG_FIRST_IN = 1,
	INET_FRAG_LAST_IN = 2,
	INET_FRAG_COMPLETE = 4,
	INET_FRAG_HASH_DEAD = 8,
	INET_FRAG_DROP = 16,
};

enum {
	INET_ULP_INFO_UNSPEC = 0,
	INET_ULP_INFO_NAME = 1,
	INET_ULP_INFO_TLS = 2,
	INET_ULP_INFO_MPTCP = 3,
	__INET_ULP_INFO_MAX = 4,
};

enum {
	INFOFRAME_VSI = 5,
	INFOFRAME_AVI = 6,
	INFOFRAME_AAI = 8,
};

enum {
	INSN_F_FRAMENO_MASK = 7,
	INSN_F_SPI_MASK = 63,
	INSN_F_SPI_SHIFT = 3,
	INSN_F_STACK_ACCESS = 512,
	INSN_F_DST_REG_STACK = 1024,
	INSN_F_SRC_REG_STACK = 2048,
};

enum {
	INTEL_DSM_FNS = 0,
	INTEL_DSM_V18_SWITCH = 3,
	INTEL_DSM_V33_SWITCH = 4,
	INTEL_DSM_DRV_STRENGTH = 9,
	INTEL_DSM_D3_RETUNE = 10,
};

enum {
	IOAM6_ATTR_UNSPEC = 0,
	IOAM6_ATTR_NS_ID = 1,
	IOAM6_ATTR_NS_DATA = 2,
	IOAM6_ATTR_NS_DATA_WIDE = 3,
	IOAM6_ATTR_SC_ID = 4,
	IOAM6_ATTR_SC_DATA = 5,
	IOAM6_ATTR_SC_NONE = 6,
	IOAM6_ATTR_PAD = 7,
	__IOAM6_ATTR_MAX = 8,
};

enum {
	IOAM6_CMD_UNSPEC = 0,
	IOAM6_CMD_ADD_NAMESPACE = 1,
	IOAM6_CMD_DEL_NAMESPACE = 2,
	IOAM6_CMD_DUMP_NAMESPACES = 3,
	IOAM6_CMD_ADD_SCHEMA = 4,
	IOAM6_CMD_DEL_SCHEMA = 5,
	IOAM6_CMD_DUMP_SCHEMAS = 6,
	IOAM6_CMD_NS_SET_SCHEMA = 7,
	__IOAM6_CMD_MAX = 8,
};

enum {
	IOBL_BUF_RING = 1,
	IOBL_INC = 2,
};

enum {
	IOCB_CMD_PREAD = 0,
	IOCB_CMD_PWRITE = 1,
	IOCB_CMD_FSYNC = 2,
	IOCB_CMD_FDSYNC = 3,
	IOCB_CMD_POLL = 5,
	IOCB_CMD_NOOP = 6,
	IOCB_CMD_PREADV = 7,
	IOCB_CMD_PWRITEV = 8,
};

enum {
	IOMMU_PASID_ARRAY_DOMAIN = 0,
	IOMMU_PASID_ARRAY_HANDLE = 1,
};

enum {
	IOMMU_SET_DOMAIN_MUST_SUCCEED = 1,
};

enum {
	IOPRIO_CLASS_NONE = 0,
	IOPRIO_CLASS_RT = 1,
	IOPRIO_CLASS_BE = 2,
	IOPRIO_CLASS_IDLE = 3,
	IOPRIO_CLASS_INVALID = 7,
};

enum {
	IOPRIO_HINT_NONE = 0,
	IOPRIO_HINT_DEV_DURATION_LIMIT_1 = 1,
	IOPRIO_HINT_DEV_DURATION_LIMIT_2 = 2,
	IOPRIO_HINT_DEV_DURATION_LIMIT_3 = 3,
	IOPRIO_HINT_DEV_DURATION_LIMIT_4 = 4,
	IOPRIO_HINT_DEV_DURATION_LIMIT_5 = 5,
	IOPRIO_HINT_DEV_DURATION_LIMIT_6 = 6,
	IOPRIO_HINT_DEV_DURATION_LIMIT_7 = 7,
};

enum {
	IOPRIO_WHO_PROCESS = 1,
	IOPRIO_WHO_PGRP = 2,
	IOPRIO_WHO_USER = 3,
};

enum {
	IORES_DESC_NONE = 0,
	IORES_DESC_CRASH_KERNEL = 1,
	IORES_DESC_ACPI_TABLES = 2,
	IORES_DESC_ACPI_NV_STORAGE = 3,
	IORES_DESC_PERSISTENT_MEMORY = 4,
	IORES_DESC_PERSISTENT_MEMORY_LEGACY = 5,
	IORES_DESC_DEVICE_PRIVATE_MEMORY = 6,
	IORES_DESC_RESERVED = 7,
	IORES_DESC_SOFT_RESERVED = 8,
	IORES_DESC_CXL = 9,
};

enum {
	IORING_MEM_REGION_REG_WAIT_ARG = 1,
};

enum {
	IORING_MEM_REGION_TYPE_USER = 1,
};

enum {
	IORING_REGISTER_SRC_REGISTERED = 1,
	IORING_REGISTER_DST_REPLACE = 2,
};

enum {
	IORING_REG_WAIT_TS = 1,
};

enum {
	IORING_RSRC_FILE = 0,
	IORING_RSRC_BUFFER = 1,
};

enum {
	IOU_COMPLETE = 0,
	IOU_ISSUE_SKIP_COMPLETE = -529,
	IOU_RETRY = -11,
	IOU_REQUEUE = -3072,
};

enum {
	IOU_F_TWQ_LAZY_WAKE = 1,
};

enum {
	IOU_POLL_DONE = 0,
	IOU_POLL_NO_ACTION = 1,
	IOU_POLL_REMOVE_POLL_USE_RES = 2,
	IOU_POLL_REISSUE = 3,
	IOU_POLL_REQUEUE = 4,
};

enum {
	IO_ACCT_STALLED_BIT = 0,
};

enum {
	IO_APOLL_OK = 0,
	IO_APOLL_ABORTED = 1,
	IO_APOLL_READY = 2,
};

enum {
	IO_CHECK_CQ_OVERFLOW_BIT = 0,
	IO_CHECK_CQ_DROPPED_BIT = 1,
};

enum {
	IO_EVENTFD_OP_SIGNAL_BIT = 0,
};

enum {
	IO_IMU_DEST = 1,
	IO_IMU_SOURCE = 2,
};

enum {
	IO_REGION_F_VMAP = 1,
	IO_REGION_F_USER_PROVIDED = 2,
	IO_REGION_F_SINGLE_REF = 4,
};

enum {
	IO_SQ_THREAD_SHOULD_STOP = 0,
	IO_SQ_THREAD_SHOULD_PARK = 1,
};

enum {
	IO_TREE_FS_PINNED_EXTENTS = 0,
	IO_TREE_FS_EXCLUDED_EXTENTS = 1,
	IO_TREE_BTREE_INODE_IO = 2,
	IO_TREE_INODE_IO = 3,
	IO_TREE_RELOC_BLOCKS = 4,
	IO_TREE_TRANS_DIRTY_PAGES = 5,
	IO_TREE_ROOT_DIRTY_LOG_PAGES = 6,
	IO_TREE_INODE_FILE_EXTENT = 7,
	IO_TREE_LOG_CSUM_RANGE = 8,
	IO_TREE_SELFTEST = 9,
	IO_TREE_DEVICE_ALLOC_STATE = 10,
};

enum {
	IO_WORKER_F_UP = 0,
	IO_WORKER_F_RUNNING = 1,
	IO_WORKER_F_FREE = 2,
};

enum {
	IO_WQ_ACCT_BOUND = 0,
	IO_WQ_ACCT_UNBOUND = 1,
	IO_WQ_ACCT_NR = 2,
};

enum {
	IO_WQ_BIT_EXIT = 0,
};

enum {
	IO_WQ_WORK_CANCEL = 1,
	IO_WQ_WORK_HASHED = 2,
	IO_WQ_WORK_UNBOUND = 4,
	IO_WQ_WORK_CONCURRENT = 16,
	IO_WQ_HASH_SHIFT = 24,
};

enum {
	IP6MRA_CREPORT_UNSPEC = 0,
	IP6MRA_CREPORT_MSGTYPE = 1,
	IP6MRA_CREPORT_MIF_ID = 2,
	IP6MRA_CREPORT_SRC_ADDR = 3,
	IP6MRA_CREPORT_DST_ADDR = 4,
	IP6MRA_CREPORT_PKT = 5,
	__IP6MRA_CREPORT_MAX = 6,
};

enum {
	IP6_FH_F_FRAG = 1,
	IP6_FH_F_AUTH = 2,
	IP6_FH_F_SKIP_RH = 4,
};

enum {
	IPMRA_CREPORT_UNSPEC = 0,
	IPMRA_CREPORT_MSGTYPE = 1,
	IPMRA_CREPORT_VIF_ID = 2,
	IPMRA_CREPORT_SRC_ADDR = 3,
	IPMRA_CREPORT_DST_ADDR = 4,
	IPMRA_CREPORT_PKT = 5,
	IPMRA_CREPORT_TABLE = 6,
	__IPMRA_CREPORT_MAX = 7,
};

enum {
	IPMRA_TABLE_UNSPEC = 0,
	IPMRA_TABLE_ID = 1,
	IPMRA_TABLE_CACHE_RES_QUEUE_LEN = 2,
	IPMRA_TABLE_MROUTE_REG_VIF_NUM = 3,
	IPMRA_TABLE_MROUTE_DO_ASSERT = 4,
	IPMRA_TABLE_MROUTE_DO_PIM = 5,
	IPMRA_TABLE_VIFS = 6,
	IPMRA_TABLE_MROUTE_DO_WRVIFWHOLE = 7,
	__IPMRA_TABLE_MAX = 8,
};

enum {
	IPMRA_VIFA_UNSPEC = 0,
	IPMRA_VIFA_IFINDEX = 1,
	IPMRA_VIFA_VIF_ID = 2,
	IPMRA_VIFA_FLAGS = 3,
	IPMRA_VIFA_BYTES_IN = 4,
	IPMRA_VIFA_BYTES_OUT = 5,
	IPMRA_VIFA_PACKETS_IN = 6,
	IPMRA_VIFA_PACKETS_OUT = 7,
	IPMRA_VIFA_LOCAL_ADDR = 8,
	IPMRA_VIFA_REMOTE_ADDR = 9,
	IPMRA_VIFA_PAD = 10,
	__IPMRA_VIFA_MAX = 11,
};

enum {
	IPMRA_VIF_UNSPEC = 0,
	IPMRA_VIF = 1,
	__IPMRA_VIF_MAX = 2,
};

enum {
	IPPROTO_IP = 0,
	IPPROTO_ICMP = 1,
	IPPROTO_IGMP = 2,
	IPPROTO_IPIP = 4,
	IPPROTO_TCP = 6,
	IPPROTO_EGP = 8,
	IPPROTO_PUP = 12,
	IPPROTO_UDP = 17,
	IPPROTO_IDP = 22,
	IPPROTO_TP = 29,
	IPPROTO_DCCP = 33,
	IPPROTO_IPV6 = 41,
	IPPROTO_RSVP = 46,
	IPPROTO_GRE = 47,
	IPPROTO_ESP = 50,
	IPPROTO_AH = 51,
	IPPROTO_MTP = 92,
	IPPROTO_BEETPH = 94,
	IPPROTO_ENCAP = 98,
	IPPROTO_PIM = 103,
	IPPROTO_COMP = 108,
	IPPROTO_L2TP = 115,
	IPPROTO_SCTP = 132,
	IPPROTO_UDPLITE = 136,
	IPPROTO_MPLS = 137,
	IPPROTO_ETHERNET = 143,
	IPPROTO_AGGFRAG = 144,
	IPPROTO_RAW = 255,
	IPPROTO_SMC = 256,
	IPPROTO_MPTCP = 262,
	IPPROTO_MAX = 263,
};

enum {
	IPSTATS_MIB_NUM = 0,
	IPSTATS_MIB_INPKTS = 1,
	IPSTATS_MIB_INOCTETS = 2,
	IPSTATS_MIB_INDELIVERS = 3,
	IPSTATS_MIB_NOECTPKTS = 4,
	IPSTATS_MIB_ECT1PKTS = 5,
	IPSTATS_MIB_ECT0PKTS = 6,
	IPSTATS_MIB_CEPKTS = 7,
	IPSTATS_MIB_OUTREQUESTS = 8,
	IPSTATS_MIB_OUTPKTS = 9,
	IPSTATS_MIB_OUTOCTETS = 10,
	IPSTATS_MIB_OUTFORWDATAGRAMS = 11,
	IPSTATS_MIB_INHDRERRORS = 12,
	IPSTATS_MIB_INTOOBIGERRORS = 13,
	IPSTATS_MIB_INNOROUTES = 14,
	IPSTATS_MIB_INADDRERRORS = 15,
	IPSTATS_MIB_INUNKNOWNPROTOS = 16,
	IPSTATS_MIB_INTRUNCATEDPKTS = 17,
	IPSTATS_MIB_INDISCARDS = 18,
	IPSTATS_MIB_OUTDISCARDS = 19,
	IPSTATS_MIB_OUTNOROUTES = 20,
	IPSTATS_MIB_REASMTIMEOUT = 21,
	IPSTATS_MIB_REASMREQDS = 22,
	IPSTATS_MIB_REASMOKS = 23,
	IPSTATS_MIB_REASMFAILS = 24,
	IPSTATS_MIB_FRAGOKS = 25,
	IPSTATS_MIB_FRAGFAILS = 26,
	IPSTATS_MIB_FRAGCREATES = 27,
	IPSTATS_MIB_INMCASTPKTS = 28,
	IPSTATS_MIB_OUTMCASTPKTS = 29,
	IPSTATS_MIB_INBCASTPKTS = 30,
	IPSTATS_MIB_OUTBCASTPKTS = 31,
	IPSTATS_MIB_INMCASTOCTETS = 32,
	IPSTATS_MIB_OUTMCASTOCTETS = 33,
	IPSTATS_MIB_INBCASTOCTETS = 34,
	IPSTATS_MIB_OUTBCASTOCTETS = 35,
	IPSTATS_MIB_CSUMERRORS = 36,
	IPSTATS_MIB_REASM_OVERLAPS = 37,
	__IPSTATS_MIB_MAX = 38,
};

enum {
	IPV4_DEVCONF_FORWARDING = 1,
	IPV4_DEVCONF_MC_FORWARDING = 2,
	IPV4_DEVCONF_PROXY_ARP = 3,
	IPV4_DEVCONF_ACCEPT_REDIRECTS = 4,
	IPV4_DEVCONF_SECURE_REDIRECTS = 5,
	IPV4_DEVCONF_SEND_REDIRECTS = 6,
	IPV4_DEVCONF_SHARED_MEDIA = 7,
	IPV4_DEVCONF_RP_FILTER = 8,
	IPV4_DEVCONF_ACCEPT_SOURCE_ROUTE = 9,
	IPV4_DEVCONF_BOOTP_RELAY = 10,
	IPV4_DEVCONF_LOG_MARTIANS = 11,
	IPV4_DEVCONF_TAG = 12,
	IPV4_DEVCONF_ARPFILTER = 13,
	IPV4_DEVCONF_MEDIUM_ID = 14,
	IPV4_DEVCONF_NOXFRM = 15,
	IPV4_DEVCONF_NOPOLICY = 16,
	IPV4_DEVCONF_FORCE_IGMP_VERSION = 17,
	IPV4_DEVCONF_ARP_ANNOUNCE = 18,
	IPV4_DEVCONF_ARP_IGNORE = 19,
	IPV4_DEVCONF_PROMOTE_SECONDARIES = 20,
	IPV4_DEVCONF_ARP_ACCEPT = 21,
	IPV4_DEVCONF_ARP_NOTIFY = 22,
	IPV4_DEVCONF_ACCEPT_LOCAL = 23,
	IPV4_DEVCONF_SRC_VMARK = 24,
	IPV4_DEVCONF_PROXY_ARP_PVLAN = 25,
	IPV4_DEVCONF_ROUTE_LOCALNET = 26,
	IPV4_DEVCONF_IGMPV2_UNSOLICITED_REPORT_INTERVAL = 27,
	IPV4_DEVCONF_IGMPV3_UNSOLICITED_REPORT_INTERVAL = 28,
	IPV4_DEVCONF_IGNORE_ROUTES_WITH_LINKDOWN = 29,
	IPV4_DEVCONF_DROP_UNICAST_IN_L2_MULTICAST = 30,
	IPV4_DEVCONF_DROP_GRATUITOUS_ARP = 31,
	IPV4_DEVCONF_BC_FORWARDING = 32,
	IPV4_DEVCONF_ARP_EVICT_NOCARRIER = 33,
	__IPV4_DEVCONF_MAX = 34,
};

enum {
	IPV6_SADDR_RULE_INIT = 0,
	IPV6_SADDR_RULE_LOCAL = 1,
	IPV6_SADDR_RULE_SCOPE = 2,
	IPV6_SADDR_RULE_PREFERRED = 3,
	IPV6_SADDR_RULE_HOA = 4,
	IPV6_SADDR_RULE_OIF = 5,
	IPV6_SADDR_RULE_LABEL = 6,
	IPV6_SADDR_RULE_PRIVACY = 7,
	IPV6_SADDR_RULE_ORCHID = 8,
	IPV6_SADDR_RULE_PREFIX = 9,
	IPV6_SADDR_RULE_NOT_OPTIMISTIC = 10,
	IPV6_SADDR_RULE_MAX = 11,
};

enum {
	IP_TUNNEL_CSUM_BIT = 0,
	IP_TUNNEL_ROUTING_BIT = 1,
	IP_TUNNEL_KEY_BIT = 2,
	IP_TUNNEL_SEQ_BIT = 3,
	IP_TUNNEL_STRICT_BIT = 4,
	IP_TUNNEL_REC_BIT = 5,
	IP_TUNNEL_VERSION_BIT = 6,
	IP_TUNNEL_NO_KEY_BIT = 7,
	IP_TUNNEL_DONT_FRAGMENT_BIT = 8,
	IP_TUNNEL_OAM_BIT = 9,
	IP_TUNNEL_CRIT_OPT_BIT = 10,
	IP_TUNNEL_GENEVE_OPT_BIT = 11,
	IP_TUNNEL_VXLAN_OPT_BIT = 12,
	IP_TUNNEL_NOCACHE_BIT = 13,
	IP_TUNNEL_ERSPAN_OPT_BIT = 14,
	IP_TUNNEL_GTP_OPT_BIT = 15,
	IP_TUNNEL_VTI_BIT = 16,
	IP_TUNNEL_SIT_ISATAP_BIT = 16,
	IP_TUNNEL_PFCP_OPT_BIT = 17,
	__IP_TUNNEL_FLAG_NUM = 18,
};

enum {
	IRQCHIP_FWNODE_REAL = 0,
	IRQCHIP_FWNODE_NAMED = 1,
	IRQCHIP_FWNODE_NAMED_ID = 2,
};

enum {
	IRQCHIP_SET_TYPE_MASKED = 1,
	IRQCHIP_EOI_IF_HANDLED = 2,
	IRQCHIP_MASK_ON_SUSPEND = 4,
	IRQCHIP_ONOFFLINE_ENABLED = 8,
	IRQCHIP_SKIP_SET_WAKE = 16,
	IRQCHIP_ONESHOT_SAFE = 32,
	IRQCHIP_EOI_THREADED = 64,
	IRQCHIP_SUPPORTS_LEVEL_MSI = 128,
	IRQCHIP_SUPPORTS_NMI = 256,
	IRQCHIP_ENABLE_WAKEUP_ON_SUSPEND = 512,
	IRQCHIP_AFFINITY_PRE_STARTUP = 1024,
	IRQCHIP_IMMUTABLE = 2048,
	IRQCHIP_MOVE_DEFERRED = 4096,
};

enum {
	IRQC_IS_HARDIRQ = 0,
	IRQC_IS_NESTED = 1,
};

enum {
	IRQD_TRIGGER_MASK = 15,
	IRQD_SETAFFINITY_PENDING = 256,
	IRQD_ACTIVATED = 512,
	IRQD_NO_BALANCING = 1024,
	IRQD_PER_CPU = 2048,
	IRQD_AFFINITY_SET = 4096,
	IRQD_LEVEL = 8192,
	IRQD_WAKEUP_STATE = 16384,
	IRQD_IRQ_DISABLED = 65536,
	IRQD_IRQ_MASKED = 131072,
	IRQD_IRQ_INPROGRESS = 262144,
	IRQD_WAKEUP_ARMED = 524288,
	IRQD_FORWARDED_TO_VCPU = 1048576,
	IRQD_AFFINITY_MANAGED = 2097152,
	IRQD_IRQ_STARTED = 4194304,
	IRQD_MANAGED_SHUTDOWN = 8388608,
	IRQD_SINGLE_TARGET = 16777216,
	IRQD_DEFAULT_TRIGGER_SET = 33554432,
	IRQD_CAN_RESERVE = 67108864,
	IRQD_HANDLE_ENFORCE_IRQCTX = 134217728,
	IRQD_AFFINITY_ON_ACTIVATE = 268435456,
	IRQD_IRQ_ENABLED_ON_SUSPEND = 536870912,
	IRQD_RESEND_WHEN_IN_PROGRESS = 1073741824,
};

enum {
	IRQS_AUTODETECT = 1,
	IRQS_SPURIOUS_DISABLED = 2,
	IRQS_POLL_INPROGRESS = 8,
	IRQS_ONESHOT = 32,
	IRQS_REPLAY = 64,
	IRQS_WAITING = 128,
	IRQS_PENDING = 512,
	IRQS_SUSPENDED = 2048,
	IRQS_TIMINGS = 4096,
	IRQS_NMI = 8192,
	IRQS_SYSFS = 16384,
};

enum {
	IRQTF_RUNTHREAD = 0,
	IRQTF_WARNED = 1,
	IRQTF_AFFINITY = 2,
	IRQTF_FORCED_THREAD = 3,
	IRQTF_READY = 4,
};

enum {
	IRQ_DOMAIN_FLAG_HIERARCHY = 1,
	IRQ_DOMAIN_NAME_ALLOCATED = 2,
	IRQ_DOMAIN_FLAG_IPI_PER_CPU = 4,
	IRQ_DOMAIN_FLAG_IPI_SINGLE = 8,
	IRQ_DOMAIN_FLAG_MSI = 16,
	IRQ_DOMAIN_FLAG_ISOLATED_MSI = 32,
	IRQ_DOMAIN_FLAG_NO_MAP = 64,
	IRQ_DOMAIN_FLAG_MSI_PARENT = 256,
	IRQ_DOMAIN_FLAG_MSI_DEVICE = 512,
	IRQ_DOMAIN_FLAG_DESTROY_GC = 1024,
	IRQ_DOMAIN_FLAG_MSI_IMMUTABLE = 2048,
	IRQ_DOMAIN_FLAG_NONCORE = 65536,
};

enum {
	IRQ_POLL_F_SCHED = 0,
	IRQ_POLL_F_DISABLE = 1,
};

enum {
	IRQ_SET_MASK_OK = 0,
	IRQ_SET_MASK_OK_NOCOPY = 1,
	IRQ_SET_MASK_OK_DONE = 2,
};

enum {
	IRQ_STARTUP_NORMAL = 0,
	IRQ_STARTUP_MANAGED = 1,
	IRQ_STARTUP_ABORT = 2,
};

enum {
	IRQ_TYPE_NONE = 0,
	IRQ_TYPE_EDGE_RISING = 1,
	IRQ_TYPE_EDGE_FALLING = 2,
	IRQ_TYPE_EDGE_BOTH = 3,
	IRQ_TYPE_LEVEL_HIGH = 4,
	IRQ_TYPE_LEVEL_LOW = 8,
	IRQ_TYPE_LEVEL_MASK = 12,
	IRQ_TYPE_SENSE_MASK = 15,
	IRQ_TYPE_DEFAULT = 15,
	IRQ_TYPE_PROBE = 16,
	IRQ_LEVEL = 256,
	IRQ_PER_CPU = 512,
	IRQ_NOPROBE = 1024,
	IRQ_NOREQUEST = 2048,
	IRQ_NOAUTOEN = 4096,
	IRQ_NO_BALANCING = 8192,
	IRQ_NESTED_THREAD = 32768,
	IRQ_NOTHREAD = 65536,
	IRQ_PER_CPU_DEVID = 131072,
	IRQ_IS_POLLED = 262144,
	IRQ_DISABLE_UNLAZY = 524288,
	IRQ_HIDDEN = 1048576,
	IRQ_NO_DEBUG = 2097152,
};

enum {
	ISCSI_CONN_INITIAL_STAGE = 0,
	ISCSI_CONN_STARTED = 1,
	ISCSI_CONN_STOPPED = 2,
	ISCSI_CONN_CLEANUP_WAIT = 3,
};

enum {
	ISCSI_HOST_SETUP = 0,
	ISCSI_HOST_REMOVED = 1,
};

enum {
	ISCSI_MAX_AHS_SIZE = 256,
	ISCSI_DIGEST_SIZE = 4,
};

enum {
	ISCSI_SESSION_LOGGED_IN = 0,
	ISCSI_SESSION_FAILED = 1,
	ISCSI_SESSION_FREE = 2,
};

enum {
	ISCSI_SESSION_TARGET_UNBOUND = 0,
	ISCSI_SESSION_TARGET_ALLOCATED = 1,
	ISCSI_SESSION_TARGET_SCANNED = 2,
	ISCSI_SESSION_TARGET_UNBINDING = 3,
	ISCSI_SESSION_TARGET_MAX = 4,
};

enum {
	ISCSI_STATE_FREE = 1,
	ISCSI_STATE_LOGGED_IN = 2,
	ISCSI_STATE_FAILED = 3,
	ISCSI_STATE_TERMINATE = 4,
	ISCSI_STATE_IN_RECOVERY = 5,
	ISCSI_STATE_RECOVERY_FAILED = 6,
	ISCSI_STATE_LOGGING_OUT = 7,
};

enum {
	ISCSI_TASK_FREE = 0,
	ISCSI_TASK_COMPLETED = 1,
	ISCSI_TASK_PENDING = 2,
	ISCSI_TASK_RUNNING = 3,
	ISCSI_TASK_ABRT_TMF = 4,
	ISCSI_TASK_ABRT_SESS_RECOV = 5,
	ISCSI_TASK_REQUEUE_SCSIQ = 6,
};

enum {
	ISCSI_TCP_SEGMENT_DONE = 0,
	ISCSI_TCP_SKB_DONE = 1,
	ISCSI_TCP_CONN_ERR = 2,
	ISCSI_TCP_SUSPENDED = 3,
};

enum {
	IS_CHECKPOINTED = 0,
	HAS_FSYNCED_INODE = 1,
	HAS_LAST_FSYNC = 2,
	IS_DIRTY = 3,
	IS_PREALLOC = 4,
};

enum {
	IU_ID_COMMAND = 1,
	IU_ID_STATUS = 3,
	IU_ID_RESPONSE = 4,
	IU_ID_TASK_MGMT = 5,
	IU_ID_READ_READY = 6,
	IU_ID_WRITE_READY = 7,
};

enum {
	I_DATA_SEM_NORMAL = 0,
	I_DATA_SEM_OTHER = 1,
	I_DATA_SEM_QUOTA = 2,
	I_DATA_SEM_EA = 3,
};

enum {
	I_LCOEF_RBPS = 0,
	I_LCOEF_RSEQIOPS = 1,
	I_LCOEF_RRANDIOPS = 2,
	I_LCOEF_WBPS = 3,
	I_LCOEF_WSEQIOPS = 4,
	I_LCOEF_WRANDIOPS = 5,
	NR_I_LCOEFS = 6,
};

enum {
	KBUF_MODE_EXPAND = 1,
	KBUF_MODE_FREE = 2,
};

enum {
	KDB_NOT_INITIALIZED = 0,
	KDB_INIT_EARLY = 1,
	KDB_INIT_FULL = 2,
};

enum {
	KERNEL_PARAM_FL_UNSAFE = 1,
	KERNEL_PARAM_FL_HWPARAM = 2,
};

enum {
	KERNEL_PARAM_OPS_FL_NOARG = 1,
};

enum {
	KF_ARG_DYNPTR_ID = 0,
	KF_ARG_LIST_HEAD_ID = 1,
	KF_ARG_LIST_NODE_ID = 2,
	KF_ARG_RB_ROOT_ID = 3,
	KF_ARG_RB_NODE_ID = 4,
	KF_ARG_WORKQUEUE_ID = 5,
	KF_ARG_RES_SPIN_LOCK_ID = 6,
};

enum {
	KTW_FREEZABLE = 1,
};

enum {
	KYBER_ASYNC_PERCENT = 75,
};

enum {
	KYBER_LATENCY_SHIFT = 2,
	KYBER_GOOD_BUCKETS = 4,
	KYBER_LATENCY_BUCKETS = 8,
};

enum {
	KYBER_READ = 0,
	KYBER_WRITE = 1,
	KYBER_DISCARD = 2,
	KYBER_OTHER = 3,
	KYBER_NUM_DOMAINS = 4,
};

enum {
	KYBER_TOTAL_LATENCY = 0,
	KYBER_IO_LATENCY = 1,
};

enum {
	LAST_NORM = 0,
	LAST_ROOT = 1,
	LAST_DOT = 2,
	LAST_DOTDOT = 3,
};

enum {
	LAT_OK = 1,
	LAT_UNKNOWN = 2,
	LAT_UNKNOWN_WRITES = 3,
	LAT_EXCEEDED = 4,
};

enum {
	LCOEF_RPAGE = 0,
	LCOEF_RSEQIO = 1,
	LCOEF_RRANDIO = 2,
	LCOEF_WPAGE = 3,
	LCOEF_WSEQIO = 4,
	LCOEF_WRANDIO = 5,
	NR_LCOEFS = 6,
};

enum {
	LEB_FREED = 0,
	LEB_FREED_IDX = 1,
	LEB_RETAINED = 2,
};

enum {
	LFS = 0,
	SSR = 1,
	AT_SSR = 2,
};

enum {
	LIBATA_MAX_PRD = 128,
	LIBATA_DUMB_MAX_PRD = 64,
	ATA_DEF_QUEUE = 1,
	ATA_MAX_QUEUE = 32,
	ATA_TAG_INTERNAL = 32,
	ATA_SHORT_PAUSE = 16,
	ATAPI_MAX_DRAIN = 16384,
	ATA_ALL_DEVICES = 3,
	ATA_SHT_EMULATED = 1,
	ATA_SHT_THIS_ID = -1,
	ATA_TFLAG_LBA48 = 1,
	ATA_TFLAG_ISADDR = 2,
	ATA_TFLAG_DEVICE = 4,
	ATA_TFLAG_WRITE = 8,
	ATA_TFLAG_LBA = 16,
	ATA_TFLAG_FUA = 32,
	ATA_TFLAG_POLLING = 64,
	ATA_DFLAG_LBA = 1,
	ATA_DFLAG_LBA48 = 2,
	ATA_DFLAG_CDB_INTR = 4,
	ATA_DFLAG_NCQ = 8,
	ATA_DFLAG_FLUSH_EXT = 16,
	ATA_DFLAG_ACPI_PENDING = 32,
	ATA_DFLAG_ACPI_FAILED = 64,
	ATA_DFLAG_AN = 128,
	ATA_DFLAG_TRUSTED = 256,
	ATA_DFLAG_FUA = 512,
	ATA_DFLAG_DMADIR = 1024,
	ATA_DFLAG_NCQ_SEND_RECV = 2048,
	ATA_DFLAG_NCQ_PRIO = 4096,
	ATA_DFLAG_CDL = 8192,
	ATA_DFLAG_CFG_MASK = 16383,
	ATA_DFLAG_PIO = 16384,
	ATA_DFLAG_NCQ_OFF = 32768,
	ATA_DFLAG_SLEEPING = 65536,
	ATA_DFLAG_DUBIOUS_XFER = 131072,
	ATA_DFLAG_NO_UNLOAD = 262144,
	ATA_DFLAG_UNLOCK_HPA = 524288,
	ATA_DFLAG_INIT_MASK = 1048575,
	ATA_DFLAG_NCQ_PRIO_ENABLED = 1048576,
	ATA_DFLAG_CDL_ENABLED = 2097152,
	ATA_DFLAG_RESUMING = 4194304,
	ATA_DFLAG_DETACH = 16777216,
	ATA_DFLAG_DETACHED = 33554432,
	ATA_DFLAG_DA = 67108864,
	ATA_DFLAG_DEVSLP = 134217728,
	ATA_DFLAG_ACPI_DISABLED = 268435456,
	ATA_DFLAG_D_SENSE = 536870912,
	ATA_DFLAG_ZAC = 1073741824,
	ATA_DFLAG_FEATURES_MASK = 201341696,
	ATA_DEV_UNKNOWN = 0,
	ATA_DEV_ATA = 1,
	ATA_DEV_ATA_UNSUP = 2,
	ATA_DEV_ATAPI = 3,
	ATA_DEV_ATAPI_UNSUP = 4,
	ATA_DEV_PMP = 5,
	ATA_DEV_PMP_UNSUP = 6,
	ATA_DEV_SEMB = 7,
	ATA_DEV_SEMB_UNSUP = 8,
	ATA_DEV_ZAC = 9,
	ATA_DEV_ZAC_UNSUP = 10,
	ATA_DEV_NONE = 11,
	ATA_LFLAG_NO_HRST = 2,
	ATA_LFLAG_NO_SRST = 4,
	ATA_LFLAG_ASSUME_ATA = 8,
	ATA_LFLAG_ASSUME_SEMB = 16,
	ATA_LFLAG_ASSUME_CLASS = 24,
	ATA_LFLAG_NO_RETRY = 32,
	ATA_LFLAG_DISABLED = 64,
	ATA_LFLAG_SW_ACTIVITY = 128,
	ATA_LFLAG_NO_LPM = 256,
	ATA_LFLAG_RST_ONCE = 512,
	ATA_LFLAG_CHANGED = 1024,
	ATA_LFLAG_NO_DEBOUNCE_DELAY = 2048,
	ATA_FLAG_SLAVE_POSS = 1,
	ATA_FLAG_SATA = 2,
	ATA_FLAG_NO_LPM = 4,
	ATA_FLAG_NO_LOG_PAGE = 32,
	ATA_FLAG_NO_ATAPI = 64,
	ATA_FLAG_PIO_DMA = 128,
	ATA_FLAG_PIO_LBA48 = 256,
	ATA_FLAG_PIO_POLLING = 512,
	ATA_FLAG_NCQ = 1024,
	ATA_FLAG_NO_POWEROFF_SPINDOWN = 2048,
	ATA_FLAG_NO_HIBERNATE_SPINDOWN = 4096,
	ATA_FLAG_DEBUGMSG = 8192,
	ATA_FLAG_FPDMA_AA = 16384,
	ATA_FLAG_IGN_SIMPLEX = 32768,
	ATA_FLAG_NO_IORDY = 65536,
	ATA_FLAG_ACPI_SATA = 131072,
	ATA_FLAG_AN = 262144,
	ATA_FLAG_PMP = 524288,
	ATA_FLAG_FPDMA_AUX = 1048576,
	ATA_FLAG_EM = 2097152,
	ATA_FLAG_SW_ACTIVITY = 4194304,
	ATA_FLAG_NO_DIPM = 8388608,
	ATA_FLAG_SAS_HOST = 16777216,
	ATA_PFLAG_EH_PENDING = 1,
	ATA_PFLAG_EH_IN_PROGRESS = 2,
	ATA_PFLAG_FROZEN = 4,
	ATA_PFLAG_RECOVERED = 8,
	ATA_PFLAG_LOADING = 16,
	ATA_PFLAG_SCSI_HOTPLUG = 64,
	ATA_PFLAG_INITIALIZING = 128,
	ATA_PFLAG_RESETTING = 256,
	ATA_PFLAG_UNLOADING = 512,
	ATA_PFLAG_UNLOADED = 1024,
	ATA_PFLAG_RESUMING = 65536,
	ATA_PFLAG_SUSPENDED = 131072,
	ATA_PFLAG_PM_PENDING = 262144,
	ATA_PFLAG_INIT_GTM_VALID = 524288,
	ATA_PFLAG_PIO32 = 1048576,
	ATA_PFLAG_PIO32CHANGE = 2097152,
	ATA_PFLAG_EXTERNAL = 4194304,
	ATA_QCFLAG_ACTIVE = 1,
	ATA_QCFLAG_DMAMAP = 2,
	ATA_QCFLAG_RTF_FILLED = 4,
	ATA_QCFLAG_IO = 8,
	ATA_QCFLAG_RESULT_TF = 16,
	ATA_QCFLAG_CLEAR_EXCL = 32,
	ATA_QCFLAG_QUIET = 64,
	ATA_QCFLAG_RETRY = 128,
	ATA_QCFLAG_HAS_CDL = 256,
	ATA_QCFLAG_EH = 65536,
	ATA_QCFLAG_SENSE_VALID = 131072,
	ATA_QCFLAG_EH_SCHEDULED = 262144,
	ATA_QCFLAG_EH_SUCCESS_CMD = 524288,
	ATA_HOST_SIMPLEX = 1,
	ATA_HOST_STARTED = 2,
	ATA_HOST_PARALLEL_SCAN = 4,
	ATA_HOST_IGNORE_ATA = 8,
	ATA_HOST_NO_PART = 16,
	ATA_HOST_NO_SSC = 32,
	ATA_HOST_NO_DEVSLP = 64,
	ATA_TMOUT_INTERNAL_QUICK = 5000,
	ATA_TMOUT_MAX_PARK = 30000,
	ATA_TMOUT_FF_WAIT_LONG = 2000,
	ATA_TMOUT_FF_WAIT = 800,
	ATA_WAIT_AFTER_RESET = 150,
	ATA_TMOUT_PMP_SRST_WAIT = 10000,
	ATA_TMOUT_SPURIOUS_PHY = 10000,
	BUS_UNKNOWN = 0,
	BUS_DMA = 1,
	BUS_IDLE = 2,
	BUS_NOINTR = 3,
	BUS_NODATA = 4,
	BUS_TIMER = 5,
	BUS_PIO = 6,
	BUS_EDD = 7,
	BUS_IDENTIFY = 8,
	BUS_PACKET = 9,
	PORT_UNKNOWN = 0,
	PORT_ENABLED = 1,
	PORT_DISABLED = 2,
	ATA_NR_PIO_MODES = 7,
	ATA_NR_MWDMA_MODES = 5,
	ATA_NR_UDMA_MODES = 8,
	ATA_SHIFT_PIO = 0,
	ATA_SHIFT_MWDMA = 7,
	ATA_SHIFT_UDMA = 12,
	ATA_SHIFT_PRIO = 6,
	ATA_PRIO_HIGH = 2,
	ATA_DMA_PAD_SZ = 4,
	ATA_ERING_SIZE = 32,
	ATA_DEFER_LINK = 1,
	ATA_DEFER_PORT = 2,
	ATA_EH_DESC_LEN = 80,
	ATA_EH_REVALIDATE = 1,
	ATA_EH_SOFTRESET = 2,
	ATA_EH_HARDRESET = 4,
	ATA_EH_RESET = 6,
	ATA_EH_ENABLE_LINK = 8,
	ATA_EH_PARK = 32,
	ATA_EH_GET_SUCCESS_SENSE = 64,
	ATA_EH_SET_ACTIVE = 128,
	ATA_EH_PERDEV_MASK = 225,
	ATA_EH_ALL_ACTIONS = 15,
	ATA_EHI_HOTPLUGGED = 1,
	ATA_EHI_NO_AUTOPSY = 4,
	ATA_EHI_QUIET = 8,
	ATA_EHI_NO_RECOVERY = 16,
	ATA_EHI_DID_SOFTRESET = 65536,
	ATA_EHI_DID_HARDRESET = 131072,
	ATA_EHI_PRINTINFO = 262144,
	ATA_EHI_SETMODE = 524288,
	ATA_EHI_POST_SETMODE = 1048576,
	ATA_EHI_DID_PRINT_QUIRKS = 2097152,
	ATA_EHI_DID_RESET = 196608,
	ATA_EHI_TO_SLAVE_MASK = 12,
	ATA_EH_MAX_TRIES = 5,
	ATA_LINK_RESUME_TRIES = 5,
	ATA_EH_DEV_TRIES = 3,
	ATA_EH_PMP_TRIES = 5,
	ATA_EH_PMP_LINK_TRIES = 3,
	SATA_PMP_RW_TIMEOUT = 3000,
	ATA_EH_CMD_TIMEOUT_TABLE_SIZE = 8,
	ATA_QUIRK_DIAGNOSTIC = 1,
	ATA_QUIRK_NODMA = 2,
	ATA_QUIRK_NONCQ = 4,
	ATA_QUIRK_MAX_SEC_128 = 8,
	ATA_QUIRK_BROKEN_HPA = 16,
	ATA_QUIRK_DISABLE = 32,
	ATA_QUIRK_HPA_SIZE = 64,
	ATA_QUIRK_IVB = 128,
	ATA_QUIRK_STUCK_ERR = 256,
	ATA_QUIRK_BRIDGE_OK = 512,
	ATA_QUIRK_ATAPI_MOD16_DMA = 1024,
	ATA_QUIRK_FIRMWARE_WARN = 2048,
	ATA_QUIRK_1_5_GBPS = 4096,
	ATA_QUIRK_NOSETXFER = 8192,
	ATA_QUIRK_BROKEN_FPDMA_AA = 16384,
	ATA_QUIRK_DUMP_ID = 32768,
	ATA_QUIRK_MAX_SEC_LBA48 = 65536,
	ATA_QUIRK_ATAPI_DMADIR = 131072,
	ATA_QUIRK_NO_NCQ_TRIM = 262144,
	ATA_QUIRK_NOLPM = 524288,
	ATA_QUIRK_WD_BROKEN_LPM = 1048576,
	ATA_QUIRK_ZERO_AFTER_TRIM = 2097152,
	ATA_QUIRK_NO_DMA_LOG = 4194304,
	ATA_QUIRK_NOTRIM = 8388608,
	ATA_QUIRK_MAX_SEC_1024 = 16777216,
	ATA_QUIRK_MAX_TRIM_128M = 33554432,
	ATA_QUIRK_NO_NCQ_ON_ATI = 67108864,
	ATA_QUIRK_NO_LPM_ON_ATI = 134217728,
	ATA_QUIRK_NO_ID_DEV_LOG = 268435456,
	ATA_QUIRK_NO_LOG_DIR = 536870912,
	ATA_QUIRK_NO_FUA = 1073741824,
	ATA_DMA_MASK_ATA = 1,
	ATA_DMA_MASK_ATAPI = 2,
	ATA_DMA_MASK_CFA = 4,
	ATAPI_READ = 0,
	ATAPI_WRITE = 1,
	ATAPI_READ_CD = 2,
	ATAPI_PASS_THRU = 3,
	ATAPI_MISC = 4,
	ATA_TIMING_SETUP = 1,
	ATA_TIMING_ACT8B = 2,
	ATA_TIMING_REC8B = 4,
	ATA_TIMING_CYC8B = 8,
	ATA_TIMING_8BIT = 14,
	ATA_TIMING_ACTIVE = 16,
	ATA_TIMING_RECOVER = 32,
	ATA_TIMING_DMACK_HOLD = 64,
	ATA_TIMING_CYCLE = 128,
	ATA_TIMING_UDMA = 256,
	ATA_TIMING_ALL = 511,
	ATA_ACPI_FILTER_SETXFER = 1,
	ATA_ACPI_FILTER_LOCK = 2,
	ATA_ACPI_FILTER_DIPM = 4,
	ATA_ACPI_FILTER_FPDMA_OFFSET = 8,
	ATA_ACPI_FILTER_FPDMA_AA = 16,
	ATA_ACPI_FILTER_DEFAULT = 7,
};

enum {
	LINK_CAPA_10HD = 0,
	LINK_CAPA_10FD = 1,
	LINK_CAPA_100HD = 2,
	LINK_CAPA_100FD = 3,
	LINK_CAPA_1000HD = 4,
	LINK_CAPA_1000FD = 5,
	LINK_CAPA_2500FD = 6,
	LINK_CAPA_5000FD = 7,
	LINK_CAPA_10000FD = 8,
	LINK_CAPA_20000FD = 9,
	LINK_CAPA_25000FD = 10,
	LINK_CAPA_40000FD = 11,
	LINK_CAPA_50000FD = 12,
	LINK_CAPA_56000FD = 13,
	LINK_CAPA_100000FD = 14,
	LINK_CAPA_200000FD = 15,
	LINK_CAPA_400000FD = 16,
	LINK_CAPA_800000FD = 17,
	__LINK_CAPA_MAX = 18,
};

enum {
	LINUX_MIB_NUM = 0,
	LINUX_MIB_SYNCOOKIESSENT = 1,
	LINUX_MIB_SYNCOOKIESRECV = 2,
	LINUX_MIB_SYNCOOKIESFAILED = 3,
	LINUX_MIB_EMBRYONICRSTS = 4,
	LINUX_MIB_PRUNECALLED = 5,
	LINUX_MIB_RCVPRUNED = 6,
	LINUX_MIB_OFOPRUNED = 7,
	LINUX_MIB_OUTOFWINDOWICMPS = 8,
	LINUX_MIB_LOCKDROPPEDICMPS = 9,
	LINUX_MIB_ARPFILTER = 10,
	LINUX_MIB_TIMEWAITED = 11,
	LINUX_MIB_TIMEWAITRECYCLED = 12,
	LINUX_MIB_TIMEWAITKILLED = 13,
	LINUX_MIB_PAWSACTIVEREJECTED = 14,
	LINUX_MIB_PAWSESTABREJECTED = 15,
	LINUX_MIB_TSECRREJECTED = 16,
	LINUX_MIB_PAWS_OLD_ACK = 17,
	LINUX_MIB_PAWS_TW_REJECTED = 18,
	LINUX_MIB_DELAYEDACKS = 19,
	LINUX_MIB_DELAYEDACKLOCKED = 20,
	LINUX_MIB_DELAYEDACKLOST = 21,
	LINUX_MIB_LISTENOVERFLOWS = 22,
	LINUX_MIB_LISTENDROPS = 23,
	LINUX_MIB_TCPHPHITS = 24,
	LINUX_MIB_TCPPUREACKS = 25,
	LINUX_MIB_TCPHPACKS = 26,
	LINUX_MIB_TCPRENORECOVERY = 27,
	LINUX_MIB_TCPSACKRECOVERY = 28,
	LINUX_MIB_TCPSACKRENEGING = 29,
	LINUX_MIB_TCPSACKREORDER = 30,
	LINUX_MIB_TCPRENOREORDER = 31,
	LINUX_MIB_TCPTSREORDER = 32,
	LINUX_MIB_TCPFULLUNDO = 33,
	LINUX_MIB_TCPPARTIALUNDO = 34,
	LINUX_MIB_TCPDSACKUNDO = 35,
	LINUX_MIB_TCPLOSSUNDO = 36,
	LINUX_MIB_TCPLOSTRETRANSMIT = 37,
	LINUX_MIB_TCPRENOFAILURES = 38,
	LINUX_MIB_TCPSACKFAILURES = 39,
	LINUX_MIB_TCPLOSSFAILURES = 40,
	LINUX_MIB_TCPFASTRETRANS = 41,
	LINUX_MIB_TCPSLOWSTARTRETRANS = 42,
	LINUX_MIB_TCPTIMEOUTS = 43,
	LINUX_MIB_TCPLOSSPROBES = 44,
	LINUX_MIB_TCPLOSSPROBERECOVERY = 45,
	LINUX_MIB_TCPRENORECOVERYFAIL = 46,
	LINUX_MIB_TCPSACKRECOVERYFAIL = 47,
	LINUX_MIB_TCPRCVCOLLAPSED = 48,
	LINUX_MIB_TCPDSACKOLDSENT = 49,
	LINUX_MIB_TCPDSACKOFOSENT = 50,
	LINUX_MIB_TCPDSACKRECV = 51,
	LINUX_MIB_TCPDSACKOFORECV = 52,
	LINUX_MIB_TCPABORTONDATA = 53,
	LINUX_MIB_TCPABORTONCLOSE = 54,
	LINUX_MIB_TCPABORTONMEMORY = 55,
	LINUX_MIB_TCPABORTONTIMEOUT = 56,
	LINUX_MIB_TCPABORTONLINGER = 57,
	LINUX_MIB_TCPABORTFAILED = 58,
	LINUX_MIB_TCPMEMORYPRESSURES = 59,
	LINUX_MIB_TCPMEMORYPRESSURESCHRONO = 60,
	LINUX_MIB_TCPSACKDISCARD = 61,
	LINUX_MIB_TCPDSACKIGNOREDOLD = 62,
	LINUX_MIB_TCPDSACKIGNOREDNOUNDO = 63,
	LINUX_MIB_TCPSPURIOUSRTOS = 64,
	LINUX_MIB_TCPMD5NOTFOUND = 65,
	LINUX_MIB_TCPMD5UNEXPECTED = 66,
	LINUX_MIB_TCPMD5FAILURE = 67,
	LINUX_MIB_SACKSHIFTED = 68,
	LINUX_MIB_SACKMERGED = 69,
	LINUX_MIB_SACKSHIFTFALLBACK = 70,
	LINUX_MIB_TCPBACKLOGDROP = 71,
	LINUX_MIB_PFMEMALLOCDROP = 72,
	LINUX_MIB_TCPMINTTLDROP = 73,
	LINUX_MIB_TCPDEFERACCEPTDROP = 74,
	LINUX_MIB_IPRPFILTER = 75,
	LINUX_MIB_TCPTIMEWAITOVERFLOW = 76,
	LINUX_MIB_TCPREQQFULLDOCOOKIES = 77,
	LINUX_MIB_TCPREQQFULLDROP = 78,
	LINUX_MIB_TCPRETRANSFAIL = 79,
	LINUX_MIB_TCPRCVCOALESCE = 80,
	LINUX_MIB_TCPBACKLOGCOALESCE = 81,
	LINUX_MIB_TCPOFOQUEUE = 82,
	LINUX_MIB_TCPOFODROP = 83,
	LINUX_MIB_TCPOFOMERGE = 84,
	LINUX_MIB_TCPCHALLENGEACK = 85,
	LINUX_MIB_TCPSYNCHALLENGE = 86,
	LINUX_MIB_TCPFASTOPENACTIVE = 87,
	LINUX_MIB_TCPFASTOPENACTIVEFAIL = 88,
	LINUX_MIB_TCPFASTOPENPASSIVE = 89,
	LINUX_MIB_TCPFASTOPENPASSIVEFAIL = 90,
	LINUX_MIB_TCPFASTOPENLISTENOVERFLOW = 91,
	LINUX_MIB_TCPFASTOPENCOOKIEREQD = 92,
	LINUX_MIB_TCPFASTOPENBLACKHOLE = 93,
	LINUX_MIB_TCPSPURIOUS_RTX_HOSTQUEUES = 94,
	LINUX_MIB_BUSYPOLLRXPACKETS = 95,
	LINUX_MIB_TCPAUTOCORKING = 96,
	LINUX_MIB_TCPFROMZEROWINDOWADV = 97,
	LINUX_MIB_TCPTOZEROWINDOWADV = 98,
	LINUX_MIB_TCPWANTZEROWINDOWADV = 99,
	LINUX_MIB_TCPSYNRETRANS = 100,
	LINUX_MIB_TCPORIGDATASENT = 101,
	LINUX_MIB_TCPHYSTARTTRAINDETECT = 102,
	LINUX_MIB_TCPHYSTARTTRAINCWND = 103,
	LINUX_MIB_TCPHYSTARTDELAYDETECT = 104,
	LINUX_MIB_TCPHYSTARTDELAYCWND = 105,
	LINUX_MIB_TCPACKSKIPPEDSYNRECV = 106,
	LINUX_MIB_TCPACKSKIPPEDPAWS = 107,
	LINUX_MIB_TCPACKSKIPPEDSEQ = 108,
	LINUX_MIB_TCPACKSKIPPEDFINWAIT2 = 109,
	LINUX_MIB_TCPACKSKIPPEDTIMEWAIT = 110,
	LINUX_MIB_TCPACKSKIPPEDCHALLENGE = 111,
	LINUX_MIB_TCPWINPROBE = 112,
	LINUX_MIB_TCPKEEPALIVE = 113,
	LINUX_MIB_TCPMTUPFAIL = 114,
	LINUX_MIB_TCPMTUPSUCCESS = 115,
	LINUX_MIB_TCPDELIVERED = 116,
	LINUX_MIB_TCPDELIVEREDCE = 117,
	LINUX_MIB_TCPACKCOMPRESSED = 118,
	LINUX_MIB_TCPZEROWINDOWDROP = 119,
	LINUX_MIB_TCPRCVQDROP = 120,
	LINUX_MIB_TCPWQUEUETOOBIG = 121,
	LINUX_MIB_TCPFASTOPENPASSIVEALTKEY = 122,
	LINUX_MIB_TCPTIMEOUTREHASH = 123,
	LINUX_MIB_TCPDUPLICATEDATAREHASH = 124,
	LINUX_MIB_TCPDSACKRECVSEGS = 125,
	LINUX_MIB_TCPDSACKIGNOREDDUBIOUS = 126,
	LINUX_MIB_TCPMIGRATEREQSUCCESS = 127,
	LINUX_MIB_TCPMIGRATEREQFAILURE = 128,
	LINUX_MIB_TCPPLBREHASH = 129,
	LINUX_MIB_TCPAOREQUIRED = 130,
	LINUX_MIB_TCPAOBAD = 131,
	LINUX_MIB_TCPAOKEYNOTFOUND = 132,
	LINUX_MIB_TCPAOGOOD = 133,
	LINUX_MIB_TCPAODROPPEDICMPS = 134,
	__LINUX_MIB_MAX = 135,
};

enum {
	LINUX_MIB_TLSNUM = 0,
	LINUX_MIB_TLSCURRTXSW = 1,
	LINUX_MIB_TLSCURRRXSW = 2,
	LINUX_MIB_TLSCURRTXDEVICE = 3,
	LINUX_MIB_TLSCURRRXDEVICE = 4,
	LINUX_MIB_TLSTXSW = 5,
	LINUX_MIB_TLSRXSW = 6,
	LINUX_MIB_TLSTXDEVICE = 7,
	LINUX_MIB_TLSRXDEVICE = 8,
	LINUX_MIB_TLSDECRYPTERROR = 9,
	LINUX_MIB_TLSRXDEVICERESYNC = 10,
	LINUX_MIB_TLSDECRYPTRETRY = 11,
	LINUX_MIB_TLSRXNOPADVIOL = 12,
	LINUX_MIB_TLSRXREKEYOK = 13,
	LINUX_MIB_TLSRXREKEYERROR = 14,
	LINUX_MIB_TLSTXREKEYOK = 15,
	LINUX_MIB_TLSTXREKEYERROR = 16,
	LINUX_MIB_TLSRXREKEYRECEIVED = 17,
	__LINUX_MIB_TLSMAX = 18,
};

enum {
	LINUX_MIB_XFRMNUM = 0,
	LINUX_MIB_XFRMINERROR = 1,
	LINUX_MIB_XFRMINBUFFERERROR = 2,
	LINUX_MIB_XFRMINHDRERROR = 3,
	LINUX_MIB_XFRMINNOSTATES = 4,
	LINUX_MIB_XFRMINSTATEPROTOERROR = 5,
	LINUX_MIB_XFRMINSTATEMODEERROR = 6,
	LINUX_MIB_XFRMINSTATESEQERROR = 7,
	LINUX_MIB_XFRMINSTATEEXPIRED = 8,
	LINUX_MIB_XFRMINSTATEMISMATCH = 9,
	LINUX_MIB_XFRMINSTATEINVALID = 10,
	LINUX_MIB_XFRMINTMPLMISMATCH = 11,
	LINUX_MIB_XFRMINNOPOLS = 12,
	LINUX_MIB_XFRMINPOLBLOCK = 13,
	LINUX_MIB_XFRMINPOLERROR = 14,
	LINUX_MIB_XFRMOUTERROR = 15,
	LINUX_MIB_XFRMOUTBUNDLEGENERROR = 16,
	LINUX_MIB_XFRMOUTBUNDLECHECKERROR = 17,
	LINUX_MIB_XFRMOUTNOSTATES = 18,
	LINUX_MIB_XFRMOUTSTATEPROTOERROR = 19,
	LINUX_MIB_XFRMOUTSTATEMODEERROR = 20,
	LINUX_MIB_XFRMOUTSTATESEQERROR = 21,
	LINUX_MIB_XFRMOUTSTATEEXPIRED = 22,
	LINUX_MIB_XFRMOUTPOLBLOCK = 23,
	LINUX_MIB_XFRMOUTPOLDEAD = 24,
	LINUX_MIB_XFRMOUTPOLERROR = 25,
	LINUX_MIB_XFRMFWDHDRERROR = 26,
	LINUX_MIB_XFRMOUTSTATEINVALID = 27,
	LINUX_MIB_XFRMACQUIREERROR = 28,
	LINUX_MIB_XFRMOUTSTATEDIRERROR = 29,
	LINUX_MIB_XFRMINSTATEDIRERROR = 30,
	LINUX_MIB_XFRMINIPTFSERROR = 31,
	LINUX_MIB_XFRMOUTNOQSPACE = 32,
	__LINUX_MIB_XFRMMAX = 33,
};

enum {
	LK_STATE_IN_USE = 0,
	NFS_DELEGATED_STATE = 1,
	NFS_OPEN_STATE = 2,
	NFS_O_RDONLY_STATE = 3,
	NFS_O_WRONLY_STATE = 4,
	NFS_O_RDWR_STATE = 5,
	NFS_STATE_RECLAIM_REBOOT = 6,
	NFS_STATE_RECLAIM_NOGRACE = 7,
	NFS_STATE_POSIX_LOCKS = 8,
	NFS_STATE_RECOVERY_FAILED = 9,
	NFS_STATE_MAY_NOTIFY_LOCK = 10,
	NFS_STATE_CHANGE_WAIT = 11,
	NFS_CLNT_DST_SSC_COPY_STATE = 12,
	NFS_CLNT_SRC_SSC_COPY_STATE = 13,
	NFS_SRV_SSC_COPY_STATE = 14,
};

enum {
	LOCKD_A_SERVER_GRACETIME = 1,
	LOCKD_A_SERVER_TCP_PORT = 2,
	LOCKD_A_SERVER_UDP_PORT = 3,
	__LOCKD_A_SERVER_MAX = 4,
	LOCKD_A_SERVER_MAX = 3,
};

enum {
	LOCKD_CMD_SERVER_SET = 1,
	LOCKD_CMD_SERVER_GET = 2,
	__LOCKD_CMD_MAX = 3,
	LOCKD_CMD_MAX = 2,
};

enum {
	LOGIC_PIO_INDIRECT = 0,
	LOGIC_PIO_CPU_MMIO = 1,
};

enum {
	LOG_INODE_ALL = 0,
	LOG_INODE_EXISTS = 1,
};

enum {
	LOG_WALK_PIN_ONLY = 0,
	LOG_WALK_REPLAY_INODES = 1,
	LOG_WALK_REPLAY_DIR_INDEX = 2,
	LOG_WALK_REPLAY_ALL = 3,
};

enum {
	LO_FLAGS_READ_ONLY = 1,
	LO_FLAGS_AUTOCLEAR = 4,
	LO_FLAGS_PARTSCAN = 8,
	LO_FLAGS_DIRECT_IO = 16,
};

enum {
	LPROPS_UNCAT = 0,
	LPROPS_DIRTY = 1,
	LPROPS_DIRTY_IDX = 2,
	LPROPS_FREE = 3,
	LPROPS_HEAP_CNT = 3,
	LPROPS_EMPTY = 4,
	LPROPS_FREEABLE = 5,
	LPROPS_FRDI_IDX = 6,
	LPROPS_CAT_MASK = 15,
	LPROPS_TAKEN = 16,
	LPROPS_INDEX = 32,
};

enum {
	LPT_SCAN_CONTINUE = 0,
	LPT_SCAN_ADD = 1,
	LPT_SCAN_STOP = 2,
};

enum {
	LS1021A = 0,
	LS1012A = 1,
	LS1028A = 2,
	LS1043A = 3,
	LS1046A = 4,
	LS2080A = 5,
	LS2085A = 6,
	LX2160A = 7,
	MCF5441X = 8,
	VF610 = 9,
};

enum {
	LTAB_DIRTY = 1,
	LSAVE_DIRTY = 2,
};

enum {
	LWTUNNEL_IP_OPTS_UNSPEC = 0,
	LWTUNNEL_IP_OPTS_GENEVE = 1,
	LWTUNNEL_IP_OPTS_VXLAN = 2,
	LWTUNNEL_IP_OPTS_ERSPAN = 3,
	__LWTUNNEL_IP_OPTS_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_ERSPAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_ERSPAN_VER = 1,
	LWTUNNEL_IP_OPT_ERSPAN_INDEX = 2,
	LWTUNNEL_IP_OPT_ERSPAN_DIR = 3,
	LWTUNNEL_IP_OPT_ERSPAN_HWID = 4,
	__LWTUNNEL_IP_OPT_ERSPAN_MAX = 5,
};

enum {
	LWTUNNEL_IP_OPT_GENEVE_UNSPEC = 0,
	LWTUNNEL_IP_OPT_GENEVE_CLASS = 1,
	LWTUNNEL_IP_OPT_GENEVE_TYPE = 2,
	LWTUNNEL_IP_OPT_GENEVE_DATA = 3,
	__LWTUNNEL_IP_OPT_GENEVE_MAX = 4,
};

enum {
	LWTUNNEL_IP_OPT_VXLAN_UNSPEC = 0,
	LWTUNNEL_IP_OPT_VXLAN_GBP = 1,
	__LWTUNNEL_IP_OPT_VXLAN_MAX = 2,
};

enum {
	LWTUNNEL_XMIT_DONE = 0,
	LWTUNNEL_XMIT_CONTINUE = 256,
};

enum {
	LWT_BPF_PROG_UNSPEC = 0,
	LWT_BPF_PROG_FD = 1,
	LWT_BPF_PROG_NAME = 2,
	__LWT_BPF_PROG_MAX = 3,
};

enum {
	LWT_BPF_UNSPEC = 0,
	LWT_BPF_IN = 1,
	LWT_BPF_OUT = 2,
	LWT_BPF_XMIT = 3,
	LWT_BPF_XMIT_HEADROOM = 4,
	__LWT_BPF_MAX = 5,
};

enum {
	Lo_unbound = 0,
	Lo_bound = 1,
	Lo_rundown = 2,
	Lo_deleting = 3,
};

enum {
	M88E3082_VCT_OFF = 0,
	M88E3082_VCT_PHASE1 = 1,
	M88E3082_VCT_PHASE2 = 2,
};

enum {
	MAX8952_REG_MODE0 = 0,
	MAX8952_REG_MODE1 = 1,
	MAX8952_REG_MODE2 = 2,
	MAX8952_REG_MODE3 = 3,
	MAX8952_REG_CONTROL = 4,
	MAX8952_REG_SYNC = 5,
	MAX8952_REG_RAMP = 6,
	MAX8952_REG_CHIP_ID1 = 7,
	MAX8952_REG_CHIP_ID2 = 8,
};

enum {
	MAX8998_IRQ_DCINF = 0,
	MAX8998_IRQ_DCINR = 1,
	MAX8998_IRQ_JIGF = 2,
	MAX8998_IRQ_JIGR = 3,
	MAX8998_IRQ_PWRONF = 4,
	MAX8998_IRQ_PWRONR = 5,
	MAX8998_IRQ_WTSREVNT = 6,
	MAX8998_IRQ_SMPLEVNT = 7,
	MAX8998_IRQ_ALARM1 = 8,
	MAX8998_IRQ_ALARM0 = 9,
	MAX8998_IRQ_ONKEY1S = 10,
	MAX8998_IRQ_TOPOFFR = 11,
	MAX8998_IRQ_DCINOVPR = 12,
	MAX8998_IRQ_CHGRSTF = 13,
	MAX8998_IRQ_DONER = 14,
	MAX8998_IRQ_CHGFAULT = 15,
	MAX8998_IRQ_LOBAT1 = 16,
	MAX8998_IRQ_LOBAT2 = 17,
	MAX8998_IRQ_NR = 18,
};

enum {
	MAX8998_LDO2 = 2,
	MAX8998_LDO3 = 3,
	MAX8998_LDO4 = 4,
	MAX8998_LDO5 = 5,
	MAX8998_LDO6 = 6,
	MAX8998_LDO7 = 7,
	MAX8998_LDO8 = 8,
	MAX8998_LDO9 = 9,
	MAX8998_LDO10 = 10,
	MAX8998_LDO11 = 11,
	MAX8998_LDO12 = 12,
	MAX8998_LDO13 = 13,
	MAX8998_LDO14 = 14,
	MAX8998_LDO15 = 15,
	MAX8998_LDO16 = 16,
	MAX8998_LDO17 = 17,
	MAX8998_BUCK1 = 18,
	MAX8998_BUCK2 = 19,
	MAX8998_BUCK3 = 20,
	MAX8998_BUCK4 = 21,
	MAX8998_EN32KHZ_AP = 22,
	MAX8998_EN32KHZ_CP = 23,
	MAX8998_ENVICHG = 24,
	MAX8998_ESAFEOUT1 = 25,
	MAX8998_ESAFEOUT2 = 26,
	MAX8998_CHARGER = 27,
};

enum {
	MAX8998_REG_IRQ1 = 0,
	MAX8998_REG_IRQ2 = 1,
	MAX8998_REG_IRQ3 = 2,
	MAX8998_REG_IRQ4 = 3,
	MAX8998_REG_IRQM1 = 4,
	MAX8998_REG_IRQM2 = 5,
	MAX8998_REG_IRQM3 = 6,
	MAX8998_REG_IRQM4 = 7,
	MAX8998_REG_STATUS1 = 8,
	MAX8998_REG_STATUS2 = 9,
	MAX8998_REG_STATUSM1 = 10,
	MAX8998_REG_STATUSM2 = 11,
	MAX8998_REG_CHGR1 = 12,
	MAX8998_REG_CHGR2 = 13,
	MAX8998_REG_LDO_ACTIVE_DISCHARGE1 = 14,
	MAX8998_REG_LDO_ACTIVE_DISCHARGE2 = 15,
	MAX8998_REG_BUCK_ACTIVE_DISCHARGE3 = 16,
	MAX8998_REG_ONOFF1 = 17,
	MAX8998_REG_ONOFF2 = 18,
	MAX8998_REG_ONOFF3 = 19,
	MAX8998_REG_ONOFF4 = 20,
	MAX8998_REG_BUCK1_VOLTAGE1 = 21,
	MAX8998_REG_BUCK1_VOLTAGE2 = 22,
	MAX8998_REG_BUCK1_VOLTAGE3 = 23,
	MAX8998_REG_BUCK1_VOLTAGE4 = 24,
	MAX8998_REG_BUCK2_VOLTAGE1 = 25,
	MAX8998_REG_BUCK2_VOLTAGE2 = 26,
	MAX8998_REG_BUCK3 = 27,
	MAX8998_REG_BUCK4 = 28,
	MAX8998_REG_LDO2_LDO3 = 29,
	MAX8998_REG_LDO4 = 30,
	MAX8998_REG_LDO5 = 31,
	MAX8998_REG_LDO6 = 32,
	MAX8998_REG_LDO7 = 33,
	MAX8998_REG_LDO8_LDO9 = 34,
	MAX8998_REG_LDO10_LDO11 = 35,
	MAX8998_REG_LDO12 = 36,
	MAX8998_REG_LDO13 = 37,
	MAX8998_REG_LDO14 = 38,
	MAX8998_REG_LDO15 = 39,
	MAX8998_REG_LDO16 = 40,
	MAX8998_REG_LDO17 = 41,
	MAX8998_REG_BKCHR = 42,
	MAX8998_REG_LBCNFG1 = 43,
	MAX8998_REG_LBCNFG2 = 44,
};

enum {
	MAX_IORES_LEVEL = 5,
};

enum {
	MAX_OPT_ARGS = 3,
};

enum {
	MBE_REFERENCED_B = 0,
	MBE_REUSABLE_B = 1,
};

enum {
	MB_INODE_PA = 0,
	MB_GROUP_PA = 1,
};

enum {
	MCT_INT_SPI = 0,
	MCT_INT_PPI = 1,
};

enum {
	MDBA_GET_ENTRY_UNSPEC = 0,
	MDBA_GET_ENTRY = 1,
	MDBA_GET_ENTRY_ATTRS = 2,
	__MDBA_GET_ENTRY_MAX = 3,
};

enum {
	MDBA_SET_ENTRY_UNSPEC = 0,
	MDBA_SET_ENTRY = 1,
	MDBA_SET_ENTRY_ATTRS = 2,
	__MDBA_SET_ENTRY_MAX = 3,
};

enum {
	MEMBARRIER_FLAG_SYNC_CORE = 1,
	MEMBARRIER_FLAG_RSEQ = 2,
};

enum {
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_READY = 1,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED = 2,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED_READY = 4,
	MEMBARRIER_STATE_GLOBAL_EXPEDITED = 8,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE_READY = 16,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ_READY = 64,
	MEMBARRIER_STATE_PRIVATE_EXPEDITED_RSEQ = 128,
};

enum {
	MEMORY_MODE_NORMAL = 0,
	MEMORY_MODE_LOW = 1,
};

enum {
	MEMORY_RECLAIM_SWAPPINESS = 0,
	MEMORY_RECLAIM_SWAPPINESS_MAX = 1,
	MEMORY_RECLAIM_NULL = 2,
};

enum {
	MEMREMAP_WB = 1,
	MEMREMAP_WT = 2,
	MEMREMAP_WC = 4,
	MEMREMAP_ENC = 8,
	MEMREMAP_DEC = 16,
};

enum {
	META_CP = 0,
	META_NAT = 1,
	META_SIT = 2,
	META_SSA = 3,
	META_MAX = 4,
	META_POR = 5,
	DATA_GENERIC = 6,
	DATA_GENERIC_ENHANCE = 7,
	DATA_GENERIC_ENHANCE_READ = 8,
	DATA_GENERIC_ENHANCE_UPDATE = 9,
	META_GENERIC = 10,
};

enum {
	MFC_STATIC = 1,
	MFC_OFFLOAD = 2,
};

enum {
	MICRON_ON_DIE_UNSUPPORTED = 0,
	MICRON_ON_DIE_SUPPORTED = 1,
	MICRON_ON_DIE_MANDATORY = 2,
};

enum {
	MILLION = 1000000,
	MIN_PERIOD = 1000,
	MAX_PERIOD = 1000000,
	MARGIN_MIN_PCT = 10,
	MARGIN_LOW_PCT = 20,
	MARGIN_TARGET_PCT = 50,
	INUSE_ADJ_STEP_PCT = 25,
	TIMER_SLACK_PCT = 1,
	WEIGHT_ONE = 65536,
};

enum {
	MIPI_DCS_NOP = 0,
	MIPI_DCS_SOFT_RESET = 1,
	MIPI_DCS_GET_COMPRESSION_MODE = 3,
	MIPI_DCS_GET_DISPLAY_ID = 4,
	MIPI_DCS_GET_ERROR_COUNT_ON_DSI = 5,
	MIPI_DCS_GET_RED_CHANNEL = 6,
	MIPI_DCS_GET_GREEN_CHANNEL = 7,
	MIPI_DCS_GET_BLUE_CHANNEL = 8,
	MIPI_DCS_GET_DISPLAY_STATUS = 9,
	MIPI_DCS_GET_POWER_MODE = 10,
	MIPI_DCS_GET_ADDRESS_MODE = 11,
	MIPI_DCS_GET_PIXEL_FORMAT = 12,
	MIPI_DCS_GET_DISPLAY_MODE = 13,
	MIPI_DCS_GET_SIGNAL_MODE = 14,
	MIPI_DCS_GET_DIAGNOSTIC_RESULT = 15,
	MIPI_DCS_ENTER_SLEEP_MODE = 16,
	MIPI_DCS_EXIT_SLEEP_MODE = 17,
	MIPI_DCS_ENTER_PARTIAL_MODE = 18,
	MIPI_DCS_ENTER_NORMAL_MODE = 19,
	MIPI_DCS_GET_IMAGE_CHECKSUM_RGB = 20,
	MIPI_DCS_GET_IMAGE_CHECKSUM_CT = 21,
	MIPI_DCS_EXIT_INVERT_MODE = 32,
	MIPI_DCS_ENTER_INVERT_MODE = 33,
	MIPI_DCS_SET_GAMMA_CURVE = 38,
	MIPI_DCS_SET_DISPLAY_OFF = 40,
	MIPI_DCS_SET_DISPLAY_ON = 41,
	MIPI_DCS_SET_COLUMN_ADDRESS = 42,
	MIPI_DCS_SET_PAGE_ADDRESS = 43,
	MIPI_DCS_WRITE_MEMORY_START = 44,
	MIPI_DCS_WRITE_LUT = 45,
	MIPI_DCS_READ_MEMORY_START = 46,
	MIPI_DCS_SET_PARTIAL_ROWS = 48,
	MIPI_DCS_SET_PARTIAL_COLUMNS = 49,
	MIPI_DCS_SET_SCROLL_AREA = 51,
	MIPI_DCS_SET_TEAR_OFF = 52,
	MIPI_DCS_SET_TEAR_ON = 53,
	MIPI_DCS_SET_ADDRESS_MODE = 54,
	MIPI_DCS_SET_SCROLL_START = 55,
	MIPI_DCS_EXIT_IDLE_MODE = 56,
	MIPI_DCS_ENTER_IDLE_MODE = 57,
	MIPI_DCS_SET_PIXEL_FORMAT = 58,
	MIPI_DCS_WRITE_MEMORY_CONTINUE = 60,
	MIPI_DCS_SET_3D_CONTROL = 61,
	MIPI_DCS_READ_MEMORY_CONTINUE = 62,
	MIPI_DCS_GET_3D_CONTROL = 63,
	MIPI_DCS_SET_VSYNC_TIMING = 64,
	MIPI_DCS_SET_TEAR_SCANLINE = 68,
	MIPI_DCS_GET_SCANLINE = 69,
	MIPI_DCS_SET_DISPLAY_BRIGHTNESS = 81,
	MIPI_DCS_GET_DISPLAY_BRIGHTNESS = 82,
	MIPI_DCS_WRITE_CONTROL_DISPLAY = 83,
	MIPI_DCS_GET_CONTROL_DISPLAY = 84,
	MIPI_DCS_WRITE_POWER_SAVE = 85,
	MIPI_DCS_GET_POWER_SAVE = 86,
	MIPI_DCS_SET_CABC_MIN_BRIGHTNESS = 94,
	MIPI_DCS_GET_CABC_MIN_BRIGHTNESS = 95,
	MIPI_DCS_READ_DDB_START = 161,
	MIPI_DCS_READ_PPS_START = 162,
	MIPI_DCS_READ_DDB_CONTINUE = 168,
	MIPI_DCS_READ_PPS_CONTINUE = 169,
};

enum {
	MIPI_DSI_RX_ACKNOWLEDGE_AND_ERROR_REPORT = 2,
	MIPI_DSI_RX_END_OF_TRANSMISSION = 8,
	MIPI_DSI_RX_GENERIC_SHORT_READ_RESPONSE_1BYTE = 17,
	MIPI_DSI_RX_GENERIC_SHORT_READ_RESPONSE_2BYTE = 18,
	MIPI_DSI_RX_GENERIC_LONG_READ_RESPONSE = 26,
	MIPI_DSI_RX_DCS_LONG_READ_RESPONSE = 28,
	MIPI_DSI_RX_DCS_SHORT_READ_RESPONSE_1BYTE = 33,
	MIPI_DSI_RX_DCS_SHORT_READ_RESPONSE_2BYTE = 34,
};

enum {
	MIPI_DSI_V_SYNC_START = 1,
	MIPI_DSI_V_SYNC_END = 17,
	MIPI_DSI_H_SYNC_START = 33,
	MIPI_DSI_H_SYNC_END = 49,
	MIPI_DSI_COMPRESSION_MODE = 7,
	MIPI_DSI_END_OF_TRANSMISSION = 8,
	MIPI_DSI_COLOR_MODE_OFF = 2,
	MIPI_DSI_COLOR_MODE_ON = 18,
	MIPI_DSI_SHUTDOWN_PERIPHERAL = 34,
	MIPI_DSI_TURN_ON_PERIPHERAL = 50,
	MIPI_DSI_GENERIC_SHORT_WRITE_0_PARAM = 3,
	MIPI_DSI_GENERIC_SHORT_WRITE_1_PARAM = 19,
	MIPI_DSI_GENERIC_SHORT_WRITE_2_PARAM = 35,
	MIPI_DSI_GENERIC_READ_REQUEST_0_PARAM = 4,
	MIPI_DSI_GENERIC_READ_REQUEST_1_PARAM = 20,
	MIPI_DSI_GENERIC_READ_REQUEST_2_PARAM = 36,
	MIPI_DSI_DCS_SHORT_WRITE = 5,
	MIPI_DSI_DCS_SHORT_WRITE_PARAM = 21,
	MIPI_DSI_DCS_READ = 6,
	MIPI_DSI_EXECUTE_QUEUE = 22,
	MIPI_DSI_SET_MAXIMUM_RETURN_PACKET_SIZE = 55,
	MIPI_DSI_NULL_PACKET = 9,
	MIPI_DSI_BLANKING_PACKET = 25,
	MIPI_DSI_GENERIC_LONG_WRITE = 41,
	MIPI_DSI_DCS_LONG_WRITE = 57,
	MIPI_DSI_PICTURE_PARAMETER_SET = 10,
	MIPI_DSI_COMPRESSED_PIXEL_STREAM = 11,
	MIPI_DSI_LOOSELY_PACKED_PIXEL_STREAM_YCBCR20 = 12,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR24 = 28,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR16 = 44,
	MIPI_DSI_PACKED_PIXEL_STREAM_30 = 13,
	MIPI_DSI_PACKED_PIXEL_STREAM_36 = 29,
	MIPI_DSI_PACKED_PIXEL_STREAM_YCBCR12 = 61,
	MIPI_DSI_PACKED_PIXEL_STREAM_16 = 14,
	MIPI_DSI_PACKED_PIXEL_STREAM_18 = 30,
	MIPI_DSI_PIXEL_STREAM_3BYTE_18 = 46,
	MIPI_DSI_PACKED_PIXEL_STREAM_24 = 62,
};

enum {
	MIX_INFLIGHT = 2147483648,
};

enum {
	MLX_MC_RBT_SUPPORT = 1,
	MLX_MC_RBT_AVL = 8,
};

enum {
	MM_FILEPAGES = 0,
	MM_ANONPAGES = 1,
	MM_SWAPENTS = 2,
	MM_SHMEMPAGES = 3,
	NR_MM_COUNTERS = 4,
};

enum {
	MOUNTPROC3_NULL = 0,
	MOUNTPROC3_MNT = 1,
	MOUNTPROC3_DUMP = 2,
	MOUNTPROC3_UMNT = 3,
	MOUNTPROC3_UMNTALL = 4,
	MOUNTPROC3_EXPORT = 5,
};

enum {
	MOUNTPROC_NULL = 0,
	MOUNTPROC_MNT = 1,
	MOUNTPROC_DUMP = 2,
	MOUNTPROC_UMNT = 3,
	MOUNTPROC_UMNTALL = 4,
	MOUNTPROC_EXPORT = 5,
};

enum {
	MOVE_CANCEL_RACE = 1,
	MOVE_SOURCE_RD_ERR = 2,
	MOVE_TARGET_RD_ERR = 3,
	MOVE_TARGET_WR_ERR = 4,
	MOVE_TARGET_BITFLIPS = 5,
	MOVE_RETRY = 6,
};

enum {
	MOXA_SUPP_RS232 = 1,
	MOXA_SUPP_RS422 = 2,
	MOXA_SUPP_RS485 = 4,
};

enum {
	MPTCP_CMSG_TS = 1,
	MPTCP_CMSG_INQ = 2,
};

enum {
	MPTCP_PM_ADDR_ATTR_UNSPEC = 0,
	MPTCP_PM_ADDR_ATTR_FAMILY = 1,
	MPTCP_PM_ADDR_ATTR_ID = 2,
	MPTCP_PM_ADDR_ATTR_ADDR4 = 3,
	MPTCP_PM_ADDR_ATTR_ADDR6 = 4,
	MPTCP_PM_ADDR_ATTR_PORT = 5,
	MPTCP_PM_ADDR_ATTR_FLAGS = 6,
	MPTCP_PM_ADDR_ATTR_IF_IDX = 7,
	__MPTCP_PM_ADDR_ATTR_MAX = 8,
};

enum {
	MPTCP_PM_ATTR_UNSPEC = 0,
	MPTCP_PM_ATTR_ADDR = 1,
	MPTCP_PM_ATTR_RCV_ADD_ADDRS = 2,
	MPTCP_PM_ATTR_SUBFLOWS = 3,
	MPTCP_PM_ATTR_TOKEN = 4,
	MPTCP_PM_ATTR_LOC_ID = 5,
	MPTCP_PM_ATTR_ADDR_REMOTE = 6,
	__MPTCP_ATTR_AFTER_LAST = 7,
};

enum {
	MPTCP_PM_CMD_UNSPEC = 0,
	MPTCP_PM_CMD_ADD_ADDR = 1,
	MPTCP_PM_CMD_DEL_ADDR = 2,
	MPTCP_PM_CMD_GET_ADDR = 3,
	MPTCP_PM_CMD_FLUSH_ADDRS = 4,
	MPTCP_PM_CMD_SET_LIMITS = 5,
	MPTCP_PM_CMD_GET_LIMITS = 6,
	MPTCP_PM_CMD_SET_FLAGS = 7,
	MPTCP_PM_CMD_ANNOUNCE = 8,
	MPTCP_PM_CMD_REMOVE = 9,
	MPTCP_PM_CMD_SUBFLOW_CREATE = 10,
	MPTCP_PM_CMD_SUBFLOW_DESTROY = 11,
	__MPTCP_PM_CMD_AFTER_LAST = 12,
};

enum {
	MPTCP_PM_ENDPOINT_ADDR = 1,
	__MPTCP_PM_ENDPOINT_MAX = 2,
};

enum {
	MPTCP_SUBFLOW_ATTR_UNSPEC = 0,
	MPTCP_SUBFLOW_ATTR_TOKEN_REM = 1,
	MPTCP_SUBFLOW_ATTR_TOKEN_LOC = 2,
	MPTCP_SUBFLOW_ATTR_RELWRITE_SEQ = 3,
	MPTCP_SUBFLOW_ATTR_MAP_SEQ = 4,
	MPTCP_SUBFLOW_ATTR_MAP_SFSEQ = 5,
	MPTCP_SUBFLOW_ATTR_SSN_OFFSET = 6,
	MPTCP_SUBFLOW_ATTR_MAP_DATALEN = 7,
	MPTCP_SUBFLOW_ATTR_FLAGS = 8,
	MPTCP_SUBFLOW_ATTR_ID_REM = 9,
	MPTCP_SUBFLOW_ATTR_ID_LOC = 10,
	MPTCP_SUBFLOW_ATTR_PAD = 11,
	__MPTCP_SUBFLOW_ATTR_MAX = 12,
};

enum {
	MSI_CHIP_FLAG_SET_EOI = 1,
	MSI_CHIP_FLAG_SET_ACK = 2,
};

enum {
	MSI_FLAG_USE_DEF_DOM_OPS = 1,
	MSI_FLAG_USE_DEF_CHIP_OPS = 2,
	MSI_FLAG_ACTIVATE_EARLY = 4,
	MSI_FLAG_MUST_REACTIVATE = 8,
	MSI_FLAG_DEV_SYSFS = 16,
	MSI_FLAG_ALLOC_SIMPLE_MSI_DESCS = 32,
	MSI_FLAG_FREE_MSI_DESCS = 64,
	MSI_FLAG_USE_DEV_FWNODE = 128,
	MSI_FLAG_PARENT_PM_DEV = 256,
	MSI_FLAG_PCI_MSI_MASK_PARENT = 512,
	MSI_GENERIC_FLAGS_MASK = 65535,
	MSI_DOMAIN_FLAGS_MASK = 4294901760,
	MSI_FLAG_MULTI_PCI_MSI = 65536,
	MSI_FLAG_PCI_MSIX = 131072,
	MSI_FLAG_LEVEL_CAPABLE = 262144,
	MSI_FLAG_MSIX_CONTIGUOUS = 524288,
	MSI_FLAG_PCI_MSIX_ALLOC_DYN = 1048576,
	MSI_FLAG_NO_AFFINITY = 2097152,
	MSI_FLAG_NO_MASK = 4194304,
};

enum {
	MTD_OPS_PLACE_OOB = 0,
	MTD_OPS_AUTO_OOB = 1,
	MTD_OPS_RAW = 2,
};

enum {
	MT_UNCACHED = 4,
	MT_CACHECLEAN = 5,
	MT_MINICLEAN = 6,
	MT_LOW_VECTORS = 7,
	MT_HIGH_VECTORS = 8,
	MT_MEMORY_RWX = 9,
	MT_MEMORY_RW = 10,
	MT_MEMORY_RO = 11,
	MT_ROM = 12,
	MT_MEMORY_RWX_NONCACHED = 13,
	MT_MEMORY_RW_DTCM = 14,
	MT_MEMORY_RWX_ITCM = 15,
	MT_MEMORY_RW_SO = 16,
	MT_MEMORY_DMA_READY = 17,
};

enum {
	MUSB_CONTROLLER_MHDRC = 0,
	MUSB_CONTROLLER_HDRC = 1,
};

enum {
	MV64XXX_I2C_ACTION_INVALID = 0,
	MV64XXX_I2C_ACTION_CONTINUE = 1,
	MV64XXX_I2C_ACTION_SEND_RESTART = 2,
	MV64XXX_I2C_ACTION_SEND_ADDR_1 = 3,
	MV64XXX_I2C_ACTION_SEND_ADDR_2 = 4,
	MV64XXX_I2C_ACTION_SEND_DATA = 5,
	MV64XXX_I2C_ACTION_RCV_DATA = 6,
	MV64XXX_I2C_ACTION_RCV_DATA_STOP = 7,
	MV64XXX_I2C_ACTION_SEND_STOP = 8,
};

enum {
	MV64XXX_I2C_STATE_INVALID = 0,
	MV64XXX_I2C_STATE_IDLE = 1,
	MV64XXX_I2C_STATE_WAITING_FOR_START_COND = 2,
	MV64XXX_I2C_STATE_WAITING_FOR_RESTART = 3,
	MV64XXX_I2C_STATE_WAITING_FOR_ADDR_1_ACK = 4,
	MV64XXX_I2C_STATE_WAITING_FOR_ADDR_2_ACK = 5,
	MV64XXX_I2C_STATE_WAITING_FOR_TARGET_ACK = 6,
	MV64XXX_I2C_STATE_WAITING_FOR_TARGET_DATA = 7,
};

enum {
	MV_DMA_BOUNDARY = 65535,
	EDMA_REQ_Q_BASE_LO_MASK = 4294966272,
	EDMA_RSP_Q_BASE_LO_MASK = 4294967040,
};

enum {
	MV_PRIMARY_BAR = 0,
	MV_IO_BAR = 2,
	MV_MISC_BAR = 3,
	MV_MAJOR_REG_AREA_SZ = 65536,
	MV_MINOR_REG_AREA_SZ = 8192,
	COAL_CLOCKS_PER_USEC = 150,
	MAX_COAL_TIME_THRESHOLD = 16777215,
	MAX_COAL_IO_COUNT = 255,
	MV_PCI_REG_BASE = 0,
	COAL_REG_BASE = 98304,
	IRQ_COAL_CAUSE = 98312,
	ALL_PORTS_COAL_IRQ = 16,
	IRQ_COAL_IO_THRESHOLD = 98508,
	IRQ_COAL_TIME_THRESHOLD = 98512,
	TRAN_COAL_CAUSE_LO = 98440,
	TRAN_COAL_CAUSE_HI = 98444,
	SATAHC0_REG_BASE = 131072,
	FLASH_CTL = 66668,
	GPIO_PORT_CTL = 66800,
	RESET_CFG = 98520,
	MV_PCI_REG_SZ = 65536,
	MV_SATAHC_REG_SZ = 65536,
	MV_SATAHC_ARBTR_REG_SZ = 8192,
	MV_PORT_REG_SZ = 8192,
	MV_MAX_Q_DEPTH = 32,
	MV_MAX_Q_DEPTH_MASK = 31,
	MV_CRQB_Q_SZ = 1024,
	MV_CRPB_Q_SZ = 256,
	MV_MAX_SG_CT = 256,
	MV_SG_TBL_SZ = 4096,
	MV_PORT_HC_SHIFT = 2,
	MV_PORTS_PER_HC = 4,
	MV_PORT_MASK = 3,
	MV_FLAG_DUAL_HC = 1073741824,
	MV_COMMON_FLAGS = 514,
	MV_GEN_I_FLAGS = 578,
	MV_GEN_II_FLAGS = 656898,
	MV_GEN_IIE_FLAGS = 919042,
	CRQB_FLAG_READ = 1,
	CRQB_TAG_SHIFT = 1,
	CRQB_IOID_SHIFT = 6,
	CRQB_PMP_SHIFT = 12,
	CRQB_HOSTQ_SHIFT = 17,
	CRQB_CMD_ADDR_SHIFT = 8,
	CRQB_CMD_CS = 4096,
	CRQB_CMD_LAST = 32768,
	CRPB_FLAG_STATUS_SHIFT = 8,
	CRPB_IOID_SHIFT_6 = 5,
	CRPB_IOID_SHIFT_7 = 7,
	EPRD_FLAG_END_OF_TBL = -2147483648,
	MV_PCI_COMMAND = 3072,
	MV_PCI_COMMAND_MWRCOM = 16,
	MV_PCI_COMMAND_MRDTRIG = 128,
	PCI_MAIN_CMD_STS = 3376,
	STOP_PCI_MASTER = 4,
	PCI_MASTER_EMPTY = 8,
	GLOB_SFT_RST = 16,
	MV_PCI_MODE = 3328,
	MV_PCI_MODE_MASK = 48,
	MV_PCI_EXP_ROM_BAR_CTL = 3372,
	MV_PCI_DISC_TIMER = 3332,
	MV_PCI_MSI_TRIGGER = 3128,
	MV_PCI_SERR_MASK = 3112,
	MV_PCI_XBAR_TMOUT = 7428,
	MV_PCI_ERR_LOW_ADDRESS = 7488,
	MV_PCI_ERR_HIGH_ADDRESS = 7492,
	MV_PCI_ERR_ATTRIBUTE = 7496,
	MV_PCI_ERR_COMMAND = 7504,
	PCI_IRQ_CAUSE = 7512,
	PCI_IRQ_MASK = 7516,
	PCI_UNMASK_ALL_IRQS = 8388607,
	PCIE_IRQ_CAUSE = 6400,
	PCIE_IRQ_MASK = 6416,
	PCIE_UNMASK_ALL_IRQS = 1034,
	PCI_HC_MAIN_IRQ_CAUSE = 7520,
	PCI_HC_MAIN_IRQ_MASK = 7524,
	SOC_HC_MAIN_IRQ_CAUSE = 131104,
	SOC_HC_MAIN_IRQ_MASK = 131108,
	ERR_IRQ = 1,
	DONE_IRQ = 2,
	HC0_IRQ_PEND = 511,
	HC_SHIFT = 9,
	DONE_IRQ_0_3 = 170,
	DONE_IRQ_4_7 = 87040,
	PCI_ERR = 262144,
	TRAN_COAL_LO_DONE = 524288,
	TRAN_COAL_HI_DONE = 1048576,
	PORTS_0_3_COAL_DONE = 256,
	PORTS_4_7_COAL_DONE = 131072,
	ALL_PORTS_COAL_DONE = 2097152,
	GPIO_INT = 4194304,
	SELF_INT = 8388608,
	TWSI_INT = 16777216,
	HC_MAIN_RSVD = -33554432,
	HC_MAIN_RSVD_5 = -524288,
	HC_MAIN_RSVD_SOC = -320,
	HC_CFG = 0,
	HC_IRQ_CAUSE = 20,
	DMA_IRQ = 1,
	HC_COAL_IRQ = 16,
	DEV_IRQ = 256,
	HC_IRQ_COAL_IO_THRESHOLD = 12,
	HC_IRQ_COAL_TIME_THRESHOLD = 16,
	SOC_LED_CTRL = 44,
	SOC_LED_CTRL_BLINK = 1,
	SOC_LED_CTRL_ACT_PRESENCE = 4,
	SHD_BLK = 256,
	SHD_CTL_AST = 32,
	SATA_STATUS = 768,
	SATA_ACTIVE = 848,
	FIS_IRQ_CAUSE = 868,
	FIS_IRQ_CAUSE_AN = 512,
	LTMODE = 780,
	LTMODE_BIT8 = 256,
	PHY_MODE2 = 816,
	PHY_MODE3 = 784,
	PHY_MODE4 = 788,
	PHY_MODE4_CFG_MASK = 3,
	PHY_MODE4_CFG_VALUE = 1,
	PHY_MODE4_RSVD_ZEROS = 1575223290,
	PHY_MODE4_RSVD_ONES = 5,
	SATA_IFCTL = 836,
	SATA_TESTCTL = 840,
	SATA_IFSTAT = 844,
	VENDOR_UNIQUE_FIS = 860,
	FISCFG = 864,
	FISCFG_WAIT_DEV_ERR = 256,
	FISCFG_SINGLE_SYNC = 65536,
	PHY_MODE9_GEN2 = 920,
	PHY_MODE9_GEN1 = 924,
	PHYCFG_OFS = 928,
	MV5_PHY_MODE = 116,
	MV5_LTMODE = 48,
	MV5_PHY_CTL = 12,
	SATA_IFCFG = 80,
	LP_PHY_CTL = 88,
	LP_PHY_CTL_PIN_PU_PLL = 1,
	LP_PHY_CTL_PIN_PU_RX = 2,
	LP_PHY_CTL_PIN_PU_TX = 4,
	LP_PHY_CTL_GEN_TX_3G = 32,
	LP_PHY_CTL_GEN_RX_3G = 512,
	MV_M2_PREAMP_MASK = 2016,
	EDMA_CFG = 0,
	EDMA_CFG_Q_DEPTH = 31,
	EDMA_CFG_NCQ = 32,
	EDMA_CFG_NCQ_GO_ON_ERR = 16384,
	EDMA_CFG_RD_BRST_EXT = 2048,
	EDMA_CFG_WR_BUFF_LEN = 8192,
	EDMA_CFG_EDMA_FBS = 65536,
	EDMA_CFG_FBS = 67108864,
	EDMA_ERR_IRQ_CAUSE = 8,
	EDMA_ERR_IRQ_MASK = 12,
	EDMA_ERR_D_PAR = 1,
	EDMA_ERR_PRD_PAR = 2,
	EDMA_ERR_DEV = 4,
	EDMA_ERR_DEV_DCON = 8,
	EDMA_ERR_DEV_CON = 16,
	EDMA_ERR_SERR = 32,
	EDMA_ERR_SELF_DIS = 128,
	EDMA_ERR_SELF_DIS_5 = 256,
	EDMA_ERR_BIST_ASYNC = 256,
	EDMA_ERR_TRANS_IRQ_7 = 256,
	EDMA_ERR_CRQB_PAR = 512,
	EDMA_ERR_CRPB_PAR = 1024,
	EDMA_ERR_INTRL_PAR = 2048,
	EDMA_ERR_IORDY = 4096,
	EDMA_ERR_LNK_CTRL_RX = 122880,
	EDMA_ERR_LNK_CTRL_RX_0 = 8192,
	EDMA_ERR_LNK_CTRL_RX_1 = 16384,
	EDMA_ERR_LNK_CTRL_RX_2 = 32768,
	EDMA_ERR_LNK_CTRL_RX_3 = 65536,
	EDMA_ERR_LNK_DATA_RX = 1966080,
	EDMA_ERR_LNK_CTRL_TX = 65011712,
	EDMA_ERR_LNK_CTRL_TX_0 = 2097152,
	EDMA_ERR_LNK_CTRL_TX_1 = 4194304,
	EDMA_ERR_LNK_CTRL_TX_2 = 8388608,
	EDMA_ERR_LNK_CTRL_TX_3 = 16777216,
	EDMA_ERR_LNK_CTRL_TX_4 = 33554432,
	EDMA_ERR_LNK_DATA_TX = 2080374784,
	EDMA_ERR_TRANS_PROTO = -2147483648,
	EDMA_ERR_OVERRUN_5 = 32,
	EDMA_ERR_UNDERRUN_5 = 64,
	EDMA_ERR_IRQ_TRANSIENT = 65101824,
	EDMA_EH_FREEZE = -65102149,
	EDMA_EH_FREEZE_5 = 8059,
	EDMA_REQ_Q_BASE_HI = 16,
	EDMA_REQ_Q_IN_PTR = 20,
	EDMA_REQ_Q_OUT_PTR = 24,
	EDMA_REQ_Q_PTR_SHIFT = 5,
	EDMA_RSP_Q_BASE_HI = 28,
	EDMA_RSP_Q_IN_PTR = 32,
	EDMA_RSP_Q_OUT_PTR = 36,
	EDMA_RSP_Q_PTR_SHIFT = 3,
	EDMA_CMD = 40,
	EDMA_EN = 1,
	EDMA_DS = 2,
	EDMA_RESET = 4,
	EDMA_STATUS = 48,
	EDMA_STATUS_CACHE_EMPTY = 64,
	EDMA_STATUS_IDLE = 128,
	EDMA_IORDY_TMOUT = 52,
	EDMA_ARB_CFG = 56,
	EDMA_HALTCOND = 96,
	EDMA_UNKNOWN_RSVD = 108,
	BMDMA_CMD = 548,
	BMDMA_STATUS = 552,
	BMDMA_PRD_LOW = 556,
	BMDMA_PRD_HIGH = 560,
	MV_HP_FLAG_MSI = 1,
	MV_HP_ERRATA_50XXB0 = 2,
	MV_HP_ERRATA_50XXB2 = 4,
	MV_HP_ERRATA_60X1B2 = 8,
	MV_HP_ERRATA_60X1C0 = 16,
	MV_HP_GEN_I = 64,
	MV_HP_GEN_II = 128,
	MV_HP_GEN_IIE = 256,
	MV_HP_PCIE = 512,
	MV_HP_CUT_THROUGH = 1024,
	MV_HP_FLAG_SOC = 2048,
	MV_HP_QUIRK_LED_BLINK_EN = 4096,
	MV_HP_FIX_LP_PHY_CTL = 8192,
	MV_PP_FLAG_EDMA_EN = 1,
	MV_PP_FLAG_NCQ_EN = 2,
	MV_PP_FLAG_FBS_EN = 4,
	MV_PP_FLAG_DELAYED_EH = 8,
	MV_PP_FLAG_FAKE_ATA_BUSY = 16,
};

enum {
	NAME_LESS = 0,
	NAME_MATCHES = 1,
	NAME_GREATER = 2,
	NOT_ON_MEDIA = 3,
};

enum {
	NAPIF_STATE_SCHED = 1,
	NAPIF_STATE_MISSED = 2,
	NAPIF_STATE_DISABLE = 4,
	NAPIF_STATE_NPSVC = 8,
	NAPIF_STATE_LISTED = 16,
	NAPIF_STATE_NO_BUSY_POLL = 32,
	NAPIF_STATE_IN_BUSY_POLL = 64,
	NAPIF_STATE_PREFER_BUSY_POLL = 128,
	NAPIF_STATE_THREADED = 256,
	NAPIF_STATE_SCHED_THREADED = 512,
	NAPIF_STATE_HAS_NOTIFIER = 1024,
};

enum {
	NAPI_F_PREFER_BUSY_POLL = 1,
	NAPI_F_END_ON_RESCHED = 2,
};

enum {
	NAPI_STATE_SCHED = 0,
	NAPI_STATE_MISSED = 1,
	NAPI_STATE_DISABLE = 2,
	NAPI_STATE_NPSVC = 3,
	NAPI_STATE_LISTED = 4,
	NAPI_STATE_NO_BUSY_POLL = 5,
	NAPI_STATE_IN_BUSY_POLL = 6,
	NAPI_STATE_PREFER_BUSY_POLL = 7,
	NAPI_STATE_THREADED = 8,
	NAPI_STATE_SCHED_THREADED = 9,
	NAPI_STATE_HAS_NOTIFIER = 10,
};

enum {
	NAT_BITMAP = 0,
	SIT_BITMAP = 1,
};

enum {
	NAT_JOURNAL = 0,
	SIT_JOURNAL = 1,
};

enum {
	NCSI_CAP_BASE = 0,
	NCSI_CAP_GENERIC = 0,
	NCSI_CAP_BC = 1,
	NCSI_CAP_MC = 2,
	NCSI_CAP_BUFFER = 3,
	NCSI_CAP_AEN = 4,
	NCSI_CAP_VLAN = 5,
	NCSI_CAP_MAX = 6,
};

enum {
	NCSI_CAP_GENERIC_HWA = 1,
	NCSI_CAP_GENERIC_HDS = 2,
	NCSI_CAP_GENERIC_FC = 4,
	NCSI_CAP_GENERIC_FC1 = 8,
	NCSI_CAP_GENERIC_MC = 16,
	NCSI_CAP_GENERIC_HWA_UNKNOWN = 0,
	NCSI_CAP_GENERIC_HWA_SUPPORT = 32,
	NCSI_CAP_GENERIC_HWA_NOT_SUPPORT = 64,
	NCSI_CAP_GENERIC_HWA_RESERVED = 96,
	NCSI_CAP_GENERIC_HWA_MASK = 96,
	NCSI_CAP_GENERIC_MASK = 127,
	NCSI_CAP_BC_ARP = 1,
	NCSI_CAP_BC_DHCPC = 2,
	NCSI_CAP_BC_DHCPS = 4,
	NCSI_CAP_BC_NETBIOS = 8,
	NCSI_CAP_BC_MASK = 15,
	NCSI_CAP_MC_IPV6_NEIGHBOR = 1,
	NCSI_CAP_MC_IPV6_ROUTER = 2,
	NCSI_CAP_MC_DHCPV6_RELAY = 4,
	NCSI_CAP_MC_DHCPV6_WELL_KNOWN = 8,
	NCSI_CAP_MC_IPV6_MLD = 16,
	NCSI_CAP_MC_IPV6_NEIGHBOR_S = 32,
	NCSI_CAP_MC_MASK = 63,
	NCSI_CAP_AEN_LSC = 1,
	NCSI_CAP_AEN_CR = 2,
	NCSI_CAP_AEN_HDS = 4,
	NCSI_CAP_AEN_MASK = 7,
	NCSI_CAP_VLAN_ONLY = 1,
	NCSI_CAP_VLAN_NO = 2,
	NCSI_CAP_VLAN_ANY = 4,
	NCSI_CAP_VLAN_MASK = 7,
};

enum {
	NCSI_MODE_BASE = 0,
	NCSI_MODE_ENABLE = 0,
	NCSI_MODE_TX_ENABLE = 1,
	NCSI_MODE_LINK = 2,
	NCSI_MODE_VLAN = 3,
	NCSI_MODE_BC = 4,
	NCSI_MODE_MC = 5,
	NCSI_MODE_AEN = 6,
	NCSI_MODE_FC = 7,
	NCSI_MODE_MAX = 8,
};

enum {
	NDA_UNSPEC = 0,
	NDA_DST = 1,
	NDA_LLADDR = 2,
	NDA_CACHEINFO = 3,
	NDA_PROBES = 4,
	NDA_VLAN = 5,
	NDA_PORT = 6,
	NDA_VNI = 7,
	NDA_IFINDEX = 8,
	NDA_MASTER = 9,
	NDA_LINK_NETNSID = 10,
	NDA_SRC_VNI = 11,
	NDA_PROTOCOL = 12,
	NDA_NH_ID = 13,
	NDA_FDB_EXT_ATTRS = 14,
	NDA_FLAGS_EXT = 15,
	NDA_NDM_STATE_MASK = 16,
	NDA_NDM_FLAGS_MASK = 17,
	__NDA_MAX = 18,
};

enum {
	NDTA_UNSPEC = 0,
	NDTA_NAME = 1,
	NDTA_THRESH1 = 2,
	NDTA_THRESH2 = 3,
	NDTA_THRESH3 = 4,
	NDTA_CONFIG = 5,
	NDTA_PARMS = 6,
	NDTA_STATS = 7,
	NDTA_GC_INTERVAL = 8,
	NDTA_PAD = 9,
	__NDTA_MAX = 10,
};

enum {
	NDTPA_UNSPEC = 0,
	NDTPA_IFINDEX = 1,
	NDTPA_REFCNT = 2,
	NDTPA_REACHABLE_TIME = 3,
	NDTPA_BASE_REACHABLE_TIME = 4,
	NDTPA_RETRANS_TIME = 5,
	NDTPA_GC_STALETIME = 6,
	NDTPA_DELAY_PROBE_TIME = 7,
	NDTPA_QUEUE_LEN = 8,
	NDTPA_APP_PROBES = 9,
	NDTPA_UCAST_PROBES = 10,
	NDTPA_MCAST_PROBES = 11,
	NDTPA_ANYCAST_DELAY = 12,
	NDTPA_PROXY_DELAY = 13,
	NDTPA_PROXY_QLEN = 14,
	NDTPA_LOCKTIME = 15,
	NDTPA_QUEUE_LENBYTES = 16,
	NDTPA_MCAST_REPROBES = 17,
	NDTPA_PAD = 18,
	NDTPA_INTERVAL_PROBE_TIME_MS = 19,
	__NDTPA_MAX = 20,
};

enum {
	NDUSEROPT_UNSPEC = 0,
	NDUSEROPT_SRCADDR = 1,
	__NDUSEROPT_MAX = 2,
};

enum {
	NEIGH_ARP_TABLE = 0,
	NEIGH_ND_TABLE = 1,
	NEIGH_NR_TABLES = 2,
	NEIGH_LINK_TABLE = 2,
};

enum {
	NEIGH_VAR_MCAST_PROBES = 0,
	NEIGH_VAR_UCAST_PROBES = 1,
	NEIGH_VAR_APP_PROBES = 2,
	NEIGH_VAR_MCAST_REPROBES = 3,
	NEIGH_VAR_RETRANS_TIME = 4,
	NEIGH_VAR_BASE_REACHABLE_TIME = 5,
	NEIGH_VAR_DELAY_PROBE_TIME = 6,
	NEIGH_VAR_INTERVAL_PROBE_TIME_MS = 7,
	NEIGH_VAR_GC_STALETIME = 8,
	NEIGH_VAR_QUEUE_LEN_BYTES = 9,
	NEIGH_VAR_PROXY_QLEN = 10,
	NEIGH_VAR_ANYCAST_DELAY = 11,
	NEIGH_VAR_PROXY_DELAY = 12,
	NEIGH_VAR_LOCKTIME = 13,
	NEIGH_VAR_QUEUE_LEN = 14,
	NEIGH_VAR_RETRANS_TIME_MS = 15,
	NEIGH_VAR_BASE_REACHABLE_TIME_MS = 16,
	NEIGH_VAR_GC_INTERVAL = 17,
	NEIGH_VAR_GC_THRESH1 = 18,
	NEIGH_VAR_GC_THRESH2 = 19,
	NEIGH_VAR_GC_THRESH3 = 20,
	NEIGH_VAR_MAX = 21,
};

enum {
	NESTED_SYNC_IMM_BIT = 0,
	NESTED_SYNC_TODO_BIT = 1,
};

enum {
	NETCONFA_UNSPEC = 0,
	NETCONFA_IFINDEX = 1,
	NETCONFA_FORWARDING = 2,
	NETCONFA_RP_FILTER = 3,
	NETCONFA_MC_FORWARDING = 4,
	NETCONFA_PROXY_NEIGH = 5,
	NETCONFA_IGNORE_ROUTES_WITH_LINKDOWN = 6,
	NETCONFA_INPUT = 7,
	NETCONFA_BC_FORWARDING = 8,
	__NETCONFA_MAX = 9,
};

enum {
	NETDEV_A_DEV_IFINDEX = 1,
	NETDEV_A_DEV_PAD = 2,
	NETDEV_A_DEV_XDP_FEATURES = 3,
	NETDEV_A_DEV_XDP_ZC_MAX_SEGS = 4,
	NETDEV_A_DEV_XDP_RX_METADATA_FEATURES = 5,
	NETDEV_A_DEV_XSK_FEATURES = 6,
	__NETDEV_A_DEV_MAX = 7,
	NETDEV_A_DEV_MAX = 6,
};

enum {
	NETDEV_A_DMABUF_IFINDEX = 1,
	NETDEV_A_DMABUF_QUEUES = 2,
	NETDEV_A_DMABUF_FD = 3,
	NETDEV_A_DMABUF_ID = 4,
	__NETDEV_A_DMABUF_MAX = 5,
	NETDEV_A_DMABUF_MAX = 4,
};

enum {
	NETDEV_A_NAPI_IFINDEX = 1,
	NETDEV_A_NAPI_ID = 2,
	NETDEV_A_NAPI_IRQ = 3,
	NETDEV_A_NAPI_PID = 4,
	NETDEV_A_NAPI_DEFER_HARD_IRQS = 5,
	NETDEV_A_NAPI_GRO_FLUSH_TIMEOUT = 6,
	NETDEV_A_NAPI_IRQ_SUSPEND_TIMEOUT = 7,
	__NETDEV_A_NAPI_MAX = 8,
	NETDEV_A_NAPI_MAX = 7,
};

enum {
	NETDEV_A_PAGE_POOL_ID = 1,
	NETDEV_A_PAGE_POOL_IFINDEX = 2,
	NETDEV_A_PAGE_POOL_NAPI_ID = 3,
	NETDEV_A_PAGE_POOL_INFLIGHT = 4,
	NETDEV_A_PAGE_POOL_INFLIGHT_MEM = 5,
	NETDEV_A_PAGE_POOL_DETACH_TIME = 6,
	NETDEV_A_PAGE_POOL_DMABUF = 7,
	NETDEV_A_PAGE_POOL_IO_URING = 8,
	__NETDEV_A_PAGE_POOL_MAX = 9,
	NETDEV_A_PAGE_POOL_MAX = 8,
};

enum {
	NETDEV_A_PAGE_POOL_STATS_INFO = 1,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_FAST = 8,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW = 9,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_SLOW_HIGH_ORDER = 10,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_EMPTY = 11,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_REFILL = 12,
	NETDEV_A_PAGE_POOL_STATS_ALLOC_WAIVE = 13,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHED = 14,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_CACHE_FULL = 15,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING = 16,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RING_FULL = 17,
	NETDEV_A_PAGE_POOL_STATS_RECYCLE_RELEASED_REFCNT = 18,
	__NETDEV_A_PAGE_POOL_STATS_MAX = 19,
	NETDEV_A_PAGE_POOL_STATS_MAX = 18,
};

enum {
	NETDEV_A_QSTATS_IFINDEX = 1,
	NETDEV_A_QSTATS_QUEUE_TYPE = 2,
	NETDEV_A_QSTATS_QUEUE_ID = 3,
	NETDEV_A_QSTATS_SCOPE = 4,
	NETDEV_A_QSTATS_RX_PACKETS = 8,
	NETDEV_A_QSTATS_RX_BYTES = 9,
	NETDEV_A_QSTATS_TX_PACKETS = 10,
	NETDEV_A_QSTATS_TX_BYTES = 11,
	NETDEV_A_QSTATS_RX_ALLOC_FAIL = 12,
	NETDEV_A_QSTATS_RX_HW_DROPS = 13,
	NETDEV_A_QSTATS_RX_HW_DROP_OVERRUNS = 14,
	NETDEV_A_QSTATS_RX_CSUM_COMPLETE = 15,
	NETDEV_A_QSTATS_RX_CSUM_UNNECESSARY = 16,
	NETDEV_A_QSTATS_RX_CSUM_NONE = 17,
	NETDEV_A_QSTATS_RX_CSUM_BAD = 18,
	NETDEV_A_QSTATS_RX_HW_GRO_PACKETS = 19,
	NETDEV_A_QSTATS_RX_HW_GRO_BYTES = 20,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_PACKETS = 21,
	NETDEV_A_QSTATS_RX_HW_GRO_WIRE_BYTES = 22,
	NETDEV_A_QSTATS_RX_HW_DROP_RATELIMITS = 23,
	NETDEV_A_QSTATS_TX_HW_DROPS = 24,
	NETDEV_A_QSTATS_TX_HW_DROP_ERRORS = 25,
	NETDEV_A_QSTATS_TX_CSUM_NONE = 26,
	NETDEV_A_QSTATS_TX_NEEDS_CSUM = 27,
	NETDEV_A_QSTATS_TX_HW_GSO_PACKETS = 28,
	NETDEV_A_QSTATS_TX_HW_GSO_BYTES = 29,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_PACKETS = 30,
	NETDEV_A_QSTATS_TX_HW_GSO_WIRE_BYTES = 31,
	NETDEV_A_QSTATS_TX_HW_DROP_RATELIMITS = 32,
	NETDEV_A_QSTATS_TX_STOP = 33,
	NETDEV_A_QSTATS_TX_WAKE = 34,
	__NETDEV_A_QSTATS_MAX = 35,
	NETDEV_A_QSTATS_MAX = 34,
};

enum {
	NETDEV_A_QUEUE_ID = 1,
	NETDEV_A_QUEUE_IFINDEX = 2,
	NETDEV_A_QUEUE_TYPE = 3,
	NETDEV_A_QUEUE_NAPI_ID = 4,
	NETDEV_A_QUEUE_DMABUF = 5,
	NETDEV_A_QUEUE_IO_URING = 6,
	NETDEV_A_QUEUE_XSK = 7,
	__NETDEV_A_QUEUE_MAX = 8,
	NETDEV_A_QUEUE_MAX = 7,
};

enum {
	NETDEV_CMD_DEV_GET = 1,
	NETDEV_CMD_DEV_ADD_NTF = 2,
	NETDEV_CMD_DEV_DEL_NTF = 3,
	NETDEV_CMD_DEV_CHANGE_NTF = 4,
	NETDEV_CMD_PAGE_POOL_GET = 5,
	NETDEV_CMD_PAGE_POOL_ADD_NTF = 6,
	NETDEV_CMD_PAGE_POOL_DEL_NTF = 7,
	NETDEV_CMD_PAGE_POOL_CHANGE_NTF = 8,
	NETDEV_CMD_PAGE_POOL_STATS_GET = 9,
	NETDEV_CMD_QUEUE_GET = 10,
	NETDEV_CMD_NAPI_GET = 11,
	NETDEV_CMD_QSTATS_GET = 12,
	NETDEV_CMD_BIND_RX = 13,
	NETDEV_CMD_NAPI_SET = 14,
	NETDEV_CMD_BIND_TX = 15,
	__NETDEV_CMD_MAX = 16,
	NETDEV_CMD_MAX = 15,
};

enum {
	NETDEV_NLGRP_MGMT = 0,
	NETDEV_NLGRP_PAGE_POOL = 1,
};

enum {
	NETIF_F_SG_BIT = 0,
	NETIF_F_IP_CSUM_BIT = 1,
	__UNUSED_NETIF_F_1 = 2,
	NETIF_F_HW_CSUM_BIT = 3,
	NETIF_F_IPV6_CSUM_BIT = 4,
	NETIF_F_HIGHDMA_BIT = 5,
	NETIF_F_FRAGLIST_BIT = 6,
	NETIF_F_HW_VLAN_CTAG_TX_BIT = 7,
	NETIF_F_HW_VLAN_CTAG_RX_BIT = 8,
	NETIF_F_HW_VLAN_CTAG_FILTER_BIT = 9,
	NETIF_F_VLAN_CHALLENGED_BIT = 10,
	NETIF_F_GSO_BIT = 11,
	__UNUSED_NETIF_F_12 = 12,
	__UNUSED_NETIF_F_13 = 13,
	NETIF_F_GRO_BIT = 14,
	NETIF_F_LRO_BIT = 15,
	NETIF_F_GSO_SHIFT = 16,
	NETIF_F_TSO_BIT = 16,
	NETIF_F_GSO_ROBUST_BIT = 17,
	NETIF_F_TSO_ECN_BIT = 18,
	NETIF_F_TSO_MANGLEID_BIT = 19,
	NETIF_F_TSO6_BIT = 20,
	NETIF_F_FSO_BIT = 21,
	NETIF_F_GSO_GRE_BIT = 22,
	NETIF_F_GSO_GRE_CSUM_BIT = 23,
	NETIF_F_GSO_IPXIP4_BIT = 24,
	NETIF_F_GSO_IPXIP6_BIT = 25,
	NETIF_F_GSO_UDP_TUNNEL_BIT = 26,
	NETIF_F_GSO_UDP_TUNNEL_CSUM_BIT = 27,
	NETIF_F_GSO_PARTIAL_BIT = 28,
	NETIF_F_GSO_TUNNEL_REMCSUM_BIT = 29,
	NETIF_F_GSO_SCTP_BIT = 30,
	NETIF_F_GSO_ESP_BIT = 31,
	NETIF_F_GSO_UDP_BIT = 32,
	NETIF_F_GSO_UDP_L4_BIT = 33,
	NETIF_F_GSO_FRAGLIST_BIT = 34,
	NETIF_F_GSO_ACCECN_BIT = 35,
	NETIF_F_GSO_LAST = 35,
	NETIF_F_FCOE_CRC_BIT = 36,
	NETIF_F_SCTP_CRC_BIT = 37,
	NETIF_F_NTUPLE_BIT = 38,
	NETIF_F_RXHASH_BIT = 39,
	NETIF_F_RXCSUM_BIT = 40,
	NETIF_F_NOCACHE_COPY_BIT = 41,
	NETIF_F_LOOPBACK_BIT = 42,
	NETIF_F_RXFCS_BIT = 43,
	NETIF_F_RXALL_BIT = 44,
	NETIF_F_HW_VLAN_STAG_TX_BIT = 45,
	NETIF_F_HW_VLAN_STAG_RX_BIT = 46,
	NETIF_F_HW_VLAN_STAG_FILTER_BIT = 47,
	NETIF_F_HW_L2FW_DOFFLOAD_BIT = 48,
	NETIF_F_HW_TC_BIT = 49,
	NETIF_F_HW_ESP_BIT = 50,
	NETIF_F_HW_ESP_TX_CSUM_BIT = 51,
	NETIF_F_RX_UDP_TUNNEL_PORT_BIT = 52,
	NETIF_F_HW_TLS_TX_BIT = 53,
	NETIF_F_HW_TLS_RX_BIT = 54,
	NETIF_F_GRO_HW_BIT = 55,
	NETIF_F_HW_TLS_RECORD_BIT = 56,
	NETIF_F_GRO_FRAGLIST_BIT = 57,
	NETIF_F_HW_MACSEC_BIT = 58,
	NETIF_F_GRO_UDP_FWD_BIT = 59,
	NETIF_F_HW_HSR_TAG_INS_BIT = 60,
	NETIF_F_HW_HSR_TAG_RM_BIT = 61,
	NETIF_F_HW_HSR_FWD_BIT = 62,
	NETIF_F_HW_HSR_DUP_BIT = 63,
	NETDEV_FEATURE_COUNT = 64,
};

enum {
	NETIF_MSG_DRV_BIT = 0,
	NETIF_MSG_PROBE_BIT = 1,
	NETIF_MSG_LINK_BIT = 2,
	NETIF_MSG_TIMER_BIT = 3,
	NETIF_MSG_IFDOWN_BIT = 4,
	NETIF_MSG_IFUP_BIT = 5,
	NETIF_MSG_RX_ERR_BIT = 6,
	NETIF_MSG_TX_ERR_BIT = 7,
	NETIF_MSG_TX_QUEUED_BIT = 8,
	NETIF_MSG_INTR_BIT = 9,
	NETIF_MSG_TX_DONE_BIT = 10,
	NETIF_MSG_RX_STATUS_BIT = 11,
	NETIF_MSG_PKTDATA_BIT = 12,
	NETIF_MSG_HW_BIT = 13,
	NETIF_MSG_WOL_BIT = 14,
	NETIF_MSG_CLASS_COUNT = 15,
};

enum {
	NETLINK_F_KERNEL_SOCKET = 0,
	NETLINK_F_RECV_PKTINFO = 1,
	NETLINK_F_BROADCAST_SEND_ERROR = 2,
	NETLINK_F_RECV_NO_ENOBUFS = 3,
	NETLINK_F_LISTEN_ALL_NSID = 4,
	NETLINK_F_CAP_ACK = 5,
	NETLINK_F_EXT_ACK = 6,
	NETLINK_F_STRICT_CHK = 7,
};

enum {
	NETLINK_UNCONNECTED = 0,
	NETLINK_CONNECTED = 1,
};

enum {
	NETNSA_NONE = 0,
	NETNSA_NSID = 1,
	NETNSA_PID = 2,
	NETNSA_FD = 3,
	NETNSA_TARGET_NSID = 4,
	NETNSA_CURRENT_NSID = 5,
	__NETNSA_MAX = 6,
};

enum {
	NET_NS_INDEX = 0,
	UTS_NS_INDEX = 1,
	IPC_NS_INDEX = 2,
	PID_NS_INDEX = 3,
	USER_NS_INDEX = 4,
	MNT_NS_INDEX = 5,
	CGROUP_NS_INDEX = 6,
	NR_NAMESPACES = 7,
};

enum {
	NET_SHAPER_A_CAPS_IFINDEX = 1,
	NET_SHAPER_A_CAPS_SCOPE = 2,
	NET_SHAPER_A_CAPS_SUPPORT_METRIC_BPS = 3,
	NET_SHAPER_A_CAPS_SUPPORT_METRIC_PPS = 4,
	NET_SHAPER_A_CAPS_SUPPORT_NESTING = 5,
	NET_SHAPER_A_CAPS_SUPPORT_BW_MIN = 6,
	NET_SHAPER_A_CAPS_SUPPORT_BW_MAX = 7,
	NET_SHAPER_A_CAPS_SUPPORT_BURST = 8,
	NET_SHAPER_A_CAPS_SUPPORT_PRIORITY = 9,
	NET_SHAPER_A_CAPS_SUPPORT_WEIGHT = 10,
	__NET_SHAPER_A_CAPS_MAX = 11,
	NET_SHAPER_A_CAPS_MAX = 10,
};

enum {
	NET_SHAPER_A_HANDLE = 1,
	NET_SHAPER_A_METRIC = 2,
	NET_SHAPER_A_BW_MIN = 3,
	NET_SHAPER_A_BW_MAX = 4,
	NET_SHAPER_A_BURST = 5,
	NET_SHAPER_A_PRIORITY = 6,
	NET_SHAPER_A_WEIGHT = 7,
	NET_SHAPER_A_IFINDEX = 8,
	NET_SHAPER_A_PARENT = 9,
	NET_SHAPER_A_LEAVES = 10,
	__NET_SHAPER_A_MAX = 11,
	NET_SHAPER_A_MAX = 10,
};

enum {
	NET_SHAPER_A_HANDLE_SCOPE = 1,
	NET_SHAPER_A_HANDLE_ID = 2,
	__NET_SHAPER_A_HANDLE_MAX = 3,
	NET_SHAPER_A_HANDLE_MAX = 2,
};

enum {
	NET_SHAPER_CMD_GET = 1,
	NET_SHAPER_CMD_SET = 2,
	NET_SHAPER_CMD_DELETE = 3,
	NET_SHAPER_CMD_GROUP = 4,
	NET_SHAPER_CMD_CAP_GET = 5,
	__NET_SHAPER_CMD_MAX = 6,
	NET_SHAPER_CMD_MAX = 5,
};

enum {
	NEXTHOP_GRP_TYPE_MPATH = 0,
	NEXTHOP_GRP_TYPE_RES = 1,
	__NEXTHOP_GRP_TYPE_MAX = 2,
};

enum {
	NFPROTO_UNSPEC = 0,
	NFPROTO_INET = 1,
	NFPROTO_IPV4 = 2,
	NFPROTO_ARP = 3,
	NFPROTO_NETDEV = 5,
	NFPROTO_BRIDGE = 7,
	NFPROTO_IPV6 = 10,
	NFPROTO_NUMPROTO = 11,
};

enum {
	NFSPROC4_CLNT_NULL = 0,
	NFSPROC4_CLNT_READ = 1,
	NFSPROC4_CLNT_WRITE = 2,
	NFSPROC4_CLNT_COMMIT = 3,
	NFSPROC4_CLNT_OPEN = 4,
	NFSPROC4_CLNT_OPEN_CONFIRM = 5,
	NFSPROC4_CLNT_OPEN_NOATTR = 6,
	NFSPROC4_CLNT_OPEN_DOWNGRADE = 7,
	NFSPROC4_CLNT_CLOSE = 8,
	NFSPROC4_CLNT_SETATTR = 9,
	NFSPROC4_CLNT_FSINFO = 10,
	NFSPROC4_CLNT_RENEW = 11,
	NFSPROC4_CLNT_SETCLIENTID = 12,
	NFSPROC4_CLNT_SETCLIENTID_CONFIRM = 13,
	NFSPROC4_CLNT_LOCK = 14,
	NFSPROC4_CLNT_LOCKT = 15,
	NFSPROC4_CLNT_LOCKU = 16,
	NFSPROC4_CLNT_ACCESS = 17,
	NFSPROC4_CLNT_GETATTR = 18,
	NFSPROC4_CLNT_LOOKUP = 19,
	NFSPROC4_CLNT_LOOKUP_ROOT = 20,
	NFSPROC4_CLNT_REMOVE = 21,
	NFSPROC4_CLNT_RENAME = 22,
	NFSPROC4_CLNT_LINK = 23,
	NFSPROC4_CLNT_SYMLINK = 24,
	NFSPROC4_CLNT_CREATE = 25,
	NFSPROC4_CLNT_PATHCONF = 26,
	NFSPROC4_CLNT_STATFS = 27,
	NFSPROC4_CLNT_READLINK = 28,
	NFSPROC4_CLNT_READDIR = 29,
	NFSPROC4_CLNT_SERVER_CAPS = 30,
	NFSPROC4_CLNT_DELEGRETURN = 31,
	NFSPROC4_CLNT_GETACL = 32,
	NFSPROC4_CLNT_SETACL = 33,
	NFSPROC4_CLNT_FS_LOCATIONS = 34,
	NFSPROC4_CLNT_RELEASE_LOCKOWNER = 35,
	NFSPROC4_CLNT_SECINFO = 36,
	NFSPROC4_CLNT_FSID_PRESENT = 37,
	NFSPROC4_CLNT_EXCHANGE_ID = 38,
	NFSPROC4_CLNT_CREATE_SESSION = 39,
	NFSPROC4_CLNT_DESTROY_SESSION = 40,
	NFSPROC4_CLNT_SEQUENCE = 41,
	NFSPROC4_CLNT_GET_LEASE_TIME = 42,
	NFSPROC4_CLNT_RECLAIM_COMPLETE = 43,
	NFSPROC4_CLNT_LAYOUTGET = 44,
	NFSPROC4_CLNT_GETDEVICEINFO = 45,
	NFSPROC4_CLNT_LAYOUTCOMMIT = 46,
	NFSPROC4_CLNT_LAYOUTRETURN = 47,
	NFSPROC4_CLNT_SECINFO_NO_NAME = 48,
	NFSPROC4_CLNT_TEST_STATEID = 49,
	NFSPROC4_CLNT_FREE_STATEID = 50,
	NFSPROC4_CLNT_GETDEVICELIST = 51,
	NFSPROC4_CLNT_BIND_CONN_TO_SESSION = 52,
	NFSPROC4_CLNT_DESTROY_CLIENTID = 53,
	NFSPROC4_CLNT_SEEK = 54,
	NFSPROC4_CLNT_ALLOCATE = 55,
	NFSPROC4_CLNT_DEALLOCATE = 56,
	NFSPROC4_CLNT_ZERO_RANGE = 57,
	NFSPROC4_CLNT_LAYOUTSTATS = 58,
	NFSPROC4_CLNT_CLONE = 59,
	NFSPROC4_CLNT_COPY = 60,
	NFSPROC4_CLNT_OFFLOAD_CANCEL = 61,
	NFSPROC4_CLNT_LOOKUPP = 62,
	NFSPROC4_CLNT_LAYOUTERROR = 63,
	NFSPROC4_CLNT_COPY_NOTIFY = 64,
	NFSPROC4_CLNT_GETXATTR = 65,
	NFSPROC4_CLNT_SETXATTR = 66,
	NFSPROC4_CLNT_LISTXATTRS = 67,
	NFSPROC4_CLNT_REMOVEXATTR = 68,
	NFSPROC4_CLNT_READ_PLUS = 69,
	NFSPROC4_CLNT_OFFLOAD_STATUS = 70,
};

enum {
	NFS_DELEGATION_NEED_RECLAIM = 0,
	NFS_DELEGATION_RETURN = 1,
	NFS_DELEGATION_RETURN_IF_CLOSED = 2,
	NFS_DELEGATION_REFERENCED = 3,
	NFS_DELEGATION_RETURNING = 4,
	NFS_DELEGATION_REVOKED = 5,
	NFS_DELEGATION_TEST_EXPIRED = 6,
	NFS_DELEGATION_INODE_FREEING = 7,
	NFS_DELEGATION_RETURN_DELAYED = 8,
	NFS_DELEGATION_DELEGTIME = 9,
};

enum {
	NFS_DEVICEID_INVALID = 0,
	NFS_DEVICEID_UNAVAILABLE = 1,
	NFS_DEVICEID_NOCACHE = 2,
};

enum {
	NFS_IOHDR_ERROR = 0,
	NFS_IOHDR_EOF = 1,
	NFS_IOHDR_REDO = 2,
	NFS_IOHDR_STAT = 3,
	NFS_IOHDR_RESEND_PNFS = 4,
	NFS_IOHDR_RESEND_MDS = 5,
	NFS_IOHDR_UNSTABLE_WRITES = 6,
	NFS_IOHDR_ODIRECT = 7,
};

enum {
	NFS_LAYOUT_RO_FAILED = 0,
	NFS_LAYOUT_RW_FAILED = 1,
	NFS_LAYOUT_BULK_RECALL = 2,
	NFS_LAYOUT_RETURN = 3,
	NFS_LAYOUT_RETURN_LOCK = 4,
	NFS_LAYOUT_RETURN_REQUESTED = 5,
	NFS_LAYOUT_INVALID_STID = 6,
	NFS_LAYOUT_FIRST_LAYOUTGET = 7,
	NFS_LAYOUT_INODE_FREEING = 8,
	NFS_LAYOUT_HASHED = 9,
	NFS_LAYOUT_DRAIN = 10,
};

enum {
	NFS_LSEG_VALID = 0,
	NFS_LSEG_ROC = 1,
	NFS_LSEG_LAYOUTCOMMIT = 2,
	NFS_LSEG_LAYOUTRETURN = 3,
	NFS_LSEG_UNAVAILABLE = 4,
};

enum {
	NFS_OWNER_RECLAIM_REBOOT = 0,
	NFS_OWNER_RECLAIM_NOGRACE = 1,
};

enum {
	NHA_GROUP_STATS_ENTRY_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY_ID = 1,
	NHA_GROUP_STATS_ENTRY_PACKETS = 2,
	NHA_GROUP_STATS_ENTRY_PACKETS_HW = 3,
	__NHA_GROUP_STATS_ENTRY_MAX = 4,
};

enum {
	NHA_GROUP_STATS_UNSPEC = 0,
	NHA_GROUP_STATS_ENTRY = 1,
	__NHA_GROUP_STATS_MAX = 2,
};

enum {
	NHA_RES_BUCKET_UNSPEC = 0,
	NHA_RES_BUCKET_PAD = 0,
	NHA_RES_BUCKET_INDEX = 1,
	NHA_RES_BUCKET_IDLE_TIME = 2,
	NHA_RES_BUCKET_NH_ID = 3,
	__NHA_RES_BUCKET_MAX = 4,
};

enum {
	NHA_RES_GROUP_UNSPEC = 0,
	NHA_RES_GROUP_PAD = 0,
	NHA_RES_GROUP_BUCKETS = 1,
	NHA_RES_GROUP_IDLE_TIMER = 2,
	NHA_RES_GROUP_UNBALANCED_TIMER = 3,
	NHA_RES_GROUP_UNBALANCED_TIME = 4,
	__NHA_RES_GROUP_MAX = 5,
};

enum {
	NHA_UNSPEC = 0,
	NHA_ID = 1,
	NHA_GROUP = 2,
	NHA_GROUP_TYPE = 3,
	NHA_BLACKHOLE = 4,
	NHA_OIF = 5,
	NHA_GATEWAY = 6,
	NHA_ENCAP_TYPE = 7,
	NHA_ENCAP = 8,
	NHA_GROUPS = 9,
	NHA_MASTER = 10,
	NHA_FDB = 11,
	NHA_RES_GROUP = 12,
	NHA_RES_BUCKET = 13,
	NHA_OP_FLAGS = 14,
	NHA_GROUP_STATS = 15,
	NHA_HW_STATS_ENABLE = 16,
	NHA_HW_STATS_USED = 17,
	__NHA_MAX = 18,
};

enum {
	NLA_UNSPEC = 0,
	NLA_U8 = 1,
	NLA_U16 = 2,
	NLA_U32 = 3,
	NLA_U64 = 4,
	NLA_STRING = 5,
	NLA_FLAG = 6,
	NLA_MSECS = 7,
	NLA_NESTED = 8,
	NLA_NESTED_ARRAY = 9,
	NLA_NUL_STRING = 10,
	NLA_BINARY = 11,
	NLA_S8 = 12,
	NLA_S16 = 13,
	NLA_S32 = 14,
	NLA_S64 = 15,
	NLA_BITFIELD32 = 16,
	NLA_REJECT = 17,
	NLA_BE16 = 18,
	NLA_BE32 = 19,
	NLA_SINT = 20,
	NLA_UINT = 21,
	__NLA_TYPE_MAX = 22,
};

enum {
	NLBL_CALIPSO_A_UNSPEC = 0,
	NLBL_CALIPSO_A_DOI = 1,
	NLBL_CALIPSO_A_MTYPE = 2,
	__NLBL_CALIPSO_A_MAX = 3,
};

enum {
	NLBL_CALIPSO_C_UNSPEC = 0,
	NLBL_CALIPSO_C_ADD = 1,
	NLBL_CALIPSO_C_REMOVE = 2,
	NLBL_CALIPSO_C_LIST = 3,
	NLBL_CALIPSO_C_LISTALL = 4,
	__NLBL_CALIPSO_C_MAX = 5,
};

enum {
	NLBL_CIPSOV4_A_UNSPEC = 0,
	NLBL_CIPSOV4_A_DOI = 1,
	NLBL_CIPSOV4_A_MTYPE = 2,
	NLBL_CIPSOV4_A_TAG = 3,
	NLBL_CIPSOV4_A_TAGLST = 4,
	NLBL_CIPSOV4_A_MLSLVLLOC = 5,
	NLBL_CIPSOV4_A_MLSLVLREM = 6,
	NLBL_CIPSOV4_A_MLSLVL = 7,
	NLBL_CIPSOV4_A_MLSLVLLST = 8,
	NLBL_CIPSOV4_A_MLSCATLOC = 9,
	NLBL_CIPSOV4_A_MLSCATREM = 10,
	NLBL_CIPSOV4_A_MLSCAT = 11,
	NLBL_CIPSOV4_A_MLSCATLST = 12,
	__NLBL_CIPSOV4_A_MAX = 13,
};

enum {
	NLBL_CIPSOV4_C_UNSPEC = 0,
	NLBL_CIPSOV4_C_ADD = 1,
	NLBL_CIPSOV4_C_REMOVE = 2,
	NLBL_CIPSOV4_C_LIST = 3,
	NLBL_CIPSOV4_C_LISTALL = 4,
	__NLBL_CIPSOV4_C_MAX = 5,
};

enum {
	NLBL_MGMT_A_UNSPEC = 0,
	NLBL_MGMT_A_DOMAIN = 1,
	NLBL_MGMT_A_PROTOCOL = 2,
	NLBL_MGMT_A_VERSION = 3,
	NLBL_MGMT_A_CV4DOI = 4,
	NLBL_MGMT_A_IPV6ADDR = 5,
	NLBL_MGMT_A_IPV6MASK = 6,
	NLBL_MGMT_A_IPV4ADDR = 7,
	NLBL_MGMT_A_IPV4MASK = 8,
	NLBL_MGMT_A_ADDRSELECTOR = 9,
	NLBL_MGMT_A_SELECTORLIST = 10,
	NLBL_MGMT_A_FAMILY = 11,
	NLBL_MGMT_A_CLPDOI = 12,
	__NLBL_MGMT_A_MAX = 13,
};

enum {
	NLBL_MGMT_C_UNSPEC = 0,
	NLBL_MGMT_C_ADD = 1,
	NLBL_MGMT_C_REMOVE = 2,
	NLBL_MGMT_C_LISTALL = 3,
	NLBL_MGMT_C_ADDDEF = 4,
	NLBL_MGMT_C_REMOVEDEF = 5,
	NLBL_MGMT_C_LISTDEF = 6,
	NLBL_MGMT_C_PROTOCOLS = 7,
	NLBL_MGMT_C_VERSION = 8,
	__NLBL_MGMT_C_MAX = 9,
};

enum {
	NLBL_UNLABEL_A_UNSPEC = 0,
	NLBL_UNLABEL_A_ACPTFLG = 1,
	NLBL_UNLABEL_A_IPV6ADDR = 2,
	NLBL_UNLABEL_A_IPV6MASK = 3,
	NLBL_UNLABEL_A_IPV4ADDR = 4,
	NLBL_UNLABEL_A_IPV4MASK = 5,
	NLBL_UNLABEL_A_IFACE = 6,
	NLBL_UNLABEL_A_SECCTX = 7,
	__NLBL_UNLABEL_A_MAX = 8,
};

enum {
	NLBL_UNLABEL_C_UNSPEC = 0,
	NLBL_UNLABEL_C_ACCEPT = 1,
	NLBL_UNLABEL_C_LIST = 2,
	NLBL_UNLABEL_C_STATICADD = 3,
	NLBL_UNLABEL_C_STATICREMOVE = 4,
	NLBL_UNLABEL_C_STATICLIST = 5,
	NLBL_UNLABEL_C_STATICADDDEF = 6,
	NLBL_UNLABEL_C_STATICREMOVEDEF = 7,
	NLBL_UNLABEL_C_STATICLISTDEF = 8,
	__NLBL_UNLABEL_C_MAX = 9,
};

enum {
	NLM_LCK_GRANTED = 0,
	NLM_LCK_DENIED = 1,
	NLM_LCK_DENIED_NOLOCKS = 2,
	NLM_LCK_BLOCKED = 3,
	NLM_LCK_DENIED_GRACE_PERIOD = 4,
	NLM_DEADLCK = 5,
	NLM_ROFS = 6,
	NLM_STALE_FH = 7,
	NLM_FBIG = 8,
	NLM_FAILED = 9,
};

enum {
	NSMPROC_NULL = 0,
	NSMPROC_STAT = 1,
	NSMPROC_MON = 2,
	NSMPROC_UNMON = 3,
	NSMPROC_UNMON_ALL = 4,
	NSMPROC_SIMU_CRASH = 5,
	NSMPROC_NOTIFY = 6,
};

enum {
	NUM_TRIAL_SAMPLES = 8192,
	MAX_SAMPLES_PER_BIT = 16,
};

enum {
	NVMEM_ADD = 1,
	NVMEM_REMOVE = 2,
	NVMEM_CELL_ADD = 3,
	NVMEM_CELL_REMOVE = 4,
	NVMEM_LAYOUT_ADD = 5,
	NVMEM_LAYOUT_REMOVE = 6,
};

enum {
	NVME_CC_ENABLE = 1,
	NVME_CC_EN_SHIFT = 0,
	NVME_CC_CSS_SHIFT = 4,
	NVME_CC_CSS_MASK = 112,
	NVME_CC_CSS_NVM = 0,
	NVME_CC_CSS_CSI = 96,
	NVME_CC_MPS_SHIFT = 7,
	NVME_CC_MPS_MASK = 1920,
	NVME_CC_AMS_SHIFT = 11,
	NVME_CC_AMS_MASK = 14336,
	NVME_CC_AMS_RR = 0,
	NVME_CC_AMS_WRRU = 2048,
	NVME_CC_AMS_VS = 14336,
	NVME_CC_SHN_SHIFT = 14,
	NVME_CC_SHN_MASK = 49152,
	NVME_CC_SHN_NONE = 0,
	NVME_CC_SHN_NORMAL = 16384,
	NVME_CC_SHN_ABRUPT = 32768,
	NVME_CC_IOSQES_SHIFT = 16,
	NVME_CC_IOSQES_MASK = 983040,
	NVME_CC_IOSQES = 393216,
	NVME_CC_IOCQES_SHIFT = 20,
	NVME_CC_IOCQES_MASK = 15728640,
	NVME_CC_IOCQES = 4194304,
	NVME_CC_CRIME = 16777216,
};

enum {
	NVME_CSTS_RDY = 1,
	NVME_CSTS_CFS = 2,
	NVME_CSTS_NSSRO = 16,
	NVME_CSTS_PP = 32,
	NVME_CSTS_SHST_NORMAL = 0,
	NVME_CSTS_SHST_OCCUR = 4,
	NVME_CSTS_SHST_CMPLT = 8,
	NVME_CSTS_SHST_MASK = 12,
};

enum {
	NVME_REG_CAP = 0,
	NVME_REG_VS = 8,
	NVME_REG_INTMS = 12,
	NVME_REG_INTMC = 16,
	NVME_REG_CC = 20,
	NVME_REG_CSTS = 28,
	NVME_REG_NSSR = 32,
	NVME_REG_AQA = 36,
	NVME_REG_ASQ = 40,
	NVME_REG_ACQ = 48,
	NVME_REG_CMBLOC = 56,
	NVME_REG_CMBSZ = 60,
	NVME_REG_BPINFO = 64,
	NVME_REG_BPRSEL = 68,
	NVME_REG_BPMBL = 72,
	NVME_REG_CMBMSC = 80,
	NVME_REG_CRTO = 104,
	NVME_REG_PMRCAP = 3584,
	NVME_REG_PMRCTL = 3588,
	NVME_REG_PMRSTS = 3592,
	NVME_REG_PMREBS = 3596,
	NVME_REG_PMRSWTP = 3600,
	NVME_REG_DBS = 4096,
};

enum {
	NV_MMIO_BAR = 5,
	NV_PORTS = 2,
	NV_PIO_MASK = 31,
	NV_MWDMA_MASK = 7,
	NV_UDMA_MASK = 127,
	NV_PORT0_SCR_REG_OFFSET = 0,
	NV_PORT1_SCR_REG_OFFSET = 64,
	NV_INT_STATUS = 16,
	NV_INT_ENABLE = 17,
	NV_INT_STATUS_CK804 = 1088,
	NV_INT_ENABLE_CK804 = 1089,
	NV_INT_DEV = 1,
	NV_INT_PM = 2,
	NV_INT_ADDED = 4,
	NV_INT_REMOVED = 8,
	NV_INT_PORT_SHIFT = 4,
	NV_INT_ALL = 15,
	NV_INT_MASK = 13,
	NV_INT_CONFIG = 18,
	NV_INT_CONFIG_METHD = 1,
	NV_MCP_SATA_CFG_20 = 80,
	NV_MCP_SATA_CFG_20_SATA_SPACE_EN = 4,
	NV_MCP_SATA_CFG_20_PORT0_EN = 131072,
	NV_MCP_SATA_CFG_20_PORT1_EN = 65536,
	NV_MCP_SATA_CFG_20_PORT0_PWB_EN = 16384,
	NV_MCP_SATA_CFG_20_PORT1_PWB_EN = 4096,
	NV_ADMA_MAX_CPBS = 32,
	NV_ADMA_CPB_SZ = 128,
	NV_ADMA_APRD_SZ = 16,
	NV_ADMA_SGTBL_LEN = 56,
	NV_ADMA_SGTBL_TOTAL_LEN = 61,
	NV_ADMA_SGTBL_SZ = 896,
	NV_ADMA_PORT_PRIV_DMA_SZ = 32768,
	NV_ADMA_GEN = 1024,
	NV_ADMA_GEN_CTL = 0,
	NV_ADMA_NOTIFIER_CLEAR = 48,
	NV_ADMA_PORT = 1152,
	NV_ADMA_PORT_SIZE = 256,
	NV_ADMA_CTL = 64,
	NV_ADMA_CPB_COUNT = 66,
	NV_ADMA_NEXT_CPB_IDX = 67,
	NV_ADMA_STAT = 68,
	NV_ADMA_CPB_BASE_LOW = 72,
	NV_ADMA_CPB_BASE_HIGH = 76,
	NV_ADMA_APPEND = 80,
	NV_ADMA_NOTIFIER = 104,
	NV_ADMA_NOTIFIER_ERROR = 108,
	NV_ADMA_CTL_HOTPLUG_IEN = 1,
	NV_ADMA_CTL_CHANNEL_RESET = 32,
	NV_ADMA_CTL_GO = 128,
	NV_ADMA_CTL_AIEN = 256,
	NV_ADMA_CTL_READ_NON_COHERENT = 2048,
	NV_ADMA_CTL_WRITE_NON_COHERENT = 4096,
	NV_CPB_RESP_DONE = 1,
	NV_CPB_RESP_ATA_ERR = 8,
	NV_CPB_RESP_CMD_ERR = 16,
	NV_CPB_RESP_CPB_ERR = 128,
	NV_CPB_CTL_CPB_VALID = 1,
	NV_CPB_CTL_QUEUE = 2,
	NV_CPB_CTL_APRD_VALID = 4,
	NV_CPB_CTL_IEN = 8,
	NV_CPB_CTL_FPDMA = 16,
	NV_APRD_WRITE = 2,
	NV_APRD_END = 4,
	NV_APRD_CONT = 8,
	NV_ADMA_STAT_TIMEOUT = 1,
	NV_ADMA_STAT_HOTUNPLUG = 2,
	NV_ADMA_STAT_HOTPLUG = 4,
	NV_ADMA_STAT_CPBERR = 16,
	NV_ADMA_STAT_SERROR = 32,
	NV_ADMA_STAT_CMD_COMPLETE = 64,
	NV_ADMA_STAT_IDLE = 256,
	NV_ADMA_STAT_LEGACY = 512,
	NV_ADMA_STAT_STOPPED = 1024,
	NV_ADMA_STAT_DONE = 4096,
	NV_ADMA_STAT_ERR = 17,
	NV_ADMA_PORT_REGISTER_MODE = 1,
	NV_ADMA_ATAPI_SETUP_COMPLETE = 2,
	NV_CTL_MCP55 = 1024,
	NV_INT_STATUS_MCP55 = 1088,
	NV_INT_ENABLE_MCP55 = 1092,
	NV_NCQ_REG_MCP55 = 1096,
	NV_INT_ALL_MCP55 = 65535,
	NV_INT_PORT_SHIFT_MCP55 = 16,
	NV_INT_MASK_MCP55 = 65533,
	NV_CTL_PRI_SWNCQ = 2,
	NV_CTL_SEC_SWNCQ = 4,
	NV_SWNCQ_IRQ_DEV = 1,
	NV_SWNCQ_IRQ_PM = 2,
	NV_SWNCQ_IRQ_ADDED = 4,
	NV_SWNCQ_IRQ_REMOVED = 8,
	NV_SWNCQ_IRQ_BACKOUT = 16,
	NV_SWNCQ_IRQ_SDBFIS = 32,
	NV_SWNCQ_IRQ_DHREGFIS = 64,
	NV_SWNCQ_IRQ_DMASETUP = 128,
	NV_SWNCQ_IRQ_HOTPLUG = 12,
};

enum {
	OD_NORMAL_SAMPLE = 0,
	OD_SUB_SAMPLE = 1,
};

enum {
	OMAP3_SOC_AM35XX = 0,
	OMAP3_SOC_OMAP3430_ES1 = 1,
	OMAP3_SOC_OMAP3430_ES2_PLUS = 2,
	OMAP3_SOC_OMAP3630 = 3,
};

enum {
	OMAP_DMA_REG_NONE = 0,
	OMAP_DMA_REG_16BIT = 1,
	OMAP_DMA_REG_2X16BIT = 2,
	OMAP_DMA_REG_32BIT = 3,
};

enum {
	OMAP_I2C_REV_REG = 0,
	OMAP_I2C_IE_REG = 1,
	OMAP_I2C_STAT_REG = 2,
	OMAP_I2C_IV_REG = 3,
	OMAP_I2C_WE_REG = 4,
	OMAP_I2C_SYSS_REG = 5,
	OMAP_I2C_BUF_REG = 6,
	OMAP_I2C_CNT_REG = 7,
	OMAP_I2C_DATA_REG = 8,
	OMAP_I2C_SYSC_REG = 9,
	OMAP_I2C_CON_REG = 10,
	OMAP_I2C_OA_REG = 11,
	OMAP_I2C_SA_REG = 12,
	OMAP_I2C_PSC_REG = 13,
	OMAP_I2C_SCLL_REG = 14,
	OMAP_I2C_SCLH_REG = 15,
	OMAP_I2C_SYSTEST_REG = 16,
	OMAP_I2C_BUFSTAT_REG = 17,
	OMAP_I2C_IP_V2_REVNB_LO = 18,
	OMAP_I2C_IP_V2_REVNB_HI = 19,
	OMAP_I2C_IP_V2_IRQSTATUS_RAW = 20,
	OMAP_I2C_IP_V2_IRQENABLE_SET = 21,
	OMAP_I2C_IP_V2_IRQENABLE_CLR = 22,
};

enum {
	OPT_UID = 0,
	OPT_GID = 1,
	OPT_MODE = 2,
	OPT_DELEGATE_CMDS = 3,
	OPT_DELEGATE_MAPS = 4,
	OPT_DELEGATE_PROGS = 5,
	OPT_DELEGATE_ATTACHS = 6,
};

enum {
	ORPHAN_INO = 0,
	APPEND_INO = 1,
	UPDATE_INO = 2,
	TRANS_DIR_INO = 3,
	XATTR_DIR_INO = 4,
	FLUSH_INO = 5,
	MAX_INO_ENTRY = 6,
};

enum {
	OVL_REDIRECT_OFF = 0,
	OVL_REDIRECT_FOLLOW = 1,
	OVL_REDIRECT_NOFOLLOW = 2,
	OVL_REDIRECT_ON = 3,
};

enum {
	OVL_UUID_OFF = 0,
	OVL_UUID_NULL = 1,
	OVL_UUID_AUTO = 2,
	OVL_UUID_ON = 3,
};

enum {
	OVL_VERITY_OFF = 0,
	OVL_VERITY_ON = 1,
	OVL_VERITY_REQUIRE = 2,
};

enum {
	OVL_XINO_OFF = 0,
	OVL_XINO_AUTO = 1,
	OVL_XINO_ON = 2,
};

enum {
	Opt_acl = 0,
	Opt_clear_cache = 1,
	Opt_commit_interval = 2,
	Opt_compress = 3,
	Opt_compress_force = 4,
	Opt_compress_force_type = 5,
	Opt_compress_type = 6,
	Opt_degraded = 7,
	Opt_device = 8,
	Opt_fatal_errors = 9,
	Opt_flushoncommit = 10,
	Opt_max_inline = 11,
	Opt_barrier = 12,
	Opt_datacow = 13,
	Opt_datasum = 14,
	Opt_defrag = 15,
	Opt_discard = 16,
	Opt_discard_mode = 17,
	Opt_ratio = 18,
	Opt_rescan_uuid_tree = 19,
	Opt_skip_balance = 20,
	Opt_space_cache = 21,
	Opt_space_cache_version = 22,
	Opt_ssd = 23,
	Opt_ssd_spread = 24,
	Opt_subvol = 25,
	Opt_subvol_empty = 26,
	Opt_subvolid = 27,
	Opt_thread_pool = 28,
	Opt_treelog = 29,
	Opt_user_subvol_rm_allowed = 30,
	Opt_norecovery = 31,
	Opt_rescue = 32,
	Opt_usebackuproot = 33,
	Opt_enospc_debug = 34,
	Opt_err = 35,
};

enum {
	Opt_bsd_df = 0,
	Opt_minix_df = 1,
	Opt_grpid = 2,
	Opt_nogrpid = 3,
	Opt_resgid = 4,
	Opt_resuid = 5,
	Opt_sb = 6,
	Opt_nouid32 = 7,
	Opt_debug = 8,
	Opt_removed = 9,
	Opt_user_xattr = 10,
	Opt_acl___2 = 11,
	Opt_auto_da_alloc = 12,
	Opt_noauto_da_alloc = 13,
	Opt_noload = 14,
	Opt_commit = 15,
	Opt_min_batch_time = 16,
	Opt_max_batch_time = 17,
	Opt_journal_dev = 18,
	Opt_journal_path = 19,
	Opt_journal_checksum = 20,
	Opt_journal_async_commit = 21,
	Opt_abort = 22,
	Opt_data_journal = 23,
	Opt_data_ordered = 24,
	Opt_data_writeback = 25,
	Opt_data_err_abort = 26,
	Opt_data_err_ignore = 27,
	Opt_test_dummy_encryption = 28,
	Opt_inlinecrypt = 29,
	Opt_usrjquota = 30,
	Opt_grpjquota = 31,
	Opt_quota = 32,
	Opt_noquota = 33,
	Opt_barrier___2 = 34,
	Opt_nobarrier = 35,
	Opt_err___2 = 36,
	Opt_usrquota = 37,
	Opt_grpquota = 38,
	Opt_prjquota = 39,
	Opt_dax = 40,
	Opt_dax_always = 41,
	Opt_dax_inode = 42,
	Opt_dax_never = 43,
	Opt_stripe = 44,
	Opt_delalloc = 45,
	Opt_nodelalloc = 46,
	Opt_warn_on_error = 47,
	Opt_nowarn_on_error = 48,
	Opt_mblk_io_submit = 49,
	Opt_debug_want_extra_isize = 50,
	Opt_nomblk_io_submit = 51,
	Opt_block_validity = 52,
	Opt_noblock_validity = 53,
	Opt_inode_readahead_blks = 54,
	Opt_journal_ioprio = 55,
	Opt_dioread_nolock = 56,
	Opt_dioread_lock = 57,
	Opt_discard___2 = 58,
	Opt_nodiscard = 59,
	Opt_init_itable = 60,
	Opt_noinit_itable = 61,
	Opt_max_dir_size_kb = 62,
	Opt_nojournal_checksum = 63,
	Opt_nombcache = 64,
	Opt_no_prefetch_block_bitmaps = 65,
	Opt_mb_optimize_scan = 66,
	Opt_errors = 67,
	Opt_data = 68,
	Opt_data_err = 69,
	Opt_jqfmt = 70,
	Opt_dax_type = 71,
};

enum {
	Opt_check = 0,
	Opt_uid = 1,
	Opt_gid = 2,
	Opt_umask = 3,
	Opt_dmask = 4,
	Opt_fmask = 5,
	Opt_allow_utime = 6,
	Opt_codepage = 7,
	Opt_usefree = 8,
	Opt_nocase = 9,
	Opt_quiet = 10,
	Opt_showexec = 11,
	Opt_debug___2 = 12,
	Opt_immutable = 13,
	Opt_dots = 14,
	Opt_dotsOK = 15,
	Opt_charset = 16,
	Opt_shortname = 17,
	Opt_utf8 = 18,
	Opt_utf8_bool = 19,
	Opt_uni_xl = 20,
	Opt_uni_xl_bool = 21,
	Opt_nonumtail = 22,
	Opt_nonumtail_bool = 23,
	Opt_obsolete = 24,
	Opt_flush = 25,
	Opt_tz = 26,
	Opt_rodir = 27,
	Opt_errors___2 = 28,
	Opt_discard___3 = 29,
	Opt_nfs = 30,
	Opt_nfs_enum = 31,
	Opt_time_offset = 32,
	Opt_dos1xfloppy = 33,
};

enum {
	Opt_direct = 0,
	Opt_fd = 1,
	Opt_gid___2 = 2,
	Opt_ignore = 3,
	Opt_indirect = 4,
	Opt_maxproto = 5,
	Opt_minproto = 6,
	Opt_offset = 7,
	Opt_pgrp = 8,
	Opt_strictexpire = 9,
	Opt_uid___2 = 10,
};

enum {
	Opt_discard_sync = 0,
	Opt_discard_async = 1,
};

enum {
	Opt_err___3 = 0,
	Opt_enc = 1,
	Opt_hash = 2,
};

enum {
	Opt_error = -1,
	Opt_fsdefault = 0,
	Opt_fsfloor = 1,
	Opt_fshat = 2,
	Opt_fsroot = 3,
	Opt_fstransmute = 4,
};

enum {
	Opt_fast_unmount = 0,
	Opt_norm_unmount = 1,
	Opt_bulk_read = 2,
	Opt_no_bulk_read = 3,
	Opt_chk_data_crc = 4,
	Opt_no_chk_data_crc = 5,
	Opt_override_compr = 6,
	Opt_assert = 7,
	Opt_auth_key = 8,
	Opt_auth_hash_name = 9,
	Opt_ignore___2 = 10,
};

enum {
	Opt_fatal_errors_panic = 0,
	Opt_fatal_errors_bug = 1,
};

enum {
	Opt_fatal_neterrors_default = 0,
	Opt_fatal_neterrors_enetunreach = 1,
	Opt_fatal_neterrors_none = 2,
};

enum {
	Opt_find_uid = 0,
	Opt_find_gid = 1,
	Opt_find_user = 2,
	Opt_find_group = 3,
	Opt_find_err = 4,
};

enum {
	Opt_gc_background = 0,
	Opt_disable_roll_forward = 1,
	Opt_norecovery___2 = 2,
	Opt_discard___4 = 3,
	Opt_nodiscard___2 = 4,
	Opt_noheap = 5,
	Opt_heap = 6,
	Opt_user_xattr___2 = 7,
	Opt_nouser_xattr = 8,
	Opt_acl___3 = 9,
	Opt_noacl = 10,
	Opt_active_logs = 11,
	Opt_disable_ext_identify = 12,
	Opt_inline_xattr = 13,
	Opt_noinline_xattr = 14,
	Opt_inline_xattr_size = 15,
	Opt_inline_data = 16,
	Opt_inline_dentry = 17,
	Opt_noinline_dentry = 18,
	Opt_flush_merge = 19,
	Opt_noflush_merge = 20,
	Opt_barrier___3 = 21,
	Opt_nobarrier___2 = 22,
	Opt_fastboot = 23,
	Opt_extent_cache = 24,
	Opt_noextent_cache = 25,
	Opt_noinline_data = 26,
	Opt_data_flush = 27,
	Opt_reserve_root = 28,
	Opt_resgid___2 = 29,
	Opt_resuid___2 = 30,
	Opt_mode = 31,
	Opt_fault_injection = 32,
	Opt_fault_type = 33,
	Opt_lazytime = 34,
	Opt_nolazytime = 35,
	Opt_quota___2 = 36,
	Opt_noquota___2 = 37,
	Opt_usrquota___2 = 38,
	Opt_grpquota___2 = 39,
	Opt_prjquota___2 = 40,
	Opt_usrjquota___2 = 41,
	Opt_grpjquota___2 = 42,
	Opt_prjjquota = 43,
	Opt_offusrjquota = 44,
	Opt_offgrpjquota = 45,
	Opt_offprjjquota = 46,
	Opt_jqfmt_vfsold = 47,
	Opt_jqfmt_vfsv0 = 48,
	Opt_jqfmt_vfsv1 = 49,
	Opt_alloc = 50,
	Opt_fsync = 51,
	Opt_test_dummy_encryption___2 = 52,
	Opt_inlinecrypt___2 = 53,
	Opt_checkpoint_disable = 54,
	Opt_checkpoint_disable_cap = 55,
	Opt_checkpoint_disable_cap_perc = 56,
	Opt_checkpoint_enable = 57,
	Opt_checkpoint_merge = 58,
	Opt_nocheckpoint_merge = 59,
	Opt_compress_algorithm = 60,
	Opt_compress_log_size = 61,
	Opt_compress_extension = 62,
	Opt_nocompress_extension = 63,
	Opt_compress_chksum = 64,
	Opt_compress_mode = 65,
	Opt_compress_cache = 66,
	Opt_atgc = 67,
	Opt_gc_merge = 68,
	Opt_nogc_merge = 69,
	Opt_discard_unit = 70,
	Opt_memory_mode = 71,
	Opt_age_extent_cache = 72,
	Opt_errors___3 = 73,
	Opt_nat_bits = 74,
	Opt_err___4 = 75,
};

enum {
	Opt_local_lock_all = 0,
	Opt_local_lock_flock = 1,
	Opt_local_lock_none = 2,
	Opt_local_lock_posix = 3,
};

enum {
	Opt_lookupcache_all = 0,
	Opt_lookupcache_none = 1,
	Opt_lookupcache_positive = 2,
};

enum {
	Opt_rescue_usebackuproot = 0,
	Opt_rescue_nologreplay = 1,
	Opt_rescue_ignorebadroots = 2,
	Opt_rescue_ignoredatacsums = 3,
	Opt_rescue_ignoremetacsums = 4,
	Opt_rescue_ignoresuperflags = 5,
	Opt_rescue_parameter_all = 6,
};

enum {
	Opt_sec_krb5 = 0,
	Opt_sec_krb5i = 1,
	Opt_sec_krb5p = 2,
	Opt_sec_lkey = 3,
	Opt_sec_lkeyi = 4,
	Opt_sec_lkeyp = 5,
	Opt_sec_none = 6,
	Opt_sec_spkm = 7,
	Opt_sec_spkmi = 8,
	Opt_sec_spkmp = 9,
	Opt_sec_sys = 10,
	nr__Opt_sec = 11,
};

enum {
	Opt_space_cache_v1 = 0,
	Opt_space_cache_v2 = 1,
};

enum {
	Opt_uid___3 = 0,
	Opt_gid___3 = 1,
	Opt_mode___2 = 2,
	Opt_source = 3,
};

enum {
	Opt_uid___4 = 0,
	Opt_gid___4 = 1,
	Opt_mode___3 = 2,
	Opt_ptmxmode = 3,
	Opt_newinstance = 4,
	Opt_max = 5,
	Opt_err___5 = 6,
};

enum {
	Opt_vers_2 = 0,
	Opt_vers_3 = 1,
	Opt_vers_4 = 2,
	Opt_vers_4_0 = 3,
	Opt_vers_4_1 = 4,
	Opt_vers_4_2 = 5,
};

enum {
	Opt_write_lazy = 0,
	Opt_write_eager = 1,
	Opt_write_wait = 2,
};

enum {
	Opt_xprt_rdma = 0,
	Opt_xprt_rdma6 = 1,
	Opt_xprt_tcp = 2,
	Opt_xprt_tcp6 = 3,
	Opt_xprt_udp = 4,
	Opt_xprt_udp6 = 5,
	nr__Opt_xprt = 6,
};

enum {
	Opt_xprtsec_none = 0,
	Opt_xprtsec_tls = 1,
	Opt_xprtsec_mtls = 2,
	nr__Opt_xprtsec = 3,
};

enum {
	PAGE_PRIVATE_NOT_POINTER = 0,
	PAGE_PRIVATE_ONGOING_MIGRATION = 1,
	PAGE_PRIVATE_INLINE_INODE = 2,
	PAGE_PRIVATE_REF_RESOURCE = 3,
	PAGE_PRIVATE_ATOMIC_WRITE = 4,
	PAGE_PRIVATE_MAX = 5,
};

enum {
	PAGE_REPORTING_IDLE = 0,
	PAGE_REPORTING_REQUESTED = 1,
	PAGE_REPORTING_ACTIVE = 2,
};

enum {
	PAGE_WAS_MAPPED = 1,
	PAGE_WAS_MLOCKED = 2,
	PAGE_OLD_STATES = 3,
};

enum {
	PALMAS_EXT_CONTROL_ENABLE1 = 1,
	PALMAS_EXT_CONTROL_ENABLE2 = 2,
	PALMAS_EXT_CONTROL_NSLEEP = 4,
};

enum {
	PARSE_INVALID = 1,
	PARSE_NOT_LONGNAME = 2,
	PARSE_EOF = 3,
};

enum {
	PCI_BRIDGE_EMUL_NO_PREFMEM_FORWARD = 1,
	PCI_BRIDGE_EMUL_NO_IO_FORWARD = 2,
};

enum {
	PCI_REASSIGN_ALL_RSRC = 1,
	PCI_REASSIGN_ALL_BUS = 2,
	PCI_PROBE_ONLY = 4,
	PCI_CAN_SKIP_ISA_ALIGN = 8,
	PCI_ENABLE_PROC_DOMAINS = 16,
	PCI_COMPAT_DOMAIN_0 = 32,
	PCI_SCAN_ALL_PCIE_DEVS = 64,
};

enum {
	PCI_STD_RESOURCES = 0,
	PCI_STD_RESOURCE_END = 5,
	PCI_ROM_RESOURCE = 6,
	PCI_BRIDGE_RESOURCES = 7,
	PCI_BRIDGE_RESOURCE_END = 10,
	PCI_NUM_RESOURCES = 11,
	DEVICE_COUNT_RESOURCE = 11,
};

enum {
	PERCPU_REF_INIT_ATOMIC = 1,
	PERCPU_REF_INIT_DEAD = 2,
	PERCPU_REF_ALLOW_REINIT = 4,
};

enum {
	PERF_FC_LEVEL = 0,
	PERF_FC_LIMIT = 1,
	PERF_FC_MAX = 2,
};

enum {
	PER_LINUX = 0,
	PER_LINUX_32BIT = 8388608,
	PER_LINUX_FDPIC = 524288,
	PER_SVR4 = 68157441,
	PER_SVR3 = 83886082,
	PER_SCOSVR3 = 117440515,
	PER_OSR5 = 100663299,
	PER_WYSEV386 = 83886084,
	PER_ISCR4 = 67108869,
	PER_BSD = 6,
	PER_SUNOS = 67108870,
	PER_XENIX = 83886087,
	PER_LINUX32 = 8,
	PER_LINUX32_3GB = 134217736,
	PER_IRIX32 = 67108873,
	PER_IRIXN32 = 67108874,
	PER_IRIX64 = 67108875,
	PER_RISCOS = 12,
	PER_SOLARIS = 67108877,
	PER_UW7 = 68157454,
	PER_OSF4 = 15,
	PER_HPUX = 16,
	PER_MASK = 255,
};

enum {
	PG_BUSY = 0,
	PG_MAPPED = 1,
	PG_FOLIO = 2,
	PG_CLEAN = 3,
	PG_COMMIT_TO_DS = 4,
	PG_INODE_REF = 5,
	PG_HEADLOCK = 6,
	PG_TEARDOWN = 7,
	PG_UNLOCKPAGE = 8,
	PG_UPTODATE = 9,
	PG_WB_END = 10,
	PG_REMOVE = 11,
	PG_CONTENDED1 = 12,
	PG_CONTENDED2 = 13,
};

enum {
	PHY_GMII_SEL_PORT_MODE = 0,
	PHY_GMII_SEL_RGMII_ID_MODE = 1,
	PHY_GMII_SEL_RMII_IO_CLK_EN = 2,
	PHY_GMII_SEL_LAST = 3,
};

enum {
	PIM_TYPE_HELLO = 0,
	PIM_TYPE_REGISTER = 1,
	PIM_TYPE_REGISTER_STOP = 2,
	PIM_TYPE_JOIN_PRUNE = 3,
	PIM_TYPE_BOOTSTRAP = 4,
	PIM_TYPE_ASSERT = 5,
	PIM_TYPE_GRAFT = 6,
	PIM_TYPE_GRAFT_ACK = 7,
	PIM_TYPE_CANDIDATE_RP_ADV = 8,
};

enum {
	PL08X_AHB1 = 1,
	PL08X_AHB2 = 2,
};

enum {
	PLAT8250_DEV_LEGACY = -1,
	PLAT8250_DEV_PLATFORM = 0,
	PLAT8250_DEV_PLATFORM1 = 1,
	PLAT8250_DEV_PLATFORM2 = 2,
	PLAT8250_DEV_FOURPORT = 3,
	PLAT8250_DEV_ACCENT = 4,
	PLAT8250_DEV_BOCA = 5,
	PLAT8250_DEV_EXAR_ST16C554 = 6,
	PLAT8250_DEV_HUB6 = 7,
	PLAT8250_DEV_AU1X00 = 8,
	PLAT8250_DEV_SM501 = 9,
};

enum {
	POOL_BITS = 256,
	POOL_READY_BITS = 256,
	POOL_EARLY_BITS = 128,
};

enum {
	POWERCAP_FC_CAP = 0,
	POWERCAP_FC_PAI = 1,
	POWERCAP_FC_MAX = 2,
};

enum {
	POWER_SUPPLY_CAPACITY_LEVEL_UNKNOWN = 0,
	POWER_SUPPLY_CAPACITY_LEVEL_CRITICAL = 1,
	POWER_SUPPLY_CAPACITY_LEVEL_LOW = 2,
	POWER_SUPPLY_CAPACITY_LEVEL_NORMAL = 3,
	POWER_SUPPLY_CAPACITY_LEVEL_HIGH = 4,
	POWER_SUPPLY_CAPACITY_LEVEL_FULL = 5,
};

enum {
	POWER_SUPPLY_HEALTH_UNKNOWN = 0,
	POWER_SUPPLY_HEALTH_GOOD = 1,
	POWER_SUPPLY_HEALTH_OVERHEAT = 2,
	POWER_SUPPLY_HEALTH_DEAD = 3,
	POWER_SUPPLY_HEALTH_OVERVOLTAGE = 4,
	POWER_SUPPLY_HEALTH_UNDERVOLTAGE = 5,
	POWER_SUPPLY_HEALTH_UNSPEC_FAILURE = 6,
	POWER_SUPPLY_HEALTH_COLD = 7,
	POWER_SUPPLY_HEALTH_WATCHDOG_TIMER_EXPIRE = 8,
	POWER_SUPPLY_HEALTH_SAFETY_TIMER_EXPIRE = 9,
	POWER_SUPPLY_HEALTH_OVERCURRENT = 10,
	POWER_SUPPLY_HEALTH_CALIBRATION_REQUIRED = 11,
	POWER_SUPPLY_HEALTH_WARM = 12,
	POWER_SUPPLY_HEALTH_COOL = 13,
	POWER_SUPPLY_HEALTH_HOT = 14,
	POWER_SUPPLY_HEALTH_NO_BATTERY = 15,
	POWER_SUPPLY_HEALTH_BLOWN_FUSE = 16,
	POWER_SUPPLY_HEALTH_CELL_IMBALANCE = 17,
};

enum {
	POWER_SUPPLY_SCOPE_UNKNOWN = 0,
	POWER_SUPPLY_SCOPE_SYSTEM = 1,
	POWER_SUPPLY_SCOPE_DEVICE = 2,
};

enum {
	POWER_SUPPLY_STATUS_UNKNOWN = 0,
	POWER_SUPPLY_STATUS_CHARGING = 1,
	POWER_SUPPLY_STATUS_DISCHARGING = 2,
	POWER_SUPPLY_STATUS_NOT_CHARGING = 3,
	POWER_SUPPLY_STATUS_FULL = 4,
};

enum {
	POWER_SUPPLY_TECHNOLOGY_UNKNOWN = 0,
	POWER_SUPPLY_TECHNOLOGY_NiMH = 1,
	POWER_SUPPLY_TECHNOLOGY_LION = 2,
	POWER_SUPPLY_TECHNOLOGY_LIPO = 3,
	POWER_SUPPLY_TECHNOLOGY_LiFe = 4,
	POWER_SUPPLY_TECHNOLOGY_NiCd = 5,
	POWER_SUPPLY_TECHNOLOGY_LiMn = 6,
};

enum {
	PREFIX_UNSPEC = 0,
	PREFIX_ADDRESS = 1,
	PREFIX_CACHEINFO = 2,
	__PREFIX_MAX = 3,
};

enum {
	PROCESS_SPIN_LOCK = 1,
	PROCESS_RES_LOCK = 2,
	PROCESS_LOCK_IRQ = 4,
};

enum {
	PROC_ENTRY_PERMANENT = 1,
	PROC_ENTRY_proc_read_iter = 2,
	PROC_ENTRY_proc_compat_ioctl = 4,
	PROC_ENTRY_proc_lseek = 8,
};

enum {
	PROC_ROOT_INO = 1,
	PROC_IPC_INIT_INO = 4026531839,
	PROC_UTS_INIT_INO = 4026531838,
	PROC_USER_INIT_INO = 4026531837,
	PROC_PID_INIT_INO = 4026531836,
	PROC_CGROUP_INIT_INO = 4026531835,
	PROC_TIME_INIT_INO = 4026531834,
};

enum {
	PWMF_REQUESTED = 0,
	PWMF_EXPORTED = 1,
};

enum {
	PWRDM_STATE_NOW = 0,
	PWRDM_STATE_PREV = 1,
};

enum {
	QIF_BLIMITS_B = 0,
	QIF_SPACE_B = 1,
	QIF_ILIMITS_B = 2,
	QIF_INODES_B = 3,
	QIF_BTIME_B = 4,
	QIF_ITIME_B = 5,
};

enum {
	QMFLAGS_IS_BLOCKING = 1,
	QMFLAGS_NO_MUTEX_LOCK = 2,
	QMFLAGS_NO_MUTEX_UNLOCK = 4,
};

enum {
	QOS_ENABLE = 0,
	QOS_CTRL = 1,
	NR_QOS_CTRL_PARAMS = 2,
};

enum {
	QOS_RPPM = 0,
	QOS_RLAT = 1,
	QOS_WPPM = 2,
	QOS_WLAT = 3,
	QOS_MIN = 4,
	QOS_MAX = 5,
	NR_QOS_PARAMS = 6,
};

enum {
	QUEUE_FLAG_DYING = 0,
	QUEUE_FLAG_NOMERGES = 1,
	QUEUE_FLAG_SAME_COMP = 2,
	QUEUE_FLAG_FAIL_IO = 3,
	QUEUE_FLAG_NOXMERGES = 4,
	QUEUE_FLAG_SAME_FORCE = 5,
	QUEUE_FLAG_INIT_DONE = 6,
	QUEUE_FLAG_STATS = 7,
	QUEUE_FLAG_REGISTERED = 8,
	QUEUE_FLAG_QUIESCED = 9,
	QUEUE_FLAG_RQ_ALLOC_TIME = 10,
	QUEUE_FLAG_HCTX_ACTIVE = 11,
	QUEUE_FLAG_SQ_SCHED = 12,
	QUEUE_FLAG_DISABLE_WBT_DEF = 13,
	QUEUE_FLAG_NO_ELV_SWITCH = 14,
	QUEUE_FLAG_QOS_ENABLED = 15,
	QUEUE_FLAG_MAX = 16,
};

enum {
	QUOTA_NL_A_UNSPEC = 0,
	QUOTA_NL_A_QTYPE = 1,
	QUOTA_NL_A_EXCESS_ID = 2,
	QUOTA_NL_A_WARNING = 3,
	QUOTA_NL_A_DEV_MAJOR = 4,
	QUOTA_NL_A_DEV_MINOR = 5,
	QUOTA_NL_A_CAUSED_ID = 6,
	QUOTA_NL_A_PAD = 7,
	__QUOTA_NL_A_MAX = 8,
};

enum {
	QUOTA_NL_C_UNSPEC = 0,
	QUOTA_NL_C_WARNING = 1,
	__QUOTA_NL_C_MAX = 2,
};

enum {
	Q_REQUEUE_PI_NONE = 0,
	Q_REQUEUE_PI_IGNORE = 1,
	Q_REQUEUE_PI_IN_PROGRESS = 2,
	Q_REQUEUE_PI_WAIT = 3,
	Q_REQUEUE_PI_DONE = 4,
	Q_REQUEUE_PI_LOCKED = 5,
};

enum {
	RADIX_TREE_ITER_TAG_MASK = 15,
	RADIX_TREE_ITER_TAGGED = 16,
	RADIX_TREE_ITER_CONTIG = 32,
};

enum {
	RANGE_BOUNDARY_WRITTEN_EXTENT = 0,
	RANGE_BOUNDARY_PREALLOC_EXTENT = 1,
	RANGE_BOUNDARY_HOLE = 2,
};

enum {
	RC_TMF_COMPLETE = 0,
	RC_INVALID_INFO_UNIT = 2,
	RC_TMF_NOT_SUPPORTED = 4,
	RC_TMF_FAILED = 5,
	RC_TMF_SUCCEEDED = 8,
	RC_INCORRECT_LUN = 9,
	RC_OVERLAPPED_TAG = 10,
};

enum {
	READA_NONE = 0,
	READA_BACK = 1,
	READA_FORWARD = 2,
	READA_FORWARD_ALWAYS = 3,
};

enum {
	REASON_BOUNDS = -1,
	REASON_TYPE = -2,
	REASON_PATHS = -3,
	REASON_LIMIT = -4,
	REASON_STACK = -5,
};

enum {
	REGION_INTERSECTS = 0,
	REGION_DISJOINT = 1,
	REGION_MIXED = 2,
};

enum {
	REGULATOR_ERROR_CLEARED = 0,
	REGULATOR_FAILED_RETRY = 1,
	REGULATOR_ERROR_ON = 2,
};

enum {
	REG_CON_MOD_TX = 0,
	REG_CON_MOD_REGISTER_TX = 1,
	REG_CON_MOD_RX = 2,
	REG_CON_MOD_REGISTER_RX = 3,
};

enum {
	REG_CSR = 0,
	CSR_BUSY = 128,
	CSR_INT = 64,
	CSR_ERR = 32,
	REG_CER = 1,
	REG_CVR = 2,
	REG_CCR = 3,
	CCR_RESET = 128,
	CCR_ON = 64,
	REG_ACKH = 4,
	REG_ACKL = 5,
	REG_CCONR = 6,
	CCONR_ENABLE_ERROR = 16,
	CCONR_RETRY_MASK = 7,
	REG_CDR0 = 7,
	CDR1_REQ = 0,
	CDR1_CNF = 1,
	CDR1_IND = 129,
	CDR1_ERR = 130,
	CDR1_IER = 131,
	CDR2_CNF_SUCCESS = 0,
	CDR2_CNF_OFF_STATE = 128,
	CDR2_CNF_BAD_REQ = 129,
	CDR2_CNF_CEC_ACCESS = 130,
	CDR2_CNF_ARB_ERROR = 131,
	CDR2_CNF_BAD_TIMING = 132,
	CDR2_CNF_NACK_ADDR = 133,
	CDR2_CNF_NACK_DATA = 134,
};

enum {
	REG_DR = 0,
	REG_ST_DMAWM = 1,
	REG_ST_TIMEOUT = 2,
	REG_FR = 3,
	REG_LCRH_RX = 4,
	REG_LCRH_TX = 5,
	REG_IBRD = 6,
	REG_FBRD = 7,
	REG_CR = 8,
	REG_IFLS = 9,
	REG_IMSC = 10,
	REG_RIS = 11,
	REG_MIS = 12,
	REG_ICR = 13,
	REG_DMACR = 14,
	REG_ST_XFCR = 15,
	REG_ST_XON1 = 16,
	REG_ST_XON2 = 17,
	REG_ST_XOFF1 = 18,
	REG_ST_XOFF2 = 19,
	REG_ST_ITCR = 20,
	REG_ST_ITIP = 21,
	REG_ST_ABCR = 22,
	REG_ST_ABIMSC = 23,
	REG_ARRAY_SIZE = 24,
};

enum {
	REG_SECONDS_REG = 0,
	REG_MINUTES_REG = 1,
	REG_HOURS_REG = 2,
	REG_DAYS_REG = 3,
	REG_MONTHS_REG = 4,
	REG_YEARS_REG = 5,
	REG_WEEKS_REG = 6,
	REG_ALARM_SECONDS_REG = 7,
	REG_ALARM_MINUTES_REG = 8,
	REG_ALARM_HOURS_REG = 9,
	REG_ALARM_DAYS_REG = 10,
	REG_ALARM_MONTHS_REG = 11,
	REG_ALARM_YEARS_REG = 12,
	REG_RTC_CTRL_REG = 13,
	REG_RTC_STATUS_REG = 14,
	REG_RTC_INTERRUPTS_REG = 15,
	REG_RTC_COMP_LSB_REG = 16,
	REG_RTC_COMP_MSB_REG = 17,
};

enum {
	REQUEST_ANY = 0,
	REQUEST_BY_ID = 1,
	REQUEST_BY_CAP = 2,
	REQUEST_BY_NODE = 3,
};

enum {
	REQ_FSEQ_PREFLUSH = 1,
	REQ_FSEQ_DATA = 2,
	REQ_FSEQ_POSTFLUSH = 4,
	REQ_FSEQ_DONE = 8,
	REQ_FSEQ_ACTIONS = 7,
	FLUSH_PENDING_TIMEOUT = 1250,
};

enum {
	REQ_F_FIXED_FILE = 1ULL,
	REQ_F_IO_DRAIN = 2ULL,
	REQ_F_LINK = 4ULL,
	REQ_F_HARDLINK = 8ULL,
	REQ_F_FORCE_ASYNC = 16ULL,
	REQ_F_BUFFER_SELECT = 32ULL,
	REQ_F_CQE_SKIP = 64ULL,
	REQ_F_FAIL = 256ULL,
	REQ_F_INFLIGHT = 512ULL,
	REQ_F_CUR_POS = 1024ULL,
	REQ_F_NOWAIT = 2048ULL,
	REQ_F_LINK_TIMEOUT = 4096ULL,
	REQ_F_NEED_CLEANUP = 8192ULL,
	REQ_F_POLLED = 16384ULL,
	REQ_F_IOPOLL_STATE = 32768ULL,
	REQ_F_BUFFER_SELECTED = 65536ULL,
	REQ_F_BUFFER_RING = 131072ULL,
	REQ_F_REISSUE = 262144ULL,
	REQ_F_SUPPORT_NOWAIT = 536870912ULL,
	REQ_F_ISREG = 1073741824ULL,
	REQ_F_CREDS = 524288ULL,
	REQ_F_REFCOUNT = 1048576ULL,
	REQ_F_ARM_LTIMEOUT = 2097152ULL,
	REQ_F_ASYNC_DATA = 4194304ULL,
	REQ_F_SKIP_LINK_CQES = 8388608ULL,
	REQ_F_SINGLE_POLL = 16777216ULL,
	REQ_F_DOUBLE_POLL = 33554432ULL,
	REQ_F_MULTISHOT = 67108864ULL,
	REQ_F_APOLL_MULTISHOT = 134217728ULL,
	REQ_F_CLEAR_POLLIN = 268435456ULL,
	REQ_F_POLL_NO_LAZY = 2147483648ULL,
	REQ_F_CAN_POLL = 4294967296ULL,
	REQ_F_BL_EMPTY = 8589934592ULL,
	REQ_F_BL_NO_RECYCLE = 17179869184ULL,
	REQ_F_BUFFERS_COMMIT = 34359738368ULL,
	REQ_F_BUF_NODE = 68719476736ULL,
	REQ_F_HAS_METADATA = 137438953472ULL,
	REQ_F_IMPORT_BUFFER = 274877906944ULL,
};

enum {
	REQ_F_FIXED_FILE_BIT = 0,
	REQ_F_IO_DRAIN_BIT = 1,
	REQ_F_LINK_BIT = 2,
	REQ_F_HARDLINK_BIT = 3,
	REQ_F_FORCE_ASYNC_BIT = 4,
	REQ_F_BUFFER_SELECT_BIT = 5,
	REQ_F_CQE_SKIP_BIT = 6,
	REQ_F_FAIL_BIT = 8,
	REQ_F_INFLIGHT_BIT = 9,
	REQ_F_CUR_POS_BIT = 10,
	REQ_F_NOWAIT_BIT = 11,
	REQ_F_LINK_TIMEOUT_BIT = 12,
	REQ_F_NEED_CLEANUP_BIT = 13,
	REQ_F_POLLED_BIT = 14,
	REQ_F_HYBRID_IOPOLL_STATE_BIT = 15,
	REQ_F_BUFFER_SELECTED_BIT = 16,
	REQ_F_BUFFER_RING_BIT = 17,
	REQ_F_REISSUE_BIT = 18,
	REQ_F_CREDS_BIT = 19,
	REQ_F_REFCOUNT_BIT = 20,
	REQ_F_ARM_LTIMEOUT_BIT = 21,
	REQ_F_ASYNC_DATA_BIT = 22,
	REQ_F_SKIP_LINK_CQES_BIT = 23,
	REQ_F_SINGLE_POLL_BIT = 24,
	REQ_F_DOUBLE_POLL_BIT = 25,
	REQ_F_MULTISHOT_BIT = 26,
	REQ_F_APOLL_MULTISHOT_BIT = 27,
	REQ_F_CLEAR_POLLIN_BIT = 28,
	REQ_F_SUPPORT_NOWAIT_BIT = 29,
	REQ_F_ISREG_BIT = 30,
	REQ_F_POLL_NO_LAZY_BIT = 31,
	REQ_F_CAN_POLL_BIT = 32,
	REQ_F_BL_EMPTY_BIT = 33,
	REQ_F_BL_NO_RECYCLE_BIT = 34,
	REQ_F_BUFFERS_COMMIT_BIT = 35,
	REQ_F_BUF_NODE_BIT = 36,
	REQ_F_HAS_METADATA_BIT = 37,
	REQ_F_IMPORT_BUFFER_BIT = 38,
	__REQ_F_LAST_BIT = 39,
};

enum {
	RK805_BUCK1_2_ILMAX_2500MA = 0,
	RK805_BUCK1_2_ILMAX_3000MA = 1,
	RK805_BUCK1_2_ILMAX_3500MA = 2,
	RK805_BUCK1_2_ILMAX_4000MA = 3,
};

enum {
	RK805_BUCK3_ILMAX_1500MA = 0,
	RK805_BUCK3_ILMAX_2000MA = 1,
	RK805_BUCK3_ILMAX_2500MA = 2,
	RK805_BUCK3_ILMAX_3000MA = 3,
};

enum {
	RK805_BUCK4_ILMAX_2000MA = 0,
	RK805_BUCK4_ILMAX_2500MA = 1,
	RK805_BUCK4_ILMAX_3000MA = 2,
	RK805_BUCK4_ILMAX_3500MA = 3,
};

enum {
	RK805_GPIO0 = 0,
	RK805_GPIO1 = 1,
};

enum {
	RK805_ID = 32848,
	RK806_ID = 32864,
	RK808_ID = 0,
	RK809_ID = 32912,
	RK816_ID = 33120,
	RK817_ID = 33136,
	RK818_ID = 33152,
};

enum {
	RK806_GPIO_DVS1 = 0,
	RK806_GPIO_DVS2 = 1,
	RK806_GPIO_DVS3 = 2,
};

enum {
	RK816_GPIO0 = 0,
};

enum {
	RK8600_CHIP_ID_08 = 8,
};

enum {
	RK8602_CHIP_ID_10 = 10,
};

enum {
	RN5T567 = 0,
	RN5T618 = 1,
	RC5T619 = 2,
};

enum {
	RN5T618_DCDC1 = 0,
	RN5T618_DCDC2 = 1,
	RN5T618_DCDC3 = 2,
	RN5T618_DCDC4 = 3,
	RN5T618_DCDC5 = 4,
	RN5T618_LDO1 = 5,
	RN5T618_LDO2 = 6,
	RN5T618_LDO3 = 7,
	RN5T618_LDO4 = 8,
	RN5T618_LDO5 = 9,
	RN5T618_LDO6 = 10,
	RN5T618_LDO7 = 11,
	RN5T618_LDO8 = 12,
	RN5T618_LDO9 = 13,
	RN5T618_LDO10 = 14,
	RN5T618_LDORTC1 = 15,
	RN5T618_LDORTC2 = 16,
	RN5T618_REG_NUM = 17,
};

enum {
	RN5T618_IRQ_SYS = 0,
	RN5T618_IRQ_DCDC = 1,
	RN5T618_IRQ_RTC = 2,
	RN5T618_IRQ_ADC = 3,
	RN5T618_IRQ_GPIO = 4,
	RN5T618_IRQ_CHG = 5,
	RN5T618_NR_IRQS = 6,
};

enum {
	ROCKCHIP_ARM_OFF_LOGIC_NORMAL = 0,
	ROCKCHIP_ARM_OFF_LOGIC_DEEP = 1,
};

enum {
	ROCKCHIP_DDRTYPE_DDR3 = 3,
	ROCKCHIP_DDRTYPE_LPDDR2 = 5,
	ROCKCHIP_DDRTYPE_LPDDR3 = 6,
	ROCKCHIP_DDRTYPE_LPDDR4 = 7,
	ROCKCHIP_DDRTYPE_LPDDR4X = 8,
};

enum {
	RPCAUTH_info = 0,
	RPCAUTH_EOF = 1,
};

enum {
	RPCAUTH_lockd = 0,
	RPCAUTH_mount = 1,
	RPCAUTH_nfs = 2,
	RPCAUTH_portmap = 3,
	RPCAUTH_statd = 4,
	RPCAUTH_nfsd4_cb = 5,
	RPCAUTH_cache = 6,
	RPCAUTH_nfsd = 7,
	RPCAUTH_gssd = 8,
	RPCAUTH_RootEOF = 9,
};

enum {
	RPCBPROC_NULL = 0,
	RPCBPROC_SET = 1,
	RPCBPROC_UNSET = 2,
	RPCBPROC_GETPORT = 3,
	RPCBPROC_GETADDR = 3,
	RPCBPROC_DUMP = 4,
	RPCBPROC_CALLIT = 5,
	RPCBPROC_BCAST = 5,
	RPCBPROC_GETTIME = 6,
	RPCBPROC_UADDR2TADDR = 7,
	RPCBPROC_TADDR2UADDR = 8,
	RPCBPROC_GETVERSADDR = 9,
	RPCBPROC_INDIRECT = 10,
	RPCBPROC_GETADDRLIST = 11,
	RPCBPROC_GETSTAT = 12,
};

enum {
	RPCSVC_MAXPAYLOAD = 4194304,
	RPCSVC_MAXPAYLOAD_TCP = 4194304,
	RPCSVC_MAXPAYLOAD_UDP = 32768,
};

enum {
	RPC_PIPEFS_MOUNT = 0,
	RPC_PIPEFS_UMOUNT = 1,
};

enum {
	RPC_TASK_RUNNING = 0,
	RPC_TASK_QUEUED = 1,
	RPC_TASK_ACTIVE = 2,
	RPC_TASK_NEED_XMIT = 3,
	RPC_TASK_NEED_RECV = 4,
	RPC_TASK_MSG_PIN_WAIT = 5,
};

enum {
	RQ_SECURE = 0,
	RQ_LOCAL = 1,
	RQ_USEDEFERRAL = 2,
	RQ_DROPME = 3,
	RQ_VICTIM = 4,
	RQ_DATA = 5,
};

enum {
	RQ_WAIT_BUSY_PCT = 5,
	UNBUSY_THR_PCT = 75,
	MIN_DELAY_THR_PCT = 500,
	MAX_DELAY_THR_PCT = 25000,
	MIN_DELAY = 250,
	MAX_DELAY = 250000,
	DFGV_USAGE_PCT = 50,
	DFGV_PERIOD = 100000,
	MAX_LAGGING_PERIODS = 10,
	IOC_PAGE_SHIFT = 12,
	IOC_PAGE_SIZE = 4096,
	IOC_SECT_TO_PAGE_SHIFT = 3,
	LCOEF_RANDIO_PAGES = 4096,
};

enum {
	RTAX_UNSPEC = 0,
	RTAX_LOCK = 1,
	RTAX_MTU = 2,
	RTAX_WINDOW = 3,
	RTAX_RTT = 4,
	RTAX_RTTVAR = 5,
	RTAX_SSTHRESH = 6,
	RTAX_CWND = 7,
	RTAX_ADVMSS = 8,
	RTAX_REORDERING = 9,
	RTAX_HOPLIMIT = 10,
	RTAX_INITCWND = 11,
	RTAX_FEATURES = 12,
	RTAX_RTO_MIN = 13,
	RTAX_INITRWND = 14,
	RTAX_QUICKACK = 15,
	RTAX_CC_ALGO = 16,
	RTAX_FASTOPEN_NO_COOKIE = 17,
	__RTAX_MAX = 18,
};

enum {
	RTC_SEC = 0,
	RTC_MIN = 1,
	RTC_HOUR = 2,
	RTC_WEEKDAY = 3,
	RTC_MONTH = 4,
	RTC_YEAR = 5,
	RTC_MONTHDAY = 6,
	RTC_NR_TIME = 7,
};

enum {
	RTM_BASE = 16,
	RTM_NEWLINK = 16,
	RTM_DELLINK = 17,
	RTM_GETLINK = 18,
	RTM_SETLINK = 19,
	RTM_NEWADDR = 20,
	RTM_DELADDR = 21,
	RTM_GETADDR = 22,
	RTM_NEWROUTE = 24,
	RTM_DELROUTE = 25,
	RTM_GETROUTE = 26,
	RTM_NEWNEIGH = 28,
	RTM_DELNEIGH = 29,
	RTM_GETNEIGH = 30,
	RTM_NEWRULE = 32,
	RTM_DELRULE = 33,
	RTM_GETRULE = 34,
	RTM_NEWQDISC = 36,
	RTM_DELQDISC = 37,
	RTM_GETQDISC = 38,
	RTM_NEWTCLASS = 40,
	RTM_DELTCLASS = 41,
	RTM_GETTCLASS = 42,
	RTM_NEWTFILTER = 44,
	RTM_DELTFILTER = 45,
	RTM_GETTFILTER = 46,
	RTM_NEWACTION = 48,
	RTM_DELACTION = 49,
	RTM_GETACTION = 50,
	RTM_NEWPREFIX = 52,
	RTM_NEWMULTICAST = 56,
	RTM_DELMULTICAST = 57,
	RTM_GETMULTICAST = 58,
	RTM_NEWANYCAST = 60,
	RTM_DELANYCAST = 61,
	RTM_GETANYCAST = 62,
	RTM_NEWNEIGHTBL = 64,
	RTM_GETNEIGHTBL = 66,
	RTM_SETNEIGHTBL = 67,
	RTM_NEWNDUSEROPT = 68,
	RTM_NEWADDRLABEL = 72,
	RTM_DELADDRLABEL = 73,
	RTM_GETADDRLABEL = 74,
	RTM_GETDCB = 78,
	RTM_SETDCB = 79,
	RTM_NEWNETCONF = 80,
	RTM_DELNETCONF = 81,
	RTM_GETNETCONF = 82,
	RTM_NEWMDB = 84,
	RTM_DELMDB = 85,
	RTM_GETMDB = 86,
	RTM_NEWNSID = 88,
	RTM_DELNSID = 89,
	RTM_GETNSID = 90,
	RTM_NEWSTATS = 92,
	RTM_GETSTATS = 94,
	RTM_SETSTATS = 95,
	RTM_NEWCACHEREPORT = 96,
	RTM_NEWCHAIN = 100,
	RTM_DELCHAIN = 101,
	RTM_GETCHAIN = 102,
	RTM_NEWNEXTHOP = 104,
	RTM_DELNEXTHOP = 105,
	RTM_GETNEXTHOP = 106,
	RTM_NEWLINKPROP = 108,
	RTM_DELLINKPROP = 109,
	RTM_GETLINKPROP = 110,
	RTM_NEWVLAN = 112,
	RTM_DELVLAN = 113,
	RTM_GETVLAN = 114,
	RTM_NEWNEXTHOPBUCKET = 116,
	RTM_DELNEXTHOPBUCKET = 117,
	RTM_GETNEXTHOPBUCKET = 118,
	RTM_NEWTUNNEL = 120,
	RTM_DELTUNNEL = 121,
	RTM_GETTUNNEL = 122,
	__RTM_MAX = 123,
};

enum {
	RTN_UNSPEC = 0,
	RTN_UNICAST = 1,
	RTN_LOCAL = 2,
	RTN_BROADCAST = 3,
	RTN_ANYCAST = 4,
	RTN_MULTICAST = 5,
	RTN_BLACKHOLE = 6,
	RTN_UNREACHABLE = 7,
	RTN_PROHIBIT = 8,
	RTN_THROW = 9,
	RTN_NAT = 10,
	RTN_XRESOLVE = 11,
	__RTN_MAX = 12,
};

enum {
	RWB_DEF_DEPTH = 16,
	RWB_WINDOW_NSEC = 100000000,
	RWB_MIN_WRITE_SAMPLES = 3,
	RWB_UNKNOWN_BUMP = 5,
};

enum {
	RX_XDP_REDIRECT = 0,
	RX_XDP_PASS = 1,
	RX_XDP_DROP = 2,
	RX_XDP_TX = 3,
	RX_XDP_TX_ERRORS = 4,
	TX_XDP_XMIT = 5,
	TX_XDP_XMIT_ERRORS = 6,
	XDP_STATS_TOTAL = 7,
};

enum {
	Root_NFS = 255,
	Root_CIFS = 254,
	Root_Generic = 253,
	Root_RAM0 = 1048576,
};

enum {
	SATA_PHY_CR_CLOCK_CRCMP_LT_LIMIT = 1,
	SATA_PHY_CR_CLOCK_DAC_CTL = 8,
	SATA_PHY_CR_CLOCK_RTUNE_CTL = 9,
	SATA_PHY_CR_CLOCK_ADC_OUT = 10,
	SATA_PHY_CR_CLOCK_MPLL_TST = 23,
};

enum {
	SBI_IS_DIRTY = 0,
	SBI_IS_CLOSE = 1,
	SBI_NEED_FSCK = 2,
	SBI_POR_DOING = 3,
	SBI_NEED_SB_WRITE = 4,
	SBI_NEED_CP = 5,
	SBI_IS_SHUTDOWN = 6,
	SBI_IS_RECOVERED = 7,
	SBI_CP_DISABLED = 8,
	SBI_CP_DISABLED_QUICK = 9,
	SBI_QUOTA_NEED_FLUSH = 10,
	SBI_QUOTA_SKIP_FLUSH = 11,
	SBI_QUOTA_NEED_REPAIR = 12,
	SBI_IS_RESIZEFS = 13,
	SBI_IS_FREEZING = 14,
	SBI_IS_WRITABLE = 15,
	MAX_SBI_FLAG = 16,
};

enum {
	SB_UNFROZEN = 0,
	SB_FREEZE_WRITE = 1,
	SB_FREEZE_PAGEFAULT = 2,
	SB_FREEZE_FS = 3,
	SB_FREEZE_COMPLETE = 4,
};

enum {
	SCANNED_GARBAGE = 0,
	SCANNED_EMPTY_SPACE = -1,
	SCANNED_A_NODE = -2,
	SCANNED_A_CORRUPT_NODE = -3,
	SCANNED_A_BAD_PAD_NODE = -4,
};

enum {
	SCMI_RAW_REPLY_QUEUE = 0,
	SCMI_RAW_NOTIF_QUEUE = 1,
	SCMI_RAW_ERRS_QUEUE = 2,
	SCMI_RAW_MAX_QUEUE = 3,
};

enum {
	SCM_TSTAMP_SND = 0,
	SCM_TSTAMP_SCHED = 1,
	SCM_TSTAMP_ACK = 2,
	SCM_TSTAMP_COMPLETION = 3,
};

enum {
	SCSI_DH_OK = 0,
	SCSI_DH_DEV_FAILED = 1,
	SCSI_DH_DEV_TEMP_BUSY = 2,
	SCSI_DH_DEV_UNSUPP = 3,
	SCSI_DH_DEVICE_MAX = 4,
	SCSI_DH_NOTCONN = 5,
	SCSI_DH_CONN_FAILURE = 6,
	SCSI_DH_TRANSPORT_MAX = 7,
	SCSI_DH_IO = 8,
	SCSI_DH_INVALID_IO = 9,
	SCSI_DH_RETRY = 10,
	SCSI_DH_IMM_RETRY = 11,
	SCSI_DH_TIMED_OUT = 12,
	SCSI_DH_RES_TEMP_UNAVAIL = 13,
	SCSI_DH_DEV_OFFLINED = 14,
	SCSI_DH_NOMEM = 15,
	SCSI_DH_NOSYS = 16,
	SCSI_DH_DRIVER_MAX = 17,
};

enum {
	SD_BALANCE_NEWIDLE = 1,
	SD_BALANCE_EXEC = 2,
	SD_BALANCE_FORK = 4,
	SD_BALANCE_WAKE = 8,
	SD_WAKE_AFFINE = 16,
	SD_ASYM_CPUCAPACITY = 32,
	SD_ASYM_CPUCAPACITY_FULL = 64,
	SD_SHARE_CPUCAPACITY = 128,
	SD_CLUSTER = 256,
	SD_SHARE_LLC = 512,
	SD_SERIALIZE = 1024,
	SD_ASYM_PACKING = 2048,
	SD_PREFER_SIBLING = 4096,
	SD_OVERLAP = 8192,
	SD_NUMA = 16384,
};

enum {
	SD_DEF_XFER_BLOCKS = 65535,
	SD_MAX_XFER_BLOCKS = 4294967295,
	SD_MAX_WS10_BLOCKS = 65535,
	SD_MAX_WS16_BLOCKS = 8388607,
};

enum {
	SD_EXT_CDB_SIZE = 32,
	SD_MEMPOOL_SIZE = 2,
};

enum {
	SD_LBP_FULL = 0,
	SD_LBP_UNMAP = 1,
	SD_LBP_WS16 = 2,
	SD_LBP_WS10 = 3,
	SD_LBP_ZERO = 4,
	SD_LBP_DISABLE = 5,
};

enum {
	SD_ZERO_WRITE = 0,
	SD_ZERO_WS = 1,
	SD_ZERO_WS16_UNMAP = 2,
	SD_ZERO_WS10_UNMAP = 3,
};

enum {
	SEG6_ATTR_UNSPEC = 0,
	SEG6_ATTR_DST = 1,
	SEG6_ATTR_DSTLEN = 2,
	SEG6_ATTR_HMACKEYID = 3,
	SEG6_ATTR_SECRET = 4,
	SEG6_ATTR_SECRETLEN = 5,
	SEG6_ATTR_ALGID = 6,
	SEG6_ATTR_HMACINFO = 7,
	__SEG6_ATTR_MAX = 8,
};

enum {
	SEG6_CMD_UNSPEC = 0,
	SEG6_CMD_SETHMAC = 1,
	SEG6_CMD_DUMPHMAC = 2,
	SEG6_CMD_SET_TUNSRC = 3,
	SEG6_CMD_GET_TUNSRC = 4,
	__SEG6_CMD_MAX = 5,
};

enum {
	SEG6_HMAC_ALGO_SHA1 = 1,
	SEG6_HMAC_ALGO_SHA256 = 2,
};

enum {
	SEG6_IPTUNNEL_UNSPEC = 0,
	SEG6_IPTUNNEL_SRH = 1,
	__SEG6_IPTUNNEL_MAX = 2,
};

enum {
	SEG6_IPTUN_MODE_INLINE = 0,
	SEG6_IPTUN_MODE_ENCAP = 1,
	SEG6_IPTUN_MODE_L2ENCAP = 2,
	SEG6_IPTUN_MODE_ENCAP_RED = 3,
	SEG6_IPTUN_MODE_L2ENCAP_RED = 4,
};

enum {
	SEG6_LOCAL_ACTION_UNSPEC = 0,
	SEG6_LOCAL_ACTION_END = 1,
	SEG6_LOCAL_ACTION_END_X = 2,
	SEG6_LOCAL_ACTION_END_T = 3,
	SEG6_LOCAL_ACTION_END_DX2 = 4,
	SEG6_LOCAL_ACTION_END_DX6 = 5,
	SEG6_LOCAL_ACTION_END_DX4 = 6,
	SEG6_LOCAL_ACTION_END_DT6 = 7,
	SEG6_LOCAL_ACTION_END_DT4 = 8,
	SEG6_LOCAL_ACTION_END_B6 = 9,
	SEG6_LOCAL_ACTION_END_B6_ENCAP = 10,
	SEG6_LOCAL_ACTION_END_BM = 11,
	SEG6_LOCAL_ACTION_END_S = 12,
	SEG6_LOCAL_ACTION_END_AS = 13,
	SEG6_LOCAL_ACTION_END_AM = 14,
	SEG6_LOCAL_ACTION_END_BPF = 15,
	SEG6_LOCAL_ACTION_END_DT46 = 16,
	__SEG6_LOCAL_ACTION_MAX = 17,
};

enum {
	SEG6_LOCAL_BPF_PROG_UNSPEC = 0,
	SEG6_LOCAL_BPF_PROG = 1,
	SEG6_LOCAL_BPF_PROG_NAME = 2,
	__SEG6_LOCAL_BPF_PROG_MAX = 3,
};

enum {
	SEG6_LOCAL_CNT_UNSPEC = 0,
	SEG6_LOCAL_CNT_PAD = 1,
	SEG6_LOCAL_CNT_PACKETS = 2,
	SEG6_LOCAL_CNT_BYTES = 3,
	SEG6_LOCAL_CNT_ERRORS = 4,
	__SEG6_LOCAL_CNT_MAX = 5,
};

enum {
	SEG6_LOCAL_FLV_OP_UNSPEC = 0,
	SEG6_LOCAL_FLV_OP_PSP = 1,
	SEG6_LOCAL_FLV_OP_USP = 2,
	SEG6_LOCAL_FLV_OP_USD = 3,
	SEG6_LOCAL_FLV_OP_NEXT_CSID = 4,
	__SEG6_LOCAL_FLV_OP_MAX = 5,
};

enum {
	SEG6_LOCAL_FLV_UNSPEC = 0,
	SEG6_LOCAL_FLV_OPERATION = 1,
	SEG6_LOCAL_FLV_LCBLOCK_BITS = 2,
	SEG6_LOCAL_FLV_LCNODE_FN_BITS = 3,
	__SEG6_LOCAL_FLV_MAX = 4,
};

enum {
	SEG6_LOCAL_UNSPEC = 0,
	SEG6_LOCAL_ACTION = 1,
	SEG6_LOCAL_SRH = 2,
	SEG6_LOCAL_TABLE = 3,
	SEG6_LOCAL_NH4 = 4,
	SEG6_LOCAL_NH6 = 5,
	SEG6_LOCAL_IIF = 6,
	SEG6_LOCAL_OIF = 7,
	SEG6_LOCAL_BPF = 8,
	SEG6_LOCAL_VRFTABLE = 9,
	SEG6_LOCAL_COUNTERS = 10,
	SEG6_LOCAL_FLAVORS = 11,
	__SEG6_LOCAL_MAX = 12,
};

enum {
	SFF8024_ID_UNK = 0,
	SFF8024_ID_SFF_8472 = 2,
	SFF8024_ID_SFP = 3,
	SFF8024_ID_DWDM_SFP = 11,
	SFF8024_ID_QSFP_8438 = 12,
	SFF8024_ID_QSFP_8436_8636 = 13,
	SFF8024_ID_QSFP28_8636 = 17,
	SFF8024_ID_QSFP_DD = 24,
	SFF8024_ID_OSFP = 25,
	SFF8024_ID_DSFP = 27,
	SFF8024_ID_QSFP_PLUS_CMIS = 30,
	SFF8024_ID_SFP_DD_CMIS = 31,
	SFF8024_ID_SFP_PLUS_CMIS = 32,
	SFF8024_ENCODING_UNSPEC = 0,
	SFF8024_ENCODING_8B10B = 1,
	SFF8024_ENCODING_4B5B = 2,
	SFF8024_ENCODING_NRZ = 3,
	SFF8024_ENCODING_8472_MANCHESTER = 4,
	SFF8024_ENCODING_8472_SONET = 5,
	SFF8024_ENCODING_8472_64B66B = 6,
	SFF8024_ENCODING_8436_MANCHESTER = 6,
	SFF8024_ENCODING_8436_SONET = 4,
	SFF8024_ENCODING_8436_64B66B = 5,
	SFF8024_ENCODING_256B257B = 7,
	SFF8024_ENCODING_PAM4 = 8,
	SFF8024_CONNECTOR_UNSPEC = 0,
	SFF8024_CONNECTOR_SC = 1,
	SFF8024_CONNECTOR_FIBERJACK = 6,
	SFF8024_CONNECTOR_LC = 7,
	SFF8024_CONNECTOR_MT_RJ = 8,
	SFF8024_CONNECTOR_MU = 9,
	SFF8024_CONNECTOR_SG = 10,
	SFF8024_CONNECTOR_OPTICAL_PIGTAIL = 11,
	SFF8024_CONNECTOR_MPO_1X12 = 12,
	SFF8024_CONNECTOR_MPO_2X16 = 13,
	SFF8024_CONNECTOR_HSSDC_II = 32,
	SFF8024_CONNECTOR_COPPER_PIGTAIL = 33,
	SFF8024_CONNECTOR_RJ45 = 34,
	SFF8024_CONNECTOR_NOSEPARATE = 35,
	SFF8024_CONNECTOR_MXC_2X16 = 36,
	SFF8024_ECC_UNSPEC = 0,
	SFF8024_ECC_100G_25GAUI_C2M_AOC = 1,
	SFF8024_ECC_100GBASE_SR4_25GBASE_SR = 2,
	SFF8024_ECC_100GBASE_LR4_25GBASE_LR = 3,
	SFF8024_ECC_100GBASE_ER4_25GBASE_ER = 4,
	SFF8024_ECC_100GBASE_SR10 = 5,
	SFF8024_ECC_100GBASE_CR4 = 11,
	SFF8024_ECC_25GBASE_CR_S = 12,
	SFF8024_ECC_25GBASE_CR_N = 13,
	SFF8024_ECC_10GBASE_T_SFI = 22,
	SFF8024_ECC_10GBASE_T_SR = 28,
	SFF8024_ECC_5GBASE_T = 29,
	SFF8024_ECC_2_5GBASE_T = 30,
};

enum {
	SFP_PHYS_ID = 0,
	SFP_PHYS_EXT_ID = 1,
	SFP_PHYS_EXT_ID_SFP = 4,
	SFP_CONNECTOR = 2,
	SFP_COMPLIANCE = 3,
	SFP_ENCODING = 11,
	SFP_BR_NOMINAL = 12,
	SFP_RATE_ID = 13,
	SFF_RID_8079 = 1,
	SFF_RID_8431_RX_ONLY = 2,
	SFF_RID_8431_TX_ONLY = 4,
	SFF_RID_8431 = 6,
	SFF_RID_10G8G = 14,
	SFP_LINK_LEN_SM_KM = 14,
	SFP_LINK_LEN_SM_100M = 15,
	SFP_LINK_LEN_50UM_OM2_10M = 16,
	SFP_LINK_LEN_62_5UM_OM1_10M = 17,
	SFP_LINK_LEN_COPPER_1M = 18,
	SFP_LINK_LEN_50UM_OM4_10M = 18,
	SFP_LINK_LEN_50UM_OM3_10M = 19,
	SFP_VENDOR_NAME = 20,
	SFP_VENDOR_OUI = 37,
	SFP_VENDOR_PN = 40,
	SFP_VENDOR_REV = 56,
	SFP_OPTICAL_WAVELENGTH_MSB = 60,
	SFP_OPTICAL_WAVELENGTH_LSB = 61,
	SFP_CABLE_SPEC = 60,
	SFP_CC_BASE = 63,
	SFP_OPTIONS = 64,
	SFP_OPTIONS_HIGH_POWER_LEVEL = 8192,
	SFP_OPTIONS_PAGING_A2 = 4096,
	SFP_OPTIONS_RETIMER = 2048,
	SFP_OPTIONS_COOLED_XCVR = 1024,
	SFP_OPTIONS_POWER_DECL = 512,
	SFP_OPTIONS_RX_LINEAR_OUT = 256,
	SFP_OPTIONS_RX_DECISION_THRESH = 128,
	SFP_OPTIONS_TUNABLE_TX = 64,
	SFP_OPTIONS_RATE_SELECT = 32,
	SFP_OPTIONS_TX_DISABLE = 16,
	SFP_OPTIONS_TX_FAULT = 8,
	SFP_OPTIONS_LOS_INVERTED = 4,
	SFP_OPTIONS_LOS_NORMAL = 2,
	SFP_BR_MAX = 66,
	SFP_BR_MIN = 67,
	SFP_VENDOR_SN = 68,
	SFP_DATECODE = 84,
	SFP_DIAGMON = 92,
	SFP_DIAGMON_DDM = 64,
	SFP_DIAGMON_INT_CAL = 32,
	SFP_DIAGMON_EXT_CAL = 16,
	SFP_DIAGMON_RXPWR_AVG = 8,
	SFP_DIAGMON_ADDRMODE = 4,
	SFP_ENHOPTS = 93,
	SFP_ENHOPTS_ALARMWARN = 128,
	SFP_ENHOPTS_SOFT_TX_DISABLE = 64,
	SFP_ENHOPTS_SOFT_TX_FAULT = 32,
	SFP_ENHOPTS_SOFT_RX_LOS = 16,
	SFP_ENHOPTS_SOFT_RATE_SELECT = 8,
	SFP_ENHOPTS_APP_SELECT_SFF8079 = 4,
	SFP_ENHOPTS_SOFT_RATE_SFF8431 = 2,
	SFP_SFF8472_COMPLIANCE = 94,
	SFP_SFF8472_COMPLIANCE_NONE = 0,
	SFP_SFF8472_COMPLIANCE_REV9_3 = 1,
	SFP_SFF8472_COMPLIANCE_REV9_5 = 2,
	SFP_SFF8472_COMPLIANCE_REV10_2 = 3,
	SFP_SFF8472_COMPLIANCE_REV10_4 = 4,
	SFP_SFF8472_COMPLIANCE_REV11_0 = 5,
	SFP_SFF8472_COMPLIANCE_REV11_3 = 6,
	SFP_SFF8472_COMPLIANCE_REV11_4 = 7,
	SFP_SFF8472_COMPLIANCE_REV12_0 = 8,
	SFP_CC_EXT = 95,
};

enum {
	SILERGY_SYR82X = 8,
	SILERGY_SYR83X = 9,
};

enum {
	SKBFL_ZEROCOPY_ENABLE = 1,
	SKBFL_SHARED_FRAG = 2,
	SKBFL_PURE_ZEROCOPY = 4,
	SKBFL_DONT_ORPHAN = 8,
	SKBFL_MANAGED_FRAG_REFS = 16,
};

enum {
	SKBTX_HW_TSTAMP_NOBPF = 1,
	SKBTX_SW_TSTAMP = 2,
	SKBTX_IN_PROGRESS = 4,
	SKBTX_COMPLETION_TSTAMP = 8,
	SKBTX_HW_TSTAMP_NETDEV = 32,
	SKBTX_SCHED_TSTAMP = 64,
	SKBTX_BPF = 128,
};

enum {
	SKB_FCLONE_UNAVAILABLE = 0,
	SKB_FCLONE_ORIG = 1,
	SKB_FCLONE_CLONE = 2,
};

enum {
	SKB_GSO_TCPV4 = 1,
	SKB_GSO_DODGY = 2,
	SKB_GSO_TCP_ECN = 4,
	SKB_GSO_TCP_FIXEDID = 8,
	SKB_GSO_TCPV6 = 16,
	SKB_GSO_FCOE = 32,
	SKB_GSO_GRE = 64,
	SKB_GSO_GRE_CSUM = 128,
	SKB_GSO_IPXIP4 = 256,
	SKB_GSO_IPXIP6 = 512,
	SKB_GSO_UDP_TUNNEL = 1024,
	SKB_GSO_UDP_TUNNEL_CSUM = 2048,
	SKB_GSO_PARTIAL = 4096,
	SKB_GSO_TUNNEL_REMCSUM = 8192,
	SKB_GSO_SCTP = 16384,
	SKB_GSO_ESP = 32768,
	SKB_GSO_UDP = 65536,
	SKB_GSO_UDP_L4 = 131072,
	SKB_GSO_FRAGLIST = 262144,
	SKB_GSO_TCP_ACCECN = 524288,
};

enum {
	SKCIPHER_WALK_SLOW = 1,
	SKCIPHER_WALK_COPY = 2,
	SKCIPHER_WALK_DIFF = 4,
	SKCIPHER_WALK_SLEEP = 8,
};

enum {
	SK_BPF_CB_TX_TIMESTAMPING = 1,
	SK_BPF_CB_MASK = 1,
};

enum {
	SK_DIAG_BPF_STORAGE_NONE = 0,
	SK_DIAG_BPF_STORAGE_PAD = 1,
	SK_DIAG_BPF_STORAGE_MAP_ID = 2,
	SK_DIAG_BPF_STORAGE_MAP_VALUE = 3,
	__SK_DIAG_BPF_STORAGE_MAX = 4,
};

enum {
	SK_DIAG_BPF_STORAGE_REP_NONE = 0,
	SK_DIAG_BPF_STORAGE = 1,
	__SK_DIAG_BPF_STORAGE_REP_MAX = 2,
};

enum {
	SK_DIAG_BPF_STORAGE_REQ_NONE = 0,
	SK_DIAG_BPF_STORAGE_REQ_MAP_FD = 1,
	__SK_DIAG_BPF_STORAGE_REQ_MAX = 2,
};

enum {
	SK_MEMINFO_RMEM_ALLOC = 0,
	SK_MEMINFO_RCVBUF = 1,
	SK_MEMINFO_WMEM_ALLOC = 2,
	SK_MEMINFO_SNDBUF = 3,
	SK_MEMINFO_FWD_ALLOC = 4,
	SK_MEMINFO_WMEM_QUEUED = 5,
	SK_MEMINFO_OPTMEM = 6,
	SK_MEMINFO_BACKLOG = 7,
	SK_MEMINFO_DROPS = 8,
	SK_MEMINFO_VARS = 9,
};

enum {
	SNDRV_CTL_TLV_OP_READ = 0,
	SNDRV_CTL_TLV_OP_WRITE = 1,
	SNDRV_CTL_TLV_OP_CMD = -1,
};

enum {
	SNDRV_DEVICE_TYPE_CONTROL = 0,
	SNDRV_DEVICE_TYPE_SEQUENCER = 1,
	SNDRV_DEVICE_TYPE_TIMER = 2,
	SNDRV_DEVICE_TYPE_HWDEP = 3,
	SNDRV_DEVICE_TYPE_RAWMIDI = 4,
	SNDRV_DEVICE_TYPE_PCM_PLAYBACK = 5,
	SNDRV_DEVICE_TYPE_PCM_CAPTURE = 6,
	SNDRV_DEVICE_TYPE_COMPRESS = 7,
};

enum {
	SNDRV_PCM_STREAM_PLAYBACK = 0,
	SNDRV_PCM_STREAM_CAPTURE = 1,
	SNDRV_PCM_STREAM_LAST = 1,
};

enum {
	SND_CTL_SUBDEV_PCM = 0,
	SND_CTL_SUBDEV_RAWMIDI = 1,
	SND_CTL_SUBDEV_ITEMS = 2,
};

enum {
	SOCK_WAKE_IO = 0,
	SOCK_WAKE_WAITD = 1,
	SOCK_WAKE_SPACE = 2,
	SOCK_WAKE_URG = 3,
};

enum {
	SOF_TIMESTAMPING_TX_HARDWARE = 1,
	SOF_TIMESTAMPING_TX_SOFTWARE = 2,
	SOF_TIMESTAMPING_RX_HARDWARE = 4,
	SOF_TIMESTAMPING_RX_SOFTWARE = 8,
	SOF_TIMESTAMPING_SOFTWARE = 16,
	SOF_TIMESTAMPING_SYS_HARDWARE = 32,
	SOF_TIMESTAMPING_RAW_HARDWARE = 64,
	SOF_TIMESTAMPING_OPT_ID = 128,
	SOF_TIMESTAMPING_TX_SCHED = 256,
	SOF_TIMESTAMPING_TX_ACK = 512,
	SOF_TIMESTAMPING_OPT_CMSG = 1024,
	SOF_TIMESTAMPING_OPT_TSONLY = 2048,
	SOF_TIMESTAMPING_OPT_STATS = 4096,
	SOF_TIMESTAMPING_OPT_PKTINFO = 8192,
	SOF_TIMESTAMPING_OPT_TX_SWHW = 16384,
	SOF_TIMESTAMPING_BIND_PHC = 32768,
	SOF_TIMESTAMPING_OPT_ID_TCP = 65536,
	SOF_TIMESTAMPING_OPT_RX_FILTER = 131072,
	SOF_TIMESTAMPING_TX_COMPLETION = 262144,
	SOF_TIMESTAMPING_LAST = 262144,
	SOF_TIMESTAMPING_MASK = 524287,
};

enum {
	SPECTRE_UNAFFECTED = 0,
	SPECTRE_MITIGATED = 1,
	SPECTRE_VULNERABLE = 2,
};

enum {
	SPECTRE_V2_METHOD_BPIALL = 1,
	SPECTRE_V2_METHOD_ICIALLU = 2,
	SPECTRE_V2_METHOD_SMC = 4,
	SPECTRE_V2_METHOD_HVC = 8,
	SPECTRE_V2_METHOD_LOOP8 = 16,
};

enum {
	SPEEDO_ID_0 = 0,
	SPEEDO_ID_1 = 1,
	SPEEDO_ID_2 = 2,
	SPEEDO_ID_COUNT = 3,
};

enum {
	SP_TASK_PENDING = 0,
	SP_NEED_VICTIM = 1,
	SP_VICTIM_REMAINS = 2,
};

enum {
	STACK_USE_NONE = 0,
	STACK_USE_UNKNOWN = 1,
	STACK_USE_FIXED_X0X = 2,
	STACK_USE_FIXED_XXX = 3,
	STACK_USE_STMDX = 4,
	NUM_STACK_USE_TYPES = 5,
};

enum {
	STATE_IDLE = 0,
	STATE_READ = 1,
	STATE_WRITE = 2,
};

enum {
	STMPE_IDX_CHIP_ID = 0,
	STMPE_IDX_SYS_CTRL = 1,
	STMPE_IDX_SYS_CTRL2 = 2,
	STMPE_IDX_ICR_LSB = 3,
	STMPE_IDX_IER_LSB = 4,
	STMPE_IDX_IER_MSB = 5,
	STMPE_IDX_ISR_LSB = 6,
	STMPE_IDX_ISR_MSB = 7,
	STMPE_IDX_GPMR_LSB = 8,
	STMPE_IDX_GPMR_CSB = 9,
	STMPE_IDX_GPMR_MSB = 10,
	STMPE_IDX_GPSR_LSB = 11,
	STMPE_IDX_GPSR_CSB = 12,
	STMPE_IDX_GPSR_MSB = 13,
	STMPE_IDX_GPCR_LSB = 14,
	STMPE_IDX_GPCR_CSB = 15,
	STMPE_IDX_GPCR_MSB = 16,
	STMPE_IDX_GPDR_LSB = 17,
	STMPE_IDX_GPDR_CSB = 18,
	STMPE_IDX_GPDR_MSB = 19,
	STMPE_IDX_GPEDR_LSB = 20,
	STMPE_IDX_GPEDR_CSB = 21,
	STMPE_IDX_GPEDR_MSB = 22,
	STMPE_IDX_GPRER_LSB = 23,
	STMPE_IDX_GPRER_CSB = 24,
	STMPE_IDX_GPRER_MSB = 25,
	STMPE_IDX_GPFER_LSB = 26,
	STMPE_IDX_GPFER_CSB = 27,
	STMPE_IDX_GPFER_MSB = 28,
	STMPE_IDX_GPPUR_LSB = 29,
	STMPE_IDX_GPPDR_LSB = 30,
	STMPE_IDX_GPAFR_U_MSB = 31,
	STMPE_IDX_IEGPIOR_LSB = 32,
	STMPE_IDX_IEGPIOR_CSB = 33,
	STMPE_IDX_IEGPIOR_MSB = 34,
	STMPE_IDX_ISGPIOR_LSB = 35,
	STMPE_IDX_ISGPIOR_CSB = 36,
	STMPE_IDX_ISGPIOR_MSB = 37,
	STMPE_IDX_MAX = 38,
};

enum {
	STPMIC1_BUCK1 = 0,
	STPMIC1_BUCK2 = 1,
	STPMIC1_BUCK3 = 2,
	STPMIC1_BUCK4 = 3,
	STPMIC1_LDO1 = 4,
	STPMIC1_LDO2 = 5,
	STPMIC1_LDO3 = 6,
	STPMIC1_LDO4 = 7,
	STPMIC1_LDO5 = 8,
	STPMIC1_LDO6 = 9,
	STPMIC1_VREF_DDR = 10,
	STPMIC1_BOOST = 11,
	STPMIC1_VBUS_OTG = 12,
	STPMIC1_SW_OUT = 13,
};

enum {
	ST_DISCONNECTED = 0,
	ST_MAINLINK_READY = 1,
	ST_CONNECTED = 2,
	ST_DISCONNECT_PENDING = 3,
	ST_DISPLAY_OFF = 4,
};

enum {
	SUBMIT_STATUS_URB = 2,
	ALLOC_DATA_IN_URB = 4,
	SUBMIT_DATA_IN_URB = 8,
	ALLOC_DATA_OUT_URB = 16,
	SUBMIT_DATA_OUT_URB = 32,
	ALLOC_CMD_URB = 64,
	SUBMIT_CMD_URB = 128,
	COMMAND_INFLIGHT = 256,
	DATA_IN_URB_INFLIGHT = 512,
	DATA_OUT_URB_INFLIGHT = 1024,
	COMMAND_ABORTED = 2048,
	IS_IN_WORK_LIST = 4096,
};

enum {
	SUNRPC_PIPEFS_NFS_PRIO = 0,
	SUNRPC_PIPEFS_RPC_PRIO = 1,
};

enum {
	SUNXI_SRC_TYPE_LEVEL_LOW = 0,
	SUNXI_SRC_TYPE_EDGE_FALLING = 1,
	SUNXI_SRC_TYPE_LEVEL_HIGH = 2,
	SUNXI_SRC_TYPE_EDGE_RISING = 3,
};

enum {
	SVC_HANDSHAKE_TO = 1250,
};

enum {
	SVC_POOL_AUTO = -1,
	SVC_POOL_GLOBAL = 0,
	SVC_POOL_PERCPU = 1,
	SVC_POOL_PERNODE = 2,
};

enum {
	SWITCHTEC_GAS_MRPC_OFFSET = 0,
	SWITCHTEC_GAS_TOP_CFG_OFFSET = 4096,
	SWITCHTEC_GAS_SW_EVENT_OFFSET = 6144,
	SWITCHTEC_GAS_SYS_INFO_OFFSET = 8192,
	SWITCHTEC_GAS_FLASH_INFO_OFFSET = 8704,
	SWITCHTEC_GAS_PART_CFG_OFFSET = 16384,
	SWITCHTEC_GAS_NTB_OFFSET = 65536,
	SWITCHTEC_GAS_PFF_CSR_OFFSET = 1261568,
};

enum {
	SWITCHTEC_NTB_REG_INFO_OFFSET = 0,
	SWITCHTEC_NTB_REG_CTRL_OFFSET = 16384,
	SWITCHTEC_NTB_REG_DBMSG_OFFSET = 409600,
};

enum {
	SWMII_SPEED_10 = 0,
	SWMII_SPEED_100 = 1,
	SWMII_SPEED_1000 = 2,
	SWMII_DUPLEX_HALF = 0,
	SWMII_DUPLEX_FULL = 1,
};

enum {
	SWP_USED = 1,
	SWP_WRITEOK = 2,
	SWP_DISCARDABLE = 4,
	SWP_DISCARDING = 8,
	SWP_SOLIDSTATE = 16,
	SWP_CONTINUED = 32,
	SWP_BLKDEV = 64,
	SWP_ACTIVATED = 128,
	SWP_FS_OPS = 256,
	SWP_AREA_DISCARD = 512,
	SWP_PAGE_DISCARD = 1024,
	SWP_STABLE_WRITES = 2048,
	SWP_SYNCHRONOUS_IO = 4096,
};

enum {
	SX150X_123 = 0,
	SX150X_456 = 1,
	SX150X_789 = 2,
};

enum {
	SX150X_789_REG_MISC_AUTOCLEAR_OFF = 1,
	SX150X_MAX_REGISTER = 173,
	SX150X_IRQ_TYPE_EDGE_RISING = 1,
	SX150X_IRQ_TYPE_EDGE_FALLING = 2,
	SX150X_789_RESET_KEY1 = 18,
	SX150X_789_RESET_KEY2 = 52,
};

enum {
	SYSTAB = 0,
	MMBASE = 1,
	MMSIZE = 2,
	DCSIZE = 3,
	DCVERS = 4,
	PARAMCOUNT = 5,
};

enum {
	TASKLET_STATE_SCHED = 0,
	TASKLET_STATE_RUN = 1,
};

enum {
	TASKSTATS_CMD_ATTR_UNSPEC = 0,
	TASKSTATS_CMD_ATTR_PID = 1,
	TASKSTATS_CMD_ATTR_TGID = 2,
	TASKSTATS_CMD_ATTR_REGISTER_CPUMASK = 3,
	TASKSTATS_CMD_ATTR_DEREGISTER_CPUMASK = 4,
	__TASKSTATS_CMD_ATTR_MAX = 5,
};

enum {
	TASKSTATS_CMD_UNSPEC = 0,
	TASKSTATS_CMD_GET = 1,
	TASKSTATS_CMD_NEW = 2,
	__TASKSTATS_CMD_MAX = 3,
};

enum {
	TASKSTATS_TYPE_UNSPEC = 0,
	TASKSTATS_TYPE_PID = 1,
	TASKSTATS_TYPE_TGID = 2,
	TASKSTATS_TYPE_STATS = 3,
	TASKSTATS_TYPE_AGGR_PID = 4,
	TASKSTATS_TYPE_AGGR_TGID = 5,
	TASKSTATS_TYPE_NULL = 6,
	__TASKSTATS_TYPE_MAX = 7,
};

enum {
	TASK_COMM_LEN = 16,
};

enum {
	TCA_ACT_UNSPEC = 0,
	TCA_ACT_KIND = 1,
	TCA_ACT_OPTIONS = 2,
	TCA_ACT_INDEX = 3,
	TCA_ACT_STATS = 4,
	TCA_ACT_PAD = 5,
	TCA_ACT_COOKIE = 6,
	TCA_ACT_FLAGS = 7,
	TCA_ACT_HW_STATS = 8,
	TCA_ACT_USED_HW_STATS = 9,
	TCA_ACT_IN_HW_COUNT = 10,
	__TCA_ACT_MAX = 11,
};

enum {
	TCA_EMATCH_TREE_UNSPEC = 0,
	TCA_EMATCH_TREE_HDR = 1,
	TCA_EMATCH_TREE_LIST = 2,
	__TCA_EMATCH_TREE_MAX = 3,
};

enum {
	TCA_FLOWER_KEY_CT_FLAGS_NEW = 1,
	TCA_FLOWER_KEY_CT_FLAGS_ESTABLISHED = 2,
	TCA_FLOWER_KEY_CT_FLAGS_RELATED = 4,
	TCA_FLOWER_KEY_CT_FLAGS_TRACKED = 8,
	TCA_FLOWER_KEY_CT_FLAGS_INVALID = 16,
	TCA_FLOWER_KEY_CT_FLAGS_REPLY = 32,
	__TCA_FLOWER_KEY_CT_FLAGS_MAX = 33,
};

enum {
	TCA_FLOWER_KEY_FLAGS_IS_FRAGMENT = 1,
	TCA_FLOWER_KEY_FLAGS_FRAG_IS_FIRST = 2,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CSUM = 4,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_DONT_FRAGMENT = 8,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_OAM = 16,
	TCA_FLOWER_KEY_FLAGS_TUNNEL_CRIT_OPT = 32,
	__TCA_FLOWER_KEY_FLAGS_MAX = 33,
};

enum {
	TCA_ROOT_UNSPEC = 0,
	TCA_ROOT_TAB = 1,
	TCA_ROOT_FLAGS = 2,
	TCA_ROOT_COUNT = 3,
	TCA_ROOT_TIME_DELTA = 4,
	TCA_ROOT_EXT_WARN_MSG = 5,
	__TCA_ROOT_MAX = 6,
};

enum {
	TCA_STAB_UNSPEC = 0,
	TCA_STAB_BASE = 1,
	TCA_STAB_DATA = 2,
	__TCA_STAB_MAX = 3,
};

enum {
	TCA_STATS_UNSPEC = 0,
	TCA_STATS_BASIC = 1,
	TCA_STATS_RATE_EST = 2,
	TCA_STATS_QUEUE = 3,
	TCA_STATS_APP = 4,
	TCA_STATS_RATE_EST64 = 5,
	TCA_STATS_PAD = 6,
	TCA_STATS_BASIC_HW = 7,
	TCA_STATS_PKT64 = 8,
	__TCA_STATS_MAX = 9,
};

enum {
	TCA_UNSPEC = 0,
	TCA_KIND = 1,
	TCA_OPTIONS = 2,
	TCA_STATS = 3,
	TCA_XSTATS = 4,
	TCA_RATE = 5,
	TCA_FCNT = 6,
	TCA_STATS2 = 7,
	TCA_STAB = 8,
	TCA_PAD = 9,
	TCA_DUMP_INVISIBLE = 10,
	TCA_CHAIN = 11,
	TCA_HW_OFFLOAD = 12,
	TCA_INGRESS_BLOCK = 13,
	TCA_EGRESS_BLOCK = 14,
	TCA_DUMP_FLAGS = 15,
	TCA_EXT_WARN_MSG = 16,
	__TCA_MAX = 17,
};

enum {
	TCG_SECP_00 = 0,
	TCG_SECP_01 = 1,
};

enum {
	TCPF_ESTABLISHED = 2,
	TCPF_SYN_SENT = 4,
	TCPF_SYN_RECV = 8,
	TCPF_FIN_WAIT1 = 16,
	TCPF_FIN_WAIT2 = 32,
	TCPF_TIME_WAIT = 64,
	TCPF_CLOSE = 128,
	TCPF_CLOSE_WAIT = 256,
	TCPF_LAST_ACK = 512,
	TCPF_LISTEN = 1024,
	TCPF_CLOSING = 2048,
	TCPF_NEW_SYN_RECV = 4096,
	TCPF_BOUND_INACTIVE = 8192,
};

enum {
	TCP_BPF_BASE = 0,
	TCP_BPF_TX = 1,
	TCP_BPF_RX = 2,
	TCP_BPF_TXRX = 3,
	TCP_BPF_NUM_CFGS = 4,
};

enum {
	TCP_BPF_IPV4 = 0,
	TCP_BPF_IPV6 = 1,
	TCP_BPF_NUM_PROTS = 2,
};

enum {
	TCP_BPF_IW = 1001,
	TCP_BPF_SNDCWND_CLAMP = 1002,
	TCP_BPF_DELACK_MAX = 1003,
	TCP_BPF_RTO_MIN = 1004,
	TCP_BPF_SYN = 1005,
	TCP_BPF_SYN_IP = 1006,
	TCP_BPF_SYN_MAC = 1007,
	TCP_BPF_SOCK_OPS_CB_FLAGS = 1008,
	SK_BPF_CB_FLAGS = 1009,
};

enum {
	TCP_CMSG_INQ = 1,
	TCP_CMSG_TS = 2,
};

enum {
	TCP_ESTABLISHED = 1,
	TCP_SYN_SENT = 2,
	TCP_SYN_RECV = 3,
	TCP_FIN_WAIT1 = 4,
	TCP_FIN_WAIT2 = 5,
	TCP_TIME_WAIT = 6,
	TCP_CLOSE = 7,
	TCP_CLOSE_WAIT = 8,
	TCP_LAST_ACK = 9,
	TCP_LISTEN = 10,
	TCP_CLOSING = 11,
	TCP_NEW_SYN_RECV = 12,
	TCP_BOUND_INACTIVE = 13,
	TCP_MAX_STATES = 14,
};

enum {
	TCP_FLAG_AE = 1,
	TCP_FLAG_CWR = 32768,
	TCP_FLAG_ECE = 16384,
	TCP_FLAG_URG = 8192,
	TCP_FLAG_ACK = 4096,
	TCP_FLAG_PSH = 2048,
	TCP_FLAG_RST = 1024,
	TCP_FLAG_SYN = 512,
	TCP_FLAG_FIN = 256,
	TCP_RESERVED_BITS = 14,
	TCP_DATA_OFFSET = 240,
};

enum {
	TCP_METRICS_ATTR_UNSPEC = 0,
	TCP_METRICS_ATTR_ADDR_IPV4 = 1,
	TCP_METRICS_ATTR_ADDR_IPV6 = 2,
	TCP_METRICS_ATTR_AGE = 3,
	TCP_METRICS_ATTR_TW_TSVAL = 4,
	TCP_METRICS_ATTR_TW_TS_STAMP = 5,
	TCP_METRICS_ATTR_VALS = 6,
	TCP_METRICS_ATTR_FOPEN_MSS = 7,
	TCP_METRICS_ATTR_FOPEN_SYN_DROPS = 8,
	TCP_METRICS_ATTR_FOPEN_SYN_DROP_TS = 9,
	TCP_METRICS_ATTR_FOPEN_COOKIE = 10,
	TCP_METRICS_ATTR_SADDR_IPV4 = 11,
	TCP_METRICS_ATTR_SADDR_IPV6 = 12,
	TCP_METRICS_ATTR_PAD = 13,
	__TCP_METRICS_ATTR_MAX = 14,
};

enum {
	TCP_METRICS_CMD_UNSPEC = 0,
	TCP_METRICS_CMD_GET = 1,
	TCP_METRICS_CMD_DEL = 2,
	__TCP_METRICS_CMD_MAX = 3,
};

enum {
	TCP_MIB_NUM = 0,
	TCP_MIB_RTOALGORITHM = 1,
	TCP_MIB_RTOMIN = 2,
	TCP_MIB_RTOMAX = 3,
	TCP_MIB_MAXCONN = 4,
	TCP_MIB_ACTIVEOPENS = 5,
	TCP_MIB_PASSIVEOPENS = 6,
	TCP_MIB_ATTEMPTFAILS = 7,
	TCP_MIB_ESTABRESETS = 8,
	TCP_MIB_CURRESTAB = 9,
	TCP_MIB_INSEGS = 10,
	TCP_MIB_OUTSEGS = 11,
	TCP_MIB_RETRANSSEGS = 12,
	TCP_MIB_INERRS = 13,
	TCP_MIB_OUTRSTS = 14,
	TCP_MIB_CSUMERRORS = 15,
	__TCP_MIB_MAX = 16,
};

enum {
	TCP_NLA_PAD = 0,
	TCP_NLA_BUSY = 1,
	TCP_NLA_RWND_LIMITED = 2,
	TCP_NLA_SNDBUF_LIMITED = 3,
	TCP_NLA_DATA_SEGS_OUT = 4,
	TCP_NLA_TOTAL_RETRANS = 5,
	TCP_NLA_PACING_RATE = 6,
	TCP_NLA_DELIVERY_RATE = 7,
	TCP_NLA_SND_CWND = 8,
	TCP_NLA_REORDERING = 9,
	TCP_NLA_MIN_RTT = 10,
	TCP_NLA_RECUR_RETRANS = 11,
	TCP_NLA_DELIVERY_RATE_APP_LMT = 12,
	TCP_NLA_SNDQ_SIZE = 13,
	TCP_NLA_CA_STATE = 14,
	TCP_NLA_SND_SSTHRESH = 15,
	TCP_NLA_DELIVERED = 16,
	TCP_NLA_DELIVERED_CE = 17,
	TCP_NLA_BYTES_SENT = 18,
	TCP_NLA_BYTES_RETRANS = 19,
	TCP_NLA_DSACK_DUPS = 20,
	TCP_NLA_REORD_SEEN = 21,
	TCP_NLA_SRTT = 22,
	TCP_NLA_TIMEOUT_REHASH = 23,
	TCP_NLA_BYTES_NOTSENT = 24,
	TCP_NLA_EDT = 25,
	TCP_NLA_TTL = 26,
	TCP_NLA_REHASH = 27,
};

enum {
	TCP_NO_QUEUE = 0,
	TCP_RECV_QUEUE = 1,
	TCP_SEND_QUEUE = 2,
	TCP_QUEUES_NR = 3,
};

enum {
	TCP_V4_FLOW = 1,
	UDP_V4_FLOW = 2,
	SCTP_V4_FLOW = 3,
	AH_ESP_V4_FLOW = 4,
	TCP_V6_FLOW = 5,
	UDP_V6_FLOW = 6,
	SCTP_V6_FLOW = 7,
	AH_ESP_V6_FLOW = 8,
	AH_V4_FLOW = 9,
	ESP_V4_FLOW = 10,
	AH_V6_FLOW = 11,
	ESP_V6_FLOW = 12,
	IPV4_USER_FLOW = 13,
	IP_USER_FLOW = 13,
	IPV6_USER_FLOW = 14,
	IPV4_FLOW = 16,
	IPV6_FLOW = 17,
	ETHER_FLOW = 18,
	GTPU_V4_FLOW = 19,
	GTPU_V6_FLOW = 20,
	GTPC_V4_FLOW = 21,
	GTPC_V6_FLOW = 22,
	GTPC_TEID_V4_FLOW = 23,
	GTPC_TEID_V6_FLOW = 24,
	GTPU_EH_V4_FLOW = 25,
	GTPU_EH_V6_FLOW = 26,
	GTPU_UL_V4_FLOW = 27,
	GTPU_UL_V6_FLOW = 28,
	GTPU_DL_V4_FLOW = 29,
	GTPU_DL_V6_FLOW = 30,
	__FLOW_TYPE_COUNT = 31,
};

enum {
	TCS4525_CHIP_ID_12 = 12,
};

enum {
	TCS4526_CHIP_ID_00 = 0,
};

enum {
	TC_MQPRIO_MODE_DCB = 0,
	TC_MQPRIO_MODE_CHANNEL = 1,
	__TC_MQPRIO_MODE_MAX = 2,
};

enum {
	TEST_NONE = 0,
	TEST_CORE = 1,
	TEST_CPUS = 2,
	TEST_PLATFORM = 3,
	TEST_DEVICES = 4,
	TEST_FREEZER = 5,
	__TEST_AFTER_LAST = 6,
};

enum {
	THRESHOLD_INDEX_0 = 0,
	THRESHOLD_INDEX_1 = 1,
	THRESHOLD_INDEX_COUNT = 2,
};

enum {
	THRESHOLD_INDEX_0___2 = 0,
	THRESHOLD_INDEX_1___2 = 1,
	THRESHOLD_INDEX_2 = 2,
	THRESHOLD_INDEX_3 = 3,
	THRESHOLD_INDEX_4 = 4,
	THRESHOLD_INDEX_5 = 5,
	THRESHOLD_INDEX_6 = 6,
	THRESHOLD_INDEX_7 = 7,
	THRESHOLD_INDEX_8 = 8,
	THRESHOLD_INDEX_9 = 9,
	THRESHOLD_INDEX_10 = 10,
	THRESHOLD_INDEX_11 = 11,
	THRESHOLD_INDEX_COUNT___2 = 12,
};

enum {
	TI_CLKM_CM = 0,
	TI_CLKM_CM2 = 1,
	TI_CLKM_PRM = 2,
	TI_CLKM_SCRM = 3,
	TI_CLKM_CTRL = 4,
	TI_CLKM_CTRL_AUX = 5,
	TI_CLKM_PLLSS = 6,
	CLK_MAX_MEMMAPS = 7,
};

enum {
	TI_CLK_FIXED = 0,
	TI_CLK_MUX = 1,
	TI_CLK_DIVIDER = 2,
	TI_CLK_COMPOSITE = 3,
	TI_CLK_FIXED_FACTOR = 4,
	TI_CLK_GATE = 5,
	TI_CLK_DPLL = 6,
};

enum {
	TLS_ALERT_DESC_CLOSE_NOTIFY = 0,
	TLS_ALERT_DESC_UNEXPECTED_MESSAGE = 10,
	TLS_ALERT_DESC_BAD_RECORD_MAC = 20,
	TLS_ALERT_DESC_RECORD_OVERFLOW = 22,
	TLS_ALERT_DESC_HANDSHAKE_FAILURE = 40,
	TLS_ALERT_DESC_BAD_CERTIFICATE = 42,
	TLS_ALERT_DESC_UNSUPPORTED_CERTIFICATE = 43,
	TLS_ALERT_DESC_CERTIFICATE_REVOKED = 44,
	TLS_ALERT_DESC_CERTIFICATE_EXPIRED = 45,
	TLS_ALERT_DESC_CERTIFICATE_UNKNOWN = 46,
	TLS_ALERT_DESC_ILLEGAL_PARAMETER = 47,
	TLS_ALERT_DESC_UNKNOWN_CA = 48,
	TLS_ALERT_DESC_ACCESS_DENIED = 49,
	TLS_ALERT_DESC_DECODE_ERROR = 50,
	TLS_ALERT_DESC_DECRYPT_ERROR = 51,
	TLS_ALERT_DESC_TOO_MANY_CIDS_REQUESTED = 52,
	TLS_ALERT_DESC_PROTOCOL_VERSION = 70,
	TLS_ALERT_DESC_INSUFFICIENT_SECURITY = 71,
	TLS_ALERT_DESC_INTERNAL_ERROR = 80,
	TLS_ALERT_DESC_INAPPROPRIATE_FALLBACK = 86,
	TLS_ALERT_DESC_USER_CANCELED = 90,
	TLS_ALERT_DESC_MISSING_EXTENSION = 109,
	TLS_ALERT_DESC_UNSUPPORTED_EXTENSION = 110,
	TLS_ALERT_DESC_UNRECOGNIZED_NAME = 112,
	TLS_ALERT_DESC_BAD_CERTIFICATE_STATUS_RESPONSE = 113,
	TLS_ALERT_DESC_UNKNOWN_PSK_IDENTITY = 115,
	TLS_ALERT_DESC_CERTIFICATE_REQUIRED = 116,
	TLS_ALERT_DESC_NO_APPLICATION_PROTOCOL = 120,
};

enum {
	TLS_ALERT_LEVEL_WARNING = 1,
	TLS_ALERT_LEVEL_FATAL = 2,
};

enum {
	TLS_NO_KEYRING = 0,
	TLS_NO_PEERID = 0,
	TLS_NO_CERT = 0,
	TLS_NO_PRIVKEY = 0,
};

enum {
	TLS_RECORD_TYPE_CHANGE_CIPHER_SPEC = 20,
	TLS_RECORD_TYPE_ALERT = 21,
	TLS_RECORD_TYPE_HANDSHAKE = 22,
	TLS_RECORD_TYPE_DATA = 23,
	TLS_RECORD_TYPE_HEARTBEAT = 24,
	TLS_RECORD_TYPE_TLS12_CID = 25,
	TLS_RECORD_TYPE_ACK = 26,
};

enum {
	TMF_INITIAL = 0,
	TMF_QUEUED = 1,
	TMF_SUCCESS = 2,
	TMF_FAILED = 3,
	TMF_TIMEDOUT = 4,
	TMF_NOT_FOUND = 5,
};

enum {
	TOKEN_END = 0,
	TOKEN_START = 1,
	TOKEN_SLAVE_ADDR_WRITE = 2,
	TOKEN_SLAVE_ADDR_READ = 3,
	TOKEN_DATA = 4,
	TOKEN_DATA_LAST = 5,
	TOKEN_STOP = 6,
};

enum {
	TPS65090_IRQ_INTERRUPT = 0,
	TPS65090_IRQ_VAC_STATUS_CHANGE = 1,
	TPS65090_IRQ_VSYS_STATUS_CHANGE = 2,
	TPS65090_IRQ_BAT_STATUS_CHANGE = 3,
	TPS65090_IRQ_CHARGING_STATUS_CHANGE = 4,
	TPS65090_IRQ_CHARGING_COMPLETE = 5,
	TPS65090_IRQ_OVERLOAD_DCDC1 = 6,
	TPS65090_IRQ_OVERLOAD_DCDC2 = 7,
	TPS65090_IRQ_OVERLOAD_DCDC3 = 8,
	TPS65090_IRQ_OVERLOAD_FET1 = 9,
	TPS65090_IRQ_OVERLOAD_FET2 = 10,
	TPS65090_IRQ_OVERLOAD_FET3 = 11,
	TPS65090_IRQ_OVERLOAD_FET4 = 12,
	TPS65090_IRQ_OVERLOAD_FET5 = 13,
	TPS65090_IRQ_OVERLOAD_FET6 = 14,
	TPS65090_IRQ_OVERLOAD_FET7 = 15,
};

enum {
	TPS65090_REGULATOR_DCDC1 = 0,
	TPS65090_REGULATOR_DCDC2 = 1,
	TPS65090_REGULATOR_DCDC3 = 2,
	TPS65090_REGULATOR_FET1 = 3,
	TPS65090_REGULATOR_FET2 = 4,
	TPS65090_REGULATOR_FET3 = 5,
	TPS65090_REGULATOR_FET4 = 6,
	TPS65090_REGULATOR_FET5 = 7,
	TPS65090_REGULATOR_FET6 = 8,
	TPS65090_REGULATOR_FET7 = 9,
	TPS65090_REGULATOR_LDO1 = 10,
	TPS65090_REGULATOR_LDO2 = 11,
	TPS65090_REGULATOR_MAX = 12,
};

enum {
	TPS6586X_ID_SYS = 0,
	TPS6586X_ID_SM_0 = 1,
	TPS6586X_ID_SM_1 = 2,
	TPS6586X_ID_SM_2 = 3,
	TPS6586X_ID_LDO_0 = 4,
	TPS6586X_ID_LDO_1 = 5,
	TPS6586X_ID_LDO_2 = 6,
	TPS6586X_ID_LDO_3 = 7,
	TPS6586X_ID_LDO_4 = 8,
	TPS6586X_ID_LDO_5 = 9,
	TPS6586X_ID_LDO_6 = 10,
	TPS6586X_ID_LDO_7 = 11,
	TPS6586X_ID_LDO_8 = 12,
	TPS6586X_ID_LDO_9 = 13,
	TPS6586X_ID_LDO_RTC = 14,
	TPS6586X_ID_MAX_REGULATOR = 15,
};

enum {
	TPS6586X_INT_PLDO_0 = 0,
	TPS6586X_INT_PLDO_1 = 1,
	TPS6586X_INT_PLDO_2 = 2,
	TPS6586X_INT_PLDO_3 = 3,
	TPS6586X_INT_PLDO_4 = 4,
	TPS6586X_INT_PLDO_5 = 5,
	TPS6586X_INT_PLDO_6 = 6,
	TPS6586X_INT_PLDO_7 = 7,
	TPS6586X_INT_COMP_DET = 8,
	TPS6586X_INT_ADC = 9,
	TPS6586X_INT_PLDO_8 = 10,
	TPS6586X_INT_PLDO_9 = 11,
	TPS6586X_INT_PSM_0 = 12,
	TPS6586X_INT_PSM_1 = 13,
	TPS6586X_INT_PSM_2 = 14,
	TPS6586X_INT_PSM_3 = 15,
	TPS6586X_INT_RTC_ALM1 = 16,
	TPS6586X_INT_ACUSB_OVP = 17,
	TPS6586X_INT_USB_DET = 18,
	TPS6586X_INT_AC_DET = 19,
	TPS6586X_INT_BAT_DET = 20,
	TPS6586X_INT_CHG_STAT = 21,
	TPS6586X_INT_CHG_TEMP = 22,
	TPS6586X_INT_PP = 23,
	TPS6586X_INT_RESUME = 24,
	TPS6586X_INT_LOW_SYS = 25,
	TPS6586X_INT_RTC_ALM2 = 26,
};

enum {
	TRACE_EVENT_FL_CAP_ANY_BIT = 0,
	TRACE_EVENT_FL_NO_SET_FILTER_BIT = 1,
	TRACE_EVENT_FL_IGNORE_ENABLE_BIT = 2,
	TRACE_EVENT_FL_TRACEPOINT_BIT = 3,
	TRACE_EVENT_FL_DYNAMIC_BIT = 4,
	TRACE_EVENT_FL_KPROBE_BIT = 5,
	TRACE_EVENT_FL_UPROBE_BIT = 6,
	TRACE_EVENT_FL_EPROBE_BIT = 7,
	TRACE_EVENT_FL_FPROBE_BIT = 8,
	TRACE_EVENT_FL_CUSTOM_BIT = 9,
	TRACE_EVENT_FL_TEST_STR_BIT = 10,
};

enum {
	TRACE_SIGNAL_DELIVERED = 0,
	TRACE_SIGNAL_IGNORED = 1,
	TRACE_SIGNAL_ALREADY_PENDING = 2,
	TRACE_SIGNAL_OVERFLOW_FAIL = 3,
	TRACE_SIGNAL_LOSE_INFO = 4,
};

enum {
	TRANS_MODE_PIO = 0,
	TRANS_MODE_IDMAC = 1,
	TRANS_MODE_EDMAC = 2,
};

enum {
	TWL_REMAP_OFF = 0,
	TWL_REMAP_SLEEP = 8,
	TWL_REMAP_ACTIVE = 9,
};

enum {
	TYPEC_MODE_USB2 = 2,
	TYPEC_MODE_USB3 = 3,
	TYPEC_MODE_USB4 = 4,
	TYPEC_MODE_AUDIO = 5,
	TYPEC_MODE_DEBUG = 6,
};

enum {
	TYPEC_STATE_SAFE = 0,
	TYPEC_STATE_USB = 1,
	TYPEC_STATE_MODAL = 2,
};

enum {
	TYPE_MAX8998 = 0,
	TYPE_LP3974 = 1,
	TYPE_LP3979 = 2,
};

enum {
	UBIFS_COMPR_FL = 1,
	UBIFS_SYNC_FL = 2,
	UBIFS_IMMUTABLE_FL = 4,
	UBIFS_APPEND_FL = 8,
	UBIFS_DIRSYNC_FL = 16,
	UBIFS_XATTR_FL = 32,
	UBIFS_CRYPT_FL = 64,
};

enum {
	UBIFS_COMPR_NONE = 0,
	UBIFS_COMPR_LZO = 1,
	UBIFS_COMPR_ZLIB = 2,
	UBIFS_COMPR_ZSTD = 3,
	UBIFS_COMPR_TYPES_CNT = 4,
};

enum {
	UBIFS_FLG_BIGLPT = 2,
	UBIFS_FLG_SPACE_FIXUP = 4,
	UBIFS_FLG_DOUBLE_HASH = 8,
	UBIFS_FLG_ENCRYPTION = 16,
	UBIFS_FLG_AUTHENTICATION = 32,
};

enum {
	UBIFS_INO_KEY = 0,
	UBIFS_DATA_KEY = 1,
	UBIFS_DENT_KEY = 2,
	UBIFS_XENT_KEY = 3,
	UBIFS_KEY_TYPES_CNT = 4,
};

enum {
	UBIFS_INO_NODE = 0,
	UBIFS_DATA_NODE = 1,
	UBIFS_DENT_NODE = 2,
	UBIFS_XENT_NODE = 3,
	UBIFS_TRUN_NODE = 4,
	UBIFS_PAD_NODE = 5,
	UBIFS_SB_NODE = 6,
	UBIFS_MST_NODE = 7,
	UBIFS_REF_NODE = 8,
	UBIFS_IDX_NODE = 9,
	UBIFS_CS_NODE = 10,
	UBIFS_ORPH_NODE = 11,
	UBIFS_AUTH_NODE = 12,
	UBIFS_SIG_NODE = 13,
	UBIFS_NODE_TYPES_CNT = 14,
};

enum {
	UBIFS_ITYPE_REG = 0,
	UBIFS_ITYPE_DIR = 1,
	UBIFS_ITYPE_LNK = 2,
	UBIFS_ITYPE_BLK = 3,
	UBIFS_ITYPE_CHR = 4,
	UBIFS_ITYPE_FIFO = 5,
	UBIFS_ITYPE_SOCK = 6,
	UBIFS_ITYPES_CNT = 7,
};

enum {
	UBIFS_KEY_HASH_R5 = 0,
	UBIFS_KEY_HASH_TEST = 1,
};

enum {
	UBIFS_LPT_PNODE = 0,
	UBIFS_LPT_NNODE = 1,
	UBIFS_LPT_LTAB = 2,
	UBIFS_LPT_LSAVE = 3,
	UBIFS_LPT_NODE_CNT = 4,
	UBIFS_LPT_NOT_A_NODE = 15,
};

enum {
	UBIFS_MST_DIRTY = 1,
	UBIFS_MST_NO_ORPHS = 2,
	UBIFS_MST_RCVRY = 4,
};

enum {
	UBIFS_NO_NODE_GROUP = 0,
	UBIFS_IN_NODE_GROUP = 1,
	UBIFS_LAST_OF_NODE_GROUP = 2,
};

enum {
	UBIFS_SIMPLE_KEY_FMT = 0,
};

enum {
	UBI_COMPAT_DELETE = 1,
	UBI_COMPAT_RO = 2,
	UBI_COMPAT_PRESERVE = 4,
	UBI_COMPAT_REJECT = 5,
};

enum {
	UBI_DYNAMIC_VOLUME = 3,
	UBI_STATIC_VOLUME = 4,
};

enum {
	UBI_IO_FF = 1,
	UBI_IO_FF_BITFLIPS = 2,
	UBI_IO_BAD_HDR = 3,
	UBI_IO_BAD_HDR_EBADMSG = 4,
	UBI_IO_BITFLIPS = 5,
};

enum {
	UBI_READONLY = 1,
	UBI_READWRITE = 2,
	UBI_EXCLUSIVE = 3,
	UBI_METAONLY = 4,
};

enum {
	UBI_VID_DYNAMIC = 1,
	UBI_VID_STATIC = 2,
};

enum {
	UBI_VOLUME_ADDED = 0,
	UBI_VOLUME_REMOVED = 1,
	UBI_VOLUME_RESIZED = 2,
	UBI_VOLUME_RENAMED = 3,
	UBI_VOLUME_SHUTDOWN = 4,
	UBI_VOLUME_UPDATED = 5,
};

enum {
	UBI_VOL_PROP_DIRECT_WRITE = 1,
};

enum {
	UBI_VOL_SKIP_CRC_CHECK_FLG = 1,
};

enum {
	UBI_VTBL_AUTORESIZE_FLG = 1,
	UBI_VTBL_SKIP_CRC_CHECK_FLG = 2,
};

enum {
	UDP_BPF_IPV4 = 0,
	UDP_BPF_IPV6 = 1,
	UDP_BPF_NUM_PROTS = 2,
};

enum {
	UDP_FLAGS_CORK = 0,
	UDP_FLAGS_NO_CHECK6_TX = 1,
	UDP_FLAGS_NO_CHECK6_RX = 2,
	UDP_FLAGS_GRO_ENABLED = 3,
	UDP_FLAGS_ACCEPT_FRAGLIST = 4,
	UDP_FLAGS_ACCEPT_L4 = 5,
	UDP_FLAGS_ENCAP_ENABLED = 6,
	UDP_FLAGS_UDPLITE_SEND_CC = 7,
	UDP_FLAGS_UDPLITE_RECV_CC = 8,
};

enum {
	UDP_MIB_NUM = 0,
	UDP_MIB_INDATAGRAMS = 1,
	UDP_MIB_NOPORTS = 2,
	UDP_MIB_INERRORS = 3,
	UDP_MIB_OUTDATAGRAMS = 4,
	UDP_MIB_RCVBUFERRORS = 5,
	UDP_MIB_SNDBUFERRORS = 6,
	UDP_MIB_CSUMERRORS = 7,
	UDP_MIB_IGNOREDMULTI = 8,
	UDP_MIB_MEMERRORS = 9,
	__UDP_MIB_MAX = 10,
};

enum {
	UNAME26 = 131072,
	ADDR_NO_RANDOMIZE = 262144,
	FDPIC_FUNCPTRS = 524288,
	MMAP_PAGE_ZERO = 1048576,
	ADDR_COMPAT_LAYOUT = 2097152,
	READ_IMPLIES_EXEC = 4194304,
	ADDR_LIMIT_32BIT = 8388608,
	SHORT_INODE = 16777216,
	WHOLE_SECONDS = 33554432,
	STICKY_TIMEOUTS = 67108864,
	ADDR_LIMIT_3GB = 134217728,
};

enum {
	US_FL_SINGLE_LUN = 1,
	US_FL_NEED_OVERRIDE = 2,
	US_FL_SCM_MULT_TARG = 4,
	US_FL_FIX_INQUIRY = 8,
	US_FL_FIX_CAPACITY = 16,
	US_FL_IGNORE_RESIDUE = 32,
	US_FL_BULK32 = 64,
	US_FL_NOT_LOCKABLE = 128,
	US_FL_GO_SLOW = 256,
	US_FL_NO_WP_DETECT = 512,
	US_FL_MAX_SECTORS_64 = 1024,
	US_FL_IGNORE_DEVICE = 2048,
	US_FL_CAPACITY_HEURISTICS = 4096,
	US_FL_MAX_SECTORS_MIN = 8192,
	US_FL_BULK_IGNORE_TAG = 16384,
	US_FL_SANE_SENSE = 32768,
	US_FL_CAPACITY_OK = 65536,
	US_FL_BAD_SENSE = 131072,
	US_FL_NO_READ_DISC_INFO = 262144,
	US_FL_NO_READ_CAPACITY_16 = 524288,
	US_FL_INITIAL_READ10 = 1048576,
	US_FL_WRITE_CACHE = 2097152,
	US_FL_NEEDS_CAP16 = 4194304,
	US_FL_IGNORE_UAS = 8388608,
	US_FL_BROKEN_FUA = 16777216,
	US_FL_NO_ATA_1X = 33554432,
	US_FL_NO_REPORT_OPCODES = 67108864,
	US_FL_MAX_SECTORS_240 = 134217728,
	US_FL_NO_REPORT_LUNS = 268435456,
	US_FL_ALWAYS_SYNC = 536870912,
	US_FL_NO_SAME = 1073741824,
	US_FL_SENSE_AFTER_SYNC = 2147483648,
};

enum {
	VCHIQ_POLL_TERMINATE = 0,
	VCHIQ_POLL_REMOVE = 1,
	VCHIQ_POLL_TXNOTIFY = 2,
	VCHIQ_POLL_RXNOTIFY = 3,
	VCHIQ_POLL_COUNT = 4,
};

enum {
	VCHIQ_SRVSTATE_FREE = 0,
	VCHIQ_SRVSTATE_HIDDEN = 1,
	VCHIQ_SRVSTATE_LISTENING = 2,
	VCHIQ_SRVSTATE_OPENING = 3,
	VCHIQ_SRVSTATE_OPEN = 4,
	VCHIQ_SRVSTATE_OPENSYNC = 5,
	VCHIQ_SRVSTATE_CLOSESENT = 6,
	VCHIQ_SRVSTATE_CLOSERECVD = 7,
	VCHIQ_SRVSTATE_CLOSEWAIT = 8,
	VCHIQ_SRVSTATE_CLOSED = 9,
};

enum {
	VIDEO_INPUT_12BITS = 0,
	VIDEO_INPUT_10BITS = 1,
	VIDEO_INPUT_REVERT = 2,
	VIDEO_INPUT_8BITS = 3,
};

enum {
	VIDEO_INPUT_SDR_RGB444 = 0,
	VIDEO_INPUT_DDR_RGB444 = 5,
	VIDEO_INPUT_DDR_YCBCR422 = 6,
};

enum {
	VP_MSIX_CONFIG_VECTOR = 0,
	VP_MSIX_VQ_VECTOR = 1,
};

enum {
	VTIME_PER_SEC_SHIFT = 37ULL,
	VTIME_PER_SEC = 137438953472ULL,
	VTIME_PER_USEC = 137438ULL,
	VTIME_PER_NSEC = 137ULL,
	VRATE_MIN_PPM = 10000ULL,
	VRATE_MAX_PPM = 100000000ULL,
	VRATE_MIN = 1374ULL,
	VRATE_CLAMP_ADJ_PCT = 4ULL,
	AUTOP_CYCLE_NSEC = 10000000000ULL,
};

enum {
	V_88F6810 = 1,
	V_88F6820 = 2,
	V_88F6828 = 4,
	V_88F6810_PLUS = 7,
	V_88F6820_PLUS = 6,
};

enum {
	V_88F6920 = 1,
	V_88F6925 = 2,
	V_88F6928 = 4,
	V_88F6920_PLUS = 7,
	V_88F6925_PLUS = 6,
};

enum {
	WALK_TRAILING = 1,
	WALK_MORE = 2,
	WALK_NOFOLLOW = 4,
};

enum {
	WBT_RWQ_BG = 0,
	WBT_RWQ_SWAP = 1,
	WBT_RWQ_DISCARD = 2,
	WBT_NUM_RWQ = 3,
};

enum {
	WBT_STATE_ON_DEFAULT = 1,
	WBT_STATE_ON_MANUAL = 2,
	WBT_STATE_OFF_DEFAULT = 3,
	WBT_STATE_OFF_MANUAL = 4,
};

enum {
	WORK_DONE_BIT = 0,
	WORK_ORDER_DONE_BIT = 1,
};

enum {
	XA_CHECK_SCHED = 4096,
};

enum {
	XDP_ATTACHED_NONE = 0,
	XDP_ATTACHED_DRV = 1,
	XDP_ATTACHED_SKB = 2,
	XDP_ATTACHED_HW = 3,
	XDP_ATTACHED_MULTI = 4,
};

enum {
	XFRM_DEV_OFFLOAD_FLAG_ACQ = 1,
};

enum {
	XFRM_DEV_OFFLOAD_IN = 1,
	XFRM_DEV_OFFLOAD_OUT = 2,
	XFRM_DEV_OFFLOAD_FWD = 3,
};

enum {
	XFRM_DEV_OFFLOAD_UNSPECIFIED = 0,
	XFRM_DEV_OFFLOAD_CRYPTO = 1,
	XFRM_DEV_OFFLOAD_PACKET = 2,
};

enum {
	XFRM_LOOKUP_ICMP = 1,
	XFRM_LOOKUP_QUEUE = 2,
	XFRM_LOOKUP_KEEP_DST_REF = 4,
};

enum {
	XFRM_MODE_FLAG_TUNNEL = 1,
};

enum {
	XFRM_MSG_BASE = 16,
	XFRM_MSG_NEWSA = 16,
	XFRM_MSG_DELSA = 17,
	XFRM_MSG_GETSA = 18,
	XFRM_MSG_NEWPOLICY = 19,
	XFRM_MSG_DELPOLICY = 20,
	XFRM_MSG_GETPOLICY = 21,
	XFRM_MSG_ALLOCSPI = 22,
	XFRM_MSG_ACQUIRE = 23,
	XFRM_MSG_EXPIRE = 24,
	XFRM_MSG_UPDPOLICY = 25,
	XFRM_MSG_UPDSA = 26,
	XFRM_MSG_POLEXPIRE = 27,
	XFRM_MSG_FLUSHSA = 28,
	XFRM_MSG_FLUSHPOLICY = 29,
	XFRM_MSG_NEWAE = 30,
	XFRM_MSG_GETAE = 31,
	XFRM_MSG_REPORT = 32,
	XFRM_MSG_MIGRATE = 33,
	XFRM_MSG_NEWSADINFO = 34,
	XFRM_MSG_GETSADINFO = 35,
	XFRM_MSG_NEWSPDINFO = 36,
	XFRM_MSG_GETSPDINFO = 37,
	XFRM_MSG_MAPPING = 38,
	XFRM_MSG_SETDEFAULT = 39,
	XFRM_MSG_GETDEFAULT = 40,
	__XFRM_MSG_MAX = 41,
};

enum {
	XFRM_POLICY_IN = 0,
	XFRM_POLICY_OUT = 1,
	XFRM_POLICY_FWD = 2,
	XFRM_POLICY_MASK = 3,
	XFRM_POLICY_MAX = 3,
};

enum {
	XFRM_POLICY_TYPE_MAIN = 0,
	XFRM_POLICY_TYPE_SUB = 1,
	XFRM_POLICY_TYPE_MAX = 2,
	XFRM_POLICY_TYPE_ANY = 255,
};

enum {
	XFRM_STATE_VOID = 0,
	XFRM_STATE_ACQ = 1,
	XFRM_STATE_VALID = 2,
	XFRM_STATE_ERROR = 3,
	XFRM_STATE_EXPIRED = 4,
	XFRM_STATE_DEAD = 5,
};

enum {
	XPT_BUSY = 0,
	XPT_CONN = 1,
	XPT_CLOSE = 2,
	XPT_DATA = 3,
	XPT_TEMP = 4,
	XPT_DEAD = 5,
	XPT_CHNGBUF = 6,
	XPT_DEFERRED = 7,
	XPT_OLD = 8,
	XPT_LISTENER = 9,
	XPT_CACHE_AUTH = 10,
	XPT_LOCAL = 11,
	XPT_KILL_TEMP = 12,
	XPT_CONG_CTRL = 13,
	XPT_HANDSHAKE = 14,
	XPT_TLS_SESSION = 15,
	XPT_PEER_AUTH = 16,
	XPT_PEER_VALID = 17,
};

enum {
	ZONELIST_FALLBACK = 0,
	MAX_ZONELISTS = 1,
};

enum {
	ZSTDbss_compress = 0,
	ZSTDbss_noCompress = 1,
};

enum {
	_DQUOT_USAGE_ENABLED = 0,
	_DQUOT_LIMITS_ENABLED = 1,
	_DQUOT_SUSPENDED = 2,
	_DQUOT_STATE_FLAGS = 3,
};

enum {
	_IRQ_DEFAULT_INIT_FLAGS = 3072,
	_IRQ_PER_CPU = 512,
	_IRQ_LEVEL = 256,
	_IRQ_NOPROBE = 1024,
	_IRQ_NOREQUEST = 2048,
	_IRQ_NOTHREAD = 65536,
	_IRQ_NOAUTOEN = 4096,
	_IRQ_NO_BALANCING = 8192,
	_IRQ_NESTED_THREAD = 32768,
	_IRQ_PER_CPU_DEVID = 131072,
	_IRQ_IS_POLLED = 262144,
	_IRQ_DISABLE_UNLAZY = 524288,
	_IRQ_HIDDEN = 1048576,
	_IRQ_NO_DEBUG = 2097152,
	_IRQF_MODIFY_MASK = 2080527,
};

enum {
	__EXTENT_DIRTY_BIT = 0,
	EXTENT_DIRTY = 1,
	__EXTENT_DIRTY_SEQ = 0,
	__EXTENT_LOCKED_BIT = 1,
	EXTENT_LOCKED = 2,
	__EXTENT_LOCKED_SEQ = 1,
	__EXTENT_DIO_LOCKED_BIT = 2,
	EXTENT_DIO_LOCKED = 4,
	__EXTENT_DIO_LOCKED_SEQ = 2,
	__EXTENT_NEW_BIT = 3,
	EXTENT_NEW = 8,
	__EXTENT_NEW_SEQ = 3,
	__EXTENT_DELALLOC_BIT = 4,
	EXTENT_DELALLOC = 16,
	__EXTENT_DELALLOC_SEQ = 4,
	__EXTENT_DEFRAG_BIT = 5,
	EXTENT_DEFRAG = 32,
	__EXTENT_DEFRAG_SEQ = 5,
	__EXTENT_BOUNDARY_BIT = 6,
	EXTENT_BOUNDARY = 64,
	__EXTENT_BOUNDARY_SEQ = 6,
	__EXTENT_NODATASUM_BIT = 7,
	EXTENT_NODATASUM = 128,
	__EXTENT_NODATASUM_SEQ = 7,
	__EXTENT_CLEAR_META_RESV_BIT = 8,
	EXTENT_CLEAR_META_RESV = 256,
	__EXTENT_CLEAR_META_RESV_SEQ = 8,
	__EXTENT_NEED_WAIT_BIT = 9,
	EXTENT_NEED_WAIT = 512,
	__EXTENT_NEED_WAIT_SEQ = 9,
	__EXTENT_NORESERVE_BIT = 10,
	EXTENT_NORESERVE = 1024,
	__EXTENT_NORESERVE_SEQ = 10,
	__EXTENT_QGROUP_RESERVED_BIT = 11,
	EXTENT_QGROUP_RESERVED = 2048,
	__EXTENT_QGROUP_RESERVED_SEQ = 11,
	__EXTENT_CLEAR_DATA_RESV_BIT = 12,
	EXTENT_CLEAR_DATA_RESV = 4096,
	__EXTENT_CLEAR_DATA_RESV_SEQ = 12,
	__EXTENT_DELALLOC_NEW_BIT = 13,
	EXTENT_DELALLOC_NEW = 8192,
	__EXTENT_DELALLOC_NEW_SEQ = 13,
	__EXTENT_FINISHING_ORDERED_BIT = 14,
	EXTENT_FINISHING_ORDERED = 16384,
	__EXTENT_FINISHING_ORDERED_SEQ = 14,
	__EXTENT_ADD_INODE_BYTES_BIT = 15,
	EXTENT_ADD_INODE_BYTES = 32768,
	__EXTENT_ADD_INODE_BYTES_SEQ = 15,
	__EXTENT_CLEAR_ALL_BITS_BIT = 16,
	EXTENT_CLEAR_ALL_BITS = 65536,
	__EXTENT_CLEAR_ALL_BITS_SEQ = 16,
	__EXTENT_NOWAIT_BIT = 17,
	EXTENT_NOWAIT = 131072,
	__EXTENT_NOWAIT_SEQ = 17,
};

enum {
	__EXTENT_FLAG_PINNED_BIT = 0,
	EXTENT_FLAG_PINNED = 1,
	__EXTENT_FLAG_PINNED_SEQ = 0,
	__EXTENT_FLAG_COMPRESS_ZLIB_BIT = 1,
	EXTENT_FLAG_COMPRESS_ZLIB = 2,
	__EXTENT_FLAG_COMPRESS_ZLIB_SEQ = 1,
	__EXTENT_FLAG_COMPRESS_LZO_BIT = 2,
	EXTENT_FLAG_COMPRESS_LZO = 4,
	__EXTENT_FLAG_COMPRESS_LZO_SEQ = 2,
	__EXTENT_FLAG_COMPRESS_ZSTD_BIT = 3,
	EXTENT_FLAG_COMPRESS_ZSTD = 8,
	__EXTENT_FLAG_COMPRESS_ZSTD_SEQ = 3,
	__EXTENT_FLAG_PREALLOC_BIT = 4,
	EXTENT_FLAG_PREALLOC = 16,
	__EXTENT_FLAG_PREALLOC_SEQ = 4,
	__EXTENT_FLAG_LOGGING_BIT = 5,
	EXTENT_FLAG_LOGGING = 32,
	__EXTENT_FLAG_LOGGING_SEQ = 5,
	__EXTENT_FLAG_MERGED_BIT = 6,
	EXTENT_FLAG_MERGED = 64,
	__EXTENT_FLAG_MERGED_SEQ = 6,
};

enum {
	__ND_OPT_PREFIX_INFO_END = 0,
	ND_OPT_SOURCE_LL_ADDR = 1,
	ND_OPT_TARGET_LL_ADDR = 2,
	ND_OPT_PREFIX_INFO = 3,
	ND_OPT_REDIRECT_HDR = 4,
	ND_OPT_MTU = 5,
	ND_OPT_NONCE = 14,
	__ND_OPT_ARRAY_MAX = 15,
	ND_OPT_ROUTE_INFO = 24,
	ND_OPT_RDNSS = 25,
	ND_OPT_DNSSL = 31,
	ND_OPT_6CO = 34,
	ND_OPT_CAPTIVE_PORTAL = 37,
	ND_OPT_PREF64 = 38,
	__ND_OPT_MAX = 39,
};

enum {
	__PAGE_UNLOCK_BIT = 0,
	PAGE_UNLOCK = 1,
	__PAGE_UNLOCK_SEQ = 0,
	__PAGE_START_WRITEBACK_BIT = 1,
	PAGE_START_WRITEBACK = 2,
	__PAGE_START_WRITEBACK_SEQ = 1,
	__PAGE_END_WRITEBACK_BIT = 2,
	PAGE_END_WRITEBACK = 4,
	__PAGE_END_WRITEBACK_SEQ = 2,
	__PAGE_SET_ORDERED_BIT = 3,
	PAGE_SET_ORDERED = 8,
	__PAGE_SET_ORDERED_SEQ = 3,
};

enum {
	__PERCPU_REF_ATOMIC = 1,
	__PERCPU_REF_DEAD = 2,
	__PERCPU_REF_ATOMIC_DEAD = 3,
	__PERCPU_REF_FLAG_BITS = 2,
};

enum {
	__QGROUP_RESERVE_BIT = 0,
	QGROUP_RESERVE = 1,
	__QGROUP_RESERVE_SEQ = 0,
	__QGROUP_RELEASE_BIT = 1,
	QGROUP_RELEASE = 2,
	__QGROUP_RELEASE_SEQ = 1,
	__QGROUP_FREE_BIT = 2,
	QGROUP_FREE = 4,
	__QGROUP_FREE_SEQ = 2,
};

enum {
	__SCHED_FEAT_PLACE_LAG = 0,
	__SCHED_FEAT_PLACE_DEADLINE_INITIAL = 1,
	__SCHED_FEAT_PLACE_REL_DEADLINE = 2,
	__SCHED_FEAT_RUN_TO_PARITY = 3,
	__SCHED_FEAT_PREEMPT_SHORT = 4,
	__SCHED_FEAT_NEXT_BUDDY = 5,
	__SCHED_FEAT_PICK_BUDDY = 6,
	__SCHED_FEAT_CACHE_HOT_BUDDY = 7,
	__SCHED_FEAT_DELAY_DEQUEUE = 8,
	__SCHED_FEAT_DELAY_ZERO = 9,
	__SCHED_FEAT_WAKEUP_PREEMPTION = 10,
	__SCHED_FEAT_HRTICK = 11,
	__SCHED_FEAT_HRTICK_DL = 12,
	__SCHED_FEAT_NONTASK_CAPACITY = 13,
	__SCHED_FEAT_TTWU_QUEUE = 14,
	__SCHED_FEAT_SIS_UTIL = 15,
	__SCHED_FEAT_WARN_DOUBLE_CLOCK = 16,
	__SCHED_FEAT_RT_PUSH_IPI = 17,
	__SCHED_FEAT_RT_RUNTIME_SHARE = 18,
	__SCHED_FEAT_LB_MIN = 19,
	__SCHED_FEAT_ATTACH_AGE_LOAD = 20,
	__SCHED_FEAT_WA_IDLE = 21,
	__SCHED_FEAT_WA_WEIGHT = 22,
	__SCHED_FEAT_WA_BIAS = 23,
	__SCHED_FEAT_UTIL_EST = 24,
	__SCHED_FEAT_LATENCY_WARN = 25,
	__SCHED_FEAT_NR = 26,
};

enum {
	__SD_BALANCE_NEWIDLE = 0,
	__SD_BALANCE_EXEC = 1,
	__SD_BALANCE_FORK = 2,
	__SD_BALANCE_WAKE = 3,
	__SD_WAKE_AFFINE = 4,
	__SD_ASYM_CPUCAPACITY = 5,
	__SD_ASYM_CPUCAPACITY_FULL = 6,
	__SD_SHARE_CPUCAPACITY = 7,
	__SD_CLUSTER = 8,
	__SD_SHARE_LLC = 9,
	__SD_SERIALIZE = 10,
	__SD_ASYM_PACKING = 11,
	__SD_PREFER_SIBLING = 12,
	__SD_OVERLAP = 13,
	__SD_NUMA = 14,
	__SD_FLAG_CNT = 15,
};

enum {
	__SPECTRE_V2_METHOD_BPIALL = 0,
	__SPECTRE_V2_METHOD_ICIALLU = 1,
	__SPECTRE_V2_METHOD_SMC = 2,
	__SPECTRE_V2_METHOD_HVC = 3,
	__SPECTRE_V2_METHOD_LOOP8 = 4,
};

enum {
	___GFP_DMA_BIT = 0,
	___GFP_HIGHMEM_BIT = 1,
	___GFP_DMA32_BIT = 2,
	___GFP_MOVABLE_BIT = 3,
	___GFP_RECLAIMABLE_BIT = 4,
	___GFP_HIGH_BIT = 5,
	___GFP_IO_BIT = 6,
	___GFP_FS_BIT = 7,
	___GFP_ZERO_BIT = 8,
	___GFP_UNUSED_BIT = 9,
	___GFP_DIRECT_RECLAIM_BIT = 10,
	___GFP_KSWAPD_RECLAIM_BIT = 11,
	___GFP_WRITE_BIT = 12,
	___GFP_NOWARN_BIT = 13,
	___GFP_RETRY_MAYFAIL_BIT = 14,
	___GFP_NOFAIL_BIT = 15,
	___GFP_NORETRY_BIT = 16,
	___GFP_MEMALLOC_BIT = 17,
	___GFP_COMP_BIT = 18,
	___GFP_NOMEMALLOC_BIT = 19,
	___GFP_HARDWALL_BIT = 20,
	___GFP_THISNODE_BIT = 21,
	___GFP_ACCOUNT_BIT = 22,
	___GFP_ZEROTAGS_BIT = 23,
	___GFP_NO_OBJ_EXT_BIT = 24,
	___GFP_LAST_BIT = 25,
};

enum {
	____TRANS_FREEZABLE_BIT = 0,
	__TRANS_FREEZABLE = 1,
	____TRANS_FREEZABLE_SEQ = 0,
	____TRANS_START_BIT = 1,
	__TRANS_START = 2,
	____TRANS_START_SEQ = 1,
	____TRANS_ATTACH_BIT = 2,
	__TRANS_ATTACH = 4,
	____TRANS_ATTACH_SEQ = 2,
	____TRANS_JOIN_BIT = 3,
	__TRANS_JOIN = 8,
	____TRANS_JOIN_SEQ = 3,
	____TRANS_JOIN_NOLOCK_BIT = 4,
	__TRANS_JOIN_NOLOCK = 16,
	____TRANS_JOIN_NOLOCK_SEQ = 4,
	____TRANS_DUMMY_BIT = 5,
	__TRANS_DUMMY = 32,
	____TRANS_DUMMY_SEQ = 5,
	____TRANS_JOIN_NOSTART_BIT = 6,
	__TRANS_JOIN_NOSTART = 64,
	____TRANS_JOIN_NOSTART_SEQ = 6,
};

enum {
	__ctx_convertBPF_PROG_TYPE_SOCKET_FILTER = 0,
	__ctx_convertBPF_PROG_TYPE_SCHED_CLS = 1,
	__ctx_convertBPF_PROG_TYPE_SCHED_ACT = 2,
	__ctx_convertBPF_PROG_TYPE_XDP = 3,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SKB = 4,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK = 5,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCK_ADDR = 6,
	__ctx_convertBPF_PROG_TYPE_LWT_IN = 7,
	__ctx_convertBPF_PROG_TYPE_LWT_OUT = 8,
	__ctx_convertBPF_PROG_TYPE_LWT_XMIT = 9,
	__ctx_convertBPF_PROG_TYPE_LWT_SEG6LOCAL = 10,
	__ctx_convertBPF_PROG_TYPE_SOCK_OPS = 11,
	__ctx_convertBPF_PROG_TYPE_SK_SKB = 12,
	__ctx_convertBPF_PROG_TYPE_SK_MSG = 13,
	__ctx_convertBPF_PROG_TYPE_FLOW_DISSECTOR = 14,
	__ctx_convertBPF_PROG_TYPE_CGROUP_DEVICE = 15,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SYSCTL = 16,
	__ctx_convertBPF_PROG_TYPE_CGROUP_SOCKOPT = 17,
	__ctx_convertBPF_PROG_TYPE_SK_REUSEPORT = 18,
	__ctx_convertBPF_PROG_TYPE_SK_LOOKUP = 19,
	__ctx_convertBPF_PROG_TYPE_STRUCT_OPS = 20,
	__ctx_convertBPF_PROG_TYPE_EXT = 21,
	__ctx_convertBPF_PROG_TYPE_SYSCALL = 22,
	__ctx_convertBPF_PROG_TYPE_NETFILTER = 23,
	__ctx_convert_unused = 24,
};

enum {
	attr_noop = 0,
	attr_delayed_allocation_blocks = 1,
	attr_session_write_kbytes = 2,
	attr_lifetime_write_kbytes = 3,
	attr_reserved_clusters = 4,
	attr_sra_exceeded_retry_limit = 5,
	attr_inode_readahead = 6,
	attr_trigger_test_error = 7,
	attr_first_error_time = 8,
	attr_last_error_time = 9,
	attr_clusters_in_group = 10,
	attr_mb_order = 11,
	attr_feature = 12,
	attr_pointer_pi = 13,
	attr_pointer_ui = 14,
	attr_pointer_ul = 15,
	attr_pointer_u64 = 16,
	attr_pointer_u8 = 17,
	attr_pointer_string = 18,
	attr_pointer_atomic = 19,
	attr_journal_task = 20,
};

enum {
	blank_off = 0,
	blank_normal_wait = 1,
	blank_vesa_wait = 2,
};

enum {
	btrfs_bitmap_nr_uptodate = 0,
	btrfs_bitmap_nr_dirty = 1,
	btrfs_bitmap_nr_writeback = 2,
	btrfs_bitmap_nr_ordered = 3,
	btrfs_bitmap_nr_checked = 4,
	btrfs_bitmap_nr_locked = 5,
	btrfs_bitmap_nr_max = 6,
};

enum {
	cpuset = 0,
	possible = 1,
	fail = 2,
};

enum {
	dns_key_data = 0,
	dns_key_error = 1,
};

enum {
	false = 0,
	true = 1,
};

enum {
	mechtype_caddy = 0,
	mechtype_tray = 1,
	mechtype_popup = 2,
	mechtype_individual_changer = 4,
	mechtype_cartridge_changer = 5,
};

enum {
	ncsi_dev_state_major = 65280,
	ncsi_dev_state_minor = 255,
	ncsi_dev_state_probe_deselect = 513,
	ncsi_dev_state_probe_package = 514,
	ncsi_dev_state_probe_channel = 515,
	ncsi_dev_state_probe_mlx_gma = 516,
	ncsi_dev_state_probe_mlx_smaf = 517,
	ncsi_dev_state_probe_cis = 518,
	ncsi_dev_state_probe_keep_phy = 519,
	ncsi_dev_state_probe_gvi = 520,
	ncsi_dev_state_probe_gc = 521,
	ncsi_dev_state_probe_gls = 522,
	ncsi_dev_state_probe_dp = 523,
	ncsi_dev_state_config_sp = 769,
	ncsi_dev_state_config_cis = 770,
	ncsi_dev_state_config_oem_gma = 771,
	ncsi_dev_state_config_apply_mac = 772,
	ncsi_dev_state_config_clear_vids = 773,
	ncsi_dev_state_config_svf = 774,
	ncsi_dev_state_config_ev = 775,
	ncsi_dev_state_config_sma = 776,
	ncsi_dev_state_config_ebf = 777,
	ncsi_dev_state_config_dgmf = 778,
	ncsi_dev_state_config_ecnt = 779,
	ncsi_dev_state_config_ec = 780,
	ncsi_dev_state_config_ae = 781,
	ncsi_dev_state_config_gls = 782,
	ncsi_dev_state_config_done = 783,
	ncsi_dev_state_suspend_select = 1025,
	ncsi_dev_state_suspend_gls = 1026,
	ncsi_dev_state_suspend_dcnt = 1027,
	ncsi_dev_state_suspend_dc = 1028,
	ncsi_dev_state_suspend_deselect = 1029,
	ncsi_dev_state_suspend_done = 1030,
};

enum {
	ncsi_dev_state_registered = 0,
	ncsi_dev_state_functional = 256,
	ncsi_dev_state_probe = 512,
	ncsi_dev_state_config = 768,
	ncsi_dev_state_suspend = 1024,
};

enum {
	none = 0,
	day = 1,
	month = 2,
	year = 3,
};

enum {
	pci_channel_io_normal = 1,
	pci_channel_io_frozen = 2,
	pci_channel_io_perm_failure = 3,
};

enum {
	ptr_explicit = 0,
	ptr_ext4_sb_info_offset = 1,
	ptr_ext4_super_block_offset = 2,
};

enum {
	scrub_bitmap_nr_has_extent = 0,
	scrub_bitmap_nr_is_metadata = 1,
	scrub_bitmap_nr_error = 2,
	scrub_bitmap_nr_io_error = 3,
	scrub_bitmap_nr_csum_error = 4,
	scrub_bitmap_nr_meta_error = 5,
	scrub_bitmap_nr_meta_gen_error = 6,
	scrub_bitmap_nr_last = 7,
};

typedef enum {
	BIT_DStream_unfinished = 0,
	BIT_DStream_endOfBuffer = 1,
	BIT_DStream_completed = 2,
	BIT_DStream_overflow = 3,
} BIT_DStream_status;

typedef enum {
	ZSTD_error_no_error = 0,
	ZSTD_error_GENERIC = 1,
	ZSTD_error_prefix_unknown = 10,
	ZSTD_error_version_unsupported = 12,
	ZSTD_error_frameParameter_unsupported = 14,
	ZSTD_error_frameParameter_windowTooLarge = 16,
	ZSTD_error_corruption_detected = 20,
	ZSTD_error_checksum_wrong = 22,
	ZSTD_error_literals_headerWrong = 24,
	ZSTD_error_dictionary_corrupted = 30,
	ZSTD_error_dictionary_wrong = 32,
	ZSTD_error_dictionaryCreation_failed = 34,
	ZSTD_error_parameter_unsupported = 40,
	ZSTD_error_parameter_combination_unsupported = 41,
	ZSTD_error_parameter_outOfBound = 42,
	ZSTD_error_tableLog_tooLarge = 44,
	ZSTD_error_maxSymbolValue_tooLarge = 46,
	ZSTD_error_maxSymbolValue_tooSmall = 48,
	ZSTD_error_cannotProduce_uncompressedBlock = 49,
	ZSTD_error_stabilityCondition_notRespected = 50,
	ZSTD_error_stage_wrong = 60,
	ZSTD_error_init_missing = 62,
	ZSTD_error_memory_allocation = 64,
	ZSTD_error_workSpace_tooSmall = 66,
	ZSTD_error_dstSize_tooSmall = 70,
	ZSTD_error_srcSize_wrong = 72,
	ZSTD_error_dstBuffer_null = 74,
	ZSTD_error_noForwardProgress_destFull = 80,
	ZSTD_error_noForwardProgress_inputEmpty = 82,
	ZSTD_error_frameIndex_tooLarge = 100,
	ZSTD_error_seekableIO = 102,
	ZSTD_error_dstBuffer_wrong = 104,
	ZSTD_error_srcBuffer_wrong = 105,
	ZSTD_error_sequenceProducer_failed = 106,
	ZSTD_error_externalSequences_invalid = 107,
	ZSTD_error_maxCode = 120,
} ZSTD_ErrorCode;

typedef ZSTD_ErrorCode ERR_enum;

typedef enum {
	FSE_repeat_none = 0,
	FSE_repeat_check = 1,
	FSE_repeat_valid = 2,
} FSE_repeat;

typedef enum {
	trustInput = 0,
	checkMaxSymbolValue = 1,
} HIST_checkInput_e;

typedef enum {
	HUF_singleStream = 0,
	HUF_fourStreams = 1,
} HUF_nbStreams_e;

typedef enum {
	HUF_repeat_none = 0,
	HUF_repeat_check = 1,
	HUF_repeat_valid = 2,
} HUF_repeat;

typedef enum {
	set_basic = 0,
	set_rle = 1,
	set_compressed = 2,
	set_repeat = 3,
} SymbolEncodingType_e;

typedef enum {
	ZSTD_cpm_noAttachDict = 0,
	ZSTD_cpm_attachDict = 1,
	ZSTD_cpm_createCDict = 2,
	ZSTD_cpm_unknown = 3,
} ZSTD_CParamMode_e;

typedef enum {
	ZSTD_defaultDisallowed = 0,
	ZSTD_defaultAllowed = 1,
} ZSTD_DefaultPolicy_e;

typedef enum {
	ZSTD_e_continue = 0,
	ZSTD_e_flush = 1,
	ZSTD_e_end = 2,
} ZSTD_EndDirective;

typedef enum {
	ZSTD_frame = 0,
	ZSTD_skippableFrame = 1,
} ZSTD_FrameType_e;

typedef enum {
	zop_dynamic = 0,
	zop_predef = 1,
} ZSTD_OptPrice_e;

typedef enum {
	ZSTD_ps_auto = 0,
	ZSTD_ps_enable = 1,
	ZSTD_ps_disable = 2,
} ZSTD_ParamSwitch_e;

typedef enum {
	ZSTD_reset_session_only = 1,
	ZSTD_reset_parameters = 2,
	ZSTD_reset_session_and_parameters = 3,
} ZSTD_ResetDirective;

typedef enum {
	ZSTD_sf_noBlockDelimiters = 0,
	ZSTD_sf_explicitBlockDelimiters = 1,
} ZSTD_SequenceFormat_e;

typedef enum {
	ZSTD_bm_buffered = 0,
	ZSTD_bm_stable = 1,
} ZSTD_bufferMode_e;

typedef enum {
	ZSTDb_not_buffered = 0,
	ZSTDb_buffered = 1,
} ZSTD_buffered_policy_e;

typedef enum {
	ZSTD_c_compressionLevel = 100,
	ZSTD_c_windowLog = 101,
	ZSTD_c_hashLog = 102,
	ZSTD_c_chainLog = 103,
	ZSTD_c_searchLog = 104,
	ZSTD_c_minMatch = 105,
	ZSTD_c_targetLength = 106,
	ZSTD_c_strategy = 107,
	ZSTD_c_targetCBlockSize = 130,
	ZSTD_c_enableLongDistanceMatching = 160,
	ZSTD_c_ldmHashLog = 161,
	ZSTD_c_ldmMinMatch = 162,
	ZSTD_c_ldmBucketSizeLog = 163,
	ZSTD_c_ldmHashRateLog = 164,
	ZSTD_c_contentSizeFlag = 200,
	ZSTD_c_checksumFlag = 201,
	ZSTD_c_dictIDFlag = 202,
	ZSTD_c_nbWorkers = 400,
	ZSTD_c_jobSize = 401,
	ZSTD_c_overlapLog = 402,
	ZSTD_c_experimentalParam1 = 500,
	ZSTD_c_experimentalParam2 = 10,
	ZSTD_c_experimentalParam3 = 1000,
	ZSTD_c_experimentalParam4 = 1001,
	ZSTD_c_experimentalParam5 = 1002,
	ZSTD_c_experimentalParam7 = 1004,
	ZSTD_c_experimentalParam8 = 1005,
	ZSTD_c_experimentalParam9 = 1006,
	ZSTD_c_experimentalParam10 = 1007,
	ZSTD_c_experimentalParam11 = 1008,
	ZSTD_c_experimentalParam12 = 1009,
	ZSTD_c_experimentalParam13 = 1010,
	ZSTD_c_experimentalParam14 = 1011,
	ZSTD_c_experimentalParam15 = 1012,
	ZSTD_c_experimentalParam16 = 1013,
	ZSTD_c_experimentalParam17 = 1014,
	ZSTD_c_experimentalParam18 = 1015,
	ZSTD_c_experimentalParam19 = 1016,
	ZSTD_c_experimentalParam20 = 1017,
} ZSTD_cParameter;

typedef enum {
	zcss_init = 0,
	zcss_load = 1,
	zcss_flush = 2,
} ZSTD_cStreamStage;

typedef enum {
	ZSTDcrp_makeClean = 0,
	ZSTDcrp_leaveDirty = 1,
} ZSTD_compResetPolicy_e;

typedef enum {
	ZSTDcs_created = 0,
	ZSTDcs_init = 1,
	ZSTDcs_ongoing = 2,
	ZSTDcs_ending = 3,
} ZSTD_compressionStage_e;

typedef enum {
	ZSTD_cwksp_alloc_objects = 0,
	ZSTD_cwksp_alloc_aligned_init_once = 1,
	ZSTD_cwksp_alloc_aligned = 2,
	ZSTD_cwksp_alloc_buffers = 3,
} ZSTD_cwksp_alloc_phase_e;

typedef enum {
	ZSTD_cwksp_dynamic_alloc = 0,
	ZSTD_cwksp_static_alloc = 1,
} ZSTD_cwksp_static_alloc_e;

typedef enum {
	ZSTD_d_windowLogMax = 100,
	ZSTD_d_experimentalParam1 = 1000,
	ZSTD_d_experimentalParam2 = 1001,
	ZSTD_d_experimentalParam3 = 1002,
	ZSTD_d_experimentalParam4 = 1003,
	ZSTD_d_experimentalParam5 = 1004,
	ZSTD_d_experimentalParam6 = 1005,
} ZSTD_dParameter;

typedef enum {
	ZSTDds_getFrameHeaderSize = 0,
	ZSTDds_decodeFrameHeader = 1,
	ZSTDds_decodeBlockHeader = 2,
	ZSTDds_decompressBlock = 3,
	ZSTDds_decompressLastBlock = 4,
	ZSTDds_checkChecksum = 5,
	ZSTDds_decodeSkippableHeader = 6,
	ZSTDds_skipFrame = 7,
} ZSTD_dStage;

typedef enum {
	zdss_init = 0,
	zdss_loadHeader = 1,
	zdss_read = 2,
	zdss_load = 3,
	zdss_flush = 4,
} ZSTD_dStreamStage;

typedef enum {
	ZSTD_dictDefaultAttach = 0,
	ZSTD_dictForceAttach = 1,
	ZSTD_dictForceCopy = 2,
	ZSTD_dictForceLoad = 3,
} ZSTD_dictAttachPref_e;

typedef enum {
	ZSTD_dct_auto = 0,
	ZSTD_dct_rawContent = 1,
	ZSTD_dct_fullDict = 2,
} ZSTD_dictContentType_e;

typedef enum {
	ZSTD_dlm_byCopy = 0,
	ZSTD_dlm_byRef = 1,
} ZSTD_dictLoadMethod_e;

typedef enum {
	ZSTD_noDict = 0,
	ZSTD_extDict = 1,
	ZSTD_dictMatchState = 2,
	ZSTD_dedicatedDictSearch = 3,
} ZSTD_dictMode_e;

typedef enum {
	ZSTD_dtlm_fast = 0,
	ZSTD_dtlm_full = 1,
} ZSTD_dictTableLoadMethod_e;

typedef enum {
	ZSTD_use_indefinitely = -1,
	ZSTD_dont_use = 0,
	ZSTD_use_once = 1,
} ZSTD_dictUses_e;

typedef enum {
	ZSTD_d_validateChecksum = 0,
	ZSTD_d_ignoreChecksum = 1,
} ZSTD_forceIgnoreChecksum_e;

typedef enum {
	ZSTD_f_zstd1 = 0,
	ZSTD_f_zstd1_magicless = 1,
} ZSTD_format_e;

typedef enum {
	ZSTDirp_continue = 0,
	ZSTDirp_reset = 1,
} ZSTD_indexResetPolicy_e;

typedef enum {
	ZSTD_not_in_dst = 0,
	ZSTD_in_dst = 1,
	ZSTD_split = 2,
} ZSTD_litLocation_e;

typedef enum {
	ZSTD_llt_none = 0,
	ZSTD_llt_literalLength = 1,
	ZSTD_llt_matchLength = 2,
} ZSTD_longLengthType_e;

typedef enum {
	ZSTD_lo_isRegularOffset = 0,
	ZSTD_lo_isLongOffset = 1,
} ZSTD_longOffset_e;

typedef enum {
	ZSTDnit_frameHeader = 0,
	ZSTDnit_blockHeader = 1,
	ZSTDnit_block = 2,
	ZSTDnit_lastBlock = 3,
	ZSTDnit_checksum = 4,
	ZSTDnit_skippableFrame = 5,
} ZSTD_nextInputType_e;

typedef enum {
	ZSTD_no_overlap = 0,
	ZSTD_overlap_src_before_dst = 1,
} ZSTD_overlap_e;

typedef enum {
	ZSTD_rmd_refSingleDDict = 0,
	ZSTD_rmd_refMultipleDDicts = 1,
} ZSTD_refMultipleDDicts_e;

typedef enum {
	ZSTD_resetTarget_CDict = 0,
	ZSTD_resetTarget_CCtx = 1,
} ZSTD_resetTarget_e;

typedef enum {
	ZSTD_fast = 1,
	ZSTD_dfast = 2,
	ZSTD_greedy = 3,
	ZSTD_lazy = 4,
	ZSTD_lazy2 = 5,
	ZSTD_btlazy2 = 6,
	ZSTD_btopt = 7,
	ZSTD_btultra = 8,
	ZSTD_btultra2 = 9,
} ZSTD_strategy;

typedef enum {
	ZSTD_tfp_forCCtx = 0,
	ZSTD_tfp_forCDict = 1,
} ZSTD_tableFillPurpose_e;

typedef enum {
	base_0possible = 0,
	base_1guaranteed = 1,
} base_directive_e;

typedef enum {
	bt_raw = 0,
	bt_rle = 1,
	bt_compressed = 2,
	bt_reserved = 3,
} blockType_e;

typedef enum {
	need_more = 0,
	block_done = 1,
	finish_started = 2,
	finish_done = 3,
} block_state;

typedef enum {
	CODES = 0,
	LENS = 1,
	DISTS = 2,
} codetype;

typedef enum {
	FILE_MEMORY_MIGRATE = 0,
	FILE_CPULIST = 1,
	FILE_MEMLIST = 2,
	FILE_EFFECTIVE_CPULIST = 3,
	FILE_EFFECTIVE_MEMLIST = 4,
	FILE_SUBPARTS_CPULIST = 5,
	FILE_EXCLUSIVE_CPULIST = 6,
	FILE_EFFECTIVE_XCPULIST = 7,
	FILE_ISOLATED_CPULIST = 8,
	FILE_CPU_EXCLUSIVE = 9,
	FILE_MEM_EXCLUSIVE = 10,
	FILE_MEM_HARDWALL = 11,
	FILE_SCHED_LOAD_BALANCE = 12,
	FILE_PARTITION_ROOT = 13,
	FILE_SCHED_RELAX_DOMAIN_LEVEL = 14,
	FILE_MEMORY_PRESSURE_ENABLED = 15,
	FILE_MEMORY_PRESSURE = 16,
	FILE_SPREAD_PAGE = 17,
	FILE_SPREAD_SLAB = 18,
} cpuset_filetype_t;

typedef enum {
	CS_ONLINE = 0,
	CS_CPU_EXCLUSIVE = 1,
	CS_MEM_EXCLUSIVE = 2,
	CS_MEM_HARDWALL = 3,
	CS_MEMORY_MIGRATE = 4,
	CS_SCHED_LOAD_BALANCE = 5,
	CS_SPREAD_PAGE = 6,
	CS_SPREAD_SLAB = 7,
} cpuset_flagbits_t;

typedef enum {
	noDictIssue = 0,
	dictSmall = 1,
} dictIssue_directive;

typedef enum {
	noDict = 0,
	withPrefix64k = 1,
	usingExtDict = 2,
} dict_directive;

typedef enum {
	EITHER = 0,
	INDEX = 1,
	DIRENT = 2,
	DIRENT_HTREE = 3,
} dirblock_type_t;

typedef enum {
	decode_full_block = 0,
	partial_decode = 1,
} earlyEnd_directive;

typedef enum {
	endOnOutputSize = 0,
	endOnInputSize = 1,
} endCondition_directive;

typedef enum {
	EXT4_IGET_NORMAL = 0,
	EXT4_IGET_SPECIAL = 1,
	EXT4_IGET_HANDLE = 2,
	EXT4_IGET_BAD = 4,
	EXT4_IGET_EA_INODE = 8,
} ext4_iget_flags;

typedef enum {
	FL_READY = 0,
	FL_STATUS = 1,
	FL_CFI_QUERY = 2,
	FL_JEDEC_QUERY = 3,
	FL_ERASING = 4,
	FL_ERASE_SUSPENDING = 5,
	FL_ERASE_SUSPENDED = 6,
	FL_WRITING = 7,
	FL_WRITING_TO_BUFFER = 8,
	FL_OTP_WRITE = 9,
	FL_WRITE_SUSPENDING = 10,
	FL_WRITE_SUSPENDED = 11,
	FL_PM_SUSPENDED = 12,
	FL_SYNCING = 13,
	FL_UNLOADING = 14,
	FL_LOCKING = 15,
	FL_UNLOCKING = 16,
	FL_POINT = 17,
	FL_XIP_WHILE_ERASING = 18,
	FL_XIP_WHILE_WRITING = 19,
	FL_SHUTDOWN = 20,
	FL_READING = 21,
	FL_CACHEDPRG = 22,
	FL_RESETTING = 23,
	FL_OTPING = 24,
	FL_PREPARING_ERASE = 25,
	FL_VERIFYING_ERASE = 26,
	FL_UNKNOWN = 27,
} flstate_t;

typedef enum {
	FS_DECRYPT = 0,
	FS_ENCRYPT = 1,
} fscrypt_direction_t;

typedef enum {
	HEAD = 0,
	FLAGS = 1,
	TIME = 2,
	OS = 3,
	EXLEN = 4,
	EXTRA = 5,
	NAME = 6,
	COMMENT = 7,
	HCRC = 8,
	DICTID = 9,
	DICT = 10,
	TYPE = 11,
	TYPEDO = 12,
	STORED = 13,
	COPY = 14,
	TABLE = 15,
	LENLENS = 16,
	CODELENS = 17,
	LEN = 18,
	LENEXT = 19,
	DIST = 20,
	DISTEXT = 21,
	MATCH = 22,
	LIT = 23,
	CHECK = 24,
	LENGTH = 25,
	DONE = 26,
	BAD = 27,
	MEM = 28,
	SYNC = 29,
} inflate_mode;

typedef enum {
	ISOLATE_ABORT = 0,
	ISOLATE_NONE = 1,
	ISOLATE_SUCCESS = 2,
} isolate_migrate_t;

typedef enum {
	KDB_ENABLE_ALL = 1,
	KDB_ENABLE_MEM_READ = 2,
	KDB_ENABLE_MEM_WRITE = 4,
	KDB_ENABLE_REG_READ = 8,
	KDB_ENABLE_REG_WRITE = 16,
	KDB_ENABLE_INSPECT = 32,
	KDB_ENABLE_FLOW_CTRL = 64,
	KDB_ENABLE_SIGNAL = 128,
	KDB_ENABLE_REBOOT = 256,
	KDB_ENABLE_ALWAYS_SAFE = 512,
	KDB_ENABLE_MASK = 1023,
	KDB_ENABLE_ALL_NO_ARGS = 1024,
	KDB_ENABLE_MEM_READ_NO_ARGS = 2048,
	KDB_ENABLE_MEM_WRITE_NO_ARGS = 4096,
	KDB_ENABLE_REG_READ_NO_ARGS = 8192,
	KDB_ENABLE_REG_WRITE_NO_ARGS = 16384,
	KDB_ENABLE_INSPECT_NO_ARGS = 32768,
	KDB_ENABLE_FLOW_CTRL_NO_ARGS = 65536,
	KDB_ENABLE_SIGNAL_NO_ARGS = 131072,
	KDB_ENABLE_REBOOT_NO_ARGS = 262144,
	KDB_ENABLE_ALWAYS_SAFE_NO_ARGS = 524288,
	KDB_ENABLE_MASK_NO_ARGS = 1047552,
	KDB_REPEAT_NO_ARGS = 1073741824,
	KDB_REPEAT_WITH_ARGS = 2147483648,
} kdb_cmdflags_t;

typedef enum {
	KDB_DB_BPT = 0,
	KDB_DB_SS = 1,
	KDB_DB_SSBPT = 2,
	KDB_DB_NOBPT = 3,
} kdb_dbtrap_t;

typedef enum {
	KDB_REASON_ENTER = 1,
	KDB_REASON_ENTER_SLAVE = 2,
	KDB_REASON_BREAK = 3,
	KDB_REASON_DEBUG = 4,
	KDB_REASON_OOPS = 5,
	KDB_REASON_SWITCH = 6,
	KDB_REASON_KEYBOARD = 7,
	KDB_REASON_NMI = 8,
	KDB_REASON_RECURSE = 9,
	KDB_REASON_SSTEP = 10,
	KDB_REASON_SYSTEM_NMI = 11,
} kdb_reason_t;

typedef enum {
	noLimit = 0,
	limitedOutput = 1,
} limitedOutput_directive;

typedef enum {
	IRQ_TX = 1,
	IRQ_RX = 2,
} omap_mbox_irq_t;

typedef enum {
	PAGE_KEEP = 0,
	PAGE_ACTIVATE = 1,
	PAGE_SUCCESS = 2,
	PAGE_CLEAN = 3,
} pageout_t;

typedef enum {
	PCI_BRIDGE_EMUL_HANDLED = 0,
	PCI_BRIDGE_EMUL_NOT_HANDLED = 1,
} pci_bridge_emul_read_status_t;

typedef enum {
	PHY_INTERFACE_MODE_NA = 0,
	PHY_INTERFACE_MODE_INTERNAL = 1,
	PHY_INTERFACE_MODE_MII = 2,
	PHY_INTERFACE_MODE_GMII = 3,
	PHY_INTERFACE_MODE_SGMII = 4,
	PHY_INTERFACE_MODE_TBI = 5,
	PHY_INTERFACE_MODE_REVMII = 6,
	PHY_INTERFACE_MODE_RMII = 7,
	PHY_INTERFACE_MODE_REVRMII = 8,
	PHY_INTERFACE_MODE_RGMII = 9,
	PHY_INTERFACE_MODE_RGMII_ID = 10,
	PHY_INTERFACE_MODE_RGMII_RXID = 11,
	PHY_INTERFACE_MODE_RGMII_TXID = 12,
	PHY_INTERFACE_MODE_RTBI = 13,
	PHY_INTERFACE_MODE_SMII = 14,
	PHY_INTERFACE_MODE_XGMII = 15,
	PHY_INTERFACE_MODE_XLGMII = 16,
	PHY_INTERFACE_MODE_MOCA = 17,
	PHY_INTERFACE_MODE_PSGMII = 18,
	PHY_INTERFACE_MODE_QSGMII = 19,
	PHY_INTERFACE_MODE_TRGMII = 20,
	PHY_INTERFACE_MODE_100BASEX = 21,
	PHY_INTERFACE_MODE_1000BASEX = 22,
	PHY_INTERFACE_MODE_2500BASEX = 23,
	PHY_INTERFACE_MODE_5GBASER = 24,
	PHY_INTERFACE_MODE_RXAUI = 25,
	PHY_INTERFACE_MODE_XAUI = 26,
	PHY_INTERFACE_MODE_10GBASER = 27,
	PHY_INTERFACE_MODE_25GBASER = 28,
	PHY_INTERFACE_MODE_USXGMII = 29,
	PHY_INTERFACE_MODE_10GKR = 30,
	PHY_INTERFACE_MODE_QUSGMII = 31,
	PHY_INTERFACE_MODE_1000BASEKX = 32,
	PHY_INTERFACE_MODE_10G_QXGMII = 33,
	PHY_INTERFACE_MODE_MAX = 34,
} phy_interface_t;

typedef enum {
	search_hashChain = 0,
	search_binaryTree = 1,
	search_rowHash = 2,
} searchMethod_e;

typedef enum {
	SS_FREE = 0,
	SS_UNCONNECTED = 1,
	SS_CONNECTING = 2,
	SS_CONNECTED = 3,
	SS_DISCONNECTING = 4,
} socket_state;

typedef enum {
	not_streaming = 0,
	is_streaming = 1,
} streaming_operation;

typedef enum {
	byPtr = 0,
	byU32 = 1,
	byU16 = 2,
} tableType_t;

typedef ZSTD_ErrorCode zstd_error_code;

enum CSI_J {
	CSI_J_CURSOR_TO_END = 0,
	CSI_J_START_TO_CURSOR = 1,
	CSI_J_VISIBLE = 2,
	CSI_J_FULL = 3,
};

enum CSI_right_square_bracket {
	CSI_RSB_COLOR_FOR_UNDERLINE = 1,
	CSI_RSB_COLOR_FOR_HALF_BRIGHT = 2,
	CSI_RSB_MAKE_CUR_COLOR_DEFAULT = 8,
	CSI_RSB_BLANKING_INTERVAL = 9,
	CSI_RSB_BELL_FREQUENCY = 10,
	CSI_RSB_BELL_DURATION = 11,
	CSI_RSB_BRING_CONSOLE_TO_FRONT = 12,
	CSI_RSB_UNBLANK = 13,
	CSI_RSB_VESA_OFF_INTERVAL = 14,
	CSI_RSB_BRING_PREV_CONSOLE_TO_FRONT = 15,
	CSI_RSB_CURSOR_BLINK_INTERVAL = 16,
};

enum DS_TYPE {
	DS_UNKNOWN = 0,
	DS_RECEIVER = 1,
	DS_REPEATER = 2,
};

enum IMX6_CPUFREQ_CLKS {
	ARM = 0,
	PLL1_SYS = 1,
	STEP = 2,
	PLL1_SW = 3,
	PLL2_PFD2_396M = 4,
	PLL2_BUS = 5,
	SECONDARY_SEL = 6,
};

enum IMX7ULP_CPUFREQ_CLKS {
	ARM___2 = 0,
	CORE = 1,
	SCS_SEL = 2,
	HSRUN_CORE = 3,
	HSRUN_SCS_SEL = 4,
	FIRC = 5,
};

enum KTHREAD_BITS {
	KTHREAD_IS_PER_CPU = 0,
	KTHREAD_SHOULD_STOP = 1,
	KTHREAD_SHOULD_PARK = 2,
};

enum MAX77686_RTC_OP {
	MAX77686_RTC_WRITE = 0,
	MAX77686_RTC_READ = 1,
};

enum OID {
	OID_id_dsa_with_sha1 = 0,
	OID_id_dsa = 1,
	OID_id_ecPublicKey = 2,
	OID_id_prime192v1 = 3,
	OID_id_prime256v1 = 4,
	OID_id_ecdsa_with_sha1 = 5,
	OID_id_ecdsa_with_sha224 = 6,
	OID_id_ecdsa_with_sha256 = 7,
	OID_id_ecdsa_with_sha384 = 8,
	OID_id_ecdsa_with_sha512 = 9,
	OID_rsaEncryption = 10,
	OID_sha1WithRSAEncryption = 11,
	OID_sha256WithRSAEncryption = 12,
	OID_sha384WithRSAEncryption = 13,
	OID_sha512WithRSAEncryption = 14,
	OID_sha224WithRSAEncryption = 15,
	OID_data = 16,
	OID_signed_data = 17,
	OID_email_address = 18,
	OID_contentType = 19,
	OID_messageDigest = 20,
	OID_signingTime = 21,
	OID_smimeCapabilites = 22,
	OID_smimeAuthenticatedAttrs = 23,
	OID_mskrb5 = 24,
	OID_krb5 = 25,
	OID_krb5u2u = 26,
	OID_msIndirectData = 27,
	OID_msStatementType = 28,
	OID_msSpOpusInfo = 29,
	OID_msPeImageDataObjId = 30,
	OID_msIndividualSPKeyPurpose = 31,
	OID_msOutlookExpress = 32,
	OID_ntlmssp = 33,
	OID_negoex = 34,
	OID_spnego = 35,
	OID_IAKerb = 36,
	OID_PKU2U = 37,
	OID_Scram = 38,
	OID_certAuthInfoAccess = 39,
	OID_sha1 = 40,
	OID_id_ansip384r1 = 41,
	OID_id_ansip521r1 = 42,
	OID_sha256 = 43,
	OID_sha384 = 44,
	OID_sha512 = 45,
	OID_sha224 = 46,
	OID_commonName = 47,
	OID_surname = 48,
	OID_countryName = 49,
	OID_locality = 50,
	OID_stateOrProvinceName = 51,
	OID_organizationName = 52,
	OID_organizationUnitName = 53,
	OID_title = 54,
	OID_description = 55,
	OID_name = 56,
	OID_givenName = 57,
	OID_initials = 58,
	OID_generationalQualifier = 59,
	OID_subjectKeyIdentifier = 60,
	OID_keyUsage = 61,
	OID_subjectAltName = 62,
	OID_issuerAltName = 63,
	OID_basicConstraints = 64,
	OID_crlDistributionPoints = 65,
	OID_certPolicies = 66,
	OID_authorityKeyIdentifier = 67,
	OID_extKeyUsage = 68,
	OID_NetlogonMechanism = 69,
	OID_appleLocalKdcSupported = 70,
	OID_gostCPSignA = 71,
	OID_gostCPSignB = 72,
	OID_gostCPSignC = 73,
	OID_gost2012PKey256 = 74,
	OID_gost2012PKey512 = 75,
	OID_gost2012Digest256 = 76,
	OID_gost2012Digest512 = 77,
	OID_gost2012Signature256 = 78,
	OID_gost2012Signature512 = 79,
	OID_gostTC26Sign256A = 80,
	OID_gostTC26Sign256B = 81,
	OID_gostTC26Sign256C = 82,
	OID_gostTC26Sign256D = 83,
	OID_gostTC26Sign512A = 84,
	OID_gostTC26Sign512B = 85,
	OID_gostTC26Sign512C = 86,
	OID_sm2 = 87,
	OID_sm3 = 88,
	OID_SM2_with_SM3 = 89,
	OID_sm3WithRSAEncryption = 90,
	OID_TPMLoadableKey = 91,
	OID_TPMImportableKey = 92,
	OID_TPMSealedData = 93,
	OID_sha3_256 = 94,
	OID_sha3_384 = 95,
	OID_sha3_512 = 96,
	OID_id_ecdsa_with_sha3_256 = 97,
	OID_id_ecdsa_with_sha3_384 = 98,
	OID_id_ecdsa_with_sha3_512 = 99,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_256 = 100,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_384 = 101,
	OID_id_rsassa_pkcs1_v1_5_with_sha3_512 = 102,
	OID__NR = 103,
};

enum PCI_HOST_CLK_CONTROL {
	PCI_CLK_375K = 3,
	PCI_CLK_8M = 4,
	PCI_CLK_12M = 0,
	PCI_CLK_16M = 5,
	PCI_CLK_24M = 1,
	PCI_CLK_33M = 6,
	PCI_CLK_48M = 2,
};

enum S2MPU02_reg {
	S2MPU02_REG_ID = 0,
	S2MPU02_REG_INT1 = 1,
	S2MPU02_REG_INT2 = 2,
	S2MPU02_REG_INT3 = 3,
	S2MPU02_REG_INT1M = 4,
	S2MPU02_REG_INT2M = 5,
	S2MPU02_REG_INT3M = 6,
	S2MPU02_REG_ST1 = 7,
	S2MPU02_REG_ST2 = 8,
	S2MPU02_REG_PWRONSRC = 9,
	S2MPU02_REG_OFFSRC = 10,
	S2MPU02_REG_BU_CHG = 11,
	S2MPU02_REG_RTCCTRL = 12,
	S2MPU02_REG_PMCTRL1 = 13,
	S2MPU02_REG_RSVD1 = 14,
	S2MPU02_REG_RSVD2 = 15,
	S2MPU02_REG_RSVD3 = 16,
	S2MPU02_REG_RSVD4 = 17,
	S2MPU02_REG_RSVD5 = 18,
	S2MPU02_REG_RSVD6 = 19,
	S2MPU02_REG_RSVD7 = 20,
	S2MPU02_REG_WRSTEN = 21,
	S2MPU02_REG_RSVD8 = 22,
	S2MPU02_REG_RSVD9 = 23,
	S2MPU02_REG_RSVD10 = 24,
	S2MPU02_REG_B1CTRL1 = 25,
	S2MPU02_REG_B1CTRL2 = 26,
	S2MPU02_REG_B2CTRL1 = 27,
	S2MPU02_REG_B2CTRL2 = 28,
	S2MPU02_REG_B3CTRL1 = 29,
	S2MPU02_REG_B3CTRL2 = 30,
	S2MPU02_REG_B4CTRL1 = 31,
	S2MPU02_REG_B4CTRL2 = 32,
	S2MPU02_REG_B5CTRL1 = 33,
	S2MPU02_REG_B5CTRL2 = 34,
	S2MPU02_REG_B5CTRL3 = 35,
	S2MPU02_REG_B5CTRL4 = 36,
	S2MPU02_REG_B5CTRL5 = 37,
	S2MPU02_REG_B6CTRL1 = 38,
	S2MPU02_REG_B6CTRL2 = 39,
	S2MPU02_REG_B7CTRL1 = 40,
	S2MPU02_REG_B7CTRL2 = 41,
	S2MPU02_REG_RAMP1 = 42,
	S2MPU02_REG_RAMP2 = 43,
	S2MPU02_REG_L1CTRL = 44,
	S2MPU02_REG_L2CTRL1 = 45,
	S2MPU02_REG_L2CTRL2 = 46,
	S2MPU02_REG_L2CTRL3 = 47,
	S2MPU02_REG_L2CTRL4 = 48,
	S2MPU02_REG_L3CTRL = 49,
	S2MPU02_REG_L4CTRL = 50,
	S2MPU02_REG_L5CTRL = 51,
	S2MPU02_REG_L6CTRL = 52,
	S2MPU02_REG_L7CTRL = 53,
	S2MPU02_REG_L8CTRL = 54,
	S2MPU02_REG_L9CTRL = 55,
	S2MPU02_REG_L10CTRL = 56,
	S2MPU02_REG_L11CTRL = 57,
	S2MPU02_REG_L12CTRL = 58,
	S2MPU02_REG_L13CTRL = 59,
	S2MPU02_REG_L14CTRL = 60,
	S2MPU02_REG_L15CTRL = 61,
	S2MPU02_REG_L16CTRL = 62,
	S2MPU02_REG_L17CTRL = 63,
	S2MPU02_REG_L18CTRL = 64,
	S2MPU02_REG_L19CTRL = 65,
	S2MPU02_REG_L20CTRL = 66,
	S2MPU02_REG_L21CTRL = 67,
	S2MPU02_REG_L22CTRL = 68,
	S2MPU02_REG_L23CTRL = 69,
	S2MPU02_REG_L24CTRL = 70,
	S2MPU02_REG_L25CTRL = 71,
	S2MPU02_REG_L26CTRL = 72,
	S2MPU02_REG_L27CTRL = 73,
	S2MPU02_REG_L28CTRL = 74,
	S2MPU02_REG_LDODSCH1 = 75,
	S2MPU02_REG_LDODSCH2 = 76,
	S2MPU02_REG_LDODSCH3 = 77,
	S2MPU02_REG_LDODSCH4 = 78,
	S2MPU02_REG_SELMIF = 79,
	S2MPU02_REG_RSVD11 = 80,
	S2MPU02_REG_RSVD12 = 81,
	S2MPU02_REG_RSVD13 = 82,
	S2MPU02_REG_DVSSEL = 83,
	S2MPU02_REG_DVSPTR = 84,
	S2MPU02_REG_DVSDATA = 85,
};

enum S2MPU02_regulators {
	S2MPU02_LDO1 = 0,
	S2MPU02_LDO2 = 1,
	S2MPU02_LDO3 = 2,
	S2MPU02_LDO4 = 3,
	S2MPU02_LDO5 = 4,
	S2MPU02_LDO6 = 5,
	S2MPU02_LDO7 = 6,
	S2MPU02_LDO8 = 7,
	S2MPU02_LDO9 = 8,
	S2MPU02_LDO10 = 9,
	S2MPU02_LDO11 = 10,
	S2MPU02_LDO12 = 11,
	S2MPU02_LDO13 = 12,
	S2MPU02_LDO14 = 13,
	S2MPU02_LDO15 = 14,
	S2MPU02_LDO16 = 15,
	S2MPU02_LDO17 = 16,
	S2MPU02_LDO18 = 17,
	S2MPU02_LDO19 = 18,
	S2MPU02_LDO20 = 19,
	S2MPU02_LDO21 = 20,
	S2MPU02_LDO22 = 21,
	S2MPU02_LDO23 = 22,
	S2MPU02_LDO24 = 23,
	S2MPU02_LDO25 = 24,
	S2MPU02_LDO26 = 25,
	S2MPU02_LDO27 = 26,
	S2MPU02_LDO28 = 27,
	S2MPU02_BUCK1 = 28,
	S2MPU02_BUCK2 = 29,
	S2MPU02_BUCK3 = 30,
	S2MPU02_BUCK4 = 31,
	S2MPU02_BUCK5 = 32,
	S2MPU02_BUCK6 = 33,
	S2MPU02_BUCK7 = 34,
	S2MPU02_REGULATOR_MAX = 35,
};

enum S2MPU05_reg {
	S2MPU05_REG_ID = 0,
	S2MPU05_REG_INT1 = 1,
	S2MPU05_REG_INT2 = 2,
	S2MPU05_REG_INT3 = 3,
	S2MPU05_REG_INT1M = 4,
	S2MPU05_REG_INT2M = 5,
	S2MPU05_REG_INT3M = 6,
	S2MPU05_REG_ST1 = 7,
	S2MPU05_REG_ST2 = 8,
	S2MPU05_REG_PWRONSRC = 9,
	S2MPU05_REG_OFFSRC = 10,
	S2MPU05_REG_BU_CHG = 11,
	S2MPU05_REG_RTC_BUF = 12,
	S2MPU05_REG_CTRL1 = 13,
	S2MPU05_REG_CTRL2 = 14,
	S2MPU05_REG_ETC_TEST = 15,
	S2MPU05_REG_OTP_ADRL = 16,
	S2MPU05_REG_OTP_ADRH = 17,
	S2MPU05_REG_OTP_DATA = 18,
	S2MPU05_REG_MON1SEL = 19,
	S2MPU05_REG_MON2SEL = 20,
	S2MPU05_REG_CTRL3 = 21,
	S2MPU05_REG_ETC_OTP = 22,
	S2MPU05_REG_UVLO = 23,
	S2MPU05_REG_TIME_CTRL1 = 24,
	S2MPU05_REG_TIME_CTRL2 = 25,
	S2MPU05_REG_B1CTRL1 = 26,
	S2MPU05_REG_B1CTRL2 = 27,
	S2MPU05_REG_B2CTRL1 = 28,
	S2MPU05_REG_B2CTRL2 = 29,
	S2MPU05_REG_B2CTRL3 = 30,
	S2MPU05_REG_B2CTRL4 = 31,
	S2MPU05_REG_B3CTRL1 = 32,
	S2MPU05_REG_B3CTRL2 = 33,
	S2MPU05_REG_B3CTRL3 = 34,
	S2MPU05_REG_B4CTRL1 = 35,
	S2MPU05_REG_B4CTRL2 = 36,
	S2MPU05_REG_B5CTRL1 = 37,
	S2MPU05_REG_B5CTRL2 = 38,
	S2MPU05_REG_BUCK_RAMP = 39,
	S2MPU05_REG_LDO_DVS1 = 40,
	S2MPU05_REG_LDO_DVS9 = 41,
	S2MPU05_REG_LDO_DVS10 = 42,
	S2MPU05_REG_L1CTRL = 43,
	S2MPU05_REG_L2CTRL = 44,
	S2MPU05_REG_L3CTRL = 45,
	S2MPU05_REG_L4CTRL = 46,
	S2MPU05_REG_L5CTRL = 47,
	S2MPU05_REG_L6CTRL = 48,
	S2MPU05_REG_L7CTRL = 49,
	S2MPU05_REG_L8CTRL = 50,
	S2MPU05_REG_L9CTRL1 = 51,
	S2MPU05_REG_L9CTRL2 = 52,
	S2MPU05_REG_L10CTRL = 53,
	S2MPU05_REG_L11CTRL1 = 54,
	S2MPU05_REG_L11CTRL2 = 55,
	S2MPU05_REG_L12CTRL = 56,
	S2MPU05_REG_L13CTRL = 57,
	S2MPU05_REG_L14CTRL = 58,
	S2MPU05_REG_L15CTRL = 59,
	S2MPU05_REG_L16CTRL = 60,
	S2MPU05_REG_L17CTRL1 = 61,
	S2MPU05_REG_L17CTRL2 = 62,
	S2MPU05_REG_L18CTRL1 = 63,
	S2MPU05_REG_L18CTRL2 = 64,
	S2MPU05_REG_L19CTRL = 65,
	S2MPU05_REG_L20CTRL = 66,
	S2MPU05_REG_L21CTRL = 67,
	S2MPU05_REG_L22CTRL = 68,
	S2MPU05_REG_L23CTRL = 69,
	S2MPU05_REG_L24CTRL = 70,
	S2MPU05_REG_L25CTRL = 71,
	S2MPU05_REG_L26CTRL = 72,
	S2MPU05_REG_L27CTRL = 73,
	S2MPU05_REG_L28CTRL = 74,
	S2MPU05_REG_L29CTRL = 75,
	S2MPU05_REG_L30CTRL = 76,
	S2MPU05_REG_L31CTRL = 77,
	S2MPU05_REG_L32CTRL = 78,
	S2MPU05_REG_L33CTRL = 79,
	S2MPU05_REG_L34CTRL = 80,
	S2MPU05_REG_L35CTRL = 81,
	S2MPU05_REG_LDO_DSCH1 = 82,
	S2MPU05_REG_LDO_DSCH2 = 83,
	S2MPU05_REG_LDO_DSCH3 = 84,
	S2MPU05_REG_LDO_DSCH4 = 85,
	S2MPU05_REG_LDO_DSCH5 = 86,
	S2MPU05_REG_LDO_CTRL1 = 87,
	S2MPU05_REG_LDO_CTRL2 = 88,
	S2MPU05_REG_TCXO_CTRL = 89,
	S2MPU05_REG_SELMIF = 90,
};

enum S2MPU05_regulators {
	S2MPU05_LDO1 = 0,
	S2MPU05_LDO2 = 1,
	S2MPU05_LDO3 = 2,
	S2MPU05_LDO4 = 3,
	S2MPU05_LDO5 = 4,
	S2MPU05_LDO6 = 5,
	S2MPU05_LDO7 = 6,
	S2MPU05_LDO8 = 7,
	S2MPU05_LDO9 = 8,
	S2MPU05_LDO10 = 9,
	S2MPU05_LDO11 = 10,
	S2MPU05_LDO12 = 11,
	S2MPU05_LDO13 = 12,
	S2MPU05_LDO14 = 13,
	S2MPU05_LDO15 = 14,
	S2MPU05_LDO16 = 15,
	S2MPU05_LDO17 = 16,
	S2MPU05_LDO18 = 17,
	S2MPU05_LDO19 = 18,
	S2MPU05_LDO20 = 19,
	S2MPU05_LDO21 = 20,
	S2MPU05_LDO22 = 21,
	S2MPU05_LDO23 = 22,
	S2MPU05_LDO24 = 23,
	S2MPU05_LDO25 = 24,
	S2MPU05_LDO26 = 25,
	S2MPU05_LDO27 = 26,
	S2MPU05_LDO28 = 27,
	S2MPU05_LDO29 = 28,
	S2MPU05_LDO30 = 29,
	S2MPU05_LDO31 = 30,
	S2MPU05_LDO32 = 31,
	S2MPU05_LDO33 = 32,
	S2MPU05_LDO34 = 33,
	S2MPU05_LDO35 = 34,
	S2MPU05_BUCK1 = 35,
	S2MPU05_BUCK2 = 36,
	S2MPU05_BUCK3 = 37,
	S2MPU05_BUCK4 = 38,
	S2MPU05_BUCK5 = 39,
	S2MPU05_REGULATOR_MAX = 40,
};

enum SD_RESPONSE_TYPE {
	SDRT_UNSPECIFIED = 0,
	SDRT_NONE = 1,
	SDRT_1 = 2,
	SDRT_1B = 3,
	SDRT_2 = 4,
	SDRT_3 = 5,
	SDRT_4 = 6,
	SDRT_5 = 7,
	SDRT_5B = 8,
	SDRT_6 = 9,
	SDRT_7 = 10,
};

enum SHIFT_DIRECTION {
	SHIFT_LEFT = 0,
	SHIFT_RIGHT = 1,
};

enum UART_TX_FLAGS {
	UART_TX_NOSTOP = 1,
};

enum USE_TYPE_E {
	USE_TYPE_SERVICE = 0,
	USE_TYPE_VCHIQ = 1,
};

enum __sk_action {
	__SK_DROP = 0,
	__SK_PASS = 1,
	__SK_REDIRECT = 2,
	__SK_NONE = 3,
};

enum _slab_flag_bits {
	_SLAB_CONSISTENCY_CHECKS = 0,
	_SLAB_RED_ZONE = 1,
	_SLAB_POISON = 2,
	_SLAB_KMALLOC = 3,
	_SLAB_HWCACHE_ALIGN = 4,
	_SLAB_CACHE_DMA = 5,
	_SLAB_CACHE_DMA32 = 6,
	_SLAB_STORE_USER = 7,
	_SLAB_PANIC = 8,
	_SLAB_TYPESAFE_BY_RCU = 9,
	_SLAB_TRACE = 10,
	_SLAB_NOLEAKTRACE = 11,
	_SLAB_NO_MERGE = 12,
	_SLAB_ACCOUNT = 13,
	_SLAB_NO_USER_FLAGS = 14,
	_SLAB_RECLAIM_ACCOUNT = 15,
	_SLAB_OBJECT_POISON = 16,
	_SLAB_CMPXCHG_DOUBLE = 17,
	_SLAB_NO_OBJ_EXT = 18,
	_SLAB_FLAGS_LAST_BIT = 19,
};

enum a3xx_sp_perfcounter_select {
	SP_LM_LOAD_INSTRUCTIONS = 0,
	SP_LM_STORE_INSTRUCTIONS = 1,
	SP_LM_ATOMICS = 2,
	SP_UCHE_LOAD_INSTRUCTIONS = 3,
	SP_UCHE_STORE_INSTRUCTIONS = 4,
	SP_UCHE_ATOMICS = 5,
	SP_VS_TEX_INSTRUCTIONS = 6,
	SP_VS_CFLOW_INSTRUCTIONS = 7,
	SP_VS_EFU_INSTRUCTIONS = 8,
	SP_VS_FULL_ALU_INSTRUCTIONS = 9,
	SP_VS_HALF_ALU_INSTRUCTIONS = 10,
	SP_FS_TEX_INSTRUCTIONS = 11,
	SP_FS_CFLOW_INSTRUCTIONS = 12,
	SP_FS_EFU_INSTRUCTIONS = 13,
	SP_FS_FULL_ALU_INSTRUCTIONS = 14,
	SP_FS_HALF_ALU_INSTRUCTIONS = 15,
	SP_FS_BARY_INSTRUCTIONS = 16,
	SP_VS_INSTRUCTIONS = 17,
	SP_FS_INSTRUCTIONS = 18,
	SP_ADDR_LOCK_COUNT = 19,
	SP_UCHE_READ_TRANS = 20,
	SP_UCHE_WRITE_TRANS = 21,
	SP_EXPORT_VPC_TRANS = 22,
	SP_EXPORT_RB_TRANS = 23,
	SP_PIXELS_KILLED = 24,
	SP_ICL1_REQUESTS = 25,
	SP_ICL1_MISSES = 26,
	SP_ICL0_REQUESTS = 27,
	SP_ICL0_MISSES = 28,
	SP_ALU_ACTIVE_CYCLES = 29,
	SP_EFU_ACTIVE_CYCLES = 30,
	SP_STALL_CYCLES_BY_VPC = 31,
	SP_STALL_CYCLES_BY_TP = 32,
	SP_STALL_CYCLES_BY_UCHE = 33,
	SP_STALL_CYCLES_BY_RB = 34,
	SP_ACTIVE_CYCLES_ANY = 35,
	SP_ACTIVE_CYCLES_ALL = 36,
};

enum a4xx_cp_perfcounter_select {
	CP_ALWAYS_COUNT = 0,
	CP_BUSY = 1,
	CP_PFP_IDLE = 2,
	CP_PFP_BUSY_WORKING = 3,
	CP_PFP_STALL_CYCLES_ANY = 4,
	CP_PFP_STARVE_CYCLES_ANY = 5,
	CP_PFP_STARVED_PER_LOAD_ADDR = 6,
	CP_PFP_STALLED_PER_STORE_ADDR = 7,
	CP_PFP_PC_PROFILE = 8,
	CP_PFP_MATCH_PM4_PKT_PROFILE = 9,
	CP_PFP_COND_INDIRECT_DISCARDED = 10,
	CP_LONG_RESUMPTIONS = 11,
	CP_RESUME_CYCLES = 12,
	CP_RESUME_TO_BOUNDARY_CYCLES = 13,
	CP_LONG_PREEMPTIONS = 14,
	CP_PREEMPT_CYCLES = 15,
	CP_PREEMPT_TO_BOUNDARY_CYCLES = 16,
	CP_ME_FIFO_EMPTY_PFP_IDLE = 17,
	CP_ME_FIFO_EMPTY_PFP_BUSY = 18,
	CP_ME_FIFO_NOT_EMPTY_NOT_FULL = 19,
	CP_ME_FIFO_FULL_ME_BUSY = 20,
	CP_ME_FIFO_FULL_ME_NON_WORKING = 21,
	CP_ME_WAITING_FOR_PACKETS = 22,
	CP_ME_BUSY_WORKING = 23,
	CP_ME_STARVE_CYCLES_ANY = 24,
	CP_ME_STARVE_CYCLES_PER_PROFILE = 25,
	CP_ME_STALL_CYCLES_PER_PROFILE = 26,
	CP_ME_PC_PROFILE = 27,
	CP_RCIU_FIFO_EMPTY = 28,
	CP_RCIU_FIFO_NOT_EMPTY_NOT_FULL = 29,
	CP_RCIU_FIFO_FULL = 30,
	CP_RCIU_FIFO_FULL_NO_CONTEXT = 31,
	CP_RCIU_FIFO_FULL_AHB_MASTER = 32,
	CP_RCIU_FIFO_FULL_OTHER = 33,
	CP_AHB_IDLE = 34,
	CP_AHB_STALL_ON_GRANT_NO_SPLIT = 35,
	CP_AHB_STALL_ON_GRANT_SPLIT = 36,
	CP_AHB_STALL_ON_GRANT_SPLIT_PROFILE = 37,
	CP_AHB_BUSY_WORKING = 38,
	CP_AHB_BUSY_STALL_ON_HRDY = 39,
	CP_AHB_BUSY_STALL_ON_HRDY_PROFILE = 40,
};

enum a5xx_cp_perfcounter_select {
	PERF_CP_ALWAYS_COUNT = 0,
	PERF_CP_BUSY_GFX_CORE_IDLE = 1,
	PERF_CP_BUSY_CYCLES = 2,
	PERF_CP_PFP_IDLE = 3,
	PERF_CP_PFP_BUSY_WORKING = 4,
	PERF_CP_PFP_STALL_CYCLES_ANY = 5,
	PERF_CP_PFP_STARVE_CYCLES_ANY = 6,
	PERF_CP_PFP_ICACHE_MISS = 7,
	PERF_CP_PFP_ICACHE_HIT = 8,
	PERF_CP_PFP_MATCH_PM4_PKT_PROFILE = 9,
	PERF_CP_ME_BUSY_WORKING = 10,
	PERF_CP_ME_IDLE = 11,
	PERF_CP_ME_STARVE_CYCLES_ANY = 12,
	PERF_CP_ME_FIFO_EMPTY_PFP_IDLE = 13,
	PERF_CP_ME_FIFO_EMPTY_PFP_BUSY = 14,
	PERF_CP_ME_FIFO_FULL_ME_BUSY = 15,
	PERF_CP_ME_FIFO_FULL_ME_NON_WORKING = 16,
	PERF_CP_ME_STALL_CYCLES_ANY = 17,
	PERF_CP_ME_ICACHE_MISS = 18,
	PERF_CP_ME_ICACHE_HIT = 19,
	PERF_CP_NUM_PREEMPTIONS = 20,
	PERF_CP_PREEMPTION_REACTION_DELAY = 21,
	PERF_CP_PREEMPTION_SWITCH_OUT_TIME = 22,
	PERF_CP_PREEMPTION_SWITCH_IN_TIME = 23,
	PERF_CP_DEAD_DRAWS_IN_BIN_RENDER = 24,
	PERF_CP_PREDICATED_DRAWS_KILLED = 25,
	PERF_CP_MODE_SWITCH = 26,
	PERF_CP_ZPASS_DONE = 27,
	PERF_CP_CONTEXT_DONE = 28,
	PERF_CP_CACHE_FLUSH = 29,
	PERF_CP_LONG_PREEMPTIONS = 30,
};

enum a6xx_cp_perfcounter_select {
	PERF_CP_ALWAYS_COUNT___2 = 0,
	PERF_CP_BUSY_GFX_CORE_IDLE___2 = 1,
	PERF_CP_BUSY_CYCLES___2 = 2,
	PERF_CP_NUM_PREEMPTIONS___2 = 3,
	PERF_CP_PREEMPTION_REACTION_DELAY___2 = 4,
	PERF_CP_PREEMPTION_SWITCH_OUT_TIME___2 = 5,
	PERF_CP_PREEMPTION_SWITCH_IN_TIME___2 = 6,
	PERF_CP_DEAD_DRAWS_IN_BIN_RENDER___2 = 7,
	PERF_CP_PREDICATED_DRAWS_KILLED___2 = 8,
	PERF_CP_MODE_SWITCH___2 = 9,
	PERF_CP_ZPASS_DONE___2 = 10,
	PERF_CP_CONTEXT_DONE___2 = 11,
	PERF_CP_CACHE_FLUSH___2 = 12,
	PERF_CP_LONG_PREEMPTIONS___2 = 13,
	PERF_CP_SQE_I_CACHE_STARVE = 14,
	PERF_CP_SQE_IDLE = 15,
	PERF_CP_SQE_PM4_STARVE_RB_IB = 16,
	PERF_CP_SQE_PM4_STARVE_SDS = 17,
	PERF_CP_SQE_MRB_STARVE = 18,
	PERF_CP_SQE_RRB_STARVE = 19,
	PERF_CP_SQE_VSD_STARVE = 20,
	PERF_CP_VSD_DECODE_STARVE = 21,
	PERF_CP_SQE_PIPE_OUT_STALL = 22,
	PERF_CP_SQE_SYNC_STALL = 23,
	PERF_CP_SQE_PM4_WFI_STALL = 24,
	PERF_CP_SQE_SYS_WFI_STALL = 25,
	PERF_CP_SQE_T4_EXEC = 26,
	PERF_CP_SQE_LOAD_STATE_EXEC = 27,
	PERF_CP_SQE_SAVE_SDS_STATE = 28,
	PERF_CP_SQE_DRAW_EXEC = 29,
	PERF_CP_SQE_CTXT_REG_BUNCH_EXEC = 30,
	PERF_CP_SQE_EXEC_PROFILED = 31,
	PERF_CP_MEMORY_POOL_EMPTY = 32,
	PERF_CP_MEMORY_POOL_SYNC_STALL = 33,
	PERF_CP_MEMORY_POOL_ABOVE_THRESH = 34,
	PERF_CP_AHB_WR_STALL_PRE_DRAWS = 35,
	PERF_CP_AHB_STALL_SQE_GMU = 36,
	PERF_CP_AHB_STALL_SQE_WR_OTHER = 37,
	PERF_CP_AHB_STALL_SQE_RD_OTHER = 38,
	PERF_CP_CLUSTER0_EMPTY = 39,
	PERF_CP_CLUSTER1_EMPTY = 40,
	PERF_CP_CLUSTER2_EMPTY = 41,
	PERF_CP_CLUSTER3_EMPTY = 42,
	PERF_CP_CLUSTER4_EMPTY = 43,
	PERF_CP_CLUSTER5_EMPTY = 44,
	PERF_CP_PM4_DATA = 45,
	PERF_CP_PM4_HEADERS = 46,
	PERF_CP_VBIF_READ_BEATS = 47,
	PERF_CP_VBIF_WRITE_BEATS = 48,
	PERF_CP_SQE_INSTR_COUNTER = 49,
};

enum a6xx_debugbus_id {
	A6XX_DBGBUS_CP = 1,
	A6XX_DBGBUS_RBBM = 2,
	A6XX_DBGBUS_VBIF = 3,
	A6XX_DBGBUS_HLSQ = 4,
	A6XX_DBGBUS_UCHE = 5,
	A6XX_DBGBUS_DPM = 6,
	A6XX_DBGBUS_TESS = 7,
	A6XX_DBGBUS_PC = 8,
	A6XX_DBGBUS_VFDP = 9,
	A6XX_DBGBUS_VPC = 10,
	A6XX_DBGBUS_TSE = 11,
	A6XX_DBGBUS_RAS = 12,
	A6XX_DBGBUS_VSC = 13,
	A6XX_DBGBUS_COM = 14,
	A6XX_DBGBUS_LRZ = 16,
	A6XX_DBGBUS_A2D = 17,
	A6XX_DBGBUS_CCUFCHE = 18,
	A6XX_DBGBUS_GMU_CX = 19,
	A6XX_DBGBUS_RBP = 20,
	A6XX_DBGBUS_DCS = 21,
	A6XX_DBGBUS_DBGC = 22,
	A6XX_DBGBUS_CX = 23,
	A6XX_DBGBUS_GMU_GX = 24,
	A6XX_DBGBUS_TPFCHE = 25,
	A6XX_DBGBUS_GBIF_GX = 26,
	A6XX_DBGBUS_GPC = 29,
	A6XX_DBGBUS_LARC = 30,
	A6XX_DBGBUS_HLSQ_SPTP = 31,
	A6XX_DBGBUS_RB_0 = 32,
	A6XX_DBGBUS_RB_1 = 33,
	A6XX_DBGBUS_RB_2 = 34,
	A6XX_DBGBUS_UCHE_WRAPPER = 36,
	A6XX_DBGBUS_CCU_0 = 40,
	A6XX_DBGBUS_CCU_1 = 41,
	A6XX_DBGBUS_CCU_2 = 42,
	A6XX_DBGBUS_VFD_0 = 56,
	A6XX_DBGBUS_VFD_1 = 57,
	A6XX_DBGBUS_VFD_2 = 58,
	A6XX_DBGBUS_VFD_3 = 59,
	A6XX_DBGBUS_VFD_4 = 60,
	A6XX_DBGBUS_VFD_5 = 61,
	A6XX_DBGBUS_SP_0 = 64,
	A6XX_DBGBUS_SP_1 = 65,
	A6XX_DBGBUS_SP_2 = 66,
	A6XX_DBGBUS_TPL1_0 = 72,
	A6XX_DBGBUS_TPL1_1 = 73,
	A6XX_DBGBUS_TPL1_2 = 74,
	A6XX_DBGBUS_TPL1_3 = 75,
	A6XX_DBGBUS_TPL1_4 = 76,
	A6XX_DBGBUS_TPL1_5 = 77,
	A6XX_DBGBUS_SPTP_0 = 88,
	A6XX_DBGBUS_SPTP_1 = 89,
	A6XX_DBGBUS_SPTP_2 = 90,
	A6XX_DBGBUS_SPTP_3 = 91,
	A6XX_DBGBUS_SPTP_4 = 92,
	A6XX_DBGBUS_SPTP_5 = 93,
};

enum a6xx_gmu_oob_state {
	GMU_OOB_BOOT_SLUMBER = 0,
	GMU_OOB_GPU_SET = 1,
	GMU_OOB_DCVS_SET = 2,
	GMU_OOB_PERFCOUNTER_SET = 3,
};

enum a6xx_preempt_state {
	PREEMPT_NONE = 0,
	PREEMPT_START = 1,
	PREEMPT_FINISH = 2,
	PREEMPT_TRIGGERED = 3,
	PREEMPT_FAULTED = 4,
	PREEMPT_PENDING = 5,
};

enum a6xx_shader_id {
	A6XX_TP0_TMO_DATA = 9,
	A6XX_TP0_SMO_DATA = 10,
	A6XX_TP0_MIPMAP_BASE_DATA = 11,
	A6XX_TP1_TMO_DATA = 25,
	A6XX_TP1_SMO_DATA = 26,
	A6XX_TP1_MIPMAP_BASE_DATA = 27,
	A6XX_SP_INST_DATA = 41,
	A6XX_SP_LB_0_DATA = 42,
	A6XX_SP_LB_1_DATA = 43,
	A6XX_SP_LB_2_DATA = 44,
	A6XX_SP_LB_3_DATA = 45,
	A6XX_SP_LB_4_DATA = 46,
	A6XX_SP_LB_5_DATA = 47,
	A6XX_SP_CB_BINDLESS_DATA = 48,
	A6XX_SP_CB_LEGACY_DATA = 49,
	A6XX_SP_GFX_UAV_BASE_DATA = 50,
	A6XX_SP_INST_TAG = 51,
	A6XX_SP_CB_BINDLESS_TAG = 52,
	A6XX_SP_TMO_UMO_TAG = 53,
	A6XX_SP_SMO_TAG = 54,
	A6XX_SP_STATE_DATA = 55,
	A6XX_HLSQ_CHUNK_CVS_RAM = 73,
	A6XX_HLSQ_CHUNK_CPS_RAM = 74,
	A6XX_HLSQ_CHUNK_CVS_RAM_TAG = 75,
	A6XX_HLSQ_CHUNK_CPS_RAM_TAG = 76,
	A6XX_HLSQ_ICB_CVS_CB_BASE_TAG = 77,
	A6XX_HLSQ_ICB_CPS_CB_BASE_TAG = 78,
	A6XX_HLSQ_CVS_MISC_RAM = 80,
	A6XX_HLSQ_CPS_MISC_RAM = 81,
	A6XX_HLSQ_INST_RAM = 82,
	A6XX_HLSQ_GFX_CVS_CONST_RAM = 83,
	A6XX_HLSQ_GFX_CPS_CONST_RAM = 84,
	A6XX_HLSQ_CVS_MISC_RAM_TAG = 85,
	A6XX_HLSQ_CPS_MISC_RAM_TAG = 86,
	A6XX_HLSQ_INST_RAM_TAG = 87,
	A6XX_HLSQ_GFX_CVS_CONST_RAM_TAG = 88,
	A6XX_HLSQ_GFX_CPS_CONST_RAM_TAG = 89,
	A6XX_HLSQ_PWR_REST_RAM = 90,
	A6XX_HLSQ_PWR_REST_TAG = 91,
	A6XX_HLSQ_DATAPATH_META = 96,
	A6XX_HLSQ_FRONTEND_META = 97,
	A6XX_HLSQ_INDIRECT_META = 98,
	A6XX_HLSQ_BACKEND_META = 99,
	A6XX_SP_LB_6_DATA = 112,
	A6XX_SP_LB_7_DATA = 113,
	A6XX_HLSQ_INST_RAM_1 = 115,
};

enum a7xx_cluster {
	A7XX_CLUSTER_NONE = 0,
	A7XX_CLUSTER_FE = 1,
	A7XX_CLUSTER_SP_VS = 2,
	A7XX_CLUSTER_PC_VS = 3,
	A7XX_CLUSTER_GRAS = 4,
	A7XX_CLUSTER_SP_PS = 5,
	A7XX_CLUSTER_VPC_PS = 6,
	A7XX_CLUSTER_PS = 7,
};

enum a7xx_debugbus_id {
	A7XX_DBGBUS_CP_0_0 = 1,
	A7XX_DBGBUS_CP_0_1 = 2,
	A7XX_DBGBUS_RBBM = 3,
	A7XX_DBGBUS_GBIF_GX = 5,
	A7XX_DBGBUS_GBIF_CX = 6,
	A7XX_DBGBUS_HLSQ = 7,
	A7XX_DBGBUS_UCHE_0 = 9,
	A7XX_DBGBUS_UCHE_1 = 10,
	A7XX_DBGBUS_TESS_BR = 13,
	A7XX_DBGBUS_TESS_BV = 14,
	A7XX_DBGBUS_PC_BR = 17,
	A7XX_DBGBUS_PC_BV = 18,
	A7XX_DBGBUS_VFDP_BR = 21,
	A7XX_DBGBUS_VFDP_BV = 22,
	A7XX_DBGBUS_VPC_BR = 25,
	A7XX_DBGBUS_VPC_BV = 26,
	A7XX_DBGBUS_TSE_BR = 29,
	A7XX_DBGBUS_TSE_BV = 30,
	A7XX_DBGBUS_RAS_BR = 33,
	A7XX_DBGBUS_RAS_BV = 34,
	A7XX_DBGBUS_VSC = 37,
	A7XX_DBGBUS_COM_0 = 39,
	A7XX_DBGBUS_LRZ_BR = 43,
	A7XX_DBGBUS_LRZ_BV = 44,
	A7XX_DBGBUS_UFC_0 = 47,
	A7XX_DBGBUS_UFC_1 = 48,
	A7XX_DBGBUS_GMU_GX = 55,
	A7XX_DBGBUS_DBGC = 59,
	A7XX_DBGBUS_CX = 60,
	A7XX_DBGBUS_GMU_CX = 61,
	A7XX_DBGBUS_GPC_BR = 62,
	A7XX_DBGBUS_GPC_BV = 63,
	A7XX_DBGBUS_LARC = 66,
	A7XX_DBGBUS_HLSQ_SPTP = 68,
	A7XX_DBGBUS_RB_0 = 70,
	A7XX_DBGBUS_RB_1 = 71,
	A7XX_DBGBUS_RB_2 = 72,
	A7XX_DBGBUS_RB_3 = 73,
	A7XX_DBGBUS_RB_4 = 74,
	A7XX_DBGBUS_RB_5 = 75,
	A7XX_DBGBUS_UCHE_WRAPPER = 102,
	A7XX_DBGBUS_CCU_0 = 106,
	A7XX_DBGBUS_CCU_1 = 107,
	A7XX_DBGBUS_CCU_2 = 108,
	A7XX_DBGBUS_CCU_3 = 109,
	A7XX_DBGBUS_CCU_4 = 110,
	A7XX_DBGBUS_CCU_5 = 111,
	A7XX_DBGBUS_VFD_BR_0 = 138,
	A7XX_DBGBUS_VFD_BR_1 = 139,
	A7XX_DBGBUS_VFD_BR_2 = 140,
	A7XX_DBGBUS_VFD_BR_3 = 141,
	A7XX_DBGBUS_VFD_BR_4 = 142,
	A7XX_DBGBUS_VFD_BR_5 = 143,
	A7XX_DBGBUS_VFD_BR_6 = 144,
	A7XX_DBGBUS_VFD_BR_7 = 145,
	A7XX_DBGBUS_VFD_BV_0 = 202,
	A7XX_DBGBUS_VFD_BV_1 = 203,
	A7XX_DBGBUS_VFD_BV_2 = 204,
	A7XX_DBGBUS_VFD_BV_3 = 205,
	A7XX_DBGBUS_USP_0 = 234,
	A7XX_DBGBUS_USP_1 = 235,
	A7XX_DBGBUS_USP_2 = 236,
	A7XX_DBGBUS_USP_3 = 237,
	A7XX_DBGBUS_USP_4 = 238,
	A7XX_DBGBUS_USP_5 = 239,
	A7XX_DBGBUS_TP_0 = 266,
	A7XX_DBGBUS_TP_1 = 267,
	A7XX_DBGBUS_TP_2 = 268,
	A7XX_DBGBUS_TP_3 = 269,
	A7XX_DBGBUS_TP_4 = 270,
	A7XX_DBGBUS_TP_5 = 271,
	A7XX_DBGBUS_TP_6 = 272,
	A7XX_DBGBUS_TP_7 = 273,
	A7XX_DBGBUS_TP_8 = 274,
	A7XX_DBGBUS_TP_9 = 275,
	A7XX_DBGBUS_TP_10 = 276,
	A7XX_DBGBUS_TP_11 = 277,
	A7XX_DBGBUS_USPTP_0 = 330,
	A7XX_DBGBUS_USPTP_1 = 331,
	A7XX_DBGBUS_USPTP_2 = 332,
	A7XX_DBGBUS_USPTP_3 = 333,
	A7XX_DBGBUS_USPTP_4 = 334,
	A7XX_DBGBUS_USPTP_5 = 335,
	A7XX_DBGBUS_USPTP_6 = 336,
	A7XX_DBGBUS_USPTP_7 = 337,
	A7XX_DBGBUS_USPTP_8 = 338,
	A7XX_DBGBUS_USPTP_9 = 339,
	A7XX_DBGBUS_USPTP_10 = 340,
	A7XX_DBGBUS_USPTP_11 = 341,
	A7XX_DBGBUS_CCHE_0 = 396,
	A7XX_DBGBUS_CCHE_1 = 397,
	A7XX_DBGBUS_CCHE_2 = 398,
	A7XX_DBGBUS_VPC_DSTR_0 = 408,
	A7XX_DBGBUS_VPC_DSTR_1 = 409,
	A7XX_DBGBUS_VPC_DSTR_2 = 410,
	A7XX_DBGBUS_HLSQ_DP_STR_0 = 411,
	A7XX_DBGBUS_HLSQ_DP_STR_1 = 412,
	A7XX_DBGBUS_HLSQ_DP_STR_2 = 413,
	A7XX_DBGBUS_HLSQ_DP_STR_3 = 414,
	A7XX_DBGBUS_HLSQ_DP_STR_4 = 415,
	A7XX_DBGBUS_HLSQ_DP_STR_5 = 416,
	A7XX_DBGBUS_UFC_DSTR_0 = 443,
	A7XX_DBGBUS_UFC_DSTR_1 = 444,
	A7XX_DBGBUS_UFC_DSTR_2 = 445,
	A7XX_DBGBUS_CGC_SUBCORE = 446,
	A7XX_DBGBUS_CGC_CORE = 447,
};

enum a7xx_pipe {
	A7XX_PIPE_NONE = 0,
	A7XX_PIPE_BR = 1,
	A7XX_PIPE_BV = 2,
	A7XX_PIPE_LPAC = 3,
};

enum a7xx_state_location {
	A7XX_HLSQ_STATE = 0,
	A7XX_HLSQ_DP = 1,
	A7XX_SP_TOP = 2,
	A7XX_USPTP = 3,
	A7XX_HLSQ_DP_STR = 4,
};

enum a7xx_statetype_id {
	A7XX_TP0_NCTX_REG = 0,
	A7XX_TP0_CTX0_3D_CVS_REG = 1,
	A7XX_TP0_CTX0_3D_CPS_REG = 2,
	A7XX_TP0_CTX1_3D_CVS_REG = 3,
	A7XX_TP0_CTX1_3D_CPS_REG = 4,
	A7XX_TP0_CTX2_3D_CPS_REG = 5,
	A7XX_TP0_CTX3_3D_CPS_REG = 6,
	A7XX_TP0_TMO_DATA = 9,
	A7XX_TP0_SMO_DATA = 10,
	A7XX_TP0_MIPMAP_BASE_DATA = 11,
	A7XX_SP_NCTX_REG = 32,
	A7XX_SP_CTX0_3D_CVS_REG = 33,
	A7XX_SP_CTX0_3D_CPS_REG = 34,
	A7XX_SP_CTX1_3D_CVS_REG = 35,
	A7XX_SP_CTX1_3D_CPS_REG = 36,
	A7XX_SP_CTX2_3D_CPS_REG = 37,
	A7XX_SP_CTX3_3D_CPS_REG = 38,
	A7XX_SP_INST_DATA = 39,
	A7XX_SP_INST_DATA_1 = 40,
	A7XX_SP_LB_0_DATA = 41,
	A7XX_SP_LB_1_DATA = 42,
	A7XX_SP_LB_2_DATA = 43,
	A7XX_SP_LB_3_DATA = 44,
	A7XX_SP_LB_4_DATA = 45,
	A7XX_SP_LB_5_DATA = 46,
	A7XX_SP_LB_6_DATA = 47,
	A7XX_SP_LB_7_DATA = 48,
	A7XX_SP_CB_RAM = 49,
	A7XX_SP_LB_13_DATA = 50,
	A7XX_SP_LB_14_DATA = 51,
	A7XX_SP_INST_TAG = 52,
	A7XX_SP_INST_DATA_2 = 53,
	A7XX_SP_TMO_TAG = 54,
	A7XX_SP_SMO_TAG = 55,
	A7XX_SP_STATE_DATA = 56,
	A7XX_SP_HWAVE_RAM = 57,
	A7XX_SP_L0_INST_BUF = 58,
	A7XX_SP_LB_8_DATA = 59,
	A7XX_SP_LB_9_DATA = 60,
	A7XX_SP_LB_10_DATA = 61,
	A7XX_SP_LB_11_DATA = 62,
	A7XX_SP_LB_12_DATA = 63,
	A7XX_HLSQ_DATAPATH_DSTR_META = 64,
	A7XX_HLSQ_L2STC_TAG_RAM = 67,
	A7XX_HLSQ_L2STC_INFO_CMD = 68,
	A7XX_HLSQ_CVS_BE_CTXT_BUF_RAM_TAG = 69,
	A7XX_HLSQ_CPS_BE_CTXT_BUF_RAM_TAG = 70,
	A7XX_HLSQ_GFX_CVS_BE_CTXT_BUF_RAM = 71,
	A7XX_HLSQ_GFX_CPS_BE_CTXT_BUF_RAM = 72,
	A7XX_HLSQ_CHUNK_CVS_RAM = 73,
	A7XX_HLSQ_CHUNK_CPS_RAM = 74,
	A7XX_HLSQ_CHUNK_CVS_RAM_TAG = 75,
	A7XX_HLSQ_CHUNK_CPS_RAM_TAG = 76,
	A7XX_HLSQ_ICB_CVS_CB_BASE_TAG = 77,
	A7XX_HLSQ_ICB_CPS_CB_BASE_TAG = 78,
	A7XX_HLSQ_CVS_MISC_RAM = 79,
	A7XX_HLSQ_CPS_MISC_RAM = 80,
	A7XX_HLSQ_CPS_MISC_RAM_1 = 81,
	A7XX_HLSQ_INST_RAM = 82,
	A7XX_HLSQ_GFX_CVS_CONST_RAM = 83,
	A7XX_HLSQ_GFX_CPS_CONST_RAM = 84,
	A7XX_HLSQ_CVS_MISC_RAM_TAG = 85,
	A7XX_HLSQ_CPS_MISC_RAM_TAG = 86,
	A7XX_HLSQ_INST_RAM_TAG = 87,
	A7XX_HLSQ_GFX_CVS_CONST_RAM_TAG = 88,
	A7XX_HLSQ_GFX_CPS_CONST_RAM_TAG = 89,
	A7XX_HLSQ_GFX_LOCAL_MISC_RAM = 90,
	A7XX_HLSQ_GFX_LOCAL_MISC_RAM_TAG = 91,
	A7XX_HLSQ_INST_RAM_1 = 92,
	A7XX_HLSQ_STPROC_META = 93,
	A7XX_HLSQ_BV_BE_META = 94,
	A7XX_HLSQ_INST_RAM_2 = 95,
	A7XX_HLSQ_DATAPATH_META = 96,
	A7XX_HLSQ_FRONTEND_META = 97,
	A7XX_HLSQ_INDIRECT_META = 98,
	A7XX_HLSQ_BACKEND_META = 99,
};

enum actions {
	REGISTER = 0,
	DEREGISTER = 1,
	CPU_DONT_CARE = 2,
};

enum adc_sort_mode {
	ADC_DECREMENT = 0,
	ADC_INCREMENT = 1,
};

enum addr_type_t {
	UNICAST_ADDR = 0,
	MULTICAST_ADDR = 1,
	ANYCAST_ADDR = 2,
};

enum adreno_family {
	ADRENO_2XX_GEN1 = 0,
	ADRENO_2XX_GEN2 = 1,
	ADRENO_3XX = 2,
	ADRENO_4XX = 3,
	ADRENO_5XX = 4,
	ADRENO_6XX_GEN1 = 5,
	ADRENO_6XX_GEN2 = 6,
	ADRENO_6XX_GEN3 = 7,
	ADRENO_6XX_GEN4 = 8,
	ADRENO_7XX_GEN1 = 9,
	ADRENO_7XX_GEN2 = 10,
	ADRENO_7XX_GEN3 = 11,
};

enum adreno_mmu_clnt_beh {
	BEH_NEVR = 0,
	BEH_TRAN_RNG = 1,
	BEH_TRAN_FLT = 2,
};

enum adreno_pm4_packet_type {
	CP_TYPE0_PKT = 0,
	CP_TYPE1_PKT = 1073741824,
	CP_TYPE2_PKT = 2147483648,
	CP_TYPE3_PKT = 3221225472,
	CP_TYPE4_PKT = 1073741824,
	CP_TYPE7_PKT = 1879048192,
};

enum adreno_pm4_type3_packets {
	CP_ME_INIT = 72,
	CP_NOP = 16,
	CP_PREEMPT_ENABLE = 28,
	CP_PREEMPT_TOKEN = 30,
	CP_INDIRECT_BUFFER = 63,
	CP_INDIRECT_BUFFER_CHAIN = 87,
	CP_INDIRECT_BUFFER_PFD = 55,
	CP_WAIT_FOR_IDLE = 38,
	CP_WAIT_REG_MEM = 60,
	CP_WAIT_REG_EQ = 82,
	CP_WAIT_REG_GTE = 83,
	CP_WAIT_UNTIL_READ = 92,
	CP_WAIT_IB_PFD_COMPLETE = 93,
	CP_REG_RMW = 33,
	CP_SET_BIN_DATA = 47,
	CP_SET_BIN_DATA5 = 47,
	CP_REG_TO_MEM = 62,
	CP_MEM_WRITE = 61,
	CP_MEM_WRITE_CNTR = 79,
	CP_COND_EXEC = 68,
	CP_COND_WRITE = 69,
	CP_COND_WRITE5 = 69,
	CP_EVENT_WRITE = 70,
	CP_EVENT_WRITE7 = 70,
	CP_EVENT_WRITE_SHD = 88,
	CP_EVENT_WRITE_CFL = 89,
	CP_EVENT_WRITE_ZPD = 91,
	CP_RUN_OPENCL = 49,
	CP_DRAW_INDX = 34,
	CP_DRAW_INDX_2 = 54,
	CP_DRAW_INDX_BIN = 52,
	CP_DRAW_INDX_2_BIN = 53,
	CP_VIZ_QUERY = 35,
	CP_SET_STATE = 37,
	CP_SET_CONSTANT = 45,
	CP_IM_LOAD = 39,
	CP_IM_LOAD_IMMEDIATE = 43,
	CP_LOAD_CONSTANT_CONTEXT = 46,
	CP_INVALIDATE_STATE = 59,
	CP_SET_SHADER_BASES = 74,
	CP_SET_BIN_MASK = 80,
	CP_SET_BIN_SELECT = 81,
	CP_CONTEXT_UPDATE = 94,
	CP_INTERRUPT = 64,
	CP_IM_STORE = 44,
	CP_SET_DRAW_INIT_FLAGS = 75,
	CP_SET_PROTECTED_MODE = 95,
	CP_BOOTSTRAP_UCODE = 111,
	CP_LOAD_STATE = 48,
	CP_LOAD_STATE4 = 48,
	CP_COND_INDIRECT_BUFFER_PFE = 58,
	CP_COND_INDIRECT_BUFFER_PFD = 50,
	CP_INDIRECT_BUFFER_PFE = 63,
	CP_SET_BIN = 76,
	CP_TEST_TWO_MEMS = 113,
	CP_REG_WR_NO_CTXT = 120,
	CP_RECORD_PFP_TIMESTAMP = 17,
	CP_SET_SECURE_MODE = 102,
	CP_WAIT_FOR_ME = 19,
	CP_SET_DRAW_STATE = 67,
	CP_DRAW_INDX_OFFSET = 56,
	CP_DRAW_INDIRECT = 40,
	CP_DRAW_INDX_INDIRECT = 41,
	CP_DRAW_INDIRECT_MULTI = 42,
	CP_DRAW_AUTO = 36,
	CP_DRAW_PRED_ENABLE_GLOBAL = 25,
	CP_DRAW_PRED_ENABLE_LOCAL = 26,
	CP_DRAW_PRED_SET = 78,
	CP_WIDE_REG_WRITE = 116,
	CP_SCRATCH_TO_REG = 77,
	CP_REG_TO_SCRATCH = 74,
	CP_WAIT_MEM_WRITES = 18,
	CP_COND_REG_EXEC = 71,
	CP_MEM_TO_REG = 66,
	CP_EXEC_CS_INDIRECT = 65,
	CP_EXEC_CS = 51,
	CP_PERFCOUNTER_ACTION = 80,
	CP_SMMU_TABLE_UPDATE = 83,
	CP_SET_MARKER = 101,
	CP_SET_PSEUDO_REG = 86,
	CP_CONTEXT_REG_BUNCH = 92,
	CP_YIELD_ENABLE = 28,
	CP_SKIP_IB2_ENABLE_GLOBAL = 29,
	CP_SKIP_IB2_ENABLE_LOCAL = 35,
	CP_SET_SUBDRAW_SIZE = 53,
	CP_WHERE_AM_I = 98,
	CP_SET_VISIBILITY_OVERRIDE = 100,
	CP_PREEMPT_ENABLE_GLOBAL = 105,
	CP_PREEMPT_ENABLE_LOCAL = 106,
	CP_CONTEXT_SWITCH_YIELD = 107,
	CP_SET_RENDER_MODE = 108,
	CP_COMPUTE_CHECKPOINT = 110,
	CP_MEM_TO_MEM = 115,
	CP_BLIT = 44,
	CP_REG_TEST = 57,
	CP_SET_MODE = 99,
	CP_LOAD_STATE6_GEOM = 50,
	CP_LOAD_STATE6_FRAG = 52,
	CP_LOAD_STATE6 = 54,
	IN_IB_PREFETCH_END = 23,
	IN_SUBBLK_PREFETCH = 31,
	IN_INSTR_PREFETCH = 32,
	IN_INSTR_MATCH = 71,
	IN_CONST_PREFETCH = 73,
	IN_INCR_UPDT_STATE = 85,
	IN_INCR_UPDT_CONST = 86,
	IN_INCR_UPDT_INSTR = 87,
	PKT4 = 4,
	IN_IB_END = 10,
	IN_GMU_INTERRUPT = 11,
	IN_PREEMPT = 15,
	CP_SCRATCH_WRITE = 76,
	CP_REG_TO_MEM_OFFSET_MEM = 116,
	CP_REG_TO_MEM_OFFSET_REG = 114,
	CP_WAIT_MEM_GTE = 20,
	CP_WAIT_TWO_REGS = 112,
	CP_MEMCPY = 117,
	CP_SET_BIN_DATA5_OFFSET = 46,
	CP_SET_UNK_BIN_DATA = 45,
	CP_CONTEXT_SWITCH = 84,
	CP_SET_AMBLE = 85,
	CP_REG_WRITE = 109,
	CP_START_BIN = 80,
	CP_END_BIN = 81,
	CP_PREEMPT_DISABLE = 108,
	CP_WAIT_TIMESTAMP = 20,
	CP_GLOBAL_TIMESTAMP = 21,
	CP_LOCAL_TIMESTAMP = 22,
	CP_THREAD_CONTROL = 23,
	CP_RESOURCE_LIST = 24,
	CP_BV_BR_COUNT_OPS = 27,
	CP_MODIFY_TIMESTAMP = 28,
	CP_CONTEXT_REG_BUNCH2 = 93,
	CP_MEM_TO_SCRATCH_MEM = 73,
	CP_FIXED_STRIDE_DRAW_TABLE = 127,
	CP_RESET_CONTEXT_STATE = 31,
	CP_CCHE_INVALIDATE = 58,
	CP_SCOPE_CNTL = 108,
};

enum ahci_imx_type {
	AHCI_IMX53 = 0,
	AHCI_IMX6Q = 1,
	AHCI_IMX6QP = 2,
	AHCI_IMX8QM = 3,
};

enum ahci_qoriq_type {
	AHCI_LS1021A = 0,
	AHCI_LS1028A = 1,
	AHCI_LS1043A = 2,
	AHCI_LS2080A = 3,
	AHCI_LS1046A = 4,
	AHCI_LS1088A = 5,
	AHCI_LS2088A = 6,
	AHCI_LX2160A = 7,
};

enum alarmtimer_type {
	ALARM_REALTIME = 0,
	ALARM_BOOTTIME = 1,
	ALARM_NUMTYPE = 2,
	ALARM_REALTIME_FREEZER = 3,
	ALARM_BOOTTIME_FREEZER = 4,
};

enum ale_fields {
	MINOR_VER = 0,
	MAJOR_VER = 1,
	ALE_ENTRIES = 2,
	ALE_POLICERS = 3,
	POL_PORT_MEN = 4,
	POL_TRUNK_ID = 5,
	POL_PORT_NUM = 6,
	POL_PRI_MEN = 7,
	POL_PRI_VAL = 8,
	POL_OUI_MEN = 9,
	POL_OUI_INDEX = 10,
	POL_DST_MEN = 11,
	POL_DST_INDEX = 12,
	POL_SRC_MEN = 13,
	POL_SRC_INDEX = 14,
	POL_OVLAN_MEN = 15,
	POL_OVLAN_INDEX = 16,
	POL_IVLAN_MEN = 17,
	POL_IVLAN_INDEX = 18,
	POL_ETHERTYPE_MEN = 19,
	POL_ETHERTYPE_INDEX = 20,
	POL_IPSRC_MEN = 21,
	POL_IPSRC_INDEX = 22,
	POL_IPDST_MEN = 23,
	POL_IPDST_INDEX = 24,
	POL_EN = 25,
	POL_RED_DROP_EN = 26,
	POL_YELLOW_DROP_EN = 27,
	POL_YELLOW_THRESH = 28,
	POL_POL_MATCH_MODE = 29,
	POL_PRIORITY_THREAD_EN = 30,
	POL_MAC_ONLY_DEF_DIS = 31,
	POL_TEST_CLR = 32,
	POL_TEST_CLR_RED = 33,
	POL_TEST_CLR_YELLOW = 34,
	POL_TEST_CLR_SELECTED = 35,
	POL_TEST_ENTRY = 36,
	POL_STATUS_HIT = 37,
	POL_STATUS_HIT_RED = 38,
	POL_STATUS_HIT_YELLOW = 39,
	ALE_DEFAULT_THREAD_EN = 40,
	ALE_DEFAULT_THREAD_VAL = 41,
	ALE_THREAD_CLASS_INDEX = 42,
	ALE_THREAD_ENABLE = 43,
	ALE_THREAD_VALUE = 44,
	ALE_FIELDS_MAX = 45,
};

enum alpha_cal_mode {
	ALPHA_SATURATION = 0,
	ALPHA_NO_SATURATION = 1,
};

enum alpha_mode {
	ALPHA_STRAIGHT = 0,
	ALPHA_INVERSE = 1,
};

enum altera_mbox_msg {
	MBOX_CMD = 0,
	MBOX_PTR = 1,
};

enum amble_type {
	PREAMBLE_AMBLE_TYPE = 0,
	BIN_PREAMBLE_AMBLE_TYPE = 1,
	POSTAMBLE_AMBLE_TYPE = 2,
	KMD_AMBLE_TYPE = 3,
};

enum amd_chipset_gen {
	AMD_CHIPSET_BEFORE_ML = 0,
	AMD_CHIPSET_CZ = 1,
	AMD_CHIPSET_NL = 2,
	AMD_CHIPSET_UNKNOWN = 3,
};

enum analog_power_block {
	AUX_BLOCK = 0,
	CH0_BLOCK = 1,
	CH1_BLOCK = 2,
	CH2_BLOCK = 3,
	CH3_BLOCK = 4,
	ANALOG_TOTAL = 5,
	POWER_ALL = 6,
};

enum analogix_dp_devtype {
	EXYNOS_DP = 0,
	RK3288_DP = 1,
	RK3399_EDP = 2,
	RK3588_EDP = 3,
};

enum arch_timer_ppi_nr {
	ARCH_TIMER_PHYS_SECURE_PPI = 0,
	ARCH_TIMER_PHYS_NONSECURE_PPI = 1,
	ARCH_TIMER_VIRT_PPI = 2,
	ARCH_TIMER_HYP_PPI = 3,
	ARCH_TIMER_HYP_VIRT_PPI = 4,
	ARCH_TIMER_MAX_TIMER_PPI = 5,
};

enum arch_timer_reg {
	ARCH_TIMER_REG_CTRL = 0,
	ARCH_TIMER_REG_CVAL = 1,
};

enum arch_timer_spi_nr {
	ARCH_TIMER_PHYS_SPI = 0,
	ARCH_TIMER_VIRT_SPI = 1,
	ARCH_TIMER_MAX_TIMER_SPI = 2,
};

enum arm_regset {
	REGSET_GPR = 0,
	REGSET_FPR = 1,
	REGSET_VFP = 2,
};

enum arm_smccc_conduit {
	SMCCC_CONDUIT_NONE = 0,
	SMCCC_CONDUIT_SMC = 1,
	SMCCC_CONDUIT_HVC = 2,
};

enum armpmu_attr_groups {
	ARMPMU_ATTR_GROUP_COMMON = 0,
	ARMPMU_ATTR_GROUP_EVENTS = 1,
	ARMPMU_ATTR_GROUP_FORMATS = 2,
	ARMPMU_ATTR_GROUP_CAPS = 3,
	ARMPMU_NR_ATTR_GROUPS = 4,
};

enum as3722_irq {
	AS3722_IRQ_LID = 0,
	AS3722_IRQ_ACOK = 1,
	AS3722_IRQ_ENABLE1 = 2,
	AS3722_IRQ_OCCUR_ALARM_SD0 = 3,
	AS3722_IRQ_ONKEY_LONG_PRESS = 4,
	AS3722_IRQ_ONKEY = 5,
	AS3722_IRQ_OVTMP = 6,
	AS3722_IRQ_LOWBAT = 7,
	AS3722_IRQ_SD0_LV = 8,
	AS3722_IRQ_SD1_LV = 9,
	AS3722_IRQ_SD2_LV = 10,
	AS3722_IRQ_PWM1_OV_PROT = 11,
	AS3722_IRQ_PWM2_OV_PROT = 12,
	AS3722_IRQ_ENABLE2 = 13,
	AS3722_IRQ_SD6_LV = 14,
	AS3722_IRQ_RTC_REP = 15,
	AS3722_IRQ_RTC_ALARM = 16,
	AS3722_IRQ_GPIO1 = 17,
	AS3722_IRQ_GPIO2 = 18,
	AS3722_IRQ_GPIO3 = 19,
	AS3722_IRQ_GPIO4 = 20,
	AS3722_IRQ_GPIO5 = 21,
	AS3722_IRQ_WATCHDOG = 22,
	AS3722_IRQ_ENABLE3 = 23,
	AS3722_IRQ_TEMP_SD0_SHUTDOWN = 24,
	AS3722_IRQ_TEMP_SD1_SHUTDOWN = 25,
	AS3722_IRQ_TEMP_SD2_SHUTDOWN = 26,
	AS3722_IRQ_TEMP_SD0_ALARM = 27,
	AS3722_IRQ_TEMP_SD1_ALARM = 28,
	AS3722_IRQ_TEMP_SD6_ALARM = 29,
	AS3722_IRQ_OCCUR_ALARM_SD6 = 30,
	AS3722_IRQ_ADC = 31,
	AS3722_IRQ_MAX = 32,
};

enum as3722_pinmux_option {
	AS3722_PINMUX_GPIO = 0,
	AS3722_PINMUX_INTERRUPT_OUT = 1,
	AS3722_PINMUX_VSUB_VBAT_UNDEB_LOW_OUT = 2,
	AS3722_PINMUX_GPIO_INTERRUPT = 3,
	AS3722_PINMUX_PWM_INPUT = 4,
	AS3722_PINMUX_VOLTAGE_IN_STBY = 5,
	AS3722_PINMUX_OC_PG_SD0 = 6,
	AS3722_PINMUX_PG_OUT = 7,
	AS3722_PINMUX_CLK32K_OUT = 8,
	AS3722_PINMUX_WATCHDOG_INPUT = 9,
	AS3722_PINMUX_SOFT_RESET_IN = 11,
	AS3722_PINMUX_PWM_OUTPUT = 12,
	AS3722_PINMUX_VSUB_VBAT_LOW_DEB_OUT = 13,
	AS3722_PINMUX_OC_PG_SD6 = 14,
};

enum as3722_regulators_id {
	AS3722_REGULATOR_ID_SD0 = 0,
	AS3722_REGULATOR_ID_SD1 = 1,
	AS3722_REGULATOR_ID_SD2 = 2,
	AS3722_REGULATOR_ID_SD3 = 3,
	AS3722_REGULATOR_ID_SD4 = 4,
	AS3722_REGULATOR_ID_SD5 = 5,
	AS3722_REGULATOR_ID_SD6 = 6,
	AS3722_REGULATOR_ID_LDO0 = 7,
	AS3722_REGULATOR_ID_LDO1 = 8,
	AS3722_REGULATOR_ID_LDO2 = 9,
	AS3722_REGULATOR_ID_LDO3 = 10,
	AS3722_REGULATOR_ID_LDO4 = 11,
	AS3722_REGULATOR_ID_LDO5 = 12,
	AS3722_REGULATOR_ID_LDO6 = 13,
	AS3722_REGULATOR_ID_LDO7 = 14,
	AS3722_REGULATOR_ID_LDO9 = 15,
	AS3722_REGULATOR_ID_LDO10 = 16,
	AS3722_REGULATOR_ID_LDO11 = 17,
	AS3722_REGULATOR_ID_MAX = 18,
};

enum asn1_class {
	ASN1_UNIV = 0,
	ASN1_APPL = 1,
	ASN1_CONT = 2,
	ASN1_PRIV = 3,
};

enum asn1_method {
	ASN1_PRIM = 0,
	ASN1_CONS = 1,
};

enum asn1_opcode {
	ASN1_OP_MATCH = 0,
	ASN1_OP_MATCH_OR_SKIP = 1,
	ASN1_OP_MATCH_ACT = 2,
	ASN1_OP_MATCH_ACT_OR_SKIP = 3,
	ASN1_OP_MATCH_JUMP = 4,
	ASN1_OP_MATCH_JUMP_OR_SKIP = 5,
	ASN1_OP_MATCH_ANY = 8,
	ASN1_OP_MATCH_ANY_OR_SKIP = 9,
	ASN1_OP_MATCH_ANY_ACT = 10,
	ASN1_OP_MATCH_ANY_ACT_OR_SKIP = 11,
	ASN1_OP_COND_MATCH_OR_SKIP = 17,
	ASN1_OP_COND_MATCH_ACT_OR_SKIP = 19,
	ASN1_OP_COND_MATCH_JUMP_OR_SKIP = 21,
	ASN1_OP_COND_MATCH_ANY = 24,
	ASN1_OP_COND_MATCH_ANY_OR_SKIP = 25,
	ASN1_OP_COND_MATCH_ANY_ACT = 26,
	ASN1_OP_COND_MATCH_ANY_ACT_OR_SKIP = 27,
	ASN1_OP_COND_FAIL = 28,
	ASN1_OP_COMPLETE = 29,
	ASN1_OP_ACT = 30,
	ASN1_OP_MAYBE_ACT = 31,
	ASN1_OP_END_SEQ = 32,
	ASN1_OP_END_SET = 33,
	ASN1_OP_END_SEQ_OF = 34,
	ASN1_OP_END_SET_OF = 35,
	ASN1_OP_END_SEQ_ACT = 36,
	ASN1_OP_END_SET_ACT = 37,
	ASN1_OP_END_SEQ_OF_ACT = 38,
	ASN1_OP_END_SET_OF_ACT = 39,
	ASN1_OP_RETURN = 40,
	ASN1_OP__NR = 41,
};

enum asn1_tag {
	ASN1_EOC = 0,
	ASN1_BOOL = 1,
	ASN1_INT = 2,
	ASN1_BTS = 3,
	ASN1_OTS = 4,
	ASN1_NULL = 5,
	ASN1_OID = 6,
	ASN1_ODE = 7,
	ASN1_EXT = 8,
	ASN1_REAL = 9,
	ASN1_ENUM = 10,
	ASN1_EPDV = 11,
	ASN1_UTF8STR = 12,
	ASN1_RELOID = 13,
	ASN1_SEQ = 16,
	ASN1_SET = 17,
	ASN1_NUMSTR = 18,
	ASN1_PRNSTR = 19,
	ASN1_TEXSTR = 20,
	ASN1_VIDSTR = 21,
	ASN1_IA5STR = 22,
	ASN1_UNITIM = 23,
	ASN1_GENTIM = 24,
	ASN1_GRASTR = 25,
	ASN1_VISSTR = 26,
	ASN1_GENSTR = 27,
	ASN1_UNISTR = 28,
	ASN1_CHRSTR = 29,
	ASN1_BMPSTR = 30,
	ASN1_LONG_TAG = 31,
};

enum assoc_array_walk_status {
	assoc_array_walk_tree_empty = 0,
	assoc_array_walk_found_terminal_node = 1,
	assoc_array_walk_found_wrong_shortcut = 2,
};

enum asymmetric_payload_bits {
	asym_crypto = 0,
	asym_subtype = 1,
	asym_key_ids = 2,
	asym_auth = 3,
};

enum ata_completion_errors {
	AC_ERR_OK = 0,
	AC_ERR_DEV = 1,
	AC_ERR_HSM = 2,
	AC_ERR_TIMEOUT = 4,
	AC_ERR_MEDIA = 8,
	AC_ERR_ATA_BUS = 16,
	AC_ERR_HOST_BUS = 32,
	AC_ERR_SYSTEM = 64,
	AC_ERR_INVALID = 128,
	AC_ERR_OTHER = 256,
	AC_ERR_NODEV_HINT = 512,
	AC_ERR_NCQ = 1024,
};

enum ata_dev_iter_mode {
	ATA_DITER_ENABLED = 0,
	ATA_DITER_ENABLED_REVERSE = 1,
	ATA_DITER_ALL = 2,
	ATA_DITER_ALL_REVERSE = 3,
};

enum ata_link_iter_mode {
	ATA_LITER_EDGE = 0,
	ATA_LITER_HOST_FIRST = 1,
	ATA_LITER_PMP_FIRST = 2,
};

enum ata_lpm_hints {
	ATA_LPM_EMPTY = 1,
	ATA_LPM_HIPM = 2,
	ATA_LPM_WAKE_ONLY = 4,
};

enum ata_lpm_policy {
	ATA_LPM_UNKNOWN = 0,
	ATA_LPM_MAX_POWER = 1,
	ATA_LPM_MED_POWER = 2,
	ATA_LPM_MED_POWER_WITH_DIPM = 3,
	ATA_LPM_MIN_POWER_WITH_PARTIAL = 4,
	ATA_LPM_MIN_POWER = 5,
};

enum ata_prot_flags {
	ATA_PROT_FLAG_PIO = 1,
	ATA_PROT_FLAG_DMA = 2,
	ATA_PROT_FLAG_NCQ = 4,
	ATA_PROT_FLAG_ATAPI = 8,
	ATA_PROT_UNKNOWN = 255,
	ATA_PROT_NODATA = 0,
	ATA_PROT_PIO = 1,
	ATA_PROT_DMA = 2,
	ATA_PROT_NCQ_NODATA = 4,
	ATA_PROT_NCQ = 6,
	ATAPI_PROT_NODATA = 8,
	ATAPI_PROT_PIO = 9,
	ATAPI_PROT_DMA = 10,
};

enum ata_quirks {
	__ATA_QUIRK_DIAGNOSTIC = 0,
	__ATA_QUIRK_NODMA = 1,
	__ATA_QUIRK_NONCQ = 2,
	__ATA_QUIRK_MAX_SEC_128 = 3,
	__ATA_QUIRK_BROKEN_HPA = 4,
	__ATA_QUIRK_DISABLE = 5,
	__ATA_QUIRK_HPA_SIZE = 6,
	__ATA_QUIRK_IVB = 7,
	__ATA_QUIRK_STUCK_ERR = 8,
	__ATA_QUIRK_BRIDGE_OK = 9,
	__ATA_QUIRK_ATAPI_MOD16_DMA = 10,
	__ATA_QUIRK_FIRMWARE_WARN = 11,
	__ATA_QUIRK_1_5_GBPS = 12,
	__ATA_QUIRK_NOSETXFER = 13,
	__ATA_QUIRK_BROKEN_FPDMA_AA = 14,
	__ATA_QUIRK_DUMP_ID = 15,
	__ATA_QUIRK_MAX_SEC_LBA48 = 16,
	__ATA_QUIRK_ATAPI_DMADIR = 17,
	__ATA_QUIRK_NO_NCQ_TRIM = 18,
	__ATA_QUIRK_NOLPM = 19,
	__ATA_QUIRK_WD_BROKEN_LPM = 20,
	__ATA_QUIRK_ZERO_AFTER_TRIM = 21,
	__ATA_QUIRK_NO_DMA_LOG = 22,
	__ATA_QUIRK_NOTRIM = 23,
	__ATA_QUIRK_MAX_SEC_1024 = 24,
	__ATA_QUIRK_MAX_TRIM_128M = 25,
	__ATA_QUIRK_NO_NCQ_ON_ATI = 26,
	__ATA_QUIRK_NO_LPM_ON_ATI = 27,
	__ATA_QUIRK_NO_ID_DEV_LOG = 28,
	__ATA_QUIRK_NO_LOG_DIR = 29,
	__ATA_QUIRK_NO_FUA = 30,
	__ATA_QUIRK_MAX = 31,
};

enum ata_xfer_mask {
	ATA_MASK_PIO = 127,
	ATA_MASK_MWDMA = 3968,
	ATA_MASK_UDMA = 1044480,
};

enum attr_id_t {
	attr_errors_magic = 0,
	attr_errors_node = 1,
	attr_errors_crc = 2,
};

enum audit_nfcfgop {
	AUDIT_XT_OP_REGISTER = 0,
	AUDIT_XT_OP_REPLACE = 1,
	AUDIT_XT_OP_UNREGISTER = 2,
	AUDIT_NFT_OP_TABLE_REGISTER = 3,
	AUDIT_NFT_OP_TABLE_UNREGISTER = 4,
	AUDIT_NFT_OP_CHAIN_REGISTER = 5,
	AUDIT_NFT_OP_CHAIN_UNREGISTER = 6,
	AUDIT_NFT_OP_RULE_REGISTER = 7,
	AUDIT_NFT_OP_RULE_UNREGISTER = 8,
	AUDIT_NFT_OP_SET_REGISTER = 9,
	AUDIT_NFT_OP_SET_UNREGISTER = 10,
	AUDIT_NFT_OP_SETELEM_REGISTER = 11,
	AUDIT_NFT_OP_SETELEM_UNREGISTER = 12,
	AUDIT_NFT_OP_GEN_REGISTER = 13,
	AUDIT_NFT_OP_OBJ_REGISTER = 14,
	AUDIT_NFT_OP_OBJ_UNREGISTER = 15,
	AUDIT_NFT_OP_OBJ_RESET = 16,
	AUDIT_NFT_OP_FLOWTABLE_REGISTER = 17,
	AUDIT_NFT_OP_FLOWTABLE_UNREGISTER = 18,
	AUDIT_NFT_OP_SETELEM_RESET = 19,
	AUDIT_NFT_OP_RULE_RESET = 20,
	AUDIT_NFT_OP_INVALID = 21,
};

enum audit_nlgrps {
	AUDIT_NLGRP_NONE = 0,
	AUDIT_NLGRP_READLOG = 1,
	__AUDIT_NLGRP_MAX = 2,
};

enum audit_ntp_type {
	AUDIT_NTP_OFFSET = 0,
	AUDIT_NTP_FREQ = 1,
	AUDIT_NTP_STATUS = 2,
	AUDIT_NTP_TAI = 3,
	AUDIT_NTP_TICK = 4,
	AUDIT_NTP_ADJUST = 5,
	AUDIT_NTP_NVALS = 6,
};

enum audit_state {
	AUDIT_STATE_DISABLED = 0,
	AUDIT_STATE_BUILD = 1,
	AUDIT_STATE_RECORD = 2,
};

enum auditsc_class_t {
	AUDITSC_NATIVE = 0,
	AUDITSC_COMPAT = 1,
	AUDITSC_OPEN = 2,
	AUDITSC_OPENAT = 3,
	AUDITSC_SOCKETCALL = 4,
	AUDITSC_EXECVE = 5,
	AUDITSC_OPENAT2 = 6,
	AUDITSC_NVALS = 7,
};

enum autofs_notify {
	NFY_NONE = 0,
	NFY_MOUNT = 1,
	NFY_EXPIRE = 2,
};

enum axp15060_irqs {
	AXP15060_IRQ_DIE_TEMP_HIGH_LV1 = 1,
	AXP15060_IRQ_DIE_TEMP_HIGH_LV2 = 2,
	AXP15060_IRQ_DCDC1_V_LOW = 3,
	AXP15060_IRQ_DCDC2_V_LOW = 4,
	AXP15060_IRQ_DCDC3_V_LOW = 5,
	AXP15060_IRQ_DCDC4_V_LOW = 6,
	AXP15060_IRQ_DCDC5_V_LOW = 7,
	AXP15060_IRQ_DCDC6_V_LOW = 8,
	AXP15060_IRQ_PEK_LONG = 9,
	AXP15060_IRQ_PEK_SHORT = 10,
	AXP15060_IRQ_GPIO1_INPUT = 11,
	AXP15060_IRQ_PEK_FAL_EDGE = 12,
	AXP15060_IRQ_PEK_RIS_EDGE = 13,
	AXP15060_IRQ_GPIO2_INPUT = 14,
};

enum axp192_irqs {
	AXP192_IRQ_ACIN_OVER_V = 1,
	AXP192_IRQ_ACIN_PLUGIN = 2,
	AXP192_IRQ_ACIN_REMOVAL = 3,
	AXP192_IRQ_VBUS_OVER_V = 4,
	AXP192_IRQ_VBUS_PLUGIN = 5,
	AXP192_IRQ_VBUS_REMOVAL = 6,
	AXP192_IRQ_VBUS_V_LOW = 7,
	AXP192_IRQ_BATT_PLUGIN = 8,
	AXP192_IRQ_BATT_REMOVAL = 9,
	AXP192_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP192_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP192_IRQ_CHARG = 12,
	AXP192_IRQ_CHARG_DONE = 13,
	AXP192_IRQ_BATT_TEMP_HIGH = 14,
	AXP192_IRQ_BATT_TEMP_LOW = 15,
	AXP192_IRQ_DIE_TEMP_HIGH = 16,
	AXP192_IRQ_CHARG_I_LOW = 17,
	AXP192_IRQ_DCDC1_V_LONG = 18,
	AXP192_IRQ_DCDC2_V_LONG = 19,
	AXP192_IRQ_DCDC3_V_LONG = 20,
	AXP192_IRQ_PEK_SHORT = 22,
	AXP192_IRQ_PEK_LONG = 23,
	AXP192_IRQ_N_OE_PWR_ON = 24,
	AXP192_IRQ_N_OE_PWR_OFF = 25,
	AXP192_IRQ_VBUS_VALID = 26,
	AXP192_IRQ_VBUS_NOT_VALID = 27,
	AXP192_IRQ_VBUS_SESS_VALID = 28,
	AXP192_IRQ_VBUS_SESS_END = 29,
	AXP192_IRQ_LOW_PWR_LVL = 31,
	AXP192_IRQ_TIMER = 32,
	AXP192_IRQ_GPIO2_INPUT = 37,
	AXP192_IRQ_GPIO1_INPUT = 38,
	AXP192_IRQ_GPIO0_INPUT = 39,
};

enum axp20x_variants {
	AXP152_ID = 0,
	AXP192_ID = 1,
	AXP202_ID = 2,
	AXP209_ID = 3,
	AXP221_ID = 4,
	AXP223_ID = 5,
	AXP288_ID = 6,
	AXP313A_ID = 7,
	AXP323_ID = 8,
	AXP717_ID = 9,
	AXP803_ID = 10,
	AXP806_ID = 11,
	AXP809_ID = 12,
	AXP813_ID = 13,
	AXP15060_ID = 14,
	NR_AXP20X_VARIANTS = 15,
};

enum axp22x_irqs {
	AXP22X_IRQ_ACIN_OVER_V = 1,
	AXP22X_IRQ_ACIN_PLUGIN = 2,
	AXP22X_IRQ_ACIN_REMOVAL = 3,
	AXP22X_IRQ_VBUS_OVER_V = 4,
	AXP22X_IRQ_VBUS_PLUGIN = 5,
	AXP22X_IRQ_VBUS_REMOVAL = 6,
	AXP22X_IRQ_VBUS_V_LOW = 7,
	AXP22X_IRQ_BATT_PLUGIN = 8,
	AXP22X_IRQ_BATT_REMOVAL = 9,
	AXP22X_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP22X_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP22X_IRQ_CHARG = 12,
	AXP22X_IRQ_CHARG_DONE = 13,
	AXP22X_IRQ_BATT_TEMP_HIGH = 14,
	AXP22X_IRQ_BATT_TEMP_LOW = 15,
	AXP22X_IRQ_DIE_TEMP_HIGH = 16,
	AXP22X_IRQ_PEK_SHORT = 17,
	AXP22X_IRQ_PEK_LONG = 18,
	AXP22X_IRQ_LOW_PWR_LVL1 = 19,
	AXP22X_IRQ_LOW_PWR_LVL2 = 20,
	AXP22X_IRQ_TIMER = 21,
	AXP22X_IRQ_PEK_FAL_EDGE = 22,
	AXP22X_IRQ_PEK_RIS_EDGE = 23,
	AXP22X_IRQ_GPIO1_INPUT = 24,
	AXP22X_IRQ_GPIO0_INPUT = 25,
};

enum axp288_irqs {
	AXP288_IRQ_VBUS_FALL = 2,
	AXP288_IRQ_VBUS_RISE = 3,
	AXP288_IRQ_OV = 4,
	AXP288_IRQ_FALLING_ALT = 5,
	AXP288_IRQ_RISING_ALT = 6,
	AXP288_IRQ_OV_ALT = 7,
	AXP288_IRQ_DONE = 10,
	AXP288_IRQ_CHARGING = 11,
	AXP288_IRQ_SAFE_QUIT = 12,
	AXP288_IRQ_SAFE_ENTER = 13,
	AXP288_IRQ_ABSENT = 14,
	AXP288_IRQ_APPEND = 15,
	AXP288_IRQ_QWBTU = 16,
	AXP288_IRQ_WBTU = 17,
	AXP288_IRQ_QWBTO = 18,
	AXP288_IRQ_WBTO = 19,
	AXP288_IRQ_QCBTU = 20,
	AXP288_IRQ_CBTU = 21,
	AXP288_IRQ_QCBTO = 22,
	AXP288_IRQ_CBTO = 23,
	AXP288_IRQ_WL2 = 24,
	AXP288_IRQ_WL1 = 25,
	AXP288_IRQ_GPADC = 26,
	AXP288_IRQ_OT = 31,
	AXP288_IRQ_GPIO0 = 32,
	AXP288_IRQ_GPIO1 = 33,
	AXP288_IRQ_POKO = 34,
	AXP288_IRQ_POKL = 35,
	AXP288_IRQ_POKS = 36,
	AXP288_IRQ_POKN = 37,
	AXP288_IRQ_POKP = 38,
	AXP288_IRQ_TIMER = 39,
	AXP288_IRQ_MV_CHNG = 40,
	AXP288_IRQ_BC_USB_CHNG = 41,
};

enum axp313a_irqs {
	AXP313A_IRQ_DIE_TEMP_HIGH = 0,
	AXP313A_IRQ_DCDC2_V_LOW = 2,
	AXP313A_IRQ_DCDC3_V_LOW = 3,
	AXP313A_IRQ_PEK_LONG = 4,
	AXP313A_IRQ_PEK_SHORT = 5,
	AXP313A_IRQ_PEK_FAL_EDGE = 6,
	AXP313A_IRQ_PEK_RIS_EDGE = 7,
};

enum axp717_irqs {
	AXP717_IRQ_VBUS_FAULT = 0,
	AXP717_IRQ_VBUS_OVER_V = 1,
	AXP717_IRQ_BOOST_OVER_V = 2,
	AXP717_IRQ_GAUGE_NEW_SOC = 4,
	AXP717_IRQ_SOC_DROP_LVL1 = 6,
	AXP717_IRQ_SOC_DROP_LVL2 = 7,
	AXP717_IRQ_PEK_RIS_EDGE = 8,
	AXP717_IRQ_PEK_FAL_EDGE = 9,
	AXP717_IRQ_PEK_LONG = 10,
	AXP717_IRQ_PEK_SHORT = 11,
	AXP717_IRQ_BATT_REMOVAL = 12,
	AXP717_IRQ_BATT_PLUGIN = 13,
	AXP717_IRQ_VBUS_REMOVAL = 14,
	AXP717_IRQ_VBUS_PLUGIN = 15,
	AXP717_IRQ_BATT_OVER_V = 16,
	AXP717_IRQ_CHARG_TIMER = 17,
	AXP717_IRQ_DIE_TEMP_HIGH = 18,
	AXP717_IRQ_CHARG = 19,
	AXP717_IRQ_CHARG_DONE = 20,
	AXP717_IRQ_BATT_OVER_CURR = 21,
	AXP717_IRQ_LDO_OVER_CURR = 22,
	AXP717_IRQ_WDOG_EXPIRE = 23,
	AXP717_IRQ_BATT_ACT_TEMP_LOW = 24,
	AXP717_IRQ_BATT_ACT_TEMP_HIGH = 25,
	AXP717_IRQ_BATT_CHG_TEMP_LOW = 26,
	AXP717_IRQ_BATT_CHG_TEMP_HIGH = 27,
	AXP717_IRQ_BATT_QUIT_TEMP_HIGH = 28,
	AXP717_IRQ_BC_USB_CHNG = 30,
	AXP717_IRQ_BC_USB_DONE = 31,
	AXP717_IRQ_TYPEC_PLUGIN = 37,
	AXP717_IRQ_TYPEC_REMOVE = 38,
};

enum axp803_irqs {
	AXP803_IRQ_ACIN_OVER_V = 1,
	AXP803_IRQ_ACIN_PLUGIN = 2,
	AXP803_IRQ_ACIN_REMOVAL = 3,
	AXP803_IRQ_VBUS_OVER_V = 4,
	AXP803_IRQ_VBUS_PLUGIN = 5,
	AXP803_IRQ_VBUS_REMOVAL = 6,
	AXP803_IRQ_BATT_PLUGIN = 7,
	AXP803_IRQ_BATT_REMOVAL = 8,
	AXP803_IRQ_BATT_ENT_ACT_MODE = 9,
	AXP803_IRQ_BATT_EXIT_ACT_MODE = 10,
	AXP803_IRQ_CHARG = 11,
	AXP803_IRQ_CHARG_DONE = 12,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH = 13,
	AXP803_IRQ_BATT_CHG_TEMP_HIGH_END = 14,
	AXP803_IRQ_BATT_CHG_TEMP_LOW = 15,
	AXP803_IRQ_BATT_CHG_TEMP_LOW_END = 16,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH = 17,
	AXP803_IRQ_BATT_ACT_TEMP_HIGH_END = 18,
	AXP803_IRQ_BATT_ACT_TEMP_LOW = 19,
	AXP803_IRQ_BATT_ACT_TEMP_LOW_END = 20,
	AXP803_IRQ_DIE_TEMP_HIGH = 21,
	AXP803_IRQ_GPADC = 22,
	AXP803_IRQ_LOW_PWR_LVL1 = 23,
	AXP803_IRQ_LOW_PWR_LVL2 = 24,
	AXP803_IRQ_TIMER = 25,
	AXP803_IRQ_PEK_FAL_EDGE = 26,
	AXP803_IRQ_PEK_RIS_EDGE = 27,
	AXP803_IRQ_PEK_SHORT = 28,
	AXP803_IRQ_PEK_LONG = 29,
	AXP803_IRQ_PEK_OVER_OFF = 30,
	AXP803_IRQ_GPIO1_INPUT = 31,
	AXP803_IRQ_GPIO0_INPUT = 32,
	AXP803_IRQ_BC_USB_CHNG = 33,
	AXP803_IRQ_MV_CHNG = 34,
};

enum axp806_irqs {
	AXP806_IRQ_DIE_TEMP_HIGH_LV1 = 0,
	AXP806_IRQ_DIE_TEMP_HIGH_LV2 = 1,
	AXP806_IRQ_DCDCA_V_LOW = 2,
	AXP806_IRQ_DCDCB_V_LOW = 3,
	AXP806_IRQ_DCDCC_V_LOW = 4,
	AXP806_IRQ_DCDCD_V_LOW = 5,
	AXP806_IRQ_DCDCE_V_LOW = 6,
	AXP806_IRQ_POK_LONG = 7,
	AXP806_IRQ_POK_SHORT = 8,
	AXP806_IRQ_WAKEUP = 9,
	AXP806_IRQ_POK_FALL = 10,
	AXP806_IRQ_POK_RISE = 11,
};

enum axp809_irqs {
	AXP809_IRQ_ACIN_OVER_V = 1,
	AXP809_IRQ_ACIN_PLUGIN = 2,
	AXP809_IRQ_ACIN_REMOVAL = 3,
	AXP809_IRQ_VBUS_OVER_V = 4,
	AXP809_IRQ_VBUS_PLUGIN = 5,
	AXP809_IRQ_VBUS_REMOVAL = 6,
	AXP809_IRQ_VBUS_V_LOW = 7,
	AXP809_IRQ_BATT_PLUGIN = 8,
	AXP809_IRQ_BATT_REMOVAL = 9,
	AXP809_IRQ_BATT_ENT_ACT_MODE = 10,
	AXP809_IRQ_BATT_EXIT_ACT_MODE = 11,
	AXP809_IRQ_CHARG = 12,
	AXP809_IRQ_CHARG_DONE = 13,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH = 14,
	AXP809_IRQ_BATT_CHG_TEMP_HIGH_END = 15,
	AXP809_IRQ_BATT_CHG_TEMP_LOW = 16,
	AXP809_IRQ_BATT_CHG_TEMP_LOW_END = 17,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH = 18,
	AXP809_IRQ_BATT_ACT_TEMP_HIGH_END = 19,
	AXP809_IRQ_BATT_ACT_TEMP_LOW = 20,
	AXP809_IRQ_BATT_ACT_TEMP_LOW_END = 21,
	AXP809_IRQ_DIE_TEMP_HIGH = 22,
	AXP809_IRQ_LOW_PWR_LVL1 = 23,
	AXP809_IRQ_LOW_PWR_LVL2 = 24,
	AXP809_IRQ_TIMER = 25,
	AXP809_IRQ_PEK_FAL_EDGE = 26,
	AXP809_IRQ_PEK_RIS_EDGE = 27,
	AXP809_IRQ_PEK_SHORT = 28,
	AXP809_IRQ_PEK_LONG = 29,
	AXP809_IRQ_PEK_OVER_OFF = 30,
	AXP809_IRQ_GPIO1_INPUT = 31,
	AXP809_IRQ_GPIO0_INPUT = 32,
};

enum backlight_scale {
	BACKLIGHT_SCALE_UNKNOWN = 0,
	BACKLIGHT_SCALE_LINEAR = 1,
	BACKLIGHT_SCALE_NON_LINEAR = 2,
};

enum backlight_type {
	BACKLIGHT_RAW = 1,
	BACKLIGHT_PLATFORM = 2,
	BACKLIGHT_FIRMWARE = 3,
	BACKLIGHT_TYPE_MAX = 4,
};

enum backlight_update_reason {
	BACKLIGHT_UPDATE_HOTKEY = 0,
	BACKLIGHT_UPDATE_SYSFS = 1,
};

enum batadv_packettype {
	BATADV_IV_OGM = 0,
	BATADV_BCAST = 1,
	BATADV_CODED = 2,
	BATADV_ELP = 3,
	BATADV_OGM2 = 4,
	BATADV_MCAST = 5,
	BATADV_UNICAST = 64,
	BATADV_UNICAST_FRAG = 65,
	BATADV_UNICAST_4ADDR = 66,
	BATADV_ICMP = 67,
	BATADV_UNICAST_TVLV = 68,
};

enum bcm2835_fsel {
	BCM2835_FSEL_COUNT = 8,
	BCM2835_FSEL_MASK = 7,
};

enum bcm590xx_reg_type {
	BCM590XX_REG_TYPE_LDO = 0,
	BCM590XX_REG_TYPE_GPLDO = 1,
	BCM590XX_REG_TYPE_SR = 2,
	BCM590XX_REG_TYPE_VBUS = 3,
};

enum bcm590xx_regmap_type {
	BCM590XX_REGMAP_PRI = 0,
	BCM590XX_REGMAP_SEC = 1,
};

enum bcmgenet_power_mode {
	GENET_POWER_CABLE_SENSE = 0,
	GENET_POWER_PASSIVE = 1,
	GENET_POWER_WOL_MAGIC = 2,
};

enum bcmgenet_rxnfc_state {
	BCMGENET_RXNFC_STATE_UNUSED = 0,
	BCMGENET_RXNFC_STATE_DISABLED = 1,
	BCMGENET_RXNFC_STATE_ENABLED = 2,
};

enum bcmgenet_stat_type {
	BCMGENET_STAT_RTNL = -1,
	BCMGENET_STAT_MIB_RX = 0,
	BCMGENET_STAT_MIB_TX = 1,
	BCMGENET_STAT_RUNT = 2,
	BCMGENET_STAT_MISC = 3,
	BCMGENET_STAT_SOFT = 4,
	BCMGENET_STAT_SOFT64 = 5,
};

enum bcmgenet_version {
	GENET_V1 = 1,
	GENET_V2 = 2,
	GENET_V3 = 3,
	GENET_V4 = 4,
	GENET_V5 = 5,
};

enum behavior {
	EXCLUSIVE = 0,
	SHARED = 1,
	DROP = 2,
};

enum bfqq_expiration {
	BFQQE_TOO_IDLE = 0,
	BFQQE_BUDGET_TIMEOUT = 1,
	BFQQE_BUDGET_EXHAUSTED = 2,
	BFQQE_NO_MORE_REQUESTS = 3,
	BFQQE_PREEMPTED = 4,
};

enum bfqq_state_flags {
	BFQQF_just_created = 0,
	BFQQF_busy = 1,
	BFQQF_wait_request = 2,
	BFQQF_non_blocking_wait_rq = 3,
	BFQQF_fifo_expire = 4,
	BFQQF_has_short_ttime = 5,
	BFQQF_sync = 6,
	BFQQF_IO_bound = 7,
	BFQQF_in_large_burst = 8,
	BFQQF_softrt_update = 9,
	BFQQF_coop = 10,
	BFQQF_split_coop = 11,
};

enum bh_state_bits {
	BH_Uptodate = 0,
	BH_Dirty = 1,
	BH_Lock = 2,
	BH_Req = 3,
	BH_Mapped = 4,
	BH_New = 5,
	BH_Async_Read = 6,
	BH_Async_Write = 7,
	BH_Delay = 8,
	BH_Boundary = 9,
	BH_Write_EIO = 10,
	BH_Unwritten = 11,
	BH_Quiet = 12,
	BH_Meta = 13,
	BH_Prio = 14,
	BH_Defer_Completion = 15,
	BH_Migrate = 16,
	BH_PrivateStart = 17,
};

enum bio_merge_status {
	BIO_MERGE_OK = 0,
	BIO_MERGE_NONE = 1,
	BIO_MERGE_FAILED = 2,
};

enum bio_post_read_step {
	STEP_DECRYPT = 1,
	STEP_DECOMPRESS = 2,
	STEP_VERITY = 4,
};

enum bio_post_read_step___2 {
	STEP_INITIAL = 0,
	STEP_DECRYPT___2 = 1,
	STEP_VERITY___2 = 2,
	STEP_MAX = 3,
};

enum bip_flags {
	BIP_BLOCK_INTEGRITY = 1,
	BIP_MAPPED_INTEGRITY = 2,
	BIP_DISK_NOCHECK = 4,
	BIP_IP_CHECKSUM = 8,
	BIP_COPY_USER = 16,
	BIP_CHECK_GUARD = 32,
	BIP_CHECK_REFTAG = 64,
	BIP_CHECK_APPTAG = 128,
};

enum blacklist_hash_type {
	BLACKLIST_HASH_X509_TBS = 1,
	BLACKLIST_HASH_BINARY = 2,
};

enum blake2b_iv {
	BLAKE2B_IV0 = 7640891576956012808ULL,
	BLAKE2B_IV1 = 13503953896175478587ULL,
	BLAKE2B_IV2 = 4354685564936845355ULL,
	BLAKE2B_IV3 = 11912009170470909681ULL,
	BLAKE2B_IV4 = 5840696475078001361ULL,
	BLAKE2B_IV5 = 11170449401992604703ULL,
	BLAKE2B_IV6 = 2270897969802886507ULL,
	BLAKE2B_IV7 = 6620516959819538809ULL,
};

enum blake2b_lengths {
	BLAKE2B_BLOCK_SIZE = 128,
	BLAKE2B_HASH_SIZE = 64,
	BLAKE2B_KEY_SIZE = 64,
	BLAKE2B_STATE_SIZE = 80,
	BLAKE2B_DESC_SIZE = 96,
	BLAKE2B_160_HASH_SIZE = 20,
	BLAKE2B_256_HASH_SIZE = 32,
	BLAKE2B_384_HASH_SIZE = 48,
	BLAKE2B_512_HASH_SIZE = 64,
};

enum blake2s_iv {
	BLAKE2S_IV0 = 1779033703,
	BLAKE2S_IV1 = 3144134277,
	BLAKE2S_IV2 = 1013904242,
	BLAKE2S_IV3 = 2773480762,
	BLAKE2S_IV4 = 1359893119,
	BLAKE2S_IV5 = 2600822924,
	BLAKE2S_IV6 = 528734635,
	BLAKE2S_IV7 = 1541459225,
};

enum blake2s_lengths {
	BLAKE2S_BLOCK_SIZE = 64,
	BLAKE2S_HASH_SIZE = 32,
	BLAKE2S_KEY_SIZE = 32,
	BLAKE2S_128_HASH_SIZE = 16,
	BLAKE2S_160_HASH_SIZE = 20,
	BLAKE2S_224_HASH_SIZE = 28,
	BLAKE2S_256_HASH_SIZE = 32,
};

enum blk_crypto_mode_num {
	BLK_ENCRYPTION_MODE_INVALID = 0,
	BLK_ENCRYPTION_MODE_AES_256_XTS = 1,
	BLK_ENCRYPTION_MODE_AES_128_CBC_ESSIV = 2,
	BLK_ENCRYPTION_MODE_ADIANTUM = 3,
	BLK_ENCRYPTION_MODE_SM4_XTS = 4,
	BLK_ENCRYPTION_MODE_MAX = 5,
};

enum blk_default_limits {
	BLK_MAX_SEGMENTS = 128,
	BLK_SAFE_MAX_SECTORS = 255,
	BLK_MAX_SEGMENT_SIZE = 65536,
	BLK_SEG_BOUNDARY_MASK = 4294967295,
};

enum blk_eh_timer_return {
	BLK_EH_DONE = 0,
	BLK_EH_RESET_TIMER = 1,
};

enum blk_integrity_checksum {
	BLK_INTEGRITY_CSUM_NONE = 0,
	BLK_INTEGRITY_CSUM_IP = 1,
	BLK_INTEGRITY_CSUM_CRC = 2,
	BLK_INTEGRITY_CSUM_CRC64 = 3,
} __attribute__((mode(byte)));

enum blk_integrity_flags {
	BLK_INTEGRITY_NOVERIFY = 1,
	BLK_INTEGRITY_NOGENERATE = 2,
	BLK_INTEGRITY_DEVICE_CAPABLE = 4,
	BLK_INTEGRITY_REF_TAG = 8,
	BLK_INTEGRITY_STACKED = 16,
};

enum blk_unique_id {
	BLK_UID_T10 = 1,
	BLK_UID_EUI64 = 2,
	BLK_UID_NAA = 3,
};

enum blk_zone_cond {
	BLK_ZONE_COND_NOT_WP = 0,
	BLK_ZONE_COND_EMPTY = 1,
	BLK_ZONE_COND_IMP_OPEN = 2,
	BLK_ZONE_COND_EXP_OPEN = 3,
	BLK_ZONE_COND_CLOSED = 4,
	BLK_ZONE_COND_READONLY = 13,
	BLK_ZONE_COND_FULL = 14,
	BLK_ZONE_COND_OFFLINE = 15,
};

enum blk_zone_report_flags {
	BLK_ZONE_REP_CAPACITY = 1,
};

enum blk_zone_type {
	BLK_ZONE_TYPE_CONVENTIONAL = 1,
	BLK_ZONE_TYPE_SEQWRITE_REQ = 2,
	BLK_ZONE_TYPE_SEQWRITE_PREF = 3,
};

enum blkg_iostat_type {
	BLKG_IOSTAT_READ = 0,
	BLKG_IOSTAT_WRITE = 1,
	BLKG_IOSTAT_DISCARD = 2,
	BLKG_IOSTAT_NR = 3,
};

enum blkg_rwstat_type {
	BLKG_RWSTAT_READ = 0,
	BLKG_RWSTAT_WRITE = 1,
	BLKG_RWSTAT_SYNC = 2,
	BLKG_RWSTAT_ASYNC = 3,
	BLKG_RWSTAT_DISCARD = 4,
	BLKG_RWSTAT_NR = 5,
	BLKG_RWSTAT_TOTAL = 5,
};

enum blktrace_act {
	__BLK_TA_QUEUE = 1,
	__BLK_TA_BACKMERGE = 2,
	__BLK_TA_FRONTMERGE = 3,
	__BLK_TA_GETRQ = 4,
	__BLK_TA_SLEEPRQ = 5,
	__BLK_TA_REQUEUE = 6,
	__BLK_TA_ISSUE = 7,
	__BLK_TA_COMPLETE = 8,
	__BLK_TA_PLUG = 9,
	__BLK_TA_UNPLUG_IO = 10,
	__BLK_TA_UNPLUG_TIMER = 11,
	__BLK_TA_INSERT = 12,
	__BLK_TA_SPLIT = 13,
	__BLK_TA_BOUNCE = 14,
	__BLK_TA_REMAP = 15,
	__BLK_TA_ABORT = 16,
	__BLK_TA_DRV_DATA = 17,
	__BLK_TA_CGROUP = 256,
};

enum blkzone_allocation_policy {
	BLKZONE_ALLOC_PRIOR_SEQ = 0,
	BLKZONE_ALLOC_ONLY_SEQ = 1,
	BLKZONE_ALLOC_PRIOR_CONV = 2,
};

enum board_ids {
	board_ahci = 0,
	board_ahci_43bit_dma = 1,
	board_ahci_ign_iferr = 2,
	board_ahci_no_debounce_delay = 3,
	board_ahci_no_msi = 4,
	board_ahci_pcs_quirk = 5,
	board_ahci_pcs_quirk_no_devslp = 6,
	board_ahci_pcs_quirk_no_sntf = 7,
	board_ahci_yes_fbs = 8,
	board_ahci_yes_fbs_atapi_dma = 9,
	board_ahci_al = 10,
	board_ahci_avn = 11,
	board_ahci_mcp65 = 12,
	board_ahci_mcp77 = 13,
	board_ahci_mcp89 = 14,
	board_ahci_mv = 15,
	board_ahci_sb600 = 16,
	board_ahci_sb700 = 17,
	board_ahci_vt8251 = 18,
	board_ahci_mcp_linux = 12,
	board_ahci_mcp67 = 12,
	board_ahci_mcp73 = 12,
	board_ahci_mcp79 = 13,
};

enum bp_type_idx {
	TYPE_INST = 0,
	TYPE_DATA = 1,
	TYPE_MAX = 2,
};

enum bpf_access_src {
	ACCESS_DIRECT = 1,
	ACCESS_HELPER = 2,
};

enum bpf_access_type {
	BPF_READ = 1,
	BPF_WRITE = 2,
};

enum bpf_addr_space_cast {
	BPF_ADDR_SPACE_CAST = 1,
};

enum bpf_adj_room_mode {
	BPF_ADJ_ROOM_NET = 0,
	BPF_ADJ_ROOM_MAC = 1,
};

enum bpf_arg_type {
	ARG_DONTCARE = 0,
	ARG_CONST_MAP_PTR = 1,
	ARG_PTR_TO_MAP_KEY = 2,
	ARG_PTR_TO_MAP_VALUE = 3,
	ARG_PTR_TO_MEM = 4,
	ARG_PTR_TO_ARENA = 5,
	ARG_CONST_SIZE = 6,
	ARG_CONST_SIZE_OR_ZERO = 7,
	ARG_PTR_TO_CTX = 8,
	ARG_ANYTHING = 9,
	ARG_PTR_TO_SPIN_LOCK = 10,
	ARG_PTR_TO_SOCK_COMMON = 11,
	ARG_PTR_TO_SOCKET = 12,
	ARG_PTR_TO_BTF_ID = 13,
	ARG_PTR_TO_RINGBUF_MEM = 14,
	ARG_CONST_ALLOC_SIZE_OR_ZERO = 15,
	ARG_PTR_TO_BTF_ID_SOCK_COMMON = 16,
	ARG_PTR_TO_PERCPU_BTF_ID = 17,
	ARG_PTR_TO_FUNC = 18,
	ARG_PTR_TO_STACK = 19,
	ARG_PTR_TO_CONST_STR = 20,
	ARG_PTR_TO_TIMER = 21,
	ARG_KPTR_XCHG_DEST = 22,
	ARG_PTR_TO_DYNPTR = 23,
	__BPF_ARG_TYPE_MAX = 24,
	ARG_PTR_TO_MAP_VALUE_OR_NULL = 259,
	ARG_PTR_TO_MEM_OR_NULL = 260,
	ARG_PTR_TO_CTX_OR_NULL = 264,
	ARG_PTR_TO_SOCKET_OR_NULL = 268,
	ARG_PTR_TO_STACK_OR_NULL = 275,
	ARG_PTR_TO_BTF_ID_OR_NULL = 269,
	ARG_PTR_TO_UNINIT_MEM = 67141636,
	ARG_PTR_TO_FIXED_SIZE_MEM = 262148,
	__BPF_ARG_TYPE_LIMIT = 134217727,
};

enum bpf_async_type {
	BPF_ASYNC_TYPE_TIMER = 0,
	BPF_ASYNC_TYPE_WQ = 1,
};

enum bpf_attach_type {
	BPF_CGROUP_INET_INGRESS = 0,
	BPF_CGROUP_INET_EGRESS = 1,
	BPF_CGROUP_INET_SOCK_CREATE = 2,
	BPF_CGROUP_SOCK_OPS = 3,
	BPF_SK_SKB_STREAM_PARSER = 4,
	BPF_SK_SKB_STREAM_VERDICT = 5,
	BPF_CGROUP_DEVICE = 6,
	BPF_SK_MSG_VERDICT = 7,
	BPF_CGROUP_INET4_BIND = 8,
	BPF_CGROUP_INET6_BIND = 9,
	BPF_CGROUP_INET4_CONNECT = 10,
	BPF_CGROUP_INET6_CONNECT = 11,
	BPF_CGROUP_INET4_POST_BIND = 12,
	BPF_CGROUP_INET6_POST_BIND = 13,
	BPF_CGROUP_UDP4_SENDMSG = 14,
	BPF_CGROUP_UDP6_SENDMSG = 15,
	BPF_LIRC_MODE2 = 16,
	BPF_FLOW_DISSECTOR = 17,
	BPF_CGROUP_SYSCTL = 18,
	BPF_CGROUP_UDP4_RECVMSG = 19,
	BPF_CGROUP_UDP6_RECVMSG = 20,
	BPF_CGROUP_GETSOCKOPT = 21,
	BPF_CGROUP_SETSOCKOPT = 22,
	BPF_TRACE_RAW_TP = 23,
	BPF_TRACE_FENTRY = 24,
	BPF_TRACE_FEXIT = 25,
	BPF_MODIFY_RETURN = 26,
	BPF_LSM_MAC = 27,
	BPF_TRACE_ITER = 28,
	BPF_CGROUP_INET4_GETPEERNAME = 29,
	BPF_CGROUP_INET6_GETPEERNAME = 30,
	BPF_CGROUP_INET4_GETSOCKNAME = 31,
	BPF_CGROUP_INET6_GETSOCKNAME = 32,
	BPF_XDP_DEVMAP = 33,
	BPF_CGROUP_INET_SOCK_RELEASE = 34,
	BPF_XDP_CPUMAP = 35,
	BPF_SK_LOOKUP = 36,
	BPF_XDP = 37,
	BPF_SK_SKB_VERDICT = 38,
	BPF_SK_REUSEPORT_SELECT = 39,
	BPF_SK_REUSEPORT_SELECT_OR_MIGRATE = 40,
	BPF_PERF_EVENT = 41,
	BPF_TRACE_KPROBE_MULTI = 42,
	BPF_LSM_CGROUP = 43,
	BPF_STRUCT_OPS = 44,
	BPF_NETFILTER = 45,
	BPF_TCX_INGRESS = 46,
	BPF_TCX_EGRESS = 47,
	BPF_TRACE_UPROBE_MULTI = 48,
	BPF_CGROUP_UNIX_CONNECT = 49,
	BPF_CGROUP_UNIX_SENDMSG = 50,
	BPF_CGROUP_UNIX_RECVMSG = 51,
	BPF_CGROUP_UNIX_GETPEERNAME = 52,
	BPF_CGROUP_UNIX_GETSOCKNAME = 53,
	BPF_NETKIT_PRIMARY = 54,
	BPF_NETKIT_PEER = 55,
	BPF_TRACE_KPROBE_SESSION = 56,
	BPF_TRACE_UPROBE_SESSION = 57,
	__MAX_BPF_ATTACH_TYPE = 58,
};

enum bpf_audit {
	BPF_AUDIT_LOAD = 0,
	BPF_AUDIT_UNLOAD = 1,
	BPF_AUDIT_MAX = 2,
};

enum bpf_cgroup_iter_order {
	BPF_CGROUP_ITER_ORDER_UNSPEC = 0,
	BPF_CGROUP_ITER_SELF_ONLY = 1,
	BPF_CGROUP_ITER_DESCENDANTS_PRE = 2,
	BPF_CGROUP_ITER_DESCENDANTS_POST = 3,
	BPF_CGROUP_ITER_ANCESTORS_UP = 4,
};

enum bpf_cgroup_storage_type {
	BPF_CGROUP_STORAGE_SHARED = 0,
	BPF_CGROUP_STORAGE_PERCPU = 1,
	__BPF_CGROUP_STORAGE_MAX = 2,
};

enum bpf_check_mtu_flags {
	BPF_MTU_CHK_SEGS = 1,
};

enum bpf_check_mtu_ret {
	BPF_MTU_CHK_RET_SUCCESS = 0,
	BPF_MTU_CHK_RET_FRAG_NEEDED = 1,
	BPF_MTU_CHK_RET_SEGS_TOOBIG = 2,
};

enum bpf_cmd {
	BPF_MAP_CREATE = 0,
	BPF_MAP_LOOKUP_ELEM = 1,
	BPF_MAP_UPDATE_ELEM = 2,
	BPF_MAP_DELETE_ELEM = 3,
	BPF_MAP_GET_NEXT_KEY = 4,
	BPF_PROG_LOAD = 5,
	BPF_OBJ_PIN = 6,
	BPF_OBJ_GET = 7,
	BPF_PROG_ATTACH = 8,
	BPF_PROG_DETACH = 9,
	BPF_PROG_TEST_RUN = 10,
	BPF_PROG_RUN = 10,
	BPF_PROG_GET_NEXT_ID = 11,
	BPF_MAP_GET_NEXT_ID = 12,
	BPF_PROG_GET_FD_BY_ID = 13,
	BPF_MAP_GET_FD_BY_ID = 14,
	BPF_OBJ_GET_INFO_BY_FD = 15,
	BPF_PROG_QUERY = 16,
	BPF_RAW_TRACEPOINT_OPEN = 17,
	BPF_BTF_LOAD = 18,
	BPF_BTF_GET_FD_BY_ID = 19,
	BPF_TASK_FD_QUERY = 20,
	BPF_MAP_LOOKUP_AND_DELETE_ELEM = 21,
	BPF_MAP_FREEZE = 22,
	BPF_BTF_GET_NEXT_ID = 23,
	BPF_MAP_LOOKUP_BATCH = 24,
	BPF_MAP_LOOKUP_AND_DELETE_BATCH = 25,
	BPF_MAP_UPDATE_BATCH = 26,
	BPF_MAP_DELETE_BATCH = 27,
	BPF_LINK_CREATE = 28,
	BPF_LINK_UPDATE = 29,
	BPF_LINK_GET_FD_BY_ID = 30,
	BPF_LINK_GET_NEXT_ID = 31,
	BPF_ENABLE_STATS = 32,
	BPF_ITER_CREATE = 33,
	BPF_LINK_DETACH = 34,
	BPF_PROG_BIND_MAP = 35,
	BPF_TOKEN_CREATE = 36,
	__MAX_BPF_CMD = 37,
};

enum bpf_cond_pseudo_jmp {
	BPF_MAY_GOTO = 0,
};

enum bpf_core_relo_kind {
	BPF_CORE_FIELD_BYTE_OFFSET = 0,
	BPF_CORE_FIELD_BYTE_SIZE = 1,
	BPF_CORE_FIELD_EXISTS = 2,
	BPF_CORE_FIELD_SIGNED = 3,
	BPF_CORE_FIELD_LSHIFT_U64 = 4,
	BPF_CORE_FIELD_RSHIFT_U64 = 5,
	BPF_CORE_TYPE_ID_LOCAL = 6,
	BPF_CORE_TYPE_ID_TARGET = 7,
	BPF_CORE_TYPE_EXISTS = 8,
	BPF_CORE_TYPE_SIZE = 9,
	BPF_CORE_ENUMVAL_EXISTS = 10,
	BPF_CORE_ENUMVAL_VALUE = 11,
	BPF_CORE_TYPE_MATCHES = 12,
};

enum bpf_dynptr_type {
	BPF_DYNPTR_TYPE_INVALID = 0,
	BPF_DYNPTR_TYPE_LOCAL = 1,
	BPF_DYNPTR_TYPE_RINGBUF = 2,
	BPF_DYNPTR_TYPE_SKB = 3,
	BPF_DYNPTR_TYPE_XDP = 4,
};

enum bpf_func_id {
	BPF_FUNC_unspec = 0,
	BPF_FUNC_map_lookup_elem = 1,
	BPF_FUNC_map_update_elem = 2,
	BPF_FUNC_map_delete_elem = 3,
	BPF_FUNC_probe_read = 4,
	BPF_FUNC_ktime_get_ns = 5,
	BPF_FUNC_trace_printk = 6,
	BPF_FUNC_get_prandom_u32 = 7,
	BPF_FUNC_get_smp_processor_id = 8,
	BPF_FUNC_skb_store_bytes = 9,
	BPF_FUNC_l3_csum_replace = 10,
	BPF_FUNC_l4_csum_replace = 11,
	BPF_FUNC_tail_call = 12,
	BPF_FUNC_clone_redirect = 13,
	BPF_FUNC_get_current_pid_tgid = 14,
	BPF_FUNC_get_current_uid_gid = 15,
	BPF_FUNC_get_current_comm = 16,
	BPF_FUNC_get_cgroup_classid = 17,
	BPF_FUNC_skb_vlan_push = 18,
	BPF_FUNC_skb_vlan_pop = 19,
	BPF_FUNC_skb_get_tunnel_key = 20,
	BPF_FUNC_skb_set_tunnel_key = 21,
	BPF_FUNC_perf_event_read = 22,
	BPF_FUNC_redirect = 23,
	BPF_FUNC_get_route_realm = 24,
	BPF_FUNC_perf_event_output = 25,
	BPF_FUNC_skb_load_bytes = 26,
	BPF_FUNC_get_stackid = 27,
	BPF_FUNC_csum_diff = 28,
	BPF_FUNC_skb_get_tunnel_opt = 29,
	BPF_FUNC_skb_set_tunnel_opt = 30,
	BPF_FUNC_skb_change_proto = 31,
	BPF_FUNC_skb_change_type = 32,
	BPF_FUNC_skb_under_cgroup = 33,
	BPF_FUNC_get_hash_recalc = 34,
	BPF_FUNC_get_current_task = 35,
	BPF_FUNC_probe_write_user = 36,
	BPF_FUNC_current_task_under_cgroup = 37,
	BPF_FUNC_skb_change_tail = 38,
	BPF_FUNC_skb_pull_data = 39,
	BPF_FUNC_csum_update = 40,
	BPF_FUNC_set_hash_invalid = 41,
	BPF_FUNC_get_numa_node_id = 42,
	BPF_FUNC_skb_change_head = 43,
	BPF_FUNC_xdp_adjust_head = 44,
	BPF_FUNC_probe_read_str = 45,
	BPF_FUNC_get_socket_cookie = 46,
	BPF_FUNC_get_socket_uid = 47,
	BPF_FUNC_set_hash = 48,
	BPF_FUNC_setsockopt = 49,
	BPF_FUNC_skb_adjust_room = 50,
	BPF_FUNC_redirect_map = 51,
	BPF_FUNC_sk_redirect_map = 52,
	BPF_FUNC_sock_map_update = 53,
	BPF_FUNC_xdp_adjust_meta = 54,
	BPF_FUNC_perf_event_read_value = 55,
	BPF_FUNC_perf_prog_read_value = 56,
	BPF_FUNC_getsockopt = 57,
	BPF_FUNC_override_return = 58,
	BPF_FUNC_sock_ops_cb_flags_set = 59,
	BPF_FUNC_msg_redirect_map = 60,
	BPF_FUNC_msg_apply_bytes = 61,
	BPF_FUNC_msg_cork_bytes = 62,
	BPF_FUNC_msg_pull_data = 63,
	BPF_FUNC_bind = 64,
	BPF_FUNC_xdp_adjust_tail = 65,
	BPF_FUNC_skb_get_xfrm_state = 66,
	BPF_FUNC_get_stack = 67,
	BPF_FUNC_skb_load_bytes_relative = 68,
	BPF_FUNC_fib_lookup = 69,
	BPF_FUNC_sock_hash_update = 70,
	BPF_FUNC_msg_redirect_hash = 71,
	BPF_FUNC_sk_redirect_hash = 72,
	BPF_FUNC_lwt_push_encap = 73,
	BPF_FUNC_lwt_seg6_store_bytes = 74,
	BPF_FUNC_lwt_seg6_adjust_srh = 75,
	BPF_FUNC_lwt_seg6_action = 76,
	BPF_FUNC_rc_repeat = 77,
	BPF_FUNC_rc_keydown = 78,
	BPF_FUNC_skb_cgroup_id = 79,
	BPF_FUNC_get_current_cgroup_id = 80,
	BPF_FUNC_get_local_storage = 81,
	BPF_FUNC_sk_select_reuseport = 82,
	BPF_FUNC_skb_ancestor_cgroup_id = 83,
	BPF_FUNC_sk_lookup_tcp = 84,
	BPF_FUNC_sk_lookup_udp = 85,
	BPF_FUNC_sk_release = 86,
	BPF_FUNC_map_push_elem = 87,
	BPF_FUNC_map_pop_elem = 88,
	BPF_FUNC_map_peek_elem = 89,
	BPF_FUNC_msg_push_data = 90,
	BPF_FUNC_msg_pop_data = 91,
	BPF_FUNC_rc_pointer_rel = 92,
	BPF_FUNC_spin_lock = 93,
	BPF_FUNC_spin_unlock = 94,
	BPF_FUNC_sk_fullsock = 95,
	BPF_FUNC_tcp_sock = 96,
	BPF_FUNC_skb_ecn_set_ce = 97,
	BPF_FUNC_get_listener_sock = 98,
	BPF_FUNC_skc_lookup_tcp = 99,
	BPF_FUNC_tcp_check_syncookie = 100,
	BPF_FUNC_sysctl_get_name = 101,
	BPF_FUNC_sysctl_get_current_value = 102,
	BPF_FUNC_sysctl_get_new_value = 103,
	BPF_FUNC_sysctl_set_new_value = 104,
	BPF_FUNC_strtol = 105,
	BPF_FUNC_strtoul = 106,
	BPF_FUNC_sk_storage_get = 107,
	BPF_FUNC_sk_storage_delete = 108,
	BPF_FUNC_send_signal = 109,
	BPF_FUNC_tcp_gen_syncookie = 110,
	BPF_FUNC_skb_output = 111,
	BPF_FUNC_probe_read_user = 112,
	BPF_FUNC_probe_read_kernel = 113,
	BPF_FUNC_probe_read_user_str = 114,
	BPF_FUNC_probe_read_kernel_str = 115,
	BPF_FUNC_tcp_send_ack = 116,
	BPF_FUNC_send_signal_thread = 117,
	BPF_FUNC_jiffies64 = 118,
	BPF_FUNC_read_branch_records = 119,
	BPF_FUNC_get_ns_current_pid_tgid = 120,
	BPF_FUNC_xdp_output = 121,
	BPF_FUNC_get_netns_cookie = 122,
	BPF_FUNC_get_current_ancestor_cgroup_id = 123,
	BPF_FUNC_sk_assign = 124,
	BPF_FUNC_ktime_get_boot_ns = 125,
	BPF_FUNC_seq_printf = 126,
	BPF_FUNC_seq_write = 127,
	BPF_FUNC_sk_cgroup_id = 128,
	BPF_FUNC_sk_ancestor_cgroup_id = 129,
	BPF_FUNC_ringbuf_output = 130,
	BPF_FUNC_ringbuf_reserve = 131,
	BPF_FUNC_ringbuf_submit = 132,
	BPF_FUNC_ringbuf_discard = 133,
	BPF_FUNC_ringbuf_query = 134,
	BPF_FUNC_csum_level = 135,
	BPF_FUNC_skc_to_tcp6_sock = 136,
	BPF_FUNC_skc_to_tcp_sock = 137,
	BPF_FUNC_skc_to_tcp_timewait_sock = 138,
	BPF_FUNC_skc_to_tcp_request_sock = 139,
	BPF_FUNC_skc_to_udp6_sock = 140,
	BPF_FUNC_get_task_stack = 141,
	BPF_FUNC_load_hdr_opt = 142,
	BPF_FUNC_store_hdr_opt = 143,
	BPF_FUNC_reserve_hdr_opt = 144,
	BPF_FUNC_inode_storage_get = 145,
	BPF_FUNC_inode_storage_delete = 146,
	BPF_FUNC_d_path = 147,
	BPF_FUNC_copy_from_user = 148,
	BPF_FUNC_snprintf_btf = 149,
	BPF_FUNC_seq_printf_btf = 150,
	BPF_FUNC_skb_cgroup_classid = 151,
	BPF_FUNC_redirect_neigh = 152,
	BPF_FUNC_per_cpu_ptr = 153,
	BPF_FUNC_this_cpu_ptr = 154,
	BPF_FUNC_redirect_peer = 155,
	BPF_FUNC_task_storage_get = 156,
	BPF_FUNC_task_storage_delete = 157,
	BPF_FUNC_get_current_task_btf = 158,
	BPF_FUNC_bprm_opts_set = 159,
	BPF_FUNC_ktime_get_coarse_ns = 160,
	BPF_FUNC_ima_inode_hash = 161,
	BPF_FUNC_sock_from_file = 162,
	BPF_FUNC_check_mtu = 163,
	BPF_FUNC_for_each_map_elem = 164,
	BPF_FUNC_snprintf = 165,
	BPF_FUNC_sys_bpf = 166,
	BPF_FUNC_btf_find_by_name_kind = 167,
	BPF_FUNC_sys_close = 168,
	BPF_FUNC_timer_init = 169,
	BPF_FUNC_timer_set_callback = 170,
	BPF_FUNC_timer_start = 171,
	BPF_FUNC_timer_cancel = 172,
	BPF_FUNC_get_func_ip = 173,
	BPF_FUNC_get_attach_cookie = 174,
	BPF_FUNC_task_pt_regs = 175,
	BPF_FUNC_get_branch_snapshot = 176,
	BPF_FUNC_trace_vprintk = 177,
	BPF_FUNC_skc_to_unix_sock = 178,
	BPF_FUNC_kallsyms_lookup_name = 179,
	BPF_FUNC_find_vma = 180,
	BPF_FUNC_loop = 181,
	BPF_FUNC_strncmp = 182,
	BPF_FUNC_get_func_arg = 183,
	BPF_FUNC_get_func_ret = 184,
	BPF_FUNC_get_func_arg_cnt = 185,
	BPF_FUNC_get_retval = 186,
	BPF_FUNC_set_retval = 187,
	BPF_FUNC_xdp_get_buff_len = 188,
	BPF_FUNC_xdp_load_bytes = 189,
	BPF_FUNC_xdp_store_bytes = 190,
	BPF_FUNC_copy_from_user_task = 191,
	BPF_FUNC_skb_set_tstamp = 192,
	BPF_FUNC_ima_file_hash = 193,
	BPF_FUNC_kptr_xchg = 194,
	BPF_FUNC_map_lookup_percpu_elem = 195,
	BPF_FUNC_skc_to_mptcp_sock = 196,
	BPF_FUNC_dynptr_from_mem = 197,
	BPF_FUNC_ringbuf_reserve_dynptr = 198,
	BPF_FUNC_ringbuf_submit_dynptr = 199,
	BPF_FUNC_ringbuf_discard_dynptr = 200,
	BPF_FUNC_dynptr_read = 201,
	BPF_FUNC_dynptr_write = 202,
	BPF_FUNC_dynptr_data = 203,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv4 = 204,
	BPF_FUNC_tcp_raw_gen_syncookie_ipv6 = 205,
	BPF_FUNC_tcp_raw_check_syncookie_ipv4 = 206,
	BPF_FUNC_tcp_raw_check_syncookie_ipv6 = 207,
	BPF_FUNC_ktime_get_tai_ns = 208,
	BPF_FUNC_user_ringbuf_drain = 209,
	BPF_FUNC_cgrp_storage_get = 210,
	BPF_FUNC_cgrp_storage_delete = 211,
	__BPF_FUNC_MAX_ID = 212,
};

enum bpf_hdr_start_off {
	BPF_HDR_START_MAC = 0,
	BPF_HDR_START_NET = 1,
};

enum bpf_iter_feature {
	BPF_ITER_RESCHED = 1,
};

enum bpf_iter_state {
	BPF_ITER_STATE_INVALID = 0,
	BPF_ITER_STATE_ACTIVE = 1,
	BPF_ITER_STATE_DRAINED = 2,
};

enum bpf_iter_task_type {
	BPF_TASK_ITER_ALL = 0,
	BPF_TASK_ITER_TID = 1,
	BPF_TASK_ITER_TGID = 2,
};

enum bpf_jit_poke_reason {
	BPF_POKE_REASON_TAIL_CALL = 0,
};

enum bpf_kfunc_flags {
	BPF_F_PAD_ZEROS = 1,
};

enum bpf_link_type {
	BPF_LINK_TYPE_UNSPEC = 0,
	BPF_LINK_TYPE_RAW_TRACEPOINT = 1,
	BPF_LINK_TYPE_TRACING = 2,
	BPF_LINK_TYPE_CGROUP = 3,
	BPF_LINK_TYPE_ITER = 4,
	BPF_LINK_TYPE_NETNS = 5,
	BPF_LINK_TYPE_XDP = 6,
	BPF_LINK_TYPE_PERF_EVENT = 7,
	BPF_LINK_TYPE_KPROBE_MULTI = 8,
	BPF_LINK_TYPE_STRUCT_OPS = 9,
	BPF_LINK_TYPE_NETFILTER = 10,
	BPF_LINK_TYPE_TCX = 11,
	BPF_LINK_TYPE_UPROBE_MULTI = 12,
	BPF_LINK_TYPE_NETKIT = 13,
	BPF_LINK_TYPE_SOCKMAP = 14,
	__MAX_BPF_LINK_TYPE = 15,
};

enum bpf_lru_list_type {
	BPF_LRU_LIST_T_ACTIVE = 0,
	BPF_LRU_LIST_T_INACTIVE = 1,
	BPF_LRU_LIST_T_FREE = 2,
	BPF_LRU_LOCAL_LIST_T_FREE = 3,
	BPF_LRU_LOCAL_LIST_T_PENDING = 4,
};

enum bpf_lwt_encap_mode {
	BPF_LWT_ENCAP_SEG6 = 0,
	BPF_LWT_ENCAP_SEG6_INLINE = 1,
	BPF_LWT_ENCAP_IP = 2,
};

enum bpf_map_type {
	BPF_MAP_TYPE_UNSPEC = 0,
	BPF_MAP_TYPE_HASH = 1,
	BPF_MAP_TYPE_ARRAY = 2,
	BPF_MAP_TYPE_PROG_ARRAY = 3,
	BPF_MAP_TYPE_PERF_EVENT_ARRAY = 4,
	BPF_MAP_TYPE_PERCPU_HASH = 5,
	BPF_MAP_TYPE_PERCPU_ARRAY = 6,
	BPF_MAP_TYPE_STACK_TRACE = 7,
	BPF_MAP_TYPE_CGROUP_ARRAY = 8,
	BPF_MAP_TYPE_LRU_HASH = 9,
	BPF_MAP_TYPE_LRU_PERCPU_HASH = 10,
	BPF_MAP_TYPE_LPM_TRIE = 11,
	BPF_MAP_TYPE_ARRAY_OF_MAPS = 12,
	BPF_MAP_TYPE_HASH_OF_MAPS = 13,
	BPF_MAP_TYPE_DEVMAP = 14,
	BPF_MAP_TYPE_SOCKMAP = 15,
	BPF_MAP_TYPE_CPUMAP = 16,
	BPF_MAP_TYPE_XSKMAP = 17,
	BPF_MAP_TYPE_SOCKHASH = 18,
	BPF_MAP_TYPE_CGROUP_STORAGE_DEPRECATED = 19,
	BPF_MAP_TYPE_CGROUP_STORAGE = 19,
	BPF_MAP_TYPE_REUSEPORT_SOCKARRAY = 20,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE_DEPRECATED = 21,
	BPF_MAP_TYPE_PERCPU_CGROUP_STORAGE = 21,
	BPF_MAP_TYPE_QUEUE = 22,
	BPF_MAP_TYPE_STACK = 23,
	BPF_MAP_TYPE_SK_STORAGE = 24,
	BPF_MAP_TYPE_DEVMAP_HASH = 25,
	BPF_MAP_TYPE_STRUCT_OPS = 26,
	BPF_MAP_TYPE_RINGBUF = 27,
	BPF_MAP_TYPE_INODE_STORAGE = 28,
	BPF_MAP_TYPE_TASK_STORAGE = 29,
	BPF_MAP_TYPE_BLOOM_FILTER = 30,
	BPF_MAP_TYPE_USER_RINGBUF = 31,
	BPF_MAP_TYPE_CGRP_STORAGE = 32,
	BPF_MAP_TYPE_ARENA = 33,
	__MAX_BPF_MAP_TYPE = 34,
};

enum bpf_netdev_command {
	XDP_SETUP_PROG = 0,
	XDP_SETUP_PROG_HW = 1,
	BPF_OFFLOAD_MAP_ALLOC = 2,
	BPF_OFFLOAD_MAP_FREE = 3,
	XDP_SETUP_XSK_POOL = 4,
};

enum bpf_perf_event_type {
	BPF_PERF_EVENT_UNSPEC = 0,
	BPF_PERF_EVENT_UPROBE = 1,
	BPF_PERF_EVENT_URETPROBE = 2,
	BPF_PERF_EVENT_KPROBE = 3,
	BPF_PERF_EVENT_KRETPROBE = 4,
	BPF_PERF_EVENT_TRACEPOINT = 5,
	BPF_PERF_EVENT_EVENT = 6,
};

enum bpf_prog_type {
	BPF_PROG_TYPE_UNSPEC = 0,
	BPF_PROG_TYPE_SOCKET_FILTER = 1,
	BPF_PROG_TYPE_KPROBE = 2,
	BPF_PROG_TYPE_SCHED_CLS = 3,
	BPF_PROG_TYPE_SCHED_ACT = 4,
	BPF_PROG_TYPE_TRACEPOINT = 5,
	BPF_PROG_TYPE_XDP = 6,
	BPF_PROG_TYPE_PERF_EVENT = 7,
	BPF_PROG_TYPE_CGROUP_SKB = 8,
	BPF_PROG_TYPE_CGROUP_SOCK = 9,
	BPF_PROG_TYPE_LWT_IN = 10,
	BPF_PROG_TYPE_LWT_OUT = 11,
	BPF_PROG_TYPE_LWT_XMIT = 12,
	BPF_PROG_TYPE_SOCK_OPS = 13,
	BPF_PROG_TYPE_SK_SKB = 14,
	BPF_PROG_TYPE_CGROUP_DEVICE = 15,
	BPF_PROG_TYPE_SK_MSG = 16,
	BPF_PROG_TYPE_RAW_TRACEPOINT = 17,
	BPF_PROG_TYPE_CGROUP_SOCK_ADDR = 18,
	BPF_PROG_TYPE_LWT_SEG6LOCAL = 19,
	BPF_PROG_TYPE_LIRC_MODE2 = 20,
	BPF_PROG_TYPE_SK_REUSEPORT = 21,
	BPF_PROG_TYPE_FLOW_DISSECTOR = 22,
	BPF_PROG_TYPE_CGROUP_SYSCTL = 23,
	BPF_PROG_TYPE_RAW_TRACEPOINT_WRITABLE = 24,
	BPF_PROG_TYPE_CGROUP_SOCKOPT = 25,
	BPF_PROG_TYPE_TRACING = 26,
	BPF_PROG_TYPE_STRUCT_OPS = 27,
	BPF_PROG_TYPE_EXT = 28,
	BPF_PROG_TYPE_LSM = 29,
	BPF_PROG_TYPE_SK_LOOKUP = 30,
	BPF_PROG_TYPE_SYSCALL = 31,
	BPF_PROG_TYPE_NETFILTER = 32,
	__MAX_BPF_PROG_TYPE = 33,
};

enum bpf_reg_liveness {
	REG_LIVE_NONE = 0,
	REG_LIVE_READ32 = 1,
	REG_LIVE_READ64 = 2,
	REG_LIVE_READ = 3,
	REG_LIVE_WRITTEN = 4,
	REG_LIVE_DONE = 8,
};

enum bpf_reg_type {
	NOT_INIT = 0,
	SCALAR_VALUE = 1,
	PTR_TO_CTX = 2,
	CONST_PTR_TO_MAP = 3,
	PTR_TO_MAP_VALUE = 4,
	PTR_TO_MAP_KEY = 5,
	PTR_TO_STACK = 6,
	PTR_TO_PACKET_META = 7,
	PTR_TO_PACKET = 8,
	PTR_TO_PACKET_END = 9,
	PTR_TO_FLOW_KEYS = 10,
	PTR_TO_SOCKET = 11,
	PTR_TO_SOCK_COMMON = 12,
	PTR_TO_TCP_SOCK = 13,
	PTR_TO_TP_BUFFER = 14,
	PTR_TO_XDP_SOCK = 15,
	PTR_TO_BTF_ID = 16,
	PTR_TO_MEM = 17,
	PTR_TO_ARENA = 18,
	PTR_TO_BUF = 19,
	PTR_TO_FUNC = 20,
	CONST_PTR_TO_DYNPTR = 21,
	__BPF_REG_TYPE_MAX = 22,
	PTR_TO_MAP_VALUE_OR_NULL = 260,
	PTR_TO_SOCKET_OR_NULL = 267,
	PTR_TO_SOCK_COMMON_OR_NULL = 268,
	PTR_TO_TCP_SOCK_OR_NULL = 269,
	PTR_TO_BTF_ID_OR_NULL = 272,
	__BPF_REG_TYPE_LIMIT = 134217727,
};

enum bpf_ret_code {
	BPF_OK = 0,
	BPF_DROP = 2,
	BPF_REDIRECT = 7,
	BPF_LWT_REROUTE = 128,
	BPF_FLOW_DISSECTOR_CONTINUE = 129,
};

enum bpf_return_type {
	RET_INTEGER = 0,
	RET_VOID = 1,
	RET_PTR_TO_MAP_VALUE = 2,
	RET_PTR_TO_SOCKET = 3,
	RET_PTR_TO_TCP_SOCK = 4,
	RET_PTR_TO_SOCK_COMMON = 5,
	RET_PTR_TO_MEM = 6,
	RET_PTR_TO_MEM_OR_BTF_ID = 7,
	RET_PTR_TO_BTF_ID = 8,
	__BPF_RET_TYPE_MAX = 9,
	RET_PTR_TO_MAP_VALUE_OR_NULL = 258,
	RET_PTR_TO_SOCKET_OR_NULL = 259,
	RET_PTR_TO_TCP_SOCK_OR_NULL = 260,
	RET_PTR_TO_SOCK_COMMON_OR_NULL = 261,
	RET_PTR_TO_RINGBUF_MEM_OR_NULL = 1286,
	RET_PTR_TO_DYNPTR_MEM_OR_NULL = 262,
	RET_PTR_TO_BTF_ID_OR_NULL = 264,
	RET_PTR_TO_BTF_ID_TRUSTED = 1048584,
	__BPF_RET_TYPE_LIMIT = 134217727,
};

enum bpf_stack_build_id_status {
	BPF_STACK_BUILD_ID_EMPTY = 0,
	BPF_STACK_BUILD_ID_VALID = 1,
	BPF_STACK_BUILD_ID_IP = 2,
};

enum bpf_stack_slot_type {
	STACK_INVALID = 0,
	STACK_SPILL = 1,
	STACK_MISC = 2,
	STACK_ZERO = 3,
	STACK_DYNPTR = 4,
	STACK_ITER = 5,
	STACK_IRQ_FLAG = 6,
};

enum bpf_stats_type {
	BPF_STATS_RUN_TIME = 0,
};

enum bpf_struct_ops_state {
	BPF_STRUCT_OPS_STATE_INIT = 0,
	BPF_STRUCT_OPS_STATE_INUSE = 1,
	BPF_STRUCT_OPS_STATE_TOBEFREE = 2,
	BPF_STRUCT_OPS_STATE_READY = 3,
};

enum bpf_struct_walk_result {
	WALK_SCALAR = 0,
	WALK_PTR = 1,
	WALK_STRUCT = 2,
};

enum bpf_task_fd_type {
	BPF_FD_TYPE_RAW_TRACEPOINT = 0,
	BPF_FD_TYPE_TRACEPOINT = 1,
	BPF_FD_TYPE_KPROBE = 2,
	BPF_FD_TYPE_KRETPROBE = 3,
	BPF_FD_TYPE_UPROBE = 4,
	BPF_FD_TYPE_URETPROBE = 5,
};

enum bpf_task_vma_iter_find_op {
	task_vma_iter_first_vma = 0,
	task_vma_iter_next_vma = 1,
	task_vma_iter_find_vma = 2,
};

enum bpf_text_poke_type {
	BPF_MOD_CALL = 0,
	BPF_MOD_JUMP = 1,
};

enum bpf_tramp_prog_type {
	BPF_TRAMP_FENTRY = 0,
	BPF_TRAMP_FEXIT = 1,
	BPF_TRAMP_MODIFY_RETURN = 2,
	BPF_TRAMP_MAX = 3,
	BPF_TRAMP_REPLACE = 4,
};

enum bpf_type {
	BPF_TYPE_UNSPEC = 0,
	BPF_TYPE_PROG = 1,
	BPF_TYPE_MAP = 2,
	BPF_TYPE_LINK = 3,
};

enum bpf_type_flag {
	PTR_MAYBE_NULL = 256,
	MEM_RDONLY = 512,
	MEM_RINGBUF = 1024,
	MEM_USER = 2048,
	MEM_PERCPU = 4096,
	OBJ_RELEASE = 8192,
	PTR_UNTRUSTED = 16384,
	MEM_UNINIT = 32768,
	DYNPTR_TYPE_LOCAL = 65536,
	DYNPTR_TYPE_RINGBUF = 131072,
	MEM_FIXED_SIZE = 262144,
	MEM_ALLOC = 524288,
	PTR_TRUSTED = 1048576,
	MEM_RCU = 2097152,
	NON_OWN_REF = 4194304,
	DYNPTR_TYPE_SKB = 8388608,
	DYNPTR_TYPE_XDP = 16777216,
	MEM_ALIGNED = 33554432,
	MEM_WRITE = 67108864,
	__BPF_TYPE_FLAG_MAX = 67108865,
	__BPF_TYPE_LAST_FLAG = 67108864,
};

enum bpf_xdp_mode {
	XDP_MODE_SKB = 0,
	XDP_MODE_DRV = 1,
	XDP_MODE_HW = 2,
	__MAX_XDP_MODE = 3,
};

enum bsc_xfer_cmd {
	CMD_WR = 0,
	CMD_RD = 1,
	CMD_WR_NOACK = 2,
	CMD_RD_NOACK = 3,
};

enum btf_arg_tag {
	ARG_TAG_CTX = 1,
	ARG_TAG_NONNULL = 2,
	ARG_TAG_TRUSTED = 4,
	ARG_TAG_NULLABLE = 8,
	ARG_TAG_ARENA = 16,
};

enum btf_field_iter_kind {
	BTF_FIELD_ITER_IDS = 0,
	BTF_FIELD_ITER_STRS = 1,
};

enum btf_field_type {
	BPF_SPIN_LOCK = 1,
	BPF_TIMER = 2,
	BPF_KPTR_UNREF = 4,
	BPF_KPTR_REF = 8,
	BPF_KPTR_PERCPU = 16,
	BPF_KPTR = 28,
	BPF_LIST_HEAD = 32,
	BPF_LIST_NODE = 64,
	BPF_RB_ROOT = 128,
	BPF_RB_NODE = 256,
	BPF_GRAPH_NODE = 320,
	BPF_GRAPH_ROOT = 160,
	BPF_REFCOUNT = 512,
	BPF_WORKQUEUE = 1024,
	BPF_UPTR = 2048,
	BPF_RES_SPIN_LOCK = 4096,
};

enum btf_func_linkage {
	BTF_FUNC_STATIC = 0,
	BTF_FUNC_GLOBAL = 1,
	BTF_FUNC_EXTERN = 2,
};

enum btf_kfunc_hook {
	BTF_KFUNC_HOOK_COMMON = 0,
	BTF_KFUNC_HOOK_XDP = 1,
	BTF_KFUNC_HOOK_TC = 2,
	BTF_KFUNC_HOOK_STRUCT_OPS = 3,
	BTF_KFUNC_HOOK_TRACING = 4,
	BTF_KFUNC_HOOK_SYSCALL = 5,
	BTF_KFUNC_HOOK_FMODRET = 6,
	BTF_KFUNC_HOOK_CGROUP = 7,
	BTF_KFUNC_HOOK_SCHED_ACT = 8,
	BTF_KFUNC_HOOK_SK_SKB = 9,
	BTF_KFUNC_HOOK_SOCKET_FILTER = 10,
	BTF_KFUNC_HOOK_LWT = 11,
	BTF_KFUNC_HOOK_NETFILTER = 12,
	BTF_KFUNC_HOOK_KPROBE = 13,
	BTF_KFUNC_HOOK_MAX = 14,
};

enum btrfs_block_group_flags {
	BLOCK_GROUP_FLAG_IREF = 0,
	BLOCK_GROUP_FLAG_REMOVED = 1,
	BLOCK_GROUP_FLAG_TO_COPY = 2,
	BLOCK_GROUP_FLAG_RELOCATING_REPAIR = 3,
	BLOCK_GROUP_FLAG_CHUNK_ITEM_INSERTED = 4,
	BLOCK_GROUP_FLAG_ZONE_IS_ACTIVE = 5,
	BLOCK_GROUP_FLAG_ZONED_DATA_RELOC = 6,
	BLOCK_GROUP_FLAG_NEEDS_FREE_SPACE = 7,
	BLOCK_GROUP_FLAG_FREE_SPACE_ADDED = 8,
	BLOCK_GROUP_FLAG_SEQUENTIAL_ZONE = 9,
	BLOCK_GROUP_FLAG_NEW = 10,
};

enum btrfs_block_group_size_class {
	BTRFS_BG_SZ_NONE = 0,
	BTRFS_BG_SZ_SMALL = 1,
	BTRFS_BG_SZ_MEDIUM = 2,
	BTRFS_BG_SZ_LARGE = 3,
};

enum btrfs_caching_type {
	BTRFS_CACHE_NO = 0,
	BTRFS_CACHE_STARTED = 1,
	BTRFS_CACHE_FINISHED = 2,
	BTRFS_CACHE_ERROR = 3,
};

enum btrfs_chunk_alloc_enum {
	CHUNK_ALLOC_NO_FORCE = 0,
	CHUNK_ALLOC_LIMITED = 1,
	CHUNK_ALLOC_FORCE = 2,
	CHUNK_ALLOC_FORCE_FOR_EXTENT = 3,
};

enum btrfs_chunk_allocation_policy {
	BTRFS_CHUNK_ALLOC_REGULAR = 0,
	BTRFS_CHUNK_ALLOC_ZONED = 1,
};

enum btrfs_compare_tree_result {
	BTRFS_COMPARE_TREE_NEW = 0,
	BTRFS_COMPARE_TREE_DELETED = 1,
	BTRFS_COMPARE_TREE_CHANGED = 2,
	BTRFS_COMPARE_TREE_SAME = 3,
};

enum btrfs_compression_type {
	BTRFS_COMPRESS_NONE = 0,
	BTRFS_COMPRESS_ZLIB = 1,
	BTRFS_COMPRESS_LZO = 2,
	BTRFS_COMPRESS_ZSTD = 3,
	BTRFS_NR_COMPRESS_TYPES = 4,
};

enum btrfs_csum_type {
	BTRFS_CSUM_TYPE_CRC32 = 0,
	BTRFS_CSUM_TYPE_XXHASH = 1,
	BTRFS_CSUM_TYPE_SHA256 = 2,
	BTRFS_CSUM_TYPE_BLAKE2 = 3,
};

enum btrfs_delayed_item_type {
	BTRFS_DELAYED_INSERTION_ITEM = 0,
	BTRFS_DELAYED_DELETION_ITEM = 1,
};

enum btrfs_delayed_ref_action {
	BTRFS_ADD_DELAYED_REF = 1,
	BTRFS_DROP_DELAYED_REF = 2,
	BTRFS_ADD_DELAYED_EXTENT = 3,
	BTRFS_UPDATE_DELAYED_HEAD = 4,
} __attribute__((mode(byte)));

enum btrfs_delayed_ref_flags {
	BTRFS_DELAYED_REFS_FLUSHING = 0,
};

enum btrfs_dev_stat_values {
	BTRFS_DEV_STAT_WRITE_ERRS = 0,
	BTRFS_DEV_STAT_READ_ERRS = 1,
	BTRFS_DEV_STAT_FLUSH_ERRS = 2,
	BTRFS_DEV_STAT_CORRUPTION_ERRS = 3,
	BTRFS_DEV_STAT_GENERATION_ERRS = 4,
	BTRFS_DEV_STAT_VALUES_MAX = 5,
};

enum btrfs_discard_state {
	BTRFS_DISCARD_EXTENTS = 0,
	BTRFS_DISCARD_BITMAPS = 1,
	BTRFS_DISCARD_RESET_CURSOR = 2,
};

enum btrfs_disk_cache_state {
	BTRFS_DC_WRITTEN = 0,
	BTRFS_DC_ERROR = 1,
	BTRFS_DC_CLEAR = 2,
	BTRFS_DC_SETUP = 3,
};

enum btrfs_err_code {
	BTRFS_ERROR_DEV_RAID1_MIN_NOT_MET = 1,
	BTRFS_ERROR_DEV_RAID10_MIN_NOT_MET = 2,
	BTRFS_ERROR_DEV_RAID5_MIN_NOT_MET = 3,
	BTRFS_ERROR_DEV_RAID6_MIN_NOT_MET = 4,
	BTRFS_ERROR_DEV_TGT_REPLACE = 5,
	BTRFS_ERROR_DEV_MISSING_NOT_FOUND = 6,
	BTRFS_ERROR_DEV_ONLY_WRITABLE = 7,
	BTRFS_ERROR_DEV_EXCL_RUN_IN_PROGRESS = 8,
	BTRFS_ERROR_DEV_RAID1C3_MIN_NOT_MET = 9,
	BTRFS_ERROR_DEV_RAID1C4_MIN_NOT_MET = 10,
};

enum btrfs_exclusive_operation {
	BTRFS_EXCLOP_NONE = 0,
	BTRFS_EXCLOP_BALANCE_PAUSED = 1,
	BTRFS_EXCLOP_BALANCE = 2,
	BTRFS_EXCLOP_DEV_ADD = 3,
	BTRFS_EXCLOP_DEV_REMOVE = 4,
	BTRFS_EXCLOP_DEV_REPLACE = 5,
	BTRFS_EXCLOP_RESIZE = 6,
	BTRFS_EXCLOP_SWAP_ACTIVATE = 7,
};

enum btrfs_extent_allocation_policy {
	BTRFS_EXTENT_ALLOC_CLUSTERED = 0,
	BTRFS_EXTENT_ALLOC_ZONED = 1,
};

enum btrfs_feature_set {
	FEAT_COMPAT = 0,
	FEAT_COMPAT_RO = 1,
	FEAT_INCOMPAT = 2,
	FEAT_MAX = 3,
};

enum btrfs_flush_state {
	FLUSH_DELAYED_ITEMS_NR = 1,
	FLUSH_DELAYED_ITEMS = 2,
	FLUSH_DELAYED_REFS_NR = 3,
	FLUSH_DELAYED_REFS = 4,
	FLUSH_DELALLOC = 5,
	FLUSH_DELALLOC_WAIT = 6,
	FLUSH_DELALLOC_FULL = 7,
	ALLOC_CHUNK = 8,
	ALLOC_CHUNK_FORCE = 9,
	RUN_DELAYED_IPUTS = 10,
	COMMIT_TRANS = 11,
	RESET_ZONES = 12,
};

enum btrfs_folio_type {
	BTRFS_SUBPAGE_METADATA = 0,
	BTRFS_SUBPAGE_DATA = 1,
};

enum btrfs_ilock_type {
	__BTRFS_ILOCK_SHARED_BIT = 0,
	BTRFS_ILOCK_SHARED = 1,
	__BTRFS_ILOCK_SHARED_SEQ = 0,
	__BTRFS_ILOCK_TRY_BIT = 1,
	BTRFS_ILOCK_TRY = 2,
	__BTRFS_ILOCK_TRY_SEQ = 1,
	__BTRFS_ILOCK_MMAP_BIT = 2,
	BTRFS_ILOCK_MMAP = 4,
	__BTRFS_ILOCK_MMAP_SEQ = 2,
};

enum btrfs_inline_ref_type {
	BTRFS_REF_TYPE_INVALID = 0,
	BTRFS_REF_TYPE_BLOCK = 1,
	BTRFS_REF_TYPE_DATA = 2,
	BTRFS_REF_TYPE_ANY = 3,
};

enum btrfs_lock_nesting {
	BTRFS_NESTING_NORMAL = 0,
	BTRFS_NESTING_COW = 1,
	BTRFS_NESTING_LEFT = 2,
	BTRFS_NESTING_RIGHT = 3,
	BTRFS_NESTING_LEFT_COW = 4,
	BTRFS_NESTING_RIGHT_COW = 5,
	BTRFS_NESTING_SPLIT = 6,
	BTRFS_NESTING_NEW_ROOT = 7,
	BTRFS_NESTING_MAX = 8,
};

enum btrfs_loop_type {
	LOOP_CACHING_NOWAIT = 0,
	LOOP_CACHING_WAIT = 1,
	LOOP_UNSET_SIZE_CLASS = 2,
	LOOP_ALLOC_CHUNK = 3,
	LOOP_WRONG_SIZE_CLASS = 4,
	LOOP_NO_EMPTY_SIZE = 5,
};

enum btrfs_map_op {
	BTRFS_MAP_READ = 0,
	BTRFS_MAP_WRITE = 1,
	BTRFS_MAP_GET_READ_MIRRORS = 2,
};

enum btrfs_mod_log_op {
	BTRFS_MOD_LOG_KEY_REPLACE = 0,
	BTRFS_MOD_LOG_KEY_ADD = 1,
	BTRFS_MOD_LOG_KEY_REMOVE = 2,
	BTRFS_MOD_LOG_KEY_REMOVE_WHILE_FREEING = 3,
	BTRFS_MOD_LOG_KEY_REMOVE_WHILE_MOVING = 4,
	BTRFS_MOD_LOG_MOVE_KEYS = 5,
	BTRFS_MOD_LOG_ROOT_REPLACE = 6,
};

enum btrfs_qgroup_mode {
	BTRFS_QGROUP_MODE_DISABLED = 0,
	BTRFS_QGROUP_MODE_FULL = 1,
	BTRFS_QGROUP_MODE_SIMPLE = 2,
};

enum btrfs_qgroup_rsv_type {
	BTRFS_QGROUP_RSV_DATA = 0,
	BTRFS_QGROUP_RSV_META_PERTRANS = 1,
	BTRFS_QGROUP_RSV_META_PREALLOC = 2,
	BTRFS_QGROUP_RSV_LAST = 3,
};

enum btrfs_raid_types {
	BTRFS_RAID_SINGLE = 0,
	BTRFS_RAID_RAID0 = 1,
	BTRFS_RAID_RAID1 = 2,
	BTRFS_RAID_DUP = 3,
	BTRFS_RAID_RAID10 = 4,
	BTRFS_RAID_RAID5 = 5,
	BTRFS_RAID_RAID6 = 6,
	BTRFS_RAID_RAID1C3 = 7,
	BTRFS_RAID_RAID1C4 = 8,
	BTRFS_NR_RAID_TYPES = 9,
};

enum btrfs_rbio_ops {
	BTRFS_RBIO_WRITE = 0,
	BTRFS_RBIO_READ_REBUILD = 1,
	BTRFS_RBIO_PARITY_SCRUB = 2,
};

enum btrfs_read_policy {
	BTRFS_READ_POLICY_PID = 0,
	BTRFS_NR_READ_POLICY = 1,
};

enum btrfs_ref_type {
	BTRFS_REF_NOT_SET = 0,
	BTRFS_REF_DATA = 1,
	BTRFS_REF_METADATA = 2,
} __attribute__((mode(byte)));

enum btrfs_reserve_flush_enum {
	BTRFS_RESERVE_NO_FLUSH = 0,
	BTRFS_RESERVE_FLUSH_LIMIT = 1,
	BTRFS_RESERVE_FLUSH_EVICT = 2,
	BTRFS_RESERVE_FLUSH_DATA = 3,
	BTRFS_RESERVE_FLUSH_FREE_SPACE_INODE = 4,
	BTRFS_RESERVE_FLUSH_ALL = 5,
	BTRFS_RESERVE_FLUSH_ALL_STEAL = 6,
	BTRFS_RESERVE_FLUSH_EMERGENCY = 7,
};

enum btrfs_rsv_type {
	BTRFS_BLOCK_RSV_GLOBAL = 0,
	BTRFS_BLOCK_RSV_DELALLOC = 1,
	BTRFS_BLOCK_RSV_TRANS = 2,
	BTRFS_BLOCK_RSV_CHUNK = 3,
	BTRFS_BLOCK_RSV_DELOPS = 4,
	BTRFS_BLOCK_RSV_DELREFS = 5,
	BTRFS_BLOCK_RSV_TREELOG = 6,
	BTRFS_BLOCK_RSV_EMPTY = 7,
	BTRFS_BLOCK_RSV_TEMP = 8,
};

enum btrfs_send_cmd {
	BTRFS_SEND_C_UNSPEC = 0,
	BTRFS_SEND_C_SUBVOL = 1,
	BTRFS_SEND_C_SNAPSHOT = 2,
	BTRFS_SEND_C_MKFILE = 3,
	BTRFS_SEND_C_MKDIR = 4,
	BTRFS_SEND_C_MKNOD = 5,
	BTRFS_SEND_C_MKFIFO = 6,
	BTRFS_SEND_C_MKSOCK = 7,
	BTRFS_SEND_C_SYMLINK = 8,
	BTRFS_SEND_C_RENAME = 9,
	BTRFS_SEND_C_LINK = 10,
	BTRFS_SEND_C_UNLINK = 11,
	BTRFS_SEND_C_RMDIR = 12,
	BTRFS_SEND_C_SET_XATTR = 13,
	BTRFS_SEND_C_REMOVE_XATTR = 14,
	BTRFS_SEND_C_WRITE = 15,
	BTRFS_SEND_C_CLONE = 16,
	BTRFS_SEND_C_TRUNCATE = 17,
	BTRFS_SEND_C_CHMOD = 18,
	BTRFS_SEND_C_CHOWN = 19,
	BTRFS_SEND_C_UTIMES = 20,
	BTRFS_SEND_C_END = 21,
	BTRFS_SEND_C_UPDATE_EXTENT = 22,
	BTRFS_SEND_C_MAX_V1 = 22,
	BTRFS_SEND_C_FALLOCATE = 23,
	BTRFS_SEND_C_FILEATTR = 24,
	BTRFS_SEND_C_ENCODED_WRITE = 25,
	BTRFS_SEND_C_MAX_V2 = 25,
	BTRFS_SEND_C_ENABLE_VERITY = 26,
	BTRFS_SEND_C_MAX_V3 = 26,
	BTRFS_SEND_C_MAX = 26,
};

enum btrfs_space_info_sub_group {
	BTRFS_SUB_GROUP_PRIMARY = 0,
	BTRFS_SUB_GROUP_DATA_RELOC = 1,
	BTRFS_SUB_GROUP_TREELOG = 2,
};

enum btrfs_trans_state {
	TRANS_STATE_RUNNING = 0,
	TRANS_STATE_COMMIT_PREP = 1,
	TRANS_STATE_COMMIT_START = 2,
	TRANS_STATE_COMMIT_DOING = 3,
	TRANS_STATE_UNBLOCKED = 4,
	TRANS_STATE_SUPER_COMMITTED = 5,
	TRANS_STATE_COMPLETED = 6,
	TRANS_STATE_MAX = 7,
};

enum btrfs_tree_block_status {
	BTRFS_TREE_BLOCK_CLEAN = 0,
	BTRFS_TREE_BLOCK_INVALID_NRITEMS = 1,
	BTRFS_TREE_BLOCK_INVALID_PARENT_KEY = 2,
	BTRFS_TREE_BLOCK_BAD_KEY_ORDER = 3,
	BTRFS_TREE_BLOCK_INVALID_LEVEL = 4,
	BTRFS_TREE_BLOCK_INVALID_FREE_SPACE = 5,
	BTRFS_TREE_BLOCK_INVALID_OFFSETS = 6,
	BTRFS_TREE_BLOCK_INVALID_BLOCKPTR = 7,
	BTRFS_TREE_BLOCK_INVALID_ITEM = 8,
	BTRFS_TREE_BLOCK_INVALID_OWNER = 9,
	BTRFS_TREE_BLOCK_WRITTEN_NOT_SET = 10,
};

enum btrfs_trim_state {
	BTRFS_TRIM_STATE_UNTRIMMED = 0,
	BTRFS_TRIM_STATE_TRIMMED = 1,
	BTRFS_TRIM_STATE_TRIMMING = 2,
};

enum buffer_map_state {
	UN_MAPPED = 0,
	PRE_MAPPED = 1,
	MUSB_MAPPED = 2,
};

enum bug_trap_type {
	BUG_TRAP_TYPE_NONE = 0,
	BUG_TRAP_TYPE_WARN = 1,
	BUG_TRAP_TYPE_BUG = 2,
};

enum bus_notifier_event {
	BUS_NOTIFY_ADD_DEVICE = 0,
	BUS_NOTIFY_DEL_DEVICE = 1,
	BUS_NOTIFY_REMOVED_DEVICE = 2,
	BUS_NOTIFY_BIND_DRIVER = 3,
	BUS_NOTIFY_BOUND_DRIVER = 4,
	BUS_NOTIFY_UNBIND_DRIVER = 5,
	BUS_NOTIFY_UNBOUND_DRIVER = 6,
	BUS_NOTIFY_DRIVER_NOT_BOUND = 7,
};

enum bus_speeds {
	SPD_375K = 0,
	SPD_390K = 1,
	SPD_187K = 2,
	SPD_200K = 3,
	SPD_93K = 4,
	SPD_97K = 5,
	SPD_46K = 6,
	SPD_50K = 7,
};

enum cache_type {
	CACHE_TYPE_NOCACHE = 0,
	CACHE_TYPE_INST = 1,
	CACHE_TYPE_DATA = 2,
	CACHE_TYPE_SEPARATE = 3,
	CACHE_TYPE_UNIFIED = 4,
};

enum cc_attr {
	CC_ATTR_MEM_ENCRYPT = 0,
	CC_ATTR_HOST_MEM_ENCRYPT = 1,
	CC_ATTR_GUEST_MEM_ENCRYPT = 2,
	CC_ATTR_GUEST_STATE_ENCRYPT = 3,
	CC_ATTR_GUEST_UNROLL_STRING_IO = 4,
	CC_ATTR_GUEST_SEV_SNP = 5,
	CC_ATTR_GUEST_SNP_SECURE_TSC = 6,
	CC_ATTR_HOST_SEV_SNP = 7,
};

enum cci400_perf_events {
	CCI400_PMU_CYCLES = 255,
};

enum cci_ace_port_type {
	ACE_INVALID_PORT = 0,
	ACE_PORT = 1,
	ACE_LITE_PORT = 2,
};

enum cci_models {
	CCI400_R0 = 0,
	CCI400_R1 = 1,
	CCI_MODEL_MAX = 2,
};

enum cd_types {
	ESDHC_CD_NONE = 0,
	ESDHC_CD_CONTROLLER = 1,
	ESDHC_CD_GPIO = 2,
	ESDHC_CD_PERMANENT = 3,
};

enum cd_types___2 {
	S3C_SDHCI_CD_INTERNAL = 0,
	S3C_SDHCI_CD_EXTERNAL = 1,
	S3C_SDHCI_CD_GPIO = 2,
	S3C_SDHCI_CD_NONE = 3,
	S3C_SDHCI_CD_PERMANENT = 4,
};

enum cdns_i2c_mode {
	CDNS_I2C_MODE_SLAVE = 0,
	CDNS_I2C_MODE_MASTER = 1,
};

enum cdns_i2c_slave_state {
	CDNS_I2C_SLAVE_STATE_IDLE = 0,
	CDNS_I2C_SLAVE_STATE_SEND = 1,
	CDNS_I2C_SLAVE_STATE_RECV = 2,
};

enum cdrom_print_option {
	CTL_NAME = 0,
	CTL_SPEED = 1,
	CTL_SLOTS = 2,
	CTL_CAPABILITY = 3,
};

enum cec_pin_state {
	CEC_ST_OFF = 0,
	CEC_ST_IDLE = 1,
	CEC_ST_TX_WAIT = 2,
	CEC_ST_TX_WAIT_FOR_HIGH = 3,
	CEC_ST_TX_START_BIT_LOW = 4,
	CEC_ST_TX_START_BIT_HIGH = 5,
	CEC_ST_TX_START_BIT_HIGH_SHORT = 6,
	CEC_ST_TX_START_BIT_HIGH_LONG = 7,
	CEC_ST_TX_START_BIT_LOW_CUSTOM = 8,
	CEC_ST_TX_START_BIT_HIGH_CUSTOM = 9,
	CEC_ST_TX_DATA_BIT_0_LOW = 10,
	CEC_ST_TX_DATA_BIT_0_HIGH = 11,
	CEC_ST_TX_DATA_BIT_0_HIGH_SHORT = 12,
	CEC_ST_TX_DATA_BIT_0_HIGH_LONG = 13,
	CEC_ST_TX_DATA_BIT_1_LOW = 14,
	CEC_ST_TX_DATA_BIT_1_HIGH = 15,
	CEC_ST_TX_DATA_BIT_1_HIGH_SHORT = 16,
	CEC_ST_TX_DATA_BIT_1_HIGH_LONG = 17,
	CEC_ST_TX_DATA_BIT_1_HIGH_PRE_SAMPLE = 18,
	CEC_ST_TX_DATA_BIT_1_HIGH_POST_SAMPLE = 19,
	CEC_ST_TX_DATA_BIT_1_HIGH_POST_SAMPLE_SHORT = 20,
	CEC_ST_TX_DATA_BIT_1_HIGH_POST_SAMPLE_LONG = 21,
	CEC_ST_TX_DATA_BIT_LOW_CUSTOM = 22,
	CEC_ST_TX_DATA_BIT_HIGH_CUSTOM = 23,
	CEC_ST_TX_PULSE_LOW_CUSTOM = 24,
	CEC_ST_TX_PULSE_HIGH_CUSTOM = 25,
	CEC_ST_TX_LOW_DRIVE = 26,
	CEC_ST_RX_START_BIT_LOW = 27,
	CEC_ST_RX_START_BIT_HIGH = 28,
	CEC_ST_RX_DATA_SAMPLE = 29,
	CEC_ST_RX_DATA_POST_SAMPLE = 30,
	CEC_ST_RX_DATA_WAIT_FOR_LOW = 31,
	CEC_ST_RX_ACK_LOW = 32,
	CEC_ST_RX_ACK_LOW_POST = 33,
	CEC_ST_RX_ACK_HIGH_POST = 34,
	CEC_ST_RX_ACK_FINISH = 35,
	CEC_ST_RX_LOW_DRIVE = 36,
	CEC_ST_RX_IRQ = 37,
	CEC_PIN_STATES = 38,
};

enum cee_attrs {
	DCB_ATTR_CEE_UNSPEC = 0,
	DCB_ATTR_CEE_PEER_PG = 1,
	DCB_ATTR_CEE_PEER_PFC = 2,
	DCB_ATTR_CEE_PEER_APP_TABLE = 3,
	DCB_ATTR_CEE_TX_PG = 4,
	DCB_ATTR_CEE_RX_PG = 5,
	DCB_ATTR_CEE_PFC = 6,
	DCB_ATTR_CEE_APP_TABLE = 7,
	DCB_ATTR_CEE_FEAT = 8,
	__DCB_ATTR_CEE_MAX = 9,
};

enum cfg80211_signal_type {
	CFG80211_SIGNAL_TYPE_NONE = 0,
	CFG80211_SIGNAL_TYPE_MBM = 1,
	CFG80211_SIGNAL_TYPE_UNSPEC = 2,
};

enum cfi_quirks {
	CFI_QUIRK_DQ_TRUE_DATA = 1,
};

enum cgroup1_param {
	Opt_all = 0,
	Opt_clone_children = 1,
	Opt_cpuset_v2_mode = 2,
	Opt_name = 3,
	Opt_none = 4,
	Opt_noprefix = 5,
	Opt_release_agent = 6,
	Opt_xattr = 7,
	Opt_favordynmods = 8,
	Opt_nofavordynmods = 9,
};

enum cgroup2_param {
	Opt_nsdelegate = 0,
	Opt_favordynmods___2 = 1,
	Opt_memory_localevents = 2,
	Opt_memory_recursiveprot = 3,
	Opt_memory_hugetlb_accounting = 4,
	Opt_pids_localevents = 5,
	nr__cgroup2_params = 6,
};

enum cgroup_bpf_attach_type {
	CGROUP_BPF_ATTACH_TYPE_INVALID = -1,
	CGROUP_INET_INGRESS = 0,
	CGROUP_INET_EGRESS = 1,
	CGROUP_INET_SOCK_CREATE = 2,
	CGROUP_SOCK_OPS = 3,
	CGROUP_DEVICE = 4,
	CGROUP_INET4_BIND = 5,
	CGROUP_INET6_BIND = 6,
	CGROUP_INET4_CONNECT = 7,
	CGROUP_INET6_CONNECT = 8,
	CGROUP_UNIX_CONNECT = 9,
	CGROUP_INET4_POST_BIND = 10,
	CGROUP_INET6_POST_BIND = 11,
	CGROUP_UDP4_SENDMSG = 12,
	CGROUP_UDP6_SENDMSG = 13,
	CGROUP_UNIX_SENDMSG = 14,
	CGROUP_SYSCTL = 15,
	CGROUP_UDP4_RECVMSG = 16,
	CGROUP_UDP6_RECVMSG = 17,
	CGROUP_UNIX_RECVMSG = 18,
	CGROUP_GETSOCKOPT = 19,
	CGROUP_SETSOCKOPT = 20,
	CGROUP_INET4_GETPEERNAME = 21,
	CGROUP_INET6_GETPEERNAME = 22,
	CGROUP_UNIX_GETPEERNAME = 23,
	CGROUP_INET4_GETSOCKNAME = 24,
	CGROUP_INET6_GETSOCKNAME = 25,
	CGROUP_UNIX_GETSOCKNAME = 26,
	CGROUP_INET_SOCK_RELEASE = 27,
	CGROUP_LSM_START = 28,
	CGROUP_LSM_END = 27,
	MAX_CGROUP_BPF_ATTACH_TYPE = 28,
};

enum cgroup_filetype {
	CGROUP_FILE_PROCS = 0,
	CGROUP_FILE_TASKS = 1,
};

enum cgroup_lifetime_events {
	CGROUP_LIFETIME_ONLINE = 0,
	CGROUP_LIFETIME_OFFLINE = 1,
};

enum cgroup_opt_features {
	OPT_FEATURE_PRESSURE = 0,
	OPT_FEATURE_COUNT = 1,
};

enum cgroup_subsys_id {
	cpuset_cgrp_id = 0,
	cpu_cgrp_id = 1,
	cpuacct_cgrp_id = 2,
	io_cgrp_id = 3,
	memory_cgrp_id = 4,
	devices_cgrp_id = 5,
	freezer_cgrp_id = 6,
	net_cls_cgrp_id = 7,
	perf_event_cgrp_id = 8,
	net_prio_cgrp_id = 9,
	pids_cgrp_id = 10,
	rdma_cgrp_id = 11,
	misc_cgrp_id = 12,
	CGROUP_SUBSYS_COUNT = 13,
};

enum chacha_constants {
	CHACHA_CONSTANT_EXPA = 1634760805,
	CHACHA_CONSTANT_ND_3 = 857760878,
	CHACHA_CONSTANT_2_BY = 2036477234,
	CHACHA_CONSTANT_TE_K = 1797285236,
};

enum chap_type_e {
	CHAP_TYPE_OUT = 0,
	CHAP_TYPE_IN = 1,
};

enum chip_type {
	chip_504x = 0,
	chip_508x = 1,
	chip_5080 = 2,
	chip_604x = 3,
	chip_608x = 4,
	chip_6042 = 5,
	chip_7042 = 6,
	chip_soc = 7,
};

enum chips {
	TPS62360 = 0,
	TPS62361 = 1,
	TPS62362 = 2,
	TPS62363 = 3,
};

enum chips___2 {
	PFUZE100 = 0,
	PFUZE200 = 1,
	PFUZE3000 = 3,
	PFUZE3001 = 49,
};

enum ci_hw_regs {
	CAP_CAPLENGTH = 0,
	CAP_HCCPARAMS = 1,
	CAP_DCCPARAMS = 2,
	CAP_TESTMODE = 3,
	CAP_LAST = 3,
	OP_USBCMD = 4,
	OP_USBSTS = 5,
	OP_USBINTR = 6,
	OP_FRINDEX = 7,
	OP_DEVICEADDR = 8,
	OP_ENDPTLISTADDR = 9,
	OP_TTCTRL = 10,
	OP_BURSTSIZE = 11,
	OP_ULPI_VIEWPORT = 12,
	OP_PORTSC = 13,
	OP_DEVLC = 14,
	OP_OTGSC = 15,
	OP_USBMODE = 16,
	OP_ENDPTSETUPSTAT = 17,
	OP_ENDPTPRIME = 18,
	OP_ENDPTFLUSH = 19,
	OP_ENDPTSTAT = 20,
	OP_ENDPTCOMPLETE = 21,
	OP_ENDPTCTRL = 22,
	OP_LAST = 38,
};

enum ci_revision {
	CI_REVISION_1X = 10,
	CI_REVISION_20 = 20,
	CI_REVISION_21 = 21,
	CI_REVISION_22 = 22,
	CI_REVISION_23 = 23,
	CI_REVISION_24 = 24,
	CI_REVISION_25 = 25,
	CI_REVISION_25_PLUS = 26,
	CI_REVISION_UNKNOWN = 99,
};

enum ci_role {
	CI_ROLE_HOST = 0,
	CI_ROLE_GADGET = 1,
	CI_ROLE_END = 2,
};

enum class_map_type {
	DD_CLASS_TYPE_DISJOINT_BITS = 0,
	DD_CLASS_TYPE_LEVEL_NUM = 1,
	DD_CLASS_TYPE_DISJOINT_NAMES = 2,
	DD_CLASS_TYPE_LEVEL_NAMES = 3,
};

enum class_stat_type {
	ZS_OBJS_ALLOCATED = 12,
	ZS_OBJS_INUSE = 13,
	NR_CLASS_STAT_TYPES = 14,
};

enum cleanup_prefix_rt_t {
	CLEANUP_PREFIX_RT_NOP = 0,
	CLEANUP_PREFIX_RT_DEL = 1,
	CLEANUP_PREFIX_RT_EXPIRE = 2,
};

enum clear_refs_types {
	CLEAR_REFS_ALL = 1,
	CLEAR_REFS_ANON = 2,
	CLEAR_REFS_MAPPED = 3,
	CLEAR_REFS_SOFT_DIRTY = 4,
	CLEAR_REFS_MM_HIWATER_RSS = 5,
	CLEAR_REFS_LAST = 6,
};

enum clk_id {
	tegra_clk_actmon = 0,
	tegra_clk_adx = 1,
	tegra_clk_adx1 = 2,
	tegra_clk_afi = 3,
	tegra_clk_amx = 4,
	tegra_clk_amx1 = 5,
	tegra_clk_apb2ape = 6,
	tegra_clk_ahbdma = 7,
	tegra_clk_apbdma = 8,
	tegra_clk_apbif = 9,
	tegra_clk_ape = 10,
	tegra_clk_audio0 = 11,
	tegra_clk_audio0_2x = 12,
	tegra_clk_audio0_mux = 13,
	tegra_clk_audio1 = 14,
	tegra_clk_audio1_2x = 15,
	tegra_clk_audio1_mux = 16,
	tegra_clk_audio2 = 17,
	tegra_clk_audio2_2x = 18,
	tegra_clk_audio2_mux = 19,
	tegra_clk_audio3 = 20,
	tegra_clk_audio3_2x = 21,
	tegra_clk_audio3_mux = 22,
	tegra_clk_audio4 = 23,
	tegra_clk_audio4_2x = 24,
	tegra_clk_audio4_mux = 25,
	tegra_clk_bsea = 26,
	tegra_clk_bsev = 27,
	tegra_clk_cclk_g = 28,
	tegra_clk_cclk_lp = 29,
	tegra_clk_cilab = 30,
	tegra_clk_cilcd = 31,
	tegra_clk_cile = 32,
	tegra_clk_clk_32k = 33,
	tegra_clk_clk72Mhz = 34,
	tegra_clk_clk72Mhz_8 = 35,
	tegra_clk_clk_m = 36,
	tegra_clk_osc = 37,
	tegra_clk_osc_div2 = 38,
	tegra_clk_osc_div4 = 39,
	tegra_clk_cml0 = 40,
	tegra_clk_cml1 = 41,
	tegra_clk_csi = 42,
	tegra_clk_csite = 43,
	tegra_clk_csite_8 = 44,
	tegra_clk_csus = 45,
	tegra_clk_cve = 46,
	tegra_clk_dam0 = 47,
	tegra_clk_dam1 = 48,
	tegra_clk_dam2 = 49,
	tegra_clk_d_audio = 50,
	tegra_clk_dbgapb = 51,
	tegra_clk_dds = 52,
	tegra_clk_dfll_ref = 53,
	tegra_clk_dfll_soc = 54,
	tegra_clk_disp1 = 55,
	tegra_clk_disp1_8 = 56,
	tegra_clk_disp2 = 57,
	tegra_clk_disp2_8 = 58,
	tegra_clk_dp2 = 59,
	tegra_clk_dpaux = 60,
	tegra_clk_dpaux1 = 61,
	tegra_clk_dsialp = 62,
	tegra_clk_dsia_mux = 63,
	tegra_clk_dsiblp = 64,
	tegra_clk_dsib_mux = 65,
	tegra_clk_dtv = 66,
	tegra_clk_emc = 67,
	tegra_clk_entropy = 68,
	tegra_clk_entropy_8 = 69,
	tegra_clk_epp = 70,
	tegra_clk_epp_8 = 71,
	tegra_clk_extern1 = 72,
	tegra_clk_extern2 = 73,
	tegra_clk_extern3 = 74,
	tegra_clk_fuse = 75,
	tegra_clk_fuse_burn = 76,
	tegra_clk_gpu = 77,
	tegra_clk_gr2d = 78,
	tegra_clk_gr2d_8 = 79,
	tegra_clk_gr3d = 80,
	tegra_clk_gr3d_8 = 81,
	tegra_clk_hclk = 82,
	tegra_clk_hda = 83,
	tegra_clk_hda_8 = 84,
	tegra_clk_hda2codec_2x = 85,
	tegra_clk_hda2codec_2x_8 = 86,
	tegra_clk_hda2hdmi = 87,
	tegra_clk_hdmi = 88,
	tegra_clk_hdmi_audio = 89,
	tegra_clk_host1x = 90,
	tegra_clk_host1x_8 = 91,
	tegra_clk_host1x_9 = 92,
	tegra_clk_hsic_trk = 93,
	tegra_clk_i2c1 = 94,
	tegra_clk_i2c2 = 95,
	tegra_clk_i2c3 = 96,
	tegra_clk_i2c4 = 97,
	tegra_clk_i2c5 = 98,
	tegra_clk_i2c6 = 99,
	tegra_clk_i2cslow = 100,
	tegra_clk_i2s0 = 101,
	tegra_clk_i2s0_sync = 102,
	tegra_clk_i2s1 = 103,
	tegra_clk_i2s1_sync = 104,
	tegra_clk_i2s2 = 105,
	tegra_clk_i2s2_sync = 106,
	tegra_clk_i2s3 = 107,
	tegra_clk_i2s3_sync = 108,
	tegra_clk_i2s4 = 109,
	tegra_clk_i2s4_sync = 110,
	tegra_clk_isp = 111,
	tegra_clk_isp_8 = 112,
	tegra_clk_isp_9 = 113,
	tegra_clk_ispb = 114,
	tegra_clk_kbc = 115,
	tegra_clk_kfuse = 116,
	tegra_clk_la = 117,
	tegra_clk_maud = 118,
	tegra_clk_mipi = 119,
	tegra_clk_mipibif = 120,
	tegra_clk_mipi_cal = 121,
	tegra_clk_mpe = 122,
	tegra_clk_mselect = 123,
	tegra_clk_msenc = 124,
	tegra_clk_ndflash = 125,
	tegra_clk_ndflash_8 = 126,
	tegra_clk_ndspeed = 127,
	tegra_clk_ndspeed_8 = 128,
	tegra_clk_nor = 129,
	tegra_clk_nvdec = 130,
	tegra_clk_nvenc = 131,
	tegra_clk_nvjpg = 132,
	tegra_clk_owr = 133,
	tegra_clk_owr_8 = 134,
	tegra_clk_pcie = 135,
	tegra_clk_pclk = 136,
	tegra_clk_pll_a = 137,
	tegra_clk_pll_a_out0 = 138,
	tegra_clk_pll_a1 = 139,
	tegra_clk_pll_c = 140,
	tegra_clk_pll_c2 = 141,
	tegra_clk_pll_c3 = 142,
	tegra_clk_pll_c4 = 143,
	tegra_clk_pll_c4_out0 = 144,
	tegra_clk_pll_c4_out1 = 145,
	tegra_clk_pll_c4_out2 = 146,
	tegra_clk_pll_c4_out3 = 147,
	tegra_clk_pll_c_out1 = 148,
	tegra_clk_pll_d = 149,
	tegra_clk_pll_d2 = 150,
	tegra_clk_pll_d2_out0 = 151,
	tegra_clk_pll_d_out0 = 152,
	tegra_clk_pll_dp = 153,
	tegra_clk_pll_e_out0 = 154,
	tegra_clk_pll_g_ref = 155,
	tegra_clk_pll_m = 156,
	tegra_clk_pll_m_out1 = 157,
	tegra_clk_pll_mb = 158,
	tegra_clk_pll_p = 159,
	tegra_clk_pll_p_out1 = 160,
	tegra_clk_pll_p_out2 = 161,
	tegra_clk_pll_p_out2_int = 162,
	tegra_clk_pll_p_out3 = 163,
	tegra_clk_pll_p_out4 = 164,
	tegra_clk_pll_p_out4_cpu = 165,
	tegra_clk_pll_p_out5 = 166,
	tegra_clk_pll_p_out_hsio = 167,
	tegra_clk_pll_p_out_xusb = 168,
	tegra_clk_pll_p_out_cpu = 169,
	tegra_clk_pll_p_out_adsp = 170,
	tegra_clk_pll_ref = 171,
	tegra_clk_pll_re_out = 172,
	tegra_clk_pll_re_vco = 173,
	tegra_clk_pll_u = 174,
	tegra_clk_pll_u_out = 175,
	tegra_clk_pll_u_out1 = 176,
	tegra_clk_pll_u_out2 = 177,
	tegra_clk_pll_u_12m = 178,
	tegra_clk_pll_u_480m = 179,
	tegra_clk_pll_u_48m = 180,
	tegra_clk_pll_u_60m = 181,
	tegra_clk_pll_x = 182,
	tegra_clk_pll_x_out0 = 183,
	tegra_clk_pwm = 184,
	tegra_clk_qspi = 185,
	tegra_clk_rtc = 186,
	tegra_clk_sata = 187,
	tegra_clk_sata_8 = 188,
	tegra_clk_sata_cold = 189,
	tegra_clk_sata_oob = 190,
	tegra_clk_sata_oob_8 = 191,
	tegra_clk_sbc1 = 192,
	tegra_clk_sbc1_8 = 193,
	tegra_clk_sbc1_9 = 194,
	tegra_clk_sbc2 = 195,
	tegra_clk_sbc2_8 = 196,
	tegra_clk_sbc2_9 = 197,
	tegra_clk_sbc3 = 198,
	tegra_clk_sbc3_8 = 199,
	tegra_clk_sbc3_9 = 200,
	tegra_clk_sbc4 = 201,
	tegra_clk_sbc4_8 = 202,
	tegra_clk_sbc4_9 = 203,
	tegra_clk_sbc5 = 204,
	tegra_clk_sbc5_8 = 205,
	tegra_clk_sbc6 = 206,
	tegra_clk_sbc6_8 = 207,
	tegra_clk_sclk = 208,
	tegra_clk_sdmmc_legacy = 209,
	tegra_clk_sdmmc1 = 210,
	tegra_clk_sdmmc1_8 = 211,
	tegra_clk_sdmmc1_9 = 212,
	tegra_clk_sdmmc2 = 213,
	tegra_clk_sdmmc2_8 = 214,
	tegra_clk_sdmmc3 = 215,
	tegra_clk_sdmmc3_8 = 216,
	tegra_clk_sdmmc3_9 = 217,
	tegra_clk_sdmmc4 = 218,
	tegra_clk_sdmmc4_8 = 219,
	tegra_clk_se = 220,
	tegra_clk_se_10 = 221,
	tegra_clk_soc_therm = 222,
	tegra_clk_soc_therm_8 = 223,
	tegra_clk_sor0 = 224,
	tegra_clk_sor0_out = 225,
	tegra_clk_sor1 = 226,
	tegra_clk_sor1_out = 227,
	tegra_clk_spdif = 228,
	tegra_clk_spdif_2x = 229,
	tegra_clk_spdif_in = 230,
	tegra_clk_spdif_in_8 = 231,
	tegra_clk_spdif_in_sync = 232,
	tegra_clk_spdif_mux = 233,
	tegra_clk_spdif_out = 234,
	tegra_clk_timer = 235,
	tegra_clk_trace = 236,
	tegra_clk_tsec = 237,
	tegra_clk_tsec_8 = 238,
	tegra_clk_tsecb = 239,
	tegra_clk_tsensor = 240,
	tegra_clk_tvdac = 241,
	tegra_clk_tvo = 242,
	tegra_clk_uarta = 243,
	tegra_clk_uarta_8 = 244,
	tegra_clk_uartb = 245,
	tegra_clk_uartb_8 = 246,
	tegra_clk_uartc = 247,
	tegra_clk_uartc_8 = 248,
	tegra_clk_uartd = 249,
	tegra_clk_uartd_8 = 250,
	tegra_clk_uarte = 251,
	tegra_clk_uarte_8 = 252,
	tegra_clk_uartape = 253,
	tegra_clk_usb2 = 254,
	tegra_clk_usb2_hsic_trk = 255,
	tegra_clk_usb2_trk = 256,
	tegra_clk_usb3 = 257,
	tegra_clk_usbd = 258,
	tegra_clk_vcp = 259,
	tegra_clk_vde = 260,
	tegra_clk_vde_8 = 261,
	tegra_clk_vfir = 262,
	tegra_clk_vi = 263,
	tegra_clk_vi_8 = 264,
	tegra_clk_vi_9 = 265,
	tegra_clk_vi_10 = 266,
	tegra_clk_vi_i2c = 267,
	tegra_clk_vic03 = 268,
	tegra_clk_vic03_8 = 269,
	tegra_clk_vim2_clk = 270,
	tegra_clk_vimclk_sync = 271,
	tegra_clk_vi_sensor = 272,
	tegra_clk_vi_sensor_8 = 273,
	tegra_clk_vi_sensor_9 = 274,
	tegra_clk_vi_sensor2 = 275,
	tegra_clk_vi_sensor2_8 = 276,
	tegra_clk_xusb_dev = 277,
	tegra_clk_xusb_dev_src = 278,
	tegra_clk_xusb_dev_src_8 = 279,
	tegra_clk_xusb_falcon_src = 280,
	tegra_clk_xusb_falcon_src_8 = 281,
	tegra_clk_xusb_fs_src = 282,
	tegra_clk_xusb_gate = 283,
	tegra_clk_xusb_host = 284,
	tegra_clk_xusb_host_src = 285,
	tegra_clk_xusb_host_src_8 = 286,
	tegra_clk_xusb_hs_src = 287,
	tegra_clk_xusb_hs_src_4 = 288,
	tegra_clk_xusb_ss = 289,
	tegra_clk_xusb_ss_src = 290,
	tegra_clk_xusb_ss_src_8 = 291,
	tegra_clk_xusb_ss_div2 = 292,
	tegra_clk_xusb_ssp_src = 293,
	tegra_clk_sclk_mux = 294,
	tegra_clk_sor_safe = 295,
	tegra_clk_cec = 296,
	tegra_clk_ispa = 297,
	tegra_clk_dmic1 = 298,
	tegra_clk_dmic2 = 299,
	tegra_clk_dmic3 = 300,
	tegra_clk_dmic1_sync_clk = 301,
	tegra_clk_dmic2_sync_clk = 302,
	tegra_clk_dmic3_sync_clk = 303,
	tegra_clk_dmic1_sync_clk_mux = 304,
	tegra_clk_dmic2_sync_clk_mux = 305,
	tegra_clk_dmic3_sync_clk_mux = 306,
	tegra_clk_iqc1 = 307,
	tegra_clk_iqc2 = 308,
	tegra_clk_pll_a_out_adsp = 309,
	tegra_clk_pll_a_out0_out_adsp = 310,
	tegra_clk_adsp = 311,
	tegra_clk_adsp_neon = 312,
	tegra_clk_max = 313,
};

enum clk_state {
	CLK_STATE_DISABLE = 0,
	CLK_STATE_ENABLE = 1,
	CLK_STATE_RESERVED = 2,
	CLK_STATE_UNCHANGED = 3,
};

enum clock_event_state {
	CLOCK_EVT_STATE_DETACHED = 0,
	CLOCK_EVT_STATE_SHUTDOWN = 1,
	CLOCK_EVT_STATE_PERIODIC = 2,
	CLOCK_EVT_STATE_ONESHOT = 3,
	CLOCK_EVT_STATE_ONESHOT_STOPPED = 4,
};

enum clock_recovery_m_value_type {
	CALCULATED_M = 0,
	REGISTER_M = 1,
};

enum clocksource_ids {
	CSID_GENERIC = 0,
	CSID_ARM_ARCH_COUNTER = 1,
	CSID_S390_TOD = 2,
	CSID_X86_TSC_EARLY = 3,
	CSID_X86_TSC = 4,
	CSID_X86_KVM_CLK = 5,
	CSID_X86_ART = 6,
	CSID_MAX = 7,
};

enum closure_state {
	CLOSURE_BITS_START = 67108864,
	CLOSURE_DESTRUCTOR = 67108864,
	CLOSURE_WAITING = 268435456,
	CLOSURE_RUNNING = 1073741824,
};

enum cluster_check_type {
	CLUSTER_IS_COMPR = 0,
	CLUSTER_COMPR_BLKS = 1,
	CLUSTER_RAW_BLKS = 2,
};

enum cma_flags {
	CMA_RESERVE_PAGES_ON_ERROR = 0,
	CMA_ZONES_VALID = 1,
	CMA_ZONES_INVALID = 2,
	CMA_ACTIVATED = 3,
};

enum cmd_mdp_stream0_pattern_sel {
	CMD_MDP_PRBS = 0,
	CMD_MDP_INCREMENTAL = 1,
	CMD_MDP_FIXED = 2,
	CMD_MDP_MDSS_GENERAL_PATTERN = 3,
};

enum cmis_cdb_fw_write_mechanism {
	CMIS_CDB_FW_WRITE_MECHANISM_NONE = 0,
	CMIS_CDB_FW_WRITE_MECHANISM_LPL = 1,
	CMIS_CDB_FW_WRITE_MECHANISM_EPL = 16,
	CMIS_CDB_FW_WRITE_MECHANISM_BOTH = 17,
};

enum color_coefficient {
	COLOR_YCBCR601 = 0,
	COLOR_YCBCR709 = 1,
};

enum color_depth {
	COLOR_6 = 0,
	COLOR_8 = 1,
	COLOR_10 = 2,
	COLOR_12 = 3,
};

enum color_fmts {
	COLOR_FMT_NV12 = 0,
	COLOR_FMT_NV21 = 1,
	COLOR_FMT_NV12_MVTB = 2,
	COLOR_FMT_NV12_UBWC = 3,
	COLOR_FMT_NV12_BPP10_UBWC = 4,
	COLOR_FMT_RGBA8888 = 5,
	COLOR_FMT_RGBA8888_UBWC = 6,
	COLOR_FMT_RGBA1010102_UBWC = 7,
	COLOR_FMT_RGB565_UBWC = 8,
	COLOR_FMT_P010_UBWC = 9,
	COLOR_FMT_P010 = 10,
};

enum color_mode {
	ALPHA_SRC_PRE_MUL = 0,
	ALPHA_SRC_NO_PRE_MUL = 1,
};

enum color_space {
	COLOR_RGB = 0,
	COLOR_YCBCR422 = 1,
	COLOR_YCBCR444 = 2,
};

enum compact_priority {
	COMPACT_PRIO_SYNC_FULL = 0,
	MIN_COMPACT_PRIORITY = 0,
	COMPACT_PRIO_SYNC_LIGHT = 1,
	MIN_COMPACT_COSTLY_PRIORITY = 1,
	DEF_COMPACT_PRIORITY = 1,
	COMPACT_PRIO_ASYNC = 2,
	INIT_COMPACT_PRIORITY = 2,
};

enum compact_result {
	COMPACT_NOT_SUITABLE_ZONE = 0,
	COMPACT_SKIPPED = 1,
	COMPACT_DEFERRED = 2,
	COMPACT_NO_SUITABLE_PAGE = 3,
	COMPACT_CONTINUE = 4,
	COMPACT_COMPLETE = 5,
	COMPACT_PARTIAL_SKIPPED = 6,
	COMPACT_CONTENDED = 7,
	COMPACT_SUCCESS = 8,
};

enum compress_algorithm_type {
	COMPRESS_LZO = 0,
	COMPRESS_LZ4 = 1,
	COMPRESS_ZSTD = 2,
	COMPRESS_LZORLE = 3,
	COMPRESS_MAX = 4,
};

enum compress_flag {
	COMPRESS_CHKSUM = 0,
	COMPRESS_MAX_FLAG = 1,
};

enum con_flush_mode {
	CONSOLE_FLUSH_PENDING = 0,
	CONSOLE_REPLAY_ALL = 1,
};

enum con_msg_format_flags {
	MSG_FORMAT_DEFAULT = 0,
	MSG_FORMAT_SYSLOG = 1,
};

enum con_scroll {
	SM_UP = 0,
	SM_DOWN = 1,
};

enum cons_flags {
	CON_PRINTBUFFER = 1,
	CON_CONSDEV = 2,
	CON_ENABLED = 4,
	CON_BOOT = 8,
	CON_ANYTIME = 16,
	CON_BRL = 32,
	CON_EXTENDED = 64,
	CON_SUSPENDED = 128,
	CON_NBCON = 256,
};

enum coredump_type_t {
	COREDUMP_FILE = 1,
	COREDUMP_PIPE = 2,
	COREDUMP_SOCK = 3,
};

enum count_type {
	F2FS_DIRTY_DENTS = 0,
	F2FS_DIRTY_DATA = 1,
	F2FS_DIRTY_QDATA = 2,
	F2FS_DIRTY_NODES = 3,
	F2FS_DIRTY_META = 4,
	F2FS_DIRTY_IMETA = 5,
	F2FS_WB_CP_DATA = 6,
	F2FS_WB_DATA = 7,
	F2FS_RD_DATA = 8,
	F2FS_RD_NODE = 9,
	F2FS_RD_META = 10,
	F2FS_DIO_WRITE = 11,
	F2FS_DIO_READ = 12,
	NR_COUNT_TYPE = 13,
};

enum cp_cond_function {
	WRITE_ALWAYS = 0,
	WRITE_LT = 1,
	WRITE_LE = 2,
	WRITE_EQ = 3,
	WRITE_NE = 4,
	WRITE_GE = 5,
	WRITE_GT = 6,
};

enum cp_reason_type {
	CP_NO_NEEDED = 0,
	CP_NON_REGULAR = 1,
	CP_COMPRESSED = 2,
	CP_HARDLINK = 3,
	CP_SB_NEED_CP = 4,
	CP_WRONG_PINO = 5,
	CP_NO_SPC_ROLL = 6,
	CP_NODE_NEED_CP = 7,
	CP_FASTBOOT_MODE = 8,
	CP_SPEC_LOG_NUM = 9,
	CP_RECOVER_DIR = 10,
	CP_XATTR_DIR = 11,
};

enum cp_thread {
	CP_SET_THREAD_BR = 1,
	CP_SET_THREAD_BV = 2,
	CP_SET_THREAD_BOTH = 3,
};

enum cpdma_control {
	CPDMA_TX_RLIM = 0,
	CPDMA_CMD_IDLE = 1,
	CPDMA_COPY_ERROR_FRAMES = 2,
	CPDMA_RX_OFF_LEN_UPDATE = 3,
	CPDMA_RX_OWNERSHIP_FLIP = 4,
	CPDMA_TX_PRIO_FIXED = 5,
	CPDMA_STAT_IDLE = 6,
	CPDMA_STAT_TX_ERR_CHAN = 7,
	CPDMA_STAT_TX_ERR_CODE = 8,
	CPDMA_STAT_RX_ERR_CHAN = 9,
	CPDMA_STAT_RX_ERR_CODE = 10,
	CPDMA_RX_BUFFER_OFFSET = 11,
};

enum cpdma_state {
	CPDMA_STATE_IDLE = 0,
	CPDMA_STATE_ACTIVE = 1,
	CPDMA_STATE_TEARDOWN = 2,
};

enum cpio_fields {
	C_MAGIC = 0,
	C_INO = 1,
	C_MODE = 2,
	C_UID = 3,
	C_GID = 4,
	C_NLINK = 5,
	C_MTIME = 6,
	C_FILESIZE = 7,
	C_MAJ = 8,
	C_MIN = 9,
	C_RMAJ = 10,
	C_RMIN = 11,
	C_NAMESIZE = 12,
	C_CHKSUM = 13,
	C_NFIELDS = 14,
};

enum cpsw_ale_control {
	ALE_ENABLE = 0,
	ALE_CLEAR = 1,
	ALE_AGEOUT = 2,
	ALE_P0_UNI_FLOOD = 3,
	ALE_VLAN_NOLEARN = 4,
	ALE_NO_PORT_VLAN = 5,
	ALE_OUI_DENY = 6,
	ALE_BYPASS = 7,
	ALE_RATE_LIMIT_TX = 8,
	ALE_VLAN_AWARE = 9,
	ALE_AUTH_ENABLE = 10,
	ALE_RATE_LIMIT = 11,
	ALE_PORT_STATE = 12,
	ALE_PORT_DROP_UNTAGGED = 13,
	ALE_PORT_DROP_UNKNOWN_VLAN = 14,
	ALE_PORT_NOLEARN = 15,
	ALE_PORT_NO_SA_UPDATE = 16,
	ALE_PORT_UNKNOWN_VLAN_MEMBER = 17,
	ALE_PORT_UNKNOWN_MCAST_FLOOD = 18,
	ALE_PORT_UNKNOWN_REG_MCAST_FLOOD = 19,
	ALE_PORT_UNTAGGED_EGRESS = 20,
	ALE_PORT_MACONLY = 21,
	ALE_PORT_MACONLY_CAF = 22,
	ALE_PORT_BCAST_LIMIT = 23,
	ALE_PORT_MCAST_LIMIT = 24,
	ALE_DEFAULT_THREAD_ID = 25,
	ALE_DEFAULT_THREAD_ENABLE = 26,
	ALE_NUM_CONTROLS = 27,
};

enum cpsw_ale_port_state {
	ALE_PORT_STATE_DISABLE = 0,
	ALE_PORT_STATE_BLOCK = 1,
	ALE_PORT_STATE_LEARN = 2,
	ALE_PORT_STATE_FORWARD = 3,
};

enum cpsw_devlink_param_id {
	CPSW_DEVLINK_PARAM_ID_BASE = 16,
	CPSW_DL_PARAM_SWITCH_MODE = 17,
	CPSW_DL_PARAM_ALE_BYPASS = 18,
};

enum cpsw_sl_regs {
	CPSW_SL_IDVER = 0,
	CPSW_SL_MACCONTROL = 1,
	CPSW_SL_MACSTATUS = 2,
	CPSW_SL_SOFT_RESET = 3,
	CPSW_SL_RX_MAXLEN = 4,
	CPSW_SL_BOFFTEST = 5,
	CPSW_SL_RX_PAUSE = 6,
	CPSW_SL_TX_PAUSE = 7,
	CPSW_SL_EMCONTROL = 8,
	CPSW_SL_RX_PRI_MAP = 9,
	CPSW_SL_TX_GAP = 10,
};

enum cpu_idle_type {
	__CPU_NOT_IDLE = 0,
	CPU_IDLE = 1,
	CPU_NEWLY_IDLE = 2,
	CPU_MAX_IDLE_TYPES = 3,
};

enum cpu_led_event {
	CPU_LED_IDLE_START = 0,
	CPU_LED_IDLE_END = 1,
	CPU_LED_START = 2,
	CPU_LED_STOP = 3,
	CPU_LED_HALTED = 4,
};

enum cpu_mitigations {
	CPU_MITIGATIONS_OFF = 0,
	CPU_MITIGATIONS_AUTO = 1,
	CPU_MITIGATIONS_AUTO_NOSMT = 2,
};

enum cpu_pm_event {
	CPU_PM_ENTER = 0,
	CPU_PM_ENTER_FAILED = 1,
	CPU_PM_EXIT = 2,
	CPU_CLUSTER_PM_ENTER = 3,
	CPU_CLUSTER_PM_ENTER_FAILED = 4,
	CPU_CLUSTER_PM_EXIT = 5,
};

enum cpu_usage_stat {
	CPUTIME_USER = 0,
	CPUTIME_NICE = 1,
	CPUTIME_SYSTEM = 2,
	CPUTIME_SOFTIRQ = 3,
	CPUTIME_IRQ = 4,
	CPUTIME_IDLE = 5,
	CPUTIME_IOWAIT = 6,
	CPUTIME_STEAL = 7,
	CPUTIME_GUEST = 8,
	CPUTIME_GUEST_NICE = 9,
	NR_STATS = 10,
};

enum cpuacct_stat_index {
	CPUACCT_STAT_USER = 0,
	CPUACCT_STAT_SYSTEM = 1,
	CPUACCT_STAT_NSTATS = 2,
};

enum cpufreq_table_sorting {
	CPUFREQ_TABLE_UNSORTED = 0,
	CPUFREQ_TABLE_SORTED_ASCENDING = 1,
	CPUFREQ_TABLE_SORTED_DESCENDING = 2,
};

enum cpuhp_smt_control {
	CPU_SMT_ENABLED = 0,
	CPU_SMT_DISABLED = 1,
	CPU_SMT_FORCE_DISABLED = 2,
	CPU_SMT_NOT_SUPPORTED = 3,
	CPU_SMT_NOT_IMPLEMENTED = 4,
};

enum cpuhp_state {
	CPUHP_INVALID = -1,
	CPUHP_OFFLINE = 0,
	CPUHP_CREATE_THREADS = 1,
	CPUHP_PERF_X86_PREPARE = 2,
	CPUHP_PERF_X86_AMD_UNCORE_PREP = 3,
	CPUHP_PERF_POWER = 4,
	CPUHP_PERF_SUPERH = 5,
	CPUHP_X86_HPET_DEAD = 6,
	CPUHP_X86_MCE_DEAD = 7,
	CPUHP_VIRT_NET_DEAD = 8,
	CPUHP_IBMVNIC_DEAD = 9,
	CPUHP_SLUB_DEAD = 10,
	CPUHP_DEBUG_OBJ_DEAD = 11,
	CPUHP_MM_WRITEBACK_DEAD = 12,
	CPUHP_MM_VMSTAT_DEAD = 13,
	CPUHP_SOFTIRQ_DEAD = 14,
	CPUHP_NET_MVNETA_DEAD = 15,
	CPUHP_CPUIDLE_DEAD = 16,
	CPUHP_ARM64_FPSIMD_DEAD = 17,
	CPUHP_ARM_OMAP_WAKE_DEAD = 18,
	CPUHP_IRQ_POLL_DEAD = 19,
	CPUHP_BLOCK_SOFTIRQ_DEAD = 20,
	CPUHP_BIO_DEAD = 21,
	CPUHP_ACPI_CPUDRV_DEAD = 22,
	CPUHP_S390_PFAULT_DEAD = 23,
	CPUHP_BLK_MQ_DEAD = 24,
	CPUHP_FS_BUFF_DEAD = 25,
	CPUHP_PRINTK_DEAD = 26,
	CPUHP_MM_MEMCQ_DEAD = 27,
	CPUHP_PERCPU_CNT_DEAD = 28,
	CPUHP_RADIX_DEAD = 29,
	CPUHP_PAGE_ALLOC = 30,
	CPUHP_NET_DEV_DEAD = 31,
	CPUHP_PCI_XGENE_DEAD = 32,
	CPUHP_IOMMU_IOVA_DEAD = 33,
	CPUHP_AP_ARM_CACHE_B15_RAC_DEAD = 34,
	CPUHP_PADATA_DEAD = 35,
	CPUHP_AP_DTPM_CPU_DEAD = 36,
	CPUHP_RANDOM_PREPARE = 37,
	CPUHP_WORKQUEUE_PREP = 38,
	CPUHP_POWER_NUMA_PREPARE = 39,
	CPUHP_HRTIMERS_PREPARE = 40,
	CPUHP_X2APIC_PREPARE = 41,
	CPUHP_SMPCFD_PREPARE = 42,
	CPUHP_RELAY_PREPARE = 43,
	CPUHP_MD_RAID5_PREPARE = 44,
	CPUHP_RCUTREE_PREP = 45,
	CPUHP_CPUIDLE_COUPLED_PREPARE = 46,
	CPUHP_POWERPC_PMAC_PREPARE = 47,
	CPUHP_POWERPC_MMU_CTX_PREPARE = 48,
	CPUHP_XEN_PREPARE = 49,
	CPUHP_XEN_EVTCHN_PREPARE = 50,
	CPUHP_ARM_SHMOBILE_SCU_PREPARE = 51,
	CPUHP_SH_SH3X_PREPARE = 52,
	CPUHP_TOPOLOGY_PREPARE = 53,
	CPUHP_NET_IUCV_PREPARE = 54,
	CPUHP_ARM_BL_PREPARE = 55,
	CPUHP_TRACE_RB_PREPARE = 56,
	CPUHP_MM_ZSWP_POOL_PREPARE = 57,
	CPUHP_KVM_PPC_BOOK3S_PREPARE = 58,
	CPUHP_ZCOMP_PREPARE = 59,
	CPUHP_TIMERS_PREPARE = 60,
	CPUHP_TMIGR_PREPARE = 61,
	CPUHP_MIPS_SOC_PREPARE = 62,
	CPUHP_BP_PREPARE_DYN = 63,
	CPUHP_BP_PREPARE_DYN_END = 83,
	CPUHP_BP_KICK_AP = 84,
	CPUHP_BRINGUP_CPU = 85,
	CPUHP_AP_IDLE_DEAD = 86,
	CPUHP_AP_OFFLINE = 87,
	CPUHP_AP_CACHECTRL_STARTING = 88,
	CPUHP_AP_SCHED_STARTING = 89,
	CPUHP_AP_RCUTREE_DYING = 90,
	CPUHP_AP_CPU_PM_STARTING = 91,
	CPUHP_AP_IRQ_GIC_STARTING = 92,
	CPUHP_AP_IRQ_HIP04_STARTING = 93,
	CPUHP_AP_IRQ_APPLE_AIC_STARTING = 94,
	CPUHP_AP_IRQ_ARMADA_XP_STARTING = 95,
	CPUHP_AP_IRQ_BCM2836_STARTING = 96,
	CPUHP_AP_IRQ_MIPS_GIC_STARTING = 97,
	CPUHP_AP_IRQ_EIOINTC_STARTING = 98,
	CPUHP_AP_IRQ_AVECINTC_STARTING = 99,
	CPUHP_AP_IRQ_SIFIVE_PLIC_STARTING = 100,
	CPUHP_AP_IRQ_THEAD_ACLINT_SSWI_STARTING = 101,
	CPUHP_AP_IRQ_RISCV_IMSIC_STARTING = 102,
	CPUHP_AP_IRQ_RISCV_SBI_IPI_STARTING = 103,
	CPUHP_AP_ARM_MVEBU_COHERENCY = 104,
	CPUHP_AP_PERF_X86_AMD_UNCORE_STARTING = 105,
	CPUHP_AP_PERF_X86_STARTING = 106,
	CPUHP_AP_PERF_X86_AMD_IBS_STARTING = 107,
	CPUHP_AP_PERF_XTENSA_STARTING = 108,
	CPUHP_AP_ARM_VFP_STARTING = 109,
	CPUHP_AP_ARM64_DEBUG_MONITORS_STARTING = 110,
	CPUHP_AP_PERF_ARM_HW_BREAKPOINT_STARTING = 111,
	CPUHP_AP_PERF_ARM_ACPI_STARTING = 112,
	CPUHP_AP_PERF_ARM_STARTING = 113,
	CPUHP_AP_PERF_RISCV_STARTING = 114,
	CPUHP_AP_ARM_L2X0_STARTING = 115,
	CPUHP_AP_EXYNOS4_MCT_TIMER_STARTING = 116,
	CPUHP_AP_ARM_ARCH_TIMER_STARTING = 117,
	CPUHP_AP_ARM_ARCH_TIMER_EVTSTRM_STARTING = 118,
	CPUHP_AP_ARM_GLOBAL_TIMER_STARTING = 119,
	CPUHP_AP_JCORE_TIMER_STARTING = 120,
	CPUHP_AP_ARM_TWD_STARTING = 121,
	CPUHP_AP_QCOM_TIMER_STARTING = 122,
	CPUHP_AP_TEGRA_TIMER_STARTING = 123,
	CPUHP_AP_ARMADA_TIMER_STARTING = 124,
	CPUHP_AP_LOONGARCH_ARCH_TIMER_STARTING = 125,
	CPUHP_AP_MIPS_GIC_TIMER_STARTING = 126,
	CPUHP_AP_ARC_TIMER_STARTING = 127,
	CPUHP_AP_REALTEK_TIMER_STARTING = 128,
	CPUHP_AP_RISCV_TIMER_STARTING = 129,
	CPUHP_AP_CLINT_TIMER_STARTING = 130,
	CPUHP_AP_CSKY_TIMER_STARTING = 131,
	CPUHP_AP_TI_GP_TIMER_STARTING = 132,
	CPUHP_AP_HYPERV_TIMER_STARTING = 133,
	CPUHP_AP_DUMMY_TIMER_STARTING = 134,
	CPUHP_AP_ARM_XEN_STARTING = 135,
	CPUHP_AP_ARM_XEN_RUNSTATE_STARTING = 136,
	CPUHP_AP_ARM_CORESIGHT_STARTING = 137,
	CPUHP_AP_ARM_CORESIGHT_CTI_STARTING = 138,
	CPUHP_AP_ARM64_ISNDEP_STARTING = 139,
	CPUHP_AP_SMPCFD_DYING = 140,
	CPUHP_AP_HRTIMERS_DYING = 141,
	CPUHP_AP_TICK_DYING = 142,
	CPUHP_AP_X86_TBOOT_DYING = 143,
	CPUHP_AP_ARM_CACHE_B15_RAC_DYING = 144,
	CPUHP_AP_ONLINE = 145,
	CPUHP_TEARDOWN_CPU = 146,
	CPUHP_AP_ONLINE_IDLE = 147,
	CPUHP_AP_HYPERV_ONLINE = 148,
	CPUHP_AP_KVM_ONLINE = 149,
	CPUHP_AP_SCHED_WAIT_EMPTY = 150,
	CPUHP_AP_SMPBOOT_THREADS = 151,
	CPUHP_AP_IRQ_AFFINITY_ONLINE = 152,
	CPUHP_AP_BLK_MQ_ONLINE = 153,
	CPUHP_AP_ARM_MVEBU_SYNC_CLOCKS = 154,
	CPUHP_AP_X86_INTEL_EPB_ONLINE = 155,
	CPUHP_AP_PERF_ONLINE = 156,
	CPUHP_AP_PERF_X86_ONLINE = 157,
	CPUHP_AP_PERF_X86_UNCORE_ONLINE = 158,
	CPUHP_AP_PERF_X86_AMD_UNCORE_ONLINE = 159,
	CPUHP_AP_PERF_X86_AMD_POWER_ONLINE = 160,
	CPUHP_AP_PERF_S390_CF_ONLINE = 161,
	CPUHP_AP_PERF_S390_SF_ONLINE = 162,
	CPUHP_AP_PERF_ARM_CCI_ONLINE = 163,
	CPUHP_AP_PERF_ARM_CCN_ONLINE = 164,
	CPUHP_AP_PERF_ARM_HISI_CPA_ONLINE = 165,
	CPUHP_AP_PERF_ARM_HISI_DDRC_ONLINE = 166,
	CPUHP_AP_PERF_ARM_HISI_HHA_ONLINE = 167,
	CPUHP_AP_PERF_ARM_HISI_L3_ONLINE = 168,
	CPUHP_AP_PERF_ARM_HISI_PA_ONLINE = 169,
	CPUHP_AP_PERF_ARM_HISI_SLLC_ONLINE = 170,
	CPUHP_AP_PERF_ARM_HISI_PCIE_PMU_ONLINE = 171,
	CPUHP_AP_PERF_ARM_HNS3_PMU_ONLINE = 172,
	CPUHP_AP_PERF_ARM_L2X0_ONLINE = 173,
	CPUHP_AP_PERF_ARM_QCOM_L2_ONLINE = 174,
	CPUHP_AP_PERF_ARM_QCOM_L3_ONLINE = 175,
	CPUHP_AP_PERF_ARM_APM_XGENE_ONLINE = 176,
	CPUHP_AP_PERF_ARM_CAVIUM_TX2_UNCORE_ONLINE = 177,
	CPUHP_AP_PERF_ARM_MARVELL_CN10K_DDR_ONLINE = 178,
	CPUHP_AP_PERF_ARM_MRVL_PEM_ONLINE = 179,
	CPUHP_AP_PERF_POWERPC_NEST_IMC_ONLINE = 180,
	CPUHP_AP_PERF_POWERPC_CORE_IMC_ONLINE = 181,
	CPUHP_AP_PERF_POWERPC_THREAD_IMC_ONLINE = 182,
	CPUHP_AP_PERF_POWERPC_TRACE_IMC_ONLINE = 183,
	CPUHP_AP_PERF_POWERPC_HV_24x7_ONLINE = 184,
	CPUHP_AP_PERF_POWERPC_HV_GPCI_ONLINE = 185,
	CPUHP_AP_PERF_CSKY_ONLINE = 186,
	CPUHP_AP_TMIGR_ONLINE = 187,
	CPUHP_AP_WATCHDOG_ONLINE = 188,
	CPUHP_AP_WORKQUEUE_ONLINE = 189,
	CPUHP_AP_RANDOM_ONLINE = 190,
	CPUHP_AP_RCUTREE_ONLINE = 191,
	CPUHP_AP_KTHREADS_ONLINE = 192,
	CPUHP_AP_BASE_CACHEINFO_ONLINE = 193,
	CPUHP_AP_ONLINE_DYN = 194,
	CPUHP_AP_ONLINE_DYN_END = 234,
	CPUHP_AP_X86_HPET_ONLINE = 235,
	CPUHP_AP_X86_KVM_CLK_ONLINE = 236,
	CPUHP_AP_ACTIVE = 237,
	CPUHP_ONLINE = 238,
};

enum cpuhp_sync_state {
	SYNC_STATE_DEAD = 0,
	SYNC_STATE_KICKED = 1,
	SYNC_STATE_SHOULD_DIE = 2,
	SYNC_STATE_ALIVE = 3,
	SYNC_STATE_SHOULD_ONLINE = 4,
	SYNC_STATE_ONLINE = 5,
};

enum createmode4 {
	NFS4_CREATE_UNCHECKED = 0,
	NFS4_CREATE_GUARDED = 1,
	NFS4_CREATE_EXCLUSIVE = 2,
	NFS4_CREATE_EXCLUSIVE4_1 = 3,
};

enum criteria {
	CR_POWER2_ALIGNED = 0,
	CR_GOAL_LEN_FAST = 1,
	CR_BEST_AVAIL_LEN = 2,
	CR_GOAL_LEN_SLOW = 3,
	CR_ANY_FREE = 4,
	EXT4_MB_NUM_CRS = 5,
};

enum crypto_attr_type_t {
	CRYPTOCFGA_UNSPEC = 0,
	CRYPTOCFGA_PRIORITY_VAL = 1,
	CRYPTOCFGA_REPORT_LARVAL = 2,
	CRYPTOCFGA_REPORT_HASH = 3,
	CRYPTOCFGA_REPORT_BLKCIPHER = 4,
	CRYPTOCFGA_REPORT_AEAD = 5,
	CRYPTOCFGA_REPORT_COMPRESS = 6,
	CRYPTOCFGA_REPORT_RNG = 7,
	CRYPTOCFGA_REPORT_CIPHER = 8,
	CRYPTOCFGA_REPORT_AKCIPHER = 9,
	CRYPTOCFGA_REPORT_KPP = 10,
	CRYPTOCFGA_REPORT_ACOMP = 11,
	CRYPTOCFGA_STAT_LARVAL = 12,
	CRYPTOCFGA_STAT_HASH = 13,
	CRYPTOCFGA_STAT_BLKCIPHER = 14,
	CRYPTOCFGA_STAT_AEAD = 15,
	CRYPTOCFGA_STAT_COMPRESS = 16,
	CRYPTOCFGA_STAT_RNG = 17,
	CRYPTOCFGA_STAT_CIPHER = 18,
	CRYPTOCFGA_STAT_AKCIPHER = 19,
	CRYPTOCFGA_STAT_KPP = 20,
	CRYPTOCFGA_STAT_ACOMP = 21,
	CRYPTOCFGA_REPORT_SIG = 22,
	__CRYPTOCFGA_MAX = 23,
};

enum csc_type {
	CSC_RGB2RGB = 0,
	CSC_YUV2RGB = 1,
	CSC_RGB2YUV = 2,
	CSC_YUV2YUV = 3,
	CSC_MAX = 4,
};

enum css_task_iter_flags {
	CSS_TASK_ITER_PROCS = 1,
	CSS_TASK_ITER_THREADED = 2,
	CSS_TASK_ITER_SKIPPED = 65536,
};

enum ct_dccp_states {
	CT_DCCP_NONE = 0,
	CT_DCCP_REQUEST = 1,
	CT_DCCP_RESPOND = 2,
	CT_DCCP_PARTOPEN = 3,
	CT_DCCP_OPEN = 4,
	CT_DCCP_CLOSEREQ = 5,
	CT_DCCP_CLOSING = 6,
	CT_DCCP_TIMEWAIT = 7,
	CT_DCCP_IGNORE = 8,
	CT_DCCP_INVALID = 9,
	__CT_DCCP_MAX = 10,
};

enum cti_port_type {
	CTI_PORT_TYPE_NONE = 0,
	CTI_PORT_TYPE_RS232 = 1,
	CTI_PORT_TYPE_RS422_485 = 2,
	CTI_PORT_TYPE_RS232_422_485_HW = 3,
	CTI_PORT_TYPE_RS232_422_485_SW = 4,
	CTI_PORT_TYPE_RS232_422_485_4B = 5,
	CTI_PORT_TYPE_RS232_422_485_2B = 6,
	CTI_PORT_TYPE_MAX = 7,
};

enum ctx_state {
	CT_STATE_DISABLED = -1,
	CT_STATE_KERNEL = 0,
	CT_STATE_IDLE = 1,
	CT_STATE_USER = 2,
	CT_STATE_GUEST = 3,
	CT_STATE_MAX = 4,
};

enum cwb_mode_input {
	INPUT_MODE_LM_OUT = 0,
	INPUT_MODE_DSPP_OUT = 1,
	INPUT_MODE_MAX = 2,
};

enum cyapa_pm_stage {
	CYAPA_PM_DEACTIVE = 0,
	CYAPA_PM_ACTIVE = 1,
	CYAPA_PM_SUSPEND = 2,
	CYAPA_PM_RESUME = 3,
	CYAPA_PM_RUNTIME_SUSPEND = 4,
	CYAPA_PM_RUNTIME_RESUME = 5,
};

enum cyapa_state {
	CYAPA_STATE_NO_DEVICE = 0,
	CYAPA_STATE_BL_BUSY = 1,
	CYAPA_STATE_BL_IDLE = 2,
	CYAPA_STATE_BL_ACTIVE = 3,
	CYAPA_STATE_OP = 4,
	CYAPA_STATE_GEN5_BL = 5,
	CYAPA_STATE_GEN5_APP = 6,
	CYAPA_STATE_GEN6_BL = 7,
	CYAPA_STATE_GEN6_APP = 8,
};

enum d_real_type {
	D_REAL_DATA = 0,
	D_REAL_METADATA = 1,
};

enum d_walk_ret {
	D_WALK_CONTINUE = 0,
	D_WALK_QUIT = 1,
	D_WALK_NORETRY = 2,
	D_WALK_SKIP = 3,
};

enum da9052_chip_id {
	DA9052 = 0,
	DA9053_AA = 1,
	DA9053_BA = 2,
	DA9053_BB = 3,
	DA9053_BC = 4,
};

enum da9063_irqs {
	DA9063_IRQ_ONKEY = 0,
	DA9063_IRQ_ALARM = 1,
	DA9063_IRQ_TICK = 2,
	DA9063_IRQ_ADC_RDY = 3,
	DA9063_IRQ_SEQ_RDY = 4,
	DA9063_IRQ_WAKE = 5,
	DA9063_IRQ_TEMP = 6,
	DA9063_IRQ_COMP_1V2 = 7,
	DA9063_IRQ_LDO_LIM = 8,
	DA9063_IRQ_REG_UVOV = 9,
	DA9063_IRQ_DVC_RDY = 10,
	DA9063_IRQ_VDD_MON = 11,
	DA9063_IRQ_WARN = 12,
	DA9063_IRQ_GPI0 = 13,
	DA9063_IRQ_GPI1 = 14,
	DA9063_IRQ_GPI2 = 15,
	DA9063_IRQ_GPI3 = 16,
	DA9063_IRQ_GPI4 = 17,
	DA9063_IRQ_GPI5 = 18,
	DA9063_IRQ_GPI6 = 19,
	DA9063_IRQ_GPI7 = 20,
	DA9063_IRQ_GPI8 = 21,
	DA9063_IRQ_GPI9 = 22,
	DA9063_IRQ_GPI10 = 23,
	DA9063_IRQ_GPI11 = 24,
	DA9063_IRQ_GPI12 = 25,
	DA9063_IRQ_GPI13 = 26,
	DA9063_IRQ_GPI14 = 27,
	DA9063_IRQ_GPI15 = 28,
};

enum da9063_page_sel_buf_fmt {
	DA9063_PAGE_SEL_BUF_PAGE_REG = 0,
	DA9063_PAGE_SEL_BUF_PAGE_VAL = 1,
	DA9063_PAGE_SEL_BUF_SIZE = 2,
};

enum da9063_paged_read_msgs {
	DA9063_PAGED_READ_MSG_PAGE_SEL = 0,
	DA9063_PAGED_READ_MSG_REG_SEL = 1,
	DA9063_PAGED_READ_MSG_DATA = 2,
	DA9063_PAGED_READ_MSG_CNT = 3,
};

enum da9063_type {
	PMIC_TYPE_DA9063 = 0,
	PMIC_TYPE_DA9063L = 1,
};

enum da9063_variant_codes {
	PMIC_DA9063_AD = 3,
	PMIC_DA9063_BB = 5,
	PMIC_DA9063_CA = 6,
	PMIC_DA9063_DA = 7,
	PMIC_DA9063_EA = 8,
};

enum data_content4 {
	NFS4_CONTENT_DATA = 0,
	NFS4_CONTENT_HOLE = 1,
};

enum dbgfs_get_mode {
	DBGFS_GET_ALREADY = 0,
	DBGFS_GET_REGULAR = 1,
	DBGFS_GET_SHORT = 2,
};

enum dcb_general_attr_values {
	DCB_ATTR_VALUE_UNDEFINED = 255,
};

enum dcbevent_notif_type {
	DCB_APP_EVENT = 1,
};

enum dcbnl_app_attrs {
	DCB_APP_ATTR_UNDEFINED = 0,
	DCB_APP_ATTR_IDTYPE = 1,
	DCB_APP_ATTR_ID = 2,
	DCB_APP_ATTR_PRIORITY = 3,
	__DCB_APP_ATTR_ENUM_MAX = 4,
	DCB_APP_ATTR_MAX = 3,
};

enum dcbnl_attrs {
	DCB_ATTR_UNDEFINED = 0,
	DCB_ATTR_IFNAME = 1,
	DCB_ATTR_STATE = 2,
	DCB_ATTR_PFC_STATE = 3,
	DCB_ATTR_PFC_CFG = 4,
	DCB_ATTR_NUM_TC = 5,
	DCB_ATTR_PG_CFG = 6,
	DCB_ATTR_SET_ALL = 7,
	DCB_ATTR_PERM_HWADDR = 8,
	DCB_ATTR_CAP = 9,
	DCB_ATTR_NUMTCS = 10,
	DCB_ATTR_BCN = 11,
	DCB_ATTR_APP = 12,
	DCB_ATTR_IEEE = 13,
	DCB_ATTR_DCBX = 14,
	DCB_ATTR_FEATCFG = 15,
	DCB_ATTR_CEE = 16,
	__DCB_ATTR_ENUM_MAX = 17,
	DCB_ATTR_MAX = 16,
};

enum dcbnl_bcn_attrs {
	DCB_BCN_ATTR_UNDEFINED = 0,
	DCB_BCN_ATTR_RP_0 = 1,
	DCB_BCN_ATTR_RP_1 = 2,
	DCB_BCN_ATTR_RP_2 = 3,
	DCB_BCN_ATTR_RP_3 = 4,
	DCB_BCN_ATTR_RP_4 = 5,
	DCB_BCN_ATTR_RP_5 = 6,
	DCB_BCN_ATTR_RP_6 = 7,
	DCB_BCN_ATTR_RP_7 = 8,
	DCB_BCN_ATTR_RP_ALL = 9,
	DCB_BCN_ATTR_BCNA_0 = 10,
	DCB_BCN_ATTR_BCNA_1 = 11,
	DCB_BCN_ATTR_ALPHA = 12,
	DCB_BCN_ATTR_BETA = 13,
	DCB_BCN_ATTR_GD = 14,
	DCB_BCN_ATTR_GI = 15,
	DCB_BCN_ATTR_TMAX = 16,
	DCB_BCN_ATTR_TD = 17,
	DCB_BCN_ATTR_RMIN = 18,
	DCB_BCN_ATTR_W = 19,
	DCB_BCN_ATTR_RD = 20,
	DCB_BCN_ATTR_RU = 21,
	DCB_BCN_ATTR_WRTT = 22,
	DCB_BCN_ATTR_RI = 23,
	DCB_BCN_ATTR_C = 24,
	DCB_BCN_ATTR_ALL = 25,
	__DCB_BCN_ATTR_ENUM_MAX = 26,
	DCB_BCN_ATTR_MAX = 25,
};

enum dcbnl_cap_attrs {
	DCB_CAP_ATTR_UNDEFINED = 0,
	DCB_CAP_ATTR_ALL = 1,
	DCB_CAP_ATTR_PG = 2,
	DCB_CAP_ATTR_PFC = 3,
	DCB_CAP_ATTR_UP2TC = 4,
	DCB_CAP_ATTR_PG_TCS = 5,
	DCB_CAP_ATTR_PFC_TCS = 6,
	DCB_CAP_ATTR_GSP = 7,
	DCB_CAP_ATTR_BCN = 8,
	DCB_CAP_ATTR_DCBX = 9,
	__DCB_CAP_ATTR_ENUM_MAX = 10,
	DCB_CAP_ATTR_MAX = 9,
};

enum dcbnl_commands {
	DCB_CMD_UNDEFINED = 0,
	DCB_CMD_GSTATE = 1,
	DCB_CMD_SSTATE = 2,
	DCB_CMD_PGTX_GCFG = 3,
	DCB_CMD_PGTX_SCFG = 4,
	DCB_CMD_PGRX_GCFG = 5,
	DCB_CMD_PGRX_SCFG = 6,
	DCB_CMD_PFC_GCFG = 7,
	DCB_CMD_PFC_SCFG = 8,
	DCB_CMD_SET_ALL = 9,
	DCB_CMD_GPERM_HWADDR = 10,
	DCB_CMD_GCAP = 11,
	DCB_CMD_GNUMTCS = 12,
	DCB_CMD_SNUMTCS = 13,
	DCB_CMD_PFC_GSTATE = 14,
	DCB_CMD_PFC_SSTATE = 15,
	DCB_CMD_BCN_GCFG = 16,
	DCB_CMD_BCN_SCFG = 17,
	DCB_CMD_GAPP = 18,
	DCB_CMD_SAPP = 19,
	DCB_CMD_IEEE_SET = 20,
	DCB_CMD_IEEE_GET = 21,
	DCB_CMD_GDCBX = 22,
	DCB_CMD_SDCBX = 23,
	DCB_CMD_GFEATCFG = 24,
	DCB_CMD_SFEATCFG = 25,
	DCB_CMD_CEE_GET = 26,
	DCB_CMD_IEEE_DEL = 27,
	__DCB_CMD_ENUM_MAX = 28,
	DCB_CMD_MAX = 27,
};

enum dcbnl_featcfg_attrs {
	DCB_FEATCFG_ATTR_UNDEFINED = 0,
	DCB_FEATCFG_ATTR_ALL = 1,
	DCB_FEATCFG_ATTR_PG = 2,
	DCB_FEATCFG_ATTR_PFC = 3,
	DCB_FEATCFG_ATTR_APP = 4,
	__DCB_FEATCFG_ATTR_ENUM_MAX = 5,
	DCB_FEATCFG_ATTR_MAX = 4,
};

enum dcbnl_numtcs_attrs {
	DCB_NUMTCS_ATTR_UNDEFINED = 0,
	DCB_NUMTCS_ATTR_ALL = 1,
	DCB_NUMTCS_ATTR_PG = 2,
	DCB_NUMTCS_ATTR_PFC = 3,
	__DCB_NUMTCS_ATTR_ENUM_MAX = 4,
	DCB_NUMTCS_ATTR_MAX = 3,
};

enum dcbnl_pfc_up_attrs {
	DCB_PFC_UP_ATTR_UNDEFINED = 0,
	DCB_PFC_UP_ATTR_0 = 1,
	DCB_PFC_UP_ATTR_1 = 2,
	DCB_PFC_UP_ATTR_2 = 3,
	DCB_PFC_UP_ATTR_3 = 4,
	DCB_PFC_UP_ATTR_4 = 5,
	DCB_PFC_UP_ATTR_5 = 6,
	DCB_PFC_UP_ATTR_6 = 7,
	DCB_PFC_UP_ATTR_7 = 8,
	DCB_PFC_UP_ATTR_ALL = 9,
	__DCB_PFC_UP_ATTR_ENUM_MAX = 10,
	DCB_PFC_UP_ATTR_MAX = 9,
};

enum dcbnl_pg_attrs {
	DCB_PG_ATTR_UNDEFINED = 0,
	DCB_PG_ATTR_TC_0 = 1,
	DCB_PG_ATTR_TC_1 = 2,
	DCB_PG_ATTR_TC_2 = 3,
	DCB_PG_ATTR_TC_3 = 4,
	DCB_PG_ATTR_TC_4 = 5,
	DCB_PG_ATTR_TC_5 = 6,
	DCB_PG_ATTR_TC_6 = 7,
	DCB_PG_ATTR_TC_7 = 8,
	DCB_PG_ATTR_TC_MAX = 9,
	DCB_PG_ATTR_TC_ALL = 10,
	DCB_PG_ATTR_BW_ID_0 = 11,
	DCB_PG_ATTR_BW_ID_1 = 12,
	DCB_PG_ATTR_BW_ID_2 = 13,
	DCB_PG_ATTR_BW_ID_3 = 14,
	DCB_PG_ATTR_BW_ID_4 = 15,
	DCB_PG_ATTR_BW_ID_5 = 16,
	DCB_PG_ATTR_BW_ID_6 = 17,
	DCB_PG_ATTR_BW_ID_7 = 18,
	DCB_PG_ATTR_BW_ID_MAX = 19,
	DCB_PG_ATTR_BW_ID_ALL = 20,
	__DCB_PG_ATTR_ENUM_MAX = 21,
	DCB_PG_ATTR_MAX = 20,
};

enum dcbnl_tc_attrs {
	DCB_TC_ATTR_PARAM_UNDEFINED = 0,
	DCB_TC_ATTR_PARAM_PGID = 1,
	DCB_TC_ATTR_PARAM_UP_MAPPING = 2,
	DCB_TC_ATTR_PARAM_STRICT_PRIO = 3,
	DCB_TC_ATTR_PARAM_BW_PCT = 4,
	DCB_TC_ATTR_PARAM_ALL = 5,
	__DCB_TC_ATTR_PARAM_ENUM_MAX = 6,
	DCB_TC_ATTR_PARAM_MAX = 5,
};

enum dd_data_dir {
	DD_READ = 0,
	DD_WRITE = 1,
};

enum dd_prio {
	DD_RT_PRIO = 0,
	DD_BE_PRIO = 1,
	DD_IDLE_PRIO = 2,
	DD_PRIO_MAX = 2,
};

enum debug_counters {
	SENT_OK = 0,
	SENT_FAIL = 1,
	SENT_FAIL_POLLING_UNSUPPORTED = 2,
	SENT_FAIL_CHANNEL_NOT_FOUND = 3,
	RESPONSE_OK = 4,
	NOTIFICATION_OK = 5,
	DELAYED_RESPONSE_OK = 6,
	XFERS_RESPONSE_TIMEOUT = 7,
	XFERS_RESPONSE_POLLED_TIMEOUT = 8,
	RESPONSE_POLLED_OK = 9,
	ERR_MSG_UNEXPECTED = 10,
	ERR_MSG_INVALID = 11,
	ERR_MSG_NOMEM = 12,
	ERR_PROTOCOL = 13,
	SCMI_DEBUG_COUNTERS_LAST = 14,
};

enum decode_reg_type {
	REG_TYPE_NONE = 0,
	REG_TYPE_ANY = 1,
	REG_TYPE_SAMEAS16 = 2,
	REG_TYPE_SP = 3,
	REG_TYPE_PC = 4,
	REG_TYPE_NOSP = 5,
	REG_TYPE_NOSPPC = 6,
	REG_TYPE_NOPC = 7,
	REG_TYPE_NOPCWB = 8,
	REG_TYPE_NOPCX = 9,
	REG_TYPE_NOSPPCX = 10,
	REG_TYPE_0 = 0,
};

enum decode_type {
	DECODE_TYPE_END = 0,
	DECODE_TYPE_TABLE = 1,
	DECODE_TYPE_CUSTOM = 2,
	DECODE_TYPE_SIMULATE = 3,
	DECODE_TYPE_EMULATE = 4,
	DECODE_TYPE_OR = 5,
	DECODE_TYPE_REJECT = 6,
	NUM_DECODE_TYPES = 7,
};

enum dentry_d_lock_class {
	DENTRY_D_LOCK_NORMAL = 0,
	DENTRY_D_LOCK_NESTED = 1,
};

enum dentry_flags {
	DCACHE_OP_HASH = 1,
	DCACHE_OP_COMPARE = 2,
	DCACHE_OP_REVALIDATE = 4,
	DCACHE_OP_DELETE = 8,
	DCACHE_OP_PRUNE = 16,
	DCACHE_DISCONNECTED = 32,
	DCACHE_REFERENCED = 64,
	DCACHE_DONTCACHE = 128,
	DCACHE_CANT_MOUNT = 256,
	DCACHE_GENOCIDE = 512,
	DCACHE_SHRINK_LIST = 1024,
	DCACHE_OP_WEAK_REVALIDATE = 2048,
	DCACHE_NFSFS_RENAMED = 4096,
	DCACHE_FSNOTIFY_PARENT_WATCHED = 8192,
	DCACHE_DENTRY_KILLED = 16384,
	DCACHE_MOUNTED = 32768,
	DCACHE_NEED_AUTOMOUNT = 65536,
	DCACHE_MANAGE_TRANSIT = 131072,
	DCACHE_LRU_LIST = 262144,
	DCACHE_ENTRY_TYPE = 3670016,
	DCACHE_MISS_TYPE = 0,
	DCACHE_WHITEOUT_TYPE = 524288,
	DCACHE_DIRECTORY_TYPE = 1048576,
	DCACHE_AUTODIR_TYPE = 1572864,
	DCACHE_REGULAR_TYPE = 2097152,
	DCACHE_SPECIAL_TYPE = 2621440,
	DCACHE_SYMLINK_TYPE = 3145728,
	DCACHE_NOKEY_NAME = 4194304,
	DCACHE_OP_REAL = 8388608,
	DCACHE_PAR_LOOKUP = 16777216,
	DCACHE_DENTRY_CURSOR = 33554432,
	DCACHE_NORCU = 67108864,
};

enum desc_state {
	desc_miss = -1,
	desc_reserved = 0,
	desc_committed = 1,
	desc_finalized = 2,
	desc_reusable = 3,
};

enum desc_status {
	FREE = 0,
	PREP = 1,
	BUSY = 2,
	PAUSED = 3,
	DONE___2 = 4,
};

enum dev_dma_attr {
	DEV_DMA_NOT_SUPPORTED = 0,
	DEV_DMA_NON_COHERENT = 1,
	DEV_DMA_COHERENT = 2,
};

enum dev_pm_opp_event {
	OPP_EVENT_ADD = 0,
	OPP_EVENT_REMOVE = 1,
	OPP_EVENT_ENABLE = 2,
	OPP_EVENT_DISABLE = 3,
	OPP_EVENT_ADJUST_VOLTAGE = 4,
};

enum dev_pm_qos_req_type {
	DEV_PM_QOS_RESUME_LATENCY = 1,
	DEV_PM_QOS_LATENCY_TOLERANCE = 2,
	DEV_PM_QOS_MIN_FREQUENCY = 3,
	DEV_PM_QOS_MAX_FREQUENCY = 4,
	DEV_PM_QOS_FLAGS = 5,
};

enum dev_prop_type {
	DEV_PROP_U8 = 0,
	DEV_PROP_U16 = 1,
	DEV_PROP_U32 = 2,
	DEV_PROP_U64 = 3,
	DEV_PROP_STRING = 4,
	DEV_PROP_REF = 5,
};

enum dev_type {
	DEV_UNKNOWN = 0,
	DEV_X1 = 1,
	DEV_X2 = 2,
	DEV_X4 = 3,
	DEV_X8 = 4,
	DEV_X16 = 5,
	DEV_X32 = 6,
	DEV_X64 = 7,
};

enum devcg_behavior {
	DEVCG_DEFAULT_NONE = 0,
	DEVCG_DEFAULT_ALLOW = 1,
	DEVCG_DEFAULT_DENY = 2,
};

enum devfreq_parent_dev_type {
	DEVFREQ_PARENT_DEV = 0,
	CPUFREQ_PARENT_DEV = 1,
};

enum devfreq_timer {
	DEVFREQ_TIMER_DEFERRABLE = 0,
	DEVFREQ_TIMER_DELAYED = 1,
	DEVFREQ_TIMER_NUM = 2,
};

enum device_id {
	MAX8973 = 0,
	MAX77621 = 1,
};

enum device_link_state {
	DL_STATE_NONE = -1,
	DL_STATE_DORMANT = 0,
	DL_STATE_AVAILABLE = 1,
	DL_STATE_CONSUMER_PROBE = 2,
	DL_STATE_ACTIVE = 3,
	DL_STATE_SUPPLIER_UNBIND = 4,
};

enum device_physical_location_horizontal_position {
	DEVICE_HORI_POS_LEFT = 0,
	DEVICE_HORI_POS_CENTER = 1,
	DEVICE_HORI_POS_RIGHT = 2,
};

enum device_physical_location_panel {
	DEVICE_PANEL_TOP = 0,
	DEVICE_PANEL_BOTTOM = 1,
	DEVICE_PANEL_LEFT = 2,
	DEVICE_PANEL_RIGHT = 3,
	DEVICE_PANEL_FRONT = 4,
	DEVICE_PANEL_BACK = 5,
	DEVICE_PANEL_UNKNOWN = 6,
};

enum device_physical_location_vertical_position {
	DEVICE_VERT_POS_UPPER = 0,
	DEVICE_VERT_POS_CENTER = 1,
	DEVICE_VERT_POS_LOWER = 2,
};

enum device_removable {
	DEVICE_REMOVABLE_NOT_SUPPORTED = 0,
	DEVICE_REMOVABLE_UNKNOWN = 1,
	DEVICE_FIXED = 2,
	DEVICE_REMOVABLE = 3,
};

enum devkmsg_log_bits {
	__DEVKMSG_LOG_BIT_ON = 0,
	__DEVKMSG_LOG_BIT_OFF = 1,
	__DEVKMSG_LOG_BIT_LOCK = 2,
};

enum devkmsg_log_masks {
	DEVKMSG_LOG_MASK_ON = 1,
	DEVKMSG_LOG_MASK_OFF = 2,
	DEVKMSG_LOG_MASK_LOCK = 4,
};

enum devlink_attr {
	DEVLINK_ATTR_UNSPEC = 0,
	DEVLINK_ATTR_BUS_NAME = 1,
	DEVLINK_ATTR_DEV_NAME = 2,
	DEVLINK_ATTR_PORT_INDEX = 3,
	DEVLINK_ATTR_PORT_TYPE = 4,
	DEVLINK_ATTR_PORT_DESIRED_TYPE = 5,
	DEVLINK_ATTR_PORT_NETDEV_IFINDEX = 6,
	DEVLINK_ATTR_PORT_NETDEV_NAME = 7,
	DEVLINK_ATTR_PORT_IBDEV_NAME = 8,
	DEVLINK_ATTR_PORT_SPLIT_COUNT = 9,
	DEVLINK_ATTR_PORT_SPLIT_GROUP = 10,
	DEVLINK_ATTR_SB_INDEX = 11,
	DEVLINK_ATTR_SB_SIZE = 12,
	DEVLINK_ATTR_SB_INGRESS_POOL_COUNT = 13,
	DEVLINK_ATTR_SB_EGRESS_POOL_COUNT = 14,
	DEVLINK_ATTR_SB_INGRESS_TC_COUNT = 15,
	DEVLINK_ATTR_SB_EGRESS_TC_COUNT = 16,
	DEVLINK_ATTR_SB_POOL_INDEX = 17,
	DEVLINK_ATTR_SB_POOL_TYPE = 18,
	DEVLINK_ATTR_SB_POOL_SIZE = 19,
	DEVLINK_ATTR_SB_POOL_THRESHOLD_TYPE = 20,
	DEVLINK_ATTR_SB_THRESHOLD = 21,
	DEVLINK_ATTR_SB_TC_INDEX = 22,
	DEVLINK_ATTR_SB_OCC_CUR = 23,
	DEVLINK_ATTR_SB_OCC_MAX = 24,
	DEVLINK_ATTR_ESWITCH_MODE = 25,
	DEVLINK_ATTR_ESWITCH_INLINE_MODE = 26,
	DEVLINK_ATTR_DPIPE_TABLES = 27,
	DEVLINK_ATTR_DPIPE_TABLE = 28,
	DEVLINK_ATTR_DPIPE_TABLE_NAME = 29,
	DEVLINK_ATTR_DPIPE_TABLE_SIZE = 30,
	DEVLINK_ATTR_DPIPE_TABLE_MATCHES = 31,
	DEVLINK_ATTR_DPIPE_TABLE_ACTIONS = 32,
	DEVLINK_ATTR_DPIPE_TABLE_COUNTERS_ENABLED = 33,
	DEVLINK_ATTR_DPIPE_ENTRIES = 34,
	DEVLINK_ATTR_DPIPE_ENTRY = 35,
	DEVLINK_ATTR_DPIPE_ENTRY_INDEX = 36,
	DEVLINK_ATTR_DPIPE_ENTRY_MATCH_VALUES = 37,
	DEVLINK_ATTR_DPIPE_ENTRY_ACTION_VALUES = 38,
	DEVLINK_ATTR_DPIPE_ENTRY_COUNTER = 39,
	DEVLINK_ATTR_DPIPE_MATCH = 40,
	DEVLINK_ATTR_DPIPE_MATCH_VALUE = 41,
	DEVLINK_ATTR_DPIPE_MATCH_TYPE = 42,
	DEVLINK_ATTR_DPIPE_ACTION = 43,
	DEVLINK_ATTR_DPIPE_ACTION_VALUE = 44,
	DEVLINK_ATTR_DPIPE_ACTION_TYPE = 45,
	DEVLINK_ATTR_DPIPE_VALUE = 46,
	DEVLINK_ATTR_DPIPE_VALUE_MASK = 47,
	DEVLINK_ATTR_DPIPE_VALUE_MAPPING = 48,
	DEVLINK_ATTR_DPIPE_HEADERS = 49,
	DEVLINK_ATTR_DPIPE_HEADER = 50,
	DEVLINK_ATTR_DPIPE_HEADER_NAME = 51,
	DEVLINK_ATTR_DPIPE_HEADER_ID = 52,
	DEVLINK_ATTR_DPIPE_HEADER_FIELDS = 53,
	DEVLINK_ATTR_DPIPE_HEADER_GLOBAL = 54,
	DEVLINK_ATTR_DPIPE_HEADER_INDEX = 55,
	DEVLINK_ATTR_DPIPE_FIELD = 56,
	DEVLINK_ATTR_DPIPE_FIELD_NAME = 57,
	DEVLINK_ATTR_DPIPE_FIELD_ID = 58,
	DEVLINK_ATTR_DPIPE_FIELD_BITWIDTH = 59,
	DEVLINK_ATTR_DPIPE_FIELD_MAPPING_TYPE = 60,
	DEVLINK_ATTR_PAD = 61,
	DEVLINK_ATTR_ESWITCH_ENCAP_MODE = 62,
	DEVLINK_ATTR_RESOURCE_LIST = 63,
	DEVLINK_ATTR_RESOURCE = 64,
	DEVLINK_ATTR_RESOURCE_NAME = 65,
	DEVLINK_ATTR_RESOURCE_ID = 66,
	DEVLINK_ATTR_RESOURCE_SIZE = 67,
	DEVLINK_ATTR_RESOURCE_SIZE_NEW = 68,
	DEVLINK_ATTR_RESOURCE_SIZE_VALID = 69,
	DEVLINK_ATTR_RESOURCE_SIZE_MIN = 70,
	DEVLINK_ATTR_RESOURCE_SIZE_MAX = 71,
	DEVLINK_ATTR_RESOURCE_SIZE_GRAN = 72,
	DEVLINK_ATTR_RESOURCE_UNIT = 73,
	DEVLINK_ATTR_RESOURCE_OCC = 74,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_ID = 75,
	DEVLINK_ATTR_DPIPE_TABLE_RESOURCE_UNITS = 76,
	DEVLINK_ATTR_PORT_FLAVOUR = 77,
	DEVLINK_ATTR_PORT_NUMBER = 78,
	DEVLINK_ATTR_PORT_SPLIT_SUBPORT_NUMBER = 79,
	DEVLINK_ATTR_PARAM = 80,
	DEVLINK_ATTR_PARAM_NAME = 81,
	DEVLINK_ATTR_PARAM_GENERIC = 82,
	DEVLINK_ATTR_PARAM_TYPE = 83,
	DEVLINK_ATTR_PARAM_VALUES_LIST = 84,
	DEVLINK_ATTR_PARAM_VALUE = 85,
	DEVLINK_ATTR_PARAM_VALUE_DATA = 86,
	DEVLINK_ATTR_PARAM_VALUE_CMODE = 87,
	DEVLINK_ATTR_REGION_NAME = 88,
	DEVLINK_ATTR_REGION_SIZE = 89,
	DEVLINK_ATTR_REGION_SNAPSHOTS = 90,
	DEVLINK_ATTR_REGION_SNAPSHOT = 91,
	DEVLINK_ATTR_REGION_SNAPSHOT_ID = 92,
	DEVLINK_ATTR_REGION_CHUNKS = 93,
	DEVLINK_ATTR_REGION_CHUNK = 94,
	DEVLINK_ATTR_REGION_CHUNK_DATA = 95,
	DEVLINK_ATTR_REGION_CHUNK_ADDR = 96,
	DEVLINK_ATTR_REGION_CHUNK_LEN = 97,
	DEVLINK_ATTR_INFO_DRIVER_NAME = 98,
	DEVLINK_ATTR_INFO_SERIAL_NUMBER = 99,
	DEVLINK_ATTR_INFO_VERSION_FIXED = 100,
	DEVLINK_ATTR_INFO_VERSION_RUNNING = 101,
	DEVLINK_ATTR_INFO_VERSION_STORED = 102,
	DEVLINK_ATTR_INFO_VERSION_NAME = 103,
	DEVLINK_ATTR_INFO_VERSION_VALUE = 104,
	DEVLINK_ATTR_SB_POOL_CELL_SIZE = 105,
	DEVLINK_ATTR_FMSG = 106,
	DEVLINK_ATTR_FMSG_OBJ_NEST_START = 107,
	DEVLINK_ATTR_FMSG_PAIR_NEST_START = 108,
	DEVLINK_ATTR_FMSG_ARR_NEST_START = 109,
	DEVLINK_ATTR_FMSG_NEST_END = 110,
	DEVLINK_ATTR_FMSG_OBJ_NAME = 111,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_TYPE = 112,
	DEVLINK_ATTR_FMSG_OBJ_VALUE_DATA = 113,
	DEVLINK_ATTR_HEALTH_REPORTER = 114,
	DEVLINK_ATTR_HEALTH_REPORTER_NAME = 115,
	DEVLINK_ATTR_HEALTH_REPORTER_STATE = 116,
	DEVLINK_ATTR_HEALTH_REPORTER_ERR_COUNT = 117,
	DEVLINK_ATTR_HEALTH_REPORTER_RECOVER_COUNT = 118,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS = 119,
	DEVLINK_ATTR_HEALTH_REPORTER_GRACEFUL_PERIOD = 120,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_RECOVER = 121,
	DEVLINK_ATTR_FLASH_UPDATE_FILE_NAME = 122,
	DEVLINK_ATTR_FLASH_UPDATE_COMPONENT = 123,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_MSG = 124,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_DONE = 125,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TOTAL = 126,
	DEVLINK_ATTR_PORT_PCI_PF_NUMBER = 127,
	DEVLINK_ATTR_PORT_PCI_VF_NUMBER = 128,
	DEVLINK_ATTR_STATS = 129,
	DEVLINK_ATTR_TRAP_NAME = 130,
	DEVLINK_ATTR_TRAP_ACTION = 131,
	DEVLINK_ATTR_TRAP_TYPE = 132,
	DEVLINK_ATTR_TRAP_GENERIC = 133,
	DEVLINK_ATTR_TRAP_METADATA = 134,
	DEVLINK_ATTR_TRAP_GROUP_NAME = 135,
	DEVLINK_ATTR_RELOAD_FAILED = 136,
	DEVLINK_ATTR_HEALTH_REPORTER_DUMP_TS_NS = 137,
	DEVLINK_ATTR_NETNS_FD = 138,
	DEVLINK_ATTR_NETNS_PID = 139,
	DEVLINK_ATTR_NETNS_ID = 140,
	DEVLINK_ATTR_HEALTH_REPORTER_AUTO_DUMP = 141,
	DEVLINK_ATTR_TRAP_POLICER_ID = 142,
	DEVLINK_ATTR_TRAP_POLICER_RATE = 143,
	DEVLINK_ATTR_TRAP_POLICER_BURST = 144,
	DEVLINK_ATTR_PORT_FUNCTION = 145,
	DEVLINK_ATTR_INFO_BOARD_SERIAL_NUMBER = 146,
	DEVLINK_ATTR_PORT_LANES = 147,
	DEVLINK_ATTR_PORT_SPLITTABLE = 148,
	DEVLINK_ATTR_PORT_EXTERNAL = 149,
	DEVLINK_ATTR_PORT_CONTROLLER_NUMBER = 150,
	DEVLINK_ATTR_FLASH_UPDATE_STATUS_TIMEOUT = 151,
	DEVLINK_ATTR_FLASH_UPDATE_OVERWRITE_MASK = 152,
	DEVLINK_ATTR_RELOAD_ACTION = 153,
	DEVLINK_ATTR_RELOAD_ACTIONS_PERFORMED = 154,
	DEVLINK_ATTR_RELOAD_LIMITS = 155,
	DEVLINK_ATTR_DEV_STATS = 156,
	DEVLINK_ATTR_RELOAD_STATS = 157,
	DEVLINK_ATTR_RELOAD_STATS_ENTRY = 158,
	DEVLINK_ATTR_RELOAD_STATS_LIMIT = 159,
	DEVLINK_ATTR_RELOAD_STATS_VALUE = 160,
	DEVLINK_ATTR_REMOTE_RELOAD_STATS = 161,
	DEVLINK_ATTR_RELOAD_ACTION_INFO = 162,
	DEVLINK_ATTR_RELOAD_ACTION_STATS = 163,
	DEVLINK_ATTR_PORT_PCI_SF_NUMBER = 164,
	DEVLINK_ATTR_RATE_TYPE = 165,
	DEVLINK_ATTR_RATE_TX_SHARE = 166,
	DEVLINK_ATTR_RATE_TX_MAX = 167,
	DEVLINK_ATTR_RATE_NODE_NAME = 168,
	DEVLINK_ATTR_RATE_PARENT_NODE_NAME = 169,
	DEVLINK_ATTR_REGION_MAX_SNAPSHOTS = 170,
	DEVLINK_ATTR_LINECARD_INDEX = 171,
	DEVLINK_ATTR_LINECARD_STATE = 172,
	DEVLINK_ATTR_LINECARD_TYPE = 173,
	DEVLINK_ATTR_LINECARD_SUPPORTED_TYPES = 174,
	DEVLINK_ATTR_NESTED_DEVLINK = 175,
	DEVLINK_ATTR_SELFTESTS = 176,
	DEVLINK_ATTR_RATE_TX_PRIORITY = 177,
	DEVLINK_ATTR_RATE_TX_WEIGHT = 178,
	DEVLINK_ATTR_REGION_DIRECT = 179,
	__DEVLINK_ATTR_MAX = 180,
	DEVLINK_ATTR_MAX = 179,
};

enum devlink_attr_selftest_id {
	DEVLINK_ATTR_SELFTEST_ID_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_ID_FLASH = 1,
	__DEVLINK_ATTR_SELFTEST_ID_MAX = 2,
	DEVLINK_ATTR_SELFTEST_ID_MAX = 1,
};

enum devlink_attr_selftest_result {
	DEVLINK_ATTR_SELFTEST_RESULT_UNSPEC = 0,
	DEVLINK_ATTR_SELFTEST_RESULT = 1,
	DEVLINK_ATTR_SELFTEST_RESULT_ID = 2,
	DEVLINK_ATTR_SELFTEST_RESULT_STATUS = 3,
	__DEVLINK_ATTR_SELFTEST_RESULT_MAX = 4,
	DEVLINK_ATTR_SELFTEST_RESULT_MAX = 3,
};

enum devlink_command {
	DEVLINK_CMD_UNSPEC = 0,
	DEVLINK_CMD_GET = 1,
	DEVLINK_CMD_SET = 2,
	DEVLINK_CMD_NEW = 3,
	DEVLINK_CMD_DEL = 4,
	DEVLINK_CMD_PORT_GET = 5,
	DEVLINK_CMD_PORT_SET = 6,
	DEVLINK_CMD_PORT_NEW = 7,
	DEVLINK_CMD_PORT_DEL = 8,
	DEVLINK_CMD_PORT_SPLIT = 9,
	DEVLINK_CMD_PORT_UNSPLIT = 10,
	DEVLINK_CMD_SB_GET = 11,
	DEVLINK_CMD_SB_SET = 12,
	DEVLINK_CMD_SB_NEW = 13,
	DEVLINK_CMD_SB_DEL = 14,
	DEVLINK_CMD_SB_POOL_GET = 15,
	DEVLINK_CMD_SB_POOL_SET = 16,
	DEVLINK_CMD_SB_POOL_NEW = 17,
	DEVLINK_CMD_SB_POOL_DEL = 18,
	DEVLINK_CMD_SB_PORT_POOL_GET = 19,
	DEVLINK_CMD_SB_PORT_POOL_SET = 20,
	DEVLINK_CMD_SB_PORT_POOL_NEW = 21,
	DEVLINK_CMD_SB_PORT_POOL_DEL = 22,
	DEVLINK_CMD_SB_TC_POOL_BIND_GET = 23,
	DEVLINK_CMD_SB_TC_POOL_BIND_SET = 24,
	DEVLINK_CMD_SB_TC_POOL_BIND_NEW = 25,
	DEVLINK_CMD_SB_TC_POOL_BIND_DEL = 26,
	DEVLINK_CMD_SB_OCC_SNAPSHOT = 27,
	DEVLINK_CMD_SB_OCC_MAX_CLEAR = 28,
	DEVLINK_CMD_ESWITCH_GET = 29,
	DEVLINK_CMD_ESWITCH_SET = 30,
	DEVLINK_CMD_DPIPE_TABLE_GET = 31,
	DEVLINK_CMD_DPIPE_ENTRIES_GET = 32,
	DEVLINK_CMD_DPIPE_HEADERS_GET = 33,
	DEVLINK_CMD_DPIPE_TABLE_COUNTERS_SET = 34,
	DEVLINK_CMD_RESOURCE_SET = 35,
	DEVLINK_CMD_RESOURCE_DUMP = 36,
	DEVLINK_CMD_RELOAD = 37,
	DEVLINK_CMD_PARAM_GET = 38,
	DEVLINK_CMD_PARAM_SET = 39,
	DEVLINK_CMD_PARAM_NEW = 40,
	DEVLINK_CMD_PARAM_DEL = 41,
	DEVLINK_CMD_REGION_GET = 42,
	DEVLINK_CMD_REGION_SET = 43,
	DEVLINK_CMD_REGION_NEW = 44,
	DEVLINK_CMD_REGION_DEL = 45,
	DEVLINK_CMD_REGION_READ = 46,
	DEVLINK_CMD_PORT_PARAM_GET = 47,
	DEVLINK_CMD_PORT_PARAM_SET = 48,
	DEVLINK_CMD_PORT_PARAM_NEW = 49,
	DEVLINK_CMD_PORT_PARAM_DEL = 50,
	DEVLINK_CMD_INFO_GET = 51,
	DEVLINK_CMD_HEALTH_REPORTER_GET = 52,
	DEVLINK_CMD_HEALTH_REPORTER_SET = 53,
	DEVLINK_CMD_HEALTH_REPORTER_RECOVER = 54,
	DEVLINK_CMD_HEALTH_REPORTER_DIAGNOSE = 55,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_GET = 56,
	DEVLINK_CMD_HEALTH_REPORTER_DUMP_CLEAR = 57,
	DEVLINK_CMD_FLASH_UPDATE = 58,
	DEVLINK_CMD_FLASH_UPDATE_END = 59,
	DEVLINK_CMD_FLASH_UPDATE_STATUS = 60,
	DEVLINK_CMD_TRAP_GET = 61,
	DEVLINK_CMD_TRAP_SET = 62,
	DEVLINK_CMD_TRAP_NEW = 63,
	DEVLINK_CMD_TRAP_DEL = 64,
	DEVLINK_CMD_TRAP_GROUP_GET = 65,
	DEVLINK_CMD_TRAP_GROUP_SET = 66,
	DEVLINK_CMD_TRAP_GROUP_NEW = 67,
	DEVLINK_CMD_TRAP_GROUP_DEL = 68,
	DEVLINK_CMD_TRAP_POLICER_GET = 69,
	DEVLINK_CMD_TRAP_POLICER_SET = 70,
	DEVLINK_CMD_TRAP_POLICER_NEW = 71,
	DEVLINK_CMD_TRAP_POLICER_DEL = 72,
	DEVLINK_CMD_HEALTH_REPORTER_TEST = 73,
	DEVLINK_CMD_RATE_GET = 74,
	DEVLINK_CMD_RATE_SET = 75,
	DEVLINK_CMD_RATE_NEW = 76,
	DEVLINK_CMD_RATE_DEL = 77,
	DEVLINK_CMD_LINECARD_GET = 78,
	DEVLINK_CMD_LINECARD_SET = 79,
	DEVLINK_CMD_LINECARD_NEW = 80,
	DEVLINK_CMD_LINECARD_DEL = 81,
	DEVLINK_CMD_SELFTESTS_GET = 82,
	DEVLINK_CMD_SELFTESTS_RUN = 83,
	DEVLINK_CMD_NOTIFY_FILTER_SET = 84,
	__DEVLINK_CMD_MAX = 85,
	DEVLINK_CMD_MAX = 84,
};

enum devlink_dpipe_action_type {
	DEVLINK_DPIPE_ACTION_TYPE_FIELD_MODIFY = 0,
};

enum devlink_dpipe_field_ethernet_id {
	DEVLINK_DPIPE_FIELD_ETHERNET_DST_MAC = 0,
};

enum devlink_dpipe_field_ipv4_id {
	DEVLINK_DPIPE_FIELD_IPV4_DST_IP = 0,
};

enum devlink_dpipe_field_ipv6_id {
	DEVLINK_DPIPE_FIELD_IPV6_DST_IP = 0,
};

enum devlink_dpipe_field_mapping_type {
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_NONE = 0,
	DEVLINK_DPIPE_FIELD_MAPPING_TYPE_IFINDEX = 1,
};

enum devlink_dpipe_header_id {
	DEVLINK_DPIPE_HEADER_ETHERNET = 0,
	DEVLINK_DPIPE_HEADER_IPV4 = 1,
	DEVLINK_DPIPE_HEADER_IPV6 = 2,
};

enum devlink_dpipe_match_type {
	DEVLINK_DPIPE_MATCH_TYPE_FIELD_EXACT = 0,
};

enum devlink_eswitch_encap_mode {
	DEVLINK_ESWITCH_ENCAP_MODE_NONE = 0,
	DEVLINK_ESWITCH_ENCAP_MODE_BASIC = 1,
};

enum devlink_health_reporter_state {
	DEVLINK_HEALTH_REPORTER_STATE_HEALTHY = 0,
	DEVLINK_HEALTH_REPORTER_STATE_ERROR = 1,
};

enum devlink_info_version_type {
	DEVLINK_INFO_VERSION_TYPE_NONE = 0,
	DEVLINK_INFO_VERSION_TYPE_COMPONENT = 1,
};

enum devlink_linecard_state {
	DEVLINK_LINECARD_STATE_UNSPEC = 0,
	DEVLINK_LINECARD_STATE_UNPROVISIONED = 1,
	DEVLINK_LINECARD_STATE_UNPROVISIONING = 2,
	DEVLINK_LINECARD_STATE_PROVISIONING = 3,
	DEVLINK_LINECARD_STATE_PROVISIONING_FAILED = 4,
	DEVLINK_LINECARD_STATE_PROVISIONED = 5,
	DEVLINK_LINECARD_STATE_ACTIVE = 6,
	__DEVLINK_LINECARD_STATE_MAX = 7,
	DEVLINK_LINECARD_STATE_MAX = 6,
};

enum devlink_multicast_groups {
	DEVLINK_MCGRP_CONFIG = 0,
};

enum devlink_param_cmode {
	DEVLINK_PARAM_CMODE_RUNTIME = 0,
	DEVLINK_PARAM_CMODE_DRIVERINIT = 1,
	DEVLINK_PARAM_CMODE_PERMANENT = 2,
	__DEVLINK_PARAM_CMODE_MAX = 3,
	DEVLINK_PARAM_CMODE_MAX = 2,
};

enum devlink_param_generic_id {
	DEVLINK_PARAM_GENERIC_ID_INT_ERR_RESET = 0,
	DEVLINK_PARAM_GENERIC_ID_MAX_MACS = 1,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_SRIOV = 2,
	DEVLINK_PARAM_GENERIC_ID_REGION_SNAPSHOT = 3,
	DEVLINK_PARAM_GENERIC_ID_IGNORE_ARI = 4,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MAX = 5,
	DEVLINK_PARAM_GENERIC_ID_MSIX_VEC_PER_PF_MIN = 6,
	DEVLINK_PARAM_GENERIC_ID_FW_LOAD_POLICY = 7,
	DEVLINK_PARAM_GENERIC_ID_RESET_DEV_ON_DRV_PROBE = 8,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ROCE = 9,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_REMOTE_DEV_RESET = 10,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_ETH = 11,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_RDMA = 12,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_VNET = 13,
	DEVLINK_PARAM_GENERIC_ID_ENABLE_IWARP = 14,
	DEVLINK_PARAM_GENERIC_ID_IO_EQ_SIZE = 15,
	DEVLINK_PARAM_GENERIC_ID_EVENT_EQ_SIZE = 16,
	__DEVLINK_PARAM_GENERIC_ID_MAX = 17,
	DEVLINK_PARAM_GENERIC_ID_MAX = 16,
};

enum devlink_param_type {
	DEVLINK_PARAM_TYPE_U8 = 1,
	DEVLINK_PARAM_TYPE_U16 = 2,
	DEVLINK_PARAM_TYPE_U32 = 3,
	DEVLINK_PARAM_TYPE_STRING = 5,
	DEVLINK_PARAM_TYPE_BOOL = 6,
};

enum devlink_port_flavour {
	DEVLINK_PORT_FLAVOUR_PHYSICAL = 0,
	DEVLINK_PORT_FLAVOUR_CPU = 1,
	DEVLINK_PORT_FLAVOUR_DSA = 2,
	DEVLINK_PORT_FLAVOUR_PCI_PF = 3,
	DEVLINK_PORT_FLAVOUR_PCI_VF = 4,
	DEVLINK_PORT_FLAVOUR_VIRTUAL = 5,
	DEVLINK_PORT_FLAVOUR_UNUSED = 6,
	DEVLINK_PORT_FLAVOUR_PCI_SF = 7,
};

enum devlink_port_fn_attr_cap {
	DEVLINK_PORT_FN_ATTR_CAP_ROCE_BIT = 0,
	DEVLINK_PORT_FN_ATTR_CAP_MIGRATABLE_BIT = 1,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_CRYPTO_BIT = 2,
	DEVLINK_PORT_FN_ATTR_CAP_IPSEC_PACKET_BIT = 3,
	__DEVLINK_PORT_FN_ATTR_CAPS_MAX = 4,
};

enum devlink_port_fn_opstate {
	DEVLINK_PORT_FN_OPSTATE_DETACHED = 0,
	DEVLINK_PORT_FN_OPSTATE_ATTACHED = 1,
};

enum devlink_port_fn_state {
	DEVLINK_PORT_FN_STATE_INACTIVE = 0,
	DEVLINK_PORT_FN_STATE_ACTIVE = 1,
};

enum devlink_port_function_attr {
	DEVLINK_PORT_FUNCTION_ATTR_UNSPEC = 0,
	DEVLINK_PORT_FUNCTION_ATTR_HW_ADDR = 1,
	DEVLINK_PORT_FN_ATTR_STATE = 2,
	DEVLINK_PORT_FN_ATTR_OPSTATE = 3,
	DEVLINK_PORT_FN_ATTR_CAPS = 4,
	DEVLINK_PORT_FN_ATTR_DEVLINK = 5,
	DEVLINK_PORT_FN_ATTR_MAX_IO_EQS = 6,
	__DEVLINK_PORT_FUNCTION_ATTR_MAX = 7,
	DEVLINK_PORT_FUNCTION_ATTR_MAX = 6,
};

enum devlink_port_type {
	DEVLINK_PORT_TYPE_NOTSET = 0,
	DEVLINK_PORT_TYPE_AUTO = 1,
	DEVLINK_PORT_TYPE_ETH = 2,
	DEVLINK_PORT_TYPE_IB = 3,
};

enum devlink_rate_type {
	DEVLINK_RATE_TYPE_LEAF = 0,
	DEVLINK_RATE_TYPE_NODE = 1,
};

enum devlink_reload_action {
	DEVLINK_RELOAD_ACTION_UNSPEC = 0,
	DEVLINK_RELOAD_ACTION_DRIVER_REINIT = 1,
	DEVLINK_RELOAD_ACTION_FW_ACTIVATE = 2,
	__DEVLINK_RELOAD_ACTION_MAX = 3,
	DEVLINK_RELOAD_ACTION_MAX = 2,
};

enum devlink_reload_limit {
	DEVLINK_RELOAD_LIMIT_UNSPEC = 0,
	DEVLINK_RELOAD_LIMIT_NO_RESET = 1,
	__DEVLINK_RELOAD_LIMIT_MAX = 2,
	DEVLINK_RELOAD_LIMIT_MAX = 1,
};

enum devlink_resource_unit {
	DEVLINK_RESOURCE_UNIT_ENTRY = 0,
};

enum devlink_sb_pool_type {
	DEVLINK_SB_POOL_TYPE_INGRESS = 0,
	DEVLINK_SB_POOL_TYPE_EGRESS = 1,
};

enum devlink_sb_threshold_type {
	DEVLINK_SB_THRESHOLD_TYPE_STATIC = 0,
	DEVLINK_SB_THRESHOLD_TYPE_DYNAMIC = 1,
};

enum devlink_selftest_status {
	DEVLINK_SELFTEST_STATUS_SKIP = 0,
	DEVLINK_SELFTEST_STATUS_PASS = 1,
	DEVLINK_SELFTEST_STATUS_FAIL = 2,
};

enum devlink_trap_action {
	DEVLINK_TRAP_ACTION_DROP = 0,
	DEVLINK_TRAP_ACTION_TRAP = 1,
	DEVLINK_TRAP_ACTION_MIRROR = 2,
};

enum devlink_trap_generic_id {
	DEVLINK_TRAP_GENERIC_ID_SMAC_MC = 0,
	DEVLINK_TRAP_GENERIC_ID_VLAN_TAG_MISMATCH = 1,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_VLAN_FILTER = 2,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_STP_FILTER = 3,
	DEVLINK_TRAP_GENERIC_ID_EMPTY_TX_LIST = 4,
	DEVLINK_TRAP_GENERIC_ID_PORT_LOOPBACK_FILTER = 5,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_ROUTE = 6,
	DEVLINK_TRAP_GENERIC_ID_TTL_ERROR = 7,
	DEVLINK_TRAP_GENERIC_ID_TAIL_DROP = 8,
	DEVLINK_TRAP_GENERIC_ID_NON_IP_PACKET = 9,
	DEVLINK_TRAP_GENERIC_ID_UC_DIP_MC_DMAC = 10,
	DEVLINK_TRAP_GENERIC_ID_DIP_LB = 11,
	DEVLINK_TRAP_GENERIC_ID_SIP_MC = 12,
	DEVLINK_TRAP_GENERIC_ID_SIP_LB = 13,
	DEVLINK_TRAP_GENERIC_ID_CORRUPTED_IP_HDR = 14,
	DEVLINK_TRAP_GENERIC_ID_IPV4_SIP_BC = 15,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_RESERVED_SCOPE = 16,
	DEVLINK_TRAP_GENERIC_ID_IPV6_MC_DIP_INTERFACE_LOCAL_SCOPE = 17,
	DEVLINK_TRAP_GENERIC_ID_MTU_ERROR = 18,
	DEVLINK_TRAP_GENERIC_ID_UNRESOLVED_NEIGH = 19,
	DEVLINK_TRAP_GENERIC_ID_RPF = 20,
	DEVLINK_TRAP_GENERIC_ID_REJECT_ROUTE = 21,
	DEVLINK_TRAP_GENERIC_ID_IPV4_LPM_UNICAST_MISS = 22,
	DEVLINK_TRAP_GENERIC_ID_IPV6_LPM_UNICAST_MISS = 23,
	DEVLINK_TRAP_GENERIC_ID_NON_ROUTABLE = 24,
	DEVLINK_TRAP_GENERIC_ID_DECAP_ERROR = 25,
	DEVLINK_TRAP_GENERIC_ID_OVERLAY_SMAC_MC = 26,
	DEVLINK_TRAP_GENERIC_ID_INGRESS_FLOW_ACTION_DROP = 27,
	DEVLINK_TRAP_GENERIC_ID_EGRESS_FLOW_ACTION_DROP = 28,
	DEVLINK_TRAP_GENERIC_ID_STP = 29,
	DEVLINK_TRAP_GENERIC_ID_LACP = 30,
	DEVLINK_TRAP_GENERIC_ID_LLDP = 31,
	DEVLINK_TRAP_GENERIC_ID_IGMP_QUERY = 32,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V1_REPORT = 33,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_REPORT = 34,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V3_REPORT = 35,
	DEVLINK_TRAP_GENERIC_ID_IGMP_V2_LEAVE = 36,
	DEVLINK_TRAP_GENERIC_ID_MLD_QUERY = 37,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_REPORT = 38,
	DEVLINK_TRAP_GENERIC_ID_MLD_V2_REPORT = 39,
	DEVLINK_TRAP_GENERIC_ID_MLD_V1_DONE = 40,
	DEVLINK_TRAP_GENERIC_ID_IPV4_DHCP = 41,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DHCP = 42,
	DEVLINK_TRAP_GENERIC_ID_ARP_REQUEST = 43,
	DEVLINK_TRAP_GENERIC_ID_ARP_RESPONSE = 44,
	DEVLINK_TRAP_GENERIC_ID_ARP_OVERLAY = 45,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_SOLICIT = 46,
	DEVLINK_TRAP_GENERIC_ID_IPV6_NEIGH_ADVERT = 47,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BFD = 48,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BFD = 49,
	DEVLINK_TRAP_GENERIC_ID_IPV4_OSPF = 50,
	DEVLINK_TRAP_GENERIC_ID_IPV6_OSPF = 51,
	DEVLINK_TRAP_GENERIC_ID_IPV4_BGP = 52,
	DEVLINK_TRAP_GENERIC_ID_IPV6_BGP = 53,
	DEVLINK_TRAP_GENERIC_ID_IPV4_VRRP = 54,
	DEVLINK_TRAP_GENERIC_ID_IPV6_VRRP = 55,
	DEVLINK_TRAP_GENERIC_ID_IPV4_PIM = 56,
	DEVLINK_TRAP_GENERIC_ID_IPV6_PIM = 57,
	DEVLINK_TRAP_GENERIC_ID_UC_LB = 58,
	DEVLINK_TRAP_GENERIC_ID_LOCAL_ROUTE = 59,
	DEVLINK_TRAP_GENERIC_ID_EXTERNAL_ROUTE = 60,
	DEVLINK_TRAP_GENERIC_ID_IPV6_UC_DIP_LINK_LOCAL_SCOPE = 61,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_NODES = 62,
	DEVLINK_TRAP_GENERIC_ID_IPV6_DIP_ALL_ROUTERS = 63,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_SOLICIT = 64,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ADVERT = 65,
	DEVLINK_TRAP_GENERIC_ID_IPV6_REDIRECT = 66,
	DEVLINK_TRAP_GENERIC_ID_IPV4_ROUTER_ALERT = 67,
	DEVLINK_TRAP_GENERIC_ID_IPV6_ROUTER_ALERT = 68,
	DEVLINK_TRAP_GENERIC_ID_PTP_EVENT = 69,
	DEVLINK_TRAP_GENERIC_ID_PTP_GENERAL = 70,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_SAMPLE = 71,
	DEVLINK_TRAP_GENERIC_ID_FLOW_ACTION_TRAP = 72,
	DEVLINK_TRAP_GENERIC_ID_EARLY_DROP = 73,
	DEVLINK_TRAP_GENERIC_ID_VXLAN_PARSING = 74,
	DEVLINK_TRAP_GENERIC_ID_LLC_SNAP_PARSING = 75,
	DEVLINK_TRAP_GENERIC_ID_VLAN_PARSING = 76,
	DEVLINK_TRAP_GENERIC_ID_PPPOE_PPP_PARSING = 77,
	DEVLINK_TRAP_GENERIC_ID_MPLS_PARSING = 78,
	DEVLINK_TRAP_GENERIC_ID_ARP_PARSING = 79,
	DEVLINK_TRAP_GENERIC_ID_IP_1_PARSING = 80,
	DEVLINK_TRAP_GENERIC_ID_IP_N_PARSING = 81,
	DEVLINK_TRAP_GENERIC_ID_GRE_PARSING = 82,
	DEVLINK_TRAP_GENERIC_ID_UDP_PARSING = 83,
	DEVLINK_TRAP_GENERIC_ID_TCP_PARSING = 84,
	DEVLINK_TRAP_GENERIC_ID_IPSEC_PARSING = 85,
	DEVLINK_TRAP_GENERIC_ID_SCTP_PARSING = 86,
	DEVLINK_TRAP_GENERIC_ID_DCCP_PARSING = 87,
	DEVLINK_TRAP_GENERIC_ID_GTP_PARSING = 88,
	DEVLINK_TRAP_GENERIC_ID_ESP_PARSING = 89,
	DEVLINK_TRAP_GENERIC_ID_BLACKHOLE_NEXTHOP = 90,
	DEVLINK_TRAP_GENERIC_ID_DMAC_FILTER = 91,
	DEVLINK_TRAP_GENERIC_ID_EAPOL = 92,
	DEVLINK_TRAP_GENERIC_ID_LOCKED_PORT = 93,
	__DEVLINK_TRAP_GENERIC_ID_MAX = 94,
	DEVLINK_TRAP_GENERIC_ID_MAX = 93,
};

enum devlink_trap_group_generic_id {
	DEVLINK_TRAP_GROUP_GENERIC_ID_L2_DROPS = 0,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_DROPS = 1,
	DEVLINK_TRAP_GROUP_GENERIC_ID_L3_EXCEPTIONS = 2,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BUFFER_DROPS = 3,
	DEVLINK_TRAP_GROUP_GENERIC_ID_TUNNEL_DROPS = 4,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_DROPS = 5,
	DEVLINK_TRAP_GROUP_GENERIC_ID_STP = 6,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LACP = 7,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LLDP = 8,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MC_SNOOPING = 9,
	DEVLINK_TRAP_GROUP_GENERIC_ID_DHCP = 10,
	DEVLINK_TRAP_GROUP_GENERIC_ID_NEIGH_DISCOVERY = 11,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BFD = 12,
	DEVLINK_TRAP_GROUP_GENERIC_ID_OSPF = 13,
	DEVLINK_TRAP_GROUP_GENERIC_ID_BGP = 14,
	DEVLINK_TRAP_GROUP_GENERIC_ID_VRRP = 15,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PIM = 16,
	DEVLINK_TRAP_GROUP_GENERIC_ID_UC_LB = 17,
	DEVLINK_TRAP_GROUP_GENERIC_ID_LOCAL_DELIVERY = 18,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EXTERNAL_DELIVERY = 19,
	DEVLINK_TRAP_GROUP_GENERIC_ID_IPV6 = 20,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_EVENT = 21,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PTP_GENERAL = 22,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_SAMPLE = 23,
	DEVLINK_TRAP_GROUP_GENERIC_ID_ACL_TRAP = 24,
	DEVLINK_TRAP_GROUP_GENERIC_ID_PARSER_ERROR_DROPS = 25,
	DEVLINK_TRAP_GROUP_GENERIC_ID_EAPOL = 26,
	__DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 27,
	DEVLINK_TRAP_GROUP_GENERIC_ID_MAX = 26,
};

enum devlink_trap_type {
	DEVLINK_TRAP_TYPE_DROP = 0,
	DEVLINK_TRAP_TYPE_EXCEPTION = 1,
	DEVLINK_TRAP_TYPE_CONTROL = 2,
};

enum devlink_var_attr_type {
	DEVLINK_VAR_ATTR_TYPE_U8 = 1,
	DEVLINK_VAR_ATTR_TYPE_U16 = 2,
	DEVLINK_VAR_ATTR_TYPE_U32 = 3,
	DEVLINK_VAR_ATTR_TYPE_U64 = 4,
	DEVLINK_VAR_ATTR_TYPE_STRING = 5,
	DEVLINK_VAR_ATTR_TYPE_FLAG = 6,
	DEVLINK_VAR_ATTR_TYPE_NUL_STRING = 10,
	DEVLINK_VAR_ATTR_TYPE_BINARY = 11,
	__DEVLINK_VAR_ATTR_TYPE_CUSTOM_BASE = 128,
};

enum devm_ioremap_type {
	DEVM_IOREMAP = 0,
	DEVM_IOREMAP_UC = 1,
	DEVM_IOREMAP_WC = 2,
	DEVM_IOREMAP_NP = 3,
};

enum dfll_ctrl_mode {
	DFLL_UNINITIALIZED = 0,
	DFLL_DISABLED = 1,
	DFLL_OPEN_LOOP = 2,
	DFLL_CLOSED_LOOP = 3,
};

enum dfll_tune_range {
	DFLL_TUNE_UNINITIALIZED = 0,
	DFLL_TUNE_LOW = 1,
};

enum die_val {
	DIE_UNUSED = 0,
	DIE_OOPS = 1,
};

enum dim_cq_period_mode {
	DIM_CQ_PERIOD_MODE_START_FROM_EQE = 0,
	DIM_CQ_PERIOD_MODE_START_FROM_CQE = 1,
	DIM_CQ_PERIOD_NUM_MODES = 2,
};

enum dim_state {
	DIM_START_MEASURE = 0,
	DIM_MEASURE_IN_PROGRESS = 1,
	DIM_APPLY_NEW_PROFILE = 2,
};

enum dim_stats_state {
	DIM_STATS_WORSE = 0,
	DIM_STATS_SAME = 1,
	DIM_STATS_BETTER = 2,
};

enum dim_step_result {
	DIM_STEPPED = 0,
	DIM_TOO_TIRED = 1,
	DIM_ON_EDGE = 2,
};

enum dim_tune_state {
	DIM_PARKING_ON_TOP = 0,
	DIM_PARKING_TIRED = 1,
	DIM_GOING_RIGHT = 2,
	DIM_GOING_LEFT = 3,
};

enum dirty_type {
	DIRTY_HOT_DATA = 0,
	DIRTY_WARM_DATA = 1,
	DIRTY_COLD_DATA = 2,
	DIRTY_HOT_NODE = 3,
	DIRTY_WARM_NODE = 4,
	DIRTY_COLD_NODE = 5,
	DIRTY = 6,
	PRE = 7,
	NR_DIRTY_TYPE = 8,
};

enum display_flags {
	DISPLAY_FLAGS_HSYNC_LOW = 1,
	DISPLAY_FLAGS_HSYNC_HIGH = 2,
	DISPLAY_FLAGS_VSYNC_LOW = 4,
	DISPLAY_FLAGS_VSYNC_HIGH = 8,
	DISPLAY_FLAGS_DE_LOW = 16,
	DISPLAY_FLAGS_DE_HIGH = 32,
	DISPLAY_FLAGS_PIXDATA_POSEDGE = 64,
	DISPLAY_FLAGS_PIXDATA_NEGEDGE = 128,
	DISPLAY_FLAGS_INTERLACED = 256,
	DISPLAY_FLAGS_DOUBLESCAN = 512,
	DISPLAY_FLAGS_DOUBLECLK = 1024,
	DISPLAY_FLAGS_SYNC_POSEDGE = 2048,
	DISPLAY_FLAGS_SYNC_NEGEDGE = 4096,
};

enum dither_down_mode {
	RGB888_TO_RGB565 = 0,
	RGB888_TO_RGB666 = 1,
};

enum dither_down_mode_sel {
	DITHER_DOWN_ALLEGRO = 0,
	DITHER_DOWN_FRC = 1,
};

enum dl_bw_request {
	dl_bw_req_deactivate = 0,
	dl_bw_req_alloc = 1,
	dl_bw_req_free = 2,
};

enum dl_dev_state {
	DL_DEV_NO_DRIVER = 0,
	DL_DEV_PROBING = 1,
	DL_DEV_DRIVER_BOUND = 2,
	DL_DEV_UNBINDING = 3,
};

enum dl_param {
	DL_RUNTIME = 0,
	DL_PERIOD = 1,
};

enum dll_reset_type {
	PM_DLL_RESET_ASSERT = 0,
	PM_DLL_RESET_RELEASE = 1,
	PM_DLL_RESET_PULSE = 2,
};

enum dma_channel_status {
	MUSB_DMA_STATUS_UNKNOWN = 0,
	MUSB_DMA_STATUS_FREE = 1,
	MUSB_DMA_STATUS_BUSY = 2,
	MUSB_DMA_STATUS_BUS_ABORT = 3,
	MUSB_DMA_STATUS_CORE_ABORT = 4,
};

enum dma_ctrl_flags {
	DMA_PREP_INTERRUPT = 1,
	DMA_CTRL_ACK = 2,
	DMA_PREP_PQ_DISABLE_P = 4,
	DMA_PREP_PQ_DISABLE_Q = 8,
	DMA_PREP_CONTINUE = 16,
	DMA_PREP_FENCE = 32,
	DMA_CTRL_REUSE = 64,
	DMA_PREP_CMD = 128,
	DMA_PREP_REPEAT = 256,
	DMA_PREP_LOAD_EOT = 512,
};

enum dma_data_direction {
	DMA_BIDIRECTIONAL = 0,
	DMA_TO_DEVICE = 1,
	DMA_FROM_DEVICE = 2,
	DMA_NONE = 3,
};

enum dma_desc_metadata_mode {
	DESC_METADATA_NONE = 0,
	DESC_METADATA_CLIENT = 1,
	DESC_METADATA_ENGINE = 2,
};

enum dma_event_q {
	EVENTQ_0 = 0,
	EVENTQ_1 = 1,
	EVENTQ_2 = 2,
	EVENTQ_3 = 3,
	EVENTQ_DEFAULT = -1,
};

enum dma_fence_flag_bits {
	DMA_FENCE_FLAG_SIGNALED_BIT = 0,
	DMA_FENCE_FLAG_TIMESTAMP_BIT = 1,
	DMA_FENCE_FLAG_ENABLE_SIGNAL_BIT = 2,
	DMA_FENCE_FLAG_USER_BITS = 3,
};

enum dma_reg {
	DMA_RING_CFG = 0,
	DMA_CTRL = 1,
	DMA_STATUS = 2,
	DMA_SCB_BURST_SIZE = 3,
	DMA_ARB_CTRL = 4,
	DMA_PRIORITY_0 = 5,
	DMA_PRIORITY_1 = 6,
	DMA_PRIORITY_2 = 7,
	DMA_INDEX2RING_0 = 8,
	DMA_INDEX2RING_1 = 9,
	DMA_INDEX2RING_2 = 10,
	DMA_INDEX2RING_3 = 11,
	DMA_INDEX2RING_4 = 12,
	DMA_INDEX2RING_5 = 13,
	DMA_INDEX2RING_6 = 14,
	DMA_INDEX2RING_7 = 15,
	DMA_RING0_TIMEOUT = 16,
	DMA_RING1_TIMEOUT = 17,
	DMA_RING2_TIMEOUT = 18,
	DMA_RING3_TIMEOUT = 19,
	DMA_RING4_TIMEOUT = 20,
	DMA_RING5_TIMEOUT = 21,
	DMA_RING6_TIMEOUT = 22,
	DMA_RING7_TIMEOUT = 23,
	DMA_RING8_TIMEOUT = 24,
	DMA_RING9_TIMEOUT = 25,
	DMA_RING10_TIMEOUT = 26,
	DMA_RING11_TIMEOUT = 27,
	DMA_RING12_TIMEOUT = 28,
	DMA_RING13_TIMEOUT = 29,
	DMA_RING14_TIMEOUT = 30,
	DMA_RING15_TIMEOUT = 31,
	DMA_RING16_TIMEOUT = 32,
};

enum dma_residue_granularity {
	DMA_RESIDUE_GRANULARITY_DESCRIPTOR = 0,
	DMA_RESIDUE_GRANULARITY_SEGMENT = 1,
	DMA_RESIDUE_GRANULARITY_BURST = 2,
};

enum dma_resv_usage {
	DMA_RESV_USAGE_KERNEL = 0,
	DMA_RESV_USAGE_WRITE = 1,
	DMA_RESV_USAGE_READ = 2,
	DMA_RESV_USAGE_BOOKKEEP = 3,
};

enum dma_ring_reg {
	TDMA_READ_PTR = 0,
	RDMA_WRITE_PTR = 0,
	TDMA_READ_PTR_HI = 1,
	RDMA_WRITE_PTR_HI = 1,
	TDMA_CONS_INDEX = 2,
	RDMA_PROD_INDEX = 2,
	TDMA_PROD_INDEX = 3,
	RDMA_CONS_INDEX = 3,
	DMA_RING_BUF_SIZE = 4,
	DMA_START_ADDR = 5,
	DMA_START_ADDR_HI = 6,
	DMA_END_ADDR = 7,
	DMA_END_ADDR_HI = 8,
	DMA_MBUF_DONE_THRESH = 9,
	TDMA_FLOW_PERIOD = 10,
	RDMA_XON_XOFF_THRESH = 10,
	TDMA_WRITE_PTR = 11,
	RDMA_READ_PTR = 11,
	TDMA_WRITE_PTR_HI = 12,
	RDMA_READ_PTR_HI = 12,
};

enum dma_slave_buswidth {
	DMA_SLAVE_BUSWIDTH_UNDEFINED = 0,
	DMA_SLAVE_BUSWIDTH_1_BYTE = 1,
	DMA_SLAVE_BUSWIDTH_2_BYTES = 2,
	DMA_SLAVE_BUSWIDTH_3_BYTES = 3,
	DMA_SLAVE_BUSWIDTH_4_BYTES = 4,
	DMA_SLAVE_BUSWIDTH_8_BYTES = 8,
	DMA_SLAVE_BUSWIDTH_16_BYTES = 16,
	DMA_SLAVE_BUSWIDTH_32_BYTES = 32,
	DMA_SLAVE_BUSWIDTH_64_BYTES = 64,
	DMA_SLAVE_BUSWIDTH_128_BYTES = 128,
};

enum dma_status {
	DMA_COMPLETE = 0,
	DMA_IN_PROGRESS = 1,
	DMA_PAUSED = 2,
	DMA_ERROR = 3,
	DMA_OUT_OF_ORDER = 4,
};

enum dma_transaction_type {
	DMA_MEMCPY = 0,
	DMA_XOR = 1,
	DMA_PQ = 2,
	DMA_XOR_VAL = 3,
	DMA_PQ_VAL = 4,
	DMA_MEMSET = 5,
	DMA_MEMSET_SG = 6,
	DMA_INTERRUPT = 7,
	DMA_PRIVATE = 8,
	DMA_ASYNC_TX = 9,
	DMA_SLAVE = 10,
	DMA_CYCLIC = 11,
	DMA_INTERLEAVE = 12,
	DMA_COMPLETION_NO_ORDER = 13,
	DMA_REPEAT = 14,
	DMA_LOAD_EOT = 15,
	DMA_TX_TYPE_END = 16,
};

enum dma_transfer_direction {
	DMA_MEM_TO_MEM = 0,
	DMA_MEM_TO_DEV = 1,
	DMA_DEV_TO_MEM = 2,
	DMA_DEV_TO_DEV = 3,
	DMA_TRANS_NONE = 4,
};

enum dmaengine_alignment {
	DMAENGINE_ALIGN_1_BYTE = 0,
	DMAENGINE_ALIGN_2_BYTES = 1,
	DMAENGINE_ALIGN_4_BYTES = 2,
	DMAENGINE_ALIGN_8_BYTES = 3,
	DMAENGINE_ALIGN_16_BYTES = 4,
	DMAENGINE_ALIGN_32_BYTES = 5,
	DMAENGINE_ALIGN_64_BYTES = 6,
	DMAENGINE_ALIGN_128_BYTES = 7,
	DMAENGINE_ALIGN_256_BYTES = 8,
};

enum dmaengine_tx_result {
	DMA_TRANS_NOERROR = 0,
	DMA_TRANS_READ_FAILED = 1,
	DMA_TRANS_WRITE_FAILED = 2,
	DMA_TRANS_ABORTED = 3,
};

enum dmamov_dst {
	SAR = 0,
	CCR = 1,
	DAR = 2,
};

enum dmi_field {
	DMI_NONE = 0,
	DMI_BIOS_VENDOR = 1,
	DMI_BIOS_VERSION = 2,
	DMI_BIOS_DATE = 3,
	DMI_BIOS_RELEASE = 4,
	DMI_EC_FIRMWARE_RELEASE = 5,
	DMI_SYS_VENDOR = 6,
	DMI_PRODUCT_NAME = 7,
	DMI_PRODUCT_VERSION = 8,
	DMI_PRODUCT_SERIAL = 9,
	DMI_PRODUCT_UUID = 10,
	DMI_PRODUCT_SKU = 11,
	DMI_PRODUCT_FAMILY = 12,
	DMI_BOARD_VENDOR = 13,
	DMI_BOARD_NAME = 14,
	DMI_BOARD_VERSION = 15,
	DMI_BOARD_SERIAL = 16,
	DMI_BOARD_ASSET_TAG = 17,
	DMI_CHASSIS_VENDOR = 18,
	DMI_CHASSIS_TYPE = 19,
	DMI_CHASSIS_VERSION = 20,
	DMI_CHASSIS_SERIAL = 21,
	DMI_CHASSIS_ASSET_TAG = 22,
	DMI_STRING_MAX = 23,
	DMI_OEM_STRING = 24,
};

enum dmx_buffer_flags {
	DMX_BUFFER_FLAG_HAD_CRC32_DISCARD = 1,
	DMX_BUFFER_FLAG_TEI = 2,
	DMX_BUFFER_PKT_COUNTER_MISMATCH = 4,
	DMX_BUFFER_FLAG_DISCONTINUITY_DETECTED = 8,
	DMX_BUFFER_FLAG_DISCONTINUITY_INDICATOR = 16,
};

enum dmx_demux_caps {
	DMX_TS_FILTERING = 1,
	DMX_SECTION_FILTERING = 4,
	DMX_MEMORY_BASED_FILTERING = 8,
};

enum dmx_frontend_source {
	DMX_MEMORY_FE = 0,
	DMX_FRONTEND_0 = 1,
};

enum dmx_input {
	DMX_IN_FRONTEND = 0,
	DMX_IN_DVR = 1,
};

enum dmx_output {
	DMX_OUT_DECODER = 0,
	DMX_OUT_TAP = 1,
	DMX_OUT_TS_TAP = 2,
	DMX_OUT_TSDEMUX_TAP = 3,
};

enum dmx_ts_pes {
	DMX_PES_AUDIO0 = 0,
	DMX_PES_VIDEO0 = 1,
	DMX_PES_TELETEXT0 = 2,
	DMX_PES_SUBTITLE0 = 3,
	DMX_PES_PCR0 = 4,
	DMX_PES_AUDIO1 = 5,
	DMX_PES_VIDEO1 = 6,
	DMX_PES_TELETEXT1 = 7,
	DMX_PES_SUBTITLE1 = 8,
	DMX_PES_PCR1 = 9,
	DMX_PES_AUDIO2 = 10,
	DMX_PES_VIDEO2 = 11,
	DMX_PES_TELETEXT2 = 12,
	DMX_PES_SUBTITLE2 = 13,
	DMX_PES_PCR2 = 14,
	DMX_PES_AUDIO3 = 15,
	DMX_PES_VIDEO3 = 16,
	DMX_PES_TELETEXT3 = 17,
	DMX_PES_SUBTITLE3 = 18,
	DMX_PES_PCR3 = 19,
	DMX_PES_OTHER = 20,
};

enum dmxdev_state {
	DMXDEV_STATE_FREE = 0,
	DMXDEV_STATE_ALLOCATED = 1,
	DMXDEV_STATE_SET = 2,
	DMXDEV_STATE_GO = 3,
	DMXDEV_STATE_DONE = 4,
	DMXDEV_STATE_TIMEDOUT = 5,
};

enum dmxdev_type {
	DMXDEV_TYPE_NONE = 0,
	DMXDEV_TYPE_SEC = 1,
	DMXDEV_TYPE_PES = 2,
};

enum dns_lookup_status {
	DNS_LOOKUP_NOT_DONE = 0,
	DNS_LOOKUP_GOOD = 1,
	DNS_LOOKUP_GOOD_WITH_BAD = 2,
	DNS_LOOKUP_BAD = 3,
	DNS_LOOKUP_GOT_NOT_FOUND = 4,
	DNS_LOOKUP_GOT_LOCAL_FAILURE = 5,
	DNS_LOOKUP_GOT_TEMP_FAILURE = 6,
	DNS_LOOKUP_GOT_NS_FAILURE = 7,
	NR__dns_lookup_status = 8,
};

enum dns_payload_content_type {
	DNS_PAYLOAD_IS_SERVER_LIST = 0,
};

enum dp_colorimetry {
	DP_COLORIMETRY_DEFAULT = 0,
	DP_COLORIMETRY_RGB_WIDE_FIXED = 1,
	DP_COLORIMETRY_BT709_YCC = 1,
	DP_COLORIMETRY_RGB_WIDE_FLOAT = 2,
	DP_COLORIMETRY_XVYCC_601 = 2,
	DP_COLORIMETRY_OPRGB = 3,
	DP_COLORIMETRY_XVYCC_709 = 3,
	DP_COLORIMETRY_DCI_P3_RGB = 4,
	DP_COLORIMETRY_SYCC_601 = 4,
	DP_COLORIMETRY_RGB_CUSTOM = 5,
	DP_COLORIMETRY_OPYCC_601 = 5,
	DP_COLORIMETRY_BT2020_RGB = 6,
	DP_COLORIMETRY_BT2020_CYCC = 6,
	DP_COLORIMETRY_BT2020_YCC = 7,
};

enum dp_content_type {
	DP_CONTENT_TYPE_NOT_DEFINED = 0,
	DP_CONTENT_TYPE_GRAPHICS = 1,
	DP_CONTENT_TYPE_PHOTO = 2,
	DP_CONTENT_TYPE_VIDEO = 3,
	DP_CONTENT_TYPE_GAME = 4,
};

enum dp_dynamic_range {
	DP_DYNAMIC_RANGE_VESA = 0,
	DP_DYNAMIC_RANGE_CTA = 1,
};

enum dp_irq_type {
	DP_IRQ_TYPE_HP_CABLE_IN = 1,
	DP_IRQ_TYPE_HP_CABLE_OUT = 2,
	DP_IRQ_TYPE_HP_CHANGE = 4,
	DP_IRQ_TYPE_UNKNOWN = 8,
};

enum dp_pixelformat {
	DP_PIXELFORMAT_RGB = 0,
	DP_PIXELFORMAT_YUV444 = 1,
	DP_PIXELFORMAT_YUV422 = 2,
	DP_PIXELFORMAT_YUV420 = 3,
	DP_PIXELFORMAT_Y_ONLY = 4,
	DP_PIXELFORMAT_RAW = 5,
	DP_PIXELFORMAT_RESERVED = 6,
};

enum dpm_order {
	DPM_ORDER_NONE = 0,
	DPM_ORDER_DEV_AFTER_PARENT = 1,
	DPM_ORDER_PARENT_BEFORE_DEV = 2,
	DPM_ORDER_DEV_LAST = 3,
};

enum dpu_3d_blend_mode {
	BLEND_3D_NONE = 0,
	BLEND_3D_FRAME_INT = 1,
	BLEND_3D_H_ROW_INT = 2,
	BLEND_3D_V_ROW_INT = 3,
	BLEND_3D_COL_INT = 4,
	BLEND_3D_MAX = 5,
};

enum dpu_cdm {
	CDM_0 = 1,
	CDM_MAX = 2,
};

enum dpu_clk_ctrl_type {
	DPU_CLK_CTRL_NONE = 0,
	DPU_CLK_CTRL_VIG0 = 1,
	DPU_CLK_CTRL_VIG1 = 2,
	DPU_CLK_CTRL_VIG2 = 3,
	DPU_CLK_CTRL_VIG3 = 4,
	DPU_CLK_CTRL_VIG4 = 5,
	DPU_CLK_CTRL_RGB0 = 6,
	DPU_CLK_CTRL_RGB1 = 7,
	DPU_CLK_CTRL_RGB2 = 8,
	DPU_CLK_CTRL_RGB3 = 9,
	DPU_CLK_CTRL_DMA0 = 10,
	DPU_CLK_CTRL_DMA1 = 11,
	DPU_CLK_CTRL_DMA2 = 12,
	DPU_CLK_CTRL_DMA3 = 13,
	DPU_CLK_CTRL_DMA4 = 14,
	DPU_CLK_CTRL_DMA5 = 15,
	DPU_CLK_CTRL_CURSOR0 = 16,
	DPU_CLK_CTRL_CURSOR1 = 17,
	DPU_CLK_CTRL_INLINE_ROT0_SSPP = 18,
	DPU_CLK_CTRL_REG_DMA = 19,
	DPU_CLK_CTRL_WB2 = 20,
	DPU_CLK_CTRL_MAX = 21,
};

enum dpu_crtc_client_type {
	RT_CLIENT = 0,
	NRT_CLIENT = 1,
};

enum dpu_crtc_crc_source {
	DPU_CRTC_CRC_SOURCE_NONE = 0,
	DPU_CRTC_CRC_SOURCE_LAYER_MIXER = 1,
	DPU_CRTC_CRC_SOURCE_ENCODER = 2,
	DPU_CRTC_CRC_SOURCE_MAX = 3,
	DPU_CRTC_CRC_SOURCE_INVALID = -1,
};

enum dpu_ctl {
	CTL_0 = 1,
	CTL_1 = 2,
	CTL_2 = 3,
	CTL_3 = 4,
	CTL_4 = 5,
	CTL_5 = 6,
	CTL_MAX = 7,
};

enum dpu_ctl_mode_sel {
	DPU_CTL_MODE_SEL_VID = 0,
	DPU_CTL_MODE_SEL_CMD = 1,
};

enum dpu_cwb {
	CWB_0 = 1,
	CWB_1 = 2,
	CWB_2 = 3,
	CWB_3 = 4,
	CWB_MAX = 5,
};

enum dpu_dp_phy_sel {
	DPU_DP_PHY_NONE = 0,
	DPU_DP_PHY_0 = 1,
	DPU_DP_PHY_1 = 2,
	DPU_DP_PHY_2 = 3,
};

enum dpu_dsc {
	DSC_NONE = 0,
	DSC_0 = 1,
	DSC_1 = 2,
	DSC_2 = 3,
	DSC_3 = 4,
	DSC_4 = 5,
	DSC_5 = 6,
	DSC_6 = 7,
	DSC_7 = 8,
	DSC_MAX = 9,
};

enum dpu_dspp {
	DSPP_0 = 1,
	DSPP_1 = 2,
	DSPP_2 = 3,
	DSPP_3 = 4,
	DSPP_MAX = 5,
};

enum dpu_enc_enable_state {
	DPU_ENC_DISABLING = 0,
	DPU_ENC_DISABLED = 1,
	DPU_ENC_ENABLING = 2,
	DPU_ENC_ENABLED = 3,
	DPU_ENC_ERR_NEEDS_HW_RESET = 4,
};

enum dpu_enc_rc_events {
	DPU_ENC_RC_EVENT_KICKOFF = 1,
	DPU_ENC_RC_EVENT_FRAME_DONE = 2,
	DPU_ENC_RC_EVENT_PRE_STOP = 3,
	DPU_ENC_RC_EVENT_STOP = 4,
	DPU_ENC_RC_EVENT_ENTER_IDLE = 5,
};

enum dpu_enc_rc_states {
	DPU_ENC_RC_STATE_OFF = 0,
	DPU_ENC_RC_STATE_PRE_OFF = 1,
	DPU_ENC_RC_STATE_ON = 2,
	DPU_ENC_RC_STATE_IDLE = 3,
};

enum dpu_enc_split_role {
	ENC_ROLE_SOLO = 0,
	ENC_ROLE_MASTER = 1,
	ENC_ROLE_SLAVE = 2,
};

enum dpu_hw_blk_type {
	DPU_HW_BLK_TOP = 0,
	DPU_HW_BLK_SSPP = 1,
	DPU_HW_BLK_LM = 2,
	DPU_HW_BLK_CTL = 3,
	DPU_HW_BLK_PINGPONG = 4,
	DPU_HW_BLK_DCWB_PINGPONG = 5,
	DPU_HW_BLK_INTF = 6,
	DPU_HW_BLK_WB = 7,
	DPU_HW_BLK_DSPP = 8,
	DPU_HW_BLK_MERGE_3D = 9,
	DPU_HW_BLK_DSC = 10,
	DPU_HW_BLK_CDM = 11,
	DPU_HW_BLK_CWB = 12,
	DPU_HW_BLK_MAX = 13,
};

enum dpu_hw_cdwn_op_mode_method_h_v {
	CDM_CDWN2_METHOD_PIXEL_DROP = 0,
	CDM_CDWN2_METHOD_AVG = 1,
	CDM_CDWN2_METHOD_COSITE = 2,
	CDM_CDWN2_METHOD_OFFSITE = 3,
};

enum dpu_hw_cdwn_output_bit_depth {
	CDM_CDWN_OUTPUT_8BIT = 0,
	CDM_CDWN_OUTPUT_10BIT = 1,
};

enum dpu_hw_cdwn_output_type {
	CDM_CDWN_OUTPUT_HDMI = 0,
	CDM_CDWN_OUTPUT_WB = 1,
};

enum dpu_hw_cdwn_type {
	CDM_CDWN_DISABLE = 0,
	CDM_CDWN_PIXEL_DROP = 1,
	CDM_CDWN_AVG = 2,
	CDM_CDWN_COSITE = 3,
	CDM_CDWN_OFFSITE = 4,
};

enum dpu_hw_filter {
	DPU_SCALE_FILTER_NEAREST = 0,
	DPU_SCALE_FILTER_BIL = 1,
	DPU_SCALE_FILTER_PCMN = 2,
	DPU_SCALE_FILTER_CA = 3,
	DPU_SCALE_FILTER_MAX = 4,
};

enum dpu_hw_filter_alpa {
	DPU_SCALE_ALPHA_PIXEL_REP = 0,
	DPU_SCALE_ALPHA_BIL = 1,
};

enum dpu_hw_filter_yuv {
	DPU_SCALE_2D_4X4 = 0,
	DPU_SCALE_2D_CIR = 1,
	DPU_SCALE_1D_SEP = 2,
	DPU_SCALE_BIL = 3,
};

enum dpu_hw_intr_reg {
	MDP_SSPP_TOP0_INTR = 0,
	MDP_SSPP_TOP0_INTR2 = 1,
	MDP_SSPP_TOP0_HIST_INTR = 2,
	MDP_INTF0_INTR = 3,
	MDP_INTF1_INTR = 4,
	MDP_INTF2_INTR = 5,
	MDP_INTF3_INTR = 6,
	MDP_INTF4_INTR = 7,
	MDP_INTF5_INTR = 8,
	MDP_INTF6_INTR = 9,
	MDP_INTF7_INTR = 10,
	MDP_INTF8_INTR = 11,
	MDP_INTF1_TEAR_INTR = 12,
	MDP_INTF2_TEAR_INTR = 13,
	MDP_AD4_0_INTR = 14,
	MDP_AD4_1_INTR = 15,
	MDP_INTR_MAX = 16,
};

enum dpu_intf {
	INTF_0 = 1,
	INTF_1 = 2,
	INTF_2 = 3,
	INTF_3 = 4,
	INTF_4 = 5,
	INTF_5 = 6,
	INTF_6 = 7,
	INTF_7 = 8,
	INTF_8 = 9,
	INTF_MAX = 10,
};

enum dpu_intf_mode {
	INTF_MODE_NONE = 0,
	INTF_MODE_CMD = 1,
	INTF_MODE_VIDEO = 2,
	INTF_MODE_WB_BLOCK = 3,
	INTF_MODE_WB_LINE = 4,
	INTF_MODE_MAX = 5,
};

enum dpu_intf_type {
	INTF_NONE = 0,
	INTF_DSI = 1,
	INTF_HDMI = 3,
	INTF_LCDC = 5,
	INTF_EDP = 9,
	INTF_DP = 10,
	INTF_WB = 256,
};

enum dpu_intr_idx {
	INTR_IDX_VSYNC = 0,
	INTR_IDX_PINGPONG = 1,
	INTR_IDX_UNDERRUN = 2,
	INTR_IDX_CTL_START = 3,
	INTR_IDX_RDPTR = 4,
	INTR_IDX_WB_DONE = 5,
	INTR_IDX_MAX = 6,
};

enum dpu_lm {
	LM_0 = 1,
	LM_1 = 2,
	LM_2 = 3,
	LM_3 = 4,
	LM_4 = 5,
	LM_5 = 6,
	LM_6 = 7,
	LM_7 = 8,
	LM_MAX = 9,
};

enum dpu_merge_3d {
	MERGE_3D_0 = 1,
	MERGE_3D_1 = 2,
	MERGE_3D_2 = 3,
	MERGE_3D_3 = 4,
	MERGE_3D_4 = 5,
	MERGE_3D_5 = 6,
	MERGE_3D_MAX = 7,
};

enum dpu_perf_mode {
	DPU_PERF_MODE_NORMAL = 0,
	DPU_PERF_MODE_MINIMUM = 1,
	DPU_PERF_MODE_FIXED = 2,
	DPU_PERF_MODE_MAX = 3,
};

enum dpu_pingpong {
	PINGPONG_NONE = 0,
	PINGPONG_0 = 1,
	PINGPONG_1 = 2,
	PINGPONG_2 = 3,
	PINGPONG_3 = 4,
	PINGPONG_4 = 5,
	PINGPONG_5 = 6,
	PINGPONG_6 = 7,
	PINGPONG_7 = 8,
	PINGPONG_CWB_0 = 9,
	PINGPONG_CWB_1 = 10,
	PINGPONG_CWB_2 = 11,
	PINGPONG_CWB_3 = 12,
	PINGPONG_S0 = 13,
	PINGPONG_MAX = 14,
};

enum dpu_qos_lut_usage {
	DPU_QOS_LUT_USAGE_LINEAR = 0,
	DPU_QOS_LUT_USAGE_MACROTILE = 1,
	DPU_QOS_LUT_USAGE_NRT = 2,
	DPU_QOS_LUT_USAGE_MAX = 3,
};

enum dpu_sspp {
	SSPP_NONE = 0,
	SSPP_VIG0 = 1,
	SSPP_VIG1 = 2,
	SSPP_VIG2 = 3,
	SSPP_VIG3 = 4,
	SSPP_RGB0 = 5,
	SSPP_RGB1 = 6,
	SSPP_RGB2 = 7,
	SSPP_RGB3 = 8,
	SSPP_DMA0 = 9,
	SSPP_DMA1 = 10,
	SSPP_DMA2 = 11,
	SSPP_DMA3 = 12,
	SSPP_DMA4 = 13,
	SSPP_DMA5 = 14,
	SSPP_CURSOR0 = 15,
	SSPP_CURSOR1 = 16,
	SSPP_MAX = 17,
};

enum dpu_sspp_multirect_index {
	DPU_SSPP_RECT_SOLO = 0,
	DPU_SSPP_RECT_0 = 1,
	DPU_SSPP_RECT_1 = 2,
};

enum dpu_sspp_multirect_mode {
	DPU_SSPP_MULTIRECT_NONE = 0,
	DPU_SSPP_MULTIRECT_PARALLEL = 1,
	DPU_SSPP_MULTIRECT_TIME_MX = 2,
};

enum dpu_sspp_type {
	SSPP_TYPE_VIG = 0,
	SSPP_TYPE_RGB = 1,
	SSPP_TYPE_DMA = 2,
	SSPP_TYPE_CURSOR = 3,
	SSPP_TYPE_MAX = 4,
};

enum dpu_stage {
	DPU_STAGE_BASE = 0,
	DPU_STAGE_0 = 1,
	DPU_STAGE_1 = 2,
	DPU_STAGE_2 = 3,
	DPU_STAGE_3 = 4,
	DPU_STAGE_4 = 5,
	DPU_STAGE_5 = 6,
	DPU_STAGE_6 = 7,
	DPU_STAGE_7 = 8,
	DPU_STAGE_8 = 9,
	DPU_STAGE_9 = 10,
	DPU_STAGE_10 = 11,
	DPU_STAGE_MAX = 12,
};

enum dpu_vbif {
	VBIF_RT = 0,
	VBIF_NRT = 1,
	VBIF_MAX = 2,
};

enum dpu_vsync_source {
	DPU_VSYNC_SOURCE_GPIO_0 = 0,
	DPU_VSYNC_SOURCE_GPIO_1 = 1,
	DPU_VSYNC_SOURCE_GPIO_2 = 2,
	DPU_VSYNC_SOURCE_INTF_0 = 3,
	DPU_VSYNC_SOURCE_INTF_1 = 4,
	DPU_VSYNC_SOURCE_INTF_2 = 5,
	DPU_VSYNC_SOURCE_INTF_3 = 6,
	DPU_VSYNC_SOURCE_WD_TIMER_4 = 11,
	DPU_VSYNC_SOURCE_WD_TIMER_3 = 12,
	DPU_VSYNC_SOURCE_WD_TIMER_2 = 13,
	DPU_VSYNC_SOURCE_WD_TIMER_1 = 14,
	DPU_VSYNC_SOURCE_WD_TIMER_0 = 15,
};

enum dpu_wb {
	WB_0 = 1,
	WB_1 = 2,
	WB_2 = 3,
	WB_3 = 4,
	WB_MAX = 5,
};

enum drbg_prefixes {
	DRBG_PREFIX0 = 0,
	DRBG_PREFIX1 = 1,
	DRBG_PREFIX2 = 2,
	DRBG_PREFIX3 = 3,
};

enum drbg_seed_state {
	DRBG_SEED_STATE_UNSEEDED = 0,
	DRBG_SEED_STATE_PARTIAL = 1,
	DRBG_SEED_STATE_FULL = 2,
};

enum drm_bridge_attach_flags {
	DRM_BRIDGE_ATTACH_NO_CONNECTOR = 1,
};

enum drm_bridge_ops {
	DRM_BRIDGE_OP_DETECT = 1,
	DRM_BRIDGE_OP_EDID = 2,
	DRM_BRIDGE_OP_HPD = 4,
	DRM_BRIDGE_OP_MODES = 8,
	DRM_BRIDGE_OP_HDMI = 16,
	DRM_BRIDGE_OP_HDMI_AUDIO = 32,
	DRM_BRIDGE_OP_DP_AUDIO = 64,
};

enum drm_bus_flags {
	DRM_BUS_FLAG_DE_LOW = 1,
	DRM_BUS_FLAG_DE_HIGH = 2,
	DRM_BUS_FLAG_PIXDATA_DRIVE_POSEDGE = 4,
	DRM_BUS_FLAG_PIXDATA_DRIVE_NEGEDGE = 8,
	DRM_BUS_FLAG_PIXDATA_SAMPLE_POSEDGE = 8,
	DRM_BUS_FLAG_PIXDATA_SAMPLE_NEGEDGE = 4,
	DRM_BUS_FLAG_DATA_MSB_TO_LSB = 16,
	DRM_BUS_FLAG_DATA_LSB_TO_MSB = 32,
	DRM_BUS_FLAG_SYNC_DRIVE_POSEDGE = 64,
	DRM_BUS_FLAG_SYNC_DRIVE_NEGEDGE = 128,
	DRM_BUS_FLAG_SYNC_SAMPLE_POSEDGE = 128,
	DRM_BUS_FLAG_SYNC_SAMPLE_NEGEDGE = 64,
	DRM_BUS_FLAG_SHARP_SIGNALS = 256,
};

enum drm_color_encoding {
	DRM_COLOR_YCBCR_BT601 = 0,
	DRM_COLOR_YCBCR_BT709 = 1,
	DRM_COLOR_YCBCR_BT2020 = 2,
	DRM_COLOR_ENCODING_MAX = 3,
};

enum drm_color_lut_tests {
	DRM_COLOR_LUT_EQUAL_CHANNELS = 1,
	DRM_COLOR_LUT_NON_DECREASING = 2,
};

enum drm_color_range {
	DRM_COLOR_YCBCR_LIMITED_RANGE = 0,
	DRM_COLOR_YCBCR_FULL_RANGE = 1,
	DRM_COLOR_RANGE_MAX = 2,
};

enum drm_colorspace {
	DRM_MODE_COLORIMETRY_DEFAULT = 0,
	DRM_MODE_COLORIMETRY_NO_DATA = 0,
	DRM_MODE_COLORIMETRY_SMPTE_170M_YCC = 1,
	DRM_MODE_COLORIMETRY_BT709_YCC = 2,
	DRM_MODE_COLORIMETRY_XVYCC_601 = 3,
	DRM_MODE_COLORIMETRY_XVYCC_709 = 4,
	DRM_MODE_COLORIMETRY_SYCC_601 = 5,
	DRM_MODE_COLORIMETRY_OPYCC_601 = 6,
	DRM_MODE_COLORIMETRY_OPRGB = 7,
	DRM_MODE_COLORIMETRY_BT2020_CYCC = 8,
	DRM_MODE_COLORIMETRY_BT2020_RGB = 9,
	DRM_MODE_COLORIMETRY_BT2020_YCC = 10,
	DRM_MODE_COLORIMETRY_DCI_P3_RGB_D65 = 11,
	DRM_MODE_COLORIMETRY_DCI_P3_RGB_THEATER = 12,
	DRM_MODE_COLORIMETRY_RGB_WIDE_FIXED = 13,
	DRM_MODE_COLORIMETRY_RGB_WIDE_FLOAT = 14,
	DRM_MODE_COLORIMETRY_BT601_YCC = 15,
	DRM_MODE_COLORIMETRY_COUNT = 16,
};

enum drm_connector_force {
	DRM_FORCE_UNSPECIFIED = 0,
	DRM_FORCE_OFF = 1,
	DRM_FORCE_ON = 2,
	DRM_FORCE_ON_DIGITAL = 3,
};

enum drm_connector_registration_state {
	DRM_CONNECTOR_INITIALIZING = 0,
	DRM_CONNECTOR_REGISTERED = 1,
	DRM_CONNECTOR_UNREGISTERED = 2,
};

enum drm_connector_status {
	connector_status_connected = 1,
	connector_status_disconnected = 2,
	connector_status_unknown = 3,
};

enum drm_connector_tv_mode {
	DRM_MODE_TV_MODE_NTSC = 0,
	DRM_MODE_TV_MODE_NTSC_443 = 1,
	DRM_MODE_TV_MODE_NTSC_J = 2,
	DRM_MODE_TV_MODE_PAL = 3,
	DRM_MODE_TV_MODE_PAL_M = 4,
	DRM_MODE_TV_MODE_PAL_N = 5,
	DRM_MODE_TV_MODE_SECAM = 6,
	DRM_MODE_TV_MODE_MONOCHROME = 7,
	DRM_MODE_TV_MODE_MAX = 8,
};

enum drm_debug_category {
	DRM_UT_CORE = 0,
	DRM_UT_DRIVER = 1,
	DRM_UT_KMS = 2,
	DRM_UT_PRIME = 3,
	DRM_UT_ATOMIC = 4,
	DRM_UT_VBL = 5,
	DRM_UT_STATE = 6,
	DRM_UT_LEASE = 7,
	DRM_UT_DP = 8,
	DRM_UT_DRMRES = 9,
};

enum drm_dp_dual_mode_type {
	DRM_DP_DUAL_MODE_NONE = 0,
	DRM_DP_DUAL_MODE_UNKNOWN = 1,
	DRM_DP_DUAL_MODE_TYPE1_DVI = 2,
	DRM_DP_DUAL_MODE_TYPE1_HDMI = 3,
	DRM_DP_DUAL_MODE_TYPE2_DVI = 4,
	DRM_DP_DUAL_MODE_TYPE2_HDMI = 5,
	DRM_DP_DUAL_MODE_LSPCON = 6,
};

enum drm_dp_mst_mode {
	DRM_DP_SST = 0,
	DRM_DP_MST = 1,
	DRM_DP_SST_SIDEBAND_MSG = 2,
};

enum drm_dp_mst_payload_allocation {
	DRM_DP_MST_PAYLOAD_ALLOCATION_NONE = 0,
	DRM_DP_MST_PAYLOAD_ALLOCATION_LOCAL = 1,
	DRM_DP_MST_PAYLOAD_ALLOCATION_DFP = 2,
	DRM_DP_MST_PAYLOAD_ALLOCATION_REMOTE = 3,
};

enum drm_dp_phy {
	DP_PHY_DPRX = 0,
	DP_PHY_LTTPR1 = 1,
	DP_PHY_LTTPR2 = 2,
	DP_PHY_LTTPR3 = 3,
	DP_PHY_LTTPR4 = 4,
	DP_PHY_LTTPR5 = 5,
	DP_PHY_LTTPR6 = 6,
	DP_PHY_LTTPR7 = 7,
	DP_PHY_LTTPR8 = 8,
	DP_MAX_LTTPR_COUNT = 8,
};

enum drm_dp_quirk {
	DP_DPCD_QUIRK_CONSTANT_N = 0,
	DP_DPCD_QUIRK_NO_PSR = 1,
	DP_DPCD_QUIRK_NO_SINK_COUNT = 2,
	DP_DPCD_QUIRK_DSC_WITHOUT_VIRTUAL_DPCD = 3,
	DP_DPCD_QUIRK_CAN_DO_MAX_LINK_RATE_3_24_GBPS = 4,
	DP_DPCD_QUIRK_HBLANK_EXPANSION_REQUIRES_DSC = 5,
};

enum drm_driver_feature {
	DRIVER_GEM = 1,
	DRIVER_MODESET = 2,
	DRIVER_RENDER = 8,
	DRIVER_ATOMIC = 16,
	DRIVER_SYNCOBJ = 32,
	DRIVER_SYNCOBJ_TIMELINE = 64,
	DRIVER_COMPUTE_ACCEL = 128,
	DRIVER_GEM_GPUVA = 256,
	DRIVER_CURSOR_HOTSPOT = 512,
	DRIVER_USE_AGP = 33554432,
	DRIVER_LEGACY = 67108864,
	DRIVER_PCI_DMA = 134217728,
	DRIVER_SG = 268435456,
	DRIVER_HAVE_DMA = 536870912,
	DRIVER_HAVE_IRQ = 1073741824,
};

enum drm_dsc_params_type {
	DRM_DSC_1_2_444 = 0,
	DRM_DSC_1_1_PRE_SCR = 1,
	DRM_DSC_1_2_422 = 2,
	DRM_DSC_1_2_420 = 3,
};

enum drm_gem_object_status {
	DRM_GEM_OBJECT_RESIDENT = 1,
	DRM_GEM_OBJECT_PURGEABLE = 2,
	DRM_GEM_OBJECT_ACTIVE = 4,
};

enum drm_gpu_sched_stat {
	DRM_GPU_SCHED_STAT_NONE = 0,
	DRM_GPU_SCHED_STAT_NOMINAL = 1,
	DRM_GPU_SCHED_STAT_ENODEV = 2,
};

enum drm_gpuva_flags {
	DRM_GPUVA_INVALIDATED = 1,
	DRM_GPUVA_SPARSE = 2,
	DRM_GPUVA_USERBITS = 4,
};

enum drm_gpuva_op_type {
	DRM_GPUVA_OP_MAP = 0,
	DRM_GPUVA_OP_REMAP = 1,
	DRM_GPUVA_OP_UNMAP = 2,
	DRM_GPUVA_OP_PREFETCH = 3,
	DRM_GPUVA_OP_DRIVER = 4,
};

enum drm_gpuvm_flags {
	DRM_GPUVM_RESV_PROTECTED = 1,
	DRM_GPUVM_USERBITS = 2,
};

enum drm_hdmi_broadcast_rgb {
	DRM_HDMI_BROADCAST_RGB_AUTO = 0,
	DRM_HDMI_BROADCAST_RGB_FULL = 1,
	DRM_HDMI_BROADCAST_RGB_LIMITED = 2,
};

enum drm_ioctl_flags {
	DRM_AUTH = 1,
	DRM_MASTER = 2,
	DRM_ROOT_ONLY = 4,
	DRM_RENDER_ALLOW = 32,
};

enum drm_link_status {
	DRM_LINK_STATUS_GOOD = 0,
	DRM_LINK_STATUS_BAD = 1,
};

enum drm_lspcon_mode {
	DRM_LSPCON_MODE_INVALID = 0,
	DRM_LSPCON_MODE_LS = 1,
	DRM_LSPCON_MODE_PCON = 2,
};

enum drm_lvds_dual_link_pixels {
	DRM_LVDS_DUAL_LINK_EVEN_ODD_PIXELS = 0,
	DRM_LVDS_DUAL_LINK_ODD_EVEN_PIXELS = 1,
};

enum drm_minor_type {
	DRM_MINOR_PRIMARY = 0,
	DRM_MINOR_CONTROL = 1,
	DRM_MINOR_RENDER = 2,
	DRM_MINOR_ACCEL = 32,
};

enum drm_mm_insert_mode {
	DRM_MM_INSERT_BEST = 0,
	DRM_MM_INSERT_LOW = 1,
	DRM_MM_INSERT_HIGH = 2,
	DRM_MM_INSERT_EVICT = 3,
	DRM_MM_INSERT_ONCE = 2147483648,
	DRM_MM_INSERT_HIGHEST = 2147483650,
	DRM_MM_INSERT_LOWEST = 2147483649,
};

enum drm_mode_analog {
	DRM_MODE_ANALOG_NTSC = 0,
	DRM_MODE_ANALOG_PAL = 1,
};

enum drm_mode_status {
	MODE_OK = 0,
	MODE_HSYNC = 1,
	MODE_VSYNC = 2,
	MODE_H_ILLEGAL = 3,
	MODE_V_ILLEGAL = 4,
	MODE_BAD_WIDTH = 5,
	MODE_NOMODE = 6,
	MODE_NO_INTERLACE = 7,
	MODE_NO_DBLESCAN = 8,
	MODE_NO_VSCAN = 9,
	MODE_MEM = 10,
	MODE_VIRTUAL_X = 11,
	MODE_VIRTUAL_Y = 12,
	MODE_MEM_VIRT = 13,
	MODE_NOCLOCK = 14,
	MODE_CLOCK_HIGH = 15,
	MODE_CLOCK_LOW = 16,
	MODE_CLOCK_RANGE = 17,
	MODE_BAD_HVALUE = 18,
	MODE_BAD_VVALUE = 19,
	MODE_BAD_VSCAN = 20,
	MODE_HSYNC_NARROW = 21,
	MODE_HSYNC_WIDE = 22,
	MODE_HBLANK_NARROW = 23,
	MODE_HBLANK_WIDE = 24,
	MODE_VSYNC_NARROW = 25,
	MODE_VSYNC_WIDE = 26,
	MODE_VBLANK_NARROW = 27,
	MODE_VBLANK_WIDE = 28,
	MODE_PANEL = 29,
	MODE_INTERLACE_WIDTH = 30,
	MODE_ONE_WIDTH = 31,
	MODE_ONE_HEIGHT = 32,
	MODE_ONE_SIZE = 33,
	MODE_NO_REDUCED = 34,
	MODE_NO_STEREO = 35,
	MODE_NO_420 = 36,
	MODE_STALE = -3,
	MODE_BAD = -2,
	MODE_ERROR = -1,
};

enum drm_mode_subconnector {
	DRM_MODE_SUBCONNECTOR_Automatic = 0,
	DRM_MODE_SUBCONNECTOR_Unknown = 0,
	DRM_MODE_SUBCONNECTOR_VGA = 1,
	DRM_MODE_SUBCONNECTOR_DVID = 3,
	DRM_MODE_SUBCONNECTOR_DVIA = 4,
	DRM_MODE_SUBCONNECTOR_Composite = 5,
	DRM_MODE_SUBCONNECTOR_SVIDEO = 6,
	DRM_MODE_SUBCONNECTOR_Component = 8,
	DRM_MODE_SUBCONNECTOR_SCART = 9,
	DRM_MODE_SUBCONNECTOR_DisplayPort = 10,
	DRM_MODE_SUBCONNECTOR_HDMIA = 11,
	DRM_MODE_SUBCONNECTOR_Native = 15,
	DRM_MODE_SUBCONNECTOR_Wireless = 18,
};

enum drm_of_lvds_pixels {
	DRM_OF_LVDS_EVEN = 1,
	DRM_OF_LVDS_ODD = 2,
};

enum drm_panel_orientation {
	DRM_MODE_PANEL_ORIENTATION_UNKNOWN = -1,
	DRM_MODE_PANEL_ORIENTATION_NORMAL = 0,
	DRM_MODE_PANEL_ORIENTATION_BOTTOM_UP = 1,
	DRM_MODE_PANEL_ORIENTATION_LEFT_UP = 2,
	DRM_MODE_PANEL_ORIENTATION_RIGHT_UP = 3,
};

enum drm_plane_type {
	DRM_PLANE_TYPE_OVERLAY = 0,
	DRM_PLANE_TYPE_PRIMARY = 1,
	DRM_PLANE_TYPE_CURSOR = 2,
};

enum drm_privacy_screen_status {
	PRIVACY_SCREEN_DISABLED = 0,
	PRIVACY_SCREEN_ENABLED = 1,
	PRIVACY_SCREEN_DISABLED_LOCKED = 2,
	PRIVACY_SCREEN_ENABLED_LOCKED = 3,
};

enum drm_scaling_filter {
	DRM_SCALING_FILTER_DEFAULT = 0,
	DRM_SCALING_FILTER_NEAREST_NEIGHBOR = 1,
};

enum drm_sched_priority {
	DRM_SCHED_PRIORITY_KERNEL = 0,
	DRM_SCHED_PRIORITY_HIGH = 1,
	DRM_SCHED_PRIORITY_NORMAL = 2,
	DRM_SCHED_PRIORITY_LOW = 3,
	DRM_SCHED_PRIORITY_COUNT = 4,
};

enum drm_stat_type {
	_DRM_STAT_LOCK = 0,
	_DRM_STAT_OPENS = 1,
	_DRM_STAT_CLOSES = 2,
	_DRM_STAT_IOCTLS = 3,
	_DRM_STAT_LOCKS = 4,
	_DRM_STAT_UNLOCKS = 5,
	_DRM_STAT_VALUE = 6,
	_DRM_STAT_BYTE = 7,
	_DRM_STAT_COUNT = 8,
	_DRM_STAT_IRQ = 9,
	_DRM_STAT_PRIMARY = 10,
	_DRM_STAT_SECONDARY = 11,
	_DRM_STAT_DMA = 12,
	_DRM_STAT_SPECIAL = 13,
	_DRM_STAT_MISSED = 14,
};

enum drm_vblank_seq_type {
	_DRM_VBLANK_ABSOLUTE = 0,
	_DRM_VBLANK_RELATIVE = 1,
	_DRM_VBLANK_HIGH_CRTC_MASK = 62,
	_DRM_VBLANK_EVENT = 67108864,
	_DRM_VBLANK_FLIP = 134217728,
	_DRM_VBLANK_NEXTONMISS = 268435456,
	_DRM_VBLANK_SECONDARY = 536870912,
	_DRM_VBLANK_SIGNAL = 1073741824,
};

enum drvtype {
	LEGACY = 0,
	SYSCON = 1,
};

enum ds_type {
	unknown_ds_type = 0,
	ds_1307 = 1,
	ds_1308 = 2,
	ds_1337 = 3,
	ds_1338 = 4,
	ds_1339 = 5,
	ds_1340 = 6,
	ds_1341 = 7,
	ds_1388 = 8,
	ds_3231 = 9,
	m41t0 = 10,
	m41t00 = 11,
	m41t11 = 12,
	mcp794xx = 13,
	rx_8025 = 14,
	rx_8130 = 15,
	last_ds_type = 16,
};

enum dsa_db_type {
	DSA_DB_PORT = 0,
	DSA_DB_LAG = 1,
	DSA_DB_BRIDGE = 2,
};

enum dsa_tag_protocol {
	DSA_TAG_PROTO_NONE = 0,
	DSA_TAG_PROTO_BRCM = 1,
	DSA_TAG_PROTO_BRCM_LEGACY = 22,
	DSA_TAG_PROTO_BRCM_PREPEND = 2,
	DSA_TAG_PROTO_DSA = 3,
	DSA_TAG_PROTO_EDSA = 4,
	DSA_TAG_PROTO_GSWIP = 5,
	DSA_TAG_PROTO_KSZ9477 = 6,
	DSA_TAG_PROTO_KSZ9893 = 7,
	DSA_TAG_PROTO_LAN9303 = 8,
	DSA_TAG_PROTO_MTK = 9,
	DSA_TAG_PROTO_QCA = 10,
	DSA_TAG_PROTO_TRAILER = 11,
	DSA_TAG_PROTO_8021Q = 12,
	DSA_TAG_PROTO_SJA1105 = 13,
	DSA_TAG_PROTO_KSZ8795 = 14,
	DSA_TAG_PROTO_OCELOT = 15,
	DSA_TAG_PROTO_AR9331 = 16,
	DSA_TAG_PROTO_RTL4_A = 17,
	DSA_TAG_PROTO_HELLCREEK = 18,
	DSA_TAG_PROTO_XRS700X = 19,
	DSA_TAG_PROTO_OCELOT_8021Q = 20,
	DSA_TAG_PROTO_SEVILLE = 21,
	DSA_TAG_PROTO_SJA1110 = 23,
	DSA_TAG_PROTO_RTL8_4 = 24,
	DSA_TAG_PROTO_RTL8_4T = 25,
	DSA_TAG_PROTO_RZN1_A5PSW = 26,
	DSA_TAG_PROTO_LAN937X = 27,
	DSA_TAG_PROTO_VSC73XX_8021Q = 28,
};

enum dsi_cmd_dst_format {
	CMD_DST_FORMAT_RGB111 = 0,
	CMD_DST_FORMAT_RGB332 = 3,
	CMD_DST_FORMAT_RGB444 = 4,
	CMD_DST_FORMAT_RGB565 = 6,
	CMD_DST_FORMAT_RGB666 = 7,
	CMD_DST_FORMAT_RGB888 = 8,
};

enum dsi_cmd_trigger {
	TRIGGER_NONE = 0,
	TRIGGER_SEOF = 1,
	TRIGGER_TE = 2,
	TRIGGER_SW = 4,
	TRIGGER_SW_SEOF = 5,
	TRIGGER_SW_TE = 6,
};

enum dsi_lane_swap {
	LANE_SWAP_0123 = 0,
	LANE_SWAP_3012 = 1,
	LANE_SWAP_2301 = 2,
	LANE_SWAP_1230 = 3,
	LANE_SWAP_0321 = 4,
	LANE_SWAP_1032 = 5,
	LANE_SWAP_2103 = 6,
	LANE_SWAP_3210 = 7,
};

enum dsi_rgb_swap {
	SWAP_RGB = 0,
	SWAP_RBG = 1,
	SWAP_BGR = 2,
	SWAP_BRG = 3,
	SWAP_GRB = 4,
	SWAP_GBR = 5,
};

enum dsi_traffic_mode {
	NON_BURST_SYNCH_PULSE = 0,
	NON_BURST_SYNCH_EVENT = 1,
	BURST_MODE = 2,
};

enum dsi_vid_dst_format {
	VID_DST_FORMAT_RGB565 = 0,
	VID_DST_FORMAT_RGB666 = 1,
	VID_DST_FORMAT_RGB666_LOOSE = 2,
	VID_DST_FORMAT_RGB888 = 3,
};

enum dspi_trans_mode {
	DSPI_XSPI_MODE = 0,
	DSPI_DMA_MODE = 1,
};

enum dvb_device_type {
	DVB_DEVICE_SEC = 0,
	DVB_DEVICE_FRONTEND = 1,
	DVB_DEVICE_DEMUX = 2,
	DVB_DEVICE_DVR = 3,
	DVB_DEVICE_CA = 4,
	DVB_DEVICE_NET = 5,
	DVB_DEVICE_VIDEO = 6,
	DVB_DEVICE_AUDIO = 7,
	DVB_DEVICE_OSD = 8,
};

enum dvb_dmx_filter_type {
	DMX_TYPE_TS = 0,
	DMX_TYPE_SEC = 1,
};

enum dvb_dmx_state {
	DMX_STATE_FREE = 0,
	DMX_STATE_ALLOCATED = 1,
	DMX_STATE_READY = 2,
	DMX_STATE_GO = 3,
};

enum dvbfe_algo {
	DVBFE_ALGO_HW = 1,
	DVBFE_ALGO_SW = 2,
	DVBFE_ALGO_CUSTOM = 4,
	DVBFE_ALGO_RECOVERY = 2147483648,
};

enum dvbfe_search {
	DVBFE_ALGO_SEARCH_SUCCESS = 1,
	DVBFE_ALGO_SEARCH_ASLEEP = 2,
	DVBFE_ALGO_SEARCH_FAILED = 4,
	DVBFE_ALGO_SEARCH_INVALID = 8,
	DVBFE_ALGO_SEARCH_AGAIN = 16,
	DVBFE_ALGO_SEARCH_ERROR = 2147483648,
};

enum dvbv3_emulation_type {
	DVBV3_UNKNOWN = 0,
	DVBV3_QPSK = 1,
	DVBV3_QAM = 2,
	DVBV3_OFDM = 3,
	DVBV3_ATSC = 4,
};

enum dw_edma_chip_flags {
	DW_EDMA_CHIP_LOCAL = 1,
};

enum dw_edma_map_format {
	EDMA_MF_EDMA_LEGACY = 0,
	EDMA_MF_EDMA_UNROLL = 1,
	EDMA_MF_HDMA_COMPAT = 5,
	EDMA_MF_HDMA_NATIVE = 7,
};

enum dw_hdmi_phy_type {
	DW_HDMI_PHY_DWC_HDMI_TX_PHY = 0,
	DW_HDMI_PHY_DWC_MHL_PHY_HEAC = 178,
	DW_HDMI_PHY_DWC_MHL_PHY = 194,
	DW_HDMI_PHY_DWC_HDMI_3D_TX_PHY_HEAC = 226,
	DW_HDMI_PHY_DWC_HDMI_3D_TX_PHY = 242,
	DW_HDMI_PHY_DWC_HDMI20_TX_PHY = 243,
	DW_HDMI_PHY_VENDOR_PHY = 254,
};

enum dw_mci_cookie {
	COOKIE_UNMAPPED = 0,
	COOKIE_PRE_MAPPED = 1,
	COOKIE_MAPPED = 2,
};

enum dw_mci_exynos_type {
	DW_MCI_TYPE_EXYNOS4210 = 0,
	DW_MCI_TYPE_EXYNOS4412 = 1,
	DW_MCI_TYPE_EXYNOS5250 = 2,
	DW_MCI_TYPE_EXYNOS5420 = 3,
	DW_MCI_TYPE_EXYNOS5420_SMU = 4,
	DW_MCI_TYPE_EXYNOS7 = 5,
	DW_MCI_TYPE_EXYNOS7_SMU = 6,
	DW_MCI_TYPE_EXYNOS7870 = 7,
	DW_MCI_TYPE_EXYNOS7870_SMU = 8,
	DW_MCI_TYPE_ARTPEC8 = 9,
};

enum dw_mci_state {
	STATE_IDLE___2 = 0,
	STATE_SENDING_CMD = 1,
	STATE_SENDING_DATA = 2,
	STATE_DATA_BUSY = 3,
	STATE_SENDING_STOP = 4,
	STATE_DATA_ERROR = 5,
	STATE_SENDING_CMD11 = 6,
	STATE_WAITING_CMD11_DONE = 7,
};

enum dw_pcie_app_clk {
	DW_PCIE_DBI_CLK = 0,
	DW_PCIE_MSTR_CLK = 1,
	DW_PCIE_SLV_CLK = 2,
	DW_PCIE_NUM_APP_CLKS = 3,
};

enum dw_pcie_app_rst {
	DW_PCIE_DBI_RST = 0,
	DW_PCIE_MSTR_RST = 1,
	DW_PCIE_SLV_RST = 2,
	DW_PCIE_NUM_APP_RSTS = 3,
};

enum dw_pcie_core_clk {
	DW_PCIE_PIPE_CLK = 0,
	DW_PCIE_CORE_CLK = 1,
	DW_PCIE_AUX_CLK = 2,
	DW_PCIE_REF_CLK = 3,
	DW_PCIE_NUM_CORE_CLKS = 4,
};

enum dw_pcie_core_rst {
	DW_PCIE_NON_STICKY_RST = 0,
	DW_PCIE_STICKY_RST = 1,
	DW_PCIE_CORE_RST = 2,
	DW_PCIE_PIPE_RST = 3,
	DW_PCIE_PHY_RST = 4,
	DW_PCIE_HOT_RST = 5,
	DW_PCIE_PWR_RST = 6,
	DW_PCIE_NUM_CORE_RSTS = 7,
};

enum dw_pcie_device_mode {
	DW_PCIE_UNKNOWN_TYPE = 0,
	DW_PCIE_EP_TYPE = 1,
	DW_PCIE_LEG_EP_TYPE = 2,
	DW_PCIE_RC_TYPE = 3,
};

enum dw_pcie_ltssm {
	DW_PCIE_LTSSM_DETECT_QUIET = 0,
	DW_PCIE_LTSSM_DETECT_ACT = 1,
	DW_PCIE_LTSSM_POLL_ACTIVE = 2,
	DW_PCIE_LTSSM_POLL_COMPLIANCE = 3,
	DW_PCIE_LTSSM_POLL_CONFIG = 4,
	DW_PCIE_LTSSM_PRE_DETECT_QUIET = 5,
	DW_PCIE_LTSSM_DETECT_WAIT = 6,
	DW_PCIE_LTSSM_CFG_LINKWD_START = 7,
	DW_PCIE_LTSSM_CFG_LINKWD_ACEPT = 8,
	DW_PCIE_LTSSM_CFG_LANENUM_WAI = 9,
	DW_PCIE_LTSSM_CFG_LANENUM_ACEPT = 10,
	DW_PCIE_LTSSM_CFG_COMPLETE = 11,
	DW_PCIE_LTSSM_CFG_IDLE = 12,
	DW_PCIE_LTSSM_RCVRY_LOCK = 13,
	DW_PCIE_LTSSM_RCVRY_SPEED = 14,
	DW_PCIE_LTSSM_RCVRY_RCVRCFG = 15,
	DW_PCIE_LTSSM_RCVRY_IDLE = 16,
	DW_PCIE_LTSSM_L0 = 17,
	DW_PCIE_LTSSM_L0S = 18,
	DW_PCIE_LTSSM_L123_SEND_EIDLE = 19,
	DW_PCIE_LTSSM_L1_IDLE = 20,
	DW_PCIE_LTSSM_L2_IDLE = 21,
	DW_PCIE_LTSSM_L2_WAKE = 22,
	DW_PCIE_LTSSM_DISABLED_ENTRY = 23,
	DW_PCIE_LTSSM_DISABLED_IDLE = 24,
	DW_PCIE_LTSSM_DISABLED = 25,
	DW_PCIE_LTSSM_LPBK_ENTRY = 26,
	DW_PCIE_LTSSM_LPBK_ACTIVE = 27,
	DW_PCIE_LTSSM_LPBK_EXIT = 28,
	DW_PCIE_LTSSM_LPBK_EXIT_TIMEOUT = 29,
	DW_PCIE_LTSSM_HOT_RESET_ENTRY = 30,
	DW_PCIE_LTSSM_HOT_RESET = 31,
	DW_PCIE_LTSSM_RCVRY_EQ0 = 32,
	DW_PCIE_LTSSM_RCVRY_EQ1 = 33,
	DW_PCIE_LTSSM_RCVRY_EQ2 = 34,
	DW_PCIE_LTSSM_RCVRY_EQ3 = 35,
	DW_PCIE_LTSSM_UNKNOWN = 4294967295,
};

enum dwc2_control_phase {
	DWC2_CONTROL_SETUP = 0,
	DWC2_CONTROL_DATA = 1,
	DWC2_CONTROL_STATUS = 2,
};

enum dwc2_ep0_state {
	DWC2_EP0_SETUP = 0,
	DWC2_EP0_DATA_IN = 1,
	DWC2_EP0_DATA_OUT = 2,
	DWC2_EP0_STATUS_IN = 3,
	DWC2_EP0_STATUS_OUT = 4,
};

enum dwc2_halt_status {
	DWC2_HC_XFER_NO_HALT_STATUS = 0,
	DWC2_HC_XFER_COMPLETE = 1,
	DWC2_HC_XFER_URB_COMPLETE = 2,
	DWC2_HC_XFER_ACK = 3,
	DWC2_HC_XFER_NAK = 4,
	DWC2_HC_XFER_NYET = 5,
	DWC2_HC_XFER_STALL = 6,
	DWC2_HC_XFER_XACT_ERR = 7,
	DWC2_HC_XFER_FRAME_OVERRUN = 8,
	DWC2_HC_XFER_BABBLE_ERR = 9,
	DWC2_HC_XFER_DATA_TOGGLE_ERR = 10,
	DWC2_HC_XFER_AHB_ERR = 11,
	DWC2_HC_XFER_PERIODIC_INCOMPLETE = 12,
	DWC2_HC_XFER_URB_DEQUEUE = 13,
};

enum dwc2_hsotg_dmamode {
	S3C_HSOTG_DMA_NONE = 0,
	S3C_HSOTG_DMA_ONLY = 1,
	S3C_HSOTG_DMA_DRV = 2,
};

enum dwc2_lx_state {
	DWC2_L0 = 0,
	DWC2_L1 = 1,
	DWC2_L2 = 2,
	DWC2_L3 = 3,
};

enum dwc2_transaction_type {
	DWC2_TRANSACTION_NONE = 0,
	DWC2_TRANSACTION_PERIODIC = 1,
	DWC2_TRANSACTION_NON_PERIODIC = 2,
	DWC2_TRANSACTION_ALL = 3,
};

enum dwc3_ep0_next {
	DWC3_EP0_UNKNOWN = 0,
	DWC3_EP0_COMPLETE = 1,
	DWC3_EP0_NRDY_DATA = 2,
	DWC3_EP0_NRDY_STATUS = 3,
};

enum dwc3_ep0_state {
	EP0_UNCONNECTED = 0,
	EP0_SETUP_PHASE = 1,
	EP0_DATA_PHASE = 2,
	EP0_STATUS_PHASE = 3,
};

enum dwc3_link_state {
	DWC3_LINK_STATE_U0 = 0,
	DWC3_LINK_STATE_U1 = 1,
	DWC3_LINK_STATE_U2 = 2,
	DWC3_LINK_STATE_U3 = 3,
	DWC3_LINK_STATE_SS_DIS = 4,
	DWC3_LINK_STATE_RX_DET = 5,
	DWC3_LINK_STATE_SS_INACT = 6,
	DWC3_LINK_STATE_POLL = 7,
	DWC3_LINK_STATE_RECOV = 8,
	DWC3_LINK_STATE_HRESET = 9,
	DWC3_LINK_STATE_CMPLY = 10,
	DWC3_LINK_STATE_LPBK = 11,
	DWC3_LINK_STATE_RESET = 14,
	DWC3_LINK_STATE_RESUME = 15,
	DWC3_LINK_STATE_MASK = 15,
};

enum dwc3_omap_utmi_mode {
	DWC3_OMAP_UTMI_MODE_UNKNOWN = 0,
	DWC3_OMAP_UTMI_MODE_HW = 1,
	DWC3_OMAP_UTMI_MODE_SW = 2,
};

enum dynamic_range {
	VESA = 0,
	CEA = 1,
};

enum e_drm_exynos_gem_mem_type {
	EXYNOS_BO_CONTIG = 0,
	EXYNOS_BO_NONCONTIG = 1,
	EXYNOS_BO_NONCACHABLE = 0,
	EXYNOS_BO_CACHABLE = 2,
	EXYNOS_BO_WC = 4,
	EXYNOS_BO_MASK = 7,
};

enum ec_comms_status {
	EC_COMMS_STATUS_PROCESSING = 1,
};

enum ec_feature_code {
	EC_FEATURE_LIMITED = 0,
	EC_FEATURE_FLASH = 1,
	EC_FEATURE_PWM_FAN = 2,
	EC_FEATURE_PWM_KEYB = 3,
	EC_FEATURE_LIGHTBAR = 4,
	EC_FEATURE_LED = 5,
	EC_FEATURE_MOTION_SENSE = 6,
	EC_FEATURE_KEYB = 7,
	EC_FEATURE_PSTORE = 8,
	EC_FEATURE_PORT80 = 9,
	EC_FEATURE_THERMAL = 10,
	EC_FEATURE_BKLIGHT_SWITCH = 11,
	EC_FEATURE_WIFI_SWITCH = 12,
	EC_FEATURE_HOST_EVENTS = 13,
	EC_FEATURE_GPIO = 14,
	EC_FEATURE_I2C = 15,
	EC_FEATURE_CHARGER = 16,
	EC_FEATURE_BATTERY = 17,
	EC_FEATURE_SMART_BATTERY = 18,
	EC_FEATURE_HANG_DETECT = 19,
	EC_FEATURE_PMU = 20,
	EC_FEATURE_SUB_MCU = 21,
	EC_FEATURE_USB_PD = 22,
	EC_FEATURE_USB_MUX = 23,
	EC_FEATURE_MOTION_SENSE_FIFO = 24,
	EC_FEATURE_VSTORE = 25,
	EC_FEATURE_USBC_SS_MUX_VIRTUAL = 26,
	EC_FEATURE_RTC = 27,
	EC_FEATURE_FINGERPRINT = 28,
	EC_FEATURE_TOUCHPAD = 29,
	EC_FEATURE_RWSIG = 30,
	EC_FEATURE_DEVICE_EVENT = 31,
	EC_FEATURE_UNIFIED_WAKE_MASKS = 32,
	EC_FEATURE_HOST_EVENT64 = 33,
	EC_FEATURE_EXEC_IN_RAM = 34,
	EC_FEATURE_CEC = 35,
	EC_FEATURE_MOTION_SENSE_TIGHT_TIMESTAMPS = 36,
	EC_FEATURE_REFINED_TABLET_MODE_HYSTERESIS = 37,
	EC_FEATURE_SCP = 39,
	EC_FEATURE_ISH = 40,
	EC_FEATURE_TYPEC_CMD = 41,
	EC_FEATURE_TYPEC_REQUIRE_AP_MODE_ENTRY = 42,
	EC_FEATURE_TYPEC_MUX_REQUIRE_AP_ACK = 43,
	EC_FEATURE_S4_RESIDENCY = 44,
	EC_FEATURE_TYPEC_AP_MUX_SET = 45,
	EC_FEATURE_TYPEC_AP_VDM_SEND = 46,
	EC_FEATURE_SYSTEM_SAFE_MODE = 47,
	EC_FEATURE_ASSERT_REBOOTS = 48,
	EC_FEATURE_TOKENIZED_LOGGING = 49,
	EC_FEATURE_AMD_STB_DUMP = 50,
	EC_FEATURE_MEMORY_DUMP = 51,
	EC_FEATURE_TYPEC_DP2_1 = 52,
	EC_FEATURE_SCP_C1 = 53,
	EC_FEATURE_UCSI_PPM = 54,
};

enum ec_led_colors {
	EC_LED_COLOR_RED = 0,
	EC_LED_COLOR_GREEN = 1,
	EC_LED_COLOR_BLUE = 2,
	EC_LED_COLOR_YELLOW = 3,
	EC_LED_COLOR_WHITE = 4,
	EC_LED_COLOR_AMBER = 5,
	EC_LED_COLOR_COUNT = 6,
};

enum ec_mkbp_event {
	EC_MKBP_EVENT_KEY_MATRIX = 0,
	EC_MKBP_EVENT_HOST_EVENT = 1,
	EC_MKBP_EVENT_SENSOR_FIFO = 2,
	EC_MKBP_EVENT_BUTTON = 3,
	EC_MKBP_EVENT_SWITCH = 4,
	EC_MKBP_EVENT_FINGERPRINT = 5,
	EC_MKBP_EVENT_SYSRQ = 6,
	EC_MKBP_EVENT_HOST_EVENT64 = 7,
	EC_MKBP_EVENT_CEC_EVENT = 8,
	EC_MKBP_EVENT_CEC_MESSAGE = 9,
	EC_MKBP_EVENT_PCHG = 12,
	EC_MKBP_EVENT_COUNT = 13,
};

enum ec_mkbp_info_type {
	EC_MKBP_INFO_KBD = 0,
	EC_MKBP_INFO_SUPPORTED = 1,
	EC_MKBP_INFO_CURRENT = 2,
};

enum ec_status {
	EC_RES_SUCCESS = 0,
	EC_RES_INVALID_COMMAND = 1,
	EC_RES_ERROR = 2,
	EC_RES_INVALID_PARAM = 3,
	EC_RES_ACCESS_DENIED = 4,
	EC_RES_INVALID_RESPONSE = 5,
	EC_RES_INVALID_VERSION = 6,
	EC_RES_INVALID_CHECKSUM = 7,
	EC_RES_IN_PROGRESS = 8,
	EC_RES_UNAVAILABLE = 9,
	EC_RES_TIMEOUT = 10,
	EC_RES_OVERFLOW = 11,
	EC_RES_INVALID_HEADER = 12,
	EC_RES_REQUEST_TRUNCATED = 13,
	EC_RES_RESPONSE_TOO_BIG = 14,
	EC_RES_BUS_ERROR = 15,
	EC_RES_BUSY = 16,
	EC_RES_INVALID_HEADER_VERSION = 17,
	EC_RES_INVALID_HEADER_CRC = 18,
	EC_RES_INVALID_DATA_CRC = 19,
	EC_RES_DUP_UNAVAILABLE = 20,
};

enum ec_temp_thresholds {
	EC_TEMP_THRESH_WARN = 0,
	EC_TEMP_THRESH_HIGH = 1,
	EC_TEMP_THRESH_HALT = 2,
	EC_TEMP_THRESH_COUNT = 3,
};

enum edac_dev_feat {
	RAS_FEAT_SCRUB = 0,
	RAS_FEAT_ECS = 1,
	RAS_FEAT_MEM_REPAIR = 2,
	RAS_FEAT_MAX = 3,
};

enum edac_mc_layer_type {
	EDAC_MC_LAYER_BRANCH = 0,
	EDAC_MC_LAYER_CHANNEL = 1,
	EDAC_MC_LAYER_SLOT = 2,
	EDAC_MC_LAYER_CHIP_SELECT = 3,
	EDAC_MC_LAYER_ALL_MEM = 4,
};

enum edac_type {
	EDAC_UNKNOWN = 0,
	EDAC_NONE = 1,
	EDAC_RESERVED = 2,
	EDAC_PARITY = 3,
	EDAC_EC = 4,
	EDAC_SECDED = 5,
	EDAC_S2ECD2ED = 6,
	EDAC_S4ECD4ED = 7,
	EDAC_S8ECD8ED = 8,
	EDAC_S16ECD16ED = 9,
};

enum edid_block_status {
	EDID_BLOCK_OK = 0,
	EDID_BLOCK_READ_FAIL = 1,
	EDID_BLOCK_NULL = 2,
	EDID_BLOCK_ZERO = 3,
	EDID_BLOCK_HEADER_CORRUPT = 4,
	EDID_BLOCK_HEADER_REPAIR = 5,
	EDID_BLOCK_HEADER_FIXED = 6,
	EDID_BLOCK_CHECKSUM = 7,
	EDID_BLOCK_VERSION = 8,
};

enum efi_rts_ids {
	EFI_NONE = 0,
	EFI_GET_TIME = 1,
	EFI_SET_TIME = 2,
	EFI_GET_WAKEUP_TIME = 3,
	EFI_SET_WAKEUP_TIME = 4,
	EFI_GET_VARIABLE = 5,
	EFI_GET_NEXT_VARIABLE = 6,
	EFI_SET_VARIABLE = 7,
	EFI_QUERY_VARIABLE_INFO = 8,
	EFI_GET_NEXT_HIGH_MONO_COUNT = 9,
	EFI_RESET_SYSTEM = 10,
	EFI_UPDATE_CAPSULE = 11,
	EFI_QUERY_CAPSULE_CAPS = 12,
	EFI_ACPI_PRM_HANDLER = 13,
};

enum ehci_hrtimer_event {
	EHCI_HRTIMER_POLL_ASS = 0,
	EHCI_HRTIMER_POLL_PSS = 1,
	EHCI_HRTIMER_POLL_DEAD = 2,
	EHCI_HRTIMER_UNLINK_INTR = 3,
	EHCI_HRTIMER_FREE_ITDS = 4,
	EHCI_HRTIMER_ACTIVE_UNLINK = 5,
	EHCI_HRTIMER_START_UNLINK_INTR = 6,
	EHCI_HRTIMER_ASYNC_UNLINKS = 7,
	EHCI_HRTIMER_IAA_WATCHDOG = 8,
	EHCI_HRTIMER_DISABLE_PERIODIC = 9,
	EHCI_HRTIMER_DISABLE_ASYNC = 10,
	EHCI_HRTIMER_IO_WATCHDOG = 11,
	EHCI_HRTIMER_NUM_EVENTS = 12,
};

enum ehci_rh_state {
	EHCI_RH_HALTED = 0,
	EHCI_RH_SUSPENDED = 1,
	EHCI_RH_RUNNING = 2,
	EHCI_RH_STOPPING = 3,
};

enum eint_type {
	EINT_TYPE_NONE = 0,
	EINT_TYPE_GPIO = 1,
	EINT_TYPE_WKUP = 2,
	EINT_TYPE_WKUP_MUX = 3,
};

enum elants_chip_id {
	EKTH3500 = 0,
	EKTF3624 = 1,
};

enum elants_iap_mode {
	ELAN_IAP_OPERATIONAL = 0,
	ELAN_IAP_RECOVERY = 1,
};

enum elants_state {
	ELAN_STATE_NORMAL = 0,
	ELAN_WAIT_QUEUE_HEADER = 1,
	ELAN_WAIT_RECALIBRATION = 2,
};

enum elv_merge {
	ELEVATOR_NO_MERGE = 0,
	ELEVATOR_FRONT_MERGE = 1,
	ELEVATOR_BACK_MERGE = 2,
	ELEVATOR_DISCARD_MERGE = 3,
};

enum emc_dll_change {
	DLL_CHANGE_NONE = 0,
	DLL_CHANGE_ON = 1,
	DLL_CHANGE_OFF = 2,
};

enum emc_dram_type {
	DRAM_TYPE_RESERVED = 0,
	DRAM_TYPE_DDR1 = 1,
	DRAM_TYPE_LPDDR2 = 2,
	DRAM_TYPE_DDR2 = 3,
};

enum emc_dram_type___2 {
	DRAM_TYPE_DDR3 = 0,
	DRAM_TYPE_DDR1___2 = 1,
	DRAM_TYPE_LPDDR2___2 = 2,
	DRAM_TYPE_DDR2___2 = 3,
};

enum emc_dram_type___3 {
	DRAM_TYPE_DDR3___2 = 0,
	DRAM_TYPE_DDR1___3 = 1,
	DRAM_TYPE_LPDDR3 = 2,
	DRAM_TYPE_DDR2___3 = 3,
};

enum emc_rate_request_type {
	EMC_RATE_DEBUG = 0,
	EMC_RATE_ICC = 1,
	EMC_RATE_TYPE_MAX = 2,
};

enum emc_rate_request_type___2 {
	EMC_RATE_DEVFREQ = 0,
	EMC_RATE_DEBUG___2 = 1,
	EMC_RATE_ICC___2 = 2,
	EMC_RATE_TYPE_MAX___2 = 3,
};

enum enable_type {
	undefined = -1,
	user_disabled = 0,
	auto_disabled = 1,
	user_enabled = 2,
	auto_enabled = 3,
};

enum environment_cap {
	ENVIRON_ANY = 0,
	ENVIRON_INDOOR = 1,
	ENVIRON_OUTDOOR = 2,
};

enum equalization_preset_type {
	EQ_PRESET_TYPE_8GTS = 0,
	EQ_PRESET_TYPE_16GTS = 1,
	EQ_PRESET_TYPE_32GTS = 2,
	EQ_PRESET_TYPE_64GTS = 3,
	EQ_PRESET_TYPE_MAX = 4,
};

enum error_detector {
	ERROR_DETECTOR_KFENCE = 0,
	ERROR_DETECTOR_KASAN = 1,
	ERROR_DETECTOR_WARN = 2,
};

enum errors_option {
	MOUNT_ERRORS_READONLY = 0,
	MOUNT_ERRORS_CONTINUE = 1,
	MOUNT_ERRORS_PANIC = 2,
};

enum ethnl_sock_type {
	ETHTOOL_SOCK_TYPE_MODULE_FW_FLASH = 0,
};

enum ethtool_c33_pse_admin_state {
	ETHTOOL_C33_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_C33_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_C33_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_c33_pse_ext_state {
	ETHTOOL_C33_PSE_EXT_STATE_ERROR_CONDITION = 1,
	ETHTOOL_C33_PSE_EXT_STATE_MR_MPS_VALID = 2,
	ETHTOOL_C33_PSE_EXT_STATE_MR_PSE_ENABLE = 3,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_DETECT_TED = 4,
	ETHTOOL_C33_PSE_EXT_STATE_OPTION_VPORT_LIM = 5,
	ETHTOOL_C33_PSE_EXT_STATE_OVLD_DETECTED = 6,
	ETHTOOL_C33_PSE_EXT_STATE_PD_DLL_POWER_TYPE = 7,
	ETHTOOL_C33_PSE_EXT_STATE_POWER_NOT_AVAILABLE = 8,
	ETHTOOL_C33_PSE_EXT_STATE_SHORT_DETECTED = 9,
};

enum ethtool_c33_pse_ext_substate_error_condition {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_NON_EXISTING_PORT = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNDEFINED_PORT = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_INTERNAL_HW_FAULT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_COMM_ERROR_AFTER_FORCE_ON = 4,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_UNKNOWN_PORT_STATUS = 5,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_TURN_OFF = 6,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_HOST_CRASH_FORCE_SHUTDOWN = 7,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_CONFIG_CHANGE = 8,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_ERROR_CONDITION_DETECTED_OVER_TEMP = 9,
};

enum ethtool_c33_pse_ext_substate_mr_pse_enable {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_MR_PSE_ENABLE_DISABLE_PIN_ACTIVE = 1,
};

enum ethtool_c33_pse_ext_substate_option_detect_ted {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_DET_IN_PROCESS = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_DETECT_TED_CONNECTION_CHECK_ERROR = 2,
};

enum ethtool_c33_pse_ext_substate_option_vport_lim {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_HIGH_VOLTAGE = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_LOW_VOLTAGE = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OPTION_VPORT_LIM_VOLTAGE_INJECTION = 3,
};

enum ethtool_c33_pse_ext_substate_ovld_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_OVLD_DETECTED_OVERLOAD = 1,
};

enum ethtool_c33_pse_ext_substate_power_not_available {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_BUDGET_EXCEEDED = 1,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PORT_PW_LIMIT_EXCEEDS_CONTROLLER_BUDGET = 2,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_PD_REQUEST_EXCEEDS_PORT_LIMIT = 3,
	ETHTOOL_C33_PSE_EXT_SUBSTATE_POWER_NOT_AVAILABLE_HW_PW_LIMIT = 4,
};

enum ethtool_c33_pse_ext_substate_short_detected {
	ETHTOOL_C33_PSE_EXT_SUBSTATE_SHORT_DETECTED_SHORT_CONDITION = 1,
};

enum ethtool_c33_pse_pw_d_status {
	ETHTOOL_C33_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_C33_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_C33_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_C33_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_C33_PSE_PW_D_STATUS_TEST = 5,
	ETHTOOL_C33_PSE_PW_D_STATUS_FAULT = 6,
	ETHTOOL_C33_PSE_PW_D_STATUS_OTHERFAULT = 7,
};

enum ethtool_cmis_cdb_cmd_id {
	ETHTOOL_CMIS_CDB_CMD_QUERY_STATUS = 0,
	ETHTOOL_CMIS_CDB_CMD_MODULE_FEATURES = 64,
	ETHTOOL_CMIS_CDB_CMD_FW_MANAGMENT_FEATURES = 65,
	ETHTOOL_CMIS_CDB_CMD_START_FW_DOWNLOAD = 257,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_LPL = 259,
	ETHTOOL_CMIS_CDB_CMD_WRITE_FW_BLOCK_EPL = 260,
	ETHTOOL_CMIS_CDB_CMD_COMPLETE_FW_DOWNLOAD = 263,
	ETHTOOL_CMIS_CDB_CMD_RUN_FW_IMAGE = 265,
	ETHTOOL_CMIS_CDB_CMD_COMMIT_FW_IMAGE = 266,
};

enum ethtool_fec_config_bits {
	ETHTOOL_FEC_NONE_BIT = 0,
	ETHTOOL_FEC_AUTO_BIT = 1,
	ETHTOOL_FEC_OFF_BIT = 2,
	ETHTOOL_FEC_RS_BIT = 3,
	ETHTOOL_FEC_BASER_BIT = 4,
	ETHTOOL_FEC_LLRS_BIT = 5,
};

enum ethtool_flags {
	ETH_FLAG_TXVLAN = 128,
	ETH_FLAG_RXVLAN = 256,
	ETH_FLAG_LRO = 32768,
	ETH_FLAG_NTUPLE = 134217728,
	ETH_FLAG_RXHASH = 268435456,
};

enum ethtool_header_flags {
	ETHTOOL_FLAG_COMPACT_BITSETS = 1,
	ETHTOOL_FLAG_OMIT_REPLY = 2,
	ETHTOOL_FLAG_STATS = 4,
};

enum ethtool_link_ext_state {
	ETHTOOL_LINK_EXT_STATE_AUTONEG = 0,
	ETHTOOL_LINK_EXT_STATE_LINK_TRAINING_FAILURE = 1,
	ETHTOOL_LINK_EXT_STATE_LINK_LOGICAL_MISMATCH = 2,
	ETHTOOL_LINK_EXT_STATE_BAD_SIGNAL_INTEGRITY = 3,
	ETHTOOL_LINK_EXT_STATE_NO_CABLE = 4,
	ETHTOOL_LINK_EXT_STATE_CABLE_ISSUE = 5,
	ETHTOOL_LINK_EXT_STATE_EEPROM_ISSUE = 6,
	ETHTOOL_LINK_EXT_STATE_CALIBRATION_FAILURE = 7,
	ETHTOOL_LINK_EXT_STATE_POWER_BUDGET_EXCEEDED = 8,
	ETHTOOL_LINK_EXT_STATE_OVERHEAT = 9,
	ETHTOOL_LINK_EXT_STATE_MODULE = 10,
};

enum ethtool_link_ext_substate_autoneg {
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_ACK_NOT_RECEIVED = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NEXT_PAGE_EXCHANGE_FAILED = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_PARTNER_DETECTED_FORCE_MODE = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_FEC_MISMATCH_DURING_OVERRIDE = 5,
	ETHTOOL_LINK_EXT_SUBSTATE_AN_NO_HCD = 6,
};

enum ethtool_link_ext_substate_bad_signal_integrity {
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_LARGE_NUMBER_OF_PHYSICAL_ERRORS = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_UNSUPPORTED_RATE = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_REFERENCE_CLOCK_LOST = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_BSI_SERDES_ALOS = 4,
};

enum ethtool_link_ext_substate_cable_issue {
	ETHTOOL_LINK_EXT_SUBSTATE_CI_UNSUPPORTED_CABLE = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_CI_CABLE_TEST_FAILURE = 2,
};

enum ethtool_link_ext_substate_link_logical_mismatch {
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_BLOCK_LOCK = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_ACQUIRE_AM_LOCK = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_PCS_DID_NOT_GET_ALIGN_STATUS = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_FC_FEC_IS_NOT_LOCKED = 4,
	ETHTOOL_LINK_EXT_SUBSTATE_LLM_RS_FEC_IS_NOT_LOCKED = 5,
};

enum ethtool_link_ext_substate_link_training {
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_FRAME_LOCK_NOT_ACQUIRED = 1,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_INHIBIT_TIMEOUT = 2,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_KR_LINK_PARTNER_DID_NOT_SET_RECEIVER_READY = 3,
	ETHTOOL_LINK_EXT_SUBSTATE_LT_REMOTE_FAULT = 4,
};

enum ethtool_link_ext_substate_module {
	ETHTOOL_LINK_EXT_SUBSTATE_MODULE_CMIS_NOT_READY = 1,
};

enum ethtool_link_mode_bit_indices {
	ETHTOOL_LINK_MODE_10baseT_Half_BIT = 0,
	ETHTOOL_LINK_MODE_10baseT_Full_BIT = 1,
	ETHTOOL_LINK_MODE_100baseT_Half_BIT = 2,
	ETHTOOL_LINK_MODE_100baseT_Full_BIT = 3,
	ETHTOOL_LINK_MODE_1000baseT_Half_BIT = 4,
	ETHTOOL_LINK_MODE_1000baseT_Full_BIT = 5,
	ETHTOOL_LINK_MODE_Autoneg_BIT = 6,
	ETHTOOL_LINK_MODE_TP_BIT = 7,
	ETHTOOL_LINK_MODE_AUI_BIT = 8,
	ETHTOOL_LINK_MODE_MII_BIT = 9,
	ETHTOOL_LINK_MODE_FIBRE_BIT = 10,
	ETHTOOL_LINK_MODE_BNC_BIT = 11,
	ETHTOOL_LINK_MODE_10000baseT_Full_BIT = 12,
	ETHTOOL_LINK_MODE_Pause_BIT = 13,
	ETHTOOL_LINK_MODE_Asym_Pause_BIT = 14,
	ETHTOOL_LINK_MODE_2500baseX_Full_BIT = 15,
	ETHTOOL_LINK_MODE_Backplane_BIT = 16,
	ETHTOOL_LINK_MODE_1000baseKX_Full_BIT = 17,
	ETHTOOL_LINK_MODE_10000baseKX4_Full_BIT = 18,
	ETHTOOL_LINK_MODE_10000baseKR_Full_BIT = 19,
	ETHTOOL_LINK_MODE_10000baseR_FEC_BIT = 20,
	ETHTOOL_LINK_MODE_20000baseMLD2_Full_BIT = 21,
	ETHTOOL_LINK_MODE_20000baseKR2_Full_BIT = 22,
	ETHTOOL_LINK_MODE_40000baseKR4_Full_BIT = 23,
	ETHTOOL_LINK_MODE_40000baseCR4_Full_BIT = 24,
	ETHTOOL_LINK_MODE_40000baseSR4_Full_BIT = 25,
	ETHTOOL_LINK_MODE_40000baseLR4_Full_BIT = 26,
	ETHTOOL_LINK_MODE_56000baseKR4_Full_BIT = 27,
	ETHTOOL_LINK_MODE_56000baseCR4_Full_BIT = 28,
	ETHTOOL_LINK_MODE_56000baseSR4_Full_BIT = 29,
	ETHTOOL_LINK_MODE_56000baseLR4_Full_BIT = 30,
	ETHTOOL_LINK_MODE_25000baseCR_Full_BIT = 31,
	ETHTOOL_LINK_MODE_25000baseKR_Full_BIT = 32,
	ETHTOOL_LINK_MODE_25000baseSR_Full_BIT = 33,
	ETHTOOL_LINK_MODE_50000baseCR2_Full_BIT = 34,
	ETHTOOL_LINK_MODE_50000baseKR2_Full_BIT = 35,
	ETHTOOL_LINK_MODE_100000baseKR4_Full_BIT = 36,
	ETHTOOL_LINK_MODE_100000baseSR4_Full_BIT = 37,
	ETHTOOL_LINK_MODE_100000baseCR4_Full_BIT = 38,
	ETHTOOL_LINK_MODE_100000baseLR4_ER4_Full_BIT = 39,
	ETHTOOL_LINK_MODE_50000baseSR2_Full_BIT = 40,
	ETHTOOL_LINK_MODE_1000baseX_Full_BIT = 41,
	ETHTOOL_LINK_MODE_10000baseCR_Full_BIT = 42,
	ETHTOOL_LINK_MODE_10000baseSR_Full_BIT = 43,
	ETHTOOL_LINK_MODE_10000baseLR_Full_BIT = 44,
	ETHTOOL_LINK_MODE_10000baseLRM_Full_BIT = 45,
	ETHTOOL_LINK_MODE_10000baseER_Full_BIT = 46,
	ETHTOOL_LINK_MODE_2500baseT_Full_BIT = 47,
	ETHTOOL_LINK_MODE_5000baseT_Full_BIT = 48,
	ETHTOOL_LINK_MODE_FEC_NONE_BIT = 49,
	ETHTOOL_LINK_MODE_FEC_RS_BIT = 50,
	ETHTOOL_LINK_MODE_FEC_BASER_BIT = 51,
	ETHTOOL_LINK_MODE_50000baseKR_Full_BIT = 52,
	ETHTOOL_LINK_MODE_50000baseSR_Full_BIT = 53,
	ETHTOOL_LINK_MODE_50000baseCR_Full_BIT = 54,
	ETHTOOL_LINK_MODE_50000baseLR_ER_FR_Full_BIT = 55,
	ETHTOOL_LINK_MODE_50000baseDR_Full_BIT = 56,
	ETHTOOL_LINK_MODE_100000baseKR2_Full_BIT = 57,
	ETHTOOL_LINK_MODE_100000baseSR2_Full_BIT = 58,
	ETHTOOL_LINK_MODE_100000baseCR2_Full_BIT = 59,
	ETHTOOL_LINK_MODE_100000baseLR2_ER2_FR2_Full_BIT = 60,
	ETHTOOL_LINK_MODE_100000baseDR2_Full_BIT = 61,
	ETHTOOL_LINK_MODE_200000baseKR4_Full_BIT = 62,
	ETHTOOL_LINK_MODE_200000baseSR4_Full_BIT = 63,
	ETHTOOL_LINK_MODE_200000baseLR4_ER4_FR4_Full_BIT = 64,
	ETHTOOL_LINK_MODE_200000baseDR4_Full_BIT = 65,
	ETHTOOL_LINK_MODE_200000baseCR4_Full_BIT = 66,
	ETHTOOL_LINK_MODE_100baseT1_Full_BIT = 67,
	ETHTOOL_LINK_MODE_1000baseT1_Full_BIT = 68,
	ETHTOOL_LINK_MODE_400000baseKR8_Full_BIT = 69,
	ETHTOOL_LINK_MODE_400000baseSR8_Full_BIT = 70,
	ETHTOOL_LINK_MODE_400000baseLR8_ER8_FR8_Full_BIT = 71,
	ETHTOOL_LINK_MODE_400000baseDR8_Full_BIT = 72,
	ETHTOOL_LINK_MODE_400000baseCR8_Full_BIT = 73,
	ETHTOOL_LINK_MODE_FEC_LLRS_BIT = 74,
	ETHTOOL_LINK_MODE_100000baseKR_Full_BIT = 75,
	ETHTOOL_LINK_MODE_100000baseSR_Full_BIT = 76,
	ETHTOOL_LINK_MODE_100000baseLR_ER_FR_Full_BIT = 77,
	ETHTOOL_LINK_MODE_100000baseCR_Full_BIT = 78,
	ETHTOOL_LINK_MODE_100000baseDR_Full_BIT = 79,
	ETHTOOL_LINK_MODE_200000baseKR2_Full_BIT = 80,
	ETHTOOL_LINK_MODE_200000baseSR2_Full_BIT = 81,
	ETHTOOL_LINK_MODE_200000baseLR2_ER2_FR2_Full_BIT = 82,
	ETHTOOL_LINK_MODE_200000baseDR2_Full_BIT = 83,
	ETHTOOL_LINK_MODE_200000baseCR2_Full_BIT = 84,
	ETHTOOL_LINK_MODE_400000baseKR4_Full_BIT = 85,
	ETHTOOL_LINK_MODE_400000baseSR4_Full_BIT = 86,
	ETHTOOL_LINK_MODE_400000baseLR4_ER4_FR4_Full_BIT = 87,
	ETHTOOL_LINK_MODE_400000baseDR4_Full_BIT = 88,
	ETHTOOL_LINK_MODE_400000baseCR4_Full_BIT = 89,
	ETHTOOL_LINK_MODE_100baseFX_Half_BIT = 90,
	ETHTOOL_LINK_MODE_100baseFX_Full_BIT = 91,
	ETHTOOL_LINK_MODE_10baseT1L_Full_BIT = 92,
	ETHTOOL_LINK_MODE_800000baseCR8_Full_BIT = 93,
	ETHTOOL_LINK_MODE_800000baseKR8_Full_BIT = 94,
	ETHTOOL_LINK_MODE_800000baseDR8_Full_BIT = 95,
	ETHTOOL_LINK_MODE_800000baseDR8_2_Full_BIT = 96,
	ETHTOOL_LINK_MODE_800000baseSR8_Full_BIT = 97,
	ETHTOOL_LINK_MODE_800000baseVR8_Full_BIT = 98,
	ETHTOOL_LINK_MODE_10baseT1S_Full_BIT = 99,
	ETHTOOL_LINK_MODE_10baseT1S_Half_BIT = 100,
	ETHTOOL_LINK_MODE_10baseT1S_P2MP_Half_BIT = 101,
	ETHTOOL_LINK_MODE_10baseT1BRR_Full_BIT = 102,
	ETHTOOL_LINK_MODE_200000baseCR_Full_BIT = 103,
	ETHTOOL_LINK_MODE_200000baseKR_Full_BIT = 104,
	ETHTOOL_LINK_MODE_200000baseDR_Full_BIT = 105,
	ETHTOOL_LINK_MODE_200000baseDR_2_Full_BIT = 106,
	ETHTOOL_LINK_MODE_200000baseSR_Full_BIT = 107,
	ETHTOOL_LINK_MODE_200000baseVR_Full_BIT = 108,
	ETHTOOL_LINK_MODE_400000baseCR2_Full_BIT = 109,
	ETHTOOL_LINK_MODE_400000baseKR2_Full_BIT = 110,
	ETHTOOL_LINK_MODE_400000baseDR2_Full_BIT = 111,
	ETHTOOL_LINK_MODE_400000baseDR2_2_Full_BIT = 112,
	ETHTOOL_LINK_MODE_400000baseSR2_Full_BIT = 113,
	ETHTOOL_LINK_MODE_400000baseVR2_Full_BIT = 114,
	ETHTOOL_LINK_MODE_800000baseCR4_Full_BIT = 115,
	ETHTOOL_LINK_MODE_800000baseKR4_Full_BIT = 116,
	ETHTOOL_LINK_MODE_800000baseDR4_Full_BIT = 117,
	ETHTOOL_LINK_MODE_800000baseDR4_2_Full_BIT = 118,
	ETHTOOL_LINK_MODE_800000baseSR4_Full_BIT = 119,
	ETHTOOL_LINK_MODE_800000baseVR4_Full_BIT = 120,
	__ETHTOOL_LINK_MODE_MASK_NBITS = 121,
};

enum ethtool_mac_stats_src {
	ETHTOOL_MAC_STATS_SRC_AGGREGATE = 0,
	ETHTOOL_MAC_STATS_SRC_EMAC = 1,
	ETHTOOL_MAC_STATS_SRC_PMAC = 2,
};

enum ethtool_mm_verify_status {
	ETHTOOL_MM_VERIFY_STATUS_UNKNOWN = 0,
	ETHTOOL_MM_VERIFY_STATUS_INITIAL = 1,
	ETHTOOL_MM_VERIFY_STATUS_VERIFYING = 2,
	ETHTOOL_MM_VERIFY_STATUS_SUCCEEDED = 3,
	ETHTOOL_MM_VERIFY_STATUS_FAILED = 4,
	ETHTOOL_MM_VERIFY_STATUS_DISABLED = 5,
};

enum ethtool_mmsv_event {
	ETHTOOL_MMSV_LP_SENT_VERIFY_MPACKET = 0,
	ETHTOOL_MMSV_LD_SENT_VERIFY_MPACKET = 1,
	ETHTOOL_MMSV_LP_SENT_RESPONSE_MPACKET = 2,
};

enum ethtool_module_fw_flash_status {
	ETHTOOL_MODULE_FW_FLASH_STATUS_STARTED = 1,
	ETHTOOL_MODULE_FW_FLASH_STATUS_IN_PROGRESS = 2,
	ETHTOOL_MODULE_FW_FLASH_STATUS_COMPLETED = 3,
	ETHTOOL_MODULE_FW_FLASH_STATUS_ERROR = 4,
};

enum ethtool_module_power_mode {
	ETHTOOL_MODULE_POWER_MODE_LOW = 1,
	ETHTOOL_MODULE_POWER_MODE_HIGH = 2,
};

enum ethtool_module_power_mode_policy {
	ETHTOOL_MODULE_POWER_MODE_POLICY_HIGH = 1,
	ETHTOOL_MODULE_POWER_MODE_POLICY_AUTO = 2,
};

enum ethtool_mpacket {
	ETHTOOL_MPACKET_VERIFY = 0,
	ETHTOOL_MPACKET_RESPONSE = 1,
};

enum ethtool_multicast_groups {
	ETHNL_MCGRP_MONITOR = 0,
};

enum ethtool_phys_id_state {
	ETHTOOL_ID_INACTIVE = 0,
	ETHTOOL_ID_ACTIVE = 1,
	ETHTOOL_ID_ON = 2,
	ETHTOOL_ID_OFF = 3,
};

enum ethtool_podl_pse_admin_state {
	ETHTOOL_PODL_PSE_ADMIN_STATE_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_ADMIN_STATE_DISABLED = 2,
	ETHTOOL_PODL_PSE_ADMIN_STATE_ENABLED = 3,
};

enum ethtool_podl_pse_pw_d_status {
	ETHTOOL_PODL_PSE_PW_D_STATUS_UNKNOWN = 1,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DISABLED = 2,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SEARCHING = 3,
	ETHTOOL_PODL_PSE_PW_D_STATUS_DELIVERING = 4,
	ETHTOOL_PODL_PSE_PW_D_STATUS_SLEEP = 5,
	ETHTOOL_PODL_PSE_PW_D_STATUS_IDLE = 6,
	ETHTOOL_PODL_PSE_PW_D_STATUS_ERROR = 7,
};

enum ethtool_reset_flags {
	ETH_RESET_MGMT = 1,
	ETH_RESET_IRQ = 2,
	ETH_RESET_DMA = 4,
	ETH_RESET_FILTER = 8,
	ETH_RESET_OFFLOAD = 16,
	ETH_RESET_MAC = 32,
	ETH_RESET_PHY = 64,
	ETH_RESET_RAM = 128,
	ETH_RESET_AP = 256,
	ETH_RESET_DEDICATED = 65535,
	ETH_RESET_ALL = 4294967295,
};

enum ethtool_sfeatures_retval_bits {
	ETHTOOL_F_UNSUPPORTED__BIT = 0,
	ETHTOOL_F_WISH__BIT = 1,
	ETHTOOL_F_COMPAT__BIT = 2,
};

enum ethtool_stringset {
	ETH_SS_TEST = 0,
	ETH_SS_STATS = 1,
	ETH_SS_PRIV_FLAGS = 2,
	ETH_SS_NTUPLE_FILTERS = 3,
	ETH_SS_FEATURES = 4,
	ETH_SS_RSS_HASH_FUNCS = 5,
	ETH_SS_TUNABLES = 6,
	ETH_SS_PHY_STATS = 7,
	ETH_SS_PHY_TUNABLES = 8,
	ETH_SS_LINK_MODES = 9,
	ETH_SS_MSG_CLASSES = 10,
	ETH_SS_WOL_MODES = 11,
	ETH_SS_SOF_TIMESTAMPING = 12,
	ETH_SS_TS_TX_TYPES = 13,
	ETH_SS_TS_RX_FILTERS = 14,
	ETH_SS_UDP_TUNNEL_TYPES = 15,
	ETH_SS_STATS_STD = 16,
	ETH_SS_STATS_ETH_PHY = 17,
	ETH_SS_STATS_ETH_MAC = 18,
	ETH_SS_STATS_ETH_CTRL = 19,
	ETH_SS_STATS_RMON = 20,
	ETH_SS_STATS_PHY = 21,
	ETH_SS_TS_FLAGS = 22,
	ETH_SS_COUNT = 23,
};

enum ethtool_supported_ring_param {
	ETHTOOL_RING_USE_RX_BUF_LEN = 1,
	ETHTOOL_RING_USE_CQE_SIZE = 2,
	ETHTOOL_RING_USE_TX_PUSH = 4,
	ETHTOOL_RING_USE_RX_PUSH = 8,
	ETHTOOL_RING_USE_TX_PUSH_BUF_LEN = 16,
	ETHTOOL_RING_USE_TCP_DATA_SPLIT = 32,
	ETHTOOL_RING_USE_HDS_THRS = 64,
};

enum ethtool_tcp_data_split {
	ETHTOOL_TCP_DATA_SPLIT_UNKNOWN = 0,
	ETHTOOL_TCP_DATA_SPLIT_DISABLED = 1,
	ETHTOOL_TCP_DATA_SPLIT_ENABLED = 2,
};

enum ethtool_test_flags {
	ETH_TEST_FL_OFFLINE = 1,
	ETH_TEST_FL_FAILED = 2,
	ETH_TEST_FL_EXTERNAL_LB = 4,
	ETH_TEST_FL_EXTERNAL_LB_DONE = 8,
};

enum event_type_t {
	EVENT_FLEXIBLE = 1,
	EVENT_PINNED = 2,
	EVENT_TIME = 4,
	EVENT_FROZEN = 8,
	EVENT_CPU = 16,
	EVENT_CGROUP = 32,
	EVENT_ALL = 3,
	EVENT_TIME_FROZEN = 12,
};

enum exact_level {
	NOT_EXACT = 0,
	EXACT = 1,
	RANGE_WITHIN = 2,
};

enum execmem_range_flags {
	EXECMEM_KASAN_SHADOW = 1,
	EXECMEM_ROX_CACHE = 2,
};

enum execmem_type {
	EXECMEM_DEFAULT = 0,
	EXECMEM_MODULE_TEXT = 0,
	EXECMEM_KPROBES = 1,
	EXECMEM_FTRACE = 2,
	EXECMEM_BPF = 3,
	EXECMEM_MODULE_DATA = 4,
	EXECMEM_TYPE_MAX = 5,
};

enum ext4_journal_trigger_type {
	EXT4_JTR_ORPHAN_FILE = 0,
	EXT4_JTR_NONE = 1,
};

enum ext4_li_mode {
	EXT4_LI_MODE_PREFETCH_BBITMAP = 0,
	EXT4_LI_MODE_ITABLE = 1,
};

enum extent_type {
	EX_READ = 0,
	EX_BLOCK_AGE = 1,
	NR_EXTENT_CACHES = 2,
};

enum exynos4210_phy_id {
	EXYNOS4210_DEVICE = 0,
	EXYNOS4210_HOST = 1,
	EXYNOS4210_HSIC0 = 2,
	EXYNOS4210_HSIC1 = 3,
	EXYNOS4210_NUM_PHYS = 4,
};

enum exynos4_plls {
	apll = 0,
	mpll = 1,
	epll = 2,
	vpll = 3,
	nr_plls = 4,
};

enum exynos4_soc {
	EXYNOS4210 = 0,
	EXYNOS4212 = 1,
	EXYNOS4412 = 2,
};

enum exynos4x12_phy_id {
	EXYNOS5250_DEVICE = 0,
	EXYNOS5250_HOST = 1,
	EXYNOS5250_HSIC0 = 2,
	EXYNOS5250_HSIC1 = 3,
};

enum exynos4x12_phy_id___2 {
	EXYNOS4x12_DEVICE = 0,
	EXYNOS4x12_HOST = 1,
	EXYNOS4x12_HSIC0 = 2,
	EXYNOS4x12_HSIC1 = 3,
	EXYNOS4x12_NUM_PHYS = 4,
};

enum exynos5250_plls {
	apll___2 = 0,
	mpll___2 = 1,
	cpll = 2,
	epll___2 = 3,
	vpll___2 = 4,
	gpll = 5,
	bpll = 6,
	nr_plls___2 = 7,
};

enum exynos5410_plls {
	apll___3 = 0,
	cpll___2 = 1,
	epll___3 = 2,
	mpll___3 = 3,
	bpll___2 = 4,
	kpll = 5,
	nr_plls___3 = 6,
};

enum exynos5_usbdrd_phy_id {
	EXYNOS5_DRDPHY_UTMI = 0,
	EXYNOS5_DRDPHY_PIPE3 = 1,
	EXYNOS5_DRDPHYS_NUM = 2,
};

enum exynos5_usbdrd_phy_tuning_state {
	PTS_UTMI_POSTINIT = 0,
	PTS_PIPE3_PREINIT = 1,
	PTS_PIPE3_INIT = 2,
	PTS_PIPE3_POSTINIT = 3,
	PTS_PIPE3_POSTLOCK = 4,
	PTS_MAX = 5,
};

enum exynos5x_plls {
	apll___4 = 0,
	cpll___3 = 1,
	dpll = 2,
	epll___4 = 3,
	rpll = 4,
	ipll = 5,
	spll = 6,
	vpll___3 = 7,
	mpll___4 = 8,
	bpll___3 = 9,
	kpll___2 = 10,
	nr_plls___4 = 11,
};

enum exynos5x_soc {
	EXYNOS5420 = 0,
	EXYNOS5800 = 1,
};

enum exynos_cpuclk_layout {
	CPUCLK_LAYOUT_E4210 = 0,
	CPUCLK_LAYOUT_E5433 = 1,
	CPUCLK_LAYOUT_E850_CL0 = 2,
	CPUCLK_LAYOUT_E850_CL1 = 3,
};

enum exynos_drm_output_type {
	EXYNOS_DISPLAY_TYPE_NONE = 0,
	EXYNOS_DISPLAY_TYPE_LCD = 1,
	EXYNOS_DISPLAY_TYPE_HDMI = 2,
	EXYNOS_DISPLAY_TYPE_VIDI = 3,
};

enum exynos_mipi_phy_id {
	EXYNOS_MIPI_PHY_ID_NONE = -1,
	EXYNOS_MIPI_PHY_ID_CSIS0 = 0,
	EXYNOS_MIPI_PHY_ID_DSIM0 = 1,
	EXYNOS_MIPI_PHY_ID_CSIS1 = 2,
	EXYNOS_MIPI_PHY_ID_DSIM1 = 3,
	EXYNOS_MIPI_PHY_ID_CSIS2 = 4,
	EXYNOS_MIPI_PHYS_NUM = 5,
};

enum exynos_mipi_phy_regmap_id {
	EXYNOS_MIPI_REGMAP_PMU = 0,
	EXYNOS_MIPI_REGMAP_DISP = 1,
	EXYNOS_MIPI_REGMAP_CAM0 = 2,
	EXYNOS_MIPI_REGMAP_CAM1 = 3,
	EXYNOS_MIPI_REGMAPS_NUM = 4,
};

enum f2fs_error {
	ERROR_CORRUPTED_CLUSTER = 0,
	ERROR_FAIL_DECOMPRESSION = 1,
	ERROR_INVALID_BLKADDR = 2,
	ERROR_CORRUPTED_DIRENT = 3,
	ERROR_CORRUPTED_INODE = 4,
	ERROR_INCONSISTENT_SUMMARY = 5,
	ERROR_INCONSISTENT_FOOTER = 6,
	ERROR_INCONSISTENT_SUM_TYPE = 7,
	ERROR_CORRUPTED_JOURNAL = 8,
	ERROR_INCONSISTENT_NODE_COUNT = 9,
	ERROR_INCONSISTENT_BLOCK_COUNT = 10,
	ERROR_INVALID_CURSEG = 11,
	ERROR_INCONSISTENT_SIT = 12,
	ERROR_CORRUPTED_VERITY_XATTR = 13,
	ERROR_CORRUPTED_XATTR = 14,
	ERROR_INVALID_NODE_REFERENCE = 15,
	ERROR_INCONSISTENT_NAT = 16,
	ERROR_MAX = 17,
};

enum factor_mode {
	ALPHA_ZERO = 0,
	ALPHA_ONE = 1,
	ALPHA_SRC = 2,
	ALPHA_SRC_INVERSE = 3,
	ALPHA_SRC_GLOBAL = 4,
};

enum fail_dup_mod_reason {
	FAIL_DUP_MOD_BECOMING = 0,
	FAIL_DUP_MOD_LOAD = 1,
};

enum fan53555_vendor {
	FAN53526_VENDOR_FAIRCHILD = 0,
	FAN53555_VENDOR_FAIRCHILD = 1,
	FAN53555_VENDOR_ROCKCHIP = 2,
	RK8602_VENDOR_ROCKCHIP = 3,
	FAN53555_VENDOR_SILERGY = 4,
	FAN53526_VENDOR_TCS = 5,
};

enum fanotify_event_type {
	FANOTIFY_EVENT_TYPE_FID = 0,
	FANOTIFY_EVENT_TYPE_FID_NAME = 1,
	FANOTIFY_EVENT_TYPE_PATH = 2,
	FANOTIFY_EVENT_TYPE_PATH_PERM = 3,
	FANOTIFY_EVENT_TYPE_OVERFLOW = 4,
	FANOTIFY_EVENT_TYPE_FS_ERROR = 5,
	FANOTIFY_EVENT_TYPE_MNT = 6,
	__FANOTIFY_EVENT_TYPE_NUM = 7,
};

enum fault_flag {
	FAULT_FLAG_WRITE = 1,
	FAULT_FLAG_MKWRITE = 2,
	FAULT_FLAG_ALLOW_RETRY = 4,
	FAULT_FLAG_RETRY_NOWAIT = 8,
	FAULT_FLAG_KILLABLE = 16,
	FAULT_FLAG_TRIED = 32,
	FAULT_FLAG_USER = 64,
	FAULT_FLAG_REMOTE = 128,
	FAULT_FLAG_INSTRUCTION = 256,
	FAULT_FLAG_INTERRUPTIBLE = 512,
	FAULT_FLAG_UNSHARE = 1024,
	FAULT_FLAG_ORIG_PTE_VALID = 2048,
	FAULT_FLAG_VMA_LOCK = 4096,
};

enum fault_option {
	FAULT_RATE = 1,
	FAULT_TYPE = 2,
	FAULT_ALL = 4,
};

enum fbq_type {
	regular = 0,
	remote = 1,
	all = 2,
};

enum fe_bandwidth {
	BANDWIDTH_8_MHZ = 0,
	BANDWIDTH_7_MHZ = 1,
	BANDWIDTH_6_MHZ = 2,
	BANDWIDTH_AUTO = 3,
	BANDWIDTH_5_MHZ = 4,
	BANDWIDTH_10_MHZ = 5,
	BANDWIDTH_1_712_MHZ = 6,
};

typedef enum fe_bandwidth fe_bandwidth_t;

enum fe_caps {
	FE_IS_STUPID = 0,
	FE_CAN_INVERSION_AUTO = 1,
	FE_CAN_FEC_1_2 = 2,
	FE_CAN_FEC_2_3 = 4,
	FE_CAN_FEC_3_4 = 8,
	FE_CAN_FEC_4_5 = 16,
	FE_CAN_FEC_5_6 = 32,
	FE_CAN_FEC_6_7 = 64,
	FE_CAN_FEC_7_8 = 128,
	FE_CAN_FEC_8_9 = 256,
	FE_CAN_FEC_AUTO = 512,
	FE_CAN_QPSK = 1024,
	FE_CAN_QAM_16 = 2048,
	FE_CAN_QAM_32 = 4096,
	FE_CAN_QAM_64 = 8192,
	FE_CAN_QAM_128 = 16384,
	FE_CAN_QAM_256 = 32768,
	FE_CAN_QAM_AUTO = 65536,
	FE_CAN_TRANSMISSION_MODE_AUTO = 131072,
	FE_CAN_BANDWIDTH_AUTO = 262144,
	FE_CAN_GUARD_INTERVAL_AUTO = 524288,
	FE_CAN_HIERARCHY_AUTO = 1048576,
	FE_CAN_8VSB = 2097152,
	FE_CAN_16VSB = 4194304,
	FE_HAS_EXTENDED_CAPS = 8388608,
	FE_CAN_MULTISTREAM = 67108864,
	FE_CAN_TURBO_FEC = 134217728,
	FE_CAN_2G_MODULATION = 268435456,
	FE_NEEDS_BENDING = 536870912,
	FE_CAN_RECOVER = 1073741824,
	FE_CAN_MUTE_TS = 2147483648,
};

enum fe_code_rate {
	FEC_NONE = 0,
	FEC_1_2 = 1,
	FEC_2_3 = 2,
	FEC_3_4 = 3,
	FEC_4_5 = 4,
	FEC_5_6 = 5,
	FEC_6_7 = 6,
	FEC_7_8 = 7,
	FEC_8_9 = 8,
	FEC_AUTO = 9,
	FEC_3_5 = 10,
	FEC_9_10 = 11,
	FEC_2_5 = 12,
	FEC_1_3 = 13,
	FEC_1_4 = 14,
	FEC_5_9 = 15,
	FEC_7_9 = 16,
	FEC_8_15 = 17,
	FEC_11_15 = 18,
	FEC_13_18 = 19,
	FEC_9_20 = 20,
	FEC_11_20 = 21,
	FEC_23_36 = 22,
	FEC_25_36 = 23,
	FEC_13_45 = 24,
	FEC_26_45 = 25,
	FEC_28_45 = 26,
	FEC_32_45 = 27,
	FEC_77_90 = 28,
	FEC_11_45 = 29,
	FEC_4_15 = 30,
	FEC_14_45 = 31,
	FEC_7_15 = 32,
};

typedef enum fe_code_rate fe_code_rate_t;

enum fe_delivery_system {
	SYS_UNDEFINED = 0,
	SYS_DVBC_ANNEX_A = 1,
	SYS_DVBC_ANNEX_B = 2,
	SYS_DVBT = 3,
	SYS_DSS = 4,
	SYS_DVBS = 5,
	SYS_DVBS2 = 6,
	SYS_DVBH = 7,
	SYS_ISDBT = 8,
	SYS_ISDBS = 9,
	SYS_ISDBC = 10,
	SYS_ATSC = 11,
	SYS_ATSCMH = 12,
	SYS_DTMB = 13,
	SYS_CMMB = 14,
	SYS_DAB = 15,
	SYS_DVBT2 = 16,
	SYS_TURBO = 17,
	SYS_DVBC_ANNEX_C = 18,
	SYS_DVBC2 = 19,
};

enum fe_guard_interval {
	GUARD_INTERVAL_1_32 = 0,
	GUARD_INTERVAL_1_16 = 1,
	GUARD_INTERVAL_1_8 = 2,
	GUARD_INTERVAL_1_4 = 3,
	GUARD_INTERVAL_AUTO = 4,
	GUARD_INTERVAL_1_128 = 5,
	GUARD_INTERVAL_19_128 = 6,
	GUARD_INTERVAL_19_256 = 7,
	GUARD_INTERVAL_PN420 = 8,
	GUARD_INTERVAL_PN595 = 9,
	GUARD_INTERVAL_PN945 = 10,
	GUARD_INTERVAL_1_64 = 11,
};

typedef enum fe_guard_interval fe_guard_interval_t;

enum fe_hierarchy {
	HIERARCHY_NONE = 0,
	HIERARCHY_1 = 1,
	HIERARCHY_2 = 2,
	HIERARCHY_4 = 3,
	HIERARCHY_AUTO = 4,
};

typedef enum fe_hierarchy fe_hierarchy_t;

enum fe_interleaving {
	INTERLEAVING_NONE = 0,
	INTERLEAVING_AUTO = 1,
	INTERLEAVING_240 = 2,
	INTERLEAVING_720 = 3,
};

enum fe_modulation {
	QPSK = 0,
	QAM_16 = 1,
	QAM_32 = 2,
	QAM_64 = 3,
	QAM_128 = 4,
	QAM_256 = 5,
	QAM_AUTO = 6,
	VSB_8 = 7,
	VSB_16 = 8,
	PSK_8 = 9,
	APSK_16 = 10,
	APSK_32 = 11,
	DQPSK = 12,
	QAM_4_NR = 13,
	QAM_1024 = 14,
	QAM_4096 = 15,
	APSK_8_L = 16,
	APSK_16_L = 17,
	APSK_32_L = 18,
	APSK_64 = 19,
	APSK_64_L = 20,
};

typedef enum fe_modulation fe_modulation_t;

enum fe_pilot {
	PILOT_ON = 0,
	PILOT_OFF = 1,
	PILOT_AUTO = 2,
};

enum fe_rolloff {
	ROLLOFF_35 = 0,
	ROLLOFF_20 = 1,
	ROLLOFF_25 = 2,
	ROLLOFF_AUTO = 3,
	ROLLOFF_15 = 4,
	ROLLOFF_10 = 5,
	ROLLOFF_5 = 6,
};

enum fe_sec_mini_cmd {
	SEC_MINI_A = 0,
	SEC_MINI_B = 1,
};

enum fe_sec_tone_mode {
	SEC_TONE_ON = 0,
	SEC_TONE_OFF = 1,
};

enum fe_sec_voltage {
	SEC_VOLTAGE_13 = 0,
	SEC_VOLTAGE_18 = 1,
	SEC_VOLTAGE_OFF = 2,
};

enum fe_spectral_inversion {
	INVERSION_OFF = 0,
	INVERSION_ON = 1,
	INVERSION_AUTO = 2,
};

typedef enum fe_spectral_inversion fe_spectral_inversion_t;

enum fe_status {
	FE_NONE = 0,
	FE_HAS_SIGNAL = 1,
	FE_HAS_CARRIER = 2,
	FE_HAS_VITERBI = 4,
	FE_HAS_SYNC = 8,
	FE_HAS_LOCK = 16,
	FE_TIMEDOUT = 32,
	FE_REINIT = 64,
};

typedef enum fe_status fe_status_t;

enum fe_transmit_mode {
	TRANSMISSION_MODE_2K = 0,
	TRANSMISSION_MODE_8K = 1,
	TRANSMISSION_MODE_AUTO = 2,
	TRANSMISSION_MODE_4K = 3,
	TRANSMISSION_MODE_1K = 4,
	TRANSMISSION_MODE_16K = 5,
	TRANSMISSION_MODE_32K = 6,
	TRANSMISSION_MODE_C1 = 7,
	TRANSMISSION_MODE_C3780 = 8,
};

typedef enum fe_transmit_mode fe_transmit_mode_t;

enum fe_type {
	FE_QPSK = 0,
	FE_QAM = 1,
	FE_OFDM = 2,
	FE_ATSC = 3,
};

enum fec_txbuf_type {
	FEC_TXBUF_T_SKB = 0,
	FEC_TXBUF_T_XDP_NDO = 1,
	FEC_TXBUF_T_XDP_TX = 2,
};

enum fib6_walk_state {
	FWS_S = 0,
	FWS_L = 1,
	FWS_R = 2,
	FWS_C = 3,
	FWS_U = 4,
};

enum fib_event_type {
	FIB_EVENT_ENTRY_REPLACE = 0,
	FIB_EVENT_ENTRY_APPEND = 1,
	FIB_EVENT_ENTRY_ADD = 2,
	FIB_EVENT_ENTRY_DEL = 3,
	FIB_EVENT_RULE_ADD = 4,
	FIB_EVENT_RULE_DEL = 5,
	FIB_EVENT_NH_ADD = 6,
	FIB_EVENT_NH_DEL = 7,
	FIB_EVENT_VIF_ADD = 8,
	FIB_EVENT_VIF_DEL = 9,
};

enum fid_type {
	FILEID_ROOT = 0,
	FILEID_INO32_GEN = 1,
	FILEID_INO32_GEN_PARENT = 2,
	FILEID_BTRFS_WITHOUT_PARENT = 77,
	FILEID_BTRFS_WITH_PARENT = 78,
	FILEID_BTRFS_WITH_PARENT_ROOT = 79,
	FILEID_UDF_WITHOUT_PARENT = 81,
	FILEID_UDF_WITH_PARENT = 82,
	FILEID_NILFS_WITHOUT_PARENT = 97,
	FILEID_NILFS_WITH_PARENT = 98,
	FILEID_FAT_WITHOUT_PARENT = 113,
	FILEID_FAT_WITH_PARENT = 114,
	FILEID_INO64_GEN = 129,
	FILEID_INO64_GEN_PARENT = 130,
	FILEID_LUSTRE = 151,
	FILEID_BCACHEFS_WITHOUT_PARENT = 177,
	FILEID_BCACHEFS_WITH_PARENT = 178,
	FILEID_KERNFS = 254,
	FILEID_INVALID = 255,
};

enum file_time_flags {
	S_ATIME = 1,
	S_MTIME = 2,
	S_CTIME = 4,
	S_VERSION = 8,
};

enum firmware_type {
	XC2028_AUTO = 0,
	XC2028_D2633 = 1,
	XC2028_D2620 = 2,
};

enum fit_type {
	NOTHING_FIT = 0,
	FL_FIT_TYPE = 1,
	LE_FIT_TYPE = 2,
	RE_FIT_TYPE = 3,
	NE_FIT_TYPE = 4,
};

enum fixed_addresses {
	FIX_EARLYCON_MEM_BASE = 0,
	__end_of_permanent_fixed_addresses = 1,
	FIX_KMAP_BEGIN = 1,
	FIX_KMAP_END = 128,
	FIX_TEXT_POKE0 = 129,
	FIX_TEXT_POKE1 = 130,
	__end_of_fixmap_region = 131,
	FIX_BTMAP_END = 1,
	FIX_BTMAP_BEGIN = 224,
	__end_of_early_ioremap_region = 225,
};

enum flow_action_hw_stats {
	FLOW_ACTION_HW_STATS_IMMEDIATE = 1,
	FLOW_ACTION_HW_STATS_DELAYED = 2,
	FLOW_ACTION_HW_STATS_ANY = 3,
	FLOW_ACTION_HW_STATS_DISABLED = 4,
	FLOW_ACTION_HW_STATS_DONT_CARE = 7,
};

enum flow_action_hw_stats_bit {
	FLOW_ACTION_HW_STATS_IMMEDIATE_BIT = 0,
	FLOW_ACTION_HW_STATS_DELAYED_BIT = 1,
	FLOW_ACTION_HW_STATS_DISABLED_BIT = 2,
	FLOW_ACTION_HW_STATS_NUM_BITS = 3,
};

enum flow_action_id {
	FLOW_ACTION_ACCEPT = 0,
	FLOW_ACTION_DROP = 1,
	FLOW_ACTION_TRAP = 2,
	FLOW_ACTION_GOTO = 3,
	FLOW_ACTION_REDIRECT = 4,
	FLOW_ACTION_MIRRED = 5,
	FLOW_ACTION_REDIRECT_INGRESS = 6,
	FLOW_ACTION_MIRRED_INGRESS = 7,
	FLOW_ACTION_VLAN_PUSH = 8,
	FLOW_ACTION_VLAN_POP = 9,
	FLOW_ACTION_VLAN_MANGLE = 10,
	FLOW_ACTION_TUNNEL_ENCAP = 11,
	FLOW_ACTION_TUNNEL_DECAP = 12,
	FLOW_ACTION_MANGLE = 13,
	FLOW_ACTION_ADD = 14,
	FLOW_ACTION_CSUM = 15,
	FLOW_ACTION_MARK = 16,
	FLOW_ACTION_PTYPE = 17,
	FLOW_ACTION_PRIORITY = 18,
	FLOW_ACTION_RX_QUEUE_MAPPING = 19,
	FLOW_ACTION_WAKE = 20,
	FLOW_ACTION_QUEUE = 21,
	FLOW_ACTION_SAMPLE = 22,
	FLOW_ACTION_POLICE = 23,
	FLOW_ACTION_CT = 24,
	FLOW_ACTION_CT_METADATA = 25,
	FLOW_ACTION_MPLS_PUSH = 26,
	FLOW_ACTION_MPLS_POP = 27,
	FLOW_ACTION_MPLS_MANGLE = 28,
	FLOW_ACTION_GATE = 29,
	FLOW_ACTION_PPPOE_PUSH = 30,
	FLOW_ACTION_JUMP = 31,
	FLOW_ACTION_PIPE = 32,
	FLOW_ACTION_VLAN_PUSH_ETH = 33,
	FLOW_ACTION_VLAN_POP_ETH = 34,
	FLOW_ACTION_CONTINUE = 35,
	NUM_FLOW_ACTIONS = 36,
};

enum flow_action_mangle_base {
	FLOW_ACT_MANGLE_UNSPEC = 0,
	FLOW_ACT_MANGLE_HDR_TYPE_ETH = 1,
	FLOW_ACT_MANGLE_HDR_TYPE_IP4 = 2,
	FLOW_ACT_MANGLE_HDR_TYPE_IP6 = 3,
	FLOW_ACT_MANGLE_HDR_TYPE_TCP = 4,
	FLOW_ACT_MANGLE_HDR_TYPE_UDP = 5,
};

enum flow_block_binder_type {
	FLOW_BLOCK_BINDER_TYPE_UNSPEC = 0,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_INGRESS = 1,
	FLOW_BLOCK_BINDER_TYPE_CLSACT_EGRESS = 2,
	FLOW_BLOCK_BINDER_TYPE_RED_EARLY_DROP = 3,
	FLOW_BLOCK_BINDER_TYPE_RED_MARK = 4,
};

enum flow_block_command {
	FLOW_BLOCK_BIND = 0,
	FLOW_BLOCK_UNBIND = 1,
};

enum flow_cls_command {
	FLOW_CLS_REPLACE = 0,
	FLOW_CLS_DESTROY = 1,
	FLOW_CLS_STATS = 2,
	FLOW_CLS_TMPLT_CREATE = 3,
	FLOW_CLS_TMPLT_DESTROY = 4,
};

enum flow_dissect_ret {
	FLOW_DISSECT_RET_OUT_GOOD = 0,
	FLOW_DISSECT_RET_OUT_BAD = 1,
	FLOW_DISSECT_RET_PROTO_AGAIN = 2,
	FLOW_DISSECT_RET_IPPROTO_AGAIN = 3,
	FLOW_DISSECT_RET_CONTINUE = 4,
};

enum flow_dissector_ctrl_flags {
	FLOW_DIS_IS_FRAGMENT = 1,
	FLOW_DIS_FIRST_FRAG = 2,
	FLOW_DIS_F_TUNNEL_CSUM = 4,
	FLOW_DIS_F_TUNNEL_DONT_FRAGMENT = 8,
	FLOW_DIS_F_TUNNEL_OAM = 16,
	FLOW_DIS_F_TUNNEL_CRIT_OPT = 32,
	FLOW_DIS_ENCAPSULATION = 64,
};

enum flow_dissector_key_id {
	FLOW_DISSECTOR_KEY_CONTROL = 0,
	FLOW_DISSECTOR_KEY_BASIC = 1,
	FLOW_DISSECTOR_KEY_IPV4_ADDRS = 2,
	FLOW_DISSECTOR_KEY_IPV6_ADDRS = 3,
	FLOW_DISSECTOR_KEY_PORTS = 4,
	FLOW_DISSECTOR_KEY_PORTS_RANGE = 5,
	FLOW_DISSECTOR_KEY_ICMP = 6,
	FLOW_DISSECTOR_KEY_ETH_ADDRS = 7,
	FLOW_DISSECTOR_KEY_TIPC = 8,
	FLOW_DISSECTOR_KEY_ARP = 9,
	FLOW_DISSECTOR_KEY_VLAN = 10,
	FLOW_DISSECTOR_KEY_FLOW_LABEL = 11,
	FLOW_DISSECTOR_KEY_GRE_KEYID = 12,
	FLOW_DISSECTOR_KEY_MPLS_ENTROPY = 13,
	FLOW_DISSECTOR_KEY_ENC_KEYID = 14,
	FLOW_DISSECTOR_KEY_ENC_IPV4_ADDRS = 15,
	FLOW_DISSECTOR_KEY_ENC_IPV6_ADDRS = 16,
	FLOW_DISSECTOR_KEY_ENC_CONTROL = 17,
	FLOW_DISSECTOR_KEY_ENC_PORTS = 18,
	FLOW_DISSECTOR_KEY_MPLS = 19,
	FLOW_DISSECTOR_KEY_TCP = 20,
	FLOW_DISSECTOR_KEY_IP = 21,
	FLOW_DISSECTOR_KEY_CVLAN = 22,
	FLOW_DISSECTOR_KEY_ENC_IP = 23,
	FLOW_DISSECTOR_KEY_ENC_OPTS = 24,
	FLOW_DISSECTOR_KEY_META = 25,
	FLOW_DISSECTOR_KEY_CT = 26,
	FLOW_DISSECTOR_KEY_HASH = 27,
	FLOW_DISSECTOR_KEY_NUM_OF_VLANS = 28,
	FLOW_DISSECTOR_KEY_PPPOE = 29,
	FLOW_DISSECTOR_KEY_L2TPV3 = 30,
	FLOW_DISSECTOR_KEY_CFM = 31,
	FLOW_DISSECTOR_KEY_IPSEC = 32,
	FLOW_DISSECTOR_KEY_MAX = 33,
};

enum flowlabel_reflect {
	FLOWLABEL_REFLECT_ESTABLISHED = 1,
	FLOWLABEL_REFLECT_TCP_RESET = 2,
	FLOWLABEL_REFLECT_ICMPV6_ECHO_REPLIES = 4,
};

enum folio_references {
	FOLIOREF_RECLAIM = 0,
	FOLIOREF_RECLAIM_CLEAN = 1,
	FOLIOREF_KEEP = 2,
	FOLIOREF_ACTIVATE = 3,
};

enum folio_walk_level {
	FW_LEVEL_PTE = 0,
	FW_LEVEL_PMD = 1,
	FW_LEVEL_PUD = 2,
};

enum format_state {
	FORMAT_STATE_NONE = 0,
	FORMAT_STATE_NUM = 1,
	FORMAT_STATE_WIDTH = 2,
	FORMAT_STATE_PRECISION = 3,
	FORMAT_STATE_CHAR = 4,
	FORMAT_STATE_STR = 5,
	FORMAT_STATE_PTR = 6,
	FORMAT_STATE_PERCENT_CHAR = 7,
	FORMAT_STATE_INVALID = 8,
};

enum fortify_func {
	FORTIFY_FUNC_strncpy = 0,
	FORTIFY_FUNC_strnlen = 1,
	FORTIFY_FUNC_strlen = 2,
	FORTIFY_FUNC_strscpy = 3,
	FORTIFY_FUNC_strlcat = 4,
	FORTIFY_FUNC_strcat = 5,
	FORTIFY_FUNC_strncat = 6,
	FORTIFY_FUNC_memset = 7,
	FORTIFY_FUNC_memcpy = 8,
	FORTIFY_FUNC_memmove = 9,
	FORTIFY_FUNC_memscan = 10,
	FORTIFY_FUNC_memcmp = 11,
	FORTIFY_FUNC_memchr = 12,
	FORTIFY_FUNC_memchr_inv = 13,
	FORTIFY_FUNC_kmemdup = 14,
	FORTIFY_FUNC_strcpy = 15,
	FORTIFY_FUNC_UNKNOWN = 16,
};

enum freeze_holder {
	FREEZE_HOLDER_KERNEL = 1,
	FREEZE_HOLDER_USERSPACE = 2,
	FREEZE_MAY_NEST = 4,
	FREEZE_EXCL = 8,
};

enum freezer_state_flags {
	CGROUP_FREEZER_ONLINE = 1,
	CGROUP_FREEZING_SELF = 2,
	CGROUP_FREEZING_PARENT = 4,
	CGROUP_FROZEN = 8,
	CGROUP_FREEZING = 6,
};

enum freq_qos_req_type {
	FREQ_QOS_MIN = 1,
	FREQ_QOS_MAX = 2,
};

enum fs_context_phase {
	FS_CONTEXT_CREATE_PARAMS = 0,
	FS_CONTEXT_CREATING = 1,
	FS_CONTEXT_AWAITING_MOUNT = 2,
	FS_CONTEXT_AWAITING_RECONF = 3,
	FS_CONTEXT_RECONF_PARAMS = 4,
	FS_CONTEXT_RECONFIGURING = 5,
	FS_CONTEXT_FAILED = 6,
};

enum fs_context_purpose {
	FS_CONTEXT_FOR_MOUNT = 0,
	FS_CONTEXT_FOR_SUBMOUNT = 1,
	FS_CONTEXT_FOR_RECONFIGURE = 2,
};

enum fs_value_type {
	fs_value_is_undefined = 0,
	fs_value_is_flag = 1,
	fs_value_is_string = 2,
	fs_value_is_blob = 3,
	fs_value_is_filename = 4,
	fs_value_is_file = 5,
};

enum fsconfig_command {
	FSCONFIG_SET_FLAG = 0,
	FSCONFIG_SET_STRING = 1,
	FSCONFIG_SET_BINARY = 2,
	FSCONFIG_SET_PATH = 3,
	FSCONFIG_SET_PATH_EMPTY = 4,
	FSCONFIG_SET_FD = 5,
	FSCONFIG_CMD_CREATE = 6,
	FSCONFIG_CMD_RECONFIGURE = 7,
	FSCONFIG_CMD_CREATE_EXCL = 8,
};

enum fsl_edma_pm_state {
	RUNNING = 0,
	SUSPENDED = 1,
};

enum fsl_mc_pool_type {
	FSL_MC_POOL_DPMCP = 0,
	FSL_MC_POOL_DPBP = 1,
	FSL_MC_POOL_DPCON = 2,
	FSL_MC_POOL_IRQ = 3,
	FSL_MC_NUM_POOL_TYPES = 4,
};

enum fsnotify_data_type {
	FSNOTIFY_EVENT_NONE = 0,
	FSNOTIFY_EVENT_FILE_RANGE = 1,
	FSNOTIFY_EVENT_PATH = 2,
	FSNOTIFY_EVENT_INODE = 3,
	FSNOTIFY_EVENT_DENTRY = 4,
	FSNOTIFY_EVENT_MNT = 5,
	FSNOTIFY_EVENT_ERROR = 6,
};

enum fsnotify_group_prio {
	FSNOTIFY_PRIO_NORMAL = 0,
	FSNOTIFY_PRIO_CONTENT = 1,
	FSNOTIFY_PRIO_PRE_CONTENT = 2,
	__FSNOTIFY_PRIO_NUM = 3,
};

enum fsnotify_iter_type {
	FSNOTIFY_ITER_TYPE_INODE = 0,
	FSNOTIFY_ITER_TYPE_VFSMOUNT = 1,
	FSNOTIFY_ITER_TYPE_SB = 2,
	FSNOTIFY_ITER_TYPE_PARENT = 3,
	FSNOTIFY_ITER_TYPE_INODE2 = 4,
	FSNOTIFY_ITER_TYPE_MNTNS = 5,
	FSNOTIFY_ITER_TYPE_COUNT = 6,
};

enum fsnotify_obj_type {
	FSNOTIFY_OBJ_TYPE_ANY = -1,
	FSNOTIFY_OBJ_TYPE_INODE = 0,
	FSNOTIFY_OBJ_TYPE_VFSMOUNT = 1,
	FSNOTIFY_OBJ_TYPE_SB = 2,
	FSNOTIFY_OBJ_TYPE_MNTNS = 3,
	FSNOTIFY_OBJ_TYPE_COUNT = 4,
	FSNOTIFY_OBJ_TYPE_DETACHED = 4,
};

enum fsync_mode {
	FSYNC_MODE_POSIX = 0,
	FSYNC_MODE_STRICT = 1,
	FSYNC_MODE_NOBARRIER = 2,
};

enum ftrace_dump_mode {
	DUMP_NONE = 0,
	DUMP_ALL = 1,
	DUMP_ORIG = 2,
	DUMP_PARAM = 3,
};

enum fullness_group {
	ZS_INUSE_RATIO_0 = 0,
	ZS_INUSE_RATIO_10 = 1,
	ZS_INUSE_RATIO_99 = 10,
	ZS_INUSE_RATIO_100 = 11,
	NR_FULLNESS_GROUPS = 12,
};

enum futex_access {
	FUTEX_READ = 0,
	FUTEX_WRITE = 1,
};

enum fw_opt {
	FW_OPT_UEVENT = 1,
	FW_OPT_NOWAIT = 2,
	FW_OPT_USERHELPER = 4,
	FW_OPT_NO_WARN = 8,
	FW_OPT_NOCACHE = 16,
	FW_OPT_NOFALLBACK_SYSFS = 32,
	FW_OPT_FALLBACK_PLATFORM = 64,
	FW_OPT_PARTIAL = 128,
};

enum fw_resource_type {
	RSC_CARVEOUT = 0,
	RSC_DEVMEM = 1,
	RSC_TRACE = 2,
	RSC_VDEV = 3,
	RSC_LAST = 4,
	RSC_VENDOR_START = 128,
	RSC_VENDOR_END = 512,
};

enum fw_status {
	FW_STATUS_UNKNOWN = 0,
	FW_STATUS_LOADING = 1,
	FW_STATUS_DONE = 2,
	FW_STATUS_ABORTED = 3,
};

enum fwh_lock_state {
	FWH_UNLOCKED = 0,
	FWH_DENY_WRITE = 1,
	FWH_IMMUTABLE = 2,
	FWH_DENY_READ = 4,
};

enum genl_validate_flags {
	GENL_DONT_VALIDATE_STRICT = 1,
	GENL_DONT_VALIDATE_DUMP = 2,
	GENL_DONT_VALIDATE_DUMP_STRICT = 4,
};

enum genpd_notication {
	GENPD_NOTIFY_PRE_OFF = 0,
	GENPD_NOTIFY_OFF = 1,
	GENPD_NOTIFY_PRE_ON = 2,
	GENPD_NOTIFY_ON = 3,
};

enum gic_type {
	GIC_V2 = 0,
	GIC_V3 = 1,
};

enum global_blend_mode {
	ALPHA_GLOBAL = 0,
	ALPHA_PER_PIX = 1,
	ALPHA_PER_PIX_GLOBAL = 2,
};

enum gpd_status {
	GENPD_STATE_ON = 0,
	GENPD_STATE_OFF = 1,
};

enum gpio_lookup_flags {
	GPIO_ACTIVE_HIGH = 0,
	GPIO_ACTIVE_LOW = 1,
	GPIO_OPEN_DRAIN = 2,
	GPIO_OPEN_SOURCE = 4,
	GPIO_PERSISTENT = 0,
	GPIO_TRANSITORY = 8,
	GPIO_PULL_UP = 16,
	GPIO_PULL_DOWN = 32,
	GPIO_PULL_DISABLE = 64,
	GPIO_LOOKUP_FLAGS_DEFAULT = 0,
};

enum gpio_select {
	NO_GPIO = 0,
	GPIO_1 = 1,
	GPIO_2 = 2,
};

enum gpio_v2_line_attr_id {
	GPIO_V2_LINE_ATTR_ID_FLAGS = 1,
	GPIO_V2_LINE_ATTR_ID_OUTPUT_VALUES = 2,
	GPIO_V2_LINE_ATTR_ID_DEBOUNCE = 3,
};

enum gpio_v2_line_changed_type {
	GPIO_V2_LINE_CHANGED_REQUESTED = 1,
	GPIO_V2_LINE_CHANGED_RELEASED = 2,
	GPIO_V2_LINE_CHANGED_CONFIG = 3,
};

enum gpio_v2_line_event_id {
	GPIO_V2_LINE_EVENT_RISING_EDGE = 1,
	GPIO_V2_LINE_EVENT_FALLING_EDGE = 2,
};

enum gpio_v2_line_flag {
	GPIO_V2_LINE_FLAG_USED = 1,
	GPIO_V2_LINE_FLAG_ACTIVE_LOW = 2,
	GPIO_V2_LINE_FLAG_INPUT = 4,
	GPIO_V2_LINE_FLAG_OUTPUT = 8,
	GPIO_V2_LINE_FLAG_EDGE_RISING = 16,
	GPIO_V2_LINE_FLAG_EDGE_FALLING = 32,
	GPIO_V2_LINE_FLAG_OPEN_DRAIN = 64,
	GPIO_V2_LINE_FLAG_OPEN_SOURCE = 128,
	GPIO_V2_LINE_FLAG_BIAS_PULL_UP = 256,
	GPIO_V2_LINE_FLAG_BIAS_PULL_DOWN = 512,
	GPIO_V2_LINE_FLAG_BIAS_DISABLED = 1024,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_REALTIME = 2048,
	GPIO_V2_LINE_FLAG_EVENT_CLOCK_HTE = 4096,
};

enum gpiod_flags {
	GPIOD_ASIS = 0,
	GPIOD_IN = 1,
	GPIOD_OUT_LOW = 3,
	GPIOD_OUT_HIGH = 7,
	GPIOD_OUT_LOW_OPEN_DRAIN = 11,
	GPIOD_OUT_HIGH_OPEN_DRAIN = 15,
};

enum gpmc_clk_domain {
	GPMC_CD_FCLK = 0,
	GPMC_CD_CLK = 1,
};

enum gpmi_type {
	IS_MX23 = 0,
	IS_MX28 = 1,
	IS_MX6Q = 2,
	IS_MX6SX = 3,
	IS_MX7D = 4,
	IS_MX8QXP = 5,
};

enum gre_conntrack {
	GRE_CT_UNREPLIED = 0,
	GRE_CT_REPLIED = 1,
	GRE_CT_MAX = 2,
};

enum gro_result {
	GRO_MERGED = 0,
	GRO_MERGED_FREE = 1,
	GRO_HELD = 2,
	GRO_NORMAL = 3,
	GRO_CONSUMED = 4,
};

typedef enum gro_result gro_result_t;

enum group_type {
	group_has_spare = 0,
	group_fully_busy = 1,
	group_misfit_task = 2,
	group_smt_balance = 3,
	group_asym_packing = 4,
	group_imbalanced = 5,
	group_overloaded = 6,
};

enum handle_to_path_flags {
	HANDLE_CHECK_PERMS = 1,
	HANDLE_CHECK_SUBTREE = 2,
};

enum handshake_auth {
	HANDSHAKE_AUTH_UNSPEC = 0,
	HANDSHAKE_AUTH_UNAUTH = 1,
	HANDSHAKE_AUTH_PSK = 2,
	HANDSHAKE_AUTH_X509 = 3,
};

enum handshake_handler_class {
	HANDSHAKE_HANDLER_CLASS_NONE = 0,
	HANDSHAKE_HANDLER_CLASS_TLSHD = 1,
	HANDSHAKE_HANDLER_CLASS_MAX = 2,
};

enum handshake_msg_type {
	HANDSHAKE_MSG_TYPE_UNSPEC = 0,
	HANDSHAKE_MSG_TYPE_CLIENTHELLO = 1,
	HANDSHAKE_MSG_TYPE_SERVERHELLO = 2,
};

enum hash_algo {
	HASH_ALGO_MD4 = 0,
	HASH_ALGO_MD5 = 1,
	HASH_ALGO_SHA1 = 2,
	HASH_ALGO_RIPE_MD_160 = 3,
	HASH_ALGO_SHA256 = 4,
	HASH_ALGO_SHA384 = 5,
	HASH_ALGO_SHA512 = 6,
	HASH_ALGO_SHA224 = 7,
	HASH_ALGO_RIPE_MD_128 = 8,
	HASH_ALGO_RIPE_MD_256 = 9,
	HASH_ALGO_RIPE_MD_320 = 10,
	HASH_ALGO_WP_256 = 11,
	HASH_ALGO_WP_384 = 12,
	HASH_ALGO_WP_512 = 13,
	HASH_ALGO_TGR_128 = 14,
	HASH_ALGO_TGR_160 = 15,
	HASH_ALGO_TGR_192 = 16,
	HASH_ALGO_SM3_256 = 17,
	HASH_ALGO_STREEBOG_256 = 18,
	HASH_ALGO_STREEBOG_512 = 19,
	HASH_ALGO_SHA3_256 = 20,
	HASH_ALGO_SHA3_384 = 21,
	HASH_ALGO_SHA3_512 = 22,
	HASH_ALGO__LAST = 23,
};

enum hctx_type {
	HCTX_TYPE_DEFAULT = 0,
	HCTX_TYPE_READ = 1,
	HCTX_TYPE_POLL = 2,
	HCTX_MAX_TYPES = 3,
};

enum hdmi_3d_structure {
	HDMI_3D_STRUCTURE_INVALID = -1,
	HDMI_3D_STRUCTURE_FRAME_PACKING = 0,
	HDMI_3D_STRUCTURE_FIELD_ALTERNATIVE = 1,
	HDMI_3D_STRUCTURE_LINE_ALTERNATIVE = 2,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_FULL = 3,
	HDMI_3D_STRUCTURE_L_DEPTH = 4,
	HDMI_3D_STRUCTURE_L_DEPTH_GFX_GFX_DEPTH = 5,
	HDMI_3D_STRUCTURE_TOP_AND_BOTTOM = 6,
	HDMI_3D_STRUCTURE_SIDE_BY_SIDE_HALF = 8,
};

enum hdmi_acr_cts {
	ACR_NONE = 0,
	ACR_32 = 1,
	ACR_44 = 2,
	ACR_48 = 3,
};

enum hdmi_active_aspect {
	HDMI_ACTIVE_ASPECT_16_9_TOP = 2,
	HDMI_ACTIVE_ASPECT_14_9_TOP = 3,
	HDMI_ACTIVE_ASPECT_16_9_CENTER = 4,
	HDMI_ACTIVE_ASPECT_PICTURE = 8,
	HDMI_ACTIVE_ASPECT_4_3 = 9,
	HDMI_ACTIVE_ASPECT_16_9 = 10,
	HDMI_ACTIVE_ASPECT_14_9 = 11,
	HDMI_ACTIVE_ASPECT_4_3_SP_14_9 = 13,
	HDMI_ACTIVE_ASPECT_16_9_SP_14_9 = 14,
	HDMI_ACTIVE_ASPECT_16_9_SP_4_3 = 15,
};

enum hdmi_audio_coding_type {
	HDMI_AUDIO_CODING_TYPE_STREAM = 0,
	HDMI_AUDIO_CODING_TYPE_PCM = 1,
	HDMI_AUDIO_CODING_TYPE_AC3 = 2,
	HDMI_AUDIO_CODING_TYPE_MPEG1 = 3,
	HDMI_AUDIO_CODING_TYPE_MP3 = 4,
	HDMI_AUDIO_CODING_TYPE_MPEG2 = 5,
	HDMI_AUDIO_CODING_TYPE_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_DTS = 7,
	HDMI_AUDIO_CODING_TYPE_ATRAC = 8,
	HDMI_AUDIO_CODING_TYPE_DSD = 9,
	HDMI_AUDIO_CODING_TYPE_EAC3 = 10,
	HDMI_AUDIO_CODING_TYPE_DTS_HD = 11,
	HDMI_AUDIO_CODING_TYPE_MLP = 12,
	HDMI_AUDIO_CODING_TYPE_DST = 13,
	HDMI_AUDIO_CODING_TYPE_WMA_PRO = 14,
	HDMI_AUDIO_CODING_TYPE_CXT = 15,
};

enum hdmi_audio_coding_type_ext {
	HDMI_AUDIO_CODING_TYPE_EXT_CT = 0,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC = 1,
	HDMI_AUDIO_CODING_TYPE_EXT_HE_AAC_V2 = 2,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG_SURROUND = 3,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC = 4,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_V2 = 5,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC = 6,
	HDMI_AUDIO_CODING_TYPE_EXT_DRA = 7,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_HE_AAC_SURROUND = 8,
	HDMI_AUDIO_CODING_TYPE_EXT_MPEG4_AAC_LC_SURROUND = 10,
};

enum hdmi_audio_sample_frequency {
	HDMI_AUDIO_SAMPLE_FREQUENCY_STREAM = 0,
	HDMI_AUDIO_SAMPLE_FREQUENCY_32000 = 1,
	HDMI_AUDIO_SAMPLE_FREQUENCY_44100 = 2,
	HDMI_AUDIO_SAMPLE_FREQUENCY_48000 = 3,
	HDMI_AUDIO_SAMPLE_FREQUENCY_88200 = 4,
	HDMI_AUDIO_SAMPLE_FREQUENCY_96000 = 5,
	HDMI_AUDIO_SAMPLE_FREQUENCY_176400 = 6,
	HDMI_AUDIO_SAMPLE_FREQUENCY_192000 = 7,
};

enum hdmi_audio_sample_size {
	HDMI_AUDIO_SAMPLE_SIZE_STREAM = 0,
	HDMI_AUDIO_SAMPLE_SIZE_16 = 1,
	HDMI_AUDIO_SAMPLE_SIZE_20 = 2,
	HDMI_AUDIO_SAMPLE_SIZE_24 = 3,
};

enum hdmi_colorimetry {
	HDMI_COLORIMETRY_NONE = 0,
	HDMI_COLORIMETRY_ITU_601 = 1,
	HDMI_COLORIMETRY_ITU_709 = 2,
	HDMI_COLORIMETRY_EXTENDED = 3,
};

enum hdmi_colorspace {
	HDMI_COLORSPACE_RGB = 0,
	HDMI_COLORSPACE_YUV422 = 1,
	HDMI_COLORSPACE_YUV444 = 2,
	HDMI_COLORSPACE_YUV420 = 3,
	HDMI_COLORSPACE_RESERVED4 = 4,
	HDMI_COLORSPACE_RESERVED5 = 5,
	HDMI_COLORSPACE_RESERVED6 = 6,
	HDMI_COLORSPACE_IDO_DEFINED = 7,
};

enum hdmi_content_type {
	HDMI_CONTENT_TYPE_GRAPHICS = 0,
	HDMI_CONTENT_TYPE_PHOTO = 1,
	HDMI_CONTENT_TYPE_CINEMA = 2,
	HDMI_CONTENT_TYPE_GAME = 3,
};

enum hdmi_ddc_read_write {
	DDC_WRITE = 0,
	DDC_READ = 1,
};

enum hdmi_eotf {
	HDMI_EOTF_TRADITIONAL_GAMMA_SDR = 0,
	HDMI_EOTF_TRADITIONAL_GAMMA_HDR = 1,
	HDMI_EOTF_SMPTE_ST2084 = 2,
	HDMI_EOTF_BT_2100_HLG = 3,
};

enum hdmi_extended_colorimetry {
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_601 = 0,
	HDMI_EXTENDED_COLORIMETRY_XV_YCC_709 = 1,
	HDMI_EXTENDED_COLORIMETRY_S_YCC_601 = 2,
	HDMI_EXTENDED_COLORIMETRY_OPYCC_601 = 3,
	HDMI_EXTENDED_COLORIMETRY_OPRGB = 4,
	HDMI_EXTENDED_COLORIMETRY_BT2020_CONST_LUM = 5,
	HDMI_EXTENDED_COLORIMETRY_BT2020 = 6,
	HDMI_EXTENDED_COLORIMETRY_RESERVED = 7,
};

enum hdmi_hdcp_key_state {
	HDCP_KEYS_STATE_NO_KEYS = 0,
	HDCP_KEYS_STATE_NOT_CHECKED = 1,
	HDCP_KEYS_STATE_CHECKING = 2,
	HDCP_KEYS_STATE_VALID = 3,
	HDCP_KEYS_STATE_AKSV_NOT_VALID = 4,
	HDCP_KEYS_STATE_CHKSUM_MISMATCH = 5,
	HDCP_KEYS_STATE_PROD_AKSV = 6,
	HDCP_KEYS_STATE_RESERVED = 7,
};

enum hdmi_hdcp_state {
	HDCP_STATE_NO_AKSV = 0,
	HDCP_STATE_INACTIVE = 1,
	HDCP_STATE_AUTHENTICATING = 2,
	HDCP_STATE_AUTHENTICATED = 3,
	HDCP_STATE_AUTH_FAILED = 4,
};

enum hdmi_infoframe_type {
	HDMI_INFOFRAME_TYPE_VENDOR = 129,
	HDMI_INFOFRAME_TYPE_AVI = 130,
	HDMI_INFOFRAME_TYPE_SPD = 131,
	HDMI_INFOFRAME_TYPE_AUDIO = 132,
	HDMI_INFOFRAME_TYPE_DRM = 135,
};

enum hdmi_mapped_regs {
	HDMI_PHY_STATUS = 4294901760,
	HDMI_PHY_RSTOUT = 4294901761,
	HDMI_ACR_CON = 4294901762,
	HDMI_ACR_MCTS0 = 4294901763,
	HDMI_ACR_CTS0 = 4294901764,
	HDMI_ACR_N0 = 4294901765,
};

enum hdmi_metadata_type {
	HDMI_STATIC_METADATA_TYPE1 = 0,
};

enum hdmi_nups {
	HDMI_NUPS_UNKNOWN = 0,
	HDMI_NUPS_HORIZONTAL = 1,
	HDMI_NUPS_VERTICAL = 2,
	HDMI_NUPS_BOTH = 3,
};

enum hdmi_phy_type {
	MSM_HDMI_PHY_8x60 = 0,
	MSM_HDMI_PHY_8960 = 1,
	MSM_HDMI_PHY_8x74 = 2,
	MSM_HDMI_PHY_8996 = 3,
	MSM_HDMI_PHY_8998 = 4,
	MSM_HDMI_PHY_MAX = 5,
};

enum hdmi_picture_aspect {
	HDMI_PICTURE_ASPECT_NONE = 0,
	HDMI_PICTURE_ASPECT_4_3 = 1,
	HDMI_PICTURE_ASPECT_16_9 = 2,
	HDMI_PICTURE_ASPECT_64_27 = 3,
	HDMI_PICTURE_ASPECT_256_135 = 4,
	HDMI_PICTURE_ASPECT_RESERVED = 5,
};

enum hdmi_quantization_range {
	HDMI_QUANTIZATION_RANGE_DEFAULT = 0,
	HDMI_QUANTIZATION_RANGE_LIMITED = 1,
	HDMI_QUANTIZATION_RANGE_FULL = 2,
	HDMI_QUANTIZATION_RANGE_RESERVED = 3,
};

enum hdmi_scan_mode {
	HDMI_SCAN_MODE_NONE = 0,
	HDMI_SCAN_MODE_OVERSCAN = 1,
	HDMI_SCAN_MODE_UNDERSCAN = 2,
	HDMI_SCAN_MODE_RESERVED = 3,
};

enum hdmi_spd_sdi {
	HDMI_SPD_SDI_UNKNOWN = 0,
	HDMI_SPD_SDI_DSTB = 1,
	HDMI_SPD_SDI_DVDP = 2,
	HDMI_SPD_SDI_DVHS = 3,
	HDMI_SPD_SDI_HDDVR = 4,
	HDMI_SPD_SDI_DVC = 5,
	HDMI_SPD_SDI_DSC = 6,
	HDMI_SPD_SDI_VCD = 7,
	HDMI_SPD_SDI_GAME = 8,
	HDMI_SPD_SDI_PC = 9,
	HDMI_SPD_SDI_BD = 10,
	HDMI_SPD_SDI_SACD = 11,
	HDMI_SPD_SDI_HDDVD = 12,
	HDMI_SPD_SDI_PMP = 13,
};

enum hdmi_type {
	HDMI_TYPE13 = 0,
	HDMI_TYPE14 = 1,
	HDMI_TYPE_COUNT = 2,
};

enum hdmi_ycc_quantization_range {
	HDMI_YCC_QUANTIZATION_RANGE_LIMITED = 0,
	HDMI_YCC_QUANTIZATION_RANGE_FULL = 1,
};

enum hid_battery_status {
	HID_BATTERY_UNKNOWN = 0,
	HID_BATTERY_QUERIED = 1,
	HID_BATTERY_REPORTED = 2,
};

enum hid_class_request {
	HID_REQ_GET_REPORT = 1,
	HID_REQ_GET_IDLE = 2,
	HID_REQ_GET_PROTOCOL = 3,
	HID_REQ_SET_REPORT = 9,
	HID_REQ_SET_IDLE = 10,
	HID_REQ_SET_PROTOCOL = 11,
};

enum hid_report_type {
	HID_INPUT_REPORT = 0,
	HID_OUTPUT_REPORT = 1,
	HID_FEATURE_REPORT = 2,
	HID_REPORT_TYPES = 3,
};

enum hid_type {
	HID_TYPE_OTHER = 0,
	HID_TYPE_USBMOUSE = 1,
	HID_TYPE_USBNONE = 2,
};

enum hk_flags {
	HK_FLAG_DOMAIN = 1,
	HK_FLAG_MANAGED_IRQ = 2,
	HK_FLAG_KERNEL_NOISE = 4,
};

enum hk_type {
	HK_TYPE_DOMAIN = 0,
	HK_TYPE_MANAGED_IRQ = 1,
	HK_TYPE_KERNEL_NOISE = 2,
	HK_TYPE_MAX = 3,
	HK_TYPE_TICK = 2,
	HK_TYPE_TIMER = 2,
	HK_TYPE_RCU = 2,
	HK_TYPE_MISC = 2,
	HK_TYPE_WQ = 2,
	HK_TYPE_KTHREAD = 2,
};

enum hn_flags_bits {
	HANDSHAKE_F_NET_DRAINING = 0,
};

enum host_event_code {
	EC_HOST_EVENT_LID_CLOSED = 1,
	EC_HOST_EVENT_LID_OPEN = 2,
	EC_HOST_EVENT_POWER_BUTTON = 3,
	EC_HOST_EVENT_AC_CONNECTED = 4,
	EC_HOST_EVENT_AC_DISCONNECTED = 5,
	EC_HOST_EVENT_BATTERY_LOW = 6,
	EC_HOST_EVENT_BATTERY_CRITICAL = 7,
	EC_HOST_EVENT_BATTERY = 8,
	EC_HOST_EVENT_THERMAL_THRESHOLD = 9,
	EC_HOST_EVENT_DEVICE = 10,
	EC_HOST_EVENT_THERMAL = 11,
	EC_HOST_EVENT_USB_CHARGER = 12,
	EC_HOST_EVENT_KEY_PRESSED = 13,
	EC_HOST_EVENT_INTERFACE_READY = 14,
	EC_HOST_EVENT_KEYBOARD_RECOVERY = 15,
	EC_HOST_EVENT_THERMAL_SHUTDOWN = 16,
	EC_HOST_EVENT_BATTERY_SHUTDOWN = 17,
	EC_HOST_EVENT_THROTTLE_START = 18,
	EC_HOST_EVENT_THROTTLE_STOP = 19,
	EC_HOST_EVENT_HANG_DETECT = 20,
	EC_HOST_EVENT_HANG_REBOOT = 21,
	EC_HOST_EVENT_PD_MCU = 22,
	EC_HOST_EVENT_BATTERY_STATUS = 23,
	EC_HOST_EVENT_PANIC = 24,
	EC_HOST_EVENT_KEYBOARD_FASTBOOT = 25,
	EC_HOST_EVENT_RTC = 26,
	EC_HOST_EVENT_MKBP = 27,
	EC_HOST_EVENT_USB_MUX = 28,
	EC_HOST_EVENT_MODE_CHANGE = 29,
	EC_HOST_EVENT_KEYBOARD_RECOVERY_HW_REINIT = 30,
	EC_HOST_EVENT_WOV = 31,
	EC_HOST_EVENT_INVALID = 32,
};

enum host_sleep_event {
	HOST_SLEEP_EVENT_S3_SUSPEND = 1,
	HOST_SLEEP_EVENT_S3_RESUME = 2,
	HOST_SLEEP_EVENT_S0IX_SUSPEND = 3,
	HOST_SLEEP_EVENT_S0IX_RESUME = 4,
	HOST_SLEEP_EVENT_S3_WAKEABLE_SUSPEND = 5,
};

enum hp_flags_bits {
	HANDSHAKE_F_PROTO_NOTIFY = 0,
};

enum hr_flags_bits {
	HANDSHAKE_F_REQ_COMPLETED = 0,
	HANDSHAKE_F_REQ_SESSION = 1,
};

enum hrtimer_base_type {
	HRTIMER_BASE_MONOTONIC = 0,
	HRTIMER_BASE_REALTIME = 1,
	HRTIMER_BASE_BOOTTIME = 2,
	HRTIMER_BASE_TAI = 3,
	HRTIMER_BASE_MONOTONIC_SOFT = 4,
	HRTIMER_BASE_REALTIME_SOFT = 5,
	HRTIMER_BASE_BOOTTIME_SOFT = 6,
	HRTIMER_BASE_TAI_SOFT = 7,
	HRTIMER_MAX_CLOCK_BASES = 8,
};

enum hrtimer_mode {
	HRTIMER_MODE_ABS = 0,
	HRTIMER_MODE_REL = 1,
	HRTIMER_MODE_PINNED = 2,
	HRTIMER_MODE_SOFT = 4,
	HRTIMER_MODE_HARD = 8,
	HRTIMER_MODE_ABS_PINNED = 2,
	HRTIMER_MODE_REL_PINNED = 3,
	HRTIMER_MODE_ABS_SOFT = 4,
	HRTIMER_MODE_REL_SOFT = 5,
	HRTIMER_MODE_ABS_PINNED_SOFT = 6,
	HRTIMER_MODE_REL_PINNED_SOFT = 7,
	HRTIMER_MODE_ABS_HARD = 8,
	HRTIMER_MODE_REL_HARD = 9,
	HRTIMER_MODE_ABS_PINNED_HARD = 10,
	HRTIMER_MODE_REL_PINNED_HARD = 11,
};

enum hrtimer_restart {
	HRTIMER_NORESTART = 0,
	HRTIMER_RESTART = 1,
};

enum hsm_task_states {
	HSM_ST_IDLE = 0,
	HSM_ST_FIRST = 1,
	HSM_ST = 2,
	HSM_ST_LAST = 3,
	HSM_ST_ERR = 4,
};

enum hub_activation_type {
	HUB_INIT = 0,
	HUB_INIT2 = 1,
	HUB_INIT3 = 2,
	HUB_POST_RESET = 3,
	HUB_RESUME = 4,
	HUB_RESET_RESUME = 5,
};

enum hub_led_mode {
	INDICATOR_AUTO = 0,
	INDICATOR_CYCLE = 1,
	INDICATOR_GREEN_BLINK = 2,
	INDICATOR_GREEN_BLINK_OFF = 3,
	INDICATOR_AMBER_BLINK = 4,
	INDICATOR_AMBER_BLINK_OFF = 5,
	INDICATOR_ALT_BLINK = 6,
	INDICATOR_ALT_BLINK_OFF = 7,
} __attribute__((mode(byte)));

enum hub_quiescing_type {
	HUB_DISCONNECT = 0,
	HUB_PRE_RESET = 1,
	HUB_SUSPEND = 2,
};

enum hw_event_mc_err_type {
	HW_EVENT_ERR_CORRECTED = 0,
	HW_EVENT_ERR_UNCORRECTED = 1,
	HW_EVENT_ERR_DEFERRED = 2,
	HW_EVENT_ERR_FATAL = 3,
	HW_EVENT_ERR_INFO = 4,
};

enum hw_protection_action {
	HWPROT_ACT_DEFAULT = 0,
	HWPROT_ACT_SHUTDOWN = 1,
	HWPROT_ACT_REBOOT = 2,
};

enum hwmon_chip_attributes {
	hwmon_chip_temp_reset_history = 0,
	hwmon_chip_in_reset_history = 1,
	hwmon_chip_curr_reset_history = 2,
	hwmon_chip_power_reset_history = 3,
	hwmon_chip_register_tz = 4,
	hwmon_chip_update_interval = 5,
	hwmon_chip_alarms = 6,
	hwmon_chip_samples = 7,
	hwmon_chip_curr_samples = 8,
	hwmon_chip_in_samples = 9,
	hwmon_chip_power_samples = 10,
	hwmon_chip_temp_samples = 11,
	hwmon_chip_beep_enable = 12,
	hwmon_chip_pec = 13,
};

enum hwmon_curr_attributes {
	hwmon_curr_enable = 0,
	hwmon_curr_input = 1,
	hwmon_curr_min = 2,
	hwmon_curr_max = 3,
	hwmon_curr_lcrit = 4,
	hwmon_curr_crit = 5,
	hwmon_curr_average = 6,
	hwmon_curr_lowest = 7,
	hwmon_curr_highest = 8,
	hwmon_curr_reset_history = 9,
	hwmon_curr_label = 10,
	hwmon_curr_alarm = 11,
	hwmon_curr_min_alarm = 12,
	hwmon_curr_max_alarm = 13,
	hwmon_curr_lcrit_alarm = 14,
	hwmon_curr_crit_alarm = 15,
	hwmon_curr_rated_min = 16,
	hwmon_curr_rated_max = 17,
	hwmon_curr_beep = 18,
};

enum hwmon_energy_attributes {
	hwmon_energy_enable = 0,
	hwmon_energy_input = 1,
	hwmon_energy_label = 2,
};

enum hwmon_fan_attributes {
	hwmon_fan_enable = 0,
	hwmon_fan_input = 1,
	hwmon_fan_label = 2,
	hwmon_fan_min = 3,
	hwmon_fan_max = 4,
	hwmon_fan_div = 5,
	hwmon_fan_pulses = 6,
	hwmon_fan_target = 7,
	hwmon_fan_alarm = 8,
	hwmon_fan_min_alarm = 9,
	hwmon_fan_max_alarm = 10,
	hwmon_fan_fault = 11,
	hwmon_fan_beep = 12,
};

enum hwmon_humidity_attributes {
	hwmon_humidity_enable = 0,
	hwmon_humidity_input = 1,
	hwmon_humidity_label = 2,
	hwmon_humidity_min = 3,
	hwmon_humidity_min_hyst = 4,
	hwmon_humidity_max = 5,
	hwmon_humidity_max_hyst = 6,
	hwmon_humidity_alarm = 7,
	hwmon_humidity_fault = 8,
	hwmon_humidity_rated_min = 9,
	hwmon_humidity_rated_max = 10,
	hwmon_humidity_min_alarm = 11,
	hwmon_humidity_max_alarm = 12,
};

enum hwmon_in_attributes {
	hwmon_in_enable = 0,
	hwmon_in_input = 1,
	hwmon_in_min = 2,
	hwmon_in_max = 3,
	hwmon_in_lcrit = 4,
	hwmon_in_crit = 5,
	hwmon_in_average = 6,
	hwmon_in_lowest = 7,
	hwmon_in_highest = 8,
	hwmon_in_reset_history = 9,
	hwmon_in_label = 10,
	hwmon_in_alarm = 11,
	hwmon_in_min_alarm = 12,
	hwmon_in_max_alarm = 13,
	hwmon_in_lcrit_alarm = 14,
	hwmon_in_crit_alarm = 15,
	hwmon_in_rated_min = 16,
	hwmon_in_rated_max = 17,
	hwmon_in_beep = 18,
	hwmon_in_fault = 19,
};

enum hwmon_intrusion_attributes {
	hwmon_intrusion_alarm = 0,
	hwmon_intrusion_beep = 1,
};

enum hwmon_power_attributes {
	hwmon_power_enable = 0,
	hwmon_power_average = 1,
	hwmon_power_average_interval = 2,
	hwmon_power_average_interval_max = 3,
	hwmon_power_average_interval_min = 4,
	hwmon_power_average_highest = 5,
	hwmon_power_average_lowest = 6,
	hwmon_power_average_max = 7,
	hwmon_power_average_min = 8,
	hwmon_power_input = 9,
	hwmon_power_input_highest = 10,
	hwmon_power_input_lowest = 11,
	hwmon_power_reset_history = 12,
	hwmon_power_accuracy = 13,
	hwmon_power_cap = 14,
	hwmon_power_cap_hyst = 15,
	hwmon_power_cap_max = 16,
	hwmon_power_cap_min = 17,
	hwmon_power_min = 18,
	hwmon_power_max = 19,
	hwmon_power_crit = 20,
	hwmon_power_lcrit = 21,
	hwmon_power_label = 22,
	hwmon_power_alarm = 23,
	hwmon_power_cap_alarm = 24,
	hwmon_power_min_alarm = 25,
	hwmon_power_max_alarm = 26,
	hwmon_power_lcrit_alarm = 27,
	hwmon_power_crit_alarm = 28,
	hwmon_power_rated_min = 29,
	hwmon_power_rated_max = 30,
};

enum hwmon_pwm_attributes {
	hwmon_pwm_input = 0,
	hwmon_pwm_enable = 1,
	hwmon_pwm_mode = 2,
	hwmon_pwm_freq = 3,
	hwmon_pwm_auto_channels_temp = 4,
};

enum hwmon_sensor_types {
	hwmon_chip = 0,
	hwmon_temp = 1,
	hwmon_in = 2,
	hwmon_curr = 3,
	hwmon_power = 4,
	hwmon_energy = 5,
	hwmon_humidity = 6,
	hwmon_fan = 7,
	hwmon_pwm = 8,
	hwmon_intrusion = 9,
	hwmon_max = 10,
};

enum hwmon_temp_attributes {
	hwmon_temp_enable = 0,
	hwmon_temp_input = 1,
	hwmon_temp_type = 2,
	hwmon_temp_lcrit = 3,
	hwmon_temp_lcrit_hyst = 4,
	hwmon_temp_min = 5,
	hwmon_temp_min_hyst = 6,
	hwmon_temp_max = 7,
	hwmon_temp_max_hyst = 8,
	hwmon_temp_crit = 9,
	hwmon_temp_crit_hyst = 10,
	hwmon_temp_emergency = 11,
	hwmon_temp_emergency_hyst = 12,
	hwmon_temp_alarm = 13,
	hwmon_temp_lcrit_alarm = 14,
	hwmon_temp_min_alarm = 15,
	hwmon_temp_max_alarm = 16,
	hwmon_temp_crit_alarm = 17,
	hwmon_temp_emergency_alarm = 18,
	hwmon_temp_fault = 19,
	hwmon_temp_offset = 20,
	hwmon_temp_label = 21,
	hwmon_temp_lowest = 22,
	hwmon_temp_highest = 23,
	hwmon_temp_reset_history = 24,
	hwmon_temp_rated_min = 25,
	hwmon_temp_rated_max = 26,
	hwmon_temp_beep = 27,
};

enum hwparam_type {
	hwparam_ioport = 0,
	hwparam_iomem = 1,
	hwparam_ioport_or_iomem = 2,
	hwparam_irq = 3,
	hwparam_dma = 4,
	hwparam_dma_addr = 5,
	hwparam_other = 6,
};

enum hwtstamp_flags {
	HWTSTAMP_FLAG_BONDED_PHC_INDEX = 1,
	HWTSTAMP_FLAG_LAST = 1,
	HWTSTAMP_FLAG_MASK = 1,
};

enum hwtstamp_provider_qualifier {
	HWTSTAMP_PROVIDER_QUALIFIER_PRECISE = 0,
	HWTSTAMP_PROVIDER_QUALIFIER_APPROX = 1,
	HWTSTAMP_PROVIDER_QUALIFIER_CNT = 2,
};

enum hwtstamp_rx_filters {
	HWTSTAMP_FILTER_NONE = 0,
	HWTSTAMP_FILTER_ALL = 1,
	HWTSTAMP_FILTER_SOME = 2,
	HWTSTAMP_FILTER_PTP_V1_L4_EVENT = 3,
	HWTSTAMP_FILTER_PTP_V1_L4_SYNC = 4,
	HWTSTAMP_FILTER_PTP_V1_L4_DELAY_REQ = 5,
	HWTSTAMP_FILTER_PTP_V2_L4_EVENT = 6,
	HWTSTAMP_FILTER_PTP_V2_L4_SYNC = 7,
	HWTSTAMP_FILTER_PTP_V2_L4_DELAY_REQ = 8,
	HWTSTAMP_FILTER_PTP_V2_L2_EVENT = 9,
	HWTSTAMP_FILTER_PTP_V2_L2_SYNC = 10,
	HWTSTAMP_FILTER_PTP_V2_L2_DELAY_REQ = 11,
	HWTSTAMP_FILTER_PTP_V2_EVENT = 12,
	HWTSTAMP_FILTER_PTP_V2_SYNC = 13,
	HWTSTAMP_FILTER_PTP_V2_DELAY_REQ = 14,
	HWTSTAMP_FILTER_NTP_ALL = 15,
	__HWTSTAMP_FILTER_CNT = 16,
};

enum hwtstamp_source {
	HWTSTAMP_SOURCE_NETDEV = 1,
	HWTSTAMP_SOURCE_PHYLIB = 2,
};

enum hwtstamp_tx_types {
	HWTSTAMP_TX_OFF = 0,
	HWTSTAMP_TX_ON = 1,
	HWTSTAMP_TX_ONESTEP_SYNC = 2,
	HWTSTAMP_TX_ONESTEP_P2P = 3,
	__HWTSTAMP_TX_CNT = 4,
};

enum i2c_alert_protocol {
	I2C_PROTOCOL_SMBUS_ALERT = 0,
	I2C_PROTOCOL_SMBUS_HOST_NOTIFY = 1,
};

enum i2c_driver_flags {
	I2C_DRV_ACPI_WAIVE_D0_PROBE = 1,
};

enum i2c_scl_freq {
	REG_VALUES_100KHZ = 0,
	REG_VALUES_400KHZ = 1,
	REG_VALUES_1MHZ = 2,
};

enum i2c_slave_event {
	I2C_SLAVE_READ_REQUESTED = 0,
	I2C_SLAVE_WRITE_REQUESTED = 1,
	I2C_SLAVE_READ_PROCESSED = 2,
	I2C_SLAVE_WRITE_RECEIVED = 3,
	I2C_SLAVE_STOP = 4,
};

enum i2c_type_exynos {
	I2C_TYPE_EXYNOS5 = 0,
	I2C_TYPE_EXYNOS7 = 1,
	I2C_TYPE_EXYNOSAUTOV9 = 2,
	I2C_TYPE_EXYNOS8895 = 3,
};

enum ib_atomic_cap {
	IB_ATOMIC_NONE = 0,
	IB_ATOMIC_HCA = 1,
	IB_ATOMIC_GLOB = 2,
};

enum ib_cq_notify_flags {
	IB_CQ_SOLICITED = 1,
	IB_CQ_NEXT_COMP = 2,
	IB_CQ_SOLICITED_MASK = 3,
	IB_CQ_REPORT_MISSED_EVENTS = 4,
};

enum ib_event_type {
	IB_EVENT_CQ_ERR = 0,
	IB_EVENT_QP_FATAL = 1,
	IB_EVENT_QP_REQ_ERR = 2,
	IB_EVENT_QP_ACCESS_ERR = 3,
	IB_EVENT_COMM_EST = 4,
	IB_EVENT_SQ_DRAINED = 5,
	IB_EVENT_PATH_MIG = 6,
	IB_EVENT_PATH_MIG_ERR = 7,
	IB_EVENT_DEVICE_FATAL = 8,
	IB_EVENT_PORT_ACTIVE = 9,
	IB_EVENT_PORT_ERR = 10,
	IB_EVENT_LID_CHANGE = 11,
	IB_EVENT_PKEY_CHANGE = 12,
	IB_EVENT_SM_CHANGE = 13,
	IB_EVENT_SRQ_ERR = 14,
	IB_EVENT_SRQ_LIMIT_REACHED = 15,
	IB_EVENT_QP_LAST_WQE_REACHED = 16,
	IB_EVENT_CLIENT_REREGISTER = 17,
	IB_EVENT_GID_CHANGE = 18,
	IB_EVENT_WQ_FATAL = 19,
};

enum ib_flow_action_type {
	IB_FLOW_ACTION_UNSPECIFIED = 0,
	IB_FLOW_ACTION_ESP = 1,
};

enum ib_flow_attr_type {
	IB_FLOW_ATTR_NORMAL = 0,
	IB_FLOW_ATTR_ALL_DEFAULT = 1,
	IB_FLOW_ATTR_MC_DEFAULT = 2,
	IB_FLOW_ATTR_SNIFFER = 3,
};

enum ib_flow_spec_type {
	IB_FLOW_SPEC_ETH = 32,
	IB_FLOW_SPEC_IB = 34,
	IB_FLOW_SPEC_IPV4 = 48,
	IB_FLOW_SPEC_IPV6 = 49,
	IB_FLOW_SPEC_ESP = 52,
	IB_FLOW_SPEC_TCP = 64,
	IB_FLOW_SPEC_UDP = 65,
	IB_FLOW_SPEC_VXLAN_TUNNEL = 80,
	IB_FLOW_SPEC_GRE = 81,
	IB_FLOW_SPEC_MPLS = 96,
	IB_FLOW_SPEC_INNER = 256,
	IB_FLOW_SPEC_ACTION_TAG = 4096,
	IB_FLOW_SPEC_ACTION_DROP = 4097,
	IB_FLOW_SPEC_ACTION_HANDLE = 4098,
	IB_FLOW_SPEC_ACTION_COUNT = 4099,
};

enum ib_gid_type {
	IB_GID_TYPE_IB = 0,
	IB_GID_TYPE_ROCE = 1,
	IB_GID_TYPE_ROCE_UDP_ENCAP = 2,
	IB_GID_TYPE_SIZE = 3,
};

enum ib_mig_state {
	IB_MIG_MIGRATED = 0,
	IB_MIG_REARM = 1,
	IB_MIG_ARMED = 2,
};

enum ib_mr_type {
	IB_MR_TYPE_MEM_REG = 0,
	IB_MR_TYPE_SG_GAPS = 1,
	IB_MR_TYPE_DM = 2,
	IB_MR_TYPE_USER = 3,
	IB_MR_TYPE_DMA = 4,
	IB_MR_TYPE_INTEGRITY = 5,
};

enum ib_mtu {
	IB_MTU_256 = 1,
	IB_MTU_512 = 2,
	IB_MTU_1024 = 3,
	IB_MTU_2048 = 4,
	IB_MTU_4096 = 5,
};

enum ib_mw_type {
	IB_MW_TYPE_1 = 1,
	IB_MW_TYPE_2 = 2,
};

enum ib_poll_context {
	IB_POLL_SOFTIRQ = 0,
	IB_POLL_WORKQUEUE = 1,
	IB_POLL_UNBOUND_WORKQUEUE = 2,
	IB_POLL_LAST_POOL_TYPE = 2,
	IB_POLL_DIRECT = 3,
};

enum ib_port_state {
	IB_PORT_NOP = 0,
	IB_PORT_DOWN = 1,
	IB_PORT_INIT = 2,
	IB_PORT_ARMED = 3,
	IB_PORT_ACTIVE = 4,
	IB_PORT_ACTIVE_DEFER = 5,
};

enum ib_qp_state {
	IB_QPS_RESET = 0,
	IB_QPS_INIT = 1,
	IB_QPS_RTR = 2,
	IB_QPS_RTS = 3,
	IB_QPS_SQD = 4,
	IB_QPS_SQE = 5,
	IB_QPS_ERR = 6,
};

enum ib_qp_type {
	IB_QPT_SMI = 0,
	IB_QPT_GSI = 1,
	IB_QPT_RC = 2,
	IB_QPT_UC = 3,
	IB_QPT_UD = 4,
	IB_QPT_RAW_IPV6 = 5,
	IB_QPT_RAW_ETHERTYPE = 6,
	IB_QPT_RAW_PACKET = 8,
	IB_QPT_XRC_INI = 9,
	IB_QPT_XRC_TGT = 10,
	IB_QPT_MAX = 11,
	IB_QPT_DRIVER = 255,
	IB_QPT_RESERVED1 = 4096,
	IB_QPT_RESERVED2 = 4097,
	IB_QPT_RESERVED3 = 4098,
	IB_QPT_RESERVED4 = 4099,
	IB_QPT_RESERVED5 = 4100,
	IB_QPT_RESERVED6 = 4101,
	IB_QPT_RESERVED7 = 4102,
	IB_QPT_RESERVED8 = 4103,
	IB_QPT_RESERVED9 = 4104,
	IB_QPT_RESERVED10 = 4105,
};

enum ib_sig_err_type {
	IB_SIG_BAD_GUARD = 0,
	IB_SIG_BAD_REFTAG = 1,
	IB_SIG_BAD_APPTAG = 2,
};

enum ib_sig_type {
	IB_SIGNAL_ALL_WR = 0,
	IB_SIGNAL_REQ_WR = 1,
};

enum ib_signature_type {
	IB_SIG_TYPE_NONE = 0,
	IB_SIG_TYPE_T10_DIF = 1,
};

enum ib_srq_attr_mask {
	IB_SRQ_MAX_WR = 1,
	IB_SRQ_LIMIT = 2,
};

enum ib_srq_type {
	IB_SRQT_BASIC = 0,
	IB_SRQT_XRC = 1,
	IB_SRQT_TM = 2,
};

enum ib_t10_dif_bg_type {
	IB_T10DIF_CRC = 0,
	IB_T10DIF_CSUM = 1,
};

enum ib_uverbs_access_flags {
	IB_UVERBS_ACCESS_LOCAL_WRITE = 1,
	IB_UVERBS_ACCESS_REMOTE_WRITE = 2,
	IB_UVERBS_ACCESS_REMOTE_READ = 4,
	IB_UVERBS_ACCESS_REMOTE_ATOMIC = 8,
	IB_UVERBS_ACCESS_MW_BIND = 16,
	IB_UVERBS_ACCESS_ZERO_BASED = 32,
	IB_UVERBS_ACCESS_ON_DEMAND = 64,
	IB_UVERBS_ACCESS_HUGETLB = 128,
	IB_UVERBS_ACCESS_FLUSH_GLOBAL = 256,
	IB_UVERBS_ACCESS_FLUSH_PERSISTENT = 512,
	IB_UVERBS_ACCESS_RELAXED_ORDERING = 1048576,
	IB_UVERBS_ACCESS_OPTIONAL_RANGE = 1072693248,
};

enum ib_uverbs_advise_mr_advice {
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH = 0,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_WRITE = 1,
	IB_UVERBS_ADVISE_MR_ADVICE_PREFETCH_NO_FAULT = 2,
};

enum ib_uverbs_create_qp_mask {
	IB_UVERBS_CREATE_QP_MASK_IND_TABLE = 1,
};

enum ib_uverbs_device_cap_flags {
	IB_UVERBS_DEVICE_RESIZE_MAX_WR = 1ULL,
	IB_UVERBS_DEVICE_BAD_PKEY_CNTR = 2ULL,
	IB_UVERBS_DEVICE_BAD_QKEY_CNTR = 4ULL,
	IB_UVERBS_DEVICE_RAW_MULTI = 8ULL,
	IB_UVERBS_DEVICE_AUTO_PATH_MIG = 16ULL,
	IB_UVERBS_DEVICE_CHANGE_PHY_PORT = 32ULL,
	IB_UVERBS_DEVICE_UD_AV_PORT_ENFORCE = 64ULL,
	IB_UVERBS_DEVICE_CURR_QP_STATE_MOD = 128ULL,
	IB_UVERBS_DEVICE_SHUTDOWN_PORT = 256ULL,
	IB_UVERBS_DEVICE_PORT_ACTIVE_EVENT = 1024ULL,
	IB_UVERBS_DEVICE_SYS_IMAGE_GUID = 2048ULL,
	IB_UVERBS_DEVICE_RC_RNR_NAK_GEN = 4096ULL,
	IB_UVERBS_DEVICE_SRQ_RESIZE = 8192ULL,
	IB_UVERBS_DEVICE_N_NOTIFY_CQ = 16384ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW = 131072ULL,
	IB_UVERBS_DEVICE_UD_IP_CSUM = 262144ULL,
	IB_UVERBS_DEVICE_XRC = 1048576ULL,
	IB_UVERBS_DEVICE_MEM_MGT_EXTENSIONS = 2097152ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2A = 8388608ULL,
	IB_UVERBS_DEVICE_MEM_WINDOW_TYPE_2B = 16777216ULL,
	IB_UVERBS_DEVICE_RC_IP_CSUM = 33554432ULL,
	IB_UVERBS_DEVICE_RAW_IP_CSUM = 67108864ULL,
	IB_UVERBS_DEVICE_MANAGED_FLOW_STEERING = 536870912ULL,
	IB_UVERBS_DEVICE_RAW_SCATTER_FCS = 17179869184ULL,
	IB_UVERBS_DEVICE_PCI_WRITE_END_PADDING = 68719476736ULL,
	IB_UVERBS_DEVICE_FLUSH_GLOBAL = 274877906944ULL,
	IB_UVERBS_DEVICE_FLUSH_PERSISTENT = 549755813888ULL,
	IB_UVERBS_DEVICE_ATOMIC_WRITE = 1099511627776ULL,
};

enum ib_uverbs_gid_type {
	IB_UVERBS_GID_TYPE_IB = 0,
	IB_UVERBS_GID_TYPE_ROCE_V1 = 1,
	IB_UVERBS_GID_TYPE_ROCE_V2 = 2,
};

enum ib_uverbs_odp_general_cap_bits {
	IB_UVERBS_ODP_SUPPORT = 1,
	IB_UVERBS_ODP_SUPPORT_IMPLICIT = 2,
};

enum ib_uverbs_odp_transport_cap_bits {
	IB_UVERBS_ODP_SUPPORT_SEND = 1,
	IB_UVERBS_ODP_SUPPORT_RECV = 2,
	IB_UVERBS_ODP_SUPPORT_WRITE = 4,
	IB_UVERBS_ODP_SUPPORT_READ = 8,
	IB_UVERBS_ODP_SUPPORT_ATOMIC = 16,
	IB_UVERBS_ODP_SUPPORT_SRQ_RECV = 32,
	IB_UVERBS_ODP_SUPPORT_FLUSH = 64,
	IB_UVERBS_ODP_SUPPORT_ATOMIC_WRITE = 128,
};

enum ib_uverbs_qp_create_flags {
	IB_UVERBS_QP_CREATE_BLOCK_MULTICAST_LOOPBACK = 2,
	IB_UVERBS_QP_CREATE_SCATTER_FCS = 256,
	IB_UVERBS_QP_CREATE_CVLAN_STRIPPING = 512,
	IB_UVERBS_QP_CREATE_PCI_WRITE_END_PADDING = 2048,
	IB_UVERBS_QP_CREATE_SQ_SIG_ALL = 4096,
};

enum ib_uverbs_qp_type {
	IB_UVERBS_QPT_RC = 2,
	IB_UVERBS_QPT_UC = 3,
	IB_UVERBS_QPT_UD = 4,
	IB_UVERBS_QPT_RAW_PACKET = 8,
	IB_UVERBS_QPT_XRC_INI = 9,
	IB_UVERBS_QPT_XRC_TGT = 10,
	IB_UVERBS_QPT_DRIVER = 255,
};

enum ib_uverbs_raw_packet_caps {
	IB_UVERBS_RAW_PACKET_CAP_CVLAN_STRIPPING = 1,
	IB_UVERBS_RAW_PACKET_CAP_SCATTER_FCS = 2,
	IB_UVERBS_RAW_PACKET_CAP_IP_CSUM = 4,
	IB_UVERBS_RAW_PACKET_CAP_DELAY_DROP = 8,
};

enum ib_uverbs_srq_type {
	IB_UVERBS_SRQT_BASIC = 0,
	IB_UVERBS_SRQT_XRC = 1,
	IB_UVERBS_SRQT_TM = 2,
};

enum ib_uverbs_wc_opcode {
	IB_UVERBS_WC_SEND = 0,
	IB_UVERBS_WC_RDMA_WRITE = 1,
	IB_UVERBS_WC_RDMA_READ = 2,
	IB_UVERBS_WC_COMP_SWAP = 3,
	IB_UVERBS_WC_FETCH_ADD = 4,
	IB_UVERBS_WC_BIND_MW = 5,
	IB_UVERBS_WC_LOCAL_INV = 6,
	IB_UVERBS_WC_TSO = 7,
	IB_UVERBS_WC_FLUSH = 8,
	IB_UVERBS_WC_ATOMIC_WRITE = 9,
};

enum ib_uverbs_wq_flags {
	IB_UVERBS_WQ_FLAGS_CVLAN_STRIPPING = 1,
	IB_UVERBS_WQ_FLAGS_SCATTER_FCS = 2,
	IB_UVERBS_WQ_FLAGS_DELAY_DROP = 4,
	IB_UVERBS_WQ_FLAGS_PCI_WRITE_END_PADDING = 8,
};

enum ib_uverbs_wq_type {
	IB_UVERBS_WQT_RQ = 0,
};

enum ib_uverbs_wr_opcode {
	IB_UVERBS_WR_RDMA_WRITE = 0,
	IB_UVERBS_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_UVERBS_WR_SEND = 2,
	IB_UVERBS_WR_SEND_WITH_IMM = 3,
	IB_UVERBS_WR_RDMA_READ = 4,
	IB_UVERBS_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_UVERBS_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_UVERBS_WR_LOCAL_INV = 7,
	IB_UVERBS_WR_BIND_MW = 8,
	IB_UVERBS_WR_SEND_WITH_INV = 9,
	IB_UVERBS_WR_TSO = 10,
	IB_UVERBS_WR_RDMA_READ_WITH_INV = 11,
	IB_UVERBS_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_UVERBS_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_UVERBS_WR_FLUSH = 14,
	IB_UVERBS_WR_ATOMIC_WRITE = 15,
};

enum ib_uverbs_write_cmds {
	IB_USER_VERBS_CMD_GET_CONTEXT = 0,
	IB_USER_VERBS_CMD_QUERY_DEVICE = 1,
	IB_USER_VERBS_CMD_QUERY_PORT = 2,
	IB_USER_VERBS_CMD_ALLOC_PD = 3,
	IB_USER_VERBS_CMD_DEALLOC_PD = 4,
	IB_USER_VERBS_CMD_CREATE_AH = 5,
	IB_USER_VERBS_CMD_MODIFY_AH = 6,
	IB_USER_VERBS_CMD_QUERY_AH = 7,
	IB_USER_VERBS_CMD_DESTROY_AH = 8,
	IB_USER_VERBS_CMD_REG_MR = 9,
	IB_USER_VERBS_CMD_REG_SMR = 10,
	IB_USER_VERBS_CMD_REREG_MR = 11,
	IB_USER_VERBS_CMD_QUERY_MR = 12,
	IB_USER_VERBS_CMD_DEREG_MR = 13,
	IB_USER_VERBS_CMD_ALLOC_MW = 14,
	IB_USER_VERBS_CMD_BIND_MW = 15,
	IB_USER_VERBS_CMD_DEALLOC_MW = 16,
	IB_USER_VERBS_CMD_CREATE_COMP_CHANNEL = 17,
	IB_USER_VERBS_CMD_CREATE_CQ = 18,
	IB_USER_VERBS_CMD_RESIZE_CQ = 19,
	IB_USER_VERBS_CMD_DESTROY_CQ = 20,
	IB_USER_VERBS_CMD_POLL_CQ = 21,
	IB_USER_VERBS_CMD_PEEK_CQ = 22,
	IB_USER_VERBS_CMD_REQ_NOTIFY_CQ = 23,
	IB_USER_VERBS_CMD_CREATE_QP = 24,
	IB_USER_VERBS_CMD_QUERY_QP = 25,
	IB_USER_VERBS_CMD_MODIFY_QP = 26,
	IB_USER_VERBS_CMD_DESTROY_QP = 27,
	IB_USER_VERBS_CMD_POST_SEND = 28,
	IB_USER_VERBS_CMD_POST_RECV = 29,
	IB_USER_VERBS_CMD_ATTACH_MCAST = 30,
	IB_USER_VERBS_CMD_DETACH_MCAST = 31,
	IB_USER_VERBS_CMD_CREATE_SRQ = 32,
	IB_USER_VERBS_CMD_MODIFY_SRQ = 33,
	IB_USER_VERBS_CMD_QUERY_SRQ = 34,
	IB_USER_VERBS_CMD_DESTROY_SRQ = 35,
	IB_USER_VERBS_CMD_POST_SRQ_RECV = 36,
	IB_USER_VERBS_CMD_OPEN_XRCD = 37,
	IB_USER_VERBS_CMD_CLOSE_XRCD = 38,
	IB_USER_VERBS_CMD_CREATE_XSRQ = 39,
	IB_USER_VERBS_CMD_OPEN_QP = 40,
};

enum ib_wc_opcode {
	IB_WC_SEND = 0,
	IB_WC_RDMA_WRITE = 1,
	IB_WC_RDMA_READ = 2,
	IB_WC_COMP_SWAP = 3,
	IB_WC_FETCH_ADD = 4,
	IB_WC_BIND_MW = 5,
	IB_WC_LOCAL_INV = 6,
	IB_WC_LSO = 7,
	IB_WC_ATOMIC_WRITE = 9,
	IB_WC_REG_MR = 10,
	IB_WC_MASKED_COMP_SWAP = 11,
	IB_WC_MASKED_FETCH_ADD = 12,
	IB_WC_FLUSH = 8,
	IB_WC_RECV = 128,
	IB_WC_RECV_RDMA_WITH_IMM = 129,
};

enum ib_wc_status {
	IB_WC_SUCCESS = 0,
	IB_WC_LOC_LEN_ERR = 1,
	IB_WC_LOC_QP_OP_ERR = 2,
	IB_WC_LOC_EEC_OP_ERR = 3,
	IB_WC_LOC_PROT_ERR = 4,
	IB_WC_WR_FLUSH_ERR = 5,
	IB_WC_MW_BIND_ERR = 6,
	IB_WC_BAD_RESP_ERR = 7,
	IB_WC_LOC_ACCESS_ERR = 8,
	IB_WC_REM_INV_REQ_ERR = 9,
	IB_WC_REM_ACCESS_ERR = 10,
	IB_WC_REM_OP_ERR = 11,
	IB_WC_RETRY_EXC_ERR = 12,
	IB_WC_RNR_RETRY_EXC_ERR = 13,
	IB_WC_LOC_RDD_VIOL_ERR = 14,
	IB_WC_REM_INV_RD_REQ_ERR = 15,
	IB_WC_REM_ABORT_ERR = 16,
	IB_WC_INV_EECN_ERR = 17,
	IB_WC_INV_EEC_STATE_ERR = 18,
	IB_WC_FATAL_ERR = 19,
	IB_WC_RESP_TIMEOUT_ERR = 20,
	IB_WC_GENERAL_ERR = 21,
};

enum ib_wq_state {
	IB_WQS_RESET = 0,
	IB_WQS_RDY = 1,
	IB_WQS_ERR = 2,
};

enum ib_wq_type {
	IB_WQT_RQ = 0,
};

enum ib_wr_opcode {
	IB_WR_RDMA_WRITE = 0,
	IB_WR_RDMA_WRITE_WITH_IMM = 1,
	IB_WR_SEND = 2,
	IB_WR_SEND_WITH_IMM = 3,
	IB_WR_RDMA_READ = 4,
	IB_WR_ATOMIC_CMP_AND_SWP = 5,
	IB_WR_ATOMIC_FETCH_AND_ADD = 6,
	IB_WR_BIND_MW = 8,
	IB_WR_LSO = 10,
	IB_WR_SEND_WITH_INV = 9,
	IB_WR_RDMA_READ_WITH_INV = 11,
	IB_WR_LOCAL_INV = 7,
	IB_WR_MASKED_ATOMIC_CMP_AND_SWP = 12,
	IB_WR_MASKED_ATOMIC_FETCH_AND_ADD = 13,
	IB_WR_FLUSH = 14,
	IB_WR_ATOMIC_WRITE = 15,
	IB_WR_REG_MR = 32,
	IB_WR_REG_MR_INTEGRITY = 33,
	IB_WR_RESERVED1 = 240,
	IB_WR_RESERVED2 = 241,
	IB_WR_RESERVED3 = 242,
	IB_WR_RESERVED4 = 243,
	IB_WR_RESERVED5 = 244,
	IB_WR_RESERVED6 = 245,
	IB_WR_RESERVED7 = 246,
	IB_WR_RESERVED8 = 247,
	IB_WR_RESERVED9 = 248,
	IB_WR_RESERVED10 = 249,
};

enum icst_control_type {
	ICST_VERSATILE = 0,
	ICST_INTEGRATOR_AP_CM = 1,
	ICST_INTEGRATOR_AP_SYS = 2,
	ICST_INTEGRATOR_AP_PCI = 3,
	ICST_INTEGRATOR_CP_CM_CORE = 4,
	ICST_INTEGRATOR_CP_CM_MEM = 5,
	ICST_INTEGRATOR_IM_PD1 = 6,
};

enum ieee80211_bss_type {
	IEEE80211_BSS_TYPE_ESS = 0,
	IEEE80211_BSS_TYPE_PBSS = 1,
	IEEE80211_BSS_TYPE_IBSS = 2,
	IEEE80211_BSS_TYPE_MBSS = 3,
	IEEE80211_BSS_TYPE_ANY = 4,
};

enum ieee80211_edmg_bw_config {
	IEEE80211_EDMG_BW_CONFIG_4 = 4,
	IEEE80211_EDMG_BW_CONFIG_5 = 5,
	IEEE80211_EDMG_BW_CONFIG_6 = 6,
	IEEE80211_EDMG_BW_CONFIG_7 = 7,
	IEEE80211_EDMG_BW_CONFIG_8 = 8,
	IEEE80211_EDMG_BW_CONFIG_9 = 9,
	IEEE80211_EDMG_BW_CONFIG_10 = 10,
	IEEE80211_EDMG_BW_CONFIG_11 = 11,
	IEEE80211_EDMG_BW_CONFIG_12 = 12,
	IEEE80211_EDMG_BW_CONFIG_13 = 13,
	IEEE80211_EDMG_BW_CONFIG_14 = 14,
	IEEE80211_EDMG_BW_CONFIG_15 = 15,
};

enum ieee802154_filtering_level {
	IEEE802154_FILTERING_NONE = 0,
	IEEE802154_FILTERING_1_FCS = 1,
	IEEE802154_FILTERING_2_PROMISCUOUS = 2,
	IEEE802154_FILTERING_3_SCAN = 3,
	IEEE802154_FILTERING_4_FRAME_FIELDS = 4,
};

enum ieee_attrs {
	DCB_ATTR_IEEE_UNSPEC = 0,
	DCB_ATTR_IEEE_ETS = 1,
	DCB_ATTR_IEEE_PFC = 2,
	DCB_ATTR_IEEE_APP_TABLE = 3,
	DCB_ATTR_IEEE_PEER_ETS = 4,
	DCB_ATTR_IEEE_PEER_PFC = 5,
	DCB_ATTR_IEEE_PEER_APP = 6,
	DCB_ATTR_IEEE_MAXRATE = 7,
	DCB_ATTR_IEEE_QCN = 8,
	DCB_ATTR_IEEE_QCN_STATS = 9,
	DCB_ATTR_DCB_BUFFER = 10,
	DCB_ATTR_DCB_APP_TRUST_TABLE = 11,
	DCB_ATTR_DCB_REWR_TABLE = 12,
	__DCB_ATTR_IEEE_MAX = 13,
};

enum ieee_attrs_app {
	DCB_ATTR_IEEE_APP_UNSPEC = 0,
	DCB_ATTR_IEEE_APP = 1,
	DCB_ATTR_DCB_APP = 2,
	__DCB_ATTR_IEEE_APP_MAX = 3,
};

enum iio_available_type {
	IIO_AVAIL_LIST = 0,
	IIO_AVAIL_RANGE = 1,
};

enum iio_buffer_direction {
	IIO_BUFFER_DIRECTION_IN = 0,
	IIO_BUFFER_DIRECTION_OUT = 1,
};

enum iio_chan_info_enum {
	IIO_CHAN_INFO_RAW = 0,
	IIO_CHAN_INFO_PROCESSED = 1,
	IIO_CHAN_INFO_SCALE = 2,
	IIO_CHAN_INFO_OFFSET = 3,
	IIO_CHAN_INFO_CALIBSCALE = 4,
	IIO_CHAN_INFO_CALIBBIAS = 5,
	IIO_CHAN_INFO_PEAK = 6,
	IIO_CHAN_INFO_PEAK_SCALE = 7,
	IIO_CHAN_INFO_QUADRATURE_CORRECTION_RAW = 8,
	IIO_CHAN_INFO_AVERAGE_RAW = 9,
	IIO_CHAN_INFO_LOW_PASS_FILTER_3DB_FREQUENCY = 10,
	IIO_CHAN_INFO_HIGH_PASS_FILTER_3DB_FREQUENCY = 11,
	IIO_CHAN_INFO_SAMP_FREQ = 12,
	IIO_CHAN_INFO_FREQUENCY = 13,
	IIO_CHAN_INFO_PHASE = 14,
	IIO_CHAN_INFO_HARDWAREGAIN = 15,
	IIO_CHAN_INFO_HYSTERESIS = 16,
	IIO_CHAN_INFO_HYSTERESIS_RELATIVE = 17,
	IIO_CHAN_INFO_INT_TIME = 18,
	IIO_CHAN_INFO_ENABLE = 19,
	IIO_CHAN_INFO_CALIBHEIGHT = 20,
	IIO_CHAN_INFO_CALIBWEIGHT = 21,
	IIO_CHAN_INFO_DEBOUNCE_COUNT = 22,
	IIO_CHAN_INFO_DEBOUNCE_TIME = 23,
	IIO_CHAN_INFO_CALIBEMISSIVITY = 24,
	IIO_CHAN_INFO_OVERSAMPLING_RATIO = 25,
	IIO_CHAN_INFO_THERMOCOUPLE_TYPE = 26,
	IIO_CHAN_INFO_CALIBAMBIENT = 27,
	IIO_CHAN_INFO_ZEROPOINT = 28,
	IIO_CHAN_INFO_TROUGH = 29,
};

enum iio_chan_type {
	IIO_VOLTAGE = 0,
	IIO_CURRENT = 1,
	IIO_POWER = 2,
	IIO_ACCEL = 3,
	IIO_ANGL_VEL = 4,
	IIO_MAGN = 5,
	IIO_LIGHT = 6,
	IIO_INTENSITY = 7,
	IIO_PROXIMITY = 8,
	IIO_TEMP = 9,
	IIO_INCLI = 10,
	IIO_ROT = 11,
	IIO_ANGL = 12,
	IIO_TIMESTAMP = 13,
	IIO_CAPACITANCE = 14,
	IIO_ALTVOLTAGE = 15,
	IIO_CCT = 16,
	IIO_PRESSURE = 17,
	IIO_HUMIDITYRELATIVE = 18,
	IIO_ACTIVITY = 19,
	IIO_STEPS = 20,
	IIO_ENERGY = 21,
	IIO_DISTANCE = 22,
	IIO_VELOCITY = 23,
	IIO_CONCENTRATION = 24,
	IIO_RESISTANCE = 25,
	IIO_PH = 26,
	IIO_UVINDEX = 27,
	IIO_ELECTRICALCONDUCTIVITY = 28,
	IIO_COUNT = 29,
	IIO_INDEX = 30,
	IIO_GRAVITY = 31,
	IIO_POSITIONRELATIVE = 32,
	IIO_PHASE = 33,
	IIO_MASSCONCENTRATION = 34,
	IIO_DELTA_ANGL = 35,
	IIO_DELTA_VELOCITY = 36,
	IIO_COLORTEMP = 37,
	IIO_CHROMATICITY = 38,
	IIO_ATTENTION = 39,
};

enum iio_endian {
	IIO_CPU = 0,
	IIO_BE = 1,
	IIO_LE = 2,
};

enum iio_event_direction {
	IIO_EV_DIR_EITHER = 0,
	IIO_EV_DIR_RISING = 1,
	IIO_EV_DIR_FALLING = 2,
	IIO_EV_DIR_NONE = 3,
	IIO_EV_DIR_SINGLETAP = 4,
	IIO_EV_DIR_DOUBLETAP = 5,
	IIO_EV_DIR_FAULT_OPENWIRE = 6,
};

enum iio_event_info {
	IIO_EV_INFO_ENABLE = 0,
	IIO_EV_INFO_VALUE = 1,
	IIO_EV_INFO_HYSTERESIS = 2,
	IIO_EV_INFO_PERIOD = 3,
	IIO_EV_INFO_HIGH_PASS_FILTER_3DB = 4,
	IIO_EV_INFO_LOW_PASS_FILTER_3DB = 5,
	IIO_EV_INFO_TIMEOUT = 6,
	IIO_EV_INFO_RESET_TIMEOUT = 7,
	IIO_EV_INFO_TAP2_MIN_DELAY = 8,
	IIO_EV_INFO_RUNNING_PERIOD = 9,
	IIO_EV_INFO_RUNNING_COUNT = 10,
};

enum iio_event_type {
	IIO_EV_TYPE_THRESH = 0,
	IIO_EV_TYPE_MAG = 1,
	IIO_EV_TYPE_ROC = 2,
	IIO_EV_TYPE_THRESH_ADAPTIVE = 3,
	IIO_EV_TYPE_MAG_ADAPTIVE = 4,
	IIO_EV_TYPE_CHANGE = 5,
	IIO_EV_TYPE_MAG_REFERENCED = 6,
	IIO_EV_TYPE_GESTURE = 7,
	IIO_EV_TYPE_FAULT = 8,
};

enum iio_modifier {
	IIO_NO_MOD = 0,
	IIO_MOD_X = 1,
	IIO_MOD_Y = 2,
	IIO_MOD_Z = 3,
	IIO_MOD_X_AND_Y = 4,
	IIO_MOD_X_AND_Z = 5,
	IIO_MOD_Y_AND_Z = 6,
	IIO_MOD_X_AND_Y_AND_Z = 7,
	IIO_MOD_X_OR_Y = 8,
	IIO_MOD_X_OR_Z = 9,
	IIO_MOD_Y_OR_Z = 10,
	IIO_MOD_X_OR_Y_OR_Z = 11,
	IIO_MOD_LIGHT_BOTH = 12,
	IIO_MOD_LIGHT_IR = 13,
	IIO_MOD_ROOT_SUM_SQUARED_X_Y = 14,
	IIO_MOD_SUM_SQUARED_X_Y_Z = 15,
	IIO_MOD_LIGHT_CLEAR = 16,
	IIO_MOD_LIGHT_RED = 17,
	IIO_MOD_LIGHT_GREEN = 18,
	IIO_MOD_LIGHT_BLUE = 19,
	IIO_MOD_QUATERNION = 20,
	IIO_MOD_TEMP_AMBIENT = 21,
	IIO_MOD_TEMP_OBJECT = 22,
	IIO_MOD_NORTH_MAGN = 23,
	IIO_MOD_NORTH_TRUE = 24,
	IIO_MOD_NORTH_MAGN_TILT_COMP = 25,
	IIO_MOD_NORTH_TRUE_TILT_COMP = 26,
	IIO_MOD_RUNNING = 27,
	IIO_MOD_JOGGING = 28,
	IIO_MOD_WALKING = 29,
	IIO_MOD_STILL = 30,
	IIO_MOD_ROOT_SUM_SQUARED_X_Y_Z = 31,
	IIO_MOD_I = 32,
	IIO_MOD_Q = 33,
	IIO_MOD_CO2 = 34,
	IIO_MOD_VOC = 35,
	IIO_MOD_LIGHT_UV = 36,
	IIO_MOD_LIGHT_DUV = 37,
	IIO_MOD_PM1 = 38,
	IIO_MOD_PM2P5 = 39,
	IIO_MOD_PM4 = 40,
	IIO_MOD_PM10 = 41,
	IIO_MOD_ETHANOL = 42,
	IIO_MOD_H2 = 43,
	IIO_MOD_O2 = 44,
	IIO_MOD_LINEAR_X = 45,
	IIO_MOD_LINEAR_Y = 46,
	IIO_MOD_LINEAR_Z = 47,
	IIO_MOD_PITCH = 48,
	IIO_MOD_YAW = 49,
	IIO_MOD_ROLL = 50,
	IIO_MOD_LIGHT_UVA = 51,
	IIO_MOD_LIGHT_UVB = 52,
};

enum iio_shared_by {
	IIO_SEPARATE = 0,
	IIO_SHARED_BY_TYPE = 1,
	IIO_SHARED_BY_DIR = 2,
	IIO_SHARED_BY_ALL = 3,
};

enum imx50_pads {
	MX50_PAD_RESERVE0 = 0,
	MX50_PAD_RESERVE1 = 1,
	MX50_PAD_RESERVE2 = 2,
	MX50_PAD_RESERVE3 = 3,
	MX50_PAD_RESERVE4 = 4,
	MX50_PAD_RESERVE5 = 5,
	MX50_PAD_RESERVE6 = 6,
	MX50_PAD_RESERVE7 = 7,
	MX50_PAD_KEY_COL0 = 8,
	MX50_PAD_KEY_ROW0 = 9,
	MX50_PAD_KEY_COL1 = 10,
	MX50_PAD_KEY_ROW1 = 11,
	MX50_PAD_KEY_COL2 = 12,
	MX50_PAD_KEY_ROW2 = 13,
	MX50_PAD_KEY_COL3 = 14,
	MX50_PAD_KEY_ROW3 = 15,
	MX50_PAD_I2C1_SCL = 16,
	MX50_PAD_I2C1_SDA = 17,
	MX50_PAD_I2C2_SCL = 18,
	MX50_PAD_I2C2_SDA = 19,
	MX50_PAD_I2C3_SCL = 20,
	MX50_PAD_I2C3_SDA = 21,
	MX50_PAD_PWM1 = 22,
	MX50_PAD_PWM2 = 23,
	MX50_PAD_0WIRE = 24,
	MX50_PAD_EPITO = 25,
	MX50_PAD_WDOG = 26,
	MX50_PAD_SSI_TXFS = 27,
	MX50_PAD_SSI_TXC = 28,
	MX50_PAD_SSI_TXD = 29,
	MX50_PAD_SSI_RXD = 30,
	MX50_PAD_SSI_RXF = 31,
	MX50_PAD_SSI_RXC = 32,
	MX50_PAD_UART1_TXD = 33,
	MX50_PAD_UART1_RXD = 34,
	MX50_PAD_UART1_CTS = 35,
	MX50_PAD_UART1_RTS = 36,
	MX50_PAD_UART2_TXD = 37,
	MX50_PAD_UART2_RXD = 38,
	MX50_PAD_UART2_CTS = 39,
	MX50_PAD_UART2_RTS = 40,
	MX50_PAD_UART3_TXD = 41,
	MX50_PAD_UART3_RXD = 42,
	MX50_PAD_UART4_TXD = 43,
	MX50_PAD_UART4_RXD = 44,
	MX50_PAD_CSPI_CLK = 45,
	MX50_PAD_CSPI_MOSI = 46,
	MX50_PAD_CSPI_MISO = 47,
	MX50_PAD_CSPI_SS0 = 48,
	MX50_PAD_ECSPI1_CLK = 49,
	MX50_PAD_ECSPI1_MOSI = 50,
	MX50_PAD_ECSPI1_MISO = 51,
	MX50_PAD_ECSPI1_SS0 = 52,
	MX50_PAD_ECSPI2_CLK = 53,
	MX50_PAD_ECSPI2_MOSI = 54,
	MX50_PAD_ECSPI2_MISO = 55,
	MX50_PAD_ECSPI2_SS0 = 56,
	MX50_PAD_SD1_CLK = 57,
	MX50_PAD_SD1_CMD = 58,
	MX50_PAD_SD1_D0 = 59,
	MX50_PAD_SD1_D1 = 60,
	MX50_PAD_SD1_D2 = 61,
	MX50_PAD_SD1_D3 = 62,
	MX50_PAD_SD2_CLK = 63,
	MX50_PAD_SD2_CMD = 64,
	MX50_PAD_SD2_D0 = 65,
	MX50_PAD_SD2_D1 = 66,
	MX50_PAD_SD2_D2 = 67,
	MX50_PAD_SD2_D3 = 68,
	MX50_PAD_SD2_D4 = 69,
	MX50_PAD_SD2_D5 = 70,
	MX50_PAD_SD2_D6 = 71,
	MX50_PAD_SD2_D7 = 72,
	MX50_PAD_SD2_WP = 73,
	MX50_PAD_SD2_CD = 74,
	MX50_PAD_DISP_D0 = 75,
	MX50_PAD_DISP_D1 = 76,
	MX50_PAD_DISP_D2 = 77,
	MX50_PAD_DISP_D3 = 78,
	MX50_PAD_DISP_D4 = 79,
	MX50_PAD_DISP_D5 = 80,
	MX50_PAD_DISP_D6 = 81,
	MX50_PAD_DISP_D7 = 82,
	MX50_PAD_DISP_WR = 83,
	MX50_PAD_DISP_RD = 84,
	MX50_PAD_DISP_RS = 85,
	MX50_PAD_DISP_CS = 86,
	MX50_PAD_DISP_BUSY = 87,
	MX50_PAD_DISP_RESET = 88,
	MX50_PAD_SD3_CLK = 89,
	MX50_PAD_SD3_CMD = 90,
	MX50_PAD_SD3_D0 = 91,
	MX50_PAD_SD3_D1 = 92,
	MX50_PAD_SD3_D2 = 93,
	MX50_PAD_SD3_D3 = 94,
	MX50_PAD_SD3_D4 = 95,
	MX50_PAD_SD3_D5 = 96,
	MX50_PAD_SD3_D6 = 97,
	MX50_PAD_SD3_D7 = 98,
	MX50_PAD_SD3_WP = 99,
	MX50_PAD_DISP_D8 = 100,
	MX50_PAD_DISP_D9 = 101,
	MX50_PAD_DISP_D10 = 102,
	MX50_PAD_DISP_D11 = 103,
	MX50_PAD_DISP_D12 = 104,
	MX50_PAD_DISP_D13 = 105,
	MX50_PAD_DISP_D14 = 106,
	MX50_PAD_DISP_D15 = 107,
	MX50_PAD_EPDC_D0 = 108,
	MX50_PAD_EPDC_D1 = 109,
	MX50_PAD_EPDC_D2 = 110,
	MX50_PAD_EPDC_D3 = 111,
	MX50_PAD_EPDC_D4 = 112,
	MX50_PAD_EPDC_D5 = 113,
	MX50_PAD_EPDC_D6 = 114,
	MX50_PAD_EPDC_D7 = 115,
	MX50_PAD_EPDC_D8 = 116,
	MX50_PAD_EPDC_D9 = 117,
	MX50_PAD_EPDC_D10 = 118,
	MX50_PAD_EPDC_D11 = 119,
	MX50_PAD_EPDC_D12 = 120,
	MX50_PAD_EPDC_D13 = 121,
	MX50_PAD_EPDC_D14 = 122,
	MX50_PAD_EPDC_D15 = 123,
	MX50_PAD_EPDC_GDCLK = 124,
	MX50_PAD_EPDC_GDSP = 125,
	MX50_PAD_EPDC_GDOE = 126,
	MX50_PAD_EPDC_GDRL = 127,
	MX50_PAD_EPDC_SDCLK = 128,
	MX50_PAD_EPDC_SDOEZ = 129,
	MX50_PAD_EPDC_SDOED = 130,
	MX50_PAD_EPDC_SDOE = 131,
	MX50_PAD_EPDC_SDLE = 132,
	MX50_PAD_EPDC_SDCLKN = 133,
	MX50_PAD_EPDC_SDSHR = 134,
	MX50_PAD_EPDC_PWRCOM = 135,
	MX50_PAD_EPDC_PWRSTAT = 136,
	MX50_PAD_EPDC_PWRCTRL0 = 137,
	MX50_PAD_EPDC_PWRCTRL1 = 138,
	MX50_PAD_EPDC_PWRCTRL2 = 139,
	MX50_PAD_EPDC_PWRCTRL3 = 140,
	MX50_PAD_EPDC_VCOM0 = 141,
	MX50_PAD_EPDC_VCOM1 = 142,
	MX50_PAD_EPDC_BDR0 = 143,
	MX50_PAD_EPDC_BDR1 = 144,
	MX50_PAD_EPDC_SDCE0 = 145,
	MX50_PAD_EPDC_SDCE1 = 146,
	MX50_PAD_EPDC_SDCE2 = 147,
	MX50_PAD_EPDC_SDCE3 = 148,
	MX50_PAD_EPDC_SDCE4 = 149,
	MX50_PAD_EPDC_SDCE5 = 150,
	MX50_PAD_EIM_DA0 = 151,
	MX50_PAD_EIM_DA1 = 152,
	MX50_PAD_EIM_DA2 = 153,
	MX50_PAD_EIM_DA3 = 154,
	MX50_PAD_EIM_DA4 = 155,
	MX50_PAD_EIM_DA5 = 156,
	MX50_PAD_EIM_DA6 = 157,
	MX50_PAD_EIM_DA7 = 158,
	MX50_PAD_EIM_DA8 = 159,
	MX50_PAD_EIM_DA9 = 160,
	MX50_PAD_EIM_DA10 = 161,
	MX50_PAD_EIM_DA11 = 162,
	MX50_PAD_EIM_DA12 = 163,
	MX50_PAD_EIM_DA13 = 164,
	MX50_PAD_EIM_DA14 = 165,
	MX50_PAD_EIM_DA15 = 166,
	MX50_PAD_EIM_CS2 = 167,
	MX50_PAD_EIM_CS1 = 168,
	MX50_PAD_EIM_CS0 = 169,
	MX50_PAD_EIM_EB0 = 170,
	MX50_PAD_EIM_EB1 = 171,
	MX50_PAD_EIM_WAIT = 172,
	MX50_PAD_EIM_BCLK = 173,
	MX50_PAD_EIM_RDY = 174,
	MX50_PAD_EIM_OE = 175,
	MX50_PAD_EIM_RW = 176,
	MX50_PAD_EIM_LBA = 177,
	MX50_PAD_EIM_CRE = 178,
};

enum imx51_pads {
	MX51_PAD_RESERVE0 = 0,
	MX51_PAD_RESERVE1 = 1,
	MX51_PAD_RESERVE2 = 2,
	MX51_PAD_RESERVE3 = 3,
	MX51_PAD_RESERVE4 = 4,
	MX51_PAD_RESERVE5 = 5,
	MX51_PAD_RESERVE6 = 6,
	MX51_PAD_EIM_DA0 = 7,
	MX51_PAD_EIM_DA1 = 8,
	MX51_PAD_EIM_DA2 = 9,
	MX51_PAD_EIM_DA3 = 10,
	MX51_PAD_EIM_DA4 = 11,
	MX51_PAD_EIM_DA5 = 12,
	MX51_PAD_EIM_DA6 = 13,
	MX51_PAD_EIM_DA7 = 14,
	MX51_PAD_EIM_DA8 = 15,
	MX51_PAD_EIM_DA9 = 16,
	MX51_PAD_EIM_DA10 = 17,
	MX51_PAD_EIM_DA11 = 18,
	MX51_PAD_EIM_DA12 = 19,
	MX51_PAD_EIM_DA13 = 20,
	MX51_PAD_EIM_DA14 = 21,
	MX51_PAD_EIM_DA15 = 22,
	MX51_PAD_EIM_D16 = 23,
	MX51_PAD_EIM_D17 = 24,
	MX51_PAD_EIM_D18 = 25,
	MX51_PAD_EIM_D19 = 26,
	MX51_PAD_EIM_D20 = 27,
	MX51_PAD_EIM_D21 = 28,
	MX51_PAD_EIM_D22 = 29,
	MX51_PAD_EIM_D23 = 30,
	MX51_PAD_EIM_D24 = 31,
	MX51_PAD_EIM_D25 = 32,
	MX51_PAD_EIM_D26 = 33,
	MX51_PAD_EIM_D27 = 34,
	MX51_PAD_EIM_D28 = 35,
	MX51_PAD_EIM_D29 = 36,
	MX51_PAD_EIM_D30 = 37,
	MX51_PAD_EIM_D31 = 38,
	MX51_PAD_EIM_A16 = 39,
	MX51_PAD_EIM_A17 = 40,
	MX51_PAD_EIM_A18 = 41,
	MX51_PAD_EIM_A19 = 42,
	MX51_PAD_EIM_A20 = 43,
	MX51_PAD_EIM_A21 = 44,
	MX51_PAD_EIM_A22 = 45,
	MX51_PAD_EIM_A23 = 46,
	MX51_PAD_EIM_A24 = 47,
	MX51_PAD_EIM_A25 = 48,
	MX51_PAD_EIM_A26 = 49,
	MX51_PAD_EIM_A27 = 50,
	MX51_PAD_EIM_EB0 = 51,
	MX51_PAD_EIM_EB1 = 52,
	MX51_PAD_EIM_EB2 = 53,
	MX51_PAD_EIM_EB3 = 54,
	MX51_PAD_EIM_OE = 55,
	MX51_PAD_EIM_CS0 = 56,
	MX51_PAD_EIM_CS1 = 57,
	MX51_PAD_EIM_CS2 = 58,
	MX51_PAD_EIM_CS3 = 59,
	MX51_PAD_EIM_CS4 = 60,
	MX51_PAD_EIM_CS5 = 61,
	MX51_PAD_EIM_DTACK = 62,
	MX51_PAD_EIM_LBA = 63,
	MX51_PAD_EIM_CRE = 64,
	MX51_PAD_DRAM_CS1 = 65,
	MX51_PAD_NANDF_WE_B = 66,
	MX51_PAD_NANDF_RE_B = 67,
	MX51_PAD_NANDF_ALE = 68,
	MX51_PAD_NANDF_CLE = 69,
	MX51_PAD_NANDF_WP_B = 70,
	MX51_PAD_NANDF_RB0 = 71,
	MX51_PAD_NANDF_RB1 = 72,
	MX51_PAD_NANDF_RB2 = 73,
	MX51_PAD_NANDF_RB3 = 74,
	MX51_PAD_GPIO_NAND = 75,
	MX51_PAD_NANDF_CS0 = 76,
	MX51_PAD_NANDF_CS1 = 77,
	MX51_PAD_NANDF_CS2 = 78,
	MX51_PAD_NANDF_CS3 = 79,
	MX51_PAD_NANDF_CS4 = 80,
	MX51_PAD_NANDF_CS5 = 81,
	MX51_PAD_NANDF_CS6 = 82,
	MX51_PAD_NANDF_CS7 = 83,
	MX51_PAD_NANDF_RDY_INT = 84,
	MX51_PAD_NANDF_D15 = 85,
	MX51_PAD_NANDF_D14 = 86,
	MX51_PAD_NANDF_D13 = 87,
	MX51_PAD_NANDF_D12 = 88,
	MX51_PAD_NANDF_D11 = 89,
	MX51_PAD_NANDF_D10 = 90,
	MX51_PAD_NANDF_D9 = 91,
	MX51_PAD_NANDF_D8 = 92,
	MX51_PAD_NANDF_D7 = 93,
	MX51_PAD_NANDF_D6 = 94,
	MX51_PAD_NANDF_D5 = 95,
	MX51_PAD_NANDF_D4 = 96,
	MX51_PAD_NANDF_D3 = 97,
	MX51_PAD_NANDF_D2 = 98,
	MX51_PAD_NANDF_D1 = 99,
	MX51_PAD_NANDF_D0 = 100,
	MX51_PAD_CSI1_D8 = 101,
	MX51_PAD_CSI1_D9 = 102,
	MX51_PAD_CSI1_D10 = 103,
	MX51_PAD_CSI1_D11 = 104,
	MX51_PAD_CSI1_D12 = 105,
	MX51_PAD_CSI1_D13 = 106,
	MX51_PAD_CSI1_D14 = 107,
	MX51_PAD_CSI1_D15 = 108,
	MX51_PAD_CSI1_D16 = 109,
	MX51_PAD_CSI1_D17 = 110,
	MX51_PAD_CSI1_D18 = 111,
	MX51_PAD_CSI1_D19 = 112,
	MX51_PAD_CSI1_VSYNC = 113,
	MX51_PAD_CSI1_HSYNC = 114,
	MX51_PAD_CSI2_D12 = 115,
	MX51_PAD_CSI2_D13 = 116,
	MX51_PAD_CSI2_D14 = 117,
	MX51_PAD_CSI2_D15 = 118,
	MX51_PAD_CSI2_D16 = 119,
	MX51_PAD_CSI2_D17 = 120,
	MX51_PAD_CSI2_D18 = 121,
	MX51_PAD_CSI2_D19 = 122,
	MX51_PAD_CSI2_VSYNC = 123,
	MX51_PAD_CSI2_HSYNC = 124,
	MX51_PAD_CSI2_PIXCLK = 125,
	MX51_PAD_I2C1_CLK = 126,
	MX51_PAD_I2C1_DAT = 127,
	MX51_PAD_AUD3_BB_TXD = 128,
	MX51_PAD_AUD3_BB_RXD = 129,
	MX51_PAD_AUD3_BB_CK = 130,
	MX51_PAD_AUD3_BB_FS = 131,
	MX51_PAD_CSPI1_MOSI = 132,
	MX51_PAD_CSPI1_MISO = 133,
	MX51_PAD_CSPI1_SS0 = 134,
	MX51_PAD_CSPI1_SS1 = 135,
	MX51_PAD_CSPI1_RDY = 136,
	MX51_PAD_CSPI1_SCLK = 137,
	MX51_PAD_UART1_RXD = 138,
	MX51_PAD_UART1_TXD = 139,
	MX51_PAD_UART1_RTS = 140,
	MX51_PAD_UART1_CTS = 141,
	MX51_PAD_UART2_RXD = 142,
	MX51_PAD_UART2_TXD = 143,
	MX51_PAD_UART3_RXD = 144,
	MX51_PAD_UART3_TXD = 145,
	MX51_PAD_OWIRE_LINE = 146,
	MX51_PAD_KEY_ROW0 = 147,
	MX51_PAD_KEY_ROW1 = 148,
	MX51_PAD_KEY_ROW2 = 149,
	MX51_PAD_KEY_ROW3 = 150,
	MX51_PAD_KEY_COL0 = 151,
	MX51_PAD_KEY_COL1 = 152,
	MX51_PAD_KEY_COL2 = 153,
	MX51_PAD_KEY_COL3 = 154,
	MX51_PAD_KEY_COL4 = 155,
	MX51_PAD_KEY_COL5 = 156,
	MX51_PAD_RESERVE7 = 157,
	MX51_PAD_USBH1_CLK = 158,
	MX51_PAD_USBH1_DIR = 159,
	MX51_PAD_USBH1_STP = 160,
	MX51_PAD_USBH1_NXT = 161,
	MX51_PAD_USBH1_DATA0 = 162,
	MX51_PAD_USBH1_DATA1 = 163,
	MX51_PAD_USBH1_DATA2 = 164,
	MX51_PAD_USBH1_DATA3 = 165,
	MX51_PAD_USBH1_DATA4 = 166,
	MX51_PAD_USBH1_DATA5 = 167,
	MX51_PAD_USBH1_DATA6 = 168,
	MX51_PAD_USBH1_DATA7 = 169,
	MX51_PAD_DI1_PIN11 = 170,
	MX51_PAD_DI1_PIN12 = 171,
	MX51_PAD_DI1_PIN13 = 172,
	MX51_PAD_DI1_D0_CS = 173,
	MX51_PAD_DI1_D1_CS = 174,
	MX51_PAD_DISPB2_SER_DIN = 175,
	MX51_PAD_DISPB2_SER_DIO = 176,
	MX51_PAD_DISPB2_SER_CLK = 177,
	MX51_PAD_DISPB2_SER_RS = 178,
	MX51_PAD_DISP1_DAT0 = 179,
	MX51_PAD_DISP1_DAT1 = 180,
	MX51_PAD_DISP1_DAT2 = 181,
	MX51_PAD_DISP1_DAT3 = 182,
	MX51_PAD_DISP1_DAT4 = 183,
	MX51_PAD_DISP1_DAT5 = 184,
	MX51_PAD_DISP1_DAT6 = 185,
	MX51_PAD_DISP1_DAT7 = 186,
	MX51_PAD_DISP1_DAT8 = 187,
	MX51_PAD_DISP1_DAT9 = 188,
	MX51_PAD_DISP1_DAT10 = 189,
	MX51_PAD_DISP1_DAT11 = 190,
	MX51_PAD_DISP1_DAT12 = 191,
	MX51_PAD_DISP1_DAT13 = 192,
	MX51_PAD_DISP1_DAT14 = 193,
	MX51_PAD_DISP1_DAT15 = 194,
	MX51_PAD_DISP1_DAT16 = 195,
	MX51_PAD_DISP1_DAT17 = 196,
	MX51_PAD_DISP1_DAT18 = 197,
	MX51_PAD_DISP1_DAT19 = 198,
	MX51_PAD_DISP1_DAT20 = 199,
	MX51_PAD_DISP1_DAT21 = 200,
	MX51_PAD_DISP1_DAT22 = 201,
	MX51_PAD_DISP1_DAT23 = 202,
	MX51_PAD_DI1_PIN3 = 203,
	MX51_PAD_DI1_PIN2 = 204,
	MX51_PAD_RESERVE8 = 205,
	MX51_PAD_DI_GP2 = 206,
	MX51_PAD_DI_GP3 = 207,
	MX51_PAD_DI2_PIN4 = 208,
	MX51_PAD_DI2_PIN2 = 209,
	MX51_PAD_DI2_PIN3 = 210,
	MX51_PAD_DI2_DISP_CLK = 211,
	MX51_PAD_DI_GP4 = 212,
	MX51_PAD_DISP2_DAT0 = 213,
	MX51_PAD_DISP2_DAT1 = 214,
	MX51_PAD_DISP2_DAT2 = 215,
	MX51_PAD_DISP2_DAT3 = 216,
	MX51_PAD_DISP2_DAT4 = 217,
	MX51_PAD_DISP2_DAT5 = 218,
	MX51_PAD_DISP2_DAT6 = 219,
	MX51_PAD_DISP2_DAT7 = 220,
	MX51_PAD_DISP2_DAT8 = 221,
	MX51_PAD_DISP2_DAT9 = 222,
	MX51_PAD_DISP2_DAT10 = 223,
	MX51_PAD_DISP2_DAT11 = 224,
	MX51_PAD_DISP2_DAT12 = 225,
	MX51_PAD_DISP2_DAT13 = 226,
	MX51_PAD_DISP2_DAT14 = 227,
	MX51_PAD_DISP2_DAT15 = 228,
	MX51_PAD_SD1_CMD = 229,
	MX51_PAD_SD1_CLK = 230,
	MX51_PAD_SD1_DATA0 = 231,
	MX51_PAD_SD1_DATA1 = 232,
	MX51_PAD_SD1_DATA2 = 233,
	MX51_PAD_SD1_DATA3 = 234,
	MX51_PAD_GPIO1_0 = 235,
	MX51_PAD_GPIO1_1 = 236,
	MX51_PAD_SD2_CMD = 237,
	MX51_PAD_SD2_CLK = 238,
	MX51_PAD_SD2_DATA0 = 239,
	MX51_PAD_SD2_DATA1 = 240,
	MX51_PAD_SD2_DATA2 = 241,
	MX51_PAD_SD2_DATA3 = 242,
	MX51_PAD_GPIO1_2 = 243,
	MX51_PAD_GPIO1_3 = 244,
	MX51_PAD_PMIC_INT_REQ = 245,
	MX51_PAD_GPIO1_4 = 246,
	MX51_PAD_GPIO1_5 = 247,
	MX51_PAD_GPIO1_6 = 248,
	MX51_PAD_GPIO1_7 = 249,
	MX51_PAD_GPIO1_8 = 250,
	MX51_PAD_GPIO1_9 = 251,
	MX51_PAD_RESERVE9 = 252,
	MX51_PAD_RESERVE10 = 253,
	MX51_PAD_RESERVE11 = 254,
	MX51_PAD_RESERVE12 = 255,
	MX51_PAD_RESERVE13 = 256,
	MX51_PAD_RESERVE14 = 257,
	MX51_PAD_RESERVE15 = 258,
	MX51_PAD_RESERVE16 = 259,
	MX51_PAD_RESERVE17 = 260,
	MX51_PAD_RESERVE18 = 261,
	MX51_PAD_RESERVE19 = 262,
	MX51_PAD_RESERVE20 = 263,
	MX51_PAD_RESERVE21 = 264,
	MX51_PAD_RESERVE22 = 265,
	MX51_PAD_RESERVE23 = 266,
	MX51_PAD_RESERVE24 = 267,
	MX51_PAD_RESERVE25 = 268,
	MX51_PAD_RESERVE26 = 269,
	MX51_PAD_RESERVE27 = 270,
	MX51_PAD_RESERVE28 = 271,
	MX51_PAD_RESERVE29 = 272,
	MX51_PAD_RESERVE30 = 273,
	MX51_PAD_RESERVE31 = 274,
	MX51_PAD_RESERVE32 = 275,
	MX51_PAD_RESERVE33 = 276,
	MX51_PAD_RESERVE34 = 277,
	MX51_PAD_RESERVE35 = 278,
	MX51_PAD_RESERVE36 = 279,
	MX51_PAD_RESERVE37 = 280,
	MX51_PAD_RESERVE38 = 281,
	MX51_PAD_RESERVE39 = 282,
	MX51_PAD_RESERVE40 = 283,
	MX51_PAD_RESERVE41 = 284,
	MX51_PAD_RESERVE42 = 285,
	MX51_PAD_RESERVE43 = 286,
	MX51_PAD_RESERVE44 = 287,
	MX51_PAD_RESERVE45 = 288,
	MX51_PAD_RESERVE46 = 289,
	MX51_PAD_RESERVE47 = 290,
	MX51_PAD_RESERVE48 = 291,
	MX51_PAD_RESERVE49 = 292,
	MX51_PAD_RESERVE50 = 293,
	MX51_PAD_RESERVE51 = 294,
	MX51_PAD_RESERVE52 = 295,
	MX51_PAD_RESERVE53 = 296,
	MX51_PAD_RESERVE54 = 297,
	MX51_PAD_RESERVE55 = 298,
	MX51_PAD_RESERVE56 = 299,
	MX51_PAD_RESERVE57 = 300,
	MX51_PAD_RESERVE58 = 301,
	MX51_PAD_RESERVE59 = 302,
	MX51_PAD_RESERVE60 = 303,
	MX51_PAD_RESERVE61 = 304,
	MX51_PAD_RESERVE62 = 305,
	MX51_PAD_RESERVE63 = 306,
	MX51_PAD_RESERVE64 = 307,
	MX51_PAD_RESERVE65 = 308,
	MX51_PAD_RESERVE66 = 309,
	MX51_PAD_RESERVE67 = 310,
	MX51_PAD_RESERVE68 = 311,
	MX51_PAD_RESERVE69 = 312,
	MX51_PAD_RESERVE70 = 313,
	MX51_PAD_RESERVE71 = 314,
	MX51_PAD_RESERVE72 = 315,
	MX51_PAD_RESERVE73 = 316,
	MX51_PAD_RESERVE74 = 317,
	MX51_PAD_RESERVE75 = 318,
	MX51_PAD_RESERVE76 = 319,
	MX51_PAD_RESERVE77 = 320,
	MX51_PAD_RESERVE78 = 321,
	MX51_PAD_RESERVE79 = 322,
	MX51_PAD_RESERVE80 = 323,
	MX51_PAD_RESERVE81 = 324,
	MX51_PAD_RESERVE82 = 325,
	MX51_PAD_RESERVE83 = 326,
	MX51_PAD_RESERVE84 = 327,
	MX51_PAD_RESERVE85 = 328,
	MX51_PAD_RESERVE86 = 329,
	MX51_PAD_RESERVE87 = 330,
	MX51_PAD_RESERVE88 = 331,
	MX51_PAD_RESERVE89 = 332,
	MX51_PAD_RESERVE90 = 333,
	MX51_PAD_RESERVE91 = 334,
	MX51_PAD_RESERVE92 = 335,
	MX51_PAD_RESERVE93 = 336,
	MX51_PAD_RESERVE94 = 337,
	MX51_PAD_RESERVE95 = 338,
	MX51_PAD_RESERVE96 = 339,
	MX51_PAD_RESERVE97 = 340,
	MX51_PAD_RESERVE98 = 341,
	MX51_PAD_RESERVE99 = 342,
	MX51_PAD_RESERVE100 = 343,
	MX51_PAD_RESERVE101 = 344,
	MX51_PAD_RESERVE102 = 345,
	MX51_PAD_RESERVE103 = 346,
	MX51_PAD_RESERVE104 = 347,
	MX51_PAD_RESERVE105 = 348,
	MX51_PAD_RESERVE106 = 349,
	MX51_PAD_RESERVE107 = 350,
	MX51_PAD_RESERVE108 = 351,
	MX51_PAD_RESERVE109 = 352,
	MX51_PAD_RESERVE110 = 353,
	MX51_PAD_RESERVE111 = 354,
	MX51_PAD_RESERVE112 = 355,
	MX51_PAD_RESERVE113 = 356,
	MX51_PAD_RESERVE114 = 357,
	MX51_PAD_RESERVE115 = 358,
	MX51_PAD_RESERVE116 = 359,
	MX51_PAD_RESERVE117 = 360,
	MX51_PAD_RESERVE118 = 361,
	MX51_PAD_RESERVE119 = 362,
	MX51_PAD_RESERVE120 = 363,
	MX51_PAD_RESERVE121 = 364,
	MX51_PAD_CSI1_PIXCLK = 365,
	MX51_PAD_CSI1_MCLK = 366,
};

enum imx53_pads {
	MX53_PAD_RESERVE0 = 0,
	MX53_PAD_RESERVE1 = 1,
	MX53_PAD_RESERVE2 = 2,
	MX53_PAD_RESERVE3 = 3,
	MX53_PAD_RESERVE4 = 4,
	MX53_PAD_RESERVE5 = 5,
	MX53_PAD_RESERVE6 = 6,
	MX53_PAD_RESERVE7 = 7,
	MX53_PAD_GPIO_19 = 8,
	MX53_PAD_KEY_COL0 = 9,
	MX53_PAD_KEY_ROW0 = 10,
	MX53_PAD_KEY_COL1 = 11,
	MX53_PAD_KEY_ROW1 = 12,
	MX53_PAD_KEY_COL2 = 13,
	MX53_PAD_KEY_ROW2 = 14,
	MX53_PAD_KEY_COL3 = 15,
	MX53_PAD_KEY_ROW3 = 16,
	MX53_PAD_KEY_COL4 = 17,
	MX53_PAD_KEY_ROW4 = 18,
	MX53_PAD_DI0_DISP_CLK = 19,
	MX53_PAD_DI0_PIN15 = 20,
	MX53_PAD_DI0_PIN2 = 21,
	MX53_PAD_DI0_PIN3 = 22,
	MX53_PAD_DI0_PIN4 = 23,
	MX53_PAD_DISP0_DAT0 = 24,
	MX53_PAD_DISP0_DAT1 = 25,
	MX53_PAD_DISP0_DAT2 = 26,
	MX53_PAD_DISP0_DAT3 = 27,
	MX53_PAD_DISP0_DAT4 = 28,
	MX53_PAD_DISP0_DAT5 = 29,
	MX53_PAD_DISP0_DAT6 = 30,
	MX53_PAD_DISP0_DAT7 = 31,
	MX53_PAD_DISP0_DAT8 = 32,
	MX53_PAD_DISP0_DAT9 = 33,
	MX53_PAD_DISP0_DAT10 = 34,
	MX53_PAD_DISP0_DAT11 = 35,
	MX53_PAD_DISP0_DAT12 = 36,
	MX53_PAD_DISP0_DAT13 = 37,
	MX53_PAD_DISP0_DAT14 = 38,
	MX53_PAD_DISP0_DAT15 = 39,
	MX53_PAD_DISP0_DAT16 = 40,
	MX53_PAD_DISP0_DAT17 = 41,
	MX53_PAD_DISP0_DAT18 = 42,
	MX53_PAD_DISP0_DAT19 = 43,
	MX53_PAD_DISP0_DAT20 = 44,
	MX53_PAD_DISP0_DAT21 = 45,
	MX53_PAD_DISP0_DAT22 = 46,
	MX53_PAD_DISP0_DAT23 = 47,
	MX53_PAD_CSI0_PIXCLK = 48,
	MX53_PAD_CSI0_MCLK = 49,
	MX53_PAD_CSI0_DATA_EN = 50,
	MX53_PAD_CSI0_VSYNC = 51,
	MX53_PAD_CSI0_DAT4 = 52,
	MX53_PAD_CSI0_DAT5 = 53,
	MX53_PAD_CSI0_DAT6 = 54,
	MX53_PAD_CSI0_DAT7 = 55,
	MX53_PAD_CSI0_DAT8 = 56,
	MX53_PAD_CSI0_DAT9 = 57,
	MX53_PAD_CSI0_DAT10 = 58,
	MX53_PAD_CSI0_DAT11 = 59,
	MX53_PAD_CSI0_DAT12 = 60,
	MX53_PAD_CSI0_DAT13 = 61,
	MX53_PAD_CSI0_DAT14 = 62,
	MX53_PAD_CSI0_DAT15 = 63,
	MX53_PAD_CSI0_DAT16 = 64,
	MX53_PAD_CSI0_DAT17 = 65,
	MX53_PAD_CSI0_DAT18 = 66,
	MX53_PAD_CSI0_DAT19 = 67,
	MX53_PAD_EIM_A25 = 68,
	MX53_PAD_EIM_EB2 = 69,
	MX53_PAD_EIM_D16 = 70,
	MX53_PAD_EIM_D17 = 71,
	MX53_PAD_EIM_D18 = 72,
	MX53_PAD_EIM_D19 = 73,
	MX53_PAD_EIM_D20 = 74,
	MX53_PAD_EIM_D21 = 75,
	MX53_PAD_EIM_D22 = 76,
	MX53_PAD_EIM_D23 = 77,
	MX53_PAD_EIM_EB3 = 78,
	MX53_PAD_EIM_D24 = 79,
	MX53_PAD_EIM_D25 = 80,
	MX53_PAD_EIM_D26 = 81,
	MX53_PAD_EIM_D27 = 82,
	MX53_PAD_EIM_D28 = 83,
	MX53_PAD_EIM_D29 = 84,
	MX53_PAD_EIM_D30 = 85,
	MX53_PAD_EIM_D31 = 86,
	MX53_PAD_EIM_A24 = 87,
	MX53_PAD_EIM_A23 = 88,
	MX53_PAD_EIM_A22 = 89,
	MX53_PAD_EIM_A21 = 90,
	MX53_PAD_EIM_A20 = 91,
	MX53_PAD_EIM_A19 = 92,
	MX53_PAD_EIM_A18 = 93,
	MX53_PAD_EIM_A17 = 94,
	MX53_PAD_EIM_A16 = 95,
	MX53_PAD_EIM_CS0 = 96,
	MX53_PAD_EIM_CS1 = 97,
	MX53_PAD_EIM_OE = 98,
	MX53_PAD_EIM_RW = 99,
	MX53_PAD_EIM_LBA = 100,
	MX53_PAD_EIM_EB0 = 101,
	MX53_PAD_EIM_EB1 = 102,
	MX53_PAD_EIM_DA0 = 103,
	MX53_PAD_EIM_DA1 = 104,
	MX53_PAD_EIM_DA2 = 105,
	MX53_PAD_EIM_DA3 = 106,
	MX53_PAD_EIM_DA4 = 107,
	MX53_PAD_EIM_DA5 = 108,
	MX53_PAD_EIM_DA6 = 109,
	MX53_PAD_EIM_DA7 = 110,
	MX53_PAD_EIM_DA8 = 111,
	MX53_PAD_EIM_DA9 = 112,
	MX53_PAD_EIM_DA10 = 113,
	MX53_PAD_EIM_DA11 = 114,
	MX53_PAD_EIM_DA12 = 115,
	MX53_PAD_EIM_DA13 = 116,
	MX53_PAD_EIM_DA14 = 117,
	MX53_PAD_EIM_DA15 = 118,
	MX53_PAD_NANDF_WE_B = 119,
	MX53_PAD_NANDF_RE_B = 120,
	MX53_PAD_EIM_WAIT = 121,
	MX53_PAD_RESERVE8 = 122,
	MX53_PAD_LVDS1_TX3_P = 123,
	MX53_PAD_LVDS1_TX2_P = 124,
	MX53_PAD_LVDS1_CLK_P = 125,
	MX53_PAD_LVDS1_TX1_P = 126,
	MX53_PAD_LVDS1_TX0_P = 127,
	MX53_PAD_LVDS0_TX3_P = 128,
	MX53_PAD_LVDS0_CLK_P = 129,
	MX53_PAD_LVDS0_TX2_P = 130,
	MX53_PAD_LVDS0_TX1_P = 131,
	MX53_PAD_LVDS0_TX0_P = 132,
	MX53_PAD_GPIO_10 = 133,
	MX53_PAD_GPIO_11 = 134,
	MX53_PAD_GPIO_12 = 135,
	MX53_PAD_GPIO_13 = 136,
	MX53_PAD_GPIO_14 = 137,
	MX53_PAD_NANDF_CLE = 138,
	MX53_PAD_NANDF_ALE = 139,
	MX53_PAD_NANDF_WP_B = 140,
	MX53_PAD_NANDF_RB0 = 141,
	MX53_PAD_NANDF_CS0 = 142,
	MX53_PAD_NANDF_CS1 = 143,
	MX53_PAD_NANDF_CS2 = 144,
	MX53_PAD_NANDF_CS3 = 145,
	MX53_PAD_FEC_MDIO = 146,
	MX53_PAD_FEC_REF_CLK = 147,
	MX53_PAD_FEC_RX_ER = 148,
	MX53_PAD_FEC_CRS_DV = 149,
	MX53_PAD_FEC_RXD1 = 150,
	MX53_PAD_FEC_RXD0 = 151,
	MX53_PAD_FEC_TX_EN = 152,
	MX53_PAD_FEC_TXD1 = 153,
	MX53_PAD_FEC_TXD0 = 154,
	MX53_PAD_FEC_MDC = 155,
	MX53_PAD_PATA_DIOW = 156,
	MX53_PAD_PATA_DMACK = 157,
	MX53_PAD_PATA_DMARQ = 158,
	MX53_PAD_PATA_BUFFER_EN = 159,
	MX53_PAD_PATA_INTRQ = 160,
	MX53_PAD_PATA_DIOR = 161,
	MX53_PAD_PATA_RESET_B = 162,
	MX53_PAD_PATA_IORDY = 163,
	MX53_PAD_PATA_DA_0 = 164,
	MX53_PAD_PATA_DA_1 = 165,
	MX53_PAD_PATA_DA_2 = 166,
	MX53_PAD_PATA_CS_0 = 167,
	MX53_PAD_PATA_CS_1 = 168,
	MX53_PAD_PATA_DATA0 = 169,
	MX53_PAD_PATA_DATA1 = 170,
	MX53_PAD_PATA_DATA2 = 171,
	MX53_PAD_PATA_DATA3 = 172,
	MX53_PAD_PATA_DATA4 = 173,
	MX53_PAD_PATA_DATA5 = 174,
	MX53_PAD_PATA_DATA6 = 175,
	MX53_PAD_PATA_DATA7 = 176,
	MX53_PAD_PATA_DATA8 = 177,
	MX53_PAD_PATA_DATA9 = 178,
	MX53_PAD_PATA_DATA10 = 179,
	MX53_PAD_PATA_DATA11 = 180,
	MX53_PAD_PATA_DATA12 = 181,
	MX53_PAD_PATA_DATA13 = 182,
	MX53_PAD_PATA_DATA14 = 183,
	MX53_PAD_PATA_DATA15 = 184,
	MX53_PAD_SD1_DATA0 = 185,
	MX53_PAD_SD1_DATA1 = 186,
	MX53_PAD_SD1_CMD = 187,
	MX53_PAD_SD1_DATA2 = 188,
	MX53_PAD_SD1_CLK = 189,
	MX53_PAD_SD1_DATA3 = 190,
	MX53_PAD_SD2_CLK = 191,
	MX53_PAD_SD2_CMD = 192,
	MX53_PAD_SD2_DATA3 = 193,
	MX53_PAD_SD2_DATA2 = 194,
	MX53_PAD_SD2_DATA1 = 195,
	MX53_PAD_SD2_DATA0 = 196,
	MX53_PAD_GPIO_0 = 197,
	MX53_PAD_GPIO_1 = 198,
	MX53_PAD_GPIO_9 = 199,
	MX53_PAD_GPIO_3 = 200,
	MX53_PAD_GPIO_6 = 201,
	MX53_PAD_GPIO_2 = 202,
	MX53_PAD_GPIO_4 = 203,
	MX53_PAD_GPIO_5 = 204,
	MX53_PAD_GPIO_7 = 205,
	MX53_PAD_GPIO_8 = 206,
	MX53_PAD_GPIO_16 = 207,
	MX53_PAD_GPIO_17 = 208,
	MX53_PAD_GPIO_18 = 209,
};

enum imx6dl_pads {
	MX6DL_PAD_RESERVE0 = 0,
	MX6DL_PAD_RESERVE1 = 1,
	MX6DL_PAD_RESERVE2 = 2,
	MX6DL_PAD_RESERVE3 = 3,
	MX6DL_PAD_RESERVE4 = 4,
	MX6DL_PAD_RESERVE5 = 5,
	MX6DL_PAD_RESERVE6 = 6,
	MX6DL_PAD_RESERVE7 = 7,
	MX6DL_PAD_RESERVE8 = 8,
	MX6DL_PAD_RESERVE9 = 9,
	MX6DL_PAD_RESERVE10 = 10,
	MX6DL_PAD_RESERVE11 = 11,
	MX6DL_PAD_RESERVE12 = 12,
	MX6DL_PAD_RESERVE13 = 13,
	MX6DL_PAD_RESERVE14 = 14,
	MX6DL_PAD_RESERVE15 = 15,
	MX6DL_PAD_RESERVE16 = 16,
	MX6DL_PAD_RESERVE17 = 17,
	MX6DL_PAD_RESERVE18 = 18,
	MX6DL_PAD_CSI0_DAT10 = 19,
	MX6DL_PAD_CSI0_DAT11 = 20,
	MX6DL_PAD_CSI0_DAT12 = 21,
	MX6DL_PAD_CSI0_DAT13 = 22,
	MX6DL_PAD_CSI0_DAT14 = 23,
	MX6DL_PAD_CSI0_DAT15 = 24,
	MX6DL_PAD_CSI0_DAT16 = 25,
	MX6DL_PAD_CSI0_DAT17 = 26,
	MX6DL_PAD_CSI0_DAT18 = 27,
	MX6DL_PAD_CSI0_DAT19 = 28,
	MX6DL_PAD_CSI0_DAT4 = 29,
	MX6DL_PAD_CSI0_DAT5 = 30,
	MX6DL_PAD_CSI0_DAT6 = 31,
	MX6DL_PAD_CSI0_DAT7 = 32,
	MX6DL_PAD_CSI0_DAT8 = 33,
	MX6DL_PAD_CSI0_DAT9 = 34,
	MX6DL_PAD_CSI0_DATA_EN = 35,
	MX6DL_PAD_CSI0_MCLK = 36,
	MX6DL_PAD_CSI0_PIXCLK = 37,
	MX6DL_PAD_CSI0_VSYNC = 38,
	MX6DL_PAD_DI0_DISP_CLK = 39,
	MX6DL_PAD_DI0_PIN15 = 40,
	MX6DL_PAD_DI0_PIN2 = 41,
	MX6DL_PAD_DI0_PIN3 = 42,
	MX6DL_PAD_DI0_PIN4 = 43,
	MX6DL_PAD_DISP0_DAT0 = 44,
	MX6DL_PAD_DISP0_DAT1 = 45,
	MX6DL_PAD_DISP0_DAT10 = 46,
	MX6DL_PAD_DISP0_DAT11 = 47,
	MX6DL_PAD_DISP0_DAT12 = 48,
	MX6DL_PAD_DISP0_DAT13 = 49,
	MX6DL_PAD_DISP0_DAT14 = 50,
	MX6DL_PAD_DISP0_DAT15 = 51,
	MX6DL_PAD_DISP0_DAT16 = 52,
	MX6DL_PAD_DISP0_DAT17 = 53,
	MX6DL_PAD_DISP0_DAT18 = 54,
	MX6DL_PAD_DISP0_DAT19 = 55,
	MX6DL_PAD_DISP0_DAT2 = 56,
	MX6DL_PAD_DISP0_DAT20 = 57,
	MX6DL_PAD_DISP0_DAT21 = 58,
	MX6DL_PAD_DISP0_DAT22 = 59,
	MX6DL_PAD_DISP0_DAT23 = 60,
	MX6DL_PAD_DISP0_DAT3 = 61,
	MX6DL_PAD_DISP0_DAT4 = 62,
	MX6DL_PAD_DISP0_DAT5 = 63,
	MX6DL_PAD_DISP0_DAT6 = 64,
	MX6DL_PAD_DISP0_DAT7 = 65,
	MX6DL_PAD_DISP0_DAT8 = 66,
	MX6DL_PAD_DISP0_DAT9 = 67,
	MX6DL_PAD_EIM_A16 = 68,
	MX6DL_PAD_EIM_A17 = 69,
	MX6DL_PAD_EIM_A18 = 70,
	MX6DL_PAD_EIM_A19 = 71,
	MX6DL_PAD_EIM_A20 = 72,
	MX6DL_PAD_EIM_A21 = 73,
	MX6DL_PAD_EIM_A22 = 74,
	MX6DL_PAD_EIM_A23 = 75,
	MX6DL_PAD_EIM_A24 = 76,
	MX6DL_PAD_EIM_A25 = 77,
	MX6DL_PAD_EIM_BCLK = 78,
	MX6DL_PAD_EIM_CS0 = 79,
	MX6DL_PAD_EIM_CS1 = 80,
	MX6DL_PAD_EIM_D16 = 81,
	MX6DL_PAD_EIM_D17 = 82,
	MX6DL_PAD_EIM_D18 = 83,
	MX6DL_PAD_EIM_D19 = 84,
	MX6DL_PAD_EIM_D20 = 85,
	MX6DL_PAD_EIM_D21 = 86,
	MX6DL_PAD_EIM_D22 = 87,
	MX6DL_PAD_EIM_D23 = 88,
	MX6DL_PAD_EIM_D24 = 89,
	MX6DL_PAD_EIM_D25 = 90,
	MX6DL_PAD_EIM_D26 = 91,
	MX6DL_PAD_EIM_D27 = 92,
	MX6DL_PAD_EIM_D28 = 93,
	MX6DL_PAD_EIM_D29 = 94,
	MX6DL_PAD_EIM_D30 = 95,
	MX6DL_PAD_EIM_D31 = 96,
	MX6DL_PAD_EIM_DA0 = 97,
	MX6DL_PAD_EIM_DA1 = 98,
	MX6DL_PAD_EIM_DA10 = 99,
	MX6DL_PAD_EIM_DA11 = 100,
	MX6DL_PAD_EIM_DA12 = 101,
	MX6DL_PAD_EIM_DA13 = 102,
	MX6DL_PAD_EIM_DA14 = 103,
	MX6DL_PAD_EIM_DA15 = 104,
	MX6DL_PAD_EIM_DA2 = 105,
	MX6DL_PAD_EIM_DA3 = 106,
	MX6DL_PAD_EIM_DA4 = 107,
	MX6DL_PAD_EIM_DA5 = 108,
	MX6DL_PAD_EIM_DA6 = 109,
	MX6DL_PAD_EIM_DA7 = 110,
	MX6DL_PAD_EIM_DA8 = 111,
	MX6DL_PAD_EIM_DA9 = 112,
	MX6DL_PAD_EIM_EB0 = 113,
	MX6DL_PAD_EIM_EB1 = 114,
	MX6DL_PAD_EIM_EB2 = 115,
	MX6DL_PAD_EIM_EB3 = 116,
	MX6DL_PAD_EIM_LBA = 117,
	MX6DL_PAD_EIM_OE = 118,
	MX6DL_PAD_EIM_RW = 119,
	MX6DL_PAD_EIM_WAIT = 120,
	MX6DL_PAD_ENET_CRS_DV = 121,
	MX6DL_PAD_ENET_MDC = 122,
	MX6DL_PAD_ENET_MDIO = 123,
	MX6DL_PAD_ENET_REF_CLK = 124,
	MX6DL_PAD_ENET_RX_ER = 125,
	MX6DL_PAD_ENET_RXD0 = 126,
	MX6DL_PAD_ENET_RXD1 = 127,
	MX6DL_PAD_ENET_TX_EN = 128,
	MX6DL_PAD_ENET_TXD0 = 129,
	MX6DL_PAD_ENET_TXD1 = 130,
	MX6DL_PAD_GPIO_0 = 131,
	MX6DL_PAD_GPIO_1 = 132,
	MX6DL_PAD_GPIO_16 = 133,
	MX6DL_PAD_GPIO_17 = 134,
	MX6DL_PAD_GPIO_18 = 135,
	MX6DL_PAD_GPIO_19 = 136,
	MX6DL_PAD_GPIO_2 = 137,
	MX6DL_PAD_GPIO_3 = 138,
	MX6DL_PAD_GPIO_4 = 139,
	MX6DL_PAD_GPIO_5 = 140,
	MX6DL_PAD_GPIO_6 = 141,
	MX6DL_PAD_GPIO_7 = 142,
	MX6DL_PAD_GPIO_8 = 143,
	MX6DL_PAD_GPIO_9 = 144,
	MX6DL_PAD_KEY_COL0 = 145,
	MX6DL_PAD_KEY_COL1 = 146,
	MX6DL_PAD_KEY_COL2 = 147,
	MX6DL_PAD_KEY_COL3 = 148,
	MX6DL_PAD_KEY_COL4 = 149,
	MX6DL_PAD_KEY_ROW0 = 150,
	MX6DL_PAD_KEY_ROW1 = 151,
	MX6DL_PAD_KEY_ROW2 = 152,
	MX6DL_PAD_KEY_ROW3 = 153,
	MX6DL_PAD_KEY_ROW4 = 154,
	MX6DL_PAD_NANDF_ALE = 155,
	MX6DL_PAD_NANDF_CLE = 156,
	MX6DL_PAD_NANDF_CS0 = 157,
	MX6DL_PAD_NANDF_CS1 = 158,
	MX6DL_PAD_NANDF_CS2 = 159,
	MX6DL_PAD_NANDF_CS3 = 160,
	MX6DL_PAD_NANDF_D0 = 161,
	MX6DL_PAD_NANDF_D1 = 162,
	MX6DL_PAD_NANDF_D2 = 163,
	MX6DL_PAD_NANDF_D3 = 164,
	MX6DL_PAD_NANDF_D4 = 165,
	MX6DL_PAD_NANDF_D5 = 166,
	MX6DL_PAD_NANDF_D6 = 167,
	MX6DL_PAD_NANDF_D7 = 168,
	MX6DL_PAD_NANDF_RB0 = 169,
	MX6DL_PAD_NANDF_WP_B = 170,
	MX6DL_PAD_RGMII_RD0 = 171,
	MX6DL_PAD_RGMII_RD1 = 172,
	MX6DL_PAD_RGMII_RD2 = 173,
	MX6DL_PAD_RGMII_RD3 = 174,
	MX6DL_PAD_RGMII_RX_CTL = 175,
	MX6DL_PAD_RGMII_RXC = 176,
	MX6DL_PAD_RGMII_TD0 = 177,
	MX6DL_PAD_RGMII_TD1 = 178,
	MX6DL_PAD_RGMII_TD2 = 179,
	MX6DL_PAD_RGMII_TD3 = 180,
	MX6DL_PAD_RGMII_TX_CTL = 181,
	MX6DL_PAD_RGMII_TXC = 182,
	MX6DL_PAD_SD1_CLK = 183,
	MX6DL_PAD_SD1_CMD = 184,
	MX6DL_PAD_SD1_DAT0 = 185,
	MX6DL_PAD_SD1_DAT1 = 186,
	MX6DL_PAD_SD1_DAT2 = 187,
	MX6DL_PAD_SD1_DAT3 = 188,
	MX6DL_PAD_SD2_CLK = 189,
	MX6DL_PAD_SD2_CMD = 190,
	MX6DL_PAD_SD2_DAT0 = 191,
	MX6DL_PAD_SD2_DAT1 = 192,
	MX6DL_PAD_SD2_DAT2 = 193,
	MX6DL_PAD_SD2_DAT3 = 194,
	MX6DL_PAD_SD3_CLK = 195,
	MX6DL_PAD_SD3_CMD = 196,
	MX6DL_PAD_SD3_DAT0 = 197,
	MX6DL_PAD_SD3_DAT1 = 198,
	MX6DL_PAD_SD3_DAT2 = 199,
	MX6DL_PAD_SD3_DAT3 = 200,
	MX6DL_PAD_SD3_DAT4 = 201,
	MX6DL_PAD_SD3_DAT5 = 202,
	MX6DL_PAD_SD3_DAT6 = 203,
	MX6DL_PAD_SD3_DAT7 = 204,
	MX6DL_PAD_SD3_RST = 205,
	MX6DL_PAD_SD4_CLK = 206,
	MX6DL_PAD_SD4_CMD = 207,
	MX6DL_PAD_SD4_DAT0 = 208,
	MX6DL_PAD_SD4_DAT1 = 209,
	MX6DL_PAD_SD4_DAT2 = 210,
	MX6DL_PAD_SD4_DAT3 = 211,
	MX6DL_PAD_SD4_DAT4 = 212,
	MX6DL_PAD_SD4_DAT5 = 213,
	MX6DL_PAD_SD4_DAT6 = 214,
	MX6DL_PAD_SD4_DAT7 = 215,
};

enum imx6q_pads {
	MX6Q_PAD_RESERVE0 = 0,
	MX6Q_PAD_RESERVE1 = 1,
	MX6Q_PAD_RESERVE2 = 2,
	MX6Q_PAD_RESERVE3 = 3,
	MX6Q_PAD_RESERVE4 = 4,
	MX6Q_PAD_RESERVE5 = 5,
	MX6Q_PAD_RESERVE6 = 6,
	MX6Q_PAD_RESERVE7 = 7,
	MX6Q_PAD_RESERVE8 = 8,
	MX6Q_PAD_RESERVE9 = 9,
	MX6Q_PAD_RESERVE10 = 10,
	MX6Q_PAD_RESERVE11 = 11,
	MX6Q_PAD_RESERVE12 = 12,
	MX6Q_PAD_RESERVE13 = 13,
	MX6Q_PAD_RESERVE14 = 14,
	MX6Q_PAD_RESERVE15 = 15,
	MX6Q_PAD_RESERVE16 = 16,
	MX6Q_PAD_RESERVE17 = 17,
	MX6Q_PAD_RESERVE18 = 18,
	MX6Q_PAD_SD2_DAT1 = 19,
	MX6Q_PAD_SD2_DAT2 = 20,
	MX6Q_PAD_SD2_DAT0 = 21,
	MX6Q_PAD_RGMII_TXC = 22,
	MX6Q_PAD_RGMII_TD0 = 23,
	MX6Q_PAD_RGMII_TD1 = 24,
	MX6Q_PAD_RGMII_TD2 = 25,
	MX6Q_PAD_RGMII_TD3 = 26,
	MX6Q_PAD_RGMII_RX_CTL = 27,
	MX6Q_PAD_RGMII_RD0 = 28,
	MX6Q_PAD_RGMII_TX_CTL = 29,
	MX6Q_PAD_RGMII_RD1 = 30,
	MX6Q_PAD_RGMII_RD2 = 31,
	MX6Q_PAD_RGMII_RD3 = 32,
	MX6Q_PAD_RGMII_RXC = 33,
	MX6Q_PAD_EIM_A25 = 34,
	MX6Q_PAD_EIM_EB2 = 35,
	MX6Q_PAD_EIM_D16 = 36,
	MX6Q_PAD_EIM_D17 = 37,
	MX6Q_PAD_EIM_D18 = 38,
	MX6Q_PAD_EIM_D19 = 39,
	MX6Q_PAD_EIM_D20 = 40,
	MX6Q_PAD_EIM_D21 = 41,
	MX6Q_PAD_EIM_D22 = 42,
	MX6Q_PAD_EIM_D23 = 43,
	MX6Q_PAD_EIM_EB3 = 44,
	MX6Q_PAD_EIM_D24 = 45,
	MX6Q_PAD_EIM_D25 = 46,
	MX6Q_PAD_EIM_D26 = 47,
	MX6Q_PAD_EIM_D27 = 48,
	MX6Q_PAD_EIM_D28 = 49,
	MX6Q_PAD_EIM_D29 = 50,
	MX6Q_PAD_EIM_D30 = 51,
	MX6Q_PAD_EIM_D31 = 52,
	MX6Q_PAD_EIM_A24 = 53,
	MX6Q_PAD_EIM_A23 = 54,
	MX6Q_PAD_EIM_A22 = 55,
	MX6Q_PAD_EIM_A21 = 56,
	MX6Q_PAD_EIM_A20 = 57,
	MX6Q_PAD_EIM_A19 = 58,
	MX6Q_PAD_EIM_A18 = 59,
	MX6Q_PAD_EIM_A17 = 60,
	MX6Q_PAD_EIM_A16 = 61,
	MX6Q_PAD_EIM_CS0 = 62,
	MX6Q_PAD_EIM_CS1 = 63,
	MX6Q_PAD_EIM_OE = 64,
	MX6Q_PAD_EIM_RW = 65,
	MX6Q_PAD_EIM_LBA = 66,
	MX6Q_PAD_EIM_EB0 = 67,
	MX6Q_PAD_EIM_EB1 = 68,
	MX6Q_PAD_EIM_DA0 = 69,
	MX6Q_PAD_EIM_DA1 = 70,
	MX6Q_PAD_EIM_DA2 = 71,
	MX6Q_PAD_EIM_DA3 = 72,
	MX6Q_PAD_EIM_DA4 = 73,
	MX6Q_PAD_EIM_DA5 = 74,
	MX6Q_PAD_EIM_DA6 = 75,
	MX6Q_PAD_EIM_DA7 = 76,
	MX6Q_PAD_EIM_DA8 = 77,
	MX6Q_PAD_EIM_DA9 = 78,
	MX6Q_PAD_EIM_DA10 = 79,
	MX6Q_PAD_EIM_DA11 = 80,
	MX6Q_PAD_EIM_DA12 = 81,
	MX6Q_PAD_EIM_DA13 = 82,
	MX6Q_PAD_EIM_DA14 = 83,
	MX6Q_PAD_EIM_DA15 = 84,
	MX6Q_PAD_EIM_WAIT = 85,
	MX6Q_PAD_EIM_BCLK = 86,
	MX6Q_PAD_DI0_DISP_CLK = 87,
	MX6Q_PAD_DI0_PIN15 = 88,
	MX6Q_PAD_DI0_PIN2 = 89,
	MX6Q_PAD_DI0_PIN3 = 90,
	MX6Q_PAD_DI0_PIN4 = 91,
	MX6Q_PAD_DISP0_DAT0 = 92,
	MX6Q_PAD_DISP0_DAT1 = 93,
	MX6Q_PAD_DISP0_DAT2 = 94,
	MX6Q_PAD_DISP0_DAT3 = 95,
	MX6Q_PAD_DISP0_DAT4 = 96,
	MX6Q_PAD_DISP0_DAT5 = 97,
	MX6Q_PAD_DISP0_DAT6 = 98,
	MX6Q_PAD_DISP0_DAT7 = 99,
	MX6Q_PAD_DISP0_DAT8 = 100,
	MX6Q_PAD_DISP0_DAT9 = 101,
	MX6Q_PAD_DISP0_DAT10 = 102,
	MX6Q_PAD_DISP0_DAT11 = 103,
	MX6Q_PAD_DISP0_DAT12 = 104,
	MX6Q_PAD_DISP0_DAT13 = 105,
	MX6Q_PAD_DISP0_DAT14 = 106,
	MX6Q_PAD_DISP0_DAT15 = 107,
	MX6Q_PAD_DISP0_DAT16 = 108,
	MX6Q_PAD_DISP0_DAT17 = 109,
	MX6Q_PAD_DISP0_DAT18 = 110,
	MX6Q_PAD_DISP0_DAT19 = 111,
	MX6Q_PAD_DISP0_DAT20 = 112,
	MX6Q_PAD_DISP0_DAT21 = 113,
	MX6Q_PAD_DISP0_DAT22 = 114,
	MX6Q_PAD_DISP0_DAT23 = 115,
	MX6Q_PAD_ENET_MDIO = 116,
	MX6Q_PAD_ENET_REF_CLK = 117,
	MX6Q_PAD_ENET_RX_ER = 118,
	MX6Q_PAD_ENET_CRS_DV = 119,
	MX6Q_PAD_ENET_RXD1 = 120,
	MX6Q_PAD_ENET_RXD0 = 121,
	MX6Q_PAD_ENET_TX_EN = 122,
	MX6Q_PAD_ENET_TXD1 = 123,
	MX6Q_PAD_ENET_TXD0 = 124,
	MX6Q_PAD_ENET_MDC = 125,
	MX6Q_PAD_KEY_COL0 = 126,
	MX6Q_PAD_KEY_ROW0 = 127,
	MX6Q_PAD_KEY_COL1 = 128,
	MX6Q_PAD_KEY_ROW1 = 129,
	MX6Q_PAD_KEY_COL2 = 130,
	MX6Q_PAD_KEY_ROW2 = 131,
	MX6Q_PAD_KEY_COL3 = 132,
	MX6Q_PAD_KEY_ROW3 = 133,
	MX6Q_PAD_KEY_COL4 = 134,
	MX6Q_PAD_KEY_ROW4 = 135,
	MX6Q_PAD_GPIO_0 = 136,
	MX6Q_PAD_GPIO_1 = 137,
	MX6Q_PAD_GPIO_9 = 138,
	MX6Q_PAD_GPIO_3 = 139,
	MX6Q_PAD_GPIO_6 = 140,
	MX6Q_PAD_GPIO_2 = 141,
	MX6Q_PAD_GPIO_4 = 142,
	MX6Q_PAD_GPIO_5 = 143,
	MX6Q_PAD_GPIO_7 = 144,
	MX6Q_PAD_GPIO_8 = 145,
	MX6Q_PAD_GPIO_16 = 146,
	MX6Q_PAD_GPIO_17 = 147,
	MX6Q_PAD_GPIO_18 = 148,
	MX6Q_PAD_GPIO_19 = 149,
	MX6Q_PAD_CSI0_PIXCLK = 150,
	MX6Q_PAD_CSI0_MCLK = 151,
	MX6Q_PAD_CSI0_DATA_EN = 152,
	MX6Q_PAD_CSI0_VSYNC = 153,
	MX6Q_PAD_CSI0_DAT4 = 154,
	MX6Q_PAD_CSI0_DAT5 = 155,
	MX6Q_PAD_CSI0_DAT6 = 156,
	MX6Q_PAD_CSI0_DAT7 = 157,
	MX6Q_PAD_CSI0_DAT8 = 158,
	MX6Q_PAD_CSI0_DAT9 = 159,
	MX6Q_PAD_CSI0_DAT10 = 160,
	MX6Q_PAD_CSI0_DAT11 = 161,
	MX6Q_PAD_CSI0_DAT12 = 162,
	MX6Q_PAD_CSI0_DAT13 = 163,
	MX6Q_PAD_CSI0_DAT14 = 164,
	MX6Q_PAD_CSI0_DAT15 = 165,
	MX6Q_PAD_CSI0_DAT16 = 166,
	MX6Q_PAD_CSI0_DAT17 = 167,
	MX6Q_PAD_CSI0_DAT18 = 168,
	MX6Q_PAD_CSI0_DAT19 = 169,
	MX6Q_PAD_SD3_DAT7 = 170,
	MX6Q_PAD_SD3_DAT6 = 171,
	MX6Q_PAD_SD3_DAT5 = 172,
	MX6Q_PAD_SD3_DAT4 = 173,
	MX6Q_PAD_SD3_CMD = 174,
	MX6Q_PAD_SD3_CLK = 175,
	MX6Q_PAD_SD3_DAT0 = 176,
	MX6Q_PAD_SD3_DAT1 = 177,
	MX6Q_PAD_SD3_DAT2 = 178,
	MX6Q_PAD_SD3_DAT3 = 179,
	MX6Q_PAD_SD3_RST = 180,
	MX6Q_PAD_NANDF_CLE = 181,
	MX6Q_PAD_NANDF_ALE = 182,
	MX6Q_PAD_NANDF_WP_B = 183,
	MX6Q_PAD_NANDF_RB0 = 184,
	MX6Q_PAD_NANDF_CS0 = 185,
	MX6Q_PAD_NANDF_CS1 = 186,
	MX6Q_PAD_NANDF_CS2 = 187,
	MX6Q_PAD_NANDF_CS3 = 188,
	MX6Q_PAD_SD4_CMD = 189,
	MX6Q_PAD_SD4_CLK = 190,
	MX6Q_PAD_NANDF_D0 = 191,
	MX6Q_PAD_NANDF_D1 = 192,
	MX6Q_PAD_NANDF_D2 = 193,
	MX6Q_PAD_NANDF_D3 = 194,
	MX6Q_PAD_NANDF_D4 = 195,
	MX6Q_PAD_NANDF_D5 = 196,
	MX6Q_PAD_NANDF_D6 = 197,
	MX6Q_PAD_NANDF_D7 = 198,
	MX6Q_PAD_SD4_DAT0 = 199,
	MX6Q_PAD_SD4_DAT1 = 200,
	MX6Q_PAD_SD4_DAT2 = 201,
	MX6Q_PAD_SD4_DAT3 = 202,
	MX6Q_PAD_SD4_DAT4 = 203,
	MX6Q_PAD_SD4_DAT5 = 204,
	MX6Q_PAD_SD4_DAT6 = 205,
	MX6Q_PAD_SD4_DAT7 = 206,
	MX6Q_PAD_SD1_DAT1 = 207,
	MX6Q_PAD_SD1_DAT0 = 208,
	MX6Q_PAD_SD1_DAT3 = 209,
	MX6Q_PAD_SD1_CMD = 210,
	MX6Q_PAD_SD1_DAT2 = 211,
	MX6Q_PAD_SD1_CLK = 212,
	MX6Q_PAD_SD2_CLK = 213,
	MX6Q_PAD_SD2_CMD = 214,
	MX6Q_PAD_SD2_DAT3 = 215,
};

enum imx6sl_pads {
	MX6SL_PAD_RESERVE0 = 0,
	MX6SL_PAD_RESERVE1 = 1,
	MX6SL_PAD_RESERVE2 = 2,
	MX6SL_PAD_RESERVE3 = 3,
	MX6SL_PAD_RESERVE4 = 4,
	MX6SL_PAD_RESERVE5 = 5,
	MX6SL_PAD_RESERVE6 = 6,
	MX6SL_PAD_RESERVE7 = 7,
	MX6SL_PAD_RESERVE8 = 8,
	MX6SL_PAD_RESERVE9 = 9,
	MX6SL_PAD_RESERVE10 = 10,
	MX6SL_PAD_RESERVE11 = 11,
	MX6SL_PAD_RESERVE12 = 12,
	MX6SL_PAD_RESERVE13 = 13,
	MX6SL_PAD_RESERVE14 = 14,
	MX6SL_PAD_RESERVE15 = 15,
	MX6SL_PAD_RESERVE16 = 16,
	MX6SL_PAD_RESERVE17 = 17,
	MX6SL_PAD_RESERVE18 = 18,
	MX6SL_PAD_AUD_MCLK = 19,
	MX6SL_PAD_AUD_RXC = 20,
	MX6SL_PAD_AUD_RXD = 21,
	MX6SL_PAD_AUD_RXFS = 22,
	MX6SL_PAD_AUD_TXC = 23,
	MX6SL_PAD_AUD_TXD = 24,
	MX6SL_PAD_AUD_TXFS = 25,
	MX6SL_PAD_ECSPI1_MISO = 26,
	MX6SL_PAD_ECSPI1_MOSI = 27,
	MX6SL_PAD_ECSPI1_SCLK = 28,
	MX6SL_PAD_ECSPI1_SS0 = 29,
	MX6SL_PAD_ECSPI2_MISO = 30,
	MX6SL_PAD_ECSPI2_MOSI = 31,
	MX6SL_PAD_ECSPI2_SCLK = 32,
	MX6SL_PAD_ECSPI2_SS0 = 33,
	MX6SL_PAD_EPDC_BDR0 = 34,
	MX6SL_PAD_EPDC_BDR1 = 35,
	MX6SL_PAD_EPDC_D0 = 36,
	MX6SL_PAD_EPDC_D1 = 37,
	MX6SL_PAD_EPDC_D10 = 38,
	MX6SL_PAD_EPDC_D11 = 39,
	MX6SL_PAD_EPDC_D12 = 40,
	MX6SL_PAD_EPDC_D13 = 41,
	MX6SL_PAD_EPDC_D14 = 42,
	MX6SL_PAD_EPDC_D15 = 43,
	MX6SL_PAD_EPDC_D2 = 44,
	MX6SL_PAD_EPDC_D3 = 45,
	MX6SL_PAD_EPDC_D4 = 46,
	MX6SL_PAD_EPDC_D5 = 47,
	MX6SL_PAD_EPDC_D6 = 48,
	MX6SL_PAD_EPDC_D7 = 49,
	MX6SL_PAD_EPDC_D8 = 50,
	MX6SL_PAD_EPDC_D9 = 51,
	MX6SL_PAD_EPDC_GDCLK = 52,
	MX6SL_PAD_EPDC_GDOE = 53,
	MX6SL_PAD_EPDC_GDRL = 54,
	MX6SL_PAD_EPDC_GDSP = 55,
	MX6SL_PAD_EPDC_PWRCOM = 56,
	MX6SL_PAD_EPDC_PWRCTRL0 = 57,
	MX6SL_PAD_EPDC_PWRCTRL1 = 58,
	MX6SL_PAD_EPDC_PWRCTRL2 = 59,
	MX6SL_PAD_EPDC_PWRCTRL3 = 60,
	MX6SL_PAD_EPDC_PWRINT = 61,
	MX6SL_PAD_EPDC_PWRSTAT = 62,
	MX6SL_PAD_EPDC_PWRWAKEUP = 63,
	MX6SL_PAD_EPDC_SDCE0 = 64,
	MX6SL_PAD_EPDC_SDCE1 = 65,
	MX6SL_PAD_EPDC_SDCE2 = 66,
	MX6SL_PAD_EPDC_SDCE3 = 67,
	MX6SL_PAD_EPDC_SDCLK = 68,
	MX6SL_PAD_EPDC_SDLE = 69,
	MX6SL_PAD_EPDC_SDOE = 70,
	MX6SL_PAD_EPDC_SDSHR = 71,
	MX6SL_PAD_EPDC_VCOM0 = 72,
	MX6SL_PAD_EPDC_VCOM1 = 73,
	MX6SL_PAD_FEC_CRS_DV = 74,
	MX6SL_PAD_FEC_MDC = 75,
	MX6SL_PAD_FEC_MDIO = 76,
	MX6SL_PAD_FEC_REF_CLK = 77,
	MX6SL_PAD_FEC_RX_ER = 78,
	MX6SL_PAD_FEC_RXD0 = 79,
	MX6SL_PAD_FEC_RXD1 = 80,
	MX6SL_PAD_FEC_TX_CLK = 81,
	MX6SL_PAD_FEC_TX_EN = 82,
	MX6SL_PAD_FEC_TXD0 = 83,
	MX6SL_PAD_FEC_TXD1 = 84,
	MX6SL_PAD_HSIC_DAT = 85,
	MX6SL_PAD_HSIC_STROBE = 86,
	MX6SL_PAD_I2C1_SCL = 87,
	MX6SL_PAD_I2C1_SDA = 88,
	MX6SL_PAD_I2C2_SCL = 89,
	MX6SL_PAD_I2C2_SDA = 90,
	MX6SL_PAD_KEY_COL0 = 91,
	MX6SL_PAD_KEY_COL1 = 92,
	MX6SL_PAD_KEY_COL2 = 93,
	MX6SL_PAD_KEY_COL3 = 94,
	MX6SL_PAD_KEY_COL4 = 95,
	MX6SL_PAD_KEY_COL5 = 96,
	MX6SL_PAD_KEY_COL6 = 97,
	MX6SL_PAD_KEY_COL7 = 98,
	MX6SL_PAD_KEY_ROW0 = 99,
	MX6SL_PAD_KEY_ROW1 = 100,
	MX6SL_PAD_KEY_ROW2 = 101,
	MX6SL_PAD_KEY_ROW3 = 102,
	MX6SL_PAD_KEY_ROW4 = 103,
	MX6SL_PAD_KEY_ROW5 = 104,
	MX6SL_PAD_KEY_ROW6 = 105,
	MX6SL_PAD_KEY_ROW7 = 106,
	MX6SL_PAD_LCD_CLK = 107,
	MX6SL_PAD_LCD_DAT0 = 108,
	MX6SL_PAD_LCD_DAT1 = 109,
	MX6SL_PAD_LCD_DAT10 = 110,
	MX6SL_PAD_LCD_DAT11 = 111,
	MX6SL_PAD_LCD_DAT12 = 112,
	MX6SL_PAD_LCD_DAT13 = 113,
	MX6SL_PAD_LCD_DAT14 = 114,
	MX6SL_PAD_LCD_DAT15 = 115,
	MX6SL_PAD_LCD_DAT16 = 116,
	MX6SL_PAD_LCD_DAT17 = 117,
	MX6SL_PAD_LCD_DAT18 = 118,
	MX6SL_PAD_LCD_DAT19 = 119,
	MX6SL_PAD_LCD_DAT2 = 120,
	MX6SL_PAD_LCD_DAT20 = 121,
	MX6SL_PAD_LCD_DAT21 = 122,
	MX6SL_PAD_LCD_DAT22 = 123,
	MX6SL_PAD_LCD_DAT23 = 124,
	MX6SL_PAD_LCD_DAT3 = 125,
	MX6SL_PAD_LCD_DAT4 = 126,
	MX6SL_PAD_LCD_DAT5 = 127,
	MX6SL_PAD_LCD_DAT6 = 128,
	MX6SL_PAD_LCD_DAT7 = 129,
	MX6SL_PAD_LCD_DAT8 = 130,
	MX6SL_PAD_LCD_DAT9 = 131,
	MX6SL_PAD_LCD_ENABLE = 132,
	MX6SL_PAD_LCD_HSYNC = 133,
	MX6SL_PAD_LCD_RESET = 134,
	MX6SL_PAD_LCD_VSYNC = 135,
	MX6SL_PAD_PWM1 = 136,
	MX6SL_PAD_REF_CLK_24M = 137,
	MX6SL_PAD_REF_CLK_32K = 138,
	MX6SL_PAD_SD1_CLK = 139,
	MX6SL_PAD_SD1_CMD = 140,
	MX6SL_PAD_SD1_DAT0 = 141,
	MX6SL_PAD_SD1_DAT1 = 142,
	MX6SL_PAD_SD1_DAT2 = 143,
	MX6SL_PAD_SD1_DAT3 = 144,
	MX6SL_PAD_SD1_DAT4 = 145,
	MX6SL_PAD_SD1_DAT5 = 146,
	MX6SL_PAD_SD1_DAT6 = 147,
	MX6SL_PAD_SD1_DAT7 = 148,
	MX6SL_PAD_SD2_CLK = 149,
	MX6SL_PAD_SD2_CMD = 150,
	MX6SL_PAD_SD2_DAT0 = 151,
	MX6SL_PAD_SD2_DAT1 = 152,
	MX6SL_PAD_SD2_DAT2 = 153,
	MX6SL_PAD_SD2_DAT3 = 154,
	MX6SL_PAD_SD2_DAT4 = 155,
	MX6SL_PAD_SD2_DAT5 = 156,
	MX6SL_PAD_SD2_DAT6 = 157,
	MX6SL_PAD_SD2_DAT7 = 158,
	MX6SL_PAD_SD2_RST = 159,
	MX6SL_PAD_SD3_CLK = 160,
	MX6SL_PAD_SD3_CMD = 161,
	MX6SL_PAD_SD3_DAT0 = 162,
	MX6SL_PAD_SD3_DAT1 = 163,
	MX6SL_PAD_SD3_DAT2 = 164,
	MX6SL_PAD_SD3_DAT3 = 165,
	MX6SL_PAD_UART1_RXD = 166,
	MX6SL_PAD_UART1_TXD = 167,
	MX6SL_PAD_WDOG_B = 168,
};

enum imx6sll_pads {
	MX6SLL_PAD_RESERVE0 = 0,
	MX6SLL_PAD_RESERVE1 = 1,
	MX6SLL_PAD_RESERVE2 = 2,
	MX6SLL_PAD_RESERVE3 = 3,
	MX6SLL_PAD_RESERVE4 = 4,
	MX6SLL_PAD_WDOG_B = 5,
	MX6SLL_PAD_REF_CLK_24M = 6,
	MX6SLL_PAD_REF_CLK_32K = 7,
	MX6SLL_PAD_PWM1 = 8,
	MX6SLL_PAD_KEY_COL0 = 9,
	MX6SLL_PAD_KEY_ROW0 = 10,
	MX6SLL_PAD_KEY_COL1 = 11,
	MX6SLL_PAD_KEY_ROW1 = 12,
	MX6SLL_PAD_KEY_COL2 = 13,
	MX6SLL_PAD_KEY_ROW2 = 14,
	MX6SLL_PAD_KEY_COL3 = 15,
	MX6SLL_PAD_KEY_ROW3 = 16,
	MX6SLL_PAD_KEY_COL4 = 17,
	MX6SLL_PAD_KEY_ROW4 = 18,
	MX6SLL_PAD_KEY_COL5 = 19,
	MX6SLL_PAD_KEY_ROW5 = 20,
	MX6SLL_PAD_KEY_COL6 = 21,
	MX6SLL_PAD_KEY_ROW6 = 22,
	MX6SLL_PAD_KEY_COL7 = 23,
	MX6SLL_PAD_KEY_ROW7 = 24,
	MX6SLL_PAD_EPDC_DATA00 = 25,
	MX6SLL_PAD_EPDC_DATA01 = 26,
	MX6SLL_PAD_EPDC_DATA02 = 27,
	MX6SLL_PAD_EPDC_DATA03 = 28,
	MX6SLL_PAD_EPDC_DATA04 = 29,
	MX6SLL_PAD_EPDC_DATA05 = 30,
	MX6SLL_PAD_EPDC_DATA06 = 31,
	MX6SLL_PAD_EPDC_DATA07 = 32,
	MX6SLL_PAD_EPDC_DATA08 = 33,
	MX6SLL_PAD_EPDC_DATA09 = 34,
	MX6SLL_PAD_EPDC_DATA10 = 35,
	MX6SLL_PAD_EPDC_DATA11 = 36,
	MX6SLL_PAD_EPDC_DATA12 = 37,
	MX6SLL_PAD_EPDC_DATA13 = 38,
	MX6SLL_PAD_EPDC_DATA14 = 39,
	MX6SLL_PAD_EPDC_DATA15 = 40,
	MX6SLL_PAD_EPDC_SDCLK = 41,
	MX6SLL_PAD_EPDC_SDLE = 42,
	MX6SLL_PAD_EPDC_SDOE = 43,
	MX6SLL_PAD_EPDC_SDSHR = 44,
	MX6SLL_PAD_EPDC_SDCE0 = 45,
	MX6SLL_PAD_EPDC_SDCE1 = 46,
	MX6SLL_PAD_EPDC_SDCE2 = 47,
	MX6SLL_PAD_EPDC_SDCE3 = 48,
	MX6SLL_PAD_EPDC_GDCLK = 49,
	MX6SLL_PAD_EPDC_GDOE = 50,
	MX6SLL_PAD_EPDC_GDRL = 51,
	MX6SLL_PAD_EPDC_GDSP = 52,
	MX6SLL_PAD_EPDC_VCOM0 = 53,
	MX6SLL_PAD_EPDC_VCOM1 = 54,
	MX6SLL_PAD_EPDC_BDR0 = 55,
	MX6SLL_PAD_EPDC_BDR1 = 56,
	MX6SLL_PAD_EPDC_PWR_CTRL0 = 57,
	MX6SLL_PAD_EPDC_PWR_CTRL1 = 58,
	MX6SLL_PAD_EPDC_PWR_CTRL2 = 59,
	MX6SLL_PAD_EPDC_PWR_CTRL3 = 60,
	MX6SLL_PAD_EPDC_PWR_COM = 61,
	MX6SLL_PAD_EPDC_PWR_INT = 62,
	MX6SLL_PAD_EPDC_PWR_STAT = 63,
	MX6SLL_PAD_EPDC_PWR_WAKE = 64,
	MX6SLL_PAD_LCD_CLK = 65,
	MX6SLL_PAD_LCD_ENABLE = 66,
	MX6SLL_PAD_LCD_HSYNC = 67,
	MX6SLL_PAD_LCD_VSYNC = 68,
	MX6SLL_PAD_LCD_RESET = 69,
	MX6SLL_PAD_LCD_DATA00 = 70,
	MX6SLL_PAD_LCD_DATA01 = 71,
	MX6SLL_PAD_LCD_DATA02 = 72,
	MX6SLL_PAD_LCD_DATA03 = 73,
	MX6SLL_PAD_LCD_DATA04 = 74,
	MX6SLL_PAD_LCD_DATA05 = 75,
	MX6SLL_PAD_LCD_DATA06 = 76,
	MX6SLL_PAD_LCD_DATA07 = 77,
	MX6SLL_PAD_LCD_DATA08 = 78,
	MX6SLL_PAD_LCD_DATA09 = 79,
	MX6SLL_PAD_LCD_DATA10 = 80,
	MX6SLL_PAD_LCD_DATA11 = 81,
	MX6SLL_PAD_LCD_DATA12 = 82,
	MX6SLL_PAD_LCD_DATA13 = 83,
	MX6SLL_PAD_LCD_DATA14 = 84,
	MX6SLL_PAD_LCD_DATA15 = 85,
	MX6SLL_PAD_LCD_DATA16 = 86,
	MX6SLL_PAD_LCD_DATA17 = 87,
	MX6SLL_PAD_LCD_DATA18 = 88,
	MX6SLL_PAD_LCD_DATA19 = 89,
	MX6SLL_PAD_LCD_DATA20 = 90,
	MX6SLL_PAD_LCD_DATA21 = 91,
	MX6SLL_PAD_LCD_DATA22 = 92,
	MX6SLL_PAD_LCD_DATA23 = 93,
	MX6SLL_PAD_AUD_RXFS = 94,
	MX6SLL_PAD_AUD_RXC = 95,
	MX6SLL_PAD_AUD_RXD = 96,
	MX6SLL_PAD_AUD_TXC = 97,
	MX6SLL_PAD_AUD_TXFS = 98,
	MX6SLL_PAD_AUD_TXD = 99,
	MX6SLL_PAD_AUD_MCLK = 100,
	MX6SLL_PAD_UART1_RXD = 101,
	MX6SLL_PAD_UART1_TXD = 102,
	MX6SLL_PAD_I2C1_SCL = 103,
	MX6SLL_PAD_I2C1_SDA = 104,
	MX6SLL_PAD_I2C2_SCL = 105,
	MX6SLL_PAD_I2C2_SDA = 106,
	MX6SLL_PAD_ECSPI1_SCLK = 107,
	MX6SLL_PAD_ECSPI1_MOSI = 108,
	MX6SLL_PAD_ECSPI1_MISO = 109,
	MX6SLL_PAD_ECSPI1_SS0 = 110,
	MX6SLL_PAD_ECSPI2_SCLK = 111,
	MX6SLL_PAD_ECSPI2_MOSI = 112,
	MX6SLL_PAD_ECSPI2_MISO = 113,
	MX6SLL_PAD_ECSPI2_SS0 = 114,
	MX6SLL_PAD_SD1_CLK = 115,
	MX6SLL_PAD_SD1_CMD = 116,
	MX6SLL_PAD_SD1_DATA0 = 117,
	MX6SLL_PAD_SD1_DATA1 = 118,
	MX6SLL_PAD_SD1_DATA2 = 119,
	MX6SLL_PAD_SD1_DATA3 = 120,
	MX6SLL_PAD_SD1_DATA4 = 121,
	MX6SLL_PAD_SD1_DATA5 = 122,
	MX6SLL_PAD_SD1_DATA6 = 123,
	MX6SLL_PAD_SD1_DATA7 = 124,
	MX6SLL_PAD_SD2_RESET = 125,
	MX6SLL_PAD_SD2_CLK = 126,
	MX6SLL_PAD_SD2_CMD = 127,
	MX6SLL_PAD_SD2_DATA0 = 128,
	MX6SLL_PAD_SD2_DATA1 = 129,
	MX6SLL_PAD_SD2_DATA2 = 130,
	MX6SLL_PAD_SD2_DATA3 = 131,
	MX6SLL_PAD_SD2_DATA4 = 132,
	MX6SLL_PAD_SD2_DATA5 = 133,
	MX6SLL_PAD_SD2_DATA6 = 134,
	MX6SLL_PAD_SD2_DATA7 = 135,
	MX6SLL_PAD_SD3_CLK = 136,
	MX6SLL_PAD_SD3_CMD = 137,
	MX6SLL_PAD_SD3_DATA0 = 138,
	MX6SLL_PAD_SD3_DATA1 = 139,
	MX6SLL_PAD_SD3_DATA2 = 140,
	MX6SLL_PAD_SD3_DATA3 = 141,
	MX6SLL_PAD_GPIO4_IO20 = 142,
	MX6SLL_PAD_GPIO4_IO21 = 143,
	MX6SLL_PAD_GPIO4_IO19 = 144,
	MX6SLL_PAD_GPIO4_IO25 = 145,
	MX6SLL_PAD_GPIO4_IO18 = 146,
	MX6SLL_PAD_GPIO4_IO24 = 147,
	MX6SLL_PAD_GPIO4_IO23 = 148,
	MX6SLL_PAD_GPIO4_IO17 = 149,
	MX6SLL_PAD_GPIO4_IO22 = 150,
	MX6SLL_PAD_GPIO4_IO16 = 151,
	MX6SLL_PAD_GPIO4_IO26 = 152,
};

enum imx6sx_pads {
	MX6Sx_PAD_RESERVE0 = 0,
	MX6Sx_PAD_RESERVE1 = 1,
	MX6Sx_PAD_RESERVE2 = 2,
	MX6Sx_PAD_RESERVE3 = 3,
	MX6Sx_PAD_RESERVE4 = 4,
	MX6SX_PAD_GPIO1_IO00 = 5,
	MX6SX_PAD_GPIO1_IO01 = 6,
	MX6SX_PAD_GPIO1_IO02 = 7,
	MX6SX_PAD_GPIO1_IO03 = 8,
	MX6SX_PAD_GPIO1_IO04 = 9,
	MX6SX_PAD_GPIO1_IO05 = 10,
	MX6SX_PAD_GPIO1_IO06 = 11,
	MX6SX_PAD_GPIO1_IO07 = 12,
	MX6SX_PAD_GPIO1_IO08 = 13,
	MX6SX_PAD_GPIO1_IO09 = 14,
	MX6SX_PAD_GPIO1_IO10 = 15,
	MX6SX_PAD_GPIO1_IO11 = 16,
	MX6SX_PAD_GPIO1_IO12 = 17,
	MX6SX_PAD_GPIO1_IO13 = 18,
	MX6SX_PAD_CSI_DATA00 = 19,
	MX6SX_PAD_CSI_DATA01 = 20,
	MX6SX_PAD_CSI_DATA02 = 21,
	MX6SX_PAD_CSI_DATA03 = 22,
	MX6SX_PAD_CSI_DATA04 = 23,
	MX6SX_PAD_CSI_DATA05 = 24,
	MX6SX_PAD_CSI_DATA06 = 25,
	MX6SX_PAD_CSI_DATA07 = 26,
	MX6SX_PAD_CSI_HSYNC = 27,
	MX6SX_PAD_CSI_MCLK = 28,
	MX6SX_PAD_CSI_PIXCLK = 29,
	MX6SX_PAD_CSI_VSYNC = 30,
	MX6SX_PAD_ENET1_COL = 31,
	MX6SX_PAD_ENET1_CRS = 32,
	MX6SX_PAD_ENET1_MDC = 33,
	MX6SX_PAD_ENET1_MDIO = 34,
	MX6SX_PAD_ENET1_RX_CLK = 35,
	MX6SX_PAD_ENET1_TX_CLK = 36,
	MX6SX_PAD_ENET2_COL = 37,
	MX6SX_PAD_ENET2_CRS = 38,
	MX6SX_PAD_ENET2_RX_CLK = 39,
	MX6SX_PAD_ENET2_TX_CLK = 40,
	MX6SX_PAD_KEY_COL0 = 41,
	MX6SX_PAD_KEY_COL1 = 42,
	MX6SX_PAD_KEY_COL2 = 43,
	MX6SX_PAD_KEY_COL3 = 44,
	MX6SX_PAD_KEY_COL4 = 45,
	MX6SX_PAD_KEY_ROW0 = 46,
	MX6SX_PAD_KEY_ROW1 = 47,
	MX6SX_PAD_KEY_ROW2 = 48,
	MX6SX_PAD_KEY_ROW3 = 49,
	MX6SX_PAD_KEY_ROW4 = 50,
	MX6SX_PAD_LCD1_CLK = 51,
	MX6SX_PAD_LCD1_DATA00 = 52,
	MX6SX_PAD_LCD1_DATA01 = 53,
	MX6SX_PAD_LCD1_DATA02 = 54,
	MX6SX_PAD_LCD1_DATA03 = 55,
	MX6SX_PAD_LCD1_DATA04 = 56,
	MX6SX_PAD_LCD1_DATA05 = 57,
	MX6SX_PAD_LCD1_DATA06 = 58,
	MX6SX_PAD_LCD1_DATA07 = 59,
	MX6SX_PAD_LCD1_DATA08 = 60,
	MX6SX_PAD_LCD1_DATA09 = 61,
	MX6SX_PAD_LCD1_DATA10 = 62,
	MX6SX_PAD_LCD1_DATA11 = 63,
	MX6SX_PAD_LCD1_DATA12 = 64,
	MX6SX_PAD_LCD1_DATA13 = 65,
	MX6SX_PAD_LCD1_DATA14 = 66,
	MX6SX_PAD_LCD1_DATA15 = 67,
	MX6SX_PAD_LCD1_DATA16 = 68,
	MX6SX_PAD_LCD1_DATA17 = 69,
	MX6SX_PAD_LCD1_DATA18 = 70,
	MX6SX_PAD_LCD1_DATA19 = 71,
	MX6SX_PAD_LCD1_DATA20 = 72,
	MX6SX_PAD_LCD1_DATA21 = 73,
	MX6SX_PAD_LCD1_DATA22 = 74,
	MX6SX_PAD_LCD1_DATA23 = 75,
	MX6SX_PAD_LCD1_ENABLE = 76,
	MX6SX_PAD_LCD1_HSYNC = 77,
	MX6SX_PAD_LCD1_RESET = 78,
	MX6SX_PAD_LCD1_VSYNC = 79,
	MX6SX_PAD_NAND_ALE = 80,
	MX6SX_PAD_NAND_CE0_B = 81,
	MX6SX_PAD_NAND_CE1_B = 82,
	MX6SX_PAD_NAND_CLE = 83,
	MX6SX_PAD_NAND_DATA00 = 84,
	MX6SX_PAD_NAND_DATA01 = 85,
	MX6SX_PAD_NAND_DATA02 = 86,
	MX6SX_PAD_NAND_DATA03 = 87,
	MX6SX_PAD_NAND_DATA04 = 88,
	MX6SX_PAD_NAND_DATA05 = 89,
	MX6SX_PAD_NAND_DATA06 = 90,
	MX6SX_PAD_NAND_DATA07 = 91,
	MX6SX_PAD_NAND_RE_B = 92,
	MX6SX_PAD_NAND_READY_B = 93,
	MX6SX_PAD_NAND_WE_B = 94,
	MX6SX_PAD_NAND_WP_B = 95,
	MX6SX_PAD_QSPI1A_DATA0 = 96,
	MX6SX_PAD_QSPI1A_DATA1 = 97,
	MX6SX_PAD_QSPI1A_DATA2 = 98,
	MX6SX_PAD_QSPI1A_DATA3 = 99,
	MX6SX_PAD_QSPI1A_DQS = 100,
	MX6SX_PAD_QSPI1A_SCLK = 101,
	MX6SX_PAD_QSPI1A_SS0_B = 102,
	MX6SX_PAD_QSPI1A_SS1_B = 103,
	MX6SX_PAD_QSPI1B_DATA0 = 104,
	MX6SX_PAD_QSPI1B_DATA1 = 105,
	MX6SX_PAD_QSPI1B_DATA2 = 106,
	MX6SX_PAD_QSPI1B_DATA3 = 107,
	MX6SX_PAD_QSPI1B_DQS = 108,
	MX6SX_PAD_QSPI1B_SCLK = 109,
	MX6SX_PAD_QSPI1B_SS0_B = 110,
	MX6SX_PAD_QSPI1B_SS1_B = 111,
	MX6SX_PAD_RGMII1_RD0 = 112,
	MX6SX_PAD_RGMII1_RD1 = 113,
	MX6SX_PAD_RGMII1_RD2 = 114,
	MX6SX_PAD_RGMII1_RD3 = 115,
	MX6SX_PAD_RGMII1_RX_CTL = 116,
	MX6SX_PAD_RGMII1_RXC = 117,
	MX6SX_PAD_RGMII1_TD0 = 118,
	MX6SX_PAD_RGMII1_TD1 = 119,
	MX6SX_PAD_RGMII1_TD2 = 120,
	MX6SX_PAD_RGMII1_TD3 = 121,
	MX6SX_PAD_RGMII1_TX_CTL = 122,
	MX6SX_PAD_RGMII1_TXC = 123,
	MX6SX_PAD_RGMII2_RD0 = 124,
	MX6SX_PAD_RGMII2_RD1 = 125,
	MX6SX_PAD_RGMII2_RD2 = 126,
	MX6SX_PAD_RGMII2_RD3 = 127,
	MX6SX_PAD_RGMII2_RX_CTL = 128,
	MX6SX_PAD_RGMII2_RXC = 129,
	MX6SX_PAD_RGMII2_TD0 = 130,
	MX6SX_PAD_RGMII2_TD1 = 131,
	MX6SX_PAD_RGMII2_TD2 = 132,
	MX6SX_PAD_RGMII2_TD3 = 133,
	MX6SX_PAD_RGMII2_TX_CTL = 134,
	MX6SX_PAD_RGMII2_TXC = 135,
	MX6SX_PAD_SD1_CLK = 136,
	MX6SX_PAD_SD1_CMD = 137,
	MX6SX_PAD_SD1_DATA0 = 138,
	MX6SX_PAD_SD1_DATA1 = 139,
	MX6SX_PAD_SD1_DATA2 = 140,
	MX6SX_PAD_SD1_DATA3 = 141,
	MX6SX_PAD_SD2_CLK = 142,
	MX6SX_PAD_SD2_CMD = 143,
	MX6SX_PAD_SD2_DATA0 = 144,
	MX6SX_PAD_SD2_DATA1 = 145,
	MX6SX_PAD_SD2_DATA2 = 146,
	MX6SX_PAD_SD2_DATA3 = 147,
	MX6SX_PAD_SD3_CLK = 148,
	MX6SX_PAD_SD3_CMD = 149,
	MX6SX_PAD_SD3_DATA0 = 150,
	MX6SX_PAD_SD3_DATA1 = 151,
	MX6SX_PAD_SD3_DATA2 = 152,
	MX6SX_PAD_SD3_DATA3 = 153,
	MX6SX_PAD_SD3_DATA4 = 154,
	MX6SX_PAD_SD3_DATA5 = 155,
	MX6SX_PAD_SD3_DATA6 = 156,
	MX6SX_PAD_SD3_DATA7 = 157,
	MX6SX_PAD_SD4_CLK = 158,
	MX6SX_PAD_SD4_CMD = 159,
	MX6SX_PAD_SD4_DATA0 = 160,
	MX6SX_PAD_SD4_DATA1 = 161,
	MX6SX_PAD_SD4_DATA2 = 162,
	MX6SX_PAD_SD4_DATA3 = 163,
	MX6SX_PAD_SD4_DATA4 = 164,
	MX6SX_PAD_SD4_DATA5 = 165,
	MX6SX_PAD_SD4_DATA6 = 166,
	MX6SX_PAD_SD4_DATA7 = 167,
	MX6SX_PAD_SD4_RESET_B = 168,
	MX6SX_PAD_USB_H_DATA = 169,
	MX6SX_PAD_USB_H_STROBE = 170,
};

enum imx6ul_pads {
	MX6UL_PAD_RESERVE0 = 0,
	MX6UL_PAD_RESERVE1 = 1,
	MX6UL_PAD_RESERVE2 = 2,
	MX6UL_PAD_RESERVE3 = 3,
	MX6UL_PAD_RESERVE4 = 4,
	MX6UL_PAD_RESERVE5 = 5,
	MX6UL_PAD_RESERVE6 = 6,
	MX6UL_PAD_RESERVE7 = 7,
	MX6UL_PAD_RESERVE8 = 8,
	MX6UL_PAD_RESERVE9 = 9,
	MX6UL_PAD_RESERVE10 = 10,
	MX6UL_PAD_SNVS_TAMPER4 = 11,
	MX6UL_PAD_RESERVE12 = 12,
	MX6UL_PAD_RESERVE13 = 13,
	MX6UL_PAD_RESERVE14 = 14,
	MX6UL_PAD_RESERVE15 = 15,
	MX6UL_PAD_RESERVE16 = 16,
	MX6UL_PAD_JTAG_MOD = 17,
	MX6UL_PAD_JTAG_TMS = 18,
	MX6UL_PAD_JTAG_TDO = 19,
	MX6UL_PAD_JTAG_TDI = 20,
	MX6UL_PAD_JTAG_TCK = 21,
	MX6UL_PAD_JTAG_TRST_B = 22,
	MX6UL_PAD_GPIO1_IO00 = 23,
	MX6UL_PAD_GPIO1_IO01 = 24,
	MX6UL_PAD_GPIO1_IO02 = 25,
	MX6UL_PAD_GPIO1_IO03 = 26,
	MX6UL_PAD_GPIO1_IO04 = 27,
	MX6UL_PAD_GPIO1_IO05 = 28,
	MX6UL_PAD_GPIO1_IO06 = 29,
	MX6UL_PAD_GPIO1_IO07 = 30,
	MX6UL_PAD_GPIO1_IO08 = 31,
	MX6UL_PAD_GPIO1_IO09 = 32,
	MX6UL_PAD_UART1_TX_DATA = 33,
	MX6UL_PAD_UART1_RX_DATA = 34,
	MX6UL_PAD_UART1_CTS_B = 35,
	MX6UL_PAD_UART1_RTS_B = 36,
	MX6UL_PAD_UART2_TX_DATA = 37,
	MX6UL_PAD_UART2_RX_DATA = 38,
	MX6UL_PAD_UART2_CTS_B = 39,
	MX6UL_PAD_UART2_RTS_B = 40,
	MX6UL_PAD_UART3_TX_DATA = 41,
	MX6UL_PAD_UART3_RX_DATA = 42,
	MX6UL_PAD_UART3_CTS_B = 43,
	MX6UL_PAD_UART3_RTS_B = 44,
	MX6UL_PAD_UART4_TX_DATA = 45,
	MX6UL_PAD_UART4_RX_DATA = 46,
	MX6UL_PAD_UART5_TX_DATA = 47,
	MX6UL_PAD_UART5_RX_DATA = 48,
	MX6UL_PAD_ENET1_RX_DATA0 = 49,
	MX6UL_PAD_ENET1_RX_DATA1 = 50,
	MX6UL_PAD_ENET1_RX_EN = 51,
	MX6UL_PAD_ENET1_TX_DATA0 = 52,
	MX6UL_PAD_ENET1_TX_DATA1 = 53,
	MX6UL_PAD_ENET1_TX_EN = 54,
	MX6UL_PAD_ENET1_TX_CLK = 55,
	MX6UL_PAD_ENET1_RX_ER = 56,
	MX6UL_PAD_ENET2_RX_DATA0 = 57,
	MX6UL_PAD_ENET2_RX_DATA1 = 58,
	MX6UL_PAD_ENET2_RX_EN = 59,
	MX6UL_PAD_ENET2_TX_DATA0 = 60,
	MX6UL_PAD_ENET2_TX_DATA1 = 61,
	MX6UL_PAD_ENET2_TX_EN = 62,
	MX6UL_PAD_ENET2_TX_CLK = 63,
	MX6UL_PAD_ENET2_RX_ER = 64,
	MX6UL_PAD_LCD_CLK = 65,
	MX6UL_PAD_LCD_ENABLE = 66,
	MX6UL_PAD_LCD_HSYNC = 67,
	MX6UL_PAD_LCD_VSYNC = 68,
	MX6UL_PAD_LCD_RESET = 69,
	MX6UL_PAD_LCD_DATA00 = 70,
	MX6UL_PAD_LCD_DATA01 = 71,
	MX6UL_PAD_LCD_DATA02 = 72,
	MX6UL_PAD_LCD_DATA03 = 73,
	MX6UL_PAD_LCD_DATA04 = 74,
	MX6UL_PAD_LCD_DATA05 = 75,
	MX6UL_PAD_LCD_DATA06 = 76,
	MX6UL_PAD_LCD_DATA07 = 77,
	MX6UL_PAD_LCD_DATA08 = 78,
	MX6UL_PAD_LCD_DATA09 = 79,
	MX6UL_PAD_LCD_DATA10 = 80,
	MX6UL_PAD_LCD_DATA11 = 81,
	MX6UL_PAD_LCD_DATA12 = 82,
	MX6UL_PAD_LCD_DATA13 = 83,
	MX6UL_PAD_LCD_DATA14 = 84,
	MX6UL_PAD_LCD_DATA15 = 85,
	MX6UL_PAD_LCD_DATA16 = 86,
	MX6UL_PAD_LCD_DATA17 = 87,
	MX6UL_PAD_LCD_DATA18 = 88,
	MX6UL_PAD_LCD_DATA19 = 89,
	MX6UL_PAD_LCD_DATA20 = 90,
	MX6UL_PAD_LCD_DATA21 = 91,
	MX6UL_PAD_LCD_DATA22 = 92,
	MX6UL_PAD_LCD_DATA23 = 93,
	MX6UL_PAD_NAND_RE_B = 94,
	MX6UL_PAD_NAND_WE_B = 95,
	MX6UL_PAD_NAND_DATA00 = 96,
	MX6UL_PAD_NAND_DATA01 = 97,
	MX6UL_PAD_NAND_DATA02 = 98,
	MX6UL_PAD_NAND_DATA03 = 99,
	MX6UL_PAD_NAND_DATA04 = 100,
	MX6UL_PAD_NAND_DATA05 = 101,
	MX6UL_PAD_NAND_DATA06 = 102,
	MX6UL_PAD_NAND_DATA07 = 103,
	MX6UL_PAD_NAND_ALE = 104,
	MX6UL_PAD_NAND_WP_B = 105,
	MX6UL_PAD_NAND_READY_B = 106,
	MX6UL_PAD_NAND_CE0_B = 107,
	MX6UL_PAD_NAND_CE1_B = 108,
	MX6UL_PAD_NAND_CLE = 109,
	MX6UL_PAD_NAND_DQS = 110,
	MX6UL_PAD_SD1_CMD = 111,
	MX6UL_PAD_SD1_CLK = 112,
	MX6UL_PAD_SD1_DATA0 = 113,
	MX6UL_PAD_SD1_DATA1 = 114,
	MX6UL_PAD_SD1_DATA2 = 115,
	MX6UL_PAD_SD1_DATA3 = 116,
	MX6UL_PAD_CSI_MCLK = 117,
	MX6UL_PAD_CSI_PIXCLK = 118,
	MX6UL_PAD_CSI_VSYNC = 119,
	MX6UL_PAD_CSI_HSYNC = 120,
	MX6UL_PAD_CSI_DATA00 = 121,
	MX6UL_PAD_CSI_DATA01 = 122,
	MX6UL_PAD_CSI_DATA02 = 123,
	MX6UL_PAD_CSI_DATA03 = 124,
	MX6UL_PAD_CSI_DATA04 = 125,
	MX6UL_PAD_CSI_DATA05 = 126,
	MX6UL_PAD_CSI_DATA06 = 127,
	MX6UL_PAD_CSI_DATA07 = 128,
};

enum imx6ull_lpsr_pads {
	MX6ULL_PAD_BOOT_MODE0 = 0,
	MX6ULL_PAD_BOOT_MODE1 = 1,
	MX6ULL_PAD_SNVS_TAMPER0 = 2,
	MX6ULL_PAD_SNVS_TAMPER1 = 3,
	MX6ULL_PAD_SNVS_TAMPER2 = 4,
	MX6ULL_PAD_SNVS_TAMPER3 = 5,
	MX6ULL_PAD_SNVS_TAMPER4 = 6,
	MX6ULL_PAD_SNVS_TAMPER5 = 7,
	MX6ULL_PAD_SNVS_TAMPER6 = 8,
	MX6ULL_PAD_SNVS_TAMPER7 = 9,
	MX6ULL_PAD_SNVS_TAMPER8 = 10,
	MX6ULL_PAD_SNVS_TAMPER9 = 11,
};

enum imx7_src_registers {
	SRC_A7RCR0 = 4,
	SRC_M4RCR = 12,
	SRC_ERCR = 20,
	SRC_HSICPHY_RCR = 28,
	SRC_USBOPHY1_RCR = 32,
	SRC_USBOPHY2_RCR = 36,
	SRC_MIPIPHY_RCR = 40,
	SRC_PCIEPHY_RCR = 44,
	SRC_DDRC_RCR = 4096,
};

enum imx7d_lpsr_pads {
	MX7D_PAD_GPIO1_IO00 = 0,
	MX7D_PAD_GPIO1_IO01 = 1,
	MX7D_PAD_GPIO1_IO02 = 2,
	MX7D_PAD_GPIO1_IO03 = 3,
	MX7D_PAD_GPIO1_IO04 = 4,
	MX7D_PAD_GPIO1_IO05 = 5,
	MX7D_PAD_GPIO1_IO06 = 6,
	MX7D_PAD_GPIO1_IO07 = 7,
};

enum imx7d_pads {
	MX7D_PAD_RESERVE0 = 0,
	MX7D_PAD_RESERVE1 = 1,
	MX7D_PAD_RESERVE2 = 2,
	MX7D_PAD_RESERVE3 = 3,
	MX7D_PAD_RESERVE4 = 4,
	MX7D_PAD_GPIO1_IO08 = 5,
	MX7D_PAD_GPIO1_IO09 = 6,
	MX7D_PAD_GPIO1_IO10 = 7,
	MX7D_PAD_GPIO1_IO11 = 8,
	MX7D_PAD_GPIO1_IO12 = 9,
	MX7D_PAD_GPIO1_IO13 = 10,
	MX7D_PAD_GPIO1_IO14 = 11,
	MX7D_PAD_GPIO1_IO15 = 12,
	MX7D_PAD_EPDC_DATA00 = 13,
	MX7D_PAD_EPDC_DATA01 = 14,
	MX7D_PAD_EPDC_DATA02 = 15,
	MX7D_PAD_EPDC_DATA03 = 16,
	MX7D_PAD_EPDC_DATA04 = 17,
	MX7D_PAD_EPDC_DATA05 = 18,
	MX7D_PAD_EPDC_DATA06 = 19,
	MX7D_PAD_EPDC_DATA07 = 20,
	MX7D_PAD_EPDC_DATA08 = 21,
	MX7D_PAD_EPDC_DATA09 = 22,
	MX7D_PAD_EPDC_DATA10 = 23,
	MX7D_PAD_EPDC_DATA11 = 24,
	MX7D_PAD_EPDC_DATA12 = 25,
	MX7D_PAD_EPDC_DATA13 = 26,
	MX7D_PAD_EPDC_DATA14 = 27,
	MX7D_PAD_EPDC_DATA15 = 28,
	MX7D_PAD_EPDC_SDCLK = 29,
	MX7D_PAD_EPDC_SDLE = 30,
	MX7D_PAD_EPDC_SDOE = 31,
	MX7D_PAD_EPDC_SDSHR = 32,
	MX7D_PAD_EPDC_SDCE0 = 33,
	MX7D_PAD_EPDC_SDCE1 = 34,
	MX7D_PAD_EPDC_SDCE2 = 35,
	MX7D_PAD_EPDC_SDCE3 = 36,
	MX7D_PAD_EPDC_GDCLK = 37,
	MX7D_PAD_EPDC_GDOE = 38,
	MX7D_PAD_EPDC_GDRL = 39,
	MX7D_PAD_EPDC_GDSP = 40,
	MX7D_PAD_EPDC_BDR0 = 41,
	MX7D_PAD_EPDC_BDR1 = 42,
	MX7D_PAD_EPDC_PWR_COM = 43,
	MX7D_PAD_EPDC_PWR_STAT = 44,
	MX7D_PAD_LCD_CLK = 45,
	MX7D_PAD_LCD_ENABLE = 46,
	MX7D_PAD_LCD_HSYNC = 47,
	MX7D_PAD_LCD_VSYNC = 48,
	MX7D_PAD_LCD_RESET = 49,
	MX7D_PAD_LCD_DATA00 = 50,
	MX7D_PAD_LCD_DATA01 = 51,
	MX7D_PAD_LCD_DATA02 = 52,
	MX7D_PAD_LCD_DATA03 = 53,
	MX7D_PAD_LCD_DATA04 = 54,
	MX7D_PAD_LCD_DATA05 = 55,
	MX7D_PAD_LCD_DATA06 = 56,
	MX7D_PAD_LCD_DATA07 = 57,
	MX7D_PAD_LCD_DATA08 = 58,
	MX7D_PAD_LCD_DATA09 = 59,
	MX7D_PAD_LCD_DATA10 = 60,
	MX7D_PAD_LCD_DATA11 = 61,
	MX7D_PAD_LCD_DATA12 = 62,
	MX7D_PAD_LCD_DATA13 = 63,
	MX7D_PAD_LCD_DATA14 = 64,
	MX7D_PAD_LCD_DATA15 = 65,
	MX7D_PAD_LCD_DATA16 = 66,
	MX7D_PAD_LCD_DATA17 = 67,
	MX7D_PAD_LCD_DATA18 = 68,
	MX7D_PAD_LCD_DATA19 = 69,
	MX7D_PAD_LCD_DATA20 = 70,
	MX7D_PAD_LCD_DATA21 = 71,
	MX7D_PAD_LCD_DATA22 = 72,
	MX7D_PAD_LCD_DATA23 = 73,
	MX7D_PAD_UART1_RX_DATA = 74,
	MX7D_PAD_UART1_TX_DATA = 75,
	MX7D_PAD_UART2_RX_DATA = 76,
	MX7D_PAD_UART2_TX_DATA = 77,
	MX7D_PAD_UART3_RX_DATA = 78,
	MX7D_PAD_UART3_TX_DATA = 79,
	MX7D_PAD_UART3_RTS_B = 80,
	MX7D_PAD_UART3_CTS_B = 81,
	MX7D_PAD_I2C1_SCL = 82,
	MX7D_PAD_I2C1_SDA = 83,
	MX7D_PAD_I2C2_SCL = 84,
	MX7D_PAD_I2C2_SDA = 85,
	MX7D_PAD_I2C3_SCL = 86,
	MX7D_PAD_I2C3_SDA = 87,
	MX7D_PAD_I2C4_SCL = 88,
	MX7D_PAD_I2C4_SDA = 89,
	MX7D_PAD_ECSPI1_SCLK = 90,
	MX7D_PAD_ECSPI1_MOSI = 91,
	MX7D_PAD_ECSPI1_MISO = 92,
	MX7D_PAD_ECSPI1_SS0 = 93,
	MX7D_PAD_ECSPI2_SCLK = 94,
	MX7D_PAD_ECSPI2_MOSI = 95,
	MX7D_PAD_ECSPI2_MISO = 96,
	MX7D_PAD_ECSPI2_SS0 = 97,
	MX7D_PAD_SD1_CD_B = 98,
	MX7D_PAD_SD1_WP = 99,
	MX7D_PAD_SD1_RESET_B = 100,
	MX7D_PAD_SD1_CLK = 101,
	MX7D_PAD_SD1_CMD = 102,
	MX7D_PAD_SD1_DATA0 = 103,
	MX7D_PAD_SD1_DATA1 = 104,
	MX7D_PAD_SD1_DATA2 = 105,
	MX7D_PAD_SD1_DATA3 = 106,
	MX7D_PAD_SD2_CD_B = 107,
	MX7D_PAD_SD2_WP = 108,
	MX7D_PAD_SD2_RESET_B = 109,
	MX7D_PAD_SD2_CLK = 110,
	MX7D_PAD_SD2_CMD = 111,
	MX7D_PAD_SD2_DATA0 = 112,
	MX7D_PAD_SD2_DATA1 = 113,
	MX7D_PAD_SD2_DATA2 = 114,
	MX7D_PAD_SD2_DATA3 = 115,
	MX7D_PAD_SD3_CLK = 116,
	MX7D_PAD_SD3_CMD = 117,
	MX7D_PAD_SD3_DATA0 = 118,
	MX7D_PAD_SD3_DATA1 = 119,
	MX7D_PAD_SD3_DATA2 = 120,
	MX7D_PAD_SD3_DATA3 = 121,
	MX7D_PAD_SD3_DATA4 = 122,
	MX7D_PAD_SD3_DATA5 = 123,
	MX7D_PAD_SD3_DATA6 = 124,
	MX7D_PAD_SD3_DATA7 = 125,
	MX7D_PAD_SD3_STROBE = 126,
	MX7D_PAD_SD3_RESET_B = 127,
	MX7D_PAD_SAI1_RX_DATA = 128,
	MX7D_PAD_SAI1_TX_BCLK = 129,
	MX7D_PAD_SAI1_TX_SYNC = 130,
	MX7D_PAD_SAI1_TX_DATA = 131,
	MX7D_PAD_SAI1_RX_SYNC = 132,
	MX7D_PAD_SAI1_RX_BCLK = 133,
	MX7D_PAD_SAI1_MCLK = 134,
	MX7D_PAD_SAI2_TX_SYNC = 135,
	MX7D_PAD_SAI2_TX_BCLK = 136,
	MX7D_PAD_SAI2_RX_DATA = 137,
	MX7D_PAD_SAI2_TX_DATA = 138,
	MX7D_PAD_ENET1_RGMII_RD0 = 139,
	MX7D_PAD_ENET1_RGMII_RD1 = 140,
	MX7D_PAD_ENET1_RGMII_RD2 = 141,
	MX7D_PAD_ENET1_RGMII_RD3 = 142,
	MX7D_PAD_ENET1_RGMII_RX_CTL = 143,
	MX7D_PAD_ENET1_RGMII_RXC = 144,
	MX7D_PAD_ENET1_RGMII_TD0 = 145,
	MX7D_PAD_ENET1_RGMII_TD1 = 146,
	MX7D_PAD_ENET1_RGMII_TD2 = 147,
	MX7D_PAD_ENET1_RGMII_TD3 = 148,
	MX7D_PAD_ENET1_RGMII_TX_CTL = 149,
	MX7D_PAD_ENET1_RGMII_TXC = 150,
	MX7D_PAD_ENET1_TX_CLK = 151,
	MX7D_PAD_ENET1_RX_CLK = 152,
	MX7D_PAD_ENET1_CRS = 153,
	MX7D_PAD_ENET1_COL = 154,
};

enum imx7ulp_pads {
	IMX7ULP_PAD_PTC0 = 0,
	IMX7ULP_PAD_PTC1 = 1,
	IMX7ULP_PAD_PTC2 = 2,
	IMX7ULP_PAD_PTC3 = 3,
	IMX7ULP_PAD_PTC4 = 4,
	IMX7ULP_PAD_PTC5 = 5,
	IMX7ULP_PAD_PTC6 = 6,
	IMX7ULP_PAD_PTC7 = 7,
	IMX7ULP_PAD_PTC8 = 8,
	IMX7ULP_PAD_PTC9 = 9,
	IMX7ULP_PAD_PTC10 = 10,
	IMX7ULP_PAD_PTC11 = 11,
	IMX7ULP_PAD_PTC12 = 12,
	IMX7ULP_PAD_PTC13 = 13,
	IMX7ULP_PAD_PTC14 = 14,
	IMX7ULP_PAD_PTC15 = 15,
	IMX7ULP_PAD_PTC16 = 16,
	IMX7ULP_PAD_PTC17 = 17,
	IMX7ULP_PAD_PTC18 = 18,
	IMX7ULP_PAD_PTC19 = 19,
	IMX7ULP_PAD_RESERVE0 = 20,
	IMX7ULP_PAD_RESERVE1 = 21,
	IMX7ULP_PAD_RESERVE2 = 22,
	IMX7ULP_PAD_RESERVE3 = 23,
	IMX7ULP_PAD_RESERVE4 = 24,
	IMX7ULP_PAD_RESERVE5 = 25,
	IMX7ULP_PAD_RESERVE6 = 26,
	IMX7ULP_PAD_RESERVE7 = 27,
	IMX7ULP_PAD_RESERVE8 = 28,
	IMX7ULP_PAD_RESERVE9 = 29,
	IMX7ULP_PAD_RESERVE10 = 30,
	IMX7ULP_PAD_RESERVE11 = 31,
	IMX7ULP_PAD_PTD0 = 32,
	IMX7ULP_PAD_PTD1 = 33,
	IMX7ULP_PAD_PTD2 = 34,
	IMX7ULP_PAD_PTD3 = 35,
	IMX7ULP_PAD_PTD4 = 36,
	IMX7ULP_PAD_PTD5 = 37,
	IMX7ULP_PAD_PTD6 = 38,
	IMX7ULP_PAD_PTD7 = 39,
	IMX7ULP_PAD_PTD8 = 40,
	IMX7ULP_PAD_PTD9 = 41,
	IMX7ULP_PAD_PTD10 = 42,
	IMX7ULP_PAD_PTD11 = 43,
	IMX7ULP_PAD_RESERVE12 = 44,
	IMX7ULP_PAD_RESERVE13 = 45,
	IMX7ULP_PAD_RESERVE14 = 46,
	IMX7ULP_PAD_RESERVE15 = 47,
	IMX7ULP_PAD_RESERVE16 = 48,
	IMX7ULP_PAD_RESERVE17 = 49,
	IMX7ULP_PAD_RESERVE18 = 50,
	IMX7ULP_PAD_RESERVE19 = 51,
	IMX7ULP_PAD_RESERVE20 = 52,
	IMX7ULP_PAD_RESERVE21 = 53,
	IMX7ULP_PAD_RESERVE22 = 54,
	IMX7ULP_PAD_RESERVE23 = 55,
	IMX7ULP_PAD_RESERVE24 = 56,
	IMX7ULP_PAD_RESERVE25 = 57,
	IMX7ULP_PAD_RESERVE26 = 58,
	IMX7ULP_PAD_RESERVE27 = 59,
	IMX7ULP_PAD_RESERVE28 = 60,
	IMX7ULP_PAD_RESERVE29 = 61,
	IMX7ULP_PAD_RESERVE30 = 62,
	IMX7ULP_PAD_RESERVE31 = 63,
	IMX7ULP_PAD_PTE0 = 64,
	IMX7ULP_PAD_PTE1 = 65,
	IMX7ULP_PAD_PTE2 = 66,
	IMX7ULP_PAD_PTE3 = 67,
	IMX7ULP_PAD_PTE4 = 68,
	IMX7ULP_PAD_PTE5 = 69,
	IMX7ULP_PAD_PTE6 = 70,
	IMX7ULP_PAD_PTE7 = 71,
	IMX7ULP_PAD_PTE8 = 72,
	IMX7ULP_PAD_PTE9 = 73,
	IMX7ULP_PAD_PTE10 = 74,
	IMX7ULP_PAD_PTE11 = 75,
	IMX7ULP_PAD_PTE12 = 76,
	IMX7ULP_PAD_PTE13 = 77,
	IMX7ULP_PAD_PTE14 = 78,
	IMX7ULP_PAD_PTE15 = 79,
	IMX7ULP_PAD_RESERVE32 = 80,
	IMX7ULP_PAD_RESERVE33 = 81,
	IMX7ULP_PAD_RESERVE34 = 82,
	IMX7ULP_PAD_RESERVE35 = 83,
	IMX7ULP_PAD_RESERVE36 = 84,
	IMX7ULP_PAD_RESERVE37 = 85,
	IMX7ULP_PAD_RESERVE38 = 86,
	IMX7ULP_PAD_RESERVE39 = 87,
	IMX7ULP_PAD_RESERVE40 = 88,
	IMX7ULP_PAD_RESERVE41 = 89,
	IMX7ULP_PAD_RESERVE42 = 90,
	IMX7ULP_PAD_RESERVE43 = 91,
	IMX7ULP_PAD_RESERVE44 = 92,
	IMX7ULP_PAD_RESERVE45 = 93,
	IMX7ULP_PAD_RESERVE46 = 94,
	IMX7ULP_PAD_RESERVE47 = 95,
	IMX7ULP_PAD_PTF0 = 96,
	IMX7ULP_PAD_PTF1 = 97,
	IMX7ULP_PAD_PTF2 = 98,
	IMX7ULP_PAD_PTF3 = 99,
	IMX7ULP_PAD_PTF4 = 100,
	IMX7ULP_PAD_PTF5 = 101,
	IMX7ULP_PAD_PTF6 = 102,
	IMX7ULP_PAD_PTF7 = 103,
	IMX7ULP_PAD_PTF8 = 104,
	IMX7ULP_PAD_PTF9 = 105,
	IMX7ULP_PAD_PTF10 = 106,
	IMX7ULP_PAD_PTF11 = 107,
	IMX7ULP_PAD_PTF12 = 108,
	IMX7ULP_PAD_PTF13 = 109,
	IMX7ULP_PAD_PTF14 = 110,
	IMX7ULP_PAD_PTF15 = 111,
	IMX7ULP_PAD_PTF16 = 112,
	IMX7ULP_PAD_PTF17 = 113,
	IMX7ULP_PAD_PTF18 = 114,
	IMX7ULP_PAD_PTF19 = 115,
};

enum imx8mp_src_registers {
	SRC_SUPERMIX_RCR = 24,
	SRC_AUDIOMIX_RCR = 28,
	SRC_MLMIX_RCR = 40,
	SRC_GPU2D_RCR = 56,
	SRC_GPU3D_RCR = 60,
	SRC_VPU_G1_RCR = 72,
	SRC_VPU_G2_RCR = 76,
	SRC_VPUVC8KE_RCR = 80,
	SRC_NOC_RCR = 84,
};

enum imx8mq_src_registers {
	SRC_A53RCR0 = 4,
	SRC_HDMI_RCR = 48,
	SRC_DISP_RCR = 52,
	SRC_GPU_RCR = 64,
	SRC_VPU_RCR = 68,
	SRC_PCIE2_RCR = 72,
	SRC_MIPIPHY1_RCR = 76,
	SRC_MIPIPHY2_RCR = 80,
	SRC_DDRC2_RCR = 4100,
};

enum imx_dma_prio {
	DMA_PRIO_HIGH = 0,
	DMA_PRIO_MEDIUM = 1,
	DMA_PRIO_LOW = 2,
};

enum imx_dma_type {
	IMX1_DMA = 0,
	IMX27_DMA = 1,
};

enum imx_gpt_type {
	GPT_TYPE_IMX1 = 0,
	GPT_TYPE_IMX21 = 1,
	GPT_TYPE_IMX31 = 2,
	GPT_TYPE_IMX6DL = 3,
};

enum imx_i2c_state {
	IMX_I2C_STATE_DONE = 0,
	IMX_I2C_STATE_FAILED = 1,
	IMX_I2C_STATE_WRITE = 2,
	IMX_I2C_STATE_DMA = 3,
	IMX_I2C_STATE_READ = 4,
	IMX_I2C_STATE_READ_CONTINUE = 5,
	IMX_I2C_STATE_READ_BLOCK_DATA = 6,
	IMX_I2C_STATE_READ_BLOCK_DATA_LEN = 7,
};

enum imx_i2c_type {
	IMX1_I2C = 0,
	IMX21_I2C = 1,
	S32G_I2C = 2,
	VF610_I2C = 3,
};

enum imx_pfdv2_type {
	IMX_PFDV2_IMX7ULP = 0,
	IMX_PFDV2_IMX8ULP = 1,
};

enum imx_pll14xx_type {
	PLL_1416X = 0,
	PLL_1443X = 1,
};

enum imx_pllv1_type {
	IMX_PLLV1_IMX1 = 0,
	IMX_PLLV1_IMX21 = 1,
	IMX_PLLV1_IMX25 = 2,
	IMX_PLLV1_IMX27 = 3,
	IMX_PLLV1_IMX31 = 4,
	IMX_PLLV1_IMX35 = 5,
};

enum imx_pllv3_type {
	IMX_PLLV3_GENERIC = 0,
	IMX_PLLV3_SYS = 1,
	IMX_PLLV3_USB = 2,
	IMX_PLLV3_USB_VF610 = 3,
	IMX_PLLV3_AV = 4,
	IMX_PLLV3_ENET = 5,
	IMX_PLLV3_ENET_IMX7 = 6,
	IMX_PLLV3_SYS_VF610 = 7,
	IMX_PLLV3_DDR_IMX7 = 8,
	IMX_PLLV3_AV_IMX7 = 9,
};

enum imx_pllv4_type {
	IMX_PLLV4_IMX7ULP = 0,
	IMX_PLLV4_IMX8ULP = 1,
	IMX_PLLV4_IMX8ULP_1GHZ = 2,
};

enum imx_rtc_type {
	IMX1_RTC = 0,
	IMX21_RTC = 1,
};

enum imx_thermal_trip {
	IMX_TRIP_PASSIVE = 0,
	IMX_TRIP_CRITICAL = 1,
};

enum imx_tx_state {
	OFF = 0,
	WAIT_AFTER_RTS = 1,
	SEND = 2,
	WAIT_AFTER_SEND = 3,
};

enum imx_uart_type {
	IMX1_UART = 0,
	IMX21_UART = 1,
};

enum imxdma_prep_type {
	IMXDMA_DESC_MEMCPY = 0,
	IMXDMA_DESC_INTERLEAVED = 1,
	IMXDMA_DESC_SLAVE_SG = 2,
	IMXDMA_DESC_CYCLIC = 3,
};

enum in6_addr_gen_mode {
	IN6_ADDR_GEN_MODE_EUI64 = 0,
	IN6_ADDR_GEN_MODE_NONE = 1,
	IN6_ADDR_GEN_MODE_STABLE_PRIVACY = 2,
	IN6_ADDR_GEN_MODE_RANDOM = 3,
};

enum inet_csk_ack_state_t {
	ICSK_ACK_SCHED = 1,
	ICSK_ACK_TIMER = 2,
	ICSK_ACK_PUSHED = 4,
	ICSK_ACK_PUSHED2 = 8,
	ICSK_ACK_NOW = 16,
	ICSK_ACK_NOMEM = 32,
};

enum inno_hdmi_dev_type {
	RK3036_HDMI = 0,
	RK3128_HDMI = 1,
};

enum inode_i_mutex_lock_class {
	I_MUTEX_NORMAL = 0,
	I_MUTEX_PARENT = 1,
	I_MUTEX_CHILD = 2,
	I_MUTEX_XATTR = 3,
	I_MUTEX_NONDIR2 = 4,
	I_MUTEX_PARENT2 = 5,
};

enum inode_state {
	inode_state_no_change = 0,
	inode_state_will_create = 1,
	inode_state_did_create = 2,
	inode_state_will_delete = 3,
	inode_state_did_delete = 4,
};

enum inode_type {
	DIR_INODE = 0,
	FILE_INODE = 1,
	DIRTY_META = 2,
	DONATE_INODE = 3,
	NR_INODE_TYPE = 4,
};

enum input_clock_type {
	INPUT_CLK_REAL = 0,
	INPUT_CLK_MONO = 1,
	INPUT_CLK_BOOT = 2,
	INPUT_CLK_MAX = 3,
};

enum io_pgtable_caps {
	IO_PGTABLE_CAP_CUSTOM_ALLOCATOR = 1,
};

enum io_pgtable_fmt {
	ARM_32_LPAE_S1 = 0,
	ARM_32_LPAE_S2 = 1,
	ARM_64_LPAE_S1 = 2,
	ARM_64_LPAE_S2 = 3,
	ARM_V7S = 4,
	ARM_MALI_LPAE = 5,
	AMD_IOMMU_V1 = 6,
	AMD_IOMMU_V2 = 7,
	APPLE_DART = 8,
	APPLE_DART2 = 9,
	IO_PGTABLE_NUM_FMTS = 10,
};

enum io_uring_cmd_flags {
	IO_URING_F_COMPLETE_DEFER = 1,
	IO_URING_F_UNLOCKED = 2,
	IO_URING_F_MULTISHOT = 4,
	IO_URING_F_IOWQ = 8,
	IO_URING_F_NONBLOCK = -2147483648,
	IO_URING_F_SQE128 = 256,
	IO_URING_F_CQE32 = 512,
	IO_URING_F_IOPOLL = 1024,
	IO_URING_F_CANCEL = 2048,
	IO_URING_F_COMPAT = 4096,
	IO_URING_F_TASK_DEAD = 8192,
};

enum io_uring_msg_ring_flags {
	IORING_MSG_DATA = 0,
	IORING_MSG_SEND_FD = 1,
};

enum io_uring_napi_op {
	IO_URING_NAPI_REGISTER_OP = 0,
	IO_URING_NAPI_STATIC_ADD_ID = 1,
	IO_URING_NAPI_STATIC_DEL_ID = 2,
};

enum io_uring_napi_tracking_strategy {
	IO_URING_NAPI_TRACKING_DYNAMIC = 0,
	IO_URING_NAPI_TRACKING_STATIC = 1,
	IO_URING_NAPI_TRACKING_INACTIVE = 255,
};

enum io_uring_op {
	IORING_OP_NOP = 0,
	IORING_OP_READV = 1,
	IORING_OP_WRITEV = 2,
	IORING_OP_FSYNC = 3,
	IORING_OP_READ_FIXED = 4,
	IORING_OP_WRITE_FIXED = 5,
	IORING_OP_POLL_ADD = 6,
	IORING_OP_POLL_REMOVE = 7,
	IORING_OP_SYNC_FILE_RANGE = 8,
	IORING_OP_SENDMSG = 9,
	IORING_OP_RECVMSG = 10,
	IORING_OP_TIMEOUT = 11,
	IORING_OP_TIMEOUT_REMOVE = 12,
	IORING_OP_ACCEPT = 13,
	IORING_OP_ASYNC_CANCEL = 14,
	IORING_OP_LINK_TIMEOUT = 15,
	IORING_OP_CONNECT = 16,
	IORING_OP_FALLOCATE = 17,
	IORING_OP_OPENAT = 18,
	IORING_OP_CLOSE = 19,
	IORING_OP_FILES_UPDATE = 20,
	IORING_OP_STATX = 21,
	IORING_OP_READ = 22,
	IORING_OP_WRITE = 23,
	IORING_OP_FADVISE = 24,
	IORING_OP_MADVISE = 25,
	IORING_OP_SEND = 26,
	IORING_OP_RECV = 27,
	IORING_OP_OPENAT2 = 28,
	IORING_OP_EPOLL_CTL = 29,
	IORING_OP_SPLICE = 30,
	IORING_OP_PROVIDE_BUFFERS = 31,
	IORING_OP_REMOVE_BUFFERS = 32,
	IORING_OP_TEE = 33,
	IORING_OP_SHUTDOWN = 34,
	IORING_OP_RENAMEAT = 35,
	IORING_OP_UNLINKAT = 36,
	IORING_OP_MKDIRAT = 37,
	IORING_OP_SYMLINKAT = 38,
	IORING_OP_LINKAT = 39,
	IORING_OP_MSG_RING = 40,
	IORING_OP_FSETXATTR = 41,
	IORING_OP_SETXATTR = 42,
	IORING_OP_FGETXATTR = 43,
	IORING_OP_GETXATTR = 44,
	IORING_OP_SOCKET = 45,
	IORING_OP_URING_CMD = 46,
	IORING_OP_SEND_ZC = 47,
	IORING_OP_SENDMSG_ZC = 48,
	IORING_OP_READ_MULTISHOT = 49,
	IORING_OP_WAITID = 50,
	IORING_OP_FUTEX_WAIT = 51,
	IORING_OP_FUTEX_WAKE = 52,
	IORING_OP_FUTEX_WAITV = 53,
	IORING_OP_FIXED_FD_INSTALL = 54,
	IORING_OP_FTRUNCATE = 55,
	IORING_OP_BIND = 56,
	IORING_OP_LISTEN = 57,
	IORING_OP_RECV_ZC = 58,
	IORING_OP_EPOLL_WAIT = 59,
	IORING_OP_READV_FIXED = 60,
	IORING_OP_WRITEV_FIXED = 61,
	IORING_OP_PIPE = 62,
	IORING_OP_LAST = 63,
};

enum io_uring_register_op {
	IORING_REGISTER_BUFFERS = 0,
	IORING_UNREGISTER_BUFFERS = 1,
	IORING_REGISTER_FILES = 2,
	IORING_UNREGISTER_FILES = 3,
	IORING_REGISTER_EVENTFD = 4,
	IORING_UNREGISTER_EVENTFD = 5,
	IORING_REGISTER_FILES_UPDATE = 6,
	IORING_REGISTER_EVENTFD_ASYNC = 7,
	IORING_REGISTER_PROBE = 8,
	IORING_REGISTER_PERSONALITY = 9,
	IORING_UNREGISTER_PERSONALITY = 10,
	IORING_REGISTER_RESTRICTIONS = 11,
	IORING_REGISTER_ENABLE_RINGS = 12,
	IORING_REGISTER_FILES2 = 13,
	IORING_REGISTER_FILES_UPDATE2 = 14,
	IORING_REGISTER_BUFFERS2 = 15,
	IORING_REGISTER_BUFFERS_UPDATE = 16,
	IORING_REGISTER_IOWQ_AFF = 17,
	IORING_UNREGISTER_IOWQ_AFF = 18,
	IORING_REGISTER_IOWQ_MAX_WORKERS = 19,
	IORING_REGISTER_RING_FDS = 20,
	IORING_UNREGISTER_RING_FDS = 21,
	IORING_REGISTER_PBUF_RING = 22,
	IORING_UNREGISTER_PBUF_RING = 23,
	IORING_REGISTER_SYNC_CANCEL = 24,
	IORING_REGISTER_FILE_ALLOC_RANGE = 25,
	IORING_REGISTER_PBUF_STATUS = 26,
	IORING_REGISTER_NAPI = 27,
	IORING_UNREGISTER_NAPI = 28,
	IORING_REGISTER_CLOCK = 29,
	IORING_REGISTER_CLONE_BUFFERS = 30,
	IORING_REGISTER_SEND_MSG_RING = 31,
	IORING_REGISTER_ZCRX_IFQ = 32,
	IORING_REGISTER_RESIZE_RINGS = 33,
	IORING_REGISTER_MEM_REGION = 34,
	IORING_REGISTER_LAST = 35,
	IORING_REGISTER_USE_REGISTERED_RING = 2147483648,
};

enum io_uring_register_pbuf_ring_flags {
	IOU_PBUF_RING_MMAP = 1,
	IOU_PBUF_RING_INC = 2,
};

enum io_uring_register_restriction_op {
	IORING_RESTRICTION_REGISTER_OP = 0,
	IORING_RESTRICTION_SQE_OP = 1,
	IORING_RESTRICTION_SQE_FLAGS_ALLOWED = 2,
	IORING_RESTRICTION_SQE_FLAGS_REQUIRED = 3,
	IORING_RESTRICTION_LAST = 4,
};

enum io_uring_socket_op {
	SOCKET_URING_OP_SIOCINQ = 0,
	SOCKET_URING_OP_SIOCOUTQ = 1,
	SOCKET_URING_OP_GETSOCKOPT = 2,
	SOCKET_URING_OP_SETSOCKOPT = 3,
};

enum io_uring_sqe_flags_bit {
	IOSQE_FIXED_FILE_BIT = 0,
	IOSQE_IO_DRAIN_BIT = 1,
	IOSQE_IO_LINK_BIT = 2,
	IOSQE_IO_HARDLINK_BIT = 3,
	IOSQE_ASYNC_BIT = 4,
	IOSQE_BUFFER_SELECT_BIT = 5,
	IOSQE_CQE_SKIP_SUCCESS_BIT = 6,
};

enum io_uring_zcrx_area_flags {
	IORING_ZCRX_AREA_DMABUF = 1,
};

enum io_wq_cancel {
	IO_WQ_CANCEL_OK = 0,
	IO_WQ_CANCEL_RUNNING = 1,
	IO_WQ_CANCEL_NOTFOUND = 2,
};

enum io_wq_type {
	IO_WQ_BOUND = 0,
	IO_WQ_UNBOUND = 1,
};

enum ioam6_event_attr {
	IOAM6_EVENT_ATTR_UNSPEC = 0,
	IOAM6_EVENT_ATTR_TRACE_NAMESPACE = 1,
	IOAM6_EVENT_ATTR_TRACE_NODELEN = 2,
	IOAM6_EVENT_ATTR_TRACE_TYPE = 3,
	IOAM6_EVENT_ATTR_TRACE_DATA = 4,
	__IOAM6_EVENT_ATTR_MAX = 5,
};

enum ioam6_event_type {
	IOAM6_EVENT_UNSPEC = 0,
	IOAM6_EVENT_TRACE = 1,
};

enum ioc_running {
	IOC_IDLE = 0,
	IOC_RUNNING = 1,
	IOC_STOP = 2,
};

enum iommu_cap {
	IOMMU_CAP_CACHE_COHERENCY = 0,
	IOMMU_CAP_NOEXEC = 1,
	IOMMU_CAP_PRE_BOOT_PROTECTION = 2,
	IOMMU_CAP_ENFORCE_CACHE_COHERENCY = 3,
	IOMMU_CAP_DEFERRED_FLUSH = 4,
	IOMMU_CAP_DIRTY_TRACKING = 5,
};

enum iommu_domain_cookie_type {
	IOMMU_COOKIE_NONE = 0,
	IOMMU_COOKIE_DMA_IOVA = 1,
	IOMMU_COOKIE_DMA_MSI = 2,
	IOMMU_COOKIE_FAULT_HANDLER = 3,
	IOMMU_COOKIE_SVA = 4,
	IOMMU_COOKIE_IOMMUFD = 5,
};

enum iommu_resv_type {
	IOMMU_RESV_DIRECT = 0,
	IOMMU_RESV_DIRECT_RELAXABLE = 1,
	IOMMU_RESV_RESERVED = 2,
	IOMMU_RESV_MSI = 3,
	IOMMU_RESV_SW_MSI = 4,
};

enum iommufd_hwpt_alloc_flags {
	IOMMU_HWPT_ALLOC_NEST_PARENT = 1,
	IOMMU_HWPT_ALLOC_DIRTY_TRACKING = 2,
	IOMMU_HWPT_FAULT_ID_VALID = 4,
	IOMMU_HWPT_ALLOC_PASID = 8,
};

enum iommufd_object_type {
	IOMMUFD_OBJ_NONE = 0,
	IOMMUFD_OBJ_ANY = 0,
	IOMMUFD_OBJ_DEVICE = 1,
	IOMMUFD_OBJ_HWPT_PAGING = 2,
	IOMMUFD_OBJ_HWPT_NESTED = 3,
	IOMMUFD_OBJ_IOAS = 4,
	IOMMUFD_OBJ_ACCESS = 5,
	IOMMUFD_OBJ_FAULT = 6,
	IOMMUFD_OBJ_VIOMMU = 7,
	IOMMUFD_OBJ_VDEVICE = 8,
	IOMMUFD_OBJ_VEVENTQ = 9,
	IOMMUFD_OBJ_MAX = 10,
};

enum iostat_lat_type {
	READ_IO = 0,
	WRITE_SYNC_IO = 1,
	WRITE_ASYNC_IO = 2,
	MAX_IO_TYPE = 3,
};

enum iostat_type {
	APP_DIRECT_IO = 0,
	APP_BUFFERED_IO = 1,
	APP_WRITE_IO = 2,
	APP_MAPPED_IO = 3,
	APP_BUFFERED_CDATA_IO = 4,
	APP_MAPPED_CDATA_IO = 5,
	FS_DATA_IO = 6,
	FS_CDATA_IO = 7,
	FS_NODE_IO = 8,
	FS_META_IO = 9,
	FS_GC_DATA_IO = 10,
	FS_GC_NODE_IO = 11,
	FS_CP_DATA_IO = 12,
	FS_CP_NODE_IO = 13,
	FS_CP_META_IO = 14,
	APP_DIRECT_READ_IO = 15,
	APP_BUFFERED_READ_IO = 16,
	APP_READ_IO = 17,
	APP_MAPPED_READ_IO = 18,
	APP_BUFFERED_CDATA_READ_IO = 19,
	APP_MAPPED_CDATA_READ_IO = 20,
	FS_DATA_READ_IO = 21,
	FS_GDATA_READ_IO = 22,
	FS_CDATA_READ_IO = 23,
	FS_NODE_READ_IO = 24,
	FS_META_READ_IO = 25,
	FS_DISCARD_IO = 26,
	FS_FLUSH_IO = 27,
	FS_ZONE_RESET_IO = 28,
	NR_IO_TYPE = 29,
};

enum ip6_defrag_users {
	IP6_DEFRAG_LOCAL_DELIVER = 0,
	IP6_DEFRAG_CONNTRACK_IN = 1,
	__IP6_DEFRAG_CONNTRACK_IN = 65536,
	IP6_DEFRAG_CONNTRACK_OUT = 65537,
	__IP6_DEFRAG_CONNTRACK_OUT = 131072,
	IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 131073,
	__IP6_DEFRAG_CONNTRACK_BRIDGE_IN = 196608,
};

enum ip_conntrack_dir {
	IP_CT_DIR_ORIGINAL = 0,
	IP_CT_DIR_REPLY = 1,
	IP_CT_DIR_MAX = 2,
};

enum ip_conntrack_info {
	IP_CT_ESTABLISHED = 0,
	IP_CT_RELATED = 1,
	IP_CT_NEW = 2,
	IP_CT_IS_REPLY = 3,
	IP_CT_ESTABLISHED_REPLY = 3,
	IP_CT_RELATED_REPLY = 4,
	IP_CT_NUMBER = 5,
	IP_CT_UNTRACKED = 7,
};

enum ip_conntrack_status {
	IPS_EXPECTED_BIT = 0,
	IPS_EXPECTED = 1,
	IPS_SEEN_REPLY_BIT = 1,
	IPS_SEEN_REPLY = 2,
	IPS_ASSURED_BIT = 2,
	IPS_ASSURED = 4,
	IPS_CONFIRMED_BIT = 3,
	IPS_CONFIRMED = 8,
	IPS_SRC_NAT_BIT = 4,
	IPS_SRC_NAT = 16,
	IPS_DST_NAT_BIT = 5,
	IPS_DST_NAT = 32,
	IPS_NAT_MASK = 48,
	IPS_SEQ_ADJUST_BIT = 6,
	IPS_SEQ_ADJUST = 64,
	IPS_SRC_NAT_DONE_BIT = 7,
	IPS_SRC_NAT_DONE = 128,
	IPS_DST_NAT_DONE_BIT = 8,
	IPS_DST_NAT_DONE = 256,
	IPS_NAT_DONE_MASK = 384,
	IPS_DYING_BIT = 9,
	IPS_DYING = 512,
	IPS_FIXED_TIMEOUT_BIT = 10,
	IPS_FIXED_TIMEOUT = 1024,
	IPS_TEMPLATE_BIT = 11,
	IPS_TEMPLATE = 2048,
	IPS_UNTRACKED_BIT = 12,
	IPS_UNTRACKED = 4096,
	IPS_NAT_CLASH_BIT = 12,
	IPS_NAT_CLASH = 4096,
	IPS_HELPER_BIT = 13,
	IPS_HELPER = 8192,
	IPS_OFFLOAD_BIT = 14,
	IPS_OFFLOAD = 16384,
	IPS_HW_OFFLOAD_BIT = 15,
	IPS_HW_OFFLOAD = 32768,
	IPS_UNCHANGEABLE_MASK = 56313,
	__IPS_MAX_BIT = 16,
};

enum ip_defrag_users {
	IP_DEFRAG_LOCAL_DELIVER = 0,
	IP_DEFRAG_CALL_RA_CHAIN = 1,
	IP_DEFRAG_CONNTRACK_IN = 2,
	__IP_DEFRAG_CONNTRACK_IN_END = 65537,
	IP_DEFRAG_CONNTRACK_OUT = 65538,
	__IP_DEFRAG_CONNTRACK_OUT_END = 131073,
	IP_DEFRAG_CONNTRACK_BRIDGE_IN = 131074,
	__IP_DEFRAG_CONNTRACK_BRIDGE_IN = 196609,
	IP_DEFRAG_VS_IN = 196610,
	IP_DEFRAG_VS_OUT = 196611,
	IP_DEFRAG_VS_FWD = 196612,
	IP_DEFRAG_AF_PACKET = 196613,
	IP_DEFRAG_MACVLAN = 196614,
};

enum ipack_space {
	IPACK_IO_SPACE = 0,
	IPACK_ID_SPACE = 1,
	IPACK_INT_SPACE = 2,
	IPACK_MEM8_SPACE = 3,
	IPACK_MEM16_SPACE = 4,
	IPACK_SPACE_COUNT = 5,
};

enum ipi_msg_type {
	IPI_WAKEUP = 0,
	IPI_TIMER = 1,
	IPI_RESCHEDULE = 2,
	IPI_CALL_FUNC = 3,
	IPI_CPU_STOP = 4,
	IPI_IRQ_WORK = 5,
	IPI_COMPLETION = 6,
	NR_IPI = 7,
	IPI_CPU_BACKTRACE = 7,
	MAX_IPI = 8,
};

enum irq_domain_bus_token {
	DOMAIN_BUS_ANY = 0,
	DOMAIN_BUS_WIRED = 1,
	DOMAIN_BUS_GENERIC_MSI = 2,
	DOMAIN_BUS_PCI_MSI = 3,
	DOMAIN_BUS_PLATFORM_MSI = 4,
	DOMAIN_BUS_NEXUS = 5,
	DOMAIN_BUS_IPI = 6,
	DOMAIN_BUS_FSL_MC_MSI = 7,
	DOMAIN_BUS_TI_SCI_INTA_MSI = 8,
	DOMAIN_BUS_WAKEUP = 9,
	DOMAIN_BUS_VMD_MSI = 10,
	DOMAIN_BUS_PCI_DEVICE_MSI = 11,
	DOMAIN_BUS_PCI_DEVICE_MSIX = 12,
	DOMAIN_BUS_DMAR = 13,
	DOMAIN_BUS_AMDVI = 14,
	DOMAIN_BUS_DEVICE_MSI = 15,
	DOMAIN_BUS_WIRED_TO_MSI = 16,
};

enum irq_gc_flags {
	IRQ_GC_INIT_MASK_CACHE = 1,
	IRQ_GC_INIT_NESTED_LOCK = 2,
	IRQ_GC_MASK_CACHE_PER_TYPE = 4,
	IRQ_GC_NO_MASK = 8,
	IRQ_GC_BE_IO = 16,
};

enum irqchip_irq_state {
	IRQCHIP_STATE_PENDING = 0,
	IRQCHIP_STATE_ACTIVE = 1,
	IRQCHIP_STATE_MASKED = 2,
	IRQCHIP_STATE_LINE_LEVEL = 3,
};

enum irqreturn {
	IRQ_NONE = 0,
	IRQ_HANDLED = 1,
	IRQ_WAKE_THREAD = 2,
};

typedef enum irqreturn irqreturn_t;

enum iscsi_boot_acpitbl_properties_enum {
	ISCSI_BOOT_ACPITBL_SIGNATURE = 0,
	ISCSI_BOOT_ACPITBL_OEM_ID = 1,
	ISCSI_BOOT_ACPITBL_OEM_TABLE_ID = 2,
};

enum iscsi_boot_eth_properties_enum {
	ISCSI_BOOT_ETH_INDEX = 0,
	ISCSI_BOOT_ETH_FLAGS = 1,
	ISCSI_BOOT_ETH_IP_ADDR = 2,
	ISCSI_BOOT_ETH_PREFIX_LEN = 3,
	ISCSI_BOOT_ETH_SUBNET_MASK = 4,
	ISCSI_BOOT_ETH_ORIGIN = 5,
	ISCSI_BOOT_ETH_GATEWAY = 6,
	ISCSI_BOOT_ETH_PRIMARY_DNS = 7,
	ISCSI_BOOT_ETH_SECONDARY_DNS = 8,
	ISCSI_BOOT_ETH_DHCP = 9,
	ISCSI_BOOT_ETH_VLAN = 10,
	ISCSI_BOOT_ETH_MAC = 11,
	ISCSI_BOOT_ETH_HOSTNAME = 12,
	ISCSI_BOOT_ETH_END_MARKER = 13,
};

enum iscsi_boot_initiator_properties_enum {
	ISCSI_BOOT_INI_INDEX = 0,
	ISCSI_BOOT_INI_FLAGS = 1,
	ISCSI_BOOT_INI_ISNS_SERVER = 2,
	ISCSI_BOOT_INI_SLP_SERVER = 3,
	ISCSI_BOOT_INI_PRI_RADIUS_SERVER = 4,
	ISCSI_BOOT_INI_SEC_RADIUS_SERVER = 5,
	ISCSI_BOOT_INI_INITIATOR_NAME = 6,
	ISCSI_BOOT_INI_END_MARKER = 7,
};

enum iscsi_boot_tgt_properties_enum {
	ISCSI_BOOT_TGT_INDEX = 0,
	ISCSI_BOOT_TGT_FLAGS = 1,
	ISCSI_BOOT_TGT_IP_ADDR = 2,
	ISCSI_BOOT_TGT_PORT = 3,
	ISCSI_BOOT_TGT_LUN = 4,
	ISCSI_BOOT_TGT_CHAP_TYPE = 5,
	ISCSI_BOOT_TGT_NIC_ASSOC = 6,
	ISCSI_BOOT_TGT_NAME = 7,
	ISCSI_BOOT_TGT_CHAP_NAME = 8,
	ISCSI_BOOT_TGT_CHAP_SECRET = 9,
	ISCSI_BOOT_TGT_REV_CHAP_NAME = 10,
	ISCSI_BOOT_TGT_REV_CHAP_SECRET = 11,
	ISCSI_BOOT_TGT_END_MARKER = 12,
};

enum iscsi_conn_state {
	ISCSI_CONN_STATE_FREE = 0,
	ISCSI_CONN_STATE_XPT_WAIT = 1,
	ISCSI_CONN_STATE_IN_LOGIN = 2,
	ISCSI_CONN_STATE_LOGGED_IN = 3,
	ISCSI_CONN_STATE_IN_LOGOUT = 4,
	ISCSI_CONN_STATE_LOGOUT_REQUESTED = 5,
	ISCSI_CONN_STATE_CLEANUP_WAIT = 6,
};

enum iscsi_connection_state {
	ISCSI_CONN_UP = 0,
	ISCSI_CONN_DOWN = 1,
	ISCSI_CONN_FAILED = 2,
	ISCSI_CONN_BOUND = 3,
};

enum iscsi_discovery_parent_type {
	ISCSI_DISC_PARENT_UNKNOWN = 1,
	ISCSI_DISC_PARENT_SENDTGT = 2,
	ISCSI_DISC_PARENT_ISNS = 3,
};

enum iscsi_err {
	ISCSI_OK = 0,
	ISCSI_ERR_DATASN = 1001,
	ISCSI_ERR_DATA_OFFSET = 1002,
	ISCSI_ERR_MAX_CMDSN = 1003,
	ISCSI_ERR_EXP_CMDSN = 1004,
	ISCSI_ERR_BAD_OPCODE = 1005,
	ISCSI_ERR_DATALEN = 1006,
	ISCSI_ERR_AHSLEN = 1007,
	ISCSI_ERR_PROTO = 1008,
	ISCSI_ERR_LUN = 1009,
	ISCSI_ERR_BAD_ITT = 1010,
	ISCSI_ERR_CONN_FAILED = 1011,
	ISCSI_ERR_R2TSN = 1012,
	ISCSI_ERR_SESSION_FAILED = 1013,
	ISCSI_ERR_HDR_DGST = 1014,
	ISCSI_ERR_DATA_DGST = 1015,
	ISCSI_ERR_PARAM_NOT_FOUND = 1016,
	ISCSI_ERR_NO_SCSI_CMD = 1017,
	ISCSI_ERR_INVALID_HOST = 1018,
	ISCSI_ERR_XMIT_FAILED = 1019,
	ISCSI_ERR_TCP_CONN_CLOSE = 1020,
	ISCSI_ERR_SCSI_EH_SESSION_RST = 1021,
	ISCSI_ERR_NOP_TIMEDOUT = 1022,
};

enum iscsi_flashnode_param {
	ISCSI_FLASHNODE_IS_FW_ASSIGNED_IPV6 = 0,
	ISCSI_FLASHNODE_PORTAL_TYPE = 1,
	ISCSI_FLASHNODE_AUTO_SND_TGT_DISABLE = 2,
	ISCSI_FLASHNODE_DISCOVERY_SESS = 3,
	ISCSI_FLASHNODE_ENTRY_EN = 4,
	ISCSI_FLASHNODE_HDR_DGST_EN = 5,
	ISCSI_FLASHNODE_DATA_DGST_EN = 6,
	ISCSI_FLASHNODE_IMM_DATA_EN = 7,
	ISCSI_FLASHNODE_INITIAL_R2T_EN = 8,
	ISCSI_FLASHNODE_DATASEQ_INORDER = 9,
	ISCSI_FLASHNODE_PDU_INORDER = 10,
	ISCSI_FLASHNODE_CHAP_AUTH_EN = 11,
	ISCSI_FLASHNODE_SNACK_REQ_EN = 12,
	ISCSI_FLASHNODE_DISCOVERY_LOGOUT_EN = 13,
	ISCSI_FLASHNODE_BIDI_CHAP_EN = 14,
	ISCSI_FLASHNODE_DISCOVERY_AUTH_OPTIONAL = 15,
	ISCSI_FLASHNODE_ERL = 16,
	ISCSI_FLASHNODE_TCP_TIMESTAMP_STAT = 17,
	ISCSI_FLASHNODE_TCP_NAGLE_DISABLE = 18,
	ISCSI_FLASHNODE_TCP_WSF_DISABLE = 19,
	ISCSI_FLASHNODE_TCP_TIMER_SCALE = 20,
	ISCSI_FLASHNODE_TCP_TIMESTAMP_EN = 21,
	ISCSI_FLASHNODE_IP_FRAG_DISABLE = 22,
	ISCSI_FLASHNODE_MAX_RECV_DLENGTH = 23,
	ISCSI_FLASHNODE_MAX_XMIT_DLENGTH = 24,
	ISCSI_FLASHNODE_FIRST_BURST = 25,
	ISCSI_FLASHNODE_DEF_TIME2WAIT = 26,
	ISCSI_FLASHNODE_DEF_TIME2RETAIN = 27,
	ISCSI_FLASHNODE_MAX_R2T = 28,
	ISCSI_FLASHNODE_KEEPALIVE_TMO = 29,
	ISCSI_FLASHNODE_ISID = 30,
	ISCSI_FLASHNODE_TSID = 31,
	ISCSI_FLASHNODE_PORT = 32,
	ISCSI_FLASHNODE_MAX_BURST = 33,
	ISCSI_FLASHNODE_DEF_TASKMGMT_TMO = 34,
	ISCSI_FLASHNODE_IPADDR = 35,
	ISCSI_FLASHNODE_ALIAS = 36,
	ISCSI_FLASHNODE_REDIRECT_IPADDR = 37,
	ISCSI_FLASHNODE_MAX_SEGMENT_SIZE = 38,
	ISCSI_FLASHNODE_LOCAL_PORT = 39,
	ISCSI_FLASHNODE_IPV4_TOS = 40,
	ISCSI_FLASHNODE_IPV6_TC = 41,
	ISCSI_FLASHNODE_IPV6_FLOW_LABEL = 42,
	ISCSI_FLASHNODE_NAME = 43,
	ISCSI_FLASHNODE_TPGT = 44,
	ISCSI_FLASHNODE_LINK_LOCAL_IPV6 = 45,
	ISCSI_FLASHNODE_DISCOVERY_PARENT_IDX = 46,
	ISCSI_FLASHNODE_DISCOVERY_PARENT_TYPE = 47,
	ISCSI_FLASHNODE_TCP_XMIT_WSF = 48,
	ISCSI_FLASHNODE_TCP_RECV_WSF = 49,
	ISCSI_FLASHNODE_CHAP_IN_IDX = 50,
	ISCSI_FLASHNODE_CHAP_OUT_IDX = 51,
	ISCSI_FLASHNODE_USERNAME = 52,
	ISCSI_FLASHNODE_USERNAME_IN = 53,
	ISCSI_FLASHNODE_PASSWORD = 54,
	ISCSI_FLASHNODE_PASSWORD_IN = 55,
	ISCSI_FLASHNODE_STATSN = 56,
	ISCSI_FLASHNODE_EXP_STATSN = 57,
	ISCSI_FLASHNODE_IS_BOOT_TGT = 58,
	ISCSI_FLASHNODE_MAX = 59,
};

enum iscsi_host_event_code {
	ISCSI_EVENT_LINKUP = 1,
	ISCSI_EVENT_LINKDOWN = 2,
	ISCSI_EVENT_MAX = 3,
};

enum iscsi_host_param {
	ISCSI_HOST_PARAM_HWADDRESS = 0,
	ISCSI_HOST_PARAM_INITIATOR_NAME = 1,
	ISCSI_HOST_PARAM_NETDEV_NAME = 2,
	ISCSI_HOST_PARAM_IPADDRESS = 3,
	ISCSI_HOST_PARAM_PORT_STATE = 4,
	ISCSI_HOST_PARAM_PORT_SPEED = 5,
	ISCSI_HOST_PARAM_MAX = 6,
};

enum iscsi_iface_param {
	ISCSI_IFACE_PARAM_DEF_TASKMGMT_TMO = 0,
	ISCSI_IFACE_PARAM_HDRDGST_EN = 1,
	ISCSI_IFACE_PARAM_DATADGST_EN = 2,
	ISCSI_IFACE_PARAM_IMM_DATA_EN = 3,
	ISCSI_IFACE_PARAM_INITIAL_R2T_EN = 4,
	ISCSI_IFACE_PARAM_DATASEQ_INORDER_EN = 5,
	ISCSI_IFACE_PARAM_PDU_INORDER_EN = 6,
	ISCSI_IFACE_PARAM_ERL = 7,
	ISCSI_IFACE_PARAM_MAX_RECV_DLENGTH = 8,
	ISCSI_IFACE_PARAM_FIRST_BURST = 9,
	ISCSI_IFACE_PARAM_MAX_R2T = 10,
	ISCSI_IFACE_PARAM_MAX_BURST = 11,
	ISCSI_IFACE_PARAM_CHAP_AUTH_EN = 12,
	ISCSI_IFACE_PARAM_BIDI_CHAP_EN = 13,
	ISCSI_IFACE_PARAM_DISCOVERY_AUTH_OPTIONAL = 14,
	ISCSI_IFACE_PARAM_DISCOVERY_LOGOUT_EN = 15,
	ISCSI_IFACE_PARAM_STRICT_LOGIN_COMP_EN = 16,
	ISCSI_IFACE_PARAM_INITIATOR_NAME = 17,
};

enum iscsi_ipaddress_state {
	ISCSI_IPDDRESS_STATE_UNCONFIGURED = 0,
	ISCSI_IPDDRESS_STATE_ACQUIRING = 1,
	ISCSI_IPDDRESS_STATE_TENTATIVE = 2,
	ISCSI_IPDDRESS_STATE_VALID = 3,
	ISCSI_IPDDRESS_STATE_DISABLING = 4,
	ISCSI_IPDDRESS_STATE_INVALID = 5,
	ISCSI_IPDDRESS_STATE_DEPRECATED = 6,
};

enum iscsi_net_param {
	ISCSI_NET_PARAM_IPV4_ADDR = 1,
	ISCSI_NET_PARAM_IPV4_SUBNET = 2,
	ISCSI_NET_PARAM_IPV4_GW = 3,
	ISCSI_NET_PARAM_IPV4_BOOTPROTO = 4,
	ISCSI_NET_PARAM_MAC = 5,
	ISCSI_NET_PARAM_IPV6_LINKLOCAL = 6,
	ISCSI_NET_PARAM_IPV6_ADDR = 7,
	ISCSI_NET_PARAM_IPV6_ROUTER = 8,
	ISCSI_NET_PARAM_IPV6_ADDR_AUTOCFG = 9,
	ISCSI_NET_PARAM_IPV6_LINKLOCAL_AUTOCFG = 10,
	ISCSI_NET_PARAM_IPV6_ROUTER_AUTOCFG = 11,
	ISCSI_NET_PARAM_IFACE_ENABLE = 12,
	ISCSI_NET_PARAM_VLAN_ID = 13,
	ISCSI_NET_PARAM_VLAN_PRIORITY = 14,
	ISCSI_NET_PARAM_VLAN_ENABLED = 15,
	ISCSI_NET_PARAM_VLAN_TAG = 16,
	ISCSI_NET_PARAM_IFACE_TYPE = 17,
	ISCSI_NET_PARAM_IFACE_NAME = 18,
	ISCSI_NET_PARAM_MTU = 19,
	ISCSI_NET_PARAM_PORT = 20,
	ISCSI_NET_PARAM_IPADDR_STATE = 21,
	ISCSI_NET_PARAM_IPV6_LINKLOCAL_STATE = 22,
	ISCSI_NET_PARAM_IPV6_ROUTER_STATE = 23,
	ISCSI_NET_PARAM_DELAYED_ACK_EN = 24,
	ISCSI_NET_PARAM_TCP_NAGLE_DISABLE = 25,
	ISCSI_NET_PARAM_TCP_WSF_DISABLE = 26,
	ISCSI_NET_PARAM_TCP_WSF = 27,
	ISCSI_NET_PARAM_TCP_TIMER_SCALE = 28,
	ISCSI_NET_PARAM_TCP_TIMESTAMP_EN = 29,
	ISCSI_NET_PARAM_CACHE_ID = 30,
	ISCSI_NET_PARAM_IPV4_DHCP_DNS_ADDR_EN = 31,
	ISCSI_NET_PARAM_IPV4_DHCP_SLP_DA_EN = 32,
	ISCSI_NET_PARAM_IPV4_TOS_EN = 33,
	ISCSI_NET_PARAM_IPV4_TOS = 34,
	ISCSI_NET_PARAM_IPV4_GRAT_ARP_EN = 35,
	ISCSI_NET_PARAM_IPV4_DHCP_ALT_CLIENT_ID_EN = 36,
	ISCSI_NET_PARAM_IPV4_DHCP_ALT_CLIENT_ID = 37,
	ISCSI_NET_PARAM_IPV4_DHCP_REQ_VENDOR_ID_EN = 38,
	ISCSI_NET_PARAM_IPV4_DHCP_USE_VENDOR_ID_EN = 39,
	ISCSI_NET_PARAM_IPV4_DHCP_VENDOR_ID = 40,
	ISCSI_NET_PARAM_IPV4_DHCP_LEARN_IQN_EN = 41,
	ISCSI_NET_PARAM_IPV4_FRAGMENT_DISABLE = 42,
	ISCSI_NET_PARAM_IPV4_IN_FORWARD_EN = 43,
	ISCSI_NET_PARAM_IPV4_TTL = 44,
	ISCSI_NET_PARAM_IPV6_GRAT_NEIGHBOR_ADV_EN = 45,
	ISCSI_NET_PARAM_IPV6_MLD_EN = 46,
	ISCSI_NET_PARAM_IPV6_FLOW_LABEL = 47,
	ISCSI_NET_PARAM_IPV6_TRAFFIC_CLASS = 48,
	ISCSI_NET_PARAM_IPV6_HOP_LIMIT = 49,
	ISCSI_NET_PARAM_IPV6_ND_REACHABLE_TMO = 50,
	ISCSI_NET_PARAM_IPV6_ND_REXMIT_TIME = 51,
	ISCSI_NET_PARAM_IPV6_ND_STALE_TMO = 52,
	ISCSI_NET_PARAM_IPV6_DUP_ADDR_DETECT_CNT = 53,
	ISCSI_NET_PARAM_IPV6_RTR_ADV_LINK_MTU = 54,
	ISCSI_NET_PARAM_REDIRECT_EN = 55,
};

enum iscsi_param {
	ISCSI_PARAM_MAX_RECV_DLENGTH = 0,
	ISCSI_PARAM_MAX_XMIT_DLENGTH = 1,
	ISCSI_PARAM_HDRDGST_EN = 2,
	ISCSI_PARAM_DATADGST_EN = 3,
	ISCSI_PARAM_INITIAL_R2T_EN = 4,
	ISCSI_PARAM_MAX_R2T = 5,
	ISCSI_PARAM_IMM_DATA_EN = 6,
	ISCSI_PARAM_FIRST_BURST = 7,
	ISCSI_PARAM_MAX_BURST = 8,
	ISCSI_PARAM_PDU_INORDER_EN = 9,
	ISCSI_PARAM_DATASEQ_INORDER_EN = 10,
	ISCSI_PARAM_ERL = 11,
	ISCSI_PARAM_IFMARKER_EN = 12,
	ISCSI_PARAM_OFMARKER_EN = 13,
	ISCSI_PARAM_EXP_STATSN = 14,
	ISCSI_PARAM_TARGET_NAME = 15,
	ISCSI_PARAM_TPGT = 16,
	ISCSI_PARAM_PERSISTENT_ADDRESS = 17,
	ISCSI_PARAM_PERSISTENT_PORT = 18,
	ISCSI_PARAM_SESS_RECOVERY_TMO = 19,
	ISCSI_PARAM_CONN_PORT = 20,
	ISCSI_PARAM_CONN_ADDRESS = 21,
	ISCSI_PARAM_USERNAME = 22,
	ISCSI_PARAM_USERNAME_IN = 23,
	ISCSI_PARAM_PASSWORD = 24,
	ISCSI_PARAM_PASSWORD_IN = 25,
	ISCSI_PARAM_FAST_ABORT = 26,
	ISCSI_PARAM_ABORT_TMO = 27,
	ISCSI_PARAM_LU_RESET_TMO = 28,
	ISCSI_PARAM_HOST_RESET_TMO = 29,
	ISCSI_PARAM_PING_TMO = 30,
	ISCSI_PARAM_RECV_TMO = 31,
	ISCSI_PARAM_IFACE_NAME = 32,
	ISCSI_PARAM_ISID = 33,
	ISCSI_PARAM_INITIATOR_NAME = 34,
	ISCSI_PARAM_TGT_RESET_TMO = 35,
	ISCSI_PARAM_TARGET_ALIAS = 36,
	ISCSI_PARAM_CHAP_IN_IDX = 37,
	ISCSI_PARAM_CHAP_OUT_IDX = 38,
	ISCSI_PARAM_BOOT_ROOT = 39,
	ISCSI_PARAM_BOOT_NIC = 40,
	ISCSI_PARAM_BOOT_TARGET = 41,
	ISCSI_PARAM_AUTO_SND_TGT_DISABLE = 42,
	ISCSI_PARAM_DISCOVERY_SESS = 43,
	ISCSI_PARAM_PORTAL_TYPE = 44,
	ISCSI_PARAM_CHAP_AUTH_EN = 45,
	ISCSI_PARAM_DISCOVERY_LOGOUT_EN = 46,
	ISCSI_PARAM_BIDI_CHAP_EN = 47,
	ISCSI_PARAM_DISCOVERY_AUTH_OPTIONAL = 48,
	ISCSI_PARAM_DEF_TIME2WAIT = 49,
	ISCSI_PARAM_DEF_TIME2RETAIN = 50,
	ISCSI_PARAM_MAX_SEGMENT_SIZE = 51,
	ISCSI_PARAM_STATSN = 52,
	ISCSI_PARAM_KEEPALIVE_TMO = 53,
	ISCSI_PARAM_LOCAL_PORT = 54,
	ISCSI_PARAM_TSID = 55,
	ISCSI_PARAM_DEF_TASKMGMT_TMO = 56,
	ISCSI_PARAM_TCP_TIMESTAMP_STAT = 57,
	ISCSI_PARAM_TCP_WSF_DISABLE = 58,
	ISCSI_PARAM_TCP_NAGLE_DISABLE = 59,
	ISCSI_PARAM_TCP_TIMER_SCALE = 60,
	ISCSI_PARAM_TCP_TIMESTAMP_EN = 61,
	ISCSI_PARAM_TCP_XMIT_WSF = 62,
	ISCSI_PARAM_TCP_RECV_WSF = 63,
	ISCSI_PARAM_IP_FRAGMENT_DISABLE = 64,
	ISCSI_PARAM_IPV4_TOS = 65,
	ISCSI_PARAM_IPV6_TC = 66,
	ISCSI_PARAM_IPV6_FLOW_LABEL = 67,
	ISCSI_PARAM_IS_FW_ASSIGNED_IPV6 = 68,
	ISCSI_PARAM_DISCOVERY_PARENT_IDX = 69,
	ISCSI_PARAM_DISCOVERY_PARENT_TYPE = 70,
	ISCSI_PARAM_LOCAL_IPADDR = 71,
	ISCSI_PARAM_MAX = 72,
};

enum iscsi_param_type {
	ISCSI_PARAM = 0,
	ISCSI_HOST_PARAM = 1,
	ISCSI_NET_PARAM = 2,
	ISCSI_FLASHNODE_PARAM = 3,
	ISCSI_CHAP_PARAM = 4,
	ISCSI_IFACE_PARAM = 5,
};

enum iscsi_port_speed {
	ISCSI_PORT_SPEED_UNKNOWN = 1,
	ISCSI_PORT_SPEED_10MBPS = 2,
	ISCSI_PORT_SPEED_100MBPS = 4,
	ISCSI_PORT_SPEED_1GBPS = 8,
	ISCSI_PORT_SPEED_10GBPS = 16,
	ISCSI_PORT_SPEED_25GBPS = 32,
	ISCSI_PORT_SPEED_40GBPS = 64,
};

enum iscsi_port_state {
	ISCSI_PORT_STATE_DOWN = 1,
	ISCSI_PORT_STATE_UP = 2,
};

enum iscsi_router_state {
	ISCSI_ROUTER_STATE_UNKNOWN = 0,
	ISCSI_ROUTER_STATE_ADVERTISED = 1,
	ISCSI_ROUTER_STATE_MANUAL = 2,
	ISCSI_ROUTER_STATE_STALE = 3,
};

enum iscsi_tgt_dscvr {
	ISCSI_TGT_DSCVR_SEND_TARGETS = 1,
	ISCSI_TGT_DSCVR_ISNS = 2,
	ISCSI_TGT_DSCVR_SLP = 3,
};

enum iscsi_uevent_e {
	ISCSI_UEVENT_UNKNOWN = 0,
	ISCSI_UEVENT_CREATE_SESSION = 11,
	ISCSI_UEVENT_DESTROY_SESSION = 12,
	ISCSI_UEVENT_CREATE_CONN = 13,
	ISCSI_UEVENT_DESTROY_CONN = 14,
	ISCSI_UEVENT_BIND_CONN = 15,
	ISCSI_UEVENT_SET_PARAM = 16,
	ISCSI_UEVENT_START_CONN = 17,
	ISCSI_UEVENT_STOP_CONN = 18,
	ISCSI_UEVENT_SEND_PDU = 19,
	ISCSI_UEVENT_GET_STATS = 20,
	ISCSI_UEVENT_GET_PARAM = 21,
	ISCSI_UEVENT_TRANSPORT_EP_CONNECT = 22,
	ISCSI_UEVENT_TRANSPORT_EP_POLL = 23,
	ISCSI_UEVENT_TRANSPORT_EP_DISCONNECT = 24,
	ISCSI_UEVENT_TGT_DSCVR = 25,
	ISCSI_UEVENT_SET_HOST_PARAM = 26,
	ISCSI_UEVENT_UNBIND_SESSION = 27,
	ISCSI_UEVENT_CREATE_BOUND_SESSION = 28,
	ISCSI_UEVENT_TRANSPORT_EP_CONNECT_THROUGH_HOST = 29,
	ISCSI_UEVENT_PATH_UPDATE = 30,
	ISCSI_UEVENT_SET_IFACE_PARAMS = 31,
	ISCSI_UEVENT_PING = 32,
	ISCSI_UEVENT_GET_CHAP = 33,
	ISCSI_UEVENT_DELETE_CHAP = 34,
	ISCSI_UEVENT_SET_FLASHNODE_PARAMS = 35,
	ISCSI_UEVENT_NEW_FLASHNODE = 36,
	ISCSI_UEVENT_DEL_FLASHNODE = 37,
	ISCSI_UEVENT_LOGIN_FLASHNODE = 38,
	ISCSI_UEVENT_LOGOUT_FLASHNODE = 39,
	ISCSI_UEVENT_LOGOUT_FLASHNODE_SID = 40,
	ISCSI_UEVENT_SET_CHAP = 41,
	ISCSI_UEVENT_GET_HOST_STATS = 42,
	ISCSI_UEVENT_DESTROY_SESSION_ASYNC = 43,
	ISCSI_KEVENT_RECV_PDU = 101,
	ISCSI_KEVENT_CONN_ERROR = 102,
	ISCSI_KEVENT_IF_ERROR = 103,
	ISCSI_KEVENT_DESTROY_SESSION = 104,
	ISCSI_KEVENT_UNBIND_SESSION = 105,
	ISCSI_KEVENT_CREATE_SESSION = 106,
	ISCSI_KEVENT_PATH_REQ = 107,
	ISCSI_KEVENT_IF_DOWN = 108,
	ISCSI_KEVENT_CONN_LOGIN_STATE = 109,
	ISCSI_KEVENT_HOST_EVENT = 110,
	ISCSI_KEVENT_PING_COMP = 111,
};

enum isp1760_ctrl_state {
	ISP1760_CTRL_SETUP = 0,
	ISP1760_CTRL_DATA_IN = 1,
	ISP1760_CTRL_DATA_OUT = 2,
	ISP1760_CTRL_STATUS = 3,
};

enum isp1760_queue_head_types {
	QH_CONTROL = 0,
	QH_BULK = 1,
	QH_INTERRUPT = 2,
	QH_END = 3,
};

enum isp176x_device_controller_fields {
	DC_DEVEN = 0,
	DC_DEVADDR = 1,
	DC_VBUSSTAT = 2,
	DC_SFRESET = 3,
	DC_GLINTENA = 4,
	DC_CDBGMOD_ACK = 5,
	DC_DDBGMODIN_ACK = 6,
	DC_DDBGMODOUT_ACK = 7,
	DC_INTPOL = 8,
	DC_IEPRXTX_7 = 9,
	DC_IEPRXTX_6 = 10,
	DC_IEPRXTX_5 = 11,
	DC_IEPRXTX_4 = 12,
	DC_IEPRXTX_3 = 13,
	DC_IEPRXTX_2 = 14,
	DC_IEPRXTX_1 = 15,
	DC_IEPRXTX_0 = 16,
	DC_IEP0SETUP = 17,
	DC_IEVBUS = 18,
	DC_IEHS_STA = 19,
	DC_IERESM = 20,
	DC_IESUSP = 21,
	DC_IEBRST = 22,
	DC_EP0SETUP = 23,
	DC_ENDPIDX = 24,
	DC_EPDIR = 25,
	DC_CLBUF = 26,
	DC_VENDP = 27,
	DC_DSEN = 28,
	DC_STATUS = 29,
	DC_STALL = 30,
	DC_BUFLEN = 31,
	DC_FFOSZ = 32,
	DC_EPENABLE = 33,
	DC_ENDPTYP = 34,
	DC_FRAMENUM = 35,
	DC_UFRAMENUM = 36,
	DC_CHIP_ID_HIGH = 37,
	DC_CHIP_ID_LOW = 38,
	DC_SCRATCH = 39,
	DC_FIELD_MAX = 40,
};

enum isp176x_host_controller_fields {
	PORT_OWNER = 0,
	PORT_POWER = 1,
	PORT_LSTATUS = 2,
	PORT_RESET = 3,
	PORT_SUSPEND = 4,
	PORT_RESUME = 5,
	PORT_PE = 6,
	PORT_CSC = 7,
	PORT_CONNECT = 8,
	HCS_PPC = 9,
	HCS_N_PORTS = 10,
	HCC_ISOC_CACHE = 11,
	HCC_ISOC_THRES = 12,
	CMD_LRESET = 13,
	CMD_RESET = 14,
	CMD_RUN = 15,
	STS_PCD = 16,
	HC_FRINDEX = 17,
	FLAG_CF = 18,
	HC_ISO_PTD_DONEMAP = 19,
	HC_ISO_PTD_SKIPMAP = 20,
	HC_ISO_PTD_LASTPTD = 21,
	HC_INT_PTD_DONEMAP = 22,
	HC_INT_PTD_SKIPMAP = 23,
	HC_INT_PTD_LASTPTD = 24,
	HC_ATL_PTD_DONEMAP = 25,
	HC_ATL_PTD_SKIPMAP = 26,
	HC_ATL_PTD_LASTPTD = 27,
	ALL_ATX_RESET = 28,
	HW_ANA_DIGI_OC = 29,
	HW_DEV_DMA = 30,
	HW_COMN_IRQ = 31,
	HW_COMN_DMA = 32,
	HW_DATA_BUS_WIDTH = 33,
	HW_DACK_POL_HIGH = 34,
	HW_DREQ_POL_HIGH = 35,
	HW_INTR_HIGH_ACT = 36,
	HW_INTF_LOCK = 37,
	HW_INTR_EDGE_TRIG = 38,
	HW_GLOBAL_INTR_EN = 39,
	HC_CHIP_ID_HIGH = 40,
	HC_CHIP_ID_LOW = 41,
	HC_CHIP_REV = 42,
	HC_SCRATCH = 43,
	SW_RESET_RESET_ATX = 44,
	SW_RESET_RESET_HC = 45,
	SW_RESET_RESET_ALL = 46,
	ISO_BUF_FILL = 47,
	INT_BUF_FILL = 48,
	ATL_BUF_FILL = 49,
	MEM_BANK_SEL = 50,
	MEM_START_ADDR = 51,
	HC_DATA = 52,
	HC_INTERRUPT = 53,
	HC_INT_IRQ_ENABLE = 54,
	HC_ATL_IRQ_ENABLE = 55,
	HC_ISO_IRQ_MASK_OR = 56,
	HC_INT_IRQ_MASK_OR = 57,
	HC_ATL_IRQ_MASK_OR = 58,
	HC_ISO_IRQ_MASK_AND = 59,
	HC_INT_IRQ_MASK_AND = 60,
	HC_ATL_IRQ_MASK_AND = 61,
	HW_OTG_DISABLE = 62,
	HW_SW_SEL_HC_DC = 63,
	HW_VBUS_DRV = 64,
	HW_SEL_CP_EXT = 65,
	HW_DM_PULLDOWN = 66,
	HW_DP_PULLDOWN = 67,
	HW_DP_PULLUP = 68,
	HW_HC_2_DIS = 69,
	HW_OTG_DISABLE_CLEAR = 70,
	HW_SW_SEL_HC_DC_CLEAR = 71,
	HW_VBUS_DRV_CLEAR = 72,
	HW_SEL_CP_EXT_CLEAR = 73,
	HW_DM_PULLDOWN_CLEAR = 74,
	HW_DP_PULLDOWN_CLEAR = 75,
	HW_DP_PULLUP_CLEAR = 76,
	HW_HC_2_DIS_CLEAR = 77,
	HC_FIELD_MAX = 78,
};

enum iter_type {
	ITER_UBUF = 0,
	ITER_IOVEC = 1,
	ITER_BVEC = 2,
	ITER_KVEC = 3,
	ITER_FOLIOQ = 4,
	ITER_XARRAY = 5,
	ITER_DISCARD = 6,
};

enum jbd2_shrink_type {
	JBD2_SHRINK_DESTROY = 0,
	JBD2_SHRINK_BUSY_STOP = 1,
	JBD2_SHRINK_BUSY_SKIP = 2,
};

enum jbd_state_bits {
	BH_JBD = 17,
	BH_JWrite = 18,
	BH_Freed = 19,
	BH_Revoked = 20,
	BH_RevokeValid = 21,
	BH_JBDDirty = 22,
	BH_JournalHead = 23,
	BH_Shadow = 24,
	BH_Verified = 25,
	BH_JBDPrivateStart = 26,
};

enum jump_label_type {
	JUMP_LABEL_NOP = 0,
	JUMP_LABEL_JMP = 1,
};

enum kcmp_type {
	KCMP_FILE = 0,
	KCMP_VM = 1,
	KCMP_FILES = 2,
	KCMP_FS = 3,
	KCMP_SIGHAND = 4,
	KCMP_IO = 5,
	KCMP_SYSVSEM = 6,
	KCMP_EPOLL_TFD = 7,
	KCMP_TYPES = 8,
};

enum kdb_msgsrc {
	KDB_MSGSRC_INTERNAL = 0,
	KDB_MSGSRC_PRINTK = 1,
};

enum kernel_load_data_id {
	LOADING_UNKNOWN = 0,
	LOADING_FIRMWARE = 1,
	LOADING_MODULE = 2,
	LOADING_KEXEC_IMAGE = 3,
	LOADING_KEXEC_INITRAMFS = 4,
	LOADING_POLICY = 5,
	LOADING_X509_CERTIFICATE = 6,
	LOADING_MAX_ID = 7,
};

enum kernel_pkey_operation {
	kernel_pkey_encrypt = 0,
	kernel_pkey_decrypt = 1,
	kernel_pkey_sign = 2,
	kernel_pkey_verify = 3,
};

enum kernel_read_file_id {
	READING_UNKNOWN = 0,
	READING_FIRMWARE = 1,
	READING_MODULE = 2,
	READING_KEXEC_IMAGE = 3,
	READING_KEXEC_INITRAMFS = 4,
	READING_POLICY = 5,
	READING_X509_CERTIFICATE = 6,
	READING_MAX_ID = 7,
};

enum kernfs_node_flag {
	KERNFS_ACTIVATED = 16,
	KERNFS_NS = 32,
	KERNFS_HAS_SEQ_SHOW = 64,
	KERNFS_HAS_MMAP = 128,
	KERNFS_LOCKDEP = 256,
	KERNFS_HIDDEN = 512,
	KERNFS_SUICIDAL = 1024,
	KERNFS_SUICIDED = 2048,
	KERNFS_EMPTY_DIR = 4096,
	KERNFS_HAS_RELEASE = 8192,
	KERNFS_REMOVING = 16384,
};

enum kernfs_node_type {
	KERNFS_DIR = 1,
	KERNFS_FILE = 2,
	KERNFS_LINK = 4,
};

enum kernfs_root_flag {
	KERNFS_ROOT_CREATE_DEACTIVATED = 1,
	KERNFS_ROOT_EXTRA_OPEN_PERM_CHECK = 2,
	KERNFS_ROOT_SUPPORT_EXPORTOP = 4,
	KERNFS_ROOT_SUPPORT_USER_XATTR = 8,
	KERNFS_ROOT_INVARIANT_PARENT = 16,
};

enum key_being_used_for {
	VERIFYING_MODULE_SIGNATURE = 0,
	VERIFYING_FIRMWARE_SIGNATURE = 1,
	VERIFYING_KEXEC_PE_SIGNATURE = 2,
	VERIFYING_KEY_SIGNATURE = 3,
	VERIFYING_KEY_SELF_SIGNATURE = 4,
	VERIFYING_UNSPECIFIED_SIGNATURE = 5,
	NR__KEY_BEING_USED_FOR = 6,
};

enum key_lookup_flag {
	KEY_LOOKUP_CREATE = 1,
	KEY_LOOKUP_PARTIAL = 2,
	KEY_LOOKUP_ALL = 3,
};

enum key_need_perm {
	KEY_NEED_UNSPECIFIED = 0,
	KEY_NEED_VIEW = 1,
	KEY_NEED_READ = 2,
	KEY_NEED_WRITE = 3,
	KEY_NEED_SEARCH = 4,
	KEY_NEED_LINK = 5,
	KEY_NEED_SETATTR = 6,
	KEY_NEED_UNLINK = 7,
	KEY_SYSADMIN_OVERRIDE = 8,
	KEY_AUTHTOKEN_OVERRIDE = 9,
	KEY_DEFER_PERM_CHECK = 10,
};

enum key_notification_subtype {
	NOTIFY_KEY_INSTANTIATED = 0,
	NOTIFY_KEY_UPDATED = 1,
	NOTIFY_KEY_LINKED = 2,
	NOTIFY_KEY_UNLINKED = 3,
	NOTIFY_KEY_CLEARED = 4,
	NOTIFY_KEY_REVOKED = 5,
	NOTIFY_KEY_INVALIDATED = 6,
	NOTIFY_KEY_SETATTR = 7,
};

enum key_state {
	KEY_IS_UNINSTANTIATED = 0,
	KEY_IS_POSITIVE = 1,
};

enum kfunc_ptr_arg_type {
	KF_ARG_PTR_TO_CTX = 0,
	KF_ARG_PTR_TO_ALLOC_BTF_ID = 1,
	KF_ARG_PTR_TO_REFCOUNTED_KPTR = 2,
	KF_ARG_PTR_TO_DYNPTR = 3,
	KF_ARG_PTR_TO_ITER = 4,
	KF_ARG_PTR_TO_LIST_HEAD = 5,
	KF_ARG_PTR_TO_LIST_NODE = 6,
	KF_ARG_PTR_TO_BTF_ID = 7,
	KF_ARG_PTR_TO_MEM = 8,
	KF_ARG_PTR_TO_MEM_SIZE = 9,
	KF_ARG_PTR_TO_CALLBACK = 10,
	KF_ARG_PTR_TO_RB_ROOT = 11,
	KF_ARG_PTR_TO_RB_NODE = 12,
	KF_ARG_PTR_TO_NULL = 13,
	KF_ARG_PTR_TO_CONST_STR = 14,
	KF_ARG_PTR_TO_MAP = 15,
	KF_ARG_PTR_TO_WORKQUEUE = 16,
	KF_ARG_PTR_TO_IRQ_FLAG = 17,
	KF_ARG_PTR_TO_RES_SPIN_LOCK = 18,
};

enum kgdb_bpstate {
	BP_UNDEFINED = 0,
	BP_REMOVED = 1,
	BP_SET = 2,
	BP_ACTIVE = 3,
};

enum kgdb_bptype {
	BP_BREAKPOINT = 0,
	BP_HARDWARE_BREAKPOINT = 1,
	BP_WRITE_WATCHPOINT = 2,
	BP_READ_WATCHPOINT = 3,
	BP_ACCESS_WATCHPOINT = 4,
	BP_POKE_BREAKPOINT = 5,
};

enum kmalloc_cache_type {
	KMALLOC_NORMAL = 0,
	KMALLOC_RANDOM_START = 0,
	KMALLOC_RANDOM_END = 0,
	KMALLOC_RECLAIM = 1,
	KMALLOC_DMA = 2,
	KMALLOC_CGROUP = 3,
	NR_KMALLOC_TYPES = 4,
};

enum kmsg_dump_reason {
	KMSG_DUMP_UNDEF = 0,
	KMSG_DUMP_PANIC = 1,
	KMSG_DUMP_OOPS = 2,
	KMSG_DUMP_EMERG = 3,
	KMSG_DUMP_SHUTDOWN = 4,
	KMSG_DUMP_MAX = 5,
};

enum kobj_ns_type {
	KOBJ_NS_TYPE_NONE = 0,
	KOBJ_NS_TYPE_NET = 1,
	KOBJ_NS_TYPES = 2,
};

enum kobject_action {
	KOBJ_ADD = 0,
	KOBJ_REMOVE = 1,
	KOBJ_CHANGE = 2,
	KOBJ_MOVE = 3,
	KOBJ_ONLINE = 4,
	KOBJ_OFFLINE = 5,
	KOBJ_BIND = 6,
	KOBJ_UNBIND = 7,
};

enum kpage_operation {
	KPAGE_FLAGS = 0,
	KPAGE_COUNT = 1,
	KPAGE_CGROUP = 2,
};

enum kprobe_slot_state {
	SLOT_CLEAN = 0,
	SLOT_DIRTY = 1,
	SLOT_USED = 2,
};

enum ksm_advisor_type {
	KSM_ADVISOR_NONE = 0,
	KSM_ADVISOR_SCAN_TIME = 1,
};

enum ksm_get_folio_flags {
	KSM_GET_FOLIO_NOLOCK = 0,
	KSM_GET_FOLIO_LOCK = 1,
	KSM_GET_FOLIO_TRYLOCK = 2,
};

enum l2tp_debug_flags {
	L2TP_MSG_DEBUG = 1,
	L2TP_MSG_CONTROL = 2,
	L2TP_MSG_SEQ = 4,
	L2TP_MSG_DATA = 8,
};

enum l3mdev_type {
	L3MDEV_TYPE_UNSPEC = 0,
	L3MDEV_TYPE_VRF = 1,
	__L3MDEV_TYPE_MAX = 2,
};

enum landlock_key_type {
	LANDLOCK_KEY_INODE = 1,
	LANDLOCK_KEY_NET_PORT = 2,
};

enum landlock_log_status {
	LANDLOCK_LOG_PENDING = 0,
	LANDLOCK_LOG_RECORDED = 1,
	LANDLOCK_LOG_DISABLED = 2,
};

enum landlock_request_type {
	LANDLOCK_REQUEST_PTRACE = 1,
	LANDLOCK_REQUEST_FS_CHANGE_TOPOLOGY = 2,
	LANDLOCK_REQUEST_FS_ACCESS = 3,
	LANDLOCK_REQUEST_NET_ACCESS = 4,
	LANDLOCK_REQUEST_SCOPE_ABSTRACT_UNIX_SOCKET = 5,
	LANDLOCK_REQUEST_SCOPE_SIGNAL = 6,
};

enum landlock_rule_type {
	LANDLOCK_RULE_PATH_BENEATH = 1,
	LANDLOCK_RULE_NET_PORT = 2,
};

enum layoutdriver_policy_flags {
	PNFS_LAYOUTRET_ON_SETATTR = 1,
	PNFS_LAYOUTRET_ON_ERROR = 2,
	PNFS_READ_WHOLE_PAGE = 4,
	PNFS_LAYOUTGET_ON_OPEN = 8,
};

enum lb_mode {
	LB_YUV_3840X5 = 0,
	LB_YUV_2560X8 = 1,
	LB_RGB_3840X2 = 2,
	LB_RGB_2560X4 = 3,
	LB_RGB_1920X5 = 4,
	LB_RGB_1280X8 = 5,
};

enum led_brightness {
	LED_OFF = 0,
	LED_ON = 1,
	LED_HALF = 127,
	LED_FULL = 255,
};

enum led_default_state {
	LEDS_DEFSTATE_OFF = 0,
	LEDS_DEFSTATE_ON = 1,
	LEDS_DEFSTATE_KEEP = 2,
};

enum led_trigger_netdev_modes {
	TRIGGER_NETDEV_LINK = 0,
	TRIGGER_NETDEV_LINK_10 = 1,
	TRIGGER_NETDEV_LINK_100 = 2,
	TRIGGER_NETDEV_LINK_1000 = 3,
	TRIGGER_NETDEV_LINK_2500 = 4,
	TRIGGER_NETDEV_LINK_5000 = 5,
	TRIGGER_NETDEV_LINK_10000 = 6,
	TRIGGER_NETDEV_HALF_DUPLEX = 7,
	TRIGGER_NETDEV_FULL_DUPLEX = 8,
	TRIGGER_NETDEV_TX = 9,
	TRIGGER_NETDEV_RX = 10,
	TRIGGER_NETDEV_TX_ERR = 11,
	TRIGGER_NETDEV_RX_ERR = 12,
	__TRIGGER_NETDEV_MAX = 13,
};

enum legacy_fs_param {
	LEGACY_FS_UNSET_PARAMS = 0,
	LEGACY_FS_MONOLITHIC_PARAMS = 1,
	LEGACY_FS_INDIVIDUAL_PARAMS = 2,
};

enum limit_by4 {
	NFS4_LIMIT_SIZE = 1,
	NFS4_LIMIT_BLOCKS = 2,
};

enum link_inband_signalling {
	LINK_INBAND_DISABLE = 1,
	LINK_INBAND_ENABLE = 2,
	LINK_INBAND_BYPASS = 4,
};

enum link_lane_count_type {
	LANE_COUNT1 = 1,
	LANE_COUNT2 = 2,
	LANE_COUNT4 = 4,
};

enum link_training_state {
	START = 0,
	CLOCK_RECOVERY = 1,
	EQUALIZER_TRAINING = 2,
	FINISHED = 3,
	FAILED = 4,
};

enum linux_mptcp_mib_field {
	MPTCP_MIB_NUM = 0,
	MPTCP_MIB_MPCAPABLEPASSIVE = 1,
	MPTCP_MIB_MPCAPABLEACTIVE = 2,
	MPTCP_MIB_MPCAPABLEACTIVEACK = 3,
	MPTCP_MIB_MPCAPABLEPASSIVEACK = 4,
	MPTCP_MIB_MPCAPABLEPASSIVEFALLBACK = 5,
	MPTCP_MIB_MPCAPABLEACTIVEFALLBACK = 6,
	MPTCP_MIB_MPCAPABLEACTIVEDROP = 7,
	MPTCP_MIB_MPCAPABLEACTIVEDISABLED = 8,
	MPTCP_MIB_MPCAPABLEENDPATTEMPT = 9,
	MPTCP_MIB_TOKENFALLBACKINIT = 10,
	MPTCP_MIB_RETRANSSEGS = 11,
	MPTCP_MIB_JOINNOTOKEN = 12,
	MPTCP_MIB_JOINSYNRX = 13,
	MPTCP_MIB_JOINSYNBACKUPRX = 14,
	MPTCP_MIB_JOINSYNACKRX = 15,
	MPTCP_MIB_JOINSYNACKBACKUPRX = 16,
	MPTCP_MIB_JOINSYNACKMAC = 17,
	MPTCP_MIB_JOINACKRX = 18,
	MPTCP_MIB_JOINACKMAC = 19,
	MPTCP_MIB_JOINREJECTED = 20,
	MPTCP_MIB_JOINSYNTX = 21,
	MPTCP_MIB_JOINSYNTXCREATSKERR = 22,
	MPTCP_MIB_JOINSYNTXBINDERR = 23,
	MPTCP_MIB_JOINSYNTXCONNECTERR = 24,
	MPTCP_MIB_DSSNOMATCH = 25,
	MPTCP_MIB_DSSCORRUPTIONFALLBACK = 26,
	MPTCP_MIB_DSSCORRUPTIONRESET = 27,
	MPTCP_MIB_INFINITEMAPTX = 28,
	MPTCP_MIB_INFINITEMAPRX = 29,
	MPTCP_MIB_DSSTCPMISMATCH = 30,
	MPTCP_MIB_DATACSUMERR = 31,
	MPTCP_MIB_OFOQUEUETAIL = 32,
	MPTCP_MIB_OFOQUEUE = 33,
	MPTCP_MIB_OFOMERGE = 34,
	MPTCP_MIB_NODSSWINDOW = 35,
	MPTCP_MIB_DUPDATA = 36,
	MPTCP_MIB_ADDADDR = 37,
	MPTCP_MIB_ADDADDRTX = 38,
	MPTCP_MIB_ADDADDRTXDROP = 39,
	MPTCP_MIB_ECHOADD = 40,
	MPTCP_MIB_ECHOADDTX = 41,
	MPTCP_MIB_ECHOADDTXDROP = 42,
	MPTCP_MIB_PORTADD = 43,
	MPTCP_MIB_ADDADDRDROP = 44,
	MPTCP_MIB_JOINPORTSYNRX = 45,
	MPTCP_MIB_JOINPORTSYNACKRX = 46,
	MPTCP_MIB_JOINPORTACKRX = 47,
	MPTCP_MIB_MISMATCHPORTSYNRX = 48,
	MPTCP_MIB_MISMATCHPORTACKRX = 49,
	MPTCP_MIB_RMADDR = 50,
	MPTCP_MIB_RMADDRDROP = 51,
	MPTCP_MIB_RMADDRTX = 52,
	MPTCP_MIB_RMADDRTXDROP = 53,
	MPTCP_MIB_RMSUBFLOW = 54,
	MPTCP_MIB_MPPRIOTX = 55,
	MPTCP_MIB_MPPRIORX = 56,
	MPTCP_MIB_MPFAILTX = 57,
	MPTCP_MIB_MPFAILRX = 58,
	MPTCP_MIB_MPFASTCLOSETX = 59,
	MPTCP_MIB_MPFASTCLOSERX = 60,
	MPTCP_MIB_MPRSTTX = 61,
	MPTCP_MIB_MPRSTRX = 62,
	MPTCP_MIB_RCVPRUNED = 63,
	MPTCP_MIB_SUBFLOWSTALE = 64,
	MPTCP_MIB_SUBFLOWRECOVER = 65,
	MPTCP_MIB_SNDWNDSHARED = 66,
	MPTCP_MIB_RCVWNDSHARED = 67,
	MPTCP_MIB_RCVWNDCONFLICTUPDATE = 68,
	MPTCP_MIB_RCVWNDCONFLICT = 69,
	MPTCP_MIB_CURRESTAB = 70,
	MPTCP_MIB_BLACKHOLE = 71,
	__MPTCP_MIB_MAX = 72,
};

enum lock_type4 {
	NFS4_UNLOCK_LT = 0,
	NFS4_READ_LT = 1,
	NFS4_WRITE_LT = 2,
	NFS4_READW_LT = 3,
	NFS4_WRITEW_LT = 4,
};

enum lockdep_ok {
	LOCKDEP_STILL_OK = 0,
	LOCKDEP_NOW_UNRELIABLE = 1,
};

enum lockdown_reason {
	LOCKDOWN_NONE = 0,
	LOCKDOWN_MODULE_SIGNATURE = 1,
	LOCKDOWN_DEV_MEM = 2,
	LOCKDOWN_EFI_TEST = 3,
	LOCKDOWN_KEXEC = 4,
	LOCKDOWN_HIBERNATION = 5,
	LOCKDOWN_PCI_ACCESS = 6,
	LOCKDOWN_IOPORT = 7,
	LOCKDOWN_MSR = 8,
	LOCKDOWN_ACPI_TABLES = 9,
	LOCKDOWN_DEVICE_TREE = 10,
	LOCKDOWN_PCMCIA_CIS = 11,
	LOCKDOWN_TIOCSSERIAL = 12,
	LOCKDOWN_MODULE_PARAMETERS = 13,
	LOCKDOWN_MMIOTRACE = 14,
	LOCKDOWN_DEBUGFS = 15,
	LOCKDOWN_XMON_WR = 16,
	LOCKDOWN_BPF_WRITE_USER = 17,
	LOCKDOWN_DBG_WRITE_KERNEL = 18,
	LOCKDOWN_RTAS_ERROR_INJECTION = 19,
	LOCKDOWN_INTEGRITY_MAX = 20,
	LOCKDOWN_KCORE = 21,
	LOCKDOWN_KPROBES = 22,
	LOCKDOWN_BPF_READ_KERNEL = 23,
	LOCKDOWN_DBG_READ_KERNEL = 24,
	LOCKDOWN_PERF = 25,
	LOCKDOWN_TRACEFS = 26,
	LOCKDOWN_XMON_RW = 27,
	LOCKDOWN_XFRM_SECRET = 28,
	LOCKDOWN_CONFIDENTIALITY_MAX = 29,
};

enum log_type {
	CURSEG_HOT_DATA = 0,
	CURSEG_WARM_DATA = 1,
	CURSEG_COLD_DATA = 2,
	CURSEG_HOT_NODE = 3,
	CURSEG_WARM_NODE = 4,
	CURSEG_COLD_NODE = 5,
	NR_PERSISTENT_LOG = 6,
	CURSEG_COLD_DATA_PINNED = 6,
	CURSEG_ALL_DATA_ATGC = 7,
	NO_CHECK_TYPE = 8,
};

enum lpuart_type {
	VF610_LPUART = 0,
	LS1021A_LPUART = 1,
	LS1028A_LPUART = 2,
	IMX7ULP_LPUART = 3,
	IMX8ULP_LPUART = 4,
	IMX8QXP_LPUART = 5,
	IMXRT1050_LPUART = 6,
};

enum lru_list {
	LRU_INACTIVE_ANON = 0,
	LRU_ACTIVE_ANON = 1,
	LRU_INACTIVE_FILE = 2,
	LRU_ACTIVE_FILE = 3,
	LRU_UNEVICTABLE = 4,
	NR_LRU_LISTS = 5,
};

enum lru_status {
	LRU_REMOVED = 0,
	LRU_REMOVED_RETRY = 1,
	LRU_ROTATE = 2,
	LRU_SKIP = 3,
	LRU_RETRY = 4,
	LRU_STOP = 5,
};

enum lruvec_flags {
	LRUVEC_CGROUP_CONGESTED = 0,
	LRUVEC_NODE_CONGESTED = 1,
};

enum lsm_event {
	LSM_POLICY_CHANGE = 0,
};

enum lsm_integrity_type {
	LSM_INT_DMVERITY_SIG_VALID = 0,
	LSM_INT_DMVERITY_ROOTHASH = 1,
	LSM_INT_FSVERITY_BUILTINSIG_VALID = 2,
};

enum lsm_order {
	LSM_ORDER_FIRST = -1,
	LSM_ORDER_MUTABLE = 0,
	LSM_ORDER_LAST = 1,
};

enum lw_bits {
	LW_URGENT = 0,
};

enum lwtunnel_encap_types {
	LWTUNNEL_ENCAP_NONE = 0,
	LWTUNNEL_ENCAP_MPLS = 1,
	LWTUNNEL_ENCAP_IP = 2,
	LWTUNNEL_ENCAP_ILA = 3,
	LWTUNNEL_ENCAP_IP6 = 4,
	LWTUNNEL_ENCAP_SEG6 = 5,
	LWTUNNEL_ENCAP_BPF = 6,
	LWTUNNEL_ENCAP_SEG6_LOCAL = 7,
	LWTUNNEL_ENCAP_RPL = 8,
	LWTUNNEL_ENCAP_IOAM6 = 9,
	LWTUNNEL_ENCAP_XFRM = 10,
	__LWTUNNEL_ENCAP_MAX = 11,
};

enum lwtunnel_ip6_t {
	LWTUNNEL_IP6_UNSPEC = 0,
	LWTUNNEL_IP6_ID = 1,
	LWTUNNEL_IP6_DST = 2,
	LWTUNNEL_IP6_SRC = 3,
	LWTUNNEL_IP6_HOPLIMIT = 4,
	LWTUNNEL_IP6_TC = 5,
	LWTUNNEL_IP6_FLAGS = 6,
	LWTUNNEL_IP6_PAD = 7,
	LWTUNNEL_IP6_OPTS = 8,
	__LWTUNNEL_IP6_MAX = 9,
};

enum lwtunnel_ip_t {
	LWTUNNEL_IP_UNSPEC = 0,
	LWTUNNEL_IP_ID = 1,
	LWTUNNEL_IP_DST = 2,
	LWTUNNEL_IP_SRC = 3,
	LWTUNNEL_IP_TTL = 4,
	LWTUNNEL_IP_TOS = 5,
	LWTUNNEL_IP_FLAGS = 6,
	LWTUNNEL_IP_PAD = 7,
	LWTUNNEL_IP_OPTS = 8,
	__LWTUNNEL_IP_MAX = 9,
};

enum lzma2_seq {
	SEQ_CONTROL = 0,
	SEQ_UNCOMPRESSED_1 = 1,
	SEQ_UNCOMPRESSED_2 = 2,
	SEQ_COMPRESSED_0 = 3,
	SEQ_COMPRESSED_1 = 4,
	SEQ_PROPERTIES = 5,
	SEQ_LZMA_PREPARE = 6,
	SEQ_LZMA_RUN = 7,
	SEQ_COPY = 8,
};

enum lzma_state {
	STATE_LIT_LIT = 0,
	STATE_MATCH_LIT_LIT = 1,
	STATE_REP_LIT_LIT = 2,
	STATE_SHORTREP_LIT_LIT = 3,
	STATE_MATCH_LIT = 4,
	STATE_REP_LIT = 5,
	STATE_SHORTREP_LIT = 6,
	STATE_LIT_MATCH = 7,
	STATE_LIT_LONGREP = 8,
	STATE_LIT_SHORTREP = 9,
	STATE_NONLIT_MATCH = 10,
	STATE_NONLIT_REP = 11,
};

enum macsec_offload {
	MACSEC_OFFLOAD_OFF = 0,
	MACSEC_OFFLOAD_PHY = 1,
	MACSEC_OFFLOAD_MAC = 2,
	__MACSEC_OFFLOAD_END = 3,
	MACSEC_OFFLOAD_MAX = 2,
};

enum macsec_validation_type {
	MACSEC_VALIDATE_DISABLED = 0,
	MACSEC_VALIDATE_CHECK = 1,
	MACSEC_VALIDATE_STRICT = 2,
	__MACSEC_VALIDATE_END = 3,
	MACSEC_VALIDATE_MAX = 2,
};

enum maple_status {
	ma_active = 0,
	ma_start = 1,
	ma_root = 2,
	ma_none = 3,
	ma_pause = 4,
	ma_overflow = 5,
	ma_underflow = 6,
	ma_error = 7,
};

enum maple_type {
	maple_dense = 0,
	maple_leaf_64 = 1,
	maple_range_64 = 2,
	maple_arange_64 = 3,
};

enum mapping_flags {
	AS_EIO = 0,
	AS_ENOSPC = 1,
	AS_MM_ALL_LOCKS = 2,
	AS_UNEVICTABLE = 3,
	AS_EXITING = 4,
	AS_NO_WRITEBACK_TAGS = 5,
	AS_RELEASE_ALWAYS = 6,
	AS_STABLE_WRITES = 7,
	AS_INACCESSIBLE = 8,
	AS_WRITEBACK_MAY_DEADLOCK_ON_RECLAIM = 9,
	AS_FOLIO_ORDER_BITS = 5,
	AS_FOLIO_ORDER_MIN = 16,
	AS_FOLIO_ORDER_MAX = 21,
};

enum mapping_status {
	MAPPING_OK = 0,
	MAPPING_INVALID = 1,
	MAPPING_EMPTY = 2,
	MAPPING_DATA_FIN = 3,
	MAPPING_DUMMY = 4,
	MAPPING_BAD_CSUM = 5,
	MAPPING_NODSS = 6,
};

enum max14577_charger_reg {
	MAX14577_CHG_REG_STATUS3 = 6,
	MAX14577_CHG_REG_CHG_CTRL1 = 15,
	MAX14577_CHG_REG_CHG_CTRL2 = 16,
	MAX14577_CHG_REG_CHG_CTRL3 = 17,
	MAX14577_CHG_REG_CHG_CTRL4 = 18,
	MAX14577_CHG_REG_CHG_CTRL5 = 19,
	MAX14577_CHG_REG_CHG_CTRL6 = 20,
	MAX14577_CHG_REG_CHG_CTRL7 = 21,
	MAX14577_CHG_REG_END = 22,
};

enum max14577_irq {
	MAX14577_IRQ_INT1_ADC = 0,
	MAX14577_IRQ_INT1_ADCLOW = 1,
	MAX14577_IRQ_INT1_ADCERR = 2,
	MAX77836_IRQ_INT1_ADC1K = 3,
	MAX14577_IRQ_INT2_CHGTYP = 4,
	MAX14577_IRQ_INT2_CHGDETRUN = 5,
	MAX14577_IRQ_INT2_DCDTMR = 6,
	MAX14577_IRQ_INT2_DBCHG = 7,
	MAX14577_IRQ_INT2_VBVOLT = 8,
	MAX77836_IRQ_INT2_VIDRM = 9,
	MAX14577_IRQ_INT3_EOC = 10,
	MAX14577_IRQ_INT3_CGMBC = 11,
	MAX14577_IRQ_INT3_OVP = 12,
	MAX14577_IRQ_INT3_MBCCHGERR = 13,
	MAX77836_IRQ_TOPSYS_T140C = 14,
	MAX77836_IRQ_TOPSYS_T120C = 15,
	MAX14577_IRQ_NUM = 16,
};

enum max14577_muic_acc_type {
	MAX14577_MUIC_ADC_GROUND = 0,
	MAX14577_MUIC_ADC_SEND_END_BUTTON = 1,
	MAX14577_MUIC_ADC_REMOTE_S1_BUTTON = 2,
	MAX14577_MUIC_ADC_REMOTE_S2_BUTTON = 3,
	MAX14577_MUIC_ADC_REMOTE_S3_BUTTON = 4,
	MAX14577_MUIC_ADC_REMOTE_S4_BUTTON = 5,
	MAX14577_MUIC_ADC_REMOTE_S5_BUTTON = 6,
	MAX14577_MUIC_ADC_REMOTE_S6_BUTTON = 7,
	MAX14577_MUIC_ADC_REMOTE_S7_BUTTON = 8,
	MAX14577_MUIC_ADC_REMOTE_S8_BUTTON = 9,
	MAX14577_MUIC_ADC_REMOTE_S9_BUTTON = 10,
	MAX14577_MUIC_ADC_REMOTE_S10_BUTTON = 11,
	MAX14577_MUIC_ADC_REMOTE_S11_BUTTON = 12,
	MAX14577_MUIC_ADC_REMOTE_S12_BUTTON = 13,
	MAX14577_MUIC_ADC_RESERVED_ACC_1 = 14,
	MAX14577_MUIC_ADC_RESERVED_ACC_2 = 15,
	MAX14577_MUIC_ADC_RESERVED_ACC_3 = 16,
	MAX14577_MUIC_ADC_RESERVED_ACC_4 = 17,
	MAX14577_MUIC_ADC_RESERVED_ACC_5 = 18,
	MAX14577_MUIC_ADC_AUDIO_DEVICE_TYPE2 = 19,
	MAX14577_MUIC_ADC_PHONE_POWERED_DEV = 20,
	MAX14577_MUIC_ADC_TTY_CONVERTER = 21,
	MAX14577_MUIC_ADC_UART_CABLE = 22,
	MAX14577_MUIC_ADC_CEA936A_TYPE1_CHG = 23,
	MAX14577_MUIC_ADC_FACTORY_MODE_USB_OFF = 24,
	MAX14577_MUIC_ADC_FACTORY_MODE_USB_ON = 25,
	MAX14577_MUIC_ADC_AV_CABLE_NOLOAD = 26,
	MAX14577_MUIC_ADC_CEA936A_TYPE2_CHG = 27,
	MAX14577_MUIC_ADC_FACTORY_MODE_UART_OFF = 28,
	MAX14577_MUIC_ADC_FACTORY_MODE_UART_ON = 29,
	MAX14577_MUIC_ADC_AUDIO_DEVICE_TYPE1 = 30,
	MAX14577_MUIC_ADC_OPEN = 31,
};

enum max14577_muic_adc_debounce_time {
	ADC_DEBOUNCE_TIME_5MS = 0,
	ADC_DEBOUNCE_TIME_10MS = 1,
	ADC_DEBOUNCE_TIME_25MS = 2,
	ADC_DEBOUNCE_TIME_38_62MS = 3,
};

enum max14577_muic_cable_group {
	MAX14577_CABLE_GROUP_ADC = 0,
	MAX14577_CABLE_GROUP_CHG = 1,
};

enum max14577_muic_charger_type {
	MAX14577_CHARGER_TYPE_NONE = 0,
	MAX14577_CHARGER_TYPE_USB = 1,
	MAX14577_CHARGER_TYPE_DOWNSTREAM_PORT = 2,
	MAX14577_CHARGER_TYPE_DEDICATED_CHG = 3,
	MAX14577_CHARGER_TYPE_SPECIAL_500MA = 4,
	MAX14577_CHARGER_TYPE_SPECIAL_1A = 5,
	MAX14577_CHARGER_TYPE_RESERVED = 6,
	MAX14577_CHARGER_TYPE_DEAD_BATTERY = 7,
	MAX77836_CHARGER_TYPE_SPECIAL_BIAS = 14,
	MAX77836_CHARGER_TYPE_RESERVED = 15,
};

enum max14577_muic_reg {
	MAX14577_MUIC_REG_STATUS1 = 4,
	MAX14577_MUIC_REG_STATUS2 = 5,
	MAX14577_MUIC_REG_CONTROL1 = 12,
	MAX14577_MUIC_REG_CONTROL3 = 14,
	MAX14577_MUIC_REG_END = 15,
};

enum max14577_muic_status {
	MAX14577_MUIC_STATUS1 = 0,
	MAX14577_MUIC_STATUS2 = 1,
	MAX14577_MUIC_STATUS_END = 2,
};

enum max14577_reg {
	MAX14577_REG_DEVICEID = 0,
	MAX14577_REG_INT1 = 1,
	MAX14577_REG_INT2 = 2,
	MAX14577_REG_INT3 = 3,
	MAX14577_REG_STATUS1 = 4,
	MAX14577_REG_STATUS2 = 5,
	MAX14577_REG_STATUS3 = 6,
	MAX14577_REG_INTMASK1 = 7,
	MAX14577_REG_INTMASK2 = 8,
	MAX14577_REG_INTMASK3 = 9,
	MAX14577_REG_CDETCTRL1 = 10,
	MAX14577_REG_RFU = 11,
	MAX14577_REG_CONTROL1 = 12,
	MAX14577_REG_CONTROL2 = 13,
	MAX14577_REG_CONTROL3 = 14,
	MAX14577_REG_CHGCTRL1 = 15,
	MAX14577_REG_CHGCTRL2 = 16,
	MAX14577_REG_CHGCTRL3 = 17,
	MAX14577_REG_CHGCTRL4 = 18,
	MAX14577_REG_CHGCTRL5 = 19,
	MAX14577_REG_CHGCTRL6 = 20,
	MAX14577_REG_CHGCTRL7 = 21,
	MAX14577_REG_END = 22,
};

enum max14577_regulators {
	MAX14577_SAFEOUT = 0,
	MAX14577_CHARGER = 1,
	MAX14577_REGULATOR_NUM = 2,
};

enum max77686_chip_name {
	CHIP_MAX77686 = 0,
	CHIP_MAX77802 = 1,
	CHIP_MAX77620 = 2,
};

enum max77686_irq {
	MAX77686_PMICIRQ_PWRONF = 0,
	MAX77686_PMICIRQ_PWRONR = 1,
	MAX77686_PMICIRQ_JIGONBF = 2,
	MAX77686_PMICIRQ_JIGONBR = 3,
	MAX77686_PMICIRQ_ACOKBF = 4,
	MAX77686_PMICIRQ_ACOKBR = 5,
	MAX77686_PMICIRQ_ONKEY1S = 6,
	MAX77686_PMICIRQ_MRSTB = 7,
	MAX77686_PMICIRQ_140C = 8,
	MAX77686_PMICIRQ_120C = 9,
	MAX77686_RTCIRQ_RTC60S = 0,
	MAX77686_RTCIRQ_RTCA1 = 1,
	MAX77686_RTCIRQ_RTCA2 = 2,
	MAX77686_RTCIRQ_SMPL = 3,
	MAX77686_RTCIRQ_RTC1S = 4,
	MAX77686_RTCIRQ_WTSR = 5,
};

enum max77686_irq_source {
	PMIC_INT1 = 0,
	PMIC_INT2 = 1,
	RTC_INT = 2,
	MAX77686_IRQ_GROUP_NR = 3,
};

enum max77686_pmic_reg {
	MAX77686_REG_DEVICE_ID = 0,
	MAX77686_REG_INTSRC = 1,
	MAX77686_REG_INT1 = 2,
	MAX77686_REG_INT2 = 3,
	MAX77686_REG_INT1MSK = 4,
	MAX77686_REG_INT2MSK = 5,
	MAX77686_REG_STATUS1 = 6,
	MAX77686_REG_STATUS2 = 7,
	MAX77686_REG_PWRON = 8,
	MAX77686_REG_ONOFF_DELAY = 9,
	MAX77686_REG_MRSTB = 10,
	MAX77686_REG_BUCK1CTRL = 16,
	MAX77686_REG_BUCK1OUT = 17,
	MAX77686_REG_BUCK2CTRL1 = 18,
	MAX77686_REG_BUCK234FREQ = 19,
	MAX77686_REG_BUCK2DVS1 = 20,
	MAX77686_REG_BUCK2DVS2 = 21,
	MAX77686_REG_BUCK2DVS3 = 22,
	MAX77686_REG_BUCK2DVS4 = 23,
	MAX77686_REG_BUCK2DVS5 = 24,
	MAX77686_REG_BUCK2DVS6 = 25,
	MAX77686_REG_BUCK2DVS7 = 26,
	MAX77686_REG_BUCK2DVS8 = 27,
	MAX77686_REG_BUCK3CTRL1 = 28,
	MAX77686_REG_BUCK3DVS1 = 30,
	MAX77686_REG_BUCK3DVS2 = 31,
	MAX77686_REG_BUCK3DVS3 = 32,
	MAX77686_REG_BUCK3DVS4 = 33,
	MAX77686_REG_BUCK3DVS5 = 34,
	MAX77686_REG_BUCK3DVS6 = 35,
	MAX77686_REG_BUCK3DVS7 = 36,
	MAX77686_REG_BUCK3DVS8 = 37,
	MAX77686_REG_BUCK4CTRL1 = 38,
	MAX77686_REG_BUCK4DVS1 = 40,
	MAX77686_REG_BUCK4DVS2 = 41,
	MAX77686_REG_BUCK4DVS3 = 42,
	MAX77686_REG_BUCK4DVS4 = 43,
	MAX77686_REG_BUCK4DVS5 = 44,
	MAX77686_REG_BUCK4DVS6 = 45,
	MAX77686_REG_BUCK4DVS7 = 46,
	MAX77686_REG_BUCK4DVS8 = 47,
	MAX77686_REG_BUCK5CTRL = 48,
	MAX77686_REG_BUCK5OUT = 49,
	MAX77686_REG_BUCK6CTRL = 50,
	MAX77686_REG_BUCK6OUT = 51,
	MAX77686_REG_BUCK7CTRL = 52,
	MAX77686_REG_BUCK7OUT = 53,
	MAX77686_REG_BUCK8CTRL = 54,
	MAX77686_REG_BUCK8OUT = 55,
	MAX77686_REG_BUCK9CTRL = 56,
	MAX77686_REG_BUCK9OUT = 57,
	MAX77686_REG_LDO1CTRL1 = 64,
	MAX77686_REG_LDO2CTRL1 = 65,
	MAX77686_REG_LDO3CTRL1 = 66,
	MAX77686_REG_LDO4CTRL1 = 67,
	MAX77686_REG_LDO5CTRL1 = 68,
	MAX77686_REG_LDO6CTRL1 = 69,
	MAX77686_REG_LDO7CTRL1 = 70,
	MAX77686_REG_LDO8CTRL1 = 71,
	MAX77686_REG_LDO9CTRL1 = 72,
	MAX77686_REG_LDO10CTRL1 = 73,
	MAX77686_REG_LDO11CTRL1 = 74,
	MAX77686_REG_LDO12CTRL1 = 75,
	MAX77686_REG_LDO13CTRL1 = 76,
	MAX77686_REG_LDO14CTRL1 = 77,
	MAX77686_REG_LDO15CTRL1 = 78,
	MAX77686_REG_LDO16CTRL1 = 79,
	MAX77686_REG_LDO17CTRL1 = 80,
	MAX77686_REG_LDO18CTRL1 = 81,
	MAX77686_REG_LDO19CTRL1 = 82,
	MAX77686_REG_LDO20CTRL1 = 83,
	MAX77686_REG_LDO21CTRL1 = 84,
	MAX77686_REG_LDO22CTRL1 = 85,
	MAX77686_REG_LDO23CTRL1 = 86,
	MAX77686_REG_LDO24CTRL1 = 87,
	MAX77686_REG_LDO25CTRL1 = 88,
	MAX77686_REG_LDO26CTRL1 = 89,
	MAX77686_REG_LDO1CTRL2 = 96,
	MAX77686_REG_LDO2CTRL2 = 97,
	MAX77686_REG_LDO3CTRL2 = 98,
	MAX77686_REG_LDO4CTRL2 = 99,
	MAX77686_REG_LDO5CTRL2 = 100,
	MAX77686_REG_LDO6CTRL2 = 101,
	MAX77686_REG_LDO7CTRL2 = 102,
	MAX77686_REG_LDO8CTRL2 = 103,
	MAX77686_REG_LDO9CTRL2 = 104,
	MAX77686_REG_LDO10CTRL2 = 105,
	MAX77686_REG_LDO11CTRL2 = 106,
	MAX77686_REG_LDO12CTRL2 = 107,
	MAX77686_REG_LDO13CTRL2 = 108,
	MAX77686_REG_LDO14CTRL2 = 109,
	MAX77686_REG_LDO15CTRL2 = 110,
	MAX77686_REG_LDO16CTRL2 = 111,
	MAX77686_REG_LDO17CTRL2 = 112,
	MAX77686_REG_LDO18CTRL2 = 113,
	MAX77686_REG_LDO19CTRL2 = 114,
	MAX77686_REG_LDO20CTRL2 = 115,
	MAX77686_REG_LDO21CTRL2 = 116,
	MAX77686_REG_LDO22CTRL2 = 117,
	MAX77686_REG_LDO23CTRL2 = 118,
	MAX77686_REG_LDO24CTRL2 = 119,
	MAX77686_REG_LDO25CTRL2 = 120,
	MAX77686_REG_LDO26CTRL2 = 121,
	MAX77686_REG_BBAT_CHG = 126,
	MAX77686_REG_32KHZ = 127,
	MAX77686_REG_PMIC_END = 128,
};

enum max77686_regulators {
	MAX77686_LDO1 = 0,
	MAX77686_LDO2 = 1,
	MAX77686_LDO3 = 2,
	MAX77686_LDO4 = 3,
	MAX77686_LDO5 = 4,
	MAX77686_LDO6 = 5,
	MAX77686_LDO7 = 6,
	MAX77686_LDO8 = 7,
	MAX77686_LDO9 = 8,
	MAX77686_LDO10 = 9,
	MAX77686_LDO11 = 10,
	MAX77686_LDO12 = 11,
	MAX77686_LDO13 = 12,
	MAX77686_LDO14 = 13,
	MAX77686_LDO15 = 14,
	MAX77686_LDO16 = 15,
	MAX77686_LDO17 = 16,
	MAX77686_LDO18 = 17,
	MAX77686_LDO19 = 18,
	MAX77686_LDO20 = 19,
	MAX77686_LDO21 = 20,
	MAX77686_LDO22 = 21,
	MAX77686_LDO23 = 22,
	MAX77686_LDO24 = 23,
	MAX77686_LDO25 = 24,
	MAX77686_LDO26 = 25,
	MAX77686_BUCK1 = 26,
	MAX77686_BUCK2 = 27,
	MAX77686_BUCK3 = 28,
	MAX77686_BUCK4 = 29,
	MAX77686_BUCK5 = 30,
	MAX77686_BUCK6 = 31,
	MAX77686_BUCK7 = 32,
	MAX77686_BUCK8 = 33,
	MAX77686_BUCK9 = 34,
	MAX77686_REG_MAX = 35,
};

enum max77686_rtc_reg {
	MAX77686_RTC_INT = 0,
	MAX77686_RTC_INTM = 1,
	MAX77686_RTC_CONTROLM = 2,
	MAX77686_RTC_CONTROL = 3,
	MAX77686_RTC_UPDATE0 = 4,
	MAX77686_WTSR_SMPL_CNTL = 6,
	MAX77686_RTC_SEC = 7,
	MAX77686_RTC_MIN = 8,
	MAX77686_RTC_HOUR = 9,
	MAX77686_RTC_WEEKDAY = 10,
	MAX77686_RTC_MONTH = 11,
	MAX77686_RTC_YEAR = 12,
	MAX77686_RTC_MONTHDAY = 13,
	MAX77686_ALARM1_SEC = 14,
	MAX77686_ALARM1_MIN = 15,
	MAX77686_ALARM1_HOUR = 16,
	MAX77686_ALARM1_WEEKDAY = 17,
	MAX77686_ALARM1_MONTH = 18,
	MAX77686_ALARM1_YEAR = 19,
	MAX77686_ALARM1_DATE = 20,
	MAX77686_ALARM2_SEC = 21,
	MAX77686_ALARM2_MIN = 22,
	MAX77686_ALARM2_HOUR = 23,
	MAX77686_ALARM2_WEEKDAY = 24,
	MAX77686_ALARM2_MONTH = 25,
	MAX77686_ALARM2_YEAR = 26,
	MAX77686_ALARM2_DATE = 27,
};

enum max77686_rtc_reg_offset {
	REG_RTC_CONTROLM = 0,
	REG_RTC_CONTROL = 1,
	REG_RTC_UPDATE0 = 2,
	REG_WTSR_SMPL_CNTL = 3,
	REG_RTC_SEC = 4,
	REG_RTC_MIN = 5,
	REG_RTC_HOUR = 6,
	REG_RTC_WEEKDAY = 7,
	REG_RTC_MONTH = 8,
	REG_RTC_YEAR = 9,
	REG_RTC_MONTHDAY = 10,
	REG_ALARM1_SEC = 11,
	REG_ALARM1_MIN = 12,
	REG_ALARM1_HOUR = 13,
	REG_ALARM1_WEEKDAY = 14,
	REG_ALARM1_MONTH = 15,
	REG_ALARM1_YEAR = 16,
	REG_ALARM1_DATE = 17,
	REG_ALARM2_SEC = 18,
	REG_ALARM2_MIN = 19,
	REG_ALARM2_HOUR = 20,
	REG_ALARM2_WEEKDAY = 21,
	REG_ALARM2_MONTH = 22,
	REG_ALARM2_YEAR = 23,
	REG_ALARM2_DATE = 24,
	REG_RTC_AE1 = 25,
	REG_RTC_END = 26,
};

enum max77686_types {
	TYPE_MAX77686 = 0,
	TYPE_MAX77802 = 1,
};

enum max77693_haptic_reg {
	MAX77693_HAPTIC_REG_STATUS = 0,
	MAX77693_HAPTIC_REG_CONFIG1 = 1,
	MAX77693_HAPTIC_REG_CONFIG2 = 2,
	MAX77693_HAPTIC_REG_CONFIG_CHNL = 3,
	MAX77693_HAPTIC_REG_CONFG_CYC1 = 4,
	MAX77693_HAPTIC_REG_CONFG_CYC2 = 5,
	MAX77693_HAPTIC_REG_CONFIG_PER1 = 6,
	MAX77693_HAPTIC_REG_CONFIG_PER2 = 7,
	MAX77693_HAPTIC_REG_CONFIG_PER3 = 8,
	MAX77693_HAPTIC_REG_CONFIG_PER4 = 9,
	MAX77693_HAPTIC_REG_CONFIG_DUTY1 = 10,
	MAX77693_HAPTIC_REG_CONFIG_DUTY2 = 11,
	MAX77693_HAPTIC_REG_CONFIG_PWM1 = 12,
	MAX77693_HAPTIC_REG_CONFIG_PWM2 = 13,
	MAX77693_HAPTIC_REG_CONFIG_PWM3 = 14,
	MAX77693_HAPTIC_REG_CONFIG_PWM4 = 15,
	MAX77693_HAPTIC_REG_REV = 16,
	MAX77693_HAPTIC_REG_END = 17,
};

enum max77693_irq_muic {
	MAX77693_MUIC_IRQ_INT1_ADC = 0,
	MAX77693_MUIC_IRQ_INT1_ADC_LOW = 1,
	MAX77693_MUIC_IRQ_INT1_ADC_ERR = 2,
	MAX77693_MUIC_IRQ_INT1_ADC1K = 3,
	MAX77693_MUIC_IRQ_INT2_CHGTYP = 4,
	MAX77693_MUIC_IRQ_INT2_CHGDETREUN = 5,
	MAX77693_MUIC_IRQ_INT2_DCDTMR = 6,
	MAX77693_MUIC_IRQ_INT2_DXOVP = 7,
	MAX77693_MUIC_IRQ_INT2_VBVOLT = 8,
	MAX77693_MUIC_IRQ_INT2_VIDRM = 9,
	MAX77693_MUIC_IRQ_INT3_EOC = 10,
	MAX77693_MUIC_IRQ_INT3_CGMBC = 11,
	MAX77693_MUIC_IRQ_INT3_OVP = 12,
	MAX77693_MUIC_IRQ_INT3_MBCCHG_ERR = 13,
	MAX77693_MUIC_IRQ_INT3_CHG_ENABLED = 14,
	MAX77693_MUIC_IRQ_INT3_BAT_DET = 15,
	MAX77693_MUIC_IRQ_NR = 16,
};

enum max77693_muic_acc_type {
	MAX77693_MUIC_ADC_GROUND = 0,
	MAX77693_MUIC_ADC_SEND_END_BUTTON = 1,
	MAX77693_MUIC_ADC_REMOTE_S1_BUTTON = 2,
	MAX77693_MUIC_ADC_REMOTE_S2_BUTTON = 3,
	MAX77693_MUIC_ADC_REMOTE_S3_BUTTON = 4,
	MAX77693_MUIC_ADC_REMOTE_S4_BUTTON = 5,
	MAX77693_MUIC_ADC_REMOTE_S5_BUTTON = 6,
	MAX77693_MUIC_ADC_REMOTE_S6_BUTTON = 7,
	MAX77693_MUIC_ADC_REMOTE_S7_BUTTON = 8,
	MAX77693_MUIC_ADC_REMOTE_S8_BUTTON = 9,
	MAX77693_MUIC_ADC_REMOTE_S9_BUTTON = 10,
	MAX77693_MUIC_ADC_REMOTE_S10_BUTTON = 11,
	MAX77693_MUIC_ADC_REMOTE_S11_BUTTON = 12,
	MAX77693_MUIC_ADC_REMOTE_S12_BUTTON = 13,
	MAX77693_MUIC_ADC_RESERVED_ACC_1 = 14,
	MAX77693_MUIC_ADC_RESERVED_ACC_2 = 15,
	MAX77693_MUIC_ADC_RESERVED_ACC_3 = 16,
	MAX77693_MUIC_ADC_RESERVED_ACC_4 = 17,
	MAX77693_MUIC_ADC_RESERVED_ACC_5 = 18,
	MAX77693_MUIC_ADC_CEA936_AUDIO = 19,
	MAX77693_MUIC_ADC_PHONE_POWERED_DEV = 20,
	MAX77693_MUIC_ADC_TTY_CONVERTER = 21,
	MAX77693_MUIC_ADC_UART_CABLE = 22,
	MAX77693_MUIC_ADC_CEA936A_TYPE1_CHG = 23,
	MAX77693_MUIC_ADC_FACTORY_MODE_USB_OFF = 24,
	MAX77693_MUIC_ADC_FACTORY_MODE_USB_ON = 25,
	MAX77693_MUIC_ADC_AV_CABLE_NOLOAD = 26,
	MAX77693_MUIC_ADC_CEA936A_TYPE2_CHG = 27,
	MAX77693_MUIC_ADC_FACTORY_MODE_UART_OFF = 28,
	MAX77693_MUIC_ADC_FACTORY_MODE_UART_ON = 29,
	MAX77693_MUIC_ADC_AUDIO_MODE_REMOTE = 30,
	MAX77693_MUIC_ADC_OPEN = 31,
	MAX77693_MUIC_GND_USB_HOST = 256,
	MAX77693_MUIC_GND_USB_HOST_VB = 260,
	MAX77693_MUIC_GND_AV_CABLE_LOAD = 258,
	MAX77693_MUIC_GND_MHL = 259,
	MAX77693_MUIC_GND_MHL_VB = 263,
};

enum max77693_muic_adc_debounce_time {
	ADC_DEBOUNCE_TIME_5MS___2 = 0,
	ADC_DEBOUNCE_TIME_10MS___2 = 1,
	ADC_DEBOUNCE_TIME_25MS___2 = 2,
	ADC_DEBOUNCE_TIME_38_62MS___2 = 3,
};

enum max77693_muic_cable_group {
	MAX77693_CABLE_GROUP_ADC = 0,
	MAX77693_CABLE_GROUP_ADC_GND = 1,
	MAX77693_CABLE_GROUP_CHG = 2,
	MAX77693_CABLE_GROUP_VBVOLT = 3,
};

enum max77693_muic_charger_type {
	MAX77693_CHARGER_TYPE_NONE = 0,
	MAX77693_CHARGER_TYPE_USB = 1,
	MAX77693_CHARGER_TYPE_DOWNSTREAM_PORT = 2,
	MAX77693_CHARGER_TYPE_DEDICATED_CHG = 3,
	MAX77693_CHARGER_TYPE_APPLE_500MA = 4,
	MAX77693_CHARGER_TYPE_APPLE_1A_2A = 5,
	MAX77693_CHARGER_TYPE_DEAD_BATTERY = 7,
};

enum max77693_muic_reg {
	MAX77693_MUIC_REG_ID = 0,
	MAX77693_MUIC_REG_INT1 = 1,
	MAX77693_MUIC_REG_INT2 = 2,
	MAX77693_MUIC_REG_INT3 = 3,
	MAX77693_MUIC_REG_STATUS1 = 4,
	MAX77693_MUIC_REG_STATUS2 = 5,
	MAX77693_MUIC_REG_STATUS3 = 6,
	MAX77693_MUIC_REG_INTMASK1 = 7,
	MAX77693_MUIC_REG_INTMASK2 = 8,
	MAX77693_MUIC_REG_INTMASK3 = 9,
	MAX77693_MUIC_REG_CDETCTRL1 = 10,
	MAX77693_MUIC_REG_CDETCTRL2 = 11,
	MAX77693_MUIC_REG_CTRL1 = 12,
	MAX77693_MUIC_REG_CTRL2 = 13,
	MAX77693_MUIC_REG_CTRL3 = 14,
	MAX77693_MUIC_REG_END = 15,
};

enum max77693_pmic_reg {
	MAX77693_LED_REG_IFLASH1 = 0,
	MAX77693_LED_REG_IFLASH2 = 1,
	MAX77693_LED_REG_ITORCH = 2,
	MAX77693_LED_REG_ITORCHTIMER = 3,
	MAX77693_LED_REG_FLASH_TIMER = 4,
	MAX77693_LED_REG_FLASH_EN = 5,
	MAX77693_LED_REG_MAX_FLASH1 = 6,
	MAX77693_LED_REG_MAX_FLASH2 = 7,
	MAX77693_LED_REG_MAX_FLASH3 = 8,
	MAX77693_LED_REG_MAX_FLASH4 = 9,
	MAX77693_LED_REG_VOUT_CNTL = 10,
	MAX77693_LED_REG_VOUT_FLASH1 = 11,
	MAX77693_LED_REG_VOUT_FLASH2 = 12,
	MAX77693_LED_REG_FLASH_INT = 14,
	MAX77693_LED_REG_FLASH_INT_MASK = 15,
	MAX77693_LED_REG_FLASH_STATUS = 16,
	MAX77693_PMIC_REG_PMIC_ID1 = 32,
	MAX77693_PMIC_REG_PMIC_ID2 = 33,
	MAX77693_PMIC_REG_INTSRC = 34,
	MAX77693_PMIC_REG_INTSRC_MASK = 35,
	MAX77693_PMIC_REG_TOPSYS_INT = 36,
	MAX77693_PMIC_REG_TOPSYS_INT_MASK = 38,
	MAX77693_PMIC_REG_TOPSYS_STAT = 40,
	MAX77693_PMIC_REG_MAINCTRL1 = 42,
	MAX77693_PMIC_REG_LSCNFG = 43,
	MAX77693_CHG_REG_CHG_INT = 176,
	MAX77693_CHG_REG_CHG_INT_MASK = 177,
	MAX77693_CHG_REG_CHG_INT_OK = 178,
	MAX77693_CHG_REG_CHG_DETAILS_00 = 179,
	MAX77693_CHG_REG_CHG_DETAILS_01 = 180,
	MAX77693_CHG_REG_CHG_DETAILS_02 = 181,
	MAX77693_CHG_REG_CHG_DETAILS_03 = 182,
	MAX77693_CHG_REG_CHG_CNFG_00 = 183,
	MAX77693_CHG_REG_CHG_CNFG_01 = 184,
	MAX77693_CHG_REG_CHG_CNFG_02 = 185,
	MAX77693_CHG_REG_CHG_CNFG_03 = 186,
	MAX77693_CHG_REG_CHG_CNFG_04 = 187,
	MAX77693_CHG_REG_CHG_CNFG_05 = 188,
	MAX77693_CHG_REG_CHG_CNFG_06 = 189,
	MAX77693_CHG_REG_CHG_CNFG_07 = 190,
	MAX77693_CHG_REG_CHG_CNFG_08 = 191,
	MAX77693_CHG_REG_CHG_CNFG_09 = 192,
	MAX77693_CHG_REG_CHG_CNFG_10 = 193,
	MAX77693_CHG_REG_CHG_CNFG_11 = 194,
	MAX77693_CHG_REG_CHG_CNFG_12 = 195,
	MAX77693_CHG_REG_CHG_CNFG_13 = 196,
	MAX77693_CHG_REG_CHG_CNFG_14 = 197,
	MAX77693_CHG_REG_SAFEOUT_CTRL = 198,
	MAX77693_PMIC_REG_END = 199,
};

enum max77693_regulators {
	MAX77693_ESAFEOUT1 = 0,
	MAX77693_ESAFEOUT2 = 1,
	MAX77693_CHARGER = 2,
	MAX77693_REG_MAX = 3,
};

enum max77693_types {
	TYPE_MAX77693_UNKNOWN = 0,
	TYPE_MAX77693 = 1,
	TYPE_MAX77705 = 2,
	TYPE_MAX77843 = 3,
	TYPE_MAX77693_NUM = 4,
};

enum max77802_pmic_reg {
	MAX77802_REG_DEVICE_ID = 0,
	MAX77802_REG_INTSRC = 1,
	MAX77802_REG_INT1 = 2,
	MAX77802_REG_INT2 = 3,
	MAX77802_REG_INT1MSK = 4,
	MAX77802_REG_INT2MSK = 5,
	MAX77802_REG_STATUS1 = 6,
	MAX77802_REG_STATUS2 = 7,
	MAX77802_REG_PWRON = 8,
	MAX77802_REG_MRSTB = 10,
	MAX77802_REG_EPWRHOLD = 11,
	MAX77802_REG_BOOSTCTRL = 14,
	MAX77802_REG_BOOSTOUT = 15,
	MAX77802_REG_BUCK1CTRL = 16,
	MAX77802_REG_BUCK1DVS1 = 17,
	MAX77802_REG_BUCK1DVS2 = 18,
	MAX77802_REG_BUCK1DVS3 = 19,
	MAX77802_REG_BUCK1DVS4 = 20,
	MAX77802_REG_BUCK1DVS5 = 21,
	MAX77802_REG_BUCK1DVS6 = 22,
	MAX77802_REG_BUCK1DVS7 = 23,
	MAX77802_REG_BUCK1DVS8 = 24,
	MAX77802_REG_BUCK2CTRL1 = 26,
	MAX77802_REG_BUCK2CTRL2 = 27,
	MAX77802_REG_BUCK2PHTRAN = 28,
	MAX77802_REG_BUCK2DVS1 = 29,
	MAX77802_REG_BUCK2DVS2 = 30,
	MAX77802_REG_BUCK2DVS3 = 31,
	MAX77802_REG_BUCK2DVS4 = 32,
	MAX77802_REG_BUCK2DVS5 = 33,
	MAX77802_REG_BUCK2DVS6 = 34,
	MAX77802_REG_BUCK2DVS7 = 35,
	MAX77802_REG_BUCK2DVS8 = 36,
	MAX77802_REG_BUCK3CTRL1 = 39,
	MAX77802_REG_BUCK3DVS1 = 40,
	MAX77802_REG_BUCK3DVS2 = 41,
	MAX77802_REG_BUCK3DVS3 = 42,
	MAX77802_REG_BUCK3DVS4 = 43,
	MAX77802_REG_BUCK3DVS5 = 44,
	MAX77802_REG_BUCK3DVS6 = 45,
	MAX77802_REG_BUCK3DVS7 = 46,
	MAX77802_REG_BUCK3DVS8 = 47,
	MAX77802_REG_BUCK4CTRL1 = 55,
	MAX77802_REG_BUCK4DVS1 = 56,
	MAX77802_REG_BUCK4DVS2 = 57,
	MAX77802_REG_BUCK4DVS3 = 58,
	MAX77802_REG_BUCK4DVS4 = 59,
	MAX77802_REG_BUCK4DVS5 = 60,
	MAX77802_REG_BUCK4DVS6 = 61,
	MAX77802_REG_BUCK4DVS7 = 62,
	MAX77802_REG_BUCK4DVS8 = 63,
	MAX77802_REG_BUCK5CTRL = 65,
	MAX77802_REG_BUCK5OUT = 66,
	MAX77802_REG_BUCK6CTRL = 68,
	MAX77802_REG_BUCK6DVS1 = 69,
	MAX77802_REG_BUCK6DVS2 = 70,
	MAX77802_REG_BUCK6DVS3 = 71,
	MAX77802_REG_BUCK6DVS4 = 72,
	MAX77802_REG_BUCK6DVS5 = 73,
	MAX77802_REG_BUCK6DVS6 = 74,
	MAX77802_REG_BUCK6DVS7 = 75,
	MAX77802_REG_BUCK6DVS8 = 76,
	MAX77802_REG_BUCK7CTRL = 78,
	MAX77802_REG_BUCK7OUT = 79,
	MAX77802_REG_BUCK8CTRL = 81,
	MAX77802_REG_BUCK8OUT = 82,
	MAX77802_REG_BUCK9CTRL = 84,
	MAX77802_REG_BUCK9OUT = 85,
	MAX77802_REG_BUCK10CTRL = 87,
	MAX77802_REG_BUCK10OUT = 88,
	MAX77802_REG_LDO1CTRL1 = 96,
	MAX77802_REG_LDO2CTRL1 = 97,
	MAX77802_REG_LDO3CTRL1 = 98,
	MAX77802_REG_LDO4CTRL1 = 99,
	MAX77802_REG_LDO5CTRL1 = 100,
	MAX77802_REG_LDO6CTRL1 = 101,
	MAX77802_REG_LDO7CTRL1 = 102,
	MAX77802_REG_LDO8CTRL1 = 103,
	MAX77802_REG_LDO9CTRL1 = 104,
	MAX77802_REG_LDO10CTRL1 = 105,
	MAX77802_REG_LDO11CTRL1 = 106,
	MAX77802_REG_LDO12CTRL1 = 107,
	MAX77802_REG_LDO13CTRL1 = 108,
	MAX77802_REG_LDO14CTRL1 = 109,
	MAX77802_REG_LDO15CTRL1 = 110,
	MAX77802_REG_LDO17CTRL1 = 112,
	MAX77802_REG_LDO18CTRL1 = 113,
	MAX77802_REG_LDO19CTRL1 = 114,
	MAX77802_REG_LDO20CTRL1 = 115,
	MAX77802_REG_LDO21CTRL1 = 116,
	MAX77802_REG_LDO22CTRL1 = 117,
	MAX77802_REG_LDO23CTRL1 = 118,
	MAX77802_REG_LDO24CTRL1 = 119,
	MAX77802_REG_LDO25CTRL1 = 120,
	MAX77802_REG_LDO26CTRL1 = 121,
	MAX77802_REG_LDO27CTRL1 = 122,
	MAX77802_REG_LDO28CTRL1 = 123,
	MAX77802_REG_LDO29CTRL1 = 124,
	MAX77802_REG_LDO30CTRL1 = 125,
	MAX77802_REG_LDO32CTRL1 = 127,
	MAX77802_REG_LDO33CTRL1 = 128,
	MAX77802_REG_LDO34CTRL1 = 129,
	MAX77802_REG_LDO35CTRL1 = 130,
	MAX77802_REG_LDO1CTRL2 = 144,
	MAX77802_REG_LDO2CTRL2 = 145,
	MAX77802_REG_LDO3CTRL2 = 146,
	MAX77802_REG_LDO4CTRL2 = 147,
	MAX77802_REG_LDO5CTRL2 = 148,
	MAX77802_REG_LDO6CTRL2 = 149,
	MAX77802_REG_LDO7CTRL2 = 150,
	MAX77802_REG_LDO8CTRL2 = 151,
	MAX77802_REG_LDO9CTRL2 = 152,
	MAX77802_REG_LDO10CTRL2 = 153,
	MAX77802_REG_LDO11CTRL2 = 154,
	MAX77802_REG_LDO12CTRL2 = 155,
	MAX77802_REG_LDO13CTRL2 = 156,
	MAX77802_REG_LDO14CTRL2 = 157,
	MAX77802_REG_LDO15CTRL2 = 158,
	MAX77802_REG_LDO17CTRL2 = 160,
	MAX77802_REG_LDO18CTRL2 = 161,
	MAX77802_REG_LDO19CTRL2 = 162,
	MAX77802_REG_LDO20CTRL2 = 163,
	MAX77802_REG_LDO21CTRL2 = 164,
	MAX77802_REG_LDO22CTRL2 = 165,
	MAX77802_REG_LDO23CTRL2 = 166,
	MAX77802_REG_LDO24CTRL2 = 167,
	MAX77802_REG_LDO25CTRL2 = 168,
	MAX77802_REG_LDO26CTRL2 = 169,
	MAX77802_REG_LDO27CTRL2 = 170,
	MAX77802_REG_LDO28CTRL2 = 171,
	MAX77802_REG_LDO29CTRL2 = 172,
	MAX77802_REG_LDO30CTRL2 = 173,
	MAX77802_REG_LDO32CTRL2 = 175,
	MAX77802_REG_LDO33CTRL2 = 176,
	MAX77802_REG_LDO34CTRL2 = 177,
	MAX77802_REG_LDO35CTRL2 = 178,
	MAX77802_REG_BBAT_CHG = 180,
	MAX77802_REG_32KHZ = 181,
	MAX77802_REG_PMIC_END = 182,
};

enum max77802_regulators {
	MAX77802_BUCK1 = 0,
	MAX77802_BUCK2 = 1,
	MAX77802_BUCK3 = 2,
	MAX77802_BUCK4 = 3,
	MAX77802_BUCK5 = 4,
	MAX77802_BUCK6 = 5,
	MAX77802_BUCK7 = 6,
	MAX77802_BUCK8 = 7,
	MAX77802_BUCK9 = 8,
	MAX77802_BUCK10 = 9,
	MAX77802_LDO1 = 10,
	MAX77802_LDO2 = 11,
	MAX77802_LDO3 = 12,
	MAX77802_LDO4 = 13,
	MAX77802_LDO5 = 14,
	MAX77802_LDO6 = 15,
	MAX77802_LDO7 = 16,
	MAX77802_LDO8 = 17,
	MAX77802_LDO9 = 18,
	MAX77802_LDO10 = 19,
	MAX77802_LDO11 = 20,
	MAX77802_LDO12 = 21,
	MAX77802_LDO13 = 22,
	MAX77802_LDO14 = 23,
	MAX77802_LDO15 = 24,
	MAX77802_LDO17 = 25,
	MAX77802_LDO18 = 26,
	MAX77802_LDO19 = 27,
	MAX77802_LDO20 = 28,
	MAX77802_LDO21 = 29,
	MAX77802_LDO23 = 30,
	MAX77802_LDO24 = 31,
	MAX77802_LDO25 = 32,
	MAX77802_LDO26 = 33,
	MAX77802_LDO27 = 34,
	MAX77802_LDO28 = 35,
	MAX77802_LDO29 = 36,
	MAX77802_LDO30 = 37,
	MAX77802_LDO32 = 38,
	MAX77802_LDO33 = 39,
	MAX77802_LDO34 = 40,
	MAX77802_LDO35 = 41,
	MAX77802_REG_MAX = 42,
};

enum max77802_rtc_reg {
	MAX77802_RTC_INT = 192,
	MAX77802_RTC_INTM = 193,
	MAX77802_RTC_CONTROLM = 194,
	MAX77802_RTC_CONTROL = 195,
	MAX77802_RTC_UPDATE0 = 196,
	MAX77802_RTC_UPDATE1 = 197,
	MAX77802_WTSR_SMPL_CNTL = 198,
	MAX77802_RTC_SEC = 199,
	MAX77802_RTC_MIN = 200,
	MAX77802_RTC_HOUR = 201,
	MAX77802_RTC_WEEKDAY = 202,
	MAX77802_RTC_MONTH = 203,
	MAX77802_RTC_YEAR = 204,
	MAX77802_RTC_MONTHDAY = 205,
	MAX77802_RTC_AE1 = 206,
	MAX77802_ALARM1_SEC = 207,
	MAX77802_ALARM1_MIN = 208,
	MAX77802_ALARM1_HOUR = 209,
	MAX77802_ALARM1_WEEKDAY = 210,
	MAX77802_ALARM1_MONTH = 211,
	MAX77802_ALARM1_YEAR = 212,
	MAX77802_ALARM1_DATE = 213,
	MAX77802_RTC_AE2 = 214,
	MAX77802_ALARM2_SEC = 215,
	MAX77802_ALARM2_MIN = 216,
	MAX77802_ALARM2_HOUR = 217,
	MAX77802_ALARM2_WEEKDAY = 218,
	MAX77802_ALARM2_MONTH = 219,
	MAX77802_ALARM2_YEAR = 220,
	MAX77802_ALARM2_DATE = 221,
	MAX77802_RTC_END = 223,
};

enum max77836_fg_reg {
	MAX77836_FG_REG_VCELL_MSB = 2,
	MAX77836_FG_REG_VCELL_LSB = 3,
	MAX77836_FG_REG_SOC_MSB = 4,
	MAX77836_FG_REG_SOC_LSB = 5,
	MAX77836_FG_REG_MODE_H = 6,
	MAX77836_FG_REG_MODE_L = 7,
	MAX77836_FG_REG_VERSION_MSB = 8,
	MAX77836_FG_REG_VERSION_LSB = 9,
	MAX77836_FG_REG_HIBRT_H = 10,
	MAX77836_FG_REG_HIBRT_L = 11,
	MAX77836_FG_REG_CONFIG_H = 12,
	MAX77836_FG_REG_CONFIG_L = 13,
	MAX77836_FG_REG_VALRT_MIN = 20,
	MAX77836_FG_REG_VALRT_MAX = 21,
	MAX77836_FG_REG_CRATE_MSB = 22,
	MAX77836_FG_REG_CRATE_LSB = 23,
	MAX77836_FG_REG_VRESET = 24,
	MAX77836_FG_REG_FGID = 25,
	MAX77836_FG_REG_STATUS_H = 26,
	MAX77836_FG_REG_STATUS_L = 27,
	MAX77836_FG_REG_END = 28,
};

enum max77836_pmic_reg {
	MAX77836_PMIC_REG_PMIC_ID = 32,
	MAX77836_PMIC_REG_PMIC_REV = 33,
	MAX77836_PMIC_REG_INTSRC = 34,
	MAX77836_PMIC_REG_INTSRC_MASK = 35,
	MAX77836_PMIC_REG_TOPSYS_INT = 36,
	MAX77836_PMIC_REG_TOPSYS_INT_MASK = 38,
	MAX77836_PMIC_REG_TOPSYS_STAT = 40,
	MAX77836_PMIC_REG_MRSTB_CNTL = 42,
	MAX77836_PMIC_REG_LSCNFG = 43,
	MAX77836_LDO_REG_CNFG1_LDO1 = 81,
	MAX77836_LDO_REG_CNFG2_LDO1 = 82,
	MAX77836_LDO_REG_CNFG1_LDO2 = 83,
	MAX77836_LDO_REG_CNFG2_LDO2 = 84,
	MAX77836_LDO_REG_CNFG_LDO_BIAS = 85,
	MAX77836_COMP_REG_COMP1 = 96,
	MAX77836_PMIC_REG_END = 97,
};

enum max77836_regulators {
	MAX77836_SAFEOUT = 0,
	MAX77836_CHARGER = 1,
	MAX77836_LDO1 = 2,
	MAX77836_LDO2 = 3,
	MAX77836_REGULATOR_NUM = 4,
};

enum max77843_charger_reg {
	MAX77843_CHG_REG_CHG_INT = 176,
	MAX77843_CHG_REG_CHG_INT_MASK = 177,
	MAX77843_CHG_REG_CHG_INT_OK = 178,
	MAX77843_CHG_REG_CHG_DTLS_00 = 179,
	MAX77843_CHG_REG_CHG_DTLS_01 = 180,
	MAX77843_CHG_REG_CHG_DTLS_02 = 181,
	MAX77843_CHG_REG_CHG_CNFG_00 = 183,
	MAX77843_CHG_REG_CHG_CNFG_01 = 184,
	MAX77843_CHG_REG_CHG_CNFG_02 = 185,
	MAX77843_CHG_REG_CHG_CNFG_03 = 186,
	MAX77843_CHG_REG_CHG_CNFG_04 = 187,
	MAX77843_CHG_REG_CHG_CNFG_06 = 189,
	MAX77843_CHG_REG_CHG_CNFG_07 = 190,
	MAX77843_CHG_REG_CHG_CNFG_09 = 192,
	MAX77843_CHG_REG_CHG_CNFG_10 = 193,
	MAX77843_CHG_REG_CHG_CNFG_11 = 194,
	MAX77843_CHG_REG_CHG_CNFG_12 = 195,
	MAX77843_CHG_REG_END = 196,
};

enum max77843_regulator_type {
	MAX77843_SAFEOUT1 = 0,
	MAX77843_SAFEOUT2 = 1,
	MAX77843_CHARGER = 2,
	MAX77843_NUM = 3,
};

enum max77843_sys_reg {
	MAX77843_SYS_REG_PMICID = 0,
	MAX77843_SYS_REG_PMICREV = 1,
	MAX77843_SYS_REG_MAINCTRL1 = 2,
	MAX77843_SYS_REG_INTSRC = 34,
	MAX77843_SYS_REG_INTSRCMASK = 35,
	MAX77843_SYS_REG_SYSINTSRC = 36,
	MAX77843_SYS_REG_SYSINTMASK = 38,
	MAX77843_SYS_REG_TOPSYS_STAT = 40,
	MAX77843_SYS_REG_SAFEOUTCTRL = 198,
	MAX77843_SYS_REG_END = 199,
};

enum max8997_haptic_motor_type {
	MAX8997_HAPTIC_ERM = 0,
	MAX8997_HAPTIC_LRA = 1,
};

enum max8997_haptic_pulse_mode {
	MAX8997_EXTERNAL_MODE = 0,
	MAX8997_INTERNAL_MODE = 1,
};

enum max8997_haptic_pwm_divisor {
	MAX8997_PWM_DIVISOR_32 = 0,
	MAX8997_PWM_DIVISOR_64 = 1,
	MAX8997_PWM_DIVISOR_128 = 2,
	MAX8997_PWM_DIVISOR_256 = 3,
};

enum max8997_haptic_reg {
	MAX8997_HAPTIC_REG_GENERAL = 0,
	MAX8997_HAPTIC_REG_CONF1 = 1,
	MAX8997_HAPTIC_REG_CONF2 = 2,
	MAX8997_HAPTIC_REG_DRVCONF = 3,
	MAX8997_HAPTIC_REG_CYCLECONF1 = 4,
	MAX8997_HAPTIC_REG_CYCLECONF2 = 5,
	MAX8997_HAPTIC_REG_SIGCONF1 = 6,
	MAX8997_HAPTIC_REG_SIGCONF2 = 7,
	MAX8997_HAPTIC_REG_SIGCONF3 = 8,
	MAX8997_HAPTIC_REG_SIGCONF4 = 9,
	MAX8997_HAPTIC_REG_SIGDC1 = 10,
	MAX8997_HAPTIC_REG_SIGDC2 = 11,
	MAX8997_HAPTIC_REG_SIGPWMDC1 = 12,
	MAX8997_HAPTIC_REG_SIGPWMDC2 = 13,
	MAX8997_HAPTIC_REG_SIGPWMDC3 = 14,
	MAX8997_HAPTIC_REG_SIGPWMDC4 = 15,
	MAX8997_HAPTIC_REG_MTR_REV = 16,
	MAX8997_HAPTIC_REG_END = 17,
};

enum max8997_irq {
	MAX8997_PMICIRQ_PWRONR = 0,
	MAX8997_PMICIRQ_PWRONF = 1,
	MAX8997_PMICIRQ_PWRON1SEC = 2,
	MAX8997_PMICIRQ_JIGONR = 3,
	MAX8997_PMICIRQ_JIGONF = 4,
	MAX8997_PMICIRQ_LOWBAT2 = 5,
	MAX8997_PMICIRQ_LOWBAT1 = 6,
	MAX8997_PMICIRQ_JIGR = 7,
	MAX8997_PMICIRQ_JIGF = 8,
	MAX8997_PMICIRQ_MR = 9,
	MAX8997_PMICIRQ_DVS1OK = 10,
	MAX8997_PMICIRQ_DVS2OK = 11,
	MAX8997_PMICIRQ_DVS3OK = 12,
	MAX8997_PMICIRQ_DVS4OK = 13,
	MAX8997_PMICIRQ_CHGINS = 14,
	MAX8997_PMICIRQ_CHGRM = 15,
	MAX8997_PMICIRQ_DCINOVP = 16,
	MAX8997_PMICIRQ_TOPOFFR = 17,
	MAX8997_PMICIRQ_CHGRSTF = 18,
	MAX8997_PMICIRQ_MBCHGTMEXPD = 19,
	MAX8997_PMICIRQ_RTC60S = 20,
	MAX8997_PMICIRQ_RTCA1 = 21,
	MAX8997_PMICIRQ_RTCA2 = 22,
	MAX8997_PMICIRQ_SMPL_INT = 23,
	MAX8997_PMICIRQ_RTC1S = 24,
	MAX8997_PMICIRQ_WTSR = 25,
	MAX8997_MUICIRQ_ADCError = 26,
	MAX8997_MUICIRQ_ADCLow = 27,
	MAX8997_MUICIRQ_ADC = 28,
	MAX8997_MUICIRQ_VBVolt = 29,
	MAX8997_MUICIRQ_DBChg = 30,
	MAX8997_MUICIRQ_DCDTmr = 31,
	MAX8997_MUICIRQ_ChgDetRun = 32,
	MAX8997_MUICIRQ_ChgTyp = 33,
	MAX8997_MUICIRQ_OVP = 34,
	MAX8997_IRQ_NR = 35,
};

enum max8997_irq_source {
	PMIC_INT1___2 = 0,
	PMIC_INT2___2 = 1,
	PMIC_INT3 = 2,
	PMIC_INT4 = 3,
	FUEL_GAUGE = 4,
	MUIC_INT1 = 5,
	MUIC_INT2 = 6,
	MUIC_INT3 = 7,
	GPIO_LOW = 8,
	GPIO_HI = 9,
	FLASH_STATUS = 10,
	MAX8997_IRQ_GROUP_NR = 11,
};

enum max8997_led_mode {
	MAX8997_NONE = 0,
	MAX8997_FLASH_MODE = 1,
	MAX8997_MOVIE_MODE = 2,
	MAX8997_FLASH_PIN_CONTROL_MODE = 3,
	MAX8997_MOVIE_PIN_CONTROL_MODE = 4,
};

enum max8997_muic_acc_type {
	MAX8997_MUIC_ADC_GROUND = 0,
	MAX8997_MUIC_ADC_MHL = 1,
	MAX8997_MUIC_ADC_REMOTE_S1_BUTTON = 2,
	MAX8997_MUIC_ADC_REMOTE_S2_BUTTON = 3,
	MAX8997_MUIC_ADC_REMOTE_S3_BUTTON = 4,
	MAX8997_MUIC_ADC_REMOTE_S4_BUTTON = 5,
	MAX8997_MUIC_ADC_REMOTE_S5_BUTTON = 6,
	MAX8997_MUIC_ADC_REMOTE_S6_BUTTON = 7,
	MAX8997_MUIC_ADC_REMOTE_S7_BUTTON = 8,
	MAX8997_MUIC_ADC_REMOTE_S8_BUTTON = 9,
	MAX8997_MUIC_ADC_REMOTE_S9_BUTTON = 10,
	MAX8997_MUIC_ADC_REMOTE_S10_BUTTON = 11,
	MAX8997_MUIC_ADC_REMOTE_S11_BUTTON = 12,
	MAX8997_MUIC_ADC_REMOTE_S12_BUTTON = 13,
	MAX8997_MUIC_ADC_RESERVED_ACC_1 = 14,
	MAX8997_MUIC_ADC_RESERVED_ACC_2 = 15,
	MAX8997_MUIC_ADC_RESERVED_ACC_3 = 16,
	MAX8997_MUIC_ADC_RESERVED_ACC_4 = 17,
	MAX8997_MUIC_ADC_RESERVED_ACC_5 = 18,
	MAX8997_MUIC_ADC_CEA936_AUDIO = 19,
	MAX8997_MUIC_ADC_PHONE_POWERED_DEV = 20,
	MAX8997_MUIC_ADC_TTY_CONVERTER = 21,
	MAX8997_MUIC_ADC_UART_CABLE = 22,
	MAX8997_MUIC_ADC_CEA936A_TYPE1_CHG = 23,
	MAX8997_MUIC_ADC_FACTORY_MODE_USB_OFF = 24,
	MAX8997_MUIC_ADC_FACTORY_MODE_USB_ON = 25,
	MAX8997_MUIC_ADC_AV_CABLE_NOLOAD = 26,
	MAX8997_MUIC_ADC_CEA936A_TYPE2_CHG = 27,
	MAX8997_MUIC_ADC_FACTORY_MODE_UART_OFF = 28,
	MAX8997_MUIC_ADC_FACTORY_MODE_UART_ON = 29,
	MAX8997_MUIC_ADC_AUDIO_MODE_REMOTE = 30,
	MAX8997_MUIC_ADC_OPEN = 31,
};

enum max8997_muic_adc_debounce_time {
	ADC_DEBOUNCE_TIME_0_5MS = 0,
	ADC_DEBOUNCE_TIME_10MS___3 = 1,
	ADC_DEBOUNCE_TIME_25MS___3 = 2,
	ADC_DEBOUNCE_TIME_38_62MS___3 = 3,
};

enum max8997_muic_cable_group {
	MAX8997_CABLE_GROUP_ADC = 0,
	MAX8997_CABLE_GROUP_ADC_GND = 1,
	MAX8997_CABLE_GROUP_CHG = 2,
	MAX8997_CABLE_GROUP_VBVOLT = 3,
};

enum max8997_muic_charger_type {
	MAX8997_CHARGER_TYPE_NONE = 0,
	MAX8997_CHARGER_TYPE_USB = 1,
	MAX8997_CHARGER_TYPE_DOWNSTREAM_PORT = 2,
	MAX8997_CHARGER_TYPE_DEDICATED_CHG = 3,
	MAX8997_CHARGER_TYPE_500MA = 4,
	MAX8997_CHARGER_TYPE_1A = 5,
	MAX8997_CHARGER_TYPE_DEAD_BATTERY = 7,
};

enum max8997_muic_reg {
	MAX8997_MUIC_REG_ID = 0,
	MAX8997_MUIC_REG_INT1 = 1,
	MAX8997_MUIC_REG_INT2 = 2,
	MAX8997_MUIC_REG_INT3 = 3,
	MAX8997_MUIC_REG_STATUS1 = 4,
	MAX8997_MUIC_REG_STATUS2 = 5,
	MAX8997_MUIC_REG_STATUS3 = 6,
	MAX8997_MUIC_REG_INTMASK1 = 7,
	MAX8997_MUIC_REG_INTMASK2 = 8,
	MAX8997_MUIC_REG_INTMASK3 = 9,
	MAX8997_MUIC_REG_CDETCTRL = 10,
	MAX8997_MUIC_REG_CONTROL1 = 12,
	MAX8997_MUIC_REG_CONTROL2 = 13,
	MAX8997_MUIC_REG_CONTROL3 = 14,
	MAX8997_MUIC_REG_END = 15,
};

enum max8997_muic_usb_type {
	MAX8997_USB_HOST = 0,
	MAX8997_USB_DEVICE = 1,
};

enum max8997_pmic_reg {
	MAX8997_REG_PMIC_ID0 = 0,
	MAX8997_REG_PMIC_ID1 = 1,
	MAX8997_REG_INTSRC = 2,
	MAX8997_REG_INT1 = 3,
	MAX8997_REG_INT2 = 4,
	MAX8997_REG_INT3 = 5,
	MAX8997_REG_INT4 = 6,
	MAX8997_REG_INT1MSK = 8,
	MAX8997_REG_INT2MSK = 9,
	MAX8997_REG_INT3MSK = 10,
	MAX8997_REG_INT4MSK = 11,
	MAX8997_REG_STATUS1 = 13,
	MAX8997_REG_STATUS2 = 14,
	MAX8997_REG_STATUS3 = 15,
	MAX8997_REG_STATUS4 = 16,
	MAX8997_REG_MAINCON1 = 19,
	MAX8997_REG_MAINCON2 = 20,
	MAX8997_REG_BUCKRAMP = 21,
	MAX8997_REG_BUCK1CTRL = 24,
	MAX8997_REG_BUCK1DVS1 = 25,
	MAX8997_REG_BUCK1DVS2 = 26,
	MAX8997_REG_BUCK1DVS3 = 27,
	MAX8997_REG_BUCK1DVS4 = 28,
	MAX8997_REG_BUCK1DVS5 = 29,
	MAX8997_REG_BUCK1DVS6 = 30,
	MAX8997_REG_BUCK1DVS7 = 31,
	MAX8997_REG_BUCK1DVS8 = 32,
	MAX8997_REG_BUCK2CTRL = 33,
	MAX8997_REG_BUCK2DVS1 = 34,
	MAX8997_REG_BUCK2DVS2 = 35,
	MAX8997_REG_BUCK2DVS3 = 36,
	MAX8997_REG_BUCK2DVS4 = 37,
	MAX8997_REG_BUCK2DVS5 = 38,
	MAX8997_REG_BUCK2DVS6 = 39,
	MAX8997_REG_BUCK2DVS7 = 40,
	MAX8997_REG_BUCK2DVS8 = 41,
	MAX8997_REG_BUCK3CTRL = 42,
	MAX8997_REG_BUCK3DVS = 43,
	MAX8997_REG_BUCK4CTRL = 44,
	MAX8997_REG_BUCK4DVS = 45,
	MAX8997_REG_BUCK5CTRL = 46,
	MAX8997_REG_BUCK5DVS1 = 47,
	MAX8997_REG_BUCK5DVS2 = 48,
	MAX8997_REG_BUCK5DVS3 = 49,
	MAX8997_REG_BUCK5DVS4 = 50,
	MAX8997_REG_BUCK5DVS5 = 51,
	MAX8997_REG_BUCK5DVS6 = 52,
	MAX8997_REG_BUCK5DVS7 = 53,
	MAX8997_REG_BUCK5DVS8 = 54,
	MAX8997_REG_BUCK6CTRL = 55,
	MAX8997_REG_BUCK6BPSKIPCTRL = 56,
	MAX8997_REG_BUCK7CTRL = 57,
	MAX8997_REG_BUCK7DVS = 58,
	MAX8997_REG_LDO1CTRL = 59,
	MAX8997_REG_LDO2CTRL = 60,
	MAX8997_REG_LDO3CTRL = 61,
	MAX8997_REG_LDO4CTRL = 62,
	MAX8997_REG_LDO5CTRL = 63,
	MAX8997_REG_LDO6CTRL = 64,
	MAX8997_REG_LDO7CTRL = 65,
	MAX8997_REG_LDO8CTRL = 66,
	MAX8997_REG_LDO9CTRL = 67,
	MAX8997_REG_LDO10CTRL = 68,
	MAX8997_REG_LDO11CTRL = 69,
	MAX8997_REG_LDO12CTRL = 70,
	MAX8997_REG_LDO13CTRL = 71,
	MAX8997_REG_LDO14CTRL = 72,
	MAX8997_REG_LDO15CTRL = 73,
	MAX8997_REG_LDO16CTRL = 74,
	MAX8997_REG_LDO17CTRL = 75,
	MAX8997_REG_LDO18CTRL = 76,
	MAX8997_REG_LDO21CTRL = 77,
	MAX8997_REG_MBCCTRL1 = 80,
	MAX8997_REG_MBCCTRL2 = 81,
	MAX8997_REG_MBCCTRL3 = 82,
	MAX8997_REG_MBCCTRL4 = 83,
	MAX8997_REG_MBCCTRL5 = 84,
	MAX8997_REG_MBCCTRL6 = 85,
	MAX8997_REG_OTPCGHCVS = 86,
	MAX8997_REG_SAFEOUTCTRL = 90,
	MAX8997_REG_LBCNFG1 = 94,
	MAX8997_REG_LBCNFG2 = 95,
	MAX8997_REG_BBCCTRL = 96,
	MAX8997_REG_FLASH1_CUR = 99,
	MAX8997_REG_FLASH2_CUR = 100,
	MAX8997_REG_MOVIE_CUR = 101,
	MAX8997_REG_GSMB_CUR = 102,
	MAX8997_REG_BOOST_CNTL = 103,
	MAX8997_REG_LEN_CNTL = 104,
	MAX8997_REG_FLASH_CNTL = 105,
	MAX8997_REG_WDT_CNTL = 106,
	MAX8997_REG_MAXFLASH1 = 107,
	MAX8997_REG_MAXFLASH2 = 108,
	MAX8997_REG_FLASHSTATUS = 109,
	MAX8997_REG_FLASHSTATUSMASK = 110,
	MAX8997_REG_GPIOCNTL1 = 112,
	MAX8997_REG_GPIOCNTL2 = 113,
	MAX8997_REG_GPIOCNTL3 = 114,
	MAX8997_REG_GPIOCNTL4 = 115,
	MAX8997_REG_GPIOCNTL5 = 116,
	MAX8997_REG_GPIOCNTL6 = 117,
	MAX8997_REG_GPIOCNTL7 = 118,
	MAX8997_REG_GPIOCNTL8 = 119,
	MAX8997_REG_GPIOCNTL9 = 120,
	MAX8997_REG_GPIOCNTL10 = 121,
	MAX8997_REG_GPIOCNTL11 = 122,
	MAX8997_REG_GPIOCNTL12 = 123,
	MAX8997_REG_LDO1CONFIG = 128,
	MAX8997_REG_LDO2CONFIG = 129,
	MAX8997_REG_LDO3CONFIG = 130,
	MAX8997_REG_LDO4CONFIG = 131,
	MAX8997_REG_LDO5CONFIG = 132,
	MAX8997_REG_LDO6CONFIG = 133,
	MAX8997_REG_LDO7CONFIG = 134,
	MAX8997_REG_LDO8CONFIG = 135,
	MAX8997_REG_LDO9CONFIG = 136,
	MAX8997_REG_LDO10CONFIG = 137,
	MAX8997_REG_LDO11CONFIG = 138,
	MAX8997_REG_LDO12CONFIG = 139,
	MAX8997_REG_LDO13CONFIG = 140,
	MAX8997_REG_LDO14CONFIG = 141,
	MAX8997_REG_LDO15CONFIG = 142,
	MAX8997_REG_LDO16CONFIG = 143,
	MAX8997_REG_LDO17CONFIG = 144,
	MAX8997_REG_LDO18CONFIG = 145,
	MAX8997_REG_LDO21CONFIG = 146,
	MAX8997_REG_DVSOKTIMER1 = 151,
	MAX8997_REG_DVSOKTIMER2 = 152,
	MAX8997_REG_DVSOKTIMER4 = 153,
	MAX8997_REG_DVSOKTIMER5 = 154,
	MAX8997_REG_PMIC_END = 155,
};

enum max8997_regulators {
	MAX8997_LDO1 = 0,
	MAX8997_LDO2 = 1,
	MAX8997_LDO3 = 2,
	MAX8997_LDO4 = 3,
	MAX8997_LDO5 = 4,
	MAX8997_LDO6 = 5,
	MAX8997_LDO7 = 6,
	MAX8997_LDO8 = 7,
	MAX8997_LDO9 = 8,
	MAX8997_LDO10 = 9,
	MAX8997_LDO11 = 10,
	MAX8997_LDO12 = 11,
	MAX8997_LDO13 = 12,
	MAX8997_LDO14 = 13,
	MAX8997_LDO15 = 14,
	MAX8997_LDO16 = 15,
	MAX8997_LDO17 = 16,
	MAX8997_LDO18 = 17,
	MAX8997_LDO21 = 18,
	MAX8997_BUCK1 = 19,
	MAX8997_BUCK2 = 20,
	MAX8997_BUCK3 = 21,
	MAX8997_BUCK4 = 22,
	MAX8997_BUCK5 = 23,
	MAX8997_BUCK6 = 24,
	MAX8997_BUCK7 = 25,
	MAX8997_EN32KHZ_AP = 26,
	MAX8997_EN32KHZ_CP = 27,
	MAX8997_ENVICHG = 28,
	MAX8997_ESAFEOUT1 = 29,
	MAX8997_ESAFEOUT2 = 30,
	MAX8997_CHARGER_CV = 31,
	MAX8997_CHARGER = 32,
	MAX8997_CHARGER_TOPOFF = 33,
	MAX8997_REG_MAX = 34,
};

enum max8997_types {
	TYPE_MAX8997 = 0,
	TYPE_MAX8966 = 1,
};

enum maxim_device_type {
	MAXIM_DEVICE_TYPE_UNKNOWN = 0,
	MAXIM_DEVICE_TYPE_MAX14577 = 1,
	MAXIM_DEVICE_TYPE_MAX77836 = 2,
	MAXIM_DEVICE_TYPE_NUM = 3,
};

enum mc13783_ssi_port {
	MC13783_SSI1_PORT = 0,
	MC13783_SSI2_PORT = 1,
};

enum mctrl_gpio_idx {
	UART_GPIO_CTS = 0,
	UART_GPIO_DSR = 1,
	UART_GPIO_DCD = 2,
	UART_GPIO_RNG = 3,
	UART_GPIO_RI = 3,
	UART_GPIO_RTS = 4,
	UART_GPIO_DTR = 5,
	UART_GPIO_MAX = 6,
};

enum mdp4_cursor_format {
	CURSOR_ARGB = 1,
	CURSOR_XRGB = 2,
};

enum mdp4_dma {
	DMA_P = 0,
	DMA_S = 1,
	DMA_E = 2,
};

enum mdp4_frame_format {
	FRAME_LINEAR = 0,
	FRAME_TILE_ARGB_4X4 = 1,
	FRAME_TILE_YCBCR_420 = 2,
};

enum mdp4_intf {
	INTF_LCDC_DTV = 0,
	INTF_DSI_VIDEO = 1,
	INTF_DSI_CMD = 2,
	INTF_EBI2_TV = 3,
};

enum mdp4_pipe {
	VG1 = 0,
	VG2 = 1,
	RGB1 = 2,
	RGB2 = 3,
	RGB3 = 4,
	VG3 = 5,
	VG4 = 6,
};

enum mdp4_scale_unit {
	SCALE_FIR = 0,
	SCALE_MN_PHASE = 1,
	SCALE_PIXEL_RPT = 2,
};

enum mdp5_ctl_mode {
	MODE_NONE = 0,
	MODE_WB_0_BLOCK = 1,
	MODE_WB_1_BLOCK = 2,
	MODE_WB_0_LINE = 3,
	MODE_WB_1_LINE = 4,
	MODE_WB_2_LINE = 5,
};

enum mdp5_cursor_alpha {
	CURSOR_ALPHA_CONST = 0,
	CURSOR_ALPHA_PER_PIXEL = 2,
};

enum mdp5_cursor_format {
	CURSOR_FMT_ARGB8888 = 0,
	CURSOR_FMT_ARGB1555 = 2,
	CURSOR_FMT_ARGB4444 = 4,
};

enum mdp5_data_format {
	DATA_FORMAT_RGB = 0,
	DATA_FORMAT_YUV = 1,
};

enum mdp5_intf_mode {
	MDP5_INTF_MODE_NONE = 0,
	MDP5_INTF_DSI_MODE_VIDEO = 1,
	MDP5_INTF_DSI_MODE_COMMAND = 2,
	MDP5_INTF_WB_MODE_BLOCK = 3,
	MDP5_INTF_WB_MODE_LINE = 4,
};

enum mdp5_intf_type {
	INTF_DISABLED = 0,
	INTF_DSI___2 = 1,
	INTF_HDMI___2 = 3,
	INTF_LCDC___2 = 5,
	INTF_eDP = 9,
	INTF_VIRTUAL = 100,
	INTF_WB___2 = 101,
};

enum mdp5_intfnum {
	NO_INTF = 0,
	INTF0 = 1,
	INTF1 = 2,
	INTF2 = 3,
	INTF3 = 4,
};

enum mdp5_pack_3d {
	PACK_3D_FRAME_INT = 0,
	PACK_3D_H_ROW_INT = 1,
	PACK_3D_V_ROW_INT = 2,
	PACK_3D_COL_INT = 3,
};

enum mdp5_pipe {
	SSPP_NONE___2 = 0,
	SSPP_VIG0___2 = 1,
	SSPP_VIG1___2 = 2,
	SSPP_VIG2___2 = 3,
	SSPP_RGB0___2 = 4,
	SSPP_RGB1___2 = 5,
	SSPP_RGB2___2 = 6,
	SSPP_DMA0___2 = 7,
	SSPP_DMA1___2 = 8,
	SSPP_VIG3___2 = 9,
	SSPP_RGB3___2 = 10,
	SSPP_CURSOR0___2 = 11,
	SSPP_CURSOR1___2 = 12,
};

enum mdp5_pipe_bwc {
	BWC_LOSSLESS = 0,
	BWC_Q_HIGH = 1,
	BWC_Q_MED = 2,
};

enum mdp5_scale_filter {
	SCALE_FILTER_NEAREST = 0,
	SCALE_FILTER_BIL = 1,
	SCALE_FILTER_PCMN = 2,
	SCALE_FILTER_CA = 3,
};

enum mdp_alpha_type {
	FG_CONST = 0,
	BG_CONST = 1,
	FG_PIXEL = 2,
	BG_PIXEL = 3,
};

enum mdp_bpc {
	BPC4 = 0,
	BPC5 = 1,
	BPC6 = 2,
	BPC8 = 3,
};

enum mdp_bpc_alpha {
	BPC1A = 0,
	BPC4A = 1,
	BPC6A = 2,
	BPC8A = 3,
};

enum mdp_chroma_samp_type {
	CHROMA_FULL = 0,
	CHROMA_H2V1 = 1,
	CHROMA_H1V2 = 2,
	CHROMA_420 = 3,
};

enum mdp_component_type {
	COMP_0 = 0,
	COMP_1_2 = 1,
	COMP_3 = 2,
	COMP_MAX = 3,
};

enum mdp_fetch_mode {
	MDP_FETCH_LINEAR = 0,
	MDP_FETCH_TILE = 1,
	MDP_FETCH_UBWC = 2,
};

enum mdp_fetch_type {
	MDP_PLANE_INTERLEAVED = 0,
	MDP_PLANE_PLANAR = 1,
	MDP_PLANE_PSEUDO_PLANAR = 2,
};

enum mdp_mixer_stage_id {
	STAGE_UNUSED = 0,
	STAGE_BASE = 1,
	STAGE0 = 2,
	STAGE1 = 3,
	STAGE2 = 4,
	STAGE3 = 5,
	STAGE4 = 6,
	STAGE5 = 7,
	STAGE6 = 8,
	STAGE_MAX = 8,
};

enum media_entity_type {
	MEDIA_ENTITY_TYPE_BASE = 0,
	MEDIA_ENTITY_TYPE_VIDEO_DEVICE = 1,
	MEDIA_ENTITY_TYPE_V4L2_SUBDEV = 2,
};

enum media_gobj_type {
	MEDIA_GRAPH_ENTITY = 0,
	MEDIA_GRAPH_PAD = 1,
	MEDIA_GRAPH_LINK = 2,
	MEDIA_GRAPH_INTF_DEVNODE = 3,
};

enum media_pad_signal_type {
	PAD_SIGNAL_DEFAULT = 0,
	PAD_SIGNAL_ANALOG = 1,
	PAD_SIGNAL_DV = 2,
	PAD_SIGNAL_AUDIO = 3,
};

enum media_request_state {
	MEDIA_REQUEST_STATE_IDLE = 0,
	MEDIA_REQUEST_STATE_VALIDATING = 1,
	MEDIA_REQUEST_STATE_QUEUED = 2,
	MEDIA_REQUEST_STATE_COMPLETE = 3,
	MEDIA_REQUEST_STATE_CLEANING = 4,
	MEDIA_REQUEST_STATE_UPDATING = 5,
	NR_OF_MEDIA_REQUEST_STATE = 6,
};

enum mem_type {
	FREE_NIDS = 0,
	NAT_ENTRIES = 1,
	DIRTY_DENTS = 2,
	INO_ENTRIES = 3,
	READ_EXTENT_CACHE = 4,
	AGE_EXTENT_CACHE = 5,
	DISCARD_CACHE = 6,
	COMPRESS_PAGE = 7,
	BASE_CHECK = 8,
};

enum mem_type___2 {
	MEM_EMPTY = 0,
	MEM_RESERVED = 1,
	MEM_UNKNOWN = 2,
	MEM_FPM = 3,
	MEM_EDO = 4,
	MEM_BEDO = 5,
	MEM_SDR = 6,
	MEM_RDR = 7,
	MEM_DDR = 8,
	MEM_RDDR = 9,
	MEM_RMBS = 10,
	MEM_DDR2 = 11,
	MEM_FB_DDR2 = 12,
	MEM_RDDR2 = 13,
	MEM_XDR = 14,
	MEM_DDR3 = 15,
	MEM_RDDR3 = 16,
	MEM_LRDDR3 = 17,
	MEM_LPDDR3 = 18,
	MEM_DDR4 = 19,
	MEM_RDDR4 = 20,
	MEM_LRDDR4 = 21,
	MEM_LPDDR4 = 22,
	MEM_DDR5 = 23,
	MEM_RDDR5 = 24,
	MEM_LRDDR5 = 25,
	MEM_NVDIMM = 26,
	MEM_WIO2 = 27,
	MEM_HBM2 = 28,
	MEM_HBM3 = 29,
};

enum membarrier_cmd {
	MEMBARRIER_CMD_QUERY = 0,
	MEMBARRIER_CMD_GLOBAL = 1,
	MEMBARRIER_CMD_GLOBAL_EXPEDITED = 2,
	MEMBARRIER_CMD_REGISTER_GLOBAL_EXPEDITED = 4,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED = 8,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED = 16,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_SYNC_CORE = 32,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_SYNC_CORE = 64,
	MEMBARRIER_CMD_PRIVATE_EXPEDITED_RSEQ = 128,
	MEMBARRIER_CMD_REGISTER_PRIVATE_EXPEDITED_RSEQ = 256,
	MEMBARRIER_CMD_GET_REGISTRATIONS = 512,
	MEMBARRIER_CMD_SHARED = 1,
};

enum membarrier_cmd_flag {
	MEMBARRIER_CMD_FLAG_CPU = 1,
};

enum memblock_flags {
	MEMBLOCK_NONE = 0,
	MEMBLOCK_HOTPLUG = 1,
	MEMBLOCK_MIRROR = 2,
	MEMBLOCK_NOMAP = 4,
	MEMBLOCK_DRIVER_MANAGED = 8,
	MEMBLOCK_RSRV_NOINIT = 16,
	MEMBLOCK_RSRV_KERN = 32,
	MEMBLOCK_KHO_SCRATCH = 64,
};

enum memcg_memory_event {
	MEMCG_LOW = 0,
	MEMCG_HIGH = 1,
	MEMCG_MAX = 2,
	MEMCG_OOM = 3,
	MEMCG_OOM_KILL = 4,
	MEMCG_OOM_GROUP_KILL = 5,
	MEMCG_SWAP_HIGH = 6,
	MEMCG_SWAP_MAX = 7,
	MEMCG_SWAP_FAIL = 8,
	MEMCG_NR_MEMORY_EVENTS = 9,
};

enum memcg_stat_item {
	MEMCG_SWAP = 47,
	MEMCG_SOCK = 48,
	MEMCG_PERCPU_B = 49,
	MEMCG_VMALLOC = 50,
	MEMCG_KMEM = 51,
	MEMCG_ZSWAP_B = 52,
	MEMCG_ZSWAPPED = 53,
	MEMCG_NR_STAT = 54,
};

enum meminit_context {
	MEMINIT_EARLY = 0,
	MEMINIT_HOTPLUG = 1,
};

enum memory_type {
	MEMORY_DEVICE_PRIVATE = 1,
	MEMORY_DEVICE_COHERENT = 2,
	MEMORY_DEVICE_FS_DAX = 3,
	MEMORY_DEVICE_GENERIC = 4,
	MEMORY_DEVICE_PCI_P2PDMA = 5,
};

enum meson_pinconf_drv {
	MESON_PINCONF_DRV_500UA = 0,
	MESON_PINCONF_DRV_2500UA = 1,
	MESON_PINCONF_DRV_3000UA = 2,
	MESON_PINCONF_DRV_4000UA = 3,
};

enum meson_reg_type {
	MESON_REG_PULLEN = 0,
	MESON_REG_PULL = 1,
	MESON_REG_DIR = 2,
	MESON_REG_OUT = 3,
	MESON_REG_IN = 4,
	MESON_REG_DS = 5,
	MESON_NUM_REG = 6,
};

enum meson_soc_id {
	MESON_SOC_G12A = 0,
	MESON_SOC_A1 = 1,
};

enum metadata_type {
	METADATA_IP_TUNNEL = 0,
	METADATA_HW_PORT_MUX = 1,
	METADATA_MACSEC = 2,
	METADATA_XFRM = 3,
};

enum mfill_atomic_mode {
	MFILL_ATOMIC_COPY = 0,
	MFILL_ATOMIC_ZEROPAGE = 1,
	MFILL_ATOMIC_CONTINUE = 2,
	MFILL_ATOMIC_POISON = 3,
	NR_MFILL_ATOMIC_MODES = 4,
};

enum migrate_mode {
	MIGRATE_ASYNC = 0,
	MIGRATE_SYNC_LIGHT = 1,
	MIGRATE_SYNC = 2,
};

enum migrate_reason {
	MR_COMPACTION = 0,
	MR_MEMORY_FAILURE = 1,
	MR_MEMORY_HOTPLUG = 2,
	MR_SYSCALL = 3,
	MR_MEMPOLICY_MBIND = 4,
	MR_NUMA_MISPLACED = 5,
	MR_CONTIG_RANGE = 6,
	MR_LONGTERM_PIN = 7,
	MR_DEMOTION = 8,
	MR_DAMON = 9,
	MR_TYPES = 10,
};

enum migratetype {
	MIGRATE_UNMOVABLE = 0,
	MIGRATE_MOVABLE = 1,
	MIGRATE_RECLAIMABLE = 2,
	MIGRATE_PCPTYPES = 3,
	MIGRATE_HIGHATOMIC = 3,
	MIGRATE_CMA = 4,
	MIGRATE_ISOLATE = 5,
	MIGRATE_TYPES = 6,
};

enum migration_type {
	migrate_load = 0,
	migrate_util = 1,
	migrate_task = 2,
	migrate_misfit = 3,
};

enum mipi_dsi_compression_algo {
	MIPI_DSI_COMPRESSION_DSC = 0,
	MIPI_DSI_COMPRESSION_VENDOR = 3,
};

enum mipi_dsi_dcs_tear_mode {
	MIPI_DSI_DCS_TEAR_MODE_VBLANK = 0,
	MIPI_DSI_DCS_TEAR_MODE_VHBLANK = 1,
};

enum mipi_dsi_pixel_format {
	MIPI_DSI_FMT_RGB888 = 0,
	MIPI_DSI_FMT_RGB666 = 1,
	MIPI_DSI_FMT_RGB666_PACKED = 2,
	MIPI_DSI_FMT_RGB565 = 3,
};

enum misc_res_type {
	MISC_CG_RES_TYPES = 0,
};

enum mixer_flag_bits {
	MXR_BIT_POWERED = 0,
	MXR_BIT_VSYNC = 1,
	MXR_BIT_INTERLACE = 2,
	MXR_BIT_VP_ENABLED = 3,
	MXR_BIT_HAS_SCLK = 4,
};

enum mixer_version_id {
	MXR_VER_0_0_0_16 = 0,
	MXR_VER_16_0_33_0 = 1,
	MXR_VER_128_0_0_184 = 2,
};

enum mm_cid_state {
	MM_CID_UNSET = 4294967295,
	MM_CID_LAZY_PUT = 2147483648,
};

enum mmc_busy_cmd {
	MMC_BUSY_CMD6 = 0,
	MMC_BUSY_ERASE = 1,
	MMC_BUSY_HPI = 2,
	MMC_BUSY_EXTR_SINGLE = 3,
	MMC_BUSY_IO = 4,
};

enum mmc_drv_op {
	MMC_DRV_OP_IOCTL = 0,
	MMC_DRV_OP_IOCTL_RPMB = 1,
	MMC_DRV_OP_BOOT_WP = 2,
	MMC_DRV_OP_GET_CARD_STATUS = 3,
	MMC_DRV_OP_GET_EXT_CSD = 4,
};

enum mmc_err_stat {
	MMC_ERR_CMD_TIMEOUT = 0,
	MMC_ERR_CMD_CRC = 1,
	MMC_ERR_DAT_TIMEOUT = 2,
	MMC_ERR_DAT_CRC = 3,
	MMC_ERR_AUTO_CMD = 4,
	MMC_ERR_ADMA = 5,
	MMC_ERR_TUNING = 6,
	MMC_ERR_CMDQ_RED = 7,
	MMC_ERR_CMDQ_GCE = 8,
	MMC_ERR_CMDQ_ICCE = 9,
	MMC_ERR_REQ_TIMEOUT = 10,
	MMC_ERR_CMDQ_REQ_TIMEOUT = 11,
	MMC_ERR_ICE_CFG = 12,
	MMC_ERR_CTRL_TIMEOUT = 13,
	MMC_ERR_UNEXPECTED_IRQ = 14,
	MMC_ERR_MAX = 15,
};

enum mmc_issue_type {
	MMC_ISSUE_SYNC = 0,
	MMC_ISSUE_DCMD = 1,
	MMC_ISSUE_ASYNC = 2,
	MMC_ISSUE_MAX = 3,
};

enum mmc_issued {
	MMC_REQ_STARTED = 0,
	MMC_REQ_BUSY = 1,
	MMC_REQ_FAILED_TO_START = 2,
	MMC_REQ_FINISHED = 3,
};

enum mmc_poweroff_type {
	MMC_POWEROFF_SUSPEND = 0,
	MMC_POWEROFF_SHUTDOWN = 1,
	MMC_POWEROFF_UNBIND = 2,
};

enum mmci_busy_state {
	MMCI_BUSY_WAITING_FOR_START_IRQ = 0,
	MMCI_BUSY_WAITING_FOR_END_IRQ = 1,
	MMCI_BUSY_DONE = 2,
};

enum mminit_level {
	MMINIT_WARNING = 0,
	MMINIT_VERIFY = 1,
	MMINIT_TRACE = 2,
};

enum mnt_tree_flags_t {
	MNT_TREE_MOVE = 1,
	MNT_TREE_BENEATH = 2,
	MNT_TREE_PROPAGATION = 4,
};

enum mod_license {
	NOT_GPL_ONLY = 0,
	GPL_ONLY = 1,
};

enum mod_mem_type {
	MOD_TEXT = 0,
	MOD_DATA = 1,
	MOD_RODATA = 2,
	MOD_RO_AFTER_INIT = 3,
	MOD_INIT_TEXT = 4,
	MOD_INIT_DATA = 5,
	MOD_INIT_RODATA = 6,
	MOD_MEM_NUM_TYPES = 7,
	MOD_INVALID = -1,
};

enum mode_set_atomic {
	LEAVE_ATOMIC_MODE_SET = 0,
	ENTER_ATOMIC_MODE_SET = 1,
};

enum mode_type {
	GQSPI_MODE_IO = 0,
	GQSPI_MODE_DMA = 1,
};

enum module_state {
	MODULE_STATE_LIVE = 0,
	MODULE_STATE_COMING = 1,
	MODULE_STATE_GOING = 2,
	MODULE_STATE_UNFORMED = 3,
};

enum motionsense_command {
	MOTIONSENSE_CMD_DUMP = 0,
	MOTIONSENSE_CMD_INFO = 1,
	MOTIONSENSE_CMD_EC_RATE = 2,
	MOTIONSENSE_CMD_SENSOR_ODR = 3,
	MOTIONSENSE_CMD_SENSOR_RANGE = 4,
	MOTIONSENSE_CMD_KB_WAKE_ANGLE = 5,
	MOTIONSENSE_CMD_DATA = 6,
	MOTIONSENSE_CMD_FIFO_INFO = 7,
	MOTIONSENSE_CMD_FIFO_FLUSH = 8,
	MOTIONSENSE_CMD_FIFO_READ = 9,
	MOTIONSENSE_CMD_PERFORM_CALIB = 10,
	MOTIONSENSE_CMD_SENSOR_OFFSET = 11,
	MOTIONSENSE_CMD_LIST_ACTIVITIES = 12,
	MOTIONSENSE_CMD_SET_ACTIVITY = 13,
	MOTIONSENSE_CMD_LID_ANGLE = 14,
	MOTIONSENSE_CMD_FIFO_INT_ENABLE = 15,
	MOTIONSENSE_CMD_SPOOF = 16,
	MOTIONSENSE_CMD_TABLET_MODE_LID_ANGLE = 17,
	MOTIONSENSE_CMD_SENSOR_SCALE = 18,
	MOTIONSENSE_NUM_CMDS = 19,
};

enum motionsensor_type {
	MOTIONSENSE_TYPE_ACCEL = 0,
	MOTIONSENSE_TYPE_GYRO = 1,
	MOTIONSENSE_TYPE_MAG = 2,
	MOTIONSENSE_TYPE_PROX = 3,
	MOTIONSENSE_TYPE_LIGHT = 4,
	MOTIONSENSE_TYPE_ACTIVITY = 5,
	MOTIONSENSE_TYPE_BARO = 6,
	MOTIONSENSE_TYPE_SYNC = 7,
	MOTIONSENSE_TYPE_MAX = 8,
};

enum mount_flags {
	MNT_NOSUID = 1,
	MNT_NODEV = 2,
	MNT_NOEXEC = 4,
	MNT_NOATIME = 8,
	MNT_NODIRATIME = 16,
	MNT_RELATIME = 32,
	MNT_READONLY = 64,
	MNT_NOSYMFOLLOW = 128,
	MNT_SHRINKABLE = 256,
	MNT_WRITE_HOLD = 512,
	MNT_SHARED = 4096,
	MNT_UNBINDABLE = 8192,
	MNT_INTERNAL = 16384,
	MNT_LOCK_ATIME = 262144,
	MNT_LOCK_NOEXEC = 524288,
	MNT_LOCK_NOSUID = 1048576,
	MNT_LOCK_NODEV = 2097152,
	MNT_LOCK_READONLY = 4194304,
	MNT_LOCKED = 8388608,
	MNT_DOOMED = 16777216,
	MNT_SYNC_UMOUNT = 33554432,
	MNT_MARKED = 67108864,
	MNT_UMOUNT = 134217728,
	MNT_SHARED_MASK = 8192,
	MNT_USER_SETTABLE_MASK = 255,
	MNT_ATIME_MASK = 56,
	MNT_INTERNAL_FLAGS = 125850112,
};

enum mount_kattr_flags_t {
	MOUNT_KATTR_RECURSE = 1,
	MOUNT_KATTR_IDMAP_REPLACE = 2,
};

enum mountstat {
	MNT_OK = 0,
	MNT_EPERM = 1,
	MNT_ENOENT = 2,
	MNT_EACCES = 13,
	MNT_EINVAL = 22,
};

enum mountstat3 {
	MNT3_OK = 0,
	MNT3ERR_PERM = 1,
	MNT3ERR_NOENT = 2,
	MNT3ERR_IO = 5,
	MNT3ERR_ACCES = 13,
	MNT3ERR_NOTDIR = 20,
	MNT3ERR_INVAL = 22,
	MNT3ERR_NAMETOOLONG = 63,
	MNT3ERR_NOTSUPP = 10004,
	MNT3ERR_SERVERFAULT = 10006,
};

enum mptcp_addr_signal_status {
	MPTCP_ADD_ADDR_SIGNAL = 0,
	MPTCP_ADD_ADDR_ECHO = 1,
	MPTCP_RM_ADDR_SIGNAL = 2,
};

enum mptcp_event_attr {
	MPTCP_ATTR_UNSPEC = 0,
	MPTCP_ATTR_TOKEN = 1,
	MPTCP_ATTR_FAMILY = 2,
	MPTCP_ATTR_LOC_ID = 3,
	MPTCP_ATTR_REM_ID = 4,
	MPTCP_ATTR_SADDR4 = 5,
	MPTCP_ATTR_SADDR6 = 6,
	MPTCP_ATTR_DADDR4 = 7,
	MPTCP_ATTR_DADDR6 = 8,
	MPTCP_ATTR_SPORT = 9,
	MPTCP_ATTR_DPORT = 10,
	MPTCP_ATTR_BACKUP = 11,
	MPTCP_ATTR_ERROR = 12,
	MPTCP_ATTR_FLAGS = 13,
	MPTCP_ATTR_TIMEOUT = 14,
	MPTCP_ATTR_IF_IDX = 15,
	MPTCP_ATTR_RESET_REASON = 16,
	MPTCP_ATTR_RESET_FLAGS = 17,
	MPTCP_ATTR_SERVER_SIDE = 18,
	__MPTCP_ATTR_MAX = 19,
};

enum mptcp_event_type {
	MPTCP_EVENT_UNSPEC = 0,
	MPTCP_EVENT_CREATED = 1,
	MPTCP_EVENT_ESTABLISHED = 2,
	MPTCP_EVENT_CLOSED = 3,
	MPTCP_EVENT_ANNOUNCED = 6,
	MPTCP_EVENT_REMOVED = 7,
	MPTCP_EVENT_SUB_ESTABLISHED = 10,
	MPTCP_EVENT_SUB_CLOSED = 11,
	MPTCP_EVENT_SUB_PRIORITY = 13,
	MPTCP_EVENT_LISTENER_CREATED = 15,
	MPTCP_EVENT_LISTENER_CLOSED = 16,
};

enum mptcp_pm_status {
	MPTCP_PM_ADD_ADDR_RECEIVED = 0,
	MPTCP_PM_ADD_ADDR_SEND_ACK = 1,
	MPTCP_PM_RM_ADDR_RECEIVED = 2,
	MPTCP_PM_ESTABLISHED = 3,
	MPTCP_PM_SUBFLOW_ESTABLISHED = 4,
	MPTCP_PM_ALREADY_ESTABLISHED = 5,
	MPTCP_PM_MPC_ENDPOINT_ACCOUNTED = 6,
};

enum mptcp_pm_type {
	MPTCP_PM_TYPE_KERNEL = 0,
	MPTCP_PM_TYPE_USERSPACE = 1,
	__MPTCP_PM_TYPE_NR = 2,
	__MPTCP_PM_TYPE_MAX = 1,
};

enum mq_rq_state {
	MQ_RQ_IDLE = 0,
	MQ_RQ_IN_FLIGHT = 1,
	MQ_RQ_COMPLETE = 2,
};

enum mremap_type {
	MREMAP_INVALID = 0,
	MREMAP_NO_RESIZE = 1,
	MREMAP_SHRINK = 2,
	MREMAP_EXPAND = 3,
};

enum msdos_sys_ind {
	DOS_EXTENDED_PARTITION = 5,
	LINUX_EXTENDED_PARTITION = 133,
	WIN98_EXTENDED_PARTITION = 15,
	LINUX_DATA_PARTITION = 131,
	LINUX_LVM_PARTITION = 142,
	LINUX_RAID_PARTITION = 253,
	SOLARIS_X86_PARTITION = 130,
	NEW_SOLARIS_X86_PARTITION = 191,
	DM6_AUX1PARTITION = 81,
	DM6_AUX3PARTITION = 83,
	DM6_PARTITION = 84,
	EZD_PARTITION = 85,
	FREEBSD_PARTITION = 165,
	OPENBSD_PARTITION = 166,
	NETBSD_PARTITION = 169,
	BSDI_PARTITION = 183,
	MINIX_PARTITION = 129,
	UNIXWARE_PARTITION = 99,
};

enum msg_end_type {
	MSG_END_STOP = 0,
	MSG_END_REPEAT_START = 1,
	MSG_END_CONTINUE = 2,
};

enum msi_desc_filter {
	MSI_DESC_ALL = 0,
	MSI_DESC_NOTASSOCIATED = 1,
	MSI_DESC_ASSOCIATED = 2,
};

enum msi_domain_ids {
	MSI_DEFAULT_DOMAIN = 0,
	MSI_MAX_DEVICE_IRQDOMAINS = 1,
};

enum msm_dp_aux_err {
	DP_AUX_ERR_NONE = 0,
	DP_AUX_ERR_ADDR = 1,
	DP_AUX_ERR_TOUT = 2,
	DP_AUX_ERR_NACK = 3,
	DP_AUX_ERR_DEFER = 4,
	DP_AUX_ERR_NACK_DEFER = 5,
	DP_AUX_ERR_PHY = 6,
};

enum msm_dp_controller {
	MSM_DP_CONTROLLER_0 = 0,
	MSM_DP_CONTROLLER_1 = 1,
	MSM_DP_CONTROLLER_2 = 2,
	MSM_DP_CONTROLLER_3 = 3,
	MSM_DP_CONTROLLER_COUNT = 4,
};

enum msm_dsi_controller {
	MSM_DSI_CONTROLLER_0 = 0,
	MSM_DSI_CONTROLLER_1 = 1,
	MSM_DSI_CONTROLLER_COUNT = 2,
};

enum msm_dsi_phy_usecase {
	MSM_DSI_PHY_STANDALONE = 0,
	MSM_DSI_PHY_MASTER = 1,
	MSM_DSI_PHY_SLAVE = 2,
};

enum msm_format_flags {
	MSM_FORMAT_FLAG_YUV_BIT = 0,
	MSM_FORMAT_FLAG_DX_BIT = 1,
	MSM_FORMAT_FLAG_COMPRESSED_BIT = 2,
	MSM_FORMAT_FLAG_UNPACK_TIGHT_BIT = 3,
	MSM_FORMAT_FLAG_UNPACK_ALIGN_MSB_BIT = 4,
};

enum msm_mmu_type {
	MSM_MMU_GPUMMU = 0,
	MSM_MMU_IOMMU = 1,
	MSM_MMU_IOMMU_PAGETABLE = 2,
};

enum mtd_file_modes {
	MTD_FILE_MODE_NORMAL = 0,
	MTD_FILE_MODE_OTP_FACTORY = 1,
	MTD_FILE_MODE_OTP_USER = 2,
	MTD_FILE_MODE_RAW = 3,
};

enum mthp_stat_item {
	MTHP_STAT_ANON_FAULT_ALLOC = 0,
	MTHP_STAT_ANON_FAULT_FALLBACK = 1,
	MTHP_STAT_ANON_FAULT_FALLBACK_CHARGE = 2,
	MTHP_STAT_ZSWPOUT = 3,
	MTHP_STAT_SWPIN = 4,
	MTHP_STAT_SWPIN_FALLBACK = 5,
	MTHP_STAT_SWPIN_FALLBACK_CHARGE = 6,
	MTHP_STAT_SWPOUT = 7,
	MTHP_STAT_SWPOUT_FALLBACK = 8,
	MTHP_STAT_SHMEM_ALLOC = 9,
	MTHP_STAT_SHMEM_FALLBACK = 10,
	MTHP_STAT_SHMEM_FALLBACK_CHARGE = 11,
	MTHP_STAT_SPLIT = 12,
	MTHP_STAT_SPLIT_FAILED = 13,
	MTHP_STAT_SPLIT_DEFERRED = 14,
	MTHP_STAT_NR_ANON = 15,
	MTHP_STAT_NR_ANON_PARTIALLY_MAPPED = 16,
	__MTHP_STAT_COUNT = 17,
};

enum multi_stop_state {
	MULTI_STOP_NONE = 0,
	MULTI_STOP_PREPARE = 1,
	MULTI_STOP_DISABLE_IRQ = 2,
	MULTI_STOP_RUN = 3,
	MULTI_STOP_EXIT = 4,
};

enum musb_buf_mode {
	BUF_SINGLE = 0,
	BUF_DOUBLE = 1,
} __attribute__((mode(byte)));

enum musb_fifo_style {
	FIFO_RXTX = 0,
	FIFO_TX = 1,
	FIFO_RX = 2,
} __attribute__((mode(byte)));

enum musb_g_ep0_state {
	MUSB_EP0_STAGE_IDLE = 0,
	MUSB_EP0_STAGE_SETUP = 1,
	MUSB_EP0_STAGE_TX = 2,
	MUSB_EP0_STAGE_RX = 3,
	MUSB_EP0_STAGE_STATUSIN = 4,
	MUSB_EP0_STAGE_STATUSOUT = 5,
	MUSB_EP0_STAGE_ACKWAIT = 6,
} __attribute__((mode(byte)));

enum musb_h_ep0_state {
	MUSB_EP0_IDLE = 0,
	MUSB_EP0_START = 1,
	MUSB_EP0_IN = 2,
	MUSB_EP0_OUT = 3,
	MUSB_EP0_STATUS = 4,
} __attribute__((mode(byte)));

enum musb_interface {
	MUSB_INTERFACE_ULPI = 0,
	MUSB_INTERFACE_UTMI = 1,
};

enum musb_mode {
	MUSB_UNDEFINED = 0,
	MUSB_HOST = 1,
	MUSB_PERIPHERAL = 2,
	MUSB_OTG = 3,
};

enum musb_vbus_id_status {
	MUSB_UNKNOWN = 0,
	MUSB_ID_GROUND = 1,
	MUSB_ID_FLOAT = 2,
	MUSB_VBUS_VALID = 3,
	MUSB_VBUS_OFF = 4,
};

enum muxtype {
	pca954x_ismux = 0,
	pca954x_isswi = 1,
};

enum mv_xor_mode {
	XOR_MODE_IN_REG = 0,
	XOR_MODE_IN_DESC = 1,
};

enum mv_xor_type {
	XOR_ORION = 0,
	XOR_ARMADA_38X = 1,
	XOR_ARMADA_37XX = 2,
};

enum mxc_cpu_pwr_mode {
	WAIT_CLOCKED = 0,
	WAIT_UNCLOCKED = 1,
	WAIT_UNCLOCKED_POWER_OFF = 2,
	STOP_POWER_ON = 3,
	STOP_POWER_OFF = 4,
};

enum mxcmci_type {
	IMX21_MMC = 0,
	IMX31_MMC = 1,
	MPC512X_MMC = 2,
};

enum mxs_dma_devtype {
	MXS_DMA_APBH = 0,
	MXS_DMA_APBX = 1,
};

enum mxs_dma_id {
	IMX23_DMA = 0,
	IMX28_DMA = 1,
};

enum mxt_suspend_mode {
	MXT_SUSPEND_DEEP_SLEEP = 0,
	MXT_SUSPEND_T9_CTRL = 1,
};

enum nand_bbt_block_status {
	NAND_BBT_BLOCK_STATUS_UNKNOWN = 0,
	NAND_BBT_BLOCK_GOOD = 1,
	NAND_BBT_BLOCK_WORN = 2,
	NAND_BBT_BLOCK_RESERVED = 3,
	NAND_BBT_BLOCK_FACTORY_BAD = 4,
	NAND_BBT_BLOCK_NUM_STATUS = 5,
};

enum nand_ecc_algo {
	NAND_ECC_ALGO_UNKNOWN = 0,
	NAND_ECC_ALGO_HAMMING = 1,
	NAND_ECC_ALGO_BCH = 2,
	NAND_ECC_ALGO_RS = 3,
};

enum nand_ecc_engine_integration {
	NAND_ECC_ENGINE_INTEGRATION_INVALID = 0,
	NAND_ECC_ENGINE_INTEGRATION_PIPELINED = 1,
	NAND_ECC_ENGINE_INTEGRATION_EXTERNAL = 2,
};

enum nand_ecc_engine_type {
	NAND_ECC_ENGINE_TYPE_INVALID = 0,
	NAND_ECC_ENGINE_TYPE_NONE = 1,
	NAND_ECC_ENGINE_TYPE_SOFT = 2,
	NAND_ECC_ENGINE_TYPE_ON_HOST = 3,
	NAND_ECC_ENGINE_TYPE_ON_DIE = 4,
};

enum nand_ecc_legacy_mode {
	NAND_ECC_INVALID = 0,
	NAND_ECC_NONE = 1,
	NAND_ECC_SOFT = 2,
	NAND_ECC_SOFT_BCH = 3,
	NAND_ECC_HW = 4,
	NAND_ECC_HW_SYNDROME = 5,
	NAND_ECC_ON_DIE = 6,
};

enum nand_ecc_placement {
	NAND_ECC_PLACEMENT_UNKNOWN = 0,
	NAND_ECC_PLACEMENT_OOB = 1,
	NAND_ECC_PLACEMENT_INTERLEAVED = 2,
};

enum nand_interface_type {
	NAND_SDR_IFACE = 0,
	NAND_NVDDR_IFACE = 1,
};

enum nand_op_instr_type {
	NAND_OP_CMD_INSTR = 0,
	NAND_OP_ADDR_INSTR = 1,
	NAND_OP_DATA_IN_INSTR = 2,
	NAND_OP_DATA_OUT_INSTR = 3,
	NAND_OP_WAITRDY_INSTR = 4,
};

enum nand_page_io_req_type {
	NAND_PAGE_READ = 0,
	NAND_PAGE_WRITE = 1,
};

enum nat_state {
	TOTAL_NAT = 0,
	DIRTY_NAT = 1,
	RECLAIMABLE_NAT = 2,
	MAX_NAT_STATE = 3,
};

enum nbcon_prio {
	NBCON_PRIO_NONE = 0,
	NBCON_PRIO_NORMAL = 1,
	NBCON_PRIO_EMERGENCY = 2,
	NBCON_PRIO_PANIC = 3,
	NBCON_PRIO_MAX = 4,
};

enum ncq_saw_flag_list {
	ncq_saw_d2h = 1,
	ncq_saw_dmas = 2,
	ncq_saw_sdb = 4,
	ncq_saw_backout = 8,
};

enum ncsi_nl_attrs {
	NCSI_ATTR_UNSPEC = 0,
	NCSI_ATTR_IFINDEX = 1,
	NCSI_ATTR_PACKAGE_LIST = 2,
	NCSI_ATTR_PACKAGE_ID = 3,
	NCSI_ATTR_CHANNEL_ID = 4,
	NCSI_ATTR_DATA = 5,
	NCSI_ATTR_MULTI_FLAG = 6,
	NCSI_ATTR_PACKAGE_MASK = 7,
	NCSI_ATTR_CHANNEL_MASK = 8,
	__NCSI_ATTR_AFTER_LAST = 9,
	NCSI_ATTR_MAX = 8,
};

enum ncsi_nl_channel_attrs {
	NCSI_CHANNEL_ATTR_UNSPEC = 0,
	NCSI_CHANNEL_ATTR = 1,
	NCSI_CHANNEL_ATTR_ID = 2,
	NCSI_CHANNEL_ATTR_VERSION_MAJOR = 3,
	NCSI_CHANNEL_ATTR_VERSION_MINOR = 4,
	NCSI_CHANNEL_ATTR_VERSION_STR = 5,
	NCSI_CHANNEL_ATTR_LINK_STATE = 6,
	NCSI_CHANNEL_ATTR_ACTIVE = 7,
	NCSI_CHANNEL_ATTR_FORCED = 8,
	NCSI_CHANNEL_ATTR_VLAN_LIST = 9,
	NCSI_CHANNEL_ATTR_VLAN_ID = 10,
	__NCSI_CHANNEL_ATTR_AFTER_LAST = 11,
	NCSI_CHANNEL_ATTR_MAX = 10,
};

enum ncsi_nl_commands {
	NCSI_CMD_UNSPEC = 0,
	NCSI_CMD_PKG_INFO = 1,
	NCSI_CMD_SET_INTERFACE = 2,
	NCSI_CMD_CLEAR_INTERFACE = 3,
	NCSI_CMD_SEND_CMD = 4,
	NCSI_CMD_SET_PACKAGE_MASK = 5,
	NCSI_CMD_SET_CHANNEL_MASK = 6,
	__NCSI_CMD_AFTER_LAST = 7,
	NCSI_CMD_MAX = 6,
};

enum ncsi_nl_pkg_attrs {
	NCSI_PKG_ATTR_UNSPEC = 0,
	NCSI_PKG_ATTR = 1,
	NCSI_PKG_ATTR_ID = 2,
	NCSI_PKG_ATTR_FORCED = 3,
	NCSI_PKG_ATTR_CHANNEL_LIST = 4,
	__NCSI_PKG_ATTR_AFTER_LAST = 5,
	NCSI_PKG_ATTR_MAX = 4,
};

enum need_lock_type {
	LOCK_REQ = 0,
	LOCK_DONE = 1,
	LOCK_RETRY = 2,
};

enum net_device_flags {
	IFF_UP = 1,
	IFF_BROADCAST = 2,
	IFF_DEBUG = 4,
	IFF_LOOPBACK = 8,
	IFF_POINTOPOINT = 16,
	IFF_NOTRAILERS = 32,
	IFF_RUNNING = 64,
	IFF_NOARP = 128,
	IFF_PROMISC = 256,
	IFF_ALLMULTI = 512,
	IFF_MASTER = 1024,
	IFF_SLAVE = 2048,
	IFF_MULTICAST = 4096,
	IFF_PORTSEL = 8192,
	IFF_AUTOMEDIA = 16384,
	IFF_DYNAMIC = 32768,
	IFF_LOWER_UP = 65536,
	IFF_DORMANT = 131072,
	IFF_ECHO = 262144,
};

enum net_device_path_type {
	DEV_PATH_ETHERNET = 0,
	DEV_PATH_VLAN = 1,
	DEV_PATH_BRIDGE = 2,
	DEV_PATH_PPPOE = 3,
	DEV_PATH_DSA = 4,
	DEV_PATH_MTK_WDMA = 5,
};

enum net_iov_type {
	NET_IOV_DMABUF = 0,
	NET_IOV_IOURING = 1,
	NET_IOV_MAX = 4294967295,
};

enum net_shaper_binding_type {
	NET_SHAPER_BINDING_TYPE_NETDEV = 0,
};

enum net_shaper_metric {
	NET_SHAPER_METRIC_BPS = 0,
	NET_SHAPER_METRIC_PPS = 1,
};

enum net_shaper_scope {
	NET_SHAPER_SCOPE_UNSPEC = 0,
	NET_SHAPER_SCOPE_NETDEV = 1,
	NET_SHAPER_SCOPE_QUEUE = 2,
	NET_SHAPER_SCOPE_NODE = 3,
	__NET_SHAPER_SCOPE_MAX = 4,
	NET_SHAPER_SCOPE_MAX = 3,
};

enum net_xmit_qdisc_t {
	__NET_XMIT_STOLEN = 65536,
	__NET_XMIT_BYPASS = 131072,
};

enum netdev_cmd {
	NETDEV_UP = 1,
	NETDEV_DOWN = 2,
	NETDEV_REBOOT = 3,
	NETDEV_CHANGE = 4,
	NETDEV_REGISTER = 5,
	NETDEV_UNREGISTER = 6,
	NETDEV_CHANGEMTU = 7,
	NETDEV_CHANGEADDR = 8,
	NETDEV_PRE_CHANGEADDR = 9,
	NETDEV_GOING_DOWN = 10,
	NETDEV_CHANGENAME = 11,
	NETDEV_FEAT_CHANGE = 12,
	NETDEV_BONDING_FAILOVER = 13,
	NETDEV_PRE_UP = 14,
	NETDEV_PRE_TYPE_CHANGE = 15,
	NETDEV_POST_TYPE_CHANGE = 16,
	NETDEV_POST_INIT = 17,
	NETDEV_PRE_UNINIT = 18,
	NETDEV_RELEASE = 19,
	NETDEV_NOTIFY_PEERS = 20,
	NETDEV_JOIN = 21,
	NETDEV_CHANGEUPPER = 22,
	NETDEV_RESEND_IGMP = 23,
	NETDEV_PRECHANGEMTU = 24,
	NETDEV_CHANGEINFODATA = 25,
	NETDEV_BONDING_INFO = 26,
	NETDEV_PRECHANGEUPPER = 27,
	NETDEV_CHANGELOWERSTATE = 28,
	NETDEV_UDP_TUNNEL_PUSH_INFO = 29,
	NETDEV_UDP_TUNNEL_DROP_INFO = 30,
	NETDEV_CHANGE_TX_QUEUE_LEN = 31,
	NETDEV_CVLAN_FILTER_PUSH_INFO = 32,
	NETDEV_CVLAN_FILTER_DROP_INFO = 33,
	NETDEV_SVLAN_FILTER_PUSH_INFO = 34,
	NETDEV_SVLAN_FILTER_DROP_INFO = 35,
	NETDEV_OFFLOAD_XSTATS_ENABLE = 36,
	NETDEV_OFFLOAD_XSTATS_DISABLE = 37,
	NETDEV_OFFLOAD_XSTATS_REPORT_USED = 38,
	NETDEV_OFFLOAD_XSTATS_REPORT_DELTA = 39,
	NETDEV_XDP_FEAT_CHANGE = 40,
};

enum netdev_lag_hash {
	NETDEV_LAG_HASH_NONE = 0,
	NETDEV_LAG_HASH_L2 = 1,
	NETDEV_LAG_HASH_L34 = 2,
	NETDEV_LAG_HASH_L23 = 3,
	NETDEV_LAG_HASH_E23 = 4,
	NETDEV_LAG_HASH_E34 = 5,
	NETDEV_LAG_HASH_VLAN_SRCMAC = 6,
	NETDEV_LAG_HASH_UNKNOWN = 7,
};

enum netdev_lag_tx_type {
	NETDEV_LAG_TX_TYPE_UNKNOWN = 0,
	NETDEV_LAG_TX_TYPE_RANDOM = 1,
	NETDEV_LAG_TX_TYPE_BROADCAST = 2,
	NETDEV_LAG_TX_TYPE_ROUNDROBIN = 3,
	NETDEV_LAG_TX_TYPE_ACTIVEBACKUP = 4,
	NETDEV_LAG_TX_TYPE_HASH = 5,
};

enum netdev_ml_priv_type {
	ML_PRIV_NONE = 0,
	ML_PRIV_CAN = 1,
};

enum netdev_offload_xstats_type {
	NETDEV_OFFLOAD_XSTATS_TYPE_L3 = 1,
};

enum netdev_priv_flags {
	IFF_802_1Q_VLAN = 1,
	IFF_EBRIDGE = 2,
	IFF_BONDING = 4,
	IFF_ISATAP = 8,
	IFF_WAN_HDLC = 16,
	IFF_XMIT_DST_RELEASE = 32,
	IFF_DONT_BRIDGE = 64,
	IFF_DISABLE_NETPOLL = 128,
	IFF_MACVLAN_PORT = 256,
	IFF_BRIDGE_PORT = 512,
	IFF_OVS_DATAPATH = 1024,
	IFF_TX_SKB_SHARING = 2048,
	IFF_UNICAST_FLT = 4096,
	IFF_TEAM_PORT = 8192,
	IFF_SUPP_NOFCS = 16384,
	IFF_LIVE_ADDR_CHANGE = 32768,
	IFF_MACVLAN = 65536,
	IFF_XMIT_DST_RELEASE_PERM = 131072,
	IFF_L3MDEV_MASTER = 262144,
	IFF_NO_QUEUE = 524288,
	IFF_OPENVSWITCH = 1048576,
	IFF_L3MDEV_SLAVE = 2097152,
	IFF_TEAM = 4194304,
	IFF_RXFH_CONFIGURED = 8388608,
	IFF_PHONY_HEADROOM = 16777216,
	IFF_MACSEC = 33554432,
	IFF_NO_RX_HANDLER = 67108864,
	IFF_FAILOVER = 134217728,
	IFF_FAILOVER_SLAVE = 268435456,
	IFF_L3MDEV_RX_HANDLER = 536870912,
	IFF_NO_ADDRCONF = 1073741824,
	IFF_TX_SKB_NO_LINEAR = 2147483648,
};

enum netdev_qstats_scope {
	NETDEV_QSTATS_SCOPE_QUEUE = 1,
};

enum netdev_queue_state_t {
	__QUEUE_STATE_DRV_XOFF = 0,
	__QUEUE_STATE_STACK_XOFF = 1,
	__QUEUE_STATE_FROZEN = 2,
};

enum netdev_queue_type {
	NETDEV_QUEUE_TYPE_RX = 0,
	NETDEV_QUEUE_TYPE_TX = 1,
};

enum netdev_reg_state {
	NETREG_UNINITIALIZED = 0,
	NETREG_REGISTERED = 1,
	NETREG_UNREGISTERING = 2,
	NETREG_UNREGISTERED = 3,
	NETREG_RELEASED = 4,
	NETREG_DUMMY = 5,
};

enum netdev_stat_type {
	NETDEV_PCPU_STAT_NONE = 0,
	NETDEV_PCPU_STAT_LSTATS = 1,
	NETDEV_PCPU_STAT_TSTATS = 2,
	NETDEV_PCPU_STAT_DSTATS = 3,
};

enum netdev_state_t {
	__LINK_STATE_START = 0,
	__LINK_STATE_PRESENT = 1,
	__LINK_STATE_NOCARRIER = 2,
	__LINK_STATE_LINKWATCH_PENDING = 3,
	__LINK_STATE_DORMANT = 4,
	__LINK_STATE_TESTING = 5,
};

enum netdev_tx {
	__NETDEV_TX_MIN = -2147483648,
	NETDEV_TX_OK = 0,
	NETDEV_TX_BUSY = 16,
};

typedef enum netdev_tx netdev_tx_t;

enum netdev_xdp_act {
	NETDEV_XDP_ACT_BASIC = 1,
	NETDEV_XDP_ACT_REDIRECT = 2,
	NETDEV_XDP_ACT_NDO_XMIT = 4,
	NETDEV_XDP_ACT_XSK_ZEROCOPY = 8,
	NETDEV_XDP_ACT_HW_OFFLOAD = 16,
	NETDEV_XDP_ACT_RX_SG = 32,
	NETDEV_XDP_ACT_NDO_XMIT_SG = 64,
	NETDEV_XDP_ACT_MASK = 127,
};

enum netdev_xdp_rx_metadata {
	NETDEV_XDP_RX_METADATA_TIMESTAMP = 1,
	NETDEV_XDP_RX_METADATA_HASH = 2,
	NETDEV_XDP_RX_METADATA_VLAN_TAG = 4,
};

enum netdev_xsk_flags {
	NETDEV_XSK_FLAGS_TX_TIMESTAMP = 1,
	NETDEV_XSK_FLAGS_TX_CHECKSUM = 2,
	NETDEV_XSK_FLAGS_TX_LAUNCH_TIME_FIFO = 4,
};

enum netevent_notif_type {
	NETEVENT_NEIGH_UPDATE = 1,
	NETEVENT_REDIRECT = 2,
	NETEVENT_DELAY_PROBE_TIME_UPDATE = 3,
	NETEVENT_IPV4_MPATH_HASH_UPDATE = 4,
	NETEVENT_IPV6_MPATH_HASH_UPDATE = 5,
	NETEVENT_IPV4_FWD_UPDATE_PRIORITY_UPDATE = 6,
};

enum netlink_attribute_type {
	NL_ATTR_TYPE_INVALID = 0,
	NL_ATTR_TYPE_FLAG = 1,
	NL_ATTR_TYPE_U8 = 2,
	NL_ATTR_TYPE_U16 = 3,
	NL_ATTR_TYPE_U32 = 4,
	NL_ATTR_TYPE_U64 = 5,
	NL_ATTR_TYPE_S8 = 6,
	NL_ATTR_TYPE_S16 = 7,
	NL_ATTR_TYPE_S32 = 8,
	NL_ATTR_TYPE_S64 = 9,
	NL_ATTR_TYPE_BINARY = 10,
	NL_ATTR_TYPE_STRING = 11,
	NL_ATTR_TYPE_NUL_STRING = 12,
	NL_ATTR_TYPE_NESTED = 13,
	NL_ATTR_TYPE_NESTED_ARRAY = 14,
	NL_ATTR_TYPE_BITFIELD32 = 15,
	NL_ATTR_TYPE_SINT = 16,
	NL_ATTR_TYPE_UINT = 17,
};

enum netlink_policy_type_attr {
	NL_POLICY_TYPE_ATTR_UNSPEC = 0,
	NL_POLICY_TYPE_ATTR_TYPE = 1,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_S = 2,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_S = 3,
	NL_POLICY_TYPE_ATTR_MIN_VALUE_U = 4,
	NL_POLICY_TYPE_ATTR_MAX_VALUE_U = 5,
	NL_POLICY_TYPE_ATTR_MIN_LENGTH = 6,
	NL_POLICY_TYPE_ATTR_MAX_LENGTH = 7,
	NL_POLICY_TYPE_ATTR_POLICY_IDX = 8,
	NL_POLICY_TYPE_ATTR_POLICY_MAXTYPE = 9,
	NL_POLICY_TYPE_ATTR_BITFIELD32_MASK = 10,
	NL_POLICY_TYPE_ATTR_PAD = 11,
	NL_POLICY_TYPE_ATTR_MASK = 12,
	__NL_POLICY_TYPE_ATTR_MAX = 13,
	NL_POLICY_TYPE_ATTR_MAX = 12,
};

enum netlink_skb_flags {
	NETLINK_SKB_DST = 8,
};

enum netlink_validation {
	NL_VALIDATE_LIBERAL = 0,
	NL_VALIDATE_TRAILING = 1,
	NL_VALIDATE_MAXTYPE = 2,
	NL_VALIDATE_UNSPEC = 4,
	NL_VALIDATE_STRICT_ATTRS = 8,
	NL_VALIDATE_NESTED = 16,
};

enum netloc_type4 {
	NL4_NAME = 1,
	NL4_URL = 2,
	NL4_NETADDR = 3,
};

enum netns_bpf_attach_type {
	NETNS_BPF_INVALID = -1,
	NETNS_BPF_FLOW_DISSECTOR = 0,
	NETNS_BPF_SK_LOOKUP = 1,
	MAX_NETNS_BPF_ATTACH_TYPE = 2,
};

enum nexthop_event_type {
	NEXTHOP_EVENT_DEL = 0,
	NEXTHOP_EVENT_REPLACE = 1,
	NEXTHOP_EVENT_RES_TABLE_PRE_REPLACE = 2,
	NEXTHOP_EVENT_BUCKET_REPLACE = 3,
	NEXTHOP_EVENT_HW_STATS_REPORT_DELTA = 4,
};

enum nf_ct_ext_id {
	NF_CT_EXT_HELPER = 0,
	NF_CT_EXT_NAT = 1,
	NF_CT_EXT_SEQADJ = 2,
	NF_CT_EXT_ACCT = 3,
	NF_CT_EXT_ECACHE = 4,
	NF_CT_EXT_TSTAMP = 5,
	NF_CT_EXT_TIMEOUT = 6,
	NF_CT_EXT_LABELS = 7,
	NF_CT_EXT_SYNPROXY = 8,
	NF_CT_EXT_ACT_CT = 9,
	NF_CT_EXT_NUM = 10,
};

enum nf_dev_hooks {
	NF_NETDEV_INGRESS = 0,
	NF_NETDEV_EGRESS = 1,
	NF_NETDEV_NUMHOOKS = 2,
};

enum nf_hook_ops_type {
	NF_HOOK_OP_UNDEFINED = 0,
	NF_HOOK_OP_NF_TABLES = 1,
	NF_HOOK_OP_BPF = 2,
};

enum nf_inet_hooks {
	NF_INET_PRE_ROUTING = 0,
	NF_INET_LOCAL_IN = 1,
	NF_INET_FORWARD = 2,
	NF_INET_LOCAL_OUT = 3,
	NF_INET_POST_ROUTING = 4,
	NF_INET_NUMHOOKS = 5,
	NF_INET_INGRESS = 5,
};

enum nf_ip_hook_priorities {
	NF_IP_PRI_FIRST = -2147483648,
	NF_IP_PRI_RAW_BEFORE_DEFRAG = -450,
	NF_IP_PRI_CONNTRACK_DEFRAG = -400,
	NF_IP_PRI_RAW = -300,
	NF_IP_PRI_SELINUX_FIRST = -225,
	NF_IP_PRI_CONNTRACK = -200,
	NF_IP_PRI_MANGLE = -150,
	NF_IP_PRI_NAT_DST = -100,
	NF_IP_PRI_FILTER = 0,
	NF_IP_PRI_SECURITY = 50,
	NF_IP_PRI_NAT_SRC = 100,
	NF_IP_PRI_SELINUX_LAST = 225,
	NF_IP_PRI_CONNTRACK_HELPER = 300,
	NF_IP_PRI_CONNTRACK_CONFIRM = 2147483647,
	NF_IP_PRI_LAST = 2147483647,
};

enum nf_log_type {
	NF_LOG_TYPE_LOG = 0,
	NF_LOG_TYPE_ULOG = 1,
	NF_LOG_TYPE_MAX = 2,
};

enum nf_nat_manip_type;

enum nfs2_ftype {
	NF2NON = 0,
	NF2REG = 1,
	NF2DIR = 2,
	NF2BLK = 3,
	NF2CHR = 4,
	NF2LNK = 5,
	NF2SOCK = 6,
	NF2BAD = 7,
	NF2FIFO = 8,
};

enum nfs3_createmode {
	NFS3_CREATE_UNCHECKED = 0,
	NFS3_CREATE_GUARDED = 1,
	NFS3_CREATE_EXCLUSIVE = 2,
};

enum nfs3_ftype {
	NF3NON = 0,
	NF3REG = 1,
	NF3DIR = 2,
	NF3BLK = 3,
	NF3CHR = 4,
	NF3LNK = 5,
	NF3SOCK = 6,
	NF3FIFO = 7,
	NF3BAD = 8,
};

enum nfs3_stable_how {
	NFS_UNSTABLE = 0,
	NFS_DATA_SYNC = 1,
	NFS_FILE_SYNC = 2,
	NFS_INVALID_STABLE_HOW = -1,
};

enum nfs4_acl_type {
	NFS4ACL_NONE = 0,
	NFS4ACL_ACL = 1,
	NFS4ACL_DACL = 2,
	NFS4ACL_SACL = 3,
};

enum nfs4_callback_procnum {
	CB_NULL = 0,
	CB_COMPOUND = 1,
};

enum nfs4_change_attr_type {
	NFS4_CHANGE_TYPE_IS_MONOTONIC_INCR = 0,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER = 1,
	NFS4_CHANGE_TYPE_IS_VERSION_COUNTER_NOPNFS = 2,
	NFS4_CHANGE_TYPE_IS_TIME_METADATA = 3,
	NFS4_CHANGE_TYPE_IS_UNDEFINED = 4,
};

enum nfs4_client_state {
	NFS4CLNT_MANAGER_RUNNING = 0,
	NFS4CLNT_CHECK_LEASE = 1,
	NFS4CLNT_LEASE_EXPIRED = 2,
	NFS4CLNT_RECLAIM_REBOOT = 3,
	NFS4CLNT_RECLAIM_NOGRACE = 4,
	NFS4CLNT_DELEGRETURN = 5,
	NFS4CLNT_SESSION_RESET = 6,
	NFS4CLNT_LEASE_CONFIRM = 7,
	NFS4CLNT_SERVER_SCOPE_MISMATCH = 8,
	NFS4CLNT_PURGE_STATE = 9,
	NFS4CLNT_BIND_CONN_TO_SESSION = 10,
	NFS4CLNT_MOVED = 11,
	NFS4CLNT_LEASE_MOVED = 12,
	NFS4CLNT_DELEGATION_EXPIRED = 13,
	NFS4CLNT_RUN_MANAGER = 14,
	NFS4CLNT_MANAGER_AVAILABLE = 15,
	NFS4CLNT_RECALL_RUNNING = 16,
	NFS4CLNT_RECALL_ANY_LAYOUT_READ = 17,
	NFS4CLNT_RECALL_ANY_LAYOUT_RW = 18,
	NFS4CLNT_DELEGRETURN_DELAYED = 19,
};

enum nfs4_ff_op_type {
	NFS4_FF_OP_LAYOUTSTATS = 0,
	NFS4_FF_OP_LAYOUTRETURN = 1,
};

enum nfs4_open_delegation_type4 {
	NFS4_OPEN_DELEGATE_NONE = 0,
	NFS4_OPEN_DELEGATE_READ = 1,
	NFS4_OPEN_DELEGATE_WRITE = 2,
	NFS4_OPEN_DELEGATE_NONE_EXT = 3,
	NFS4_OPEN_DELEGATE_READ_ATTRS_DELEG = 4,
	NFS4_OPEN_DELEGATE_WRITE_ATTRS_DELEG = 5,
};

enum nfs4_session_state {
	NFS4_SESSION_INITING = 0,
	NFS4_SESSION_ESTABLISHED = 1,
};

enum nfs4_setxattr_options {
	SETXATTR4_EITHER = 0,
	SETXATTR4_CREATE = 1,
	SETXATTR4_REPLACE = 2,
};

enum nfs4_slot_tbl_state {
	NFS4_SLOT_TBL_DRAINING = 0,
};

enum nfs_cb_opnum4 {
	OP_CB_GETATTR = 3,
	OP_CB_RECALL = 4,
	OP_CB_LAYOUTRECALL = 5,
	OP_CB_NOTIFY = 6,
	OP_CB_PUSH_DELEG = 7,
	OP_CB_RECALL_ANY = 8,
	OP_CB_RECALLABLE_OBJ_AVAIL = 9,
	OP_CB_RECALL_SLOT = 10,
	OP_CB_SEQUENCE = 11,
	OP_CB_WANTS_CANCELLED = 12,
	OP_CB_NOTIFY_LOCK = 13,
	OP_CB_NOTIFY_DEVICEID = 14,
	OP_CB_OFFLOAD = 15,
	OP_CB_ILLEGAL = 10044,
};

enum nfs_ftype {
	NFNON = 0,
	NFREG = 1,
	NFDIR = 2,
	NFBLK = 3,
	NFCHR = 4,
	NFLNK = 5,
	NFSOCK = 6,
	NFBAD = 7,
	NFFIFO = 8,
};

enum nfs_ftype4 {
	NF4BAD = 0,
	NF4REG = 1,
	NF4DIR = 2,
	NF4BLK = 3,
	NF4CHR = 4,
	NF4LNK = 5,
	NF4SOCK = 6,
	NF4FIFO = 7,
	NF4ATTRDIR = 8,
	NF4NAMEDATTR = 9,
};

enum nfs_lock_status {
	NFS_LOCK_NOT_SET = 0,
	NFS_LOCK_LOCK = 1,
	NFS_LOCK_NOLOCK = 2,
};

enum nfs_opnum4 {
	OP_ACCESS = 3,
	OP_CLOSE = 4,
	OP_COMMIT = 5,
	OP_CREATE = 6,
	OP_DELEGPURGE = 7,
	OP_DELEGRETURN = 8,
	OP_GETATTR = 9,
	OP_GETFH = 10,
	OP_LINK = 11,
	OP_LOCK = 12,
	OP_LOCKT = 13,
	OP_LOCKU = 14,
	OP_LOOKUP = 15,
	OP_LOOKUPP = 16,
	OP_NVERIFY = 17,
	OP_OPEN = 18,
	OP_OPENATTR = 19,
	OP_OPEN_CONFIRM = 20,
	OP_OPEN_DOWNGRADE = 21,
	OP_PUTFH = 22,
	OP_PUTPUBFH = 23,
	OP_PUTROOTFH = 24,
	OP_READ = 25,
	OP_READDIR = 26,
	OP_READLINK = 27,
	OP_REMOVE = 28,
	OP_RENAME = 29,
	OP_RENEW = 30,
	OP_RESTOREFH = 31,
	OP_SAVEFH = 32,
	OP_SECINFO = 33,
	OP_SETATTR = 34,
	OP_SETCLIENTID = 35,
	OP_SETCLIENTID_CONFIRM = 36,
	OP_VERIFY = 37,
	OP_WRITE = 38,
	OP_RELEASE_LOCKOWNER = 39,
	OP_BACKCHANNEL_CTL = 40,
	OP_BIND_CONN_TO_SESSION = 41,
	OP_EXCHANGE_ID = 42,
	OP_CREATE_SESSION = 43,
	OP_DESTROY_SESSION = 44,
	OP_FREE_STATEID = 45,
	OP_GET_DIR_DELEGATION = 46,
	OP_GETDEVICEINFO = 47,
	OP_GETDEVICELIST = 48,
	OP_LAYOUTCOMMIT = 49,
	OP_LAYOUTGET = 50,
	OP_LAYOUTRETURN = 51,
	OP_SECINFO_NO_NAME = 52,
	OP_SEQUENCE = 53,
	OP_SET_SSV = 54,
	OP_TEST_STATEID = 55,
	OP_WANT_DELEGATION = 56,
	OP_DESTROY_CLIENTID = 57,
	OP_RECLAIM_COMPLETE = 58,
	OP_ALLOCATE = 59,
	OP_COPY = 60,
	OP_COPY_NOTIFY = 61,
	OP_DEALLOCATE = 62,
	OP_IO_ADVISE = 63,
	OP_LAYOUTERROR = 64,
	OP_LAYOUTSTATS = 65,
	OP_OFFLOAD_CANCEL = 66,
	OP_OFFLOAD_STATUS = 67,
	OP_READ_PLUS = 68,
	OP_SEEK = 69,
	OP_WRITE_SAME = 70,
	OP_CLONE = 71,
	OP_GETXATTR = 72,
	OP_SETXATTR = 73,
	OP_LISTXATTRS = 74,
	OP_REMOVEXATTR = 75,
	OP_ILLEGAL = 10044,
};

enum nfs_param {
	Opt_ac = 0,
	Opt_acdirmax = 1,
	Opt_acdirmin = 2,
	Opt_acl___4 = 3,
	Opt_acregmax = 4,
	Opt_acregmin = 5,
	Opt_actimeo = 6,
	Opt_addr = 7,
	Opt_bg = 8,
	Opt_bsize = 9,
	Opt_clientaddr = 10,
	Opt_cto = 11,
	Opt_alignwrite = 12,
	Opt_fatal_neterrors = 13,
	Opt_fg = 14,
	Opt_fscache = 15,
	Opt_fscache_flag = 16,
	Opt_hard = 17,
	Opt_intr = 18,
	Opt_local_lock = 19,
	Opt_lock = 20,
	Opt_lookupcache = 21,
	Opt_migration = 22,
	Opt_minorversion = 23,
	Opt_mountaddr = 24,
	Opt_mounthost = 25,
	Opt_mountport = 26,
	Opt_mountproto = 27,
	Opt_mountvers = 28,
	Opt_namelen = 29,
	Opt_nconnect = 30,
	Opt_max_connect = 31,
	Opt_port = 32,
	Opt_posix = 33,
	Opt_proto = 34,
	Opt_rdirplus = 35,
	Opt_rdirplus_none = 36,
	Opt_rdirplus_force = 37,
	Opt_rdma = 38,
	Opt_resvport = 39,
	Opt_retrans = 40,
	Opt_retry = 41,
	Opt_rsize = 42,
	Opt_sec = 43,
	Opt_sharecache = 44,
	Opt_sloppy = 45,
	Opt_soft = 46,
	Opt_softerr = 47,
	Opt_softreval = 48,
	Opt_source___2 = 49,
	Opt_tcp = 50,
	Opt_timeo = 51,
	Opt_trunkdiscovery = 52,
	Opt_udp = 53,
	Opt_v = 54,
	Opt_vers = 55,
	Opt_wsize = 56,
	Opt_write = 57,
	Opt_xprtsec = 58,
};

enum nfs_stat {
	NFS_OK = 0,
	NFSERR_PERM = 1,
	NFSERR_NOENT = 2,
	NFSERR_IO = 5,
	NFSERR_NXIO = 6,
	NFSERR_EAGAIN = 11,
	NFSERR_ACCES = 13,
	NFSERR_EXIST = 17,
	NFSERR_XDEV = 18,
	NFSERR_NODEV = 19,
	NFSERR_NOTDIR = 20,
	NFSERR_ISDIR = 21,
	NFSERR_INVAL = 22,
	NFSERR_FBIG = 27,
	NFSERR_NOSPC = 28,
	NFSERR_ROFS = 30,
	NFSERR_MLINK = 31,
	NFSERR_NAMETOOLONG = 63,
	NFSERR_NOTEMPTY = 66,
	NFSERR_DQUOT = 69,
	NFSERR_STALE = 70,
	NFSERR_REMOTE = 71,
	NFSERR_WFLUSH = 99,
	NFSERR_BADHANDLE = 10001,
	NFSERR_NOT_SYNC = 10002,
	NFSERR_BAD_COOKIE = 10003,
	NFSERR_NOTSUPP = 10004,
	NFSERR_TOOSMALL = 10005,
	NFSERR_SERVERFAULT = 10006,
	NFSERR_BADTYPE = 10007,
	NFSERR_JUKEBOX = 10008,
	NFSERR_SAME = 10009,
	NFSERR_DENIED = 10010,
	NFSERR_EXPIRED = 10011,
	NFSERR_LOCKED = 10012,
	NFSERR_GRACE = 10013,
	NFSERR_FHEXPIRED = 10014,
	NFSERR_SHARE_DENIED = 10015,
	NFSERR_WRONGSEC = 10016,
	NFSERR_CLID_INUSE = 10017,
	NFSERR_RESOURCE = 10018,
	NFSERR_MOVED = 10019,
	NFSERR_NOFILEHANDLE = 10020,
	NFSERR_MINOR_VERS_MISMATCH = 10021,
	NFSERR_STALE_CLIENTID = 10022,
	NFSERR_STALE_STATEID = 10023,
	NFSERR_OLD_STATEID = 10024,
	NFSERR_BAD_STATEID = 10025,
	NFSERR_BAD_SEQID = 10026,
	NFSERR_NOT_SAME = 10027,
	NFSERR_LOCK_RANGE = 10028,
	NFSERR_SYMLINK = 10029,
	NFSERR_RESTOREFH = 10030,
	NFSERR_LEASE_MOVED = 10031,
	NFSERR_ATTRNOTSUPP = 10032,
	NFSERR_NO_GRACE = 10033,
	NFSERR_RECLAIM_BAD = 10034,
	NFSERR_RECLAIM_CONFLICT = 10035,
	NFSERR_BAD_XDR = 10036,
	NFSERR_LOCKS_HELD = 10037,
	NFSERR_OPENMODE = 10038,
	NFSERR_BADOWNER = 10039,
	NFSERR_BADCHAR = 10040,
	NFSERR_BADNAME = 10041,
	NFSERR_BAD_RANGE = 10042,
	NFSERR_LOCK_NOTSUPP = 10043,
	NFSERR_OP_ILLEGAL = 10044,
	NFSERR_DEADLOCK = 10045,
	NFSERR_FILE_OPEN = 10046,
	NFSERR_ADMIN_REVOKED = 10047,
	NFSERR_CB_PATH_DOWN = 10048,
};

enum nfs_stat_bytecounters {
	NFSIOS_NORMALREADBYTES = 0,
	NFSIOS_NORMALWRITTENBYTES = 1,
	NFSIOS_DIRECTREADBYTES = 2,
	NFSIOS_DIRECTWRITTENBYTES = 3,
	NFSIOS_SERVERREADBYTES = 4,
	NFSIOS_SERVERWRITTENBYTES = 5,
	NFSIOS_READPAGES = 6,
	NFSIOS_WRITEPAGES = 7,
	__NFSIOS_BYTESMAX = 8,
};

enum nfs_stat_eventcounters {
	NFSIOS_INODEREVALIDATE = 0,
	NFSIOS_DENTRYREVALIDATE = 1,
	NFSIOS_DATAINVALIDATE = 2,
	NFSIOS_ATTRINVALIDATE = 3,
	NFSIOS_VFSOPEN = 4,
	NFSIOS_VFSLOOKUP = 5,
	NFSIOS_VFSACCESS = 6,
	NFSIOS_VFSUPDATEPAGE = 7,
	NFSIOS_VFSREADPAGE = 8,
	NFSIOS_VFSREADPAGES = 9,
	NFSIOS_VFSWRITEPAGE = 10,
	NFSIOS_VFSWRITEPAGES = 11,
	NFSIOS_VFSGETDENTS = 12,
	NFSIOS_VFSSETATTR = 13,
	NFSIOS_VFSFLUSH = 14,
	NFSIOS_VFSFSYNC = 15,
	NFSIOS_VFSLOCK = 16,
	NFSIOS_VFSRELEASE = 17,
	NFSIOS_CONGESTIONWAIT = 18,
	NFSIOS_SETATTRTRUNC = 19,
	NFSIOS_EXTENDWRITE = 20,
	NFSIOS_SILLYRENAME = 21,
	NFSIOS_SHORTREAD = 22,
	NFSIOS_SHORTWRITE = 23,
	NFSIOS_DELAY = 24,
	NFSIOS_PNFS_READ = 25,
	NFSIOS_PNFS_WRITE = 26,
	__NFSIOS_COUNTSMAX = 27,
};

enum nfsstat4 {
	NFS4_OK = 0,
	NFS4ERR_PERM = 1,
	NFS4ERR_NOENT = 2,
	NFS4ERR_IO = 5,
	NFS4ERR_NXIO = 6,
	NFS4ERR_ACCESS = 13,
	NFS4ERR_EXIST = 17,
	NFS4ERR_XDEV = 18,
	NFS4ERR_NOTDIR = 20,
	NFS4ERR_ISDIR = 21,
	NFS4ERR_INVAL = 22,
	NFS4ERR_FBIG = 27,
	NFS4ERR_NOSPC = 28,
	NFS4ERR_ROFS = 30,
	NFS4ERR_MLINK = 31,
	NFS4ERR_NAMETOOLONG = 63,
	NFS4ERR_NOTEMPTY = 66,
	NFS4ERR_DQUOT = 69,
	NFS4ERR_STALE = 70,
	NFS4ERR_BADHANDLE = 10001,
	NFS4ERR_BAD_COOKIE = 10003,
	NFS4ERR_NOTSUPP = 10004,
	NFS4ERR_TOOSMALL = 10005,
	NFS4ERR_SERVERFAULT = 10006,
	NFS4ERR_BADTYPE = 10007,
	NFS4ERR_DELAY = 10008,
	NFS4ERR_SAME = 10009,
	NFS4ERR_DENIED = 10010,
	NFS4ERR_EXPIRED = 10011,
	NFS4ERR_LOCKED = 10012,
	NFS4ERR_GRACE = 10013,
	NFS4ERR_FHEXPIRED = 10014,
	NFS4ERR_SHARE_DENIED = 10015,
	NFS4ERR_WRONGSEC = 10016,
	NFS4ERR_CLID_INUSE = 10017,
	NFS4ERR_RESOURCE = 10018,
	NFS4ERR_MOVED = 10019,
	NFS4ERR_NOFILEHANDLE = 10020,
	NFS4ERR_MINOR_VERS_MISMATCH = 10021,
	NFS4ERR_STALE_CLIENTID = 10022,
	NFS4ERR_STALE_STATEID = 10023,
	NFS4ERR_OLD_STATEID = 10024,
	NFS4ERR_BAD_STATEID = 10025,
	NFS4ERR_BAD_SEQID = 10026,
	NFS4ERR_NOT_SAME = 10027,
	NFS4ERR_LOCK_RANGE = 10028,
	NFS4ERR_SYMLINK = 10029,
	NFS4ERR_RESTOREFH = 10030,
	NFS4ERR_LEASE_MOVED = 10031,
	NFS4ERR_ATTRNOTSUPP = 10032,
	NFS4ERR_NO_GRACE = 10033,
	NFS4ERR_RECLAIM_BAD = 10034,
	NFS4ERR_RECLAIM_CONFLICT = 10035,
	NFS4ERR_BADXDR = 10036,
	NFS4ERR_LOCKS_HELD = 10037,
	NFS4ERR_OPENMODE = 10038,
	NFS4ERR_BADOWNER = 10039,
	NFS4ERR_BADCHAR = 10040,
	NFS4ERR_BADNAME = 10041,
	NFS4ERR_BAD_RANGE = 10042,
	NFS4ERR_LOCK_NOTSUPP = 10043,
	NFS4ERR_OP_ILLEGAL = 10044,
	NFS4ERR_DEADLOCK = 10045,
	NFS4ERR_FILE_OPEN = 10046,
	NFS4ERR_ADMIN_REVOKED = 10047,
	NFS4ERR_CB_PATH_DOWN = 10048,
	NFS4ERR_BADIOMODE = 10049,
	NFS4ERR_BADLAYOUT = 10050,
	NFS4ERR_BAD_SESSION_DIGEST = 10051,
	NFS4ERR_BADSESSION = 10052,
	NFS4ERR_BADSLOT = 10053,
	NFS4ERR_COMPLETE_ALREADY = 10054,
	NFS4ERR_CONN_NOT_BOUND_TO_SESSION = 10055,
	NFS4ERR_DELEG_ALREADY_WANTED = 10056,
	NFS4ERR_BACK_CHAN_BUSY = 10057,
	NFS4ERR_LAYOUTTRYLATER = 10058,
	NFS4ERR_LAYOUTUNAVAILABLE = 10059,
	NFS4ERR_NOMATCHING_LAYOUT = 10060,
	NFS4ERR_RECALLCONFLICT = 10061,
	NFS4ERR_UNKNOWN_LAYOUTTYPE = 10062,
	NFS4ERR_SEQ_MISORDERED = 10063,
	NFS4ERR_SEQUENCE_POS = 10064,
	NFS4ERR_REQ_TOO_BIG = 10065,
	NFS4ERR_REP_TOO_BIG = 10066,
	NFS4ERR_REP_TOO_BIG_TO_CACHE = 10067,
	NFS4ERR_RETRY_UNCACHED_REP = 10068,
	NFS4ERR_UNSAFE_COMPOUND = 10069,
	NFS4ERR_TOO_MANY_OPS = 10070,
	NFS4ERR_OP_NOT_IN_SESSION = 10071,
	NFS4ERR_HASH_ALG_UNSUPP = 10072,
	NFS4ERR_CLIENTID_BUSY = 10074,
	NFS4ERR_PNFS_IO_HOLE = 10075,
	NFS4ERR_SEQ_FALSE_RETRY = 10076,
	NFS4ERR_BAD_HIGH_SLOT = 10077,
	NFS4ERR_DEADSESSION = 10078,
	NFS4ERR_ENCR_ALG_UNSUPP = 10079,
	NFS4ERR_PNFS_NO_LAYOUT = 10080,
	NFS4ERR_NOT_ONLY_OP = 10081,
	NFS4ERR_WRONG_CRED = 10082,
	NFS4ERR_WRONG_TYPE = 10083,
	NFS4ERR_DIRDELEG_UNAVAIL = 10084,
	NFS4ERR_REJECT_DELEG = 10085,
	NFS4ERR_RETURNCONFLICT = 10086,
	NFS4ERR_DELEG_REVOKED = 10087,
	NFS4ERR_PARTNER_NOTSUPP = 10088,
	NFS4ERR_PARTNER_NO_AUTH = 10089,
	NFS4ERR_UNION_NOTSUPP = 10090,
	NFS4ERR_OFFLOAD_DENIED = 10091,
	NFS4ERR_WRONG_LFS = 10092,
	NFS4ERR_BADLABEL = 10093,
	NFS4ERR_OFFLOAD_NO_REQS = 10094,
	NFS4ERR_NOXATTR = 10095,
	NFS4ERR_XATTR2BIG = 10096,
	NFS4ERR_FIRST_FREE = 10097,
};

enum nh_notifier_info_type {
	NH_NOTIFIER_INFO_TYPE_SINGLE = 0,
	NH_NOTIFIER_INFO_TYPE_GRP = 1,
	NH_NOTIFIER_INFO_TYPE_RES_TABLE = 2,
	NH_NOTIFIER_INFO_TYPE_RES_BUCKET = 3,
	NH_NOTIFIER_INFO_TYPE_GRP_HW_STATS = 4,
};

enum nid_state {
	FREE_NID = 0,
	PREALLOC_NID = 1,
	MAX_NID_STATE = 2,
};

enum nl80211_auth_type {
	NL80211_AUTHTYPE_OPEN_SYSTEM = 0,
	NL80211_AUTHTYPE_SHARED_KEY = 1,
	NL80211_AUTHTYPE_FT = 2,
	NL80211_AUTHTYPE_NETWORK_EAP = 3,
	NL80211_AUTHTYPE_SAE = 4,
	NL80211_AUTHTYPE_FILS_SK = 5,
	NL80211_AUTHTYPE_FILS_SK_PFS = 6,
	NL80211_AUTHTYPE_FILS_PK = 7,
	__NL80211_AUTHTYPE_NUM = 8,
	NL80211_AUTHTYPE_MAX = 7,
	NL80211_AUTHTYPE_AUTOMATIC = 8,
};

enum nl80211_band {
	NL80211_BAND_2GHZ = 0,
	NL80211_BAND_5GHZ = 1,
	NL80211_BAND_60GHZ = 2,
	NL80211_BAND_6GHZ = 3,
	NL80211_BAND_S1GHZ = 4,
	NL80211_BAND_LC = 5,
	NUM_NL80211_BANDS = 6,
};

enum nl80211_bss_select_attr {
	__NL80211_BSS_SELECT_ATTR_INVALID = 0,
	NL80211_BSS_SELECT_ATTR_RSSI = 1,
	NL80211_BSS_SELECT_ATTR_BAND_PREF = 2,
	NL80211_BSS_SELECT_ATTR_RSSI_ADJUST = 3,
	__NL80211_BSS_SELECT_ATTR_AFTER_LAST = 4,
	NL80211_BSS_SELECT_ATTR_MAX = 3,
};

enum nl80211_chan_width {
	NL80211_CHAN_WIDTH_20_NOHT = 0,
	NL80211_CHAN_WIDTH_20 = 1,
	NL80211_CHAN_WIDTH_40 = 2,
	NL80211_CHAN_WIDTH_80 = 3,
	NL80211_CHAN_WIDTH_80P80 = 4,
	NL80211_CHAN_WIDTH_160 = 5,
	NL80211_CHAN_WIDTH_5 = 6,
	NL80211_CHAN_WIDTH_10 = 7,
	NL80211_CHAN_WIDTH_1 = 8,
	NL80211_CHAN_WIDTH_2 = 9,
	NL80211_CHAN_WIDTH_4 = 10,
	NL80211_CHAN_WIDTH_8 = 11,
	NL80211_CHAN_WIDTH_16 = 12,
	NL80211_CHAN_WIDTH_320 = 13,
};

enum nl80211_dfs_regions {
	NL80211_DFS_UNSET = 0,
	NL80211_DFS_FCC = 1,
	NL80211_DFS_ETSI = 2,
	NL80211_DFS_JP = 3,
};

enum nl80211_dfs_state {
	NL80211_DFS_USABLE = 0,
	NL80211_DFS_UNAVAILABLE = 1,
	NL80211_DFS_AVAILABLE = 2,
};

enum nl80211_iftype {
	NL80211_IFTYPE_UNSPECIFIED = 0,
	NL80211_IFTYPE_ADHOC = 1,
	NL80211_IFTYPE_STATION = 2,
	NL80211_IFTYPE_AP = 3,
	NL80211_IFTYPE_AP_VLAN = 4,
	NL80211_IFTYPE_WDS = 5,
	NL80211_IFTYPE_MONITOR = 6,
	NL80211_IFTYPE_MESH_POINT = 7,
	NL80211_IFTYPE_P2P_CLIENT = 8,
	NL80211_IFTYPE_P2P_GO = 9,
	NL80211_IFTYPE_P2P_DEVICE = 10,
	NL80211_IFTYPE_OCB = 11,
	NL80211_IFTYPE_NAN = 12,
	NUM_NL80211_IFTYPES = 13,
	NL80211_IFTYPE_MAX = 12,
};

enum nl80211_key_mode {
	NL80211_KEY_RX_TX = 0,
	NL80211_KEY_NO_TX = 1,
	NL80211_KEY_SET_TX = 2,
};

enum nl80211_mfp {
	NL80211_MFP_NO = 0,
	NL80211_MFP_REQUIRED = 1,
	NL80211_MFP_OPTIONAL = 2,
};

enum nl80211_reg_initiator {
	NL80211_REGDOM_SET_BY_CORE = 0,
	NL80211_REGDOM_SET_BY_USER = 1,
	NL80211_REGDOM_SET_BY_DRIVER = 2,
	NL80211_REGDOM_SET_BY_COUNTRY_IE = 3,
};

enum nl80211_sae_pwe_mechanism {
	NL80211_SAE_PWE_UNSPECIFIED = 0,
	NL80211_SAE_PWE_HUNT_AND_PECK = 1,
	NL80211_SAE_PWE_HASH_TO_ELEMENT = 2,
	NL80211_SAE_PWE_BOTH = 3,
};

enum nl80211_sar_type {
	NL80211_SAR_TYPE_POWER = 0,
	NUM_NL80211_SAR_TYPE = 1,
};

enum nl80211_user_reg_hint_type {
	NL80211_USER_REG_HINT_USER = 0,
	NL80211_USER_REG_HINT_CELL_BASE = 1,
	NL80211_USER_REG_HINT_INDOOR = 2,
};

enum nl802154_cca_modes {
	__NL802154_CCA_INVALID = 0,
	NL802154_CCA_ENERGY = 1,
	NL802154_CCA_CARRIER = 2,
	NL802154_CCA_ENERGY_CARRIER = 3,
	NL802154_CCA_ALOHA = 4,
	NL802154_CCA_UWB_SHR = 5,
	NL802154_CCA_UWB_MULTIPLEXED = 6,
	__NL802154_CCA_ATTR_AFTER_LAST = 7,
	NL802154_CCA_ATTR_MAX = 6,
};

enum nl802154_cca_opts {
	NL802154_CCA_OPT_ENERGY_CARRIER_AND = 0,
	NL802154_CCA_OPT_ENERGY_CARRIER_OR = 1,
	__NL802154_CCA_OPT_ATTR_AFTER_LAST = 2,
	NL802154_CCA_OPT_ATTR_MAX = 1,
};

enum nl802154_supported_bool_states {
	NL802154_SUPPORTED_BOOL_FALSE = 0,
	NL802154_SUPPORTED_BOOL_TRUE = 1,
	__NL802154_SUPPORTED_BOOL_INVALD = 2,
	NL802154_SUPPORTED_BOOL_BOTH = 3,
	__NL802154_SUPPORTED_BOOL_AFTER_LAST = 4,
	NL802154_SUPPORTED_BOOL_MAX = 3,
};

enum nla_policy_validation {
	NLA_VALIDATE_NONE = 0,
	NLA_VALIDATE_RANGE = 1,
	NLA_VALIDATE_RANGE_WARN_TOO_LONG = 2,
	NLA_VALIDATE_MIN = 3,
	NLA_VALIDATE_MAX = 4,
	NLA_VALIDATE_MASK = 5,
	NLA_VALIDATE_RANGE_PTR = 6,
	NLA_VALIDATE_FUNCTION = 7,
};

enum nlmsgerr_attrs {
	NLMSGERR_ATTR_UNUSED = 0,
	NLMSGERR_ATTR_MSG = 1,
	NLMSGERR_ATTR_OFFS = 2,
	NLMSGERR_ATTR_COOKIE = 3,
	NLMSGERR_ATTR_POLICY = 4,
	NLMSGERR_ATTR_MISS_TYPE = 5,
	NLMSGERR_ATTR_MISS_NEST = 6,
	__NLMSGERR_ATTR_MAX = 7,
	NLMSGERR_ATTR_MAX = 6,
};

enum node_stat_item {
	NR_LRU_BASE = 0,
	NR_INACTIVE_ANON = 0,
	NR_ACTIVE_ANON = 1,
	NR_INACTIVE_FILE = 2,
	NR_ACTIVE_FILE = 3,
	NR_UNEVICTABLE = 4,
	NR_SLAB_RECLAIMABLE_B = 5,
	NR_SLAB_UNRECLAIMABLE_B = 6,
	NR_ISOLATED_ANON = 7,
	NR_ISOLATED_FILE = 8,
	WORKINGSET_NODES = 9,
	WORKINGSET_REFAULT_BASE = 10,
	WORKINGSET_REFAULT_ANON = 10,
	WORKINGSET_REFAULT_FILE = 11,
	WORKINGSET_ACTIVATE_BASE = 12,
	WORKINGSET_ACTIVATE_ANON = 12,
	WORKINGSET_ACTIVATE_FILE = 13,
	WORKINGSET_RESTORE_BASE = 14,
	WORKINGSET_RESTORE_ANON = 14,
	WORKINGSET_RESTORE_FILE = 15,
	WORKINGSET_NODERECLAIM = 16,
	NR_ANON_MAPPED = 17,
	NR_FILE_MAPPED = 18,
	NR_FILE_PAGES = 19,
	NR_FILE_DIRTY = 20,
	NR_WRITEBACK = 21,
	NR_WRITEBACK_TEMP = 22,
	NR_SHMEM = 23,
	NR_SHMEM_THPS = 24,
	NR_SHMEM_PMDMAPPED = 25,
	NR_FILE_THPS = 26,
	NR_FILE_PMDMAPPED = 27,
	NR_ANON_THPS = 28,
	NR_VMSCAN_WRITE = 29,
	NR_VMSCAN_IMMEDIATE = 30,
	NR_DIRTIED = 31,
	NR_WRITTEN = 32,
	NR_THROTTLED_WRITTEN = 33,
	NR_KERNEL_MISC_RECLAIMABLE = 34,
	NR_FOLL_PIN_ACQUIRED = 35,
	NR_FOLL_PIN_RELEASED = 36,
	NR_KERNEL_STACK_KB = 37,
	NR_PAGETABLE = 38,
	NR_SECONDARY_PAGETABLE = 39,
	NR_IOMMU_PAGES = 40,
	NR_SWAPCACHE = 41,
	PGDEMOTE_KSWAPD = 42,
	PGDEMOTE_DIRECT = 43,
	PGDEMOTE_KHUGEPAGED = 44,
	PGDEMOTE_PROACTIVE = 45,
	NR_BALLOON_PAGES = 46,
	NR_VM_NODE_STAT_ITEMS = 47,
};

enum node_states {
	N_POSSIBLE = 0,
	N_ONLINE = 1,
	N_NORMAL_MEMORY = 2,
	N_HIGH_MEMORY = 3,
	N_MEMORY = 4,
	N_CPU = 5,
	N_GENERIC_INITIATOR = 6,
	NR_NODE_STATES = 7,
};

enum node_type {
	NODE_TYPE_REGULAR = 0,
	NODE_TYPE_INODE = 1,
	NODE_TYPE_XATTR = 2,
};

enum notify_state {
	SECCOMP_NOTIFY_INIT = 0,
	SECCOMP_NOTIFY_SENT = 1,
	SECCOMP_NOTIFY_REPLIED = 2,
};

enum nv_adma_regbits {
	CMDEND = 32768,
	WNB = 16384,
	IGN = 8192,
	CS1n = 4096,
	DA2 = 1024,
	DA1 = 512,
	DA0 = 256,
};

enum nv_host_type {
	GENERIC = 0,
	NFORCE2 = 1,
	NFORCE3 = 1,
	CK804 = 2,
	ADMA = 3,
	MCP5x = 4,
	SWNCQ = 5,
};

enum nvmem_type {
	NVMEM_TYPE_UNKNOWN = 0,
	NVMEM_TYPE_EEPROM = 1,
	NVMEM_TYPE_OTP = 2,
	NVMEM_TYPE_BATTERY_BACKED = 3,
	NVMEM_TYPE_FRAM = 4,
};

enum objext_flags {
	OBJEXTS_ALLOC_FAIL = 4,
	__NR_OBJEXTS_FLAGS = 8,
};

enum ocmem_client {
	OCMEM_GRAPHICS = 0,
	OCMEM_CLIENT_MAX = 1,
};

enum of_gpio_flags {
	OF_GPIO_ACTIVE_LOW = 1,
	OF_GPIO_SINGLE_ENDED = 2,
	OF_GPIO_OPEN_DRAIN = 4,
	OF_GPIO_TRANSITORY = 8,
	OF_GPIO_PULL_UP = 16,
	OF_GPIO_PULL_DOWN = 32,
	OF_GPIO_PULL_DISABLE = 64,
};

enum of_overlay_notify_action {
	OF_OVERLAY_INIT = 0,
	OF_OVERLAY_PRE_APPLY = 1,
	OF_OVERLAY_POST_APPLY = 2,
	OF_OVERLAY_PRE_REMOVE = 3,
	OF_OVERLAY_POST_REMOVE = 4,
};

enum of_reconfig_change {
	OF_RECONFIG_NO_CHANGE = 0,
	OF_RECONFIG_CHANGE_ADD = 1,
	OF_RECONFIG_CHANGE_REMOVE = 2,
};

enum offload_act_command {
	FLOW_ACT_REPLACE = 0,
	FLOW_ACT_DESTROY = 1,
	FLOW_ACT_STATS = 2,
};

enum ohci_rh_state {
	OHCI_RH_HALTED = 0,
	OHCI_RH_SUSPENDED = 1,
	OHCI_RH_RUNNING = 2,
};

enum omap3_l3_code {
	OMAP_L3_CODE_NOERROR = 0,
	OMAP_L3_CODE_UNSUP_CMD = 1,
	OMAP_L3_CODE_ADDR_HOLE = 2,
	OMAP_L3_CODE_PROTECT_VIOLATION = 3,
	OMAP_L3_CODE_IN_BAND_ERR = 4,
	OMAP_L3_CODE_REQ_TOUT_NOT_ACCEPT = 7,
	OMAP_L3_CODE_REQ_TOUT_NO_RESP = 8,
};

enum omap3_l3_initiator_id {
	OMAP_L3_LCD = 29,
	OMAP_L3_SAD2D = 28,
	OMAP_L3_IA_MPU_SS_1 = 27,
	OMAP_L3_IA_MPU_SS_2 = 26,
	OMAP_L3_IA_MPU_SS_3 = 25,
	OMAP_L3_IA_MPU_SS_4 = 24,
	OMAP_L3_IA_MPU_SS_5 = 23,
	OMAP_L3_IA_IVA_SS_1 = 22,
	OMAP_L3_IA_IVA_SS_2 = 21,
	OMAP_L3_IA_IVA_SS_3 = 20,
	OMAP_L3_IA_IVA_SS_DMA_1 = 19,
	OMAP_L3_IA_IVA_SS_DMA_2 = 18,
	OMAP_L3_IA_IVA_SS_DMA_3 = 17,
	OMAP_L3_IA_IVA_SS_DMA_4 = 16,
	OMAP_L3_IA_IVA_SS_DMA_5 = 15,
	OMAP_L3_IA_IVA_SS_DMA_6 = 14,
	OMAP_L3_IA_SGX = 13,
	OMAP_L3_IA_CAM_1 = 12,
	OMAP_L3_IA_CAM_2 = 11,
	OMAP_L3_IA_CAM_3 = 10,
	OMAP_L3_IA_DAP = 9,
	OMAP_L3_SDMA_WR_1 = 8,
	OMAP_L3_SDMA_WR_2 = 7,
	OMAP_L3_SDMA_RD_1 = 6,
	OMAP_L3_SDMA_RD_2 = 5,
	OMAP_L3_SDMA_RD_3 = 4,
	OMAP_L3_SDMA_RD_4 = 3,
	OMAP_L3_USBOTG = 2,
	OMAP_L3_USBHOST = 1,
};

enum omap_control_phy_type {
	OMAP_CTRL_TYPE_OTGHS = 1,
	OMAP_CTRL_TYPE_USB2 = 2,
	OMAP_CTRL_TYPE_PIPE3 = 3,
	OMAP_CTRL_TYPE_PCIE = 4,
	OMAP_CTRL_TYPE_DRA7USB2 = 5,
	OMAP_CTRL_TYPE_AM437USB2 = 6,
};

enum omap_control_usb_mode {
	USB_MODE_UNDEFINED = 0,
	USB_MODE_HOST = 1,
	USB_MODE_DEVICE = 2,
	USB_MODE_DISCONNECT = 3,
};

enum omap_dwc3_vbus_id_status {
	OMAP_DWC3_ID_FLOAT = 0,
	OMAP_DWC3_ID_GROUND = 1,
	OMAP_DWC3_VBUS_OFF = 2,
	OMAP_DWC3_VBUS_VALID = 3,
};

enum omap_prm_domain_mode {
	OMAP_PRMD_OFF = 0,
	OMAP_PRMD_RETENTION = 1,
	OMAP_PRMD_ON_INACTIVE = 2,
	OMAP_PRMD_ON_ACTIVE = 3,
};

enum omap_reg_offsets {
	GCR = 0,
	GSCR = 1,
	GRST1 = 2,
	HW_ID = 3,
	PCH2_ID = 4,
	PCH0_ID = 5,
	PCH1_ID = 6,
	PCHG_ID = 7,
	PCHD_ID = 8,
	CAPS_0 = 9,
	CAPS_1 = 10,
	CAPS_2 = 11,
	CAPS_3 = 12,
	CAPS_4 = 13,
	PCH2_SR = 14,
	PCH0_SR = 15,
	PCH1_SR = 16,
	PCHD_SR = 17,
	REVISION = 18,
	IRQSTATUS_L0 = 19,
	IRQSTATUS_L1 = 20,
	IRQSTATUS_L2 = 21,
	IRQSTATUS_L3 = 22,
	IRQENABLE_L0 = 23,
	IRQENABLE_L1 = 24,
	IRQENABLE_L2 = 25,
	IRQENABLE_L3 = 26,
	SYSSTATUS = 27,
	OCP_SYSCONFIG = 28,
	CPC = 29,
	CCR2 = 30,
	LCH_CTRL = 31,
	CSDP = 32,
	CCR___2 = 33,
	CICR = 34,
	CSR = 35,
	CEN = 36,
	CFN = 37,
	CSFI = 38,
	CSEI = 39,
	CSAC = 40,
	CDAC = 41,
	CDEI = 42,
	CDFI = 43,
	CLNK_CTRL = 44,
	CSSA = 45,
	CDSA = 46,
	COLOR = 47,
	CCEN = 48,
	CCFN = 49,
	CDP = 50,
	CNDP = 51,
	CCDN = 52,
};

enum oom_constraint {
	CONSTRAINT_NONE = 0,
	CONSTRAINT_CPUSET = 1,
	CONSTRAINT_MEMORY_POLICY = 2,
	CONSTRAINT_MEMCG = 3,
};

enum opal_atom_width {
	OPAL_WIDTH_TINY = 0,
	OPAL_WIDTH_SHORT = 1,
	OPAL_WIDTH_MEDIUM = 2,
	OPAL_WIDTH_LONG = 3,
	OPAL_WIDTH_TOKEN = 4,
};

enum opal_key_type {
	OPAL_INCLUDED = 0,
	OPAL_KEYRING = 1,
};

enum opal_lock_flags {
	OPAL_SAVE_FOR_LOCK = 1,
};

enum opal_lock_state {
	OPAL_RO = 1,
	OPAL_RW = 2,
	OPAL_LK = 4,
};

enum opal_mbr {
	OPAL_MBR_ENABLE = 0,
	OPAL_MBR_DISABLE = 1,
};

enum opal_mbr_done_flag {
	OPAL_MBR_NOT_DONE = 0,
	OPAL_MBR_DONE = 1,
};

enum opal_method {
	OPAL_PROPERTIES = 0,
	OPAL_STARTSESSION = 1,
	OPAL_REVERT = 2,
	OPAL_ACTIVATE = 3,
	OPAL_EGET = 4,
	OPAL_ESET = 5,
	OPAL_NEXT = 6,
	OPAL_EAUTHENTICATE = 7,
	OPAL_GETACL = 8,
	OPAL_GENKEY = 9,
	OPAL_REVERTSP = 10,
	OPAL_GET = 11,
	OPAL_SET = 12,
	OPAL_AUTHENTICATE = 13,
	OPAL_RANDOM = 14,
	OPAL_ERASE = 15,
};

enum opal_parameter {
	OPAL_SUM_SET_LIST = 393216,
};

enum opal_response_token {
	OPAL_DTA_TOKENID_BYTESTRING = 224,
	OPAL_DTA_TOKENID_SINT = 225,
	OPAL_DTA_TOKENID_UINT = 226,
	OPAL_DTA_TOKENID_TOKEN = 227,
	OPAL_DTA_TOKENID_INVALID = 0,
};

enum opal_revert_lsp_opts {
	OPAL_PRESERVE = 1,
};

enum opal_revertlsp {
	OPAL_KEEP_GLOBAL_RANGE_KEY = 393216,
};

enum opal_table_ops {
	OPAL_READ_TABLE = 0,
	OPAL_WRITE_TABLE = 1,
};

enum opal_token {
	OPAL_TRUE = 1,
	OPAL_FALSE = 0,
	OPAL_BOOLEAN_EXPR = 3,
	OPAL_TABLE = 0,
	OPAL_STARTROW = 1,
	OPAL_ENDROW = 2,
	OPAL_STARTCOLUMN = 3,
	OPAL_ENDCOLUMN = 4,
	OPAL_VALUES = 1,
	OPAL_TABLE_UID = 0,
	OPAL_TABLE_NAME = 1,
	OPAL_TABLE_COMMON = 2,
	OPAL_TABLE_TEMPLATE = 3,
	OPAL_TABLE_KIND = 4,
	OPAL_TABLE_COLUMN = 5,
	OPAL_TABLE_COLUMNS = 6,
	OPAL_TABLE_ROWS = 7,
	OPAL_TABLE_ROWS_FREE = 8,
	OPAL_TABLE_ROW_BYTES = 9,
	OPAL_TABLE_LASTID = 10,
	OPAL_TABLE_MIN = 11,
	OPAL_TABLE_MAX = 12,
	OPAL_PIN = 3,
	OPAL_RANGESTART = 3,
	OPAL_RANGELENGTH = 4,
	OPAL_READLOCKENABLED = 5,
	OPAL_WRITELOCKENABLED = 6,
	OPAL_READLOCKED = 7,
	OPAL_WRITELOCKED = 8,
	OPAL_ACTIVEKEY = 10,
	OPAL_LIFECYCLE = 6,
	OPAL_MAXRANGES = 4,
	OPAL_MBRENABLE = 1,
	OPAL_MBRDONE = 2,
	OPAL_HOSTPROPERTIES = 0,
	OPAL_STARTLIST = 240,
	OPAL_ENDLIST = 241,
	OPAL_STARTNAME = 242,
	OPAL_ENDNAME = 243,
	OPAL_CALL = 248,
	OPAL_ENDOFDATA = 249,
	OPAL_ENDOFSESSION = 250,
	OPAL_STARTTRANSACTON = 251,
	OPAL_ENDTRANSACTON = 252,
	OPAL_EMPTYATOM = 255,
	OPAL_WHERE = 0,
};

enum opal_uid {
	OPAL_SMUID_UID = 0,
	OPAL_THISSP_UID = 1,
	OPAL_ADMINSP_UID = 2,
	OPAL_LOCKINGSP_UID = 3,
	OPAL_ENTERPRISE_LOCKINGSP_UID = 4,
	OPAL_ANYBODY_UID = 5,
	OPAL_SID_UID = 6,
	OPAL_ADMIN1_UID = 7,
	OPAL_USER1_UID = 8,
	OPAL_USER2_UID = 9,
	OPAL_PSID_UID = 10,
	OPAL_ENTERPRISE_BANDMASTER0_UID = 11,
	OPAL_ENTERPRISE_ERASEMASTER_UID = 12,
	OPAL_TABLE_TABLE = 13,
	OPAL_LOCKINGRANGE_GLOBAL = 14,
	OPAL_LOCKINGRANGE_ACE_START_TO_KEY = 15,
	OPAL_LOCKINGRANGE_ACE_RDLOCKED = 16,
	OPAL_LOCKINGRANGE_ACE_WRLOCKED = 17,
	OPAL_MBRCONTROL = 18,
	OPAL_MBR = 19,
	OPAL_AUTHORITY_TABLE = 20,
	OPAL_C_PIN_TABLE = 21,
	OPAL_LOCKING_INFO_TABLE = 22,
	OPAL_ENTERPRISE_LOCKING_INFO_TABLE = 23,
	OPAL_DATASTORE = 24,
	OPAL_C_PIN_MSID = 25,
	OPAL_C_PIN_SID = 26,
	OPAL_C_PIN_ADMIN1 = 27,
	OPAL_HALF_UID_AUTHORITY_OBJ_REF = 28,
	OPAL_HALF_UID_BOOLEAN_ACE = 29,
	OPAL_UID_HEXFF = 30,
};

enum opal_user {
	OPAL_ADMIN1 = 0,
	OPAL_USER1 = 1,
	OPAL_USER2 = 2,
	OPAL_USER3 = 3,
	OPAL_USER4 = 4,
	OPAL_USER5 = 5,
	OPAL_USER6 = 6,
	OPAL_USER7 = 7,
	OPAL_USER8 = 8,
	OPAL_USER9 = 9,
};

enum open_claim_type4 {
	NFS4_OPEN_CLAIM_NULL = 0,
	NFS4_OPEN_CLAIM_PREVIOUS = 1,
	NFS4_OPEN_CLAIM_DELEGATE_CUR = 2,
	NFS4_OPEN_CLAIM_DELEGATE_PREV = 3,
	NFS4_OPEN_CLAIM_FH = 4,
	NFS4_OPEN_CLAIM_DELEG_CUR_FH = 5,
	NFS4_OPEN_CLAIM_DELEG_PREV_FH = 6,
};

enum opentype4 {
	NFS4_OPEN_NOCREATE = 0,
	NFS4_OPEN_CREATE = 1,
};

enum operation_mode {
	DP_AS_SDP_AVT_DYNAMIC_VTOTAL = 0,
	DP_AS_SDP_AVT_FIXED_VTOTAL = 1,
	DP_AS_SDP_FAVT_TRR_NOT_REACHED = 2,
	DP_AS_SDP_FAVT_TRR_REACHED = 3,
};

enum opp_table_access {
	OPP_TABLE_ACCESS_UNKNOWN = 0,
	OPP_TABLE_ACCESS_EXCLUSIVE = 1,
	OPP_TABLE_ACCESS_SHARED = 2,
};

enum orion_ehci_phy_ver {
	EHCI_PHY_ORION = 0,
	EHCI_PHY_DD = 1,
	EHCI_PHY_KW = 2,
	EHCI_PHY_NA = 3,
};

enum orion_mdio_bus_type {
	BUS_TYPE_SMI = 0,
	BUS_TYPE_XSMI = 1,
};

enum orion_spi_type {
	ORION_SPI = 0,
	ARMADA_SPI = 1,
};

enum otg_fsm_timer {
	A_WAIT_VRISE = 0,
	A_WAIT_VFALL = 1,
	A_WAIT_BCON = 2,
	A_AIDL_BDIS = 3,
	B_ASE0_BRST = 4,
	A_BIDL_ADIS = 5,
	B_AIDL_BDIS = 6,
	B_SE0_SRP = 7,
	B_SRP_FAIL = 8,
	A_WAIT_ENUM = 9,
	B_DATA_PLS = 10,
	B_SSEND_SRP = 11,
	NUM_OTG_FSM_TIMERS = 12,
};

enum ovl_copyop {
	OVL_COPY = 0,
	OVL_CLONE = 1,
	OVL_DEDUPE = 2,
};

enum ovl_entry_flag {
	OVL_E_UPPER_ALIAS = 0,
	OVL_E_OPAQUE = 1,
	OVL_E_CONNECTED = 2,
	OVL_E_XWHITEOUTS = 3,
};

enum ovl_inode_flag {
	OVL_IMPURE = 0,
	OVL_WHITEOUTS = 1,
	OVL_INDEX = 2,
	OVL_UPPERDATA = 3,
	OVL_CONST_INO = 4,
	OVL_HAS_DIGEST = 5,
	OVL_VERIFIED_DIGEST = 6,
};

enum ovl_opt {
	Opt_lowerdir = 0,
	Opt_lowerdir_add = 1,
	Opt_datadir_add = 2,
	Opt_upperdir = 3,
	Opt_workdir = 4,
	Opt_default_permissions = 5,
	Opt_redirect_dir = 6,
	Opt_index = 7,
	Opt_uuid = 8,
	Opt_nfs_export = 9,
	Opt_userxattr = 10,
	Opt_xino = 11,
	Opt_metacopy = 12,
	Opt_verity = 13,
	Opt_volatile = 14,
	Opt_override_creds = 15,
};

enum ovl_path_type {
	__OVL_PATH_UPPER = 1,
	__OVL_PATH_MERGE = 2,
	__OVL_PATH_ORIGIN = 4,
};

enum ovl_xattr {
	OVL_XATTR_OPAQUE = 0,
	OVL_XATTR_REDIRECT = 1,
	OVL_XATTR_ORIGIN = 2,
	OVL_XATTR_IMPURE = 3,
	OVL_XATTR_NLINK = 4,
	OVL_XATTR_UPPER = 5,
	OVL_XATTR_UUID = 6,
	OVL_XATTR_METACOPY = 7,
	OVL_XATTR_PROTATTR = 8,
	OVL_XATTR_XWHITEOUT = 9,
};

enum owner_state {
	OWNER_NULL = 1,
	OWNER_WRITER = 2,
	OWNER_READER = 4,
	OWNER_NONSPINNABLE = 8,
};

enum packet_sock_flags {
	PACKET_SOCK_ORIGDEV = 0,
	PACKET_SOCK_AUXDATA = 1,
	PACKET_SOCK_TX_HAS_OFF = 2,
	PACKET_SOCK_TP_LOSS = 3,
	PACKET_SOCK_RUNNING = 4,
	PACKET_SOCK_PRESSURE = 5,
	PACKET_SOCK_QDISC_BYPASS = 6,
};

enum page_memcg_data_flags {
	MEMCG_DATA_OBJEXTS = 1,
	MEMCG_DATA_KMEM = 2,
	__NR_MEMCG_DATA_FLAGS = 4,
};

enum page_size_enum {
	__PAGE_SIZE = 4096,
};

enum page_type {
	DATA = 0,
	NODE = 1,
	META = 2,
	NR_PAGE_TYPE = 3,
	META_FLUSH = 4,
	IPU = 5,
	OPU = 6,
};

enum page_walk_action {
	ACTION_SUBTREE = 0,
	ACTION_CONTINUE = 1,
	ACTION_AGAIN = 2,
};

enum page_walk_lock {
	PGWALK_RDLOCK = 0,
	PGWALK_WRLOCK = 1,
	PGWALK_WRLOCK_VERIFY = 2,
};

enum pageblock_bits {
	PB_migrate = 0,
	PB_migrate_end = 2,
	PB_migrate_skip = 3,
	NR_PAGEBLOCK_BITS = 4,
};

enum pageflags {
	PG_locked = 0,
	PG_writeback = 1,
	PG_referenced = 2,
	PG_uptodate = 3,
	PG_dirty = 4,
	PG_lru = 5,
	PG_head = 6,
	PG_waiters = 7,
	PG_active = 8,
	PG_workingset = 9,
	PG_owner_priv_1 = 10,
	PG_owner_2 = 11,
	PG_arch_1 = 12,
	PG_reserved = 13,
	PG_private = 14,
	PG_private_2 = 15,
	PG_reclaim = 16,
	PG_swapbacked = 17,
	PG_unevictable = 18,
	PG_dropbehind = 19,
	PG_mlocked = 20,
	__NR_PAGEFLAGS = 21,
	PG_readahead = 16,
	PG_swapcache = 10,
	PG_checked = 10,
	PG_anon_exclusive = 11,
	PG_mappedtodisk = 11,
	PG_fscache = 15,
	PG_pinned = 10,
	PG_savepinned = 4,
	PG_foreign = 10,
	PG_xen_remapped = 10,
	PG_isolated = 16,
	PG_reported = 3,
	PG_has_hwpoisoned = 8,
	PG_large_rmappable = 9,
	PG_partially_mapped = 16,
};

enum pagetype {
	PGTY_buddy = 240,
	PGTY_offline = 241,
	PGTY_table = 242,
	PGTY_guard = 243,
	PGTY_hugetlb = 244,
	PGTY_slab = 245,
	PGTY_zsmalloc = 246,
	PGTY_unaccepted = 247,
	PGTY_large_kmalloc = 248,
	PGTY_mapcount_underflow = 255,
};

enum palmas_external_requestor_id {
	PALMAS_EXTERNAL_REQSTR_ID_REGEN1 = 0,
	PALMAS_EXTERNAL_REQSTR_ID_REGEN2 = 1,
	PALMAS_EXTERNAL_REQSTR_ID_SYSEN1 = 2,
	PALMAS_EXTERNAL_REQSTR_ID_SYSEN2 = 3,
	PALMAS_EXTERNAL_REQSTR_ID_CLK32KG = 4,
	PALMAS_EXTERNAL_REQSTR_ID_CLK32KGAUDIO = 5,
	PALMAS_EXTERNAL_REQSTR_ID_REGEN3 = 6,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS12 = 7,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS3 = 8,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS45 = 9,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS6 = 10,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS7 = 11,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS8 = 12,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS9 = 13,
	PALMAS_EXTERNAL_REQSTR_ID_SMPS10 = 14,
	PALMAS_EXTERNAL_REQSTR_ID_LDO1 = 15,
	PALMAS_EXTERNAL_REQSTR_ID_LDO2 = 16,
	PALMAS_EXTERNAL_REQSTR_ID_LDO3 = 17,
	PALMAS_EXTERNAL_REQSTR_ID_LDO4 = 18,
	PALMAS_EXTERNAL_REQSTR_ID_LDO5 = 19,
	PALMAS_EXTERNAL_REQSTR_ID_LDO6 = 20,
	PALMAS_EXTERNAL_REQSTR_ID_LDO7 = 21,
	PALMAS_EXTERNAL_REQSTR_ID_LDO8 = 22,
	PALMAS_EXTERNAL_REQSTR_ID_LDO9 = 23,
	PALMAS_EXTERNAL_REQSTR_ID_LDOLN = 24,
	PALMAS_EXTERNAL_REQSTR_ID_LDOUSB = 25,
	PALMAS_EXTERNAL_REQSTR_ID_MAX = 26,
};

enum palmas_irqs {
	PALMAS_CHARG_DET_N_VBUS_OVV_IRQ = 0,
	PALMAS_PWRON_IRQ = 1,
	PALMAS_LONG_PRESS_KEY_IRQ = 2,
	PALMAS_RPWRON_IRQ = 3,
	PALMAS_PWRDOWN_IRQ = 4,
	PALMAS_HOTDIE_IRQ = 5,
	PALMAS_VSYS_MON_IRQ = 6,
	PALMAS_VBAT_MON_IRQ = 7,
	PALMAS_RTC_ALARM_IRQ = 8,
	PALMAS_RTC_TIMER_IRQ = 9,
	PALMAS_WDT_IRQ = 10,
	PALMAS_BATREMOVAL_IRQ = 11,
	PALMAS_RESET_IN_IRQ = 12,
	PALMAS_FBI_BB_IRQ = 13,
	PALMAS_SHORT_IRQ = 14,
	PALMAS_VAC_ACOK_IRQ = 15,
	PALMAS_GPADC_AUTO_0_IRQ = 16,
	PALMAS_GPADC_AUTO_1_IRQ = 17,
	PALMAS_GPADC_EOC_SW_IRQ = 18,
	PALMAS_GPADC_EOC_RT_IRQ = 19,
	PALMAS_ID_OTG_IRQ = 20,
	PALMAS_ID_IRQ = 21,
	PALMAS_VBUS_OTG_IRQ = 22,
	PALMAS_VBUS_IRQ = 23,
	PALMAS_GPIO_0_IRQ = 24,
	PALMAS_GPIO_1_IRQ = 25,
	PALMAS_GPIO_2_IRQ = 26,
	PALMAS_GPIO_3_IRQ = 27,
	PALMAS_GPIO_4_IRQ = 28,
	PALMAS_GPIO_5_IRQ = 29,
	PALMAS_GPIO_6_IRQ = 30,
	PALMAS_GPIO_7_IRQ = 31,
	PALMAS_NUM_IRQ = 32,
};

enum palmas_pinmux {
	PALMAS_PINMUX_OPTION0 = 0,
	PALMAS_PINMUX_OPTION1 = 1,
	PALMAS_PINMUX_OPTION2 = 2,
	PALMAS_PINMUX_OPTION3 = 3,
	PALMAS_PINMUX_GPIO = 4,
	PALMAS_PINMUX_LED = 5,
	PALMAS_PINMUX_PWM = 6,
	PALMAS_PINMUX_REGEN = 7,
	PALMAS_PINMUX_SYSEN = 8,
	PALMAS_PINMUX_CLK32KGAUDIO = 9,
	PALMAS_PINMUX_ID = 10,
	PALMAS_PINMUX_VBUS_DET = 11,
	PALMAS_PINMUX_CHRG_DET = 12,
	PALMAS_PINMUX_VAC = 13,
	PALMAS_PINMUX_VACOK = 14,
	PALMAS_PINMUX_POWERGOOD = 15,
	PALMAS_PINMUX_USB_PSEL = 16,
	PALMAS_PINMUX_MSECURE = 17,
	PALMAS_PINMUX_PWRHOLD = 18,
	PALMAS_PINMUX_INT = 19,
	PALMAS_PINMUX_NRESWARM = 20,
	PALMAS_PINMUX_SIMRSTO = 21,
	PALMAS_PINMUX_SIMRSTI = 22,
	PALMAS_PINMUX_LOW_VBAT = 23,
	PALMAS_PINMUX_WIRELESS_CHRG1 = 24,
	PALMAS_PINMUX_RCM = 25,
	PALMAS_PINMUX_PWRDOWN = 26,
	PALMAS_PINMUX_GPADC_START = 27,
	PALMAS_PINMUX_RESET_IN = 28,
	PALMAS_PINMUX_NSLEEP = 29,
	PALMAS_PINMUX_ENABLE = 30,
	PALMAS_PINMUX_NA = 65535,
};

enum palmas_regulators {
	PALMAS_REG_SMPS12 = 0,
	PALMAS_REG_SMPS123 = 1,
	PALMAS_REG_SMPS3 = 2,
	PALMAS_REG_SMPS45 = 3,
	PALMAS_REG_SMPS457 = 4,
	PALMAS_REG_SMPS6 = 5,
	PALMAS_REG_SMPS7 = 6,
	PALMAS_REG_SMPS8 = 7,
	PALMAS_REG_SMPS9 = 8,
	PALMAS_REG_SMPS10_OUT2 = 9,
	PALMAS_REG_SMPS10_OUT1 = 10,
	PALMAS_REG_LDO1 = 11,
	PALMAS_REG_LDO2 = 12,
	PALMAS_REG_LDO3 = 13,
	PALMAS_REG_LDO4 = 14,
	PALMAS_REG_LDO5 = 15,
	PALMAS_REG_LDO6 = 16,
	PALMAS_REG_LDO7 = 17,
	PALMAS_REG_LDO8 = 18,
	PALMAS_REG_LDO9 = 19,
	PALMAS_REG_LDOLN = 20,
	PALMAS_REG_LDOUSB = 21,
	PALMAS_REG_REGEN1 = 22,
	PALMAS_REG_REGEN2 = 23,
	PALMAS_REG_REGEN3 = 24,
	PALMAS_REG_SYSEN1 = 25,
	PALMAS_REG_SYSEN2 = 26,
	PALMAS_NUM_REGS = 27,
};

enum palmas_usb_state {
	PALMAS_USB_STATE_DISCONNECT = 0,
	PALMAS_USB_STATE_VBUS = 1,
	PALMAS_USB_STATE_ID = 2,
};

enum param_type {
	TUNER_PARAM_TYPE_RADIO = 0,
	TUNER_PARAM_TYPE_PAL = 1,
	TUNER_PARAM_TYPE_SECAM = 2,
	TUNER_PARAM_TYPE_NTSC = 3,
	TUNER_PARAM_TYPE_DIGITAL = 4,
};

enum partition_cmd {
	partcmd_enable = 0,
	partcmd_enablei = 1,
	partcmd_disable = 2,
	partcmd_update = 3,
	partcmd_invalidate = 4,
};

enum passtype {
	PASS_SCAN = 0,
	PASS_REVOKE = 1,
	PASS_REPLAY = 2,
};

enum pattern_set {
	PRBS7 = 0,
	D10_2 = 1,
	TRAINING_PTN1 = 2,
	TRAINING_PTN2 = 3,
	DP_NONE = 4,
};

enum pca_type {
	max_7356 = 0,
	max_7357 = 1,
	max_7358 = 2,
	max_7367 = 3,
	max_7368 = 4,
	max_7369 = 5,
	pca_9540 = 6,
	pca_9542 = 7,
	pca_9543 = 8,
	pca_9544 = 9,
	pca_9545 = 10,
	pca_9546 = 11,
	pca_9547 = 12,
	pca_9548 = 13,
	pca_9846 = 14,
	pca_9847 = 15,
	pca_9848 = 16,
	pca_9849 = 17,
};

enum pce_status {
	PCE_STATUS_NONE = 0,
	PCE_STATUS_ACQUIRED = 1,
	PCE_STATUS_PREPARED = 2,
	PCE_STATUS_ENABLED = 3,
	PCE_STATUS_ERROR = 4,
};

enum pchg_state {
	PCHG_STATE_RESET = 0,
	PCHG_STATE_INITIALIZED = 1,
	PCHG_STATE_ENABLED = 2,
	PCHG_STATE_DETECTED = 3,
	PCHG_STATE_CHARGING = 4,
	PCHG_STATE_FULL = 5,
	PCHG_STATE_DOWNLOAD = 6,
	PCHG_STATE_DOWNLOADING = 7,
	PCHG_STATE_CONNECTED = 8,
	PCHG_STATE_COUNT = 9,
};

enum pci_bar_type {
	pci_bar_unknown = 0,
	pci_bar_io = 1,
	pci_bar_mem32 = 2,
	pci_bar_mem64 = 3,
};

enum pci_barno {
	NO_BAR = -1,
	BAR_0 = 0,
	BAR_1 = 1,
	BAR_2 = 2,
	BAR_3 = 3,
	BAR_4 = 4,
	BAR_5 = 5,
};

enum pci_board_num_t {
	pbn_default = 0,
	pbn_b0_1_115200 = 1,
	pbn_b0_2_115200 = 2,
	pbn_b0_4_115200 = 3,
	pbn_b0_5_115200 = 4,
	pbn_b0_8_115200 = 5,
	pbn_b0_1_921600 = 6,
	pbn_b0_2_921600 = 7,
	pbn_b0_4_921600 = 8,
	pbn_b0_2_1130000 = 9,
	pbn_b0_4_1152000 = 10,
	pbn_b0_4_1250000 = 11,
	pbn_b0_2_1843200 = 12,
	pbn_b0_4_1843200 = 13,
	pbn_b0_1_15625000 = 14,
	pbn_b0_bt_1_115200 = 15,
	pbn_b0_bt_2_115200 = 16,
	pbn_b0_bt_4_115200 = 17,
	pbn_b0_bt_8_115200 = 18,
	pbn_b0_bt_1_460800 = 19,
	pbn_b0_bt_2_460800 = 20,
	pbn_b0_bt_4_460800 = 21,
	pbn_b0_bt_1_921600 = 22,
	pbn_b0_bt_2_921600 = 23,
	pbn_b0_bt_4_921600 = 24,
	pbn_b0_bt_8_921600 = 25,
	pbn_b1_1_115200 = 26,
	pbn_b1_2_115200 = 27,
	pbn_b1_4_115200 = 28,
	pbn_b1_8_115200 = 29,
	pbn_b1_16_115200 = 30,
	pbn_b1_1_921600 = 31,
	pbn_b1_2_921600 = 32,
	pbn_b1_4_921600 = 33,
	pbn_b1_8_921600 = 34,
	pbn_b1_2_1250000 = 35,
	pbn_b1_bt_1_115200 = 36,
	pbn_b1_bt_2_115200 = 37,
	pbn_b1_bt_4_115200 = 38,
	pbn_b1_bt_2_921600 = 39,
	pbn_b1_1_1382400 = 40,
	pbn_b1_2_1382400 = 41,
	pbn_b1_4_1382400 = 42,
	pbn_b1_8_1382400 = 43,
	pbn_b2_1_115200 = 44,
	pbn_b2_2_115200 = 45,
	pbn_b2_4_115200 = 46,
	pbn_b2_8_115200 = 47,
	pbn_b2_1_460800 = 48,
	pbn_b2_4_460800 = 49,
	pbn_b2_8_460800 = 50,
	pbn_b2_16_460800 = 51,
	pbn_b2_1_921600 = 52,
	pbn_b2_4_921600 = 53,
	pbn_b2_8_921600 = 54,
	pbn_b2_8_1152000 = 55,
	pbn_b2_bt_1_115200 = 56,
	pbn_b2_bt_2_115200 = 57,
	pbn_b2_bt_4_115200 = 58,
	pbn_b2_bt_2_921600 = 59,
	pbn_b2_bt_4_921600 = 60,
	pbn_b3_2_115200 = 61,
	pbn_b3_4_115200 = 62,
	pbn_b3_8_115200 = 63,
	pbn_b4_bt_2_921600 = 64,
	pbn_b4_bt_4_921600 = 65,
	pbn_b4_bt_8_921600 = 66,
	pbn_panacom = 67,
	pbn_panacom2 = 68,
	pbn_panacom4 = 69,
	pbn_plx_romulus = 70,
	pbn_oxsemi = 71,
	pbn_oxsemi_1_15625000 = 72,
	pbn_oxsemi_2_15625000 = 73,
	pbn_oxsemi_4_15625000 = 74,
	pbn_oxsemi_8_15625000 = 75,
	pbn_intel_i960 = 76,
	pbn_sgi_ioc3 = 77,
	pbn_computone_4 = 78,
	pbn_computone_6 = 79,
	pbn_computone_8 = 80,
	pbn_sbsxrsio = 81,
	pbn_pasemi_1682M = 82,
	pbn_ni8430_2 = 83,
	pbn_ni8430_4 = 84,
	pbn_ni8430_8 = 85,
	pbn_ni8430_16 = 86,
	pbn_ADDIDATA_PCIe_1_3906250 = 87,
	pbn_ADDIDATA_PCIe_2_3906250 = 88,
	pbn_ADDIDATA_PCIe_4_3906250 = 89,
	pbn_ADDIDATA_PCIe_8_3906250 = 90,
	pbn_ce4100_1_115200 = 91,
	pbn_omegapci = 92,
	pbn_NETMOS9900_2s_115200 = 93,
	pbn_brcm_trumanage = 94,
	pbn_fintek_4 = 95,
	pbn_fintek_8 = 96,
	pbn_fintek_12 = 97,
	pbn_fintek_F81504A = 98,
	pbn_fintek_F81508A = 99,
	pbn_fintek_F81512A = 100,
	pbn_wch382_2 = 101,
	pbn_wch384_4 = 102,
	pbn_wch384_8 = 103,
	pbn_sunix_pci_1s = 104,
	pbn_sunix_pci_2s = 105,
	pbn_sunix_pci_4s = 106,
	pbn_sunix_pci_8s = 107,
	pbn_sunix_pci_16s = 108,
	pbn_titan_1_4000000 = 109,
	pbn_titan_2_4000000 = 110,
	pbn_titan_4_4000000 = 111,
	pbn_titan_8_4000000 = 112,
	pbn_moxa_2 = 113,
	pbn_moxa_4 = 114,
	pbn_moxa_8 = 115,
};

enum pci_bus_flags {
	PCI_BUS_FLAGS_NO_MSI = 1,
	PCI_BUS_FLAGS_NO_MMRBC = 2,
	PCI_BUS_FLAGS_NO_AERSID = 4,
	PCI_BUS_FLAGS_NO_EXTCFG = 8,
};

enum pci_bus_speed {
	PCI_SPEED_33MHz = 0,
	PCI_SPEED_66MHz = 1,
	PCI_SPEED_66MHz_PCIX = 2,
	PCI_SPEED_100MHz_PCIX = 3,
	PCI_SPEED_133MHz_PCIX = 4,
	PCI_SPEED_66MHz_PCIX_ECC = 5,
	PCI_SPEED_100MHz_PCIX_ECC = 6,
	PCI_SPEED_133MHz_PCIX_ECC = 7,
	PCI_SPEED_66MHz_PCIX_266 = 9,
	PCI_SPEED_100MHz_PCIX_266 = 10,
	PCI_SPEED_133MHz_PCIX_266 = 11,
	AGP_UNKNOWN = 12,
	AGP_1X = 13,
	AGP_2X = 14,
	AGP_4X = 15,
	AGP_8X = 16,
	PCI_SPEED_66MHz_PCIX_533 = 17,
	PCI_SPEED_100MHz_PCIX_533 = 18,
	PCI_SPEED_133MHz_PCIX_533 = 19,
	PCIE_SPEED_2_5GT = 20,
	PCIE_SPEED_5_0GT = 21,
	PCIE_SPEED_8_0GT = 22,
	PCIE_SPEED_16_0GT = 23,
	PCIE_SPEED_32_0GT = 24,
	PCIE_SPEED_64_0GT = 25,
	PCI_SPEED_UNKNOWN = 255,
};

enum pci_dev_flags {
	PCI_DEV_FLAGS_MSI_INTX_DISABLE_BUG = 1,
	PCI_DEV_FLAGS_NO_D3 = 2,
	PCI_DEV_FLAGS_ASSIGNED = 4,
	PCI_DEV_FLAGS_ACS_ENABLED_QUIRK = 8,
	PCI_DEV_FLAG_PCIE_BRIDGE_ALIAS = 32,
	PCI_DEV_FLAGS_NO_BUS_RESET = 64,
	PCI_DEV_FLAGS_NO_PM_RESET = 128,
	PCI_DEV_FLAGS_VPD_REF_F0 = 256,
	PCI_DEV_FLAGS_BRIDGE_XLATE_ROOT = 512,
	PCI_DEV_FLAGS_NO_FLR_RESET = 1024,
	PCI_DEV_FLAGS_NO_RELAXED_ORDERING = 2048,
	PCI_DEV_FLAGS_HAS_MSI_MASKING = 4096,
	PCI_DEV_FLAGS_MSIX_TOUCH_ENTRY_DATA_FIRST = 8192,
};

enum pci_epc_bar_type {
	BAR_PROGRAMMABLE = 0,
	BAR_FIXED = 1,
	BAR_RESIZABLE = 2,
	BAR_RESERVED = 3,
};

enum pci_ers_result {
	PCI_ERS_RESULT_NONE = 1,
	PCI_ERS_RESULT_CAN_RECOVER = 2,
	PCI_ERS_RESULT_NEED_RESET = 3,
	PCI_ERS_RESULT_DISCONNECT = 4,
	PCI_ERS_RESULT_RECOVERED = 5,
	PCI_ERS_RESULT_NO_AER_DRIVER = 6,
};

enum pci_fixup_pass {
	pci_fixup_early = 0,
	pci_fixup_header = 1,
	pci_fixup_final = 2,
	pci_fixup_enable = 3,
	pci_fixup_resume = 4,
	pci_fixup_suspend = 5,
	pci_fixup_resume_early = 6,
	pci_fixup_suspend_late = 7,
};

enum pci_interrupt_pin {
	PCI_INTERRUPT_UNKNOWN = 0,
	PCI_INTERRUPT_INTA = 1,
	PCI_INTERRUPT_INTB = 2,
	PCI_INTERRUPT_INTC = 3,
	PCI_INTERRUPT_INTD = 4,
};

enum pci_mmap_api {
	PCI_MMAP_SYSFS = 0,
	PCI_MMAP_PROCFS = 1,
};

enum pci_mmap_state {
	pci_mmap_io = 0,
	pci_mmap_mem = 1,
};

enum pci_p2pdma_map_type {
	PCI_P2PDMA_MAP_UNKNOWN = 0,
	PCI_P2PDMA_MAP_NONE = 1,
	PCI_P2PDMA_MAP_NOT_SUPPORTED = 2,
	PCI_P2PDMA_MAP_BUS_ADDR = 3,
	PCI_P2PDMA_MAP_THRU_HOST_BRIDGE = 4,
};

enum pcie_bus_config_types {
	PCIE_BUS_TUNE_OFF = 0,
	PCIE_BUS_DEFAULT = 1,
	PCIE_BUS_SAFE = 2,
	PCIE_BUS_PERFORMANCE = 3,
	PCIE_BUS_PEER2PEER = 4,
};

enum pcie_link_width {
	PCIE_LNK_WIDTH_RESRV = 0,
	PCIE_LNK_X1 = 1,
	PCIE_LNK_X2 = 2,
	PCIE_LNK_X4 = 4,
	PCIE_LNK_X8 = 8,
	PCIE_LNK_X12 = 12,
	PCIE_LNK_X16 = 16,
	PCIE_LNK_X32 = 32,
	PCIE_LNK_WIDTH_UNKNOWN = 255,
};

enum pcie_reset_state {
	pcie_deassert_reset = 1,
	pcie_warm_reset = 2,
	pcie_hot_reset = 3,
};

enum pcim_addr_devres_type {
	PCIM_ADDR_DEVRES_TYPE_INVALID = 0,
	PCIM_ADDR_DEVRES_TYPE_REGION = 1,
	PCIM_ADDR_DEVRES_TYPE_REGION_MAPPING = 2,
	PCIM_ADDR_DEVRES_TYPE_MAPPING = 3,
};

enum pcpu_fc {
	PCPU_FC_AUTO = 0,
	PCPU_FC_EMBED = 1,
	PCPU_FC_PAGE = 2,
	PCPU_FC_NR = 3,
};

enum pd_apdo_type {
	APDO_TYPE_PPS = 0,
};

enum pd_pdo_type {
	PDO_TYPE_FIXED = 0,
	PDO_TYPE_BATT = 1,
	PDO_TYPE_VAR = 2,
	PDO_TYPE_APDO = 3,
};

enum pedit_cmd {
	TCA_PEDIT_KEY_EX_CMD_SET = 0,
	TCA_PEDIT_KEY_EX_CMD_ADD = 1,
	__PEDIT_CMD_MAX = 2,
};

enum pedit_header_type {
	TCA_PEDIT_KEY_EX_HDR_TYPE_NETWORK = 0,
	TCA_PEDIT_KEY_EX_HDR_TYPE_ETH = 1,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP4 = 2,
	TCA_PEDIT_KEY_EX_HDR_TYPE_IP6 = 3,
	TCA_PEDIT_KEY_EX_HDR_TYPE_TCP = 4,
	TCA_PEDIT_KEY_EX_HDR_TYPE_UDP = 5,
	__PEDIT_HDR_TYPE_MAX = 6,
};

enum peer_app_attr {
	DCB_ATTR_CEE_PEER_APP_UNSPEC = 0,
	DCB_ATTR_CEE_PEER_APP_INFO = 1,
	DCB_ATTR_CEE_PEER_APP = 2,
	__DCB_ATTR_CEE_PEER_APP_MAX = 3,
};

enum perf_addr_filter_action_t {
	PERF_ADDR_FILTER_ACTION_STOP = 0,
	PERF_ADDR_FILTER_ACTION_START = 1,
	PERF_ADDR_FILTER_ACTION_FILTER = 2,
};

enum perf_bpf_event_type {
	PERF_BPF_EVENT_UNKNOWN = 0,
	PERF_BPF_EVENT_PROG_LOAD = 1,
	PERF_BPF_EVENT_PROG_UNLOAD = 2,
	PERF_BPF_EVENT_MAX = 3,
};

enum perf_branch_sample_type {
	PERF_SAMPLE_BRANCH_USER = 1,
	PERF_SAMPLE_BRANCH_KERNEL = 2,
	PERF_SAMPLE_BRANCH_HV = 4,
	PERF_SAMPLE_BRANCH_ANY = 8,
	PERF_SAMPLE_BRANCH_ANY_CALL = 16,
	PERF_SAMPLE_BRANCH_ANY_RETURN = 32,
	PERF_SAMPLE_BRANCH_IND_CALL = 64,
	PERF_SAMPLE_BRANCH_ABORT_TX = 128,
	PERF_SAMPLE_BRANCH_IN_TX = 256,
	PERF_SAMPLE_BRANCH_NO_TX = 512,
	PERF_SAMPLE_BRANCH_COND = 1024,
	PERF_SAMPLE_BRANCH_CALL_STACK = 2048,
	PERF_SAMPLE_BRANCH_IND_JUMP = 4096,
	PERF_SAMPLE_BRANCH_CALL = 8192,
	PERF_SAMPLE_BRANCH_NO_FLAGS = 16384,
	PERF_SAMPLE_BRANCH_NO_CYCLES = 32768,
	PERF_SAMPLE_BRANCH_TYPE_SAVE = 65536,
	PERF_SAMPLE_BRANCH_HW_INDEX = 131072,
	PERF_SAMPLE_BRANCH_PRIV_SAVE = 262144,
	PERF_SAMPLE_BRANCH_COUNTERS = 524288,
	PERF_SAMPLE_BRANCH_MAX = 1048576,
};

enum perf_branch_sample_type_shift {
	PERF_SAMPLE_BRANCH_USER_SHIFT = 0,
	PERF_SAMPLE_BRANCH_KERNEL_SHIFT = 1,
	PERF_SAMPLE_BRANCH_HV_SHIFT = 2,
	PERF_SAMPLE_BRANCH_ANY_SHIFT = 3,
	PERF_SAMPLE_BRANCH_ANY_CALL_SHIFT = 4,
	PERF_SAMPLE_BRANCH_ANY_RETURN_SHIFT = 5,
	PERF_SAMPLE_BRANCH_IND_CALL_SHIFT = 6,
	PERF_SAMPLE_BRANCH_ABORT_TX_SHIFT = 7,
	PERF_SAMPLE_BRANCH_IN_TX_SHIFT = 8,
	PERF_SAMPLE_BRANCH_NO_TX_SHIFT = 9,
	PERF_SAMPLE_BRANCH_COND_SHIFT = 10,
	PERF_SAMPLE_BRANCH_CALL_STACK_SHIFT = 11,
	PERF_SAMPLE_BRANCH_IND_JUMP_SHIFT = 12,
	PERF_SAMPLE_BRANCH_CALL_SHIFT = 13,
	PERF_SAMPLE_BRANCH_NO_FLAGS_SHIFT = 14,
	PERF_SAMPLE_BRANCH_NO_CYCLES_SHIFT = 15,
	PERF_SAMPLE_BRANCH_TYPE_SAVE_SHIFT = 16,
	PERF_SAMPLE_BRANCH_HW_INDEX_SHIFT = 17,
	PERF_SAMPLE_BRANCH_PRIV_SAVE_SHIFT = 18,
	PERF_SAMPLE_BRANCH_COUNTERS_SHIFT = 19,
	PERF_SAMPLE_BRANCH_MAX_SHIFT = 20,
};

enum perf_callchain_context {
	PERF_CONTEXT_HV = 18446744073709551584ULL,
	PERF_CONTEXT_KERNEL = 18446744073709551488ULL,
	PERF_CONTEXT_USER = 18446744073709551104ULL,
	PERF_CONTEXT_GUEST = 18446744073709549568ULL,
	PERF_CONTEXT_GUEST_KERNEL = 18446744073709549440ULL,
	PERF_CONTEXT_GUEST_USER = 18446744073709549056ULL,
	PERF_CONTEXT_MAX = 18446744073709547521ULL,
};

enum perf_event_arm_regs {
	PERF_REG_ARM_R0 = 0,
	PERF_REG_ARM_R1 = 1,
	PERF_REG_ARM_R2 = 2,
	PERF_REG_ARM_R3 = 3,
	PERF_REG_ARM_R4 = 4,
	PERF_REG_ARM_R5 = 5,
	PERF_REG_ARM_R6 = 6,
	PERF_REG_ARM_R7 = 7,
	PERF_REG_ARM_R8 = 8,
	PERF_REG_ARM_R9 = 9,
	PERF_REG_ARM_R10 = 10,
	PERF_REG_ARM_FP = 11,
	PERF_REG_ARM_IP = 12,
	PERF_REG_ARM_SP = 13,
	PERF_REG_ARM_LR = 14,
	PERF_REG_ARM_PC = 15,
	PERF_REG_ARM_MAX = 16,
};

enum perf_event_ioc_flags {
	PERF_IOC_FLAG_GROUP = 1,
};

enum perf_event_read_format {
	PERF_FORMAT_TOTAL_TIME_ENABLED = 1,
	PERF_FORMAT_TOTAL_TIME_RUNNING = 2,
	PERF_FORMAT_ID = 4,
	PERF_FORMAT_GROUP = 8,
	PERF_FORMAT_LOST = 16,
	PERF_FORMAT_MAX = 32,
};

enum perf_event_sample_format {
	PERF_SAMPLE_IP = 1,
	PERF_SAMPLE_TID = 2,
	PERF_SAMPLE_TIME = 4,
	PERF_SAMPLE_ADDR = 8,
	PERF_SAMPLE_READ = 16,
	PERF_SAMPLE_CALLCHAIN = 32,
	PERF_SAMPLE_ID = 64,
	PERF_SAMPLE_CPU = 128,
	PERF_SAMPLE_PERIOD = 256,
	PERF_SAMPLE_STREAM_ID = 512,
	PERF_SAMPLE_RAW = 1024,
	PERF_SAMPLE_BRANCH_STACK = 2048,
	PERF_SAMPLE_REGS_USER = 4096,
	PERF_SAMPLE_STACK_USER = 8192,
	PERF_SAMPLE_WEIGHT = 16384,
	PERF_SAMPLE_DATA_SRC = 32768,
	PERF_SAMPLE_IDENTIFIER = 65536,
	PERF_SAMPLE_TRANSACTION = 131072,
	PERF_SAMPLE_REGS_INTR = 262144,
	PERF_SAMPLE_PHYS_ADDR = 524288,
	PERF_SAMPLE_AUX = 1048576,
	PERF_SAMPLE_CGROUP = 2097152,
	PERF_SAMPLE_DATA_PAGE_SIZE = 4194304,
	PERF_SAMPLE_CODE_PAGE_SIZE = 8388608,
	PERF_SAMPLE_WEIGHT_STRUCT = 16777216,
	PERF_SAMPLE_MAX = 33554432,
};

enum perf_event_state {
	PERF_EVENT_STATE_DEAD = -5,
	PERF_EVENT_STATE_REVOKED = -4,
	PERF_EVENT_STATE_EXIT = -3,
	PERF_EVENT_STATE_ERROR = -2,
	PERF_EVENT_STATE_OFF = -1,
	PERF_EVENT_STATE_INACTIVE = 0,
	PERF_EVENT_STATE_ACTIVE = 1,
};

enum perf_event_task_context {
	perf_invalid_context = -1,
	perf_hw_context = 0,
	perf_sw_context = 1,
	perf_nr_task_contexts = 2,
};

enum perf_event_type {
	PERF_RECORD_MMAP = 1,
	PERF_RECORD_LOST = 2,
	PERF_RECORD_COMM = 3,
	PERF_RECORD_EXIT = 4,
	PERF_RECORD_THROTTLE = 5,
	PERF_RECORD_UNTHROTTLE = 6,
	PERF_RECORD_FORK = 7,
	PERF_RECORD_READ = 8,
	PERF_RECORD_SAMPLE = 9,
	PERF_RECORD_MMAP2 = 10,
	PERF_RECORD_AUX = 11,
	PERF_RECORD_ITRACE_START = 12,
	PERF_RECORD_LOST_SAMPLES = 13,
	PERF_RECORD_SWITCH = 14,
	PERF_RECORD_SWITCH_CPU_WIDE = 15,
	PERF_RECORD_NAMESPACES = 16,
	PERF_RECORD_KSYMBOL = 17,
	PERF_RECORD_BPF_EVENT = 18,
	PERF_RECORD_CGROUP = 19,
	PERF_RECORD_TEXT_POKE = 20,
	PERF_RECORD_AUX_OUTPUT_HW_ID = 21,
	PERF_RECORD_MAX = 22,
};

enum perf_hw_cache_id {
	PERF_COUNT_HW_CACHE_L1D = 0,
	PERF_COUNT_HW_CACHE_L1I = 1,
	PERF_COUNT_HW_CACHE_LL = 2,
	PERF_COUNT_HW_CACHE_DTLB = 3,
	PERF_COUNT_HW_CACHE_ITLB = 4,
	PERF_COUNT_HW_CACHE_BPU = 5,
	PERF_COUNT_HW_CACHE_NODE = 6,
	PERF_COUNT_HW_CACHE_MAX = 7,
};

enum perf_hw_cache_op_id {
	PERF_COUNT_HW_CACHE_OP_READ = 0,
	PERF_COUNT_HW_CACHE_OP_WRITE = 1,
	PERF_COUNT_HW_CACHE_OP_PREFETCH = 2,
	PERF_COUNT_HW_CACHE_OP_MAX = 3,
};

enum perf_hw_cache_op_result_id {
	PERF_COUNT_HW_CACHE_RESULT_ACCESS = 0,
	PERF_COUNT_HW_CACHE_RESULT_MISS = 1,
	PERF_COUNT_HW_CACHE_RESULT_MAX = 2,
};

enum perf_hw_id {
	PERF_COUNT_HW_CPU_CYCLES = 0,
	PERF_COUNT_HW_INSTRUCTIONS = 1,
	PERF_COUNT_HW_CACHE_REFERENCES = 2,
	PERF_COUNT_HW_CACHE_MISSES = 3,
	PERF_COUNT_HW_BRANCH_INSTRUCTIONS = 4,
	PERF_COUNT_HW_BRANCH_MISSES = 5,
	PERF_COUNT_HW_BUS_CYCLES = 6,
	PERF_COUNT_HW_STALLED_CYCLES_FRONTEND = 7,
	PERF_COUNT_HW_STALLED_CYCLES_BACKEND = 8,
	PERF_COUNT_HW_REF_CPU_CYCLES = 9,
	PERF_COUNT_HW_MAX = 10,
};

enum perf_pmu_scope {
	PERF_PMU_SCOPE_NONE = 0,
	PERF_PMU_SCOPE_CORE = 1,
	PERF_PMU_SCOPE_DIE = 2,
	PERF_PMU_SCOPE_CLUSTER = 3,
	PERF_PMU_SCOPE_PKG = 4,
	PERF_PMU_SCOPE_SYS_WIDE = 5,
	PERF_PMU_MAX_SCOPE = 6,
};

enum perf_record_ksymbol_type {
	PERF_RECORD_KSYMBOL_TYPE_UNKNOWN = 0,
	PERF_RECORD_KSYMBOL_TYPE_BPF = 1,
	PERF_RECORD_KSYMBOL_TYPE_OOL = 2,
	PERF_RECORD_KSYMBOL_TYPE_MAX = 3,
};

enum perf_sample_regs_abi {
	PERF_SAMPLE_REGS_ABI_NONE = 0,
	PERF_SAMPLE_REGS_ABI_32 = 1,
	PERF_SAMPLE_REGS_ABI_64 = 2,
};

enum perf_sw_ids {
	PERF_COUNT_SW_CPU_CLOCK = 0,
	PERF_COUNT_SW_TASK_CLOCK = 1,
	PERF_COUNT_SW_PAGE_FAULTS = 2,
	PERF_COUNT_SW_CONTEXT_SWITCHES = 3,
	PERF_COUNT_SW_CPU_MIGRATIONS = 4,
	PERF_COUNT_SW_PAGE_FAULTS_MIN = 5,
	PERF_COUNT_SW_PAGE_FAULTS_MAJ = 6,
	PERF_COUNT_SW_ALIGNMENT_FAULTS = 7,
	PERF_COUNT_SW_EMULATION_FAULTS = 8,
	PERF_COUNT_SW_DUMMY = 9,
	PERF_COUNT_SW_BPF_OUTPUT = 10,
	PERF_COUNT_SW_CGROUP_SWITCHES = 11,
	PERF_COUNT_SW_MAX = 12,
};

enum perf_type_id {
	PERF_TYPE_HARDWARE = 0,
	PERF_TYPE_SOFTWARE = 1,
	PERF_TYPE_TRACEPOINT = 2,
	PERF_TYPE_HW_CACHE = 3,
	PERF_TYPE_RAW = 4,
	PERF_TYPE_BREAKPOINT = 5,
	PERF_TYPE_MAX = 6,
};

enum pgdat_flags {
	PGDAT_DIRTY = 0,
	PGDAT_WRITEBACK = 1,
	PGDAT_RECLAIM_LOCKED = 2,
};

enum pgt_entry {
	NORMAL_PMD = 0,
	HPAGE_PMD = 1,
	NORMAL_PUD = 2,
	HPAGE_PUD = 3,
};

enum phy_led_modes {
	PHY_LED_ACTIVE_HIGH = 0,
	PHY_LED_ACTIVE_LOW = 1,
	PHY_LED_INACTIVE_HIGH_IMPEDANCE = 2,
	__PHY_LED_MODES_NUM = 3,
};

enum phy_media {
	PHY_MEDIA_DEFAULT = 0,
	PHY_MEDIA_SR = 1,
	PHY_MEDIA_DAC = 2,
};

enum phy_mode {
	PHY_MODE_INVALID = 0,
	PHY_MODE_USB_HOST = 1,
	PHY_MODE_USB_HOST_LS = 2,
	PHY_MODE_USB_HOST_FS = 3,
	PHY_MODE_USB_HOST_HS = 4,
	PHY_MODE_USB_HOST_SS = 5,
	PHY_MODE_USB_DEVICE = 6,
	PHY_MODE_USB_DEVICE_LS = 7,
	PHY_MODE_USB_DEVICE_FS = 8,
	PHY_MODE_USB_DEVICE_HS = 9,
	PHY_MODE_USB_DEVICE_SS = 10,
	PHY_MODE_USB_OTG = 11,
	PHY_MODE_UFS_HS_A = 12,
	PHY_MODE_UFS_HS_B = 13,
	PHY_MODE_PCIE = 14,
	PHY_MODE_ETHERNET = 15,
	PHY_MODE_MIPI_DPHY = 16,
	PHY_MODE_SATA = 17,
	PHY_MODE_LVDS = 18,
	PHY_MODE_DP = 19,
	PHY_MODE_HDMI = 20,
};

enum phy_state {
	PHY_DOWN = 0,
	PHY_READY = 1,
	PHY_HALTED = 2,
	PHY_ERROR = 3,
	PHY_UP = 4,
	PHY_RUNNING = 5,
	PHY_NOLINK = 6,
	PHY_CABLETEST = 7,
};

enum phy_state_work {
	PHY_STATE_WORK_NONE = 0,
	PHY_STATE_WORK_ANEG = 1,
	PHY_STATE_WORK_SUSPEND = 2,
};

enum phy_tunable_id {
	ETHTOOL_PHY_ID_UNSPEC = 0,
	ETHTOOL_PHY_DOWNSHIFT = 1,
	ETHTOOL_PHY_FAST_LINK_DOWN = 2,
	ETHTOOL_PHY_EDPD = 3,
	__ETHTOOL_PHY_TUNABLE_COUNT = 4,
};

enum phy_upstream {
	PHY_UPSTREAM_MAC = 0,
	PHY_UPSTREAM_PHY = 1,
};

enum phylink_op_type {
	PHYLINK_NETDEV = 0,
	PHYLINK_DEV = 1,
};

enum pid_type {
	PIDTYPE_PID = 0,
	PIDTYPE_TGID = 1,
	PIDTYPE_PGID = 2,
	PIDTYPE_SID = 3,
	PIDTYPE_MAX = 4,
};

enum pidcg_event {
	PIDCG_MAX = 0,
	PIDCG_FORKFAIL = 1,
	NR_PIDCG_EVENTS = 2,
};

enum pin_config_param {
	PIN_CONFIG_BIAS_BUS_HOLD = 0,
	PIN_CONFIG_BIAS_DISABLE = 1,
	PIN_CONFIG_BIAS_HIGH_IMPEDANCE = 2,
	PIN_CONFIG_BIAS_PULL_DOWN = 3,
	PIN_CONFIG_BIAS_PULL_PIN_DEFAULT = 4,
	PIN_CONFIG_BIAS_PULL_UP = 5,
	PIN_CONFIG_DRIVE_OPEN_DRAIN = 6,
	PIN_CONFIG_DRIVE_OPEN_SOURCE = 7,
	PIN_CONFIG_DRIVE_PUSH_PULL = 8,
	PIN_CONFIG_DRIVE_STRENGTH = 9,
	PIN_CONFIG_DRIVE_STRENGTH_UA = 10,
	PIN_CONFIG_INPUT_DEBOUNCE = 11,
	PIN_CONFIG_INPUT_ENABLE = 12,
	PIN_CONFIG_INPUT_SCHMITT = 13,
	PIN_CONFIG_INPUT_SCHMITT_ENABLE = 14,
	PIN_CONFIG_INPUT_SCHMITT_UV = 15,
	PIN_CONFIG_MODE_LOW_POWER = 16,
	PIN_CONFIG_MODE_PWM = 17,
	PIN_CONFIG_OUTPUT = 18,
	PIN_CONFIG_OUTPUT_ENABLE = 19,
	PIN_CONFIG_OUTPUT_IMPEDANCE_OHMS = 20,
	PIN_CONFIG_PERSIST_STATE = 21,
	PIN_CONFIG_POWER_SOURCE = 22,
	PIN_CONFIG_SKEW_DELAY = 23,
	PIN_CONFIG_SLEEP_HARDWARE_STATE = 24,
	PIN_CONFIG_SLEW_RATE = 25,
	PIN_CONFIG_END = 127,
	PIN_CONFIG_MAX = 255,
};

enum pincfg_type {
	PINCFG_TYPE_FUNC = 0,
	PINCFG_TYPE_DAT = 1,
	PINCFG_TYPE_PUD = 2,
	PINCFG_TYPE_DRV = 3,
	PINCFG_TYPE_CON_PDN = 4,
	PINCFG_TYPE_PUD_PDN = 5,
	PINCFG_TYPE_NUM = 6,
};

enum pinctrl_map_type {
	PIN_MAP_TYPE_INVALID = 0,
	PIN_MAP_TYPE_DUMMY_STATE = 1,
	PIN_MAP_TYPE_MUX_GROUP = 2,
	PIN_MAP_TYPE_CONFIGS_PIN = 3,
	PIN_MAP_TYPE_CONFIGS_GROUP = 4,
};

enum pipe3_mode {
	PIPE3_MODE_PCIE = 1,
	PIPE3_MODE_SATA = 2,
	PIPE3_MODE_USBSS = 3,
};

enum pkcs7_actions {
	ACT_pkcs7_check_content_type = 0,
	ACT_pkcs7_extract_cert = 1,
	ACT_pkcs7_note_OID = 2,
	ACT_pkcs7_note_certificate_list = 3,
	ACT_pkcs7_note_content = 4,
	ACT_pkcs7_note_data = 5,
	ACT_pkcs7_note_signed_info = 6,
	ACT_pkcs7_note_signeddata_version = 7,
	ACT_pkcs7_note_signerinfo_version = 8,
	ACT_pkcs7_sig_note_authenticated_attr = 9,
	ACT_pkcs7_sig_note_digest_algo = 10,
	ACT_pkcs7_sig_note_issuer = 11,
	ACT_pkcs7_sig_note_pkey_algo = 12,
	ACT_pkcs7_sig_note_serial = 13,
	ACT_pkcs7_sig_note_set_of_authattrs = 14,
	ACT_pkcs7_sig_note_signature = 15,
	ACT_pkcs7_sig_note_skid = 16,
	NR__pkcs7_actions = 17,
};

enum pkt_hash_types {
	PKT_HASH_TYPE_NONE = 0,
	PKT_HASH_TYPE_L2 = 1,
	PKT_HASH_TYPE_L3 = 2,
	PKT_HASH_TYPE_L4 = 3,
};

enum pl011_rs485_tx_state {
	OFF___2 = 0,
	WAIT_AFTER_RTS___2 = 1,
	SEND___2 = 2,
	WAIT_AFTER_SEND___2 = 3,
};

enum pl08x_burst_size {
	PL08X_BURST_SZ_1 = 0,
	PL08X_BURST_SZ_4 = 1,
	PL08X_BURST_SZ_8 = 2,
	PL08X_BURST_SZ_16 = 3,
	PL08X_BURST_SZ_32 = 4,
	PL08X_BURST_SZ_64 = 5,
	PL08X_BURST_SZ_128 = 6,
	PL08X_BURST_SZ_256 = 7,
};

enum pl08x_bus_width {
	PL08X_BUS_WIDTH_8_BITS = 0,
	PL08X_BUS_WIDTH_16_BITS = 1,
	PL08X_BUS_WIDTH_32_BITS = 2,
};

enum pl08x_dma_chan_state {
	PL08X_CHAN_IDLE = 0,
	PL08X_CHAN_RUNNING = 1,
	PL08X_CHAN_PAUSED = 2,
	PL08X_CHAN_WAITING = 3,
};

enum pl330_byteswap {
	SWAP_NO = 0,
	SWAP_2 = 1,
	SWAP_4 = 2,
	SWAP_8 = 3,
	SWAP_16 = 4,
};

enum pl330_cachectrl {
	CCTRL0 = 0,
	CCTRL1 = 1,
	CCTRL2 = 2,
	CCTRL3 = 3,
	INVALID1 = 4,
	INVALID2 = 5,
	CCTRL6 = 6,
	CCTRL7 = 7,
};

enum pl330_cond {
	SINGLE = 0,
	BURST = 1,
	ALWAYS = 2,
};

enum pl330_dmac_state {
	UNINIT = 0,
	INIT = 1,
	DYING = 2,
};

enum pl330_op_err {
	PL330_ERR_NONE = 0,
	PL330_ERR_ABORT = 1,
	PL330_ERR_FAIL = 2,
};

enum pldmfw_update_mode {
	PLDMFW_UPDATE_MODE_FULL = 0,
	PLDMFW_UPDATE_MODE_SINGLE_COMPONENT = 1,
};

enum pm_api_id {
	PM_API_FEATURES = 0,
	PM_GET_API_VERSION = 1,
	PM_REGISTER_NOTIFIER = 5,
	PM_FORCE_POWERDOWN = 8,
	PM_REQUEST_WAKEUP = 10,
	PM_SYSTEM_SHUTDOWN = 12,
	PM_REQUEST_NODE = 13,
	PM_RELEASE_NODE = 14,
	PM_SET_REQUIREMENT = 15,
	PM_RESET_ASSERT = 17,
	PM_RESET_GET_STATUS = 18,
	PM_MMIO_WRITE = 19,
	PM_MMIO_READ = 20,
	PM_PM_INIT_FINALIZE = 21,
	PM_FPGA_LOAD = 22,
	PM_FPGA_GET_STATUS = 23,
	PM_GET_CHIPID = 24,
	PM_SECURE_SHA = 26,
	PM_PINCTRL_REQUEST = 28,
	PM_PINCTRL_RELEASE = 29,
	PM_PINCTRL_SET_FUNCTION = 31,
	PM_PINCTRL_CONFIG_PARAM_GET = 32,
	PM_PINCTRL_CONFIG_PARAM_SET = 33,
	PM_IOCTL = 34,
	PM_QUERY_DATA = 35,
	PM_CLOCK_ENABLE = 36,
	PM_CLOCK_DISABLE = 37,
	PM_CLOCK_GETSTATE = 38,
	PM_CLOCK_SETDIVIDER = 39,
	PM_CLOCK_GETDIVIDER = 40,
	PM_CLOCK_SETPARENT = 43,
	PM_CLOCK_GETPARENT = 44,
	PM_FPGA_READ = 46,
	PM_SECURE_AES = 47,
	PM_EFUSE_ACCESS = 53,
	PM_FEATURE_CHECK = 63,
};

enum pm_ioctl_id {
	IOCTL_GET_RPU_OPER_MODE = 0,
	IOCTL_SET_RPU_OPER_MODE = 1,
	IOCTL_RPU_BOOT_ADDR_CONFIG = 2,
	IOCTL_TCM_COMB_CONFIG = 3,
	IOCTL_SET_TAPDELAY_BYPASS = 4,
	IOCTL_SD_DLL_RESET = 6,
	IOCTL_SET_SD_TAPDELAY = 7,
	IOCTL_SET_PLL_FRAC_MODE = 8,
	IOCTL_GET_PLL_FRAC_MODE = 9,
	IOCTL_SET_PLL_FRAC_DATA = 10,
	IOCTL_GET_PLL_FRAC_DATA = 11,
	IOCTL_WRITE_GGS = 12,
	IOCTL_READ_GGS = 13,
	IOCTL_WRITE_PGGS = 14,
	IOCTL_READ_PGGS = 15,
	IOCTL_SET_BOOT_HEALTH_STATUS = 17,
	IOCTL_OSPI_MUX_SELECT = 21,
	IOCTL_REGISTER_SGI = 25,
	IOCTL_SET_FEATURE_CONFIG = 26,
	IOCTL_GET_FEATURE_CONFIG = 27,
	IOCTL_READ_REG = 28,
	IOCTL_SET_SD_CONFIG = 30,
	IOCTL_SET_GEM_CONFIG = 31,
	IOCTL_GET_QOS = 34,
};

enum pm_node_id {
	NODE_SD_0 = 39,
	NODE_SD_1 = 40,
};

enum pm_qos_flags_status {
	PM_QOS_FLAGS_UNDEFINED = -1,
	PM_QOS_FLAGS_NONE = 0,
	PM_QOS_FLAGS_SOME = 1,
	PM_QOS_FLAGS_ALL = 2,
};

enum pm_qos_req_action {
	PM_QOS_ADD_REQ = 0,
	PM_QOS_UPDATE_REQ = 1,
	PM_QOS_REMOVE_REQ = 2,
};

enum pm_qos_type {
	PM_QOS_UNITIALIZED = 0,
	PM_QOS_MAX = 1,
	PM_QOS_MIN = 2,
};

enum pm_sd_config_type {
	SD_CONFIG_EMMC_SEL = 1,
	SD_CONFIG_BASECLK = 2,
	SD_CONFIG_8BIT = 3,
	SD_CONFIG_FIXED = 4,
};

enum pmsu_idle_prepare_flags {
	PMSU_PREPARE_NORMAL = 0,
	PMSU_PREPARE_DEEP_IDLE = 1,
	PMSU_PREPARE_SNOOP_DISABLE = 2,
};

enum pnfs_iomode {
	IOMODE_READ = 1,
	IOMODE_RW = 2,
	IOMODE_ANY = 3,
};

enum pnfs_layout_destroy_mode {
	PNFS_LAYOUT_INVALIDATE = 0,
	PNFS_LAYOUT_BULK_RETURN = 1,
	PNFS_LAYOUT_FILE_BULK_RETURN = 2,
};

enum pnfs_layoutreturn_type {
	RETURN_FILE = 1,
	RETURN_FSID = 2,
	RETURN_ALL = 3,
};

enum pnfs_layouttype {
	LAYOUT_NFSV4_1_FILES = 1,
	LAYOUT_OSD2_OBJECTS = 2,
	LAYOUT_BLOCK_VOLUME = 3,
	LAYOUT_FLEX_FILES = 4,
	LAYOUT_SCSI = 5,
	LAYOUT_TYPE_MAX = 6,
};

enum pnfs_notify_deviceid_type4 {
	NOTIFY_DEVICEID4_CHANGE = 2,
	NOTIFY_DEVICEID4_DELETE = 4,
};

enum pnfs_try_status {
	PNFS_ATTEMPTED = 0,
	PNFS_NOT_ATTEMPTED = 1,
	PNFS_TRY_AGAIN = 2,
};

enum pnfs_update_layout_reason {
	PNFS_UPDATE_LAYOUT_UNKNOWN = 0,
	PNFS_UPDATE_LAYOUT_NO_PNFS = 1,
	PNFS_UPDATE_LAYOUT_RD_ZEROLEN = 2,
	PNFS_UPDATE_LAYOUT_MDSTHRESH = 3,
	PNFS_UPDATE_LAYOUT_NOMEM = 4,
	PNFS_UPDATE_LAYOUT_BULK_RECALL = 5,
	PNFS_UPDATE_LAYOUT_IO_TEST_FAIL = 6,
	PNFS_UPDATE_LAYOUT_FOUND_CACHED = 7,
	PNFS_UPDATE_LAYOUT_RETURN = 8,
	PNFS_UPDATE_LAYOUT_RETRY = 9,
	PNFS_UPDATE_LAYOUT_BLOCKED = 10,
	PNFS_UPDATE_LAYOUT_INVALID_OPEN = 11,
	PNFS_UPDATE_LAYOUT_SEND_LAYOUTGET = 12,
	PNFS_UPDATE_LAYOUT_EXIT = 13,
};

enum poll_time_type {
	PT_TIMEVAL = 0,
	PT_OLD_TIMEVAL = 1,
	PT_TIMESPEC = 2,
	PT_OLD_TIMESPEC = 3,
};

enum pool_workqueue_stats {
	PWQ_STAT_STARTED = 0,
	PWQ_STAT_COMPLETED = 1,
	PWQ_STAT_CPU_TIME = 2,
	PWQ_STAT_CPU_INTENSIVE = 3,
	PWQ_STAT_CM_WAKEUP = 4,
	PWQ_STAT_REPATRIATED = 5,
	PWQ_STAT_MAYDAY = 6,
	PWQ_STAT_RESCUED = 7,
	PWQ_NR_STATS = 8,
};

enum port_pkey_state {
	IB_PORT_PKEY_NOT_VALID = 0,
	IB_PORT_PKEY_VALID = 1,
	IB_PORT_PKEY_LISTED = 2,
};

enum positive_aop_returns {
	AOP_WRITEPAGE_ACTIVATE = 524288,
	AOP_TRUNCATED_PAGE = 524289,
};

enum posix_timer_state {
	POSIX_TIMER_DISARMED = 0,
	POSIX_TIMER_ARMED = 1,
	POSIX_TIMER_REQUEUE_PENDING = 2,
};

enum power_supply_charge_behaviour {
	POWER_SUPPLY_CHARGE_BEHAVIOUR_AUTO = 0,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE = 1,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_INHIBIT_CHARGE_AWAKE = 2,
	POWER_SUPPLY_CHARGE_BEHAVIOUR_FORCE_DISCHARGE = 3,
};

enum power_supply_charge_type {
	POWER_SUPPLY_CHARGE_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_CHARGE_TYPE_NONE = 1,
	POWER_SUPPLY_CHARGE_TYPE_TRICKLE = 2,
	POWER_SUPPLY_CHARGE_TYPE_FAST = 3,
	POWER_SUPPLY_CHARGE_TYPE_STANDARD = 4,
	POWER_SUPPLY_CHARGE_TYPE_ADAPTIVE = 5,
	POWER_SUPPLY_CHARGE_TYPE_CUSTOM = 6,
	POWER_SUPPLY_CHARGE_TYPE_LONGLIFE = 7,
	POWER_SUPPLY_CHARGE_TYPE_BYPASS = 8,
};

enum power_supply_notifier_events {
	PSY_EVENT_PROP_CHANGED = 0,
};

enum power_supply_property {
	POWER_SUPPLY_PROP_STATUS = 0,
	POWER_SUPPLY_PROP_CHARGE_TYPE = 1,
	POWER_SUPPLY_PROP_CHARGE_TYPES = 2,
	POWER_SUPPLY_PROP_HEALTH = 3,
	POWER_SUPPLY_PROP_PRESENT = 4,
	POWER_SUPPLY_PROP_ONLINE = 5,
	POWER_SUPPLY_PROP_AUTHENTIC = 6,
	POWER_SUPPLY_PROP_TECHNOLOGY = 7,
	POWER_SUPPLY_PROP_CYCLE_COUNT = 8,
	POWER_SUPPLY_PROP_VOLTAGE_MAX = 9,
	POWER_SUPPLY_PROP_VOLTAGE_MIN = 10,
	POWER_SUPPLY_PROP_VOLTAGE_MAX_DESIGN = 11,
	POWER_SUPPLY_PROP_VOLTAGE_MIN_DESIGN = 12,
	POWER_SUPPLY_PROP_VOLTAGE_NOW = 13,
	POWER_SUPPLY_PROP_VOLTAGE_AVG = 14,
	POWER_SUPPLY_PROP_VOLTAGE_OCV = 15,
	POWER_SUPPLY_PROP_VOLTAGE_BOOT = 16,
	POWER_SUPPLY_PROP_CURRENT_MAX = 17,
	POWER_SUPPLY_PROP_CURRENT_NOW = 18,
	POWER_SUPPLY_PROP_CURRENT_AVG = 19,
	POWER_SUPPLY_PROP_CURRENT_BOOT = 20,
	POWER_SUPPLY_PROP_POWER_NOW = 21,
	POWER_SUPPLY_PROP_POWER_AVG = 22,
	POWER_SUPPLY_PROP_CHARGE_FULL_DESIGN = 23,
	POWER_SUPPLY_PROP_CHARGE_EMPTY_DESIGN = 24,
	POWER_SUPPLY_PROP_CHARGE_FULL = 25,
	POWER_SUPPLY_PROP_CHARGE_EMPTY = 26,
	POWER_SUPPLY_PROP_CHARGE_NOW = 27,
	POWER_SUPPLY_PROP_CHARGE_AVG = 28,
	POWER_SUPPLY_PROP_CHARGE_COUNTER = 29,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT = 30,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_CURRENT_MAX = 31,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE = 32,
	POWER_SUPPLY_PROP_CONSTANT_CHARGE_VOLTAGE_MAX = 33,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT = 34,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_LIMIT_MAX = 35,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_START_THRESHOLD = 36,
	POWER_SUPPLY_PROP_CHARGE_CONTROL_END_THRESHOLD = 37,
	POWER_SUPPLY_PROP_CHARGE_BEHAVIOUR = 38,
	POWER_SUPPLY_PROP_INPUT_CURRENT_LIMIT = 39,
	POWER_SUPPLY_PROP_INPUT_VOLTAGE_LIMIT = 40,
	POWER_SUPPLY_PROP_INPUT_POWER_LIMIT = 41,
	POWER_SUPPLY_PROP_ENERGY_FULL_DESIGN = 42,
	POWER_SUPPLY_PROP_ENERGY_EMPTY_DESIGN = 43,
	POWER_SUPPLY_PROP_ENERGY_FULL = 44,
	POWER_SUPPLY_PROP_ENERGY_EMPTY = 45,
	POWER_SUPPLY_PROP_ENERGY_NOW = 46,
	POWER_SUPPLY_PROP_ENERGY_AVG = 47,
	POWER_SUPPLY_PROP_CAPACITY = 48,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MIN = 49,
	POWER_SUPPLY_PROP_CAPACITY_ALERT_MAX = 50,
	POWER_SUPPLY_PROP_CAPACITY_ERROR_MARGIN = 51,
	POWER_SUPPLY_PROP_CAPACITY_LEVEL = 52,
	POWER_SUPPLY_PROP_TEMP = 53,
	POWER_SUPPLY_PROP_TEMP_MAX = 54,
	POWER_SUPPLY_PROP_TEMP_MIN = 55,
	POWER_SUPPLY_PROP_TEMP_ALERT_MIN = 56,
	POWER_SUPPLY_PROP_TEMP_ALERT_MAX = 57,
	POWER_SUPPLY_PROP_TEMP_AMBIENT = 58,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MIN = 59,
	POWER_SUPPLY_PROP_TEMP_AMBIENT_ALERT_MAX = 60,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_NOW = 61,
	POWER_SUPPLY_PROP_TIME_TO_EMPTY_AVG = 62,
	POWER_SUPPLY_PROP_TIME_TO_FULL_NOW = 63,
	POWER_SUPPLY_PROP_TIME_TO_FULL_AVG = 64,
	POWER_SUPPLY_PROP_TYPE = 65,
	POWER_SUPPLY_PROP_USB_TYPE = 66,
	POWER_SUPPLY_PROP_SCOPE = 67,
	POWER_SUPPLY_PROP_PRECHARGE_CURRENT = 68,
	POWER_SUPPLY_PROP_CHARGE_TERM_CURRENT = 69,
	POWER_SUPPLY_PROP_CALIBRATE = 70,
	POWER_SUPPLY_PROP_MANUFACTURE_YEAR = 71,
	POWER_SUPPLY_PROP_MANUFACTURE_MONTH = 72,
	POWER_SUPPLY_PROP_MANUFACTURE_DAY = 73,
	POWER_SUPPLY_PROP_MODEL_NAME = 74,
	POWER_SUPPLY_PROP_MANUFACTURER = 75,
	POWER_SUPPLY_PROP_SERIAL_NUMBER = 76,
};

enum power_supply_type {
	POWER_SUPPLY_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_TYPE_BATTERY = 1,
	POWER_SUPPLY_TYPE_UPS = 2,
	POWER_SUPPLY_TYPE_MAINS = 3,
	POWER_SUPPLY_TYPE_USB = 4,
	POWER_SUPPLY_TYPE_USB_DCP = 5,
	POWER_SUPPLY_TYPE_USB_CDP = 6,
	POWER_SUPPLY_TYPE_USB_ACA = 7,
	POWER_SUPPLY_TYPE_USB_TYPE_C = 8,
	POWER_SUPPLY_TYPE_USB_PD = 9,
	POWER_SUPPLY_TYPE_USB_PD_DRP = 10,
	POWER_SUPPLY_TYPE_APPLE_BRICK_ID = 11,
	POWER_SUPPLY_TYPE_WIRELESS = 12,
};

enum power_supply_usb_type {
	POWER_SUPPLY_USB_TYPE_UNKNOWN = 0,
	POWER_SUPPLY_USB_TYPE_SDP = 1,
	POWER_SUPPLY_USB_TYPE_DCP = 2,
	POWER_SUPPLY_USB_TYPE_CDP = 3,
	POWER_SUPPLY_USB_TYPE_ACA = 4,
	POWER_SUPPLY_USB_TYPE_C = 5,
	POWER_SUPPLY_USB_TYPE_PD = 6,
	POWER_SUPPLY_USB_TYPE_PD_DRP = 7,
	POWER_SUPPLY_USB_TYPE_PD_PPS = 8,
	POWER_SUPPLY_USB_TYPE_APPLE_BRICK_ID = 9,
};

enum pr_status {
	PR_STS_SUCCESS = 0,
	PR_STS_IOERR = 2,
	PR_STS_RESERVATION_CONFLICT = 24,
	PR_STS_RETRY_PATH_FAILURE = 917504,
	PR_STS_PATH_FAST_FAILED = 983040,
	PR_STS_PATH_FAILED = 65536,
};

enum pr_type {
	PR_WRITE_EXCLUSIVE = 1,
	PR_EXCLUSIVE_ACCESS = 2,
	PR_WRITE_EXCLUSIVE_REG_ONLY = 3,
	PR_EXCLUSIVE_ACCESS_REG_ONLY = 4,
	PR_WRITE_EXCLUSIVE_ALL_REGS = 5,
	PR_EXCLUSIVE_ACCESS_ALL_REGS = 6,
};

enum pre_emphasis_level {
	PRE_EMPHASIS_LEVEL_0 = 0,
	PRE_EMPHASIS_LEVEL_1 = 1,
	PRE_EMPHASIS_LEVEL_2 = 2,
	PRE_EMPHASIS_LEVEL_3 = 3,
};

enum preempt_state {
	PREEMPT_NONE___2 = 0,
	PREEMPT_START___2 = 1,
	PREEMPT_ABORT = 2,
	PREEMPT_TRIGGERED___2 = 3,
	PREEMPT_FAULTED___2 = 4,
	PREEMPT_PENDING___2 = 5,
};

enum prep_dispatch {
	PREP_DISPATCH_OK = 0,
	PREP_DISPATCH_NO_TAG = 1,
	PREP_DISPATCH_NO_BUDGET = 2,
};

enum printk_info_flags {
	LOG_FORCE_CON = 1,
	LOG_NEWLINE = 2,
	LOG_CONT = 8,
};

enum prio_policy {
	POLICY_NO_CHANGE = 0,
	POLICY_PROMOTE_TO_RT = 1,
	POLICY_RESTRICT_TO_BE = 2,
	POLICY_ALL_TO_IDLE = 3,
	POLICY_NONE_TO_RT = 4,
};

enum priv_stack_mode {
	PRIV_STACK_UNKNOWN = 0,
	NO_PRIV_STACK = 1,
	PRIV_STACK_ADAPTIVE = 2,
};

enum probe_type {
	PROBE_DEFAULT_STRATEGY = 0,
	PROBE_PREFER_ASYNCHRONOUS = 1,
	PROBE_FORCE_SYNCHRONOUS = 2,
};

enum probes_arm_action {
	PROBES_PRELOAD_IMM = 0,
	PROBES_PRELOAD_REG = 1,
	PROBES_BRANCH_IMM = 2,
	PROBES_BRANCH_REG = 3,
	PROBES_MRS = 4,
	PROBES_CLZ = 5,
	PROBES_SATURATING_ARITHMETIC = 6,
	PROBES_MUL1 = 7,
	PROBES_MUL2 = 8,
	PROBES_SWP = 9,
	PROBES_LDRSTRD = 10,
	PROBES_LOAD = 11,
	PROBES_STORE = 12,
	PROBES_LOAD_EXTRA = 13,
	PROBES_STORE_EXTRA = 14,
	PROBES_MOV_IP_SP = 15,
	PROBES_DATA_PROCESSING_REG = 16,
	PROBES_DATA_PROCESSING_IMM = 17,
	PROBES_MOV_HALFWORD = 18,
	PROBES_SEV = 19,
	PROBES_WFE = 20,
	PROBES_SATURATE = 21,
	PROBES_REV = 22,
	PROBES_MMI = 23,
	PROBES_PACK = 24,
	PROBES_EXTEND = 25,
	PROBES_EXTEND_ADD = 26,
	PROBES_MUL_ADD_LONG = 27,
	PROBES_MUL_ADD = 28,
	PROBES_BITFIELD = 29,
	PROBES_BRANCH = 30,
	PROBES_LDMSTM = 31,
	NUM_PROBES_ARM_ACTIONS = 32,
};

enum probes_insn {
	INSN_REJECTED = 0,
	INSN_GOOD = 1,
	INSN_GOOD_NO_SLOT = 2,
};

enum proc_cn_event {
	PROC_EVENT_NONE = 0,
	PROC_EVENT_FORK = 1,
	PROC_EVENT_EXEC = 2,
	PROC_EVENT_UID = 4,
	PROC_EVENT_GID = 64,
	PROC_EVENT_SID = 128,
	PROC_EVENT_PTRACE = 256,
	PROC_EVENT_COMM = 512,
	PROC_EVENT_NONZERO_EXIT = 536870912,
	PROC_EVENT_COREDUMP = 1073741824,
	PROC_EVENT_EXIT = 2147483648,
};

enum proc_cn_mcast_op {
	PROC_CN_MCAST_LISTEN = 1,
	PROC_CN_MCAST_IGNORE = 2,
};

enum proc_hidepid {
	HIDEPID_OFF = 0,
	HIDEPID_NO_ACCESS = 1,
	HIDEPID_INVISIBLE = 2,
	HIDEPID_NOT_PTRACEABLE = 4,
};

enum proc_mem_force {
	PROC_MEM_FORCE_ALWAYS = 0,
	PROC_MEM_FORCE_PTRACE = 1,
	PROC_MEM_FORCE_NEVER = 2,
};

enum proc_param {
	Opt_gid___5 = 0,
	Opt_hidepid = 1,
	Opt_subset = 2,
};

enum proc_pidonly {
	PROC_PIDONLY_OFF = 0,
	PROC_PIDONLY_ON = 1,
};

enum procmap_query_flags {
	PROCMAP_QUERY_VMA_READABLE = 1,
	PROCMAP_QUERY_VMA_WRITABLE = 2,
	PROCMAP_QUERY_VMA_EXECUTABLE = 4,
	PROCMAP_QUERY_VMA_SHARED = 8,
	PROCMAP_QUERY_COVERING_OR_NEXT_VMA = 16,
	PROCMAP_QUERY_FILE_BACKED_VMA = 32,
};

enum prs_errcode {
	PERR_NONE = 0,
	PERR_INVCPUS = 1,
	PERR_INVPARENT = 2,
	PERR_NOTPART = 3,
	PERR_NOTEXCL = 4,
	PERR_NOCPUS = 5,
	PERR_HOTPLUG = 6,
	PERR_CPUSEMPTY = 7,
	PERR_HKEEPING = 8,
	PERR_ACCESS = 9,
	PERR_REMOTE = 10,
};

enum pru_type {
	PRU_TYPE_PRU = 0,
	PRU_TYPE_RTU = 1,
	PRU_TYPE_TX_PRU = 2,
	PRU_TYPE_MAX = 3,
};

enum pruss_gp_mux_sel {
	PRUSS_GP_MUX_SEL_GP = 0,
	PRUSS_GP_MUX_SEL_ENDAT = 1,
	PRUSS_GP_MUX_SEL_RESERVED = 2,
	PRUSS_GP_MUX_SEL_SD = 3,
	PRUSS_GP_MUX_SEL_MII2 = 4,
	PRUSS_GP_MUX_SEL_MAX = 5,
};

enum pruss_gpi_mode {
	PRUSS_GPI_MODE_DIRECT = 0,
	PRUSS_GPI_MODE_PARALLEL = 1,
	PRUSS_GPI_MODE_28BIT_SHIFT = 2,
	PRUSS_GPI_MODE_MII = 3,
	PRUSS_GPI_MODE_MAX = 4,
};

enum pruss_mem {
	PRUSS_MEM_DRAM0 = 0,
	PRUSS_MEM_DRAM1 = 1,
	PRUSS_MEM_SHRD_RAM2 = 2,
	PRUSS_MEM_MAX = 3,
};

enum pruss_pru_id {
	PRUSS_PRU0 = 0,
	PRUSS_PRU1 = 1,
	PRUSS_NUM_PRUS = 2,
};

enum pseudo_reg {
	SMMU_INFO = 0,
	NON_SECURE_SAVE_ADDR = 1,
	SECURE_SAVE_ADDR = 2,
	NON_PRIV_SAVE_ADDR = 3,
	COUNTER = 4,
	VSC_PIPE_DATA_DRAW_BASE = 8,
	VSC_SIZE_BASE = 9,
	VSC_PIPE_DATA_PRIM_BASE = 10,
	UNK_STRM_ADDRESS = 11,
	UNK_STRM_SIZE_ADDRESS = 12,
	BINDLESS_BASE_0_ADDR = 16,
	BINDLESS_BASE_1_ADDR = 17,
	BINDLESS_BASE_2_ADDR = 18,
	BINDLESS_BASE_3_ADDR = 19,
	BINDLESS_BASE_4_ADDR = 20,
	BINDLESS_BASE_5_ADDR = 21,
	BINDLESS_BASE_6_ADDR = 22,
};

enum psi_aggregators {
	PSI_AVGS = 0,
	PSI_POLL = 1,
	NR_PSI_AGGREGATORS = 2,
};

enum psi_res {
	PSI_IO = 0,
	PSI_MEM = 1,
	PSI_CPU = 2,
	NR_PSI_RESOURCES = 3,
};

enum psi_states {
	PSI_IO_SOME = 0,
	PSI_IO_FULL = 1,
	PSI_MEM_SOME = 2,
	PSI_MEM_FULL = 3,
	PSI_CPU_SOME = 4,
	PSI_CPU_FULL = 5,
	PSI_NONIDLE = 6,
	NR_PSI_STATES = 7,
};

enum psi_task_count {
	NR_IOWAIT = 0,
	NR_MEMSTALL = 1,
	NR_RUNNING = 2,
	NR_MEMSTALL_RUNNING = 3,
	NR_PSI_TASK_COUNTS = 4,
};

enum ptp_clock_events {
	PTP_CLOCK_ALARM = 0,
	PTP_CLOCK_EXTTS = 1,
	PTP_CLOCK_EXTOFF = 2,
	PTP_CLOCK_PPS = 3,
	PTP_CLOCK_PPSUSR = 4,
};

enum ptp_pin_function {
	PTP_PF_NONE = 0,
	PTP_PF_EXTTS = 1,
	PTP_PF_PEROUT = 2,
	PTP_PF_PHYSYNC = 3,
};

enum ptrace_syscall_dir {
	PTRACE_SYSCALL_ENTER = 0,
	PTRACE_SYSCALL_EXIT = 1,
};

enum pud_index {
	PUD_PULL_DISABLE = 0,
	PUD_PULL_DOWN = 1,
	PUD_PULL_UP = 2,
	PUD_MAX = 3,
};

enum pwm_polarity {
	PWM_POLARITY_NORMAL = 0,
	PWM_POLARITY_INVERSED = 1,
};

enum qcom_scm_arg_types {
	QCOM_SCM_VAL = 0,
	QCOM_SCM_RO = 1,
	QCOM_SCM_RW = 2,
	QCOM_SCM_BUFVAL = 3,
};

enum qcom_scm_convention {
	SMC_CONVENTION_UNKNOWN = 0,
	SMC_CONVENTION_LEGACY = 1,
	SMC_CONVENTION_ARM_32 = 2,
	SMC_CONVENTION_ARM_64 = 3,
};

enum qcom_scm_ice_cipher {
	QCOM_SCM_ICE_CIPHER_AES_128_XTS = 0,
	QCOM_SCM_ICE_CIPHER_AES_128_CBC = 1,
	QCOM_SCM_ICE_CIPHER_AES_256_XTS = 3,
	QCOM_SCM_ICE_CIPHER_AES_256_CBC = 4,
};

enum qcom_scm_ocmem_client {
	QCOM_SCM_OCMEM_UNUSED_ID = 0,
	QCOM_SCM_OCMEM_GRAPHICS_ID = 1,
	QCOM_SCM_OCMEM_VIDEO_ID = 2,
	QCOM_SCM_OCMEM_LP_AUDIO_ID = 3,
	QCOM_SCM_OCMEM_SENSORS_ID = 4,
	QCOM_SCM_OCMEM_OTHER_OS_ID = 5,
	QCOM_SCM_OCMEM_DEBUG_ID = 6,
};

enum qcom_tzmem_policy {
	QCOM_TZMEM_POLICY_STATIC = 1,
	QCOM_TZMEM_POLICY_MULTIPLIER = 2,
	QCOM_TZMEM_POLICY_ON_DEMAND = 3,
};

enum qdisc_class_ops_flags {
	QDISC_CLASS_OPS_DOIT_UNLOCKED = 1,
};

enum qdisc_state2_t {
	__QDISC_STATE2_RUNNING = 0,
};

enum qdisc_state_t {
	__QDISC_STATE_SCHED = 0,
	__QDISC_STATE_DEACTIVATED = 1,
	__QDISC_STATE_MISSED = 2,
	__QDISC_STATE_DRAINING = 3,
};

enum quota_type {
	USRQUOTA = 0,
	GRPQUOTA = 1,
	PRJQUOTA = 2,
};

enum ramfs_param {
	Opt_mode___4 = 0,
};

enum rc_driver_type {
	RC_DRIVER_SCANCODE = 0,
	RC_DRIVER_IR_RAW = 1,
	RC_DRIVER_IR_RAW_TX = 2,
};

enum rc_proto {
	RC_PROTO_UNKNOWN = 0,
	RC_PROTO_OTHER = 1,
	RC_PROTO_RC5 = 2,
	RC_PROTO_RC5X_20 = 3,
	RC_PROTO_RC5_SZ = 4,
	RC_PROTO_JVC = 5,
	RC_PROTO_SONY12 = 6,
	RC_PROTO_SONY15 = 7,
	RC_PROTO_SONY20 = 8,
	RC_PROTO_NEC = 9,
	RC_PROTO_NECX = 10,
	RC_PROTO_NEC32 = 11,
	RC_PROTO_SANYO = 12,
	RC_PROTO_MCIR2_KBD = 13,
	RC_PROTO_MCIR2_MSE = 14,
	RC_PROTO_RC6_0 = 15,
	RC_PROTO_RC6_6A_20 = 16,
	RC_PROTO_RC6_6A_24 = 17,
	RC_PROTO_RC6_6A_32 = 18,
	RC_PROTO_RC6_MCE = 19,
	RC_PROTO_SHARP = 20,
	RC_PROTO_XMP = 21,
	RC_PROTO_CEC = 22,
	RC_PROTO_IMON = 23,
	RC_PROTO_RCMM12 = 24,
	RC_PROTO_RCMM24 = 25,
	RC_PROTO_RCMM32 = 26,
	RC_PROTO_XBOX_DVD = 27,
	RC_PROTO_MAX = 27,
};

enum rd_sect_type {
	RD_NONE = 0,
	RD_TEST = 1,
	RD_CMD = 2,
	RD_GPUADDR = 3,
	RD_CONTEXT = 4,
	RD_CMDSTREAM = 5,
	RD_CMDSTREAM_ADDR = 6,
	RD_PARAM = 7,
	RD_FLUSH = 8,
	RD_PROGRAM = 9,
	RD_VERT_SHADER = 10,
	RD_FRAG_SHADER = 11,
	RD_BUFFER_CONTENTS = 12,
	RD_GPU_ID = 13,
	RD_CHIP_ID = 14,
};

enum rdma_ah_attr_type {
	RDMA_AH_ATTR_TYPE_UNDEFINED = 0,
	RDMA_AH_ATTR_TYPE_IB = 1,
	RDMA_AH_ATTR_TYPE_ROCE = 2,
	RDMA_AH_ATTR_TYPE_OPA = 3,
};

enum rdma_driver_id {
	RDMA_DRIVER_UNKNOWN = 0,
	RDMA_DRIVER_MLX5 = 1,
	RDMA_DRIVER_MLX4 = 2,
	RDMA_DRIVER_CXGB3 = 3,
	RDMA_DRIVER_CXGB4 = 4,
	RDMA_DRIVER_MTHCA = 5,
	RDMA_DRIVER_BNXT_RE = 6,
	RDMA_DRIVER_OCRDMA = 7,
	RDMA_DRIVER_NES = 8,
	RDMA_DRIVER_I40IW = 9,
	RDMA_DRIVER_IRDMA = 9,
	RDMA_DRIVER_VMW_PVRDMA = 10,
	RDMA_DRIVER_QEDR = 11,
	RDMA_DRIVER_HNS = 12,
	RDMA_DRIVER_USNIC = 13,
	RDMA_DRIVER_RXE = 14,
	RDMA_DRIVER_HFI1 = 15,
	RDMA_DRIVER_QIB = 16,
	RDMA_DRIVER_EFA = 17,
	RDMA_DRIVER_SIW = 18,
	RDMA_DRIVER_ERDMA = 19,
	RDMA_DRIVER_MANA = 20,
};

enum rdma_link_layer {
	IB_LINK_LAYER_UNSPECIFIED = 0,
	IB_LINK_LAYER_INFINIBAND = 1,
	IB_LINK_LAYER_ETHERNET = 2,
};

enum rdma_netdev_t {
	RDMA_NETDEV_OPA_VNIC = 0,
	RDMA_NETDEV_IPOIB = 1,
};

enum rdma_nl_counter_mask {
	RDMA_COUNTER_MASK_QP_TYPE = 1,
	RDMA_COUNTER_MASK_PID = 2,
};

enum rdma_nl_counter_mode {
	RDMA_COUNTER_MODE_NONE = 0,
	RDMA_COUNTER_MODE_AUTO = 1,
	RDMA_COUNTER_MODE_MANUAL = 2,
	RDMA_COUNTER_MODE_MAX = 3,
};

enum rdma_nl_dev_type {
	RDMA_DEVICE_TYPE_SMI = 1,
};

enum rdma_nl_name_assign_type {
	RDMA_NAME_ASSIGN_TYPE_UNKNOWN = 0,
	RDMA_NAME_ASSIGN_TYPE_USER = 1,
};

enum rdma_restrack_type {
	RDMA_RESTRACK_PD = 0,
	RDMA_RESTRACK_CQ = 1,
	RDMA_RESTRACK_QP = 2,
	RDMA_RESTRACK_CM_ID = 3,
	RDMA_RESTRACK_MR = 4,
	RDMA_RESTRACK_CTX = 5,
	RDMA_RESTRACK_COUNTER = 6,
	RDMA_RESTRACK_SRQ = 7,
	RDMA_RESTRACK_MAX = 8,
};

enum rdmacg_file_type {
	RDMACG_RESOURCE_TYPE_MAX = 0,
	RDMACG_RESOURCE_TYPE_STAT = 1,
};

enum rdmacg_resource_type {
	RDMACG_RESOURCE_HCA_HANDLE = 0,
	RDMACG_RESOURCE_HCA_OBJECT = 1,
	RDMACG_RESOURCE_MAX = 2,
};

enum reboot_mode {
	REBOOT_UNDEFINED = -1,
	REBOOT_COLD = 0,
	REBOOT_WARM = 1,
	REBOOT_HARD = 2,
	REBOOT_SOFT = 3,
	REBOOT_GPIO = 4,
};

enum reboot_type {
	BOOT_TRIPLE = 116,
	BOOT_KBD = 107,
	BOOT_BIOS = 98,
	BOOT_ACPI = 97,
	BOOT_EFI = 101,
	BOOT_CF9_FORCE = 112,
	BOOT_CF9_SAFE = 113,
};

enum ref_state_type {
	REF_TYPE_PTR = 2,
	REF_TYPE_IRQ = 4,
	REF_TYPE_LOCK = 8,
	REF_TYPE_RES_LOCK = 16,
	REF_TYPE_RES_LOCK_IRQ = 32,
	REF_TYPE_LOCK_MASK = 56,
};

enum refcount_saturation_type {
	REFCOUNT_ADD_NOT_ZERO_OVF = 0,
	REFCOUNT_ADD_OVF = 1,
	REFCOUNT_ADD_UAF = 2,
	REFCOUNT_SUB_UAF = 3,
	REFCOUNT_DEC_LEAK = 4,
};

enum reg_arg_type {
	SRC_OP = 0,
	DST_OP = 1,
	DST_OP_NO_MARK = 2,
};

enum reg_idx {
	DSIM_STATUS_REG = 0,
	DSIM_SWRST_REG = 1,
	DSIM_CLKCTRL_REG = 2,
	DSIM_TIMEOUT_REG = 3,
	DSIM_CONFIG_REG = 4,
	DSIM_ESCMODE_REG = 5,
	DSIM_MDRESOL_REG = 6,
	DSIM_MVPORCH_REG = 7,
	DSIM_MHPORCH_REG = 8,
	DSIM_MSYNC_REG = 9,
	DSIM_INTSRC_REG = 10,
	DSIM_INTMSK_REG = 11,
	DSIM_PKTHDR_REG = 12,
	DSIM_PAYLOAD_REG = 13,
	DSIM_RXFIFO_REG = 14,
	DSIM_FIFOCTRL_REG = 15,
	DSIM_PLLCTRL_REG = 16,
	DSIM_PHYCTRL_REG = 17,
	DSIM_PHYTIMING_REG = 18,
	DSIM_PHYTIMING1_REG = 19,
	DSIM_PHYTIMING2_REG = 20,
	NUM_REGS = 21,
};

enum reg_value_idx {
	RESET_TYPE = 0,
	PLL_TIMER = 1,
	STOP_STATE_CNT = 2,
	PHYCTRL_ULPS_EXIT = 3,
	PHYCTRL_VREG_LP = 4,
	PHYCTRL_SLEW_UP = 5,
	PHYTIMING_LPX = 6,
	PHYTIMING_HS_EXIT = 7,
	PHYTIMING_CLK_PREPARE = 8,
	PHYTIMING_CLK_ZERO = 9,
	PHYTIMING_CLK_POST = 10,
	PHYTIMING_CLK_TRAIL = 11,
	PHYTIMING_HS_PREPARE = 12,
	PHYTIMING_HS_ZERO = 13,
	PHYTIMING_HS_TRAIL = 14,
};

enum regcache_type {
	REGCACHE_NONE = 0,
	REGCACHE_RBTREE = 1,
	REGCACHE_FLAT = 2,
	REGCACHE_MAPLE = 3,
};

enum regmap_endian {
	REGMAP_ENDIAN_DEFAULT = 0,
	REGMAP_ENDIAN_BIG = 1,
	REGMAP_ENDIAN_LITTLE = 2,
	REGMAP_ENDIAN_NATIVE = 3,
};

enum regs {
	FP = 11,
	SP = 13,
	LR = 14,
	PC = 15,
};

enum regulator_active_discharge {
	REGULATOR_ACTIVE_DISCHARGE_DEFAULT = 0,
	REGULATOR_ACTIVE_DISCHARGE_DISABLE = 1,
	REGULATOR_ACTIVE_DISCHARGE_ENABLE = 2,
};

enum regulator_detection_severity {
	REGULATOR_SEVERITY_PROT = 0,
	REGULATOR_SEVERITY_ERR = 1,
	REGULATOR_SEVERITY_WARN = 2,
};

enum regulator_get_type {
	NORMAL_GET = 0,
	EXCLUSIVE_GET = 1,
	OPTIONAL_GET = 2,
	MAX_GET_TYPE = 3,
};

enum regulator_status {
	REGULATOR_STATUS_OFF = 0,
	REGULATOR_STATUS_ON = 1,
	REGULATOR_STATUS_ERROR = 2,
	REGULATOR_STATUS_FAST = 3,
	REGULATOR_STATUS_NORMAL = 4,
	REGULATOR_STATUS_IDLE = 5,
	REGULATOR_STATUS_STANDBY = 6,
	REGULATOR_STATUS_BYPASS = 7,
	REGULATOR_STATUS_UNDEFINED = 8,
};

enum regulator_type {
	REGULATOR_VOLTAGE = 0,
	REGULATOR_CURRENT = 1,
};

enum release_type {
	leaf_only = 0,
	whole_subtree = 1,
};

enum reloc_stage {
	MOVE_DATA_EXTENTS = 0,
	UPDATE_DATA_PTRS = 1,
};

enum req_flag_bits {
	__REQ_FAILFAST_DEV = 8,
	__REQ_FAILFAST_TRANSPORT = 9,
	__REQ_FAILFAST_DRIVER = 10,
	__REQ_SYNC = 11,
	__REQ_META = 12,
	__REQ_PRIO = 13,
	__REQ_NOMERGE = 14,
	__REQ_IDLE = 15,
	__REQ_INTEGRITY = 16,
	__REQ_FUA = 17,
	__REQ_PREFLUSH = 18,
	__REQ_RAHEAD = 19,
	__REQ_BACKGROUND = 20,
	__REQ_NOWAIT = 21,
	__REQ_POLLED = 22,
	__REQ_ALLOC_CACHE = 23,
	__REQ_SWAP = 24,
	__REQ_DRV = 25,
	__REQ_FS_PRIVATE = 26,
	__REQ_ATOMIC = 27,
	__REQ_NOUNMAP = 28,
	__REQ_NR_BITS = 29,
};

enum req_op {
	REQ_OP_READ = 0,
	REQ_OP_WRITE = 1,
	REQ_OP_FLUSH = 2,
	REQ_OP_DISCARD = 3,
	REQ_OP_SECURE_ERASE = 5,
	REQ_OP_ZONE_APPEND = 7,
	REQ_OP_WRITE_ZEROES = 9,
	REQ_OP_ZONE_OPEN = 10,
	REQ_OP_ZONE_CLOSE = 11,
	REQ_OP_ZONE_FINISH = 13,
	REQ_OP_ZONE_RESET = 15,
	REQ_OP_ZONE_RESET_ALL = 17,
	REQ_OP_DRV_IN = 34,
	REQ_OP_DRV_OUT = 35,
	REQ_OP_LAST = 36,
};

enum resctrl_conf_type {
	CDP_NONE = 0,
	CDP_CODE = 1,
	CDP_DATA = 2,
};

enum reset_control_flags {
	RESET_CONTROL_EXCLUSIVE = 4,
	RESET_CONTROL_EXCLUSIVE_DEASSERTED = 12,
	RESET_CONTROL_EXCLUSIVE_RELEASED = 0,
	RESET_CONTROL_SHARED = 1,
	RESET_CONTROL_SHARED_DEASSERTED = 9,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE = 6,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_DEASSERTED = 14,
	RESET_CONTROL_OPTIONAL_EXCLUSIVE_RELEASED = 2,
	RESET_CONTROL_OPTIONAL_SHARED = 3,
	RESET_CONTROL_OPTIONAL_SHARED_DEASSERTED = 11,
};

enum resolve_mode {
	RESOLVE_TBD = 0,
	RESOLVE_PTR = 1,
	RESOLVE_STRUCT_OR_ARRAY = 2,
};

enum rk3036_plls {
	apll___5 = 0,
	dpll___2 = 1,
	gpll___2 = 2,
};

enum rk3128_plls {
	apll___6 = 0,
	dpll___3 = 1,
	cpll___4 = 2,
	gpll___3 = 3,
};

enum rk3188_plls {
	apll___7 = 0,
	cpll___5 = 1,
	dpll___4 = 2,
	gpll___4 = 3,
};

enum rk3228_plls {
	apll___8 = 0,
	dpll___5 = 1,
	cpll___6 = 2,
	gpll___5 = 3,
};

enum rk3288_plls {
	apll___9 = 0,
	dpll___6 = 1,
	cpll___7 = 2,
	gpll___6 = 3,
	npll = 4,
};

enum rk3288_pwr_mode_con {
	PMU_PWR_MODE_EN = 0,
	PMU_CLK_CORE_SRC_GATE_EN = 1,
	PMU_GLOBAL_INT_DISABLE = 2,
	PMU_L2FLUSH_EN = 3,
	PMU_BUS_PD_EN = 4,
	PMU_A12_0_PD_EN = 5,
	PMU_SCU_EN = 6,
	PMU_PLL_PD_EN = 7,
	PMU_CHIP_PD_EN = 8,
	PMU_PWROFF_COMB = 9,
	PMU_ALIVE_USE_LF = 10,
	PMU_PMU_USE_LF = 11,
	PMU_OSC_24M_DIS = 12,
	PMU_INPUT_CLAMP_EN = 13,
	PMU_WAKEUP_RESET_EN = 14,
	PMU_SREF0_ENTER_EN = 15,
	PMU_SREF1_ENTER_EN = 16,
	PMU_DDR0IO_RET_EN = 17,
	PMU_DDR1IO_RET_EN = 18,
	PMU_DDR0_GATING_EN = 19,
	PMU_DDR1_GATING_EN = 20,
	PMU_DDR0IO_RET_DE_REQ = 21,
	PMU_DDR1IO_RET_DE_REQ = 22,
};

enum rk3288_pwr_mode_con1 {
	PMU_CLR_BUS = 0,
	PMU_CLR_CORE = 1,
	PMU_CLR_CPUP = 2,
	PMU_CLR_ALIVE = 3,
	PMU_CLR_DMA = 4,
	PMU_CLR_PERI = 5,
	PMU_CLR_GPU = 6,
	PMU_CLR_VIDEO = 7,
	PMU_CLR_HEVC = 8,
	PMU_CLR_VIO = 9,
};

enum rk3288_variant {
	RK3288_CRU = 0,
	RK3288W_CRU = 1,
};

enum rk3x_i2c_state {
	STATE_IDLE___3 = 0,
	STATE_START = 1,
	STATE_READ___2 = 2,
	STATE_WRITE___2 = 3,
	STATE_STOP = 4,
};

enum rk805_pinmux_option {
	RK805_PINMUX_GPIO = 0,
};

enum rk805_reg {
	RK805_ID_DCDC1 = 0,
	RK805_ID_DCDC2 = 1,
	RK805_ID_DCDC3 = 2,
	RK805_ID_DCDC4 = 3,
	RK805_ID_LDO1 = 4,
	RK805_ID_LDO2 = 5,
	RK805_ID_LDO3 = 6,
};

enum rk806_irqs {
	RK806_IRQ_PWRON_FALL = 0,
	RK806_IRQ_PWRON_RISE = 1,
	RK806_IRQ_PWRON = 2,
	RK806_IRQ_PWRON_LP = 3,
	RK806_IRQ_HOTDIE = 4,
	RK806_IRQ_VDC_RISE = 5,
	RK806_IRQ_VDC_FALL = 6,
	RK806_IRQ_VB_LO = 7,
	RK806_IRQ_REV0 = 8,
	RK806_IRQ_REV1 = 9,
	RK806_IRQ_REV2 = 10,
	RK806_IRQ_CRC_ERROR = 11,
	RK806_IRQ_SLP3_GPIO = 12,
	RK806_IRQ_SLP2_GPIO = 13,
	RK806_IRQ_SLP1_GPIO = 14,
	RK806_IRQ_WDT = 15,
};

enum rk806_pinmux_option {
	RK806_PINMUX_FUN0 = 0,
	RK806_PINMUX_FUN1 = 1,
	RK806_PINMUX_FUN2 = 2,
	RK806_PINMUX_FUN3 = 3,
	RK806_PINMUX_FUN4 = 4,
	RK806_PINMUX_FUN5 = 5,
};

enum rk806_reg_id {
	RK806_ID_DCDC1 = 0,
	RK806_ID_DCDC2 = 1,
	RK806_ID_DCDC3 = 2,
	RK806_ID_DCDC4 = 3,
	RK806_ID_DCDC5 = 4,
	RK806_ID_DCDC6 = 5,
	RK806_ID_DCDC7 = 6,
	RK806_ID_DCDC8 = 7,
	RK806_ID_DCDC9 = 8,
	RK806_ID_DCDC10 = 9,
	RK806_ID_NLDO1 = 10,
	RK806_ID_NLDO2 = 11,
	RK806_ID_NLDO3 = 12,
	RK806_ID_NLDO4 = 13,
	RK806_ID_NLDO5 = 14,
	RK806_ID_PLDO1 = 15,
	RK806_ID_PLDO2 = 16,
	RK806_ID_PLDO3 = 17,
	RK806_ID_PLDO4 = 18,
	RK806_ID_PLDO5 = 19,
	RK806_ID_PLDO6 = 20,
	RK806_ID_END = 21,
};

enum rk808_reg {
	RK808_ID_DCDC1 = 0,
	RK808_ID_DCDC2 = 1,
	RK808_ID_DCDC3 = 2,
	RK808_ID_DCDC4 = 3,
	RK808_ID_LDO1 = 4,
	RK808_ID_LDO2 = 5,
	RK808_ID_LDO3 = 6,
	RK808_ID_LDO4 = 7,
	RK808_ID_LDO5 = 8,
	RK808_ID_LDO6 = 9,
	RK808_ID_LDO7 = 10,
	RK808_ID_LDO8 = 11,
	RK808_ID_SWITCH1 = 12,
	RK808_ID_SWITCH2 = 13,
};

enum rk809_reg_id {
	RK809_ID_DCDC5 = 13,
	RK809_ID_SW1 = 14,
	RK809_ID_SW2 = 15,
	RK809_NUM_REGULATORS = 16,
};

enum rk816_irqs {
	RK816_IRQ_PWRON_FALL = 0,
	RK816_IRQ_PWRON_RISE = 1,
	RK816_IRQ_VB_LOW = 2,
	RK816_IRQ_PWRON = 3,
	RK816_IRQ_PWRON_LP = 4,
	RK816_IRQ_HOTDIE = 5,
	RK816_IRQ_RTC_ALARM = 6,
	RK816_IRQ_RTC_PERIOD = 7,
	RK816_IRQ_USB_OV = 8,
	RK816_IRQ_PLUG_IN = 9,
	RK816_IRQ_PLUG_OUT = 10,
	RK816_IRQ_CHG_OK = 11,
	RK816_IRQ_CHG_TE = 12,
	RK816_IRQ_CHG_TS = 13,
	RK816_IRQ_CHG_CVTLIM = 14,
	RK816_IRQ_DISCHG_ILIM = 15,
};

enum rk816_pinmux_option {
	RK816_PINMUX_THERMISTOR = 0,
	RK816_PINMUX_GPIO = 1,
};

enum rk816_reg {
	RK816_ID_DCDC1 = 0,
	RK816_ID_DCDC2 = 1,
	RK816_ID_DCDC3 = 2,
	RK816_ID_DCDC4 = 3,
	RK816_ID_LDO1 = 4,
	RK816_ID_LDO2 = 5,
	RK816_ID_LDO3 = 6,
	RK816_ID_LDO4 = 7,
	RK816_ID_LDO5 = 8,
	RK816_ID_LDO6 = 9,
	RK816_ID_BOOST = 10,
	RK816_ID_OTG_SW = 11,
};

enum rk817_reg_id {
	RK817_ID_DCDC1 = 0,
	RK817_ID_DCDC2 = 1,
	RK817_ID_DCDC3 = 2,
	RK817_ID_DCDC4 = 3,
	RK817_ID_LDO1 = 4,
	RK817_ID_LDO2 = 5,
	RK817_ID_LDO3 = 6,
	RK817_ID_LDO4 = 7,
	RK817_ID_LDO5 = 8,
	RK817_ID_LDO6 = 9,
	RK817_ID_LDO7 = 10,
	RK817_ID_LDO8 = 11,
	RK817_ID_LDO9 = 12,
	RK817_ID_BOOST = 13,
	RK817_ID_BOOST_OTG_SW = 14,
	RK817_NUM_REGULATORS = 15,
};

enum rk818_reg {
	RK818_ID_DCDC1 = 0,
	RK818_ID_DCDC2 = 1,
	RK818_ID_DCDC3 = 2,
	RK818_ID_DCDC4 = 3,
	RK818_ID_BOOST = 4,
	RK818_ID_LDO1 = 5,
	RK818_ID_LDO2 = 6,
	RK818_ID_LDO3 = 7,
	RK818_ID_LDO4 = 8,
	RK818_ID_LDO5 = 9,
	RK818_ID_LDO6 = 10,
	RK818_ID_LDO7 = 11,
	RK818_ID_LDO8 = 12,
	RK818_ID_LDO9 = 13,
	RK818_ID_SWITCH = 14,
	RK818_ID_HDMI_SWITCH = 15,
	RK818_ID_OTG_SWITCH = 16,
};

enum rlimit_type {
	UCOUNT_RLIMIT_NPROC = 0,
	UCOUNT_RLIMIT_MSGQUEUE = 1,
	UCOUNT_RLIMIT_SIGPENDING = 2,
	UCOUNT_RLIMIT_MEMLOCK = 3,
	UCOUNT_RLIMIT_COUNTS = 4,
};

enum rmap_level {
	RMAP_LEVEL_PTE = 0,
	RMAP_LEVEL_PMD = 1,
	RMAP_LEVEL_PUD = 2,
};

enum rmp_flags {
	RMP_LOCKED = 1,
	RMP_USE_SHARED_ZEROPAGE = 2,
};

enum rmqueue_mode {
	RMQUEUE_NORMAL = 0,
	RMQUEUE_CMA = 1,
	RMQUEUE_CLAIM = 2,
	RMQUEUE_STEAL = 3,
};

enum rockchip_clk_branch_type {
	branch_composite = 0,
	branch_mux = 1,
	branch_grf_mux = 2,
	branch_divider = 3,
	branch_fraction_divider = 4,
	branch_gate = 5,
	branch_grf_gate = 6,
	branch_linked_gate = 7,
	branch_mmc = 8,
	branch_grf_mmc = 9,
	branch_inverter = 10,
	branch_factor = 11,
	branch_ddrclk = 12,
	branch_half_divider = 13,
};

enum rockchip_grf_type {
	grf_type_sys = 0,
	grf_type_pmu0 = 1,
	grf_type_pmu1 = 2,
	grf_type_ioc = 3,
	grf_type_vo = 4,
	grf_type_vpu = 5,
};

enum rockchip_mux_route_location {
	ROCKCHIP_ROUTE_SAME = 0,
	ROCKCHIP_ROUTE_PMU = 1,
	ROCKCHIP_ROUTE_GRF = 2,
};

enum rockchip_pin_drv_type {
	DRV_TYPE_IO_DEFAULT = 0,
	DRV_TYPE_IO_1V8_OR_3V0 = 1,
	DRV_TYPE_IO_1V8_ONLY = 2,
	DRV_TYPE_IO_1V8_3V0_AUTO = 3,
	DRV_TYPE_IO_3V3_ONLY = 4,
	DRV_TYPE_MAX = 5,
};

enum rockchip_pin_pull_type {
	PULL_TYPE_IO_DEFAULT = 0,
	PULL_TYPE_IO_1V8_ONLY = 1,
	PULL_TYPE_MAX = 2,
};

enum rockchip_pinctrl_type {
	PX30 = 0,
	RV1108 = 1,
	RV1126 = 2,
	RK2928 = 3,
	RK3066B = 4,
	RK3128 = 5,
	RK3188 = 6,
	RK3288 = 7,
	RK3308 = 8,
	RK3328 = 9,
	RK3368 = 10,
	RK3399 = 11,
	RK3528 = 12,
	RK3562 = 13,
	RK3568 = 14,
	RK3576 = 15,
	RK3588 = 16,
};

enum rockchip_pll_type {
	pll_rk3036 = 0,
	pll_rk3066 = 1,
	pll_rk3328 = 2,
	pll_rk3399 = 3,
	pll_rk3588 = 4,
	pll_rk3588_core = 5,
	pll_rk3588_ddr = 6,
};

enum rockchip_usb2phy_host_state {
	PHY_STATE_HS_ONLINE = 0,
	PHY_STATE_DISCONNECT = 1,
	PHY_STATE_CONNECT = 2,
	PHY_STATE_FS_LS_ONLINE = 4,
};

enum rockchip_usb2phy_port_id {
	USB2PHY_PORT_OTG = 0,
	USB2PHY_PORT_HOST = 1,
	USB2PHY_NUM_PORTS = 2,
};

enum rpc_accept_stat {
	RPC_SUCCESS = 0,
	RPC_PROG_UNAVAIL = 1,
	RPC_PROG_MISMATCH = 2,
	RPC_PROC_UNAVAIL = 3,
	RPC_GARBAGE_ARGS = 4,
	RPC_SYSTEM_ERR = 5,
	RPC_DROP_REPLY = 60000,
};

enum rpc_auth_flavors {
	RPC_AUTH_NULL = 0,
	RPC_AUTH_UNIX = 1,
	RPC_AUTH_SHORT = 2,
	RPC_AUTH_DES = 3,
	RPC_AUTH_KRB = 4,
	RPC_AUTH_GSS = 6,
	RPC_AUTH_TLS = 7,
	RPC_AUTH_MAXFLAVOR = 8,
	RPC_AUTH_GSS_KRB5 = 390003,
	RPC_AUTH_GSS_KRB5I = 390004,
	RPC_AUTH_GSS_KRB5P = 390005,
	RPC_AUTH_GSS_LKEY = 390006,
	RPC_AUTH_GSS_LKEYI = 390007,
	RPC_AUTH_GSS_LKEYP = 390008,
	RPC_AUTH_GSS_SPKM = 390009,
	RPC_AUTH_GSS_SPKMI = 390010,
	RPC_AUTH_GSS_SPKMP = 390011,
};

enum rpc_auth_stat {
	RPC_AUTH_OK = 0,
	RPC_AUTH_BADCRED = 1,
	RPC_AUTH_REJECTEDCRED = 2,
	RPC_AUTH_BADVERF = 3,
	RPC_AUTH_REJECTEDVERF = 4,
	RPC_AUTH_TOOWEAK = 5,
	RPCSEC_GSS_CREDPROBLEM = 13,
	RPCSEC_GSS_CTXPROBLEM = 14,
};

enum rpc_display_format_t {
	RPC_DISPLAY_ADDR = 0,
	RPC_DISPLAY_PORT = 1,
	RPC_DISPLAY_PROTO = 2,
	RPC_DISPLAY_HEX_ADDR = 3,
	RPC_DISPLAY_HEX_PORT = 4,
	RPC_DISPLAY_NETID = 5,
	RPC_DISPLAY_MAX = 6,
};

enum rpc_msg_type {
	RPC_CALL = 0,
	RPC_REPLY = 1,
};

enum rpc_reject_stat {
	RPC_MISMATCH = 0,
	RPC_AUTH_ERROR = 1,
};

enum rpc_reply_stat {
	RPC_MSG_ACCEPTED = 0,
	RPC_MSG_DENIED = 1,
};

enum rpi_firmware_clk_id {
	RPI_FIRMWARE_EMMC_CLK_ID = 1,
	RPI_FIRMWARE_UART_CLK_ID = 2,
	RPI_FIRMWARE_ARM_CLK_ID = 3,
	RPI_FIRMWARE_CORE_CLK_ID = 4,
	RPI_FIRMWARE_V3D_CLK_ID = 5,
	RPI_FIRMWARE_H264_CLK_ID = 6,
	RPI_FIRMWARE_ISP_CLK_ID = 7,
	RPI_FIRMWARE_SDRAM_CLK_ID = 8,
	RPI_FIRMWARE_PIXEL_CLK_ID = 9,
	RPI_FIRMWARE_PWM_CLK_ID = 10,
	RPI_FIRMWARE_HEVC_CLK_ID = 11,
	RPI_FIRMWARE_EMMC2_CLK_ID = 12,
	RPI_FIRMWARE_M2MC_CLK_ID = 13,
	RPI_FIRMWARE_PIXEL_BVB_CLK_ID = 14,
	RPI_FIRMWARE_VEC_CLK_ID = 15,
	RPI_FIRMWARE_DISP_CLK_ID = 16,
	RPI_FIRMWARE_NUM_CLK_ID = 17,
};

enum rpi_firmware_property_status {
	RPI_FIRMWARE_STATUS_REQUEST = 0,
	RPI_FIRMWARE_STATUS_SUCCESS = 2147483648,
	RPI_FIRMWARE_STATUS_ERROR = 2147483649,
};

enum rpi_firmware_property_tag {
	RPI_FIRMWARE_PROPERTY_END = 0,
	RPI_FIRMWARE_GET_FIRMWARE_REVISION = 1,
	RPI_FIRMWARE_SET_CURSOR_INFO = 32784,
	RPI_FIRMWARE_SET_CURSOR_STATE = 32785,
	RPI_FIRMWARE_GET_BOARD_MODEL = 65537,
	RPI_FIRMWARE_GET_BOARD_REVISION = 65538,
	RPI_FIRMWARE_GET_BOARD_MAC_ADDRESS = 65539,
	RPI_FIRMWARE_GET_BOARD_SERIAL = 65540,
	RPI_FIRMWARE_GET_ARM_MEMORY = 65541,
	RPI_FIRMWARE_GET_VC_MEMORY = 65542,
	RPI_FIRMWARE_GET_CLOCKS = 65543,
	RPI_FIRMWARE_GET_POWER_STATE = 131073,
	RPI_FIRMWARE_GET_TIMING = 131074,
	RPI_FIRMWARE_SET_POWER_STATE = 163841,
	RPI_FIRMWARE_GET_CLOCK_STATE = 196609,
	RPI_FIRMWARE_GET_CLOCK_RATE = 196610,
	RPI_FIRMWARE_GET_VOLTAGE = 196611,
	RPI_FIRMWARE_GET_MAX_CLOCK_RATE = 196612,
	RPI_FIRMWARE_GET_MAX_VOLTAGE = 196613,
	RPI_FIRMWARE_GET_TEMPERATURE = 196614,
	RPI_FIRMWARE_GET_MIN_CLOCK_RATE = 196615,
	RPI_FIRMWARE_GET_MIN_VOLTAGE = 196616,
	RPI_FIRMWARE_GET_TURBO = 196617,
	RPI_FIRMWARE_GET_MAX_TEMPERATURE = 196618,
	RPI_FIRMWARE_GET_STC = 196619,
	RPI_FIRMWARE_ALLOCATE_MEMORY = 196620,
	RPI_FIRMWARE_LOCK_MEMORY = 196621,
	RPI_FIRMWARE_UNLOCK_MEMORY = 196622,
	RPI_FIRMWARE_RELEASE_MEMORY = 196623,
	RPI_FIRMWARE_EXECUTE_CODE = 196624,
	RPI_FIRMWARE_EXECUTE_QPU = 196625,
	RPI_FIRMWARE_SET_ENABLE_QPU = 196626,
	RPI_FIRMWARE_GET_DISPMANX_RESOURCE_MEM_HANDLE = 196628,
	RPI_FIRMWARE_GET_EDID_BLOCK = 196640,
	RPI_FIRMWARE_GET_CUSTOMER_OTP = 196641,
	RPI_FIRMWARE_GET_DOMAIN_STATE = 196656,
	RPI_FIRMWARE_GET_THROTTLED = 196678,
	RPI_FIRMWARE_GET_CLOCK_MEASURED = 196679,
	RPI_FIRMWARE_NOTIFY_REBOOT = 196680,
	RPI_FIRMWARE_SET_CLOCK_STATE = 229377,
	RPI_FIRMWARE_SET_CLOCK_RATE = 229378,
	RPI_FIRMWARE_SET_VOLTAGE = 229379,
	RPI_FIRMWARE_SET_TURBO = 229385,
	RPI_FIRMWARE_SET_CUSTOMER_OTP = 229409,
	RPI_FIRMWARE_SET_DOMAIN_STATE = 229424,
	RPI_FIRMWARE_GET_GPIO_STATE = 196673,
	RPI_FIRMWARE_SET_GPIO_STATE = 229441,
	RPI_FIRMWARE_SET_SDHOST_CLOCK = 229442,
	RPI_FIRMWARE_GET_GPIO_CONFIG = 196675,
	RPI_FIRMWARE_SET_GPIO_CONFIG = 229443,
	RPI_FIRMWARE_GET_PERIPH_REG = 196677,
	RPI_FIRMWARE_SET_PERIPH_REG = 229445,
	RPI_FIRMWARE_GET_POE_HAT_VAL = 196681,
	RPI_FIRMWARE_SET_POE_HAT_VAL = 196688,
	RPI_FIRMWARE_NOTIFY_XHCI_RESET = 196696,
	RPI_FIRMWARE_NOTIFY_DISPLAY_DONE = 196710,
	RPI_FIRMWARE_FRAMEBUFFER_ALLOCATE = 262145,
	RPI_FIRMWARE_FRAMEBUFFER_BLANK = 262146,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PHYSICAL_WIDTH_HEIGHT = 262147,
	RPI_FIRMWARE_FRAMEBUFFER_GET_VIRTUAL_WIDTH_HEIGHT = 262148,
	RPI_FIRMWARE_FRAMEBUFFER_GET_DEPTH = 262149,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PIXEL_ORDER = 262150,
	RPI_FIRMWARE_FRAMEBUFFER_GET_ALPHA_MODE = 262151,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PITCH = 262152,
	RPI_FIRMWARE_FRAMEBUFFER_GET_VIRTUAL_OFFSET = 262153,
	RPI_FIRMWARE_FRAMEBUFFER_GET_OVERSCAN = 262154,
	RPI_FIRMWARE_FRAMEBUFFER_GET_PALETTE = 262155,
	RPI_FIRMWARE_FRAMEBUFFER_GET_TOUCHBUF = 262159,
	RPI_FIRMWARE_FRAMEBUFFER_GET_GPIOVIRTBUF = 262160,
	RPI_FIRMWARE_FRAMEBUFFER_RELEASE = 294913,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PHYSICAL_WIDTH_HEIGHT = 278531,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VIRTUAL_WIDTH_HEIGHT = 278532,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_DEPTH = 278533,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PIXEL_ORDER = 278534,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_ALPHA_MODE = 278535,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VIRTUAL_OFFSET = 278537,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_OVERSCAN = 278538,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_PALETTE = 278539,
	RPI_FIRMWARE_FRAMEBUFFER_TEST_VSYNC = 278542,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PHYSICAL_WIDTH_HEIGHT = 294915,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VIRTUAL_WIDTH_HEIGHT = 294916,
	RPI_FIRMWARE_FRAMEBUFFER_SET_DEPTH = 294917,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PIXEL_ORDER = 294918,
	RPI_FIRMWARE_FRAMEBUFFER_SET_ALPHA_MODE = 294919,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VIRTUAL_OFFSET = 294921,
	RPI_FIRMWARE_FRAMEBUFFER_SET_OVERSCAN = 294922,
	RPI_FIRMWARE_FRAMEBUFFER_SET_PALETTE = 294923,
	RPI_FIRMWARE_FRAMEBUFFER_SET_TOUCHBUF = 294943,
	RPI_FIRMWARE_FRAMEBUFFER_SET_GPIOVIRTBUF = 294944,
	RPI_FIRMWARE_FRAMEBUFFER_SET_VSYNC = 294926,
	RPI_FIRMWARE_FRAMEBUFFER_SET_BACKLIGHT = 294927,
	RPI_FIRMWARE_VCHIQ_INIT = 294928,
	RPI_FIRMWARE_GET_COMMAND_LINE = 327681,
	RPI_FIRMWARE_GET_DMA_CHANNELS = 393217,
};

enum rpm_request {
	RPM_REQ_NONE = 0,
	RPM_REQ_IDLE = 1,
	RPM_REQ_SUSPEND = 2,
	RPM_REQ_AUTOSUSPEND = 3,
	RPM_REQ_RESUME = 4,
};

enum rpm_status {
	RPM_INVALID = -1,
	RPM_ACTIVE = 0,
	RPM_RESUMING = 1,
	RPM_SUSPENDED = 2,
	RPM_SUSPENDING = 3,
	RPM_BLOCKED = 4,
};

enum rpmb_type {
	RPMB_TYPE_EMMC = 0,
	RPMB_TYPE_UFS = 1,
	RPMB_TYPE_NVME = 2,
};

enum rproc_crash_type {
	RPROC_MMUFAULT = 0,
	RPROC_WATCHDOG = 1,
	RPROC_FATAL_ERROR = 2,
};

enum rproc_dump_mechanism {
	RPROC_COREDUMP_DISABLED = 0,
	RPROC_COREDUMP_ENABLED = 1,
	RPROC_COREDUMP_INLINE = 2,
};

enum rproc_features {
	RPROC_FEAT_ATTACH_ON_RECOVERY = 0,
	RPROC_MAX_FEATURES = 1,
};

enum rproc_state {
	RPROC_OFFLINE = 0,
	RPROC_SUSPENDED = 1,
	RPROC_RUNNING = 2,
	RPROC_CRASHED = 3,
	RPROC_DELETED = 4,
	RPROC_ATTACHED = 5,
	RPROC_DETACHED = 6,
	RPROC_LAST = 7,
};

enum rq_end_io_ret {
	RQ_END_IO_NONE = 0,
	RQ_END_IO_FREE = 1,
};

enum rq_qos_id {
	RQ_QOS_WBT = 0,
	RQ_QOS_LATENCY = 1,
	RQ_QOS_COST = 2,
};

enum rqf_flags {
	__RQF_STARTED = 0,
	__RQF_FLUSH_SEQ = 1,
	__RQF_MIXED_MERGE = 2,
	__RQF_DONTPREP = 3,
	__RQF_SCHED_TAGS = 4,
	__RQF_USE_SCHED = 5,
	__RQF_FAILED = 6,
	__RQF_QUIET = 7,
	__RQF_IO_STAT = 8,
	__RQF_PM = 9,
	__RQF_HASHED = 10,
	__RQF_STATS = 11,
	__RQF_SPECIAL_PAYLOAD = 12,
	__RQF_ZONE_WRITE_PLUGGING = 13,
	__RQF_TIMED_OUT = 14,
	__RQF_RESV = 15,
	__RQF_BITS = 16,
};

enum rsaprivkey_actions {
	ACT_rsa_get_d = 0,
	ACT_rsa_get_dp = 1,
	ACT_rsa_get_dq = 2,
	ACT_rsa_get_e = 3,
	ACT_rsa_get_n = 4,
	ACT_rsa_get_p = 5,
	ACT_rsa_get_q = 6,
	ACT_rsa_get_qinv = 7,
	NR__rsaprivkey_actions = 8,
};

enum rsapubkey_actions {
	ACT_rsa_get_e___2 = 0,
	ACT_rsa_get_n___2 = 1,
	NR__rsapubkey_actions = 2,
};

enum rsc_handling_status {
	RSC_HANDLED = 0,
	RSC_IGNORED = 1,
};

enum rseq_cpu_id_state {
	RSEQ_CPU_ID_UNINITIALIZED = -1,
	RSEQ_CPU_ID_REGISTRATION_FAILED = -2,
};

enum rseq_cs_flags {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL = 2,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE = 4,
};

enum rseq_cs_flags_bit {
	RSEQ_CS_FLAG_NO_RESTART_ON_PREEMPT_BIT = 0,
	RSEQ_CS_FLAG_NO_RESTART_ON_SIGNAL_BIT = 1,
	RSEQ_CS_FLAG_NO_RESTART_ON_MIGRATE_BIT = 2,
};

enum rseq_event_mask_bits {
	RSEQ_EVENT_PREEMPT_BIT = 0,
	RSEQ_EVENT_SIGNAL_BIT = 1,
	RSEQ_EVENT_MIGRATE_BIT = 2,
};

enum rseq_flags {
	RSEQ_FLAG_UNREGISTER = 1,
};

enum rt6_nud_state {
	RT6_NUD_FAIL_HARD = -3,
	RT6_NUD_FAIL_PROBE = -2,
	RT6_NUD_FAIL_DO_RR = -1,
	RT6_NUD_SUCCEED = 1,
};

enum rt_class_t {
	RT_TABLE_UNSPEC = 0,
	RT_TABLE_COMPAT = 252,
	RT_TABLE_DEFAULT = 253,
	RT_TABLE_MAIN = 254,
	RT_TABLE_LOCAL = 255,
	RT_TABLE_MAX = 4294967295,
};

enum rt_scope_t {
	RT_SCOPE_UNIVERSE = 0,
	RT_SCOPE_SITE = 200,
	RT_SCOPE_LINK = 253,
	RT_SCOPE_HOST = 254,
	RT_SCOPE_NOWHERE = 255,
};

enum rtattr_type_t {
	RTA_UNSPEC = 0,
	RTA_DST = 1,
	RTA_SRC = 2,
	RTA_IIF = 3,
	RTA_OIF = 4,
	RTA_GATEWAY = 5,
	RTA_PRIORITY = 6,
	RTA_PREFSRC = 7,
	RTA_METRICS = 8,
	RTA_MULTIPATH = 9,
	RTA_PROTOINFO = 10,
	RTA_FLOW = 11,
	RTA_CACHEINFO = 12,
	RTA_SESSION = 13,
	RTA_MP_ALGO = 14,
	RTA_TABLE = 15,
	RTA_MARK = 16,
	RTA_MFC_STATS = 17,
	RTA_VIA = 18,
	RTA_NEWDST = 19,
	RTA_PREF = 20,
	RTA_ENCAP_TYPE = 21,
	RTA_ENCAP = 22,
	RTA_EXPIRES = 23,
	RTA_PAD = 24,
	RTA_UID = 25,
	RTA_TTL_PROPAGATE = 26,
	RTA_IP_PROTO = 27,
	RTA_SPORT = 28,
	RTA_DPORT = 29,
	RTA_NH_ID = 30,
	RTA_FLOWLABEL = 31,
	__RTA_MAX = 32,
};

enum rtmutex_chainwalk {
	RT_MUTEX_MIN_CHAINWALK = 0,
	RT_MUTEX_FULL_CHAINWALK = 1,
};

enum rtnetlink_groups {
	RTNLGRP_NONE = 0,
	RTNLGRP_LINK = 1,
	RTNLGRP_NOTIFY = 2,
	RTNLGRP_NEIGH = 3,
	RTNLGRP_TC = 4,
	RTNLGRP_IPV4_IFADDR = 5,
	RTNLGRP_IPV4_MROUTE = 6,
	RTNLGRP_IPV4_ROUTE = 7,
	RTNLGRP_IPV4_RULE = 8,
	RTNLGRP_IPV6_IFADDR = 9,
	RTNLGRP_IPV6_MROUTE = 10,
	RTNLGRP_IPV6_ROUTE = 11,
	RTNLGRP_IPV6_IFINFO = 12,
	RTNLGRP_DECnet_IFADDR = 13,
	RTNLGRP_NOP2 = 14,
	RTNLGRP_DECnet_ROUTE = 15,
	RTNLGRP_DECnet_RULE = 16,
	RTNLGRP_NOP4 = 17,
	RTNLGRP_IPV6_PREFIX = 18,
	RTNLGRP_IPV6_RULE = 19,
	RTNLGRP_ND_USEROPT = 20,
	RTNLGRP_PHONET_IFADDR = 21,
	RTNLGRP_PHONET_ROUTE = 22,
	RTNLGRP_DCB = 23,
	RTNLGRP_IPV4_NETCONF = 24,
	RTNLGRP_IPV6_NETCONF = 25,
	RTNLGRP_MDB = 26,
	RTNLGRP_MPLS_ROUTE = 27,
	RTNLGRP_NSID = 28,
	RTNLGRP_MPLS_NETCONF = 29,
	RTNLGRP_IPV4_MROUTE_R = 30,
	RTNLGRP_IPV6_MROUTE_R = 31,
	RTNLGRP_NEXTHOP = 32,
	RTNLGRP_BRVLAN = 33,
	RTNLGRP_MCTP_IFADDR = 34,
	RTNLGRP_TUNNEL = 35,
	RTNLGRP_STATS = 36,
	RTNLGRP_IPV4_MCADDR = 37,
	RTNLGRP_IPV6_MCADDR = 38,
	RTNLGRP_IPV6_ACADDR = 39,
	__RTNLGRP_MAX = 40,
};

enum rtnl_kinds {
	RTNL_KIND_NEW = 0,
	RTNL_KIND_DEL = 1,
	RTNL_KIND_GET = 2,
	RTNL_KIND_SET = 3,
};

enum rtnl_link_flags {
	RTNL_FLAG_DOIT_UNLOCKED = 1,
	RTNL_FLAG_BULK_DEL_SUPPORTED = 2,
	RTNL_FLAG_DUMP_UNLOCKED = 4,
	RTNL_FLAG_DUMP_SPLIT_NLM_DONE = 8,
};

enum rv1108_plls {
	apll___10 = 0,
	dpll___7 = 1,
	gpll___7 = 2,
};

enum rv1126_plls {
	apll___11 = 0,
	dpll___8 = 1,
	cpll___8 = 2,
	hpll = 3,
};

enum rv1126_pmu_plls {
	gpll___8 = 0,
};

enum rw_hint {
	WRITE_LIFE_NOT_SET = 0,
	WRITE_LIFE_NONE = 1,
	WRITE_LIFE_SHORT = 2,
	WRITE_LIFE_MEDIUM = 3,
	WRITE_LIFE_LONG = 4,
	WRITE_LIFE_EXTREME = 5,
} __attribute__((mode(byte)));

enum rwsem_waiter_type {
	RWSEM_WAITING_FOR_WRITE = 0,
	RWSEM_WAITING_FOR_READ = 1,
};

enum rwsem_wake_type {
	RWSEM_WAKE_ANY = 0,
	RWSEM_WAKE_READERS = 1,
	RWSEM_WAKE_READ_OWNED = 2,
};

enum rwsig_action {
	RWSIG_ACTION_ABORT = 0,
	RWSIG_ACTION_CONTINUE = 1,
};

enum rx_handler_result {
	RX_HANDLER_CONSUMED = 0,
	RX_HANDLER_ANOTHER = 1,
	RX_HANDLER_EXACT = 2,
	RX_HANDLER_PASS = 3,
};

typedef enum rx_handler_result rx_handler_result_t;

enum s2idle_states {
	S2IDLE_STATE_NONE = 0,
	S2IDLE_STATE_ENTER = 1,
	S2IDLE_STATE_WAKE = 2,
};

enum s2mpa01_reg {
	S2MPA01_REG_ID = 0,
	S2MPA01_REG_INT1 = 1,
	S2MPA01_REG_INT2 = 2,
	S2MPA01_REG_INT3 = 3,
	S2MPA01_REG_INT1M = 4,
	S2MPA01_REG_INT2M = 5,
	S2MPA01_REG_INT3M = 6,
	S2MPA01_REG_ST1 = 7,
	S2MPA01_REG_ST2 = 8,
	S2MPA01_REG_PWRONSRC = 9,
	S2MPA01_REG_OFFSRC = 10,
	S2MPA01_REG_RTC_BUF = 11,
	S2MPA01_REG_CTRL1 = 12,
	S2MPA01_REG_ETC_TEST = 13,
	S2MPA01_REG_RSVD1 = 14,
	S2MPA01_REG_BU_CHG = 15,
	S2MPA01_REG_RAMP1 = 16,
	S2MPA01_REG_RAMP2 = 17,
	S2MPA01_REG_LDO_DSCH1 = 18,
	S2MPA01_REG_LDO_DSCH2 = 19,
	S2MPA01_REG_LDO_DSCH3 = 20,
	S2MPA01_REG_LDO_DSCH4 = 21,
	S2MPA01_REG_OTP_ADRL = 22,
	S2MPA01_REG_OTP_ADRH = 23,
	S2MPA01_REG_OTP_DATA = 24,
	S2MPA01_REG_MON1SEL = 25,
	S2MPA01_REG_MON2SEL = 26,
	S2MPA01_REG_LEE = 27,
	S2MPA01_REG_RSVD2 = 28,
	S2MPA01_REG_RSVD3 = 29,
	S2MPA01_REG_RSVD4 = 30,
	S2MPA01_REG_RSVD5 = 31,
	S2MPA01_REG_RSVD6 = 32,
	S2MPA01_REG_TOP_RSVD = 33,
	S2MPA01_REG_DVS_SEL = 34,
	S2MPA01_REG_DVS_PTR = 35,
	S2MPA01_REG_DVS_DATA = 36,
	S2MPA01_REG_RSVD_NO = 37,
	S2MPA01_REG_UVLO = 38,
	S2MPA01_REG_LEE_NO = 39,
	S2MPA01_REG_B1CTRL1 = 40,
	S2MPA01_REG_B1CTRL2 = 41,
	S2MPA01_REG_B2CTRL1 = 42,
	S2MPA01_REG_B2CTRL2 = 43,
	S2MPA01_REG_B3CTRL1 = 44,
	S2MPA01_REG_B3CTRL2 = 45,
	S2MPA01_REG_B4CTRL1 = 46,
	S2MPA01_REG_B4CTRL2 = 47,
	S2MPA01_REG_B5CTRL1 = 48,
	S2MPA01_REG_B5CTRL2 = 49,
	S2MPA01_REG_B5CTRL3 = 50,
	S2MPA01_REG_B5CTRL4 = 51,
	S2MPA01_REG_B5CTRL5 = 52,
	S2MPA01_REG_B5CTRL6 = 53,
	S2MPA01_REG_B6CTRL1 = 54,
	S2MPA01_REG_B6CTRL2 = 55,
	S2MPA01_REG_B7CTRL1 = 56,
	S2MPA01_REG_B7CTRL2 = 57,
	S2MPA01_REG_B8CTRL1 = 58,
	S2MPA01_REG_B8CTRL2 = 59,
	S2MPA01_REG_B9CTRL1 = 60,
	S2MPA01_REG_B9CTRL2 = 61,
	S2MPA01_REG_B10CTRL1 = 62,
	S2MPA01_REG_B10CTRL2 = 63,
	S2MPA01_REG_L1CTRL = 64,
	S2MPA01_REG_L2CTRL = 65,
	S2MPA01_REG_L3CTRL = 66,
	S2MPA01_REG_L4CTRL = 67,
	S2MPA01_REG_L5CTRL = 68,
	S2MPA01_REG_L6CTRL = 69,
	S2MPA01_REG_L7CTRL = 70,
	S2MPA01_REG_L8CTRL = 71,
	S2MPA01_REG_L9CTRL = 72,
	S2MPA01_REG_L10CTRL = 73,
	S2MPA01_REG_L11CTRL = 74,
	S2MPA01_REG_L12CTRL = 75,
	S2MPA01_REG_L13CTRL = 76,
	S2MPA01_REG_L14CTRL = 77,
	S2MPA01_REG_L15CTRL = 78,
	S2MPA01_REG_L16CTRL = 79,
	S2MPA01_REG_L17CTRL = 80,
	S2MPA01_REG_L18CTRL = 81,
	S2MPA01_REG_L19CTRL = 82,
	S2MPA01_REG_L20CTRL = 83,
	S2MPA01_REG_L21CTRL = 84,
	S2MPA01_REG_L22CTRL = 85,
	S2MPA01_REG_L23CTRL = 86,
	S2MPA01_REG_L24CTRL = 87,
	S2MPA01_REG_L25CTRL = 88,
	S2MPA01_REG_L26CTRL = 89,
	S2MPA01_REG_LDO_OVCB1 = 90,
	S2MPA01_REG_LDO_OVCB2 = 91,
	S2MPA01_REG_LDO_OVCB3 = 92,
	S2MPA01_REG_LDO_OVCB4 = 93,
};

enum s2mpa01_regulators {
	S2MPA01_LDO1 = 0,
	S2MPA01_LDO2 = 1,
	S2MPA01_LDO3 = 2,
	S2MPA01_LDO4 = 3,
	S2MPA01_LDO5 = 4,
	S2MPA01_LDO6 = 5,
	S2MPA01_LDO7 = 6,
	S2MPA01_LDO8 = 7,
	S2MPA01_LDO9 = 8,
	S2MPA01_LDO10 = 9,
	S2MPA01_LDO11 = 10,
	S2MPA01_LDO12 = 11,
	S2MPA01_LDO13 = 12,
	S2MPA01_LDO14 = 13,
	S2MPA01_LDO15 = 14,
	S2MPA01_LDO16 = 15,
	S2MPA01_LDO17 = 16,
	S2MPA01_LDO18 = 17,
	S2MPA01_LDO19 = 18,
	S2MPA01_LDO20 = 19,
	S2MPA01_LDO21 = 20,
	S2MPA01_LDO22 = 21,
	S2MPA01_LDO23 = 22,
	S2MPA01_LDO24 = 23,
	S2MPA01_LDO25 = 24,
	S2MPA01_LDO26 = 25,
	S2MPA01_BUCK1 = 26,
	S2MPA01_BUCK2 = 27,
	S2MPA01_BUCK3 = 28,
	S2MPA01_BUCK4 = 29,
	S2MPA01_BUCK5 = 30,
	S2MPA01_BUCK6 = 31,
	S2MPA01_BUCK7 = 32,
	S2MPA01_BUCK8 = 33,
	S2MPA01_BUCK9 = 34,
	S2MPA01_BUCK10 = 35,
	S2MPA01_REGULATOR_MAX = 36,
};

enum s2mpg10_irq {
	S2MPG10_IRQ_PWRONF = 0,
	S2MPG10_IRQ_PWRONR = 1,
	S2MPG10_IRQ_JIGONBF = 2,
	S2MPG10_IRQ_JIGONBR = 3,
	S2MPG10_IRQ_ACOKBF = 4,
	S2MPG10_IRQ_ACOKBR = 5,
	S2MPG10_IRQ_PWRON1S = 6,
	S2MPG10_IRQ_MRB = 7,
	S2MPG10_IRQ_RTC60S = 8,
	S2MPG10_IRQ_RTCA1 = 9,
	S2MPG10_IRQ_RTCA0 = 10,
	S2MPG10_IRQ_RTC1S = 11,
	S2MPG10_IRQ_WTSR_COLDRST = 12,
	S2MPG10_IRQ_WTSR = 13,
	S2MPG10_IRQ_WRST = 14,
	S2MPG10_IRQ_SMPL = 15,
	S2MPG10_IRQ_120C = 16,
	S2MPG10_IRQ_140C = 17,
	S2MPG10_IRQ_TSD = 18,
	S2MPG10_IRQ_PIF_TIMEOUT1 = 19,
	S2MPG10_IRQ_PIF_TIMEOUT2 = 20,
	S2MPG10_IRQ_SPD_PARITY_ERR = 21,
	S2MPG10_IRQ_SPD_ABNORMAL_STOP = 22,
	S2MPG10_IRQ_PMETER_OVERF = 23,
	S2MPG10_IRQ_OCP_B1M = 24,
	S2MPG10_IRQ_OCP_B2M = 25,
	S2MPG10_IRQ_OCP_B3M = 26,
	S2MPG10_IRQ_OCP_B4M = 27,
	S2MPG10_IRQ_OCP_B5M = 28,
	S2MPG10_IRQ_OCP_B6M = 29,
	S2MPG10_IRQ_OCP_B7M = 30,
	S2MPG10_IRQ_OCP_B8M = 31,
	S2MPG10_IRQ_OCP_B9M = 32,
	S2MPG10_IRQ_OCP_B10M = 33,
	S2MPG10_IRQ_WLWP_ACC = 34,
	S2MPG10_IRQ_SMPL_TIMEOUT = 35,
	S2MPG10_IRQ_WTSR_TIMEOUT = 36,
	S2MPG10_IRQ_SPD_SRP_PKT_RST = 37,
	S2MPG10_IRQ_PWR_WARN_CH0 = 38,
	S2MPG10_IRQ_PWR_WARN_CH1 = 39,
	S2MPG10_IRQ_PWR_WARN_CH2 = 40,
	S2MPG10_IRQ_PWR_WARN_CH3 = 41,
	S2MPG10_IRQ_PWR_WARN_CH4 = 42,
	S2MPG10_IRQ_PWR_WARN_CH5 = 43,
	S2MPG10_IRQ_PWR_WARN_CH6 = 44,
	S2MPG10_IRQ_PWR_WARN_CH7 = 45,
	S2MPG10_IRQ_NR = 46,
};

enum s2mpg10_pmic_reg {
	S2MPG10_PMIC_INT1 = 0,
	S2MPG10_PMIC_INT2 = 1,
	S2MPG10_PMIC_INT3 = 2,
	S2MPG10_PMIC_INT4 = 3,
	S2MPG10_PMIC_INT5 = 4,
	S2MPG10_PMIC_INT6 = 5,
	S2MPG10_PMIC_INT1M = 6,
	S2MPG10_PMIC_INT2M = 7,
	S2MPG10_PMIC_INT3M = 8,
	S2MPG10_PMIC_INT4M = 9,
	S2MPG10_PMIC_INT5M = 10,
	S2MPG10_PMIC_INT6M = 11,
	S2MPG10_PMIC_STATUS1 = 12,
	S2MPG10_PMIC_STATUS2 = 13,
	S2MPG10_PMIC_PWRONSRC = 14,
	S2MPG10_PMIC_OFFSRC = 15,
	S2MPG10_PMIC_BU_CHG = 16,
	S2MPG10_PMIC_RTCBUF = 17,
	S2MPG10_PMIC_COMMON_CTRL1 = 18,
	S2MPG10_PMIC_COMMON_CTRL2 = 19,
	S2MPG10_PMIC_COMMON_CTRL3 = 20,
	S2MPG10_PMIC_COMMON_CTRL4 = 21,
	S2MPG10_PMIC_SMPL_WARN_CTRL = 22,
	S2MPG10_PMIC_MIMICKING_CTRL = 23,
	S2MPG10_PMIC_B1M_CTRL = 24,
	S2MPG10_PMIC_B1M_OUT1 = 25,
	S2MPG10_PMIC_B1M_OUT2 = 26,
	S2MPG10_PMIC_B2M_CTRL = 27,
	S2MPG10_PMIC_B2M_OUT1 = 28,
	S2MPG10_PMIC_B2M_OUT2 = 29,
	S2MPG10_PMIC_B3M_CTRL = 30,
	S2MPG10_PMIC_B3M_OUT1 = 31,
	S2MPG10_PMIC_B3M_OUT2 = 32,
	S2MPG10_PMIC_B4M_CTRL = 33,
	S2MPG10_PMIC_B4M_OUT1 = 34,
	S2MPG10_PMIC_B4M_OUT2 = 35,
	S2MPG10_PMIC_B5M_CTRL = 36,
	S2MPG10_PMIC_B5M_OUT1 = 37,
	S2MPG10_PMIC_B5M_OUT2 = 38,
	S2MPG10_PMIC_B6M_CTRL = 39,
	S2MPG10_PMIC_B6M_OUT1 = 40,
	S2MPG10_PMIC_B6M_OUT2 = 41,
	S2MPG10_PMIC_B7M_CTRL = 42,
	S2MPG10_PMIC_B7M_OUT1 = 43,
	S2MPG10_PMIC_B7M_OUT2 = 44,
	S2MPG10_PMIC_B8M_CTRL = 45,
	S2MPG10_PMIC_B8M_OUT1 = 46,
	S2MPG10_PMIC_B8M_OUT2 = 47,
	S2MPG10_PMIC_B9M_CTRL = 48,
	S2MPG10_PMIC_B9M_OUT1 = 49,
	S2MPG10_PMIC_B9M_OUT2 = 50,
	S2MPG10_PMIC_B10M_CTRL = 51,
	S2MPG10_PMIC_B10M_OUT1 = 52,
	S2MPG10_PMIC_B10M_OUT2 = 53,
	S2MPG10_PMIC_BUCK1M_USONIC = 54,
	S2MPG10_PMIC_BUCK2M_USONIC = 55,
	S2MPG10_PMIC_BUCK3M_USONIC = 56,
	S2MPG10_PMIC_BUCK4M_USONIC = 57,
	S2MPG10_PMIC_BUCK5M_USONIC = 58,
	S2MPG10_PMIC_BUCK6M_USONIC = 59,
	S2MPG10_PMIC_BUCK7M_USONIC = 60,
	S2MPG10_PMIC_BUCK8M_USONIC = 61,
	S2MPG10_PMIC_BUCK9M_USONIC = 62,
	S2MPG10_PMIC_BUCK10M_USONIC = 63,
	S2MPG10_PMIC_L1M_CTRL = 64,
	S2MPG10_PMIC_L2M_CTRL = 65,
	S2MPG10_PMIC_L3M_CTRL = 66,
	S2MPG10_PMIC_L4M_CTRL = 67,
	S2MPG10_PMIC_L5M_CTRL = 68,
	S2MPG10_PMIC_L6M_CTRL = 69,
	S2MPG10_PMIC_L7M_CTRL = 70,
	S2MPG10_PMIC_L8M_CTRL = 71,
	S2MPG10_PMIC_L9M_CTRL = 72,
	S2MPG10_PMIC_L10M_CTRL = 73,
	S2MPG10_PMIC_L11M_CTRL1 = 74,
	S2MPG10_PMIC_L11M_CTRL2 = 75,
	S2MPG10_PMIC_L12M_CTRL1 = 76,
	S2MPG10_PMIC_L12M_CTRL2 = 77,
	S2MPG10_PMIC_L13M_CTRL1 = 78,
	S2MPG10_PMIC_L13M_CTRL2 = 79,
	S2MPG10_PMIC_L14M_CTRL = 80,
	S2MPG10_PMIC_L15M_CTRL1 = 81,
	S2MPG10_PMIC_L15M_CTRL2 = 82,
	S2MPG10_PMIC_L16M_CTRL = 83,
	S2MPG10_PMIC_L17M_CTRL = 84,
	S2MPG10_PMIC_L18M_CTRL = 85,
	S2MPG10_PMIC_L19M_CTRL = 86,
	S2MPG10_PMIC_L20M_CTRL = 87,
	S2MPG10_PMIC_L21M_CTRL = 88,
	S2MPG10_PMIC_L22M_CTRL = 89,
	S2MPG10_PMIC_L23M_CTRL = 90,
	S2MPG10_PMIC_L24M_CTRL = 91,
	S2MPG10_PMIC_L25M_CTRL = 92,
	S2MPG10_PMIC_L26M_CTRL = 93,
	S2MPG10_PMIC_L27M_CTRL = 94,
	S2MPG10_PMIC_L28M_CTRL = 95,
	S2MPG10_PMIC_L29M_CTRL = 96,
	S2MPG10_PMIC_L30M_CTRL = 97,
	S2MPG10_PMIC_L31M_CTRL = 98,
	S2MPG10_PMIC_LDO_CTRL1 = 99,
	S2MPG10_PMIC_LDO_CTRL2 = 100,
	S2MPG10_PMIC_LDO_DSCH1 = 101,
	S2MPG10_PMIC_LDO_DSCH2 = 102,
	S2MPG10_PMIC_LDO_DSCH3 = 103,
	S2MPG10_PMIC_LDO_DSCH4 = 104,
	S2MPG10_PMIC_LDO_BUCK7M_HLIMIT = 105,
	S2MPG10_PMIC_LDO_BUCK7M_LLIMIT = 106,
	S2MPG10_PMIC_LDO_LDO21M_HLIMIT = 107,
	S2MPG10_PMIC_LDO_LDO21M_LLIMIT = 108,
	S2MPG10_PMIC_LDO_LDO11M_HLIMIT = 109,
	S2MPG10_PMIC_DVS_RAMP1 = 110,
	S2MPG10_PMIC_DVS_RAMP2 = 111,
	S2MPG10_PMIC_DVS_RAMP3 = 112,
	S2MPG10_PMIC_DVS_RAMP4 = 113,
	S2MPG10_PMIC_DVS_RAMP5 = 114,
	S2MPG10_PMIC_DVS_RAMP6 = 115,
	S2MPG10_PMIC_DVS_SYNC_CTRL1 = 116,
	S2MPG10_PMIC_DVS_SYNC_CTRL2 = 117,
	S2MPG10_PMIC_DVS_SYNC_CTRL3 = 118,
	S2MPG10_PMIC_DVS_SYNC_CTRL4 = 119,
	S2MPG10_PMIC_DVS_SYNC_CTRL5 = 120,
	S2MPG10_PMIC_DVS_SYNC_CTRL6 = 121,
	S2MPG10_PMIC_OFF_CTRL1 = 122,
	S2MPG10_PMIC_OFF_CTRL2 = 123,
	S2MPG10_PMIC_OFF_CTRL3 = 124,
	S2MPG10_PMIC_OFF_CTRL4 = 125,
	S2MPG10_PMIC_SEQ_CTRL1 = 126,
	S2MPG10_PMIC_SEQ_CTRL2 = 127,
	S2MPG10_PMIC_SEQ_CTRL3 = 128,
	S2MPG10_PMIC_SEQ_CTRL4 = 129,
	S2MPG10_PMIC_SEQ_CTRL5 = 130,
	S2MPG10_PMIC_SEQ_CTRL6 = 131,
	S2MPG10_PMIC_SEQ_CTRL7 = 132,
	S2MPG10_PMIC_SEQ_CTRL8 = 133,
	S2MPG10_PMIC_SEQ_CTRL9 = 134,
	S2MPG10_PMIC_SEQ_CTRL10 = 135,
	S2MPG10_PMIC_SEQ_CTRL11 = 136,
	S2MPG10_PMIC_SEQ_CTRL12 = 137,
	S2MPG10_PMIC_SEQ_CTRL13 = 138,
	S2MPG10_PMIC_SEQ_CTRL14 = 139,
	S2MPG10_PMIC_SEQ_CTRL15 = 140,
	S2MPG10_PMIC_SEQ_CTRL16 = 141,
	S2MPG10_PMIC_SEQ_CTRL17 = 142,
	S2MPG10_PMIC_SEQ_CTRL18 = 143,
	S2MPG10_PMIC_SEQ_CTRL19 = 144,
	S2MPG10_PMIC_SEQ_CTRL20 = 145,
	S2MPG10_PMIC_SEQ_CTRL21 = 146,
	S2MPG10_PMIC_SEQ_CTRL22 = 147,
	S2MPG10_PMIC_SEQ_CTRL23 = 148,
	S2MPG10_PMIC_SEQ_CTRL24 = 149,
	S2MPG10_PMIC_SEQ_CTRL25 = 150,
	S2MPG10_PMIC_SEQ_CTRL26 = 151,
	S2MPG10_PMIC_SEQ_CTRL27 = 152,
	S2MPG10_PMIC_SEQ_CTRL28 = 153,
	S2MPG10_PMIC_SEQ_CTRL29 = 154,
	S2MPG10_PMIC_SEQ_CTRL30 = 155,
	S2MPG10_PMIC_SEQ_CTRL31 = 156,
	S2MPG10_PMIC_SEQ_CTRL32 = 157,
	S2MPG10_PMIC_SEQ_CTRL33 = 158,
	S2MPG10_PMIC_SEQ_CTRL34 = 159,
	S2MPG10_PMIC_SEQ_CTRL35 = 160,
	S2MPG10_PMIC_OFF_SEQ_CTRL1 = 161,
	S2MPG10_PMIC_OFF_SEQ_CTRL2 = 162,
	S2MPG10_PMIC_OFF_SEQ_CTRL3 = 163,
	S2MPG10_PMIC_OFF_SEQ_CTRL4 = 164,
	S2MPG10_PMIC_OFF_SEQ_CTRL5 = 165,
	S2MPG10_PMIC_OFF_SEQ_CTRL6 = 166,
	S2MPG10_PMIC_OFF_SEQ_CTRL7 = 167,
	S2MPG10_PMIC_OFF_SEQ_CTRL8 = 168,
	S2MPG10_PMIC_OFF_SEQ_CTRL9 = 169,
	S2MPG10_PMIC_OFF_SEQ_CTRL10 = 170,
	S2MPG10_PMIC_OFF_SEQ_CTRL11 = 171,
	S2MPG10_PMIC_OFF_SEQ_CTRL12 = 172,
	S2MPG10_PMIC_OFF_SEQ_CTRL13 = 173,
	S2MPG10_PMIC_OFF_SEQ_CTRL14 = 174,
	S2MPG10_PMIC_OFF_SEQ_CTRL15 = 175,
	S2MPG10_PMIC_OFF_SEQ_CTRL16 = 176,
	S2MPG10_PMIC_OFF_SEQ_CTRL17 = 177,
	S2MPG10_PMIC_OFF_SEQ_CTRL18 = 178,
	S2MPG10_PMIC_PCTRLSEL1 = 179,
	S2MPG10_PMIC_PCTRLSEL2 = 180,
	S2MPG10_PMIC_PCTRLSEL3 = 181,
	S2MPG10_PMIC_PCTRLSEL4 = 182,
	S2MPG10_PMIC_PCTRLSEL5 = 183,
	S2MPG10_PMIC_PCTRLSEL6 = 184,
	S2MPG10_PMIC_PCTRLSEL7 = 185,
	S2MPG10_PMIC_PCTRLSEL8 = 186,
	S2MPG10_PMIC_PCTRLSEL9 = 187,
	S2MPG10_PMIC_PCTRLSEL10 = 188,
	S2MPG10_PMIC_PCTRLSEL11 = 189,
	S2MPG10_PMIC_PCTRLSEL12 = 190,
	S2MPG10_PMIC_PCTRLSEL13 = 191,
	S2MPG10_PMIC_DCTRLSEL1 = 192,
	S2MPG10_PMIC_DCTRLSEL2 = 193,
	S2MPG10_PMIC_DCTRLSEL3 = 194,
	S2MPG10_PMIC_DCTRLSEL4 = 195,
	S2MPG10_PMIC_DCTRLSEL5 = 196,
	S2MPG10_PMIC_DCTRLSEL6 = 197,
	S2MPG10_PMIC_DCTRLSEL7 = 198,
	S2MPG10_PMIC_GPIO_CTRL1 = 199,
	S2MPG10_PMIC_GPIO_CTRL2 = 200,
	S2MPG10_PMIC_GPIO_CTRL3 = 201,
	S2MPG10_PMIC_GPIO_CTRL4 = 202,
	S2MPG10_PMIC_GPIO_CTRL5 = 203,
	S2MPG10_PMIC_GPIO_CTRL6 = 204,
	S2MPG10_PMIC_GPIO_CTRL7 = 205,
	S2MPG10_PMIC_B2M_OCP_WARN = 206,
	S2MPG10_PMIC_B2M_OCP_WARN_X = 207,
	S2MPG10_PMIC_B2M_OCP_WARN_Y = 208,
	S2MPG10_PMIC_B2M_OCP_WARN_Z = 209,
	S2MPG10_PMIC_B3M_OCP_WARN = 210,
	S2MPG10_PMIC_B3M_OCP_WARN_X = 211,
	S2MPG10_PMIC_B3M_OCP_WARN_Y = 212,
	S2MPG10_PMIC_B3M_OCP_WARN_Z = 213,
	S2MPG10_PMIC_B10M_OCP_WARN = 214,
	S2MPG10_PMIC_B10M_OCP_WARN_X = 215,
	S2MPG10_PMIC_B10M_OCP_WARN_Y = 216,
	S2MPG10_PMIC_B10M_OCP_WARN_Z = 217,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN = 218,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_X = 219,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_Y = 220,
	S2MPG10_PMIC_B2M_SOFT_OCP_WARN_Z = 221,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN = 222,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_X = 223,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_Y = 224,
	S2MPG10_PMIC_B3M_SOFT_OCP_WARN_Z = 225,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN = 226,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_X = 227,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_Y = 228,
	S2MPG10_PMIC_B10M_SOFT_OCP_WARN_Z = 229,
	S2MPG10_PMIC_BUCK_OCP_EN1 = 230,
	S2MPG10_PMIC_BUCK_OCP_EN2 = 231,
	S2MPG10_PMIC_BUCK_OCP_PD_EN1 = 232,
	S2MPG10_PMIC_BUCK_OCP_PD_EN2 = 233,
	S2MPG10_PMIC_BUCK_OCP_CTRL1 = 234,
	S2MPG10_PMIC_BUCK_OCP_CTRL2 = 235,
	S2MPG10_PMIC_BUCK_OCP_CTRL3 = 236,
	S2MPG10_PMIC_BUCK_OCP_CTRL4 = 237,
	S2MPG10_PMIC_BUCK_OCP_CTRL5 = 238,
	S2MPG10_PMIC_PIF_CTRL = 239,
	S2MPG10_PMIC_BUCK_HR_MODE1 = 240,
	S2MPG10_PMIC_BUCK_HR_MODE2 = 241,
	S2MPG10_PMIC_FAULTOUT_CTRL = 242,
	S2MPG10_PMIC_LDO_SENSE1 = 243,
	S2MPG10_PMIC_LDO_SENSE2 = 244,
	S2MPG10_PMIC_LDO_SENSE3 = 245,
	S2MPG10_PMIC_LDO_SENSE4 = 246,
};

enum s2mps11_irq {
	S2MPS11_IRQ_PWRONF = 0,
	S2MPS11_IRQ_PWRONR = 1,
	S2MPS11_IRQ_JIGONBF = 2,
	S2MPS11_IRQ_JIGONBR = 3,
	S2MPS11_IRQ_ACOKBF = 4,
	S2MPS11_IRQ_ACOKBR = 5,
	S2MPS11_IRQ_PWRON1S = 6,
	S2MPS11_IRQ_MRB = 7,
	S2MPS11_IRQ_RTC60S = 8,
	S2MPS11_IRQ_RTCA1 = 9,
	S2MPS11_IRQ_RTCA0 = 10,
	S2MPS11_IRQ_SMPL = 11,
	S2MPS11_IRQ_RTC1S = 12,
	S2MPS11_IRQ_WTSR = 13,
	S2MPS11_IRQ_INT120C = 14,
	S2MPS11_IRQ_INT140C = 15,
	S2MPS11_IRQ_NR = 16,
};

enum s2mps11_reg {
	S2MPS11_REG_ID = 0,
	S2MPS11_REG_INT1 = 1,
	S2MPS11_REG_INT2 = 2,
	S2MPS11_REG_INT3 = 3,
	S2MPS11_REG_INT1M = 4,
	S2MPS11_REG_INT2M = 5,
	S2MPS11_REG_INT3M = 6,
	S2MPS11_REG_ST1 = 7,
	S2MPS11_REG_ST2 = 8,
	S2MPS11_REG_OFFSRC = 9,
	S2MPS11_REG_PWRONSRC = 10,
	S2MPS11_REG_RTC_CTRL = 11,
	S2MPS11_REG_CTRL1 = 12,
	S2MPS11_REG_ETC_TEST = 13,
	S2MPS11_REG_RSVD3 = 14,
	S2MPS11_REG_BU_CHG = 15,
	S2MPS11_REG_RAMP = 16,
	S2MPS11_REG_RAMP_BUCK = 17,
	S2MPS11_REG_LDO1_8 = 18,
	S2MPS11_REG_LDO9_16 = 19,
	S2MPS11_REG_LDO17_24 = 20,
	S2MPS11_REG_LDO25_32 = 21,
	S2MPS11_REG_LDO33_38 = 22,
	S2MPS11_REG_LDO1_8_1 = 23,
	S2MPS11_REG_LDO9_16_1 = 24,
	S2MPS11_REG_LDO17_24_1 = 25,
	S2MPS11_REG_LDO25_32_1 = 26,
	S2MPS11_REG_LDO33_38_1 = 27,
	S2MPS11_REG_OTP_ADRL = 28,
	S2MPS11_REG_OTP_ADRH = 29,
	S2MPS11_REG_OTP_DATA = 30,
	S2MPS11_REG_MON1SEL = 31,
	S2MPS11_REG_MON2SEL = 32,
	S2MPS11_REG_LEE = 33,
	S2MPS11_REG_RSVD_NO = 34,
	S2MPS11_REG_UVLO = 35,
	S2MPS11_REG_LEE_NO = 36,
	S2MPS11_REG_B1CTRL1 = 37,
	S2MPS11_REG_B1CTRL2 = 38,
	S2MPS11_REG_B2CTRL1 = 39,
	S2MPS11_REG_B2CTRL2 = 40,
	S2MPS11_REG_B3CTRL1 = 41,
	S2MPS11_REG_B3CTRL2 = 42,
	S2MPS11_REG_B4CTRL1 = 43,
	S2MPS11_REG_B4CTRL2 = 44,
	S2MPS11_REG_B5CTRL1 = 45,
	S2MPS11_REG_BUCK5_SW = 46,
	S2MPS11_REG_B5CTRL2 = 47,
	S2MPS11_REG_B5CTRL3 = 48,
	S2MPS11_REG_B5CTRL4 = 49,
	S2MPS11_REG_B5CTRL5 = 50,
	S2MPS11_REG_B6CTRL1 = 51,
	S2MPS11_REG_B6CTRL2 = 52,
	S2MPS11_REG_B7CTRL1 = 53,
	S2MPS11_REG_B7CTRL2 = 54,
	S2MPS11_REG_B8CTRL1 = 55,
	S2MPS11_REG_B8CTRL2 = 56,
	S2MPS11_REG_B9CTRL1 = 57,
	S2MPS11_REG_B9CTRL2 = 58,
	S2MPS11_REG_B10CTRL1 = 59,
	S2MPS11_REG_B10CTRL2 = 60,
	S2MPS11_REG_L1CTRL = 61,
	S2MPS11_REG_L2CTRL = 62,
	S2MPS11_REG_L3CTRL = 63,
	S2MPS11_REG_L4CTRL = 64,
	S2MPS11_REG_L5CTRL = 65,
	S2MPS11_REG_L6CTRL = 66,
	S2MPS11_REG_L7CTRL = 67,
	S2MPS11_REG_L8CTRL = 68,
	S2MPS11_REG_L9CTRL = 69,
	S2MPS11_REG_L10CTRL = 70,
	S2MPS11_REG_L11CTRL = 71,
	S2MPS11_REG_L12CTRL = 72,
	S2MPS11_REG_L13CTRL = 73,
	S2MPS11_REG_L14CTRL = 74,
	S2MPS11_REG_L15CTRL = 75,
	S2MPS11_REG_L16CTRL = 76,
	S2MPS11_REG_L17CTRL = 77,
	S2MPS11_REG_L18CTRL = 78,
	S2MPS11_REG_L19CTRL = 79,
	S2MPS11_REG_L20CTRL = 80,
	S2MPS11_REG_L21CTRL = 81,
	S2MPS11_REG_L22CTRL = 82,
	S2MPS11_REG_L23CTRL = 83,
	S2MPS11_REG_L24CTRL = 84,
	S2MPS11_REG_L25CTRL = 85,
	S2MPS11_REG_L26CTRL = 86,
	S2MPS11_REG_L27CTRL = 87,
	S2MPS11_REG_L28CTRL = 88,
	S2MPS11_REG_L29CTRL = 89,
	S2MPS11_REG_L30CTRL = 90,
	S2MPS11_REG_L31CTRL = 91,
	S2MPS11_REG_L32CTRL = 92,
	S2MPS11_REG_L33CTRL = 93,
	S2MPS11_REG_L34CTRL = 94,
	S2MPS11_REG_L35CTRL = 95,
	S2MPS11_REG_L36CTRL = 96,
	S2MPS11_REG_L37CTRL = 97,
	S2MPS11_REG_L38CTRL = 98,
};

enum s2mps11_regulators {
	S2MPS11_LDO1 = 0,
	S2MPS11_LDO2 = 1,
	S2MPS11_LDO3 = 2,
	S2MPS11_LDO4 = 3,
	S2MPS11_LDO5 = 4,
	S2MPS11_LDO6 = 5,
	S2MPS11_LDO7 = 6,
	S2MPS11_LDO8 = 7,
	S2MPS11_LDO9 = 8,
	S2MPS11_LDO10 = 9,
	S2MPS11_LDO11 = 10,
	S2MPS11_LDO12 = 11,
	S2MPS11_LDO13 = 12,
	S2MPS11_LDO14 = 13,
	S2MPS11_LDO15 = 14,
	S2MPS11_LDO16 = 15,
	S2MPS11_LDO17 = 16,
	S2MPS11_LDO18 = 17,
	S2MPS11_LDO19 = 18,
	S2MPS11_LDO20 = 19,
	S2MPS11_LDO21 = 20,
	S2MPS11_LDO22 = 21,
	S2MPS11_LDO23 = 22,
	S2MPS11_LDO24 = 23,
	S2MPS11_LDO25 = 24,
	S2MPS11_LDO26 = 25,
	S2MPS11_LDO27 = 26,
	S2MPS11_LDO28 = 27,
	S2MPS11_LDO29 = 28,
	S2MPS11_LDO30 = 29,
	S2MPS11_LDO31 = 30,
	S2MPS11_LDO32 = 31,
	S2MPS11_LDO33 = 32,
	S2MPS11_LDO34 = 33,
	S2MPS11_LDO35 = 34,
	S2MPS11_LDO36 = 35,
	S2MPS11_LDO37 = 36,
	S2MPS11_LDO38 = 37,
	S2MPS11_BUCK1 = 38,
	S2MPS11_BUCK2 = 39,
	S2MPS11_BUCK3 = 40,
	S2MPS11_BUCK4 = 41,
	S2MPS11_BUCK5 = 42,
	S2MPS11_BUCK6 = 43,
	S2MPS11_BUCK7 = 44,
	S2MPS11_BUCK8 = 45,
	S2MPS11_BUCK9 = 46,
	S2MPS11_BUCK10 = 47,
	S2MPS11_REGULATOR_MAX = 48,
};

enum s2mps13_reg {
	S2MPS13_REG_ID = 0,
	S2MPS13_REG_INT1 = 1,
	S2MPS13_REG_INT2 = 2,
	S2MPS13_REG_INT3 = 3,
	S2MPS13_REG_INT1M = 4,
	S2MPS13_REG_INT2M = 5,
	S2MPS13_REG_INT3M = 6,
	S2MPS13_REG_ST1 = 7,
	S2MPS13_REG_ST2 = 8,
	S2MPS13_REG_PWRONSRC = 9,
	S2MPS13_REG_OFFSRC = 10,
	S2MPS13_REG_BU_CHG = 11,
	S2MPS13_REG_RTCCTRL = 12,
	S2MPS13_REG_CTRL1 = 13,
	S2MPS13_REG_CTRL2 = 14,
	S2MPS13_REG_RSVD1 = 15,
	S2MPS13_REG_RSVD2 = 16,
	S2MPS13_REG_RSVD3 = 17,
	S2MPS13_REG_RSVD4 = 18,
	S2MPS13_REG_RSVD5 = 19,
	S2MPS13_REG_RSVD6 = 20,
	S2MPS13_REG_CTRL3 = 21,
	S2MPS13_REG_RSVD7 = 22,
	S2MPS13_REG_RSVD8 = 23,
	S2MPS13_REG_WRSTBI = 24,
	S2MPS13_REG_B1CTRL = 25,
	S2MPS13_REG_B1OUT = 26,
	S2MPS13_REG_B2CTRL = 27,
	S2MPS13_REG_B2OUT = 28,
	S2MPS13_REG_B3CTRL = 29,
	S2MPS13_REG_B3OUT = 30,
	S2MPS13_REG_B4CTRL = 31,
	S2MPS13_REG_B4OUT = 32,
	S2MPS13_REG_B5CTRL = 33,
	S2MPS13_REG_B5OUT = 34,
	S2MPS13_REG_B6CTRL = 35,
	S2MPS13_REG_B6OUT = 36,
	S2MPS13_REG_B7CTRL = 37,
	S2MPS13_REG_B7SW = 38,
	S2MPS13_REG_B7OUT = 39,
	S2MPS13_REG_B8CTRL = 40,
	S2MPS13_REG_B8OUT = 41,
	S2MPS13_REG_B9CTRL = 42,
	S2MPS13_REG_B9OUT = 43,
	S2MPS13_REG_B10CTRL = 44,
	S2MPS13_REG_B10OUT = 45,
	S2MPS13_REG_BB1CTRL = 46,
	S2MPS13_REG_BB1OUT = 47,
	S2MPS13_REG_BUCK_RAMP1 = 48,
	S2MPS13_REG_BUCK_RAMP2 = 49,
	S2MPS13_REG_LDO_DVS1 = 50,
	S2MPS13_REG_LDO_DVS2 = 51,
	S2MPS13_REG_LDO_DVS3 = 52,
	S2MPS13_REG_B6OUT2 = 53,
	S2MPS13_REG_L1CTRL = 54,
	S2MPS13_REG_L2CTRL = 55,
	S2MPS13_REG_L3CTRL = 56,
	S2MPS13_REG_L4CTRL = 57,
	S2MPS13_REG_L5CTRL = 58,
	S2MPS13_REG_L6CTRL = 59,
	S2MPS13_REG_L7CTRL = 60,
	S2MPS13_REG_L8CTRL = 61,
	S2MPS13_REG_L9CTRL = 62,
	S2MPS13_REG_L10CTRL = 63,
	S2MPS13_REG_L11CTRL = 64,
	S2MPS13_REG_L12CTRL = 65,
	S2MPS13_REG_L13CTRL = 66,
	S2MPS13_REG_L14CTRL = 67,
	S2MPS13_REG_L15CTRL = 68,
	S2MPS13_REG_L16CTRL = 69,
	S2MPS13_REG_L17CTRL = 70,
	S2MPS13_REG_L18CTRL = 71,
	S2MPS13_REG_L19CTRL = 72,
	S2MPS13_REG_L20CTRL = 73,
	S2MPS13_REG_L21CTRL = 74,
	S2MPS13_REG_L22CTRL = 75,
	S2MPS13_REG_L23CTRL = 76,
	S2MPS13_REG_L24CTRL = 77,
	S2MPS13_REG_L25CTRL = 78,
	S2MPS13_REG_L26CTRL = 79,
	S2MPS13_REG_L27CTRL = 80,
	S2MPS13_REG_L28CTRL = 81,
	S2MPS13_REG_L29CTRL = 82,
	S2MPS13_REG_L30CTRL = 83,
	S2MPS13_REG_L31CTRL = 84,
	S2MPS13_REG_L32CTRL = 85,
	S2MPS13_REG_L33CTRL = 86,
	S2MPS13_REG_L34CTRL = 87,
	S2MPS13_REG_L35CTRL = 88,
	S2MPS13_REG_L36CTRL = 89,
	S2MPS13_REG_L37CTRL = 90,
	S2MPS13_REG_L38CTRL = 91,
	S2MPS13_REG_L39CTRL = 92,
	S2MPS13_REG_L40CTRL = 93,
	S2MPS13_REG_LDODSCH1 = 94,
	S2MPS13_REG_LDODSCH2 = 95,
	S2MPS13_REG_LDODSCH3 = 96,
	S2MPS13_REG_LDODSCH4 = 97,
	S2MPS13_REG_LDODSCH5 = 98,
};

enum s2mps13_regulators {
	S2MPS13_LDO1 = 0,
	S2MPS13_LDO2 = 1,
	S2MPS13_LDO3 = 2,
	S2MPS13_LDO4 = 3,
	S2MPS13_LDO5 = 4,
	S2MPS13_LDO6 = 5,
	S2MPS13_LDO7 = 6,
	S2MPS13_LDO8 = 7,
	S2MPS13_LDO9 = 8,
	S2MPS13_LDO10 = 9,
	S2MPS13_LDO11 = 10,
	S2MPS13_LDO12 = 11,
	S2MPS13_LDO13 = 12,
	S2MPS13_LDO14 = 13,
	S2MPS13_LDO15 = 14,
	S2MPS13_LDO16 = 15,
	S2MPS13_LDO17 = 16,
	S2MPS13_LDO18 = 17,
	S2MPS13_LDO19 = 18,
	S2MPS13_LDO20 = 19,
	S2MPS13_LDO21 = 20,
	S2MPS13_LDO22 = 21,
	S2MPS13_LDO23 = 22,
	S2MPS13_LDO24 = 23,
	S2MPS13_LDO25 = 24,
	S2MPS13_LDO26 = 25,
	S2MPS13_LDO27 = 26,
	S2MPS13_LDO28 = 27,
	S2MPS13_LDO29 = 28,
	S2MPS13_LDO30 = 29,
	S2MPS13_LDO31 = 30,
	S2MPS13_LDO32 = 31,
	S2MPS13_LDO33 = 32,
	S2MPS13_LDO34 = 33,
	S2MPS13_LDO35 = 34,
	S2MPS13_LDO36 = 35,
	S2MPS13_LDO37 = 36,
	S2MPS13_LDO38 = 37,
	S2MPS13_LDO39 = 38,
	S2MPS13_LDO40 = 39,
	S2MPS13_BUCK1 = 40,
	S2MPS13_BUCK2 = 41,
	S2MPS13_BUCK3 = 42,
	S2MPS13_BUCK4 = 43,
	S2MPS13_BUCK5 = 44,
	S2MPS13_BUCK6 = 45,
	S2MPS13_BUCK7 = 46,
	S2MPS13_BUCK8 = 47,
	S2MPS13_BUCK9 = 48,
	S2MPS13_BUCK10 = 49,
	S2MPS13_REGULATOR_MAX = 50,
};

enum s2mps14_irq {
	S2MPS14_IRQ_PWRONF = 0,
	S2MPS14_IRQ_PWRONR = 1,
	S2MPS14_IRQ_JIGONBF = 2,
	S2MPS14_IRQ_JIGONBR = 3,
	S2MPS14_IRQ_ACOKBF = 4,
	S2MPS14_IRQ_ACOKBR = 5,
	S2MPS14_IRQ_PWRON1S = 6,
	S2MPS14_IRQ_MRB = 7,
	S2MPS14_IRQ_RTC60S = 8,
	S2MPS14_IRQ_RTCA1 = 9,
	S2MPS14_IRQ_RTCA0 = 10,
	S2MPS14_IRQ_SMPL = 11,
	S2MPS14_IRQ_RTC1S = 12,
	S2MPS14_IRQ_WTSR = 13,
	S2MPS14_IRQ_INT120C = 14,
	S2MPS14_IRQ_INT140C = 15,
	S2MPS14_IRQ_TSD = 16,
	S2MPS14_IRQ_NR = 17,
};

enum s2mps14_reg {
	S2MPS14_REG_ID = 0,
	S2MPS14_REG_INT1 = 1,
	S2MPS14_REG_INT2 = 2,
	S2MPS14_REG_INT3 = 3,
	S2MPS14_REG_INT1M = 4,
	S2MPS14_REG_INT2M = 5,
	S2MPS14_REG_INT3M = 6,
	S2MPS14_REG_ST1 = 7,
	S2MPS14_REG_ST2 = 8,
	S2MPS14_REG_PWRONSRC = 9,
	S2MPS14_REG_OFFSRC = 10,
	S2MPS14_REG_BU_CHG = 11,
	S2MPS14_REG_RTCCTRL = 12,
	S2MPS14_REG_CTRL1 = 13,
	S2MPS14_REG_CTRL2 = 14,
	S2MPS14_REG_RSVD1 = 15,
	S2MPS14_REG_RSVD2 = 16,
	S2MPS14_REG_RSVD3 = 17,
	S2MPS14_REG_RSVD4 = 18,
	S2MPS14_REG_RSVD5 = 19,
	S2MPS14_REG_RSVD6 = 20,
	S2MPS14_REG_CTRL3 = 21,
	S2MPS14_REG_RSVD7 = 22,
	S2MPS14_REG_RSVD8 = 23,
	S2MPS14_REG_WRSTBI = 24,
	S2MPS14_REG_B1CTRL1 = 25,
	S2MPS14_REG_B1CTRL2 = 26,
	S2MPS14_REG_B2CTRL1 = 27,
	S2MPS14_REG_B2CTRL2 = 28,
	S2MPS14_REG_B3CTRL1 = 29,
	S2MPS14_REG_B3CTRL2 = 30,
	S2MPS14_REG_B4CTRL1 = 31,
	S2MPS14_REG_B4CTRL2 = 32,
	S2MPS14_REG_B5CTRL1 = 33,
	S2MPS14_REG_B5CTRL2 = 34,
	S2MPS14_REG_L1CTRL = 35,
	S2MPS14_REG_L2CTRL = 36,
	S2MPS14_REG_L3CTRL = 37,
	S2MPS14_REG_L4CTRL = 38,
	S2MPS14_REG_L5CTRL = 39,
	S2MPS14_REG_L6CTRL = 40,
	S2MPS14_REG_L7CTRL = 41,
	S2MPS14_REG_L8CTRL = 42,
	S2MPS14_REG_L9CTRL = 43,
	S2MPS14_REG_L10CTRL = 44,
	S2MPS14_REG_L11CTRL = 45,
	S2MPS14_REG_L12CTRL = 46,
	S2MPS14_REG_L13CTRL = 47,
	S2MPS14_REG_L14CTRL = 48,
	S2MPS14_REG_L15CTRL = 49,
	S2MPS14_REG_L16CTRL = 50,
	S2MPS14_REG_L17CTRL = 51,
	S2MPS14_REG_L18CTRL = 52,
	S2MPS14_REG_L19CTRL = 53,
	S2MPS14_REG_L20CTRL = 54,
	S2MPS14_REG_L21CTRL = 55,
	S2MPS14_REG_L22CTRL = 56,
	S2MPS14_REG_L23CTRL = 57,
	S2MPS14_REG_L24CTRL = 58,
	S2MPS14_REG_L25CTRL = 59,
	S2MPS14_REG_LDODSCH1 = 60,
	S2MPS14_REG_LDODSCH2 = 61,
	S2MPS14_REG_LDODSCH3 = 62,
};

enum s2mps14_regulators {
	S2MPS14_LDO1 = 0,
	S2MPS14_LDO2 = 1,
	S2MPS14_LDO3 = 2,
	S2MPS14_LDO4 = 3,
	S2MPS14_LDO5 = 4,
	S2MPS14_LDO6 = 5,
	S2MPS14_LDO7 = 6,
	S2MPS14_LDO8 = 7,
	S2MPS14_LDO9 = 8,
	S2MPS14_LDO10 = 9,
	S2MPS14_LDO11 = 10,
	S2MPS14_LDO12 = 11,
	S2MPS14_LDO13 = 12,
	S2MPS14_LDO14 = 13,
	S2MPS14_LDO15 = 14,
	S2MPS14_LDO16 = 15,
	S2MPS14_LDO17 = 16,
	S2MPS14_LDO18 = 17,
	S2MPS14_LDO19 = 18,
	S2MPS14_LDO20 = 19,
	S2MPS14_LDO21 = 20,
	S2MPS14_LDO22 = 21,
	S2MPS14_LDO23 = 22,
	S2MPS14_LDO24 = 23,
	S2MPS14_LDO25 = 24,
	S2MPS14_BUCK1 = 25,
	S2MPS14_BUCK2 = 26,
	S2MPS14_BUCK3 = 27,
	S2MPS14_BUCK4 = 28,
	S2MPS14_BUCK5 = 29,
	S2MPS14_REGULATOR_MAX = 30,
};

enum s2mps15_reg {
	S2MPS15_REG_ID = 0,
	S2MPS15_REG_INT1 = 1,
	S2MPS15_REG_INT2 = 2,
	S2MPS15_REG_INT3 = 3,
	S2MPS15_REG_INT1M = 4,
	S2MPS15_REG_INT2M = 5,
	S2MPS15_REG_INT3M = 6,
	S2MPS15_REG_ST1 = 7,
	S2MPS15_REG_ST2 = 8,
	S2MPS15_REG_PWRONSRC = 9,
	S2MPS15_REG_OFFSRC = 10,
	S2MPS15_REG_BU_CHG = 11,
	S2MPS15_REG_RTC_BUF = 12,
	S2MPS15_REG_CTRL1 = 13,
	S2MPS15_REG_CTRL2 = 14,
	S2MPS15_REG_RSVD1 = 15,
	S2MPS15_REG_RSVD2 = 16,
	S2MPS15_REG_RSVD3 = 17,
	S2MPS15_REG_RSVD4 = 18,
	S2MPS15_REG_RSVD5 = 19,
	S2MPS15_REG_RSVD6 = 20,
	S2MPS15_REG_CTRL3 = 21,
	S2MPS15_REG_RSVD7 = 22,
	S2MPS15_REG_RSVD8 = 23,
	S2MPS15_REG_RSVD9 = 24,
	S2MPS15_REG_B1CTRL1 = 25,
	S2MPS15_REG_B1CTRL2 = 26,
	S2MPS15_REG_B2CTRL1 = 27,
	S2MPS15_REG_B2CTRL2 = 28,
	S2MPS15_REG_B3CTRL1 = 29,
	S2MPS15_REG_B3CTRL2 = 30,
	S2MPS15_REG_B4CTRL1 = 31,
	S2MPS15_REG_B4CTRL2 = 32,
	S2MPS15_REG_B5CTRL1 = 33,
	S2MPS15_REG_B5CTRL2 = 34,
	S2MPS15_REG_B6CTRL1 = 35,
	S2MPS15_REG_B6CTRL2 = 36,
	S2MPS15_REG_B7CTRL1 = 37,
	S2MPS15_REG_B7CTRL2 = 38,
	S2MPS15_REG_B8CTRL1 = 39,
	S2MPS15_REG_B8CTRL2 = 40,
	S2MPS15_REG_B9CTRL1 = 41,
	S2MPS15_REG_B9CTRL2 = 42,
	S2MPS15_REG_B10CTRL1 = 43,
	S2MPS15_REG_B10CTRL2 = 44,
	S2MPS15_REG_BBCTRL1 = 45,
	S2MPS15_REG_BBCTRL2 = 46,
	S2MPS15_REG_BRAMP = 47,
	S2MPS15_REG_LDODVS1 = 48,
	S2MPS15_REG_LDODVS2 = 49,
	S2MPS15_REG_LDODVS3 = 50,
	S2MPS15_REG_LDODVS4 = 51,
	S2MPS15_REG_L1CTRL = 52,
	S2MPS15_REG_L2CTRL = 53,
	S2MPS15_REG_L3CTRL = 54,
	S2MPS15_REG_L4CTRL = 55,
	S2MPS15_REG_L5CTRL = 56,
	S2MPS15_REG_L6CTRL = 57,
	S2MPS15_REG_L7CTRL = 58,
	S2MPS15_REG_L8CTRL = 59,
	S2MPS15_REG_L9CTRL = 60,
	S2MPS15_REG_L10CTRL = 61,
	S2MPS15_REG_L11CTRL = 62,
	S2MPS15_REG_L12CTRL = 63,
	S2MPS15_REG_L13CTRL = 64,
	S2MPS15_REG_L14CTRL = 65,
	S2MPS15_REG_L15CTRL = 66,
	S2MPS15_REG_L16CTRL = 67,
	S2MPS15_REG_L17CTRL = 68,
	S2MPS15_REG_L18CTRL = 69,
	S2MPS15_REG_L19CTRL = 70,
	S2MPS15_REG_L20CTRL = 71,
	S2MPS15_REG_L21CTRL = 72,
	S2MPS15_REG_L22CTRL = 73,
	S2MPS15_REG_L23CTRL = 74,
	S2MPS15_REG_L24CTRL = 75,
	S2MPS15_REG_L25CTRL = 76,
	S2MPS15_REG_L26CTRL = 77,
	S2MPS15_REG_L27CTRL = 78,
	S2MPS15_REG_LDODSCH1 = 79,
	S2MPS15_REG_LDODSCH2 = 80,
	S2MPS15_REG_LDODSCH3 = 81,
	S2MPS15_REG_LDODSCH4 = 82,
};

enum s2mps15_regulators {
	S2MPS15_LDO1 = 0,
	S2MPS15_LDO2 = 1,
	S2MPS15_LDO3 = 2,
	S2MPS15_LDO4 = 3,
	S2MPS15_LDO5 = 4,
	S2MPS15_LDO6 = 5,
	S2MPS15_LDO7 = 6,
	S2MPS15_LDO8 = 7,
	S2MPS15_LDO9 = 8,
	S2MPS15_LDO10 = 9,
	S2MPS15_LDO11 = 10,
	S2MPS15_LDO12 = 11,
	S2MPS15_LDO13 = 12,
	S2MPS15_LDO14 = 13,
	S2MPS15_LDO15 = 14,
	S2MPS15_LDO16 = 15,
	S2MPS15_LDO17 = 16,
	S2MPS15_LDO18 = 17,
	S2MPS15_LDO19 = 18,
	S2MPS15_LDO20 = 19,
	S2MPS15_LDO21 = 20,
	S2MPS15_LDO22 = 21,
	S2MPS15_LDO23 = 22,
	S2MPS15_LDO24 = 23,
	S2MPS15_LDO25 = 24,
	S2MPS15_LDO26 = 25,
	S2MPS15_LDO27 = 26,
	S2MPS15_BUCK1 = 27,
	S2MPS15_BUCK2 = 28,
	S2MPS15_BUCK3 = 29,
	S2MPS15_BUCK4 = 30,
	S2MPS15_BUCK5 = 31,
	S2MPS15_BUCK6 = 32,
	S2MPS15_BUCK7 = 33,
	S2MPS15_BUCK8 = 34,
	S2MPS15_BUCK9 = 35,
	S2MPS15_BUCK10 = 36,
	S2MPS15_BUCK11 = 37,
	S2MPS15_REGULATOR_MAX = 38,
};

enum s2mpu02_irq {
	S2MPU02_IRQ_PWRONF = 0,
	S2MPU02_IRQ_PWRONR = 1,
	S2MPU02_IRQ_JIGONBF = 2,
	S2MPU02_IRQ_JIGONBR = 3,
	S2MPU02_IRQ_ACOKBF = 4,
	S2MPU02_IRQ_ACOKBR = 5,
	S2MPU02_IRQ_PWRON1S = 6,
	S2MPU02_IRQ_MRB = 7,
	S2MPU02_IRQ_RTC60S = 8,
	S2MPU02_IRQ_RTCA1 = 9,
	S2MPU02_IRQ_RTCA0 = 10,
	S2MPU02_IRQ_SMPL = 11,
	S2MPU02_IRQ_RTC1S = 12,
	S2MPU02_IRQ_WTSR = 13,
	S2MPU02_IRQ_INT120C = 14,
	S2MPU02_IRQ_INT140C = 15,
	S2MPU02_IRQ_TSD = 16,
	S2MPU02_IRQ_NR = 17,
};

enum s2mpu05_irq {
	S2MPU05_IRQ_PWRONF = 0,
	S2MPU05_IRQ_PWRONR = 1,
	S2MPU05_IRQ_JIGONBF = 2,
	S2MPU05_IRQ_JIGONBR = 3,
	S2MPU05_IRQ_ACOKF = 4,
	S2MPU05_IRQ_ACOKR = 5,
	S2MPU05_IRQ_PWRON1S = 6,
	S2MPU05_IRQ_MRB = 7,
	S2MPU05_IRQ_RTC60S = 8,
	S2MPU05_IRQ_RTCA1 = 9,
	S2MPU05_IRQ_RTCA0 = 10,
	S2MPU05_IRQ_SMPL = 11,
	S2MPU05_IRQ_RTC1S = 12,
	S2MPU05_IRQ_WTSR = 13,
	S2MPU05_IRQ_INT120C = 14,
	S2MPU05_IRQ_INT140C = 15,
	S2MPU05_IRQ_TSD = 16,
	S2MPU05_IRQ_NR = 17,
};

enum s3c24xx_i2c_state {
	STATE_IDLE___4 = 0,
	STATE_START___2 = 1,
	STATE_READ___3 = 2,
	STATE_WRITE___3 = 3,
	STATE_STOP___2 = 4,
};

enum s3c24xx_port_type {
	TYPE_S3C6400 = 0,
	TYPE_APPLE_S5L = 1,
};

enum s5m8767_dvs_buck_ramp_values {
	S5M8767_DVS_BUCK_RAMP_5 = 4,
	S5M8767_DVS_BUCK_RAMP_10 = 9,
	S5M8767_DVS_BUCK_RAMP_12_5 = 11,
	S5M8767_DVS_BUCK_RAMP_25 = 13,
	S5M8767_DVS_BUCK_RAMP_50 = 14,
	S5M8767_DVS_BUCK_RAMP_100 = 15,
};

enum s5m8767_irq {
	S5M8767_IRQ_PWRR = 0,
	S5M8767_IRQ_PWRF = 1,
	S5M8767_IRQ_PWR1S = 2,
	S5M8767_IRQ_JIGR = 3,
	S5M8767_IRQ_JIGF = 4,
	S5M8767_IRQ_LOWBAT2 = 5,
	S5M8767_IRQ_LOWBAT1 = 6,
	S5M8767_IRQ_MRB = 7,
	S5M8767_IRQ_DVSOK2 = 8,
	S5M8767_IRQ_DVSOK3 = 9,
	S5M8767_IRQ_DVSOK4 = 10,
	S5M8767_IRQ_RTC60S = 11,
	S5M8767_IRQ_RTCA1 = 12,
	S5M8767_IRQ_RTCA2 = 13,
	S5M8767_IRQ_SMPL = 14,
	S5M8767_IRQ_RTC1S = 15,
	S5M8767_IRQ_WTSR = 16,
	S5M8767_IRQ_NR = 17,
};

enum s5m8767_reg {
	S5M8767_REG_ID = 0,
	S5M8767_REG_INT1 = 1,
	S5M8767_REG_INT2 = 2,
	S5M8767_REG_INT3 = 3,
	S5M8767_REG_INT1M = 4,
	S5M8767_REG_INT2M = 5,
	S5M8767_REG_INT3M = 6,
	S5M8767_REG_STATUS1 = 7,
	S5M8767_REG_STATUS2 = 8,
	S5M8767_REG_STATUS3 = 9,
	S5M8767_REG_CTRL1 = 10,
	S5M8767_REG_CTRL2 = 11,
	S5M8767_REG_LOWBAT1 = 12,
	S5M8767_REG_LOWBAT2 = 13,
	S5M8767_REG_BUCHG = 14,
	S5M8767_REG_DVSRAMP = 15,
	S5M8767_REG_DVSTIMER2 = 16,
	S5M8767_REG_DVSTIMER3 = 17,
	S5M8767_REG_DVSTIMER4 = 18,
	S5M8767_REG_LDO1 = 19,
	S5M8767_REG_LDO2 = 20,
	S5M8767_REG_LDO3 = 21,
	S5M8767_REG_LDO4 = 22,
	S5M8767_REG_LDO5 = 23,
	S5M8767_REG_LDO6 = 24,
	S5M8767_REG_LDO7 = 25,
	S5M8767_REG_LDO8 = 26,
	S5M8767_REG_LDO9 = 27,
	S5M8767_REG_LDO10 = 28,
	S5M8767_REG_LDO11 = 29,
	S5M8767_REG_LDO12 = 30,
	S5M8767_REG_LDO13 = 31,
	S5M8767_REG_LDO14 = 32,
	S5M8767_REG_LDO15 = 33,
	S5M8767_REG_LDO16 = 34,
	S5M8767_REG_LDO17 = 35,
	S5M8767_REG_LDO18 = 36,
	S5M8767_REG_LDO19 = 37,
	S5M8767_REG_LDO20 = 38,
	S5M8767_REG_LDO21 = 39,
	S5M8767_REG_LDO22 = 40,
	S5M8767_REG_LDO23 = 41,
	S5M8767_REG_LDO24 = 42,
	S5M8767_REG_LDO25 = 43,
	S5M8767_REG_LDO26 = 44,
	S5M8767_REG_LDO27 = 45,
	S5M8767_REG_LDO28 = 46,
	S5M8767_REG_UVLO = 49,
	S5M8767_REG_BUCK1CTRL1 = 50,
	S5M8767_REG_BUCK1CTRL2 = 51,
	S5M8767_REG_BUCK2CTRL = 52,
	S5M8767_REG_BUCK2DVS1 = 53,
	S5M8767_REG_BUCK2DVS2 = 54,
	S5M8767_REG_BUCK2DVS3 = 55,
	S5M8767_REG_BUCK2DVS4 = 56,
	S5M8767_REG_BUCK2DVS5 = 57,
	S5M8767_REG_BUCK2DVS6 = 58,
	S5M8767_REG_BUCK2DVS7 = 59,
	S5M8767_REG_BUCK2DVS8 = 60,
	S5M8767_REG_BUCK3CTRL = 61,
	S5M8767_REG_BUCK3DVS1 = 62,
	S5M8767_REG_BUCK3DVS2 = 63,
	S5M8767_REG_BUCK3DVS3 = 64,
	S5M8767_REG_BUCK3DVS4 = 65,
	S5M8767_REG_BUCK3DVS5 = 66,
	S5M8767_REG_BUCK3DVS6 = 67,
	S5M8767_REG_BUCK3DVS7 = 68,
	S5M8767_REG_BUCK3DVS8 = 69,
	S5M8767_REG_BUCK4CTRL = 70,
	S5M8767_REG_BUCK4DVS1 = 71,
	S5M8767_REG_BUCK4DVS2 = 72,
	S5M8767_REG_BUCK4DVS3 = 73,
	S5M8767_REG_BUCK4DVS4 = 74,
	S5M8767_REG_BUCK4DVS5 = 75,
	S5M8767_REG_BUCK4DVS6 = 76,
	S5M8767_REG_BUCK4DVS7 = 77,
	S5M8767_REG_BUCK4DVS8 = 78,
	S5M8767_REG_BUCK5CTRL1 = 79,
	S5M8767_REG_BUCK5CTRL2 = 80,
	S5M8767_REG_BUCK5CTRL3 = 81,
	S5M8767_REG_BUCK5CTRL4 = 82,
	S5M8767_REG_BUCK5CTRL5 = 83,
	S5M8767_REG_BUCK6CTRL1 = 84,
	S5M8767_REG_BUCK6CTRL2 = 85,
	S5M8767_REG_BUCK7CTRL1 = 86,
	S5M8767_REG_BUCK7CTRL2 = 87,
	S5M8767_REG_BUCK8CTRL1 = 88,
	S5M8767_REG_BUCK8CTRL2 = 89,
	S5M8767_REG_BUCK9CTRL1 = 90,
	S5M8767_REG_BUCK9CTRL2 = 91,
	S5M8767_REG_LDO1CTRL = 92,
	S5M8767_REG_LDO2_1CTRL = 93,
	S5M8767_REG_LDO2_2CTRL = 94,
	S5M8767_REG_LDO2_3CTRL = 95,
	S5M8767_REG_LDO2_4CTRL = 96,
	S5M8767_REG_LDO3CTRL = 97,
	S5M8767_REG_LDO4CTRL = 98,
	S5M8767_REG_LDO5CTRL = 99,
	S5M8767_REG_LDO6CTRL = 100,
	S5M8767_REG_LDO7CTRL = 101,
	S5M8767_REG_LDO8CTRL = 102,
	S5M8767_REG_LDO9CTRL = 103,
	S5M8767_REG_LDO10CTRL = 104,
	S5M8767_REG_LDO11CTRL = 105,
	S5M8767_REG_LDO12CTRL = 106,
	S5M8767_REG_LDO13CTRL = 107,
	S5M8767_REG_LDO14CTRL = 108,
	S5M8767_REG_LDO15CTRL = 109,
	S5M8767_REG_LDO16CTRL = 110,
	S5M8767_REG_LDO17CTRL = 111,
	S5M8767_REG_LDO18CTRL = 112,
	S5M8767_REG_LDO19CTRL = 113,
	S5M8767_REG_LDO20CTRL = 114,
	S5M8767_REG_LDO21CTRL = 115,
	S5M8767_REG_LDO22CTRL = 116,
	S5M8767_REG_LDO23CTRL = 117,
	S5M8767_REG_LDO24CTRL = 118,
	S5M8767_REG_LDO25CTRL = 119,
	S5M8767_REG_LDO26CTRL = 120,
	S5M8767_REG_LDO27CTRL = 121,
	S5M8767_REG_LDO28CTRL = 122,
};

enum s5m8767_regulators {
	S5M8767_LDO1 = 0,
	S5M8767_LDO2 = 1,
	S5M8767_LDO3 = 2,
	S5M8767_LDO4 = 3,
	S5M8767_LDO5 = 4,
	S5M8767_LDO6 = 5,
	S5M8767_LDO7 = 6,
	S5M8767_LDO8 = 7,
	S5M8767_LDO9 = 8,
	S5M8767_LDO10 = 9,
	S5M8767_LDO11 = 10,
	S5M8767_LDO12 = 11,
	S5M8767_LDO13 = 12,
	S5M8767_LDO14 = 13,
	S5M8767_LDO15 = 14,
	S5M8767_LDO16 = 15,
	S5M8767_LDO17 = 16,
	S5M8767_LDO18 = 17,
	S5M8767_LDO19 = 18,
	S5M8767_LDO20 = 19,
	S5M8767_LDO21 = 20,
	S5M8767_LDO22 = 21,
	S5M8767_LDO23 = 22,
	S5M8767_LDO24 = 23,
	S5M8767_LDO25 = 24,
	S5M8767_LDO26 = 25,
	S5M8767_LDO27 = 26,
	S5M8767_LDO28 = 27,
	S5M8767_BUCK1 = 28,
	S5M8767_BUCK2 = 29,
	S5M8767_BUCK3 = 30,
	S5M8767_BUCK4 = 31,
	S5M8767_BUCK5 = 32,
	S5M8767_BUCK6 = 33,
	S5M8767_BUCK7 = 34,
	S5M8767_BUCK8 = 35,
	S5M8767_BUCK9 = 36,
	S5M8767_AP_EN32KHZ = 37,
	S5M8767_CP_EN32KHZ = 38,
	S5M8767_REG_MAX = 39,
};

enum s_alloc {
	sa_rootdomain = 0,
	sa_sd = 1,
	sa_sd_storage = 2,
	sa_none = 3,
};

enum sacle_up_mode {
	SCALE_UP_BIL = 0,
	SCALE_UP_BIC = 1,
};

enum sam_status {
	SAM_STAT_GOOD = 0,
	SAM_STAT_CHECK_CONDITION = 2,
	SAM_STAT_CONDITION_MET = 4,
	SAM_STAT_BUSY = 8,
	SAM_STAT_INTERMEDIATE = 16,
	SAM_STAT_INTERMEDIATE_CONDITION_MET = 20,
	SAM_STAT_RESERVATION_CONFLICT = 24,
	SAM_STAT_COMMAND_TERMINATED = 34,
	SAM_STAT_TASK_SET_FULL = 40,
	SAM_STAT_ACA_ACTIVE = 48,
	SAM_STAT_TASK_ABORTED = 64,
};

enum samsung_dsim_type {
	DSIM_TYPE_EXYNOS3250 = 0,
	DSIM_TYPE_EXYNOS4210 = 1,
	DSIM_TYPE_EXYNOS5410 = 2,
	DSIM_TYPE_EXYNOS5422 = 3,
	DSIM_TYPE_EXYNOS5433 = 4,
	DSIM_TYPE_IMX8MM = 5,
	DSIM_TYPE_IMX8MP = 6,
	DSIM_TYPE_COUNT = 7,
};

enum samsung_keypad_type {
	KEYPAD_TYPE_SAMSUNG = 0,
	KEYPAD_TYPE_S5PV210 = 1,
};

enum samsung_pll_type {
	pll_2126 = 0,
	pll_3000 = 1,
	pll_35xx = 2,
	pll_36xx = 3,
	pll_2550 = 4,
	pll_2650 = 5,
	pll_4500 = 6,
	pll_4502 = 7,
	pll_4508 = 8,
	pll_4600 = 9,
	pll_4650 = 10,
	pll_4650c = 11,
	pll_6552 = 12,
	pll_6552_s3c2416 = 13,
	pll_6553 = 14,
	pll_2550x = 15,
	pll_2550xx = 16,
	pll_2650x = 17,
	pll_2650xx = 18,
	pll_1417x = 19,
	pll_1418x = 20,
	pll_1450x = 21,
	pll_1451x = 22,
	pll_1452x = 23,
	pll_1460x = 24,
	pll_0818x = 25,
	pll_0822x = 26,
	pll_0831x = 27,
	pll_142xx = 28,
	pll_0516x = 29,
	pll_0517x = 30,
	pll_0518x = 31,
	pll_531x = 32,
	pll_1051x = 33,
	pll_1052x = 34,
	pll_0717x = 35,
	pll_0718x = 36,
	pll_0732x = 37,
	pll_4311 = 38,
};

enum scale_down_mode {
	SCALE_DOWN_BIL = 0,
	SCALE_DOWN_AVG = 1,
};

enum scale_freq_source {
	SCALE_FREQ_SOURCE_CPUFREQ = 0,
	SCALE_FREQ_SOURCE_ARCH = 1,
	SCALE_FREQ_SOURCE_CPPC = 2,
	SCALE_FREQ_SOURCE_VIRT = 3,
};

enum scale_mode {
	SCALE_NONE = 0,
	SCALE_UP = 1,
	SCALE_DOWN = 2,
};

enum scan_balance {
	SCAN_EQUAL = 0,
	SCAN_FRACT = 1,
	SCAN_ANON = 2,
	SCAN_FILE = 3,
};

enum sched_tunable_scaling {
	SCHED_TUNABLESCALING_NONE = 0,
	SCHED_TUNABLESCALING_LOG = 1,
	SCHED_TUNABLESCALING_LINEAR = 2,
	SCHED_TUNABLESCALING_END = 3,
};

enum scmi_bad_msg {
	MSG_UNEXPECTED = -1,
	MSG_INVALID = -2,
	MSG_UNKNOWN = -3,
	MSG_NOMEM = -4,
	MSG_MBOX_SPURIOUS = -5,
};

enum scmi_base_protocol_cmd {
	BASE_DISCOVER_VENDOR = 3,
	BASE_DISCOVER_SUB_VENDOR = 4,
	BASE_DISCOVER_IMPLEMENT_VERSION = 5,
	BASE_DISCOVER_LIST_PROTOCOLS = 6,
	BASE_DISCOVER_AGENT = 7,
	BASE_NOTIFY_ERRORS = 8,
	BASE_SET_DEVICE_PERMISSIONS = 9,
	BASE_SET_PROTOCOL_PERMISSIONS = 10,
	BASE_RESET_AGENT_CONFIGURATION = 11,
};

enum scmi_clk_feats {
	SCMI_CLK_ATOMIC_SUPPORTED = 0,
	SCMI_CLK_STATE_CTRL_SUPPORTED = 1,
	SCMI_CLK_RATE_CTRL_SUPPORTED = 2,
	SCMI_CLK_PARENT_CTRL_SUPPORTED = 3,
	SCMI_CLK_DUTY_CYCLE_SUPPORTED = 4,
	SCMI_CLK_FEATS_COUNT = 5,
};

enum scmi_clock_oem_config {
	SCMI_CLOCK_CFG_DUTY_CYCLE = 1,
	SCMI_CLOCK_CFG_PHASE = 2,
	SCMI_CLOCK_CFG_OEM_START = 128,
	SCMI_CLOCK_CFG_OEM_END = 255,
};

enum scmi_clock_protocol_cmd {
	CLOCK_ATTRIBUTES = 3,
	CLOCK_DESCRIBE_RATES = 4,
	CLOCK_RATE_SET = 5,
	CLOCK_RATE_GET = 6,
	CLOCK_CONFIG_SET = 7,
	CLOCK_NAME_GET = 8,
	CLOCK_RATE_NOTIFY = 9,
	CLOCK_RATE_CHANGE_REQUESTED_NOTIFY = 10,
	CLOCK_CONFIG_GET = 11,
	CLOCK_POSSIBLE_PARENTS_GET = 12,
	CLOCK_PARENT_SET = 13,
	CLOCK_PARENT_GET = 14,
	CLOCK_GET_PERMISSIONS = 15,
};

enum scmi_common_cmd {
	PROTOCOL_VERSION = 0,
	PROTOCOL_ATTRIBUTES = 1,
	PROTOCOL_MESSAGE_ATTRIBUTES = 2,
	NEGOTIATE_PROTOCOL_VERSION = 16,
};

enum scmi_error_codes {
	SCMI_SUCCESS = 0,
	SCMI_ERR_SUPPORT = -1,
	SCMI_ERR_PARAMS = -2,
	SCMI_ERR_ACCESS = -3,
	SCMI_ERR_ENTRY = -4,
	SCMI_ERR_RANGE = -5,
	SCMI_ERR_BUSY = -6,
	SCMI_ERR_COMMS = -7,
	SCMI_ERR_GENERIC = -8,
	SCMI_ERR_HARDWARE = -9,
	SCMI_ERR_PROTOCOL = -10,
};

enum scmi_imx_bbm_protocol_cmd {
	IMX_BBM_GPR_SET = 3,
	IMX_BBM_GPR_GET = 4,
	IMX_BBM_RTC_ATTRIBUTES = 5,
	IMX_BBM_RTC_TIME_SET = 6,
	IMX_BBM_RTC_TIME_GET = 7,
	IMX_BBM_RTC_ALARM_SET = 8,
	IMX_BBM_BUTTON_GET = 9,
	IMX_BBM_RTC_NOTIFY = 10,
	IMX_BBM_BUTTON_NOTIFY = 11,
};

enum scmi_imx_cpu_protocol_cmd {
	SCMI_IMX_CPU_ATTRIBUTES = 3,
	SCMI_IMX_CPU_START = 4,
	SCMI_IMX_CPU_STOP = 5,
	SCMI_IMX_CPU_RESET_VECTOR_SET = 6,
	SCMI_IMX_CPU_INFO_GET = 12,
};

enum scmi_imx_lmm_op {
	SCMI_IMX_LMM_BOOT = 0,
	SCMI_IMX_LMM_POWER_ON = 1,
	SCMI_IMX_LMM_SHUTDOWN = 2,
};

enum scmi_imx_lmm_protocol_cmd {
	SCMI_IMX_LMM_ATTRIBUTES = 3,
	SCMI_IMX_LMM_BOOT___2 = 4,
	SCMI_IMX_LMM_RESET = 5,
	SCMI_IMX_LMM_SHUTDOWN___2 = 6,
	SCMI_IMX_LMM_WAKE = 7,
	SCMI_IMX_LMM_SUSPEND = 8,
	SCMI_IMX_LMM_NOTIFY = 9,
	SCMI_IMX_LMM_RESET_REASON = 10,
	SCMI_IMX_LMM_POWER_ON___2 = 11,
	SCMI_IMX_LMM_RESET_VECTOR_SET = 12,
};

enum scmi_imx_lmm_state {
	LMM_STATE_LM_OFF = 0,
	LMM_STATE_LM_ON = 1,
	LMM_STATE_LM_SUSPEND = 2,
	LMM_STATE_LM_POWERED = 3,
};

enum scmi_imx_misc_protocol_cmd {
	SCMI_IMX_MISC_CTRL_SET = 3,
	SCMI_IMX_MISC_CTRL_GET = 4,
	SCMI_IMX_MISC_CTRL_NOTIFY = 8,
};

enum scmi_notification_events {
	SCMI_EVENT_POWER_STATE_CHANGED = 0,
	SCMI_EVENT_CLOCK_RATE_CHANGED = 0,
	SCMI_EVENT_CLOCK_RATE_CHANGE_REQUESTED = 1,
	SCMI_EVENT_PERFORMANCE_LIMITS_CHANGED = 0,
	SCMI_EVENT_PERFORMANCE_LEVEL_CHANGED = 1,
	SCMI_EVENT_SENSOR_TRIP_POINT_EVENT = 0,
	SCMI_EVENT_SENSOR_UPDATE = 1,
	SCMI_EVENT_RESET_ISSUED = 0,
	SCMI_EVENT_BASE_ERROR_EVENT = 0,
	SCMI_EVENT_SYSTEM_POWER_STATE_NOTIFIER = 0,
	SCMI_EVENT_POWERCAP_CAP_CHANGED = 0,
	SCMI_EVENT_POWERCAP_MEASUREMENTS_CHANGED = 1,
};

enum scmi_nxp_notification_events {
	SCMI_EVENT_IMX_BBM_RTC = 0,
	SCMI_EVENT_IMX_BBM_BUTTON = 1,
	SCMI_EVENT_IMX_MISC_CONTROL = 0,
};

enum scmi_performance_protocol_cmd {
	PERF_DOMAIN_ATTRIBUTES = 3,
	PERF_DESCRIBE_LEVELS = 4,
	PERF_LIMITS_SET = 5,
	PERF_LIMITS_GET = 6,
	PERF_LEVEL_SET = 7,
	PERF_LEVEL_GET = 8,
	PERF_NOTIFY_LIMITS = 9,
	PERF_NOTIFY_LEVEL = 10,
	PERF_DESCRIBE_FASTCHANNEL = 11,
	PERF_DOMAIN_NAME_GET = 12,
};

enum scmi_pinctrl_conf_type {
	SCMI_PIN_DEFAULT = 0,
	SCMI_PIN_BIAS_BUS_HOLD = 1,
	SCMI_PIN_BIAS_DISABLE = 2,
	SCMI_PIN_BIAS_HIGH_IMPEDANCE = 3,
	SCMI_PIN_BIAS_PULL_UP = 4,
	SCMI_PIN_BIAS_PULL_DEFAULT = 5,
	SCMI_PIN_BIAS_PULL_DOWN = 6,
	SCMI_PIN_DRIVE_OPEN_DRAIN = 7,
	SCMI_PIN_DRIVE_OPEN_SOURCE = 8,
	SCMI_PIN_DRIVE_PUSH_PULL = 9,
	SCMI_PIN_DRIVE_STRENGTH = 10,
	SCMI_PIN_INPUT_DEBOUNCE = 11,
	SCMI_PIN_INPUT_MODE = 12,
	SCMI_PIN_PULL_MODE = 13,
	SCMI_PIN_INPUT_VALUE = 14,
	SCMI_PIN_INPUT_SCHMITT = 15,
	SCMI_PIN_LOW_POWER_MODE = 16,
	SCMI_PIN_OUTPUT_MODE = 17,
	SCMI_PIN_OUTPUT_VALUE = 18,
	SCMI_PIN_POWER_SOURCE = 19,
	SCMI_PIN_SLEW_RATE = 20,
	SCMI_PIN_OEM_START = 192,
	SCMI_PIN_OEM_END = 255,
};

enum scmi_pinctrl_protocol_cmd {
	PINCTRL_ATTRIBUTES = 3,
	PINCTRL_LIST_ASSOCIATIONS = 4,
	PINCTRL_SETTINGS_GET = 5,
	PINCTRL_SETTINGS_CONFIGURE = 6,
	PINCTRL_REQUEST = 7,
	PINCTRL_RELEASE = 8,
	PINCTRL_NAME_GET = 9,
	PINCTRL_SET_PERMISSIONS = 10,
};

enum scmi_pinctrl_selector_type {
	PIN_TYPE = 0,
	GROUP_TYPE = 1,
	FUNCTION_TYPE = 2,
};

enum scmi_power_protocol_cmd {
	POWER_DOMAIN_ATTRIBUTES = 3,
	POWER_STATE_SET = 4,
	POWER_STATE_GET = 5,
	POWER_STATE_NOTIFY = 6,
	POWER_DOMAIN_NAME_GET = 8,
};

enum scmi_power_scale {
	SCMI_POWER_BOGOWATTS = 0,
	SCMI_POWER_MILLIWATTS = 1,
	SCMI_POWER_MICROWATTS = 2,
};

enum scmi_powercap_protocol_cmd {
	POWERCAP_DOMAIN_ATTRIBUTES = 3,
	POWERCAP_CAP_GET = 4,
	POWERCAP_CAP_SET = 5,
	POWERCAP_PAI_GET = 6,
	POWERCAP_PAI_SET = 7,
	POWERCAP_DOMAIN_NAME_GET = 8,
	POWERCAP_MEASUREMENTS_GET = 9,
	POWERCAP_CAP_NOTIFY = 10,
	POWERCAP_MEASUREMENTS_NOTIFY = 11,
	POWERCAP_DESCRIBE_FASTCHANNEL = 12,
};

enum scmi_reset_protocol_cmd {
	RESET_DOMAIN_ATTRIBUTES = 3,
	RESET = 4,
	RESET_NOTIFY = 5,
	RESET_DOMAIN_NAME_GET = 6,
};

enum scmi_sensor_class {
	NONE = 0,
	UNSPEC = 1,
	TEMPERATURE_C = 2,
	TEMPERATURE_F = 3,
	TEMPERATURE_K = 4,
	VOLTAGE = 5,
	CURRENT = 6,
	POWER = 7,
	ENERGY = 8,
	CHARGE = 9,
	VOLTAMPERE = 10,
	NITS = 11,
	LUMENS = 12,
	LUX = 13,
	CANDELAS = 14,
	KPA = 15,
	PSI = 16,
	NEWTON = 17,
	CFM = 18,
	RPM = 19,
	HERTZ = 20,
	SECS = 21,
	MINS = 22,
	HOURS = 23,
	DAYS = 24,
	WEEKS = 25,
	MILS = 26,
	INCHES = 27,
	FEET = 28,
	CUBIC_INCHES = 29,
	CUBIC_FEET = 30,
	METERS = 31,
	CUBIC_CM = 32,
	CUBIC_METERS = 33,
	LITERS = 34,
	FLUID_OUNCES = 35,
	RADIANS = 36,
	STERADIANS = 37,
	REVOLUTIONS = 38,
	CYCLES = 39,
	GRAVITIES = 40,
	OUNCES = 41,
	POUNDS = 42,
	FOOT_POUNDS = 43,
	OUNCE_INCHES = 44,
	GAUSS = 45,
	GILBERTS = 46,
	HENRIES = 47,
	FARADS = 48,
	OHMS = 49,
	SIEMENS = 50,
	MOLES = 51,
	BECQUERELS = 52,
	PPM = 53,
	DECIBELS = 54,
	DBA = 55,
	DBC = 56,
	GRAYS = 57,
	SIEVERTS = 58,
	COLOR_TEMP_K = 59,
	BITS = 60,
	BYTES = 61,
	WORDS = 62,
	DWORDS = 63,
	QWORDS = 64,
	PERCENTAGE = 65,
	PASCALS = 66,
	COUNTS = 67,
	GRAMS = 68,
	NEWTON_METERS = 69,
	HITS = 70,
	MISSES = 71,
	RETRIES = 72,
	OVERRUNS = 73,
	UNDERRUNS = 74,
	COLLISIONS = 75,
	PACKETS = 76,
	MESSAGES = 77,
	CHARS = 78,
	ERRORS = 79,
	CORRECTED_ERRS = 80,
	UNCORRECTABLE_ERRS = 81,
	SQ_MILS = 82,
	SQ_INCHES = 83,
	SQ_FEET = 84,
	SQ_CM = 85,
	SQ_METERS = 86,
	RADIANS_SEC = 87,
	BPM = 88,
	METERS_SEC_SQUARED = 89,
	METERS_SEC = 90,
	CUBIC_METERS_SEC = 91,
	MM_MERCURY = 92,
	RADIANS_SEC_SQUARED = 93,
	OEM_UNIT = 255,
};

enum scmi_sensor_protocol_cmd {
	SENSOR_DESCRIPTION_GET = 3,
	SENSOR_TRIP_POINT_NOTIFY = 4,
	SENSOR_TRIP_POINT_CONFIG = 5,
	SENSOR_READING_GET = 6,
	SENSOR_AXIS_DESCRIPTION_GET = 7,
	SENSOR_LIST_UPDATE_INTERVALS = 8,
	SENSOR_CONFIG_GET = 9,
	SENSOR_CONFIG_SET = 10,
	SENSOR_CONTINUOUS_UPDATE_NOTIFY = 11,
	SENSOR_NAME_GET = 12,
	SENSOR_AXIS_NAME_GET = 13,
};

enum scmi_std_protocol {
	SCMI_PROTOCOL_BASE = 16,
	SCMI_PROTOCOL_POWER = 17,
	SCMI_PROTOCOL_SYSTEM = 18,
	SCMI_PROTOCOL_PERF = 19,
	SCMI_PROTOCOL_CLOCK = 20,
	SCMI_PROTOCOL_SENSOR = 21,
	SCMI_PROTOCOL_RESET = 22,
	SCMI_PROTOCOL_VOLTAGE = 23,
	SCMI_PROTOCOL_POWERCAP = 24,
	SCMI_PROTOCOL_PINCTRL = 25,
};

enum scmi_system_events {
	SCMI_SYSTEM_SHUTDOWN = 0,
	SCMI_SYSTEM_COLDRESET = 1,
	SCMI_SYSTEM_WARMRESET = 2,
	SCMI_SYSTEM_POWERUP = 3,
	SCMI_SYSTEM_SUSPEND = 4,
	SCMI_SYSTEM_MAX = 5,
};

enum scmi_system_protocol_cmd {
	SYSTEM_POWER_STATE_NOTIFY = 5,
};

enum scmi_voltage_level_mode {
	SCMI_VOLTAGE_LEVEL_SET_AUTO = 0,
	SCMI_VOLTAGE_LEVEL_SET_SYNC = 1,
};

enum scmi_voltage_protocol_cmd {
	VOLTAGE_DOMAIN_ATTRIBUTES = 3,
	VOLTAGE_DESCRIBE_LEVELS = 4,
	VOLTAGE_CONFIG_SET = 5,
	VOLTAGE_CONFIG_GET = 6,
	VOLTAGE_LEVEL_SET = 7,
	VOLTAGE_LEVEL_GET = 8,
	VOLTAGE_DOMAIN_NAME_GET = 9,
};

enum scrub_stripe_flags {
	SCRUB_STRIPE_FLAG_INITIALIZED = 0,
	SCRUB_STRIPE_FLAG_REPAIR_DONE = 1,
	SCRUB_STRIPE_FLAG_NO_REPORT = 2,
};

enum scrub_type {
	SCRUB_UNKNOWN = 0,
	SCRUB_NONE = 1,
	SCRUB_SW_PROG = 2,
	SCRUB_SW_SRC = 3,
	SCRUB_SW_PROG_SRC = 4,
	SCRUB_SW_TUNABLE = 5,
	SCRUB_HW_PROG = 6,
	SCRUB_HW_SRC = 7,
	SCRUB_HW_PROG_SRC = 8,
	SCRUB_HW_TUNABLE = 9,
};

enum scsi_cmnd_submitter {
	SUBMITTED_BY_BLOCK_LAYER = 0,
	SUBMITTED_BY_SCSI_ERROR_HANDLER = 1,
	SUBMITTED_BY_SCSI_RESET_IOCTL = 2,
} __attribute__((mode(byte)));

enum scsi_device_event {
	SDEV_EVT_MEDIA_CHANGE = 1,
	SDEV_EVT_INQUIRY_CHANGE_REPORTED = 2,
	SDEV_EVT_CAPACITY_CHANGE_REPORTED = 3,
	SDEV_EVT_SOFT_THRESHOLD_REACHED_REPORTED = 4,
	SDEV_EVT_MODE_PARAMETER_CHANGE_REPORTED = 5,
	SDEV_EVT_LUN_CHANGE_REPORTED = 6,
	SDEV_EVT_ALUA_STATE_CHANGE_REPORTED = 7,
	SDEV_EVT_POWER_ON_RESET_OCCURRED = 8,
	SDEV_EVT_FIRST = 1,
	SDEV_EVT_LAST = 8,
	SDEV_EVT_MAXBITS = 9,
};

enum scsi_device_state {
	SDEV_CREATED = 1,
	SDEV_RUNNING = 2,
	SDEV_CANCEL = 3,
	SDEV_DEL = 4,
	SDEV_QUIESCE = 5,
	SDEV_OFFLINE = 6,
	SDEV_TRANSPORT_OFFLINE = 7,
	SDEV_BLOCK = 8,
	SDEV_CREATED_BLOCK = 9,
};

enum scsi_devinfo_key {
	SCSI_DEVINFO_GLOBAL = 0,
	SCSI_DEVINFO_SPI = 1,
};

enum scsi_disposition {
	NEEDS_RETRY = 8193,
	SUCCESS = 8194,
	FAILED___2 = 8195,
	QUEUED = 8196,
	SOFT_ERROR = 8197,
	ADD_TO_MLQUEUE = 8198,
	TIMEOUT_ERROR = 8199,
	SCSI_RETURN_NOT_HANDLED = 8200,
	FAST_IO_FAIL = 8201,
};

enum scsi_host_guard_type {
	SHOST_DIX_GUARD_CRC = 1,
	SHOST_DIX_GUARD_IP = 2,
};

enum scsi_host_prot_capabilities {
	SHOST_DIF_TYPE1_PROTECTION = 1,
	SHOST_DIF_TYPE2_PROTECTION = 2,
	SHOST_DIF_TYPE3_PROTECTION = 4,
	SHOST_DIX_TYPE0_PROTECTION = 8,
	SHOST_DIX_TYPE1_PROTECTION = 16,
	SHOST_DIX_TYPE2_PROTECTION = 32,
	SHOST_DIX_TYPE3_PROTECTION = 64,
};

enum scsi_host_state {
	SHOST_CREATED = 1,
	SHOST_RUNNING = 2,
	SHOST_CANCEL = 3,
	SHOST_DEL = 4,
	SHOST_RECOVERY = 5,
	SHOST_CANCEL_RECOVERY = 6,
	SHOST_DEL_RECOVERY = 7,
};

enum scsi_host_status {
	DID_OK = 0,
	DID_NO_CONNECT = 1,
	DID_BUS_BUSY = 2,
	DID_TIME_OUT = 3,
	DID_BAD_TARGET = 4,
	DID_ABORT = 5,
	DID_PARITY = 6,
	DID_ERROR = 7,
	DID_RESET = 8,
	DID_BAD_INTR = 9,
	DID_PASSTHROUGH = 10,
	DID_SOFT_ERROR = 11,
	DID_IMM_RETRY = 12,
	DID_REQUEUE = 13,
	DID_TRANSPORT_DISRUPTED = 14,
	DID_TRANSPORT_FAILFAST = 15,
	DID_TRANSPORT_MARGINAL = 20,
};

enum scsi_ml_status {
	SCSIML_STAT_OK = 0,
	SCSIML_STAT_RESV_CONFLICT = 1,
	SCSIML_STAT_NOSPC = 2,
	SCSIML_STAT_MED_ERROR = 3,
	SCSIML_STAT_TGT_FAILURE = 4,
	SCSIML_STAT_DL_TIMEOUT = 5,
};

enum scsi_msg_byte {
	COMMAND_COMPLETE = 0,
	EXTENDED_MESSAGE = 1,
	SAVE_POINTERS = 2,
	RESTORE_POINTERS = 3,
	DISCONNECT = 4,
	INITIATOR_ERROR = 5,
	ABORT_TASK_SET = 6,
	MESSAGE_REJECT = 7,
	NOP = 8,
	MSG_PARITY_ERROR = 9,
	LINKED_CMD_COMPLETE = 10,
	LINKED_FLG_CMD_COMPLETE = 11,
	TARGET_RESET = 12,
	ABORT_TASK = 13,
	CLEAR_TASK_SET = 14,
	INITIATE_RECOVERY = 15,
	RELEASE_RECOVERY = 16,
	TERMINATE_IO_PROC = 17,
	CLEAR_ACA = 22,
	LOGICAL_UNIT_RESET = 23,
	SIMPLE_QUEUE_TAG = 32,
	HEAD_OF_QUEUE_TAG = 33,
	ORDERED_QUEUE_TAG = 34,
	IGNORE_WIDE_RESIDUE = 35,
	ACA = 36,
	QAS_REQUEST = 85,
	BUS_DEVICE_RESET = 12,
	ABORT = 6,
};

enum scsi_pr_type {
	SCSI_PR_WRITE_EXCLUSIVE = 1,
	SCSI_PR_EXCLUSIVE_ACCESS = 3,
	SCSI_PR_WRITE_EXCLUSIVE_REG_ONLY = 5,
	SCSI_PR_EXCLUSIVE_ACCESS_REG_ONLY = 6,
	SCSI_PR_WRITE_EXCLUSIVE_ALL_REGS = 7,
	SCSI_PR_EXCLUSIVE_ACCESS_ALL_REGS = 8,
};

enum scsi_prot_flags {
	SCSI_PROT_TRANSFER_PI = 1,
	SCSI_PROT_GUARD_CHECK = 2,
	SCSI_PROT_REF_CHECK = 4,
	SCSI_PROT_REF_INCREMENT = 8,
	SCSI_PROT_IP_CHECKSUM = 16,
};

enum scsi_prot_operations {
	SCSI_PROT_NORMAL = 0,
	SCSI_PROT_READ_INSERT = 1,
	SCSI_PROT_WRITE_STRIP = 2,
	SCSI_PROT_READ_STRIP = 3,
	SCSI_PROT_WRITE_INSERT = 4,
	SCSI_PROT_READ_PASS = 5,
	SCSI_PROT_WRITE_PASS = 6,
};

enum scsi_scan_mode {
	SCSI_SCAN_INITIAL = 0,
	SCSI_SCAN_RESCAN = 1,
	SCSI_SCAN_MANUAL = 2,
};

enum scsi_target_state {
	STARGET_CREATED = 1,
	STARGET_RUNNING = 2,
	STARGET_REMOVE = 3,
	STARGET_CREATED_REMOVE = 4,
	STARGET_DEL = 5,
};

enum scsi_timeout_action {
	SCSI_EH_DONE = 0,
	SCSI_EH_RESET_TIMER = 1,
	SCSI_EH_NOT_HANDLED = 2,
};

enum scsi_timeouts {
	SCSI_DEFAULT_EH_TIMEOUT = 2500,
};

enum scsi_vpd_parameters {
	SCSI_VPD_HEADER_SIZE = 4,
	SCSI_VPD_LIST_SIZE = 36,
};

enum sctp_conntrack {
	SCTP_CONNTRACK_NONE = 0,
	SCTP_CONNTRACK_CLOSED = 1,
	SCTP_CONNTRACK_COOKIE_WAIT = 2,
	SCTP_CONNTRACK_COOKIE_ECHOED = 3,
	SCTP_CONNTRACK_ESTABLISHED = 4,
	SCTP_CONNTRACK_SHUTDOWN_SENT = 5,
	SCTP_CONNTRACK_SHUTDOWN_RECD = 6,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT = 7,
	SCTP_CONNTRACK_HEARTBEAT_SENT = 8,
	SCTP_CONNTRACK_HEARTBEAT_ACKED = 9,
	SCTP_CONNTRACK_MAX = 10,
};

enum sctp_msg_flags {
	MSG_NOTIFICATION = 32768,
};

enum scx_consts {
	SCX_DSP_DFL_MAX_BATCH = 32,
	SCX_DSP_MAX_LOOPS = 32,
	SCX_WATCHDOG_MAX_TIMEOUT = 7500,
	SCX_EXIT_BT_LEN = 64,
	SCX_EXIT_MSG_LEN = 1024,
	SCX_EXIT_DUMP_DFL_LEN = 32768,
	SCX_CPUPERF_ONE = 1024,
	SCX_TASK_ITER_BATCH = 32,
};

enum scx_cpu_preempt_reason {
	SCX_CPU_PREEMPT_RT = 0,
	SCX_CPU_PREEMPT_DL = 1,
	SCX_CPU_PREEMPT_STOP = 2,
	SCX_CPU_PREEMPT_UNKNOWN = 3,
};

enum scx_deq_flags {
	SCX_DEQ_SLEEP = 1ULL,
	SCX_DEQ_CORE_SCHED_EXEC = 4294967296ULL,
};

enum scx_dsq_id_flags {
	SCX_DSQ_FLAG_BUILTIN = 9223372036854775808ULL,
	SCX_DSQ_FLAG_LOCAL_ON = 4611686018427387904ULL,
	SCX_DSQ_INVALID = 9223372036854775808ULL,
	SCX_DSQ_GLOBAL = 9223372036854775809ULL,
	SCX_DSQ_LOCAL = 9223372036854775810ULL,
	SCX_DSQ_LOCAL_ON = 13835058055282163712ULL,
	SCX_DSQ_LOCAL_CPU_MASK = 4294967295ULL,
};

enum scx_dsq_iter_flags {
	SCX_DSQ_ITER_REV = 65536,
	__SCX_DSQ_ITER_HAS_SLICE = 1073741824,
	__SCX_DSQ_ITER_HAS_VTIME = 2147483648,
	__SCX_DSQ_ITER_USER_FLAGS = 65536,
	__SCX_DSQ_ITER_ALL_FLAGS = 3221291008,
};

enum scx_dsq_lnode_flags {
	SCX_DSQ_LNODE_ITER_CURSOR = 1,
	__SCX_DSQ_LNODE_PRIV_SHIFT = 16,
};

enum scx_enable_state {
	SCX_ENABLING = 0,
	SCX_ENABLED = 1,
	SCX_DISABLING = 2,
	SCX_DISABLED = 3,
};

enum scx_enq_flags {
	SCX_ENQ_WAKEUP = 1ULL,
	SCX_ENQ_HEAD = 16ULL,
	SCX_ENQ_CPU_SELECTED = 1024ULL,
	SCX_ENQ_PREEMPT = 4294967296ULL,
	SCX_ENQ_REENQ = 1099511627776ULL,
	SCX_ENQ_LAST = 2199023255552ULL,
	__SCX_ENQ_INTERNAL_MASK = 18374686479671623680ULL,
	SCX_ENQ_CLEAR_OPSS = 72057594037927936ULL,
	SCX_ENQ_DSQ_PRIQ = 144115188075855872ULL,
};

enum scx_ent_dsq_flags {
	SCX_TASK_DSQ_ON_PRIQ = 1,
};

enum scx_ent_flags {
	SCX_TASK_QUEUED = 1,
	SCX_TASK_RESET_RUNNABLE_AT = 4,
	SCX_TASK_DEQD_FOR_SLEEP = 8,
	SCX_TASK_STATE_SHIFT = 8,
	SCX_TASK_STATE_BITS = 2,
	SCX_TASK_STATE_MASK = 768,
	SCX_TASK_CURSOR = -2147483648,
};

enum scx_exit_code {
	SCX_ECODE_RSN_HOTPLUG = 4294967296ULL,
	SCX_ECODE_ACT_RESTART = 281474976710656ULL,
};

enum scx_exit_kind {
	SCX_EXIT_NONE = 0,
	SCX_EXIT_DONE = 1,
	SCX_EXIT_UNREG = 64,
	SCX_EXIT_UNREG_BPF = 65,
	SCX_EXIT_UNREG_KERN = 66,
	SCX_EXIT_SYSRQ = 67,
	SCX_EXIT_ERROR = 1024,
	SCX_EXIT_ERROR_BPF = 1025,
	SCX_EXIT_ERROR_STALL = 1026,
};

enum scx_kf_mask {
	SCX_KF_UNLOCKED = 0,
	SCX_KF_CPU_RELEASE = 1,
	SCX_KF_DISPATCH = 2,
	SCX_KF_ENQUEUE = 4,
	SCX_KF_SELECT_CPU = 8,
	SCX_KF_REST = 16,
	__SCX_KF_RQ_LOCKED = 31,
	__SCX_KF_TERMINAL = 28,
};

enum scx_kick_flags {
	SCX_KICK_IDLE = 1,
	SCX_KICK_PREEMPT = 2,
	SCX_KICK_WAIT = 4,
};

enum scx_opi {
	SCX_OPI_BEGIN = 0,
	SCX_OPI_NORMAL_BEGIN = 0,
	SCX_OPI_NORMAL_END = 29,
	SCX_OPI_CPU_HOTPLUG_BEGIN = 29,
	SCX_OPI_CPU_HOTPLUG_END = 31,
	SCX_OPI_END = 31,
};

enum scx_ops_flags {
	SCX_OPS_KEEP_BUILTIN_IDLE = 1ULL,
	SCX_OPS_ENQ_LAST = 2ULL,
	SCX_OPS_ENQ_EXITING = 4ULL,
	SCX_OPS_SWITCH_PARTIAL = 8ULL,
	SCX_OPS_ENQ_MIGRATION_DISABLED = 16ULL,
	SCX_OPS_ALLOW_QUEUED_WAKEUP = 32ULL,
	SCX_OPS_BUILTIN_IDLE_PER_NODE = 64ULL,
	SCX_OPS_HAS_CGROUP_WEIGHT = 65536ULL,
	SCX_OPS_ALL_FLAGS = 65663ULL,
	__SCX_OPS_INTERNAL_MASK = 18374686479671623680ULL,
	SCX_OPS_HAS_CPU_PREEMPT = 72057594037927936ULL,
};

enum scx_ops_state {
	SCX_OPSS_NONE = 0,
	SCX_OPSS_QUEUEING = 1,
	SCX_OPSS_QUEUED = 2,
	SCX_OPSS_DISPATCHING = 3,
	SCX_OPSS_QSEQ_SHIFT = 2,
};

enum scx_pick_idle_cpu_flags {
	SCX_PICK_IDLE_CORE = 1,
	SCX_PICK_IDLE_IN_NODE = 2,
};

enum scx_public_consts {
	SCX_OPS_NAME_LEN = 128ULL,
	SCX_SLICE_DFL = 20000000ULL,
	SCX_SLICE_INF = 18446744073709551615ULL,
};

enum scx_rq_flags {
	SCX_RQ_ONLINE = 1,
	SCX_RQ_CAN_STOP_TICK = 2,
	SCX_RQ_BAL_PENDING = 4,
	SCX_RQ_BAL_KEEP = 8,
	SCX_RQ_BYPASSING = 16,
	SCX_RQ_CLK_VALID = 32,
	SCX_RQ_IN_WAKEUP = 65536,
	SCX_RQ_IN_BALANCE = 131072,
};

enum scx_task_state {
	SCX_TASK_NONE = 0,
	SCX_TASK_INIT = 1,
	SCX_TASK_READY = 2,
	SCX_TASK_ENABLED = 3,
	SCX_TASK_NR_STATES = 4,
};

enum scx_tg_flags {
	SCX_TG_ONLINE = 1,
	SCX_TG_INITED = 2,
};

enum scx_wake_flags {
	SCX_WAKE_FORK = 4,
	SCX_WAKE_TTWU = 8,
	SCX_WAKE_SYNC = 16,
};

enum sd_uhs2_operation {
	UHS2_PHY_INIT = 0,
	UHS2_SET_CONFIG = 1,
	UHS2_ENABLE_INT = 2,
	UHS2_DISABLE_INT = 3,
	UHS2_ENABLE_CLK = 4,
	UHS2_DISABLE_CLK = 5,
	UHS2_CHECK_DORMANT = 6,
	UHS2_SET_IOS = 7,
};

enum sdhci_cookie {
	COOKIE_UNMAPPED___2 = 0,
	COOKIE_PRE_MAPPED___2 = 1,
	COOKIE_MAPPED___2 = 2,
};

enum sdhci_reset_reason {
	SDHCI_RESET_FOR_INIT = 0,
	SDHCI_RESET_FOR_REQUEST_ERROR = 1,
	SDHCI_RESET_FOR_REQUEST_ERROR_DATA_ONLY = 2,
	SDHCI_RESET_FOR_TUNING_ABORT = 3,
	SDHCI_RESET_FOR_CARD_REMOVED = 4,
	SDHCI_RESET_FOR_CQE_RECOVERY = 5,
};

enum sdma_peripheral_type {
	IMX_DMATYPE_SSI = 0,
	IMX_DMATYPE_SSI_SP = 1,
	IMX_DMATYPE_MMC = 2,
	IMX_DMATYPE_SDHC = 3,
	IMX_DMATYPE_UART = 4,
	IMX_DMATYPE_UART_SP = 5,
	IMX_DMATYPE_FIRI = 6,
	IMX_DMATYPE_CSPI = 7,
	IMX_DMATYPE_CSPI_SP = 8,
	IMX_DMATYPE_SIM = 9,
	IMX_DMATYPE_ATA = 10,
	IMX_DMATYPE_CCM = 11,
	IMX_DMATYPE_EXT = 12,
	IMX_DMATYPE_MSHC = 13,
	IMX_DMATYPE_MSHC_SP = 14,
	IMX_DMATYPE_DSP = 15,
	IMX_DMATYPE_MEMORY = 16,
	IMX_DMATYPE_FIFO_MEMORY = 17,
	IMX_DMATYPE_SPDIF = 18,
	IMX_DMATYPE_IPU_MEMORY = 19,
	IMX_DMATYPE_ASRC = 20,
	IMX_DMATYPE_ESAI = 21,
	IMX_DMATYPE_SSI_DUAL = 22,
	IMX_DMATYPE_ASRC_SP = 23,
	IMX_DMATYPE_SAI = 24,
	IMX_DMATYPE_MULTI_SAI = 25,
	IMX_DMATYPE_HDMI = 26,
	IMX_DMATYPE_I2C = 27,
};

enum sec_device_type {
	S5M8767X = 0,
	S2DOS05 = 1,
	S2MPA01 = 2,
	S2MPG10 = 3,
	S2MPS11X = 4,
	S2MPS13X = 5,
	S2MPS14X = 6,
	S2MPS15X = 7,
	S2MPU02 = 8,
	S2MPU05 = 9,
};

enum seg6_end_dt_mode {
	DT_INVALID_MODE = -22,
	DT_LEGACY_MODE = 0,
	DT_VRF_MODE = 1,
};

enum seg6_local_flv_action {
	SEG6_LOCAL_FLV_ACT_UNSPEC = 0,
	SEG6_LOCAL_FLV_ACT_END = 1,
	SEG6_LOCAL_FLV_ACT_PSP = 2,
	SEG6_LOCAL_FLV_ACT_USP = 3,
	SEG6_LOCAL_FLV_ACT_USD = 4,
	__SEG6_LOCAL_FLV_ACT_MAX = 5,
};

enum seg6_local_pktinfo {
	SEG6_LOCAL_PKTINFO_NOHDR = 0,
	SEG6_LOCAL_PKTINFO_SL_ZERO = 1,
	SEG6_LOCAL_PKTINFO_SL_ONE = 2,
	SEG6_LOCAL_PKTINFO_SL_MORE = 3,
	__SEG6_LOCAL_PKTINFO_MAX = 4,
};

enum serdev_parity {
	SERDEV_PARITY_NONE = 0,
	SERDEV_PARITY_EVEN = 1,
	SERDEV_PARITY_ODD = 2,
};

enum serio_event_type {
	SERIO_RESCAN_PORT = 0,
	SERIO_RECONNECT_PORT = 1,
	SERIO_RECONNECT_SUBTREE = 2,
	SERIO_REGISTER_PORT = 3,
	SERIO_ATTACH_DRIVER = 4,
};

enum sfpb_ahb_arb_master_port_en {
	SFPB_MASTER_PORT_ENABLE = 3,
	SFPB_MASTER_PORT_DISABLE = 0,
};

enum sgp_type {
	SGP_READ = 0,
	SGP_NOALLOC = 1,
	SGP_CACHE = 2,
	SGP_WRITE = 3,
	SGP_FALLOC = 4,
};

enum shmem_param {
	Opt_gid___6 = 0,
	Opt_huge = 1,
	Opt_mode___5 = 2,
	Opt_mpol = 3,
	Opt_nr_blocks = 4,
	Opt_nr_inodes = 5,
	Opt_size = 6,
	Opt_uid___5 = 7,
	Opt_inode32 = 8,
	Opt_inode64 = 9,
	Opt_noswap = 10,
	Opt_quota___3 = 11,
	Opt_usrquota___3 = 12,
	Opt_grpquota___3 = 13,
	Opt_usrquota_block_hardlimit = 14,
	Opt_usrquota_inode_hardlimit = 15,
	Opt_grpquota_block_hardlimit = 16,
	Opt_grpquota_inode_hardlimit = 17,
	Opt_casefold_version = 18,
	Opt_casefold = 19,
	Opt_strict_encoding = 20,
};

enum si5351_clkout_src {
	SI5351_CLKOUT_SRC_DEFAULT = 0,
	SI5351_CLKOUT_SRC_MSYNTH_N = 1,
	SI5351_CLKOUT_SRC_MSYNTH_0_4 = 2,
	SI5351_CLKOUT_SRC_XTAL = 3,
	SI5351_CLKOUT_SRC_CLKIN = 4,
};

enum si5351_disable_state {
	SI5351_DISABLE_DEFAULT = 0,
	SI5351_DISABLE_LOW = 1,
	SI5351_DISABLE_HIGH = 2,
	SI5351_DISABLE_FLOATING = 3,
	SI5351_DISABLE_NEVER = 4,
};

enum si5351_drive_strength {
	SI5351_DRIVE_DEFAULT = 0,
	SI5351_DRIVE_2MA = 2,
	SI5351_DRIVE_4MA = 4,
	SI5351_DRIVE_6MA = 6,
	SI5351_DRIVE_8MA = 8,
};

enum si5351_multisynth_src {
	SI5351_MULTISYNTH_SRC_DEFAULT = 0,
	SI5351_MULTISYNTH_SRC_VCO0 = 1,
	SI5351_MULTISYNTH_SRC_VCO1 = 2,
};

enum si5351_pll_src {
	SI5351_PLL_SRC_DEFAULT = 0,
	SI5351_PLL_SRC_XTAL = 1,
	SI5351_PLL_SRC_CLKIN = 2,
};

enum si5351_variant {
	SI5351_VARIANT_A = 1,
	SI5351_VARIANT_A3 = 2,
	SI5351_VARIANT_B = 3,
	SI5351_VARIANT_C = 4,
};

enum sig_handler {
	HANDLER_CURRENT = 0,
	HANDLER_SIG_DFL = 1,
	HANDLER_EXIT = 2,
};

enum siginfo_layout {
	SIL_KILL = 0,
	SIL_TIMER = 1,
	SIL_POLL = 2,
	SIL_FAULT = 3,
	SIL_FAULT_TRAPNO = 4,
	SIL_FAULT_MCEERR = 5,
	SIL_FAULT_BNDERR = 6,
	SIL_FAULT_PKUERR = 7,
	SIL_FAULT_PERF_EVENT = 8,
	SIL_CHLD = 9,
	SIL_RT = 10,
	SIL_SYS = 11,
};

enum sk_action {
	SK_DROP = 0,
	SK_PASS = 1,
};

enum sk_pacing {
	SK_PACING_NONE = 0,
	SK_PACING_NEEDED = 1,
	SK_PACING_FQ = 2,
};

enum sk_psock_state_bits {
	SK_PSOCK_TX_ENABLED = 0,
	SK_PSOCK_RX_STRP_ENABLED = 1,
};

enum sk_rst_reason {
	SK_RST_REASON_NOT_SPECIFIED = 0,
	SK_RST_REASON_NO_SOCKET = 1,
	SK_RST_REASON_TCP_INVALID_ACK_SEQUENCE = 2,
	SK_RST_REASON_TCP_RFC7323_PAWS = 3,
	SK_RST_REASON_TCP_TOO_OLD_ACK = 4,
	SK_RST_REASON_TCP_ACK_UNSENT_DATA = 5,
	SK_RST_REASON_TCP_FLAGS = 6,
	SK_RST_REASON_TCP_OLD_ACK = 7,
	SK_RST_REASON_TCP_ABORT_ON_DATA = 8,
	SK_RST_REASON_TCP_TIMEWAIT_SOCKET = 9,
	SK_RST_REASON_INVALID_SYN = 10,
	SK_RST_REASON_TCP_ABORT_ON_CLOSE = 11,
	SK_RST_REASON_TCP_ABORT_ON_LINGER = 12,
	SK_RST_REASON_TCP_ABORT_ON_MEMORY = 13,
	SK_RST_REASON_TCP_STATE = 14,
	SK_RST_REASON_TCP_KEEPALIVE_TIMEOUT = 15,
	SK_RST_REASON_TCP_DISCONNECT_WITH_DATA = 16,
	SK_RST_REASON_MPTCP_RST_EUNSPEC = 17,
	SK_RST_REASON_MPTCP_RST_EMPTCP = 18,
	SK_RST_REASON_MPTCP_RST_ERESOURCE = 19,
	SK_RST_REASON_MPTCP_RST_EPROHIBIT = 20,
	SK_RST_REASON_MPTCP_RST_EWQ2BIG = 21,
	SK_RST_REASON_MPTCP_RST_EBADPERF = 22,
	SK_RST_REASON_MPTCP_RST_EMIDDLEBOX = 23,
	SK_RST_REASON_ERROR = 24,
	SK_RST_REASON_MAX = 25,
};

enum skb_drop_reason {
	SKB_NOT_DROPPED_YET = 0,
	SKB_CONSUMED = 1,
	SKB_DROP_REASON_NOT_SPECIFIED = 2,
	SKB_DROP_REASON_NO_SOCKET = 3,
	SKB_DROP_REASON_SOCKET_CLOSE = 4,
	SKB_DROP_REASON_SOCKET_FILTER = 5,
	SKB_DROP_REASON_SOCKET_RCVBUFF = 6,
	SKB_DROP_REASON_UNIX_DISCONNECT = 7,
	SKB_DROP_REASON_UNIX_SKIP_OOB = 8,
	SKB_DROP_REASON_PKT_TOO_SMALL = 9,
	SKB_DROP_REASON_TCP_CSUM = 10,
	SKB_DROP_REASON_UDP_CSUM = 11,
	SKB_DROP_REASON_NETFILTER_DROP = 12,
	SKB_DROP_REASON_OTHERHOST = 13,
	SKB_DROP_REASON_IP_CSUM = 14,
	SKB_DROP_REASON_IP_INHDR = 15,
	SKB_DROP_REASON_IP_RPFILTER = 16,
	SKB_DROP_REASON_UNICAST_IN_L2_MULTICAST = 17,
	SKB_DROP_REASON_XFRM_POLICY = 18,
	SKB_DROP_REASON_IP_NOPROTO = 19,
	SKB_DROP_REASON_PROTO_MEM = 20,
	SKB_DROP_REASON_TCP_AUTH_HDR = 21,
	SKB_DROP_REASON_TCP_MD5NOTFOUND = 22,
	SKB_DROP_REASON_TCP_MD5UNEXPECTED = 23,
	SKB_DROP_REASON_TCP_MD5FAILURE = 24,
	SKB_DROP_REASON_TCP_AONOTFOUND = 25,
	SKB_DROP_REASON_TCP_AOUNEXPECTED = 26,
	SKB_DROP_REASON_TCP_AOKEYNOTFOUND = 27,
	SKB_DROP_REASON_TCP_AOFAILURE = 28,
	SKB_DROP_REASON_SOCKET_BACKLOG = 29,
	SKB_DROP_REASON_TCP_FLAGS = 30,
	SKB_DROP_REASON_TCP_ABORT_ON_DATA = 31,
	SKB_DROP_REASON_TCP_ZEROWINDOW = 32,
	SKB_DROP_REASON_TCP_OLD_DATA = 33,
	SKB_DROP_REASON_TCP_OVERWINDOW = 34,
	SKB_DROP_REASON_TCP_OFOMERGE = 35,
	SKB_DROP_REASON_TCP_RFC7323_PAWS = 36,
	SKB_DROP_REASON_TCP_RFC7323_PAWS_ACK = 37,
	SKB_DROP_REASON_TCP_RFC7323_TW_PAWS = 38,
	SKB_DROP_REASON_TCP_RFC7323_TSECR = 39,
	SKB_DROP_REASON_TCP_LISTEN_OVERFLOW = 40,
	SKB_DROP_REASON_TCP_OLD_SEQUENCE = 41,
	SKB_DROP_REASON_TCP_INVALID_SEQUENCE = 42,
	SKB_DROP_REASON_TCP_INVALID_ACK_SEQUENCE = 43,
	SKB_DROP_REASON_TCP_RESET = 44,
	SKB_DROP_REASON_TCP_INVALID_SYN = 45,
	SKB_DROP_REASON_TCP_CLOSE = 46,
	SKB_DROP_REASON_TCP_FASTOPEN = 47,
	SKB_DROP_REASON_TCP_OLD_ACK = 48,
	SKB_DROP_REASON_TCP_TOO_OLD_ACK = 49,
	SKB_DROP_REASON_TCP_ACK_UNSENT_DATA = 50,
	SKB_DROP_REASON_TCP_OFO_QUEUE_PRUNE = 51,
	SKB_DROP_REASON_TCP_OFO_DROP = 52,
	SKB_DROP_REASON_IP_OUTNOROUTES = 53,
	SKB_DROP_REASON_BPF_CGROUP_EGRESS = 54,
	SKB_DROP_REASON_IPV6DISABLED = 55,
	SKB_DROP_REASON_NEIGH_CREATEFAIL = 56,
	SKB_DROP_REASON_NEIGH_FAILED = 57,
	SKB_DROP_REASON_NEIGH_QUEUEFULL = 58,
	SKB_DROP_REASON_NEIGH_DEAD = 59,
	SKB_DROP_REASON_NEIGH_HH_FILLFAIL = 60,
	SKB_DROP_REASON_TC_EGRESS = 61,
	SKB_DROP_REASON_SECURITY_HOOK = 62,
	SKB_DROP_REASON_QDISC_DROP = 63,
	SKB_DROP_REASON_QDISC_OVERLIMIT = 64,
	SKB_DROP_REASON_QDISC_CONGESTED = 65,
	SKB_DROP_REASON_CAKE_FLOOD = 66,
	SKB_DROP_REASON_FQ_BAND_LIMIT = 67,
	SKB_DROP_REASON_FQ_HORIZON_LIMIT = 68,
	SKB_DROP_REASON_FQ_FLOW_LIMIT = 69,
	SKB_DROP_REASON_CPU_BACKLOG = 70,
	SKB_DROP_REASON_XDP = 71,
	SKB_DROP_REASON_TC_INGRESS = 72,
	SKB_DROP_REASON_UNHANDLED_PROTO = 73,
	SKB_DROP_REASON_SKB_CSUM = 74,
	SKB_DROP_REASON_SKB_GSO_SEG = 75,
	SKB_DROP_REASON_SKB_UCOPY_FAULT = 76,
	SKB_DROP_REASON_DEV_HDR = 77,
	SKB_DROP_REASON_DEV_READY = 78,
	SKB_DROP_REASON_FULL_RING = 79,
	SKB_DROP_REASON_NOMEM = 80,
	SKB_DROP_REASON_HDR_TRUNC = 81,
	SKB_DROP_REASON_TAP_FILTER = 82,
	SKB_DROP_REASON_TAP_TXFILTER = 83,
	SKB_DROP_REASON_ICMP_CSUM = 84,
	SKB_DROP_REASON_INVALID_PROTO = 85,
	SKB_DROP_REASON_IP_INADDRERRORS = 86,
	SKB_DROP_REASON_IP_INNOROUTES = 87,
	SKB_DROP_REASON_IP_LOCAL_SOURCE = 88,
	SKB_DROP_REASON_IP_INVALID_SOURCE = 89,
	SKB_DROP_REASON_IP_LOCALNET = 90,
	SKB_DROP_REASON_IP_INVALID_DEST = 91,
	SKB_DROP_REASON_PKT_TOO_BIG = 92,
	SKB_DROP_REASON_DUP_FRAG = 93,
	SKB_DROP_REASON_FRAG_REASM_TIMEOUT = 94,
	SKB_DROP_REASON_FRAG_TOO_FAR = 95,
	SKB_DROP_REASON_TCP_MINTTL = 96,
	SKB_DROP_REASON_IPV6_BAD_EXTHDR = 97,
	SKB_DROP_REASON_IPV6_NDISC_FRAG = 98,
	SKB_DROP_REASON_IPV6_NDISC_HOP_LIMIT = 99,
	SKB_DROP_REASON_IPV6_NDISC_BAD_CODE = 100,
	SKB_DROP_REASON_IPV6_NDISC_BAD_OPTIONS = 101,
	SKB_DROP_REASON_IPV6_NDISC_NS_OTHERHOST = 102,
	SKB_DROP_REASON_QUEUE_PURGE = 103,
	SKB_DROP_REASON_TC_COOKIE_ERROR = 104,
	SKB_DROP_REASON_PACKET_SOCK_ERROR = 105,
	SKB_DROP_REASON_TC_CHAIN_NOTFOUND = 106,
	SKB_DROP_REASON_TC_RECLASSIFY_LOOP = 107,
	SKB_DROP_REASON_VXLAN_INVALID_HDR = 108,
	SKB_DROP_REASON_VXLAN_VNI_NOT_FOUND = 109,
	SKB_DROP_REASON_MAC_INVALID_SOURCE = 110,
	SKB_DROP_REASON_VXLAN_ENTRY_EXISTS = 111,
	SKB_DROP_REASON_NO_TX_TARGET = 112,
	SKB_DROP_REASON_IP_TUNNEL_ECN = 113,
	SKB_DROP_REASON_TUNNEL_TXINFO = 114,
	SKB_DROP_REASON_LOCAL_MAC = 115,
	SKB_DROP_REASON_ARP_PVLAN_DISABLE = 116,
	SKB_DROP_REASON_MAC_IEEE_MAC_CONTROL = 117,
	SKB_DROP_REASON_BRIDGE_INGRESS_STP_STATE = 118,
	SKB_DROP_REASON_MAX = 119,
	SKB_DROP_REASON_SUBSYS_MASK = 4294901760,
};

enum skb_drop_reason_subsys {
	SKB_DROP_REASON_SUBSYS_CORE = 0,
	SKB_DROP_REASON_SUBSYS_MAC80211_UNUSABLE = 1,
	SKB_DROP_REASON_SUBSYS_OPENVSWITCH = 2,
	SKB_DROP_REASON_SUBSYS_NUM = 3,
};

enum skb_ext_id {
	SKB_EXT_BRIDGE_NF = 0,
	SKB_EXT_SEC_PATH = 1,
	SKB_EXT_MPTCP = 2,
	SKB_EXT_NUM = 3,
};

enum skb_tstamp_type {
	SKB_CLOCK_REALTIME = 0,
	SKB_CLOCK_MONOTONIC = 1,
	SKB_CLOCK_TAI = 2,
	__SKB_CLOCK_MAX = 2,
};

enum sknetlink_groups {
	SKNLGRP_NONE = 0,
	SKNLGRP_INET_TCP_DESTROY = 1,
	SKNLGRP_INET_UDP_DESTROY = 2,
	SKNLGRP_INET6_TCP_DESTROY = 3,
	SKNLGRP_INET6_UDP_DESTROY = 4,
	__SKNLGRP_MAX = 5,
};

enum slab_stat_type {
	SL_ALL = 0,
	SL_PARTIAL = 1,
	SL_CPU = 2,
	SL_OBJECTS = 3,
	SL_TOTAL = 4,
};

enum slab_state {
	DOWN___2 = 0,
	PARTIAL = 1,
	UP___2 = 2,
	FULL = 3,
};

enum smk_inos {
	SMK_ROOT_INO = 2,
	SMK_LOAD = 3,
	SMK_CIPSO = 4,
	SMK_DOI = 5,
	SMK_DIRECT = 6,
	SMK_AMBIENT = 7,
	SMK_NET4ADDR = 8,
	SMK_ONLYCAP = 9,
	SMK_LOGGING = 10,
	SMK_LOAD_SELF = 11,
	SMK_ACCESSES = 12,
	SMK_MAPPED = 13,
	SMK_LOAD2 = 14,
	SMK_LOAD_SELF2 = 15,
	SMK_ACCESS2 = 16,
	SMK_CIPSO2 = 17,
	SMK_REVOKE_SUBJ = 18,
	SMK_CHANGE_RULE = 19,
	SMK_SYSLOG = 20,
	SMK_PTRACE = 21,
	SMK_UNCONFINED = 22,
	SMK_NET6ADDR = 23,
	SMK_RELABEL_SELF = 24,
};

enum snd_compr_direction {
	SND_COMPRESS_PLAYBACK = 0,
	SND_COMPRESS_CAPTURE = 1,
	SND_COMPRESS_ACCEL = 2,
};

enum snd_ctl_add_mode {
	CTL_ADD_EXCLUSIVE = 0,
	CTL_REPLACE = 1,
	CTL_ADD_ON_REPLACE = 2,
};

enum snd_device_state {
	SNDRV_DEV_BUILD = 0,
	SNDRV_DEV_REGISTERED = 1,
	SNDRV_DEV_DISCONNECTED = 2,
};

enum snd_device_type {
	SNDRV_DEV_LOWLEVEL = 0,
	SNDRV_DEV_INFO = 1,
	SNDRV_DEV_BUS = 2,
	SNDRV_DEV_CODEC = 3,
	SNDRV_DEV_PCM = 4,
	SNDRV_DEV_COMPRESS = 5,
	SNDRV_DEV_RAWMIDI = 6,
	SNDRV_DEV_TIMER = 7,
	SNDRV_DEV_SEQUENCER = 8,
	SNDRV_DEV_HWDEP = 9,
	SNDRV_DEV_JACK = 10,
	SNDRV_DEV_CONTROL = 11,
};

enum snd_jack_types {
	SND_JACK_HEADPHONE = 1,
	SND_JACK_MICROPHONE = 2,
	SND_JACK_HEADSET = 3,
	SND_JACK_LINEOUT = 4,
	SND_JACK_MECHANICAL = 8,
	SND_JACK_VIDEOOUT = 16,
	SND_JACK_AVOUT = 20,
	SND_JACK_LINEIN = 32,
	SND_JACK_USB = 64,
	SND_JACK_BTN_0 = 16384,
	SND_JACK_BTN_1 = 8192,
	SND_JACK_BTN_2 = 4096,
	SND_JACK_BTN_3 = 2048,
	SND_JACK_BTN_4 = 1024,
	SND_JACK_BTN_5 = 512,
};

enum snd_soc_bias_level {
	SND_SOC_BIAS_OFF = 0,
	SND_SOC_BIAS_STANDBY = 1,
	SND_SOC_BIAS_PREPARE = 2,
	SND_SOC_BIAS_ON = 3,
};

enum snd_soc_dapm_type {
	snd_soc_dapm_input = 0,
	snd_soc_dapm_output = 1,
	snd_soc_dapm_mux = 2,
	snd_soc_dapm_demux = 3,
	snd_soc_dapm_mixer = 4,
	snd_soc_dapm_mixer_named_ctl = 5,
	snd_soc_dapm_pga = 6,
	snd_soc_dapm_out_drv = 7,
	snd_soc_dapm_adc = 8,
	snd_soc_dapm_dac = 9,
	snd_soc_dapm_micbias = 10,
	snd_soc_dapm_mic = 11,
	snd_soc_dapm_hp = 12,
	snd_soc_dapm_spk = 13,
	snd_soc_dapm_line = 14,
	snd_soc_dapm_switch = 15,
	snd_soc_dapm_vmid = 16,
	snd_soc_dapm_pre = 17,
	snd_soc_dapm_post = 18,
	snd_soc_dapm_supply = 19,
	snd_soc_dapm_pinctrl = 20,
	snd_soc_dapm_regulator_supply = 21,
	snd_soc_dapm_clock_supply = 22,
	snd_soc_dapm_aif_in = 23,
	snd_soc_dapm_aif_out = 24,
	snd_soc_dapm_siggen = 25,
	snd_soc_dapm_sink = 26,
	snd_soc_dapm_dai_in = 27,
	snd_soc_dapm_dai_out = 28,
	snd_soc_dapm_dai_link = 29,
	snd_soc_dapm_kcontrol = 30,
	snd_soc_dapm_buffer = 31,
	snd_soc_dapm_scheduler = 32,
	snd_soc_dapm_effect = 33,
	snd_soc_dapm_src = 34,
	snd_soc_dapm_asrc = 35,
	snd_soc_dapm_encoder = 36,
	snd_soc_dapm_decoder = 37,
	SND_SOC_DAPM_TYPE_COUNT = 38,
};

enum snd_soc_dobj_type {
	SND_SOC_DOBJ_NONE = 0,
	SND_SOC_DOBJ_MIXER = 1,
	SND_SOC_DOBJ_BYTES = 2,
	SND_SOC_DOBJ_ENUM = 3,
	SND_SOC_DOBJ_GRAPH = 4,
	SND_SOC_DOBJ_WIDGET = 5,
	SND_SOC_DOBJ_DAI_LINK = 6,
	SND_SOC_DOBJ_PCM = 7,
	SND_SOC_DOBJ_CODEC_LINK = 8,
	SND_SOC_DOBJ_BACKEND_LINK = 9,
};

enum snd_soc_dpcm_state {
	SND_SOC_DPCM_STATE_NEW = 0,
	SND_SOC_DPCM_STATE_OPEN = 1,
	SND_SOC_DPCM_STATE_HW_PARAMS = 2,
	SND_SOC_DPCM_STATE_PREPARE = 3,
	SND_SOC_DPCM_STATE_START = 4,
	SND_SOC_DPCM_STATE_STOP = 5,
	SND_SOC_DPCM_STATE_PAUSED = 6,
	SND_SOC_DPCM_STATE_SUSPEND = 7,
	SND_SOC_DPCM_STATE_HW_FREE = 8,
	SND_SOC_DPCM_STATE_CLOSE = 9,
};

enum snd_soc_dpcm_trigger {
	SND_SOC_DPCM_TRIGGER_PRE = 0,
	SND_SOC_DPCM_TRIGGER_POST = 1,
};

enum snd_soc_dpcm_update {
	SND_SOC_DPCM_UPDATE_NO = 0,
	SND_SOC_DPCM_UPDATE_BE = 1,
	SND_SOC_DPCM_UPDATE_FE = 2,
};

enum snd_soc_pcm_subclass {
	SND_SOC_PCM_CLASS_PCM = 0,
	SND_SOC_PCM_CLASS_BE = 1,
};

enum snd_soc_trigger_order {
	SND_SOC_TRIGGER_ORDER_DEFAULT = 0,
	SND_SOC_TRIGGER_ORDER_LDC = 1,
	SND_SOC_TRIGGER_ORDER_MAX = 2,
};

enum sndrv_ctl_event_type {
	SNDRV_CTL_EVENT_ELEM = 0,
	SNDRV_CTL_EVENT_LAST = 0,
};

enum snoop_when {
	SUBMIT = 0,
	COMPLETE = 1,
};

enum soc_type {
	SOC_ARCH_EXYNOS3250 = 1,
	SOC_ARCH_EXYNOS4210 = 2,
	SOC_ARCH_EXYNOS4412 = 3,
	SOC_ARCH_EXYNOS5250 = 4,
	SOC_ARCH_EXYNOS5260 = 5,
	SOC_ARCH_EXYNOS5420 = 6,
	SOC_ARCH_EXYNOS5420_TRIMINFO = 7,
	SOC_ARCH_EXYNOS5433 = 8,
	SOC_ARCH_EXYNOS7 = 9,
};

enum sock_flags {
	SOCK_DEAD = 0,
	SOCK_DONE = 1,
	SOCK_URGINLINE = 2,
	SOCK_KEEPOPEN = 3,
	SOCK_LINGER = 4,
	SOCK_DESTROY = 5,
	SOCK_BROADCAST = 6,
	SOCK_TIMESTAMP = 7,
	SOCK_ZAPPED = 8,
	SOCK_USE_WRITE_QUEUE = 9,
	SOCK_DBG = 10,
	SOCK_RCVTSTAMP = 11,
	SOCK_RCVTSTAMPNS = 12,
	SOCK_LOCALROUTE = 13,
	SOCK_MEMALLOC = 14,
	SOCK_TIMESTAMPING_RX_SOFTWARE = 15,
	SOCK_FASYNC = 16,
	SOCK_RXQ_OVFL = 17,
	SOCK_ZEROCOPY = 18,
	SOCK_WIFI_STATUS = 19,
	SOCK_NOFCS = 20,
	SOCK_FILTER_LOCKED = 21,
	SOCK_SELECT_ERR_QUEUE = 22,
	SOCK_RCU_FREE = 23,
	SOCK_TXTIME = 24,
	SOCK_XDP = 25,
	SOCK_TSTAMP_NEW = 26,
	SOCK_RCVMARK = 27,
	SOCK_RCVPRIORITY = 28,
	SOCK_TIMESTAMPING_ANY = 29,
};

enum sock_shutdown_cmd {
	SHUT_RD = 0,
	SHUT_WR = 1,
	SHUT_RDWR = 2,
};

enum sock_type {
	SOCK_STREAM = 1,
	SOCK_DGRAM = 2,
	SOCK_RAW = 3,
	SOCK_RDM = 4,
	SOCK_SEQPACKET = 5,
	SOCK_DCCP = 6,
	SOCK_PACKET = 10,
};

enum socket_flags {
	SOCKWQ_ASYNC_NOSPACE = 0,
	SOCKWQ_ASYNC_WAITDATA = 1,
	SOCK_NOSPACE = 2,
	SOCK_SUPPORT_ZC = 3,
	SOCK_CUSTOM_SOCKOPT = 4,
};

enum special_kfunc_type {
	KF_bpf_obj_new_impl = 0,
	KF_bpf_obj_drop_impl = 1,
	KF_bpf_refcount_acquire_impl = 2,
	KF_bpf_list_push_front_impl = 3,
	KF_bpf_list_push_back_impl = 4,
	KF_bpf_list_pop_front = 5,
	KF_bpf_list_pop_back = 6,
	KF_bpf_list_front = 7,
	KF_bpf_list_back = 8,
	KF_bpf_cast_to_kern_ctx = 9,
	KF_bpf_rdonly_cast = 10,
	KF_bpf_rcu_read_lock = 11,
	KF_bpf_rcu_read_unlock = 12,
	KF_bpf_rbtree_remove = 13,
	KF_bpf_rbtree_add_impl = 14,
	KF_bpf_rbtree_first = 15,
	KF_bpf_rbtree_root = 16,
	KF_bpf_rbtree_left = 17,
	KF_bpf_rbtree_right = 18,
	KF_bpf_dynptr_from_skb = 19,
	KF_bpf_dynptr_from_xdp = 20,
	KF_bpf_dynptr_slice = 21,
	KF_bpf_dynptr_slice_rdwr = 22,
	KF_bpf_dynptr_clone = 23,
	KF_bpf_percpu_obj_new_impl = 24,
	KF_bpf_percpu_obj_drop_impl = 25,
	KF_bpf_throw = 26,
	KF_bpf_wq_set_callback_impl = 27,
	KF_bpf_preempt_disable = 28,
	KF_bpf_preempt_enable = 29,
	KF_bpf_iter_css_task_new = 30,
	KF_bpf_session_cookie = 31,
	KF_bpf_get_kmem_cache = 32,
	KF_bpf_local_irq_save = 33,
	KF_bpf_local_irq_restore = 34,
	KF_bpf_iter_num_new = 35,
	KF_bpf_iter_num_next = 36,
	KF_bpf_iter_num_destroy = 37,
	KF_bpf_set_dentry_xattr = 38,
	KF_bpf_remove_dentry_xattr = 39,
	KF_bpf_res_spin_lock = 40,
	KF_bpf_res_spin_unlock = 41,
	KF_bpf_res_spin_lock_irqsave = 42,
	KF_bpf_res_spin_unlock_irqrestore = 43,
	KF___bpf_trap = 44,
};

enum spi_imx_devtype {
	IMX1_CSPI = 0,
	IMX21_CSPI = 1,
	IMX27_CSPI = 2,
	IMX31_CSPI = 3,
	IMX35_CSPI = 4,
	IMX51_ECSPI = 5,
	IMX53_ECSPI = 6,
};

enum spi_mem_data_dir {
	SPI_MEM_NO_DATA = 0,
	SPI_MEM_DATA_IN = 1,
	SPI_MEM_DATA_OUT = 2,
};

enum spi_nor_cmd_ext {
	SPI_NOR_EXT_NONE = 0,
	SPI_NOR_EXT_REPEAT = 1,
	SPI_NOR_EXT_INVERT = 2,
	SPI_NOR_EXT_HEX = 3,
};

enum spi_nor_option_flags {
	SNOR_F_HAS_SR_TB = 1,
	SNOR_F_NO_OP_CHIP_ERASE = 2,
	SNOR_F_BROKEN_RESET = 4,
	SNOR_F_4B_OPCODES = 8,
	SNOR_F_HAS_4BAIT = 16,
	SNOR_F_HAS_LOCK = 32,
	SNOR_F_HAS_16BIT_SR = 64,
	SNOR_F_NO_READ_CR = 128,
	SNOR_F_HAS_SR_TB_BIT6 = 256,
	SNOR_F_HAS_4BIT_BP = 512,
	SNOR_F_HAS_SR_BP3_BIT6 = 1024,
	SNOR_F_IO_MODE_EN_VOLATILE = 2048,
	SNOR_F_SOFT_RESET = 4096,
	SNOR_F_SWP_IS_VOLATILE = 8192,
	SNOR_F_RWW = 16384,
	SNOR_F_ECC = 32768,
	SNOR_F_NO_WP = 65536,
	SNOR_F_SWAP16 = 131072,
};

enum spi_nor_pp_command_index {
	SNOR_CMD_PP = 0,
	SNOR_CMD_PP_1_1_4 = 1,
	SNOR_CMD_PP_1_4_4 = 2,
	SNOR_CMD_PP_4_4_4 = 3,
	SNOR_CMD_PP_1_1_8 = 4,
	SNOR_CMD_PP_1_8_8 = 5,
	SNOR_CMD_PP_8_8_8 = 6,
	SNOR_CMD_PP_8_8_8_DTR = 7,
	SNOR_CMD_PP_MAX = 8,
};

enum spi_nor_protocol {
	SNOR_PROTO_1_1_1 = 65793,
	SNOR_PROTO_1_1_2 = 65794,
	SNOR_PROTO_1_1_4 = 65796,
	SNOR_PROTO_1_1_8 = 65800,
	SNOR_PROTO_1_2_2 = 66050,
	SNOR_PROTO_1_4_4 = 66564,
	SNOR_PROTO_1_8_8 = 67592,
	SNOR_PROTO_2_2_2 = 131586,
	SNOR_PROTO_4_4_4 = 263172,
	SNOR_PROTO_8_8_8 = 526344,
	SNOR_PROTO_1_1_1_DTR = 16843009,
	SNOR_PROTO_1_2_2_DTR = 16843266,
	SNOR_PROTO_1_4_4_DTR = 16843780,
	SNOR_PROTO_1_8_8_DTR = 16844808,
	SNOR_PROTO_8_8_8_DTR = 17303560,
};

enum spi_nor_read_command_index {
	SNOR_CMD_READ = 0,
	SNOR_CMD_READ_FAST = 1,
	SNOR_CMD_READ_1_1_1_DTR = 2,
	SNOR_CMD_READ_1_1_2 = 3,
	SNOR_CMD_READ_1_2_2 = 4,
	SNOR_CMD_READ_2_2_2 = 5,
	SNOR_CMD_READ_1_2_2_DTR = 6,
	SNOR_CMD_READ_1_1_4 = 7,
	SNOR_CMD_READ_1_4_4 = 8,
	SNOR_CMD_READ_4_4_4 = 9,
	SNOR_CMD_READ_1_4_4_DTR = 10,
	SNOR_CMD_READ_1_1_8 = 11,
	SNOR_CMD_READ_1_8_8 = 12,
	SNOR_CMD_READ_8_8_8 = 13,
	SNOR_CMD_READ_1_8_8_DTR = 14,
	SNOR_CMD_READ_8_8_8_DTR = 15,
	SNOR_CMD_READ_MAX = 16,
};

enum spi_offload_trigger_type {
	SPI_OFFLOAD_TRIGGER_DATA_READY = 0,
	SPI_OFFLOAD_TRIGGER_PERIODIC = 1,
};

enum sr_instance {
	OMAP_SR_MPU = 0,
	OMAP_SR_CORE = 1,
	OMAP_SR_IVA = 2,
	OMAP_SR_NR = 3,
};

enum sr_retry_flags {
	IO_SR_MSG_RETRY = 1,
	IO_SR_MSG_PARTIAL_MAP = 2,
};

enum stat_group {
	STAT_READ = 0,
	STAT_WRITE = 1,
	STAT_DISCARD = 2,
	STAT_FLUSH = 3,
	NR_STAT_GROUPS = 4,
};

enum stat_item {
	ALLOC_FASTPATH = 0,
	ALLOC_SLOWPATH = 1,
	FREE_FASTPATH = 2,
	FREE_SLOWPATH = 3,
	FREE_FROZEN = 4,
	FREE_ADD_PARTIAL = 5,
	FREE_REMOVE_PARTIAL = 6,
	ALLOC_FROM_PARTIAL = 7,
	ALLOC_SLAB = 8,
	ALLOC_REFILL = 9,
	ALLOC_NODE_MISMATCH = 10,
	FREE_SLAB = 11,
	CPUSLAB_FLUSH = 12,
	DEACTIVATE_FULL = 13,
	DEACTIVATE_EMPTY = 14,
	DEACTIVATE_TO_HEAD = 15,
	DEACTIVATE_TO_TAIL = 16,
	DEACTIVATE_REMOTE_FREES = 17,
	DEACTIVATE_BYPASS = 18,
	ORDER_FALLBACK = 19,
	CMPXCHG_DOUBLE_CPU_FAIL = 20,
	CMPXCHG_DOUBLE_FAIL = 21,
	CPU_PARTIAL_ALLOC = 22,
	CPU_PARTIAL_FREE = 23,
	CPU_PARTIAL_NODE = 24,
	CPU_PARTIAL_DRAIN = 25,
	NR_SLUB_STAT_ITEMS = 26,
};

enum state {
	Start = 0,
	Collect = 1,
	GotHeader = 2,
	SkipIt = 3,
	GotName = 4,
	CopyFile = 5,
	GotSymlink = 6,
	Reset = 7,
};

enum state_protect_how4 {
	SP4_NONE = 0,
	SP4_MACH_CRED = 1,
	SP4_SSV = 2,
};

enum stmpe_block {
	STMPE_BLOCK_GPIO = 1,
	STMPE_BLOCK_KEYPAD = 2,
	STMPE_BLOCK_TOUCHSCREEN = 4,
	STMPE_BLOCK_ADC = 8,
	STMPE_BLOCK_PWM = 16,
	STMPE_BLOCK_ROTATOR = 32,
};

enum stmpe_partnum {
	STMPE610 = 0,
	STMPE801 = 1,
	STMPE811 = 2,
	STMPE1600 = 3,
	STMPE1601 = 4,
	STMPE1801 = 5,
	STMPE2401 = 6,
	STMPE2403 = 7,
	STMPE_NBR_PARTS = 8,
};

enum stop_cp_reason {
	STOP_CP_REASON_SHUTDOWN = 0,
	STOP_CP_REASON_FAULT_INJECT = 1,
	STOP_CP_REASON_META_PAGE = 2,
	STOP_CP_REASON_WRITE_FAIL = 3,
	STOP_CP_REASON_CORRUPTED_SUMMARY = 4,
	STOP_CP_REASON_UPDATE_INODE = 5,
	STOP_CP_REASON_FLUSH_FAIL = 6,
	STOP_CP_REASON_NO_SEGMENT = 7,
	STOP_CP_REASON_CORRUPTED_FREE_BITMAP = 8,
	STOP_CP_REASON_MAX = 9,
};

enum store_type {
	wr_invalid = 0,
	wr_new_root = 1,
	wr_store_root = 2,
	wr_exact_fit = 3,
	wr_spanning_store = 4,
	wr_split_store = 5,
	wr_rebalance = 6,
	wr_append = 7,
	wr_node_store = 8,
	wr_slot_store = 9,
};

enum string_size_units {
	STRING_UNITS_10 = 0,
	STRING_UNITS_2 = 1,
	STRING_UNITS_MASK = 1,
	STRING_UNITS_NO_SPACE = 1073741824,
	STRING_UNITS_NO_BYTES = 2147483648,
};

enum stripetype4 {
	STRIPE_SPARSE = 1,
	STRIPE_DENSE = 2,
};

enum subpixel_order {
	SubPixelUnknown = 0,
	SubPixelHorizontalRGB = 1,
	SubPixelHorizontalBGR = 2,
	SubPixelVerticalRGB = 3,
	SubPixelVerticalBGR = 4,
	SubPixelNone = 5,
};

enum sum_check_bits {
	SUM_CHECK_P = 0,
	SUM_CHECK_Q = 1,
};

enum sum_check_flags {
	SUM_CHECK_P_RESULT = 1,
	SUM_CHECK_Q_RESULT = 2,
};

enum sun6i_dphy_direction {
	SUN6I_DPHY_DIRECTION_TX = 0,
	SUN6I_DPHY_DIRECTION_RX = 1,
};

enum sunxi_desc_bias_voltage {
	BIAS_VOLTAGE_NONE = 0,
	BIAS_VOLTAGE_GRP_CONFIG = 1,
	BIAS_VOLTAGE_PIO_POW_MODE_SEL = 2,
	BIAS_VOLTAGE_PIO_POW_MODE_CTL = 3,
};

enum super_iter_flags_t {
	SUPER_ITER_EXCL = 1,
	SUPER_ITER_UNLOCKED = 2,
	SUPER_ITER_REVERSE = 4,
};

enum support_mode {
	ALLOW_LEGACY = 0,
	DENY_LEGACY = 1,
};

enum suspend_stat_step {
	SUSPEND_WORKING = 0,
	SUSPEND_FREEZE = 1,
	SUSPEND_PREPARE = 2,
	SUSPEND_SUSPEND = 3,
	SUSPEND_SUSPEND_LATE = 4,
	SUSPEND_SUSPEND_NOIRQ = 5,
	SUSPEND_RESUME_NOIRQ = 6,
	SUSPEND_RESUME_EARLY = 7,
	SUSPEND_RESUME = 8,
};

enum svc_auth_status {
	SVC_GARBAGE = 1,
	SVC_SYSERR = 2,
	SVC_VALID = 3,
	SVC_NEGATIVE = 4,
	SVC_OK = 5,
	SVC_DROP = 6,
	SVC_CLOSE = 7,
	SVC_DENIED = 8,
	SVC_PENDING = 9,
	SVC_COMPLETE = 10,
};

enum sw_activity {
	OFF___3 = 0,
	BLINK_ON = 1,
	BLINK_OFF = 2,
};

enum swap_cluster_flags {
	CLUSTER_FLAG_NONE = 0,
	CLUSTER_FLAG_FREE = 1,
	CLUSTER_FLAG_NONFULL = 2,
	CLUSTER_FLAG_FRAG = 3,
	CLUSTER_FLAG_USABLE = 3,
	CLUSTER_FLAG_FULL = 4,
	CLUSTER_FLAG_DISCARD = 5,
	CLUSTER_FLAG_MAX = 6,
};

enum switch_power_state {
	DRM_SWITCH_POWER_ON = 0,
	DRM_SWITCH_POWER_OFF = 1,
	DRM_SWITCH_POWER_CHANGING = 2,
	DRM_SWITCH_POWER_DYNAMIC_OFF = 3,
};

enum switchdev_attr_id {
	SWITCHDEV_ATTR_ID_UNDEFINED = 0,
	SWITCHDEV_ATTR_ID_PORT_STP_STATE = 1,
	SWITCHDEV_ATTR_ID_PORT_MST_STATE = 2,
	SWITCHDEV_ATTR_ID_PORT_BRIDGE_FLAGS = 3,
	SWITCHDEV_ATTR_ID_PORT_PRE_BRIDGE_FLAGS = 4,
	SWITCHDEV_ATTR_ID_PORT_MROUTER = 5,
	SWITCHDEV_ATTR_ID_BRIDGE_AGEING_TIME = 6,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_FILTERING = 7,
	SWITCHDEV_ATTR_ID_BRIDGE_VLAN_PROTOCOL = 8,
	SWITCHDEV_ATTR_ID_BRIDGE_MC_DISABLED = 9,
	SWITCHDEV_ATTR_ID_BRIDGE_MROUTER = 10,
	SWITCHDEV_ATTR_ID_BRIDGE_MST = 11,
	SWITCHDEV_ATTR_ID_MRP_PORT_ROLE = 12,
	SWITCHDEV_ATTR_ID_VLAN_MSTI = 13,
};

enum switchdev_notifier_type {
	SWITCHDEV_FDB_ADD_TO_BRIDGE = 1,
	SWITCHDEV_FDB_DEL_TO_BRIDGE = 2,
	SWITCHDEV_FDB_ADD_TO_DEVICE = 3,
	SWITCHDEV_FDB_DEL_TO_DEVICE = 4,
	SWITCHDEV_FDB_OFFLOADED = 5,
	SWITCHDEV_FDB_FLUSH_TO_BRIDGE = 6,
	SWITCHDEV_PORT_OBJ_ADD = 7,
	SWITCHDEV_PORT_OBJ_DEL = 8,
	SWITCHDEV_PORT_ATTR_SET = 9,
	SWITCHDEV_VXLAN_FDB_ADD_TO_BRIDGE = 10,
	SWITCHDEV_VXLAN_FDB_DEL_TO_BRIDGE = 11,
	SWITCHDEV_VXLAN_FDB_ADD_TO_DEVICE = 12,
	SWITCHDEV_VXLAN_FDB_DEL_TO_DEVICE = 13,
	SWITCHDEV_VXLAN_FDB_OFFLOADED = 14,
	SWITCHDEV_BRPORT_OFFLOADED = 15,
	SWITCHDEV_BRPORT_UNOFFLOADED = 16,
	SWITCHDEV_BRPORT_REPLAY = 17,
};

enum switchdev_obj_id {
	SWITCHDEV_OBJ_ID_UNDEFINED = 0,
	SWITCHDEV_OBJ_ID_PORT_VLAN = 1,
	SWITCHDEV_OBJ_ID_PORT_MDB = 2,
	SWITCHDEV_OBJ_ID_HOST_MDB = 3,
	SWITCHDEV_OBJ_ID_MRP = 4,
	SWITCHDEV_OBJ_ID_RING_TEST_MRP = 5,
	SWITCHDEV_OBJ_ID_RING_ROLE_MRP = 6,
	SWITCHDEV_OBJ_ID_RING_STATE_MRP = 7,
	SWITCHDEV_OBJ_ID_IN_TEST_MRP = 8,
	SWITCHDEV_OBJ_ID_IN_ROLE_MRP = 9,
	SWITCHDEV_OBJ_ID_IN_STATE_MRP = 10,
};

enum sys_off_mode {
	SYS_OFF_MODE_POWER_OFF_PREPARE = 0,
	SYS_OFF_MODE_POWER_OFF = 1,
	SYS_OFF_MODE_RESTART_PREPARE = 2,
	SYS_OFF_MODE_RESTART = 3,
};

enum sys_powerdown {
	SYS_AFTR = 0,
	SYS_LPA = 1,
	SYS_SLEEP = 2,
	NUM_SYS_POWERDOWN = 3,
};

enum sysc_clocks {
	SYSC_FCK = 0,
	SYSC_ICK = 1,
	SYSC_OPTFCK0 = 2,
	SYSC_OPTFCK1 = 3,
	SYSC_OPTFCK2 = 4,
	SYSC_OPTFCK3 = 5,
	SYSC_OPTFCK4 = 6,
	SYSC_OPTFCK5 = 7,
	SYSC_OPTFCK6 = 8,
	SYSC_OPTFCK7 = 9,
	SYSC_MAX_CLOCKS = 10,
};

enum sysc_registers {
	SYSC_REVISION = 0,
	SYSC_SYSCONFIG = 1,
	SYSC_SYSSTATUS = 2,
	SYSC_MAX_REGS = 3,
};

enum sysc_soc {
	SOC_UNKNOWN = 0,
	SOC_2420 = 1,
	SOC_2430 = 2,
	SOC_3430 = 3,
	SOC_AM35 = 4,
	SOC_3630 = 5,
	SOC_4430 = 6,
	SOC_4460 = 7,
	SOC_4470 = 8,
	SOC_5430 = 9,
	SOC_AM3 = 10,
	SOC_AM4 = 11,
	SOC_DRA7 = 12,
};

enum sysctl_writes_mode {
	SYSCTL_WRITES_LEGACY = -1,
	SYSCTL_WRITES_WARN = 0,
	SYSCTL_WRITES_STRICT = 1,
};

enum system_states {
	SYSTEM_BOOTING = 0,
	SYSTEM_SCHEDULING = 1,
	SYSTEM_FREEING_INITMEM = 2,
	SYSTEM_RUNNING = 3,
	SYSTEM_HALT = 4,
	SYSTEM_POWER_OFF = 5,
	SYSTEM_RESTART = 6,
	SYSTEM_SUSPEND = 7,
};

enum t100_type {
	MXT_T100_TYPE_FINGER = 1,
	MXT_T100_TYPE_PASSIVE_STYLUS = 2,
	MXT_T100_TYPE_HOVERING_FINGER = 4,
	MXT_T100_TYPE_GLOVE = 5,
	MXT_T100_TYPE_LARGE_TOUCH = 6,
};

enum t10_dif_type {
	T10_PI_TYPE0_PROTECTION = 0,
	T10_PI_TYPE1_PROTECTION = 1,
	T10_PI_TYPE2_PROTECTION = 2,
	T10_PI_TYPE3_PROTECTION = 3,
};

enum tap_delay_bypass_ctrl {
	PM_TAPDELAY_BYPASS_DISABLE = 0,
	PM_TAPDELAY_BYPASS_ENABLE = 1,
};

enum tap_delay_signal_type {
	PM_TAPDELAY_NAND_DQS_IN = 0,
	PM_TAPDELAY_NAND_DQS_OUT = 1,
	PM_TAPDELAY_QSPI = 2,
	PM_TAPDELAY_MAX = 3,
};

enum tap_delay_type {
	PM_TAPDELAY_INPUT = 0,
	PM_TAPDELAY_OUTPUT = 1,
};

enum task_work_notify_mode {
	TWA_NONE = 0,
	TWA_RESUME = 1,
	TWA_SIGNAL = 2,
	TWA_SIGNAL_NO_IPI = 3,
	TWA_NMI_CURRENT = 4,
};

enum tc_fifo_command {
	TC_FIFO_REPLACE = 0,
	TC_FIFO_DESTROY = 1,
	TC_FIFO_STATS = 2,
};

enum tc_link_layer {
	TC_LINKLAYER_UNAWARE = 0,
	TC_LINKLAYER_ETHERNET = 1,
	TC_LINKLAYER_ATM = 2,
};

enum tc_mq_command {
	TC_MQ_CREATE = 0,
	TC_MQ_DESTROY = 1,
	TC_MQ_STATS = 2,
	TC_MQ_GRAFT = 3,
};

enum tc_root_command {
	TC_ROOT_GRAFT = 0,
};

enum tc_setup_type {
	TC_QUERY_CAPS = 0,
	TC_SETUP_QDISC_MQPRIO = 1,
	TC_SETUP_CLSU32 = 2,
	TC_SETUP_CLSFLOWER = 3,
	TC_SETUP_CLSMATCHALL = 4,
	TC_SETUP_CLSBPF = 5,
	TC_SETUP_BLOCK = 6,
	TC_SETUP_QDISC_CBS = 7,
	TC_SETUP_QDISC_RED = 8,
	TC_SETUP_QDISC_PRIO = 9,
	TC_SETUP_QDISC_MQ = 10,
	TC_SETUP_QDISC_ETF = 11,
	TC_SETUP_ROOT_QDISC = 12,
	TC_SETUP_QDISC_GRED = 13,
	TC_SETUP_QDISC_TAPRIO = 14,
	TC_SETUP_FT = 15,
	TC_SETUP_QDISC_ETS = 16,
	TC_SETUP_QDISC_TBF = 17,
	TC_SETUP_QDISC_FIFO = 18,
	TC_SETUP_QDISC_HTB = 19,
	TC_SETUP_ACT = 20,
};

enum tca_id {
	TCA_ID_UNSPEC = 0,
	TCA_ID_POLICE = 1,
	TCA_ID_GACT = 5,
	TCA_ID_IPT = 6,
	TCA_ID_PEDIT = 7,
	TCA_ID_MIRRED = 8,
	TCA_ID_NAT = 9,
	TCA_ID_XT = 10,
	TCA_ID_SKBEDIT = 11,
	TCA_ID_VLAN = 12,
	TCA_ID_BPF = 13,
	TCA_ID_CONNMARK = 14,
	TCA_ID_SKBMOD = 15,
	TCA_ID_CSUM = 16,
	TCA_ID_TUNNEL_KEY = 17,
	TCA_ID_SIMP = 22,
	TCA_ID_IFE = 25,
	TCA_ID_SAMPLE = 26,
	TCA_ID_CTINFO = 27,
	TCA_ID_MPLS = 28,
	TCA_ID_CT = 29,
	TCA_ID_GATE = 30,
	__TCA_ID_MAX = 255,
};

enum tcf_proto_ops_flags {
	TCF_PROTO_OPS_DOIT_UNLOCKED = 1,
};

enum tcp_ca_ack_event_flags {
	CA_ACK_SLOWPATH = 1,
	CA_ACK_WIN_UPDATE = 2,
	CA_ACK_ECE = 4,
};

enum tcp_ca_event {
	CA_EVENT_TX_START = 0,
	CA_EVENT_CWND_RESTART = 1,
	CA_EVENT_COMPLETE_CWR = 2,
	CA_EVENT_LOSS = 3,
	CA_EVENT_ECN_NO_CE = 4,
	CA_EVENT_ECN_IS_CE = 5,
};

enum tcp_ca_state {
	TCP_CA_Open = 0,
	TCP_CA_Disorder = 1,
	TCP_CA_CWR = 2,
	TCP_CA_Recovery = 3,
	TCP_CA_Loss = 4,
};

enum tcp_chrono {
	TCP_CHRONO_UNSPEC = 0,
	TCP_CHRONO_BUSY = 1,
	TCP_CHRONO_RWND_LIMITED = 2,
	TCP_CHRONO_SNDBUF_LIMITED = 3,
	__TCP_CHRONO_MAX = 4,
};

enum tcp_conntrack {
	TCP_CONNTRACK_NONE = 0,
	TCP_CONNTRACK_SYN_SENT = 1,
	TCP_CONNTRACK_SYN_RECV = 2,
	TCP_CONNTRACK_ESTABLISHED = 3,
	TCP_CONNTRACK_FIN_WAIT = 4,
	TCP_CONNTRACK_CLOSE_WAIT = 5,
	TCP_CONNTRACK_LAST_ACK = 6,
	TCP_CONNTRACK_TIME_WAIT = 7,
	TCP_CONNTRACK_CLOSE = 8,
	TCP_CONNTRACK_LISTEN = 9,
	TCP_CONNTRACK_MAX = 10,
	TCP_CONNTRACK_IGNORE = 11,
	TCP_CONNTRACK_RETRANS = 12,
	TCP_CONNTRACK_UNACK = 13,
	TCP_CONNTRACK_TIMEOUT_MAX = 14,
};

enum tcp_fastopen_client_fail {
	TFO_STATUS_UNSPEC = 0,
	TFO_COOKIE_UNAVAILABLE = 1,
	TFO_DATA_NOT_ACKED = 2,
	TFO_SYN_RETRANSMITTED = 3,
};

enum tcp_metric_index {
	TCP_METRIC_RTT = 0,
	TCP_METRIC_RTTVAR = 1,
	TCP_METRIC_SSTHRESH = 2,
	TCP_METRIC_CWND = 3,
	TCP_METRIC_REORDERING = 4,
	TCP_METRIC_RTT_US = 5,
	TCP_METRIC_RTTVAR_US = 6,
	__TCP_METRIC_MAX = 7,
};

enum tcp_queue {
	TCP_FRAG_IN_WRITE_QUEUE = 0,
	TCP_FRAG_IN_RTX_QUEUE = 1,
};

enum tcp_seq_states {
	TCP_SEQ_STATE_LISTENING = 0,
	TCP_SEQ_STATE_ESTABLISHED = 1,
};

enum tcp_skb_cb_sacked_flags {
	TCPCB_SACKED_ACKED = 1,
	TCPCB_SACKED_RETRANS = 2,
	TCPCB_LOST = 4,
	TCPCB_TAGBITS = 7,
	TCPCB_REPAIRED = 16,
	TCPCB_EVER_RETRANS = 128,
	TCPCB_RETRANS = 146,
};

enum tcp_synack_type {
	TCP_SYNACK_NORMAL = 0,
	TCP_SYNACK_FASTOPEN = 1,
	TCP_SYNACK_COOKIE = 2,
};

enum tcp_tw_status {
	TCP_TW_SUCCESS = 0,
	TCP_TW_RST = 1,
	TCP_TW_ACK = 2,
	TCP_TW_SYN = 3,
	TCP_TW_ACK_OOW = 4,
};

enum tcpa_event_types {
	PREBOOT = 0,
	POST_CODE = 1,
	UNUSED = 2,
	NO_ACTION = 3,
	SEPARATOR = 4,
	ACTION = 5,
	EVENT_TAG = 6,
	SCRTM_CONTENTS = 7,
	SCRTM_VERSION = 8,
	CPU_MICROCODE = 9,
	PLATFORM_CONFIG_FLAGS = 10,
	TABLE_OF_DEVICES = 11,
	COMPACT_HASH = 12,
	IPL = 13,
	IPL_PARTITION_DATA = 14,
	NONHOST_CODE = 15,
	NONHOST_CONFIG = 16,
	NONHOST_INFO = 17,
};

enum tcx_action_base {
	TCX_NEXT = -1,
	TCX_PASS = 0,
	TCX_DROP = 2,
	TCX_REDIRECT = 7,
};

enum tda18271_i2c_gate {
	TDA18271_GATE_AUTO = 0,
	TDA18271_GATE_ANALOG = 1,
	TDA18271_GATE_DIGITAL = 2,
};

enum tda18271_map_type {
	MAIN_PLL = 0,
	CAL_PLL = 1,
	RF_CAL = 2,
	RF_CAL_KMCO = 3,
	RF_CAL_DC_OVER_DT = 4,
	BP_FILTER = 5,
	RF_BAND = 6,
	GAIN_TAPER = 7,
	IR_MEASURE = 8,
};

enum tda18271_mode {
	TDA18271_ANALOG = 0,
	TDA18271_DIGITAL = 1,
};

enum tda18271_output_options {
	TDA18271_OUTPUT_LT_XT_ON = 0,
	TDA18271_OUTPUT_LT_OFF = 1,
	TDA18271_OUTPUT_XT_OFF = 2,
};

enum tda18271_pll {
	TDA18271_MAIN_PLL = 0,
	TDA18271_CAL_PLL = 1,
};

enum tda18271_role {
	TDA18271_MASTER = 0,
	TDA18271_SLAVE = 1,
};

enum tda18271_small_i2c {
	TDA18271_39_BYTE_CHUNK_INIT = 0,
	TDA18271_16_BYTE_CHUNK_INIT = 16,
	TDA18271_08_BYTE_CHUNK_INIT = 8,
	TDA18271_03_BYTE_CHUNK_INIT = 3,
};

enum tda18271_ver {
	TDA18271HDC1 = 0,
	TDA18271HDC2 = 1,
};

enum tda8290_lna {
	TDA8290_LNA_OFF = 0,
	TDA8290_LNA_GP0_HIGH_ON = 1,
	TDA8290_LNA_GP0_HIGH_OFF = 2,
	TDA8290_LNA_ON_BRIDGE = 3,
};

enum tea5767_xtal {
	TEA5767_LOW_LO_32768 = 0,
	TEA5767_HIGH_LO_32768 = 1,
	TEA5767_LOW_LO_13MHz = 2,
	TEA5767_HIGH_LO_13MHz = 3,
};

enum tegra124_function {
	TEGRA124_FUNC_SNPS = 0,
	TEGRA124_FUNC_XUSB = 1,
	TEGRA124_FUNC_UART = 2,
	TEGRA124_FUNC_PCIE = 3,
	TEGRA124_FUNC_USB3 = 4,
	TEGRA124_FUNC_SATA = 5,
	TEGRA124_FUNC_RSVD = 6,
};

enum tegra_actmon_device {
	MCALL = 0,
	MCCPU = 1,
};

enum tegra_dfll_pmu_if {
	TEGRA_DFLL_PMU_I2C = 0,
	TEGRA_DFLL_PMU_PWM = 1,
};

enum tegra_icc_client_type {
	TEGRA_ICC_NONE = 0,
	TEGRA_ICC_NISO = 1,
	TEGRA_ICC_ISO_DISPLAY = 2,
	TEGRA_ICC_ISO_VI = 3,
	TEGRA_ICC_ISO_AUDIO = 4,
	TEGRA_ICC_ISO_VIFAL = 5,
};

enum tegra_io_pad {
	TEGRA_IO_PAD_AUDIO = 0,
	TEGRA_IO_PAD_AUDIO_HV = 1,
	TEGRA_IO_PAD_BB = 2,
	TEGRA_IO_PAD_CAM = 3,
	TEGRA_IO_PAD_COMP = 4,
	TEGRA_IO_PAD_CONN = 5,
	TEGRA_IO_PAD_CSIA = 6,
	TEGRA_IO_PAD_CSIB = 7,
	TEGRA_IO_PAD_CSIC = 8,
	TEGRA_IO_PAD_CSID = 9,
	TEGRA_IO_PAD_CSIE = 10,
	TEGRA_IO_PAD_CSIF = 11,
	TEGRA_IO_PAD_CSIG = 12,
	TEGRA_IO_PAD_CSIH = 13,
	TEGRA_IO_PAD_DAP3 = 14,
	TEGRA_IO_PAD_DAP5 = 15,
	TEGRA_IO_PAD_DBG = 16,
	TEGRA_IO_PAD_DEBUG_NONAO = 17,
	TEGRA_IO_PAD_DMIC = 18,
	TEGRA_IO_PAD_DMIC_HV = 19,
	TEGRA_IO_PAD_DP = 20,
	TEGRA_IO_PAD_DSI = 21,
	TEGRA_IO_PAD_DSIB = 22,
	TEGRA_IO_PAD_DSIC = 23,
	TEGRA_IO_PAD_DSID = 24,
	TEGRA_IO_PAD_EDP = 25,
	TEGRA_IO_PAD_EMMC = 26,
	TEGRA_IO_PAD_EMMC2 = 27,
	TEGRA_IO_PAD_EQOS = 28,
	TEGRA_IO_PAD_GPIO = 29,
	TEGRA_IO_PAD_GP_PWM2 = 30,
	TEGRA_IO_PAD_GP_PWM3 = 31,
	TEGRA_IO_PAD_HDMI = 32,
	TEGRA_IO_PAD_HDMI_DP0 = 33,
	TEGRA_IO_PAD_HDMI_DP1 = 34,
	TEGRA_IO_PAD_HDMI_DP2 = 35,
	TEGRA_IO_PAD_HDMI_DP3 = 36,
	TEGRA_IO_PAD_HSIC = 37,
	TEGRA_IO_PAD_HV = 38,
	TEGRA_IO_PAD_LVDS = 39,
	TEGRA_IO_PAD_MIPI_BIAS = 40,
	TEGRA_IO_PAD_NAND = 41,
	TEGRA_IO_PAD_PEX_BIAS = 42,
	TEGRA_IO_PAD_PEX_CLK_BIAS = 43,
	TEGRA_IO_PAD_PEX_CLK1 = 44,
	TEGRA_IO_PAD_PEX_CLK2 = 45,
	TEGRA_IO_PAD_PEX_CLK3 = 46,
	TEGRA_IO_PAD_PEX_CLK_2_BIAS = 47,
	TEGRA_IO_PAD_PEX_CLK_2 = 48,
	TEGRA_IO_PAD_PEX_CNTRL = 49,
	TEGRA_IO_PAD_PEX_CTL2 = 50,
	TEGRA_IO_PAD_PEX_L0_RST = 51,
	TEGRA_IO_PAD_PEX_L1_RST = 52,
	TEGRA_IO_PAD_PEX_L5_RST = 53,
	TEGRA_IO_PAD_PWR_CTL = 54,
	TEGRA_IO_PAD_SDMMC1 = 55,
	TEGRA_IO_PAD_SDMMC1_HV = 56,
	TEGRA_IO_PAD_SDMMC2 = 57,
	TEGRA_IO_PAD_SDMMC2_HV = 58,
	TEGRA_IO_PAD_SDMMC3 = 59,
	TEGRA_IO_PAD_SDMMC3_HV = 60,
	TEGRA_IO_PAD_SDMMC4 = 61,
	TEGRA_IO_PAD_SOC_GPIO10 = 62,
	TEGRA_IO_PAD_SOC_GPIO12 = 63,
	TEGRA_IO_PAD_SOC_GPIO13 = 64,
	TEGRA_IO_PAD_SOC_GPIO53 = 65,
	TEGRA_IO_PAD_SPI = 66,
	TEGRA_IO_PAD_SPI_HV = 67,
	TEGRA_IO_PAD_SYS_DDC = 68,
	TEGRA_IO_PAD_UART = 69,
	TEGRA_IO_PAD_UART4 = 70,
	TEGRA_IO_PAD_UART5 = 71,
	TEGRA_IO_PAD_UFS = 72,
	TEGRA_IO_PAD_USB0 = 73,
	TEGRA_IO_PAD_USB1 = 74,
	TEGRA_IO_PAD_USB2 = 75,
	TEGRA_IO_PAD_USB3 = 76,
	TEGRA_IO_PAD_USB_BIAS = 77,
	TEGRA_IO_PAD_AO_HV = 78,
};

enum tegra_mux {
	TEGRA_MUX_BLINK = 0,
	TEGRA_MUX_CCLA = 1,
	TEGRA_MUX_CEC = 2,
	TEGRA_MUX_CLDVFS = 3,
	TEGRA_MUX_CLK = 4,
	TEGRA_MUX_CLK12 = 5,
	TEGRA_MUX_CPU = 6,
	TEGRA_MUX_CSI = 7,
	TEGRA_MUX_DAP = 8,
	TEGRA_MUX_DAP1 = 9,
	TEGRA_MUX_DAP2 = 10,
	TEGRA_MUX_DEV3 = 11,
	TEGRA_MUX_DISPLAYA = 12,
	TEGRA_MUX_DISPLAYA_ALT = 13,
	TEGRA_MUX_DISPLAYB = 14,
	TEGRA_MUX_DP = 15,
	TEGRA_MUX_DSI_B = 16,
	TEGRA_MUX_DTV = 17,
	TEGRA_MUX_EXTPERIPH1 = 18,
	TEGRA_MUX_EXTPERIPH2 = 19,
	TEGRA_MUX_EXTPERIPH3 = 20,
	TEGRA_MUX_GMI = 21,
	TEGRA_MUX_GMI_ALT = 22,
	TEGRA_MUX_HDA = 23,
	TEGRA_MUX_HSI = 24,
	TEGRA_MUX_I2C1 = 25,
	TEGRA_MUX_I2C2 = 26,
	TEGRA_MUX_I2C3 = 27,
	TEGRA_MUX_I2C4 = 28,
	TEGRA_MUX_I2CPWR = 29,
	TEGRA_MUX_I2S0 = 30,
	TEGRA_MUX_I2S1 = 31,
	TEGRA_MUX_I2S2 = 32,
	TEGRA_MUX_I2S3 = 33,
	TEGRA_MUX_I2S4 = 34,
	TEGRA_MUX_IRDA = 35,
	TEGRA_MUX_KBC = 36,
	TEGRA_MUX_OWR = 37,
	TEGRA_MUX_PE = 38,
	TEGRA_MUX_PE0 = 39,
	TEGRA_MUX_PE1 = 40,
	TEGRA_MUX_PMI = 41,
	TEGRA_MUX_PWM0 = 42,
	TEGRA_MUX_PWM1 = 43,
	TEGRA_MUX_PWM2 = 44,
	TEGRA_MUX_PWM3 = 45,
	TEGRA_MUX_PWRON = 46,
	TEGRA_MUX_RESET_OUT_N = 47,
	TEGRA_MUX_RSVD1 = 48,
	TEGRA_MUX_RSVD2 = 49,
	TEGRA_MUX_RSVD3 = 50,
	TEGRA_MUX_RSVD4 = 51,
	TEGRA_MUX_RTCK = 52,
	TEGRA_MUX_SATA = 53,
	TEGRA_MUX_SDMMC1 = 54,
	TEGRA_MUX_SDMMC2 = 55,
	TEGRA_MUX_SDMMC3 = 56,
	TEGRA_MUX_SDMMC4 = 57,
	TEGRA_MUX_SOC = 58,
	TEGRA_MUX_SPDIF = 59,
	TEGRA_MUX_SPI1 = 60,
	TEGRA_MUX_SPI2 = 61,
	TEGRA_MUX_SPI3 = 62,
	TEGRA_MUX_SPI4 = 63,
	TEGRA_MUX_SPI5 = 64,
	TEGRA_MUX_SPI6 = 65,
	TEGRA_MUX_SYS = 66,
	TEGRA_MUX_TMDS = 67,
	TEGRA_MUX_TRACE = 68,
	TEGRA_MUX_UARTA = 69,
	TEGRA_MUX_UARTB = 70,
	TEGRA_MUX_UARTC = 71,
	TEGRA_MUX_UARTD = 72,
	TEGRA_MUX_ULPI = 73,
	TEGRA_MUX_USB = 74,
	TEGRA_MUX_VGP1 = 75,
	TEGRA_MUX_VGP2 = 76,
	TEGRA_MUX_VGP3 = 77,
	TEGRA_MUX_VGP4 = 78,
	TEGRA_MUX_VGP5 = 79,
	TEGRA_MUX_VGP6 = 80,
	TEGRA_MUX_VI = 81,
	TEGRA_MUX_VI_ALT1 = 82,
	TEGRA_MUX_VI_ALT3 = 83,
	TEGRA_MUX_VIMCLK2 = 84,
	TEGRA_MUX_VIMCLK2_ALT = 85,
};

enum tegra_mux___2 {
	TEGRA_MUX_BLINK___2 = 0,
	TEGRA_MUX_CEC___2 = 1,
	TEGRA_MUX_CLDVFS___2 = 2,
	TEGRA_MUX_CLK___2 = 3,
	TEGRA_MUX_CLK12___2 = 4,
	TEGRA_MUX_CPU___2 = 5,
	TEGRA_MUX_DAP___2 = 6,
	TEGRA_MUX_DAP1___2 = 7,
	TEGRA_MUX_DAP2___2 = 8,
	TEGRA_MUX_DEV3___2 = 9,
	TEGRA_MUX_DISPLAYA___2 = 10,
	TEGRA_MUX_DISPLAYA_ALT___2 = 11,
	TEGRA_MUX_DISPLAYB___2 = 12,
	TEGRA_MUX_DTV___2 = 13,
	TEGRA_MUX_EMC_DLL = 14,
	TEGRA_MUX_EXTPERIPH1___2 = 15,
	TEGRA_MUX_EXTPERIPH2___2 = 16,
	TEGRA_MUX_EXTPERIPH3___2 = 17,
	TEGRA_MUX_GMI___2 = 18,
	TEGRA_MUX_GMI_ALT___2 = 19,
	TEGRA_MUX_HDA___2 = 20,
	TEGRA_MUX_HSI___2 = 21,
	TEGRA_MUX_I2C1___2 = 22,
	TEGRA_MUX_I2C2___2 = 23,
	TEGRA_MUX_I2C3___2 = 24,
	TEGRA_MUX_I2C4___2 = 25,
	TEGRA_MUX_I2CPWR___2 = 26,
	TEGRA_MUX_I2S0___2 = 27,
	TEGRA_MUX_I2S1___2 = 28,
	TEGRA_MUX_I2S2___2 = 29,
	TEGRA_MUX_I2S3___2 = 30,
	TEGRA_MUX_I2S4___2 = 31,
	TEGRA_MUX_IRDA___2 = 32,
	TEGRA_MUX_KBC___2 = 33,
	TEGRA_MUX_NAND = 34,
	TEGRA_MUX_NAND_ALT = 35,
	TEGRA_MUX_OWR___2 = 36,
	TEGRA_MUX_PMI___2 = 37,
	TEGRA_MUX_PWM0___2 = 38,
	TEGRA_MUX_PWM1___2 = 39,
	TEGRA_MUX_PWM2___2 = 40,
	TEGRA_MUX_PWM3___2 = 41,
	TEGRA_MUX_PWRON___2 = 42,
	TEGRA_MUX_RESET_OUT_N___2 = 43,
	TEGRA_MUX_RSVD1___2 = 44,
	TEGRA_MUX_RSVD2___2 = 45,
	TEGRA_MUX_RSVD3___2 = 46,
	TEGRA_MUX_RSVD4___2 = 47,
	TEGRA_MUX_RTCK___2 = 48,
	TEGRA_MUX_SDMMC1___2 = 49,
	TEGRA_MUX_SDMMC2___2 = 50,
	TEGRA_MUX_SDMMC3___2 = 51,
	TEGRA_MUX_SDMMC4___2 = 52,
	TEGRA_MUX_SOC___2 = 53,
	TEGRA_MUX_SPDIF___2 = 54,
	TEGRA_MUX_SPI1___2 = 55,
	TEGRA_MUX_SPI2___2 = 56,
	TEGRA_MUX_SPI3___2 = 57,
	TEGRA_MUX_SPI4___2 = 58,
	TEGRA_MUX_SPI5___2 = 59,
	TEGRA_MUX_SPI6___2 = 60,
	TEGRA_MUX_SYSCLK = 61,
	TEGRA_MUX_TRACE___2 = 62,
	TEGRA_MUX_UARTA___2 = 63,
	TEGRA_MUX_UARTB___2 = 64,
	TEGRA_MUX_UARTC___2 = 65,
	TEGRA_MUX_UARTD___2 = 66,
	TEGRA_MUX_ULPI___2 = 67,
	TEGRA_MUX_USB___2 = 68,
	TEGRA_MUX_VGP1___2 = 69,
	TEGRA_MUX_VGP2___2 = 70,
	TEGRA_MUX_VGP3___2 = 71,
	TEGRA_MUX_VGP4___2 = 72,
	TEGRA_MUX_VGP5___2 = 73,
	TEGRA_MUX_VGP6___2 = 74,
	TEGRA_MUX_VI___2 = 75,
	TEGRA_MUX_VI_ALT1___2 = 76,
	TEGRA_MUX_VI_ALT3___2 = 77,
};

enum tegra_mux___3 {
	TEGRA_MUX_BLINK___3 = 0,
	TEGRA_MUX_CEC___3 = 1,
	TEGRA_MUX_CLK_12M_OUT = 2,
	TEGRA_MUX_CLK_32K_IN = 3,
	TEGRA_MUX_CORE_PWR_REQ = 4,
	TEGRA_MUX_CPU_PWR_REQ = 5,
	TEGRA_MUX_CRT = 6,
	TEGRA_MUX_DAP___3 = 7,
	TEGRA_MUX_DDR = 8,
	TEGRA_MUX_DEV3___3 = 9,
	TEGRA_MUX_DISPLAYA___3 = 10,
	TEGRA_MUX_DISPLAYB___3 = 11,
	TEGRA_MUX_DTV___3 = 12,
	TEGRA_MUX_EXTPERIPH1___3 = 13,
	TEGRA_MUX_EXTPERIPH2___3 = 14,
	TEGRA_MUX_EXTPERIPH3___3 = 15,
	TEGRA_MUX_GMI___3 = 16,
	TEGRA_MUX_GMI_ALT___3 = 17,
	TEGRA_MUX_HDA___3 = 18,
	TEGRA_MUX_HDCP = 19,
	TEGRA_MUX_HDMI = 20,
	TEGRA_MUX_HSI___3 = 21,
	TEGRA_MUX_I2C1___3 = 22,
	TEGRA_MUX_I2C2___3 = 23,
	TEGRA_MUX_I2C3___3 = 24,
	TEGRA_MUX_I2C4___3 = 25,
	TEGRA_MUX_I2CPWR___3 = 26,
	TEGRA_MUX_I2S0___3 = 27,
	TEGRA_MUX_I2S1___3 = 28,
	TEGRA_MUX_I2S2___3 = 29,
	TEGRA_MUX_I2S3___3 = 30,
	TEGRA_MUX_I2S4___3 = 31,
	TEGRA_MUX_INVALID = 32,
	TEGRA_MUX_KBC___3 = 33,
	TEGRA_MUX_MIO = 34,
	TEGRA_MUX_NAND___2 = 35,
	TEGRA_MUX_NAND_ALT___2 = 36,
	TEGRA_MUX_OWR___3 = 37,
	TEGRA_MUX_PCIE = 38,
	TEGRA_MUX_PWM0___3 = 39,
	TEGRA_MUX_PWM1___3 = 40,
	TEGRA_MUX_PWM2___3 = 41,
	TEGRA_MUX_PWM3___3 = 42,
	TEGRA_MUX_PWR_INT_N = 43,
	TEGRA_MUX_RSVD1___3 = 44,
	TEGRA_MUX_RSVD2___3 = 45,
	TEGRA_MUX_RSVD3___3 = 46,
	TEGRA_MUX_RSVD4___3 = 47,
	TEGRA_MUX_RTCK___3 = 48,
	TEGRA_MUX_SATA___2 = 49,
	TEGRA_MUX_SDMMC1___3 = 50,
	TEGRA_MUX_SDMMC2___3 = 51,
	TEGRA_MUX_SDMMC3___3 = 52,
	TEGRA_MUX_SDMMC4___3 = 53,
	TEGRA_MUX_SPDIF___3 = 54,
	TEGRA_MUX_SPI1___3 = 55,
	TEGRA_MUX_SPI2___3 = 56,
	TEGRA_MUX_SPI2_ALT = 57,
	TEGRA_MUX_SPI3___3 = 58,
	TEGRA_MUX_SPI4___3 = 59,
	TEGRA_MUX_SPI5___3 = 60,
	TEGRA_MUX_SPI6___3 = 61,
	TEGRA_MUX_SYSCLK___2 = 62,
	TEGRA_MUX_TEST = 63,
	TEGRA_MUX_TRACE___3 = 64,
	TEGRA_MUX_UARTA___3 = 65,
	TEGRA_MUX_UARTB___3 = 66,
	TEGRA_MUX_UARTC___3 = 67,
	TEGRA_MUX_UARTD___3 = 68,
	TEGRA_MUX_UARTE = 69,
	TEGRA_MUX_ULPI___3 = 70,
	TEGRA_MUX_VGP1___3 = 71,
	TEGRA_MUX_VGP2___3 = 72,
	TEGRA_MUX_VGP3___3 = 73,
	TEGRA_MUX_VGP4___3 = 74,
	TEGRA_MUX_VGP5___3 = 75,
	TEGRA_MUX_VGP6___3 = 76,
	TEGRA_MUX_VI___3 = 77,
	TEGRA_MUX_VI_ALT1___3 = 78,
	TEGRA_MUX_VI_ALT2 = 79,
	TEGRA_MUX_VI_ALT3___3 = 80,
};

enum tegra_mux___4 {
	TEGRA_MUX_AHB_CLK = 0,
	TEGRA_MUX_APB_CLK = 1,
	TEGRA_MUX_AUDIO_SYNC = 2,
	TEGRA_MUX_CRT___2 = 3,
	TEGRA_MUX_DAP1___3 = 4,
	TEGRA_MUX_DAP2___3 = 5,
	TEGRA_MUX_DAP3 = 6,
	TEGRA_MUX_DAP4 = 7,
	TEGRA_MUX_DAP5 = 8,
	TEGRA_MUX_DISPLAYA___4 = 9,
	TEGRA_MUX_DISPLAYB___4 = 10,
	TEGRA_MUX_EMC_TEST0_DLL = 11,
	TEGRA_MUX_EMC_TEST1_DLL = 12,
	TEGRA_MUX_GMI___4 = 13,
	TEGRA_MUX_GMI_INT = 14,
	TEGRA_MUX_HDMI___2 = 15,
	TEGRA_MUX_I2CP = 16,
	TEGRA_MUX_I2C1___4 = 17,
	TEGRA_MUX_I2C2___4 = 18,
	TEGRA_MUX_I2C3___4 = 19,
	TEGRA_MUX_IDE = 20,
	TEGRA_MUX_IRDA___3 = 21,
	TEGRA_MUX_KBC___4 = 22,
	TEGRA_MUX_MIO___2 = 23,
	TEGRA_MUX_MIPI_HS = 24,
	TEGRA_MUX_NAND___3 = 25,
	TEGRA_MUX_OSC = 26,
	TEGRA_MUX_OWR___4 = 27,
	TEGRA_MUX_PCIE___2 = 28,
	TEGRA_MUX_PLLA_OUT = 29,
	TEGRA_MUX_PLLC_OUT1 = 30,
	TEGRA_MUX_PLLM_OUT1 = 31,
	TEGRA_MUX_PLLP_OUT2 = 32,
	TEGRA_MUX_PLLP_OUT3 = 33,
	TEGRA_MUX_PLLP_OUT4 = 34,
	TEGRA_MUX_PWM = 35,
	TEGRA_MUX_PWR_INTR = 36,
	TEGRA_MUX_PWR_ON = 37,
	TEGRA_MUX_RSVD1___4 = 38,
	TEGRA_MUX_RSVD2___4 = 39,
	TEGRA_MUX_RSVD3___4 = 40,
	TEGRA_MUX_RSVD4___4 = 41,
	TEGRA_MUX_RTCK___4 = 42,
	TEGRA_MUX_SDIO1 = 43,
	TEGRA_MUX_SDIO2 = 44,
	TEGRA_MUX_SDIO3 = 45,
	TEGRA_MUX_SDIO4 = 46,
	TEGRA_MUX_SFLASH = 47,
	TEGRA_MUX_SPDIF___4 = 48,
	TEGRA_MUX_SPI1___4 = 49,
	TEGRA_MUX_SPI2___4 = 50,
	TEGRA_MUX_SPI2_ALT___2 = 51,
	TEGRA_MUX_SPI3___4 = 52,
	TEGRA_MUX_SPI4___4 = 53,
	TEGRA_MUX_TRACE___4 = 54,
	TEGRA_MUX_TWC = 55,
	TEGRA_MUX_UARTA___4 = 56,
	TEGRA_MUX_UARTB___4 = 57,
	TEGRA_MUX_UARTC___4 = 58,
	TEGRA_MUX_UARTD___4 = 59,
	TEGRA_MUX_UARTE___2 = 60,
	TEGRA_MUX_ULPI___4 = 61,
	TEGRA_MUX_VI___4 = 62,
	TEGRA_MUX_VI_SENSOR_CLK = 63,
	TEGRA_MUX_XIO = 64,
};

enum tegra_pinconf_param {
	TEGRA_PINCONF_PARAM_PULL = 0,
	TEGRA_PINCONF_PARAM_TRISTATE = 1,
	TEGRA_PINCONF_PARAM_ENABLE_INPUT = 2,
	TEGRA_PINCONF_PARAM_OPEN_DRAIN = 3,
	TEGRA_PINCONF_PARAM_LOCK = 4,
	TEGRA_PINCONF_PARAM_IORESET = 5,
	TEGRA_PINCONF_PARAM_RCV_SEL = 6,
	TEGRA_PINCONF_PARAM_HIGH_SPEED_MODE = 7,
	TEGRA_PINCONF_PARAM_SCHMITT = 8,
	TEGRA_PINCONF_PARAM_LOW_POWER_MODE = 9,
	TEGRA_PINCONF_PARAM_DRIVE_DOWN_STRENGTH = 10,
	TEGRA_PINCONF_PARAM_DRIVE_UP_STRENGTH = 11,
	TEGRA_PINCONF_PARAM_SLEW_RATE_FALLING = 12,
	TEGRA_PINCONF_PARAM_SLEW_RATE_RISING = 13,
	TEGRA_PINCONF_PARAM_DRIVE_TYPE = 14,
	TEGRA_PINCONF_PARAM_GPIO_MODE = 15,
};

enum tegra_platform {
	TEGRA_PLATFORM_SILICON = 0,
	TEGRA_PLATFORM_QT = 1,
	TEGRA_PLATFORM_SYSTEM_FPGA = 2,
	TEGRA_PLATFORM_UNIT_FPGA = 3,
	TEGRA_PLATFORM_ASIM_QT = 4,
	TEGRA_PLATFORM_ASIM_LINSIM = 5,
	TEGRA_PLATFORM_DSIM_ASIM_LINSIM = 6,
	TEGRA_PLATFORM_VERIFICATION_SIMULATION = 7,
	TEGRA_PLATFORM_VDK = 8,
	TEGRA_PLATFORM_VSP = 9,
	TEGRA_PLATFORM_MAX = 10,
};

enum tegra_revision {
	TEGRA_REVISION_UNKNOWN = 0,
	TEGRA_REVISION_A01 = 1,
	TEGRA_REVISION_A02 = 2,
	TEGRA_REVISION_A03 = 3,
	TEGRA_REVISION_A03p = 4,
	TEGRA_REVISION_A04 = 5,
	TEGRA_REVISION_MAX = 6,
};

enum tegra_state {
	TEGRA_C1 = 0,
	TEGRA_C7 = 1,
	TEGRA_CC6 = 2,
	TEGRA_STATE_COUNT = 3,
};

enum tegra_super_gen {
	gen4 = 4,
	gen5 = 5,
};

enum tegra_suspend_mode {
	TEGRA_SUSPEND_NONE = 0,
	TEGRA_SUSPEND_LP2 = 1,
	TEGRA_SUSPEND_LP1 = 2,
	TEGRA_SUSPEND_LP0 = 3,
	TEGRA_MAX_SUSPEND_MODE = 4,
	TEGRA_SUSPEND_NOT_READY = 5,
};

enum tegra_usb_phy_port_speed {
	TEGRA_USB_PHY_PORT_SPEED_FULL = 0,
	TEGRA_USB_PHY_PORT_SPEED_LOW = 1,
	TEGRA_USB_PHY_PORT_SPEED_HIGH = 2,
};

enum tegra_xusb_padctl_param {
	TEGRA_XUSB_PADCTL_IDDQ = 0,
};

enum temp_type {
	HOT = 0,
	WARM = 1,
	COLD = 2,
	NR_TEMP_TYPE = 3,
};

enum tg_state_flags {
	THROTL_TG_PENDING = 1,
	THROTL_TG_WAS_EMPTY = 2,
	THROTL_TG_IOPS_WAS_EMPTY = 4,
	THROTL_TG_CANCELING = 8,
};

enum thermal_device_mode {
	THERMAL_DEVICE_DISABLED = 0,
	THERMAL_DEVICE_ENABLED = 1,
};

enum thermal_notify_event {
	THERMAL_EVENT_UNSPECIFIED = 0,
	THERMAL_EVENT_TEMP_SAMPLE = 1,
	THERMAL_TRIP_VIOLATED = 2,
	THERMAL_TRIP_CHANGED = 3,
	THERMAL_DEVICE_DOWN = 4,
	THERMAL_DEVICE_UP = 5,
	THERMAL_DEVICE_POWER_CAPABILITY_CHANGED = 6,
	THERMAL_TABLE_CHANGED = 7,
	THERMAL_EVENT_KEEP_ALIVE = 8,
	THERMAL_TZ_BIND_CDEV = 9,
	THERMAL_TZ_UNBIND_CDEV = 10,
	THERMAL_INSTANCE_WEIGHT_CHANGED = 11,
	THERMAL_TZ_RESUME = 12,
	THERMAL_TZ_ADD_THRESHOLD = 13,
	THERMAL_TZ_DEL_THRESHOLD = 14,
	THERMAL_TZ_FLUSH_THRESHOLDS = 15,
};

enum thermal_trend {
	THERMAL_TREND_STABLE = 0,
	THERMAL_TREND_RAISING = 1,
	THERMAL_TREND_DROPPING = 2,
};

enum thermal_trip_type {
	THERMAL_TRIP_ACTIVE = 0,
	THERMAL_TRIP_PASSIVE = 1,
	THERMAL_TRIP_HOT = 2,
	THERMAL_TRIP_CRITICAL = 3,
};

enum ti_adpll_clocks {
	TI_ADPLL_DCO = 0,
	TI_ADPLL_DCO_GATE = 1,
	TI_ADPLL_N2 = 2,
	TI_ADPLL_M2 = 3,
	TI_ADPLL_M2_GATE = 4,
	TI_ADPLL_BYPASS = 5,
	TI_ADPLL_HIF = 6,
	TI_ADPLL_DIV2 = 7,
	TI_ADPLL_CLKOUT = 8,
	TI_ADPLL_CLKOUT2 = 9,
	TI_ADPLL_M3 = 10,
};

enum ti_adpll_inputs {
	TI_ADPLL_CLKINP = 0,
	TI_ADPLL_CLKINPULOW = 1,
	TI_ADPLL_CLKINPHIF = 2,
};

enum ti_adpll_lj_outputs {
	TI_ADPLL_LJ_CLKDCOLDO = 0,
	TI_ADPLL_LJ_CLKOUT = 1,
	TI_ADPLL_LJ_CLKOUTLDO = 2,
};

enum ti_adpll_s_outputs {
	TI_ADPLL_S_DCOCLKLDO = 0,
	TI_ADPLL_S_CLKOUT = 1,
	TI_ADPLL_S_CLKOUTX2 = 2,
	TI_ADPLL_S_CLKOUTHIF = 3,
};

enum ti_sysc_module_type {
	TI_SYSC_OMAP2 = 0,
	TI_SYSC_OMAP2_TIMER = 1,
	TI_SYSC_OMAP3_SHAM = 2,
	TI_SYSC_OMAP3_AES = 3,
	TI_SYSC_OMAP4 = 4,
	TI_SYSC_OMAP4_TIMER = 5,
	TI_SYSC_OMAP4_SIMPLE = 6,
	TI_SYSC_OMAP34XX_SR = 7,
	TI_SYSC_OMAP36XX_SR = 8,
	TI_SYSC_OMAP4_SR = 9,
	TI_SYSC_OMAP4_MCASP = 10,
	TI_SYSC_OMAP4_USB_HOST_FS = 11,
	TI_SYSC_DRA7_MCAN = 12,
	TI_SYSC_PRUSS = 13,
};

enum tick_broadcast_mode {
	TICK_BROADCAST_OFF = 0,
	TICK_BROADCAST_ON = 1,
	TICK_BROADCAST_FORCE = 2,
};

enum tick_broadcast_state {
	TICK_BROADCAST_EXIT = 0,
	TICK_BROADCAST_ENTER = 1,
};

enum tick_dep_bits {
	TICK_DEP_BIT_POSIX_TIMER = 0,
	TICK_DEP_BIT_PERF_EVENTS = 1,
	TICK_DEP_BIT_SCHED = 2,
	TICK_DEP_BIT_CLOCK_UNSTABLE = 3,
	TICK_DEP_BIT_RCU = 4,
	TICK_DEP_BIT_RCU_EXP = 5,
};

enum tick_device_mode {
	TICKDEV_MODE_PERIODIC = 0,
	TICKDEV_MODE_ONESHOT = 1,
};

enum timekeeping_adv_mode {
	TK_ADV_TICK = 0,
	TK_ADV_FREQ = 1,
};

enum timespec_type {
	TT_NONE = 0,
	TT_NATIVE = 1,
	TT_COMPAT = 2,
};

enum tk_offsets {
	TK_OFFS_REAL = 0,
	TK_OFFS_BOOT = 1,
	TK_OFFS_TAI = 2,
	TK_OFFS_MAX = 3,
};

enum tp_mode {
	IAP_MODE = 1,
	MAIN_MODE = 2,
};

enum tpacket_versions {
	TPACKET_V1 = 0,
	TPACKET_V2 = 1,
	TPACKET_V3 = 2,
};

enum tpm_duration {
	TPM_SHORT = 0,
	TPM_MEDIUM = 1,
	TPM_LONG = 2,
	TPM_LONG_LONG = 3,
	TPM_UNDEFINED = 4,
	TPM_NUM_DURATIONS = 4,
};

enum tps65086_irqs {
	TPS65086_IRQ_DIETEMP = 0,
	TPS65086_IRQ_SHUTDN = 1,
	TPS65086_IRQ_FAULT = 2,
};

enum tps65090_cells {
	PMIC = 0,
	CHARGER = 1,
};

enum tps65217_bl_fdim {
	TPS65217_BL_FDIM_100HZ = 0,
	TPS65217_BL_FDIM_200HZ = 1,
	TPS65217_BL_FDIM_500HZ = 2,
	TPS65217_BL_FDIM_1000HZ = 3,
};

enum tps65217_bl_isel {
	TPS65217_BL_ISET1 = 1,
	TPS65217_BL_ISET2 = 2,
};

enum tps65217_regulator_id {
	TPS65217_DCDC_1 = 0,
	TPS65217_DCDC_2 = 1,
	TPS65217_DCDC_3 = 2,
	TPS65217_LDO_1 = 3,
	TPS65217_LDO_2 = 4,
	TPS65217_LDO_3 = 5,
	TPS65217_LDO_4 = 6,
};

enum tps65218_irqs {
	TPS65218_PRGC_IRQ = 0,
	TPS65218_CC_AQC_IRQ = 1,
	TPS65218_HOT_IRQ = 2,
	TPS65218_PB_IRQ = 3,
	TPS65218_AC_IRQ = 4,
	TPS65218_VPRG_IRQ = 5,
	TPS65218_INVALID1_IRQ = 6,
	TPS65218_INVALID2_IRQ = 7,
	TPS65218_LS1_I_IRQ = 8,
	TPS65218_LS2_I_IRQ = 9,
	TPS65218_LS3_I_IRQ = 10,
	TPS65218_LS1_F_IRQ = 11,
	TPS65218_LS2_F_IRQ = 12,
	TPS65218_LS3_F_IRQ = 13,
	TPS65218_INVALID3_IRQ = 14,
	TPS65218_INVALID4_IRQ = 15,
};

enum tps65218_regulator_id {
	TPS65218_DCDC_1 = 0,
	TPS65218_DCDC_2 = 1,
	TPS65218_DCDC_3 = 2,
	TPS65218_DCDC_4 = 3,
	TPS65218_DCDC_5 = 4,
	TPS65218_DCDC_6 = 5,
	TPS65218_LDO_1 = 6,
	TPS65218_LS_2 = 7,
	TPS65218_LS_3 = 8,
};

enum tps65917_external_requestor_id {
	TPS65917_EXTERNAL_REQSTR_ID_REGEN1 = 0,
	TPS65917_EXTERNAL_REQSTR_ID_REGEN2 = 1,
	TPS65917_EXTERNAL_REQSTR_ID_REGEN3 = 2,
	TPS65917_EXTERNAL_REQSTR_ID_SMPS1 = 3,
	TPS65917_EXTERNAL_REQSTR_ID_SMPS2 = 4,
	TPS65917_EXTERNAL_REQSTR_ID_SMPS3 = 5,
	TPS65917_EXTERNAL_REQSTR_ID_SMPS4 = 6,
	TPS65917_EXTERNAL_REQSTR_ID_SMPS5 = 7,
	TPS65917_EXTERNAL_REQSTR_ID_SMPS12 = 8,
	TPS65917_EXTERNAL_REQSTR_ID_LDO1 = 9,
	TPS65917_EXTERNAL_REQSTR_ID_LDO2 = 10,
	TPS65917_EXTERNAL_REQSTR_ID_LDO3 = 11,
	TPS65917_EXTERNAL_REQSTR_ID_LDO4 = 12,
	TPS65917_EXTERNAL_REQSTR_ID_LDO5 = 13,
	TPS65917_EXTERNAL_REQSTR_ID_MAX = 14,
};

enum tps65917_irqs {
	TPS65917_RESERVED1 = 0,
	TPS65917_PWRON_IRQ = 1,
	TPS65917_LONG_PRESS_KEY_IRQ = 2,
	TPS65917_RESERVED2 = 3,
	TPS65917_PWRDOWN_IRQ = 4,
	TPS65917_HOTDIE_IRQ = 5,
	TPS65917_VSYS_MON_IRQ = 6,
	TPS65917_RESERVED3 = 7,
	TPS65917_RESERVED4 = 8,
	TPS65917_OTP_ERROR_IRQ = 9,
	TPS65917_WDT_IRQ = 10,
	TPS65917_RESERVED5 = 11,
	TPS65917_RESET_IN_IRQ = 12,
	TPS65917_FSD_IRQ = 13,
	TPS65917_SHORT_IRQ = 14,
	TPS65917_RESERVED6 = 15,
	TPS65917_GPADC_AUTO_0_IRQ = 16,
	TPS65917_GPADC_AUTO_1_IRQ = 17,
	TPS65917_GPADC_EOC_SW_IRQ = 18,
	TPS65917_RESREVED6 = 19,
	TPS65917_RESERVED7 = 20,
	TPS65917_RESERVED8 = 21,
	TPS65917_RESERVED9 = 22,
	TPS65917_VBUS_IRQ = 23,
	TPS65917_GPIO_0_IRQ = 24,
	TPS65917_GPIO_1_IRQ = 25,
	TPS65917_GPIO_2_IRQ = 26,
	TPS65917_GPIO_3_IRQ = 27,
	TPS65917_GPIO_4_IRQ = 28,
	TPS65917_GPIO_5_IRQ = 29,
	TPS65917_GPIO_6_IRQ = 30,
	TPS65917_RESERVED10 = 31,
	TPS65917_NUM_IRQ = 32,
};

enum tps65917_regulators {
	TPS65917_REG_SMPS1 = 0,
	TPS65917_REG_SMPS2 = 1,
	TPS65917_REG_SMPS3 = 2,
	TPS65917_REG_SMPS4 = 3,
	TPS65917_REG_SMPS5 = 4,
	TPS65917_REG_SMPS12 = 5,
	TPS65917_REG_LDO1 = 6,
	TPS65917_REG_LDO2 = 7,
	TPS65917_REG_LDO3 = 8,
	TPS65917_REG_LDO4 = 9,
	TPS65917_REG_LDO5 = 10,
	TPS65917_REG_REGEN1 = 11,
	TPS65917_REG_REGEN2 = 12,
	TPS65917_REG_REGEN3 = 13,
	TPS65917_NUM_REGS = 14,
};

enum track_item {
	TRACK_ALLOC = 0,
	TRACK_FREE = 1,
};

enum translation_map {
	LAT1_MAP = 0,
	GRAF_MAP = 1,
	IBMPC_MAP = 2,
	USER_MAP = 3,
	FIRST_MAP = 0,
	LAST_MAP = 3,
};

enum ts_filter_type {
	TS_PACKET = 1,
	TS_PAYLOAD_ONLY = 2,
	TS_DECODER = 4,
	TS_DEMUX = 8,
};

enum tshut_mode {
	TSHUT_MODE_CRU = 0,
	TSHUT_MODE_GPIO = 1,
};

enum tshut_polarity {
	TSHUT_LOW_ACTIVE = 0,
	TSHUT_HIGH_ACTIVE = 1,
};

enum tsq_enum {
	TSQ_THROTTLED = 0,
	TSQ_QUEUED = 1,
	TCP_TSQ_DEFERRED = 2,
	TCP_WRITE_TIMER_DEFERRED = 3,
	TCP_DELACK_TIMER_DEFERRED = 4,
	TCP_MTU_REDUCED_DEFERRED = 5,
	TCP_ACK_DEFERRED = 6,
};

enum tsq_flags {
	TSQF_THROTTLED = 1,
	TSQF_QUEUED = 2,
	TCPF_TSQ_DEFERRED = 4,
	TCPF_WRITE_TIMER_DEFERRED = 8,
	TCPF_DELACK_TIMER_DEFERRED = 16,
	TCPF_MTU_REDUCED_DEFERRED = 32,
	TCPF_ACK_DEFERRED = 64,
};

enum ttu_flags {
	TTU_SPLIT_HUGE_PMD = 4,
	TTU_IGNORE_MLOCK = 8,
	TTU_SYNC = 16,
	TTU_HWPOISON = 32,
	TTU_BATCH_FLUSH = 64,
	TTU_RMAP_LOCKED = 128,
};

enum tty_driver_flag {
	TTY_DRIVER_INSTALLED = 1,
	TTY_DRIVER_RESET_TERMIOS = 2,
	TTY_DRIVER_REAL_RAW = 4,
	TTY_DRIVER_DYNAMIC_DEV = 8,
	TTY_DRIVER_DEVPTS_MEM = 16,
	TTY_DRIVER_HARDWARE_BREAK = 32,
	TTY_DRIVER_DYNAMIC_ALLOC = 64,
	TTY_DRIVER_UNNUMBERED_NODE = 128,
};

enum tty_driver_subtype {
	SYSTEM_TYPE_TTY = 1,
	SYSTEM_TYPE_CONSOLE = 2,
	SYSTEM_TYPE_SYSCONS = 3,
	SYSTEM_TYPE_SYSPTMX = 4,
	PTY_TYPE_MASTER = 1,
	PTY_TYPE_SLAVE = 2,
	SERIAL_TYPE_NORMAL = 1,
};

enum tty_driver_type {
	TTY_DRIVER_TYPE_SYSTEM = 0,
	TTY_DRIVER_TYPE_CONSOLE = 1,
	TTY_DRIVER_TYPE_SERIAL = 2,
	TTY_DRIVER_TYPE_PTY = 3,
	TTY_DRIVER_TYPE_SCC = 4,
	TTY_DRIVER_TYPE_SYSCONS = 5,
};

enum tty_flow_change {
	TTY_FLOW_NO_CHANGE = 0,
	TTY_THROTTLE_SAFE = 1,
	TTY_UNTHROTTLE_SAFE = 2,
};

enum tty_struct_flags {
	TTY_THROTTLED = 0,
	TTY_IO_ERROR = 1,
	TTY_OTHER_CLOSED = 2,
	TTY_EXCLUSIVE = 3,
	TTY_DO_WRITE_WAKEUP = 4,
	TTY_LDISC_OPEN = 5,
	TTY_PTY_LOCK = 6,
	TTY_NO_WRITE_SPLIT = 7,
	TTY_HUPPED = 8,
	TTY_HUPPING = 9,
	TTY_LDISC_CHANGING = 10,
	TTY_LDISC_HALTED = 11,
};

enum tunable_id {
	ETHTOOL_ID_UNSPEC = 0,
	ETHTOOL_RX_COPYBREAK = 1,
	ETHTOOL_TX_COPYBREAK = 2,
	ETHTOOL_PFC_PREVENTION_TOUT = 3,
	ETHTOOL_TX_COPYBREAK_BUF_SIZE = 4,
	__ETHTOOL_TUNABLE_COUNT = 5,
};

enum tunable_type_id {
	ETHTOOL_TUNABLE_UNSPEC = 0,
	ETHTOOL_TUNABLE_U8 = 1,
	ETHTOOL_TUNABLE_U16 = 2,
	ETHTOOL_TUNABLE_U32 = 3,
	ETHTOOL_TUNABLE_U64 = 4,
	ETHTOOL_TUNABLE_STRING = 5,
	ETHTOOL_TUNABLE_S8 = 6,
	ETHTOOL_TUNABLE_S16 = 7,
	ETHTOOL_TUNABLE_S32 = 8,
	ETHTOOL_TUNABLE_S64 = 9,
};

enum twl4030_audio_res {
	TWL4030_AUDIO_RES_POWER = 0,
	TWL4030_AUDIO_RES_APLL = 1,
	TWL4030_AUDIO_RES_MAX = 2,
};

enum twl4030_module_ids {
	TWL4030_MODULE_AUDIO_VOICE = 9,
	TWL4030_MODULE_GPIO = 10,
	TWL4030_MODULE_INTBR = 11,
	TWL4030_MODULE_TEST = 12,
	TWL4030_MODULE_KEYPAD = 13,
	TWL4030_MODULE_MADC = 14,
	TWL4030_MODULE_INTERRUPTS = 15,
	TWL4030_MODULE_PRECHARGE = 16,
	TWL4030_MODULE_BACKUP = 17,
	TWL4030_MODULE_INT = 18,
	TWL5031_MODULE_ACCESSORY = 19,
	TWL5031_MODULE_INTERRUPTS = 20,
	TWL4030_MODULE_LAST = 21,
};

enum twl4030_usb_mode {
	T2_USB_MODE_ULPI = 1,
	T2_USB_MODE_CEA2011_3PIN = 2,
};

enum twl6030_module_ids {
	TWL6030_MODULE_ID0 = 9,
	TWL6030_MODULE_ID1 = 10,
	TWL6030_MODULE_ID2 = 11,
	TWL6030_MODULE_GPADC = 12,
	TWL6030_MODULE_GASGAUGE = 13,
	TWL6032_MODULE_CHARGE = 14,
	TWL6030_MODULE_LAST = 15,
};

enum twl_class {
	TWL_4030 = 0,
	TWL_6030 = 1,
};

enum twl_module_ids {
	TWL_MODULE_USB = 0,
	TWL_MODULE_PIH = 1,
	TWL_MODULE_MAIN_CHARGE = 2,
	TWL_MODULE_PM_MASTER = 3,
	TWL_MODULE_PM_RECEIVER = 4,
	TWL_MODULE_RTC = 5,
	TWL_MODULE_PWM = 6,
	TWL_MODULE_LED = 7,
	TWL_MODULE_SECURED_REG = 8,
	TWL_MODULE_LAST = 9,
};

enum txtime_flags {
	SOF_TXTIME_DEADLINE_MODE = 1,
	SOF_TXTIME_REPORT_ERRORS = 2,
	SOF_TXTIME_FLAGS_LAST = 2,
	SOF_TXTIME_FLAGS_MASK = 3,
};

enum typec_accessory {
	TYPEC_ACCESSORY_NONE = 0,
	TYPEC_ACCESSORY_AUDIO = 1,
	TYPEC_ACCESSORY_DEBUG = 2,
};

enum typec_control_command {
	TYPEC_CONTROL_COMMAND_EXIT_MODES = 0,
	TYPEC_CONTROL_COMMAND_CLEAR_EVENTS = 1,
	TYPEC_CONTROL_COMMAND_ENTER_MODE = 2,
	TYPEC_CONTROL_COMMAND_TBT_UFP_REPLY = 3,
	TYPEC_CONTROL_COMMAND_USB_MUX_SET = 4,
	TYPEC_CONTROL_COMMAND_BIST_SHARE_MODE = 5,
	TYPEC_CONTROL_COMMAND_SEND_VDM_REQ = 6,
};

enum typec_data_role {
	TYPEC_DEVICE = 0,
	TYPEC_HOST = 1,
};

enum typec_orientation {
	TYPEC_ORIENTATION_NONE = 0,
	TYPEC_ORIENTATION_NORMAL = 1,
	TYPEC_ORIENTATION_REVERSE = 2,
};

enum typec_partner_type {
	TYPEC_PARTNER_SOP = 0,
	TYPEC_PARTNER_SOP_PRIME = 1,
};

enum typec_plug_index {
	TYPEC_PLUG_SOP_P = 0,
	TYPEC_PLUG_SOP_PP = 1,
};

enum typec_plug_type {
	USB_PLUG_NONE = 0,
	USB_PLUG_TYPE_A = 1,
	USB_PLUG_TYPE_B = 2,
	USB_PLUG_TYPE_C = 3,
	USB_PLUG_CAPTIVE = 4,
};

enum typec_port_data {
	TYPEC_PORT_DFP = 0,
	TYPEC_PORT_UFP = 1,
	TYPEC_PORT_DRD = 2,
};

enum typec_port_type {
	TYPEC_PORT_SRC = 0,
	TYPEC_PORT_SNK = 1,
	TYPEC_PORT_DRP = 2,
};

enum typec_pwr_opmode {
	TYPEC_PWR_MODE_USB = 0,
	TYPEC_PWR_MODE_1_5A = 1,
	TYPEC_PWR_MODE_3_0A = 2,
	TYPEC_PWR_MODE_PD = 3,
};

enum typec_role {
	TYPEC_SINK = 0,
	TYPEC_SOURCE = 1,
};

enum uaddr {
	MTD_UADDR_NOT_SUPPORTED = 0,
	MTD_UADDR_0x0555_0x02AA = 1,
	MTD_UADDR_0x0555_0x0AAA = 2,
	MTD_UADDR_0x5555_0x2AAA = 3,
	MTD_UADDR_0x0AAA_0x0554 = 4,
	MTD_UADDR_0x0AAA_0x0555 = 5,
	MTD_UADDR_0xAAAA_0x5555 = 6,
	MTD_UADDR_DONT_CARE = 7,
	MTD_UADDR_UNNECESSARY = 8,
};

enum uart_iotype {
	UPIO_UNKNOWN = -1,
	UPIO_PORT = 0,
	UPIO_HUB6 = 1,
	UPIO_MEM = 2,
	UPIO_MEM32 = 3,
	UPIO_AU = 4,
	UPIO_TSI = 5,
	UPIO_MEM32BE = 6,
	UPIO_MEM16 = 7,
};

enum uart_pm_state {
	UART_PM_STATE_ON = 0,
	UART_PM_STATE_OFF = 3,
	UART_PM_STATE_UNDEFINED = 4,
};

enum uclamp_id {
	UCLAMP_MIN = 0,
	UCLAMP_MAX = 1,
	UCLAMP_CNT = 2,
};

enum ucount_type {
	UCOUNT_USER_NAMESPACES = 0,
	UCOUNT_PID_NAMESPACES = 1,
	UCOUNT_UTS_NAMESPACES = 2,
	UCOUNT_IPC_NAMESPACES = 3,
	UCOUNT_NET_NAMESPACES = 4,
	UCOUNT_MNT_NAMESPACES = 5,
	UCOUNT_CGROUP_NAMESPACES = 6,
	UCOUNT_TIME_NAMESPACES = 7,
	UCOUNT_INOTIFY_INSTANCES = 8,
	UCOUNT_INOTIFY_WATCHES = 9,
	UCOUNT_FANOTIFY_GROUPS = 10,
	UCOUNT_FANOTIFY_MARKS = 11,
	UCOUNT_COUNTS = 12,
};

enum udp_conntrack {
	UDP_CT_UNREPLIED = 0,
	UDP_CT_REPLIED = 1,
	UDP_CT_MAX = 2,
};

enum udp_parsable_tunnel_type {
	UDP_TUNNEL_TYPE_VXLAN = 1,
	UDP_TUNNEL_TYPE_GENEVE = 2,
	UDP_TUNNEL_TYPE_VXLAN_GPE = 4,
};

enum udp_tunnel_nic_info_flags {
	UDP_TUNNEL_NIC_INFO_MAY_SLEEP = 1,
	UDP_TUNNEL_NIC_INFO_OPEN_ONLY = 2,
	UDP_TUNNEL_NIC_INFO_IPV4_ONLY = 4,
	UDP_TUNNEL_NIC_INFO_STATIC_IANA_VXLAN = 8,
};

enum uhid_dev_flag {
	UHID_DEV_NUMBERED_FEATURE_REPORTS = 1,
	UHID_DEV_NUMBERED_OUTPUT_REPORTS = 2,
	UHID_DEV_NUMBERED_INPUT_REPORTS = 4,
};

enum uhid_event_type {
	__UHID_LEGACY_CREATE = 0,
	UHID_DESTROY = 1,
	UHID_START = 2,
	UHID_STOP = 3,
	UHID_OPEN = 4,
	UHID_CLOSE = 5,
	UHID_OUTPUT = 6,
	__UHID_LEGACY_OUTPUT_EV = 7,
	__UHID_LEGACY_INPUT = 8,
	UHID_GET_REPORT = 9,
	UHID_GET_REPORT_REPLY = 10,
	UHID_CREATE2 = 11,
	UHID_INPUT2 = 12,
	UHID_SET_REPORT = 13,
	UHID_SET_REPORT_REPLY = 14,
};

enum uhid_legacy_event_type {
	UHID_CREATE = 0,
	UHID_OUTPUT_EV = 7,
	UHID_INPUT = 8,
	UHID_FEATURE = 9,
	UHID_FEATURE_ANSWER = 10,
};

enum uhid_report_type {
	UHID_FEATURE_REPORT = 0,
	UHID_OUTPUT_REPORT = 1,
	UHID_INPUT_REPORT = 2,
};

enum ulp_cpu_pwr_mode {
	ULP_PM_HSRUN = 0,
	ULP_PM_RUN = 1,
	ULP_PM_WAIT = 2,
	ULP_PM_STOP = 3,
	ULP_PM_VLPS = 4,
	ULP_PM_VLLS = 5,
};

enum umh_disable_depth {
	UMH_ENABLED = 0,
	UMH_FREEZING = 1,
	UMH_DISABLED = 2,
};

enum umount_tree_flags {
	UMOUNT_SYNC = 1,
	UMOUNT_PROPAGATE = 2,
	UMOUNT_CONNECTED = 4,
};

enum unix_vertex_index {
	UNIX_VERTEX_INDEX_MARK1 = 0,
	UNIX_VERTEX_INDEX_MARK2 = 1,
	UNIX_VERTEX_INDEX_START = 2,
};

enum unwind_reason_code {
	URC_OK = 0,
	URC_CONTINUE_UNWIND = 8,
	URC_FAILURE = 9,
};

enum usb3503_mode {
	USB3503_MODE_UNKNOWN = 0,
	USB3503_MODE_HUB = 1,
	USB3503_MODE_STANDBY = 2,
	USB3503_MODE_BYPASS = 3,
};

enum usb3_link_state {
	USB3_LPM_U0 = 0,
	USB3_LPM_U1 = 1,
	USB3_LPM_U2 = 2,
	USB3_LPM_U3 = 3,
};

enum usb4604_mode {
	USB4604_MODE_UNKNOWN = 0,
	USB4604_MODE_HUB = 1,
	USB4604_MODE_STANDBY = 2,
};

enum usb_charger_state {
	USB_CHARGER_DEFAULT = 0,
	USB_CHARGER_PRESENT = 1,
	USB_CHARGER_ABSENT = 2,
};

enum usb_charger_type {
	UNKNOWN_TYPE = 0,
	SDP_TYPE = 1,
	DCP_TYPE = 2,
	CDP_TYPE = 3,
	ACA_TYPE = 4,
};

enum usb_chg_state {
	USB_CHG_STATE_UNDEFINED = 0,
	USB_CHG_STATE_WAIT_FOR_DCD = 1,
	USB_CHG_STATE_DCD_DONE = 2,
	USB_CHG_STATE_PRIMARY_DONE = 3,
	USB_CHG_STATE_SECONDARY_DONE = 4,
	USB_CHG_STATE_DETECTED = 5,
};

enum usb_dev_authorize_policy {
	USB_DEVICE_AUTHORIZE_NONE = 0,
	USB_DEVICE_AUTHORIZE_ALL = 1,
	USB_DEVICE_AUTHORIZE_INTERNAL = 2,
};

enum usb_device_speed {
	USB_SPEED_UNKNOWN = 0,
	USB_SPEED_LOW = 1,
	USB_SPEED_FULL = 2,
	USB_SPEED_HIGH = 3,
	USB_SPEED_WIRELESS = 4,
	USB_SPEED_SUPER = 5,
	USB_SPEED_SUPER_PLUS = 6,
};

enum usb_device_state {
	USB_STATE_NOTATTACHED = 0,
	USB_STATE_ATTACHED = 1,
	USB_STATE_POWERED = 2,
	USB_STATE_RECONNECTING = 3,
	USB_STATE_UNAUTHENTICATED = 4,
	USB_STATE_DEFAULT = 5,
	USB_STATE_ADDRESS = 6,
	USB_STATE_CONFIGURED = 7,
	USB_STATE_SUSPENDED = 8,
};

enum usb_dr_mode {
	USB_DR_MODE_UNKNOWN = 0,
	USB_DR_MODE_HOST = 1,
	USB_DR_MODE_PERIPHERAL = 2,
	USB_DR_MODE_OTG = 3,
};

enum usb_interface_condition {
	USB_INTERFACE_UNBOUND = 0,
	USB_INTERFACE_BINDING = 1,
	USB_INTERFACE_BOUND = 2,
	USB_INTERFACE_UNBINDING = 3,
};

enum usb_led_event {
	USB_LED_EVENT_HOST = 0,
	USB_LED_EVENT_GADGET = 1,
};

enum usb_link_tunnel_mode {
	USB_LINK_UNKNOWN = 0,
	USB_LINK_NATIVE = 1,
	USB_LINK_TUNNELED = 2,
};

enum usb_mode {
	USB_MODE_NONE = 0,
	USB_MODE_USB2 = 1,
	USB_MODE_USB3 = 2,
	USB_MODE_USB4 = 3,
};

enum usb_otg_state {
	OTG_STATE_UNDEFINED = 0,
	OTG_STATE_B_IDLE = 1,
	OTG_STATE_B_SRP_INIT = 2,
	OTG_STATE_B_PERIPHERAL = 3,
	OTG_STATE_B_WAIT_ACON = 4,
	OTG_STATE_B_HOST = 5,
	OTG_STATE_A_IDLE = 6,
	OTG_STATE_A_WAIT_VRISE = 7,
	OTG_STATE_A_WAIT_BCON = 8,
	OTG_STATE_A_HOST = 9,
	OTG_STATE_A_SUSPEND = 10,
	OTG_STATE_A_PERIPHERAL = 11,
	OTG_STATE_A_WAIT_VFALL = 12,
	OTG_STATE_A_VBUS_ERR = 13,
};

enum usb_pd_control_mux {
	USB_PD_CTRL_MUX_NO_CHANGE = 0,
	USB_PD_CTRL_MUX_NONE = 1,
	USB_PD_CTRL_MUX_USB = 2,
	USB_PD_CTRL_MUX_DP = 3,
	USB_PD_CTRL_MUX_DOCK = 4,
	USB_PD_CTRL_MUX_AUTO = 5,
	USB_PD_CTRL_MUX_COUNT = 6,
};

enum usb_pd_control_role {
	USB_PD_CTRL_ROLE_NO_CHANGE = 0,
	USB_PD_CTRL_ROLE_TOGGLE_ON = 1,
	USB_PD_CTRL_ROLE_TOGGLE_OFF = 2,
	USB_PD_CTRL_ROLE_FORCE_SINK = 3,
	USB_PD_CTRL_ROLE_FORCE_SOURCE = 4,
	USB_PD_CTRL_ROLE_FREEZE = 5,
	USB_PD_CTRL_ROLE_COUNT = 6,
};

enum usb_pd_control_swap {
	USB_PD_CTRL_SWAP_NONE = 0,
	USB_PD_CTRL_SWAP_DATA = 1,
	USB_PD_CTRL_SWAP_POWER = 2,
	USB_PD_CTRL_SWAP_VCONN = 3,
	USB_PD_CTRL_SWAP_COUNT = 4,
};

enum usb_pd_svdm_ver {
	SVDM_VER_1_0 = 0,
	SVDM_VER_2_0 = 1,
	SVDM_VER_MAX = 1,
};

enum usb_phy_events {
	USB_EVENT_NONE = 0,
	USB_EVENT_VBUS = 1,
	USB_EVENT_ID = 2,
	USB_EVENT_CHARGER = 3,
	USB_EVENT_ENUMERATED = 4,
};

enum usb_phy_interface {
	USBPHY_INTERFACE_MODE_UNKNOWN = 0,
	USBPHY_INTERFACE_MODE_UTMI = 1,
	USBPHY_INTERFACE_MODE_UTMIW = 2,
	USBPHY_INTERFACE_MODE_ULPI = 3,
	USBPHY_INTERFACE_MODE_SERIAL = 4,
	USBPHY_INTERFACE_MODE_HSIC = 5,
};

enum usb_phy_type {
	USB_PHY_TYPE_UNDEFINED = 0,
	USB_PHY_TYPE_USB2 = 1,
	USB_PHY_TYPE_USB3 = 2,
};

enum usb_port_connect_type {
	USB_PORT_CONNECT_TYPE_UNKNOWN = 0,
	USB_PORT_CONNECT_TYPE_HOT_PLUG = 1,
	USB_PORT_CONNECT_TYPE_HARD_WIRED = 2,
	USB_PORT_NOT_USED = 3,
};

enum usb_role {
	USB_ROLE_NONE = 0,
	USB_ROLE_HOST = 1,
	USB_ROLE_DEVICE = 2,
};

enum usb_ssp_rate {
	USB_SSP_GEN_UNKNOWN = 0,
	USB_SSP_GEN_2x1 = 1,
	USB_SSP_GEN_1x2 = 2,
	USB_SSP_GEN_2x2 = 3,
};

enum usb_wireless_status {
	USB_WIRELESS_STATUS_NA = 0,
	USB_WIRELESS_STATUS_DISCONNECTED = 1,
	USB_WIRELESS_STATUS_CONNECTED = 2,
};

enum usbhs_omap_port_mode {
	OMAP_USBHS_PORT_MODE_UNUSED = 0,
	OMAP_EHCI_PORT_MODE_PHY = 1,
	OMAP_EHCI_PORT_MODE_TLL = 2,
	OMAP_EHCI_PORT_MODE_HSIC = 3,
	OMAP_OHCI_PORT_MODE_PHY_6PIN_DATSE0 = 4,
	OMAP_OHCI_PORT_MODE_PHY_6PIN_DPDM = 5,
	OMAP_OHCI_PORT_MODE_PHY_3PIN_DATSE0 = 6,
	OMAP_OHCI_PORT_MODE_PHY_4PIN_DPDM = 7,
	OMAP_OHCI_PORT_MODE_TLL_6PIN_DATSE0 = 8,
	OMAP_OHCI_PORT_MODE_TLL_6PIN_DPDM = 9,
	OMAP_OHCI_PORT_MODE_TLL_3PIN_DATSE0 = 10,
	OMAP_OHCI_PORT_MODE_TLL_4PIN_DPDM = 11,
	OMAP_OHCI_PORT_MODE_TLL_2PIN_DATSE0 = 12,
	OMAP_OHCI_PORT_MODE_TLL_2PIN_DPDM = 13,
};

enum usdhi6_wait_for {
	USDHI6_WAIT_FOR_REQUEST = 0,
	USDHI6_WAIT_FOR_CMD = 1,
	USDHI6_WAIT_FOR_MREAD = 2,
	USDHI6_WAIT_FOR_MWRITE = 3,
	USDHI6_WAIT_FOR_READ = 4,
	USDHI6_WAIT_FOR_WRITE = 5,
	USDHI6_WAIT_FOR_DATA_END = 6,
	USDHI6_WAIT_FOR_STOP = 7,
	USDHI6_WAIT_FOR_DMA = 8,
};

enum ushc_request {
	USHC_GET_CAPS = 0,
	USHC_HOST_CTRL = 1,
	USHC_PWR_CTRL = 2,
	USHC_CLK_FREQ = 3,
	USHC_EXEC_CMD = 4,
	USHC_READ_RESP = 5,
	USHC_RESET = 6,
};

enum ushc_request_type {
	USHC_GET_CAPS_TYPE = 192,
	USHC_HOST_CTRL_TYPE = 64,
	USHC_PWR_CTRL_TYPE = 64,
	USHC_CLK_FREQ_TYPE = 64,
	USHC_EXEC_CMD_TYPE = 64,
	USHC_READ_RESP_TYPE = 192,
	USHC_RESET_TYPE = 64,
};

enum utf16_endian {
	UTF16_HOST_ENDIAN = 0,
	UTF16_LITTLE_ENDIAN = 1,
	UTF16_BIG_ENDIAN = 2,
};

enum utf8_normalization {
	UTF8_NFDI = 0,
	UTF8_NFDICF = 1,
	UTF8_NMAX = 2,
};

enum uts_proc {
	UTS_PROC_ARCH = 0,
	UTS_PROC_OSTYPE = 1,
	UTS_PROC_OSRELEASE = 2,
	UTS_PROC_VERSION = 3,
	UTS_PROC_HOSTNAME = 4,
	UTS_PROC_DOMAINNAME = 5,
};

enum v4l2_async_match_type {
	V4L2_ASYNC_MATCH_TYPE_I2C = 0,
	V4L2_ASYNC_MATCH_TYPE_FWNODE = 1,
};

enum v4l2_av1_frame_restoration_type {
	V4L2_AV1_FRAME_RESTORE_NONE = 0,
	V4L2_AV1_FRAME_RESTORE_WIENER = 1,
	V4L2_AV1_FRAME_RESTORE_SGRPROJ = 2,
	V4L2_AV1_FRAME_RESTORE_SWITCHABLE = 3,
};

enum v4l2_av1_frame_type {
	V4L2_AV1_KEY_FRAME = 0,
	V4L2_AV1_INTER_FRAME = 1,
	V4L2_AV1_INTRA_ONLY_FRAME = 2,
	V4L2_AV1_SWITCH_FRAME = 3,
};

enum v4l2_av1_interpolation_filter {
	V4L2_AV1_INTERPOLATION_FILTER_EIGHTTAP = 0,
	V4L2_AV1_INTERPOLATION_FILTER_EIGHTTAP_SMOOTH = 1,
	V4L2_AV1_INTERPOLATION_FILTER_EIGHTTAP_SHARP = 2,
	V4L2_AV1_INTERPOLATION_FILTER_BILINEAR = 3,
	V4L2_AV1_INTERPOLATION_FILTER_SWITCHABLE = 4,
};

enum v4l2_av1_segment_feature {
	V4L2_AV1_SEG_LVL_ALT_Q = 0,
	V4L2_AV1_SEG_LVL_ALT_LF_Y_V = 1,
	V4L2_AV1_SEG_LVL_REF_FRAME = 5,
	V4L2_AV1_SEG_LVL_REF_SKIP = 6,
	V4L2_AV1_SEG_LVL_REF_GLOBALMV = 7,
	V4L2_AV1_SEG_LVL_MAX = 8,
};

enum v4l2_av1_tx_mode {
	V4L2_AV1_TX_MODE_ONLY_4X4 = 0,
	V4L2_AV1_TX_MODE_LARGEST = 1,
	V4L2_AV1_TX_MODE_SELECT = 2,
};

enum v4l2_av1_warp_model {
	V4L2_AV1_WARP_MODEL_IDENTITY = 0,
	V4L2_AV1_WARP_MODEL_TRANSLATION = 1,
	V4L2_AV1_WARP_MODEL_ROTZOOM = 2,
	V4L2_AV1_WARP_MODEL_AFFINE = 3,
};

enum v4l2_buf_type {
	V4L2_BUF_TYPE_VIDEO_CAPTURE = 1,
	V4L2_BUF_TYPE_VIDEO_OUTPUT = 2,
	V4L2_BUF_TYPE_VIDEO_OVERLAY = 3,
	V4L2_BUF_TYPE_VBI_CAPTURE = 4,
	V4L2_BUF_TYPE_VBI_OUTPUT = 5,
	V4L2_BUF_TYPE_SLICED_VBI_CAPTURE = 6,
	V4L2_BUF_TYPE_SLICED_VBI_OUTPUT = 7,
	V4L2_BUF_TYPE_VIDEO_OUTPUT_OVERLAY = 8,
	V4L2_BUF_TYPE_VIDEO_CAPTURE_MPLANE = 9,
	V4L2_BUF_TYPE_VIDEO_OUTPUT_MPLANE = 10,
	V4L2_BUF_TYPE_SDR_CAPTURE = 11,
	V4L2_BUF_TYPE_SDR_OUTPUT = 12,
	V4L2_BUF_TYPE_META_CAPTURE = 13,
	V4L2_BUF_TYPE_META_OUTPUT = 14,
	V4L2_BUF_TYPE_PRIVATE = 128,
};

enum v4l2_colorspace {
	V4L2_COLORSPACE_DEFAULT = 0,
	V4L2_COLORSPACE_SMPTE170M = 1,
	V4L2_COLORSPACE_SMPTE240M = 2,
	V4L2_COLORSPACE_REC709 = 3,
	V4L2_COLORSPACE_BT878 = 4,
	V4L2_COLORSPACE_470_SYSTEM_M = 5,
	V4L2_COLORSPACE_470_SYSTEM_BG = 6,
	V4L2_COLORSPACE_JPEG = 7,
	V4L2_COLORSPACE_SRGB = 8,
	V4L2_COLORSPACE_OPRGB = 9,
	V4L2_COLORSPACE_BT2020 = 10,
	V4L2_COLORSPACE_RAW = 11,
	V4L2_COLORSPACE_DCI_P3 = 12,
	V4L2_COLORSPACE_LAST = 13,
};

enum v4l2_connector_type {
	V4L2_CONN_UNKNOWN = 0,
	V4L2_CONN_COMPOSITE = 1,
	V4L2_CONN_SVIDEO = 2,
};

enum v4l2_ctrl_type {
	V4L2_CTRL_TYPE_INTEGER = 1,
	V4L2_CTRL_TYPE_BOOLEAN = 2,
	V4L2_CTRL_TYPE_MENU = 3,
	V4L2_CTRL_TYPE_BUTTON = 4,
	V4L2_CTRL_TYPE_INTEGER64 = 5,
	V4L2_CTRL_TYPE_CTRL_CLASS = 6,
	V4L2_CTRL_TYPE_STRING = 7,
	V4L2_CTRL_TYPE_BITMASK = 8,
	V4L2_CTRL_TYPE_INTEGER_MENU = 9,
	V4L2_CTRL_COMPOUND_TYPES = 256,
	V4L2_CTRL_TYPE_U8 = 256,
	V4L2_CTRL_TYPE_U16 = 257,
	V4L2_CTRL_TYPE_U32 = 258,
	V4L2_CTRL_TYPE_AREA = 262,
	V4L2_CTRL_TYPE_RECT = 263,
	V4L2_CTRL_TYPE_HDR10_CLL_INFO = 272,
	V4L2_CTRL_TYPE_HDR10_MASTERING_DISPLAY = 273,
	V4L2_CTRL_TYPE_H264_SPS = 512,
	V4L2_CTRL_TYPE_H264_PPS = 513,
	V4L2_CTRL_TYPE_H264_SCALING_MATRIX = 514,
	V4L2_CTRL_TYPE_H264_SLICE_PARAMS = 515,
	V4L2_CTRL_TYPE_H264_DECODE_PARAMS = 516,
	V4L2_CTRL_TYPE_H264_PRED_WEIGHTS = 517,
	V4L2_CTRL_TYPE_FWHT_PARAMS = 544,
	V4L2_CTRL_TYPE_VP8_FRAME = 576,
	V4L2_CTRL_TYPE_MPEG2_QUANTISATION = 592,
	V4L2_CTRL_TYPE_MPEG2_SEQUENCE = 593,
	V4L2_CTRL_TYPE_MPEG2_PICTURE = 594,
	V4L2_CTRL_TYPE_VP9_COMPRESSED_HDR = 608,
	V4L2_CTRL_TYPE_VP9_FRAME = 609,
	V4L2_CTRL_TYPE_HEVC_SPS = 624,
	V4L2_CTRL_TYPE_HEVC_PPS = 625,
	V4L2_CTRL_TYPE_HEVC_SLICE_PARAMS = 626,
	V4L2_CTRL_TYPE_HEVC_SCALING_MATRIX = 627,
	V4L2_CTRL_TYPE_HEVC_DECODE_PARAMS = 628,
	V4L2_CTRL_TYPE_AV1_SEQUENCE = 640,
	V4L2_CTRL_TYPE_AV1_TILE_GROUP_ENTRY = 641,
	V4L2_CTRL_TYPE_AV1_FRAME = 642,
	V4L2_CTRL_TYPE_AV1_FILM_GRAIN = 643,
};

enum v4l2_field {
	V4L2_FIELD_ANY = 0,
	V4L2_FIELD_NONE = 1,
	V4L2_FIELD_TOP = 2,
	V4L2_FIELD_BOTTOM = 3,
	V4L2_FIELD_INTERLACED = 4,
	V4L2_FIELD_SEQ_TB = 5,
	V4L2_FIELD_SEQ_BT = 6,
	V4L2_FIELD_ALTERNATE = 7,
	V4L2_FIELD_INTERLACED_TB = 8,
	V4L2_FIELD_INTERLACED_BT = 9,
};

enum v4l2_frmivaltypes {
	V4L2_FRMIVAL_TYPE_DISCRETE = 1,
	V4L2_FRMIVAL_TYPE_CONTINUOUS = 2,
	V4L2_FRMIVAL_TYPE_STEPWISE = 3,
};

enum v4l2_frmsizetypes {
	V4L2_FRMSIZE_TYPE_DISCRETE = 1,
	V4L2_FRMSIZE_TYPE_CONTINUOUS = 2,
	V4L2_FRMSIZE_TYPE_STEPWISE = 3,
};

enum v4l2_fwnode_bus_type {
	V4L2_FWNODE_BUS_TYPE_GUESS = 0,
	V4L2_FWNODE_BUS_TYPE_CSI2_CPHY = 1,
	V4L2_FWNODE_BUS_TYPE_CSI1 = 2,
	V4L2_FWNODE_BUS_TYPE_CCP2 = 3,
	V4L2_FWNODE_BUS_TYPE_CSI2_DPHY = 4,
	V4L2_FWNODE_BUS_TYPE_PARALLEL = 5,
	V4L2_FWNODE_BUS_TYPE_BT656 = 6,
	V4L2_FWNODE_BUS_TYPE_DPI = 7,
	NR_OF_V4L2_FWNODE_BUS_TYPE = 8,
};

enum v4l2_fwnode_orientation {
	V4L2_FWNODE_ORIENTATION_FRONT = 0,
	V4L2_FWNODE_ORIENTATION_BACK = 1,
	V4L2_FWNODE_ORIENTATION_EXTERNAL = 2,
};

enum v4l2_hsv_encoding {
	V4L2_HSV_ENC_180 = 128,
	V4L2_HSV_ENC_256 = 129,
};

enum v4l2_i2c_tuner_type {
	ADDRS_RADIO = 0,
	ADDRS_DEMOD = 1,
	ADDRS_TV = 2,
	ADDRS_TV_WITH_DEMOD = 3,
};

enum v4l2_mbus_csi2_cphy_line_orders_type {
	V4L2_MBUS_CSI2_CPHY_LINE_ORDER_ABC = 0,
	V4L2_MBUS_CSI2_CPHY_LINE_ORDER_ACB = 1,
	V4L2_MBUS_CSI2_CPHY_LINE_ORDER_BAC = 2,
	V4L2_MBUS_CSI2_CPHY_LINE_ORDER_BCA = 3,
	V4L2_MBUS_CSI2_CPHY_LINE_ORDER_CAB = 4,
	V4L2_MBUS_CSI2_CPHY_LINE_ORDER_CBA = 5,
};

enum v4l2_mbus_frame_desc_flags {
	V4L2_MBUS_FRAME_DESC_FL_LEN_MAX = 1,
	V4L2_MBUS_FRAME_DESC_FL_BLOB = 2,
};

enum v4l2_mbus_frame_desc_type {
	V4L2_MBUS_FRAME_DESC_TYPE_UNDEFINED = 0,
	V4L2_MBUS_FRAME_DESC_TYPE_PARALLEL = 1,
	V4L2_MBUS_FRAME_DESC_TYPE_CSI2 = 2,
};

enum v4l2_mbus_type {
	V4L2_MBUS_UNKNOWN = 0,
	V4L2_MBUS_PARALLEL = 1,
	V4L2_MBUS_BT656 = 2,
	V4L2_MBUS_CSI1 = 3,
	V4L2_MBUS_CCP2 = 4,
	V4L2_MBUS_CSI2_DPHY = 5,
	V4L2_MBUS_CSI2_CPHY = 6,
	V4L2_MBUS_DPI = 7,
	V4L2_MBUS_INVALID = 8,
};

enum v4l2_memory {
	V4L2_MEMORY_MMAP = 1,
	V4L2_MEMORY_USERPTR = 2,
	V4L2_MEMORY_OVERLAY = 3,
	V4L2_MEMORY_DMABUF = 4,
};

enum v4l2_pixel_encoding {
	V4L2_PIXEL_ENC_UNKNOWN = 0,
	V4L2_PIXEL_ENC_YUV = 1,
	V4L2_PIXEL_ENC_RGB = 2,
	V4L2_PIXEL_ENC_BAYER = 3,
};

enum v4l2_preemphasis {
	V4L2_PREEMPHASIS_DISABLED = 0,
	V4L2_PREEMPHASIS_50_uS = 1,
	V4L2_PREEMPHASIS_75_uS = 2,
};

enum v4l2_priority {
	V4L2_PRIORITY_UNSET = 0,
	V4L2_PRIORITY_BACKGROUND = 1,
	V4L2_PRIORITY_INTERACTIVE = 2,
	V4L2_PRIORITY_RECORD = 3,
	V4L2_PRIORITY_DEFAULT = 2,
};

enum v4l2_quantization {
	V4L2_QUANTIZATION_DEFAULT = 0,
	V4L2_QUANTIZATION_FULL_RANGE = 1,
	V4L2_QUANTIZATION_LIM_RANGE = 2,
};

enum v4l2_subdev_format_whence {
	V4L2_SUBDEV_FORMAT_TRY = 0,
	V4L2_SUBDEV_FORMAT_ACTIVE = 1,
};

enum v4l2_subdev_ir_mode {
	V4L2_SUBDEV_IR_MODE_PULSE_WIDTH = 0,
};

enum v4l2_subdev_routing_restriction {
	V4L2_SUBDEV_ROUTING_NO_1_TO_N = 1,
	V4L2_SUBDEV_ROUTING_NO_N_TO_1 = 2,
	V4L2_SUBDEV_ROUTING_NO_SINK_STREAM_MIX = 4,
	V4L2_SUBDEV_ROUTING_NO_SOURCE_STREAM_MIX = 8,
	V4L2_SUBDEV_ROUTING_NO_SINK_MULTIPLEXING = 16,
	V4L2_SUBDEV_ROUTING_NO_SOURCE_MULTIPLEXING = 32,
	V4L2_SUBDEV_ROUTING_ONLY_1_TO_1 = 3,
	V4L2_SUBDEV_ROUTING_NO_STREAM_MIX = 12,
	V4L2_SUBDEV_ROUTING_NO_MULTIPLEXING = 48,
};

enum v4l2_tuner_type {
	V4L2_TUNER_RADIO = 1,
	V4L2_TUNER_ANALOG_TV = 2,
	V4L2_TUNER_DIGITAL_TV = 3,
	V4L2_TUNER_SDR = 4,
	V4L2_TUNER_RF = 5,
};

enum v4l2_video_device_flags {
	V4L2_FL_REGISTERED = 0,
	V4L2_FL_USES_V4L2_FH = 1,
	V4L2_FL_QUIRK_INVERTED_CROP = 2,
	V4L2_FL_SUBDEV_RO_DEVNODE = 3,
};

enum v4l2_xfer_func {
	V4L2_XFER_FUNC_DEFAULT = 0,
	V4L2_XFER_FUNC_709 = 1,
	V4L2_XFER_FUNC_SRGB = 2,
	V4L2_XFER_FUNC_OPRGB = 3,
	V4L2_XFER_FUNC_SMPTE240M = 4,
	V4L2_XFER_FUNC_NONE = 5,
	V4L2_XFER_FUNC_DCI_P3 = 6,
	V4L2_XFER_FUNC_SMPTE2084 = 7,
	V4L2_XFER_FUNC_LAST = 8,
};

enum v4l2_ycbcr_encoding {
	V4L2_YCBCR_ENC_DEFAULT = 0,
	V4L2_YCBCR_ENC_601 = 1,
	V4L2_YCBCR_ENC_709 = 2,
	V4L2_YCBCR_ENC_XV601 = 3,
	V4L2_YCBCR_ENC_XV709 = 4,
	V4L2_YCBCR_ENC_BT2020 = 6,
	V4L2_YCBCR_ENC_BT2020_CONST_LUM = 7,
	V4L2_YCBCR_ENC_SMPTE240M = 8,
	V4L2_YCBCR_ENC_LAST = 9,
};

enum vb2_buffer_state {
	VB2_BUF_STATE_DEQUEUED = 0,
	VB2_BUF_STATE_IN_REQUEST = 1,
	VB2_BUF_STATE_PREPARING = 2,
	VB2_BUF_STATE_QUEUED = 3,
	VB2_BUF_STATE_ACTIVE = 4,
	VB2_BUF_STATE_DONE = 5,
	VB2_BUF_STATE_ERROR = 6,
};

enum vc_ctl_state {
	ESnormal = 0,
	ESesc = 1,
	ESsquare = 2,
	ESgetpars = 3,
	ESfunckey = 4,
	EShash = 5,
	ESsetG0 = 6,
	ESsetG1 = 7,
	ESpercent = 8,
	EScsiignore = 9,
	ESnonstd = 10,
	ESpalette = 11,
	ESosc = 12,
	ESANSI_first = 12,
	ESapc = 13,
	ESpm = 14,
	ESdcs = 15,
	ESANSI_last = 15,
};

enum vc_intensity {
	VCI_HALF_BRIGHT = 0,
	VCI_NORMAL = 1,
	VCI_BOLD = 2,
	VCI_MASK = 3,
};

enum vchiq_bulk_dir {
	VCHIQ_BULK_TRANSMIT = 0,
	VCHIQ_BULK_RECEIVE = 1,
};

enum vchiq_bulk_mode {
	VCHIQ_BULK_MODE_CALLBACK = 0,
	VCHIQ_BULK_MODE_BLOCKING = 1,
	VCHIQ_BULK_MODE_NOCALLBACK = 2,
	VCHIQ_BULK_MODE_WAITING = 3,
};

enum vchiq_connstate {
	VCHIQ_CONNSTATE_DISCONNECTED = 0,
	VCHIQ_CONNSTATE_CONNECTING = 1,
	VCHIQ_CONNSTATE_CONNECTED = 2,
	VCHIQ_CONNSTATE_PAUSING = 3,
	VCHIQ_CONNSTATE_PAUSE_SENT = 4,
	VCHIQ_CONNSTATE_PAUSED = 5,
	VCHIQ_CONNSTATE_RESUMING = 6,
	VCHIQ_CONNSTATE_PAUSE_TIMEOUT = 7,
	VCHIQ_CONNSTATE_RESUME_TIMEOUT = 8,
};

enum vchiq_reason {
	VCHIQ_SERVICE_OPENED = 0,
	VCHIQ_SERVICE_CLOSED = 1,
	VCHIQ_MESSAGE_AVAILABLE = 2,
	VCHIQ_BULK_TRANSMIT_DONE = 3,
	VCHIQ_BULK_RECEIVE_DONE = 4,
	VCHIQ_BULK_TRANSMIT_ABORTED = 5,
	VCHIQ_BULK_RECEIVE_ABORTED = 6,
};

enum vchiq_service_option {
	VCHIQ_SERVICE_OPTION_AUTOCLOSE = 0,
	VCHIQ_SERVICE_OPTION_SLOT_QUOTA = 1,
	VCHIQ_SERVICE_OPTION_MESSAGE_QUOTA = 2,
	VCHIQ_SERVICE_OPTION_SYNCHRONOUS = 3,
	VCHIQ_SERVICE_OPTION_TRACE = 4,
};

enum vdso_clock_mode {
	VDSO_CLOCKMODE_NONE = 0,
	VDSO_CLOCKMODE_ARCHTIMER = 1,
	VDSO_CLOCKMODE_MAX = 2,
	VDSO_CLOCKMODE_TIMENS = 2147483647,
};

enum vdso_pages {
	VDSO_TIME_PAGE_OFFSET = 0,
	VDSO_TIMENS_PAGE_OFFSET = 1,
	VDSO_RNG_PAGE_OFFSET = 2,
	VDSO_ARCH_PAGES_START = 3,
	VDSO_ARCH_PAGES_END = 3,
	VDSO_NR_PAGES = 4,
};

enum verifier_phase {
	CHECK_META = 0,
	CHECK_TYPE = 1,
};

enum versatile_reboot {
	INTEGRATOR_REBOOT_CM = 0,
	VERSATILE_REBOOT_CM = 1,
	REALVIEW_REBOOT_EB = 2,
	REALVIEW_REBOOT_PB1176 = 3,
	REALVIEW_REBOOT_PB11MP = 4,
	REALVIEW_REBOOT_PBA8 = 5,
	REALVIEW_REBOOT_PBX = 6,
};

enum vesa_blank_mode {
	VESA_NO_BLANKING = 0,
	VESA_VSYNC_SUSPEND = 1,
	VESA_HSYNC_SUSPEND = 2,
	VESA_POWERDOWN = 3,
	VESA_BLANK_MAX = 3,
};

enum vexpress_reset_func {
	FUNC_RESET = 0,
	FUNC_SHUTDOWN = 1,
	FUNC_REBOOT = 2,
};

enum vf610_nfc_variant {
	NFC_VFC610 = 1,
};

enum vf610_pads {
	VF610_PAD_PTA6 = 0,
	VF610_PAD_PTA8 = 1,
	VF610_PAD_PTA9 = 2,
	VF610_PAD_PTA10 = 3,
	VF610_PAD_PTA11 = 4,
	VF610_PAD_PTA12 = 5,
	VF610_PAD_PTA16 = 6,
	VF610_PAD_PTA17 = 7,
	VF610_PAD_PTA18 = 8,
	VF610_PAD_PTA19 = 9,
	VF610_PAD_PTA20 = 10,
	VF610_PAD_PTA21 = 11,
	VF610_PAD_PTA22 = 12,
	VF610_PAD_PTA23 = 13,
	VF610_PAD_PTA24 = 14,
	VF610_PAD_PTA25 = 15,
	VF610_PAD_PTA26 = 16,
	VF610_PAD_PTA27 = 17,
	VF610_PAD_PTA28 = 18,
	VF610_PAD_PTA29 = 19,
	VF610_PAD_PTA30 = 20,
	VF610_PAD_PTA31 = 21,
	VF610_PAD_PTB0 = 22,
	VF610_PAD_PTB1 = 23,
	VF610_PAD_PTB2 = 24,
	VF610_PAD_PTB3 = 25,
	VF610_PAD_PTB4 = 26,
	VF610_PAD_PTB5 = 27,
	VF610_PAD_PTB6 = 28,
	VF610_PAD_PTB7 = 29,
	VF610_PAD_PTB8 = 30,
	VF610_PAD_PTB9 = 31,
	VF610_PAD_PTB10 = 32,
	VF610_PAD_PTB11 = 33,
	VF610_PAD_PTB12 = 34,
	VF610_PAD_PTB13 = 35,
	VF610_PAD_PTB14 = 36,
	VF610_PAD_PTB15 = 37,
	VF610_PAD_PTB16 = 38,
	VF610_PAD_PTB17 = 39,
	VF610_PAD_PTB18 = 40,
	VF610_PAD_PTB19 = 41,
	VF610_PAD_PTB20 = 42,
	VF610_PAD_PTB21 = 43,
	VF610_PAD_PTB22 = 44,
	VF610_PAD_PTC0 = 45,
	VF610_PAD_PTC1 = 46,
	VF610_PAD_PTC2 = 47,
	VF610_PAD_PTC3 = 48,
	VF610_PAD_PTC4 = 49,
	VF610_PAD_PTC5 = 50,
	VF610_PAD_PTC6 = 51,
	VF610_PAD_PTC7 = 52,
	VF610_PAD_PTC8 = 53,
	VF610_PAD_PTC9 = 54,
	VF610_PAD_PTC10 = 55,
	VF610_PAD_PTC11 = 56,
	VF610_PAD_PTC12 = 57,
	VF610_PAD_PTC13 = 58,
	VF610_PAD_PTC14 = 59,
	VF610_PAD_PTC15 = 60,
	VF610_PAD_PTC16 = 61,
	VF610_PAD_PTC17 = 62,
	VF610_PAD_PTD31 = 63,
	VF610_PAD_PTD30 = 64,
	VF610_PAD_PTD29 = 65,
	VF610_PAD_PTD28 = 66,
	VF610_PAD_PTD27 = 67,
	VF610_PAD_PTD26 = 68,
	VF610_PAD_PTD25 = 69,
	VF610_PAD_PTD24 = 70,
	VF610_PAD_PTD23 = 71,
	VF610_PAD_PTD22 = 72,
	VF610_PAD_PTD21 = 73,
	VF610_PAD_PTD20 = 74,
	VF610_PAD_PTD19 = 75,
	VF610_PAD_PTD18 = 76,
	VF610_PAD_PTD17 = 77,
	VF610_PAD_PTD16 = 78,
	VF610_PAD_PTD0 = 79,
	VF610_PAD_PTD1 = 80,
	VF610_PAD_PTD2 = 81,
	VF610_PAD_PTD3 = 82,
	VF610_PAD_PTD4 = 83,
	VF610_PAD_PTD5 = 84,
	VF610_PAD_PTD6 = 85,
	VF610_PAD_PTD7 = 86,
	VF610_PAD_PTD8 = 87,
	VF610_PAD_PTD9 = 88,
	VF610_PAD_PTD10 = 89,
	VF610_PAD_PTD11 = 90,
	VF610_PAD_PTD12 = 91,
	VF610_PAD_PTD13 = 92,
	VF610_PAD_PTB23 = 93,
	VF610_PAD_PTB24 = 94,
	VF610_PAD_PTB25 = 95,
	VF610_PAD_PTB26 = 96,
	VF610_PAD_PTB27 = 97,
	VF610_PAD_PTB28 = 98,
	VF610_PAD_PTC26 = 99,
	VF610_PAD_PTC27 = 100,
	VF610_PAD_PTC28 = 101,
	VF610_PAD_PTC29 = 102,
	VF610_PAD_PTC30 = 103,
	VF610_PAD_PTC31 = 104,
	VF610_PAD_PTE0 = 105,
	VF610_PAD_PTE1 = 106,
	VF610_PAD_PTE2 = 107,
	VF610_PAD_PTE3 = 108,
	VF610_PAD_PTE4 = 109,
	VF610_PAD_PTE5 = 110,
	VF610_PAD_PTE6 = 111,
	VF610_PAD_PTE7 = 112,
	VF610_PAD_PTE8 = 113,
	VF610_PAD_PTE9 = 114,
	VF610_PAD_PTE10 = 115,
	VF610_PAD_PTE11 = 116,
	VF610_PAD_PTE12 = 117,
	VF610_PAD_PTE13 = 118,
	VF610_PAD_PTE14 = 119,
	VF610_PAD_PTE15 = 120,
	VF610_PAD_PTE16 = 121,
	VF610_PAD_PTE17 = 122,
	VF610_PAD_PTE18 = 123,
	VF610_PAD_PTE19 = 124,
	VF610_PAD_PTE20 = 125,
	VF610_PAD_PTE21 = 126,
	VF610_PAD_PTE22 = 127,
	VF610_PAD_PTE23 = 128,
	VF610_PAD_PTE24 = 129,
	VF610_PAD_PTE25 = 130,
	VF610_PAD_PTE26 = 131,
	VF610_PAD_PTE27 = 132,
	VF610_PAD_PTE28 = 133,
	VF610_PAD_PTA7 = 134,
};

enum vfl_devnode_direction {
	VFL_DIR_RX = 0,
	VFL_DIR_TX = 1,
	VFL_DIR_M2M = 2,
};

enum vfl_devnode_type {
	VFL_TYPE_VIDEO = 0,
	VFL_TYPE_VBI = 1,
	VFL_TYPE_RADIO = 2,
	VFL_TYPE_SUBDEV = 3,
	VFL_TYPE_SDR = 4,
	VFL_TYPE_TOUCH = 5,
	VFL_TYPE_MAX = 6,
};

enum vgt_event_type {
	VS_DEALLOC = 0,
	PS_DEALLOC = 1,
	VS_DONE_TS = 2,
	PS_DONE_TS = 3,
	CACHE_FLUSH_TS = 4,
	CONTEXT_DONE = 5,
	CACHE_FLUSH = 6,
	VIZQUERY_START = 7,
	HLSQ_FLUSH = 7,
	VIZQUERY_END = 8,
	SC_WAIT_WC = 9,
	WRITE_PRIMITIVE_COUNTS = 9,
	START_PRIMITIVE_CTRS = 11,
	STOP_PRIMITIVE_CTRS = 12,
	RST_PIX_CNT = 13,
	RST_VTX_CNT = 14,
	TILE_FLUSH = 15,
	STAT_EVENT = 16,
	CACHE_FLUSH_AND_INV_TS_EVENT = 20,
	ZPASS_DONE = 21,
	CACHE_FLUSH_AND_INV_EVENT = 22,
	RB_DONE_TS = 22,
	PERFCOUNTER_START = 23,
	PERFCOUNTER_STOP = 24,
	VS_FETCH_DONE = 27,
	FACENESS_FLUSH = 28,
	WT_DONE_TS = 8,
	START_FRAGMENT_CTRS = 13,
	STOP_FRAGMENT_CTRS = 14,
	START_COMPUTE_CTRS = 15,
	STOP_COMPUTE_CTRS = 16,
	FLUSH_SO_0 = 17,
	FLUSH_SO_1 = 18,
	FLUSH_SO_2 = 19,
	FLUSH_SO_3 = 20,
	PC_CCU_INVALIDATE_DEPTH = 24,
	PC_CCU_INVALIDATE_COLOR = 25,
	PC_CCU_RESOLVE_TS = 26,
	PC_CCU_FLUSH_DEPTH_TS = 28,
	PC_CCU_FLUSH_COLOR_TS = 29,
	BLIT = 30,
	LRZ_FLIP_BUFFER = 36,
	LRZ_CLEAR = 37,
	LRZ_FLUSH = 38,
	BLIT_OP_FILL_2D = 39,
	BLIT_OP_COPY_2D = 40,
	UNK_40 = 40,
	LRZ_Q_CACHE_INVALIDATE = 41,
	BLIT_OP_SCALE_2D = 42,
	CONTEXT_DONE_2D = 43,
	UNK_2C = 44,
	UNK_2D = 45,
	CACHE_INVALIDATE = 49,
	LABEL = 63,
	DUMMY_EVENT = 1,
	CCU_INVALIDATE_DEPTH = 24,
	CCU_INVALIDATE_COLOR = 25,
	CCU_RESOLVE_CLEAN = 26,
	CCU_FLUSH_DEPTH = 28,
	CCU_FLUSH_COLOR = 29,
	CCU_RESOLVE = 30,
	CCU_END_RESOLVE_GROUP = 31,
	CCU_CLEAN_DEPTH = 32,
	CCU_CLEAN_COLOR = 33,
	CACHE_RESET = 48,
	CACHE_CLEAN = 49,
	CACHE_FLUSH7 = 50,
	CACHE_INVALIDATE7 = 51,
};

enum video_config_bpp {
	VIDEO_CONFIG_18BPP = 0,
	VIDEO_CONFIG_24BPP = 1,
};

enum video_pattern_sel {
	VID_PRBS = 0,
	VID_INCREMENTAL = 1,
	VID_FIXED = 2,
	VID_MDSS_GENERAL_PATTERN = 3,
};

enum video_timing_recognition_type {
	VIDEO_TIMING_FROM_CAPTURE = 0,
	VIDEO_TIMING_FROM_REGISTER = 1,
};

enum visit_state {
	NOT_VISITED = 0,
	VISITED = 1,
	RESOLVED = 2,
};

enum vlan_flags {
	VLAN_FLAG_REORDER_HDR = 1,
	VLAN_FLAG_GVRP = 2,
	VLAN_FLAG_LOOSE_BINDING = 4,
	VLAN_FLAG_MVRP = 8,
	VLAN_FLAG_BRIDGE_BINDING = 16,
};

enum vlan_protos {
	VLAN_PROTO_8021Q = 0,
	VLAN_PROTO_8021AD = 1,
	VLAN_PROTO_NUM = 2,
};

enum vm_event_item {
	PGPGIN = 0,
	PGPGOUT = 1,
	PSWPIN = 2,
	PSWPOUT = 3,
	PGALLOC_DMA = 4,
	PGALLOC_NORMAL = 5,
	PGALLOC_HIGH = 6,
	PGALLOC_MOVABLE = 7,
	ALLOCSTALL_DMA = 8,
	ALLOCSTALL_NORMAL = 9,
	ALLOCSTALL_HIGH = 10,
	ALLOCSTALL_MOVABLE = 11,
	PGSCAN_SKIP_DMA = 12,
	PGSCAN_SKIP_NORMAL = 13,
	PGSCAN_SKIP_HIGH = 14,
	PGSCAN_SKIP_MOVABLE = 15,
	PGFREE = 16,
	PGACTIVATE = 17,
	PGDEACTIVATE = 18,
	PGLAZYFREE = 19,
	PGFAULT = 20,
	PGMAJFAULT = 21,
	PGLAZYFREED = 22,
	PGREFILL = 23,
	PGREUSE = 24,
	PGSTEAL_KSWAPD = 25,
	PGSTEAL_DIRECT = 26,
	PGSTEAL_KHUGEPAGED = 27,
	PGSTEAL_PROACTIVE = 28,
	PGSCAN_KSWAPD = 29,
	PGSCAN_DIRECT = 30,
	PGSCAN_KHUGEPAGED = 31,
	PGSCAN_PROACTIVE = 32,
	PGSCAN_DIRECT_THROTTLE = 33,
	PGSCAN_ANON = 34,
	PGSCAN_FILE = 35,
	PGSTEAL_ANON = 36,
	PGSTEAL_FILE = 37,
	PGINODESTEAL = 38,
	SLABS_SCANNED = 39,
	KSWAPD_INODESTEAL = 40,
	KSWAPD_LOW_WMARK_HIT_QUICKLY = 41,
	KSWAPD_HIGH_WMARK_HIT_QUICKLY = 42,
	PAGEOUTRUN = 43,
	PGROTATED = 44,
	DROP_PAGECACHE = 45,
	DROP_SLAB = 46,
	OOM_KILL = 47,
	PGMIGRATE_SUCCESS = 48,
	PGMIGRATE_FAIL = 49,
	THP_MIGRATION_SUCCESS = 50,
	THP_MIGRATION_FAIL = 51,
	THP_MIGRATION_SPLIT = 52,
	COMPACTMIGRATE_SCANNED = 53,
	COMPACTFREE_SCANNED = 54,
	COMPACTISOLATED = 55,
	COMPACTSTALL = 56,
	COMPACTFAIL = 57,
	COMPACTSUCCESS = 58,
	KCOMPACTD_WAKE = 59,
	KCOMPACTD_MIGRATE_SCANNED = 60,
	KCOMPACTD_FREE_SCANNED = 61,
	CMA_ALLOC_SUCCESS = 62,
	CMA_ALLOC_FAIL = 63,
	UNEVICTABLE_PGCULLED = 64,
	UNEVICTABLE_PGSCANNED = 65,
	UNEVICTABLE_PGRESCUED = 66,
	UNEVICTABLE_PGMLOCKED = 67,
	UNEVICTABLE_PGMUNLOCKED = 68,
	UNEVICTABLE_PGCLEARED = 69,
	UNEVICTABLE_PGSTRANDED = 70,
	BALLOON_INFLATE = 71,
	BALLOON_DEFLATE = 72,
	BALLOON_MIGRATE = 73,
	SWAP_RA = 74,
	SWAP_RA_HIT = 75,
	SWPIN_ZERO = 76,
	SWPOUT_ZERO = 77,
	KSM_SWPIN_COPY = 78,
	COW_KSM = 79,
	ZSWPIN = 80,
	ZSWPOUT = 81,
	ZSWPWB = 82,
	NR_VM_EVENT_ITEMS = 83,
};

enum vm_fault_reason {
	VM_FAULT_OOM = 1,
	VM_FAULT_SIGBUS = 2,
	VM_FAULT_MAJOR = 4,
	VM_FAULT_HWPOISON = 16,
	VM_FAULT_HWPOISON_LARGE = 32,
	VM_FAULT_SIGSEGV = 64,
	VM_FAULT_NOPAGE = 256,
	VM_FAULT_LOCKED = 512,
	VM_FAULT_RETRY = 1024,
	VM_FAULT_FALLBACK = 2048,
	VM_FAULT_DONE_COW = 4096,
	VM_FAULT_NEEDDSYNC = 8192,
	VM_FAULT_COMPLETED = 16384,
	VM_FAULT_HINDEX_MASK = 983040,
};

enum vm_stat_item {
	NR_DIRTY_THRESHOLD = 0,
	NR_DIRTY_BG_THRESHOLD = 1,
	NR_MEMMAP_PAGES = 2,
	NR_MEMMAP_BOOT_PAGES = 3,
	NR_VM_STAT_ITEMS = 4,
};

enum vma_merge_state {
	VMA_MERGE_START = 0,
	VMA_MERGE_ERROR_NOMEM = 1,
	VMA_MERGE_NOMERGE = 2,
	VMA_MERGE_SUCCESS = 3,
};

enum vmpressure_levels {
	VMPRESSURE_LOW = 0,
	VMPRESSURE_MEDIUM = 1,
	VMPRESSURE_CRITICAL = 2,
	VMPRESSURE_NUM_LEVELS = 3,
};

enum vmpressure_modes {
	VMPRESSURE_NO_PASSTHROUGH = 0,
	VMPRESSURE_HIERARCHY = 1,
	VMPRESSURE_LOCAL = 2,
	VMPRESSURE_NUM_MODES = 3,
};

enum vmscan_throttle_state {
	VMSCAN_THROTTLE_WRITEBACK = 0,
	VMSCAN_THROTTLE_ISOLATED = 1,
	VMSCAN_THROTTLE_NOPROGRESS = 2,
	VMSCAN_THROTTLE_CONGESTED = 3,
	NR_VMSCAN_THROTTLE = 4,
};

enum voltage_swing_level {
	VOLTAGE_LEVEL_0 = 0,
	VOLTAGE_LEVEL_1 = 1,
	VOLTAGE_LEVEL_2 = 2,
	VOLTAGE_LEVEL_3 = 3,
};

enum vop_data_format {
	VOP_FMT_ARGB8888 = 0,
	VOP_FMT_RGB888 = 1,
	VOP_FMT_RGB565 = 2,
	VOP_FMT_YUV420SP = 4,
	VOP_FMT_YUV422SP = 5,
	VOP_FMT_YUV444SP = 6,
};

enum vop_pending {
	VOP_PENDING_FB_UNREF = 0,
};

enum vop_pol {
	HSYNC_POSITIVE = 0,
	VSYNC_POSITIVE = 1,
	DEN_NEGATIVE = 2,
};

enum vp_vq_vector_policy {
	VP_VQ_VECTOR_POLICY_EACH = 0,
	VP_VQ_VECTOR_POLICY_SHARED_SLOW = 1,
	VP_VQ_VECTOR_POLICY_SHARED = 2,
};

enum wb_reason {
	WB_REASON_BACKGROUND = 0,
	WB_REASON_VMSCAN = 1,
	WB_REASON_SYNC = 2,
	WB_REASON_PERIODIC = 3,
	WB_REASON_LAPTOP_TIMER = 4,
	WB_REASON_FS_FREE_SPACE = 5,
	WB_REASON_FORKER_THREAD = 6,
	WB_REASON_FOREIGN_FLUSH = 7,
	WB_REASON_MAX = 8,
};

enum wb_stat_item {
	WB_RECLAIMABLE = 0,
	WB_WRITEBACK = 1,
	WB_DIRTIED = 2,
	WB_WRITTEN = 3,
	NR_WB_STAT_ITEMS = 4,
};

enum wb_state {
	WB_registered = 0,
	WB_writeback_running = 1,
	WB_has_dirty_io = 2,
	WB_start_all = 3,
};

enum wbt_flags {
	WBT_TRACKED = 1,
	WBT_READ = 2,
	WBT_SWAP = 4,
	WBT_DISCARD = 8,
	WBT_NR_BITS = 4,
};

enum why_no_delegation4 {
	WND4_NOT_WANTED = 0,
	WND4_CONTENTION = 1,
	WND4_RESOURCE = 2,
	WND4_NOT_SUPP_FTYPE = 3,
	WND4_WRITE_DELEG_NOT_SUPP_FTYPE = 4,
	WND4_NOT_SUPP_UPGRADE = 5,
	WND4_NOT_SUPP_DOWNGRADE = 6,
	WND4_CANCELLED = 7,
	WND4_IS_DIR = 8,
};

enum wiphy_flags {
	WIPHY_FLAG_SUPPORTS_EXT_KEK_KCK = 1,
	WIPHY_FLAG_SUPPORTS_MLO = 2,
	WIPHY_FLAG_SPLIT_SCAN_6GHZ = 4,
	WIPHY_FLAG_NETNS_OK = 8,
	WIPHY_FLAG_PS_ON_BY_DEFAULT = 16,
	WIPHY_FLAG_4ADDR_AP = 32,
	WIPHY_FLAG_4ADDR_STATION = 64,
	WIPHY_FLAG_CONTROL_PORT_PROTOCOL = 128,
	WIPHY_FLAG_IBSS_RSN = 256,
	WIPHY_FLAG_DISABLE_WEXT = 512,
	WIPHY_FLAG_MESH_AUTH = 1024,
	WIPHY_FLAG_SUPPORTS_EXT_KCK_32 = 2048,
	WIPHY_FLAG_SUPPORTS_NSTR_NONPRIMARY = 4096,
	WIPHY_FLAG_SUPPORTS_FW_ROAM = 8192,
	WIPHY_FLAG_AP_UAPSD = 16384,
	WIPHY_FLAG_SUPPORTS_TDLS = 32768,
	WIPHY_FLAG_TDLS_EXTERNAL_SETUP = 65536,
	WIPHY_FLAG_HAVE_AP_SME = 131072,
	WIPHY_FLAG_REPORTS_OBSS = 262144,
	WIPHY_FLAG_AP_PROBE_RESP_OFFLOAD = 524288,
	WIPHY_FLAG_OFFCHAN_TX = 1048576,
	WIPHY_FLAG_HAS_REMAIN_ON_CHANNEL = 2097152,
	WIPHY_FLAG_SUPPORTS_5_10_MHZ = 4194304,
	WIPHY_FLAG_HAS_CHANNEL_SWITCH = 8388608,
	WIPHY_FLAG_NOTIFY_REGDOM_BY_DRIVER = 16777216,
	WIPHY_FLAG_CHANNEL_CHANGE_ON_BEACON = 33554432,
};

enum wm8994_type {
	WM8994 = 0,
	WM8958 = 1,
	WM1811 = 2,
};

enum work_bits {
	WORK_STRUCT_PENDING_BIT = 0,
	WORK_STRUCT_INACTIVE_BIT = 1,
	WORK_STRUCT_PWQ_BIT = 2,
	WORK_STRUCT_LINKED_BIT = 3,
	WORK_STRUCT_FLAG_BITS = 4,
	WORK_STRUCT_COLOR_SHIFT = 4,
	WORK_STRUCT_COLOR_BITS = 4,
	WORK_STRUCT_PWQ_SHIFT = 8,
	WORK_OFFQ_FLAG_SHIFT = 4,
	WORK_OFFQ_BH_BIT = 4,
	WORK_OFFQ_FLAG_END = 5,
	WORK_OFFQ_FLAG_BITS = 1,
	WORK_OFFQ_DISABLE_SHIFT = 5,
	WORK_OFFQ_DISABLE_BITS = 16,
	WORK_OFFQ_POOL_SHIFT = 21,
	WORK_OFFQ_LEFT = 11,
	WORK_OFFQ_POOL_BITS = 11,
};

enum work_cancel_flags {
	WORK_CANCEL_DELAYED = 1,
	WORK_CANCEL_DISABLE = 2,
};

enum work_flags {
	WORK_STRUCT_PENDING = 1,
	WORK_STRUCT_INACTIVE = 2,
	WORK_STRUCT_PWQ = 4,
	WORK_STRUCT_LINKED = 8,
	WORK_STRUCT_STATIC = 0,
};

enum worker_flags {
	WORKER_DIE = 2,
	WORKER_IDLE = 4,
	WORKER_PREP = 8,
	WORKER_CPU_INTENSIVE = 64,
	WORKER_UNBOUND = 128,
	WORKER_REBOUND = 256,
	WORKER_NOT_RUNNING = 456,
};

enum worker_pool_flags {
	POOL_BH = 1,
	POOL_MANAGER_ACTIVE = 2,
	POOL_DISASSOCIATED = 4,
	POOL_BH_DRAINING = 8,
};

enum wp_types {
	ESDHC_WP_NONE = 0,
	ESDHC_WP_CONTROLLER = 1,
	ESDHC_WP_GPIO = 2,
};

enum wq_affn_scope {
	WQ_AFFN_DFL = 0,
	WQ_AFFN_CPU = 1,
	WQ_AFFN_SMT = 2,
	WQ_AFFN_CACHE = 3,
	WQ_AFFN_NUMA = 4,
	WQ_AFFN_SYSTEM = 5,
	WQ_AFFN_NR_TYPES = 6,
};

enum wq_consts {
	WQ_MAX_ACTIVE = 2048,
	WQ_UNBOUND_MAX_ACTIVE = 2048,
	WQ_DFL_ACTIVE = 1024,
	WQ_DFL_MIN_ACTIVE = 8,
};

enum wq_flags {
	WQ_BH = 1,
	WQ_UNBOUND = 2,
	WQ_FREEZABLE = 4,
	WQ_MEM_RECLAIM = 8,
	WQ_HIGHPRI = 16,
	WQ_CPU_INTENSIVE = 32,
	WQ_SYSFS = 64,
	WQ_POWER_EFFICIENT = 128,
	__WQ_DESTROYING = 32768,
	__WQ_DRAINING = 65536,
	__WQ_ORDERED = 131072,
	__WQ_LEGACY = 262144,
	__WQ_BH_ALLOWS = 17,
};

enum wq_internal_consts {
	NR_STD_WORKER_POOLS = 2,
	UNBOUND_POOL_HASH_ORDER = 6,
	BUSY_WORKER_HASH_ORDER = 6,
	MAX_IDLE_WORKERS_RATIO = 4,
	IDLE_WORKER_TIMEOUT = 75000,
	MAYDAY_INITIAL_TIMEOUT = 2,
	MAYDAY_INTERVAL = 25,
	CREATE_COOLDOWN = 250,
	RESCUER_NICE_LEVEL = -20,
	HIGHPRI_NICE_LEVEL = -20,
	WQ_NAME_LEN = 32,
	WORKER_ID_LEN = 42,
};

enum wq_misc_consts {
	WORK_NR_COLORS = 16,
	WORK_CPU_UNBOUND = 8,
	WORK_BUSY_PENDING = 1,
	WORK_BUSY_RUNNING = 2,
	WORKER_DESC_LEN = 32,
};

enum writeback_sync_modes {
	WB_SYNC_NONE = 0,
	WB_SYNC_ALL = 1,
};

enum x509_actions {
	ACT_x509_extract_key_data = 0,
	ACT_x509_extract_name_segment = 1,
	ACT_x509_note_OID = 2,
	ACT_x509_note_issuer = 3,
	ACT_x509_note_not_after = 4,
	ACT_x509_note_not_before = 5,
	ACT_x509_note_params = 6,
	ACT_x509_note_serial = 7,
	ACT_x509_note_sig_algo = 8,
	ACT_x509_note_signature = 9,
	ACT_x509_note_subject = 10,
	ACT_x509_note_tbs_certificate = 11,
	ACT_x509_process_extension = 12,
	NR__x509_actions = 13,
};

enum x509_akid_actions {
	ACT_x509_akid_note_kid = 0,
	ACT_x509_akid_note_name = 1,
	ACT_x509_akid_note_serial = 2,
	ACT_x509_extract_name_segment___2 = 3,
	ACT_x509_note_OID___2 = 4,
	NR__x509_akid_actions = 5,
};

enum xa_lock_type {
	XA_LOCK_IRQ = 1,
	XA_LOCK_BH = 2,
};

enum xc2028_state {
	XC2028_NO_FIRMWARE = 0,
	XC2028_WAITING_FIRMWARE = 1,
	XC2028_ACTIVE = 2,
	XC2028_SLEEP = 3,
	XC2028_NODEV = 4,
};

enum xdma_ip_type {
	XDMA_TYPE_AXIDMA = 0,
	XDMA_TYPE_CDMA = 1,
	XDMA_TYPE_VDMA = 2,
	XDMA_TYPE_AXIMCDMA = 3,
};

enum xdp_action {
	XDP_ABORTED = 0,
	XDP_DROP = 1,
	XDP_PASS = 2,
	XDP_TX = 3,
	XDP_REDIRECT = 4,
};

enum xdp_buff_flags {
	XDP_FLAGS_HAS_FRAGS = 1,
	XDP_FLAGS_FRAGS_PF_MEMALLOC = 2,
};

enum xdp_mem_type {
	MEM_TYPE_PAGE_SHARED = 0,
	MEM_TYPE_PAGE_ORDER0 = 1,
	MEM_TYPE_PAGE_POOL = 2,
	MEM_TYPE_XSK_BUFF_POOL = 3,
	MEM_TYPE_MAX = 4,
};

enum xdp_rss_hash_type {
	XDP_RSS_L3_IPV4 = 1,
	XDP_RSS_L3_IPV6 = 2,
	XDP_RSS_L3_DYNHDR = 4,
	XDP_RSS_L4 = 8,
	XDP_RSS_L4_TCP = 16,
	XDP_RSS_L4_UDP = 32,
	XDP_RSS_L4_SCTP = 64,
	XDP_RSS_L4_IPSEC = 128,
	XDP_RSS_L4_ICMP = 256,
	XDP_RSS_TYPE_NONE = 0,
	XDP_RSS_TYPE_L2 = 0,
	XDP_RSS_TYPE_L3_IPV4 = 1,
	XDP_RSS_TYPE_L3_IPV6 = 2,
	XDP_RSS_TYPE_L3_IPV4_OPT = 5,
	XDP_RSS_TYPE_L3_IPV6_EX = 6,
	XDP_RSS_TYPE_L4_ANY = 8,
	XDP_RSS_TYPE_L4_IPV4_TCP = 25,
	XDP_RSS_TYPE_L4_IPV4_UDP = 41,
	XDP_RSS_TYPE_L4_IPV4_SCTP = 73,
	XDP_RSS_TYPE_L4_IPV4_IPSEC = 137,
	XDP_RSS_TYPE_L4_IPV4_ICMP = 265,
	XDP_RSS_TYPE_L4_IPV6_TCP = 26,
	XDP_RSS_TYPE_L4_IPV6_UDP = 42,
	XDP_RSS_TYPE_L4_IPV6_SCTP = 74,
	XDP_RSS_TYPE_L4_IPV6_IPSEC = 138,
	XDP_RSS_TYPE_L4_IPV6_ICMP = 266,
	XDP_RSS_TYPE_L4_IPV6_TCP_EX = 30,
	XDP_RSS_TYPE_L4_IPV6_UDP_EX = 46,
	XDP_RSS_TYPE_L4_IPV6_SCTP_EX = 78,
};

enum xdp_rx_metadata {
	XDP_METADATA_KFUNC_RX_TIMESTAMP = 0,
	XDP_METADATA_KFUNC_RX_HASH = 1,
	XDP_METADATA_KFUNC_RX_VLAN_TAG = 2,
	MAX_XDP_METADATA_KFUNC = 3,
};

enum xen_domain_type {
	XEN_NATIVE = 0,
	XEN_PV_DOMAIN = 1,
	XEN_HVM_DOMAIN = 2,
};

enum xfer_buf_dir {
	TO_XFER_BUF = 0,
	FROM_XFER_BUF = 1,
};

enum xfrm_ae_ftype_t {
	XFRM_AE_UNSPEC = 0,
	XFRM_AE_RTHR = 1,
	XFRM_AE_RVAL = 2,
	XFRM_AE_LVAL = 4,
	XFRM_AE_ETHR = 8,
	XFRM_AE_CR = 16,
	XFRM_AE_CE = 32,
	XFRM_AE_CU = 64,
	__XFRM_AE_MAX = 65,
};

enum xfrm_attr_type_t {
	XFRMA_UNSPEC = 0,
	XFRMA_ALG_AUTH = 1,
	XFRMA_ALG_CRYPT = 2,
	XFRMA_ALG_COMP = 3,
	XFRMA_ENCAP = 4,
	XFRMA_TMPL = 5,
	XFRMA_SA = 6,
	XFRMA_POLICY = 7,
	XFRMA_SEC_CTX = 8,
	XFRMA_LTIME_VAL = 9,
	XFRMA_REPLAY_VAL = 10,
	XFRMA_REPLAY_THRESH = 11,
	XFRMA_ETIMER_THRESH = 12,
	XFRMA_SRCADDR = 13,
	XFRMA_COADDR = 14,
	XFRMA_LASTUSED = 15,
	XFRMA_POLICY_TYPE = 16,
	XFRMA_MIGRATE = 17,
	XFRMA_ALG_AEAD = 18,
	XFRMA_KMADDRESS = 19,
	XFRMA_ALG_AUTH_TRUNC = 20,
	XFRMA_MARK = 21,
	XFRMA_TFCPAD = 22,
	XFRMA_REPLAY_ESN_VAL = 23,
	XFRMA_SA_EXTRA_FLAGS = 24,
	XFRMA_PROTO = 25,
	XFRMA_ADDRESS_FILTER = 26,
	XFRMA_PAD = 27,
	XFRMA_OFFLOAD_DEV = 28,
	XFRMA_SET_MARK = 29,
	XFRMA_SET_MARK_MASK = 30,
	XFRMA_IF_ID = 31,
	XFRMA_MTIMER_THRESH = 32,
	XFRMA_SA_DIR = 33,
	XFRMA_NAT_KEEPALIVE_INTERVAL = 34,
	XFRMA_SA_PCPU = 35,
	XFRMA_IPTFS_DROP_TIME = 36,
	XFRMA_IPTFS_REORDER_WINDOW = 37,
	XFRMA_IPTFS_DONT_FRAG = 38,
	XFRMA_IPTFS_INIT_DELAY = 39,
	XFRMA_IPTFS_MAX_QSIZE = 40,
	XFRMA_IPTFS_PKT_SIZE = 41,
	__XFRMA_MAX = 42,
};

enum xfrm_nlgroups {
	XFRMNLGRP_NONE = 0,
	XFRMNLGRP_ACQUIRE = 1,
	XFRMNLGRP_EXPIRE = 2,
	XFRMNLGRP_SA = 3,
	XFRMNLGRP_POLICY = 4,
	XFRMNLGRP_AEVENTS = 5,
	XFRMNLGRP_REPORT = 6,
	XFRMNLGRP_MIGRATE = 7,
	XFRMNLGRP_MAPPING = 8,
	__XFRMNLGRP_MAX = 9,
};

enum xfrm_pol_inexact_candidate_type {
	XFRM_POL_CAND_BOTH = 0,
	XFRM_POL_CAND_SADDR = 1,
	XFRM_POL_CAND_DADDR = 2,
	XFRM_POL_CAND_ANY = 3,
	XFRM_POL_CAND_MAX = 4,
};

enum xfrm_replay_mode {
	XFRM_REPLAY_MODE_LEGACY = 0,
	XFRM_REPLAY_MODE_BMP = 1,
	XFRM_REPLAY_MODE_ESN = 2,
};

enum xfrm_sa_dir {
	XFRM_SA_DIR_IN = 1,
	XFRM_SA_DIR_OUT = 2,
};

enum xhci_cancelled_td_status {
	TD_DIRTY = 0,
	TD_HALTED = 1,
	TD_CLEARING_CACHE = 2,
	TD_CLEARING_CACHE_DEFERRED = 3,
	TD_CLEARED = 4,
};

enum xhci_ep_reset_type {
	EP_HARD_RESET = 0,
	EP_SOFT_RESET = 1,
};

enum xhci_overhead_type {
	LS_OVERHEAD_TYPE = 0,
	FS_OVERHEAD_TYPE = 1,
	HS_OVERHEAD_TYPE = 2,
};

enum xhci_ring_type {
	TYPE_CTRL = 0,
	TYPE_ISOC = 1,
	TYPE_BULK = 2,
	TYPE_INTR = 3,
	TYPE_STREAM = 4,
	TYPE_COMMAND = 5,
	TYPE_EVENT = 6,
};

enum xhci_setup_dev {
	SETUP_CONTEXT_ONLY = 0,
	SETUP_CONTEXT_ADDRESS = 1,
};

enum xhci_sideband_notify_type {
	XHCI_SIDEBAND_XFER_RING_FREE = 0,
};

enum xhci_sideband_type {
	XHCI_SIDEBAND_AUDIO = 0,
	XHCI_SIDEBAND_VENDOR = 1,
};

enum xiic_endian {
	LITTLE = 0,
	BIG = 1,
};

enum xilinx_i2c_state {
	STATE_DONE = 0,
	STATE_ERROR = 1,
	STATE_START___3 = 2,
};

enum xprt_transports {
	XPRT_TRANSPORT_UDP = 17,
	XPRT_TRANSPORT_TCP = 6,
	XPRT_TRANSPORT_BC_TCP = -2147483642,
	XPRT_TRANSPORT_RDMA = 256,
	XPRT_TRANSPORT_BC_RDMA = -2147483392,
	XPRT_TRANSPORT_LOCAL = 257,
	XPRT_TRANSPORT_TCP_TLS = 258,
};

enum xprt_xid_rb_cmp {
	XID_RB_EQUAL = 0,
	XID_RB_LEFT = 1,
	XID_RB_RIGHT = 2,
};

enum xprtsec_policies {
	RPC_XPRTSEC_NONE = 0,
	RPC_XPRTSEC_TLS_ANON = 1,
	RPC_XPRTSEC_TLS_X509 = 2,
};

enum xps_map_type {
	XPS_CPUS = 0,
	XPS_RXQS = 1,
	XPS_MAPS_MAX = 2,
};

enum xz_check {
	XZ_CHECK_NONE = 0,
	XZ_CHECK_CRC32 = 1,
	XZ_CHECK_CRC64 = 4,
	XZ_CHECK_SHA256 = 10,
};

enum xz_mode {
	XZ_SINGLE = 0,
	XZ_PREALLOC = 1,
	XZ_DYNALLOC = 2,
};

enum xz_ret {
	XZ_OK = 0,
	XZ_STREAM_END = 1,
	XZ_UNSUPPORTED_CHECK = 2,
	XZ_MEM_ERROR = 3,
	XZ_MEMLIMIT_ERROR = 4,
	XZ_FORMAT_ERROR = 5,
	XZ_OPTIONS_ERROR = 6,
	XZ_DATA_ERROR = 7,
	XZ_BUF_ERROR = 8,
};

enum zbc_zone_alignment_method {
	ZBC_CONSTANT_ZONE_LENGTH = 1,
	ZBC_CONSTANT_ZONE_START_OFFSET = 8,
};

enum zbc_zone_cond {
	ZBC_ZONE_COND_NO_WP = 0,
	ZBC_ZONE_COND_EMPTY = 1,
	ZBC_ZONE_COND_IMP_OPEN = 2,
	ZBC_ZONE_COND_EXP_OPEN = 3,
	ZBC_ZONE_COND_CLOSED = 4,
	ZBC_ZONE_COND_READONLY = 13,
	ZBC_ZONE_COND_FULL = 14,
	ZBC_ZONE_COND_OFFLINE = 15,
};

enum zbc_zone_type {
	ZBC_ZONE_TYPE_CONV = 1,
	ZBC_ZONE_TYPE_SEQWRITE_REQ = 2,
	ZBC_ZONE_TYPE_SEQWRITE_PREF = 3,
	ZBC_ZONE_TYPE_SEQ_OR_BEFORE_REQ = 4,
	ZBC_ZONE_TYPE_GAP = 5,
};

enum zone_flags {
	ZONE_BOOSTED_WATERMARK = 0,
	ZONE_RECLAIM_ACTIVE = 1,
	ZONE_BELOW_HIGH = 2,
};

enum zone_stat_item {
	NR_FREE_PAGES = 0,
	NR_FREE_PAGES_BLOCKS = 1,
	NR_ZONE_LRU_BASE = 2,
	NR_ZONE_INACTIVE_ANON = 2,
	NR_ZONE_ACTIVE_ANON = 3,
	NR_ZONE_INACTIVE_FILE = 4,
	NR_ZONE_ACTIVE_FILE = 5,
	NR_ZONE_UNEVICTABLE = 6,
	NR_ZONE_WRITE_PENDING = 7,
	NR_MLOCK = 8,
	NR_ZSPAGES = 9,
	NR_FREE_CMA_PAGES = 10,
	NR_VM_ZONE_STAT_ITEMS = 11,
};

enum zone_type {
	ZONE_DMA = 0,
	ZONE_NORMAL = 1,
	ZONE_HIGHMEM = 2,
	ZONE_MOVABLE = 3,
	__MAX_NR_ZONES = 4,
};

enum zone_watermarks {
	WMARK_MIN = 0,
	WMARK_LOW = 1,
	WMARK_HIGH = 2,
	WMARK_PROMO = 3,
	NR_WMARK = 4,
};

enum zswap_init_type {
	ZSWAP_UNINIT = 0,
	ZSWAP_INIT_SUCCEED = 1,
	ZSWAP_INIT_FAILED = 2,
};

enum zynq_clk {
	armpll = 0,
	ddrpll = 1,
	iopll = 2,
	cpu_6or4x = 3,
	cpu_3or2x = 4,
	cpu_2x = 5,
	cpu_1x = 6,
	ddr2x = 7,
	ddr3x = 8,
	dci = 9,
	lqspi = 10,
	smc = 11,
	pcap = 12,
	gem0 = 13,
	gem1 = 14,
	fclk0 = 15,
	fclk1 = 16,
	fclk2 = 17,
	fclk3 = 18,
	can0 = 19,
	can1 = 20,
	sdio0 = 21,
	sdio1 = 22,
	uart0 = 23,
	uart1 = 24,
	spi0 = 25,
	spi1 = 26,
	dma = 27,
	usb0_aper = 28,
	usb1_aper = 29,
	gem0_aper = 30,
	gem1_aper = 31,
	sdio0_aper = 32,
	sdio1_aper = 33,
	spi0_aper = 34,
	spi1_aper = 35,
	can0_aper = 36,
	can1_aper = 37,
	i2c0_aper = 38,
	i2c1_aper = 39,
	uart0_aper = 40,
	uart1_aper = 41,
	gpio_aper = 42,
	lqspi_aper = 43,
	smc_aper = 44,
	swdt = 45,
	dbg_trc = 46,
	dbg_apb = 47,
	clk_max = 48,
};

enum zynq_io_standards {
	zynq_iostd_min = 0,
	zynq_iostd_lvcmos18 = 1,
	zynq_iostd_lvcmos25 = 2,
	zynq_iostd_lvcmos33 = 3,
	zynq_iostd_hstl = 4,
	zynq_iostd_max = 5,
};

enum zynq_pinmux_functions {
	ZYNQ_PMUX_can0 = 0,
	ZYNQ_PMUX_can1 = 1,
	ZYNQ_PMUX_ethernet0 = 2,
	ZYNQ_PMUX_ethernet1 = 3,
	ZYNQ_PMUX_gpio0 = 4,
	ZYNQ_PMUX_i2c0 = 5,
	ZYNQ_PMUX_i2c1 = 6,
	ZYNQ_PMUX_mdio0 = 7,
	ZYNQ_PMUX_mdio1 = 8,
	ZYNQ_PMUX_qspi0 = 9,
	ZYNQ_PMUX_qspi1 = 10,
	ZYNQ_PMUX_qspi_fbclk = 11,
	ZYNQ_PMUX_qspi_cs1 = 12,
	ZYNQ_PMUX_spi0 = 13,
	ZYNQ_PMUX_spi1 = 14,
	ZYNQ_PMUX_spi0_ss = 15,
	ZYNQ_PMUX_spi1_ss = 16,
	ZYNQ_PMUX_sdio0 = 17,
	ZYNQ_PMUX_sdio0_pc = 18,
	ZYNQ_PMUX_sdio0_cd = 19,
	ZYNQ_PMUX_sdio0_wp = 20,
	ZYNQ_PMUX_sdio1 = 21,
	ZYNQ_PMUX_sdio1_pc = 22,
	ZYNQ_PMUX_sdio1_cd = 23,
	ZYNQ_PMUX_sdio1_wp = 24,
	ZYNQ_PMUX_smc0_nor = 25,
	ZYNQ_PMUX_smc0_nor_cs1 = 26,
	ZYNQ_PMUX_smc0_nor_addr25 = 27,
	ZYNQ_PMUX_smc0_nand = 28,
	ZYNQ_PMUX_ttc0 = 29,
	ZYNQ_PMUX_ttc1 = 30,
	ZYNQ_PMUX_uart0 = 31,
	ZYNQ_PMUX_uart1 = 32,
	ZYNQ_PMUX_usb0 = 33,
	ZYNQ_PMUX_usb1 = 34,
	ZYNQ_PMUX_swdt0 = 35,
	ZYNQ_PMUX_MAX_FUNC = 36,
};

typedef _Bool bool;

typedef char __pad_after_uframe[4];

typedef char __pad_before_uframe[0];

typedef const char (* const ethnl_string_array_t)[32];

typedef int __kernel_clockid_t;

typedef int __kernel_daddr_t;

typedef int __kernel_key_t;

typedef int __kernel_mqd_t;

typedef int __kernel_pid_t;

typedef int __kernel_ptrdiff_t;

typedef int __kernel_rwf_t;

typedef int __kernel_ssize_t;

typedef int __kernel_timer_t;

typedef int __s32;

typedef int class_get_unused_fd_t;

typedef __kernel_clockid_t clockid_t;

typedef __s32 s32;

typedef s32 compat_clock_t;

typedef s32 compat_int_t;

typedef s32 compat_long_t;

typedef s32 compat_pid_t;

typedef s32 compat_ssize_t;

typedef s32 compat_timer_t;

typedef int cydp_t;

typedef s32 dma_cookie_t;

typedef int ext4_grpblk_t;

typedef int folio_walk_flags_t;

typedef int fpb_t;

typedef int fpi_t;

typedef s32 int32_t;

typedef int32_t key_serial_t;

typedef __kernel_key_t key_t;

typedef int mpi_size_t;

typedef __kernel_mqd_t mqd_t;

typedef s32 old_time32_t;

typedef int pci_power_t;

typedef __kernel_pid_t pid_t;

typedef __kernel_ptrdiff_t ptrdiff_t;

typedef int rmap_t;

typedef __kernel_rwf_t rwf_t;

typedef int snd_ctl_elem_iface_t;

typedef int snd_ctl_elem_type_t;

typedef int snd_pcm_access_t;

typedef int snd_pcm_format_t;

typedef int snd_pcm_state_t;

typedef int snd_pcm_subformat_t;

typedef __kernel_ssize_t ssize_t;

typedef int suspend_state_t;

typedef __kernel_timer_t timer_t;

typedef long int __kernel_long_t;

typedef __kernel_long_t __kernel_clock_t;

typedef __kernel_long_t __kernel_off_t;

typedef __kernel_long_t __kernel_old_time_t;

typedef __kernel_long_t __kernel_suseconds_t;

typedef __kernel_clock_t clock_t;

typedef long int intptr_t;

typedef long int mpi_limb_signed_t;

typedef __kernel_off_t off_t;

typedef long int snd_pcm_sframes_t;

typedef __kernel_suseconds_t suseconds_t;

typedef long long int __s64;

typedef __s64 s64;

typedef s64 int64_t;

typedef int64_t S64;

typedef long long int __kernel_loff_t;

typedef long long int __kernel_time64_t;

typedef s64 compat_loff_t;

typedef s64 ktime_t;

typedef __kernel_loff_t loff_t;

typedef long long int qsize_t;

typedef __s64 time64_t;

typedef long long unsigned int __u64;

typedef __u64 Elf64_Addr;

typedef __u64 Elf64_Off;

typedef __u64 Elf64_Xword;

typedef __u64 u64;

typedef u64 uint64_t;

typedef uint64_t U64;

typedef U64 ZSTD_VecMask;

typedef __u64 __addrpair;

typedef __u64 __be64;

typedef __u64 __le64;

typedef __u64 __virtio64;

typedef u64 acpi_io_address;

typedef u64 arm_lpae_iopte;

typedef u64 async_cookie_t;

typedef __u64 blist_flags_t;

typedef u64 blkcnt_t;

typedef u64 clientid4;

typedef u64 compat_u64;

typedef u64 efi_physical_addr_t;

typedef long long unsigned int ext4_fsblk_t;

typedef __be64 fdt64_t;

typedef u64 freelist_full_t;

typedef u64 io_req_flags_t;

typedef long long unsigned int llu;

typedef u64 netdev_features_t;

typedef u64 sci_t;

typedef u64 sector_t;

typedef __u64 timeu64_t;

typedef u64 u_int64_t;

typedef u64 upf_t;

typedef __u64 v4l2_std_id;

typedef uint64_t vli_type;

typedef long unsigned int mpi_limb_t;

typedef mpi_limb_t UWtype;

typedef long unsigned int __kernel_ulong_t;

typedef __kernel_ulong_t aio_context_t;

typedef long unsigned int cycles_t;

typedef long unsigned int efi_status_t;

typedef long unsigned int elf_greg_t;

typedef elf_greg_t elf_gregset_t[18];

typedef __kernel_ulong_t ino_t;

typedef long unsigned int irq_hw_number_t;

typedef long unsigned int kernel_ulong_t;

typedef long unsigned int kimage_entry_t;

typedef long unsigned int mdp5_smp_state_t[2];

typedef mpi_limb_t *mpi_ptr_t;

typedef long unsigned int netmem_ref;

typedef long unsigned int old_sigset_t;

typedef long unsigned int pte_marker;

typedef long unsigned int snd_pcm_uframes_t;

typedef long unsigned int uLong;

typedef long unsigned int u_long;

typedef long unsigned int uintptr_t;

typedef long unsigned int ulg;

typedef long unsigned int ulong;

typedef uintptr_t uptrval;

typedef long unsigned int vm_flags_t;

typedef short int __s16;

typedef __s16 s16;

typedef s16 int16_t;

typedef int16_t S16;

typedef short int mm_id_mapcount_t;

typedef short unsigned int __u16;

typedef __u16 Elf32_Half;

typedef __u16 Elf64_Half;

typedef short unsigned int ush;

typedef ush Pos;

typedef __u16 u16;

typedef u16 uint16_t;

typedef uint16_t U16;

typedef __u16 __be16;

typedef __u16 __hc16;

typedef short unsigned int __kernel_gid16_t;

typedef short unsigned int __kernel_gid_t;

typedef short unsigned int __kernel_ipc_pid_t;

typedef short unsigned int __kernel_mode_t;

typedef short unsigned int __kernel_old_dev_t;

typedef __kernel_gid_t __kernel_old_gid_t;

typedef short unsigned int __kernel_uid_t;

typedef __kernel_uid_t __kernel_old_uid_t;

typedef short unsigned int __kernel_sa_family_t;

typedef short unsigned int __kernel_uid16_t;

typedef __u16 __le16;

typedef __u16 __sum16;

typedef __u16 __virtio16;

typedef u16 access_mask_t;

typedef __u16 comp_t;

typedef u16 efi_char16_t;

typedef __kernel_gid16_t gid16_t;

typedef u16 layer_mask_t;

typedef short unsigned int mifi_t;

typedef short unsigned int mm_id_t;

typedef __kernel_mode_t mode_t;

typedef __kernel_old_gid_t old_gid_t;

typedef __kernel_old_uid_t old_uid_t;

typedef short unsigned int pci_bus_flags_t;

typedef short unsigned int pci_dev_flags_t;

typedef short unsigned int pipe_index_t;

typedef __kernel_sa_family_t sa_family_t;

typedef u16 u_int16_t;

typedef short unsigned int u_short;

typedef u16 ucs2_char_t;

typedef __kernel_uid16_t uid16_t;

typedef __u16 uio_meta_flags_t;

typedef short unsigned int umode_t;

typedef short unsigned int ushort;

typedef short unsigned int vifi_t;

typedef u16 wchar_t;

typedef signed char __s8;

typedef __s8 s8;

typedef s8 int8_t;

typedef signed char int8x16_t[16];

typedef signed char int8x8_t[8];

typedef signed char poly8x16_t[16];

typedef unsigned char __u8;

typedef __u8 u8;

typedef u8 uint8_t;

typedef uint8_t BYTE;

typedef unsigned char Byte;

typedef uint8_t U8;

typedef u8 blk_status_t;

typedef unsigned char cc_t;

typedef u8 deny_masks_t;

typedef u8 dscp_t;

typedef __u8 dvd_challenge[10];

typedef __u8 dvd_key[5];

typedef u8 efi_bool_t;

typedef u8 rmap_age_t;

typedef unsigned char *sk_buff_data_t;

typedef unsigned char u8___2;

typedef unsigned char u_char;

typedef u8 u_int8_t;

typedef unsigned char uch;

typedef unsigned char uint8_t___2;

typedef unsigned char uint8x16_t[16];

typedef unsigned char uint8x8_t[8];

typedef uint8x16_t unative_t;

typedef const unsigned char utf8leaf_t;

typedef const unsigned char utf8trie_t;

typedef unsigned int __kernel_size_t;

typedef __kernel_size_t size_t;

typedef size_t BitContainerType;

typedef unsigned int __u32;

typedef __u32 Elf32_Addr;

typedef __u32 Elf32_Off;

typedef __u32 Elf32_Word;

typedef __u32 Elf64_Word;

typedef unsigned int FSE_CTable;

typedef unsigned int FSE_DTable;

typedef size_t HUF_CElt;

typedef __u32 u32;

typedef u32 uint32_t;

typedef uint32_t U32;

typedef U32 HUF_DTable;

typedef unsigned int IPos;

typedef unsigned int USItype;

typedef __u32 __be32;

typedef u32 __compat_uid32_t;

typedef __u32 __dw;

typedef __u32 __hc32;

typedef u32 __kernel_dev_t;

typedef unsigned int __kernel_gid32_t;

typedef unsigned int __kernel_uid32_t;

typedef __u32 __le32;

typedef unsigned int __poll_t;

typedef __u32 __portpair;

typedef __u32 __virtio32;

typedef __u32 __wsum;

typedef u32 acpi_object_type;

typedef unsigned int autofs_wqt_t;

typedef unsigned int blk_features_t;

typedef unsigned int blk_flags_t;

typedef unsigned int blk_insert_t;

typedef unsigned int blk_mode_t;

typedef __u32 blk_mq_req_flags_t;

typedef __u32 blk_opf_t;

typedef unsigned int blk_qc_t;

typedef u32 block_t;

typedef u32 compat_caddr_t;

typedef u32 compat_size_t;

typedef u32 compat_uint_t;

typedef u32 compat_ulong_t;

typedef u32 compat_uptr_t;

typedef u32 depot_stack_handle_t;

typedef __kernel_dev_t dev_t;

typedef u32 dma_addr_t;

typedef uint32_t drbg_flag_t;

typedef unsigned int drm_magic_t;

typedef u32 errseq_t;

typedef unsigned int ext4_group_t;

typedef __u32 ext4_lblk_t;

typedef __le32 f2fs_hash_t;

typedef __be32 fdt32_t;

typedef unsigned int fgf_t;

typedef unsigned int fmode_t;

typedef unsigned int fop_flags_t;

typedef unsigned int gfp_t;

typedef __kernel_gid32_t gid_t;

typedef __u32 if_mask;

typedef unsigned int ioasid_t;

typedef unsigned int iov_iter_extraction_t;

typedef unsigned int isolate_mode_t;

typedef uint32_t itt_t;

typedef u32 jump_label_t;

typedef unsigned int kasan_vmalloc_flags_t;

typedef uint32_t key_perm_t;

typedef u32 kprobe_opcode_t;

typedef unsigned int mmc_pm_flag_t;

typedef u32 nid_t;

typedef u32 nlink_t;

typedef u32 pci_bus_addr_t;

typedef unsigned int pci_channel_state_t;

typedef unsigned int pci_ers_result_t;

typedef u32 pmdval_t;

typedef pmdval_t pgd_t[2];

typedef u32 pteval_t;

typedef pteval_t pgprot_t;

typedef unsigned int pgtbl_mod_mask;

typedef u32 phandle;

typedef u32 phys_addr_t;

typedef pmdval_t pmd_t;

typedef u32 probes_opcode_t;

typedef __kernel_uid32_t projid_t;

typedef pteval_t pte_t;

typedef __kernel_uid32_t qid_t;

typedef U32 rankValCol_t[13];

typedef __u32 req_flags_t;

typedef phys_addr_t resource_size_t;

typedef u32 rpc_authflavor_t;

typedef __be32 rpc_fraghdr;

typedef unsigned int slab_flags_t;

typedef unsigned int speed_t;

typedef u32 ssci_t;

typedef u32 sysmmu_iova_t;

typedef u32 sysmmu_pte_t;

typedef unsigned int t_key;

typedef unsigned int tcflag_t;

typedef unsigned int tid_t;

typedef unsigned int uInt;

typedef unsigned int u_int;

typedef u32 u_int32_t;

typedef unsigned int uffd_flags_t;

typedef __kernel_uid32_t uid_t;

typedef unsigned int uint;

typedef u32 unative_t___2;

typedef u32 unicode_t;

typedef unsigned int upstat_t;

typedef u32 usb_port_location_t;

typedef unsigned int vm_fault_t;

typedef unsigned int xa_mark_t;

typedef u32 xdp_features_t;

typedef unsigned int zap_flags_t;

typedef struct {
	BitContainerType bitContainer;
	unsigned int bitPos;
	char *startPtr;
	char *ptr;
	char *endPtr;
} BIT_CStream_t;

typedef struct {
	BitContainerType bitContainer;
	unsigned int bitsConsumed;
	const char *ptr;
	const char *start;
	const char *limitPtr;
} BIT_DStream_t;

typedef struct {
	size_t nbSequences;
	size_t blockSize;
	size_t litSize;
} BlockSummary;

typedef struct {
	BYTE maxTableLog;
	BYTE tableType;
	BYTE tableLog;
	BYTE reserved;
} DTableDesc;

typedef struct {
	size_t estLitSize;
	size_t estBlockSize;
} EstimatedBlockSize;

typedef struct {
	unsigned int events[1024];
	size_t nbEvents;
} Fingerprint;

typedef struct {
	Fingerprint pastEvents;
	Fingerprint newEvents;
} FPStats;

typedef struct {
	ptrdiff_t value;
	const void *stateTable;
	const void *symbolTT;
	unsigned int stateLog;
} FSE_CState_t;

typedef struct {
	size_t state;
	const void *table;
} FSE_DState_t;

typedef struct {
	U16 tableLog;
	U16 fastMode;
} FSE_DTableHeader;

typedef struct {
	short int ncount[256];
} FSE_DecompressWksp;

typedef struct {
	short unsigned int newState;
	unsigned char symbol;
	unsigned char nbBits;
} FSE_decode_t;

typedef struct {
	int deltaFindState;
	U32 deltaNbBits;
} FSE_symbolCompressionTransform;

typedef struct {
	size_t bitContainer[2];
	size_t bitPos[2];
	BYTE *startPtr;
	BYTE *ptr;
	BYTE *endPtr;
} HUF_CStream_t;

typedef struct {
	BYTE tableLog;
	BYTE maxSymbolValue;
	BYTE unused[2];
} HUF_CTableHeader;

typedef struct {
	FSE_CTable CTable[59];
	U32 scratchBuffer[41];
	unsigned int count[13];
	S16 norm[13];
} HUF_CompressWeightsWksp;

typedef struct {
	BYTE nbBits;
	BYTE byte;
} HUF_DEltX1;

typedef struct {
	U16 sequence;
	BYTE nbBits;
	BYTE length;
} HUF_DEltX2;

typedef struct {
	const BYTE *ip[4];
	BYTE *op[4];
	U64 bits[4];
	const void *dt;
	const BYTE *ilowest;
	BYTE *oend;
	const BYTE *iend[4];
	long: 32;
} HUF_DecompressFastArgs;

typedef struct {
	U32 rankVal[13];
	U32 rankStart[13];
	U32 statsWksp[219];
	BYTE symbols[256];
	BYTE huffWeight[256];
} HUF_ReadDTableX1_Workspace;

typedef struct {
	BYTE symbol;
} sortedSymbol_t;

typedef struct {
	U32 rankVal[156];
	U32 rankStats[13];
	U32 rankStart0[15];
	sortedSymbol_t sortedSymbol[256];
	BYTE weightList[256];
	U32 calleeWksp[219];
} HUF_ReadDTableX2_Workspace;

typedef struct {
	HUF_CompressWeightsWksp wksp;
	BYTE bitsToWeight[13];
	BYTE huffWeight[255];
} HUF_WriteCTableWksp;

struct nodeElt_s {
	U32 count;
	U16 parent;
	BYTE byte;
	BYTE nbBits;
};

typedef struct nodeElt_s nodeElt;

typedef nodeElt huffNodeTable[512];

typedef struct {
	U16 base;
	U16 curr;
} rankPos;

typedef struct {
	huffNodeTable huffNodeTbl;
	rankPos rankPosition[192];
} HUF_buildCTable_wksp_tables;

typedef struct {
	unsigned int count[256];
	HUF_CElt CTable[257];
	union {
		HUF_buildCTable_wksp_tables buildCTable_wksp;
		HUF_WriteCTableWksp writeCTable_wksp;
		U32 hist_wksp[1024];
	} wksps;
} HUF_compress_tables_t;

struct buffer_head;

typedef struct {
	__le32 *p;
	__le32 key;
	struct buffer_head *bh;
} Indirect;

typedef struct {
	unsigned int hashTable[32768];
	short unsigned int chainTable[65536];
	const unsigned char *end;
	const unsigned char *base;
	const unsigned char *dictBase;
	unsigned int dictLimit;
	unsigned int lowLimit;
	unsigned int nextToUpdate;
	unsigned int compressionLevel;
} LZ4HC_CCtx_internal;

typedef struct {
	const uint8_t *externalDict;
	size_t extDictSize;
	const uint8_t *prefixEnd;
	size_t prefixSize;
} LZ4_streamDecode_t_internal;

typedef union {
	long long unsigned int table[4];
	LZ4_streamDecode_t_internal internal_donotuse;
} LZ4_streamDecode_t;

typedef union {
	size_t table[65548];
	LZ4HC_CCtx_internal internal_donotuse;
} LZ4_streamHC_t;

typedef struct {
	uint32_t hashTable[4096];
	uint32_t currentOffset;
	uint32_t initCheck;
	const uint8_t *dictionary;
	uint8_t *bufferStart;
	uint32_t dictSize;
} LZ4_stream_t_internal;

typedef union {
	long long unsigned int table[2052];
	LZ4_stream_t_internal internal_donotuse;
} LZ4_stream_t;

typedef struct {
	U32 offset;
	U32 litLength;
	U32 matchLength;
} rawSeq;

typedef struct {
	rawSeq *seq;
	size_t pos;
	size_t posInSequence;
	size_t size;
	size_t capacity;
} RawSeqStore_t;

struct folio;

typedef struct {
	struct folio *v;
} Sector;

typedef struct {
	unsigned int offset;
	unsigned int litLength;
	unsigned int matchLength;
	unsigned int rep;
} ZSTD_Sequence;

typedef struct {
	int collectSequences;
	ZSTD_Sequence *seqStart;
	size_t seqIndex;
	size_t maxSequences;
} SeqCollector;

struct SeqDef_s;

typedef struct SeqDef_s SeqDef;

typedef struct {
	SeqDef *sequencesStart;
	SeqDef *sequences;
	BYTE *litStart;
	BYTE *lit;
	BYTE *llCode;
	BYTE *mlCode;
	BYTE *ofCode;
	size_t maxNbSeq;
	size_t maxNbLit;
	ZSTD_longLengthType_e longLengthType;
	U32 longLengthPos;
} SeqStore_t;

typedef struct {
	S16 norm[53];
	U32 wksp[285];
} ZSTD_BuildCTableWksp;

struct ZSTD_DDict_s;

typedef struct ZSTD_DDict_s ZSTD_DDict;

typedef struct {
	const ZSTD_DDict **ddictPtrTable;
	size_t ddictPtrTableSize;
	size_t ddictPtrCount;
} ZSTD_DDictHashSet;

typedef struct {
	long long unsigned int frameContentSize;
	long long unsigned int windowSize;
	unsigned int blockSizeMax;
	ZSTD_FrameType_e frameType;
	unsigned int headerSize;
	unsigned int dictID;
	unsigned int checksumFlag;
	unsigned int _reserved1;
	unsigned int _reserved2;
	long: 32;
} ZSTD_FrameHeader;

typedef struct {
	unsigned int longOffsetShare;
	unsigned int maxNbAdditionalBits;
} ZSTD_OffsetInfo;

typedef struct {
	U32 litLength;
	U32 matchLength;
} ZSTD_SequenceLength;

typedef struct {
	U32 idx;
	U32 posInSequence;
	size_t posInSrc;
} ZSTD_SequencePosition;

typedef struct {
	SymbolEncodingType_e hType;
	BYTE hufDesBuffer[128];
	size_t hufDesSize;
} ZSTD_hufCTablesMetadata_t;

typedef struct {
	SymbolEncodingType_e llType;
	SymbolEncodingType_e ofType;
	SymbolEncodingType_e mlType;
	BYTE fseTablesBuffer[133];
	size_t fseTablesSize;
	size_t lastCountSize;
} ZSTD_fseCTablesMetadata_t;

typedef struct {
	ZSTD_hufCTablesMetadata_t hufMetadata;
	ZSTD_fseCTablesMetadata_t fseMetadata;
} ZSTD_entropyCTablesMetadata_t;

typedef struct {
	SeqStore_t fullSeqStoreChunk;
	SeqStore_t firstHalfSeqStore;
	SeqStore_t secondHalfSeqStore;
	SeqStore_t currSeqStore;
	SeqStore_t nextSeqStore;
	U32 partitions[196];
	ZSTD_entropyCTablesMetadata_t entropyMetadata;
} ZSTD_blockSplitCtx;

typedef struct {
	HUF_CElt CTable[257];
	HUF_repeat repeatMode;
} ZSTD_hufCTables_t;

typedef struct {
	FSE_CTable offcodeCTable[193];
	FSE_CTable matchlengthCTable[363];
	FSE_CTable litlengthCTable[329];
	FSE_repeat offcode_repeatMode;
	FSE_repeat matchlength_repeatMode;
	FSE_repeat litlength_repeatMode;
} ZSTD_fseCTables_t;

typedef struct {
	ZSTD_hufCTables_t huf;
	ZSTD_fseCTables_t fse;
} ZSTD_entropyCTables_t;

typedef struct {
	ZSTD_entropyCTables_t entropy;
	U32 rep[3];
} ZSTD_compressedBlockState_t;

typedef struct {
	const BYTE *nextSrc;
	const BYTE *base;
	const BYTE *dictBase;
	U32 dictLimit;
	U32 lowLimit;
	U32 nbOverflowCorrections;
} ZSTD_window_t;

typedef struct {
	U32 off;
	U32 len;
} ZSTD_match_t;

typedef struct {
	int price;
	U32 off;
	U32 mlen;
	U32 litlen;
	U32 rep[3];
} ZSTD_optimal_t;

typedef struct {
	unsigned int *litFreq;
	unsigned int *litLengthFreq;
	unsigned int *matchLengthFreq;
	unsigned int *offCodeFreq;
	ZSTD_match_t *matchTable;
	ZSTD_optimal_t *priceTable;
	U32 litSum;
	U32 litLengthSum;
	U32 matchLengthSum;
	U32 offCodeSum;
	U32 litSumBasePrice;
	U32 litLengthSumBasePrice;
	U32 matchLengthSumBasePrice;
	U32 offCodeSumBasePrice;
	ZSTD_OptPrice_e priceType;
	const ZSTD_entropyCTables_t *symbolCosts;
	ZSTD_ParamSwitch_e literalCompressionMode;
} optState_t;

typedef struct {
	unsigned int windowLog;
	unsigned int chainLog;
	unsigned int hashLog;
	unsigned int searchLog;
	unsigned int minMatch;
	unsigned int targetLength;
	ZSTD_strategy strategy;
} ZSTD_compressionParameters;

struct ZSTD_MatchState_t;

typedef struct ZSTD_MatchState_t ZSTD_MatchState_t;

struct ZSTD_MatchState_t {
	ZSTD_window_t window;
	U32 loadedDictEnd;
	U32 nextToUpdate;
	U32 hashLog3;
	U32 rowHashLog;
	BYTE *tagTable;
	U32 hashCache[8];
	long: 32;
	U64 hashSalt;
	U32 hashSaltEntropy;
	U32 *hashTable;
	U32 *hashTable3;
	U32 *chainTable;
	int forceNonContiguous;
	int dedicatedDictSearch;
	optState_t opt;
	const ZSTD_MatchState_t *dictMatchState;
	ZSTD_compressionParameters cParams;
	const RawSeqStore_t *ldmSeqStore;
	int prefetchCDictTables;
	int lazySkipping;
};

typedef struct {
	ZSTD_compressedBlockState_t *prevCBlock;
	ZSTD_compressedBlockState_t *nextCBlock;
	ZSTD_MatchState_t matchState;
} ZSTD_blockState_t;

typedef struct {
	size_t error;
	int lowerBound;
	int upperBound;
} ZSTD_bounds;

typedef struct {
	U32 f1c;
	U32 f1d;
	U32 f7b;
	U32 f7c;
} ZSTD_cpuid_t;

typedef void * (*ZSTD_allocFunction)(void *, size_t);

typedef void (*ZSTD_freeFunction)(void *, void *);

typedef struct {
	ZSTD_allocFunction customAlloc;
	ZSTD_freeFunction customFree;
	void *opaque;
} ZSTD_customMem;

typedef struct {
	void *workspace;
	void *workspaceEnd;
	void *objectEnd;
	void *tableEnd;
	void *tableValidEnd;
	void *allocStart;
	void *initOnceStart;
	BYTE allocFailed;
	int workspaceOversizedDuration;
	ZSTD_cwksp_alloc_phase_e phase;
	ZSTD_cwksp_static_alloc_e isStatic;
} ZSTD_cwksp;

typedef struct {
	U16 nextState;
	BYTE nbAdditionalBits;
	BYTE nbBits;
	U32 baseValue;
} ZSTD_seqSymbol;

typedef struct {
	ZSTD_seqSymbol LLTable[513];
	ZSTD_seqSymbol OFTable[257];
	ZSTD_seqSymbol MLTable[513];
	HUF_DTable hufTable[4097];
	U32 rep[3];
	U32 workspace[157];
} ZSTD_entropyDTables_t;

typedef struct {
	int contentSizeFlag;
	int checksumFlag;
	int noDictIDFlag;
} ZSTD_frameParameters;

typedef struct {
	long long unsigned int ingested;
	long long unsigned int consumed;
	long long unsigned int produced;
	long long unsigned int flushed;
	unsigned int currentJobID;
	unsigned int nbActiveWorkers;
} ZSTD_frameProgression;

typedef struct {
	size_t nbBlocks;
	size_t compressedSize;
	long long unsigned int decompressedBound;
} ZSTD_frameSizeInfo;

typedef struct {
	size_t state;
	const ZSTD_seqSymbol *table;
} ZSTD_fseState;

struct ZSTD_CDict_s;

typedef struct ZSTD_CDict_s ZSTD_CDict;

typedef struct {
	void *dictBuffer;
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
	ZSTD_CDict *cdict;
} ZSTD_localDict;

typedef struct {
	RawSeqStore_t seqStore;
	U32 startPosInBlock;
	U32 endPosInBlock;
	U32 offset;
} ZSTD_optLdm_t;

typedef struct {
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
} ZSTD_parameters;

typedef struct {
	U32 fastMode;
	U32 tableLog;
} ZSTD_seqSymbol_header;

typedef struct {
	U32 LLtype;
	U32 Offtype;
	U32 MLtype;
	size_t size;
	size_t lastCountSize;
	int longOffsets;
} ZSTD_symbolEncodingTypeStats_t;

typedef struct {
	long unsigned int fds_bits[32];
} __kernel_fd_set;

typedef struct {
	int val[2];
} __kernel_fsid_t;

typedef struct {
	U32 tableTime;
	U32 decode256Time;
} algo_time_t;

typedef struct {
	u32 lock;
} arch_rwlock_t;

struct __raw_tickets {
	u16 owner;
	u16 next;
};

typedef struct {
	union {
		u32 slock;
		struct __raw_tickets tickets;
	};
} arch_spinlock_t;

typedef struct {
	s64 counter;
} atomic64_t;

typedef struct {
	int counter;
} atomic_t;

typedef atomic_t atomic_long_t;

typedef struct {
	char ax25_call[7];
} ax25_address;

struct hlist_node {
	struct hlist_node *next;
	struct hlist_node **pprev;
};

struct timer_list {
	struct hlist_node entry;
	long unsigned int expires;
	void (*function)(struct timer_list *);
	u32 flags;
};

typedef struct {
	char slave;
	struct timer_list slave_timer;
	short unsigned int slave_timeout;
} ax25_dama_info;

typedef struct {
	blockType_e blockType;
	U32 lastBlock;
	U32 origSize;
} blockProperties_t;

typedef struct {
	union {
		void *kernel;
		void *user;
	};
	bool is_kernel: 1;
} sockptr_t;

typedef sockptr_t bpfptr_t;

typedef struct {
	unsigned int interval;
	unsigned int timeout;
} cisco_proto;

typedef struct {
	void *lock;
} class_cpus_read_lock_t;

typedef struct {
	int *lock;
} class_disable_irq_t;

struct rq;

typedef struct {
	struct rq *lock;
	struct rq *lock2;
} class_double_rq_lock_t;

struct irq_desc;

typedef struct {
	struct irq_desc *lock;
	long unsigned int flags;
	bool bus;
} class_irqdesc_lock_t;

typedef struct {
	void *lock;
	long unsigned int flags;
} class_irqsave_t;

typedef struct {
	void *lock;
} class_jump_label_lock_t;

struct device;

typedef struct {
	struct device *lock;
} class_msi_descs_lock_t;

struct perf_cpu_context;

struct perf_event_context;

typedef struct {
	struct perf_cpu_context *cpuctx;
	struct perf_event_context *ctx;
} class_perf_ctx_lock_t;

typedef struct {
	void *lock;
} class_preempt_t;

struct raw_spinlock;

typedef struct raw_spinlock raw_spinlock_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_irq_t;

typedef struct {
	raw_spinlock_t *lock;
	long unsigned int flags;
} class_raw_spinlock_irqsave_t;

typedef struct {
	raw_spinlock_t *lock;
} class_raw_spinlock_t;

typedef struct {
	void *lock;
} class_rcu_t;

typedef struct {
	arch_rwlock_t raw_lock;
} rwlock_t;

typedef struct {
	rwlock_t *lock;
	long unsigned int flags;
} class_read_lock_irqsave_t;

struct pin_cookie {};

struct rq_flags {
	long unsigned int flags;
	struct pin_cookie cookie;
	unsigned int clock_update_flags;
};

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irq_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_irqsave_t;

typedef struct {
	struct rq *lock;
	struct rq_flags rf;
} class_rq_lock_t;

struct spinlock;

typedef struct spinlock spinlock_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_irq_t;

typedef struct {
	spinlock_t *lock;
	long unsigned int flags;
} class_spinlock_irqsave_t;

typedef struct {
	spinlock_t *lock;
} class_spinlock_t;

struct srcu_struct;

typedef struct {
	struct srcu_struct *lock;
	int idx;
} class_srcu_t;

struct task_struct;

typedef struct {
	struct task_struct *lock;
	struct rq *rq;
	struct rq_flags rf;
} class_task_rq_lock_t;

typedef struct {
	rwlock_t *lock;
} class_write_lock_irq_t;

typedef struct {
	rwlock_t *lock;
	long unsigned int flags;
} class_write_lock_irqsave_t;

typedef struct {
	unsigned char op;
	unsigned char bits;
	short unsigned int val;
} code;

typedef struct {
	__be16 disc_information_length;
	__u8 disc_status: 2;
	__u8 border_status: 2;
	__u8 erasable: 1;
	__u8 reserved1: 3;
	__u8 n_first_track;
	__u8 n_sessions_lsb;
	__u8 first_track_lsb;
	__u8 last_track_lsb;
	__u8 mrw_status: 2;
	__u8 dbit: 1;
	__u8 reserved2: 2;
	__u8 uru: 1;
	__u8 dbc_v: 1;
	__u8 did_v: 1;
	__u8 disc_type;
	__u8 n_sessions_msb;
	__u8 first_track_msb;
	__u8 last_track_msb;
	__u32 disc_id;
	__u32 lead_in;
	__u32 lead_out;
	__u8 disc_bar_code[8];
	__u8 reserved3;
	__u8 n_opc;
} disc_information;

typedef struct {
	long unsigned int bits[1];
} dma_cap_mask_t;

struct dvd_lu_send_agid {
	__u8 type;
	unsigned int agid: 2;
};

struct dvd_host_send_challenge {
	__u8 type;
	unsigned int agid: 2;
	dvd_challenge chal;
};

struct dvd_send_key {
	__u8 type;
	unsigned int agid: 2;
	dvd_key key;
};

struct dvd_lu_send_challenge {
	__u8 type;
	unsigned int agid: 2;
	dvd_challenge chal;
};

struct dvd_lu_send_title_key {
	__u8 type;
	unsigned int agid: 2;
	dvd_key title_key;
	int lba;
	unsigned int cpm: 1;
	unsigned int cp_sec: 1;
	unsigned int cgms: 2;
};

struct dvd_lu_send_asf {
	__u8 type;
	unsigned int agid: 2;
	unsigned int asf: 1;
};

struct dvd_host_send_rpcstate {
	__u8 type;
	__u8 pdrc;
};

struct dvd_lu_send_rpcstate {
	__u8 type: 2;
	__u8 vra: 3;
	__u8 ucca: 3;
	__u8 region_mask;
	__u8 rpc_scheme;
};

typedef union {
	__u8 type;
	struct dvd_lu_send_agid lsa;
	struct dvd_host_send_challenge hsc;
	struct dvd_send_key lsk;
	struct dvd_lu_send_challenge lsc;
	struct dvd_send_key hsk;
	struct dvd_lu_send_title_key lstk;
	struct dvd_lu_send_asf lsasf;
	struct dvd_host_send_rpcstate hrpcs;
	struct dvd_lu_send_rpcstate lrpcs;
} dvd_authinfo;

struct dvd_layer {
	__u8 book_version: 4;
	__u8 book_type: 4;
	__u8 min_rate: 4;
	__u8 disc_size: 4;
	__u8 layer_type: 4;
	__u8 track_path: 1;
	__u8 nlayers: 2;
	char: 1;
	__u8 track_density: 4;
	__u8 linear_density: 4;
	__u8 bca: 1;
	__u32 start_sector;
	__u32 end_sector;
	__u32 end_sector_l0;
};

struct dvd_physical {
	__u8 type;
	__u8 layer_num;
	struct dvd_layer layer[4];
};

struct dvd_copyright {
	__u8 type;
	__u8 layer_num;
	__u8 cpst;
	__u8 rmi;
};

struct dvd_disckey {
	__u8 type;
	unsigned int agid: 2;
	__u8 value[2048];
};

struct dvd_bca {
	__u8 type;
	int len;
	__u8 value[188];
};

struct dvd_manufact {
	__u8 type;
	__u8 layer_num;
	int len;
	__u8 value[2048];
};

typedef union {
	__u8 type;
	struct dvd_physical physical;
	struct dvd_copyright copyright;
	struct dvd_disckey disckey;
	struct dvd_bca bca;
	struct dvd_manufact manufact;
} dvd_struct;

typedef struct {
	u64 length;
	u64 data;
} efi_capsule_block_desc_t;

typedef struct {
	__u8 b[16];
} guid_t;

typedef guid_t efi_guid_t;

typedef struct {
	efi_guid_t guid;
	u32 headersize;
	u32 flags;
	u32 imagesize;
} efi_capsule_header_t;

typedef struct {
	efi_guid_t guid;
	u32 table;
} efi_config_table_32_t;

typedef struct {
	efi_guid_t guid;
	u64 table;
} efi_config_table_64_t;

typedef union {
	struct {
		efi_guid_t guid;
		void *table;
	};
	efi_config_table_32_t mixed_mode;
} efi_config_table_t;

typedef struct {
	efi_guid_t guid;
	long unsigned int *ptr;
	const char name[16];
} efi_config_table_type_t;

typedef struct {
	u32 type;
	u32 pad;
	u64 phys_addr;
	u64 virt_addr;
	u64 num_pages;
	u64 attribute;
} efi_memory_desc_t;

typedef struct {
	u32 version;
	u32 num_entries;
	u32 desc_size;
	u32 flags;
	efi_memory_desc_t entry[0];
} efi_memory_attributes_table_t;

typedef struct {
	u16 version;
	u16 length;
	u32 runtime_services_supported;
} efi_rt_properties_table_t;

typedef struct {
	u64 signature;
	u32 revision;
	u32 headersize;
	u32 crc32;
	u32 reserved;
} efi_table_hdr_t;

typedef struct {
	efi_table_hdr_t hdr;
	u32 get_time;
	u32 set_time;
	u32 get_wakeup_time;
	u32 set_wakeup_time;
	u32 set_virtual_address_map;
	u32 convert_pointer;
	u32 get_variable;
	u32 get_next_variable;
	u32 set_variable;
	u32 get_next_high_mono_count;
	u32 reset_system;
	u32 update_capsule;
	u32 query_capsule_caps;
	u32 query_variable_info;
} efi_runtime_services_32_t;

typedef struct {
	u16 year;
	u8 month;
	u8 day;
	u8 hour;
	u8 minute;
	u8 second;
	u8 pad1;
	u32 nanosecond;
	s16 timezone;
	u8 daylight;
	u8 pad2;
} efi_time_t;

typedef struct {
	u32 resolution;
	u32 accuracy;
	u8 sets_to_zero;
} efi_time_cap_t;

typedef efi_status_t efi_get_time_t(efi_time_t *, efi_time_cap_t *);

typedef efi_status_t efi_set_time_t(efi_time_t *);

typedef efi_status_t efi_get_wakeup_time_t(efi_bool_t *, efi_bool_t *, efi_time_t *);

typedef efi_status_t efi_set_wakeup_time_t(efi_bool_t, efi_time_t *);

typedef efi_status_t efi_set_virtual_address_map_t(long unsigned int, long unsigned int, u32, efi_memory_desc_t *);

typedef efi_status_t efi_get_variable_t(efi_char16_t *, efi_guid_t *, u32 *, long unsigned int *, void *);

typedef efi_status_t efi_get_next_variable_t(long unsigned int *, efi_char16_t *, efi_guid_t *);

typedef efi_status_t efi_set_variable_t(efi_char16_t *, efi_guid_t *, u32, long unsigned int, void *);

typedef efi_status_t efi_get_next_high_mono_count_t(u32 *);

typedef void efi_reset_system_t(int, efi_status_t, long unsigned int, efi_char16_t *);

typedef efi_status_t efi_update_capsule_t(efi_capsule_header_t **, long unsigned int, long unsigned int);

typedef efi_status_t efi_query_capsule_caps_t(efi_capsule_header_t **, long unsigned int, u64 *, int *);

typedef efi_status_t efi_query_variable_info_t(u32, u64 *, u64 *, u64 *);

typedef union {
	struct {
		efi_table_hdr_t hdr;
		efi_get_time_t *get_time;
		efi_set_time_t *set_time;
		efi_get_wakeup_time_t *get_wakeup_time;
		efi_set_wakeup_time_t *set_wakeup_time;
		efi_set_virtual_address_map_t *set_virtual_address_map;
		void *convert_pointer;
		efi_get_variable_t *get_variable;
		efi_get_next_variable_t *get_next_variable;
		efi_set_variable_t *set_variable;
		efi_get_next_high_mono_count_t *get_next_high_mono_count;
		efi_reset_system_t *reset_system;
		efi_update_capsule_t *update_capsule;
		efi_query_capsule_caps_t *query_capsule_caps;
		efi_query_variable_info_t *query_variable_info;
	};
	efi_runtime_services_32_t mixed_mode;
} efi_runtime_services_t;

typedef struct {
	efi_table_hdr_t hdr;
	u32 fw_vendor;
	u32 fw_revision;
	u32 con_in_handle;
	u32 con_in;
	u32 con_out_handle;
	u32 con_out;
	u32 stderr_handle;
	u32 stderr;
	u32 runtime;
	u32 boottime;
	u32 nr_tables;
	u32 tables;
} efi_system_table_32_t;

union efi_simple_text_input_protocol;

typedef union efi_simple_text_input_protocol efi_simple_text_input_protocol_t;

union efi_simple_text_output_protocol;

typedef union efi_simple_text_output_protocol efi_simple_text_output_protocol_t;

union efi_boot_services;

typedef union efi_boot_services efi_boot_services_t;

typedef union {
	struct {
		efi_table_hdr_t hdr;
		long unsigned int fw_vendor;
		u32 fw_revision;
		long unsigned int con_in_handle;
		efi_simple_text_input_protocol_t *con_in;
		long unsigned int con_out_handle;
		efi_simple_text_output_protocol_t *con_out;
		long unsigned int stderr_handle;
		long unsigned int stderr;
		efi_runtime_services_t *runtime;
		efi_boot_services_t *boottime;
		long unsigned int nr_tables;
		long unsigned int tables;
	};
	efi_system_table_32_t mixed_mode;
} efi_system_table_t;

typedef struct {
	__le16 e_tag;
	__le16 e_perm;
	__le32 e_id;
} ext4_acl_entry;

typedef struct {
	__le32 a_version;
} ext4_acl_header;

typedef __kernel_fd_set fd_set;

typedef struct {
	long unsigned int *in;
	long unsigned int *out;
	long unsigned int *ex;
	long unsigned int *res_in;
	long unsigned int *res_out;
	long unsigned int *res_ex;
} fd_set_bits;

typedef struct {
	atomic_t refcnt;
} file_ref_t;

typedef struct {
	unsigned int t391;
	unsigned int t392;
	unsigned int n391;
	unsigned int n392;
	unsigned int n393;
	short unsigned int lmi;
	short unsigned int dce;
} fr_proto;

typedef struct {
	unsigned int dlci;
} fr_proto_pvc;

typedef struct {
	unsigned int dlci;
	char master[16];
} fr_proto_pvc_info;

typedef union {
	struct {
		void *freelist;
		long unsigned int counter;
	};
	freelist_full_t full;
} freelist_aba_t;

typedef struct {
	long unsigned int v;
} freeptr_t;

typedef struct {
	long unsigned int key[2];
} hsiphash_key_t;

typedef struct {
	unsigned int __softirq_pending;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
} irq_cpustat_t;

typedef struct {
	u64 val;
} kernel_cap_t;

typedef struct {
	gid_t val;
} kgid_t;

typedef struct {
	projid_t val;
} kprojid_t;

typedef struct {
	uid_t val;
} kuid_t;

typedef struct {
	U32 offset;
	U32 checksum;
} ldmEntry_t;

typedef struct {
	const BYTE *split;
	U32 hash;
	U32 checksum;
	ldmEntry_t *bucket;
} ldmMatchCandidate_t;

typedef struct {
	ZSTD_ParamSwitch_e enableLdm;
	U32 hashLog;
	U32 bucketSizeLog;
	U32 minMatchLength;
	U32 hashRateLog;
	U32 windowLog;
} ldmParams_t;

typedef struct {
	U64 rolling;
	U64 stopMask;
} ldmRollingHashState_t;

typedef struct {
	ZSTD_window_t window;
	ldmEntry_t *hashTable;
	U32 loadedDictEnd;
	BYTE *bucketOffsets;
	size_t splitIndices[64];
	ldmMatchCandidate_t matchCandidates[64];
} ldmState_t;

typedef struct {
	__le64 b;
	__le64 a;
} le128;

typedef struct {
	atomic64_t a;
} local64_t;

typedef struct {} local_lock_t;

typedef struct {
	atomic_long_t a;
} local_t;

typedef struct {
	local_lock_t llock;
	u8 acquired;
} local_trylock_t;

typedef struct {} lockdep_map_p;

typedef union {
	long unsigned int x[1];
} map_word;

typedef struct {
	atomic64_t id;
	atomic_t vmalloc_seq;
	long unsigned int sigpage;
	long unsigned int vdso;
	long: 32;
} mm_context_t;

typedef struct {} netdevice_tracker;

typedef struct {} netns_tracker;

typedef struct {
	char data[8];
} nfs4_verifier;

typedef struct {
	long unsigned int bits[1];
} nodemask_t;

typedef struct {
	pgd_t pgd;
} p4d_t;

typedef struct {
	u64 pme;
} pagemap_entry_t;

typedef struct {
	u64 val;
} pfn_t;

struct net;

typedef struct {
	struct net *net;
} possible_net_t;

typedef struct {
	p4d_t p4d;
} pud_t;

typedef struct {
	short unsigned int encoding;
	short unsigned int parity;
} raw_hdlc_proto;

typedef struct {
	atomic_t refcnt;
} rcuref_t;

typedef struct {
	size_t written;
	size_t count;
	union {
		char *buf;
		void *data;
	} arg;
	int error;
} read_descriptor_t;

typedef union {
} release_pages_arg;

typedef struct {
	__u16 report_key_length;
	__u8 reserved1;
	__u8 reserved2;
	__u8 ucca: 3;
	__u8 vra: 3;
	__u8 type_code: 2;
	__u8 region_mask;
	__u8 rpc_scheme;
	__u8 reserved3;
} rpc_state_t;

typedef struct {
	BIT_DStream_t DStream;
	ZSTD_fseState stateLL;
	ZSTD_fseState stateOffb;
	ZSTD_fseState stateML;
	size_t prevOffset[3];
} seqState_t;

typedef struct {
	U32 *splitLocations;
	size_t idx;
} seqStoreSplits;

typedef struct {
	size_t litLength;
	size_t matchLength;
	size_t offset;
} seq_t;

struct seqcount {
	unsigned int sequence;
};

typedef struct seqcount seqcount_t;

typedef struct {
	seqcount_t seqcount;
} seqcount_latch_t;

struct seqcount_spinlock {
	seqcount_t seqcount;
};

typedef struct seqcount_spinlock seqcount_spinlock_t;

struct raw_spinlock {
	arch_spinlock_t raw_lock;
};

struct spinlock {
	union {
		struct raw_spinlock rlock;
	};
};

typedef struct {
	seqcount_spinlock_t seqcount;
	spinlock_t lock;
} seqlock_t;

typedef struct {
	long unsigned int sig[2];
} sigset_t;

typedef struct {
	u64 key[2];
} siphash_key_t;

struct list_head {
	struct list_head *next;
	struct list_head *prev;
};

struct wait_queue_head {
	spinlock_t lock;
	struct list_head head;
};

typedef struct wait_queue_head wait_queue_head_t;

typedef struct {
	spinlock_t slock;
	int owned;
	wait_queue_head_t wq;
} socket_lock_t;

typedef struct {
	char *from;
	char *to;
} substring_t;

typedef struct {
	long unsigned int val;
} swp_entry_t;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
} sync_serial_settings;

typedef struct {
	unsigned int clock_rate;
	unsigned int clock_type;
	short unsigned int loopback;
	unsigned int slot_map;
} te1_settings;

typedef struct {
	__be16 track_information_length;
	__u8 track_lsb;
	__u8 session_lsb;
	__u8 reserved1;
	__u8 track_mode: 4;
	__u8 copy: 1;
	__u8 damage: 1;
	__u8 reserved2: 2;
	__u8 data_mode: 4;
	__u8 fp: 1;
	__u8 packet: 1;
	__u8 blank: 1;
	__u8 rt: 1;
	__u8 nwa_v: 1;
	__u8 lra_v: 1;
	__u8 reserved3: 6;
	__be32 track_start;
	__be32 next_writable;
	__be32 free_blocks;
	__be32 fixed_packet_size;
	__be32 track_size;
	__be32 last_rec_address;
} track_information;

typedef struct {
	int data;
	int audio;
	int cdi;
	int xa;
	long int error;
} tracktype;

typedef struct {
	u64 v;
} u64_stats_t;

typedef struct {
	__u8 b[16];
} uuid_t;

typedef struct {
	gid_t val;
} vfsgid_t;

typedef struct {
	uid_t val;
} vfsuid_t;

typedef struct {
	short unsigned int dce;
	unsigned int modulo;
	unsigned int window;
	unsigned int t1;
	unsigned int t2;
	unsigned int n2;
} x25_hdlc_proto;

struct in6_addr {
	union {
		__u8 u6_addr8[16];
		__be16 u6_addr16[8];
		__be32 u6_addr32[4];
	} in6_u;
};

typedef union {
	__be32 a4;
	__be32 a6[4];
	struct in6_addr in6;
} xfrm_address_t;

typedef ZSTD_compressionParameters zstd_compression_parameters;

typedef ZSTD_customMem zstd_custom_mem;

typedef ZSTD_FrameHeader zstd_frame_header;

typedef ZSTD_parameters zstd_parameters;

typedef ZSTD_Sequence zstd_sequence;

struct refcount_struct {
	atomic_t refs;
};

typedef struct refcount_struct refcount_t;

struct sk_buff;

struct sk_buff_list {
	struct sk_buff *next;
	struct sk_buff *prev;
};

struct sk_buff_head {
	union {
		struct {
			struct sk_buff *next;
			struct sk_buff *prev;
		};
		struct sk_buff_list list;
	};
	__u32 qlen;
	spinlock_t lock;
};

struct qdisc_skb_head {
	struct sk_buff *head;
	struct sk_buff *tail;
	__u32 qlen;
	spinlock_t lock;
};

struct u64_stats_sync {
	seqcount_t seq;
};

struct gnet_stats_basic_sync {
	u64_stats_t bytes;
	u64_stats_t packets;
	struct u64_stats_sync syncp;
	long: 32;
	long: 32;
	long: 32;
};

struct gnet_stats_queue {
	__u32 qlen;
	__u32 backlog;
	__u32 drops;
	__u32 requeues;
	__u32 overlimits;
};

struct callback_head {
	struct callback_head *next;
	void (*func)(struct callback_head *);
};

struct lock_class_key {};

struct Qdisc_ops;

struct qdisc_size_table;

struct netdev_queue;

struct net_rate_estimator;

struct Qdisc {
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	unsigned int flags;
	u32 limit;
	const struct Qdisc_ops *ops;
	struct qdisc_size_table *stab;
	struct hlist_node hash;
	u32 handle;
	u32 parent;
	struct netdev_queue *dev_queue;
	struct net_rate_estimator *rate_est;
	struct gnet_stats_basic_sync *cpu_bstats;
	struct gnet_stats_queue *cpu_qstats;
	int pad;
	refcount_t refcnt;
	struct sk_buff_head gso_skb;
	struct qdisc_skb_head q;
	struct gnet_stats_basic_sync bstats;
	struct gnet_stats_queue qstats;
	int owner;
	long unsigned int state;
	long unsigned int state2;
	struct Qdisc *next_sched;
	struct sk_buff_head skb_bad_txq;
	long: 32;
	long: 32;
	long: 32;
	spinlock_t busylock;
	spinlock_t seqlock;
	struct callback_head rcu;
	netdevice_tracker dev_tracker;
	struct lock_class_key root_lock_key;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long: 32;
	long int privdata[0];
};

struct Qdisc_class_common {
	u32 classid;
	unsigned int filter_cnt;
	struct hlist_node hnode;
};

struct hlist_head;

struct Qdisc_class_hash {
	struct hlist_head *hash;
	unsigned int hashsize;
	unsigned int hashmask;
	unsigned int hashelems;
};

struct tcmsg;

struct netlink_ext_ack;

struct nlattr;

struct qdisc_walker;

struct tcf_block;

struct gnet_dump;

struct Qdisc_class_ops {
	unsigned int flags;
	struct netdev_queue * (*select_queue)(struct Qdisc *, struct tcmsg *);
	int (*graft)(struct Qdisc *, long unsigned int, struct Qdisc *, struct Qdisc **, struct netlink_ext_ack *);
	struct Qdisc * (*leaf)(struct Qdisc *, long unsigned int);
	void (*qlen_notify)(struct Qdisc *, long unsigned int);
	long unsigned int (*find)(struct Qdisc *, u32);
	int (*change)(struct Qdisc *, u32, u32, struct nlattr **, long unsigned int *, struct netlink_ext_ack *);
	int (*delete)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	void (*walk)(struct Qdisc *, struct qdisc_walker *);
	struct tcf_block * (*tcf_block)(struct Qdisc *, long unsigned int, struct netlink_ext_ack *);
	long unsigned int (*bind_tcf)(struct Qdisc *, long unsigned int, u32);
	void (*unbind_tcf)(struct Qdisc *, long unsigned int);
	int (*dump)(struct Qdisc *, long unsigned int, struct sk_buff *, struct tcmsg *);
	int (*dump_stats)(struct Qdisc *, long unsigned int, struct gnet_dump *);
};

struct module;

struct Qdisc_ops {
	struct Qdisc_ops *next;
	const struct Qdisc_class_ops *cl_ops;
	char id[16];
	int priv_size;
	unsigned int static_flags;
	int (*enqueue)(struct sk_buff *, struct Qdisc *, struct sk_buff **);
	struct sk_buff * (*dequeue)(struct Qdisc *);
	struct sk_buff * (*peek)(struct Qdisc *);
	int (*init)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*reset)(struct Qdisc *);
	void (*destroy)(struct Qdisc *);
	int (*change)(struct Qdisc *, struct nlattr *, struct netlink_ext_ack *);
	void (*attach)(struct Qdisc *);
	int (*change_tx_queue_len)(struct Qdisc *, unsigned int);
	void (*change_real_num_tx)(struct Qdisc *, unsigned int);
	int (*dump)(struct Qdisc *, struct sk_buff *);
	int (*dump_stats)(struct Qdisc *, struct gnet_dump *);
	void (*ingress_block_set)(struct Qdisc *, u32);
	void (*egress_block_set)(struct Qdisc *, u32);
	u32 (*ingress_block_get)(struct Qdisc *);
	u32 (*egress_block_get)(struct Qdisc *);
	struct module *owner;
};

struct optimistic_spin_queue {
	atomic_t tail;
};

struct mutex {
	atomic_long_t owner;
	raw_spinlock_t wait_lock;
	struct optimistic_spin_queue osq;
	struct list_head wait_list;
};

struct kref {
	refcount_t refcount;
};

struct swait_queue_head {
	raw_spinlock_t lock;
	struct list_head task_list;
};

struct completion {
	unsigned int done;
	struct swait_queue_head wait;
};

struct blk_mq_queue_map {
	unsigned int *mq_map;
	unsigned int nr_queues;
	unsigned int queue_offset;
};

struct rw_semaphore {
	atomic_long_t count;
	atomic_long_t owner;
	struct optimistic_spin_queue osq;
	raw_spinlock_t wait_lock;
	struct list_head wait_list;
};

struct blk_mq_ops;

struct blk_mq_tags;

struct blk_mq_tag_set {
	const struct blk_mq_ops *ops;
	struct blk_mq_queue_map map[3];
	unsigned int nr_maps;
	unsigned int nr_hw_queues;
	unsigned int queue_depth;
	unsigned int reserved_tags;
	unsigned int cmd_size;
	int numa_node;
	unsigned int timeout;
	unsigned int flags;
	void *driver_data;
	struct blk_mq_tags **tags;
	struct blk_mq_tags *shared_tags;
	struct mutex tag_list_lock;
	struct list_head tag_list;
	struct srcu_struct *srcu;
	struct rw_semaphore update_nr_hwq_lock;
};

struct kset;

struct kobj_type;

struct kernfs_node;

struct kobject {
	const char *name;
	struct list_head entry;
	struct kobject *parent;
	struct kset *kset;
	const struct kobj_type *ktype;
	struct kernfs_node *sd;
	struct kref kref;
	unsigned int state_initialized: 1;
	unsigned int state_in_sysfs: 1;
	unsigned int state_add_uevent_sent: 1;
	unsigned int state_remove_uevent_sent: 1;
	unsigned int uevent_suppress: 1;
};

struct dev_links_info {
	struct list_head suppliers;
	struct list_head consumers;
	struct list_head defer_sync;
	enum dl_dev_state status;
};

struct pm_message {
	int event;
};

typedef struct pm_message pm_message_t;

struct rb_node {
	long unsigned int __rb_parent_color;
	struct rb_node *rb_right;
	struct rb_node *rb_left;
};

struct timerqueue_node {
	struct rb_node node;
	long: 32;
	ktime_t expires;
};

struct hrtimer_clock_base;

struct hrtimer {
	struct timerqueue_node node;
	ktime_t _softexpires;
	enum hrtimer_restart (*function)(struct hrtimer *);
	struct hrtimer_clock_base *base;
	u8 state;
	u8 is_rel;
	u8 is_soft;
	u8 is_hard;
	long: 32;
};

struct work_struct;

typedef void (*work_func_t)(struct work_struct *);

struct work_struct {
	atomic_long_t data;
	struct list_head entry;
	work_func_t func;
};

struct wakeup_source;

struct wake_irq;

struct pm_subsys_data;

struct dev_pm_qos;

struct dev_pm_info {
	pm_message_t power_state;
	bool can_wakeup: 1;
	bool async_suspend: 1;
	bool in_dpm_list: 1;
	bool is_prepared: 1;
	bool is_suspended: 1;
	bool is_noirq_suspended: 1;
	bool is_late_suspended: 1;
	bool no_pm: 1;
	bool early_init: 1;
	bool direct_complete: 1;
	u32 driver_flags;
	spinlock_t lock;
	struct list_head entry;
	struct completion completion;
	struct wakeup_source *wakeup;
	bool wakeup_path: 1;
	bool syscore: 1;
	bool no_pm_callbacks: 1;
	bool work_in_progress: 1;
	bool smart_suspend: 1;
	bool must_resume: 1;
	bool may_skip_resume: 1;
	struct hrtimer suspend_timer;
	u64 timer_expires;
	struct work_struct work;
	wait_queue_head_t wait_queue;
	struct wake_irq *wakeirq;
	atomic_t usage_count;
	atomic_t child_count;
	unsigned int disable_depth: 3;
	bool idle_notification: 1;
	bool request_pending: 1;
	bool deferred_resume: 1;
	bool needs_force_resume: 1;
	bool runtime_auto: 1;
	bool ignore_children: 1;
	bool no_callbacks: 1;
	bool irq_safe: 1;
	bool use_autosuspend: 1;
	bool timer_autosuspends: 1;
	bool memalloc_noio: 1;
	unsigned int links_count;
	enum rpm_request request;
	enum rpm_status runtime_status;
	enum rpm_status last_status;
	int runtime_error;
	int autosuspend_delay;
	long: 32;
	u64 last_busy;
	u64 active_time;
	u64 suspended_time;
	u64 accounting_timestamp;
	struct pm_subsys_data *subsys_data;
	void (*set_latency_tolerance)(struct device *, s32);
	struct dev_pm_qos *qos;
	long: 32;
};

struct irq_domain;

struct msi_device_data;

struct dev_msi_info {
	struct irq_domain *domain;
	struct msi_device_data *data;
};

struct dma_iommu_mapping;

struct dev_archdata {
	struct dma_iommu_mapping *mapping;
	unsigned int dma_ops_setup: 1;
};

struct device_private;

struct device_type;

struct bus_type;

struct device_driver;

struct dev_pm_domain;

struct em_perf_domain;

struct dev_pin_info;

struct dma_map_ops;

struct bus_dma_region;

struct device_dma_parameters;

struct dma_coherent_mem;

struct cma;

struct device_node;

struct fwnode_handle;

struct class;

struct attribute_group;

struct iommu_group;

struct dev_iommu;

struct device_physical_location;

struct device {
	struct kobject kobj;
	struct device *parent;
	struct device_private *p;
	const char *init_name;
	const struct device_type *type;
	const struct bus_type *bus;
	struct device_driver *driver;
	void *platform_data;
	void *driver_data;
	struct mutex mutex;
	struct dev_links_info links;
	long: 32;
	struct dev_pm_info power;
	struct dev_pm_domain *pm_domain;
	struct em_perf_domain *em_pd;
	struct dev_pin_info *pins;
	struct dev_msi_info msi;
	const struct dma_map_ops *dma_ops;
	u64 *dma_mask;
	long: 32;
	u64 coherent_dma_mask;
	u64 bus_dma_limit;
	const struct bus_dma_region *dma_range_map;
	struct device_dma_parameters *dma_parms;
	struct list_head dma_pools;
	struct dma_coherent_mem *dma_mem;
	struct cma *cma_area;
	struct dev_archdata archdata;
	struct device_node *of_node;
	struct fwnode_handle *fwnode;
	dev_t devt;
	u32 id;
	spinlock_t devres_lock;
	struct list_head devres_head;
	const struct class *class;
	const struct attribute_group **groups;
	void (*release)(struct device *);
	struct iommu_group *iommu_group;
	struct dev_iommu *iommu;
	struct device_physical_location *physical_location;
	enum device_removable removable;
	bool offline_disabled: 1;
	bool offline: 1;
	bool of_node_reused: 1;
	bool state_synced: 1;
	bool can_match: 1;
	bool dma_coherent: 1;
	bool dma_skip_sync: 1;
	long: 32;
};

struct scsi_host_template;

struct scsi_transport_template;

struct workqueue_struct;

struct Scsi_Host {
	struct list_head __devices;
	struct list_head __targets;
	struct list_head starved_list;
	spinlock_t default_lock;
	spinlock_t *host_lock;
	struct mutex scan_mutex;
	struct list_head eh_abort_list;
	struct list_head eh_cmd_q;
	struct task_struct *ehandler;
	struct completion *eh_action;
	wait_queue_head_t host_wait;
	const struct scsi_host_template *hostt;
	struct scsi_transport_template *transportt;
	struct kref tagset_refcnt;
	struct completion tagset_freed;
	struct blk_mq_tag_set tag_set;
	atomic_t host_blocked;
	unsigned int host_failed;
	unsigned int host_eh_scheduled;
	unsigned int host_no;
	int eh_deadline;
	long unsigned int last_reset;
	unsigned int max_channel;
	unsigned int max_id;
	u64 max_lun;
	unsigned int unique_id;
	short unsigned int max_cmd_len;
	int this_id;
	int can_queue;
	short int cmd_per_lun;
	short unsigned int sg_tablesize;
	short unsigned int sg_prot_tablesize;
	unsigned int max_sectors;
	unsigned int opt_sectors;
	unsigned int max_segment_size;
	unsigned int dma_alignment;
	long unsigned int dma_boundary;
	long unsigned int virt_boundary_mask;
	unsigned int nr_hw_queues;
	unsigned int nr_maps;
	unsigned int active_mode: 2;
	unsigned int host_self_blocked: 1;
	unsigned int reverse_ordering: 1;
	unsigned int tmf_in_progress: 1;
	unsigned int async_scan: 1;
	unsigned int eh_noresume: 1;
	unsigned int no_write_same: 1;
	unsigned int host_tagset: 1;
	unsigned int queuecommand_may_block: 1;
	unsigned int short_inquiry: 1;
	unsigned int no_scsi2_lun_in_cdb: 1;
	struct workqueue_struct *work_q;
	struct workqueue_struct *tmf_work_q;
	unsigned int max_host_blocked;
	unsigned int prot_capabilities;
	unsigned char prot_guard_type;
	long unsigned int base;
	long unsigned int io_port;
	unsigned char n_io_port;
	unsigned char dma_channel;
	unsigned int irq;
	enum scsi_host_state shost_state;
	long: 32;
	struct device shost_gendev;
	struct device shost_dev;
	void *shost_data;
	struct device *dma_dev;
	int rpm_autosuspend_delay;
	long unsigned int hostdata[0];
	long: 32;
};

struct SeqDef_s {
	U32 offBase;
	U16 litLength;
	U16 mlBase;
};

struct XC_TV_STANDARD {
	char *name;
	u16 audio_mode;
	u16 video_mode;
};

struct XC_TV_STANDARD___2 {
	const char *Name;
	u16 audio_mode;
	u16 video_mode;
	u16 int_freq;
};

typedef size_t (*ZSTD_sequenceProducer_F)(void *, ZSTD_Sequence *, size_t, const void *, size_t, const void *, size_t, int, size_t);

struct ZSTD_CCtx_params_s {
	ZSTD_format_e format;
	ZSTD_compressionParameters cParams;
	ZSTD_frameParameters fParams;
	int compressionLevel;
	int forceWindow;
	size_t targetCBlockSize;
	int srcSizeHint;
	ZSTD_dictAttachPref_e attachDictPref;
	ZSTD_ParamSwitch_e literalCompressionMode;
	int nbWorkers;
	size_t jobSize;
	int overlapLog;
	int rsyncable;
	ldmParams_t ldmParams;
	int enableDedicatedDictSearch;
	ZSTD_bufferMode_e inBufferMode;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_SequenceFormat_e blockDelimiters;
	int validateSequences;
	ZSTD_ParamSwitch_e postBlockSplitter;
	int preBlockSplitter_level;
	size_t maxBlockSize;
	ZSTD_ParamSwitch_e useRowMatchFinder;
	int deterministicRefPrefix;
	ZSTD_customMem customMem;
	ZSTD_ParamSwitch_e prefetchCDictTables;
	int enableMatchFinderFallback;
	void *extSeqProdState;
	ZSTD_sequenceProducer_F extSeqProdFunc;
	ZSTD_ParamSwitch_e searchForExternalRepcodes;
};

typedef struct ZSTD_CCtx_params_s ZSTD_CCtx_params;

struct xxh64_state {
	uint64_t total_len;
	uint64_t v1;
	uint64_t v2;
	uint64_t v3;
	uint64_t v4;
	uint64_t mem64[4];
	uint32_t memsize;
	long: 32;
};

struct POOL_ctx_s;

typedef struct POOL_ctx_s ZSTD_threadPool;

struct ZSTD_inBuffer_s {
	const void *src;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_inBuffer_s ZSTD_inBuffer;

struct ZSTD_prefixDict_s {
	const void *dict;
	size_t dictSize;
	ZSTD_dictContentType_e dictContentType;
};

typedef struct ZSTD_prefixDict_s ZSTD_prefixDict;

struct ZSTD_CCtx_s {
	ZSTD_compressionStage_e stage;
	int cParamsChanged;
	int bmi2;
	ZSTD_CCtx_params requestedParams;
	ZSTD_CCtx_params appliedParams;
	ZSTD_CCtx_params simpleApiParams;
	U32 dictID;
	size_t dictContentSize;
	ZSTD_cwksp workspace;
	size_t blockSizeMax;
	long long unsigned int pledgedSrcSizePlusOne;
	long long unsigned int consumedSrcSize;
	long long unsigned int producedCSize;
	struct xxh64_state xxhState;
	ZSTD_customMem customMem;
	ZSTD_threadPool *pool;
	size_t staticSize;
	SeqCollector seqCollector;
	int isFirstBlock;
	int initialized;
	SeqStore_t seqStore;
	ldmState_t ldmState;
	rawSeq *ldmSequences;
	size_t maxNbLdmSequences;
	RawSeqStore_t externSeqStore;
	ZSTD_blockState_t blockState;
	void *tmpWorkspace;
	size_t tmpWkspSize;
	ZSTD_buffered_policy_e bufferedPolicy;
	char *inBuff;
	size_t inBuffSize;
	size_t inToCompress;
	size_t inBuffPos;
	size_t inBuffTarget;
	char *outBuff;
	size_t outBuffSize;
	size_t outBuffContentSize;
	size_t outBuffFlushedSize;
	ZSTD_cStreamStage streamStage;
	U32 frameEnded;
	ZSTD_inBuffer expectedInBuffer;
	size_t stableIn_notConsumed;
	size_t expectedOutBufferSize;
	ZSTD_localDict localDict;
	const ZSTD_CDict *cdict;
	ZSTD_prefixDict prefixDict;
	ZSTD_blockSplitCtx blockSplitCtx;
	ZSTD_Sequence *extSeqBuf;
	size_t extSeqBufCapacity;
};

typedef struct ZSTD_CCtx_s ZSTD_CCtx;

typedef ZSTD_CCtx ZSTD_CStream;

typedef ZSTD_CCtx zstd_cctx;

typedef ZSTD_CStream zstd_cstream;

struct ZSTD_CDict_s {
	const void *dictContent;
	size_t dictContentSize;
	ZSTD_dictContentType_e dictContentType;
	U32 *entropyWorkspace;
	ZSTD_cwksp workspace;
	long: 32;
	ZSTD_MatchState_t matchState;
	ZSTD_compressedBlockState_t cBlockState;
	ZSTD_customMem customMem;
	U32 dictID;
	int compressionLevel;
	ZSTD_ParamSwitch_e useRowMatchFinder;
	long: 32;
};

typedef ZSTD_CDict zstd_cdict;

struct ZSTD_outBuffer_s {
	void *dst;
	size_t size;
	size_t pos;
};

typedef struct ZSTD_outBuffer_s ZSTD_outBuffer;

struct ZSTD_DCtx_s {
	const ZSTD_seqSymbol *LLTptr;
	const ZSTD_seqSymbol *MLTptr;
	const ZSTD_seqSymbol *OFTptr;
	const HUF_DTable *HUFptr;
	ZSTD_entropyDTables_t entropy;
	U32 workspace[640];
	const void *previousDstEnd;
	const void *prefixStart;
	const void *virtualStart;
	const void *dictEnd;
	size_t expected;
	ZSTD_FrameHeader fParams;
	U64 processedCSize;
	U64 decodedSize;
	blockType_e bType;
	ZSTD_dStage stage;
	U32 litEntropy;
	U32 fseEntropy;
	struct xxh64_state xxhState;
	size_t headerSize;
	ZSTD_format_e format;
	ZSTD_forceIgnoreChecksum_e forceIgnoreChecksum;
	U32 validateChecksum;
	const BYTE *litPtr;
	ZSTD_customMem customMem;
	size_t litSize;
	size_t rleSize;
	size_t staticSize;
	int isFrameDecompression;
	ZSTD_DDict *ddictLocal;
	const ZSTD_DDict *ddict;
	U32 dictID;
	int ddictIsCold;
	ZSTD_dictUses_e dictUses;
	ZSTD_DDictHashSet *ddictSet;
	ZSTD_refMultipleDDicts_e refMultipleDDicts;
	int disableHufAsm;
	int maxBlockSizeParam;
	ZSTD_dStreamStage streamStage;
	char *inBuff;
	size_t inBuffSize;
	size_t inPos;
	size_t maxWindowSize;
	char *outBuff;
	size_t outBuffSize;
	size_t outStart;
	size_t outEnd;
	size_t lhSize;
	U32 hostageByte;
	int noForwardProgress;
	ZSTD_bufferMode_e outBufferMode;
	ZSTD_outBuffer expectedOutBuffer;
	BYTE *litBuffer;
	const BYTE *litBufferEnd;
	ZSTD_litLocation_e litBufferLocation;
	BYTE litExtraBuffer[65568];
	BYTE headerBuffer[18];
	size_t oversizedDuration;
};

typedef struct ZSTD_DCtx_s ZSTD_DCtx;

typedef ZSTD_DCtx ZSTD_DStream;

typedef ZSTD_DCtx zstd_dctx;

typedef ZSTD_DStream zstd_dstream;

struct ZSTD_DDict_s {
	void *dictBuffer;
	const void *dictContent;
	size_t dictSize;
	ZSTD_entropyDTables_t entropy;
	U32 dictID;
	U32 entropyPresent;
	ZSTD_customMem cMem;
};

typedef ZSTD_DDict zstd_ddict;

typedef ZSTD_inBuffer zstd_in_buffer;

typedef ZSTD_outBuffer zstd_out_buffer;

struct __aio_sigset {
	const sigset_t *sigmask;
	size_t sigsetsize;
};

struct llist_node {
	struct llist_node *next;
};

struct __call_single_node {
	struct llist_node lli