# ----------------------------------------------------------------------------
#
#  Copyright (C) 2018-2024 Fons Adriaensen <fons@linuxaudio.org>
#    
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http:#www.gnu.org/licenses/>.
#
# ----------------------------------------------------------------------------


from zita_jacktools.jackclient import JackClient
from zita_jacktools import jackbw8filt_ext


class JackBW8filt(JackClient):

    """
    Eight order Butterworth filters. Each output can be lowpass or highpass,
    or both in series.
    """

    def __init__(self, ninp, nout, client_name, server_name = None):
        """
        Create a new JackBW8 instance with given number of inputs
        and outputs. 

        The result should be checked using get_state().
        The maximum number of inputs and outputs is 100.

        The optional 'server_name' allows to select between running
        Jack servers.
        """
        self._jbw8filt, base = jackbw8filt_ext.makecaps (self, client_name, server_name, ninp, nout)
        super().__init__(base)


    def set_filter (self, inp, out, hpf, lpf) :
        """
        Set input, HP and/or LP filter parameters for given output.

        'hpf', 'lpf' : HP and LP cutoff frequency, or 0 to disable a filter.
         """
        return jackbw8filt_ext.set_filter (self._jbw8filt, inp, out, hpf, lpf)


