/*
 * Decompiled with CFR 0.152.
 */
package ext.plantuml.com.ctreber.acearth.scanbit;

import ext.plantuml.com.ctreber.acearth.scanbit.ScanBit;
import ext.plantuml.com.ctreber.aclib.sort.QuickSort;
import java.util.ArrayList;
import java.util.List;

class ScanBuf {
    private List[] fScanbuf;
    private int fLineMin;
    private int fLineMax;
    private final int fLines;
    private final int fPoints;
    private boolean fScanBufsAdded;

    public ScanBuf(int pLines, int pPoints) {
        this.fLines = pLines;
        this.fPoints = pPoints;
        this.fLineMin = Integer.MAX_VALUE;
        this.fLineMax = Integer.MIN_VALUE;
        this.fScanBufsAdded = false;
        this.fScanbuf = new ArrayList[this.fLines];
        for (int i = 0; i < this.fScanbuf.length; ++i) {
            this.fScanbuf[i] = new ArrayList();
        }
    }

    public void addLine(double pXFrom, double pYFrom, double pXTo, double pYTo) {
        int lYTo;
        int lYFrom;
        if (pYFrom < pYTo) {
            lYFrom = (int)Math.ceil(pYFrom - 0.5);
            lYTo = (int)Math.floor(pYTo - 0.5);
            if ((double)lYTo == pYTo - 0.5) {
                --lYTo;
            }
        } else {
            lYFrom = (int)Math.ceil(pYTo - 0.5);
            lYTo = (int)Math.floor(pYFrom - 0.5);
            if ((double)lYTo == pYFrom - 0.5) {
                --lYTo;
            }
        }
        if (lYFrom < 0) {
            lYFrom = 0;
        }
        if (lYTo >= this.fLines) {
            lYTo = this.fLines - 1;
        }
        if (lYFrom > lYTo) {
            return;
        }
        if (lYFrom < this.fLineMin) {
            this.fLineMin = lYFrom;
        }
        if (lYTo > this.fLineMax) {
            this.fLineMax = lYTo;
        }
        double lDx = (pXTo - pXFrom) / (pYTo - pYFrom);
        double lX = pXFrom + lDx * ((double)lYFrom + 0.5 - pYFrom);
        for (int lLineNo = lYFrom; lLineNo <= lYTo; ++lLineNo) {
            this.fScanbuf[lLineNo].add(lX);
            lX += lDx;
        }
        this.fScanBufsAdded = true;
    }

    public boolean containsPoints() {
        return this.fScanBufsAdded;
    }

    public List getScanbits(int pCurveType) {
        ArrayList<ScanBit> fScanBits = new ArrayList<ScanBit>();
        for (int lLineNo = this.fLineMin; lLineNo <= this.fLineMax; ++lLineNo) {
            Object[] lScanLine = this.fScanbuf[lLineNo].toArray(new Double[0]);
            QuickSort lSort = new QuickSort();
            lSort.sort(lScanLine);
            for (int n = 0; n < lScanLine.length; n += 2) {
                int lXLo = (int)Math.ceil((Double)lScanLine[n] - 0.5);
                int lXHi = (int)Math.floor((Double)lScanLine[n + 1] - 0.5);
                if (lXLo < 0) {
                    lXLo = 0;
                }
                if (lXHi >= this.fPoints) {
                    lXHi = this.fPoints - 1;
                }
                if (lXLo > lXHi) continue;
                fScanBits.add(new ScanBit(lLineNo, lXLo, lXHi, pCurveType));
            }
        }
        return fScanBits;
    }

    public int getYMax() {
        return this.fLineMax;
    }

    public int getYMin() {
        return this.fLineMin;
    }
}

