/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.jdepend;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import jdepend.xmlui.JDepend;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.ExecuteWatchdog;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.LoaderUtils;

public class JDependTask
extends Task {
    private Path sourcesPath;
    private Path classesPath;
    private File outputFile;
    private File dir;
    private Path compileClasspath;
    private boolean haltonerror = false;
    private boolean fork = false;
    private Long timeout = null;
    private String jvm = null;
    private String format = "text";
    private PatternSet defaultPatterns = new PatternSet();
    private static Constructor<?> packageFilterC;
    private static Method setFilter;
    private boolean includeRuntime = false;
    private Path runtimeClasses = null;
    private static final int SUCCESS = 0;
    private static final int ERRORS = 1;

    public void setIncluderuntime(boolean b) {
        this.includeRuntime = b;
    }

    public void setTimeout(Long value) {
        this.timeout = value;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setHaltonerror(boolean haltonerror) {
        this.haltonerror = haltonerror;
    }

    public boolean getHaltonerror() {
        return this.haltonerror;
    }

    public void setFork(boolean value) {
        this.fork = value;
    }

    public boolean getFork() {
        return this.fork;
    }

    public void setJvm(String value) {
        this.jvm = value;
    }

    @Deprecated
    public Path createSourcespath() {
        if (this.sourcesPath == null) {
            this.sourcesPath = new Path(this.getProject());
        }
        return this.sourcesPath.createPath();
    }

    @Deprecated
    public Path getSourcespath() {
        return this.sourcesPath;
    }

    public Path createClassespath() {
        if (this.classesPath == null) {
            this.classesPath = new Path(this.getProject());
        }
        return this.classesPath.createPath();
    }

    public Path getClassespath() {
        return this.classesPath;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public File getDir() {
        return this.dir;
    }

    public void setClasspath(Path classpath) {
        if (this.compileClasspath == null) {
            this.compileClasspath = classpath;
        } else {
            this.compileClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.compileClasspath;
    }

    public Path createClasspath() {
        if (this.compileClasspath == null) {
            this.compileClasspath = new Path(this.getProject());
        }
        return this.compileClasspath.createPath();
    }

    public Commandline.Argument createJvmarg(CommandlineJava commandline) {
        return commandline.createVmArgument();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public PatternSet.NameEntry createExclude() {
        return this.defaultPatterns.createExclude();
    }

    public PatternSet getExcludes() {
        return this.defaultPatterns;
    }

    public void setFormat(FormatAttribute ea) {
        this.format = ea.getValue();
    }

    private void addClasspathEntry(String resource) {
        resource = resource.startsWith("/") ? resource.substring(1) : "org/apache/tools/ant/taskdefs/optional/jdepend/" + resource;
        File f = LoaderUtils.getResourceSource((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)resource);
        if (f == null) {
            this.log("Couldn't find " + resource, 4);
        } else {
            this.log("Found " + f.getAbsolutePath(), 4);
            this.runtimeClasses.createPath().setLocation(f);
        }
    }

    public void execute() throws BuildException {
        boolean errorOccurred;
        int exitValue;
        CommandlineJava commandline = new CommandlineJava();
        if ("text".equals(this.format)) {
            commandline.setClassname("jdepend.textui.JDepend");
        } else if ("xml".equals(this.format)) {
            commandline.setClassname("jdepend.xmlui.JDepend");
        }
        if (this.jvm != null) {
            commandline.setVm(this.jvm);
        }
        if (this.getSourcespath() == null && this.getClassespath() == null) {
            throw new BuildException("Missing classespath required argument");
        }
        if (this.getClassespath() == null) {
            this.log("sourcespath is deprecated in JDepend >= 2.5 - please convert to classespath");
        }
        boolean wasKilled = false;
        if (!this.getFork()) {
            exitValue = this.executeInVM(commandline);
        } else {
            ExecuteWatchdog watchdog = this.createWatchdog();
            exitValue = this.executeAsForked(commandline, watchdog);
            if (watchdog != null) {
                wasKilled = watchdog.killedProcess();
            }
        }
        boolean bl = errorOccurred = exitValue == 1 || wasKilled;
        if (errorOccurred) {
            String errorMessage = "JDepend FAILED" + (wasKilled ? " - Timed out" : "");
            if (this.getHaltonerror()) {
                throw new BuildException(errorMessage, this.getLocation());
            }
            this.log(errorMessage, 0);
        }
    }

    public int executeInVM(CommandlineJava commandline) throws BuildException {
        Object jdepend = "xml".equals(this.format) ? new JDepend() : new jdepend.textui.JDepend();
        FileWriter fw = null;
        PrintWriter pw = null;
        if (this.getOutputFile() != null) {
            try {
                fw = new FileWriter(this.getOutputFile().getPath());
            }
            catch (IOException e) {
                String msg = "JDepend Failed when creating the output file: " + e.getMessage();
                this.log(msg);
                throw new BuildException(msg);
            }
            pw = new PrintWriter(fw);
            jdepend.setWriter(pw);
            this.log("Output to be stored in " + this.getOutputFile().getPath());
        }
        try {
            this.getWorkingPath().ifPresent(arg_0 -> this.lambda$executeInVM$0((jdepend.textui.JDepend)jdepend, arg_0));
            String[] patterns = this.defaultPatterns.getExcludePatterns(this.getProject());
            if (patterns != null && patterns.length > 0) {
                if (setFilter != null) {
                    ArrayList v = new ArrayList();
                    Collections.addAll(v, patterns);
                    try {
                        Object o = packageFilterC.newInstance(v);
                        setFilter.invoke(jdepend, o);
                    }
                    catch (Throwable e) {
                        this.log("excludes will be ignored as JDepend doesn't like me: " + e.getMessage(), 1);
                    }
                } else {
                    this.log("Sorry, your version of JDepend doesn't support excludes", 1);
                }
            }
            jdepend.analyze();
            if (pw != null && pw.checkError()) {
                throw new IOException("Encountered an error writing JDepend output");
            }
        }
        catch (IOException ex) {
            try {
                throw new BuildException((Throwable)ex);
            }
            catch (Throwable throwable) {
                FileUtils.close(pw);
                FileUtils.close(fw);
                throw throwable;
            }
        }
        FileUtils.close((Writer)pw);
        FileUtils.close((Writer)fw);
        return 0;
    }

    public int executeAsForked(CommandlineJava commandline, ExecuteWatchdog watchdog) throws BuildException {
        this.runtimeClasses = new Path(this.getProject());
        this.addClasspathEntry("/jdepend/textui/JDepend.class");
        this.createClasspath();
        if (!this.getClasspath().toString().isEmpty()) {
            this.createJvmarg(commandline).setValue("-classpath");
            this.createJvmarg(commandline).setValue(this.getClasspath().toString());
        }
        if (this.includeRuntime) {
            Map env = Execute.getEnvironmentVariables();
            String cp = (String)env.get("CLASSPATH");
            if (cp != null) {
                commandline.createClasspath(this.getProject()).createPath().append(new Path(this.getProject(), cp));
            }
            this.log("Implicitly adding " + this.runtimeClasses + " to CLASSPATH", 3);
            commandline.createClasspath(this.getProject()).createPath().append(this.runtimeClasses);
        }
        if (this.getOutputFile() != null) {
            commandline.createArgument().setValue("-file");
            commandline.createArgument().setValue(this.outputFile.getPath());
        }
        this.getWorkingPath().ifPresent(path -> {
            for (String filepath : path.list()) {
                File f = new File(filepath);
                if (!f.exists() || !f.isDirectory()) {
                    throw new BuildException("\"%s\" does not represent a valid directory. JDepend would fail.", new Object[]{f.getPath()});
                }
                commandline.createArgument().setValue(f.getPath());
            }
        });
        Execute execute = new Execute((ExecuteStreamHandler)new LogStreamHandler((Task)this, 2, 1), watchdog);
        execute.setCommandline(commandline.getCommandline());
        if (this.getDir() != null) {
            execute.setWorkingDirectory(this.getDir());
            execute.setAntRun(this.getProject());
        }
        if (this.getOutputFile() != null) {
            this.log("Output to be stored in " + this.getOutputFile().getPath());
        }
        this.log(commandline.describeCommand(), 3);
        try {
            return execute.execute();
        }
        catch (IOException e) {
            throw new BuildException("Process fork failed.", (Throwable)e, this.getLocation());
        }
    }

    protected ExecuteWatchdog createWatchdog() throws BuildException {
        if (this.getTimeout() == null) {
            return null;
        }
        return new ExecuteWatchdog(this.getTimeout().longValue());
    }

    private Optional<Path> getWorkingPath() {
        Optional<Path> result = Optional.ofNullable(this.getClassespath());
        if (result.isPresent()) {
            return result;
        }
        result = Optional.ofNullable(this.getSourcespath());
        result.ifPresent(resources -> this.log("nested sourcespath is deprecated; please use classespath"));
        return result;
    }

    private /* synthetic */ void lambda$executeInVM$0(jdepend.textui.JDepend jdepend, Path path) {
        for (String filepath : path.list()) {
            File f = new File(filepath);
            if (!f.exists()) {
                String msg = "\"" + f.getPath() + "\" does not represent a valid file or directory. JDepend would fail.";
                this.log(msg);
                throw new BuildException(msg);
            }
            try {
                jdepend.addDirectory(f.getPath());
            }
            catch (IOException e) {
                String msg = "JDepend Failed when adding a class directory: " + e.getMessage();
                this.log(msg);
                throw new BuildException(msg);
            }
        }
    }

    static {
        block2: {
            try {
                Class<?> packageFilter = Class.forName("jdepend.framework.PackageFilter");
                packageFilterC = packageFilter.getConstructor(Collection.class);
                setFilter = jdepend.textui.JDepend.class.getDeclaredMethod("setFilter", packageFilter);
            }
            catch (Throwable t) {
                if (setFilter != null) break block2;
                packageFilterC = null;
            }
        }
    }

    public static class FormatAttribute
    extends EnumeratedAttribute {
        private String[] formats = new String[]{"xml", "text"};

        public String[] getValues() {
            return this.formats;
        }
    }
}

