/*
 * Copyright (c) 2018-2020, Andreas Kling <kling@serenityos.org>
 *
 * SPDX-License-Identifier: BSD-2-Clause
 */

#pragma once

#include <LibWeb/HTML/HTMLElement.h>

namespace Web::HTML {

class HTMLBRElement final : public HTMLElement {
    WEB_PLATFORM_OBJECT(HTMLBRElement, HTMLElement);

public:
    virtual ~HTMLBRElement() override;

    virtual JS::GCPtr<Layout::Node> create_layout_node(NonnullRefPtr<CSS::StyleProperties>) override;

private:
    HTMLBRElement(DOM::Document&, DOM::QualifiedName);
};

}
