/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;
import org.zaproxy.zap.extension.custompages.CustomPage;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.TechSet;
import org.zaproxy.zap.users.User;

public final class PassiveScanData {
    private static final Logger LOGGER = LogManager.getLogger(PassiveScanData.class);
    private static ExtensionUserManagement extUserMgmt = null;
    private final HttpMessage message;
    private final Context context;
    private final TechSet techSet;
    private List<User> userList = null;
    private Map<CustomPage.Type, Boolean> customPageMap;

    PassiveScanData(HttpMessage msg) {
        this.message = msg;
        this.context = PassiveScanData.getContext(this.message);
        if (this.getContext() == null) {
            this.userList = Collections.emptyList();
            this.techSet = TechSet.getAllTech();
        } else {
            this.techSet = this.getContext().getTechSet();
        }
    }

    private static Context getContext(HttpMessage message) {
        List<Context> contextList = Model.getSingleton().getSession().getContextsForUrl(message.getRequestHeader().getURI().toString());
        if (contextList.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No Context found for: " + message.getRequestHeader().getURI().toString());
            }
            return null;
        }
        return contextList.get(0);
    }

    public List<User> getUsers() {
        if (this.userList != null) {
            return this.userList;
        }
        if (PassiveScanData.getExtensionUserManagement() == null) {
            this.userList = Collections.emptyList();
            return this.userList;
        }
        this.userList = Collections.unmodifiableList(new ArrayList<User>(PassiveScanData.getExtensionUserManagement().getContextUserAuthManager(this.getContext().getId()).getUsers()));
        return this.userList;
    }

    private static ExtensionUserManagement getExtensionUserManagement() {
        return extUserMgmt != null ? extUserMgmt : Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class);
    }

    static void setExtUserMgmt(ExtensionUserManagement extUserMgmt) {
        PassiveScanData.extUserMgmt = extUserMgmt;
    }

    public boolean hasContext() {
        return this.context != null;
    }

    public Context getContext() {
        return this.context;
    }

    public TechSet getTechSet() {
        return this.techSet;
    }

    private boolean isCustomPage(HttpMessage msg, CustomPage.Type cpType) {
        if (this.context == null) {
            return false;
        }
        if (this.customPageMap == null) {
            this.customPageMap = new HashMap<CustomPage.Type, Boolean>();
        }
        return this.customPageMap.computeIfAbsent(cpType, type -> this.context.isCustomPageWithFallback(msg, (CustomPage.Type)((Object)type)));
    }

    public boolean isPage200(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404) || this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.OK_200)) {
            return true;
        }
        return msg.getResponseHeader().getStatusCode() == 200;
    }

    public boolean isPage500(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.OK_200) || this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return true;
        }
        return msg.getResponseHeader().getStatusCode() == 500;
    }

    public boolean isPage404(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.OK_200) || this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404)) {
            return true;
        }
        return msg.getResponseHeader().getStatusCode() == 404;
    }

    public boolean isPageOther(HttpMessage msg) {
        return this.isCustomPage(msg, CustomPage.Type.OTHER);
    }

    public boolean isSuccess(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404) || this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.OK_200)) {
            return true;
        }
        return HttpStatusCode.isSuccess(msg.getResponseHeader().getStatusCode());
    }

    public boolean isClientError(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.OK_200) || this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404)) {
            return true;
        }
        return HttpStatusCode.isClientError(msg.getResponseHeader().getStatusCode());
    }

    public boolean isServerError(HttpMessage msg) {
        if (this.isCustomPage(msg, CustomPage.Type.OK_200) || this.isCustomPage(msg, CustomPage.Type.NOTFOUND_404)) {
            return false;
        }
        if (this.isCustomPage(msg, CustomPage.Type.ERROR_500)) {
            return true;
        }
        return HttpStatusCode.isServerError(msg.getResponseHeader().getStatusCode());
    }
}

