/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.control;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnClassLoader;
import org.zaproxy.zap.control.AddOnLoaderUtils;
import org.zaproxy.zap.control.AddOnUninstallationProgressCallback;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.pscan.ExtensionPassiveScan;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.utils.ZapResourceBundleControl;

public final class AddOnInstaller {
    private static final Logger logger = LogManager.getLogger(AddOnInstaller.class);
    private static final String ADD_ON_DATA_DIR = "addOnData";
    private static final String ADD_ON_DATA_LIBS_DIR = "libs";

    private AddOnInstaller() {
    }

    public static void install(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOnInstaller.installResourceBundle(addOnClassLoader, addOn);
        AddOnInstaller.installAddOnFiles(addOnClassLoader, addOn, true);
        List<Extension> listExts = AddOnInstaller.installAddOnExtensions(addOn);
        AddOnInstaller.installAddOnActiveScanRules(addOn, addOnClassLoader);
        AddOnInstaller.installAddOnPassiveScanRules(addOn, addOnClassLoader);
        for (Extension ext : listExts) {
            if (!ext.isEnabled()) continue;
            try {
                ext.postInstall();
            }
            catch (Exception e) {
                logger.error("Post install method failed for add-on " + addOn.getId() + " extension " + ext.getName());
            }
        }
    }

    @Deprecated
    public static boolean uninstall(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        return AddOnInstaller.uninstall(addOn, callback, null);
    }

    public static boolean uninstall(AddOn addOn, AddOnUninstallationProgressCallback callback, Set<AddOn> installedAddOns) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.");
        AddOnInstaller.validateCallbackNotNull(callback);
        try {
            boolean uninstalledWithoutErrors = true;
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnPassiveScanRules(addOn, callback);
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnActiveScanRules(addOn, callback);
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnExtensions(addOn, callback);
            AddOnInstaller.uninstallResourceBundle(addOn);
            return uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnFiles(addOn, callback, installedAddOns);
        }
        catch (Throwable e) {
            logger.error("An error occurred while uninstalling the add-on: " + addOn.getId(), e);
            return false;
        }
    }

    public static boolean softUninstall(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.");
        AddOnInstaller.validateCallbackNotNull(callback);
        try {
            boolean uninstalledWithoutErrors = true;
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnPassiveScanRules(addOn, callback);
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnActiveScanRules(addOn, callback);
            return uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnExtensions(addOn, callback);
        }
        catch (Throwable e) {
            logger.error("An error occurred while uninstalling the add-on: " + addOn.getId(), e);
            return false;
        }
    }

    static void installResourceBundle(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOn.BundleData bundleData = addOn.getBundleData();
        if (bundleData.isEmpty()) {
            return;
        }
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(bundleData.getBaseName(), Constant.getLocale(), addOnClassLoader, new ZapResourceBundleControl());
            addOn.setResourceBundle(resourceBundle);
            String bundlePrefix = bundleData.getPrefix();
            if (!bundlePrefix.isEmpty()) {
                Constant.messages.addMessageBundle(bundlePrefix, resourceBundle);
            }
        }
        catch (MissingResourceException e) {
            logger.error("Declared bundle not found in " + addOn.getId() + " add-on:", (Throwable)e);
        }
    }

    private static void uninstallResourceBundle(AddOn addOn) {
        String bundlePrefix = addOn.getBundleData().getPrefix();
        if (!bundlePrefix.isEmpty()) {
            Constant.messages.removeMessageBundle(bundlePrefix);
        }
    }

    private static List<Extension> installAddOnExtensions(AddOn addOn) {
        ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
        List<Extension> listExts = ExtensionFactory.loadAddOnExtensions(extensionLoader, (Configuration)Model.getSingleton().getOptionsParam().getConfig(), addOn);
        for (Extension ext : listExts) {
            AddOnInstaller.installAddOnExtensionImpl(addOn, ext, extensionLoader);
        }
        return listExts;
    }

    public static void installAddOnExtension(AddOn addOn, Extension ext) {
        ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
        ExtensionFactory.addAddOnExtension(extensionLoader, (Configuration)Model.getSingleton().getOptionsParam().getConfig(), ext);
        AddOnInstaller.installAddOnExtensionImpl(addOn, ext, extensionLoader);
    }

    private static void installAddOnExtensionImpl(AddOn addOn, Extension ext, ExtensionLoader extensionLoader) {
        if (ext.isEnabled()) {
            logger.debug("Starting extension " + ext.getName());
            try {
                extensionLoader.startLifeCycle(ext);
            }
            catch (Throwable e) {
                logger.error("An error occurred while installing the add-on: " + addOn.getId(), e);
            }
        }
    }

    private static boolean uninstallAddOnExtensions(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        boolean uninstalledWithoutErrors = true;
        callback.extensionsWillBeRemoved(addOn.getLoadedExtensions().size());
        ArrayList<Extension> extensions = new ArrayList<Extension>(addOn.getLoadedExtensions());
        Collections.reverse(extensions);
        for (Extension ext : extensions) {
            uninstalledWithoutErrors &= AddOnInstaller.uninstallAddOnExtension(addOn, ext, callback);
        }
        return uninstalledWithoutErrors;
    }

    protected static boolean uninstallAddOnExtension(AddOn addOn, Extension extension, AddOnUninstallationProgressCallback callback) {
        boolean uninstalledWithoutErrors = true;
        if (extension.isEnabled()) {
            String extUiName = extension.getUIName();
            if (extension.canUnload()) {
                logger.debug("Unloading ext: " + extension.getName());
                try {
                    extension.unload();
                    Control.getSingleton().getExtensionLoader().removeExtension(extension);
                    ExtensionFactory.unloadAddOnExtension(extension);
                }
                catch (Exception e) {
                    logger.error("An error occurred while uninstalling the extension \"" + extension.getName() + "\" bundled in the add-on \"" + addOn.getId() + "\":", (Throwable)e);
                    uninstalledWithoutErrors = false;
                }
            } else {
                logger.debug("Cant dynamically unload ext: " + extension.getName());
                uninstalledWithoutErrors = false;
            }
            callback.extensionRemoved(extUiName);
        } else {
            ExtensionFactory.unloadAddOnExtension(extension);
        }
        addOn.removeLoadedExtension(extension);
        return uninstalledWithoutErrors;
    }

    private static void installAddOnActiveScanRules(AddOn addOn, AddOnClassLoader addOnClassLoader) {
        List<AbstractPlugin> ascanrules = AddOnLoaderUtils.getActiveScanRules(addOn, addOnClassLoader);
        if (!ascanrules.isEmpty()) {
            for (AbstractPlugin ascanrule : ascanrules) {
                String name = ascanrule.getClass().getCanonicalName();
                logger.debug("Install ascanrule: " + name);
                PluginFactory.loadedPlugin(ascanrule);
                if (PluginFactory.isPluginLoaded(ascanrule)) continue;
                logger.error("Failed to install ascanrule: " + name);
            }
        }
    }

    private static boolean uninstallAddOnActiveScanRules(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        boolean uninstalledWithoutErrors = true;
        List<AbstractPlugin> loadedAscanrules = addOn.getLoadedAscanrules();
        if (!loadedAscanrules.isEmpty()) {
            logger.debug("Uninstall ascanrules: " + addOn.getAscanrules());
            callback.activeScanRulesWillBeRemoved(loadedAscanrules.size());
            for (AbstractPlugin ascanrule : loadedAscanrules) {
                String name = ascanrule.getClass().getCanonicalName();
                logger.debug("Uninstall ascanrule: " + name);
                PluginFactory.unloadedPlugin(ascanrule);
                if (PluginFactory.isPluginLoaded(ascanrule)) {
                    logger.error("Failed to uninstall ascanrule: " + name);
                    uninstalledWithoutErrors = false;
                }
                callback.activeScanRuleRemoved(name);
            }
            addOn.setLoadedAscanrules(Collections.emptyList());
            addOn.setLoadedAscanrulesSet(false);
        }
        return uninstalledWithoutErrors;
    }

    private static void installAddOnPassiveScanRules(AddOn addOn, AddOnClassLoader addOnClassLoader) {
        List<PluginPassiveScanner> pscanrules = AddOnLoaderUtils.getPassiveScanRules(addOn, addOnClassLoader);
        ExtensionPassiveScan extPscan = Control.getSingleton().getExtensionLoader().getExtension(ExtensionPassiveScan.class);
        if (!pscanrules.isEmpty() && extPscan != null) {
            for (PluginPassiveScanner pscanrule : pscanrules) {
                String name = pscanrule.getClass().getCanonicalName();
                logger.debug("Install pscanrule: " + name);
                if (extPscan.addPassiveScanner(pscanrule)) continue;
                logger.error("Failed to install pscanrule: " + name);
            }
        }
    }

    private static boolean uninstallAddOnPassiveScanRules(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        boolean uninstalledWithoutErrors = true;
        List<PluginPassiveScanner> loadedPscanrules = addOn.getLoadedPscanrules();
        ExtensionPassiveScan extPscan = Control.getSingleton().getExtensionLoader().getExtension(ExtensionPassiveScan.class);
        if (!loadedPscanrules.isEmpty()) {
            logger.debug("Uninstall pscanrules: " + addOn.getPscanrules());
            callback.passiveScanRulesWillBeRemoved(loadedPscanrules.size());
            for (PluginPassiveScanner pscanrule : loadedPscanrules) {
                String name = pscanrule.getClass().getCanonicalName();
                logger.debug("Uninstall pscanrule: " + name);
                if (!extPscan.removePassiveScanner(pscanrule)) {
                    logger.error("Failed to uninstall pscanrule: " + name);
                    uninstalledWithoutErrors = false;
                }
                callback.passiveScanRuleRemoved(name);
            }
            addOn.setLoadedPscanrules(Collections.emptyList());
            addOn.setLoadedPscanrulesSet(false);
        }
        return uninstalledWithoutErrors;
    }

    static boolean installAddOnLibs(AddOn addOn) {
        return AddOnInstaller.installAddOnLibs(addOn, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean installAddOnLibs(AddOn addOn, boolean overwrite) {
        List<AddOn.Lib> libs = addOn.getLibs();
        if (libs.isEmpty()) {
            return true;
        }
        Path targetDir = AddOnInstaller.getAddOnLibsDir(addOn);
        try {
            Files.createDirectories(targetDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            logger.warn("Failed to create libs directory for " + addOn.getId(), (Throwable)e);
            return false;
        }
        try (ZipFile zip = new ZipFile(addOn.getFile());){
            Iterator<AddOn.Lib> iterator = libs.iterator();
            while (iterator.hasNext()) {
                AddOn.Lib lib = iterator.next();
                String name = lib.getName();
                if (logger.isDebugEnabled()) {
                    logger.debug("Installing library for " + addOn + ": " + name);
                }
                Path targetFile = targetDir.resolve(name);
                try {
                    lib.setFileSystemUrl(targetFile.toUri().toURL());
                }
                catch (MalformedURLException e) {
                    logger.warn("Failed to convert lib's filesystem path to URL for " + addOn.getId(), (Throwable)e);
                    boolean bl = false;
                    if (zip == null) return bl;
                    if (var5_7 == null) {
                        zip.close();
                        return bl;
                    }
                    try {
                        zip.close();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        var5_7.addSuppressed(throwable);
                        return bl;
                    }
                }
                if (!overwrite && Files.exists(targetFile, new LinkOption[0])) continue;
                ZipEntry libZipEntry = zip.getEntry(lib.getJarPath());
                if (libZipEntry == null) {
                    logger.warn("Library not found in " + addOn + " add-on: " + lib);
                    boolean bl = false;
                    return bl;
                }
                try {
                    InputStream in = zip.getInputStream(libZipEntry);
                    Throwable throwable = null;
                    try {
                        Files.copy(in, targetFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
                catch (IOException e) {
                    logger.warn("Failed to copy the library for " + addOn + ": " + targetFile, (Throwable)e);
                    boolean bl = false;
                    if (zip == null) return bl;
                    if (var5_7 != null) {
                        try {
                            zip.close();
                            return bl;
                        }
                        catch (Throwable throwable) {
                            var5_7.addSuppressed(throwable);
                            return bl;
                        }
                    }
                    zip.close();
                    return bl;
                }
            }
            return true;
        }
        catch (IOException e) {
            logger.error("An error occurred while installing libraries for " + addOn, (Throwable)e);
            return false;
        }
    }

    static Path getAddOnDataDir(AddOn addOn) {
        return Paths.get(Constant.getZapHome(), ADD_ON_DATA_DIR, addOn.getId());
    }

    static Path getAddOnLibsDir(AddOn addOn) {
        return AddOnInstaller.getAddOnDataDir(addOn).resolve(ADD_ON_DATA_LIBS_DIR);
    }

    static boolean installMissingAddOnLibs(AddOn addOn) {
        return AddOnInstaller.installAddOnLibs(addOn, false);
    }

    static boolean uninstallAddOnLibs(AddOn addOn) {
        List<AddOn.Lib> libs = addOn.getLibs();
        if (libs.isEmpty()) {
            return true;
        }
        Path addOnLibsDir = AddOnInstaller.getAddOnLibsDir(addOn);
        try {
            AddOnInstaller.deleteDir(addOnLibsDir);
        }
        catch (IOException e) {
            logger.error("An error occurred while uninstalling libraries for " + addOn, (Throwable)e);
            return false;
        }
        Path addOnDataDir = addOnLibsDir.getParent();
        try (Stream<Path> entries = Files.list(addOnDataDir);){
            if (!entries.findAny().isPresent()) {
                Files.delete(addOnDataDir);
            }
        }
        catch (IOException e) {
            logger.warn("An error occurred while removing the directory " + addOnDataDir, (Throwable)e);
            return false;
        }
        return true;
    }

    private static void deleteDir(Path dir) throws IOException {
        if (Files.notExists(dir, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                if (e != null) {
                    throw e;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void installMissingAddOnFiles(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOnInstaller.installAddOnFiles(addOnClassLoader, addOn, false);
    }

    public static void updateAddOnFiles(AddOnClassLoader addOnClassLoader, AddOn addOn) {
        AddOnInstaller.installAddOnFiles(addOnClassLoader, addOn, true);
    }

    private static void installAddOnFiles(AddOnClassLoader addOnClassLoader, AddOn addOn, boolean overwrite) {
        List<String> fileNames = addOn.getFiles();
        if (fileNames == null || fileNames.isEmpty()) {
            return;
        }
        for (String name : fileNames) {
            File outfile = new File(Constant.getZapHome(), name);
            if (!overwrite && outfile.exists()) continue;
            if (!outfile.getParentFile().exists() && !outfile.getParentFile().mkdirs()) {
                logger.error("Failed to create directories for add-on " + addOn + ": " + outfile.getAbsolutePath());
                continue;
            }
            logger.debug("Installing file: " + name);
            URL fileURL = addOnClassLoader.findResource(name);
            if (fileURL == null) {
                logger.error("File not found in add-on " + addOn + ": " + name);
                continue;
            }
            try {
                InputStream in = fileURL.openStream();
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(outfile);
                    Throwable throwable2 = null;
                    try {
                        int bytesRead;
                        byte[] buffer = new byte[1024];
                        while ((bytesRead = in.read(buffer)) != -1) {
                            ((OutputStream)out).write(buffer, 0, bytesRead);
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)out).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)out).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                logger.error("Failed to install a file from add-on " + addOn + ": " + outfile.getAbsolutePath(), (Throwable)e);
            }
        }
        Control.getSingleton().getExtensionLoader().addonFilesAdded();
    }

    private static void validateCallbackNotNull(AddOnUninstallationProgressCallback callback) {
        Validate.notNull((Object)callback, (String)"Parameter callback must not be null.");
    }

    @Deprecated
    public static boolean uninstallAddOnFiles(AddOn addOn, AddOnUninstallationProgressCallback callback) {
        return AddOnInstaller.uninstallAddOnFiles(addOn, callback, null);
    }

    public static boolean uninstallAddOnFiles(AddOn addOn, AddOnUninstallationProgressCallback callback, Set<AddOn> installedAddOns) {
        Validate.notNull((Object)addOn, (String)"Parameter addOn must not be null.");
        AddOnInstaller.validateCallbackNotNull(callback);
        List<String> fileNames = AddOnInstaller.getFilesSafeForUninstall(addOn, installedAddOns == null ? Collections.emptySet() : installedAddOns);
        if (fileNames.isEmpty()) {
            return true;
        }
        callback.filesWillBeRemoved(fileNames.size());
        boolean uninstalledWithoutErrors = true;
        for (String name : fileNames) {
            if (name == null) continue;
            logger.debug("Uninstall file: " + name);
            File file = new File(Constant.getZapHome(), name);
            try {
                File parent = file.getParentFile();
                if (file.exists() && !file.delete()) {
                    logger.error("Failed to delete: " + file.getAbsolutePath());
                    uninstalledWithoutErrors = false;
                }
                callback.fileRemoved();
                if (parent.isDirectory() && parent.list().length == 0) {
                    logger.debug("Deleting: " + parent.getAbsolutePath());
                    if (!parent.delete()) {
                        logger.debug("Failed to delete: " + parent.getAbsolutePath());
                    }
                }
                AddOnInstaller.deleteEmptyDirsCreatedForAddOnFiles(file);
            }
            catch (Exception e) {
                logger.error("Failed to uninstall file " + file.getAbsolutePath(), (Throwable)e);
            }
        }
        Control.getSingleton().getExtensionLoader().addonFilesRemoved();
        return uninstalledWithoutErrors;
    }

    private static List<String> getFilesSafeForUninstall(AddOn addOn, Set<AddOn> installedAddOns) {
        if (addOn.getFiles() == null || addOn.getFiles().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> files = new ArrayList<String>(addOn.getFiles());
        installedAddOns.forEach(installedAddOn -> {
            if (installedAddOn == addOn) {
                return;
            }
            List<String> addOnFiles = installedAddOn.getFiles();
            if (addOnFiles == null || addOnFiles.isEmpty()) {
                return;
            }
            files.removeAll(addOnFiles);
        });
        return files;
    }

    private static void deleteEmptyDirsCreatedForAddOnFiles(File file) {
        File currentFile;
        if (file == null) {
            return;
        }
        for (currentFile = file; currentFile != null && !currentFile.exists(); currentFile = currentFile.getParentFile()) {
        }
        String root = new File(Constant.getZapHome()).getAbsolutePath();
        while (currentFile != null && currentFile.exists() && currentFile.getAbsolutePath().startsWith(root) && currentFile.getAbsolutePath().length() > root.length()) {
            AddOnInstaller.deleteEmptyDirs(currentFile);
            currentFile = currentFile.getParentFile();
        }
    }

    private static void deleteEmptyDirs(File dir) {
        logger.debug("Deleting dir " + dir.getAbsolutePath());
        for (File d : dir.listFiles()) {
            if (!d.isDirectory()) continue;
            AddOnInstaller.deleteEmptyDirs(d);
        }
        if (!dir.delete()) {
            logger.debug("Failed to delete: " + dir.getAbsolutePath());
        }
    }
}

