/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.security.KeyStore;
import java.security.Provider;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.openjsse.javax.net.ssl.SSLSocket;
import org.openjsse.net.ssl.OpenJSSE;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lokhttp3/internal/platform/OpenJSSEPlatform;", "Lokhttp3/internal/platform/Platform;", "()V", "provider", "Ljava/security/Provider;", "configureTlsExtensions", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "hostname", "", "protocols", "", "Lokhttp3/Protocol;", "getSelectedProtocol", "newSSLContext", "Ljavax/net/ssl/SSLContext;", "platformTrustManager", "Ljavax/net/ssl/X509TrustManager;", "trustManager", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "Companion", "okhttp"})
public final class OpenJSSEPlatform
extends Platform {
    private final Provider provider = (Provider)new OpenJSSE();
    private static final boolean isSupported;
    public static final Companion Companion;

    @Override
    @NotNull
    public SSLContext newSSLContext() {
        SSLContext sSLContext = SSLContext.getInstance("TLSv1.3", this.provider);
        Intrinsics.checkExpressionValueIsNotNull(sSLContext, "SSLContext.getInstance(\"TLSv1.3\", provider)");
        return sSLContext;
    }

    @Override
    @NotNull
    public X509TrustManager platformTrustManager() {
        Object[] trustManagers;
        TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm(), this.provider);
        factory.init((KeyStore)null);
        TrustManagerFactory trustManagerFactory = factory;
        Intrinsics.checkExpressionValueIsNotNull(trustManagerFactory, "factory");
        Object[] objectArray = trustManagerFactory.getTrustManagers();
        if (objectArray == null) {
            Intrinsics.throwNpe();
        }
        boolean bl = (trustManagers = objectArray).length == 1 && trustManagers[0] instanceof X509TrustManager;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            Object[] objectArray2 = trustManagers;
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected default trust managers: ");
            boolean bl5 = false;
            String string = Arrays.toString(objectArray2);
            Intrinsics.checkExpressionValueIsNotNull(string, "java.util.Arrays.toString(this)");
            String string2 = string;
            String string3 = stringBuilder.append(string2).toString();
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        TrustManager trustManager = trustManagers[0];
        if (trustManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.X509TrustManager");
        }
        return (X509TrustManager)trustManager;
    }

    @Override
    @Nullable
    public X509TrustManager trustManager(@NotNull SSLSocketFactory sslSocketFactory) {
        Intrinsics.checkParameterIsNotNull(sslSocketFactory, "sslSocketFactory");
        throw (Throwable)new UnsupportedOperationException("clientBuilder.sslSocketFactory(SSLSocketFactory) not supported with OpenJSSE");
    }

    /*
     * WARNING - void declaration
     */
    public void configureTlsExtensions(@NotNull javax.net.ssl.SSLSocket sslSocket, @Nullable String hostname, @NotNull List<? extends Protocol> protocols) {
        Intrinsics.checkParameterIsNotNull(sslSocket, "sslSocket");
        Intrinsics.checkParameterIsNotNull(protocols, "protocols");
        if (sslSocket instanceof SSLSocket) {
            SSLParameters sslParameters = ((SSLSocket)sslSocket).getSSLParameters();
            if (sslParameters instanceof org.openjsse.javax.net.ssl.SSLParameters) {
                void $this$toTypedArray$iv;
                List<String> names = Platform.Companion.alpnProtocolNames(protocols);
                Collection collection = names;
                org.openjsse.javax.net.ssl.SSLParameters sSLParameters = (org.openjsse.javax.net.ssl.SSLParameters)sslParameters;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                String[] stringArray2 = stringArray;
                sSLParameters.setApplicationProtocols(stringArray2);
                ((SSLSocket)sslSocket).setSSLParameters(sslParameters);
            }
        } else {
            super.configureTlsExtensions(sslSocket, hostname, protocols);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String getSelectedProtocol(@NotNull javax.net.ssl.SSLSocket sslSocket) {
        void var2_2;
        String protocol;
        Intrinsics.checkParameterIsNotNull(sslSocket, "sslSocket");
        return sslSocket instanceof SSLSocket ? ((protocol = ((SSLSocket)sslSocket).getApplicationProtocol()) == null || Intrinsics.areEqual(protocol, "") ? null : var2_2) : super.getSelectedProtocol(sslSocket);
    }

    private OpenJSSEPlatform() {
    }

    static {
        boolean bl;
        Companion = new Companion(null);
        try {
            Class.forName("org.openjsse.net.ssl.OpenJSSE");
            bl = true;
        }
        catch (ClassNotFoundException _) {
            bl = false;
        }
        isSupported = bl;
    }

    public /* synthetic */ OpenJSSEPlatform(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\b"}, d2={"Lokhttp3/internal/platform/OpenJSSEPlatform$Companion;", "", "()V", "isSupported", "", "()Z", "buildIfSupported", "Lokhttp3/internal/platform/OpenJSSEPlatform;", "okhttp"})
    public static final class Companion {
        public final boolean isSupported() {
            return isSupported;
        }

        @Nullable
        public final OpenJSSEPlatform buildIfSupported() {
            return this.isSupported() ? new OpenJSSEPlatform(null) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

