/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.IOException;
import mediathek.tool.MVHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

public class FileSize {
    public static String laengeString(String url) {
        String groesseStr = "";
        long l = FileSize.getFileSizeFromUrl(url);
        if (l > 1000000L) {
            groesseStr = String.valueOf(l / 1000000L);
        } else if (l > 0L) {
            groesseStr = "1";
        }
        return groesseStr;
    }

    public static long getContentLength(@NotNull Response response) {
        String sizeStr = response.headers().get("Content-Length");
        long respLength = -1L;
        if (sizeStr != null) {
            try {
                respLength = Long.parseLong(sizeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return respLength;
    }

    private static long getFileSizeFromUrl(@NotNull String url) {
        String lUrl = url.toLowerCase();
        if (!lUrl.startsWith("http") || lUrl.endsWith(".m3u8")) {
            return -1L;
        }
        Request request = new Request.Builder().url(url).head().build();
        long respLength = -1L;
        try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();){
            if (response.isSuccessful()) {
                respLength = FileSize.getContentLength(response);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (respLength < 1000000L) {
            respLength = -1L;
        }
        return respLength;
    }
}

