/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Aggregate;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Type;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Struct
extends Aggregate {
    private static final Map<List<Type>, StructReference> structCache = new ConcurrentHashMap<List<Type>, StructReference>();
    private static final ReferenceQueue<Struct> structReferenceQueue = new ReferenceQueue();
    private final Type[] fields;

    public static Struct newStruct(Type ... fields2) {
        Struct s2;
        List<Type> fieldsList = Arrays.asList(fields2);
        StructReference ref = structCache.get(fieldsList);
        Struct struct = s2 = ref != null ? (Struct)ref.get() : null;
        if (s2 != null) {
            return s2;
        }
        while ((ref = (StructReference)structReferenceQueue.poll()) != null) {
            structCache.remove(ref.fieldsList);
        }
        s2 = new Struct(Foreign.getInstance(), fields2);
        structCache.put(fieldsList, new StructReference(s2, structReferenceQueue, fieldsList));
        return s2;
    }

    private Struct(Foreign foreign, Type ... fields2) {
        super(foreign, foreign.newStruct(Type.nativeHandles(fields2), false));
        this.fields = (Type[])fields2.clone();
    }

    @Deprecated
    public Struct(Type ... fields2) {
        super(Foreign.getInstance(), Foreign.getInstance().newStruct(Type.nativeHandles(fields2), false));
        this.fields = (Type[])fields2.clone();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.equals(this.fields, ((Struct)o).fields);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + Arrays.hashCode(this.fields);
        return result2;
    }

    private static final class StructReference
    extends WeakReference<Struct> {
        List<Type> fieldsList;

        private StructReference(Struct struct, ReferenceQueue<? super Struct> referenceQueue, List<Type> fieldsList) {
            super(struct, referenceQueue);
            this.fieldsList = fieldsList;
        }
    }
}

