"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var re_reselect_1 = __importDefault(require("re-reselect"));
var __1 = require("../../..");
var get_chart_id_1 = require("../../../../state/selectors/get_chart_id");
var get_last_drag_1 = require("../../../../state/selectors/get_last_drag");
var events_1 = require("../../../../utils/events");
var get_heatmap_config_1 = require("./get_heatmap_config");
var get_picked_cells_1 = require("./get_picked_cells");
var heatmap_spec_1 = require("./heatmap_spec");
var is_brush_available_1 = require("./is_brush_available");
function createOnBrushEndCaller() {
    var prevProps = null;
    var selector = null;
    return function (state) {
        if (selector === null && state.chartType === __1.ChartTypes.Heatmap) {
            if (!is_brush_available_1.isBrushEndProvided(state)) {
                selector = null;
                prevProps = null;
                return;
            }
            selector = re_reselect_1.default([get_last_drag_1.getLastDragSelector, heatmap_spec_1.getSpecOrNull, get_heatmap_config_1.getHeatmapConfigSelector, get_picked_cells_1.getPickedCells], function (lastDrag, spec, _a, pickedCells) {
                var onBrushEnd = _a.onBrushEnd;
                var nextProps = {
                    lastDrag: lastDrag,
                    onBrushEnd: onBrushEnd,
                };
                if (!spec || !onBrushEnd || pickedCells === null) {
                    return;
                }
                if (lastDrag !== null && events_1.hasDragged(prevProps, nextProps)) {
                    onBrushEnd(pickedCells);
                }
                prevProps = nextProps;
            })({
                keySelector: get_chart_id_1.getChartIdSelector,
            });
        }
        if (selector) {
            selector(state);
        }
    };
}
exports.createOnBrushEndCaller = createOnBrushEndCaller;
//# sourceMappingURL=on_brush_end_caller.js.map