/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.auth;

import java.io.Serializable;
import javax.crypto.spec.SecretKeySpec;
import twitter4j.HttpResponse;
import twitter4j.TwitterException;

abstract class OAuthToken
implements Serializable {
    private static final long serialVersionUID = -7841506492508140600L;
    private final String token;
    private final String tokenSecret;
    private transient SecretKeySpec secretKeySpec;
    private String[] responseStr = null;

    public OAuthToken(String token, String tokenSecret) {
        if (token == null) {
            throw new IllegalArgumentException("Token can't be null");
        }
        if (tokenSecret == null) {
            throw new IllegalArgumentException("TokenSecret can't be null");
        }
        this.token = token;
        this.tokenSecret = tokenSecret;
    }

    OAuthToken(HttpResponse response) throws TwitterException {
        this(response.asString());
    }

    OAuthToken(String string) {
        this.responseStr = string.split("&");
        this.tokenSecret = this.getParameter("oauth_token_secret");
        this.token = this.getParameter("oauth_token");
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    void setSecretKeySpec(SecretKeySpec secretKeySpec) {
        this.secretKeySpec = secretKeySpec;
    }

    SecretKeySpec getSecretKeySpec() {
        return this.secretKeySpec;
    }

    public String getParameter(String parameter) {
        String value = null;
        for (String str : this.responseStr) {
            if (!str.startsWith(parameter + '=')) continue;
            value = str.split("=")[1].trim();
            break;
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuthToken)) {
            return false;
        }
        OAuthToken that = (OAuthToken)o;
        if (!this.token.equals(that.token)) {
            return false;
        }
        return this.tokenSecret.equals(that.tokenSecret);
    }

    public int hashCode() {
        int result = this.token.hashCode();
        result = 31 * result + this.tokenSecret.hashCode();
        return result;
    }

    public String toString() {
        return "OAuthToken{token='" + this.token + '\'' + ", tokenSecret='" + this.tokenSecret + '\'' + ", secretKeySpec=" + this.secretKeySpec + '}';
    }
}

