/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import io.undertow.client.ClientRequest;
import io.undertow.client.ClientResponse;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Marshalling;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionMessages;
import org.wildfly.httpclient.transaction.HttpRemoteTransactionPeer;
import org.wildfly.httpclient.transaction.TransactionConstants;
import org.wildfly.security.auth.client.AuthenticationConfiguration;
import org.wildfly.transaction.client.spi.SubordinateTransactionControl;
import org.xnio.IoUtils;

class HttpSubordinateTransactionHandle
implements SubordinateTransactionControl {
    private final HttpTargetContext targetContext;
    private final Xid id;
    private final SSLContext sslContext;
    private final AuthenticationConfiguration authenticationConfiguration;

    HttpSubordinateTransactionHandle(Xid id, HttpTargetContext targetContext, SSLContext sslContext, AuthenticationConfiguration authenticationConfiguration) {
        this.id = id;
        this.targetContext = targetContext;
        this.sslContext = sslContext;
        this.authenticationConfiguration = authenticationConfiguration;
    }

    Xid getId() {
        return this.id;
    }

    @Override
    public void commit(boolean onePhase) throws XAException {
        String operationPath = "/txn/v1/xa/commit" + (onePhase ? "?opc=true" : "");
        this.processOperation(operationPath);
    }

    @Override
    public void rollback() throws XAException {
        this.processOperation("/txn/v1/xa/rollback");
    }

    @Override
    public void end(int flags) throws XAException {
    }

    @Override
    public void beforeCompletion() throws XAException {
        this.processOperation("/txn/v1/xa/bc");
    }

    @Override
    public int prepare() throws XAException {
        boolean readOnly = this.processOperation("/txn/v1/xa/prep", result -> {
            String header = result.getResponseHeaders().getFirst(TransactionConstants.READ_ONLY);
            return header != null && Boolean.parseBoolean(header);
        });
        return readOnly ? 3 : 0;
    }

    @Override
    public void forget() throws XAException {
        this.processOperation("/txn/v1/xa/forget");
    }

    private void processOperation(String operationPath) throws XAException {
        this.processOperation(operationPath, null);
    }

    private <T> T processOperation(String operationPath, Function<ClientResponse, T> resultFunction) throws XAException {
        CompletableFuture result = new CompletableFuture();
        ClientRequest cr = new ClientRequest().setMethod(Methods.POST).setPath(this.targetContext.getUri().getPath() + operationPath);
        cr.getRequestHeaders().put(Headers.ACCEPT, "application/x-wf-jbmar-exception;version=1");
        cr.getRequestHeaders().put(Headers.CONTENT_TYPE, "application/x-wf-jbmar-xid;version=1");
        this.targetContext.sendRequest(cr, this.sslContext, this.authenticationConfiguration, output -> {
            Marshaller marshaller = this.targetContext.createMarshaller(HttpRemoteTransactionPeer.createMarshallingConf());
            marshaller.start(Marshalling.createByteOutput(output));
            marshaller.writeInt(this.id.getFormatId());
            byte[] gtid = this.id.getGlobalTransactionId();
            marshaller.writeInt(gtid.length);
            marshaller.write(gtid);
            byte[] bq = this.id.getBranchQualifier();
            marshaller.writeInt(bq.length);
            marshaller.write(bq);
            marshaller.finish();
            output.close();
        }, (input, response, closeable) -> {
            try {
                result.complete(resultFunction != null ? (Object)resultFunction.apply(response) : null);
            }
            finally {
                IoUtils.safeClose(closeable);
            }
        }, result::completeExceptionally, null, null);
        try {
            try {
                return result.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw HttpRemoteTransactionMessages.MESSAGES.interruptedXA(-3);
            }
        }
        catch (ExecutionException e) {
            try {
                throw e.getCause();
            }
            catch (XAException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                XAException xaException = new XAException(-3);
                xaException.initCause(ex);
                throw xaException;
            }
        }
    }
}

