/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.data.WebAuthnAuthenticationContext;
import com.webauthn4j.data.WebAuthnRegistrationContext;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AAGUID;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.AttestationStatement;
import com.webauthn4j.data.client.CollectedClientData;
import com.webauthn4j.data.client.TokenBinding;
import com.webauthn4j.data.extension.ExtensionOutput;
import com.webauthn4j.data.extension.authenticator.AuthenticationExtensionsAuthenticatorOutputs;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorOutput;
import com.webauthn4j.data.extension.client.AuthenticationExtensionsClientOutputs;
import com.webauthn4j.data.extension.client.ExtensionClientOutput;
import com.webauthn4j.server.ServerProperty;
import com.webauthn4j.validator.exception.ConstraintViolationException;
import java.util.Map;

class BeanAssertUtil {
    private BeanAssertUtil() {
    }

    public static void validate(WebAuthnAuthenticationContext webAuthnAuthenticationContext) {
        if (webAuthnAuthenticationContext == null) {
            throw new ConstraintViolationException("webAuthnAuthenticationContext must not be null");
        }
        if (webAuthnAuthenticationContext.getCredentialId() == null) {
            throw new ConstraintViolationException("credentialId must not be null");
        }
        if (webAuthnAuthenticationContext.getClientDataJSON() == null) {
            throw new ConstraintViolationException("clientDataJSON must not be null");
        }
        if (webAuthnAuthenticationContext.getAuthenticatorData() == null) {
            throw new ConstraintViolationException("authenticatorData must not be null");
        }
        if (webAuthnAuthenticationContext.getSignature() == null) {
            throw new ConstraintViolationException("signature must not be null");
        }
        BeanAssertUtil.validate(webAuthnAuthenticationContext.getServerProperty());
    }

    public static void validate(WebAuthnRegistrationContext webAuthnRegistrationContext) {
        if (webAuthnRegistrationContext == null) {
            throw new ConstraintViolationException("webAuthnRegistrationContext must not be null");
        }
        if (webAuthnRegistrationContext.getAttestationObject() == null) {
            throw new ConstraintViolationException("attestationObject must not be null");
        }
        if (webAuthnRegistrationContext.getClientDataJSON() == null) {
            throw new ConstraintViolationException("clientDataJSON must not be null");
        }
        BeanAssertUtil.validate(webAuthnRegistrationContext.getServerProperty());
    }

    public static void validate(CollectedClientData collectedClientData) {
        if (collectedClientData == null) {
            throw new ConstraintViolationException("collectedClientData must not be null");
        }
        if (collectedClientData.getType() == null) {
            throw new ConstraintViolationException("type must not be null");
        }
        if (collectedClientData.getChallenge() == null) {
            throw new ConstraintViolationException("challenge must not be null");
        }
        if (collectedClientData.getOrigin() == null) {
            throw new ConstraintViolationException("origin must not be null");
        }
        BeanAssertUtil.validate(collectedClientData.getTokenBinding());
    }

    public static void validate(TokenBinding tokenBinding) {
        if (tokenBinding == null) {
            return;
        }
        if (tokenBinding.getStatus() == null) {
            throw new ConstraintViolationException("status must not be null");
        }
    }

    public static void validate(AttestationObject attestationObject) {
        if (attestationObject == null) {
            throw new ConstraintViolationException("attestationObject must not be null");
        }
        BeanAssertUtil.validate(attestationObject.getAttestationStatement());
        BeanAssertUtil.validate(attestationObject.getAuthenticatorData());
    }

    public static <T extends ExtensionAuthenticatorOutput> void validate(AuthenticatorData<T> authenticatorData) {
        byte[] rpIdHash;
        if (authenticatorData == null) {
            throw new ConstraintViolationException("authenticatorData must not be null");
        }
        AttestedCredentialData attestedCredentialData = authenticatorData.getAttestedCredentialData();
        if (attestedCredentialData != null) {
            BeanAssertUtil.validate(attestedCredentialData);
        }
        if ((rpIdHash = authenticatorData.getRpIdHash()) == null) {
            throw new ConstraintViolationException("rpIdHash must not be null");
        }
        if (rpIdHash.length != 32) {
            throw new ConstraintViolationException("rpIdHash must be 32 bytes length");
        }
        long signCount = authenticatorData.getSignCount();
        if (signCount < 0L || signCount > 0xFFFFFFFFL) {
            throw new ConstraintViolationException("signCount must be unsigned int");
        }
        AuthenticationExtensionsAuthenticatorOutputs<T> extensions = authenticatorData.getExtensions();
        BeanAssertUtil.validateAuthenticatorExtensionsOutputs(extensions);
    }

    public static void validate(AttestedCredentialData attestedCredentialData) {
        if (attestedCredentialData == null) {
            throw new ConstraintViolationException("attestedCredentialData must not be null");
        }
        AAGUID aaguid = attestedCredentialData.getAaguid();
        if (aaguid == null) {
            throw new ConstraintViolationException("aaguid must not be null");
        }
        if (attestedCredentialData.getCredentialId() == null) {
            throw new ConstraintViolationException("credentialId must not be null");
        }
        COSEKey coseKey = attestedCredentialData.getCOSEKey();
        BeanAssertUtil.validate(coseKey);
    }

    public static <T extends ExtensionClientOutput> void validateAuthenticationExtensionsClientOutputs(AuthenticationExtensionsClientOutputs<T> authenticationExtensionsClientOutputs) {
        if (authenticationExtensionsClientOutputs == null) {
            return;
        }
        for (Map.Entry set : authenticationExtensionsClientOutputs.entrySet()) {
            BeanAssertUtil.validate((String)set.getKey(), (ExtensionOutput)set.getValue());
        }
    }

    public static <T extends ExtensionAuthenticatorOutput> void validateAuthenticatorExtensionsOutputs(AuthenticationExtensionsAuthenticatorOutputs<T> authenticationExtensionsAuthenticatorOutputs) {
        if (authenticationExtensionsAuthenticatorOutputs == null) {
            return;
        }
        for (Map.Entry set : authenticationExtensionsAuthenticatorOutputs.entrySet()) {
            BeanAssertUtil.validate((String)set.getKey(), (ExtensionOutput)set.getValue());
        }
    }

    public static void validate(String identifier, ExtensionOutput extensionOutput) {
        if (identifier == null) {
            throw new ConstraintViolationException("identifier must not be null");
        }
        if (!identifier.equals(extensionOutput.getIdentifier())) {
            throw new ConstraintViolationException("identifier must match");
        }
        extensionOutput.validate();
    }

    public static void validate(ServerProperty serverProperty) {
        if (serverProperty == null) {
            throw new ConstraintViolationException("serverProperty must not be null");
        }
        if (serverProperty.getRpId() == null) {
            throw new ConstraintViolationException("rpId must not be null");
        }
        if (serverProperty.getChallenge() == null) {
            throw new ConstraintViolationException("challenge must not be null");
        }
        if (serverProperty.getOrigin() == null) {
            throw new ConstraintViolationException("origin must not be null");
        }
    }

    public static void validate(AttestationStatement attestationStatement) {
        if (attestationStatement == null) {
            throw new ConstraintViolationException("attestationStatement must not be null");
        }
        attestationStatement.validate();
    }

    public static void validate(COSEKey coseKey) {
        if (coseKey == null) {
            throw new ConstraintViolationException("coseKey must not be null");
        }
        coseKey.validate();
    }
}

