/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import org.infinispan.IllegalLifecycleStateException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.ReflectionUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.ComponentFactory;
import org.infinispan.factories.components.ComponentMetadata;
import org.infinispan.factories.components.ComponentMetadataRepo;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentAlias;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class BasicComponentRegistryImpl
implements BasicComponentRegistry {
    private static final Log log = LogFactory.getLog(BasicComponentRegistryImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ClassLoader classLoader;
    private final ComponentMetadataRepo metadataRepo;
    private final Scopes scope;
    private final BasicComponentRegistry next;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final ConcurrentMap<String, ComponentWrapper> components = new ConcurrentHashMap<String, ComponentWrapper>();
    @GuardedBy(value="lock")
    private final List<String> startedComponents = new ArrayList<String>();
    @GuardedBy(value="lock")
    private final Map<Thread, ComponentPath> mutatorThreads;
    private volatile ComponentStatus status;

    public BasicComponentRegistryImpl(ClassLoader classLoader, ComponentMetadataRepo metadataRepo, Scopes scope, BasicComponentRegistry next) {
        this.classLoader = classLoader;
        this.metadataRepo = metadataRepo;
        this.scope = scope;
        this.next = next;
        this.status = ComponentStatus.RUNNING;
        this.mutatorThreads = new HashMap<Thread, ComponentPath>();
        this.registerComponent(BasicComponentRegistry.class, this, false);
    }

    @Override
    public <T> ComponentRef<T> getComponent(String name, Class<T> componentType) {
        return this.getComponent0(name, componentType, true);
    }

    public <T> ComponentRef<T> getComponent0(String name, Class<T> componentType, boolean needInstance) {
        ComponentRef<T> nextScopeRef;
        ComponentWrapper wrapper = (ComponentWrapper)this.components.get(name);
        if (wrapper != null && (wrapper.isAtLeast(WrapperState.WIRED) || !needInstance)) {
            return wrapper;
        }
        if (wrapper == null && this.next != null && (nextScopeRef = this.next.getComponent(name, componentType)) != null) {
            return nextScopeRef;
        }
        ComponentFactory factory = this.findFactory(name);
        if (wrapper == null) {
            if (factory == null) {
                return null;
            }
            wrapper = this.registerWrapper(name, true);
        }
        if (needInstance) {
            if (factory != null) {
                this.instantiateWrapper(wrapper, factory);
            } else {
                this.awaitWrapperState(wrapper, WrapperState.INSTANTIATED);
            }
            this.wireWrapper(wrapper);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentWrapper registerWrapper(String name, boolean manageLifecycle) {
        ComponentWrapper wrapper = new ComponentWrapper(this, name, manageLifecycle);
        this.lock.lock();
        try {
            if (this.status != ComponentStatus.RUNNING) {
                throw new IllegalLifecycleStateException("Cannot register components while the registry is not running");
            }
            ComponentWrapper existing = this.components.putIfAbsent(wrapper.name, wrapper);
            ComponentWrapper componentWrapper = existing != null ? existing : wrapper;
            return componentWrapper;
        }
        finally {
            this.lock.unlock();
        }
    }

    void instantiateWrapper(ComponentWrapper wrapper, ComponentFactory factory) {
        Object instance;
        String name = wrapper.name;
        if (!this.prepareWrapperChange(wrapper, WrapperState.EMPTY, WrapperState.INSTANTIATING)) {
            this.awaitWrapperState(wrapper, WrapperState.INSTANTIATED);
            return;
        }
        try {
            instance = factory.construct(name);
        }
        catch (Throwable t) {
            this.commitWrapperStateChange(wrapper, WrapperState.INSTANTIATING, WrapperState.FAILED);
            throw new CacheConfigurationException("Failed to construct component " + name + ", path " + this.getCurrentComponentPath(), t);
        }
        if (instance instanceof ComponentAlias) {
            ComponentAlias alias = (ComponentAlias)instance;
            this.commitWrapperAliasChange(wrapper, alias, null, WrapperState.INSTANTIATING, WrapperState.INSTANTIATED);
            return;
        }
        ComponentMetadata metadata = this.getMetadataForComponent(instance);
        if (metadata != null && metadata.getScope() != null && metadata.getScope() != this.scope) {
            throw new CacheConfigurationException("Component " + wrapper.name + " has scope " + (Object)((Object)metadata.getScope()) + " but its factory is " + (Object)((Object)this.scope));
        }
        this.commitWrapperInstanceChange(wrapper, instance, metadata, WrapperState.INSTANTIATING, WrapperState.INSTANTIATED);
    }

    void wireWrapper(ComponentWrapper wrapper) {
        if (!this.prepareWrapperChange(wrapper, WrapperState.INSTANTIATED, WrapperState.WIRING)) {
            this.awaitWrapperState(wrapper, WrapperState.WIRED);
            return;
        }
        if (wrapper.instance instanceof ComponentAlias) {
            ComponentAlias alias = (ComponentAlias)wrapper.instance;
            String aliasTargetName = alias.getComponentName();
            ComponentRef<Object> targetRef = this.getComponent(aliasTargetName, Object.class);
            if (targetRef == null) {
                throw new CacheConfigurationException("Alias " + wrapper.name + " target component is missing: " + aliasTargetName);
            }
            targetRef.wired();
            this.commitWrapperAliasChange(wrapper, alias, targetRef, WrapperState.WIRING, WrapperState.WIRED);
        } else {
            try {
                this.performInjection(wrapper.instance, wrapper.metadata, false);
            }
            catch (Throwable t) {
                this.commitWrapperStateChange(wrapper, WrapperState.WIRING, WrapperState.FAILED);
                throw t;
            }
            WrapperState wiredState = wrapper.metadata != null ? WrapperState.WIRED : WrapperState.STARTED;
            this.commitWrapperStateChange(wrapper, WrapperState.WIRING, wiredState);
        }
    }

    @Override
    public void wireDependencies(Object target, boolean startDependencies) {
        ComponentMetadata metadata = this.metadataRepo.getComponentMetadata(target.getClass());
        this.performInjection(target, metadata, startDependencies);
    }

    private <T> ComponentFactory findFactory(String name) {
        String factoryName = this.metadataRepo.findFactoryForComponent(name);
        if (factoryName == null) {
            return null;
        }
        ComponentRef<ComponentFactory> factoryRef = this.getComponent(factoryName, ComponentFactory.class);
        if (factoryRef == null) {
            factoryRef = this.tryAutoInstantiation(factoryName);
        }
        return factoryRef != null ? factoryRef.wired() : null;
    }

    private void commitWrapperStateChange(ComponentWrapper wrapper, WrapperState expectedState, WrapperState newState) {
        this.commitWrapperChange(wrapper, wrapper.instance, wrapper.metadata, wrapper.aliasTarget, expectedState, newState);
    }

    private void commitWrapperInstanceChange(ComponentWrapper wrapper, Object instance, ComponentMetadata metadata, WrapperState expectedState, WrapperState newState) {
        this.commitWrapperChange(wrapper, instance, metadata, null, expectedState, newState);
    }

    private void commitWrapperAliasChange(ComponentWrapper wrapper, ComponentAlias alias, ComponentRef<?> targetRef, WrapperState expectedState, WrapperState newState) {
        this.commitWrapperChange(wrapper, alias, null, targetRef, expectedState, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitWrapperChange(ComponentWrapper wrapper, Object instance, ComponentMetadata metadata, ComponentRef<?> aliasTargetRef, WrapperState expectedState, WrapperState newState) {
        this.lock.lock();
        try {
            if (wrapper.state != expectedState) {
                throw new IllegalLifecycleStateException("Component " + wrapper.name + " has wrong status: " + (Object)((Object)wrapper.state) + ", expected: " + (Object)((Object)expectedState));
            }
            wrapper.instance = instance;
            wrapper.metadata = metadata;
            wrapper.aliasTarget = aliasTargetRef;
            wrapper.state = newState;
            ComponentPath currentPath = this.mutatorThreads.get(Thread.currentThread());
            if (currentPath.next != null) {
                this.mutatorThreads.put(Thread.currentThread(), currentPath.next);
            } else {
                this.mutatorThreads.remove(Thread.currentThread());
            }
            if (trace) {
                log.tracef("Changed status of " + wrapper.name + " to " + (Object)((Object)wrapper.state), new Object[0]);
            }
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    private ComponentRef<ComponentFactory> tryAutoInstantiation(String factoryName) {
        Class factoryClass = Util.loadClass((String)factoryName, (ClassLoader)this.classLoader);
        ComponentMetadata metadata = this.metadataRepo.getComponentMetadata(factoryClass);
        if (metadata != null && metadata.getScope() != null && metadata.getScope() != this.scope) {
            return null;
        }
        if (!AutoInstantiableFactory.class.isAssignableFrom(factoryClass)) {
            return null;
        }
        DefaultFactoryFactory factoryFactory = new DefaultFactoryFactory(factoryClass);
        ComponentWrapper wrapper = this.registerWrapper(factoryName, true);
        this.instantiateWrapper(wrapper, factoryFactory);
        this.wireWrapper(wrapper);
        return wrapper;
    }

    private void performInjection(Object target, ComponentMetadata metadata, boolean startDependencies) {
        try {
            if (metadata == null) {
                return;
            }
            for (ComponentMetadata.InjectFieldMetadata injectFieldMetadata : metadata.getInjectFields()) {
                this.setInjectionField(target, injectFieldMetadata, startDependencies);
            }
            for (Serializable serializable : metadata.getInjectMethods()) {
                this.invokeInjectionMethod(target, (ComponentMetadata.InjectMethodMetadata)serializable, startDependencies);
            }
        }
        catch (IllegalLifecycleStateException | CacheConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to inject dependencies for component class " + target.getClass().getName() + ", path " + this.getCurrentComponentPath(), (Throwable)e);
        }
    }

    private void invokeInjectionMethod(Object target, ComponentMetadata.InjectMethodMetadata injectMethodMetadata, boolean startDependencies) {
        Class<?>[] parameterComponentTypes = injectMethodMetadata.getParameterClasses();
        Object[] params = new Object[parameterComponentTypes.length];
        if (trace) {
            log.tracef("Injecting dependencies for method %s.%s", target.getClass().getName(), injectMethodMetadata);
        }
        for (int i = 0; i < parameterComponentTypes.length; ++i) {
            Object value;
            String name = injectMethodMetadata.getDependencyName(i);
            boolean parameterLazy = injectMethodMetadata.getParameterLazy(i);
            params[i] = value = this.getDependency(name, parameterComponentTypes[i], parameterLazy, startDependencies);
        }
        if (System.getSecurityManager() == null) {
            ReflectionUtil.invokeAccessibly((Object)target, (Method)injectMethodMetadata.getMethod(), (Object[])params);
        } else {
            AccessController.doPrivileged(() -> ReflectionUtil.invokeAccessibly((Object)target, (Method)injectMethodMetadata.getMethod(), (Object[])params));
        }
    }

    private void setInjectionField(Object target, ComponentMetadata.InjectFieldMetadata injectFieldMetadata, boolean startDependencies) {
        String name = injectFieldMetadata.getDependencyName();
        boolean lazy = injectFieldMetadata.isLazy();
        Class<?> componentType = injectFieldMetadata.getComponentClass();
        Object value = this.getDependency(name, componentType, lazy, startDependencies);
        if (System.getSecurityManager() == null) {
            ReflectionUtil.setAccessibly((Object)target, (Field)injectFieldMetadata.getField(), (Object)value);
        } else {
            AccessController.doPrivileged(() -> {
                ReflectionUtil.setAccessibly((Object)target, (Field)injectFieldMetadata.getField(), (Object)value);
                return null;
            });
        }
    }

    private Object getDependency(String name, Class<?> componentType, boolean lazy, boolean startDependencies) {
        ComponentRef<?> componentRef = this.getComponent0(name, componentType, !lazy);
        if (componentRef == null) {
            throw new CacheConfigurationException("Unable to construct dependency " + name + " in scope " + (Object)((Object)this.scope) + " for " + this.getCurrentComponentPath());
        }
        ComponentRef<?> value = lazy ? componentRef : (startDependencies ? componentRef.running() : componentRef.wired());
        return value;
    }

    @Override
    public <T> ComponentRef<T> registerComponent(String componentName, T instance, boolean manageLifecycle) {
        Class<?> componentClass;
        ComponentMetadata metadata = this.getMetadataForComponent(instance);
        Class<?> clazz = componentClass = instance != null ? instance.getClass() : null;
        if (metadata != null && metadata.getScope() != null && metadata.getScope() != this.scope) {
            throw new CacheConfigurationException("Wrong registration scope " + (Object)((Object)this.scope) + " for component class " + componentClass);
        }
        ComponentWrapper wrapper = this.registerWrapper(componentName, manageLifecycle);
        if (!this.prepareWrapperChange(wrapper, WrapperState.EMPTY, WrapperState.INSTANTIATING)) {
            throw new CacheConfigurationException("Component " + componentName + " is already registered");
        }
        this.commitWrapperInstanceChange(wrapper, instance, metadata, WrapperState.INSTANTIATING, WrapperState.INSTANTIATED);
        this.wireWrapper(wrapper);
        return wrapper;
    }

    private ComponentMetadata getMetadataForComponent(Object component) {
        return component != null ? this.metadataRepo.getComponentMetadata(component.getClass()) : null;
    }

    @Override
    public void registerAlias(String aliasName, String targetComponentName, Class<?> targetComponentType) {
        ComponentWrapper wrapper = this.registerWrapper(aliasName, false);
        if (!this.prepareWrapperChange(wrapper, WrapperState.EMPTY, WrapperState.INSTANTIATING)) {
            throw new IllegalStateException("Cannot register alias " + aliasName + " with target " + targetComponentName + " as the name is already registered");
        }
        this.commitWrapperAliasChange(wrapper, ComponentAlias.of(targetComponentName), null, WrapperState.INSTANTIATING, WrapperState.INSTANTIATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDynamicDependency(String ownerComponentName, String dependencyComponentName) {
        ComponentRef<Object> ref = this.getComponent0(ownerComponentName, Object.class, false);
        if (ref instanceof ComponentWrapper) {
            ComponentWrapper wrapper = (ComponentWrapper)ref;
            this.lock.lock();
            try {
                wrapper.addDynamicDependency(dependencyComponentName);
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replaceComponent(String componentName, Object newInstance, boolean manageLifecycle) {
        boolean start;
        this.lock.lock();
        try {
            ComponentWrapper oldWrapper = (ComponentWrapper)this.components.remove(componentName);
            start = oldWrapper != null && oldWrapper.isRunning();
        }
        finally {
            this.lock.unlock();
        }
        this.registerComponent(componentName, newInstance, manageLifecycle);
        if (start) {
            this.getComponent(componentName, newInstance.getClass()).running();
        }
    }

    @Override
    public void rewire() {
        this.lock.lock();
        try {
            if (this.status == ComponentStatus.TERMINATED) {
                this.status = ComponentStatus.RUNNING;
            }
            for (ComponentWrapper wrapper : this.components.values()) {
                this.performInjection(wrapper.instance, wrapper.metadata, false);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ComponentRef<?>> getRegisteredComponents() {
        this.lock.lock();
        try {
            ArrayList<ComponentWrapper> list = new ArrayList<ComponentWrapper>(this.components.size());
            for (ComponentWrapper wrapper : this.components.values()) {
                list.add(wrapper);
            }
            ArrayList<ComponentWrapper> arrayList = list;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        ArrayList<String> componentsToStop;
        this.lock.lock();
        try {
            if (this.status != ComponentStatus.RUNNING) {
                throw new IllegalStateException("Stopping is only allowed in the RUNNING state, current state is " + (Object)((Object)this.status) + "!");
            }
            componentsToStop = new ArrayList<String>(this.startedComponents);
            this.status = ComponentStatus.STOPPING;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
        for (int i = componentsToStop.size() - 1; i >= 0; --i) {
            ComponentWrapper wrapper = (ComponentWrapper)this.components.get(componentsToStop.get(i));
            this.stopWrapper(wrapper);
        }
        this.lock.lock();
        try {
            this.startedComponents.clear();
            this.removeVolatileComponents();
            this.status = ComponentStatus.TERMINATED;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @GuardedBy(value="lock")
    private void removeVolatileComponents() {
        Iterator it = this.components.values().iterator();
        while (it.hasNext()) {
            boolean survivesRestarts;
            ComponentWrapper wrapper = (ComponentWrapper)it.next();
            boolean bl = survivesRestarts = wrapper.metadata != null && wrapper.metadata.isSurvivesRestarts();
            if (wrapper.manageLifecycle && !survivesRestarts) {
                if (trace) {
                    log.tracef("Removing component %s in state %s", wrapper.name, (Object)wrapper.state);
                }
                it.remove();
                continue;
            }
            if (wrapper.manageLifecycle && wrapper.state == WrapperState.STOPPED) {
                wrapper.state = WrapperState.INSTANTIATED;
            }
            if (!trace) continue;
            log.tracef("Keeping component %s in state %s", wrapper.name, (Object)wrapper.state);
        }
    }

    void startWrapper(ComponentWrapper wrapper) {
        if (!this.prepareWrapperChange(wrapper, WrapperState.WIRED, WrapperState.STARTING)) {
            this.awaitWrapperState(wrapper, WrapperState.STARTED);
            return;
        }
        if (wrapper.aliasTarget != null) {
            wrapper.aliasTarget.running();
            this.commitWrapperStateChange(wrapper, WrapperState.STARTING, WrapperState.STARTED);
            return;
        }
        if (wrapper.metadata == null) {
            this.commitWrapperStateChange(wrapper, WrapperState.STARTING, WrapperState.FAILED);
            throw new IllegalStateException("Components without metadata should go directly to RUNNING state");
        }
        this.startDependencies(wrapper);
        if (!wrapper.manageLifecycle) {
            this.commitWrapperStateChange(wrapper, WrapperState.STARTING, WrapperState.STARTED);
            return;
        }
        if (wrapper.metadata.getPostStartMethods().length > 0) {
            log.warnf("Running post-start methods on class %s as start methods, in the future the @PostStart annotation will be ignored", wrapper.metadata.getName());
        }
        try {
            for (ComponentMetadata.PrioritizedMethodMetadata method : wrapper.metadata.getStartMethods()) {
                ReflectionUtil.invokeAccessibly((Object)wrapper.instance, (Method)method.getMethod(), null);
            }
            for (ComponentMetadata.PrioritizedMethodMetadata method : wrapper.metadata.getPostStartMethods()) {
                ReflectionUtil.invokeAccessibly((Object)wrapper.instance, (Method)method.getMethod(), null);
            }
            this.commitWrapperStateChange(wrapper, WrapperState.STARTING, WrapperState.STARTED);
        }
        catch (Throwable t) {
            this.commitWrapperStateChange(wrapper, WrapperState.STARTING, WrapperState.FAILED);
            throw t;
        }
        finally {
            this.logStartedComponent(wrapper);
        }
    }

    private void logStartedComponent(ComponentWrapper wrapper) {
        this.lock.lock();
        try {
            this.startedComponents.add(wrapper.getName());
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startDependencies(ComponentWrapper wrapper) {
        for (ComponentMetadata.InjectFieldMetadata injectFieldMetadata : wrapper.metadata.getInjectFields()) {
            ComponentRef<?> dependency;
            String name = injectFieldMetadata.getDependencyName();
            if (injectFieldMetadata.isLazy() || (dependency = this.getComponent(name, injectFieldMetadata.getComponentClass())) == null) continue;
            dependency.running();
        }
        for (Serializable serializable : wrapper.metadata.getInjectMethods()) {
            Class<?>[] componentTypes = ((ComponentMetadata.InjectMethodMetadata)serializable).getParameterClasses();
            for (int i = 0; i < componentTypes.length; ++i) {
                ComponentRef<?> dependency;
                String name = ((ComponentMetadata.InjectMethodMetadata)serializable).getDependencyName(i);
                if (((ComponentMetadata.InjectMethodMetadata)serializable).getParameterLazy(i) || (dependency = this.getComponent(name, componentTypes[i])) == null) continue;
                dependency.running();
            }
        }
        ComponentPath remainingDependencies = wrapper.dynamicDependencies;
        while (remainingDependencies != null) {
            String componentName = remainingDependencies.name;
            ComponentRef<Object> dependency = this.getComponent(componentName, Object.class);
            if (dependency != null) {
                dependency.running();
            }
            remainingDependencies = remainingDependencies.next;
        }
    }

    private void stopWrapper(ComponentWrapper wrapper) {
        if (!this.prepareWrapperChange(wrapper, WrapperState.STARTED, WrapperState.STOPPING) && !this.prepareWrapperChange(wrapper, WrapperState.FAILED, WrapperState.STOPPING)) {
            return;
        }
        this.performStop(wrapper);
        this.commitWrapperStateChange(wrapper, WrapperState.STOPPING, WrapperState.STOPPED);
    }

    private void performStop(ComponentWrapper wrapper) {
        if (!wrapper.manageLifecycle || wrapper.metadata == null) {
            return;
        }
        try {
            for (ComponentMetadata.PrioritizedMethodMetadata method : wrapper.metadata.getStopMethods()) {
                ReflectionUtil.invokeAccessibly((Object)wrapper.instance, (Method)method.getMethod(), null);
            }
        }
        catch (Exception e) {
            log.error("Error stopping component " + wrapper.name, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean prepareWrapperChange(ComponentWrapper wrapper, WrapperState expectedState, WrapperState newState) {
        this.lock.lock();
        try {
            if (this.status != ComponentStatus.RUNNING && newState.isBefore(WrapperState.STOPPING)) {
                throw new IllegalLifecycleStateException("Cannot wire or start components while the registry is not running");
            }
            if (wrapper.state != expectedState) {
                boolean bl = false;
                return bl;
            }
            wrapper.state = newState;
            ComponentPath currentPath = this.mutatorThreads.get(Thread.currentThread());
            String name = wrapper.name;
            String className = wrapper.instance != null ? wrapper.instance.getClass().getName() : null;
            this.mutatorThreads.put(Thread.currentThread(), new ComponentPath(name, className, currentPath));
            if (trace) {
                log.tracef("Changed status of " + name + " to " + (Object)((Object)wrapper.state), new Object[0]);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitWrapperState(ComponentWrapper wrapper, WrapperState expectedState) {
        this.lock.lock();
        try {
            ComponentPath currentComponentPath;
            String name = wrapper.name;
            if (wrapper.state == WrapperState.EMPTY) {
                throw new CacheConfigurationException("Component " + name + " is missing a strong reference: waiting to become " + (Object)((Object)expectedState) + " but it has not been instantiated yet");
            }
            if (wrapper.state.isBefore(expectedState) && (currentComponentPath = this.mutatorThreads.get(Thread.currentThread())) != null && currentComponentPath.contains(name)) {
                String className = wrapper.instance != null ? wrapper.instance.getClass().getName() : null;
                throw new CacheConfigurationException("Dependency cycle detected, please use ComponentRef<T> to break the cycle in path " + new ComponentPath(name, className, this.getCurrentComponentPath()));
            }
            while (this.status == ComponentStatus.RUNNING && wrapper.isBefore(expectedState)) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw new IllegalLifecycleStateException("Interrupted while waiting for component " + name + " to start");
                }
            }
            wrapper.expectState(expectedState, WrapperState.STOPPING);
        }
        finally {
            this.lock.unlock();
        }
    }

    private ComponentPath getCurrentComponentPath() {
        this.lock.lock();
        try {
            ComponentPath componentPath = this.mutatorThreads.get(Thread.currentThread());
            return componentPath;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class DefaultFactoryFactory
    implements ComponentFactory {
        private final Class<? extends ComponentFactory> factoryClass;

        DefaultFactoryFactory(Class<? extends ComponentFactory> factoryClass) {
            this.factoryClass = factoryClass;
        }

        @Override
        public Object construct(String componentName) {
            assert (this.factoryClass.getName().equals(componentName));
            try {
                return this.factoryClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CacheConfigurationException("Unable to instantiate factory " + this.factoryClass.getName(), (Throwable)e);
            }
        }
    }

    static class ComponentPath {
        final String name;
        final String className;
        final ComponentPath next;

        ComponentPath(String name, String className, ComponentPath next) {
            this.name = name;
            this.className = className;
            this.next = next;
        }

        public boolean contains(String name) {
            ComponentPath path = this;
            while (path != null) {
                if (path.name.equals(name)) {
                    return true;
                }
                path = path.next;
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            boolean firstIteration = true;
            ComponentPath path = this;
            while (path != null) {
                if (firstIteration) {
                    firstIteration = false;
                } else {
                    sb.append("\n  << ");
                }
                sb.append(path.name);
                if (this.className != null) {
                    sb.append(" (a ").append(path.className).append(")");
                }
                path = path.next;
            }
            return sb.toString();
        }
    }

    static class ComponentWrapper
    implements ComponentRef {
        private final BasicComponentRegistryImpl registry;
        private final String name;
        private final boolean manageLifecycle;
        private volatile WrapperState state;
        private volatile ComponentPath dynamicDependencies;
        private volatile Object instance;
        private volatile ComponentMetadata metadata;
        private volatile ComponentRef<?> aliasTarget;

        ComponentWrapper(BasicComponentRegistryImpl registry, String name, boolean manageLifecycle) {
            this.registry = registry;
            this.name = name;
            this.manageLifecycle = manageLifecycle;
            this.state = WrapperState.EMPTY;
        }

        public Object running() {
            if (!this.isRunning()) {
                this.wire();
                this.registry.startWrapper(this);
                this.expectState(WrapperState.STARTED, WrapperState.STOPPING);
            }
            return this.aliasTarget != null ? this.aliasTarget.running() : this.instance;
        }

        public Object wired() {
            if (!this.isWired()) {
                this.wire();
            }
            return this.aliasTarget != null ? this.aliasTarget.wired() : this.instance;
        }

        public void wire() {
            if (!this.isAtLeast(WrapperState.INSTANTIATED)) {
                ComponentFactory factory = this.registry.findFactory(this.name);
                this.registry.instantiateWrapper(this, factory);
            }
            this.registry.wireWrapper(this);
        }

        @Override
        public boolean isRunning() {
            return this.state == WrapperState.STARTED;
        }

        @Override
        public boolean isWired() {
            return this.isAtLeast(WrapperState.WIRED) && this.isBefore(WrapperState.STOPPING);
        }

        @Override
        public String getName() {
            return this.name;
        }

        void expectState(WrapperState firstAllowedState, WrapperState firstDisallowedState) {
            WrapperState localState = this.state;
            if (localState.isBefore(firstAllowedState)) {
                throw new IllegalLifecycleStateException("Component " + this.name + " is not yet " + (Object)((Object)firstAllowedState));
            }
            if (localState.isAtLeast(firstDisallowedState)) {
                throw new IllegalLifecycleStateException("Component " + this.name + " is already " + (Object)((Object)localState));
            }
        }

        boolean isAtLeast(WrapperState expectedState) {
            return this.state.isAtLeast(expectedState);
        }

        boolean isBefore(WrapperState expectedState) {
            return this.state.isBefore(expectedState);
        }

        @GuardedBy(value="lock")
        void addDynamicDependency(String subComponentName) {
            this.dynamicDependencies = new ComponentPath(subComponentName, null, this.dynamicDependencies);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ComponentWrapper{").append("name=").append(this.name);
            if (this.aliasTarget != null) {
                sb.append(", aliasTarget=").append(this.aliasTarget);
            } else {
                sb.append(", instance=").append(this.instance);
            }
            sb.append(", status=").append((Object)this.state);
            sb.append('}');
            return sb.toString();
        }
    }

    static enum WrapperState {
        EMPTY,
        INSTANTIATING,
        INSTANTIATED,
        WIRING,
        WIRED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        FAILED;


        boolean isAtLeast(WrapperState other) {
            return this.ordinal() >= other.ordinal();
        }

        boolean isBefore(WrapperState other) {
            return this.ordinal() < other.ordinal();
        }
    }
}

