/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jsonpatch.JsonPatchException;
import com.github.fge.jsonpatch.JsonPatchOperation;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;

public final class JsonPatch {
    private final List<JsonPatchOperation> operations;

    @JsonCreator
    @VisibleForTesting
    JsonPatch(List<JsonPatchOperation> operations) {
        this.operations = ImmutableList.copyOf(operations);
    }

    public static JsonPatch fromJson(JsonNode node) throws IOException {
        Preconditions.checkNotNull((Object)node, (Object)"input cannot be null");
        return (JsonPatch)JacksonUtils.getReader().withType(JsonPatch.class).readValue(node);
    }

    public JsonNode apply(JsonNode node) throws JsonPatchException {
        Preconditions.checkNotNull((Object)node, (Object)"input cannot be null");
        JsonNode ret = node;
        for (JsonPatchOperation operation : this.operations) {
            ret = operation.apply(ret);
        }
        return ret;
    }

    public String toString() {
        return this.operations.toString();
    }
}

