/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.ActionTokenKeyModel;
import org.keycloak.models.ActionTokenStoreProvider;
import org.keycloak.models.ActionTokenValueModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.sessions.infinispan.InfinispanKeycloakTransaction;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenReducedKey;
import org.keycloak.models.sessions.infinispan.entities.ActionTokenValueEntity;

public class InfinispanActionTokenStoreProvider
implements ActionTokenStoreProvider {
    private static final Logger LOG = Logger.getLogger(InfinispanActionTokenStoreProvider.class);
    private final Cache<ActionTokenReducedKey, ActionTokenValueEntity> actionKeyCache;
    private final InfinispanKeycloakTransaction tx;
    private final KeycloakSession session;

    public InfinispanActionTokenStoreProvider(KeycloakSession session, Cache<ActionTokenReducedKey, ActionTokenValueEntity> actionKeyCache) {
        this.session = session;
        this.actionKeyCache = actionKeyCache;
        this.tx = new InfinispanKeycloakTransaction();
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.tx);
    }

    public void close() {
    }

    public void put(ActionTokenKeyModel key, Map<String, String> notes) {
        if (key == null || key.getUserId() == null || key.getActionId() == null) {
            return;
        }
        ActionTokenReducedKey tokenKey = new ActionTokenReducedKey(key.getUserId(), key.getActionId(), key.getActionVerificationNonce());
        ActionTokenValueEntity tokenValue = new ActionTokenValueEntity(notes);
        LOG.debugf("Adding used action token to actionTokens cache: %s", (Object)tokenKey.toString());
        this.tx.put(this.actionKeyCache, tokenKey, tokenValue, key.getExpiration() - Time.currentTime(), TimeUnit.SECONDS);
    }

    public ActionTokenValueModel get(ActionTokenKeyModel actionTokenKey) {
        if (actionTokenKey == null || actionTokenKey.getUserId() == null || actionTokenKey.getActionId() == null) {
            return null;
        }
        ActionTokenReducedKey key = new ActionTokenReducedKey(actionTokenKey.getUserId(), actionTokenKey.getActionId(), actionTokenKey.getActionVerificationNonce());
        ActionTokenValueModel value = (ActionTokenValueModel)this.actionKeyCache.getAdvancedCache().get((Object)key);
        if (value == null) {
            LOG.debugf("Not found any value in actionTokens cache for key: %s", (Object)key.toString());
        } else {
            LOG.debugf("Found value in actionTokens cache for key: %s", (Object)key.toString());
        }
        return value;
    }

    public ActionTokenValueModel remove(ActionTokenKeyModel actionTokenKey) {
        if (actionTokenKey == null || actionTokenKey.getUserId() == null || actionTokenKey.getActionId() == null) {
            return null;
        }
        ActionTokenReducedKey key = new ActionTokenReducedKey(actionTokenKey.getUserId(), actionTokenKey.getActionId(), actionTokenKey.getActionVerificationNonce());
        ActionTokenValueEntity value = (ActionTokenValueEntity)this.actionKeyCache.get((Object)key);
        if (value != null) {
            this.tx.remove(this.actionKeyCache, key);
        }
        return value;
    }
}

