/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.WildFlySecurityManager;

class ContentRepositoryCleaner {
    private final LocalModelControllerClient client;
    private final ControlledProcessStateService controlledProcessStateService;
    private final ScheduledExecutorService scheduledExecutor;
    private long cleanInterval = 0L;
    private volatile boolean enabled;
    private final boolean server;
    private ScheduledFuture<?> cleanTask;
    private final ContentRepositoryCleanerTask cleanRunnable = new ContentRepositoryCleanerTask();

    public ContentRepositoryCleaner(LocalModelControllerClient client, ControlledProcessStateService controlledProcessStateService, ScheduledExecutorService scheduledExecutor, long interval, boolean server) {
        this.controlledProcessStateService = controlledProcessStateService;
        this.client = client;
        this.scheduledExecutor = scheduledExecutor;
        this.enabled = true;
        this.cleanInterval = interval;
        this.server = server;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getCleanInterval() {
        return this.cleanInterval;
    }

    private void cancelScan() {
        if (this.cleanTask != null) {
            this.cleanTask.cancel(true);
            this.cleanTask = null;
        }
        this.client.close();
    }

    synchronized void startScan() {
        if (this.enabled) {
            this.cleanTask = this.scheduledExecutor.scheduleWithFixedDelay(this.cleanRunnable, this.cleanInterval, this.cleanInterval, TimeUnit.MILLISECONDS);
        }
    }

    synchronized void stopScan() {
        this.enabled = false;
        this.cancelScan();
    }

    void cleanObsoleteContent() {
        if (this.controlledProcessStateService.getCurrentState() == ControlledProcessState.State.RUNNING) {
            ModelNode response;
            ModelNode request;
            PathAddress address = PathAddress.EMPTY_ADDRESS;
            if (!this.server) {
                request = Util.getReadAttributeOperation((PathAddress)PathAddress.EMPTY_ADDRESS, (String)"local-host-name");
                response = ContentRepositoryCleaner.privilegedExecution().execute(arg_0 -> ((LocalModelControllerClient)this.client).execute(arg_0), request);
                if ("success".equals(response.get("outcome").asString()) && response.get("result").isDefined()) {
                    address = address.append("host", response.get("result").asString());
                } else {
                    if ("cancelled".equals(response.get("outcome").asString())) {
                        return;
                    }
                    if ("failed".equals(response.get("outcome").asString())) {
                        this.error(response);
                        return;
                    }
                }
            }
            request = Util.createOperation((String)"clean-obsolete-content", (PathAddress)address);
            response = ContentRepositoryCleaner.privilegedExecution().execute(arg_0 -> ((LocalModelControllerClient)this.client).execute(arg_0), request);
            if ("success".equals(response.get("outcome").asString())) {
                if (response.get("result").isDefined()) {
                    ServerLogger.ROOT_LOGGER.debug(response.get("result"));
                }
            } else if ("failed".equals(response.get("outcome").asString())) {
                this.error(response);
            }
        }
    }

    private void error(ModelNode response) {
        if (response.hasDefined("failure-description")) {
            ServerLogger.ROOT_LOGGER.failedToCleanObsoleteContent(response.get("failure-description").asString());
        } else {
            ServerLogger.ROOT_LOGGER.failedToCleanObsoleteContent(response.asString());
        }
    }

    private static Execution privilegedExecution() {
        return WildFlySecurityManager.isChecking() ? Execution.PRIVILEGED : Execution.NON_PRIVILEGED;
    }

    private static interface Execution {
        public static final Execution NON_PRIVILEGED = new Execution(){

            @Override
            public <T, R> R execute(Function<T, R> function, T t) {
                return function.apply(t);
            }
        };
        public static final Execution PRIVILEGED = new Execution(){

            @Override
            public <T, R> R execute(Function<T, R> function, T t) {
                try {
                    return (R)AccessController.doPrivileged(() -> NON_PRIVILEGED.execute(function, t));
                }
                catch (PrivilegedActionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new RuntimeException(cause);
                }
            }
        };

        public <T, R> R execute(Function<T, R> var1, T var2);
    }

    private class ContentRepositoryCleanerTask
    implements Runnable {
        private ContentRepositoryCleanerTask() {
        }

        @Override
        public void run() {
            ContentRepositoryCleaner.this.cleanObsoleteContent();
        }
    }
}

