#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 universe-reverse-instances
version:              1.1.1
visibility:           public
id:                   universe-reverse-instances-1.1.1-JTcGZesP75m4DEMuLkkld4
key:                  universe-reverse-instances-1.1.1-JTcGZesP75m4DEMuLkkld4
license:              BSD-3-Clause
copyright:            Daniel Wagner 2014
maintainer:           me@dmwit.com
author:               Daniel Wagner
homepage:             https://github.com/dmwit/universe
synopsis:
    Instances of standard classes that are made possible by enumerations

description:
    For example this package provides a @Eq (a -> b)@ instance:

    @
    instance (Finite a, Eq b) => Eq (a -> b) where
    f == g = and [f x == g x | x <- universeF]
    @

category:             Data
abi:                  2977dbe65d89a99d947fc24dae5f84b9
exposed:              True
exposed-modules:
    Data.Universe.Instances.Eq Data.Universe.Instances.Ord
    Data.Universe.Instances.Read Data.Universe.Instances.Show
    Data.Universe.Instances.Traversable

import-dirs:
    /usr/lib/ghc-8.10.5/site-local/universe-reverse-instances-1.1.1

library-dirs:
    /usr/lib/ghc-8.10.5/site-local/universe-reverse-instances-1.1.1

dynamic-library-dirs: /usr/lib
data-dir:
    /usr/share/i386-linux-ghc-8.10.5/universe-reverse-instances-1.1.1

hs-libraries:         HSuniverse-reverse-instances-1.1.1-JTcGZesP75m4DEMuLkkld4
depends:
    base-4.14.2.0 containers-0.6.4.1
    universe-base-1.1.2-76XTKmPL6G0Datb31jBziY

haddock-interfaces:
    /usr/share/doc/haskell-universe-reverse-instances/html/universe-reverse-instances.haddock

haddock-html:         /usr/share/doc/haskell-universe-reverse-instances/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

