#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 math-functions
version:              0.3.4.2
visibility:           public
id:                   math-functions-0.3.4.2-IJhAMriziU16J2oMLHgysC
key:                  math-functions-0.3.4.2-IJhAMriziU16J2oMLHgysC
license:              BSD-2-Clause
maintainer:           Alexey Khudyakov <alexey.skladnoy@gmail.com>
author:
    Bryan O'\''Sullivan <bos@serpentine.com>,
    Alexey Khudyakov <alexey.skladnoy@gmail.com>

homepage:             https://github.com/bos/math-functions
synopsis:             Collection of tools for numeric computations
description:
    This library contain collection of various utilities for numerical
    computing. So far there'\''re special mathematical functions,
    compensated summation algorithm, summation of series, root finding
    for real functions, polynomial summation and Chebyshev
    polynomials.

category:             Math, Numeric
abi:                  f550d2d01d22d2aaa22fa906d8c76691
exposed:              True
exposed-modules:
    Numeric.MathFunctions.Comparison Numeric.MathFunctions.Constants
    Numeric.Polynomial Numeric.Polynomial.Chebyshev Numeric.RootFinding
    Numeric.Series Numeric.SpecFunctions Numeric.SpecFunctions.Extra
    Numeric.SpecFunctions.Internal Numeric.Sum

hidden-modules:       Numeric.SpecFunctions.Compat
import-dirs:          /usr/lib/ghc-8.10.5/site-local/math-functions-0.3.4.2
library-dirs:         /usr/lib/ghc-8.10.5/site-local/math-functions-0.3.4.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/math-functions-0.3.4.2
hs-libraries:         HSmath-functions-0.3.4.2-IJhAMriziU16J2oMLHgysC
depends:
    base-4.14.2.0 data-default-class-0.1.2.0-9cFfQKP7sucLLfD3ZZyiPI
    deepseq-1.4.4.0 primitive-0.7.1.0-H44eQ1j8hQJ3Kj2SFx0Ivh
    vector-0.12.3.0-K9OZS5OCy7cE2QKQqSO9mp

haddock-interfaces:
    /usr/share/doc/haskell-math-functions/html/math-functions.haddock

haddock-html:         /usr/share/doc/haskell-math-functions/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

