#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 lsp-types
version:              1.2.0.0
visibility:           public
id:                   lsp-types-1.2.0.0-LPzodctwqIt88VlB7aKCM1
key:                  lsp-types-1.2.0.0-LPzodctwqIt88VlB7aKCM1
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:
    Haskell library for the Microsoft Language Server Protocol, data types

description:
    An implementation of the types to allow language implementors to
    support the Language Server Protocol for their specific language.

category:             Development
abi:                  fe5c88772529f4f330c33bc53f9a1785
exposed:              True
exposed-modules:
    Data.IxMap Language.LSP.Types Language.LSP.Types.Capabilities
    Language.LSP.Types.Lens Language.LSP.VFS

hidden-modules:
    Language.LSP.Types.Cancellation
    Language.LSP.Types.ClientCapabilities Language.LSP.Types.CodeAction
    Language.LSP.Types.CodeLens Language.LSP.Types.Command
    Language.LSP.Types.Common Language.LSP.Types.Completion
    Language.LSP.Types.Configuration Language.LSP.Types.Declaration
    Language.LSP.Types.Definition Language.LSP.Types.Diagnostic
    Language.LSP.Types.DocumentColor Language.LSP.Types.DocumentFilter
    Language.LSP.Types.DocumentHighlight
    Language.LSP.Types.DocumentLink Language.LSP.Types.DocumentSymbol
    Language.LSP.Types.FoldingRange Language.LSP.Types.Formatting
    Language.LSP.Types.Hover Language.LSP.Types.Implementation
    Language.LSP.Types.Initialize Language.LSP.Types.Location
    Language.LSP.Types.LspId Language.LSP.Types.MarkupContent
    Language.LSP.Types.Method Language.LSP.Types.Message
    Language.LSP.Types.Parsing Language.LSP.Types.Progress
    Language.LSP.Types.Registration Language.LSP.Types.References
    Language.LSP.Types.Rename Language.LSP.Types.SelectionRange
    Language.LSP.Types.ServerCapabilities
    Language.LSP.Types.SignatureHelp
    Language.LSP.Types.StaticRegistrationOptions
    Language.LSP.Types.TextDocument Language.LSP.Types.TypeDefinition
    Language.LSP.Types.Uri Language.LSP.Types.Utils
    Language.LSP.Types.Window Language.LSP.Types.WatchedFiles
    Language.LSP.Types.WorkspaceEdit
    Language.LSP.Types.WorkspaceFolders
    Language.LSP.Types.WorkspaceSymbol

import-dirs:          /usr/lib/ghc-8.10.5/site-local/lsp-types-1.2.0.0
library-dirs:         /usr/lib/ghc-8.10.5/site-local/lsp-types-1.2.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/lsp-types-1.2.0.0
hs-libraries:         HSlsp-types-1.2.0.0-LPzodctwqIt88VlB7aKCM1
depends:
    aeson-1.5.6.0-IA546NaLWlLGqcowhw6tTs base-4.14.2.0 binary-0.8.8.0
    bytestring-0.10.12.0 containers-0.6.4.1
    data-default-0.7.1.1-FiQ1o71Il6AF4wrr19xinj deepseq-1.4.4.0
    dependent-sum-0.7.1.0-K5Ubw1JI8oOA91k5GKnqt6
    dependent-sum-template-0.1.0.3-BGfSImN6KWKFQflLRkPOOF
    directory-1.3.6.0 filepath-1.4.2.1
    hashable-1.3.2.0-L2CDkY7lZtECinpkHRj0mo
    hslogger-1.3.1.0-Lh3ETJdSJLMBHJimIxSUpu
    lens-5.0.1-7XUkI0pM5Tr3OUSblTWRuC
    network-uri-2.6.4.1-FvgDgWAahTMJnOZjiFXR50
    rope-utf16-splay-0.3.2.0-5mP4j1fCbrTDcTAnOrxucw
    scientific-0.3.7.0-Ea1GK6jx8XDEEsfAKxwFym
    some-1.0.3-1KmRXE4Js6K5qWAWmRn59k template-haskell-2.16.0.0
    temporary-1.3-2IjA4J7jKmb3rvOA3dYC2H text-1.2.4.1
    unordered-containers-0.2.14.0-D9MLkVL2jXfKIhE8RrmI8O

haddock-interfaces:   /usr/share/doc/haskell-lsp-types/html/lsp-types.haddock
haddock-html:         /usr/share/doc/haskell-lsp-types/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

