#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 dyre
version:              0.9.1
visibility:           public
id:                   dyre-0.9.1-DLA2quPgLvyFi9qWUS0ALD
key:                  dyre-0.9.1-DLA2quPgLvyFi9qWUS0ALD
license:              BSD-3-Clause
copyright:            (c) 2011-2019 Will Donnelly, Fraser Tweedale
maintainer:           Fraser Tweedale <frase@frase.id.au>
author:               Will Donnelly
stability:            beta
homepage:             http://github.com/willdonnelly/dyre
synopsis:             Dynamic reconfiguration in Haskell
description:
    Dyre implements dynamic reconfiguration facilities after the
    style of Xmonad. Dyre aims to be as simple as possible without
    sacrificing features, and places an emphasis on simplicity of
    integration with an application.
    A full introduction with a complete example project can be found
    in the documentation for '\''Config.Dyre'\''

category:             Development, Configuration
abi:                  eed48eff1fe75cd9d382ee0046038a4f
exposed:              True
exposed-modules:
    Config.Dyre Config.Dyre.Compat Config.Dyre.Compile
    Config.Dyre.Options Config.Dyre.Params Config.Dyre.Paths
    Config.Dyre.Relaunch

import-dirs:          /usr/lib/ghc-8.10.5/site-local/dyre-0.9.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/dyre-0.9.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/dyre-0.9.1
hs-libraries:         HSdyre-0.9.1-DLA2quPgLvyFi9qWUS0ALD
depends:
    base-4.14.2.0 binary-0.8.8.0 directory-1.3.6.0
    executable-path-0.0.3.1-84VowVJXXjdLu8L9GxK1jL filepath-1.4.2.1
    io-storage-0.3-7KNpGOvhO9P2GCHKDWRBbU process-1.6.9.0 time-1.9.3
    unix-2.7.2.2 xdg-basedir-0.2.2-HxO6vm11dHzJE1a7l4Y8Vh

haddock-interfaces:   /usr/share/doc/haskell-dyre/html/dyre.haddock
haddock-html:         /usr/share/doc/haskell-dyre/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

